<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class p_eastimate_view extends p_eastimate
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'p_eastimate';

	// Page object name
	public $PageObjName = "p_eastimate_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (p_eastimate)
		if (!isset($GLOBALS["p_eastimate"]) || get_class($GLOBALS["p_eastimate"]) == PROJECT_NAMESPACE . "p_eastimate") {
			$GLOBALS["p_eastimate"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["p_eastimate"];
		}
		$keyUrl = "";
		if (Get("id") !== NULL) {
			$this->RecKey["id"] = Get("id");
			$keyUrl .= "&amp;id=" . urlencode($this->RecKey["id"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'p_eastimate');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $p_eastimate;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($p_eastimate);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "p_eastimateview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecs = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $RecCnt;
	public $RecKey = array();
	public $IsModal = FALSE;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SkipHeaderFooter, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("p_eastimatelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->job_type->setVisibility();
		$this->job_category->setVisibility();
		$this->company_id->setVisibility();
		$this->description->setVisibility();
		$this->size->setVisibility();
		$this->quantity->setVisibility();
		$this->pages->setVisibility();
		$this->paper->setVisibility();
		$this->remarks->setVisibility();
		$this->pr_01->setVisibility();
		$this->qty_pr_01->setVisibility();
		$this->pl_01->setVisibility();
		$this->qty_pl_01->setVisibility();
		$this->pr_02->setVisibility();
		$this->qty_pr_02->setVisibility();
		$this->pl_02->setVisibility();
		$this->qty_pl_02->setVisibility();
		$this->pr_03->setVisibility();
		$this->qty_pr_03->setVisibility();
		$this->pl_03->setVisibility();
		$this->qty_pl_03->setVisibility();
		$this->pr_04->setVisibility();
		$this->qty_pr_04->setVisibility();
		$this->pl_04->setVisibility();
		$this->qty_pl_04->setVisibility();
		$this->pa_01->setVisibility();
		$this->qty_pa_01->setVisibility();
		$this->pa_02->setVisibility();
		$this->qty_pa_02->setVisibility();
		$this->pa_03->setVisibility();
		$this->qty_pa_03->setVisibility();
		$this->pa_04->setVisibility();
		$this->qty_pa_04->setVisibility();
		$this->pa_05->setVisibility();
		$this->qty_pa_05->setVisibility();
		$this->pc_01->setVisibility();
		$this->qty_pc_01->setVisibility();
		$this->pc_02->setVisibility();
		$this->qty_pc_02->setVisibility();
		$this->o_01->setVisibility();
		$this->qty_o_01->setVisibility();
		$this->lamination_type->setVisibility();
		$this->lamination_qty->setVisibility();
		$this->die_type->setVisibility();
		$this->die_qty->setVisibility();
		$this->binding_type->setVisibility();
		$this->binding_qty->setVisibility();
		$this->number_type->setVisibility();
		$this->number_qty->setVisibility();
		$this->de_01->setVisibility();
		$this->qty_de_01->setVisibility();
		$this->de_02->setVisibility();
		$this->qty_de_02->setVisibility();
		$this->de_03->setVisibility();
		$this->qty_de_03->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->size);
		$this->setupLookupOptions($this->pr_01);
		$this->setupLookupOptions($this->pl_01);
		$this->setupLookupOptions($this->pr_02);
		$this->setupLookupOptions($this->pl_02);
		$this->setupLookupOptions($this->pr_03);
		$this->setupLookupOptions($this->pl_03);
		$this->setupLookupOptions($this->pr_04);
		$this->setupLookupOptions($this->pl_04);
		$this->setupLookupOptions($this->pa_01);
		$this->setupLookupOptions($this->pa_02);
		$this->setupLookupOptions($this->pa_03);
		$this->setupLookupOptions($this->pa_04);
		$this->setupLookupOptions($this->pa_05);
		$this->setupLookupOptions($this->pc_01);
		$this->setupLookupOptions($this->pc_02);
		$this->setupLookupOptions($this->o_01);
		$this->setupLookupOptions($this->lamination_type);
		$this->setupLookupOptions($this->die_type);
		$this->setupLookupOptions($this->binding_type);
		$this->setupLookupOptions($this->number_type);
		$this->setupLookupOptions($this->de_01);
		$this->setupLookupOptions($this->de_02);
		$this->setupLookupOptions($this->de_03);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (IsApi() && Key(0) != NULL) {
				$this->id->setQueryStringValue(Key(0));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (Post("id") !== NULL) {
				$this->id->setFormValue(Post("id"));
				$this->RecKey["id"] = $this->id->FormValue;
			} elseif (IsApi() && Route(2) != NULL) {
				$this->id->setFormValue(Route(2));
				$this->RecKey["id"] = $this->id->FormValue;
			} else {
				$returnUrl = "p_eastimatelist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = &$this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "p_eastimatelist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "p_eastimatelist.php"; // Not page request, return to list
		}
		if ($returnUrl <> "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->AddUrl) . "'});\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());

		// Copy
		$item = &$option->add("copy");
		$copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,btn:'AddBtn',url:'" . HtmlEncode($this->CopyUrl) . "'});\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		$item->Visible = ($this->CopyUrl <> "" && $Security->canAdd());

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->job_type->setDbValue($row['job_type']);
		$this->job_category->setDbValue($row['job_category']);
		$this->company_id->setDbValue($row['company_id']);
		$this->description->setDbValue($row['description']);
		$this->size->setDbValue($row['size']);
		$this->quantity->setDbValue($row['quantity']);
		$this->pages->setDbValue($row['pages']);
		$this->paper->setDbValue($row['paper']);
		$this->remarks->setDbValue($row['remarks']);
		$this->pr_01->setDbValue($row['pr_01']);
		if (array_key_exists('EV__pr_01', $rs->fields)) {
			$this->pr_01->VirtualValue = $rs->fields('EV__pr_01'); // Set up virtual field value
		} else {
			$this->pr_01->VirtualValue = ""; // Clear value
		}
		$this->qty_pr_01->setDbValue($row['qty_pr_01']);
		$this->pl_01->setDbValue($row['pl_01']);
		$this->qty_pl_01->setDbValue($row['qty_pl_01']);
		$this->pr_02->setDbValue($row['pr_02']);
		if (array_key_exists('EV__pr_02', $rs->fields)) {
			$this->pr_02->VirtualValue = $rs->fields('EV__pr_02'); // Set up virtual field value
		} else {
			$this->pr_02->VirtualValue = ""; // Clear value
		}
		$this->qty_pr_02->setDbValue($row['qty_pr_02']);
		$this->pl_02->setDbValue($row['pl_02']);
		$this->qty_pl_02->setDbValue($row['qty_pl_02']);
		$this->pr_03->setDbValue($row['pr_03']);
		if (array_key_exists('EV__pr_03', $rs->fields)) {
			$this->pr_03->VirtualValue = $rs->fields('EV__pr_03'); // Set up virtual field value
		} else {
			$this->pr_03->VirtualValue = ""; // Clear value
		}
		$this->qty_pr_03->setDbValue($row['qty_pr_03']);
		$this->pl_03->setDbValue($row['pl_03']);
		$this->qty_pl_03->setDbValue($row['qty_pl_03']);
		$this->pr_04->setDbValue($row['pr_04']);
		if (array_key_exists('EV__pr_04', $rs->fields)) {
			$this->pr_04->VirtualValue = $rs->fields('EV__pr_04'); // Set up virtual field value
		} else {
			$this->pr_04->VirtualValue = ""; // Clear value
		}
		$this->qty_pr_04->setDbValue($row['qty_pr_04']);
		$this->pl_04->setDbValue($row['pl_04']);
		$this->qty_pl_04->setDbValue($row['qty_pl_04']);
		$this->pa_01->setDbValue($row['pa_01']);
		$this->qty_pa_01->setDbValue($row['qty_pa_01']);
		$this->pa_02->setDbValue($row['pa_02']);
		$this->qty_pa_02->setDbValue($row['qty_pa_02']);
		$this->pa_03->setDbValue($row['pa_03']);
		$this->qty_pa_03->setDbValue($row['qty_pa_03']);
		$this->pa_04->setDbValue($row['pa_04']);
		$this->qty_pa_04->setDbValue($row['qty_pa_04']);
		$this->pa_05->setDbValue($row['pa_05']);
		$this->qty_pa_05->setDbValue($row['qty_pa_05']);
		$this->pc_01->setDbValue($row['pc_01']);
		$this->qty_pc_01->setDbValue($row['qty_pc_01']);
		$this->pc_02->setDbValue($row['pc_02']);
		$this->qty_pc_02->setDbValue($row['qty_pc_02']);
		$this->o_01->setDbValue($row['o_01']);
		$this->qty_o_01->setDbValue($row['qty_o_01']);
		$this->lamination_type->setDbValue($row['lamination_type']);
		if (array_key_exists('EV__lamination_type', $rs->fields)) {
			$this->lamination_type->VirtualValue = $rs->fields('EV__lamination_type'); // Set up virtual field value
		} else {
			$this->lamination_type->VirtualValue = ""; // Clear value
		}
		$this->lamination_qty->setDbValue($row['lamination_qty']);
		$this->die_type->setDbValue($row['die_type']);
		if (array_key_exists('EV__die_type', $rs->fields)) {
			$this->die_type->VirtualValue = $rs->fields('EV__die_type'); // Set up virtual field value
		} else {
			$this->die_type->VirtualValue = ""; // Clear value
		}
		$this->die_qty->setDbValue($row['die_qty']);
		$this->binding_type->setDbValue($row['binding_type']);
		$this->binding_qty->setDbValue($row['binding_qty']);
		$this->number_type->setDbValue($row['number_type']);
		if (array_key_exists('EV__number_type', $rs->fields)) {
			$this->number_type->VirtualValue = $rs->fields('EV__number_type'); // Set up virtual field value
		} else {
			$this->number_type->VirtualValue = ""; // Clear value
		}
		$this->number_qty->setDbValue($row['number_qty']);
		$this->de_01->setDbValue($row['de_01']);
		if (array_key_exists('EV__de_01', $rs->fields)) {
			$this->de_01->VirtualValue = $rs->fields('EV__de_01'); // Set up virtual field value
		} else {
			$this->de_01->VirtualValue = ""; // Clear value
		}
		$this->qty_de_01->setDbValue($row['qty_de_01']);
		$this->de_02->setDbValue($row['de_02']);
		if (array_key_exists('EV__de_02', $rs->fields)) {
			$this->de_02->VirtualValue = $rs->fields('EV__de_02'); // Set up virtual field value
		} else {
			$this->de_02->VirtualValue = ""; // Clear value
		}
		$this->qty_de_02->setDbValue($row['qty_de_02']);
		$this->de_03->setDbValue($row['de_03']);
		if (array_key_exists('EV__de_03', $rs->fields)) {
			$this->de_03->VirtualValue = $rs->fields('EV__de_03'); // Set up virtual field value
		} else {
			$this->de_03->VirtualValue = ""; // Clear value
		}
		$this->qty_de_03->setDbValue($row['qty_de_03']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['job_type'] = NULL;
		$row['job_category'] = NULL;
		$row['company_id'] = NULL;
		$row['description'] = NULL;
		$row['size'] = NULL;
		$row['quantity'] = NULL;
		$row['pages'] = NULL;
		$row['paper'] = NULL;
		$row['remarks'] = NULL;
		$row['pr_01'] = NULL;
		$row['qty_pr_01'] = NULL;
		$row['pl_01'] = NULL;
		$row['qty_pl_01'] = NULL;
		$row['pr_02'] = NULL;
		$row['qty_pr_02'] = NULL;
		$row['pl_02'] = NULL;
		$row['qty_pl_02'] = NULL;
		$row['pr_03'] = NULL;
		$row['qty_pr_03'] = NULL;
		$row['pl_03'] = NULL;
		$row['qty_pl_03'] = NULL;
		$row['pr_04'] = NULL;
		$row['qty_pr_04'] = NULL;
		$row['pl_04'] = NULL;
		$row['qty_pl_04'] = NULL;
		$row['pa_01'] = NULL;
		$row['qty_pa_01'] = NULL;
		$row['pa_02'] = NULL;
		$row['qty_pa_02'] = NULL;
		$row['pa_03'] = NULL;
		$row['qty_pa_03'] = NULL;
		$row['pa_04'] = NULL;
		$row['qty_pa_04'] = NULL;
		$row['pa_05'] = NULL;
		$row['qty_pa_05'] = NULL;
		$row['pc_01'] = NULL;
		$row['qty_pc_01'] = NULL;
		$row['pc_02'] = NULL;
		$row['qty_pc_02'] = NULL;
		$row['o_01'] = NULL;
		$row['qty_o_01'] = NULL;
		$row['lamination_type'] = NULL;
		$row['lamination_qty'] = NULL;
		$row['die_type'] = NULL;
		$row['die_qty'] = NULL;
		$row['binding_type'] = NULL;
		$row['binding_qty'] = NULL;
		$row['number_type'] = NULL;
		$row['number_qty'] = NULL;
		$row['de_01'] = NULL;
		$row['qty_de_01'] = NULL;
		$row['de_02'] = NULL;
		$row['qty_de_02'] = NULL;
		$row['de_03'] = NULL;
		$row['qty_de_03'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Convert decimal values if posted back
		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_01->FormValue == $this->qty_pr_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_01->CurrentValue)))
			$this->qty_pr_01->CurrentValue = ConvertToFloatString($this->qty_pr_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_01->FormValue == $this->qty_pl_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_01->CurrentValue)))
			$this->qty_pl_01->CurrentValue = ConvertToFloatString($this->qty_pl_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_02->FormValue == $this->qty_pr_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_02->CurrentValue)))
			$this->qty_pr_02->CurrentValue = ConvertToFloatString($this->qty_pr_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_02->FormValue == $this->qty_pl_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_02->CurrentValue)))
			$this->qty_pl_02->CurrentValue = ConvertToFloatString($this->qty_pl_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_03->FormValue == $this->qty_pr_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_03->CurrentValue)))
			$this->qty_pr_03->CurrentValue = ConvertToFloatString($this->qty_pr_03->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_03->FormValue == $this->qty_pl_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_03->CurrentValue)))
			$this->qty_pl_03->CurrentValue = ConvertToFloatString($this->qty_pl_03->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pr_04->FormValue == $this->qty_pr_04->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pr_04->CurrentValue)))
			$this->qty_pr_04->CurrentValue = ConvertToFloatString($this->qty_pr_04->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pl_04->FormValue == $this->qty_pl_04->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pl_04->CurrentValue)))
			$this->qty_pl_04->CurrentValue = ConvertToFloatString($this->qty_pl_04->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_01->FormValue == $this->qty_pa_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_01->CurrentValue)))
			$this->qty_pa_01->CurrentValue = ConvertToFloatString($this->qty_pa_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_02->FormValue == $this->qty_pa_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_02->CurrentValue)))
			$this->qty_pa_02->CurrentValue = ConvertToFloatString($this->qty_pa_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_03->FormValue == $this->qty_pa_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_03->CurrentValue)))
			$this->qty_pa_03->CurrentValue = ConvertToFloatString($this->qty_pa_03->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_04->FormValue == $this->qty_pa_04->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_04->CurrentValue)))
			$this->qty_pa_04->CurrentValue = ConvertToFloatString($this->qty_pa_04->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pa_05->FormValue == $this->qty_pa_05->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pa_05->CurrentValue)))
			$this->qty_pa_05->CurrentValue = ConvertToFloatString($this->qty_pa_05->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pc_01->FormValue == $this->qty_pc_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pc_01->CurrentValue)))
			$this->qty_pc_01->CurrentValue = ConvertToFloatString($this->qty_pc_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_pc_02->FormValue == $this->qty_pc_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_pc_02->CurrentValue)))
			$this->qty_pc_02->CurrentValue = ConvertToFloatString($this->qty_pc_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_o_01->FormValue == $this->qty_o_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_o_01->CurrentValue)))
			$this->qty_o_01->CurrentValue = ConvertToFloatString($this->qty_o_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->binding_qty->FormValue == $this->binding_qty->CurrentValue && is_numeric(ConvertToFloatString($this->binding_qty->CurrentValue)))
			$this->binding_qty->CurrentValue = ConvertToFloatString($this->binding_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_de_01->FormValue == $this->qty_de_01->CurrentValue && is_numeric(ConvertToFloatString($this->qty_de_01->CurrentValue)))
			$this->qty_de_01->CurrentValue = ConvertToFloatString($this->qty_de_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_de_02->FormValue == $this->qty_de_02->CurrentValue && is_numeric(ConvertToFloatString($this->qty_de_02->CurrentValue)))
			$this->qty_de_02->CurrentValue = ConvertToFloatString($this->qty_de_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->qty_de_03->FormValue == $this->qty_de_03->CurrentValue && is_numeric(ConvertToFloatString($this->qty_de_03->CurrentValue)))
			$this->qty_de_03->CurrentValue = ConvertToFloatString($this->qty_de_03->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// job_type
		// job_category
		// company_id
		// description
		// size
		// quantity
		// pages
		// paper
		// remarks
		// pr_01
		// qty_pr_01
		// pl_01
		// qty_pl_01
		// pr_02
		// qty_pr_02
		// pl_02
		// qty_pl_02
		// pr_03
		// qty_pr_03
		// pl_03
		// qty_pl_03
		// pr_04
		// qty_pr_04
		// pl_04
		// qty_pl_04
		// pa_01
		// qty_pa_01
		// pa_02
		// qty_pa_02
		// pa_03
		// qty_pa_03
		// pa_04
		// qty_pa_04
		// pa_05
		// qty_pa_05
		// pc_01
		// qty_pc_01
		// pc_02
		// qty_pc_02
		// o_01
		// qty_o_01
		// lamination_type
		// lamination_qty
		// die_type
		// die_qty
		// binding_type
		// binding_qty
		// number_type
		// number_qty
		// de_01
		// qty_de_01
		// de_02
		// qty_de_02
		// de_03
		// qty_de_03
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// job_type
			if (strval($this->job_type->CurrentValue) <> "") {
				$this->job_type->ViewValue = $this->job_type->optionCaption($this->job_type->CurrentValue);
			} else {
				$this->job_type->ViewValue = NULL;
			}
			$this->job_type->ViewCustomAttributes = "";

			// job_category
			if (strval($this->job_category->CurrentValue) <> "") {
				$this->job_category->ViewValue = $this->job_category->optionCaption($this->job_category->CurrentValue);
			} else {
				$this->job_category->ViewValue = NULL;
			}
			$this->job_category->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// size
			$curVal = strval($this->size->CurrentValue);
			if ($curVal <> "") {
				$this->size->ViewValue = $this->size->lookupCacheOption($curVal);
				if ($this->size->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`description`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->size->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->size->ViewValue = $this->size->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->size->ViewValue = $this->size->CurrentValue;
					}
				}
			} else {
				$this->size->ViewValue = NULL;
			}
			$this->size->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// pages
			$this->pages->ViewValue = $this->pages->CurrentValue;
			$this->pages->ViewCustomAttributes = "";

			// paper
			$this->paper->ViewValue = $this->paper->CurrentValue;
			$this->paper->ViewValue = FormatNumber($this->paper->ViewValue, 0, -2, -2, -2);
			$this->paper->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// pr_01
			if ($this->pr_01->VirtualValue <> "") {
				$this->pr_01->ViewValue = $this->pr_01->VirtualValue;
			} else {
			$curVal = strval($this->pr_01->CurrentValue);
			if ($curVal <> "") {
				$this->pr_01->ViewValue = $this->pr_01->lookupCacheOption($curVal);
				if ($this->pr_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_01->ViewValue = $this->pr_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_01->ViewValue = $this->pr_01->CurrentValue;
					}
				}
			} else {
				$this->pr_01->ViewValue = NULL;
			}
			}
			$this->pr_01->ViewCustomAttributes = "";

			// qty_pr_01
			$this->qty_pr_01->ViewValue = $this->qty_pr_01->CurrentValue;
			$this->qty_pr_01->ViewValue = FormatNumber($this->qty_pr_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_01->ViewCustomAttributes = "";

			// pl_01
			$curVal = strval($this->pl_01->CurrentValue);
			if ($curVal <> "") {
				$this->pl_01->ViewValue = $this->pl_01->lookupCacheOption($curVal);
				if ($this->pl_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_01->ViewValue = $this->pl_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_01->ViewValue = $this->pl_01->CurrentValue;
					}
				}
			} else {
				$this->pl_01->ViewValue = NULL;
			}
			$this->pl_01->ViewCustomAttributes = "";

			// qty_pl_01
			$this->qty_pl_01->ViewValue = $this->qty_pl_01->CurrentValue;
			$this->qty_pl_01->ViewValue = FormatNumber($this->qty_pl_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_01->ViewCustomAttributes = "";

			// pr_02
			if ($this->pr_02->VirtualValue <> "") {
				$this->pr_02->ViewValue = $this->pr_02->VirtualValue;
			} else {
			$curVal = strval($this->pr_02->CurrentValue);
			if ($curVal <> "") {
				$this->pr_02->ViewValue = $this->pr_02->lookupCacheOption($curVal);
				if ($this->pr_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_02->ViewValue = $this->pr_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_02->ViewValue = $this->pr_02->CurrentValue;
					}
				}
			} else {
				$this->pr_02->ViewValue = NULL;
			}
			}
			$this->pr_02->ViewCustomAttributes = "";

			// qty_pr_02
			$this->qty_pr_02->ViewValue = $this->qty_pr_02->CurrentValue;
			$this->qty_pr_02->ViewValue = FormatNumber($this->qty_pr_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_02->ViewCustomAttributes = "";

			// pl_02
			$curVal = strval($this->pl_02->CurrentValue);
			if ($curVal <> "") {
				$this->pl_02->ViewValue = $this->pl_02->lookupCacheOption($curVal);
				if ($this->pl_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_02->ViewValue = $this->pl_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_02->ViewValue = $this->pl_02->CurrentValue;
					}
				}
			} else {
				$this->pl_02->ViewValue = NULL;
			}
			$this->pl_02->ViewCustomAttributes = "";

			// qty_pl_02
			$this->qty_pl_02->ViewValue = $this->qty_pl_02->CurrentValue;
			$this->qty_pl_02->ViewValue = FormatNumber($this->qty_pl_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_02->ViewCustomAttributes = "";

			// pr_03
			if ($this->pr_03->VirtualValue <> "") {
				$this->pr_03->ViewValue = $this->pr_03->VirtualValue;
			} else {
			$curVal = strval($this->pr_03->CurrentValue);
			if ($curVal <> "") {
				$this->pr_03->ViewValue = $this->pr_03->lookupCacheOption($curVal);
				if ($this->pr_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_03->ViewValue = $this->pr_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_03->ViewValue = $this->pr_03->CurrentValue;
					}
				}
			} else {
				$this->pr_03->ViewValue = NULL;
			}
			}
			$this->pr_03->ViewCustomAttributes = "";

			// qty_pr_03
			$this->qty_pr_03->ViewValue = $this->qty_pr_03->CurrentValue;
			$this->qty_pr_03->ViewValue = FormatNumber($this->qty_pr_03->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_03->ViewCustomAttributes = "";

			// pl_03
			$curVal = strval($this->pl_03->CurrentValue);
			if ($curVal <> "") {
				$this->pl_03->ViewValue = $this->pl_03->lookupCacheOption($curVal);
				if ($this->pl_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_03->ViewValue = $this->pl_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_03->ViewValue = $this->pl_03->CurrentValue;
					}
				}
			} else {
				$this->pl_03->ViewValue = NULL;
			}
			$this->pl_03->ViewCustomAttributes = "";

			// qty_pl_03
			$this->qty_pl_03->ViewValue = $this->qty_pl_03->CurrentValue;
			$this->qty_pl_03->ViewValue = FormatNumber($this->qty_pl_03->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_03->ViewCustomAttributes = "";

			// pr_04
			if ($this->pr_04->VirtualValue <> "") {
				$this->pr_04->ViewValue = $this->pr_04->VirtualValue;
			} else {
			$curVal = strval($this->pr_04->CurrentValue);
			if ($curVal <> "") {
				$this->pr_04->ViewValue = $this->pr_04->lookupCacheOption($curVal);
				if ($this->pr_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pr_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pr_04->ViewValue = $this->pr_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pr_04->ViewValue = $this->pr_04->CurrentValue;
					}
				}
			} else {
				$this->pr_04->ViewValue = NULL;
			}
			}
			$this->pr_04->ViewCustomAttributes = "";

			// qty_pr_04
			$this->qty_pr_04->ViewValue = $this->qty_pr_04->CurrentValue;
			$this->qty_pr_04->ViewValue = FormatNumber($this->qty_pr_04->ViewValue, 2, -2, -2, -2);
			$this->qty_pr_04->ViewCustomAttributes = "";

			// pl_04
			$curVal = strval($this->pl_04->CurrentValue);
			if ($curVal <> "") {
				$this->pl_04->ViewValue = $this->pl_04->lookupCacheOption($curVal);
				if ($this->pl_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_04->ViewValue = $this->pl_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_04->ViewValue = $this->pl_04->CurrentValue;
					}
				}
			} else {
				$this->pl_04->ViewValue = NULL;
			}
			$this->pl_04->ViewCustomAttributes = "";

			// qty_pl_04
			$this->qty_pl_04->ViewValue = $this->qty_pl_04->CurrentValue;
			$this->qty_pl_04->ViewValue = FormatNumber($this->qty_pl_04->ViewValue, 2, -2, -2, -2);
			$this->qty_pl_04->ViewCustomAttributes = "";

			// pa_01
			$this->pa_01->ViewValue = $this->pa_01->CurrentValue;
			$curVal = strval($this->pa_01->CurrentValue);
			if ($curVal <> "") {
				$this->pa_01->ViewValue = $this->pa_01->lookupCacheOption($curVal);
				if ($this->pa_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_01->ViewValue = $this->pa_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_01->ViewValue = $this->pa_01->CurrentValue;
					}
				}
			} else {
				$this->pa_01->ViewValue = NULL;
			}
			$this->pa_01->ViewCustomAttributes = "";

			// qty_pa_01
			$this->qty_pa_01->ViewValue = $this->qty_pa_01->CurrentValue;
			$this->qty_pa_01->ViewValue = FormatNumber($this->qty_pa_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_01->ViewCustomAttributes = "";

			// pa_02
			$this->pa_02->ViewValue = $this->pa_02->CurrentValue;
			$curVal = strval($this->pa_02->CurrentValue);
			if ($curVal <> "") {
				$this->pa_02->ViewValue = $this->pa_02->lookupCacheOption($curVal);
				if ($this->pa_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_02->ViewValue = $this->pa_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_02->ViewValue = $this->pa_02->CurrentValue;
					}
				}
			} else {
				$this->pa_02->ViewValue = NULL;
			}
			$this->pa_02->ViewCustomAttributes = "";

			// qty_pa_02
			$this->qty_pa_02->ViewValue = $this->qty_pa_02->CurrentValue;
			$this->qty_pa_02->ViewValue = FormatNumber($this->qty_pa_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_02->ViewCustomAttributes = "";

			// pa_03
			$this->pa_03->ViewValue = $this->pa_03->CurrentValue;
			$curVal = strval($this->pa_03->CurrentValue);
			if ($curVal <> "") {
				$this->pa_03->ViewValue = $this->pa_03->lookupCacheOption($curVal);
				if ($this->pa_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_03->ViewValue = $this->pa_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_03->ViewValue = $this->pa_03->CurrentValue;
					}
				}
			} else {
				$this->pa_03->ViewValue = NULL;
			}
			$this->pa_03->ViewCustomAttributes = "";

			// qty_pa_03
			$this->qty_pa_03->ViewValue = $this->qty_pa_03->CurrentValue;
			$this->qty_pa_03->ViewValue = FormatNumber($this->qty_pa_03->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_03->ViewCustomAttributes = "";

			// pa_04
			$this->pa_04->ViewValue = $this->pa_04->CurrentValue;
			$curVal = strval($this->pa_04->CurrentValue);
			if ($curVal <> "") {
				$this->pa_04->ViewValue = $this->pa_04->lookupCacheOption($curVal);
				if ($this->pa_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_04->ViewValue = $this->pa_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_04->ViewValue = $this->pa_04->CurrentValue;
					}
				}
			} else {
				$this->pa_04->ViewValue = NULL;
			}
			$this->pa_04->ViewCustomAttributes = "";

			// qty_pa_04
			$this->qty_pa_04->ViewValue = $this->qty_pa_04->CurrentValue;
			$this->qty_pa_04->ViewValue = FormatNumber($this->qty_pa_04->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_04->ViewCustomAttributes = "";

			// pa_05
			$this->pa_05->ViewValue = $this->pa_05->CurrentValue;
			$curVal = strval($this->pa_05->CurrentValue);
			if ($curVal <> "") {
				$this->pa_05->ViewValue = $this->pa_05->lookupCacheOption($curVal);
				if ($this->pa_05->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pa_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pa_05->ViewValue = $this->pa_05->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pa_05->ViewValue = $this->pa_05->CurrentValue;
					}
				}
			} else {
				$this->pa_05->ViewValue = NULL;
			}
			$this->pa_05->ViewCustomAttributes = "";

			// qty_pa_05
			$this->qty_pa_05->ViewValue = $this->qty_pa_05->CurrentValue;
			$this->qty_pa_05->ViewValue = FormatNumber($this->qty_pa_05->ViewValue, 2, -2, -2, -2);
			$this->qty_pa_05->ViewCustomAttributes = "";

			// pc_01
			$curVal = strval($this->pc_01->CurrentValue);
			if ($curVal <> "") {
				$this->pc_01->ViewValue = $this->pc_01->lookupCacheOption($curVal);
				if ($this->pc_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pc_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pc_01->ViewValue = $this->pc_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pc_01->ViewValue = $this->pc_01->CurrentValue;
					}
				}
			} else {
				$this->pc_01->ViewValue = NULL;
			}
			$this->pc_01->ViewCustomAttributes = "";

			// qty_pc_01
			$this->qty_pc_01->ViewValue = $this->qty_pc_01->CurrentValue;
			$this->qty_pc_01->ViewValue = FormatNumber($this->qty_pc_01->ViewValue, 2, -2, -2, -2);
			$this->qty_pc_01->ViewCustomAttributes = "";

			// pc_02
			$curVal = strval($this->pc_02->CurrentValue);
			if ($curVal <> "") {
				$this->pc_02->ViewValue = $this->pc_02->lookupCacheOption($curVal);
				if ($this->pc_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pc_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pc_02->ViewValue = $this->pc_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pc_02->ViewValue = $this->pc_02->CurrentValue;
					}
				}
			} else {
				$this->pc_02->ViewValue = NULL;
			}
			$this->pc_02->ViewCustomAttributes = "";

			// qty_pc_02
			$this->qty_pc_02->ViewValue = $this->qty_pc_02->CurrentValue;
			$this->qty_pc_02->ViewValue = FormatNumber($this->qty_pc_02->ViewValue, 2, -2, -2, -2);
			$this->qty_pc_02->ViewCustomAttributes = "";

			// o_01
			$curVal = strval($this->o_01->CurrentValue);
			if ($curVal <> "") {
				$this->o_01->ViewValue = $this->o_01->lookupCacheOption($curVal);
				if ($this->o_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->o_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->o_01->ViewValue = $this->o_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->o_01->ViewValue = $this->o_01->CurrentValue;
					}
				}
			} else {
				$this->o_01->ViewValue = NULL;
			}
			$this->o_01->ViewCustomAttributes = "";

			// qty_o_01
			$this->qty_o_01->ViewValue = $this->qty_o_01->CurrentValue;
			$this->qty_o_01->ViewValue = FormatNumber($this->qty_o_01->ViewValue, 2, -2, -2, -2);
			$this->qty_o_01->ViewCustomAttributes = "";

			// lamination_type
			if ($this->lamination_type->VirtualValue <> "") {
				$this->lamination_type->ViewValue = $this->lamination_type->VirtualValue;
			} else {
			$curVal = strval($this->lamination_type->CurrentValue);
			if ($curVal <> "") {
				$this->lamination_type->ViewValue = $this->lamination_type->lookupCacheOption($curVal);
				if ($this->lamination_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (123) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->lamination_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->lamination_type->ViewValue = $this->lamination_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->lamination_type->ViewValue = $this->lamination_type->CurrentValue;
					}
				}
			} else {
				$this->lamination_type->ViewValue = NULL;
			}
			}
			$this->lamination_type->ViewCustomAttributes = "";

			// lamination_qty
			$this->lamination_qty->ViewValue = $this->lamination_qty->CurrentValue;
			$this->lamination_qty->ViewValue = FormatNumber($this->lamination_qty->ViewValue, 0, -2, -2, -2);
			$this->lamination_qty->ViewCustomAttributes = "";

			// die_type
			if ($this->die_type->VirtualValue <> "") {
				$this->die_type->ViewValue = $this->die_type->VirtualValue;
			} else {
			$curVal = strval($this->die_type->CurrentValue);
			if ($curVal <> "") {
				$this->die_type->ViewValue = $this->die_type->lookupCacheOption($curVal);
				if ($this->die_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (124) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->die_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->die_type->ViewValue = $this->die_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->die_type->ViewValue = $this->die_type->CurrentValue;
					}
				}
			} else {
				$this->die_type->ViewValue = NULL;
			}
			}
			$this->die_type->ViewCustomAttributes = "";

			// die_qty
			$this->die_qty->ViewValue = $this->die_qty->CurrentValue;
			$this->die_qty->ViewValue = FormatNumber($this->die_qty->ViewValue, 0, -2, -2, -2);
			$this->die_qty->ViewCustomAttributes = "";

			// binding_type
			$curVal = strval($this->binding_type->CurrentValue);
			if ($curVal <> "") {
				$this->binding_type->ViewValue = $this->binding_type->lookupCacheOption($curVal);
				if ($this->binding_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->binding_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->binding_type->ViewValue = $this->binding_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->binding_type->ViewValue = $this->binding_type->CurrentValue;
					}
				}
			} else {
				$this->binding_type->ViewValue = NULL;
			}
			$this->binding_type->ViewCustomAttributes = "";

			// binding_qty
			$this->binding_qty->ViewValue = $this->binding_qty->CurrentValue;
			$this->binding_qty->ViewValue = FormatNumber($this->binding_qty->ViewValue, 2, -2, -2, -2);
			$this->binding_qty->ViewCustomAttributes = "";

			// number_type
			if ($this->number_type->VirtualValue <> "") {
				$this->number_type->ViewValue = $this->number_type->VirtualValue;
			} else {
			$curVal = strval($this->number_type->CurrentValue);
			if ($curVal <> "") {
				$this->number_type->ViewValue = $this->number_type->lookupCacheOption($curVal);
				if ($this->number_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->number_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->number_type->ViewValue = $this->number_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->number_type->ViewValue = $this->number_type->CurrentValue;
					}
				}
			} else {
				$this->number_type->ViewValue = NULL;
			}
			}
			$this->number_type->ViewCustomAttributes = "";

			// number_qty
			$this->number_qty->ViewValue = $this->number_qty->CurrentValue;
			$this->number_qty->ViewValue = FormatNumber($this->number_qty->ViewValue, 0, -2, -2, -2);
			$this->number_qty->ViewCustomAttributes = "";

			// de_01
			if ($this->de_01->VirtualValue <> "") {
				$this->de_01->ViewValue = $this->de_01->VirtualValue;
			} else {
			$curVal = strval($this->de_01->CurrentValue);
			if ($curVal <> "") {
				$this->de_01->ViewValue = $this->de_01->lookupCacheOption($curVal);
				if ($this->de_01->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->de_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->de_01->ViewValue = $this->de_01->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->de_01->ViewValue = $this->de_01->CurrentValue;
					}
				}
			} else {
				$this->de_01->ViewValue = NULL;
			}
			}
			$this->de_01->ViewCustomAttributes = "";

			// qty_de_01
			$this->qty_de_01->ViewValue = $this->qty_de_01->CurrentValue;
			$this->qty_de_01->ViewValue = FormatNumber($this->qty_de_01->ViewValue, 2, -2, -2, -2);
			$this->qty_de_01->ViewCustomAttributes = "";

			// de_02
			if ($this->de_02->VirtualValue <> "") {
				$this->de_02->ViewValue = $this->de_02->VirtualValue;
			} else {
			$curVal = strval($this->de_02->CurrentValue);
			if ($curVal <> "") {
				$this->de_02->ViewValue = $this->de_02->lookupCacheOption($curVal);
				if ($this->de_02->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->de_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->de_02->ViewValue = $this->de_02->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->de_02->ViewValue = $this->de_02->CurrentValue;
					}
				}
			} else {
				$this->de_02->ViewValue = NULL;
			}
			}
			$this->de_02->ViewCustomAttributes = "";

			// qty_de_02
			$this->qty_de_02->ViewValue = $this->qty_de_02->CurrentValue;
			$this->qty_de_02->ViewValue = FormatNumber($this->qty_de_02->ViewValue, 2, -2, -2, -2);
			$this->qty_de_02->ViewCustomAttributes = "";

			// de_03
			if ($this->de_03->VirtualValue <> "") {
				$this->de_03->ViewValue = $this->de_03->VirtualValue;
			} else {
			$curVal = strval($this->de_03->CurrentValue);
			if ($curVal <> "") {
				$this->de_03->ViewValue = $this->de_03->lookupCacheOption($curVal);
				if ($this->de_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->de_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->de_03->ViewValue = $this->de_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->de_03->ViewValue = $this->de_03->CurrentValue;
					}
				}
			} else {
				$this->de_03->ViewValue = NULL;
			}
			}
			$this->de_03->ViewCustomAttributes = "";

			// qty_de_03
			$this->qty_de_03->ViewValue = $this->qty_de_03->CurrentValue;
			$this->qty_de_03->ViewValue = FormatNumber($this->qty_de_03->ViewValue, 2, -2, -2, -2);
			$this->qty_de_03->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// job_type
			$this->job_type->LinkCustomAttributes = "";
			$this->job_type->HrefValue = "";
			$this->job_type->TooltipValue = "";

			// job_category
			$this->job_category->LinkCustomAttributes = "";
			$this->job_category->HrefValue = "";
			$this->job_category->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";
			$this->description->TooltipValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// pages
			$this->pages->LinkCustomAttributes = "";
			$this->pages->HrefValue = "";
			$this->pages->TooltipValue = "";

			// paper
			$this->paper->LinkCustomAttributes = "";
			$this->paper->HrefValue = "";
			$this->paper->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// pr_01
			$this->pr_01->LinkCustomAttributes = "";
			$this->pr_01->HrefValue = "";
			$this->pr_01->TooltipValue = "";

			// qty_pr_01
			$this->qty_pr_01->LinkCustomAttributes = "";
			$this->qty_pr_01->HrefValue = "";
			$this->qty_pr_01->TooltipValue = "";

			// pl_01
			$this->pl_01->LinkCustomAttributes = "";
			$this->pl_01->HrefValue = "";
			$this->pl_01->TooltipValue = "";

			// qty_pl_01
			$this->qty_pl_01->LinkCustomAttributes = "";
			$this->qty_pl_01->HrefValue = "";
			$this->qty_pl_01->TooltipValue = "";

			// pr_02
			$this->pr_02->LinkCustomAttributes = "";
			$this->pr_02->HrefValue = "";
			$this->pr_02->TooltipValue = "";

			// qty_pr_02
			$this->qty_pr_02->LinkCustomAttributes = "";
			$this->qty_pr_02->HrefValue = "";
			$this->qty_pr_02->TooltipValue = "";

			// pl_02
			$this->pl_02->LinkCustomAttributes = "";
			$this->pl_02->HrefValue = "";
			$this->pl_02->TooltipValue = "";

			// qty_pl_02
			$this->qty_pl_02->LinkCustomAttributes = "";
			$this->qty_pl_02->HrefValue = "";
			$this->qty_pl_02->TooltipValue = "";

			// pr_03
			$this->pr_03->LinkCustomAttributes = "";
			$this->pr_03->HrefValue = "";
			$this->pr_03->TooltipValue = "";

			// qty_pr_03
			$this->qty_pr_03->LinkCustomAttributes = "";
			$this->qty_pr_03->HrefValue = "";
			$this->qty_pr_03->TooltipValue = "";

			// pl_03
			$this->pl_03->LinkCustomAttributes = "";
			$this->pl_03->HrefValue = "";
			$this->pl_03->TooltipValue = "";

			// qty_pl_03
			$this->qty_pl_03->LinkCustomAttributes = "";
			$this->qty_pl_03->HrefValue = "";
			$this->qty_pl_03->TooltipValue = "";

			// pr_04
			$this->pr_04->LinkCustomAttributes = "";
			$this->pr_04->HrefValue = "";
			$this->pr_04->TooltipValue = "";

			// qty_pr_04
			$this->qty_pr_04->LinkCustomAttributes = "";
			$this->qty_pr_04->HrefValue = "";
			$this->qty_pr_04->TooltipValue = "";

			// pl_04
			$this->pl_04->LinkCustomAttributes = "";
			$this->pl_04->HrefValue = "";
			$this->pl_04->TooltipValue = "";

			// qty_pl_04
			$this->qty_pl_04->LinkCustomAttributes = "";
			$this->qty_pl_04->HrefValue = "";
			$this->qty_pl_04->TooltipValue = "";

			// pa_01
			$this->pa_01->LinkCustomAttributes = "";
			$this->pa_01->HrefValue = "";
			$this->pa_01->TooltipValue = "";

			// qty_pa_01
			$this->qty_pa_01->LinkCustomAttributes = "";
			$this->qty_pa_01->HrefValue = "";
			$this->qty_pa_01->TooltipValue = "";

			// pa_02
			$this->pa_02->LinkCustomAttributes = "";
			$this->pa_02->HrefValue = "";
			$this->pa_02->TooltipValue = "";

			// qty_pa_02
			$this->qty_pa_02->LinkCustomAttributes = "";
			$this->qty_pa_02->HrefValue = "";
			$this->qty_pa_02->TooltipValue = "";

			// pa_03
			$this->pa_03->LinkCustomAttributes = "";
			$this->pa_03->HrefValue = "";
			$this->pa_03->TooltipValue = "";

			// qty_pa_03
			$this->qty_pa_03->LinkCustomAttributes = "";
			$this->qty_pa_03->HrefValue = "";
			$this->qty_pa_03->TooltipValue = "";

			// pa_04
			$this->pa_04->LinkCustomAttributes = "";
			$this->pa_04->HrefValue = "";
			$this->pa_04->TooltipValue = "";

			// qty_pa_04
			$this->qty_pa_04->LinkCustomAttributes = "";
			$this->qty_pa_04->HrefValue = "";
			$this->qty_pa_04->TooltipValue = "";

			// pa_05
			$this->pa_05->LinkCustomAttributes = "";
			$this->pa_05->HrefValue = "";
			$this->pa_05->TooltipValue = "";

			// qty_pa_05
			$this->qty_pa_05->LinkCustomAttributes = "";
			$this->qty_pa_05->HrefValue = "";
			$this->qty_pa_05->TooltipValue = "";

			// pc_01
			$this->pc_01->LinkCustomAttributes = "";
			$this->pc_01->HrefValue = "";
			$this->pc_01->TooltipValue = "";

			// qty_pc_01
			$this->qty_pc_01->LinkCustomAttributes = "";
			$this->qty_pc_01->HrefValue = "";
			$this->qty_pc_01->TooltipValue = "";

			// pc_02
			$this->pc_02->LinkCustomAttributes = "";
			$this->pc_02->HrefValue = "";
			$this->pc_02->TooltipValue = "";

			// qty_pc_02
			$this->qty_pc_02->LinkCustomAttributes = "";
			$this->qty_pc_02->HrefValue = "";
			$this->qty_pc_02->TooltipValue = "";

			// o_01
			$this->o_01->LinkCustomAttributes = "";
			$this->o_01->HrefValue = "";
			$this->o_01->TooltipValue = "";

			// qty_o_01
			$this->qty_o_01->LinkCustomAttributes = "";
			$this->qty_o_01->HrefValue = "";
			$this->qty_o_01->TooltipValue = "";

			// lamination_type
			$this->lamination_type->LinkCustomAttributes = "";
			$this->lamination_type->HrefValue = "";
			$this->lamination_type->TooltipValue = "";

			// lamination_qty
			$this->lamination_qty->LinkCustomAttributes = "";
			$this->lamination_qty->HrefValue = "";
			$this->lamination_qty->TooltipValue = "";

			// die_type
			$this->die_type->LinkCustomAttributes = "";
			$this->die_type->HrefValue = "";
			$this->die_type->TooltipValue = "";

			// die_qty
			$this->die_qty->LinkCustomAttributes = "";
			$this->die_qty->HrefValue = "";
			$this->die_qty->TooltipValue = "";

			// binding_type
			$this->binding_type->LinkCustomAttributes = "";
			$this->binding_type->HrefValue = "";
			$this->binding_type->TooltipValue = "";

			// binding_qty
			$this->binding_qty->LinkCustomAttributes = "";
			$this->binding_qty->HrefValue = "";
			$this->binding_qty->TooltipValue = "";

			// number_type
			$this->number_type->LinkCustomAttributes = "";
			$this->number_type->HrefValue = "";
			$this->number_type->TooltipValue = "";

			// number_qty
			$this->number_qty->LinkCustomAttributes = "";
			$this->number_qty->HrefValue = "";
			$this->number_qty->TooltipValue = "";

			// de_01
			$this->de_01->LinkCustomAttributes = "";
			$this->de_01->HrefValue = "";
			$this->de_01->TooltipValue = "";

			// qty_de_01
			$this->qty_de_01->LinkCustomAttributes = "";
			$this->qty_de_01->HrefValue = "";
			$this->qty_de_01->TooltipValue = "";

			// de_02
			$this->de_02->LinkCustomAttributes = "";
			$this->de_02->HrefValue = "";
			$this->de_02->TooltipValue = "";

			// qty_de_02
			$this->qty_de_02->LinkCustomAttributes = "";
			$this->qty_de_02->HrefValue = "";
			$this->qty_de_02->TooltipValue = "";

			// de_03
			$this->de_03->LinkCustomAttributes = "";
			$this->de_03->HrefValue = "";
			$this->de_03->TooltipValue = "";

			// qty_de_03
			$this->qty_de_03->LinkCustomAttributes = "";
			$this->qty_de_03->HrefValue = "";
			$this->qty_de_03->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("p_eastimatelist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$pages->add(7);
		$pages->add(8);
		$pages->add(9);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_size":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_01":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_01":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_02":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_02":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_03":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_03":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pr_04":
					$lookupFilter = function() {
						return "`s_grp` IN (116)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_04":
					$lookupFilter = function() {
						return "`s_grp` IN (115)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_01":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_02":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_03":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_04":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pa_05":
					$lookupFilter = function() {
						return "`s_grp` IN (101,102,112)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pc_01":
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pc_02":
					$lookupFilter = function() {
						return "`s_grp` IN (125) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_o_01":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_lamination_type":
					$lookupFilter = function() {
						return "`s_grp` IN (123) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_die_type":
					$lookupFilter = function() {
						return "`s_grp` IN (124) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_binding_type":
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_number_type":
					$lookupFilter = function() {
						return "`s_grp` IN (114) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_de_01":
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_de_02":
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_de_03":
					$lookupFilter = function() {
						return "`s_grp` IN (121) and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_size":
							break;
						case "x_pr_01":
							break;
						case "x_pl_01":
							break;
						case "x_pr_02":
							break;
						case "x_pl_02":
							break;
						case "x_pr_03":
							break;
						case "x_pl_03":
							break;
						case "x_pr_04":
							break;
						case "x_pl_04":
							break;
						case "x_pa_01":
							break;
						case "x_pa_02":
							break;
						case "x_pa_03":
							break;
						case "x_pa_04":
							break;
						case "x_pa_05":
							break;
						case "x_pc_01":
							break;
						case "x_pc_02":
							break;
						case "x_o_01":
							break;
						case "x_lamination_type":
							break;
						case "x_die_type":
							break;
						case "x_binding_type":
							break;
						case "x_number_type":
							break;
						case "x_de_01":
							break;
						case "x_de_02":
							break;
						case "x_de_03":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>