<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class p_po_add extends p_po
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'p_po';

	// Page object name
	public $PageObjName = "p_po_add";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (p_po)
		if (!isset($GLOBALS["p_po"]) || get_class($GLOBALS["p_po"]) == PROJECT_NAMESPACE . "p_po") {
			$GLOBALS["p_po"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["p_po"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'p_po');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $p_po;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($p_po);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "p_poview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("p_polist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->po->Visible = FALSE;
		$this->type->setVisibility();
		$this->job_category->setVisibility();
		$this->company_id->setVisibility();
		$this->item->setVisibility();
		$this->quantity->setVisibility();
		$this->item_size->setVisibility();
		$this->description_03->setVisibility();
		$this->description_02->setVisibility();
		$this->description_09->setVisibility();
		$this->description_01->setVisibility();
		$this->description_08->setVisibility();
		$this->description_07->setVisibility();
		$this->description_10->setVisibility();
		$this->description_04->setVisibility();
		$this->description_06->setVisibility();
		$this->description_05->setVisibility();
		$this->description_11->Visible = FALSE;
		$this->amount->setVisibility();
		$this->gst->setVisibility();
		$this->buyer_instruction->setVisibility();
		$this->remarks->setVisibility();
		$this->despatch_date->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->uploads->Visible = FALSE;
		$this->production_plan->Visible = FALSE;
		$this->part_dispatch->Visible = FALSE;
		$this->payment_terms->Visible = FALSE;
		$this->transport_type->Visible = FALSE;
		$this->partner_shipping_id->Visible = FALSE;
		$this->description_12->Visible = FALSE;
		$this->description_17->Visible = FALSE;
		$this->description_18->Visible = FALSE;
		$this->description_19->Visible = FALSE;
		$this->description_20->Visible = FALSE;
		$this->production_site->Visible = FALSE;
		$this->jc_no->Visible = FALSE;
		$this->a_operator->Visible = FALSE;
		$this->a_datetime->Visible = FALSE;
		$this->app_operator->Visible = FALSE;
		$this->app_datetime->Visible = FALSE;
		$this->c_operator->Visible = FALSE;
		$this->c_datetime->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->description_03);
		$this->setupLookupOptions($this->description_02);
		$this->setupLookupOptions($this->description_09);
		$this->setupLookupOptions($this->description_01);
		$this->setupLookupOptions($this->description_08);
		$this->setupLookupOptions($this->description_07);
		$this->setupLookupOptions($this->description_10);
		$this->setupLookupOptions($this->description_04);
		$this->setupLookupOptions($this->description_06);
		$this->setupLookupOptions($this->description_05);
		$this->setupLookupOptions($this->gst);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->production_plan);
		$this->setupLookupOptions($this->payment_terms);
		$this->setupLookupOptions($this->transport_type);
		$this->setupLookupOptions($this->partner_shipping_id);
		$this->setupLookupOptions($this->production_site);
		$this->setupLookupOptions($this->a_operator);
		$this->setupLookupOptions($this->app_operator);
		$this->setupLookupOptions($this->c_operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("p_polist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "p_polist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "p_poview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->po->CurrentValue = 0;
		$this->type->CurrentValue = 0;
		$this->job_category->CurrentValue = 0;
		$this->company_id->CurrentValue = ((isset($_GET["CID"]))? $_GET["CID"]:((isset($_COOKIE["CID"]))? $_COOKIE["CID"]:User_Company_ID()));
		$this->item->CurrentValue = (isset($_COOKIE["ITEM"]))? $_COOKIE["ITEM"]:'';
		$this->quantity->CurrentValue = (isset($_COOKIE["QTY"]))? $_COOKIE["QTY"]:'';
		$this->item_size->CurrentValue = (isset($_COOKIE["SIZE"]))? $_COOKIE["SIZE"]:'';
		$this->description_03->CurrentValue = (isset($_COOKIE["D03"]))? $_COOKIE["D03"]:'';
		$this->description_02->CurrentValue = (isset($_COOKIE["D02"]))? $_COOKIE["D02"]:'';
		$this->description_09->CurrentValue = (isset($_COOKIE["D09"]))? $_COOKIE["D09"]:'';
		$this->description_01->CurrentValue = (isset($_COOKIE["D01"]))? $_COOKIE["D01"]:'';
		$this->description_08->CurrentValue = (isset($_COOKIE["D08"]))? $_COOKIE["D08"]:'';
		$this->description_07->CurrentValue = (isset($_COOKIE["D07"]))? $_COOKIE["D07"]:'';
		$this->description_10->CurrentValue = (isset($_COOKIE["D10"]))? $_COOKIE["D10"]:'';
		$this->description_04->CurrentValue = (isset($_COOKIE["D04"]))? $_COOKIE["D04"]:'';
		$this->description_06->CurrentValue = (isset($_COOKIE["D06"]))? $_COOKIE["D06"]:'';
		$this->description_05->CurrentValue = (isset($_COOKIE["D05"]))? $_COOKIE["D05"]:'';
		$this->description_11->CurrentValue = NULL;
		$this->description_11->OldValue = $this->description_11->CurrentValue;
		$this->amount->CurrentValue = NULL;
		$this->amount->OldValue = $this->amount->CurrentValue;
		$this->gst->CurrentValue = 1;
		$this->buyer_instruction->CurrentValue = NULL;
		$this->buyer_instruction->OldValue = $this->buyer_instruction->CurrentValue;
		$this->remarks->CurrentValue = NULL;
		$this->remarks->OldValue = $this->remarks->CurrentValue;
		$this->despatch_date->CurrentValue = NULL;
		$this->despatch_date->OldValue = $this->despatch_date->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->uploads->Upload->DbValue = NULL;
		$this->uploads->OldValue = $this->uploads->Upload->DbValue;
		$this->uploads->CurrentValue = NULL; // Clear file related field
		$this->production_plan->CurrentValue = NULL;
		$this->production_plan->OldValue = $this->production_plan->CurrentValue;
		$this->part_dispatch->CurrentValue = NULL;
		$this->part_dispatch->OldValue = $this->part_dispatch->CurrentValue;
		$this->payment_terms->CurrentValue = NULL;
		$this->payment_terms->OldValue = $this->payment_terms->CurrentValue;
		$this->transport_type->CurrentValue = NULL;
		$this->transport_type->OldValue = $this->transport_type->CurrentValue;
		$this->partner_shipping_id->CurrentValue = NULL;
		$this->partner_shipping_id->OldValue = $this->partner_shipping_id->CurrentValue;
		$this->description_12->CurrentValue = NULL;
		$this->description_12->OldValue = $this->description_12->CurrentValue;
		$this->description_17->CurrentValue = NULL;
		$this->description_17->OldValue = $this->description_17->CurrentValue;
		$this->description_18->CurrentValue = NULL;
		$this->description_18->OldValue = $this->description_18->CurrentValue;
		$this->description_19->CurrentValue = NULL;
		$this->description_19->OldValue = $this->description_19->CurrentValue;
		$this->description_20->CurrentValue = 1;
		$this->production_site->CurrentValue = NULL;
		$this->production_site->OldValue = $this->production_site->CurrentValue;
		$this->jc_no->CurrentValue = NULL;
		$this->jc_no->OldValue = $this->jc_no->CurrentValue;
		$this->a_operator->CurrentValue = NULL;
		$this->a_operator->OldValue = $this->a_operator->CurrentValue;
		$this->a_datetime->CurrentValue = NULL;
		$this->a_datetime->OldValue = $this->a_datetime->CurrentValue;
		$this->app_operator->CurrentValue = NULL;
		$this->app_operator->OldValue = $this->app_operator->CurrentValue;
		$this->app_datetime->CurrentValue = NULL;
		$this->app_datetime->OldValue = $this->app_datetime->CurrentValue;
		$this->c_operator->CurrentValue = NULL;
		$this->c_operator->OldValue = $this->c_operator->CurrentValue;
		$this->c_datetime->CurrentValue = NULL;
		$this->c_datetime->OldValue = $this->c_datetime->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'type' first before field var 'x_type'
		$val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
		if (!$this->type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->type->Visible = FALSE; // Disable update for API request
			else
				$this->type->setFormValue($val);
		}

		// Check field name 'job_category' first before field var 'x_job_category'
		$val = $CurrentForm->hasValue("job_category") ? $CurrentForm->getValue("job_category") : $CurrentForm->getValue("x_job_category");
		if (!$this->job_category->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->job_category->Visible = FALSE; // Disable update for API request
			else
				$this->job_category->setFormValue($val);
		}

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}

		// Check field name 'item' first before field var 'x_item'
		$val = $CurrentForm->hasValue("item") ? $CurrentForm->getValue("item") : $CurrentForm->getValue("x_item");
		if (!$this->item->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->item->Visible = FALSE; // Disable update for API request
			else
				$this->item->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'item_size' first before field var 'x_item_size'
		$val = $CurrentForm->hasValue("item_size") ? $CurrentForm->getValue("item_size") : $CurrentForm->getValue("x_item_size");
		if (!$this->item_size->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->item_size->Visible = FALSE; // Disable update for API request
			else
				$this->item_size->setFormValue($val);
		}

		// Check field name 'description_03' first before field var 'x_description_03'
		$val = $CurrentForm->hasValue("description_03") ? $CurrentForm->getValue("description_03") : $CurrentForm->getValue("x_description_03");
		if (!$this->description_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_03->Visible = FALSE; // Disable update for API request
			else
				$this->description_03->setFormValue($val);
		}

		// Check field name 'description_02' first before field var 'x_description_02'
		$val = $CurrentForm->hasValue("description_02") ? $CurrentForm->getValue("description_02") : $CurrentForm->getValue("x_description_02");
		if (!$this->description_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_02->Visible = FALSE; // Disable update for API request
			else
				$this->description_02->setFormValue($val);
		}

		// Check field name 'description_09' first before field var 'x_description_09'
		$val = $CurrentForm->hasValue("description_09") ? $CurrentForm->getValue("description_09") : $CurrentForm->getValue("x_description_09");
		if (!$this->description_09->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_09->Visible = FALSE; // Disable update for API request
			else
				$this->description_09->setFormValue($val);
		}

		// Check field name 'description_01' first before field var 'x_description_01'
		$val = $CurrentForm->hasValue("description_01") ? $CurrentForm->getValue("description_01") : $CurrentForm->getValue("x_description_01");
		if (!$this->description_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_01->Visible = FALSE; // Disable update for API request
			else
				$this->description_01->setFormValue($val);
		}

		// Check field name 'description_08' first before field var 'x_description_08'
		$val = $CurrentForm->hasValue("description_08") ? $CurrentForm->getValue("description_08") : $CurrentForm->getValue("x_description_08");
		if (!$this->description_08->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_08->Visible = FALSE; // Disable update for API request
			else
				$this->description_08->setFormValue($val);
		}

		// Check field name 'description_07' first before field var 'x_description_07'
		$val = $CurrentForm->hasValue("description_07") ? $CurrentForm->getValue("description_07") : $CurrentForm->getValue("x_description_07");
		if (!$this->description_07->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_07->Visible = FALSE; // Disable update for API request
			else
				$this->description_07->setFormValue($val);
		}

		// Check field name 'description_10' first before field var 'x_description_10'
		$val = $CurrentForm->hasValue("description_10") ? $CurrentForm->getValue("description_10") : $CurrentForm->getValue("x_description_10");
		if (!$this->description_10->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_10->Visible = FALSE; // Disable update for API request
			else
				$this->description_10->setFormValue($val);
		}

		// Check field name 'description_04' first before field var 'x_description_04'
		$val = $CurrentForm->hasValue("description_04") ? $CurrentForm->getValue("description_04") : $CurrentForm->getValue("x_description_04");
		if (!$this->description_04->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_04->Visible = FALSE; // Disable update for API request
			else
				$this->description_04->setFormValue($val);
		}

		// Check field name 'description_06' first before field var 'x_description_06'
		$val = $CurrentForm->hasValue("description_06") ? $CurrentForm->getValue("description_06") : $CurrentForm->getValue("x_description_06");
		if (!$this->description_06->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_06->Visible = FALSE; // Disable update for API request
			else
				$this->description_06->setFormValue($val);
		}

		// Check field name 'description_05' first before field var 'x_description_05'
		$val = $CurrentForm->hasValue("description_05") ? $CurrentForm->getValue("description_05") : $CurrentForm->getValue("x_description_05");
		if (!$this->description_05->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_05->Visible = FALSE; // Disable update for API request
			else
				$this->description_05->setFormValue($val);
		}

		// Check field name 'amount' first before field var 'x_amount'
		$val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
		if (!$this->amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->amount->Visible = FALSE; // Disable update for API request
			else
				$this->amount->setFormValue($val);
		}

		// Check field name 'gst' first before field var 'x_gst'
		$val = $CurrentForm->hasValue("gst") ? $CurrentForm->getValue("gst") : $CurrentForm->getValue("x_gst");
		if (!$this->gst->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gst->Visible = FALSE; // Disable update for API request
			else
				$this->gst->setFormValue($val);
		}

		// Check field name 'buyer_instruction' first before field var 'x_buyer_instruction'
		$val = $CurrentForm->hasValue("buyer_instruction") ? $CurrentForm->getValue("buyer_instruction") : $CurrentForm->getValue("x_buyer_instruction");
		if (!$this->buyer_instruction->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_instruction->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_instruction->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'despatch_date' first before field var 'x_despatch_date'
		$val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
		if (!$this->despatch_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_date->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_date->setFormValue($val);
			$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 11);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->type->CurrentValue = $this->type->FormValue;
		$this->job_category->CurrentValue = $this->job_category->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->item->CurrentValue = $this->item->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->item_size->CurrentValue = $this->item_size->FormValue;
		$this->description_03->CurrentValue = $this->description_03->FormValue;
		$this->description_02->CurrentValue = $this->description_02->FormValue;
		$this->description_09->CurrentValue = $this->description_09->FormValue;
		$this->description_01->CurrentValue = $this->description_01->FormValue;
		$this->description_08->CurrentValue = $this->description_08->FormValue;
		$this->description_07->CurrentValue = $this->description_07->FormValue;
		$this->description_10->CurrentValue = $this->description_10->FormValue;
		$this->description_04->CurrentValue = $this->description_04->FormValue;
		$this->description_06->CurrentValue = $this->description_06->FormValue;
		$this->description_05->CurrentValue = $this->description_05->FormValue;
		$this->amount->CurrentValue = $this->amount->FormValue;
		$this->gst->CurrentValue = $this->gst->FormValue;
		$this->buyer_instruction->CurrentValue = $this->buyer_instruction->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
		$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 11);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->po->setDbValue($row['po']);
		$this->type->setDbValue($row['type']);
		$this->job_category->setDbValue($row['job_category']);
		$this->company_id->setDbValue($row['company_id']);
		$this->item->setDbValue($row['item']);
		$this->quantity->setDbValue($row['quantity']);
		$this->item_size->setDbValue($row['item_size']);
		$this->description_03->setDbValue($row['description_03']);
		$this->description_02->setDbValue($row['description_02']);
		$this->description_09->setDbValue($row['description_09']);
		$this->description_01->setDbValue($row['description_01']);
		$this->description_08->setDbValue($row['description_08']);
		$this->description_07->setDbValue($row['description_07']);
		$this->description_10->setDbValue($row['description_10']);
		$this->description_04->setDbValue($row['description_04']);
		$this->description_06->setDbValue($row['description_06']);
		$this->description_05->setDbValue($row['description_05']);
		$this->description_11->setDbValue($row['description_11']);
		$this->amount->setDbValue($row['amount']);
		$this->gst->setDbValue($row['gst']);
		$this->buyer_instruction->setDbValue($row['buyer_instruction']);
		$this->remarks->setDbValue($row['remarks']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->production_plan->setDbValue($row['production_plan']);
		$this->part_dispatch->setDbValue($row['part_dispatch']);
		$this->payment_terms->setDbValue($row['payment_terms']);
		$this->transport_type->setDbValue($row['transport_type']);
		$this->partner_shipping_id->setDbValue($row['partner_shipping_id']);
		$this->description_12->setDbValue($row['description_12']);
		$this->description_17->setDbValue($row['description_17']);
		$this->description_18->setDbValue($row['description_18']);
		$this->description_19->setDbValue($row['description_19']);
		$this->description_20->setDbValue($row['description_20']);
		$this->production_site->setDbValue($row['production_site']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->a_datetime->setDbValue($row['a_datetime']);
		$this->app_operator->setDbValue($row['app_operator']);
		$this->app_datetime->setDbValue($row['app_datetime']);
		$this->c_operator->setDbValue($row['c_operator']);
		$this->c_datetime->setDbValue($row['c_datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['po'] = $this->po->CurrentValue;
		$row['type'] = $this->type->CurrentValue;
		$row['job_category'] = $this->job_category->CurrentValue;
		$row['company_id'] = $this->company_id->CurrentValue;
		$row['item'] = $this->item->CurrentValue;
		$row['quantity'] = $this->quantity->CurrentValue;
		$row['item_size'] = $this->item_size->CurrentValue;
		$row['description_03'] = $this->description_03->CurrentValue;
		$row['description_02'] = $this->description_02->CurrentValue;
		$row['description_09'] = $this->description_09->CurrentValue;
		$row['description_01'] = $this->description_01->CurrentValue;
		$row['description_08'] = $this->description_08->CurrentValue;
		$row['description_07'] = $this->description_07->CurrentValue;
		$row['description_10'] = $this->description_10->CurrentValue;
		$row['description_04'] = $this->description_04->CurrentValue;
		$row['description_06'] = $this->description_06->CurrentValue;
		$row['description_05'] = $this->description_05->CurrentValue;
		$row['description_11'] = $this->description_11->CurrentValue;
		$row['amount'] = $this->amount->CurrentValue;
		$row['gst'] = $this->gst->CurrentValue;
		$row['buyer_instruction'] = $this->buyer_instruction->CurrentValue;
		$row['remarks'] = $this->remarks->CurrentValue;
		$row['despatch_date'] = $this->despatch_date->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['uploads'] = $this->uploads->Upload->DbValue;
		$row['production_plan'] = $this->production_plan->CurrentValue;
		$row['part_dispatch'] = $this->part_dispatch->CurrentValue;
		$row['payment_terms'] = $this->payment_terms->CurrentValue;
		$row['transport_type'] = $this->transport_type->CurrentValue;
		$row['partner_shipping_id'] = $this->partner_shipping_id->CurrentValue;
		$row['description_12'] = $this->description_12->CurrentValue;
		$row['description_17'] = $this->description_17->CurrentValue;
		$row['description_18'] = $this->description_18->CurrentValue;
		$row['description_19'] = $this->description_19->CurrentValue;
		$row['description_20'] = $this->description_20->CurrentValue;
		$row['production_site'] = $this->production_site->CurrentValue;
		$row['jc_no'] = $this->jc_no->CurrentValue;
		$row['a_operator'] = $this->a_operator->CurrentValue;
		$row['a_datetime'] = $this->a_datetime->CurrentValue;
		$row['app_operator'] = $this->app_operator->CurrentValue;
		$row['app_datetime'] = $this->app_datetime->CurrentValue;
		$row['c_operator'] = $this->c_operator->CurrentValue;
		$row['c_datetime'] = $this->c_datetime->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// po
		// type
		// job_category
		// company_id
		// item
		// quantity
		// item_size
		// description_03
		// description_02
		// description_09
		// description_01
		// description_08
		// description_07
		// description_10
		// description_04
		// description_06
		// description_05
		// description_11
		// amount
		// gst
		// buyer_instruction
		// remarks
		// despatch_date
		// operator
		// datetime
		// uploads
		// production_plan
		// part_dispatch
		// payment_terms
		// transport_type
		// partner_shipping_id
		// description_12
		// description_17
		// description_18
		// description_19
		// description_20
		// production_site
		// jc_no
		// a_operator
		// a_datetime
		// app_operator
		// app_datetime
		// c_operator
		// c_datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// type
			if (strval($this->type->CurrentValue) <> "") {
				$this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
			} else {
				$this->type->ViewValue = NULL;
			}
			$this->type->ViewCustomAttributes = "";

			// job_category
			if (strval($this->job_category->CurrentValue) <> "") {
				$this->job_category->ViewValue = $this->job_category->optionCaption($this->job_category->CurrentValue);
			} else {
				$this->job_category->ViewValue = NULL;
			}
			$this->job_category->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? ((User_Site() == 0) ? "" : "(`status` = 1 and `partner_type` = 2 and `id` >= 1000)") : "(`id` = " .  User_Company_ID()  . " || `id` = " .  User_Company_ID()  . ") and `status` = 1 and `id` >= 1000 and `partner_type` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// item
			$this->item->ViewValue = $this->item->CurrentValue;
			$this->item->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// item_size
			$this->item_size->ViewValue = $this->item_size->CurrentValue;
			$this->item_size->ViewCustomAttributes = "";

			// description_03
			$curVal = strval($this->description_03->CurrentValue);
			if ($curVal <> "") {
				$this->description_03->ViewValue = $this->description_03->lookupCacheOption($curVal);
				if ($this->description_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (116)" : "`s_grp` IN (116) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->description_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
							$this->description_03->ViewValue->add($this->description_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->description_03->ViewValue = $this->description_03->CurrentValue;
					}
				}
			} else {
				$this->description_03->ViewValue = NULL;
			}
			$this->description_03->ViewCustomAttributes = "";

			// description_02
			$curVal = strval($this->description_02->CurrentValue);
			if ($curVal <> "") {
				$this->description_02->ViewValue = $this->description_02->lookupCacheOption($curVal);
				if ($this->description_02->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (115)" : "`s_grp` IN (115) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->description_02->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
							$this->description_02->ViewValue->add($this->description_02->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->description_02->ViewValue = $this->description_02->CurrentValue;
					}
				}
			} else {
				$this->description_02->ViewValue = NULL;
			}
			$this->description_02->ViewCustomAttributes = "";

			// description_09
			$curVal = strval($this->description_09->CurrentValue);
			if ($curVal <> "") {
				$this->description_09->ViewValue = $this->description_09->lookupCacheOption($curVal);
				if ($this->description_09->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (126)" : "`s_grp` IN (126) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->description_09->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
							$this->description_09->ViewValue->add($this->description_09->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->description_09->ViewValue = $this->description_09->CurrentValue;
					}
				}
			} else {
				$this->description_09->ViewValue = NULL;
			}
			$this->description_09->ViewCustomAttributes = "";

			// description_01
			$curVal = strval($this->description_01->CurrentValue);
			if ($curVal <> "") {
				$this->description_01->ViewValue = $this->description_01->lookupCacheOption($curVal);
				if ($this->description_01->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (101,102,112)" : "`s_grp` IN (101,102,112) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->description_01->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
							$this->description_01->ViewValue->add($this->description_01->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->description_01->ViewValue = $this->description_01->CurrentValue;
					}
				}
			} else {
				$this->description_01->ViewValue = NULL;
			}
			$this->description_01->ViewCustomAttributes = "";

			// description_08
			$curVal = strval($this->description_08->CurrentValue);
			if ($curVal <> "") {
				$this->description_08->ViewValue = $this->description_08->lookupCacheOption($curVal);
				if ($this->description_08->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (125)" : "`s_grp` IN (125) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->description_08->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
							$this->description_08->ViewValue->add($this->description_08->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->description_08->ViewValue = $this->description_08->CurrentValue;
					}
				}
			} else {
				$this->description_08->ViewValue = NULL;
			}
			$this->description_08->ViewCustomAttributes = "";

			// description_07
			$curVal = strval($this->description_07->CurrentValue);
			if ($curVal <> "") {
				$this->description_07->ViewValue = $this->description_07->lookupCacheOption($curVal);
				if ($this->description_07->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (123)" : "`s_grp` IN (123) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->description_07->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
							$this->description_07->ViewValue->add($this->description_07->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->description_07->ViewValue = $this->description_07->CurrentValue;
					}
				}
			} else {
				$this->description_07->ViewValue = NULL;
			}
			$this->description_07->ViewCustomAttributes = "";

			// description_10
			$curVal = strval($this->description_10->CurrentValue);
			if ($curVal <> "") {
				$this->description_10->ViewValue = $this->description_10->lookupCacheOption($curVal);
				if ($this->description_10->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (124)" : "`s_grp` IN (124) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->description_10->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
							$this->description_10->ViewValue->add($this->description_10->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->description_10->ViewValue = $this->description_10->CurrentValue;
					}
				}
			} else {
				$this->description_10->ViewValue = NULL;
			}
			$this->description_10->ViewCustomAttributes = "";

			// description_04
			$curVal = strval($this->description_04->CurrentValue);
			if ($curVal <> "") {
				$this->description_04->ViewValue = $this->description_04->lookupCacheOption($curVal);
				if ($this->description_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (114)" : "`s_grp` IN (114) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->description_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
							$this->description_04->ViewValue->add($this->description_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->description_04->ViewValue = $this->description_04->CurrentValue;
					}
				}
			} else {
				$this->description_04->ViewValue = NULL;
			}
			$this->description_04->ViewCustomAttributes = "";

			// description_06
			$curVal = strval($this->description_06->CurrentValue);
			if ($curVal <> "") {
				$this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
				if ($this->description_06->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (121)" : "`s_grp` IN (121) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->description_06->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
							$this->description_06->ViewValue->add($this->description_06->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->description_06->ViewValue = $this->description_06->CurrentValue;
					}
				}
			} else {
				$this->description_06->ViewValue = NULL;
			}
			$this->description_06->ViewCustomAttributes = "";

			// description_05
			$curVal = strval($this->description_05->CurrentValue);
			if ($curVal <> "") {
				$this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
				if ($this->description_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` NOT IN (101,102,112,114,115,116,121,123,124,125,126)" : "`s_grp` NOT IN (101,102,112,114,115,116,121,123,124,125,126) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->description_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
							$this->description_05->ViewValue->add($this->description_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->description_05->ViewValue = $this->description_05->CurrentValue;
					}
				}
			} else {
				$this->description_05->ViewValue = NULL;
			}
			$this->description_05->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewCustomAttributes = "";

			// gst
			$curVal = strval($this->gst->CurrentValue);
			if ($curVal <> "") {
				$this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
				if ($this->gst->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->gst->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
						$arwrk[3] = $rswrk->fields('df3');
						$this->gst->ViewValue = $this->gst->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->gst->ViewValue = $this->gst->CurrentValue;
					}
				}
			} else {
				$this->gst->ViewValue = NULL;
			}
			$this->gst->ViewCustomAttributes = "";

			// buyer_instruction
			$this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;
			$this->buyer_instruction->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 11);
			$this->datetime->ViewCustomAttributes = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";
			$this->type->TooltipValue = "";

			// job_category
			$this->job_category->LinkCustomAttributes = "";
			$this->job_category->HrefValue = "";
			$this->job_category->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// item
			$this->item->LinkCustomAttributes = "";
			$this->item->HrefValue = "";
			$this->item->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// item_size
			$this->item_size->LinkCustomAttributes = "";
			$this->item_size->HrefValue = "";
			$this->item_size->TooltipValue = "";

			// description_03
			$this->description_03->LinkCustomAttributes = "";
			$this->description_03->HrefValue = "";
			$this->description_03->TooltipValue = "";

			// description_02
			$this->description_02->LinkCustomAttributes = "";
			$this->description_02->HrefValue = "";
			$this->description_02->TooltipValue = "";

			// description_09
			$this->description_09->LinkCustomAttributes = "";
			$this->description_09->HrefValue = "";
			$this->description_09->TooltipValue = "";

			// description_01
			$this->description_01->LinkCustomAttributes = "";
			$this->description_01->HrefValue = "";
			$this->description_01->TooltipValue = "";

			// description_08
			$this->description_08->LinkCustomAttributes = "";
			$this->description_08->HrefValue = "";
			$this->description_08->TooltipValue = "";

			// description_07
			$this->description_07->LinkCustomAttributes = "";
			$this->description_07->HrefValue = "";
			$this->description_07->TooltipValue = "";

			// description_10
			$this->description_10->LinkCustomAttributes = "";
			$this->description_10->HrefValue = "";
			$this->description_10->TooltipValue = "";

			// description_04
			$this->description_04->LinkCustomAttributes = "";
			$this->description_04->HrefValue = "";
			$this->description_04->TooltipValue = "";

			// description_06
			$this->description_06->LinkCustomAttributes = "";
			$this->description_06->HrefValue = "";
			$this->description_06->TooltipValue = "";

			// description_05
			$this->description_05->LinkCustomAttributes = "";
			$this->description_05->HrefValue = "";
			$this->description_05->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// gst
			$this->gst->LinkCustomAttributes = "";
			$this->gst->HrefValue = "";
			$this->gst->TooltipValue = "";

			// buyer_instruction
			$this->buyer_instruction->LinkCustomAttributes = "";
			$this->buyer_instruction->HrefValue = "";
			$this->buyer_instruction->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// type
			$this->type->EditAttrs["class"] = "form-control";
			$this->type->EditCustomAttributes = "";
			$this->type->EditValue = $this->type->options(TRUE);

			// job_category
			$this->job_category->EditCustomAttributes = "";
			$this->job_category->EditValue = $this->job_category->options(FALSE);

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? ((User_Site() == 0) ? "" : "(`status` = 1 and `partner_type` = 2 and `id` >= 1000)") : "(`id` = " .  User_Company_ID()  . " || `id` = " .  User_Company_ID()  . ") and `status` = 1 and `id` >= 1000 and `partner_type` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->company_id->EditValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->EditValue = HtmlEncode($this->company_id->CurrentValue);
					}
				}
			} else {
				$this->company_id->EditValue = NULL;
			}
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// item
			$this->item->EditAttrs["class"] = "form-control";
			$this->item->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->item->CurrentValue = HtmlDecode($this->item->CurrentValue);
			$this->item->EditValue = HtmlEncode($this->item->CurrentValue);
			$this->item->PlaceHolder = RemoveHtml($this->item->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// item_size
			$this->item_size->EditAttrs["class"] = "form-control";
			$this->item_size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->item_size->CurrentValue = HtmlDecode($this->item_size->CurrentValue);
			$this->item_size->EditValue = HtmlEncode($this->item_size->CurrentValue);
			$this->item_size->PlaceHolder = RemoveHtml($this->item_size->caption());

			// description_03
			$this->description_03->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_03->CurrentValue));
			if ($curVal <> "")
				$this->description_03->ViewValue = $this->description_03->lookupCacheOption($curVal);
			else
				$this->description_03->ViewValue = $this->description_03->Lookup !== NULL && is_array($this->description_03->Lookup->Options) ? $curVal : NULL;
			if ($this->description_03->ViewValue !== NULL) { // Load from cache
				$this->description_03->EditValue = array_values($this->description_03->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (116)" : "`s_grp` IN (116) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_03->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, -2);
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, -2);
				}
				$this->description_03->EditValue = $arwrk;
			}

			// description_02
			$this->description_02->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_02->CurrentValue));
			if ($curVal <> "")
				$this->description_02->ViewValue = $this->description_02->lookupCacheOption($curVal);
			else
				$this->description_02->ViewValue = $this->description_02->Lookup !== NULL && is_array($this->description_02->Lookup->Options) ? $curVal : NULL;
			if ($this->description_02->ViewValue !== NULL) { // Load from cache
				$this->description_02->EditValue = array_values($this->description_02->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (115)" : "`s_grp` IN (115) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_02->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, -2);
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, -2);
				}
				$this->description_02->EditValue = $arwrk;
			}

			// description_09
			$this->description_09->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_09->CurrentValue));
			if ($curVal <> "")
				$this->description_09->ViewValue = $this->description_09->lookupCacheOption($curVal);
			else
				$this->description_09->ViewValue = $this->description_09->Lookup !== NULL && is_array($this->description_09->Lookup->Options) ? $curVal : NULL;
			if ($this->description_09->ViewValue !== NULL) { // Load from cache
				$this->description_09->EditValue = array_values($this->description_09->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (126)" : "`s_grp` IN (126) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_09->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, -2);
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, -2);
				}
				$this->description_09->EditValue = $arwrk;
			}

			// description_01
			$this->description_01->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_01->CurrentValue));
			if ($curVal <> "")
				$this->description_01->ViewValue = $this->description_01->lookupCacheOption($curVal);
			else
				$this->description_01->ViewValue = $this->description_01->Lookup !== NULL && is_array($this->description_01->Lookup->Options) ? $curVal : NULL;
			if ($this->description_01->ViewValue !== NULL) { // Load from cache
				$this->description_01->EditValue = array_values($this->description_01->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (101,102,112)" : "`s_grp` IN (101,102,112) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_01->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, -2);
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, -2);
				}
				$this->description_01->EditValue = $arwrk;
			}

			// description_08
			$this->description_08->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_08->CurrentValue));
			if ($curVal <> "")
				$this->description_08->ViewValue = $this->description_08->lookupCacheOption($curVal);
			else
				$this->description_08->ViewValue = $this->description_08->Lookup !== NULL && is_array($this->description_08->Lookup->Options) ? $curVal : NULL;
			if ($this->description_08->ViewValue !== NULL) { // Load from cache
				$this->description_08->EditValue = array_values($this->description_08->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (125)" : "`s_grp` IN (125) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_08->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, -2);
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, -2);
				}
				$this->description_08->EditValue = $arwrk;
			}

			// description_07
			$this->description_07->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_07->CurrentValue));
			if ($curVal <> "")
				$this->description_07->ViewValue = $this->description_07->lookupCacheOption($curVal);
			else
				$this->description_07->ViewValue = $this->description_07->Lookup !== NULL && is_array($this->description_07->Lookup->Options) ? $curVal : NULL;
			if ($this->description_07->ViewValue !== NULL) { // Load from cache
				$this->description_07->EditValue = array_values($this->description_07->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (123)" : "`s_grp` IN (123) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_07->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, -2);
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, -2);
				}
				$this->description_07->EditValue = $arwrk;
			}

			// description_10
			$this->description_10->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_10->CurrentValue));
			if ($curVal <> "")
				$this->description_10->ViewValue = $this->description_10->lookupCacheOption($curVal);
			else
				$this->description_10->ViewValue = $this->description_10->Lookup !== NULL && is_array($this->description_10->Lookup->Options) ? $curVal : NULL;
			if ($this->description_10->ViewValue !== NULL) { // Load from cache
				$this->description_10->EditValue = array_values($this->description_10->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (124)" : "`s_grp` IN (124) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_10->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, -2);
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, -2);
				}
				$this->description_10->EditValue = $arwrk;
			}

			// description_04
			$this->description_04->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_04->CurrentValue));
			if ($curVal <> "")
				$this->description_04->ViewValue = $this->description_04->lookupCacheOption($curVal);
			else
				$this->description_04->ViewValue = $this->description_04->Lookup !== NULL && is_array($this->description_04->Lookup->Options) ? $curVal : NULL;
			if ($this->description_04->ViewValue !== NULL) { // Load from cache
				$this->description_04->EditValue = array_values($this->description_04->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (114)" : "`s_grp` IN (114) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_04->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, -2);
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, -2);
				}
				$this->description_04->EditValue = $arwrk;
			}

			// description_06
			$this->description_06->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_06->CurrentValue));
			if ($curVal <> "")
				$this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
			else
				$this->description_06->ViewValue = $this->description_06->Lookup !== NULL && is_array($this->description_06->Lookup->Options) ? $curVal : NULL;
			if ($this->description_06->ViewValue !== NULL) { // Load from cache
				$this->description_06->EditValue = array_values($this->description_06->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (121)" : "`s_grp` IN (121) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_06->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, -2);
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, -2);
				}
				$this->description_06->EditValue = $arwrk;
			}

			// description_05
			$this->description_05->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_05->CurrentValue));
			if ($curVal <> "")
				$this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
			else
				$this->description_05->ViewValue = $this->description_05->Lookup !== NULL && is_array($this->description_05->Lookup->Options) ? $curVal : NULL;
			if ($this->description_05->ViewValue !== NULL) { // Load from cache
				$this->description_05->EditValue = array_values($this->description_05->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` NOT IN (101,102,112,114,115,116,121,123,124,125,126)" : "`s_grp` NOT IN (101,102,112,114,115,116,121,123,124,125,126) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_05->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, -2);
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, -2);
				}
				$this->description_05->EditValue = $arwrk;
			}

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = 'ReadOnly';
			if (REMOVE_XSS)
				$this->amount->CurrentValue = HtmlDecode($this->amount->CurrentValue);
			$this->amount->EditValue = HtmlEncode($this->amount->CurrentValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

			// gst
			$this->gst->EditAttrs["class"] = "form-control";
			$this->gst->EditCustomAttributes = "";
			$curVal = trim(strval($this->gst->CurrentValue));
			if ($curVal <> "")
				$this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
			else
				$this->gst->ViewValue = $this->gst->Lookup !== NULL && is_array($this->gst->Lookup->Options) ? $curVal : NULL;
			if ($this->gst->ViewValue !== NULL) { // Load from cache
				$this->gst->EditValue = array_values($this->gst->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->gst->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->gst->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, -2);
				}
				$this->gst->EditValue = $arwrk;
			}

			// buyer_instruction
			$this->buyer_instruction->EditAttrs["class"] = "form-control";
			$this->buyer_instruction->EditCustomAttributes = "";
			$this->buyer_instruction->EditValue = HtmlEncode($this->buyer_instruction->CurrentValue);
			$this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// despatch_date
			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = HtmlEncode(FormatDateTime($this->despatch_date->CurrentValue, 8));
			$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

			// operator
			// datetime
			// Add refer script
			// type

			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";

			// job_category
			$this->job_category->LinkCustomAttributes = "";
			$this->job_category->HrefValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// item
			$this->item->LinkCustomAttributes = "";
			$this->item->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// item_size
			$this->item_size->LinkCustomAttributes = "";
			$this->item_size->HrefValue = "";

			// description_03
			$this->description_03->LinkCustomAttributes = "";
			$this->description_03->HrefValue = "";

			// description_02
			$this->description_02->LinkCustomAttributes = "";
			$this->description_02->HrefValue = "";

			// description_09
			$this->description_09->LinkCustomAttributes = "";
			$this->description_09->HrefValue = "";

			// description_01
			$this->description_01->LinkCustomAttributes = "";
			$this->description_01->HrefValue = "";

			// description_08
			$this->description_08->LinkCustomAttributes = "";
			$this->description_08->HrefValue = "";

			// description_07
			$this->description_07->LinkCustomAttributes = "";
			$this->description_07->HrefValue = "";

			// description_10
			$this->description_10->LinkCustomAttributes = "";
			$this->description_10->HrefValue = "";

			// description_04
			$this->description_04->LinkCustomAttributes = "";
			$this->description_04->HrefValue = "";

			// description_06
			$this->description_06->LinkCustomAttributes = "";
			$this->description_06->HrefValue = "";

			// description_05
			$this->description_05->LinkCustomAttributes = "";
			$this->description_05->HrefValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";

			// gst
			$this->gst->LinkCustomAttributes = "";
			$this->gst->HrefValue = "";

			// buyer_instruction
			$this->buyer_instruction->LinkCustomAttributes = "";
			$this->buyer_instruction->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->po->Required) {
			if (!$this->po->IsDetailKey && $this->po->FormValue != NULL && $this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if ($this->type->Required) {
			if (!$this->type->IsDetailKey && $this->type->FormValue != NULL && $this->type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
			}
		}
		if ($this->job_category->Required) {
			if ($this->job_category->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->job_category->caption(), $this->job_category->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->company_id->FormValue)) {
			AddMessage($FormError, $this->company_id->errorMessage());
		}
		if ($this->item->Required) {
			if (!$this->item->IsDetailKey && $this->item->FormValue != NULL && $this->item->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->item->caption(), $this->item->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if ($this->item_size->Required) {
			if (!$this->item_size->IsDetailKey && $this->item_size->FormValue != NULL && $this->item_size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->item_size->caption(), $this->item_size->RequiredErrorMessage));
			}
		}
		if ($this->description_03->Required) {
			if ($this->description_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_03->caption(), $this->description_03->RequiredErrorMessage));
			}
		}
		if ($this->description_02->Required) {
			if ($this->description_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_02->caption(), $this->description_02->RequiredErrorMessage));
			}
		}
		if ($this->description_09->Required) {
			if ($this->description_09->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_09->caption(), $this->description_09->RequiredErrorMessage));
			}
		}
		if ($this->description_01->Required) {
			if ($this->description_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_01->caption(), $this->description_01->RequiredErrorMessage));
			}
		}
		if ($this->description_08->Required) {
			if ($this->description_08->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_08->caption(), $this->description_08->RequiredErrorMessage));
			}
		}
		if ($this->description_07->Required) {
			if ($this->description_07->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_07->caption(), $this->description_07->RequiredErrorMessage));
			}
		}
		if ($this->description_10->Required) {
			if ($this->description_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_10->caption(), $this->description_10->RequiredErrorMessage));
			}
		}
		if ($this->description_04->Required) {
			if ($this->description_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_04->caption(), $this->description_04->RequiredErrorMessage));
			}
		}
		if ($this->description_06->Required) {
			if ($this->description_06->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_06->caption(), $this->description_06->RequiredErrorMessage));
			}
		}
		if ($this->description_05->Required) {
			if ($this->description_05->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_05->caption(), $this->description_05->RequiredErrorMessage));
			}
		}
		if ($this->description_11->Required) {
			if (!$this->description_11->IsDetailKey && $this->description_11->FormValue != NULL && $this->description_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_11->caption(), $this->description_11->RequiredErrorMessage));
			}
		}
		if ($this->amount->Required) {
			if (!$this->amount->IsDetailKey && $this->amount->FormValue != NULL && $this->amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
			}
		}
		if ($this->gst->Required) {
			if (!$this->gst->IsDetailKey && $this->gst->FormValue != NULL && $this->gst->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gst->caption(), $this->gst->RequiredErrorMessage));
			}
		}
		if ($this->buyer_instruction->Required) {
			if (!$this->buyer_instruction->IsDetailKey && $this->buyer_instruction->FormValue != NULL && $this->buyer_instruction->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_instruction->caption(), $this->buyer_instruction->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->despatch_date->Required) {
			if (!$this->despatch_date->IsDetailKey && $this->despatch_date->FormValue != NULL && $this->despatch_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->despatch_date->FormValue)) {
			AddMessage($FormError, $this->despatch_date->errorMessage());
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->uploads->Required) {
			if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
			}
		}
		if ($this->production_plan->Required) {
			if (!$this->production_plan->IsDetailKey && $this->production_plan->FormValue != NULL && $this->production_plan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_plan->caption(), $this->production_plan->RequiredErrorMessage));
			}
		}
		if ($this->part_dispatch->Required) {
			if (!$this->part_dispatch->IsDetailKey && $this->part_dispatch->FormValue != NULL && $this->part_dispatch->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->part_dispatch->caption(), $this->part_dispatch->RequiredErrorMessage));
			}
		}
		if ($this->payment_terms->Required) {
			if (!$this->payment_terms->IsDetailKey && $this->payment_terms->FormValue != NULL && $this->payment_terms->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment_terms->caption(), $this->payment_terms->RequiredErrorMessage));
			}
		}
		if ($this->transport_type->Required) {
			if (!$this->transport_type->IsDetailKey && $this->transport_type->FormValue != NULL && $this->transport_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->transport_type->caption(), $this->transport_type->RequiredErrorMessage));
			}
		}
		if ($this->partner_shipping_id->Required) {
			if (!$this->partner_shipping_id->IsDetailKey && $this->partner_shipping_id->FormValue != NULL && $this->partner_shipping_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_shipping_id->caption(), $this->partner_shipping_id->RequiredErrorMessage));
			}
		}
		if ($this->description_12->Required) {
			if (!$this->description_12->IsDetailKey && $this->description_12->FormValue != NULL && $this->description_12->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_12->caption(), $this->description_12->RequiredErrorMessage));
			}
		}
		if ($this->description_17->Required) {
			if (!$this->description_17->IsDetailKey && $this->description_17->FormValue != NULL && $this->description_17->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_17->caption(), $this->description_17->RequiredErrorMessage));
			}
		}
		if ($this->description_18->Required) {
			if (!$this->description_18->IsDetailKey && $this->description_18->FormValue != NULL && $this->description_18->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_18->caption(), $this->description_18->RequiredErrorMessage));
			}
		}
		if ($this->description_19->Required) {
			if (!$this->description_19->IsDetailKey && $this->description_19->FormValue != NULL && $this->description_19->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_19->caption(), $this->description_19->RequiredErrorMessage));
			}
		}
		if ($this->description_20->Required) {
			if (!$this->description_20->IsDetailKey && $this->description_20->FormValue != NULL && $this->description_20->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_20->caption(), $this->description_20->RequiredErrorMessage));
			}
		}
		if ($this->production_site->Required) {
			if (!$this->production_site->IsDetailKey && $this->production_site->FormValue != NULL && $this->production_site->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_site->caption(), $this->production_site->RequiredErrorMessage));
			}
		}
		if ($this->jc_no->Required) {
			if (!$this->jc_no->IsDetailKey && $this->jc_no->FormValue != NULL && $this->jc_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
			}
		}
		if ($this->a_operator->Required) {
			if (!$this->a_operator->IsDetailKey && $this->a_operator->FormValue != NULL && $this->a_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_operator->caption(), $this->a_operator->RequiredErrorMessage));
			}
		}
		if ($this->a_datetime->Required) {
			if (!$this->a_datetime->IsDetailKey && $this->a_datetime->FormValue != NULL && $this->a_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_datetime->caption(), $this->a_datetime->RequiredErrorMessage));
			}
		}
		if ($this->app_operator->Required) {
			if (!$this->app_operator->IsDetailKey && $this->app_operator->FormValue != NULL && $this->app_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->app_operator->caption(), $this->app_operator->RequiredErrorMessage));
			}
		}
		if ($this->app_datetime->Required) {
			if (!$this->app_datetime->IsDetailKey && $this->app_datetime->FormValue != NULL && $this->app_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->app_datetime->caption(), $this->app_datetime->RequiredErrorMessage));
			}
		}
		if ($this->c_operator->Required) {
			if (!$this->c_operator->IsDetailKey && $this->c_operator->FormValue != NULL && $this->c_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->c_operator->caption(), $this->c_operator->RequiredErrorMessage));
			}
		}
		if ($this->c_datetime->Required) {
			if (!$this->c_datetime->IsDetailKey && $this->c_datetime->FormValue != NULL && $this->c_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->c_datetime->caption(), $this->c_datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
			$this->uploads->OldUploadPath = '/.p_uploads/sppo/' . $this->id->CurrentValue . '/' ;
			$this->uploads->UploadPath = $this->uploads->OldUploadPath;
		}
		$rsnew = [];

		// type
		$this->type->setDbValueDef($rsnew, $this->type->CurrentValue, 0, strval($this->type->CurrentValue) == "");

		// job_category
		$this->job_category->setDbValueDef($rsnew, $this->job_category->CurrentValue, 0, strval($this->job_category->CurrentValue) == "");

		// company_id
		$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, NULL, FALSE);

		// item
		$this->item->setDbValueDef($rsnew, $this->item->CurrentValue, "", FALSE);

		// quantity
		$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, NULL, FALSE);

		// item_size
		$this->item_size->setDbValueDef($rsnew, $this->item_size->CurrentValue, NULL, FALSE);

		// description_03
		$this->description_03->setDbValueDef($rsnew, $this->description_03->CurrentValue, NULL, FALSE);

		// description_02
		$this->description_02->setDbValueDef($rsnew, $this->description_02->CurrentValue, NULL, FALSE);

		// description_09
		$this->description_09->setDbValueDef($rsnew, $this->description_09->CurrentValue, NULL, FALSE);

		// description_01
		$this->description_01->setDbValueDef($rsnew, $this->description_01->CurrentValue, NULL, FALSE);

		// description_08
		$this->description_08->setDbValueDef($rsnew, $this->description_08->CurrentValue, NULL, FALSE);

		// description_07
		$this->description_07->setDbValueDef($rsnew, $this->description_07->CurrentValue, NULL, FALSE);

		// description_10
		$this->description_10->setDbValueDef($rsnew, $this->description_10->CurrentValue, NULL, FALSE);

		// description_04
		$this->description_04->setDbValueDef($rsnew, $this->description_04->CurrentValue, NULL, FALSE);

		// description_06
		$this->description_06->setDbValueDef($rsnew, $this->description_06->CurrentValue, NULL, FALSE);

		// description_05
		$this->description_05->setDbValueDef($rsnew, $this->description_05->CurrentValue, NULL, FALSE);

		// amount
		$this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, "", strval($this->amount->CurrentValue) == "");

		// gst
		$this->gst->setDbValueDef($rsnew, $this->gst->CurrentValue, 0, strval($this->gst->CurrentValue) == "");

		// buyer_instruction
		$this->buyer_instruction->setDbValueDef($rsnew, $this->buyer_instruction->CurrentValue, NULL, FALSE);

		// remarks
		$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, FALSE);

		// despatch_date
		$this->despatch_date->setDbValueDef($rsnew, UnFormatDateTime($this->despatch_date->CurrentValue, 0), NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("p_polist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? ((User_Site() == 0) ? "" : "(`status` = 1 and `partner_type` = 2 and `id` >= 1000)") : "(`id` = " .  User_Company_ID()  . " || `id` = " .  User_Company_ID()  . ") and `status` = 1 and `id` >= 1000 and `partner_type` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_03":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (116)" : "`s_grp` IN (116) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_02":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (115)" : "`s_grp` IN (115) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_09":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (126)" : "`s_grp` IN (126) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_01":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (101,102,112)" : "`s_grp` IN (101,102,112) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_08":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (125)" : "`s_grp` IN (125) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_07":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (123)" : "`s_grp` IN (123) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_10":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (124)" : "`s_grp` IN (124) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_04":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (114)" : "`s_grp` IN (114) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_06":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (121)" : "`s_grp` IN (121) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_05":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` NOT IN (101,102,112,114,115,116,121,123,124,125,126)" : "`s_grp` NOT IN (101,102,112,114,115,116,121,123,124,125,126) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_gst":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_production_plan":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_payment_terms":
					$lookupFilter = function() {
						return "`grp` = 81";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_transport_type":
					$lookupFilter = function() {
						return "`grp` = 82";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_shipping_id":
					$lookupFilter = function() {
						return "`status` < 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_production_site":
					$lookupFilter = function() {
						return "`grp` IN (0,3)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_c_operator":
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_description_03":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_02":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_09":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_01":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_08":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_07":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_10":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_04":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_06":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_05":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_gst":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							break;
						case "x_operator":
							break;
						case "x_production_plan":
							break;
						case "x_payment_terms":
							break;
						case "x_transport_type":
							break;
						case "x_partner_shipping_id":
							break;
						case "x_production_site":
							break;
						case "x_a_operator":
							break;
						case "x_app_operator":
							break;
						case "x_c_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>