<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for p_stock
 */
class p_stock extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $location;
	public $s_date;
	public $rid;
	public $b_stock;
	public $p_stock;
	public $remarks;
	public $remarks_1;
	public $operator;
	public $datetime;
	public $packing_type;
	public $shortage;
	public $stock_id;
	public $lot_no;
	public $b_stock_packets;
	public $p_stock_packets;
	public $shortage_packets;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'p_stock';
		$this->TableName = 'p_stock';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`p_stock`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('p_stock', 'p_stock', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// location
		$this->location = new DbField('p_stock', 'p_stock', 'x_location', 'location', '`location`', '`location`', 19, -1, FALSE, '`location`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->location->Nullable = FALSE; // NOT NULL field
		$this->location->Required = TRUE; // Required field
		$this->location->Sortable = TRUE; // Allow sort
		$this->location->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->location->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->location->Lookup = new Lookup('location', 'godown', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->location->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['location'] = &$this->location;

		// s_date
		$this->s_date = new DbField('p_stock', 'p_stock', 'x_s_date', 's_date', '`s_date`', CastDateFieldForLike('`s_date`', 0, "DB"), 135, 0, FALSE, '`s_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->s_date->Nullable = FALSE; // NOT NULL field
		$this->s_date->Required = TRUE; // Required field
		$this->s_date->Sortable = TRUE; // Allow sort
		$this->s_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['s_date'] = &$this->s_date;

		// rid
		$this->rid = new DbField('p_stock', 'p_stock', 'x_rid', 'rid', '`rid`', '`rid`', 19, -1, FALSE, '`EV__rid`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->rid->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->rid->Lookup = new Lookup('rid', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// b_stock
		$this->b_stock = new DbField('p_stock', 'p_stock', 'x_b_stock', 'b_stock', '`b_stock`', '`b_stock`', 4, -1, FALSE, '`b_stock`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_stock->Nullable = FALSE; // NOT NULL field
		$this->b_stock->Required = TRUE; // Required field
		$this->b_stock->Sortable = TRUE; // Allow sort
		$this->b_stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b_stock'] = &$this->b_stock;

		// p_stock
		$this->p_stock = new DbField('p_stock', 'p_stock', 'x_p_stock', 'p_stock', '`p_stock`', '`p_stock`', 4, -1, FALSE, '`p_stock`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->p_stock->Required = TRUE; // Required field
		$this->p_stock->Sortable = TRUE; // Allow sort
		$this->p_stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['p_stock'] = &$this->p_stock;

		// remarks
		$this->remarks = new DbField('p_stock', 'p_stock', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 201, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Required = TRUE; // Required field
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// remarks_1
		$this->remarks_1 = new DbField('p_stock', 'p_stock', 'x_remarks_1', 'remarks_1', '`remarks_1`', '`remarks_1`', 200, -1, FALSE, '`remarks_1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks_1->Sortable = TRUE; // Allow sort
		$this->fields['remarks_1'] = &$this->remarks_1;

		// operator
		$this->operator = new DbField('p_stock', 'p_stock', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('p_stock', 'p_stock', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// packing_type
		$this->packing_type = new DbField('p_stock', 'p_stock', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 2, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packing_type->Nullable = FALSE; // NOT NULL field
		$this->packing_type->Required = TRUE; // Required field
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// shortage
		$this->shortage = new DbField('p_stock', 'p_stock', 'x_shortage', 'shortage', '`shortage`', '`shortage`', 131, -1, FALSE, '`shortage`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->shortage->Sortable = TRUE; // Allow sort
		$this->shortage->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['shortage'] = &$this->shortage;

		// stock_id
		$this->stock_id = new DbField('p_stock', 'p_stock', 'x_stock_id', 'stock_id', '`stock_id`', '`stock_id`', 200, -1, FALSE, '`stock_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->stock_id->Sortable = TRUE; // Allow sort
		$this->fields['stock_id'] = &$this->stock_id;

		// lot_no
		$this->lot_no = new DbField('p_stock', 'p_stock', 'x_lot_no', 'lot_no', '`lot_no`', '`lot_no`', 200, -1, FALSE, '`lot_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lot_no->Sortable = TRUE; // Allow sort
		$this->fields['lot_no'] = &$this->lot_no;

		// b_stock_packets
		$this->b_stock_packets = new DbField('p_stock', 'p_stock', 'x_b_stock_packets', 'b_stock_packets', '`b_stock_packets`', '`b_stock_packets`', 4, -1, FALSE, '`b_stock_packets`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_stock_packets->Sortable = TRUE; // Allow sort
		$this->b_stock_packets->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b_stock_packets'] = &$this->b_stock_packets;

		// p_stock_packets
		$this->p_stock_packets = new DbField('p_stock', 'p_stock', 'x_p_stock_packets', 'p_stock_packets', '`p_stock_packets`', '`p_stock_packets`', 4, -1, FALSE, '`p_stock_packets`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->p_stock_packets->Sortable = TRUE; // Allow sort
		$this->p_stock_packets->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['p_stock_packets'] = &$this->p_stock_packets;

		// shortage_packets
		$this->shortage_packets = new DbField('p_stock', 'p_stock', 'x_shortage_packets', 'shortage_packets', '`shortage_packets`', '`shortage_packets`', 4, -1, FALSE, '`shortage_packets`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->shortage_packets->Sortable = TRUE; // Allow sort
		$this->shortage_packets->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['shortage_packets'] = &$this->shortage_packets;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`p_stock`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `p_stock`.`rid` LIMIT 1) AS `EV__rid` FROM `p_stock`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (User_Site() == 0) ? "`location` > 0" : "`location` > 0 and FIND_IN_SET(`location`,". User_Site() .")";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->rid->AdvancedSearch->SearchValue <> "" ||
			$this->rid->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->location->DbValue = $row['location'];
		$this->s_date->DbValue = $row['s_date'];
		$this->rid->DbValue = $row['rid'];
		$this->b_stock->DbValue = $row['b_stock'];
		$this->p_stock->DbValue = $row['p_stock'];
		$this->remarks->DbValue = $row['remarks'];
		$this->remarks_1->DbValue = $row['remarks_1'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->shortage->DbValue = $row['shortage'];
		$this->stock_id->DbValue = $row['stock_id'];
		$this->lot_no->DbValue = $row['lot_no'];
		$this->b_stock_packets->DbValue = $row['b_stock_packets'];
		$this->p_stock_packets->DbValue = $row['p_stock_packets'];
		$this->shortage_packets->DbValue = $row['shortage_packets'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "p_stocklist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "p_stockview.php")
			return $Language->phrase("View");
		elseif ($pageName == "p_stockedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "p_stockadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "p_stocklist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("p_stockview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("p_stockview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "p_stockadd.php?" . $this->getUrlParm($parm);
		else
			$url = "p_stockadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("p_stockedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("p_stockadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("p_stockdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->location->setDbValue($rs->fields('location'));
		$this->s_date->setDbValue($rs->fields('s_date'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->b_stock->setDbValue($rs->fields('b_stock'));
		$this->p_stock->setDbValue($rs->fields('p_stock'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->remarks_1->setDbValue($rs->fields('remarks_1'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->shortage->setDbValue($rs->fields('shortage'));
		$this->stock_id->setDbValue($rs->fields('stock_id'));
		$this->lot_no->setDbValue($rs->fields('lot_no'));
		$this->b_stock_packets->setDbValue($rs->fields('b_stock_packets'));
		$this->p_stock_packets->setDbValue($rs->fields('p_stock_packets'));
		$this->shortage_packets->setDbValue($rs->fields('shortage_packets'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// location
		// s_date
		// rid
		// b_stock
		// p_stock
		// remarks
		// remarks_1
		// operator
		// datetime
		// packing_type
		// shortage
		// stock_id
		// lot_no
		// b_stock_packets
		// p_stock_packets
		// shortage_packets
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// location
		$curVal = strval($this->location->CurrentValue);
		if ($curVal <> "") {
			$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
			if ($this->location->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Site() == 0) ? "id > 0" : "id > 0 and FIND_IN_SET(`id`,". User_Site() .")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->location->ViewValue = $this->location->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->location->ViewValue = $this->location->CurrentValue;
				}
			}
		} else {
			$this->location->ViewValue = NULL;
		}
		$this->location->ViewCustomAttributes = "";

		// s_date
		$this->s_date->ViewValue = $this->s_date->CurrentValue;
		$this->s_date->ViewValue = FormatDateTime($this->s_date->ViewValue, 0);
		$this->s_date->ViewCustomAttributes = "";

		// rid
		if ($this->rid->VirtualValue <> "") {
			$this->rid->ViewValue = $this->rid->VirtualValue;
		} else {
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =  1 and `product_type` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// b_stock
		$this->b_stock->ViewValue = $this->b_stock->CurrentValue;
		$this->b_stock->ViewValue = FormatNumber($this->b_stock->ViewValue, 2, -2, -2, -2);
		$this->b_stock->ViewCustomAttributes = "";

		// p_stock
		$this->p_stock->ViewValue = $this->p_stock->CurrentValue;
		$this->p_stock->ViewValue = FormatNumber($this->p_stock->ViewValue, 2, -2, -2, -2);
		$this->p_stock->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// remarks_1
		$this->remarks_1->ViewValue = $this->remarks_1->CurrentValue;
		$this->remarks_1->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// packing_type
		$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
		$this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, 0, -2, -2, -2);
		$this->packing_type->ViewCustomAttributes = "";

		// shortage
		$this->shortage->ViewValue = $this->shortage->CurrentValue;
		$this->shortage->ViewValue = FormatNumber($this->shortage->ViewValue, 2, -2, -2, -2);
		$this->shortage->ViewCustomAttributes = "";

		// stock_id
		$this->stock_id->ViewValue = $this->stock_id->CurrentValue;
		$this->stock_id->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
		$this->lot_no->ViewCustomAttributes = "";

		// b_stock_packets
		$this->b_stock_packets->ViewValue = $this->b_stock_packets->CurrentValue;
		$this->b_stock_packets->ViewValue = FormatNumber($this->b_stock_packets->ViewValue, 2, -2, -2, -2);
		$this->b_stock_packets->ViewCustomAttributes = "";

		// p_stock_packets
		$this->p_stock_packets->ViewValue = $this->p_stock_packets->CurrentValue;
		$this->p_stock_packets->ViewValue = FormatNumber($this->p_stock_packets->ViewValue, 2, -2, -2, -2);
		$this->p_stock_packets->ViewCustomAttributes = "";

		// shortage_packets
		$this->shortage_packets->ViewValue = $this->shortage_packets->CurrentValue;
		$this->shortage_packets->ViewValue = FormatNumber($this->shortage_packets->ViewValue, 2, -2, -2, -2);
		$this->shortage_packets->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// location
		$this->location->LinkCustomAttributes = "";
		$this->location->HrefValue = "";
		$this->location->TooltipValue = "";

		// s_date
		$this->s_date->LinkCustomAttributes = "";
		$this->s_date->HrefValue = "";
		$this->s_date->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		$this->rid->HrefValue = "";
		$this->rid->TooltipValue = "";

		// b_stock
		$this->b_stock->LinkCustomAttributes = "";
		$this->b_stock->HrefValue = "";
		$this->b_stock->TooltipValue = "";

		// p_stock
		$this->p_stock->LinkCustomAttributes = "";
		$this->p_stock->HrefValue = "";
		$this->p_stock->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// remarks_1
		$this->remarks_1->LinkCustomAttributes = "";
		$this->remarks_1->HrefValue = "";
		$this->remarks_1->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// shortage
		$this->shortage->LinkCustomAttributes = "";
		$this->shortage->HrefValue = "";
		$this->shortage->TooltipValue = "";

		// stock_id
		$this->stock_id->LinkCustomAttributes = "";
		$this->stock_id->HrefValue = "";
		$this->stock_id->TooltipValue = "";

		// lot_no
		$this->lot_no->LinkCustomAttributes = "";
		$this->lot_no->HrefValue = "";
		$this->lot_no->TooltipValue = "";

		// b_stock_packets
		$this->b_stock_packets->LinkCustomAttributes = "";
		$this->b_stock_packets->HrefValue = "";
		$this->b_stock_packets->TooltipValue = "";

		// p_stock_packets
		$this->p_stock_packets->LinkCustomAttributes = "";
		$this->p_stock_packets->HrefValue = "";
		$this->p_stock_packets->TooltipValue = "";

		// shortage_packets
		$this->shortage_packets->LinkCustomAttributes = "";
		$this->shortage_packets->HrefValue = "";
		$this->shortage_packets->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// location
		$this->location->EditAttrs["class"] = "form-control";
		$this->location->EditCustomAttributes = "";

		// s_date
		$this->s_date->EditAttrs["class"] = "form-control";
		$this->s_date->EditCustomAttributes = "";
		$this->s_date->EditValue = $this->s_date->CurrentValue;
		$this->s_date->EditValue = FormatDateTime($this->s_date->EditValue, 0);
		$this->s_date->ViewCustomAttributes = "";

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		if ($this->rid->VirtualValue <> "") {
			$this->rid->EditValue = $this->rid->VirtualValue;
		} else {
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =  1 and `product_type` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->EditValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->EditValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->EditValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// b_stock
		$this->b_stock->EditAttrs["class"] = "form-control";
		$this->b_stock->EditCustomAttributes = "";
		$this->b_stock->EditValue = $this->b_stock->CurrentValue;
		$this->b_stock->EditValue = FormatNumber($this->b_stock->EditValue, 2, -2, -2, -2);
		$this->b_stock->ViewCustomAttributes = "";

		// p_stock
		$this->p_stock->EditAttrs["class"] = "form-control";
		$this->p_stock->EditCustomAttributes = "";
		$this->p_stock->EditValue = $this->p_stock->CurrentValue;
		$this->p_stock->PlaceHolder = RemoveHtml($this->p_stock->caption());
		if (strval($this->p_stock->EditValue) <> "" && is_numeric($this->p_stock->EditValue))
			$this->p_stock->EditValue = FormatNumber($this->p_stock->EditValue, -2, -2, -2, -2);

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// remarks_1
		$this->remarks_1->EditAttrs["class"] = "form-control";
		$this->remarks_1->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remarks_1->CurrentValue = HtmlDecode($this->remarks_1->CurrentValue);
		$this->remarks_1->EditValue = $this->remarks_1->CurrentValue;
		$this->remarks_1->PlaceHolder = RemoveHtml($this->remarks_1->caption());

		// operator
		// datetime
		// packing_type

		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";
		$this->packing_type->EditValue = $this->packing_type->CurrentValue;
		$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

		// shortage
		$this->shortage->EditAttrs["class"] = "form-control";
		$this->shortage->EditCustomAttributes = "";
		$this->shortage->EditValue = $this->shortage->CurrentValue;
		$this->shortage->PlaceHolder = RemoveHtml($this->shortage->caption());
		if (strval($this->shortage->EditValue) <> "" && is_numeric($this->shortage->EditValue))
			$this->shortage->EditValue = FormatNumber($this->shortage->EditValue, -2, -2, -2, -2);

		// stock_id
		$this->stock_id->EditAttrs["class"] = "form-control";
		$this->stock_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->stock_id->CurrentValue = HtmlDecode($this->stock_id->CurrentValue);
		$this->stock_id->EditValue = $this->stock_id->CurrentValue;
		$this->stock_id->PlaceHolder = RemoveHtml($this->stock_id->caption());

		// lot_no
		$this->lot_no->EditAttrs["class"] = "form-control";
		$this->lot_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
		$this->lot_no->EditValue = $this->lot_no->CurrentValue;
		$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

		// b_stock_packets
		$this->b_stock_packets->EditAttrs["class"] = "form-control";
		$this->b_stock_packets->EditCustomAttributes = "";
		$this->b_stock_packets->EditValue = $this->b_stock_packets->CurrentValue;
		$this->b_stock_packets->PlaceHolder = RemoveHtml($this->b_stock_packets->caption());
		if (strval($this->b_stock_packets->EditValue) <> "" && is_numeric($this->b_stock_packets->EditValue))
			$this->b_stock_packets->EditValue = FormatNumber($this->b_stock_packets->EditValue, -2, -2, -2, -2);

		// p_stock_packets
		$this->p_stock_packets->EditAttrs["class"] = "form-control";
		$this->p_stock_packets->EditCustomAttributes = "";
		$this->p_stock_packets->EditValue = $this->p_stock_packets->CurrentValue;
		$this->p_stock_packets->PlaceHolder = RemoveHtml($this->p_stock_packets->caption());
		if (strval($this->p_stock_packets->EditValue) <> "" && is_numeric($this->p_stock_packets->EditValue))
			$this->p_stock_packets->EditValue = FormatNumber($this->p_stock_packets->EditValue, -2, -2, -2, -2);

		// shortage_packets
		$this->shortage_packets->EditAttrs["class"] = "form-control";
		$this->shortage_packets->EditCustomAttributes = "";
		$this->shortage_packets->EditValue = $this->shortage_packets->CurrentValue;
		$this->shortage_packets->PlaceHolder = RemoveHtml($this->shortage_packets->caption());
		if (strval($this->shortage_packets->EditValue) <> "" && is_numeric($this->shortage_packets->EditValue))
			$this->shortage_packets->EditValue = FormatNumber($this->shortage_packets->EditValue, -2, -2, -2, -2);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->s_date);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->b_stock);
					$doc->exportCaption($this->p_stock);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->remarks_1);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->shortage);
					$doc->exportCaption($this->stock_id);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->b_stock_packets);
					$doc->exportCaption($this->p_stock_packets);
					$doc->exportCaption($this->shortage_packets);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->s_date);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->b_stock);
					$doc->exportCaption($this->p_stock);
					$doc->exportCaption($this->remarks_1);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->shortage);
					$doc->exportCaption($this->stock_id);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->b_stock_packets);
					$doc->exportCaption($this->p_stock_packets);
					$doc->exportCaption($this->shortage_packets);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->location);
						$doc->exportField($this->s_date);
						$doc->exportField($this->rid);
						$doc->exportField($this->b_stock);
						$doc->exportField($this->p_stock);
						$doc->exportField($this->remarks);
						$doc->exportField($this->remarks_1);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->shortage);
						$doc->exportField($this->stock_id);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->b_stock_packets);
						$doc->exportField($this->p_stock_packets);
						$doc->exportField($this->shortage_packets);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->location);
						$doc->exportField($this->s_date);
						$doc->exportField($this->rid);
						$doc->exportField($this->b_stock);
						$doc->exportField($this->p_stock);
						$doc->exportField($this->remarks_1);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->shortage);
						$doc->exportField($this->stock_id);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->b_stock_packets);
						$doc->exportField($this->p_stock_packets);
						$doc->exportField($this->shortage_packets);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>