<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class p_stock_add extends p_stock
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'p_stock';

	// Page object name
	public $PageObjName = "p_stock_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (p_stock)
		if (!isset($GLOBALS["p_stock"]) || get_class($GLOBALS["p_stock"]) == PROJECT_NAMESPACE . "p_stock") {
			$GLOBALS["p_stock"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["p_stock"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'p_stock');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $p_stock;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($p_stock);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "p_stockview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("p_stocklist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->location->setVisibility();
		$this->s_date->setVisibility();
		$this->rid->setVisibility();
		$this->b_stock->setVisibility();
		$this->p_stock->Visible = FALSE;
		$this->remarks->Visible = FALSE;
		$this->remarks_1->Visible = FALSE;
		$this->operator->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->packing_type->setVisibility();
		$this->shortage->setVisibility();
		$this->stock_id->setVisibility();
		$this->lot_no->setVisibility();
		$this->b_stock_packets->setVisibility();
		$this->p_stock_packets->setVisibility();
		$this->shortage_packets->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("p_stocklist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "p_stocklist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "p_stockview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->location->CurrentValue = NULL;
		$this->location->OldValue = $this->location->CurrentValue;
		$this->s_date->CurrentValue = NULL;
		$this->s_date->OldValue = $this->s_date->CurrentValue;
		$this->rid->CurrentValue = NULL;
		$this->rid->OldValue = $this->rid->CurrentValue;
		$this->b_stock->CurrentValue = NULL;
		$this->b_stock->OldValue = $this->b_stock->CurrentValue;
		$this->p_stock->CurrentValue = NULL;
		$this->p_stock->OldValue = $this->p_stock->CurrentValue;
		$this->remarks->CurrentValue = NULL;
		$this->remarks->OldValue = $this->remarks->CurrentValue;
		$this->remarks_1->CurrentValue = NULL;
		$this->remarks_1->OldValue = $this->remarks_1->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->packing_type->CurrentValue = NULL;
		$this->packing_type->OldValue = $this->packing_type->CurrentValue;
		$this->shortage->CurrentValue = NULL;
		$this->shortage->OldValue = $this->shortage->CurrentValue;
		$this->stock_id->CurrentValue = NULL;
		$this->stock_id->OldValue = $this->stock_id->CurrentValue;
		$this->lot_no->CurrentValue = NULL;
		$this->lot_no->OldValue = $this->lot_no->CurrentValue;
		$this->b_stock_packets->CurrentValue = NULL;
		$this->b_stock_packets->OldValue = $this->b_stock_packets->CurrentValue;
		$this->p_stock_packets->CurrentValue = NULL;
		$this->p_stock_packets->OldValue = $this->p_stock_packets->CurrentValue;
		$this->shortage_packets->CurrentValue = NULL;
		$this->shortage_packets->OldValue = $this->shortage_packets->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'location' first before field var 'x_location'
		$val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
		if (!$this->location->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->location->Visible = FALSE; // Disable update for API request
			else
				$this->location->setFormValue($val);
		}

		// Check field name 's_date' first before field var 'x_s_date'
		$val = $CurrentForm->hasValue("s_date") ? $CurrentForm->getValue("s_date") : $CurrentForm->getValue("x_s_date");
		if (!$this->s_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_date->Visible = FALSE; // Disable update for API request
			else
				$this->s_date->setFormValue($val);
			$this->s_date->CurrentValue = UnFormatDateTime($this->s_date->CurrentValue, 0);
		}

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid->Visible = FALSE; // Disable update for API request
			else
				$this->rid->setFormValue($val);
		}

		// Check field name 'b_stock' first before field var 'x_b_stock'
		$val = $CurrentForm->hasValue("b_stock") ? $CurrentForm->getValue("b_stock") : $CurrentForm->getValue("x_b_stock");
		if (!$this->b_stock->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_stock->Visible = FALSE; // Disable update for API request
			else
				$this->b_stock->setFormValue($val);
		}

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}

		// Check field name 'shortage' first before field var 'x_shortage'
		$val = $CurrentForm->hasValue("shortage") ? $CurrentForm->getValue("shortage") : $CurrentForm->getValue("x_shortage");
		if (!$this->shortage->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shortage->Visible = FALSE; // Disable update for API request
			else
				$this->shortage->setFormValue($val);
		}

		// Check field name 'stock_id' first before field var 'x_stock_id'
		$val = $CurrentForm->hasValue("stock_id") ? $CurrentForm->getValue("stock_id") : $CurrentForm->getValue("x_stock_id");
		if (!$this->stock_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->stock_id->Visible = FALSE; // Disable update for API request
			else
				$this->stock_id->setFormValue($val);
		}

		// Check field name 'lot_no' first before field var 'x_lot_no'
		$val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
		if (!$this->lot_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lot_no->Visible = FALSE; // Disable update for API request
			else
				$this->lot_no->setFormValue($val);
		}

		// Check field name 'b_stock_packets' first before field var 'x_b_stock_packets'
		$val = $CurrentForm->hasValue("b_stock_packets") ? $CurrentForm->getValue("b_stock_packets") : $CurrentForm->getValue("x_b_stock_packets");
		if (!$this->b_stock_packets->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_stock_packets->Visible = FALSE; // Disable update for API request
			else
				$this->b_stock_packets->setFormValue($val);
		}

		// Check field name 'p_stock_packets' first before field var 'x_p_stock_packets'
		$val = $CurrentForm->hasValue("p_stock_packets") ? $CurrentForm->getValue("p_stock_packets") : $CurrentForm->getValue("x_p_stock_packets");
		if (!$this->p_stock_packets->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->p_stock_packets->Visible = FALSE; // Disable update for API request
			else
				$this->p_stock_packets->setFormValue($val);
		}

		// Check field name 'shortage_packets' first before field var 'x_shortage_packets'
		$val = $CurrentForm->hasValue("shortage_packets") ? $CurrentForm->getValue("shortage_packets") : $CurrentForm->getValue("x_shortage_packets");
		if (!$this->shortage_packets->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shortage_packets->Visible = FALSE; // Disable update for API request
			else
				$this->shortage_packets->setFormValue($val);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->location->CurrentValue = $this->location->FormValue;
		$this->s_date->CurrentValue = $this->s_date->FormValue;
		$this->s_date->CurrentValue = UnFormatDateTime($this->s_date->CurrentValue, 0);
		$this->rid->CurrentValue = $this->rid->FormValue;
		$this->b_stock->CurrentValue = $this->b_stock->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->shortage->CurrentValue = $this->shortage->FormValue;
		$this->stock_id->CurrentValue = $this->stock_id->FormValue;
		$this->lot_no->CurrentValue = $this->lot_no->FormValue;
		$this->b_stock_packets->CurrentValue = $this->b_stock_packets->FormValue;
		$this->p_stock_packets->CurrentValue = $this->p_stock_packets->FormValue;
		$this->shortage_packets->CurrentValue = $this->shortage_packets->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->location->setDbValue($row['location']);
		$this->s_date->setDbValue($row['s_date']);
		$this->rid->setDbValue($row['rid']);
		if (array_key_exists('EV__rid', $rs->fields)) {
			$this->rid->VirtualValue = $rs->fields('EV__rid'); // Set up virtual field value
		} else {
			$this->rid->VirtualValue = ""; // Clear value
		}
		$this->b_stock->setDbValue($row['b_stock']);
		$this->p_stock->setDbValue($row['p_stock']);
		$this->remarks->setDbValue($row['remarks']);
		$this->remarks_1->setDbValue($row['remarks_1']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->shortage->setDbValue($row['shortage']);
		$this->stock_id->setDbValue($row['stock_id']);
		$this->lot_no->setDbValue($row['lot_no']);
		$this->b_stock_packets->setDbValue($row['b_stock_packets']);
		$this->p_stock_packets->setDbValue($row['p_stock_packets']);
		$this->shortage_packets->setDbValue($row['shortage_packets']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['location'] = $this->location->CurrentValue;
		$row['s_date'] = $this->s_date->CurrentValue;
		$row['rid'] = $this->rid->CurrentValue;
		$row['b_stock'] = $this->b_stock->CurrentValue;
		$row['p_stock'] = $this->p_stock->CurrentValue;
		$row['remarks'] = $this->remarks->CurrentValue;
		$row['remarks_1'] = $this->remarks_1->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['packing_type'] = $this->packing_type->CurrentValue;
		$row['shortage'] = $this->shortage->CurrentValue;
		$row['stock_id'] = $this->stock_id->CurrentValue;
		$row['lot_no'] = $this->lot_no->CurrentValue;
		$row['b_stock_packets'] = $this->b_stock_packets->CurrentValue;
		$row['p_stock_packets'] = $this->p_stock_packets->CurrentValue;
		$row['shortage_packets'] = $this->shortage_packets->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->b_stock->FormValue == $this->b_stock->CurrentValue && is_numeric(ConvertToFloatString($this->b_stock->CurrentValue)))
			$this->b_stock->CurrentValue = ConvertToFloatString($this->b_stock->CurrentValue);

		// Convert decimal values if posted back
		if ($this->shortage->FormValue == $this->shortage->CurrentValue && is_numeric(ConvertToFloatString($this->shortage->CurrentValue)))
			$this->shortage->CurrentValue = ConvertToFloatString($this->shortage->CurrentValue);

		// Convert decimal values if posted back
		if ($this->b_stock_packets->FormValue == $this->b_stock_packets->CurrentValue && is_numeric(ConvertToFloatString($this->b_stock_packets->CurrentValue)))
			$this->b_stock_packets->CurrentValue = ConvertToFloatString($this->b_stock_packets->CurrentValue);

		// Convert decimal values if posted back
		if ($this->p_stock_packets->FormValue == $this->p_stock_packets->CurrentValue && is_numeric(ConvertToFloatString($this->p_stock_packets->CurrentValue)))
			$this->p_stock_packets->CurrentValue = ConvertToFloatString($this->p_stock_packets->CurrentValue);

		// Convert decimal values if posted back
		if ($this->shortage_packets->FormValue == $this->shortage_packets->CurrentValue && is_numeric(ConvertToFloatString($this->shortage_packets->CurrentValue)))
			$this->shortage_packets->CurrentValue = ConvertToFloatString($this->shortage_packets->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// location
		// s_date
		// rid
		// b_stock
		// p_stock
		// remarks
		// remarks_1
		// operator
		// datetime
		// packing_type
		// shortage
		// stock_id
		// lot_no
		// b_stock_packets
		// p_stock_packets
		// shortage_packets

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// location
			$curVal = strval($this->location->CurrentValue);
			if ($curVal <> "") {
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
				if ($this->location->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Site() == 0) ? "id > 0" : "id > 0 and FIND_IN_SET(`id`,". User_Site() .")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->location->ViewValue = $this->location->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->location->ViewValue = $this->location->CurrentValue;
					}
				}
			} else {
				$this->location->ViewValue = NULL;
			}
			$this->location->ViewCustomAttributes = "";

			// s_date
			$this->s_date->ViewValue = $this->s_date->CurrentValue;
			$this->s_date->ViewValue = FormatDateTime($this->s_date->ViewValue, 0);
			$this->s_date->ViewCustomAttributes = "";

			// rid
			if ($this->rid->VirtualValue <> "") {
				$this->rid->ViewValue = $this->rid->VirtualValue;
			} else {
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =  1 and `product_type` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// b_stock
			$this->b_stock->ViewValue = $this->b_stock->CurrentValue;
			$this->b_stock->ViewValue = FormatNumber($this->b_stock->ViewValue, 2, -2, -2, -2);
			$this->b_stock->ViewCustomAttributes = "";

			// p_stock
			$this->p_stock->ViewValue = $this->p_stock->CurrentValue;
			$this->p_stock->ViewValue = FormatNumber($this->p_stock->ViewValue, 2, -2, -2, -2);
			$this->p_stock->ViewCustomAttributes = "";

			// remarks_1
			$this->remarks_1->ViewValue = $this->remarks_1->CurrentValue;
			$this->remarks_1->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// packing_type
			$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
			$this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, 0, -2, -2, -2);
			$this->packing_type->ViewCustomAttributes = "";

			// shortage
			$this->shortage->ViewValue = $this->shortage->CurrentValue;
			$this->shortage->ViewValue = FormatNumber($this->shortage->ViewValue, 2, -2, -2, -2);
			$this->shortage->ViewCustomAttributes = "";

			// stock_id
			$this->stock_id->ViewValue = $this->stock_id->CurrentValue;
			$this->stock_id->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// b_stock_packets
			$this->b_stock_packets->ViewValue = $this->b_stock_packets->CurrentValue;
			$this->b_stock_packets->ViewValue = FormatNumber($this->b_stock_packets->ViewValue, 2, -2, -2, -2);
			$this->b_stock_packets->ViewCustomAttributes = "";

			// p_stock_packets
			$this->p_stock_packets->ViewValue = $this->p_stock_packets->CurrentValue;
			$this->p_stock_packets->ViewValue = FormatNumber($this->p_stock_packets->ViewValue, 2, -2, -2, -2);
			$this->p_stock_packets->ViewCustomAttributes = "";

			// shortage_packets
			$this->shortage_packets->ViewValue = $this->shortage_packets->CurrentValue;
			$this->shortage_packets->ViewValue = FormatNumber($this->shortage_packets->ViewValue, 2, -2, -2, -2);
			$this->shortage_packets->ViewCustomAttributes = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";
			$this->location->TooltipValue = "";

			// s_date
			$this->s_date->LinkCustomAttributes = "";
			$this->s_date->HrefValue = "";
			$this->s_date->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";
			$this->rid->TooltipValue = "";

			// b_stock
			$this->b_stock->LinkCustomAttributes = "";
			$this->b_stock->HrefValue = "";
			$this->b_stock->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// shortage
			$this->shortage->LinkCustomAttributes = "";
			$this->shortage->HrefValue = "";
			$this->shortage->TooltipValue = "";

			// stock_id
			$this->stock_id->LinkCustomAttributes = "";
			$this->stock_id->HrefValue = "";
			$this->stock_id->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// b_stock_packets
			$this->b_stock_packets->LinkCustomAttributes = "";
			$this->b_stock_packets->HrefValue = "";
			$this->b_stock_packets->TooltipValue = "";

			// p_stock_packets
			$this->p_stock_packets->LinkCustomAttributes = "";
			$this->p_stock_packets->HrefValue = "";
			$this->p_stock_packets->TooltipValue = "";

			// shortage_packets
			$this->shortage_packets->LinkCustomAttributes = "";
			$this->shortage_packets->HrefValue = "";
			$this->shortage_packets->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// location
			$this->location->EditAttrs["class"] = "form-control";
			$this->location->EditCustomAttributes = "";
			$curVal = trim(strval($this->location->CurrentValue));
			if ($curVal <> "")
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
			else
				$this->location->ViewValue = $this->location->Lookup !== NULL && is_array($this->location->Lookup->Options) ? $curVal : NULL;
			if ($this->location->ViewValue !== NULL) { // Load from cache
				$this->location->EditValue = array_values($this->location->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->location->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (User_Site() == 0) ? "id > 0" : "id > 0 and FIND_IN_SET(`id`,". User_Site() .")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->location->EditValue = $arwrk;
			}

			// s_date
			$this->s_date->EditAttrs["class"] = "form-control";
			$this->s_date->EditCustomAttributes = "";
			$this->s_date->EditValue = HtmlEncode(FormatDateTime($this->s_date->CurrentValue, 8));
			$this->s_date->PlaceHolder = RemoveHtml($this->s_date->caption());

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			$curVal = trim(strval($this->rid->CurrentValue));
			if ($curVal <> "")
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			else
				$this->rid->ViewValue = $this->rid->Lookup !== NULL && is_array($this->rid->Lookup->Options) ? $curVal : NULL;
			if ($this->rid->ViewValue !== NULL) { // Load from cache
				$this->rid->EditValue = array_values($this->rid->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->rid->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` =  1 and `product_type` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->rid->EditValue = $arwrk;
			}

			// b_stock
			$this->b_stock->EditAttrs["class"] = "form-control";
			$this->b_stock->EditCustomAttributes = "";
			$this->b_stock->EditValue = HtmlEncode($this->b_stock->CurrentValue);
			$this->b_stock->PlaceHolder = RemoveHtml($this->b_stock->caption());
			if (strval($this->b_stock->EditValue) <> "" && is_numeric($this->b_stock->EditValue))
				$this->b_stock->EditValue = FormatNumber($this->b_stock->EditValue, -2, -2, -2, -2);

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$this->packing_type->EditValue = HtmlEncode($this->packing_type->CurrentValue);
			$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

			// shortage
			$this->shortage->EditAttrs["class"] = "form-control";
			$this->shortage->EditCustomAttributes = "";
			$this->shortage->EditValue = HtmlEncode($this->shortage->CurrentValue);
			$this->shortage->PlaceHolder = RemoveHtml($this->shortage->caption());
			if (strval($this->shortage->EditValue) <> "" && is_numeric($this->shortage->EditValue))
				$this->shortage->EditValue = FormatNumber($this->shortage->EditValue, -2, -2, -2, -2);

			// stock_id
			$this->stock_id->EditAttrs["class"] = "form-control";
			$this->stock_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->stock_id->CurrentValue = HtmlDecode($this->stock_id->CurrentValue);
			$this->stock_id->EditValue = HtmlEncode($this->stock_id->CurrentValue);
			$this->stock_id->PlaceHolder = RemoveHtml($this->stock_id->caption());

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
			$this->lot_no->EditValue = HtmlEncode($this->lot_no->CurrentValue);
			$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

			// b_stock_packets
			$this->b_stock_packets->EditAttrs["class"] = "form-control";
			$this->b_stock_packets->EditCustomAttributes = "";
			$this->b_stock_packets->EditValue = HtmlEncode($this->b_stock_packets->CurrentValue);
			$this->b_stock_packets->PlaceHolder = RemoveHtml($this->b_stock_packets->caption());
			if (strval($this->b_stock_packets->EditValue) <> "" && is_numeric($this->b_stock_packets->EditValue))
				$this->b_stock_packets->EditValue = FormatNumber($this->b_stock_packets->EditValue, -2, -2, -2, -2);

			// p_stock_packets
			$this->p_stock_packets->EditAttrs["class"] = "form-control";
			$this->p_stock_packets->EditCustomAttributes = "";
			$this->p_stock_packets->EditValue = HtmlEncode($this->p_stock_packets->CurrentValue);
			$this->p_stock_packets->PlaceHolder = RemoveHtml($this->p_stock_packets->caption());
			if (strval($this->p_stock_packets->EditValue) <> "" && is_numeric($this->p_stock_packets->EditValue))
				$this->p_stock_packets->EditValue = FormatNumber($this->p_stock_packets->EditValue, -2, -2, -2, -2);

			// shortage_packets
			$this->shortage_packets->EditAttrs["class"] = "form-control";
			$this->shortage_packets->EditCustomAttributes = "";
			$this->shortage_packets->EditValue = HtmlEncode($this->shortage_packets->CurrentValue);
			$this->shortage_packets->PlaceHolder = RemoveHtml($this->shortage_packets->caption());
			if (strval($this->shortage_packets->EditValue) <> "" && is_numeric($this->shortage_packets->EditValue))
				$this->shortage_packets->EditValue = FormatNumber($this->shortage_packets->EditValue, -2, -2, -2, -2);

			// Add refer script
			// location

			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";

			// s_date
			$this->s_date->LinkCustomAttributes = "";
			$this->s_date->HrefValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";

			// b_stock
			$this->b_stock->LinkCustomAttributes = "";
			$this->b_stock->HrefValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";

			// shortage
			$this->shortage->LinkCustomAttributes = "";
			$this->shortage->HrefValue = "";

			// stock_id
			$this->stock_id->LinkCustomAttributes = "";
			$this->stock_id->HrefValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";

			// b_stock_packets
			$this->b_stock_packets->LinkCustomAttributes = "";
			$this->b_stock_packets->HrefValue = "";

			// p_stock_packets
			$this->p_stock_packets->LinkCustomAttributes = "";
			$this->p_stock_packets->HrefValue = "";

			// shortage_packets
			$this->shortage_packets->LinkCustomAttributes = "";
			$this->shortage_packets->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->location->Required) {
			if (!$this->location->IsDetailKey && $this->location->FormValue != NULL && $this->location->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
			}
		}
		if ($this->s_date->Required) {
			if (!$this->s_date->IsDetailKey && $this->s_date->FormValue != NULL && $this->s_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_date->caption(), $this->s_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->s_date->FormValue)) {
			AddMessage($FormError, $this->s_date->errorMessage());
		}
		if ($this->rid->Required) {
			if (!$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if ($this->b_stock->Required) {
			if (!$this->b_stock->IsDetailKey && $this->b_stock->FormValue != NULL && $this->b_stock->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_stock->caption(), $this->b_stock->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->b_stock->FormValue)) {
			AddMessage($FormError, $this->b_stock->errorMessage());
		}
		if ($this->p_stock->Required) {
			if (!$this->p_stock->IsDetailKey && $this->p_stock->FormValue != NULL && $this->p_stock->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->p_stock->caption(), $this->p_stock->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->remarks_1->Required) {
			if (!$this->remarks_1->IsDetailKey && $this->remarks_1->FormValue != NULL && $this->remarks_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks_1->caption(), $this->remarks_1->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->packing_type->FormValue)) {
			AddMessage($FormError, $this->packing_type->errorMessage());
		}
		if ($this->shortage->Required) {
			if (!$this->shortage->IsDetailKey && $this->shortage->FormValue != NULL && $this->shortage->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shortage->caption(), $this->shortage->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->shortage->FormValue)) {
			AddMessage($FormError, $this->shortage->errorMessage());
		}
		if ($this->stock_id->Required) {
			if (!$this->stock_id->IsDetailKey && $this->stock_id->FormValue != NULL && $this->stock_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->stock_id->caption(), $this->stock_id->RequiredErrorMessage));
			}
		}
		if ($this->lot_no->Required) {
			if (!$this->lot_no->IsDetailKey && $this->lot_no->FormValue != NULL && $this->lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
			}
		}
		if ($this->b_stock_packets->Required) {
			if (!$this->b_stock_packets->IsDetailKey && $this->b_stock_packets->FormValue != NULL && $this->b_stock_packets->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_stock_packets->caption(), $this->b_stock_packets->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->b_stock_packets->FormValue)) {
			AddMessage($FormError, $this->b_stock_packets->errorMessage());
		}
		if ($this->p_stock_packets->Required) {
			if (!$this->p_stock_packets->IsDetailKey && $this->p_stock_packets->FormValue != NULL && $this->p_stock_packets->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->p_stock_packets->caption(), $this->p_stock_packets->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->p_stock_packets->FormValue)) {
			AddMessage($FormError, $this->p_stock_packets->errorMessage());
		}
		if ($this->shortage_packets->Required) {
			if (!$this->shortage_packets->IsDetailKey && $this->shortage_packets->FormValue != NULL && $this->shortage_packets->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shortage_packets->caption(), $this->shortage_packets->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->shortage_packets->FormValue)) {
			AddMessage($FormError, $this->shortage_packets->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// location
		$this->location->setDbValueDef($rsnew, $this->location->CurrentValue, 0, FALSE);

		// s_date
		$this->s_date->setDbValueDef($rsnew, UnFormatDateTime($this->s_date->CurrentValue, 0), CurrentDate(), FALSE);

		// rid
		$this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, 0, FALSE);

		// b_stock
		$this->b_stock->setDbValueDef($rsnew, $this->b_stock->CurrentValue, 0, FALSE);

		// packing_type
		$this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, 0, FALSE);

		// shortage
		$this->shortage->setDbValueDef($rsnew, $this->shortage->CurrentValue, NULL, FALSE);

		// stock_id
		$this->stock_id->setDbValueDef($rsnew, $this->stock_id->CurrentValue, NULL, FALSE);

		// lot_no
		$this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, NULL, FALSE);

		// b_stock_packets
		$this->b_stock_packets->setDbValueDef($rsnew, $this->b_stock_packets->CurrentValue, NULL, FALSE);

		// p_stock_packets
		$this->p_stock_packets->setDbValueDef($rsnew, $this->p_stock_packets->CurrentValue, NULL, FALSE);

		// shortage_packets
		$this->shortage_packets->setDbValueDef($rsnew, $this->shortage_packets->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("p_stocklist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_location":
					$lookupFilter = function() {
						return (User_Site() == 0) ? "id > 0" : "id > 0 and FIND_IN_SET(`id`,". User_Site() .")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`status` =  1 and `product_type` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_location":
							break;
						case "x_rid":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>