<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for packing_list_no
 */
class packing_list_no extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $buyer_po;
	public $roll_no;
	public $qty;
	public $pl_no;
	public $_barcode;
	public $buyer_ref;
	public $design_id;
	public $size_buyer;
	public $buyers_id;
	public $po;
	public $despatch_week;
	public $sqm;
	public $current_works;
	public $id;
	public $operator;
	public $datetime;
	public $po_price;
	public $po_discount;
	public $po_currency;
	public $buyer_uid;
	public $sqm_a;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'packing_list_no';
		$this->TableName = 'packing_list_no';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`packing_list_no`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// buyer_po
		$this->buyer_po = new DbField('packing_list_no', 'packing_list_no', 'x_buyer_po', 'buyer_po', '`buyer_po`', '`buyer_po`', 200, -1, FALSE, '`buyer_po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_po->Sortable = TRUE; // Allow sort
		$this->fields['buyer_po'] = &$this->buyer_po;

		// roll_no
		$this->roll_no = new DbField('packing_list_no', 'packing_list_no', 'x_roll_no', 'roll_no', '`roll_no`', '`roll_no`', 18, -1, FALSE, '`roll_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->roll_no->Sortable = TRUE; // Allow sort
		$this->roll_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['roll_no'] = &$this->roll_no;

		// qty
		$this->qty = new DbField('packing_list_no', 'packing_list_no', 'x_qty', 'qty', '`qty`', '`qty`', 18, -1, FALSE, '`qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty->Sortable = TRUE; // Allow sort
		$this->qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['qty'] = &$this->qty;

		// pl_no
		$this->pl_no = new DbField('packing_list_no', 'packing_list_no', 'x_pl_no', 'pl_no', '`pl_no`', '`pl_no`', 131, -1, FALSE, '`pl_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pl_no->Nullable = FALSE; // NOT NULL field
		$this->pl_no->Sortable = TRUE; // Allow sort
		$this->pl_no->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['pl_no'] = &$this->pl_no;

		// barcode
		$this->_barcode = new DbField('packing_list_no', 'packing_list_no', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 19, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_barcode->Nullable = FALSE; // NOT NULL field
		$this->_barcode->Required = TRUE; // Required field
		$this->_barcode->Sortable = TRUE; // Allow sort
		$this->_barcode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['barcode'] = &$this->_barcode;

		// buyer_ref
		$this->buyer_ref = new DbField('packing_list_no', 'packing_list_no', 'x_buyer_ref', 'buyer_ref', '`buyer_ref`', '`buyer_ref`', 2, -1, FALSE, '`buyer_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->buyer_ref->Sortable = TRUE; // Allow sort
		$this->fields['buyer_ref'] = &$this->buyer_ref;

		// design_id
		$this->design_id = new DbField('packing_list_no', 'packing_list_no', 'x_design_id', 'design_id', '`design_id`', '`design_id`', 200, -1, FALSE, '`design_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->design_id->Sortable = TRUE; // Allow sort
		$this->design_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->design_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->design_id->Lookup = new Lookup('design_id', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->design_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['design_id'] = &$this->design_id;

		// size_buyer
		$this->size_buyer = new DbField('packing_list_no', 'packing_list_no', 'x_size_buyer', 'size_buyer', '`size_buyer`', '`size_buyer`', 200, -1, FALSE, '`size_buyer`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_buyer->Sortable = TRUE; // Allow sort
		$this->fields['size_buyer'] = &$this->size_buyer;

		// buyers_id
		$this->buyers_id = new DbField('packing_list_no', 'packing_list_no', 'x_buyers_id', 'buyers_id', '`buyers_id`', '`buyers_id`', 19, -1, FALSE, '`buyers_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->buyers_id->Sortable = TRUE; // Allow sort
		$this->buyers_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyers_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyers_id->Lookup = new Lookup('buyers_id', 'buyer', FALSE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyers_id'] = &$this->buyers_id;

		// po
		$this->po = new DbField('packing_list_no', 'packing_list_no', 'x_po', 'po', '`po`', '`po`', 19, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// despatch_week
		$this->despatch_week = new DbField('packing_list_no', 'packing_list_no', 'x_despatch_week', 'despatch_week', '`despatch_week`', '`despatch_week`', 18, -1, FALSE, '`despatch_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->despatch_week->Sortable = TRUE; // Allow sort
		$this->despatch_week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->despatch_week->Lookup = new Lookup('despatch_week', 'not_week', FALSE, 'id', ["wid","wed","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->despatch_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['despatch_week'] = &$this->despatch_week;

		// sqm
		$this->sqm = new DbField('packing_list_no', 'packing_list_no', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 4, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// current_works
		$this->current_works = new DbField('packing_list_no', 'packing_list_no', 'x_current_works', 'current_works', '`current_works`', '`current_works`', 18, -1, FALSE, '`current_works`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->current_works->Nullable = FALSE; // NOT NULL field
		$this->current_works->Sortable = TRUE; // Allow sort
		$this->current_works->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->current_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->current_works->Lookup = new Lookup('current_works', 'godown', TRUE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->current_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['current_works'] = &$this->current_works;

		// id
		$this->id = new DbField('packing_list_no', 'packing_list_no', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// operator
		$this->operator = new DbField('packing_list_no', 'packing_list_no', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('packing_list_no', 'packing_list_no', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// po_price
		$this->po_price = new DbField('packing_list_no', 'packing_list_no', 'x_po_price', 'po_price', '`po_price`', '`po_price`', 200, -1, FALSE, '`po_price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_price->Sortable = FALSE; // Allow sort
		$this->fields['po_price'] = &$this->po_price;

		// po_discount
		$this->po_discount = new DbField('packing_list_no', 'packing_list_no', 'x_po_discount', 'po_discount', '`po_discount`', '`po_discount`', 131, -1, FALSE, '`po_discount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_discount->Nullable = FALSE; // NOT NULL field
		$this->po_discount->Sortable = FALSE; // Allow sort
		$this->po_discount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['po_discount'] = &$this->po_discount;

		// po_currency
		$this->po_currency = new DbField('packing_list_no', 'packing_list_no', 'x_po_currency', 'po_currency', '`po_currency`', '`po_currency`', 18, -1, FALSE, '`po_currency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_currency->Sortable = FALSE; // Allow sort
		$this->po_currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_currency'] = &$this->po_currency;

		// buyer_uid
		$this->buyer_uid = new DbField('packing_list_no', 'packing_list_no', 'x_buyer_uid', 'buyer_uid', '`buyer_uid`', '`buyer_uid`', 200, -1, FALSE, '`buyer_uid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_uid->Sortable = FALSE; // Allow sort
		$this->fields['buyer_uid'] = &$this->buyer_uid;

		// sqm_a
		$this->sqm_a = new DbField('packing_list_no', 'packing_list_no', 'x_sqm_a', 'sqm_a', '`sqm_a`', '`sqm_a`', 5, -1, FALSE, '`sqm_a`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm_a->Sortable = TRUE; // Allow sort
		$this->sqm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm_a'] = &$this->sqm_a;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`packing_list_no`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`barcode` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->buyer_po->DbValue = $row['buyer_po'];
		$this->roll_no->DbValue = $row['roll_no'];
		$this->qty->DbValue = $row['qty'];
		$this->pl_no->DbValue = $row['pl_no'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->buyer_ref->DbValue = $row['buyer_ref'];
		$this->design_id->DbValue = $row['design_id'];
		$this->size_buyer->DbValue = $row['size_buyer'];
		$this->buyers_id->DbValue = $row['buyers_id'];
		$this->po->DbValue = $row['po'];
		$this->despatch_week->DbValue = $row['despatch_week'];
		$this->sqm->DbValue = $row['sqm'];
		$this->current_works->DbValue = $row['current_works'];
		$this->id->DbValue = $row['id'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->po_price->DbValue = $row['po_price'];
		$this->po_discount->DbValue = $row['po_discount'];
		$this->po_currency->DbValue = $row['po_currency'];
		$this->buyer_uid->DbValue = $row['buyer_uid'];
		$this->sqm_a->DbValue = $row['sqm_a'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "packing_list_nolist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "packing_list_noview.php")
			return $Language->phrase("View");
		elseif ($pageName == "packing_list_noedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "packing_list_noadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "packing_list_nolist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("packing_list_noview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("packing_list_noview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "packing_list_noadd.php?" . $this->getUrlParm($parm);
		else
			$url = "packing_list_noadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("packing_list_noedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("packing_list_noadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("packing_list_nodelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->buyer_po->setDbValue($rs->fields('buyer_po'));
		$this->roll_no->setDbValue($rs->fields('roll_no'));
		$this->qty->setDbValue($rs->fields('qty'));
		$this->pl_no->setDbValue($rs->fields('pl_no'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->buyer_ref->setDbValue($rs->fields('buyer_ref'));
		$this->design_id->setDbValue($rs->fields('design_id'));
		$this->size_buyer->setDbValue($rs->fields('size_buyer'));
		$this->buyers_id->setDbValue($rs->fields('buyers_id'));
		$this->po->setDbValue($rs->fields('po'));
		$this->despatch_week->setDbValue($rs->fields('despatch_week'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->current_works->setDbValue($rs->fields('current_works'));
		$this->id->setDbValue($rs->fields('id'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->po_price->setDbValue($rs->fields('po_price'));
		$this->po_discount->setDbValue($rs->fields('po_discount'));
		$this->po_currency->setDbValue($rs->fields('po_currency'));
		$this->buyer_uid->setDbValue($rs->fields('buyer_uid'));
		$this->sqm_a->setDbValue($rs->fields('sqm_a'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// buyer_po
		// roll_no

		$this->roll_no->CellCssStyle = "width: 10px;";

		// qty
		$this->qty->CellCssStyle = "width: 10px;";

		// pl_no
		$this->pl_no->CellCssStyle = "width: 15px;";

		// barcode
		$this->_barcode->CellCssStyle = "width: 25px;";

		// buyer_ref
		// design_id
		// size_buyer
		// buyers_id
		// po
		// despatch_week
		// sqm
		// current_works

		$this->current_works->CellCssStyle = "white-space: nowrap;";

		// id
		// operator
		// datetime
		// po_price

		$this->po_price->CellCssStyle = "white-space: nowrap;";

		// po_discount
		$this->po_discount->CellCssStyle = "white-space: nowrap;";

		// po_currency
		$this->po_currency->CellCssStyle = "white-space: nowrap;";

		// buyer_uid
		$this->buyer_uid->CellCssStyle = "white-space: nowrap;";

		// sqm_a
		// buyer_po

		$this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;
		$this->buyer_po->ViewCustomAttributes = "";

		// roll_no
		$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
		$this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, 0, -2, -2, -2);
		$this->roll_no->ViewCustomAttributes = "";

		// qty
		$this->qty->ViewValue = $this->qty->CurrentValue;
		$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
		$this->qty->ViewCustomAttributes = "";

		// pl_no
		$this->pl_no->ViewValue = $this->pl_no->CurrentValue;
		$this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, 2, -2, -2, -2);
		$this->pl_no->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
		$this->_barcode->ViewCustomAttributes = "";

		// buyer_ref
		$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
		$this->buyer_ref->ViewCustomAttributes = "";

		// design_id
		$curVal = strval($this->design_id->CurrentValue);
		if ($curVal <> "") {
			$this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
			if ($this->design_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->design_id->ViewValue = $this->design_id->CurrentValue;
				}
			}
		} else {
			$this->design_id->ViewValue = NULL;
		}
		$this->design_id->ViewCustomAttributes = "";

		// size_buyer
		$this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;
		$this->size_buyer->ViewCustomAttributes = "";

		// buyers_id
		$curVal = strval($this->buyers_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
			if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` > 1000 and `grp` = 3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
				}
			}
		} else {
			$this->buyers_id->ViewValue = NULL;
		}
		$this->buyers_id->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// despatch_week
		$curVal = strval($this->despatch_week->CurrentValue);
		if ($curVal <> "") {
			$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
				}
			}
		} else {
			$this->despatch_week->ViewValue = NULL;
		}
		$this->despatch_week->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// current_works
		$curVal = strval($this->current_works->CurrentValue);
		if ($curVal <> "") {
			$this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
			if ($this->current_works->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->current_works->ViewValue = $this->current_works->CurrentValue;
				}
			}
		} else {
			$this->current_works->ViewValue = NULL;
		}
		$this->current_works->ViewCustomAttributes = "";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// po_price
		$this->po_price->ViewValue = $this->po_price->CurrentValue;
		$this->po_price->ViewCustomAttributes = "";

		// po_discount
		$this->po_discount->ViewValue = $this->po_discount->CurrentValue;
		$this->po_discount->ViewValue = FormatNumber($this->po_discount->ViewValue, 2, -2, -2, -2);
		$this->po_discount->ViewCustomAttributes = "";

		// po_currency
		$this->po_currency->ViewValue = $this->po_currency->CurrentValue;
		$this->po_currency->ViewValue = FormatNumber($this->po_currency->ViewValue, 0, -2, -2, -2);
		$this->po_currency->ViewCustomAttributes = "";

		// buyer_uid
		$this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;
		$this->buyer_uid->ViewCustomAttributes = "";

		// sqm_a
		$this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
		$this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, 2, -2, -2, -2);
		$this->sqm_a->ViewCustomAttributes = "";

		// buyer_po
		$this->buyer_po->LinkCustomAttributes = "";
		$this->buyer_po->HrefValue = "";
		$this->buyer_po->TooltipValue = "";

		// roll_no
		$this->roll_no->LinkCustomAttributes = "";
		$this->roll_no->HrefValue = "";
		$this->roll_no->TooltipValue = "";

		// qty
		$this->qty->LinkCustomAttributes = "";
		$this->qty->HrefValue = "";
		$this->qty->TooltipValue = "";

		// pl_no
		$this->pl_no->LinkCustomAttributes = "";
		$this->pl_no->HrefValue = "";
		$this->pl_no->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// buyer_ref
		$this->buyer_ref->LinkCustomAttributes = "";
		$this->buyer_ref->HrefValue = "";
		$this->buyer_ref->TooltipValue = "";

		// design_id
		$this->design_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->design_id->CurrentValue)) {
			$this->design_id->HrefValue = "packing_list_nolist.php?x_design_id=" . $this->design_id->CurrentValue; // Add prefix/suffix
			$this->design_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
		} else {
			$this->design_id->HrefValue = "";
		}
		$this->design_id->TooltipValue = "";

		// size_buyer
		$this->size_buyer->LinkCustomAttributes = "";
		$this->size_buyer->HrefValue = "";
		$this->size_buyer->TooltipValue = "";

		// buyers_id
		$this->buyers_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->buyers_id->CurrentValue)) {
			$this->buyers_id->HrefValue = "packing_list_nolist.php?x_buyers_id=" . $this->buyers_id->CurrentValue; // Add prefix/suffix
			$this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
		} else {
			$this->buyers_id->HrefValue = "";
		}
		$this->buyers_id->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// despatch_week
		$this->despatch_week->LinkCustomAttributes = "";
		$this->despatch_week->HrefValue = "";
		$this->despatch_week->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// current_works
		$this->current_works->LinkCustomAttributes = "";
		$this->current_works->HrefValue = "";
		$this->current_works->TooltipValue = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// po_price
		$this->po_price->LinkCustomAttributes = "";
		$this->po_price->HrefValue = "";
		$this->po_price->TooltipValue = "";

		// po_discount
		$this->po_discount->LinkCustomAttributes = "";
		$this->po_discount->HrefValue = "";
		$this->po_discount->TooltipValue = "";

		// po_currency
		$this->po_currency->LinkCustomAttributes = "";
		$this->po_currency->HrefValue = "";
		$this->po_currency->TooltipValue = "";

		// buyer_uid
		$this->buyer_uid->LinkCustomAttributes = "";
		$this->buyer_uid->HrefValue = "";
		$this->buyer_uid->TooltipValue = "";

		// sqm_a
		$this->sqm_a->LinkCustomAttributes = "";
		$this->sqm_a->HrefValue = "";
		$this->sqm_a->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// buyer_po
		$this->buyer_po->EditAttrs["class"] = "form-control";
		$this->buyer_po->EditCustomAttributes = "";
		$this->buyer_po->EditValue = $this->buyer_po->CurrentValue;
		$this->buyer_po->ViewCustomAttributes = "";

		// roll_no
		$this->roll_no->EditAttrs["class"] = "form-control";
		$this->roll_no->EditCustomAttributes = "";
		$this->roll_no->EditValue = $this->roll_no->CurrentValue;
		$this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

		// qty
		$this->qty->EditAttrs["class"] = "form-control";
		$this->qty->EditCustomAttributes = "";
		$this->qty->EditValue = $this->qty->CurrentValue;
		$this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

		// pl_no
		$this->pl_no->EditAttrs["class"] = "form-control";
		$this->pl_no->EditCustomAttributes = "";
		$this->pl_no->EditValue = $this->pl_no->CurrentValue;
		$this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());
		if (strval($this->pl_no->EditValue) <> "" && is_numeric($this->pl_no->EditValue))
			$this->pl_no->EditValue = FormatNumber($this->pl_no->EditValue, -2, -2, -2, -2);

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";
		$this->_barcode->EditValue = $this->_barcode->CurrentValue;
		$this->_barcode->EditValue = FormatNumber($this->_barcode->EditValue, 0, -2, -2, -2);
		$this->_barcode->ViewCustomAttributes = "";

		// buyer_ref
		$this->buyer_ref->EditAttrs["class"] = "form-control";
		$this->buyer_ref->EditCustomAttributes = "";
		$this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
		$this->buyer_ref->ViewCustomAttributes = "";

		// design_id
		$this->design_id->EditAttrs["class"] = "form-control";
		$this->design_id->EditCustomAttributes = "";
		$curVal = strval($this->design_id->CurrentValue);
		if ($curVal <> "") {
			$this->design_id->EditValue = $this->design_id->lookupCacheOption($curVal);
			if ($this->design_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->design_id->EditValue = $this->design_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->design_id->EditValue = $this->design_id->CurrentValue;
				}
			}
		} else {
			$this->design_id->EditValue = NULL;
		}
		$this->design_id->ViewCustomAttributes = "";

		// size_buyer
		$this->size_buyer->EditAttrs["class"] = "form-control";
		$this->size_buyer->EditCustomAttributes = "";
		$this->size_buyer->EditValue = $this->size_buyer->CurrentValue;
		$this->size_buyer->ViewCustomAttributes = "";

		// buyers_id
		$this->buyers_id->EditAttrs["class"] = "form-control";
		$this->buyers_id->EditCustomAttributes = "";
		$curVal = strval($this->buyers_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyers_id->EditValue = $this->buyers_id->lookupCacheOption($curVal);
			if ($this->buyers_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` > 1000 and `grp` = 3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->buyers_id->EditValue = $this->buyers_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyers_id->EditValue = $this->buyers_id->CurrentValue;
				}
			}
		} else {
			$this->buyers_id->EditValue = NULL;
		}
		$this->buyers_id->ViewCustomAttributes = "";

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->EditValue = FormatNumber($this->po->EditValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// despatch_week
		$this->despatch_week->EditAttrs["class"] = "form-control";
		$this->despatch_week->EditCustomAttributes = "";
		$curVal = strval($this->despatch_week->CurrentValue);
		if ($curVal <> "") {
			$this->despatch_week->EditValue = $this->despatch_week->lookupCacheOption($curVal);
			if ($this->despatch_week->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->despatch_week->EditValue = $this->despatch_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->despatch_week->EditValue = $this->despatch_week->CurrentValue;
				}
			}
		} else {
			$this->despatch_week->EditValue = NULL;
		}
		$this->despatch_week->ViewCustomAttributes = "";

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = "";
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// current_works
		$this->current_works->EditAttrs["class"] = "form-control";
		$this->current_works->EditCustomAttributes = "";
		$curVal = strval($this->current_works->CurrentValue);
		if ($curVal <> "") {
			$this->current_works->EditValue = $this->current_works->lookupCacheOption($curVal);
			if ($this->current_works->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->current_works->EditValue = $this->current_works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->current_works->EditValue = $this->current_works->CurrentValue;
				}
			}
		} else {
			$this->current_works->EditValue = NULL;
		}
		$this->current_works->ViewCustomAttributes = "";

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// operator
		// datetime
		// po_price

		$this->po_price->EditAttrs["class"] = "form-control";
		$this->po_price->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->po_price->CurrentValue = HtmlDecode($this->po_price->CurrentValue);
		$this->po_price->EditValue = $this->po_price->CurrentValue;
		$this->po_price->PlaceHolder = RemoveHtml($this->po_price->caption());

		// po_discount
		$this->po_discount->EditAttrs["class"] = "form-control";
		$this->po_discount->EditCustomAttributes = "";
		$this->po_discount->EditValue = $this->po_discount->CurrentValue;
		$this->po_discount->PlaceHolder = RemoveHtml($this->po_discount->caption());
		if (strval($this->po_discount->EditValue) <> "" && is_numeric($this->po_discount->EditValue))
			$this->po_discount->EditValue = FormatNumber($this->po_discount->EditValue, -2, -2, -2, -2);

		// po_currency
		$this->po_currency->EditAttrs["class"] = "form-control";
		$this->po_currency->EditCustomAttributes = "";
		$this->po_currency->EditValue = $this->po_currency->CurrentValue;
		$this->po_currency->PlaceHolder = RemoveHtml($this->po_currency->caption());

		// buyer_uid
		$this->buyer_uid->EditAttrs["class"] = "form-control";
		$this->buyer_uid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_uid->CurrentValue = HtmlDecode($this->buyer_uid->CurrentValue);
		$this->buyer_uid->EditValue = $this->buyer_uid->CurrentValue;
		$this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

		// sqm_a
		$this->sqm_a->EditAttrs["class"] = "form-control";
		$this->sqm_a->EditCustomAttributes = "";
		$this->sqm_a->EditValue = $this->sqm_a->CurrentValue;
		$this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
		if (strval($this->sqm_a->EditValue) <> "" && is_numeric($this->sqm_a->EditValue))
			$this->sqm_a->EditValue = FormatNumber($this->sqm_a->EditValue, -2, -2, -2, -2);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			$this->_barcode->Count++; // Increment count
			if (is_numeric($this->sqm->CurrentValue))
				$this->sqm->Total += $this->sqm->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->_barcode->CurrentValue = $this->_barcode->Count;
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
			$this->_barcode->ViewCustomAttributes = "";
			$this->_barcode->HrefValue = ""; // Clear href value
			$this->sqm->CurrentValue = $this->sqm->Total;
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";
			$this->sqm->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->buyer_po);
					$doc->exportCaption($this->roll_no);
					$doc->exportCaption($this->qty);
					$doc->exportCaption($this->pl_no);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->buyer_ref);
					$doc->exportCaption($this->design_id);
					$doc->exportCaption($this->size_buyer);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->sqm_a);
				} else {
					$doc->exportCaption($this->buyer_po);
					$doc->exportCaption($this->roll_no);
					$doc->exportCaption($this->qty);
					$doc->exportCaption($this->pl_no);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->design_id);
					$doc->exportCaption($this->size_buyer);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->sqm_a);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->buyer_po);
						$doc->exportField($this->roll_no);
						$doc->exportField($this->qty);
						$doc->exportField($this->pl_no);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->buyer_ref);
						$doc->exportField($this->design_id);
						$doc->exportField($this->size_buyer);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->po);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->sqm);
						$doc->exportField($this->id);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->sqm_a);
					} else {
						$doc->exportField($this->buyer_po);
						$doc->exportField($this->roll_no);
						$doc->exportField($this->qty);
						$doc->exportField($this->pl_no);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->design_id);
						$doc->exportField($this->size_buyer);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->po);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->sqm);
						$doc->exportField($this->id);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->sqm_a);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->buyer_po, '');
				$doc->exportAggregate($this->roll_no, '');
				$doc->exportAggregate($this->qty, '');
				$doc->exportAggregate($this->pl_no, '');
				$doc->exportAggregate($this->_barcode, 'COUNT');
				$doc->exportAggregate($this->design_id, '');
				$doc->exportAggregate($this->size_buyer, '');
				$doc->exportAggregate($this->buyers_id, '');
				$doc->exportAggregate($this->po, '');
				$doc->exportAggregate($this->despatch_week, '');
				$doc->exportAggregate($this->sqm, 'TOTAL');
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->operator, '');
				$doc->exportAggregate($this->datetime, '');
				$doc->exportAggregate($this->sqm_a, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'packing_list_no';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'packing_list_no';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'packing_list_no';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'packing_list_no';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>