<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class packing_list_no_search extends packing_list_no
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'packing_list_no';

	// Page object name
	public $PageObjName = "packing_list_no_search";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (packing_list_no)
		if (!isset($GLOBALS["packing_list_no"]) || get_class($GLOBALS["packing_list_no"]) == PROJECT_NAMESPACE . "packing_list_no") {
			$GLOBALS["packing_list_no"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["packing_list_no"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'packing_list_no');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $packing_list_no;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($packing_list_no);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "packing_list_noview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("packing_list_nolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->buyer_po->setVisibility();
		$this->roll_no->setVisibility();
		$this->qty->setVisibility();
		$this->pl_no->setVisibility();
		$this->_barcode->setVisibility();
		$this->buyer_ref->setVisibility();
		$this->design_id->setVisibility();
		$this->size_buyer->setVisibility();
		$this->buyers_id->setVisibility();
		$this->po->setVisibility();
		$this->despatch_week->setVisibility();
		$this->sqm->setVisibility();
		$this->current_works->setVisibility();
		$this->id->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->po_price->Visible = FALSE;
		$this->po_discount->Visible = FALSE;
		$this->po_currency->Visible = FALSE;
		$this->buyer_uid->Visible = FALSE;
		$this->sqm_a->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->design_id);
		$this->setupLookupOptions($this->buyers_id);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->current_works);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "packing_list_nolist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->buyer_po); // buyer_po
		$this->buildSearchUrl($srchUrl, $this->roll_no); // roll_no
		$this->buildSearchUrl($srchUrl, $this->qty); // qty
		$this->buildSearchUrl($srchUrl, $this->pl_no); // pl_no
		$this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
		$this->buildSearchUrl($srchUrl, $this->buyer_ref); // buyer_ref
		$this->buildSearchUrl($srchUrl, $this->design_id); // design_id
		$this->buildSearchUrl($srchUrl, $this->size_buyer); // size_buyer
		$this->buildSearchUrl($srchUrl, $this->buyers_id); // buyers_id
		$this->buildSearchUrl($srchUrl, $this->po); // po
		$this->buildSearchUrl($srchUrl, $this->despatch_week); // despatch_week
		$this->buildSearchUrl($srchUrl, $this->sqm); // sqm
		$this->buildSearchUrl($srchUrl, $this->current_works); // current_works
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->sqm_a); // sqm_a
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// buyer_po

		if (!$this->isAddOrEdit())
			$this->buyer_po->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_po"));
		$this->buyer_po->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_po"));

		// roll_no
		if (!$this->isAddOrEdit())
			$this->roll_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_roll_no"));
		$this->roll_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_roll_no"));

		// qty
		if (!$this->isAddOrEdit())
			$this->qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty"));
		$this->qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty"));

		// pl_no
		if (!$this->isAddOrEdit())
			$this->pl_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pl_no"));
		$this->pl_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pl_no"));

		// barcode
		if (!$this->isAddOrEdit())
			$this->_barcode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__barcode"));
		$this->_barcode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__barcode"));
		$this->_barcode->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v__barcode"));
		$this->_barcode->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y__barcode"));
		$this->_barcode->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w__barcode"));

		// buyer_ref
		if (!$this->isAddOrEdit())
			$this->buyer_ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_ref"));
		$this->buyer_ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_ref"));

		// design_id
		if (!$this->isAddOrEdit())
			$this->design_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_design_id"));
		$this->design_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_design_id"));

		// size_buyer
		if (!$this->isAddOrEdit())
			$this->size_buyer->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_size_buyer"));
		$this->size_buyer->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_size_buyer"));

		// buyers_id
		if (!$this->isAddOrEdit())
			$this->buyers_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyers_id"));
		$this->buyers_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyers_id"));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po"));
		$this->po->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po"));
		$this->po->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_po"));
		$this->po->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_po"));
		$this->po->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_po"));

		// despatch_week
		if (!$this->isAddOrEdit())
			$this->despatch_week->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_despatch_week"));
		$this->despatch_week->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_despatch_week"));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sqm"));
		$this->sqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sqm"));

		// current_works
		if (!$this->isAddOrEdit())
			$this->current_works->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_current_works"));
		$this->current_works->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_current_works"));

		// id
		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// sqm_a
		if (!$this->isAddOrEdit())
			$this->sqm_a->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sqm_a"));
		$this->sqm_a->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sqm_a"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->pl_no->FormValue == $this->pl_no->CurrentValue && is_numeric(ConvertToFloatString($this->pl_no->CurrentValue)))
			$this->pl_no->CurrentValue = ConvertToFloatString($this->pl_no->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm_a->FormValue == $this->sqm_a->CurrentValue && is_numeric(ConvertToFloatString($this->sqm_a->CurrentValue)))
			$this->sqm_a->CurrentValue = ConvertToFloatString($this->sqm_a->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// buyer_po
		// roll_no
		// qty
		// pl_no
		// barcode
		// buyer_ref
		// design_id
		// size_buyer
		// buyers_id
		// po
		// despatch_week
		// sqm
		// current_works
		// id
		// operator
		// datetime
		// po_price
		// po_discount
		// po_currency
		// buyer_uid
		// sqm_a

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// buyer_po
			$this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;
			$this->buyer_po->ViewCustomAttributes = "";

			// roll_no
			$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
			$this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, 0, -2, -2, -2);
			$this->roll_no->ViewCustomAttributes = "";

			// qty
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// pl_no
			$this->pl_no->ViewValue = $this->pl_no->CurrentValue;
			$this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, 2, -2, -2, -2);
			$this->pl_no->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
			$this->_barcode->ViewCustomAttributes = "";

			// buyer_ref
			$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
			$this->buyer_ref->ViewCustomAttributes = "";

			// design_id
			$curVal = strval($this->design_id->CurrentValue);
			if ($curVal <> "") {
				$this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
				if ($this->design_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->design_id->ViewValue = $this->design_id->CurrentValue;
					}
				}
			} else {
				$this->design_id->ViewValue = NULL;
			}
			$this->design_id->ViewCustomAttributes = "";

			// size_buyer
			$this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;
			$this->size_buyer->ViewCustomAttributes = "";

			// buyers_id
			$curVal = strval($this->buyers_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
				if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 1000 and `grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
					}
				}
			} else {
				$this->buyers_id->ViewValue = NULL;
			}
			$this->buyers_id->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// current_works
			$curVal = strval($this->current_works->CurrentValue);
			if ($curVal <> "") {
				$this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
				if ($this->current_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->current_works->ViewValue = $this->current_works->CurrentValue;
					}
				}
			} else {
				$this->current_works->ViewValue = NULL;
			}
			$this->current_works->ViewCustomAttributes = "";

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// sqm_a
			$this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
			$this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, 2, -2, -2, -2);
			$this->sqm_a->ViewCustomAttributes = "";

			// buyer_po
			$this->buyer_po->LinkCustomAttributes = "";
			$this->buyer_po->HrefValue = "";
			$this->buyer_po->TooltipValue = "";

			// roll_no
			$this->roll_no->LinkCustomAttributes = "";
			$this->roll_no->HrefValue = "";
			$this->roll_no->TooltipValue = "";

			// qty
			$this->qty->LinkCustomAttributes = "";
			$this->qty->HrefValue = "";
			$this->qty->TooltipValue = "";

			// pl_no
			$this->pl_no->LinkCustomAttributes = "";
			$this->pl_no->HrefValue = "";
			$this->pl_no->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// buyer_ref
			$this->buyer_ref->LinkCustomAttributes = "";
			$this->buyer_ref->HrefValue = "";
			$this->buyer_ref->TooltipValue = "";

			// design_id
			$this->design_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->design_id->CurrentValue)) {
				$this->design_id->HrefValue = "packing_list_nolist.php?x_design_id=" . $this->design_id->CurrentValue; // Add prefix/suffix
				$this->design_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
			} else {
				$this->design_id->HrefValue = "";
			}
			$this->design_id->TooltipValue = "";

			// size_buyer
			$this->size_buyer->LinkCustomAttributes = "";
			$this->size_buyer->HrefValue = "";
			$this->size_buyer->TooltipValue = "";

			// buyers_id
			$this->buyers_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyers_id->CurrentValue)) {
				$this->buyers_id->HrefValue = "packing_list_nolist.php?x_buyers_id=" . $this->buyers_id->CurrentValue; // Add prefix/suffix
				$this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
			} else {
				$this->buyers_id->HrefValue = "";
			}
			$this->buyers_id->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// current_works
			$this->current_works->LinkCustomAttributes = "";
			$this->current_works->HrefValue = "";
			$this->current_works->TooltipValue = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// sqm_a
			$this->sqm_a->LinkCustomAttributes = "";
			$this->sqm_a->HrefValue = "";
			$this->sqm_a->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// buyer_po
			$this->buyer_po->EditAttrs["class"] = "form-control";
			$this->buyer_po->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_po->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_po->AdvancedSearch->SearchValue);
			$this->buyer_po->EditValue = HtmlEncode($this->buyer_po->AdvancedSearch->SearchValue);
			$this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

			// roll_no
			$this->roll_no->EditAttrs["class"] = "form-control";
			$this->roll_no->EditCustomAttributes = "";
			$this->roll_no->EditValue = HtmlEncode($this->roll_no->AdvancedSearch->SearchValue);
			$this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

			// qty
			$this->qty->EditAttrs["class"] = "form-control";
			$this->qty->EditCustomAttributes = "";
			$this->qty->EditValue = HtmlEncode($this->qty->AdvancedSearch->SearchValue);
			$this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

			// pl_no
			$this->pl_no->EditAttrs["class"] = "form-control";
			$this->pl_no->EditCustomAttributes = "";
			$this->pl_no->EditValue = HtmlEncode($this->pl_no->AdvancedSearch->SearchValue);
			$this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$this->_barcode->EditValue = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$this->_barcode->EditValue2 = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue2);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

			// buyer_ref
			$this->buyer_ref->EditAttrs["class"] = "form-control";
			$this->buyer_ref->EditCustomAttributes = "";
			$this->buyer_ref->EditValue = HtmlEncode($this->buyer_ref->AdvancedSearch->SearchValue);
			$this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

			// design_id
			$this->design_id->EditAttrs["class"] = "form-control";
			$this->design_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->design_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->design_id->AdvancedSearch->ViewValue = $this->design_id->lookupCacheOption($curVal);
			else
				$this->design_id->AdvancedSearch->ViewValue = $this->design_id->Lookup !== NULL && is_array($this->design_id->Lookup->Options) ? $curVal : NULL;
			if ($this->design_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->design_id->EditValue = array_values($this->design_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->design_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->design_id->EditValue = $arwrk;
			}

			// size_buyer
			$this->size_buyer->EditAttrs["class"] = "form-control";
			$this->size_buyer->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size_buyer->AdvancedSearch->SearchValue = HtmlDecode($this->size_buyer->AdvancedSearch->SearchValue);
			$this->size_buyer->EditValue = HtmlEncode($this->size_buyer->AdvancedSearch->SearchValue);
			$this->size_buyer->PlaceHolder = RemoveHtml($this->size_buyer->caption());

			// buyers_id
			$this->buyers_id->EditAttrs["class"] = "form-control";
			$this->buyers_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->buyers_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
			else
				$this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->Lookup !== NULL && is_array($this->buyers_id->Lookup->Options) ? $curVal : NULL;
			if ($this->buyers_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->buyers_id->EditValue = array_values($this->buyers_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->buyers_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` > 1000 and `grp` = 3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyers_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->buyers_id->EditValue = $arwrk;
			}

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue2 = HtmlEncode($this->po->AdvancedSearch->SearchValue2);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$curVal = trim(strval($this->despatch_week->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			else
				$this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->Lookup !== NULL && is_array($this->despatch_week->Lookup->Options) ? $curVal : NULL;
			if ($this->despatch_week->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->despatch_week->EditValue = array_values($this->despatch_week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->despatch_week->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->despatch_week->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->despatch_week->EditValue = $arwrk;
			}

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// current_works
			$this->current_works->EditAttrs["class"] = "form-control";
			$this->current_works->EditCustomAttributes = "";
			$curVal = trim(strval($this->current_works->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->current_works->AdvancedSearch->ViewValue = $this->current_works->lookupCacheOption($curVal);
			else
				$this->current_works->AdvancedSearch->ViewValue = $this->current_works->Lookup !== NULL && is_array($this->current_works->Lookup->Options) ? $curVal : NULL;
			if ($this->current_works->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->current_works->EditValue = array_values($this->current_works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->current_works->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->current_works->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->current_works->EditValue = $arwrk;
			}

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->AdvancedSearch->SearchValue);
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// sqm_a
			$this->sqm_a->EditAttrs["class"] = "form-control";
			$this->sqm_a->EditCustomAttributes = "";
			$this->sqm_a->EditValue = HtmlEncode($this->sqm_a->AdvancedSearch->SearchValue);
			$this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->roll_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->roll_no->errorMessage());
		}
		if (!CheckInteger($this->qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty->errorMessage());
		}
		if (!CheckNumber($this->pl_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pl_no->errorMessage());
		}
		if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->_barcode->errorMessage());
		}
		if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->_barcode->errorMessage());
		}
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->sqm->errorMessage());
		}
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->operator->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckNumber($this->sqm_a->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->sqm_a->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->buyer_po->AdvancedSearch->load();
		$this->roll_no->AdvancedSearch->load();
		$this->qty->AdvancedSearch->load();
		$this->pl_no->AdvancedSearch->load();
		$this->_barcode->AdvancedSearch->load();
		$this->buyer_ref->AdvancedSearch->load();
		$this->design_id->AdvancedSearch->load();
		$this->size_buyer->AdvancedSearch->load();
		$this->buyers_id->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->despatch_week->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->current_works->AdvancedSearch->load();
		$this->id->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->sqm_a->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("packing_list_nolist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_design_id":
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_buyers_id":
					$lookupFilter = function() {
						return "`id` > 1000 and `grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_current_works":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_design_id":
							break;
						case "x_buyers_id":
							break;
						case "x_despatch_week":
							break;
						case "x_current_works":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>