<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for packing_list_tmp
 */
class packing_list_tmp extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $pl_no;
	public $buyers_id;
	public $_barcode;
	public $roll_no_start;
	public $design;
	public $buyer_ref;
	public $buyer_code;
	public $buyer_uid;
	public $partner_ref;
	public $no_of_bales;
	public $buyer_po;
	public $quantity;
	public $size;
	public $sqm;
	public $amount;
	public $currency;
	public $price;
	public $discount;
	public $hsn;
	public $gst;
	public $composition;
	public $price_exchange;
	public $amount_exchange;
	public $roll_no;
	public $roll_no_end;
	public $design_code;
	public $cbm;
	public $weight;
	public $sqm_a;
	public $partner_other_ref;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'packing_list_tmp';
		$this->TableName = 'packing_list_tmp';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`packing_list_tmp`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// pl_no
		$this->pl_no = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_pl_no', 'pl_no', '`pl_no`', '`pl_no`', 131, -1, FALSE, '`pl_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pl_no->Sortable = TRUE; // Allow sort
		$this->pl_no->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['pl_no'] = &$this->pl_no;

		// buyers_id
		$this->buyers_id = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_buyers_id', 'buyers_id', '`buyers_id`', '`buyers_id`', 18, -1, FALSE, '`buyers_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->buyers_id->Sortable = TRUE; // Allow sort
		$this->buyers_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyers_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyers_id->Lookup = new Lookup('buyers_id', 'buyer', FALSE, 'id', ["name","code","",""], [], ["x_buyer_ref"], [], [], [], [], '`name` ASC', '');
		$this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyers_id'] = &$this->buyers_id;

		// barcode
		$this->_barcode = new DbField('packing_list_tmp', 'packing_list_tmp', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 19, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_barcode->Sortable = TRUE; // Allow sort
		$this->_barcode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['barcode'] = &$this->_barcode;

		// roll_no_start
		$this->roll_no_start = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_roll_no_start', 'roll_no_start', '`roll_no_start`', '`roll_no_start`', 18, -1, FALSE, '`roll_no_start`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->roll_no_start->Sortable = TRUE; // Allow sort
		$this->roll_no_start->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['roll_no_start'] = &$this->roll_no_start;

		// design
		$this->design = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_design', 'design', '`design`', '`design`', 201, -1, FALSE, '`design`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design->Sortable = TRUE; // Allow sort
		$this->design->Lookup = new Lookup('design', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->design->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['design'] = &$this->design;

		// buyer_ref
		$this->buyer_ref = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_buyer_ref', 'buyer_ref', '`buyer_ref`', '`buyer_ref`', 201, -1, FALSE, '`EV__buyer_ref`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->buyer_ref->Sortable = TRUE; // Allow sort
		$this->buyer_ref->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyer_ref->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyer_ref->Lookup = new Lookup('buyer_ref', 'partner_product_ref', FALSE, 'id', ["partner_ref","","",""], ["x_buyers_id"], [], ["partner"], ["x_partner"], [], [], '`partner_ref` ASC', '');
		$this->fields['buyer_ref'] = &$this->buyer_ref;

		// buyer_code
		$this->buyer_code = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_buyer_code', 'buyer_code', '`buyer_code`', '`buyer_code`', 200, -1, FALSE, '`buyer_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_code->Sortable = TRUE; // Allow sort
		$this->fields['buyer_code'] = &$this->buyer_code;

		// buyer_uid
		$this->buyer_uid = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_buyer_uid', 'buyer_uid', '`buyer_uid`', '`buyer_uid`', 200, -1, FALSE, '`buyer_uid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_uid->Sortable = TRUE; // Allow sort
		$this->fields['buyer_uid'] = &$this->buyer_uid;

		// partner_ref
		$this->partner_ref = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_partner_ref', 'partner_ref', '`partner_ref`', '`partner_ref`', 200, -1, FALSE, '`partner_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_ref->Sortable = TRUE; // Allow sort
		$this->fields['partner_ref'] = &$this->partner_ref;

		// no_of_bales
		$this->no_of_bales = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_no_of_bales', 'no_of_bales', '`no_of_bales`', '`no_of_bales`', 2, -1, FALSE, '`no_of_bales`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->no_of_bales->Nullable = FALSE; // NOT NULL field
		$this->no_of_bales->Required = TRUE; // Required field
		$this->no_of_bales->Sortable = TRUE; // Allow sort
		$this->no_of_bales->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['no_of_bales'] = &$this->no_of_bales;

		// buyer_po
		$this->buyer_po = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_buyer_po', 'buyer_po', '`buyer_po`', '`buyer_po`', 200, -1, FALSE, '`buyer_po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_po->Sortable = TRUE; // Allow sort
		$this->fields['buyer_po'] = &$this->buyer_po;

		// quantity
		$this->quantity = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 20, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Nullable = FALSE; // NOT NULL field
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['quantity'] = &$this->quantity;

		// size
		$this->size = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_size', 'size', '`size`', '`size`', 200, -1, FALSE, '`size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size->Sortable = TRUE; // Allow sort
		$this->fields['size'] = &$this->size;

		// sqm
		$this->sqm = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 131, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Nullable = FALSE; // NOT NULL field
		$this->sqm->Required = TRUE; // Required field
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// amount
		$this->amount = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_amount', 'amount', '`amount`', '`amount`', 131, -1, FALSE, '`amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount->Nullable = FALSE; // NOT NULL field
		$this->amount->Required = TRUE; // Required field
		$this->amount->Sortable = TRUE; // Allow sort
		$this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amount'] = &$this->amount;

		// currency
		$this->currency = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_currency', 'currency', '`currency`', '`currency`', 2, -1, FALSE, '`currency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->currency->Nullable = FALSE; // NOT NULL field
		$this->currency->Required = TRUE; // Required field
		$this->currency->Sortable = TRUE; // Allow sort
		$this->currency->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->currency->Lookup = new Lookup('currency', 'currency', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['currency'] = &$this->currency;

		// price
		$this->price = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_price', 'price', '`price`', '`price`', 131, -1, FALSE, '`price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price->Nullable = FALSE; // NOT NULL field
		$this->price->Required = TRUE; // Required field
		$this->price->Sortable = TRUE; // Allow sort
		$this->price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price'] = &$this->price;

		// discount
		$this->discount = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_discount', 'discount', '`discount`', '`discount`', 131, -1, FALSE, '`discount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->discount->Sortable = TRUE; // Allow sort
		$this->discount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['discount'] = &$this->discount;

		// hsn
		$this->hsn = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_hsn', 'hsn', '`hsn`', '`hsn`', 200, -1, FALSE, '`hsn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->hsn->Sortable = TRUE; // Allow sort
		$this->fields['hsn'] = &$this->hsn;

		// gst
		$this->gst = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_gst', 'gst', '`gst`', '`gst`', 131, -1, FALSE, '`gst`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->gst->Sortable = TRUE; // Allow sort
		$this->gst->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['gst'] = &$this->gst;

		// composition
		$this->composition = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_composition', 'composition', '`composition`', '`composition`', 200, -1, FALSE, '`composition`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->composition->Sortable = TRUE; // Allow sort
		$this->fields['composition'] = &$this->composition;

		// price_exchange
		$this->price_exchange = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_price_exchange', 'price_exchange', '`price_exchange`', '`price_exchange`', 131, -1, FALSE, '`price_exchange`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price_exchange->Nullable = FALSE; // NOT NULL field
		$this->price_exchange->Sortable = TRUE; // Allow sort
		$this->price_exchange->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price_exchange'] = &$this->price_exchange;

		// amount_exchange
		$this->amount_exchange = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_amount_exchange', 'amount_exchange', '`amount_exchange`', '`amount_exchange`', 131, -1, FALSE, '`amount_exchange`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount_exchange->Nullable = FALSE; // NOT NULL field
		$this->amount_exchange->Sortable = TRUE; // Allow sort
		$this->amount_exchange->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amount_exchange'] = &$this->amount_exchange;

		// roll_no
		$this->roll_no = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_roll_no', 'roll_no', '`roll_no`', '`roll_no`', 200, -1, FALSE, '`roll_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->roll_no->Sortable = FALSE; // Allow sort
		$this->fields['roll_no'] = &$this->roll_no;

		// roll_no_end
		$this->roll_no_end = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_roll_no_end', 'roll_no_end', '`roll_no_end`', '`roll_no_end`', 18, -1, FALSE, '`roll_no_end`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->roll_no_end->Sortable = FALSE; // Allow sort
		$this->roll_no_end->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['roll_no_end'] = &$this->roll_no_end;

		// design_code
		$this->design_code = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_design_code', 'design_code', '`design_code`', '`design_code`', 200, -1, FALSE, '`design_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design_code->Sortable = FALSE; // Allow sort
		$this->fields['design_code'] = &$this->design_code;

		// cbm
		$this->cbm = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_cbm', 'cbm', '`cbm`', '`cbm`', 131, -1, FALSE, '`cbm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cbm->Sortable = TRUE; // Allow sort
		$this->cbm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cbm'] = &$this->cbm;

		// weight
		$this->weight = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_weight', 'weight', '`weight`', '`weight`', 131, -1, FALSE, '`weight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->weight->Sortable = TRUE; // Allow sort
		$this->weight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['weight'] = &$this->weight;

		// sqm_a
		$this->sqm_a = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_sqm_a', 'sqm_a', '`sqm_a`', '`sqm_a`', 131, -1, FALSE, '`sqm_a`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm_a->Sortable = TRUE; // Allow sort
		$this->sqm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm_a'] = &$this->sqm_a;

		// partner_other_ref
		$this->partner_other_ref = new DbField('packing_list_tmp', 'packing_list_tmp', 'x_partner_other_ref', 'partner_other_ref', '`partner_other_ref`', '`partner_other_ref`', 201, -1, FALSE, '`partner_other_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->partner_other_ref->Sortable = TRUE; // Allow sort
		$this->fields['partner_other_ref'] = &$this->partner_other_ref;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`packing_list_tmp`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `partner_ref` FROM `partner_product_ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `packing_list_tmp`.`buyer_ref` LIMIT 1) AS `EV__buyer_ref` FROM `packing_list_tmp`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` ASC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->buyer_ref->AdvancedSearch->SearchValue <> "" ||
			$this->buyer_ref->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->buyer_ref->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->buyer_ref->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->pl_no->DbValue = $row['pl_no'];
		$this->buyers_id->DbValue = $row['buyers_id'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->roll_no_start->DbValue = $row['roll_no_start'];
		$this->design->DbValue = $row['design'];
		$this->buyer_ref->DbValue = $row['buyer_ref'];
		$this->buyer_code->DbValue = $row['buyer_code'];
		$this->buyer_uid->DbValue = $row['buyer_uid'];
		$this->partner_ref->DbValue = $row['partner_ref'];
		$this->no_of_bales->DbValue = $row['no_of_bales'];
		$this->buyer_po->DbValue = $row['buyer_po'];
		$this->quantity->DbValue = $row['quantity'];
		$this->size->DbValue = $row['size'];
		$this->sqm->DbValue = $row['sqm'];
		$this->amount->DbValue = $row['amount'];
		$this->currency->DbValue = $row['currency'];
		$this->price->DbValue = $row['price'];
		$this->discount->DbValue = $row['discount'];
		$this->hsn->DbValue = $row['hsn'];
		$this->gst->DbValue = $row['gst'];
		$this->composition->DbValue = $row['composition'];
		$this->price_exchange->DbValue = $row['price_exchange'];
		$this->amount_exchange->DbValue = $row['amount_exchange'];
		$this->roll_no->DbValue = $row['roll_no'];
		$this->roll_no_end->DbValue = $row['roll_no_end'];
		$this->design_code->DbValue = $row['design_code'];
		$this->cbm->DbValue = $row['cbm'];
		$this->weight->DbValue = $row['weight'];
		$this->sqm_a->DbValue = $row['sqm_a'];
		$this->partner_other_ref->DbValue = $row['partner_other_ref'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "packing_list_tmplist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "packing_list_tmpview.php")
			return $Language->phrase("View");
		elseif ($pageName == "packing_list_tmpedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "packing_list_tmpadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "packing_list_tmplist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("packing_list_tmpview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("packing_list_tmpview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "packing_list_tmpadd.php?" . $this->getUrlParm($parm);
		else
			$url = "packing_list_tmpadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("packing_list_tmpedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("packing_list_tmpadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("packing_list_tmpdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->pl_no->setDbValue($rs->fields('pl_no'));
		$this->buyers_id->setDbValue($rs->fields('buyers_id'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->roll_no_start->setDbValue($rs->fields('roll_no_start'));
		$this->design->setDbValue($rs->fields('design'));
		$this->buyer_ref->setDbValue($rs->fields('buyer_ref'));
		$this->buyer_code->setDbValue($rs->fields('buyer_code'));
		$this->buyer_uid->setDbValue($rs->fields('buyer_uid'));
		$this->partner_ref->setDbValue($rs->fields('partner_ref'));
		$this->no_of_bales->setDbValue($rs->fields('no_of_bales'));
		$this->buyer_po->setDbValue($rs->fields('buyer_po'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->size->setDbValue($rs->fields('size'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->amount->setDbValue($rs->fields('amount'));
		$this->currency->setDbValue($rs->fields('currency'));
		$this->price->setDbValue($rs->fields('price'));
		$this->discount->setDbValue($rs->fields('discount'));
		$this->hsn->setDbValue($rs->fields('hsn'));
		$this->gst->setDbValue($rs->fields('gst'));
		$this->composition->setDbValue($rs->fields('composition'));
		$this->price_exchange->setDbValue($rs->fields('price_exchange'));
		$this->amount_exchange->setDbValue($rs->fields('amount_exchange'));
		$this->roll_no->setDbValue($rs->fields('roll_no'));
		$this->roll_no_end->setDbValue($rs->fields('roll_no_end'));
		$this->design_code->setDbValue($rs->fields('design_code'));
		$this->cbm->setDbValue($rs->fields('cbm'));
		$this->weight->setDbValue($rs->fields('weight'));
		$this->sqm_a->setDbValue($rs->fields('sqm_a'));
		$this->partner_other_ref->setDbValue($rs->fields('partner_other_ref'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// pl_no
		// buyers_id
		// barcode
		// roll_no_start
		// design

		$this->design->CellCssStyle = "white-space: nowrap;";

		// buyer_ref
		// buyer_code
		// buyer_uid
		// partner_ref
		// no_of_bales
		// buyer_po
		// quantity
		// size
		// sqm
		// amount
		// currency
		// price
		// discount
		// hsn
		// gst
		// composition
		// price_exchange
		// amount_exchange
		// roll_no

		$this->roll_no->CellCssStyle = "white-space: nowrap;";

		// roll_no_end
		$this->roll_no_end->CellCssStyle = "white-space: nowrap;";

		// design_code
		// cbm
		// weight
		// sqm_a
		// partner_other_ref
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// pl_no
		$this->pl_no->ViewValue = $this->pl_no->CurrentValue;
		$this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, 2, -2, -2, -2);
		$this->pl_no->ViewCustomAttributes = "";

		// buyers_id
		$curVal = strval($this->buyers_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
			if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` > 1000 and `grp` = 3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
				}
			}
		} else {
			$this->buyers_id->ViewValue = NULL;
		}
		$this->buyers_id->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
		$this->_barcode->ViewCustomAttributes = "";

		// roll_no_start
		$this->roll_no_start->ViewValue = $this->roll_no_start->CurrentValue;
		$this->roll_no_start->ViewValue = FormatNumber($this->roll_no_start->ViewValue, 0, -2, -2, -2);
		$this->roll_no_start->ViewCustomAttributes = "";

		// design
		$this->design->ViewValue = $this->design->CurrentValue;
		$curVal = strval($this->design->CurrentValue);
		if ($curVal <> "") {
			$this->design->ViewValue = $this->design->lookupCacheOption($curVal);
			if ($this->design->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->design->ViewValue = $this->design->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->design->ViewValue = $this->design->CurrentValue;
				}
			}
		} else {
			$this->design->ViewValue = NULL;
		}
		$this->design->ViewCustomAttributes = "";

		// buyer_ref
		if ($this->buyer_ref->VirtualValue <> "") {
			$this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
		} else {
		$curVal = strval($this->buyer_ref->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
			if ($this->buyer_ref->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
				}
			}
		} else {
			$this->buyer_ref->ViewValue = NULL;
		}
		}
		$this->buyer_ref->ViewCustomAttributes = "";

		// buyer_code
		$this->buyer_code->ViewValue = $this->buyer_code->CurrentValue;
		$this->buyer_code->ViewCustomAttributes = "";

		// buyer_uid
		$this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;
		$this->buyer_uid->ViewCustomAttributes = "";

		// partner_ref
		$this->partner_ref->ViewValue = $this->partner_ref->CurrentValue;
		$this->partner_ref->ViewCustomAttributes = "";

		// no_of_bales
		$this->no_of_bales->ViewValue = $this->no_of_bales->CurrentValue;
		$this->no_of_bales->ViewValue = FormatNumber($this->no_of_bales->ViewValue, 0, -2, -2, -2);
		$this->no_of_bales->ViewCustomAttributes = "";

		// buyer_po
		$this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;
		$this->buyer_po->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// size
		$this->size->ViewValue = $this->size->CurrentValue;
		$this->size->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// amount
		$this->amount->ViewValue = $this->amount->CurrentValue;
		$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
		$this->amount->ViewCustomAttributes = "";

		// currency
		$curVal = strval($this->currency->CurrentValue);
		if ($curVal <> "") {
			$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			if ($this->currency->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->currency->ViewValue = $this->currency->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->currency->ViewValue = $this->currency->CurrentValue;
				}
			}
		} else {
			$this->currency->ViewValue = NULL;
		}
		$this->currency->ViewCustomAttributes = "";

		// price
		$this->price->ViewValue = $this->price->CurrentValue;
		$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
		$this->price->ViewCustomAttributes = "";

		// discount
		$this->discount->ViewValue = $this->discount->CurrentValue;
		$this->discount->ViewValue = FormatNumber($this->discount->ViewValue, 2, -2, -2, -2);
		$this->discount->ViewCustomAttributes = "";

		// hsn
		$this->hsn->ViewValue = $this->hsn->CurrentValue;
		$this->hsn->ViewCustomAttributes = "";

		// gst
		$this->gst->ViewValue = $this->gst->CurrentValue;
		$this->gst->ViewValue = FormatNumber($this->gst->ViewValue, 2, -2, -2, -2);
		$this->gst->ViewCustomAttributes = "";

		// composition
		$this->composition->ViewValue = $this->composition->CurrentValue;
		$this->composition->ViewCustomAttributes = "";

		// price_exchange
		$this->price_exchange->ViewValue = $this->price_exchange->CurrentValue;
		$this->price_exchange->ViewValue = FormatNumber($this->price_exchange->ViewValue, 2, -2, -2, -2);
		$this->price_exchange->ViewCustomAttributes = "";

		// amount_exchange
		$this->amount_exchange->ViewValue = $this->amount_exchange->CurrentValue;
		$this->amount_exchange->ViewValue = FormatNumber($this->amount_exchange->ViewValue, 2, -2, -2, -2);
		$this->amount_exchange->ViewCustomAttributes = "";

		// roll_no
		$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
		$this->roll_no->ViewCustomAttributes = "";

		// roll_no_end
		$this->roll_no_end->ViewValue = $this->roll_no_end->CurrentValue;
		$this->roll_no_end->ViewValue = FormatNumber($this->roll_no_end->ViewValue, 0, -2, -2, -2);
		$this->roll_no_end->ViewCustomAttributes = "";

		// design_code
		$this->design_code->ViewValue = $this->design_code->CurrentValue;
		$this->design_code->ViewCustomAttributes = "";

		// cbm
		$this->cbm->ViewValue = $this->cbm->CurrentValue;
		$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 2, -2, -2, -2);
		$this->cbm->ViewCustomAttributes = "";

		// weight
		$this->weight->ViewValue = $this->weight->CurrentValue;
		$this->weight->ViewValue = FormatNumber($this->weight->ViewValue, 2, -2, -2, -2);
		$this->weight->ViewCustomAttributes = "";

		// sqm_a
		$this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
		$this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, 2, -2, -2, -2);
		$this->sqm_a->ViewCustomAttributes = "";

		// partner_other_ref
		$this->partner_other_ref->ViewValue = $this->partner_other_ref->CurrentValue;
		$this->partner_other_ref->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// pl_no
		$this->pl_no->LinkCustomAttributes = "";
		$this->pl_no->HrefValue = "";
		$this->pl_no->TooltipValue = "";

		// buyers_id
		$this->buyers_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->buyers_id->CurrentValue)) {
			$this->buyers_id->HrefValue = "bcodelist.php?x_buyers_id=" . $this->buyers_id->CurrentValue; // Add prefix/suffix
			$this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
		} else {
			$this->buyers_id->HrefValue = "";
		}
		$this->buyers_id->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// roll_no_start
		$this->roll_no_start->LinkCustomAttributes = "";
		$this->roll_no_start->HrefValue = "";
		$this->roll_no_start->TooltipValue = "";

		// design
		$this->design->LinkCustomAttributes = "";
		$this->design->HrefValue = "";
		$this->design->TooltipValue = "";

		// buyer_ref
		$this->buyer_ref->LinkCustomAttributes = "";
		if (!EmptyValue($this->buyer_ref->CurrentValue)) {
			$this->buyer_ref->HrefValue = "bcodelist.php?x_buyer_ref=" . $this->buyer_ref->CurrentValue; // Add prefix/suffix
			$this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
		} else {
			$this->buyer_ref->HrefValue = "";
		}
		$this->buyer_ref->TooltipValue = "";

		// buyer_code
		$this->buyer_code->LinkCustomAttributes = "";
		$this->buyer_code->HrefValue = "";
		$this->buyer_code->TooltipValue = "";

		// buyer_uid
		$this->buyer_uid->LinkCustomAttributes = "";
		$this->buyer_uid->HrefValue = "";
		$this->buyer_uid->TooltipValue = "";

		// partner_ref
		$this->partner_ref->LinkCustomAttributes = "";
		$this->partner_ref->HrefValue = "";
		$this->partner_ref->TooltipValue = "";

		// no_of_bales
		$this->no_of_bales->LinkCustomAttributes = "";
		$this->no_of_bales->HrefValue = "";
		$this->no_of_bales->TooltipValue = "";

		// buyer_po
		$this->buyer_po->LinkCustomAttributes = "";
		$this->buyer_po->HrefValue = "";
		$this->buyer_po->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// size
		$this->size->LinkCustomAttributes = "";
		$this->size->HrefValue = "";
		$this->size->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// amount
		$this->amount->LinkCustomAttributes = "";
		$this->amount->HrefValue = "";
		$this->amount->TooltipValue = "";

		// currency
		$this->currency->LinkCustomAttributes = "";
		$this->currency->HrefValue = "";
		$this->currency->TooltipValue = "";

		// price
		$this->price->LinkCustomAttributes = "";
		$this->price->HrefValue = "";
		$this->price->TooltipValue = "";

		// discount
		$this->discount->LinkCustomAttributes = "";
		$this->discount->HrefValue = "";
		$this->discount->TooltipValue = "";

		// hsn
		$this->hsn->LinkCustomAttributes = "";
		$this->hsn->HrefValue = "";
		$this->hsn->TooltipValue = "";

		// gst
		$this->gst->LinkCustomAttributes = "";
		$this->gst->HrefValue = "";
		$this->gst->TooltipValue = "";

		// composition
		$this->composition->LinkCustomAttributes = "";
		$this->composition->HrefValue = "";
		$this->composition->TooltipValue = "";

		// price_exchange
		$this->price_exchange->LinkCustomAttributes = "";
		$this->price_exchange->HrefValue = "";
		$this->price_exchange->TooltipValue = "";

		// amount_exchange
		$this->amount_exchange->LinkCustomAttributes = "";
		$this->amount_exchange->HrefValue = "";
		$this->amount_exchange->TooltipValue = "";

		// roll_no
		$this->roll_no->LinkCustomAttributes = "";
		$this->roll_no->HrefValue = "";
		$this->roll_no->TooltipValue = "";

		// roll_no_end
		$this->roll_no_end->LinkCustomAttributes = "";
		$this->roll_no_end->HrefValue = "";
		$this->roll_no_end->TooltipValue = "";

		// design_code
		$this->design_code->LinkCustomAttributes = "";
		$this->design_code->HrefValue = "";
		$this->design_code->TooltipValue = "";

		// cbm
		$this->cbm->LinkCustomAttributes = "";
		$this->cbm->HrefValue = "";
		$this->cbm->TooltipValue = "";

		// weight
		$this->weight->LinkCustomAttributes = "";
		$this->weight->HrefValue = "";
		$this->weight->TooltipValue = "";

		// sqm_a
		$this->sqm_a->LinkCustomAttributes = "";
		$this->sqm_a->HrefValue = "";
		$this->sqm_a->TooltipValue = "";

		// partner_other_ref
		$this->partner_other_ref->LinkCustomAttributes = "";
		$this->partner_other_ref->HrefValue = "";
		$this->partner_other_ref->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// pl_no
		$this->pl_no->EditAttrs["class"] = "form-control";
		$this->pl_no->EditCustomAttributes = "";
		$this->pl_no->EditValue = $this->pl_no->CurrentValue;
		$this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());
		if (strval($this->pl_no->EditValue) <> "" && is_numeric($this->pl_no->EditValue))
			$this->pl_no->EditValue = FormatNumber($this->pl_no->EditValue, -2, -2, -2, -2);

		// buyers_id
		$this->buyers_id->EditAttrs["class"] = "form-control";
		$this->buyers_id->EditCustomAttributes = "";
		$curVal = strval($this->buyers_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyers_id->EditValue = $this->buyers_id->lookupCacheOption($curVal);
			if ($this->buyers_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` > 1000 and `grp` = 3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->buyers_id->EditValue = $this->buyers_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyers_id->EditValue = $this->buyers_id->CurrentValue;
				}
			}
		} else {
			$this->buyers_id->EditValue = NULL;
		}
		$this->buyers_id->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";
		$this->_barcode->EditValue = $this->_barcode->CurrentValue;
		$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

		// roll_no_start
		$this->roll_no_start->EditAttrs["class"] = "form-control";
		$this->roll_no_start->EditCustomAttributes = "";
		$this->roll_no_start->EditValue = $this->roll_no_start->CurrentValue;
		$this->roll_no_start->PlaceHolder = RemoveHtml($this->roll_no_start->caption());

		// design
		$this->design->EditAttrs["class"] = "form-control";
		$this->design->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
		$this->design->EditValue = $this->design->CurrentValue;
		$this->design->PlaceHolder = RemoveHtml($this->design->caption());

		// buyer_ref
		$this->buyer_ref->EditAttrs["class"] = "form-control";
		$this->buyer_ref->EditCustomAttributes = "";
		if ($this->buyer_ref->VirtualValue <> "") {
			$this->buyer_ref->EditValue = $this->buyer_ref->VirtualValue;
		} else {
		$curVal = strval($this->buyer_ref->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_ref->EditValue = $this->buyer_ref->lookupCacheOption($curVal);
			if ($this->buyer_ref->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer_ref->EditValue = $this->buyer_ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
				}
			}
		} else {
			$this->buyer_ref->EditValue = NULL;
		}
		}
		$this->buyer_ref->ViewCustomAttributes = "";

		// buyer_code
		$this->buyer_code->EditAttrs["class"] = "form-control";
		$this->buyer_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_code->CurrentValue = HtmlDecode($this->buyer_code->CurrentValue);
		$this->buyer_code->EditValue = $this->buyer_code->CurrentValue;
		$this->buyer_code->PlaceHolder = RemoveHtml($this->buyer_code->caption());

		// buyer_uid
		$this->buyer_uid->EditAttrs["class"] = "form-control";
		$this->buyer_uid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_uid->CurrentValue = HtmlDecode($this->buyer_uid->CurrentValue);
		$this->buyer_uid->EditValue = $this->buyer_uid->CurrentValue;
		$this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

		// partner_ref
		$this->partner_ref->EditAttrs["class"] = "form-control";
		$this->partner_ref->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->partner_ref->CurrentValue = HtmlDecode($this->partner_ref->CurrentValue);
		$this->partner_ref->EditValue = $this->partner_ref->CurrentValue;
		$this->partner_ref->PlaceHolder = RemoveHtml($this->partner_ref->caption());

		// no_of_bales
		$this->no_of_bales->EditAttrs["class"] = "form-control";
		$this->no_of_bales->EditCustomAttributes = "";
		$this->no_of_bales->EditValue = $this->no_of_bales->CurrentValue;
		$this->no_of_bales->PlaceHolder = RemoveHtml($this->no_of_bales->caption());

		// buyer_po
		$this->buyer_po->EditAttrs["class"] = "form-control";
		$this->buyer_po->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_po->CurrentValue = HtmlDecode($this->buyer_po->CurrentValue);
		$this->buyer_po->EditValue = $this->buyer_po->CurrentValue;
		$this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

		// size
		$this->size->EditAttrs["class"] = "form-control";
		$this->size->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->size->CurrentValue = HtmlDecode($this->size->CurrentValue);
		$this->size->EditValue = $this->size->CurrentValue;
		$this->size->PlaceHolder = RemoveHtml($this->size->caption());

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = "";
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
		if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
			$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, -2);

		// amount
		$this->amount->EditAttrs["class"] = "form-control";
		$this->amount->EditCustomAttributes = "";
		$this->amount->EditValue = $this->amount->CurrentValue;
		$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
		if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue))
			$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, -2);

		// currency
		$this->currency->EditAttrs["class"] = "form-control";
		$this->currency->EditCustomAttributes = "";

		// price
		$this->price->EditAttrs["class"] = "form-control";
		$this->price->EditCustomAttributes = "";
		$this->price->EditValue = $this->price->CurrentValue;
		$this->price->PlaceHolder = RemoveHtml($this->price->caption());
		if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
			$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, -2);

		// discount
		$this->discount->EditAttrs["class"] = "form-control";
		$this->discount->EditCustomAttributes = "";
		$this->discount->EditValue = $this->discount->CurrentValue;
		$this->discount->PlaceHolder = RemoveHtml($this->discount->caption());
		if (strval($this->discount->EditValue) <> "" && is_numeric($this->discount->EditValue))
			$this->discount->EditValue = FormatNumber($this->discount->EditValue, -2, -2, -2, -2);

		// hsn
		$this->hsn->EditAttrs["class"] = "form-control";
		$this->hsn->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->hsn->CurrentValue = HtmlDecode($this->hsn->CurrentValue);
		$this->hsn->EditValue = $this->hsn->CurrentValue;
		$this->hsn->PlaceHolder = RemoveHtml($this->hsn->caption());

		// gst
		$this->gst->EditAttrs["class"] = "form-control";
		$this->gst->EditCustomAttributes = "";
		$this->gst->EditValue = $this->gst->CurrentValue;
		$this->gst->PlaceHolder = RemoveHtml($this->gst->caption());
		if (strval($this->gst->EditValue) <> "" && is_numeric($this->gst->EditValue))
			$this->gst->EditValue = FormatNumber($this->gst->EditValue, -2, -2, -2, -2);

		// composition
		$this->composition->EditAttrs["class"] = "form-control";
		$this->composition->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->composition->CurrentValue = HtmlDecode($this->composition->CurrentValue);
		$this->composition->EditValue = $this->composition->CurrentValue;
		$this->composition->PlaceHolder = RemoveHtml($this->composition->caption());

		// price_exchange
		$this->price_exchange->EditAttrs["class"] = "form-control";
		$this->price_exchange->EditCustomAttributes = "";
		$this->price_exchange->EditValue = $this->price_exchange->CurrentValue;
		$this->price_exchange->PlaceHolder = RemoveHtml($this->price_exchange->caption());
		if (strval($this->price_exchange->EditValue) <> "" && is_numeric($this->price_exchange->EditValue))
			$this->price_exchange->EditValue = FormatNumber($this->price_exchange->EditValue, -2, -2, -2, -2);

		// amount_exchange
		$this->amount_exchange->EditAttrs["class"] = "form-control";
		$this->amount_exchange->EditCustomAttributes = "";
		$this->amount_exchange->EditValue = $this->amount_exchange->CurrentValue;
		$this->amount_exchange->PlaceHolder = RemoveHtml($this->amount_exchange->caption());
		if (strval($this->amount_exchange->EditValue) <> "" && is_numeric($this->amount_exchange->EditValue))
			$this->amount_exchange->EditValue = FormatNumber($this->amount_exchange->EditValue, -2, -2, -2, -2);

		// roll_no
		$this->roll_no->EditAttrs["class"] = "form-control";
		$this->roll_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->roll_no->CurrentValue = HtmlDecode($this->roll_no->CurrentValue);
		$this->roll_no->EditValue = $this->roll_no->CurrentValue;
		$this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

		// roll_no_end
		$this->roll_no_end->EditAttrs["class"] = "form-control";
		$this->roll_no_end->EditCustomAttributes = "";
		$this->roll_no_end->EditValue = $this->roll_no_end->CurrentValue;
		$this->roll_no_end->PlaceHolder = RemoveHtml($this->roll_no_end->caption());

		// design_code
		$this->design_code->EditAttrs["class"] = "form-control";
		$this->design_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->design_code->CurrentValue = HtmlDecode($this->design_code->CurrentValue);
		$this->design_code->EditValue = $this->design_code->CurrentValue;
		$this->design_code->PlaceHolder = RemoveHtml($this->design_code->caption());

		// cbm
		$this->cbm->EditAttrs["class"] = "form-control";
		$this->cbm->EditCustomAttributes = "";
		$this->cbm->EditValue = $this->cbm->CurrentValue;
		$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
		if (strval($this->cbm->EditValue) <> "" && is_numeric($this->cbm->EditValue))
			$this->cbm->EditValue = FormatNumber($this->cbm->EditValue, -2, -2, -2, -2);

		// weight
		$this->weight->EditAttrs["class"] = "form-control";
		$this->weight->EditCustomAttributes = "";
		$this->weight->EditValue = $this->weight->CurrentValue;
		$this->weight->PlaceHolder = RemoveHtml($this->weight->caption());
		if (strval($this->weight->EditValue) <> "" && is_numeric($this->weight->EditValue))
			$this->weight->EditValue = FormatNumber($this->weight->EditValue, -2, -2, -2, -2);

		// sqm_a
		$this->sqm_a->EditAttrs["class"] = "form-control";
		$this->sqm_a->EditCustomAttributes = "";
		$this->sqm_a->EditValue = $this->sqm_a->CurrentValue;
		$this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
		if (strval($this->sqm_a->EditValue) <> "" && is_numeric($this->sqm_a->EditValue))
			$this->sqm_a->EditValue = FormatNumber($this->sqm_a->EditValue, -2, -2, -2, -2);

		// partner_other_ref
		$this->partner_other_ref->EditAttrs["class"] = "form-control";
		$this->partner_other_ref->EditCustomAttributes = "";
		$this->partner_other_ref->EditValue = $this->partner_other_ref->CurrentValue;
		$this->partner_other_ref->PlaceHolder = RemoveHtml($this->partner_other_ref->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			$this->_barcode->Count++; // Increment count
			if (is_numeric($this->quantity->CurrentValue))
				$this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
			if (is_numeric($this->sqm->CurrentValue))
				$this->sqm->Total += $this->sqm->CurrentValue; // Accumulate total
			if (is_numeric($this->amount->CurrentValue))
				$this->amount->Total += $this->amount->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->_barcode->CurrentValue = $this->_barcode->Count;
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
			$this->_barcode->ViewCustomAttributes = "";
			$this->_barcode->HrefValue = ""; // Clear href value
			$this->quantity->CurrentValue = $this->quantity->Total;
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";
			$this->quantity->HrefValue = ""; // Clear href value
			$this->sqm->CurrentValue = $this->sqm->Total;
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";
			$this->sqm->HrefValue = ""; // Clear href value
			$this->amount->CurrentValue = $this->amount->Total;
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";
			$this->amount->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->pl_no);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->roll_no_start);
					$doc->exportCaption($this->buyer_ref);
					$doc->exportCaption($this->buyer_code);
					$doc->exportCaption($this->buyer_uid);
					$doc->exportCaption($this->partner_ref);
					$doc->exportCaption($this->no_of_bales);
					$doc->exportCaption($this->buyer_po);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->size);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->discount);
					$doc->exportCaption($this->hsn);
					$doc->exportCaption($this->gst);
					$doc->exportCaption($this->composition);
					$doc->exportCaption($this->price_exchange);
					$doc->exportCaption($this->amount_exchange);
					$doc->exportCaption($this->design_code);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->weight);
					$doc->exportCaption($this->sqm_a);
					$doc->exportCaption($this->partner_other_ref);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->pl_no);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->roll_no_start);
					$doc->exportCaption($this->design);
					$doc->exportCaption($this->buyer_ref);
					$doc->exportCaption($this->buyer_code);
					$doc->exportCaption($this->buyer_uid);
					$doc->exportCaption($this->partner_ref);
					$doc->exportCaption($this->no_of_bales);
					$doc->exportCaption($this->buyer_po);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->size);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->discount);
					$doc->exportCaption($this->hsn);
					$doc->exportCaption($this->gst);
					$doc->exportCaption($this->composition);
					$doc->exportCaption($this->price_exchange);
					$doc->exportCaption($this->amount_exchange);
					$doc->exportCaption($this->design_code);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->weight);
					$doc->exportCaption($this->sqm_a);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->pl_no);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->roll_no_start);
						$doc->exportField($this->buyer_ref);
						$doc->exportField($this->buyer_code);
						$doc->exportField($this->buyer_uid);
						$doc->exportField($this->partner_ref);
						$doc->exportField($this->no_of_bales);
						$doc->exportField($this->buyer_po);
						$doc->exportField($this->quantity);
						$doc->exportField($this->size);
						$doc->exportField($this->sqm);
						$doc->exportField($this->amount);
						$doc->exportField($this->currency);
						$doc->exportField($this->price);
						$doc->exportField($this->discount);
						$doc->exportField($this->hsn);
						$doc->exportField($this->gst);
						$doc->exportField($this->composition);
						$doc->exportField($this->price_exchange);
						$doc->exportField($this->amount_exchange);
						$doc->exportField($this->design_code);
						$doc->exportField($this->cbm);
						$doc->exportField($this->weight);
						$doc->exportField($this->sqm_a);
						$doc->exportField($this->partner_other_ref);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->pl_no);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->roll_no_start);
						$doc->exportField($this->design);
						$doc->exportField($this->buyer_ref);
						$doc->exportField($this->buyer_code);
						$doc->exportField($this->buyer_uid);
						$doc->exportField($this->partner_ref);
						$doc->exportField($this->no_of_bales);
						$doc->exportField($this->buyer_po);
						$doc->exportField($this->quantity);
						$doc->exportField($this->size);
						$doc->exportField($this->sqm);
						$doc->exportField($this->amount);
						$doc->exportField($this->currency);
						$doc->exportField($this->price);
						$doc->exportField($this->discount);
						$doc->exportField($this->hsn);
						$doc->exportField($this->gst);
						$doc->exportField($this->composition);
						$doc->exportField($this->price_exchange);
						$doc->exportField($this->amount_exchange);
						$doc->exportField($this->design_code);
						$doc->exportField($this->cbm);
						$doc->exportField($this->weight);
						$doc->exportField($this->sqm_a);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->pl_no, '');
				$doc->exportAggregate($this->buyers_id, '');
				$doc->exportAggregate($this->_barcode, 'COUNT');
				$doc->exportAggregate($this->roll_no_start, '');
				$doc->exportAggregate($this->design, '');
				$doc->exportAggregate($this->buyer_ref, '');
				$doc->exportAggregate($this->buyer_code, '');
				$doc->exportAggregate($this->buyer_uid, '');
				$doc->exportAggregate($this->partner_ref, '');
				$doc->exportAggregate($this->no_of_bales, '');
				$doc->exportAggregate($this->buyer_po, '');
				$doc->exportAggregate($this->quantity, 'TOTAL');
				$doc->exportAggregate($this->size, '');
				$doc->exportAggregate($this->sqm, 'TOTAL');
				$doc->exportAggregate($this->amount, 'TOTAL');
				$doc->exportAggregate($this->currency, '');
				$doc->exportAggregate($this->price, '');
				$doc->exportAggregate($this->discount, '');
				$doc->exportAggregate($this->hsn, '');
				$doc->exportAggregate($this->gst, '');
				$doc->exportAggregate($this->composition, '');
				$doc->exportAggregate($this->price_exchange, '');
				$doc->exportAggregate($this->amount_exchange, '');
				$doc->exportAggregate($this->design_code, '');
				$doc->exportAggregate($this->cbm, '');
				$doc->exportAggregate($this->weight, '');
				$doc->exportAggregate($this->sqm_a, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>