<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class packing_list_tmp_list extends packing_list_tmp
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'packing_list_tmp';

	// Page object name
	public $PageObjName = "packing_list_tmp_list";

	// Grid form hidden field names
	public $FormName = "fpacking_list_tmplist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (packing_list_tmp)
		if (!isset($GLOBALS["packing_list_tmp"]) || get_class($GLOBALS["packing_list_tmp"]) == PROJECT_NAMESPACE . "packing_list_tmp") {
			$GLOBALS["packing_list_tmp"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["packing_list_tmp"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "packing_list_tmpadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "packing_list_tmpdelete.php";
		$this->MultiUpdateUrl = "packing_list_tmpupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'packing_list_tmp');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fpacking_list_tmplistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $packing_list_tmp;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($packing_list_tmp);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->pl_no->setVisibility();
		$this->buyers_id->setVisibility();
		$this->_barcode->setVisibility();
		$this->roll_no_start->setVisibility();
		$this->design->setVisibility();
		$this->buyer_ref->setVisibility();
		$this->buyer_code->setVisibility();
		$this->buyer_uid->setVisibility();
		$this->partner_ref->setVisibility();
		$this->no_of_bales->setVisibility();
		$this->buyer_po->setVisibility();
		$this->quantity->setVisibility();
		$this->size->setVisibility();
		$this->sqm->setVisibility();
		$this->amount->setVisibility();
		$this->currency->setVisibility();
		$this->price->setVisibility();
		$this->discount->setVisibility();
		$this->hsn->setVisibility();
		$this->gst->setVisibility();
		$this->composition->setVisibility();
		$this->price_exchange->setVisibility();
		$this->amount_exchange->setVisibility();
		$this->roll_no->Visible = FALSE;
		$this->roll_no_end->Visible = FALSE;
		$this->design_code->setVisibility();
		$this->cbm->setVisibility();
		$this->weight->setVisibility();
		$this->sqm_a->setVisibility();
		$this->partner_other_ref->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->buyers_id);
		$this->setupLookupOptions($this->design);
		$this->setupLookupOptions($this->buyer_ref);
		$this->setupLookupOptions($this->currency);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fpacking_list_tmplistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->pl_no->AdvancedSearch->toJson(), ","); // Field pl_no
		$filterList = Concat($filterList, $this->buyers_id->AdvancedSearch->toJson(), ","); // Field buyers_id
		$filterList = Concat($filterList, $this->_barcode->AdvancedSearch->toJson(), ","); // Field barcode
		$filterList = Concat($filterList, $this->roll_no_start->AdvancedSearch->toJson(), ","); // Field roll_no_start
		$filterList = Concat($filterList, $this->buyer_ref->AdvancedSearch->toJson(), ","); // Field buyer_ref
		$filterList = Concat($filterList, $this->buyer_code->AdvancedSearch->toJson(), ","); // Field buyer_code
		$filterList = Concat($filterList, $this->buyer_uid->AdvancedSearch->toJson(), ","); // Field buyer_uid
		$filterList = Concat($filterList, $this->partner_ref->AdvancedSearch->toJson(), ","); // Field partner_ref
		$filterList = Concat($filterList, $this->no_of_bales->AdvancedSearch->toJson(), ","); // Field no_of_bales
		$filterList = Concat($filterList, $this->buyer_po->AdvancedSearch->toJson(), ","); // Field buyer_po
		$filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
		$filterList = Concat($filterList, $this->size->AdvancedSearch->toJson(), ","); // Field size
		$filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
		$filterList = Concat($filterList, $this->amount->AdvancedSearch->toJson(), ","); // Field amount
		$filterList = Concat($filterList, $this->currency->AdvancedSearch->toJson(), ","); // Field currency
		$filterList = Concat($filterList, $this->price->AdvancedSearch->toJson(), ","); // Field price
		$filterList = Concat($filterList, $this->discount->AdvancedSearch->toJson(), ","); // Field discount
		$filterList = Concat($filterList, $this->hsn->AdvancedSearch->toJson(), ","); // Field hsn
		$filterList = Concat($filterList, $this->gst->AdvancedSearch->toJson(), ","); // Field gst
		$filterList = Concat($filterList, $this->composition->AdvancedSearch->toJson(), ","); // Field composition
		$filterList = Concat($filterList, $this->price_exchange->AdvancedSearch->toJson(), ","); // Field price_exchange
		$filterList = Concat($filterList, $this->amount_exchange->AdvancedSearch->toJson(), ","); // Field amount_exchange
		$filterList = Concat($filterList, $this->design_code->AdvancedSearch->toJson(), ","); // Field design_code
		$filterList = Concat($filterList, $this->cbm->AdvancedSearch->toJson(), ","); // Field cbm
		$filterList = Concat($filterList, $this->weight->AdvancedSearch->toJson(), ","); // Field weight
		$filterList = Concat($filterList, $this->sqm_a->AdvancedSearch->toJson(), ","); // Field sqm_a
		$filterList = Concat($filterList, $this->partner_other_ref->AdvancedSearch->toJson(), ","); // Field partner_other_ref
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fpacking_list_tmplistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field pl_no
		$this->pl_no->AdvancedSearch->SearchValue = @$filter["x_pl_no"];
		$this->pl_no->AdvancedSearch->SearchOperator = @$filter["z_pl_no"];
		$this->pl_no->AdvancedSearch->SearchCondition = @$filter["v_pl_no"];
		$this->pl_no->AdvancedSearch->SearchValue2 = @$filter["y_pl_no"];
		$this->pl_no->AdvancedSearch->SearchOperator2 = @$filter["w_pl_no"];
		$this->pl_no->AdvancedSearch->save();

		// Field buyers_id
		$this->buyers_id->AdvancedSearch->SearchValue = @$filter["x_buyers_id"];
		$this->buyers_id->AdvancedSearch->SearchOperator = @$filter["z_buyers_id"];
		$this->buyers_id->AdvancedSearch->SearchCondition = @$filter["v_buyers_id"];
		$this->buyers_id->AdvancedSearch->SearchValue2 = @$filter["y_buyers_id"];
		$this->buyers_id->AdvancedSearch->SearchOperator2 = @$filter["w_buyers_id"];
		$this->buyers_id->AdvancedSearch->save();

		// Field barcode
		$this->_barcode->AdvancedSearch->SearchValue = @$filter["x__barcode"];
		$this->_barcode->AdvancedSearch->SearchOperator = @$filter["z__barcode"];
		$this->_barcode->AdvancedSearch->SearchCondition = @$filter["v__barcode"];
		$this->_barcode->AdvancedSearch->SearchValue2 = @$filter["y__barcode"];
		$this->_barcode->AdvancedSearch->SearchOperator2 = @$filter["w__barcode"];
		$this->_barcode->AdvancedSearch->save();

		// Field roll_no_start
		$this->roll_no_start->AdvancedSearch->SearchValue = @$filter["x_roll_no_start"];
		$this->roll_no_start->AdvancedSearch->SearchOperator = @$filter["z_roll_no_start"];
		$this->roll_no_start->AdvancedSearch->SearchCondition = @$filter["v_roll_no_start"];
		$this->roll_no_start->AdvancedSearch->SearchValue2 = @$filter["y_roll_no_start"];
		$this->roll_no_start->AdvancedSearch->SearchOperator2 = @$filter["w_roll_no_start"];
		$this->roll_no_start->AdvancedSearch->save();

		// Field buyer_ref
		$this->buyer_ref->AdvancedSearch->SearchValue = @$filter["x_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchOperator = @$filter["z_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchCondition = @$filter["v_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchValue2 = @$filter["y_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->save();

		// Field buyer_code
		$this->buyer_code->AdvancedSearch->SearchValue = @$filter["x_buyer_code"];
		$this->buyer_code->AdvancedSearch->SearchOperator = @$filter["z_buyer_code"];
		$this->buyer_code->AdvancedSearch->SearchCondition = @$filter["v_buyer_code"];
		$this->buyer_code->AdvancedSearch->SearchValue2 = @$filter["y_buyer_code"];
		$this->buyer_code->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_code"];
		$this->buyer_code->AdvancedSearch->save();

		// Field buyer_uid
		$this->buyer_uid->AdvancedSearch->SearchValue = @$filter["x_buyer_uid"];
		$this->buyer_uid->AdvancedSearch->SearchOperator = @$filter["z_buyer_uid"];
		$this->buyer_uid->AdvancedSearch->SearchCondition = @$filter["v_buyer_uid"];
		$this->buyer_uid->AdvancedSearch->SearchValue2 = @$filter["y_buyer_uid"];
		$this->buyer_uid->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_uid"];
		$this->buyer_uid->AdvancedSearch->save();

		// Field partner_ref
		$this->partner_ref->AdvancedSearch->SearchValue = @$filter["x_partner_ref"];
		$this->partner_ref->AdvancedSearch->SearchOperator = @$filter["z_partner_ref"];
		$this->partner_ref->AdvancedSearch->SearchCondition = @$filter["v_partner_ref"];
		$this->partner_ref->AdvancedSearch->SearchValue2 = @$filter["y_partner_ref"];
		$this->partner_ref->AdvancedSearch->SearchOperator2 = @$filter["w_partner_ref"];
		$this->partner_ref->AdvancedSearch->save();

		// Field no_of_bales
		$this->no_of_bales->AdvancedSearch->SearchValue = @$filter["x_no_of_bales"];
		$this->no_of_bales->AdvancedSearch->SearchOperator = @$filter["z_no_of_bales"];
		$this->no_of_bales->AdvancedSearch->SearchCondition = @$filter["v_no_of_bales"];
		$this->no_of_bales->AdvancedSearch->SearchValue2 = @$filter["y_no_of_bales"];
		$this->no_of_bales->AdvancedSearch->SearchOperator2 = @$filter["w_no_of_bales"];
		$this->no_of_bales->AdvancedSearch->save();

		// Field buyer_po
		$this->buyer_po->AdvancedSearch->SearchValue = @$filter["x_buyer_po"];
		$this->buyer_po->AdvancedSearch->SearchOperator = @$filter["z_buyer_po"];
		$this->buyer_po->AdvancedSearch->SearchCondition = @$filter["v_buyer_po"];
		$this->buyer_po->AdvancedSearch->SearchValue2 = @$filter["y_buyer_po"];
		$this->buyer_po->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_po"];
		$this->buyer_po->AdvancedSearch->save();

		// Field quantity
		$this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
		$this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
		$this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
		$this->quantity->AdvancedSearch->save();

		// Field size
		$this->size->AdvancedSearch->SearchValue = @$filter["x_size"];
		$this->size->AdvancedSearch->SearchOperator = @$filter["z_size"];
		$this->size->AdvancedSearch->SearchCondition = @$filter["v_size"];
		$this->size->AdvancedSearch->SearchValue2 = @$filter["y_size"];
		$this->size->AdvancedSearch->SearchOperator2 = @$filter["w_size"];
		$this->size->AdvancedSearch->save();

		// Field sqm
		$this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
		$this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
		$this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
		$this->sqm->AdvancedSearch->save();

		// Field amount
		$this->amount->AdvancedSearch->SearchValue = @$filter["x_amount"];
		$this->amount->AdvancedSearch->SearchOperator = @$filter["z_amount"];
		$this->amount->AdvancedSearch->SearchCondition = @$filter["v_amount"];
		$this->amount->AdvancedSearch->SearchValue2 = @$filter["y_amount"];
		$this->amount->AdvancedSearch->SearchOperator2 = @$filter["w_amount"];
		$this->amount->AdvancedSearch->save();

		// Field currency
		$this->currency->AdvancedSearch->SearchValue = @$filter["x_currency"];
		$this->currency->AdvancedSearch->SearchOperator = @$filter["z_currency"];
		$this->currency->AdvancedSearch->SearchCondition = @$filter["v_currency"];
		$this->currency->AdvancedSearch->SearchValue2 = @$filter["y_currency"];
		$this->currency->AdvancedSearch->SearchOperator2 = @$filter["w_currency"];
		$this->currency->AdvancedSearch->save();

		// Field price
		$this->price->AdvancedSearch->SearchValue = @$filter["x_price"];
		$this->price->AdvancedSearch->SearchOperator = @$filter["z_price"];
		$this->price->AdvancedSearch->SearchCondition = @$filter["v_price"];
		$this->price->AdvancedSearch->SearchValue2 = @$filter["y_price"];
		$this->price->AdvancedSearch->SearchOperator2 = @$filter["w_price"];
		$this->price->AdvancedSearch->save();

		// Field discount
		$this->discount->AdvancedSearch->SearchValue = @$filter["x_discount"];
		$this->discount->AdvancedSearch->SearchOperator = @$filter["z_discount"];
		$this->discount->AdvancedSearch->SearchCondition = @$filter["v_discount"];
		$this->discount->AdvancedSearch->SearchValue2 = @$filter["y_discount"];
		$this->discount->AdvancedSearch->SearchOperator2 = @$filter["w_discount"];
		$this->discount->AdvancedSearch->save();

		// Field hsn
		$this->hsn->AdvancedSearch->SearchValue = @$filter["x_hsn"];
		$this->hsn->AdvancedSearch->SearchOperator = @$filter["z_hsn"];
		$this->hsn->AdvancedSearch->SearchCondition = @$filter["v_hsn"];
		$this->hsn->AdvancedSearch->SearchValue2 = @$filter["y_hsn"];
		$this->hsn->AdvancedSearch->SearchOperator2 = @$filter["w_hsn"];
		$this->hsn->AdvancedSearch->save();

		// Field gst
		$this->gst->AdvancedSearch->SearchValue = @$filter["x_gst"];
		$this->gst->AdvancedSearch->SearchOperator = @$filter["z_gst"];
		$this->gst->AdvancedSearch->SearchCondition = @$filter["v_gst"];
		$this->gst->AdvancedSearch->SearchValue2 = @$filter["y_gst"];
		$this->gst->AdvancedSearch->SearchOperator2 = @$filter["w_gst"];
		$this->gst->AdvancedSearch->save();

		// Field composition
		$this->composition->AdvancedSearch->SearchValue = @$filter["x_composition"];
		$this->composition->AdvancedSearch->SearchOperator = @$filter["z_composition"];
		$this->composition->AdvancedSearch->SearchCondition = @$filter["v_composition"];
		$this->composition->AdvancedSearch->SearchValue2 = @$filter["y_composition"];
		$this->composition->AdvancedSearch->SearchOperator2 = @$filter["w_composition"];
		$this->composition->AdvancedSearch->save();

		// Field price_exchange
		$this->price_exchange->AdvancedSearch->SearchValue = @$filter["x_price_exchange"];
		$this->price_exchange->AdvancedSearch->SearchOperator = @$filter["z_price_exchange"];
		$this->price_exchange->AdvancedSearch->SearchCondition = @$filter["v_price_exchange"];
		$this->price_exchange->AdvancedSearch->SearchValue2 = @$filter["y_price_exchange"];
		$this->price_exchange->AdvancedSearch->SearchOperator2 = @$filter["w_price_exchange"];
		$this->price_exchange->AdvancedSearch->save();

		// Field amount_exchange
		$this->amount_exchange->AdvancedSearch->SearchValue = @$filter["x_amount_exchange"];
		$this->amount_exchange->AdvancedSearch->SearchOperator = @$filter["z_amount_exchange"];
		$this->amount_exchange->AdvancedSearch->SearchCondition = @$filter["v_amount_exchange"];
		$this->amount_exchange->AdvancedSearch->SearchValue2 = @$filter["y_amount_exchange"];
		$this->amount_exchange->AdvancedSearch->SearchOperator2 = @$filter["w_amount_exchange"];
		$this->amount_exchange->AdvancedSearch->save();

		// Field design_code
		$this->design_code->AdvancedSearch->SearchValue = @$filter["x_design_code"];
		$this->design_code->AdvancedSearch->SearchOperator = @$filter["z_design_code"];
		$this->design_code->AdvancedSearch->SearchCondition = @$filter["v_design_code"];
		$this->design_code->AdvancedSearch->SearchValue2 = @$filter["y_design_code"];
		$this->design_code->AdvancedSearch->SearchOperator2 = @$filter["w_design_code"];
		$this->design_code->AdvancedSearch->save();

		// Field cbm
		$this->cbm->AdvancedSearch->SearchValue = @$filter["x_cbm"];
		$this->cbm->AdvancedSearch->SearchOperator = @$filter["z_cbm"];
		$this->cbm->AdvancedSearch->SearchCondition = @$filter["v_cbm"];
		$this->cbm->AdvancedSearch->SearchValue2 = @$filter["y_cbm"];
		$this->cbm->AdvancedSearch->SearchOperator2 = @$filter["w_cbm"];
		$this->cbm->AdvancedSearch->save();

		// Field weight
		$this->weight->AdvancedSearch->SearchValue = @$filter["x_weight"];
		$this->weight->AdvancedSearch->SearchOperator = @$filter["z_weight"];
		$this->weight->AdvancedSearch->SearchCondition = @$filter["v_weight"];
		$this->weight->AdvancedSearch->SearchValue2 = @$filter["y_weight"];
		$this->weight->AdvancedSearch->SearchOperator2 = @$filter["w_weight"];
		$this->weight->AdvancedSearch->save();

		// Field sqm_a
		$this->sqm_a->AdvancedSearch->SearchValue = @$filter["x_sqm_a"];
		$this->sqm_a->AdvancedSearch->SearchOperator = @$filter["z_sqm_a"];
		$this->sqm_a->AdvancedSearch->SearchCondition = @$filter["v_sqm_a"];
		$this->sqm_a->AdvancedSearch->SearchValue2 = @$filter["y_sqm_a"];
		$this->sqm_a->AdvancedSearch->SearchOperator2 = @$filter["w_sqm_a"];
		$this->sqm_a->AdvancedSearch->save();

		// Field partner_other_ref
		$this->partner_other_ref->AdvancedSearch->SearchValue = @$filter["x_partner_other_ref"];
		$this->partner_other_ref->AdvancedSearch->SearchOperator = @$filter["z_partner_other_ref"];
		$this->partner_other_ref->AdvancedSearch->SearchCondition = @$filter["v_partner_other_ref"];
		$this->partner_other_ref->AdvancedSearch->SearchValue2 = @$filter["y_partner_other_ref"];
		$this->partner_other_ref->AdvancedSearch->SearchOperator2 = @$filter["w_partner_other_ref"];
		$this->partner_other_ref->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->pl_no, $default, FALSE); // pl_no
		$this->buildSearchSql($where, $this->buyers_id, $default, FALSE); // buyers_id
		$this->buildSearchSql($where, $this->_barcode, $default, FALSE); // barcode
		$this->buildSearchSql($where, $this->roll_no_start, $default, FALSE); // roll_no_start
		$this->buildSearchSql($where, $this->buyer_ref, $default, FALSE); // buyer_ref
		$this->buildSearchSql($where, $this->buyer_code, $default, FALSE); // buyer_code
		$this->buildSearchSql($where, $this->buyer_uid, $default, FALSE); // buyer_uid
		$this->buildSearchSql($where, $this->partner_ref, $default, FALSE); // partner_ref
		$this->buildSearchSql($where, $this->no_of_bales, $default, FALSE); // no_of_bales
		$this->buildSearchSql($where, $this->buyer_po, $default, FALSE); // buyer_po
		$this->buildSearchSql($where, $this->quantity, $default, FALSE); // quantity
		$this->buildSearchSql($where, $this->size, $default, FALSE); // size
		$this->buildSearchSql($where, $this->sqm, $default, FALSE); // sqm
		$this->buildSearchSql($where, $this->amount, $default, FALSE); // amount
		$this->buildSearchSql($where, $this->currency, $default, FALSE); // currency
		$this->buildSearchSql($where, $this->price, $default, FALSE); // price
		$this->buildSearchSql($where, $this->discount, $default, FALSE); // discount
		$this->buildSearchSql($where, $this->hsn, $default, FALSE); // hsn
		$this->buildSearchSql($where, $this->gst, $default, FALSE); // gst
		$this->buildSearchSql($where, $this->composition, $default, FALSE); // composition
		$this->buildSearchSql($where, $this->price_exchange, $default, FALSE); // price_exchange
		$this->buildSearchSql($where, $this->amount_exchange, $default, FALSE); // amount_exchange
		$this->buildSearchSql($where, $this->design_code, $default, FALSE); // design_code
		$this->buildSearchSql($where, $this->cbm, $default, FALSE); // cbm
		$this->buildSearchSql($where, $this->weight, $default, FALSE); // weight
		$this->buildSearchSql($where, $this->sqm_a, $default, FALSE); // sqm_a
		$this->buildSearchSql($where, $this->partner_other_ref, $default, FALSE); // partner_other_ref

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->pl_no->AdvancedSearch->save(); // pl_no
			$this->buyers_id->AdvancedSearch->save(); // buyers_id
			$this->_barcode->AdvancedSearch->save(); // barcode
			$this->roll_no_start->AdvancedSearch->save(); // roll_no_start
			$this->buyer_ref->AdvancedSearch->save(); // buyer_ref
			$this->buyer_code->AdvancedSearch->save(); // buyer_code
			$this->buyer_uid->AdvancedSearch->save(); // buyer_uid
			$this->partner_ref->AdvancedSearch->save(); // partner_ref
			$this->no_of_bales->AdvancedSearch->save(); // no_of_bales
			$this->buyer_po->AdvancedSearch->save(); // buyer_po
			$this->quantity->AdvancedSearch->save(); // quantity
			$this->size->AdvancedSearch->save(); // size
			$this->sqm->AdvancedSearch->save(); // sqm
			$this->amount->AdvancedSearch->save(); // amount
			$this->currency->AdvancedSearch->save(); // currency
			$this->price->AdvancedSearch->save(); // price
			$this->discount->AdvancedSearch->save(); // discount
			$this->hsn->AdvancedSearch->save(); // hsn
			$this->gst->AdvancedSearch->save(); // gst
			$this->composition->AdvancedSearch->save(); // composition
			$this->price_exchange->AdvancedSearch->save(); // price_exchange
			$this->amount_exchange->AdvancedSearch->save(); // amount_exchange
			$this->design_code->AdvancedSearch->save(); // design_code
			$this->cbm->AdvancedSearch->save(); // cbm
			$this->weight->AdvancedSearch->save(); // weight
			$this->sqm_a->AdvancedSearch->save(); // sqm_a
			$this->partner_other_ref->AdvancedSearch->save(); // partner_other_ref
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->buyers_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->design, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_ref, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_code, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_uid, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->partner_ref, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_po, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->size, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->hsn, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->composition, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->design_code, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->partner_other_ref, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pl_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyers_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_barcode->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->roll_no_start->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_ref->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_code->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_uid->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->partner_ref->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->no_of_bales->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_po->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->quantity->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->size->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sqm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->currency->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->price->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->discount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->hsn->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->gst->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->composition->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->price_exchange->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->amount_exchange->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->design_code->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cbm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->weight->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sqm_a->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->partner_other_ref->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->pl_no->AdvancedSearch->unsetSession();
		$this->buyers_id->AdvancedSearch->unsetSession();
		$this->_barcode->AdvancedSearch->unsetSession();
		$this->roll_no_start->AdvancedSearch->unsetSession();
		$this->buyer_ref->AdvancedSearch->unsetSession();
		$this->buyer_code->AdvancedSearch->unsetSession();
		$this->buyer_uid->AdvancedSearch->unsetSession();
		$this->partner_ref->AdvancedSearch->unsetSession();
		$this->no_of_bales->AdvancedSearch->unsetSession();
		$this->buyer_po->AdvancedSearch->unsetSession();
		$this->quantity->AdvancedSearch->unsetSession();
		$this->size->AdvancedSearch->unsetSession();
		$this->sqm->AdvancedSearch->unsetSession();
		$this->amount->AdvancedSearch->unsetSession();
		$this->currency->AdvancedSearch->unsetSession();
		$this->price->AdvancedSearch->unsetSession();
		$this->discount->AdvancedSearch->unsetSession();
		$this->hsn->AdvancedSearch->unsetSession();
		$this->gst->AdvancedSearch->unsetSession();
		$this->composition->AdvancedSearch->unsetSession();
		$this->price_exchange->AdvancedSearch->unsetSession();
		$this->amount_exchange->AdvancedSearch->unsetSession();
		$this->design_code->AdvancedSearch->unsetSession();
		$this->cbm->AdvancedSearch->unsetSession();
		$this->weight->AdvancedSearch->unsetSession();
		$this->sqm_a->AdvancedSearch->unsetSession();
		$this->partner_other_ref->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->pl_no->AdvancedSearch->load();
		$this->buyers_id->AdvancedSearch->load();
		$this->_barcode->AdvancedSearch->load();
		$this->roll_no_start->AdvancedSearch->load();
		$this->buyer_ref->AdvancedSearch->load();
		$this->buyer_code->AdvancedSearch->load();
		$this->buyer_uid->AdvancedSearch->load();
		$this->partner_ref->AdvancedSearch->load();
		$this->no_of_bales->AdvancedSearch->load();
		$this->buyer_po->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->size->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->currency->AdvancedSearch->load();
		$this->price->AdvancedSearch->load();
		$this->discount->AdvancedSearch->load();
		$this->hsn->AdvancedSearch->load();
		$this->gst->AdvancedSearch->load();
		$this->composition->AdvancedSearch->load();
		$this->price_exchange->AdvancedSearch->load();
		$this->amount_exchange->AdvancedSearch->load();
		$this->design_code->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->weight->AdvancedSearch->load();
		$this->sqm_a->AdvancedSearch->load();
		$this->partner_other_ref->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->pl_no, $ctrl); // pl_no
			$this->updateSort($this->buyers_id, $ctrl); // buyers_id
			$this->updateSort($this->_barcode, $ctrl); // barcode
			$this->updateSort($this->roll_no_start, $ctrl); // roll_no_start
			$this->updateSort($this->design, $ctrl); // design
			$this->updateSort($this->buyer_ref, $ctrl); // buyer_ref
			$this->updateSort($this->buyer_code, $ctrl); // buyer_code
			$this->updateSort($this->buyer_uid, $ctrl); // buyer_uid
			$this->updateSort($this->partner_ref, $ctrl); // partner_ref
			$this->updateSort($this->no_of_bales, $ctrl); // no_of_bales
			$this->updateSort($this->buyer_po, $ctrl); // buyer_po
			$this->updateSort($this->quantity, $ctrl); // quantity
			$this->updateSort($this->size, $ctrl); // size
			$this->updateSort($this->sqm, $ctrl); // sqm
			$this->updateSort($this->amount, $ctrl); // amount
			$this->updateSort($this->currency, $ctrl); // currency
			$this->updateSort($this->price, $ctrl); // price
			$this->updateSort($this->discount, $ctrl); // discount
			$this->updateSort($this->hsn, $ctrl); // hsn
			$this->updateSort($this->gst, $ctrl); // gst
			$this->updateSort($this->composition, $ctrl); // composition
			$this->updateSort($this->price_exchange, $ctrl); // price_exchange
			$this->updateSort($this->amount_exchange, $ctrl); // amount_exchange
			$this->updateSort($this->design_code, $ctrl); // design_code
			$this->updateSort($this->cbm, $ctrl); // cbm
			$this->updateSort($this->weight, $ctrl); // weight
			$this->updateSort($this->sqm_a, $ctrl); // sqm_a
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("ASC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
				$this->id->setSort("");
				$this->pl_no->setSort("");
				$this->buyers_id->setSort("");
				$this->_barcode->setSort("");
				$this->roll_no_start->setSort("");
				$this->design->setSort("");
				$this->buyer_ref->setSort("");
				$this->buyer_code->setSort("");
				$this->buyer_uid->setSort("");
				$this->partner_ref->setSort("");
				$this->no_of_bales->setSort("");
				$this->buyer_po->setSort("");
				$this->quantity->setSort("");
				$this->size->setSort("");
				$this->sqm->setSort("");
				$this->amount->setSort("");
				$this->currency->setSort("");
				$this->price->setSort("");
				$this->discount->setSort("");
				$this->hsn->setSort("");
				$this->gst->setSort("");
				$this->composition->setSort("");
				$this->price_exchange->setSort("");
				$this->amount_exchange->setSort("");
				$this->design_code->setSort("");
				$this->cbm->setSort("");
				$this->weight->setSort("");
				$this->sqm_a->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fpacking_list_tmplistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fpacking_list_tmplistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fpacking_list_tmplist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fpacking_list_tmplistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		$item->Body = "<a class=\"btn btn-default ew-advanced-aearch\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"packing_list_tmpsrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fpacking_list_tmplistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// pl_no
		if (!$this->isAddOrEdit())
			$this->pl_no->AdvancedSearch->setSearchValue(Get("x_pl_no", Get("pl_no", "")));
		if ($this->pl_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pl_no->AdvancedSearch->setSearchOperator(Get("z_pl_no", ""));

		// buyers_id
		if (!$this->isAddOrEdit())
			$this->buyers_id->AdvancedSearch->setSearchValue(Get("x_buyers_id", Get("buyers_id", "")));
		if ($this->buyers_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyers_id->AdvancedSearch->setSearchOperator(Get("z_buyers_id", ""));

		// barcode
		if (!$this->isAddOrEdit())
			$this->_barcode->AdvancedSearch->setSearchValue(Get("x__barcode", Get("_barcode", "")));
		if ($this->_barcode->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_barcode->AdvancedSearch->setSearchOperator(Get("z__barcode", ""));

		// roll_no_start
		if (!$this->isAddOrEdit())
			$this->roll_no_start->AdvancedSearch->setSearchValue(Get("x_roll_no_start", Get("roll_no_start", "")));
		if ($this->roll_no_start->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->roll_no_start->AdvancedSearch->setSearchOperator(Get("z_roll_no_start", ""));

		// buyer_ref
		if (!$this->isAddOrEdit())
			$this->buyer_ref->AdvancedSearch->setSearchValue(Get("x_buyer_ref", Get("buyer_ref", "")));
		if ($this->buyer_ref->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_ref->AdvancedSearch->setSearchOperator(Get("z_buyer_ref", ""));

		// buyer_code
		if (!$this->isAddOrEdit())
			$this->buyer_code->AdvancedSearch->setSearchValue(Get("x_buyer_code", Get("buyer_code", "")));
		if ($this->buyer_code->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_code->AdvancedSearch->setSearchOperator(Get("z_buyer_code", ""));

		// buyer_uid
		if (!$this->isAddOrEdit())
			$this->buyer_uid->AdvancedSearch->setSearchValue(Get("x_buyer_uid", Get("buyer_uid", "")));
		if ($this->buyer_uid->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_uid->AdvancedSearch->setSearchOperator(Get("z_buyer_uid", ""));

		// partner_ref
		if (!$this->isAddOrEdit())
			$this->partner_ref->AdvancedSearch->setSearchValue(Get("x_partner_ref", Get("partner_ref", "")));
		if ($this->partner_ref->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->partner_ref->AdvancedSearch->setSearchOperator(Get("z_partner_ref", ""));

		// no_of_bales
		if (!$this->isAddOrEdit())
			$this->no_of_bales->AdvancedSearch->setSearchValue(Get("x_no_of_bales", Get("no_of_bales", "")));
		if ($this->no_of_bales->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->no_of_bales->AdvancedSearch->setSearchOperator(Get("z_no_of_bales", ""));

		// buyer_po
		if (!$this->isAddOrEdit())
			$this->buyer_po->AdvancedSearch->setSearchValue(Get("x_buyer_po", Get("buyer_po", "")));
		if ($this->buyer_po->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_po->AdvancedSearch->setSearchOperator(Get("z_buyer_po", ""));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue(Get("x_quantity", Get("quantity", "")));
		if ($this->quantity->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->quantity->AdvancedSearch->setSearchOperator(Get("z_quantity", ""));

		// size
		if (!$this->isAddOrEdit())
			$this->size->AdvancedSearch->setSearchValue(Get("x_size", Get("size", "")));
		if ($this->size->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->size->AdvancedSearch->setSearchOperator(Get("z_size", ""));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue(Get("x_sqm", Get("sqm", "")));
		if ($this->sqm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sqm->AdvancedSearch->setSearchOperator(Get("z_sqm", ""));

		// amount
		if (!$this->isAddOrEdit())
			$this->amount->AdvancedSearch->setSearchValue(Get("x_amount", Get("amount", "")));
		if ($this->amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->amount->AdvancedSearch->setSearchOperator(Get("z_amount", ""));

		// currency
		if (!$this->isAddOrEdit())
			$this->currency->AdvancedSearch->setSearchValue(Get("x_currency", Get("currency", "")));
		if ($this->currency->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->currency->AdvancedSearch->setSearchOperator(Get("z_currency", ""));

		// price
		if (!$this->isAddOrEdit())
			$this->price->AdvancedSearch->setSearchValue(Get("x_price", Get("price", "")));
		if ($this->price->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->price->AdvancedSearch->setSearchOperator(Get("z_price", ""));

		// discount
		if (!$this->isAddOrEdit())
			$this->discount->AdvancedSearch->setSearchValue(Get("x_discount", Get("discount", "")));
		if ($this->discount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->discount->AdvancedSearch->setSearchOperator(Get("z_discount", ""));

		// hsn
		if (!$this->isAddOrEdit())
			$this->hsn->AdvancedSearch->setSearchValue(Get("x_hsn", Get("hsn", "")));
		if ($this->hsn->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->hsn->AdvancedSearch->setSearchOperator(Get("z_hsn", ""));

		// gst
		if (!$this->isAddOrEdit())
			$this->gst->AdvancedSearch->setSearchValue(Get("x_gst", Get("gst", "")));
		if ($this->gst->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->gst->AdvancedSearch->setSearchOperator(Get("z_gst", ""));

		// composition
		if (!$this->isAddOrEdit())
			$this->composition->AdvancedSearch->setSearchValue(Get("x_composition", Get("composition", "")));
		if ($this->composition->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->composition->AdvancedSearch->setSearchOperator(Get("z_composition", ""));

		// price_exchange
		if (!$this->isAddOrEdit())
			$this->price_exchange->AdvancedSearch->setSearchValue(Get("x_price_exchange", Get("price_exchange", "")));
		if ($this->price_exchange->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->price_exchange->AdvancedSearch->setSearchOperator(Get("z_price_exchange", ""));

		// amount_exchange
		if (!$this->isAddOrEdit())
			$this->amount_exchange->AdvancedSearch->setSearchValue(Get("x_amount_exchange", Get("amount_exchange", "")));
		if ($this->amount_exchange->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->amount_exchange->AdvancedSearch->setSearchOperator(Get("z_amount_exchange", ""));

		// design_code
		if (!$this->isAddOrEdit())
			$this->design_code->AdvancedSearch->setSearchValue(Get("x_design_code", Get("design_code", "")));
		if ($this->design_code->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->design_code->AdvancedSearch->setSearchOperator(Get("z_design_code", ""));

		// cbm
		if (!$this->isAddOrEdit())
			$this->cbm->AdvancedSearch->setSearchValue(Get("x_cbm", Get("cbm", "")));
		if ($this->cbm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cbm->AdvancedSearch->setSearchOperator(Get("z_cbm", ""));

		// weight
		if (!$this->isAddOrEdit())
			$this->weight->AdvancedSearch->setSearchValue(Get("x_weight", Get("weight", "")));
		if ($this->weight->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->weight->AdvancedSearch->setSearchOperator(Get("z_weight", ""));

		// sqm_a
		if (!$this->isAddOrEdit())
			$this->sqm_a->AdvancedSearch->setSearchValue(Get("x_sqm_a", Get("sqm_a", "")));
		if ($this->sqm_a->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sqm_a->AdvancedSearch->setSearchOperator(Get("z_sqm_a", ""));

		// partner_other_ref
		if (!$this->isAddOrEdit())
			$this->partner_other_ref->AdvancedSearch->setSearchValue(Get("x_partner_other_ref", Get("partner_other_ref", "")));
		if ($this->partner_other_ref->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->partner_other_ref->AdvancedSearch->setSearchOperator(Get("z_partner_other_ref", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->pl_no->setDbValue($row['pl_no']);
		$this->buyers_id->setDbValue($row['buyers_id']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->roll_no_start->setDbValue($row['roll_no_start']);
		$this->design->setDbValue($row['design']);
		$this->buyer_ref->setDbValue($row['buyer_ref']);
		if (array_key_exists('EV__buyer_ref', $rs->fields)) {
			$this->buyer_ref->VirtualValue = $rs->fields('EV__buyer_ref'); // Set up virtual field value
		} else {
			$this->buyer_ref->VirtualValue = ""; // Clear value
		}
		$this->buyer_code->setDbValue($row['buyer_code']);
		$this->buyer_uid->setDbValue($row['buyer_uid']);
		$this->partner_ref->setDbValue($row['partner_ref']);
		$this->no_of_bales->setDbValue($row['no_of_bales']);
		$this->buyer_po->setDbValue($row['buyer_po']);
		$this->quantity->setDbValue($row['quantity']);
		$this->size->setDbValue($row['size']);
		$this->sqm->setDbValue($row['sqm']);
		$this->amount->setDbValue($row['amount']);
		$this->currency->setDbValue($row['currency']);
		$this->price->setDbValue($row['price']);
		$this->discount->setDbValue($row['discount']);
		$this->hsn->setDbValue($row['hsn']);
		$this->gst->setDbValue($row['gst']);
		$this->composition->setDbValue($row['composition']);
		$this->price_exchange->setDbValue($row['price_exchange']);
		$this->amount_exchange->setDbValue($row['amount_exchange']);
		$this->roll_no->setDbValue($row['roll_no']);
		$this->roll_no_end->setDbValue($row['roll_no_end']);
		$this->design_code->setDbValue($row['design_code']);
		$this->cbm->setDbValue($row['cbm']);
		$this->weight->setDbValue($row['weight']);
		$this->sqm_a->setDbValue($row['sqm_a']);
		$this->partner_other_ref->setDbValue($row['partner_other_ref']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['pl_no'] = NULL;
		$row['buyers_id'] = NULL;
		$row['barcode'] = NULL;
		$row['roll_no_start'] = NULL;
		$row['design'] = NULL;
		$row['buyer_ref'] = NULL;
		$row['buyer_code'] = NULL;
		$row['buyer_uid'] = NULL;
		$row['partner_ref'] = NULL;
		$row['no_of_bales'] = NULL;
		$row['buyer_po'] = NULL;
		$row['quantity'] = NULL;
		$row['size'] = NULL;
		$row['sqm'] = NULL;
		$row['amount'] = NULL;
		$row['currency'] = NULL;
		$row['price'] = NULL;
		$row['discount'] = NULL;
		$row['hsn'] = NULL;
		$row['gst'] = NULL;
		$row['composition'] = NULL;
		$row['price_exchange'] = NULL;
		$row['amount_exchange'] = NULL;
		$row['roll_no'] = NULL;
		$row['roll_no_end'] = NULL;
		$row['design_code'] = NULL;
		$row['cbm'] = NULL;
		$row['weight'] = NULL;
		$row['sqm_a'] = NULL;
		$row['partner_other_ref'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->pl_no->FormValue == $this->pl_no->CurrentValue && is_numeric(ConvertToFloatString($this->pl_no->CurrentValue)))
			$this->pl_no->CurrentValue = ConvertToFloatString($this->pl_no->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->discount->FormValue == $this->discount->CurrentValue && is_numeric(ConvertToFloatString($this->discount->CurrentValue)))
			$this->discount->CurrentValue = ConvertToFloatString($this->discount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->gst->FormValue == $this->gst->CurrentValue && is_numeric(ConvertToFloatString($this->gst->CurrentValue)))
			$this->gst->CurrentValue = ConvertToFloatString($this->gst->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price_exchange->FormValue == $this->price_exchange->CurrentValue && is_numeric(ConvertToFloatString($this->price_exchange->CurrentValue)))
			$this->price_exchange->CurrentValue = ConvertToFloatString($this->price_exchange->CurrentValue);

		// Convert decimal values if posted back
		if ($this->amount_exchange->FormValue == $this->amount_exchange->CurrentValue && is_numeric(ConvertToFloatString($this->amount_exchange->CurrentValue)))
			$this->amount_exchange->CurrentValue = ConvertToFloatString($this->amount_exchange->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cbm->FormValue == $this->cbm->CurrentValue && is_numeric(ConvertToFloatString($this->cbm->CurrentValue)))
			$this->cbm->CurrentValue = ConvertToFloatString($this->cbm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->weight->FormValue == $this->weight->CurrentValue && is_numeric(ConvertToFloatString($this->weight->CurrentValue)))
			$this->weight->CurrentValue = ConvertToFloatString($this->weight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm_a->FormValue == $this->sqm_a->CurrentValue && is_numeric(ConvertToFloatString($this->sqm_a->CurrentValue)))
			$this->sqm_a->CurrentValue = ConvertToFloatString($this->sqm_a->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// pl_no
		// buyers_id
		// barcode
		// roll_no_start
		// design

		$this->design->CellCssStyle = "white-space: nowrap;";

		// buyer_ref
		// buyer_code
		// buyer_uid
		// partner_ref
		// no_of_bales
		// buyer_po
		// quantity
		// size
		// sqm
		// amount
		// currency
		// price
		// discount
		// hsn
		// gst
		// composition
		// price_exchange
		// amount_exchange
		// roll_no

		$this->roll_no->CellCssStyle = "white-space: nowrap;";

		// roll_no_end
		$this->roll_no_end->CellCssStyle = "white-space: nowrap;";

		// design_code
		// cbm
		// weight
		// sqm_a
		// partner_other_ref
		// Accumulate aggregate value

		if ($this->RowType <> ROWTYPE_AGGREGATEINIT && $this->RowType <> ROWTYPE_AGGREGATE) {
			$this->_barcode->Count++; // Increment count
			if (is_numeric($this->quantity->CurrentValue))
				$this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
			if (is_numeric($this->sqm->CurrentValue))
				$this->sqm->Total += $this->sqm->CurrentValue; // Accumulate total
			if (is_numeric($this->amount->CurrentValue))
				$this->amount->Total += $this->amount->CurrentValue; // Accumulate total
		}
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// pl_no
			$this->pl_no->ViewValue = $this->pl_no->CurrentValue;
			$this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, 2, -2, -2, -2);
			$this->pl_no->ViewCustomAttributes = "";

			// buyers_id
			$curVal = strval($this->buyers_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
				if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 1000 and `grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
					}
				}
			} else {
				$this->buyers_id->ViewValue = NULL;
			}
			$this->buyers_id->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
			$this->_barcode->ViewCustomAttributes = "";

			// roll_no_start
			$this->roll_no_start->ViewValue = $this->roll_no_start->CurrentValue;
			$this->roll_no_start->ViewValue = FormatNumber($this->roll_no_start->ViewValue, 0, -2, -2, -2);
			$this->roll_no_start->ViewCustomAttributes = "";

			// design
			$this->design->ViewValue = $this->design->CurrentValue;
			$curVal = strval($this->design->CurrentValue);
			if ($curVal <> "") {
				$this->design->ViewValue = $this->design->lookupCacheOption($curVal);
				if ($this->design->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->design->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->design->ViewValue = $this->design->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->design->ViewValue = $this->design->CurrentValue;
					}
				}
			} else {
				$this->design->ViewValue = NULL;
			}
			$this->design->ViewCustomAttributes = "";

			// buyer_ref
			if ($this->buyer_ref->VirtualValue <> "") {
				$this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
			} else {
			$curVal = strval($this->buyer_ref->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
				if ($this->buyer_ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
					}
				}
			} else {
				$this->buyer_ref->ViewValue = NULL;
			}
			}
			$this->buyer_ref->ViewCustomAttributes = "";

			// buyer_code
			$this->buyer_code->ViewValue = $this->buyer_code->CurrentValue;
			$this->buyer_code->ViewCustomAttributes = "";

			// buyer_uid
			$this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;
			$this->buyer_uid->ViewCustomAttributes = "";

			// partner_ref
			$this->partner_ref->ViewValue = $this->partner_ref->CurrentValue;
			$this->partner_ref->ViewCustomAttributes = "";

			// no_of_bales
			$this->no_of_bales->ViewValue = $this->no_of_bales->CurrentValue;
			$this->no_of_bales->ViewValue = FormatNumber($this->no_of_bales->ViewValue, 0, -2, -2, -2);
			$this->no_of_bales->ViewCustomAttributes = "";

			// buyer_po
			$this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;
			$this->buyer_po->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// size
			$this->size->ViewValue = $this->size->CurrentValue;
			$this->size->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// discount
			$this->discount->ViewValue = $this->discount->CurrentValue;
			$this->discount->ViewValue = FormatNumber($this->discount->ViewValue, 2, -2, -2, -2);
			$this->discount->ViewCustomAttributes = "";

			// hsn
			$this->hsn->ViewValue = $this->hsn->CurrentValue;
			$this->hsn->ViewCustomAttributes = "";

			// gst
			$this->gst->ViewValue = $this->gst->CurrentValue;
			$this->gst->ViewValue = FormatNumber($this->gst->ViewValue, 2, -2, -2, -2);
			$this->gst->ViewCustomAttributes = "";

			// composition
			$this->composition->ViewValue = $this->composition->CurrentValue;
			$this->composition->ViewCustomAttributes = "";

			// price_exchange
			$this->price_exchange->ViewValue = $this->price_exchange->CurrentValue;
			$this->price_exchange->ViewValue = FormatNumber($this->price_exchange->ViewValue, 2, -2, -2, -2);
			$this->price_exchange->ViewCustomAttributes = "";

			// amount_exchange
			$this->amount_exchange->ViewValue = $this->amount_exchange->CurrentValue;
			$this->amount_exchange->ViewValue = FormatNumber($this->amount_exchange->ViewValue, 2, -2, -2, -2);
			$this->amount_exchange->ViewCustomAttributes = "";

			// design_code
			$this->design_code->ViewValue = $this->design_code->CurrentValue;
			$this->design_code->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 2, -2, -2, -2);
			$this->cbm->ViewCustomAttributes = "";

			// weight
			$this->weight->ViewValue = $this->weight->CurrentValue;
			$this->weight->ViewValue = FormatNumber($this->weight->ViewValue, 2, -2, -2, -2);
			$this->weight->ViewCustomAttributes = "";

			// sqm_a
			$this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
			$this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, 2, -2, -2, -2);
			$this->sqm_a->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// pl_no
			$this->pl_no->LinkCustomAttributes = "";
			$this->pl_no->HrefValue = "";
			$this->pl_no->TooltipValue = "";

			// buyers_id
			$this->buyers_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyers_id->CurrentValue)) {
				$this->buyers_id->HrefValue = "bcodelist.php?x_buyers_id=" . $this->buyers_id->CurrentValue; // Add prefix/suffix
				$this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
			} else {
				$this->buyers_id->HrefValue = "";
			}
			$this->buyers_id->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// roll_no_start
			$this->roll_no_start->LinkCustomAttributes = "";
			$this->roll_no_start->HrefValue = "";
			$this->roll_no_start->TooltipValue = "";

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";
			$this->design->TooltipValue = "";

			// buyer_ref
			$this->buyer_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyer_ref->CurrentValue)) {
				$this->buyer_ref->HrefValue = "bcodelist.php?x_buyer_ref=" . $this->buyer_ref->CurrentValue; // Add prefix/suffix
				$this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
			} else {
				$this->buyer_ref->HrefValue = "";
			}
			$this->buyer_ref->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer_ref->ViewValue = $this->highlightValue($this->buyer_ref);

			// buyer_code
			$this->buyer_code->LinkCustomAttributes = "";
			$this->buyer_code->HrefValue = "";
			$this->buyer_code->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer_code->ViewValue = $this->highlightValue($this->buyer_code);

			// buyer_uid
			$this->buyer_uid->LinkCustomAttributes = "";
			$this->buyer_uid->HrefValue = "";
			$this->buyer_uid->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer_uid->ViewValue = $this->highlightValue($this->buyer_uid);

			// partner_ref
			$this->partner_ref->LinkCustomAttributes = "";
			$this->partner_ref->HrefValue = "";
			$this->partner_ref->TooltipValue = "";
			if (!$this->isExport())
				$this->partner_ref->ViewValue = $this->highlightValue($this->partner_ref);

			// no_of_bales
			$this->no_of_bales->LinkCustomAttributes = "";
			$this->no_of_bales->HrefValue = "";
			$this->no_of_bales->TooltipValue = "";

			// buyer_po
			$this->buyer_po->LinkCustomAttributes = "";
			$this->buyer_po->HrefValue = "";
			$this->buyer_po->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer_po->ViewValue = $this->highlightValue($this->buyer_po);

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";
			if (!$this->isExport())
				$this->size->ViewValue = $this->highlightValue($this->size);

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";
			$this->currency->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// discount
			$this->discount->LinkCustomAttributes = "";
			$this->discount->HrefValue = "";
			$this->discount->TooltipValue = "";

			// hsn
			$this->hsn->LinkCustomAttributes = "";
			$this->hsn->HrefValue = "";
			$this->hsn->TooltipValue = "";
			if (!$this->isExport())
				$this->hsn->ViewValue = $this->highlightValue($this->hsn);

			// gst
			$this->gst->LinkCustomAttributes = "";
			$this->gst->HrefValue = "";
			$this->gst->TooltipValue = "";

			// composition
			$this->composition->LinkCustomAttributes = "";
			$this->composition->HrefValue = "";
			$this->composition->TooltipValue = "";
			if (!$this->isExport())
				$this->composition->ViewValue = $this->highlightValue($this->composition);

			// price_exchange
			$this->price_exchange->LinkCustomAttributes = "";
			$this->price_exchange->HrefValue = "";
			$this->price_exchange->TooltipValue = "";

			// amount_exchange
			$this->amount_exchange->LinkCustomAttributes = "";
			$this->amount_exchange->HrefValue = "";
			$this->amount_exchange->TooltipValue = "";

			// design_code
			$this->design_code->LinkCustomAttributes = "";
			$this->design_code->HrefValue = "";
			$this->design_code->TooltipValue = "";
			if (!$this->isExport())
				$this->design_code->ViewValue = $this->highlightValue($this->design_code);

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// weight
			$this->weight->LinkCustomAttributes = "";
			$this->weight->HrefValue = "";
			$this->weight->TooltipValue = "";

			// sqm_a
			$this->sqm_a->LinkCustomAttributes = "";
			$this->sqm_a->HrefValue = "";
			$this->sqm_a->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->_barcode->Count = 0; // Initialize count
			$this->quantity->Total = 0; // Initialize total
			$this->sqm->Total = 0; // Initialize total
			$this->amount->Total = 0; // Initialize total
		} elseif ($this->RowType == ROWTYPE_AGGREGATE) { // Aggregate row
			$this->_barcode->CurrentValue = $this->_barcode->Count;
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
			$this->_barcode->ViewCustomAttributes = "";
			$this->_barcode->HrefValue = ""; // Clear href value
			$this->quantity->CurrentValue = $this->quantity->Total;
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";
			$this->quantity->HrefValue = ""; // Clear href value
			$this->sqm->CurrentValue = $this->sqm->Total;
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";
			$this->sqm->HrefValue = ""; // Clear href value
			$this->amount->CurrentValue = $this->amount->Total;
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";
			$this->amount->HrefValue = ""; // Clear href value
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->pl_no->AdvancedSearch->load();
		$this->buyers_id->AdvancedSearch->load();
		$this->_barcode->AdvancedSearch->load();
		$this->roll_no_start->AdvancedSearch->load();
		$this->buyer_ref->AdvancedSearch->load();
		$this->buyer_code->AdvancedSearch->load();
		$this->buyer_uid->AdvancedSearch->load();
		$this->partner_ref->AdvancedSearch->load();
		$this->no_of_bales->AdvancedSearch->load();
		$this->buyer_po->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->size->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->currency->AdvancedSearch->load();
		$this->price->AdvancedSearch->load();
		$this->discount->AdvancedSearch->load();
		$this->hsn->AdvancedSearch->load();
		$this->gst->AdvancedSearch->load();
		$this->composition->AdvancedSearch->load();
		$this->price_exchange->AdvancedSearch->load();
		$this->amount_exchange->AdvancedSearch->load();
		$this->design_code->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->weight->AdvancedSearch->load();
		$this->sqm_a->AdvancedSearch->load();
		$this->partner_other_ref->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fpacking_list_tmplist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fpacking_list_tmplist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fpacking_list_tmplist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_packing_list_tmp\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_packing_list_tmp',hdr:ew.language.phrase('ExportToEmailText'),f:document.fpacking_list_tmplist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_buyers_id":
					$lookupFilter = function() {
						return "`id` > 1000 and `grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_design":
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyers_id":
							break;
						case "x_design":
							break;
						case "x_buyer_ref":
							break;
						case "x_currency":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>