<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for partner_balance
 */
class partner_balance extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $location;
	public $partner_id;
	public $balance;
	public $receipt;
	public $panel_amount;
	public $total_amount;
	public $ref;
	public $partner_name;
	public $url;
	public $url_mog;
	public $url_r_list;
	public $dated;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'partner_balance';
		$this->TableName = 'partner_balance';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`partner_balance`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// location
		$this->location = new DbField('partner_balance', 'partner_balance', 'x_location', 'location', '`location`', '`location`', 19, -1, FALSE, '`location`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->location->IsForeignKey = TRUE; // Foreign key field
		$this->location->Sortable = TRUE; // Allow sort
		$this->location->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->location->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->location->Lookup = new Lookup('location', 'godown', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->location->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['location'] = &$this->location;

		// partner_id
		$this->partner_id = new DbField('partner_balance', 'partner_balance', 'x_partner_id', 'partner_id', '`partner_id`', '`partner_id`', 19, -1, FALSE, '`partner_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_id->IsForeignKey = TRUE; // Foreign key field
		$this->partner_id->Required = TRUE; // Required field
		$this->partner_id->Sortable = TRUE; // Allow sort
		$this->partner_id->Lookup = new Lookup('partner_id', 'buyer', FALSE, 'id', ["name","mobile","",""], [], ["x_ref"], [], [], [], [], '`name` ASC', '');
		$this->partner_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['partner_id'] = &$this->partner_id;

		// balance
		$this->balance = new DbField('partner_balance', 'partner_balance', 'x_balance', 'balance', '`balance`', '`balance`', 20, -1, FALSE, '`balance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->balance->Sortable = TRUE; // Allow sort
		$this->balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['balance'] = &$this->balance;

		// receipt
		$this->receipt = new DbField('partner_balance', 'partner_balance', 'x_receipt', 'receipt', '`receipt`', '`receipt`', 20, -1, FALSE, '`receipt`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->receipt->Required = TRUE; // Required field
		$this->receipt->Sortable = TRUE; // Allow sort
		$this->receipt->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['receipt'] = &$this->receipt;

		// panel_amount
		$this->panel_amount = new DbField('partner_balance', 'partner_balance', 'x_panel_amount', 'panel_amount', '`panel_amount`', '`panel_amount`', 20, -1, FALSE, '`panel_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->panel_amount->Sortable = TRUE; // Allow sort
		$this->panel_amount->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['panel_amount'] = &$this->panel_amount;

		// total_amount
		$this->total_amount = new DbField('partner_balance', 'partner_balance', 'x_total_amount', 'total_amount', '`total_amount`', '`total_amount`', 20, -1, FALSE, '`total_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->total_amount->Sortable = TRUE; // Allow sort
		$this->total_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['total_amount'] = &$this->total_amount;

		// ref
		$this->ref = new DbField('partner_balance', 'partner_balance', 'x_ref', 'ref', '`ref`', '`ref`', 200, -1, FALSE, '`ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->ref->Sortable = TRUE; // Allow sort
		$this->ref->Lookup = new Lookup('ref', 'partner_balance', FALSE, 'ref', ["ref","balance","",""], ["x_partner_id"], [], ["partner_id"], ["x_partner_id"], [], [], '`ref` ASC', '');
		$this->fields['ref'] = &$this->ref;

		// partner_name
		$this->partner_name = new DbField('partner_balance', 'partner_balance', 'x_partner_name', 'partner_name', '`partner_name`', '`partner_name`', 200, -1, FALSE, '`partner_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_name->Sortable = FALSE; // Allow sort
		$this->fields['partner_name'] = &$this->partner_name;

		// url
		$this->url = new DbField('partner_balance', 'partner_balance', 'x_url', 'url', 'concat(\'receiptadd.php?location=\',`location`,\'&partner=\',`partner_id`,\'&oid=\',`ref`,\'&balance=\',`balance`)', 'concat(\'receiptadd.php?location=\',`location`,\'&partner=\',`partner_id`,\'&oid=\',`ref`,\'&balance=\',`balance`)', 200, -1, FALSE, 'concat(\'receiptadd.php?location=\',`location`,\'&partner=\',`partner_id`,\'&oid=\',`ref`,\'&balance=\',`balance`)', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->url->IsCustom = TRUE; // Custom field
		$this->url->Sortable = FALSE; // Allow sort
		$this->fields['url'] = &$this->url;

		// url_mog
		$this->url_mog = new DbField('partner_balance', 'partner_balance', 'x_url_mog', 'url_mog', 'concat(\'material_outlist.php?x_cart_ref=\',`ref`,\'&x_issue_to=\',`partner_id`)', 'concat(\'material_outlist.php?x_cart_ref=\',`ref`,\'&x_issue_to=\',`partner_id`)', 200, -1, FALSE, 'concat(\'material_outlist.php?x_cart_ref=\',`ref`,\'&x_issue_to=\',`partner_id`)', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->url_mog->IsCustom = TRUE; // Custom field
		$this->url_mog->Sortable = FALSE; // Allow sort
		$this->fields['url_mog'] = &$this->url_mog;

		// url_r_list
		$this->url_r_list = new DbField('partner_balance', 'partner_balance', 'x_url_r_list', 'url_r_list', 'concat(\'receiptlist.php?x_location=\',`location`,\'&x_partner_id=\',`partner_id`,\'&x_order_id=\',`ref`)', 'concat(\'receiptlist.php?x_location=\',`location`,\'&x_partner_id=\',`partner_id`,\'&x_order_id=\',`ref`)', 200, -1, FALSE, 'concat(\'receiptlist.php?x_location=\',`location`,\'&x_partner_id=\',`partner_id`,\'&x_order_id=\',`ref`)', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->url_r_list->IsCustom = TRUE; // Custom field
		$this->url_r_list->Sortable = FALSE; // Allow sort
		$this->fields['url_r_list'] = &$this->url_r_list;

		// dated
		$this->dated = new DbField('partner_balance', 'partner_balance', 'x_dated', 'dated', '`dated`', CastDateFieldForLike('`dated`', 0, "DB"), 135, 0, FALSE, '`dated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dated->Sortable = TRUE; // Allow sort
		$this->dated->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dated'] = &$this->dated;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "partner_balance_compiled") {
			if ($this->partner_id->getSessionValue() <> "")
				$masterFilter .= "`partner_id`=" . QuotedValue($this->partner_id->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
			if ($this->location->getSessionValue() <> "")
				$masterFilter .= " AND `location`=" . QuotedValue($this->location->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "partner_balance_compiled") {
			if ($this->partner_id->getSessionValue() <> "")
				$detailFilter .= "`partner_id`=" . QuotedValue($this->partner_id->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
			if ($this->location->getSessionValue() <> "")
				$detailFilter .= " AND `location`=" . QuotedValue($this->location->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_partner_balance_compiled()
	{
		return "`partner_id`=@partner_id@ AND `location`=@location@";
	}

	// Detail filter
	public function sqlDetailFilter_partner_balance_compiled()
	{
		return "`partner_id`=@partner_id@ AND `location`=@location@";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`partner_balance`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, concat('receiptadd.php?location=',`location`,'&partner=',`partner_id`,'&oid=',`ref`,'&balance=',`balance`) AS `url`, concat('material_outlist.php?x_cart_ref=',`ref`,'&x_issue_to=',`partner_id`) AS `url_mog`, concat('receiptlist.php?x_location=',`location`,'&x_partner_id=',`partner_id`,'&x_order_id=',`ref`) AS `url_r_list` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (User_Site() == 0) ? "" : "FIND_IN_SET(`location`,". User_Site() .")";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`ref` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->location->DbValue = $row['location'];
		$this->partner_id->DbValue = $row['partner_id'];
		$this->balance->DbValue = $row['balance'];
		$this->receipt->DbValue = $row['receipt'];
		$this->panel_amount->DbValue = $row['panel_amount'];
		$this->total_amount->DbValue = $row['total_amount'];
		$this->ref->DbValue = $row['ref'];
		$this->partner_name->DbValue = $row['partner_name'];
		$this->url->DbValue = $row['url'];
		$this->url_mog->DbValue = $row['url_mog'];
		$this->url_r_list->DbValue = $row['url_r_list'];
		$this->dated->DbValue = $row['dated'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "partner_balancelist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "partner_balanceview.php")
			return $Language->phrase("View");
		elseif ($pageName == "partner_balanceedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "partner_balanceadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "partner_balancelist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("partner_balanceview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("partner_balanceview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "partner_balanceadd.php?" . $this->getUrlParm($parm);
		else
			$url = "partner_balanceadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("partner_balanceedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("partner_balanceadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("partner_balancedelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "partner_balance_compiled" && !ContainsString($url, TABLE_SHOW_MASTER . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . TABLE_SHOW_MASTER . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_partner_id=" . urlencode($this->partner_id->CurrentValue);
			$url .= "&fk_location=" . urlencode($this->location->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->location->setDbValue($rs->fields('location'));
		$this->partner_id->setDbValue($rs->fields('partner_id'));
		$this->balance->setDbValue($rs->fields('balance'));
		$this->receipt->setDbValue($rs->fields('receipt'));
		$this->panel_amount->setDbValue($rs->fields('panel_amount'));
		$this->total_amount->setDbValue($rs->fields('total_amount'));
		$this->ref->setDbValue($rs->fields('ref'));
		$this->partner_name->setDbValue($rs->fields('partner_name'));
		$this->url->setDbValue($rs->fields('url'));
		$this->url_mog->setDbValue($rs->fields('url_mog'));
		$this->url_r_list->setDbValue($rs->fields('url_r_list'));
		$this->dated->setDbValue($rs->fields('dated'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// location
		// partner_id
		// balance
		// receipt
		// panel_amount
		// total_amount
		// ref
		// partner_name

		$this->partner_name->CellCssStyle = "white-space: nowrap;";

		// url
		$this->url->CellCssStyle = "white-space: nowrap;";

		// url_mog
		$this->url_mog->CellCssStyle = "white-space: nowrap;";

		// url_r_list
		$this->url_r_list->CellCssStyle = "white-space: nowrap;";

		// dated
		// location

		$curVal = strval($this->location->CurrentValue);
		if ($curVal <> "") {
			$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
			if ($this->location->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->location->ViewValue = $this->location->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->location->ViewValue = $this->location->CurrentValue;
				}
			}
		} else {
			$this->location->ViewValue = NULL;
		}
		$this->location->ViewCustomAttributes = "";

		// partner_id
		$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
		$curVal = strval($this->partner_id->CurrentValue);
		if ($curVal <> "") {
			$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
			if ($this->partner_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
				}
			}
		} else {
			$this->partner_id->ViewValue = NULL;
		}
		$this->partner_id->ViewCustomAttributes = "";

		// balance
		$this->balance->ViewValue = $this->balance->CurrentValue;
		$this->balance->ViewValue = FormatNumber($this->balance->ViewValue, 2, -2, -2, -2);
		$this->balance->ViewCustomAttributes = "";

		// receipt
		$this->receipt->ViewValue = $this->receipt->CurrentValue;
		$this->receipt->ViewValue = FormatNumber($this->receipt->ViewValue, 2, -2, -2, -2);
		$this->receipt->ViewCustomAttributes = "";

		// panel_amount
		$this->panel_amount->ViewValue = $this->panel_amount->CurrentValue;
		$this->panel_amount->ViewValue = FormatNumber($this->panel_amount->ViewValue, 0, -2, -2, -2);
		$this->panel_amount->ViewCustomAttributes = "";

		// total_amount
		$this->total_amount->ViewValue = $this->total_amount->CurrentValue;
		$this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, 2, -2, -2, -2);
		$this->total_amount->ViewCustomAttributes = "";

		// ref
		$arwrk = array();
		$arwrk[1] = $this->ref->CurrentValue;
		$arwrk[2] = FormatNumber($this->balance->CurrentValue, 2, -2, -2, -2);
		$this->ref->ViewValue = $this->ref->displayValue($arwrk);
		$this->ref->ViewCustomAttributes = "";

		// partner_name
		$this->partner_name->ViewValue = $this->partner_name->CurrentValue;
		$this->partner_name->ViewCustomAttributes = "";

		// url
		$this->url->ViewValue = $this->url->CurrentValue;
		$this->url->ViewCustomAttributes = "";

		// url_mog
		$this->url_mog->ViewValue = $this->url_mog->CurrentValue;
		$this->url_mog->ViewCustomAttributes = "";

		// url_r_list
		$this->url_r_list->ViewValue = $this->url_r_list->CurrentValue;
		$this->url_r_list->ViewCustomAttributes = "";

		// dated
		$this->dated->ViewValue = $this->dated->CurrentValue;
		$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
		$this->dated->ViewCustomAttributes = "";

		// location
		$this->location->LinkCustomAttributes = "";
		if (!EmptyValue($this->location->CurrentValue)) {
			$this->location->HrefValue = "partner_balancelist.php?x_location=" . $this->location->CurrentValue; // Add prefix/suffix
			$this->location->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->location->HrefValue = FullUrl($this->location->HrefValue, "href");
		} else {
			$this->location->HrefValue = "";
		}
		$this->location->TooltipValue = "";

		// partner_id
		$this->partner_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->partner_id->CurrentValue)) {
			$this->partner_id->HrefValue = "partner_balancelist.php?x_partner_id=" . $this->partner_id->CurrentValue; // Add prefix/suffix
			$this->partner_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
		} else {
			$this->partner_id->HrefValue = "";
		}
		$this->partner_id->TooltipValue = "";

		// balance
		$this->balance->LinkCustomAttributes = "";
		if (!EmptyValue($this->url->CurrentValue)) {
			$this->balance->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
			$this->balance->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->balance->HrefValue = FullUrl($this->balance->HrefValue, "href");
		} else {
			$this->balance->HrefValue = "";
		}
		$this->balance->TooltipValue = "";

		// receipt
		$this->receipt->LinkCustomAttributes = "";
		if (!EmptyValue($this->url->CurrentValue)) {
			$this->receipt->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
			$this->receipt->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->receipt->HrefValue = FullUrl($this->receipt->HrefValue, "href");
		} else {
			$this->receipt->HrefValue = "";
		}
		$this->receipt->TooltipValue = "";

		// panel_amount
		$this->panel_amount->LinkCustomAttributes = "";
		$this->panel_amount->HrefValue = "";
		$this->panel_amount->TooltipValue = "";

		// total_amount
		$this->total_amount->LinkCustomAttributes = "";
		if (!EmptyValue($this->url_mog->CurrentValue)) {
			$this->total_amount->HrefValue = $this->url_mog->CurrentValue; // Add prefix/suffix
			$this->total_amount->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->total_amount->HrefValue = FullUrl($this->total_amount->HrefValue, "href");
		} else {
			$this->total_amount->HrefValue = "";
		}
		$this->total_amount->TooltipValue = "";

		// ref
		$this->ref->LinkCustomAttributes = "";
		$this->ref->HrefValue = "";
		$this->ref->TooltipValue = "";

		// partner_name
		$this->partner_name->LinkCustomAttributes = "";
		if (!EmptyValue($this->partner_name->CurrentValue)) {
			$this->partner_name->HrefValue = "partner_balancelist.php?x_partner_name=" . $this->partner_name->CurrentValue; // Add prefix/suffix
			$this->partner_name->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->partner_name->HrefValue = FullUrl($this->partner_name->HrefValue, "href");
		} else {
			$this->partner_name->HrefValue = "";
		}
		$this->partner_name->TooltipValue = "";

		// url
		$this->url->LinkCustomAttributes = "";
		$this->url->HrefValue = "";
		$this->url->TooltipValue = "";

		// url_mog
		$this->url_mog->LinkCustomAttributes = "";
		$this->url_mog->HrefValue = "";
		$this->url_mog->TooltipValue = "";

		// url_r_list
		$this->url_r_list->LinkCustomAttributes = "";
		$this->url_r_list->HrefValue = "";
		$this->url_r_list->TooltipValue = "";

		// dated
		$this->dated->LinkCustomAttributes = "";
		$this->dated->HrefValue = "";
		$this->dated->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// location
		$this->location->EditAttrs["class"] = "form-control";
		$this->location->EditCustomAttributes = "";
		if ($this->location->getSessionValue() <> "") {
			$this->location->CurrentValue = $this->location->getSessionValue();
		$curVal = strval($this->location->CurrentValue);
		if ($curVal <> "") {
			$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
			if ($this->location->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->location->ViewValue = $this->location->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->location->ViewValue = $this->location->CurrentValue;
				}
			}
		} else {
			$this->location->ViewValue = NULL;
		}
		$this->location->ViewCustomAttributes = "";
		} else {
		}

		// partner_id
		$this->partner_id->EditAttrs["class"] = "form-control";
		$this->partner_id->EditCustomAttributes = "";
		if ($this->partner_id->getSessionValue() <> "") {
			$this->partner_id->CurrentValue = $this->partner_id->getSessionValue();
		$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
		$curVal = strval($this->partner_id->CurrentValue);
		if ($curVal <> "") {
			$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
			if ($this->partner_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
				}
			}
		} else {
			$this->partner_id->ViewValue = NULL;
		}
		$this->partner_id->ViewCustomAttributes = "";
		} else {
		$this->partner_id->EditValue = $this->partner_id->CurrentValue;
		$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());
		}

		// balance
		$this->balance->EditAttrs["class"] = "form-control";
		$this->balance->EditCustomAttributes = "";
		$this->balance->EditValue = $this->balance->CurrentValue;
		$this->balance->PlaceHolder = RemoveHtml($this->balance->caption());

		// receipt
		$this->receipt->EditAttrs["class"] = "form-control";
		$this->receipt->EditCustomAttributes = "";
		$this->receipt->EditValue = $this->receipt->CurrentValue;
		$this->receipt->PlaceHolder = RemoveHtml($this->receipt->caption());

		// panel_amount
		$this->panel_amount->EditAttrs["class"] = "form-control";
		$this->panel_amount->EditCustomAttributes = "";
		$this->panel_amount->EditValue = $this->panel_amount->CurrentValue;
		$this->panel_amount->PlaceHolder = RemoveHtml($this->panel_amount->caption());

		// total_amount
		$this->total_amount->EditAttrs["class"] = "form-control";
		$this->total_amount->EditCustomAttributes = "";
		$this->total_amount->EditValue = $this->total_amount->CurrentValue;
		$this->total_amount->PlaceHolder = RemoveHtml($this->total_amount->caption());

		// ref
		$this->ref->EditCustomAttributes = "";

		// partner_name
		$this->partner_name->EditAttrs["class"] = "form-control";
		$this->partner_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->partner_name->CurrentValue = HtmlDecode($this->partner_name->CurrentValue);
		$this->partner_name->EditValue = $this->partner_name->CurrentValue;
		$this->partner_name->PlaceHolder = RemoveHtml($this->partner_name->caption());

		// url
		$this->url->EditAttrs["class"] = "form-control";
		$this->url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
		$this->url->EditValue = $this->url->CurrentValue;
		$this->url->PlaceHolder = RemoveHtml($this->url->caption());

		// url_mog
		$this->url_mog->EditAttrs["class"] = "form-control";
		$this->url_mog->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->url_mog->CurrentValue = HtmlDecode($this->url_mog->CurrentValue);
		$this->url_mog->EditValue = $this->url_mog->CurrentValue;
		$this->url_mog->PlaceHolder = RemoveHtml($this->url_mog->caption());

		// url_r_list
		$this->url_r_list->EditAttrs["class"] = "form-control";
		$this->url_r_list->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->url_r_list->CurrentValue = HtmlDecode($this->url_r_list->CurrentValue);
		$this->url_r_list->EditValue = $this->url_r_list->CurrentValue;
		$this->url_r_list->PlaceHolder = RemoveHtml($this->url_r_list->caption());

		// dated
		$this->dated->EditAttrs["class"] = "form-control";
		$this->dated->EditCustomAttributes = "";
		$this->dated->EditValue = FormatDateTime($this->dated->CurrentValue, 8);
		$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->balance->CurrentValue))
				$this->balance->Total += $this->balance->CurrentValue; // Accumulate total
			if (is_numeric($this->receipt->CurrentValue))
				$this->receipt->Total += $this->receipt->CurrentValue; // Accumulate total
			if (is_numeric($this->panel_amount->CurrentValue))
				$this->panel_amount->Total += $this->panel_amount->CurrentValue; // Accumulate total
			if (is_numeric($this->total_amount->CurrentValue))
				$this->total_amount->Total += $this->total_amount->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->balance->CurrentValue = $this->balance->Total;
			$this->balance->ViewValue = $this->balance->CurrentValue;
			$this->balance->ViewValue = FormatNumber($this->balance->ViewValue, 2, -2, -2, -2);
			$this->balance->ViewCustomAttributes = "";
			$this->balance->HrefValue = ""; // Clear href value
			$this->receipt->CurrentValue = $this->receipt->Total;
			$this->receipt->ViewValue = $this->receipt->CurrentValue;
			$this->receipt->ViewValue = FormatNumber($this->receipt->ViewValue, 2, -2, -2, -2);
			$this->receipt->ViewCustomAttributes = "";
			$this->receipt->HrefValue = ""; // Clear href value
			$this->panel_amount->CurrentValue = $this->panel_amount->Total;
			$this->panel_amount->ViewValue = $this->panel_amount->CurrentValue;
			$this->panel_amount->ViewValue = FormatNumber($this->panel_amount->ViewValue, 0, -2, -2, -2);
			$this->panel_amount->ViewCustomAttributes = "";
			$this->panel_amount->HrefValue = ""; // Clear href value
			$this->total_amount->CurrentValue = $this->total_amount->Total;
			$this->total_amount->ViewValue = $this->total_amount->CurrentValue;
			$this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, 2, -2, -2, -2);
			$this->total_amount->ViewCustomAttributes = "";
			$this->total_amount->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->balance);
					$doc->exportCaption($this->receipt);
					$doc->exportCaption($this->panel_amount);
					$doc->exportCaption($this->total_amount);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->dated);
				} else {
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->balance);
					$doc->exportCaption($this->receipt);
					$doc->exportCaption($this->panel_amount);
					$doc->exportCaption($this->total_amount);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->dated);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->location);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->balance);
						$doc->exportField($this->receipt);
						$doc->exportField($this->panel_amount);
						$doc->exportField($this->total_amount);
						$doc->exportField($this->ref);
						$doc->exportField($this->dated);
					} else {
						$doc->exportField($this->location);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->balance);
						$doc->exportField($this->receipt);
						$doc->exportField($this->panel_amount);
						$doc->exportField($this->total_amount);
						$doc->exportField($this->ref);
						$doc->exportField($this->dated);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->location, '');
				$doc->exportAggregate($this->partner_id, '');
				$doc->exportAggregate($this->balance, 'TOTAL');
				$doc->exportAggregate($this->receipt, 'TOTAL');
				$doc->exportAggregate($this->panel_amount, 'TOTAL');
				$doc->exportAggregate($this->total_amount, 'TOTAL');
				$doc->exportAggregate($this->ref, '');
				$doc->exportAggregate($this->dated, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>