<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for partner_product_ref
 */
class partner_product_ref extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $partner_type;
	public $partner;
	public $partner_ref;
	public $_barcode;
	public $partner_code;
	public $product_type;
	public $shape;
	public $grp;
	public $s_grp;
	public $product;
	public $rid;
	public $spl_ins;
	public $packing_type;
	public $batch_no;
	public $unit;
	public $w;
	public $w_cm;
	public $l;
	public $l_cm;
	public $h;
	public $h_cm;
	public $partner_size;
	public $sqm;
	public $cbm;
	public $weight_sqm;
	public $price;
	public $price_cs;
	public $currency;
	public $hsn;
	public $composition;
	public $status;
	public $operator;
	public $datetime;
	public $gcode;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'partner_product_ref';
		$this->TableName = 'partner_product_ref';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`partner_product_ref`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('partner_product_ref', 'partner_product_ref', 'x_id', 'id', '`id`', '`id`', 3, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// partner_type
		$this->partner_type = new DbField('partner_product_ref', 'partner_product_ref', 'x_partner_type', 'partner_type', '`partner_type`', '`partner_type`', 16, -1, FALSE, '`partner_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->partner_type->Nullable = FALSE; // NOT NULL field
		$this->partner_type->Required = TRUE; // Required field
		$this->partner_type->Sortable = TRUE; // Allow sort
		$this->partner_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->partner_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->partner_type->Lookup = new Lookup('partner_type', 'admin_category', FALSE, 'id', ["item","","",""], [], ["x_partner"], [], [], [], [], '`item` ASC', '');
		$this->partner_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['partner_type'] = &$this->partner_type;

		// partner
		$this->partner = new DbField('partner_product_ref', 'partner_product_ref', 'x_partner', 'partner', '`partner`', '`partner`', 3, -1, FALSE, '`partner`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->partner->Nullable = FALSE; // NOT NULL field
		$this->partner->Required = TRUE; // Required field
		$this->partner->Sortable = TRUE; // Allow sort
		$this->partner->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->partner->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->partner->Lookup = new Lookup('partner', 'buyer_seller_view', FALSE, 'id', ["name","","",""], ["x_partner_type"], [], ["partner_type"], ["x_partner_type"], ["currency"], ["x_currency"], '`name` ASC', '');
		$this->partner->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['partner'] = &$this->partner;

		// partner_ref
		$this->partner_ref = new DbField('partner_product_ref', 'partner_product_ref', 'x_partner_ref', 'partner_ref', '`partner_ref`', '`partner_ref`', 200, -1, FALSE, '`partner_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_ref->Nullable = FALSE; // NOT NULL field
		$this->partner_ref->Required = TRUE; // Required field
		$this->partner_ref->Sortable = TRUE; // Allow sort
		$this->fields['partner_ref'] = &$this->partner_ref;

		// barcode
		$this->_barcode = new DbField('partner_product_ref', 'partner_product_ref', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 200, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_barcode->Sortable = TRUE; // Allow sort
		$this->fields['barcode'] = &$this->_barcode;

		// partner_code
		$this->partner_code = new DbField('partner_product_ref', 'partner_product_ref', 'x_partner_code', 'partner_code', '`partner_code`', '`partner_code`', 200, -1, FALSE, '`partner_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_code->Sortable = TRUE; // Allow sort
		$this->fields['partner_code'] = &$this->partner_code;

		// product_type
		$this->product_type = new DbField('partner_product_ref', 'partner_product_ref', 'x_product_type', 'product_type', '`product_type`', '`product_type`', 18, -1, FALSE, '`product_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product_type->Required = TRUE; // Required field
		$this->product_type->Sortable = TRUE; // Allow sort
		$this->product_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product_type->Lookup = new Lookup('product_type', 'product_type', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->product_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product_type'] = &$this->product_type;

		// shape
		$this->shape = new DbField('partner_product_ref', 'partner_product_ref', 'x_shape', 'shape', '`shape`', '`shape`', 200, -1, FALSE, '`shape`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->shape->Sortable = TRUE; // Allow sort
		$this->shape->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->shape->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->shape->Lookup = new Lookup('shape', 'shape', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->shape->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['shape'] = &$this->shape;

		// grp
		$this->grp = new DbField('partner_product_ref', 'partner_product_ref', 'x_grp', 'grp', '`grp`', '`grp`', 2, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_s_grp","x_packing_type","x_hsn","x_composition"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('partner_product_ref', 'partner_product_ref', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 2, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], ["x_product"], ["grp"], ["x_grp"], [], [], '`product_group` ASC', '');
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('partner_product_ref', 'partner_product_ref', 'x_product', 'product', '`product`', '`product`', 2, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', '_product_view', FALSE, 'id', ["product","","",""], ["x_s_grp"], ["x_rid"], ["s_grp"], ["x_s_grp"], [], [], '`product` ASC', '');
		$this->fields['product'] = &$this->product;

		// rid
		$this->rid = new DbField('partner_product_ref', 'partner_product_ref', 'x_rid', 'rid', '`rid`', '`rid`', 2, -1, FALSE, '`EV__rid`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->rid->IsForeignKey = TRUE; // Foreign key field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->rid->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->rid->Lookup = new Lookup('rid', 'ref', TRUE, 'id', ["product_code","","",""], ["x_product"], ["x_batch_no","x_gcode"], ["product"], ["x_product"], ["cbm"], ["x_cbm"], '`product_code` ASC', '');
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// spl_ins
		$this->spl_ins = new DbField('partner_product_ref', 'partner_product_ref', 'x_spl_ins', 'spl_ins', '`spl_ins`', '`spl_ins`', 200, -1, FALSE, '`spl_ins`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->spl_ins->Sortable = TRUE; // Allow sort
		$this->fields['spl_ins'] = &$this->spl_ins;

		// packing_type
		$this->packing_type = new DbField('partner_product_ref', 'partner_product_ref', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 2, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->packing_type->Lookup = new Lookup('packing_type', 'packing_type', FALSE, 'id', ["code","packing","",""], ["x_grp"], [], ["grp"], ["x_grp"], [], [], '`code` ASC', '');
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// batch_no
		$this->batch_no = new DbField('partner_product_ref', 'partner_product_ref', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 18, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->batch_no->Lookup = new Lookup('batch_no', 'batch_no', FALSE, 'id', ["batch_no","description","",""], ["x_rid"], [], ["rid"], ["x_rid"], [], [], '`batch_no` ASC', '');
		$this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_no'] = &$this->batch_no;

		// unit
		$this->unit = new DbField('partner_product_ref', 'partner_product_ref', 'x_unit', 'unit', '`unit`', '`unit`', 2, -1, FALSE, '`unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->unit->Sortable = TRUE; // Allow sort
		$this->unit->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->unit->Lookup = new Lookup('unit', 'partner_product_ref', FALSE, '', ["","","",""], [], [], [], [], ["currency"], ["x_currency"], '', '');
		$this->unit->OptionCount = 5;
		$this->unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['unit'] = &$this->unit;

		// w
		$this->w = new DbField('partner_product_ref', 'partner_product_ref', 'x_w', 'w', '`w`', '`w`', 200, -1, FALSE, '`w`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->w->Sortable = TRUE; // Allow sort
		$this->fields['w'] = &$this->w;

		// w_cm
		$this->w_cm = new DbField('partner_product_ref', 'partner_product_ref', 'x_w_cm', 'w_cm', '`w_cm`', '`w_cm`', 3, -1, FALSE, '`w_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->w_cm->Sortable = TRUE; // Allow sort
		$this->w_cm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['w_cm'] = &$this->w_cm;

		// l
		$this->l = new DbField('partner_product_ref', 'partner_product_ref', 'x_l', 'l', '`l`', '`l`', 200, -1, FALSE, '`l`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->l->Sortable = TRUE; // Allow sort
		$this->fields['l'] = &$this->l;

		// l_cm
		$this->l_cm = new DbField('partner_product_ref', 'partner_product_ref', 'x_l_cm', 'l_cm', '`l_cm`', '`l_cm`', 3, -1, FALSE, '`l_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->l_cm->Sortable = TRUE; // Allow sort
		$this->l_cm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['l_cm'] = &$this->l_cm;

		// h
		$this->h = new DbField('partner_product_ref', 'partner_product_ref', 'x_h', 'h', '`h`', '`h`', 200, -1, FALSE, '`h`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->h->Sortable = TRUE; // Allow sort
		$this->fields['h'] = &$this->h;

		// h_cm
		$this->h_cm = new DbField('partner_product_ref', 'partner_product_ref', 'x_h_cm', 'h_cm', '`h_cm`', '`h_cm`', 3, -1, FALSE, '`h_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->h_cm->Sortable = TRUE; // Allow sort
		$this->h_cm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['h_cm'] = &$this->h_cm;

		// partner_size
		$this->partner_size = new DbField('partner_product_ref', 'partner_product_ref', 'x_partner_size', 'partner_size', '`partner_size`', '`partner_size`', 200, -1, FALSE, '`partner_size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_size->Sortable = TRUE; // Allow sort
		$this->fields['partner_size'] = &$this->partner_size;

		// sqm
		$this->sqm = new DbField('partner_product_ref', 'partner_product_ref', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 131, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->fields['sqm'] = &$this->sqm;

		// cbm
		$this->cbm = new DbField('partner_product_ref', 'partner_product_ref', 'x_cbm', 'cbm', '`cbm`', '`cbm`', 131, -1, FALSE, '`cbm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cbm->Nullable = FALSE; // NOT NULL field
		$this->cbm->Sortable = TRUE; // Allow sort
		$this->cbm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cbm'] = &$this->cbm;

		// weight_sqm
		$this->weight_sqm = new DbField('partner_product_ref', 'partner_product_ref', 'x_weight_sqm', 'weight_sqm', '`weight_sqm`', '`weight_sqm`', 131, -1, FALSE, '`weight_sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->weight_sqm->Nullable = FALSE; // NOT NULL field
		$this->weight_sqm->Required = TRUE; // Required field
		$this->weight_sqm->Sortable = TRUE; // Allow sort
		$this->weight_sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['weight_sqm'] = &$this->weight_sqm;

		// price
		$this->price = new DbField('partner_product_ref', 'partner_product_ref', 'x_price', 'price', '`price`', '`price`', 4, -1, FALSE, '`price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price->Required = TRUE; // Required field
		$this->price->Sortable = TRUE; // Allow sort
		$this->price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price'] = &$this->price;

		// price_cs
		$this->price_cs = new DbField('partner_product_ref', 'partner_product_ref', 'x_price_cs', 'price_cs', '`price_cs`', '`price_cs`', 131, -1, FALSE, '`price_cs`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price_cs->Sortable = TRUE; // Allow sort
		$this->price_cs->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price_cs'] = &$this->price_cs;

		// currency
		$this->currency = new DbField('partner_product_ref', 'partner_product_ref', 'x_currency', 'currency', '`currency`', '`currency`', 2, -1, FALSE, '`currency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->currency->Sortable = TRUE; // Allow sort
		$this->currency->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->currency->Lookup = new Lookup('currency', 'currency', FALSE, 'id', ["code","name","",""], [], [], [], [], [], [], '`code` ASC', '');
		$this->currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['currency'] = &$this->currency;

		// hsn
		$this->hsn = new DbField('partner_product_ref', 'partner_product_ref', 'x_hsn', 'hsn', '`hsn`', '`hsn`', 18, -1, FALSE, '`hsn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->hsn->Sortable = TRUE; // Allow sort
		$this->hsn->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->hsn->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->hsn->Lookup = new Lookup('hsn', 'tax_category', FALSE, 'id', ["item","hsn_code","tax_percent",""], ["x_grp"], [], ["grp"], ["x_grp"], [], [], '`item` ASC', '');
		$this->hsn->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['hsn'] = &$this->hsn;

		// composition
		$this->composition = new DbField('partner_product_ref', 'partner_product_ref', 'x_composition', 'composition', '`composition`', '`composition`', 18, -1, FALSE, '`composition`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->composition->Sortable = TRUE; // Allow sort
		$this->composition->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->composition->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->composition->Lookup = new Lookup('composition', 'composition', FALSE, 'id', ["composition","","",""], ["x_grp"], [], ["grp"], ["x_grp"], [], [], '`composition` ASC', '');
		$this->composition->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['composition'] = &$this->composition;

		// status
		$this->status = new DbField('partner_product_ref', 'partner_product_ref', 'x_status', 'status', '`status`', '`status`', 16, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'partner_product_ref', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 2;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// operator
		$this->operator = new DbField('partner_product_ref', 'partner_product_ref', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('partner_product_ref', 'partner_product_ref', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 7, "DB"), 135, 7, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// gcode
		$this->gcode = new DbField('partner_product_ref', 'partner_product_ref', 'x_gcode', 'gcode', '`gcode`', '`gcode`', 200, -1, FALSE, '`gcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->gcode->Nullable = FALSE; // NOT NULL field
		$this->gcode->Required = TRUE; // Required field
		$this->gcode->Sortable = FALSE; // Allow sort
		$this->gcode->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->gcode->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->gcode->Lookup = new Lookup('gcode', 'ref', FALSE, 'gcode', ["gcode","","",""], ["x_rid"], [], ["id"], ["x_id"], [], [], '`gcode` ASC', '');
		$this->fields['gcode'] = &$this->gcode;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "ref") {
			if ($this->rid->getSessionValue() <> "")
				$masterFilter .= "`id`=" . QuotedValue($this->rid->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "ref") {
			if ($this->rid->getSessionValue() <> "")
				$detailFilter .= "`rid`=" . QuotedValue($this->rid->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_ref()
	{
		return "`id`=@id@";
	}

	// Detail filter
	public function sqlDetailFilter_ref()
	{
		return "`rid`=@rid@";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`partner_product_ref`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT DISTINCT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `partner_product_ref`.`rid` LIMIT 1) AS `EV__rid` FROM `partner_product_ref`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (User_Category() == 0) ?  "" : "`partner` = " .  User_Company_ID()  . "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->rid->AdvancedSearch->SearchValue <> "" ||
			$this->rid->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->partner_type->DbValue = $row['partner_type'];
		$this->partner->DbValue = $row['partner'];
		$this->partner_ref->DbValue = $row['partner_ref'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->partner_code->DbValue = $row['partner_code'];
		$this->product_type->DbValue = $row['product_type'];
		$this->shape->DbValue = $row['shape'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->rid->DbValue = $row['rid'];
		$this->spl_ins->DbValue = $row['spl_ins'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->unit->DbValue = $row['unit'];
		$this->w->DbValue = $row['w'];
		$this->w_cm->DbValue = $row['w_cm'];
		$this->l->DbValue = $row['l'];
		$this->l_cm->DbValue = $row['l_cm'];
		$this->h->DbValue = $row['h'];
		$this->h_cm->DbValue = $row['h_cm'];
		$this->partner_size->DbValue = $row['partner_size'];
		$this->sqm->DbValue = $row['sqm'];
		$this->cbm->DbValue = $row['cbm'];
		$this->weight_sqm->DbValue = $row['weight_sqm'];
		$this->price->DbValue = $row['price'];
		$this->price_cs->DbValue = $row['price_cs'];
		$this->currency->DbValue = $row['currency'];
		$this->hsn->DbValue = $row['hsn'];
		$this->composition->DbValue = $row['composition'];
		$this->status->DbValue = $row['status'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->gcode->DbValue = $row['gcode'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "partner_product_reflist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "partner_product_refview.php")
			return $Language->phrase("View");
		elseif ($pageName == "partner_product_refedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "partner_product_refadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "partner_product_reflist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("partner_product_refview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("partner_product_refview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "partner_product_refadd.php?" . $this->getUrlParm($parm);
		else
			$url = "partner_product_refadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("partner_product_refedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("partner_product_refadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("partner_product_refdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "ref" && !ContainsString($url, TABLE_SHOW_MASTER . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . TABLE_SHOW_MASTER . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_id=" . urlencode($this->rid->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->partner_type->setDbValue($rs->fields('partner_type'));
		$this->partner->setDbValue($rs->fields('partner'));
		$this->partner_ref->setDbValue($rs->fields('partner_ref'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->partner_code->setDbValue($rs->fields('partner_code'));
		$this->product_type->setDbValue($rs->fields('product_type'));
		$this->shape->setDbValue($rs->fields('shape'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->spl_ins->setDbValue($rs->fields('spl_ins'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->unit->setDbValue($rs->fields('unit'));
		$this->w->setDbValue($rs->fields('w'));
		$this->w_cm->setDbValue($rs->fields('w_cm'));
		$this->l->setDbValue($rs->fields('l'));
		$this->l_cm->setDbValue($rs->fields('l_cm'));
		$this->h->setDbValue($rs->fields('h'));
		$this->h_cm->setDbValue($rs->fields('h_cm'));
		$this->partner_size->setDbValue($rs->fields('partner_size'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->cbm->setDbValue($rs->fields('cbm'));
		$this->weight_sqm->setDbValue($rs->fields('weight_sqm'));
		$this->price->setDbValue($rs->fields('price'));
		$this->price_cs->setDbValue($rs->fields('price_cs'));
		$this->currency->setDbValue($rs->fields('currency'));
		$this->hsn->setDbValue($rs->fields('hsn'));
		$this->composition->setDbValue($rs->fields('composition'));
		$this->status->setDbValue($rs->fields('status'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->gcode->setDbValue($rs->fields('gcode'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// partner_type
		// partner
		// partner_ref
		// barcode
		// partner_code
		// product_type
		// shape
		// grp
		// s_grp
		// product
		// rid

		$this->rid->CellCssStyle = "white-space: nowrap;";

		// spl_ins
		// packing_type
		// batch_no
		// unit
		// w
		// w_cm
		// l
		// l_cm
		// h
		// h_cm
		// partner_size
		// sqm
		// cbm
		// weight_sqm
		// price
		// price_cs
		// currency
		// hsn
		// composition
		// status
		// operator
		// datetime
		// gcode

		$this->gcode->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// partner_type
		$curVal = strval($this->partner_type->CurrentValue);
		if ($curVal <> "") {
			$this->partner_type->ViewValue = $this->partner_type->lookupCacheOption($curVal);
			if ($this->partner_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return ((User_Category() == 0) ? "FIND_IN_SET(`id`, '1,2') and `status` = 1" : ((User_Category() == 1) ? "`id` = 1 and `status` = 1" : ((User_Category() == 2) ? "`id` = 2 and `status` = 1" : "FIND_IN_SET(`id`, '1,2') and `status` = 1")));
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->partner_type->ViewValue = $this->partner_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_type->ViewValue = $this->partner_type->CurrentValue;
				}
			}
		} else {
			$this->partner_type->ViewValue = NULL;
		}
		$this->partner_type->ViewCustomAttributes = "";

		// partner
		$curVal = strval($this->partner->CurrentValue);
		if ($curVal <> "") {
			$this->partner->ViewValue = $this->partner->lookupCacheOption($curVal);
			if ($this->partner->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Category() == 0) ?  "`status` = 1 || `category` = 1" : "(`id` = " .  User_Company_ID()  . " and `status` = 1)  || `category` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->partner->ViewValue = $this->partner->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner->ViewValue = $this->partner->CurrentValue;
				}
			}
		} else {
			$this->partner->ViewValue = NULL;
		}
		$this->partner->ViewCustomAttributes = "";

		// partner_ref
		$this->partner_ref->ViewValue = $this->partner_ref->CurrentValue;
		$this->partner_ref->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewCustomAttributes = "";

		// partner_code
		$this->partner_code->ViewValue = $this->partner_code->CurrentValue;
		$this->partner_code->ViewCustomAttributes = "";

		// product_type
		$curVal = strval($this->product_type->CurrentValue);
		if ($curVal <> "") {
			$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
			if ($this->product_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `id` != 9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product_type->ViewValue = $this->product_type->CurrentValue;
				}
			}
		} else {
			$this->product_type->ViewValue = NULL;
		}
		$this->product_type->ViewCustomAttributes = "";

		// shape
		$curVal = strval($this->shape->CurrentValue);
		if ($curVal <> "") {
			$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
			if ($this->shape->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->shape->ViewValue = $this->shape->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->shape->ViewValue = $this->shape->CurrentValue;
				}
			}
		} else {
			$this->shape->ViewValue = NULL;
		}
		$this->shape->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// rid
		if ($this->rid->VirtualValue <> "") {
			$this->rid->ViewValue = $this->rid->VirtualValue;
		} else {
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// spl_ins
		$this->spl_ins->ViewValue = $this->spl_ins->CurrentValue;
		$this->spl_ins->ViewCustomAttributes = "";

		// packing_type
		$curVal = strval($this->packing_type->CurrentValue);
		if ($curVal <> "") {
			$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			if ($this->packing_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
				}
			}
		} else {
			$this->packing_type->ViewValue = NULL;
		}
		$this->packing_type->ViewCustomAttributes = "";

		// batch_no
		$curVal = strval($this->batch_no->CurrentValue);
		if ($curVal <> "") {
			$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			if ($this->batch_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return ((pd_byepass() == 2) ? "`status` = 1" : ((pd_byepass() == 1) ? "(`bom_app_id` >  0 and `status` = 1) || (`a_operator` > 0 and `status` = 1)" : "(`a_operator` > 0 and `status` = 1)"));
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
				}
			}
		} else {
			$this->batch_no->ViewValue = NULL;
		}
		$this->batch_no->ViewCustomAttributes = "";

		// unit
		if (strval($this->unit->CurrentValue) <> "") {
			$this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
		} else {
			$this->unit->ViewValue = NULL;
		}
		$this->unit->ViewCustomAttributes = "";

		// w
		$this->w->ViewValue = $this->w->CurrentValue;
		$this->w->ViewCustomAttributes = "";

		// w_cm
		$this->w_cm->ViewValue = $this->w_cm->CurrentValue;
		$this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, 2, -2, -2, -2);
		$this->w_cm->ViewCustomAttributes = "";

		// l
		$this->l->ViewValue = $this->l->CurrentValue;
		$this->l->ViewCustomAttributes = "";

		// l_cm
		$this->l_cm->ViewValue = $this->l_cm->CurrentValue;
		$this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, 2, -2, -2, -2);
		$this->l_cm->ViewCustomAttributes = "";

		// h
		$this->h->ViewValue = $this->h->CurrentValue;
		$this->h->ViewCustomAttributes = "";

		// h_cm
		$this->h_cm->ViewValue = $this->h_cm->CurrentValue;
		$this->h_cm->ViewValue = FormatNumber($this->h_cm->ViewValue, 2, -2, -2, -2);
		$this->h_cm->ViewCustomAttributes = "";

		// partner_size
		$this->partner_size->ViewValue = $this->partner_size->CurrentValue;
		$this->partner_size->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 4, -2, -2, 0);
		$this->sqm->ViewCustomAttributes = "";

		// cbm
		$this->cbm->ViewValue = $this->cbm->CurrentValue;
		$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 4, -2, -2, -2);
		$this->cbm->ViewCustomAttributes = "";

		// weight_sqm
		$this->weight_sqm->ViewValue = $this->weight_sqm->CurrentValue;
		$this->weight_sqm->ViewValue = FormatNumber($this->weight_sqm->ViewValue, 3, -2, -2, -2);
		$this->weight_sqm->ViewCustomAttributes = "";

		// price
		$this->price->ViewValue = $this->price->CurrentValue;
		$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, 0);
		$this->price->ViewCustomAttributes = "";

		// price_cs
		$this->price_cs->ViewValue = $this->price_cs->CurrentValue;
		$this->price_cs->ViewValue = FormatNumber($this->price_cs->ViewValue, 2, -2, -2, -2);
		$this->price_cs->ViewCustomAttributes = "";

		// currency
		$curVal = strval($this->currency->CurrentValue);
		if ($curVal <> "") {
			$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			if ($this->currency->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->currency->ViewValue = $this->currency->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->currency->ViewValue = $this->currency->CurrentValue;
				}
			}
		} else {
			$this->currency->ViewValue = NULL;
		}
		$this->currency->ViewCustomAttributes = "";

		// hsn
		$curVal = strval($this->hsn->CurrentValue);
		if ($curVal <> "") {
			$this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
			if ($this->hsn->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->hsn->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
					$this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->hsn->ViewValue = $this->hsn->CurrentValue;
				}
			}
		} else {
			$this->hsn->ViewValue = NULL;
		}
		$this->hsn->ViewCustomAttributes = "";

		// composition
		$curVal = strval($this->composition->CurrentValue);
		if ($curVal <> "") {
			$this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
			if ($this->composition->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->composition->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->composition->ViewValue = $this->composition->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->composition->ViewValue = $this->composition->CurrentValue;
				}
			}
		} else {
			$this->composition->ViewValue = NULL;
		}
		$this->composition->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 7);
		$this->datetime->ViewCustomAttributes = "";

		// gcode
		$curVal = strval($this->gcode->CurrentValue);
		if ($curVal <> "") {
			$this->gcode->ViewValue = $this->gcode->lookupCacheOption($curVal);
			if ($this->gcode->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`gcode`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->gcode->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->gcode->ViewValue = $this->gcode->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->gcode->ViewValue = $this->gcode->CurrentValue;
				}
			}
		} else {
			$this->gcode->ViewValue = NULL;
		}
		$this->gcode->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// partner_type
		$this->partner_type->LinkCustomAttributes = "";
		$this->partner_type->HrefValue = "";
		$this->partner_type->TooltipValue = "";

		// partner
		$this->partner->LinkCustomAttributes = "";
		$this->partner->HrefValue = "";
		$this->partner->TooltipValue = "";

		// partner_ref
		$this->partner_ref->LinkCustomAttributes = "";
		$this->partner_ref->HrefValue = "";
		$this->partner_ref->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// partner_code
		$this->partner_code->LinkCustomAttributes = "";
		$this->partner_code->HrefValue = "";
		$this->partner_code->TooltipValue = "";

		// product_type
		$this->product_type->LinkCustomAttributes = "";
		$this->product_type->HrefValue = "";
		$this->product_type->TooltipValue = "";

		// shape
		$this->shape->LinkCustomAttributes = "";
		$this->shape->HrefValue = "";
		$this->shape->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->grp->CurrentValue)) {
			$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
			$this->grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
		} else {
			$this->grp->HrefValue = "";
		}
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->s_grp->CurrentValue)) {
			$this->s_grp->HrefValue = "product_cart_blist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
			$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
		} else {
			$this->s_grp->HrefValue = "";
		}
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "product_cart_blist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		$this->rid->HrefValue = "";
		$this->rid->TooltipValue = "";

		// spl_ins
		$this->spl_ins->LinkCustomAttributes = "";
		$this->spl_ins->HrefValue = "";
		$this->spl_ins->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		$this->batch_no->HrefValue = "";
		$this->batch_no->TooltipValue = "";

		// unit
		$this->unit->LinkCustomAttributes = "";
		if (!EmptyValue($this->unit->CurrentValue)) {
			$this->unit->HrefValue = "product_cart_blist.php?x_ref=" . $this->unit->CurrentValue; // Add prefix/suffix
			$this->unit->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
		} else {
			$this->unit->HrefValue = "";
		}
		$this->unit->TooltipValue = "";

		// w
		$this->w->LinkCustomAttributes = "";
		$this->w->HrefValue = "";
		$this->w->TooltipValue = "";

		// w_cm
		$this->w_cm->LinkCustomAttributes = "";
		$this->w_cm->HrefValue = "";
		$this->w_cm->TooltipValue = "";

		// l
		$this->l->LinkCustomAttributes = "";
		$this->l->HrefValue = "";
		$this->l->TooltipValue = "";

		// l_cm
		$this->l_cm->LinkCustomAttributes = "";
		$this->l_cm->HrefValue = "";
		$this->l_cm->TooltipValue = "";

		// h
		$this->h->LinkCustomAttributes = "";
		$this->h->HrefValue = "";
		$this->h->TooltipValue = "";

		// h_cm
		$this->h_cm->LinkCustomAttributes = "";
		$this->h_cm->HrefValue = "";
		$this->h_cm->TooltipValue = "";

		// partner_size
		$this->partner_size->LinkCustomAttributes = "";
		$this->partner_size->HrefValue = "";
		$this->partner_size->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// cbm
		$this->cbm->LinkCustomAttributes = "";
		$this->cbm->HrefValue = "";
		$this->cbm->TooltipValue = "";

		// weight_sqm
		$this->weight_sqm->LinkCustomAttributes = "";
		$this->weight_sqm->HrefValue = "";
		$this->weight_sqm->TooltipValue = "";

		// price
		$this->price->LinkCustomAttributes = "";
		$this->price->HrefValue = "";
		$this->price->TooltipValue = "";

		// price_cs
		$this->price_cs->LinkCustomAttributes = "";
		$this->price_cs->HrefValue = "";
		$this->price_cs->TooltipValue = "";

		// currency
		$this->currency->LinkCustomAttributes = "";
		$this->currency->HrefValue = "";
		$this->currency->TooltipValue = "";

		// hsn
		$this->hsn->LinkCustomAttributes = "";
		$this->hsn->HrefValue = "";
		$this->hsn->TooltipValue = "";

		// composition
		$this->composition->LinkCustomAttributes = "";
		$this->composition->HrefValue = "";
		$this->composition->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// gcode
		$this->gcode->LinkCustomAttributes = "";
		$this->gcode->HrefValue = "";
		$this->gcode->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// partner_type
		$this->partner_type->EditAttrs["class"] = "form-control";
		$this->partner_type->EditCustomAttributes = "";

		// partner
		$this->partner->EditAttrs["class"] = "form-control";
		$this->partner->EditCustomAttributes = "";

		// partner_ref
		$this->partner_ref->EditAttrs["class"] = "form-control";
		$this->partner_ref->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->partner_ref->CurrentValue = HtmlDecode($this->partner_ref->CurrentValue);
		$this->partner_ref->EditValue = $this->partner_ref->CurrentValue;
		$this->partner_ref->PlaceHolder = RemoveHtml($this->partner_ref->caption());

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_barcode->CurrentValue = HtmlDecode($this->_barcode->CurrentValue);
		$this->_barcode->EditValue = $this->_barcode->CurrentValue;
		$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

		// partner_code
		$this->partner_code->EditAttrs["class"] = "form-control";
		$this->partner_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->partner_code->CurrentValue = HtmlDecode($this->partner_code->CurrentValue);
		$this->partner_code->EditValue = $this->partner_code->CurrentValue;
		$this->partner_code->PlaceHolder = RemoveHtml($this->partner_code->caption());

		// product_type
		$this->product_type->EditAttrs["class"] = "form-control";
		$this->product_type->EditCustomAttributes = "";

		// shape
		$this->shape->EditAttrs["class"] = "form-control";
		$this->shape->EditCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		if ($this->rid->getSessionValue() <> "") {
			$this->rid->CurrentValue = $this->rid->getSessionValue();
		if ($this->rid->VirtualValue <> "") {
			$this->rid->ViewValue = $this->rid->VirtualValue;
		} else {
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";
		} else {
		}

		// spl_ins
		$this->spl_ins->EditAttrs["class"] = "form-control";
		$this->spl_ins->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->spl_ins->CurrentValue = HtmlDecode($this->spl_ins->CurrentValue);
		$this->spl_ins->EditValue = $this->spl_ins->CurrentValue;
		$this->spl_ins->PlaceHolder = RemoveHtml($this->spl_ins->caption());

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";

		// unit
		$this->unit->EditAttrs["class"] = "form-control";
		$this->unit->EditCustomAttributes = "";
		$this->unit->EditValue = $this->unit->options(TRUE);

		// w
		$this->w->EditAttrs["class"] = "form-control";
		$this->w->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->w->CurrentValue = HtmlDecode($this->w->CurrentValue);
		$this->w->EditValue = $this->w->CurrentValue;
		$this->w->PlaceHolder = RemoveHtml($this->w->caption());

		// w_cm
		$this->w_cm->EditAttrs["class"] = "form-control";
		$this->w_cm->EditCustomAttributes = 'tabindex="999"';
		$this->w_cm->EditValue = $this->w_cm->CurrentValue;
		$this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());

		// l
		$this->l->EditAttrs["class"] = "form-control";
		$this->l->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->l->CurrentValue = HtmlDecode($this->l->CurrentValue);
		$this->l->EditValue = $this->l->CurrentValue;
		$this->l->PlaceHolder = RemoveHtml($this->l->caption());

		// l_cm
		$this->l_cm->EditAttrs["class"] = "form-control";
		$this->l_cm->EditCustomAttributes = 'tabindex="999"';
		$this->l_cm->EditValue = $this->l_cm->CurrentValue;
		$this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());

		// h
		$this->h->EditAttrs["class"] = "form-control";
		$this->h->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->h->CurrentValue = HtmlDecode($this->h->CurrentValue);
		$this->h->EditValue = $this->h->CurrentValue;
		$this->h->PlaceHolder = RemoveHtml($this->h->caption());

		// h_cm
		$this->h_cm->EditAttrs["class"] = "form-control";
		$this->h_cm->EditCustomAttributes = 'tabindex="999"';
		$this->h_cm->EditValue = $this->h_cm->CurrentValue;
		$this->h_cm->PlaceHolder = RemoveHtml($this->h_cm->caption());

		// partner_size
		$this->partner_size->EditAttrs["class"] = "form-control";
		$this->partner_size->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->partner_size->CurrentValue = HtmlDecode($this->partner_size->CurrentValue);
		$this->partner_size->EditValue = $this->partner_size->CurrentValue;
		$this->partner_size->PlaceHolder = RemoveHtml($this->partner_size->caption());

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = 'ReadOnly';
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
		if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
			$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, 0);

		// cbm
		$this->cbm->EditAttrs["class"] = "form-control";
		$this->cbm->EditCustomAttributes = "";
		$this->cbm->EditValue = $this->cbm->CurrentValue;
		$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
		if (strval($this->cbm->EditValue) <> "" && is_numeric($this->cbm->EditValue))
			$this->cbm->EditValue = FormatNumber($this->cbm->EditValue, -2, -2, -2, -2);

		// weight_sqm
		$this->weight_sqm->EditAttrs["class"] = "form-control";
		$this->weight_sqm->EditCustomAttributes = "";
		$this->weight_sqm->EditValue = $this->weight_sqm->CurrentValue;
		$this->weight_sqm->PlaceHolder = RemoveHtml($this->weight_sqm->caption());
		if (strval($this->weight_sqm->EditValue) <> "" && is_numeric($this->weight_sqm->EditValue))
			$this->weight_sqm->EditValue = FormatNumber($this->weight_sqm->EditValue, -2, -2, -2, -2);

		// price
		$this->price->EditAttrs["class"] = "form-control";
		$this->price->EditCustomAttributes = "";
		$this->price->EditValue = $this->price->CurrentValue;
		$this->price->PlaceHolder = RemoveHtml($this->price->caption());
		if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
			$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, 0);

		// price_cs
		$this->price_cs->EditAttrs["class"] = "form-control";
		$this->price_cs->EditCustomAttributes = "";
		$this->price_cs->EditValue = $this->price_cs->CurrentValue;
		$this->price_cs->PlaceHolder = RemoveHtml($this->price_cs->caption());
		if (strval($this->price_cs->EditValue) <> "" && is_numeric($this->price_cs->EditValue))
			$this->price_cs->EditValue = FormatNumber($this->price_cs->EditValue, -2, -2, -2, -2);

		// currency
		$this->currency->EditAttrs["class"] = "form-control";
		$this->currency->EditCustomAttributes = "";

		// hsn
		$this->hsn->EditAttrs["class"] = "form-control";
		$this->hsn->EditCustomAttributes = "";

		// composition
		$this->composition->EditAttrs["class"] = "form-control";
		$this->composition->EditCustomAttributes = "";

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// operator
		// datetime
		// gcode

		$this->gcode->EditAttrs["class"] = "form-control";
		$this->gcode->EditCustomAttributes = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->partner_type);
					$doc->exportCaption($this->partner);
					$doc->exportCaption($this->partner_ref);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->partner_code);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->shape);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->spl_ins);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->w);
					$doc->exportCaption($this->w_cm);
					$doc->exportCaption($this->l);
					$doc->exportCaption($this->l_cm);
					$doc->exportCaption($this->h);
					$doc->exportCaption($this->h_cm);
					$doc->exportCaption($this->partner_size);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->weight_sqm);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->price_cs);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->hsn);
					$doc->exportCaption($this->composition);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->partner_type);
					$doc->exportCaption($this->partner);
					$doc->exportCaption($this->partner_ref);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->partner_code);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->shape);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->spl_ins);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->w);
					$doc->exportCaption($this->w_cm);
					$doc->exportCaption($this->l);
					$doc->exportCaption($this->l_cm);
					$doc->exportCaption($this->h);
					$doc->exportCaption($this->h_cm);
					$doc->exportCaption($this->partner_size);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->weight_sqm);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->price_cs);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->hsn);
					$doc->exportCaption($this->composition);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->partner_type);
						$doc->exportField($this->partner);
						$doc->exportField($this->partner_ref);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->partner_code);
						$doc->exportField($this->product_type);
						$doc->exportField($this->shape);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->spl_ins);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->unit);
						$doc->exportField($this->w);
						$doc->exportField($this->w_cm);
						$doc->exportField($this->l);
						$doc->exportField($this->l_cm);
						$doc->exportField($this->h);
						$doc->exportField($this->h_cm);
						$doc->exportField($this->partner_size);
						$doc->exportField($this->sqm);
						$doc->exportField($this->cbm);
						$doc->exportField($this->weight_sqm);
						$doc->exportField($this->price);
						$doc->exportField($this->price_cs);
						$doc->exportField($this->currency);
						$doc->exportField($this->hsn);
						$doc->exportField($this->composition);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->partner_type);
						$doc->exportField($this->partner);
						$doc->exportField($this->partner_ref);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->partner_code);
						$doc->exportField($this->product_type);
						$doc->exportField($this->shape);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->spl_ins);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->unit);
						$doc->exportField($this->w);
						$doc->exportField($this->w_cm);
						$doc->exportField($this->l);
						$doc->exportField($this->l_cm);
						$doc->exportField($this->h);
						$doc->exportField($this->h_cm);
						$doc->exportField($this->partner_size);
						$doc->exportField($this->sqm);
						$doc->exportField($this->cbm);
						$doc->exportField($this->weight_sqm);
						$doc->exportField($this->price);
						$doc->exportField($this->price_cs);
						$doc->exportField($this->currency);
						$doc->exportField($this->hsn);
						$doc->exportField($this->composition);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>