<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class partner_product_ref_add extends partner_product_ref
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'partner_product_ref';

	// Page object name
	public $PageObjName = "partner_product_ref_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (partner_product_ref)
		if (!isset($GLOBALS["partner_product_ref"]) || get_class($GLOBALS["partner_product_ref"]) == PROJECT_NAMESPACE . "partner_product_ref") {
			$GLOBALS["partner_product_ref"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["partner_product_ref"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Table object (ref)
		if (!isset($GLOBALS['ref']))
			$GLOBALS['ref'] = new ref();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'partner_product_ref');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $partner_product_ref;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($partner_product_ref);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "partner_product_refview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("partner_product_reflist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->partner_type->setVisibility();
		$this->partner->setVisibility();
		$this->partner_ref->setVisibility();
		$this->_barcode->setVisibility();
		$this->partner_code->setVisibility();
		$this->product_type->setVisibility();
		$this->shape->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid->setVisibility();
		$this->spl_ins->setVisibility();
		$this->packing_type->setVisibility();
		$this->batch_no->setVisibility();
		$this->unit->setVisibility();
		$this->w->setVisibility();
		$this->w_cm->setVisibility();
		$this->l->setVisibility();
		$this->l_cm->setVisibility();
		$this->h->setVisibility();
		$this->h_cm->setVisibility();
		$this->partner_size->setVisibility();
		$this->sqm->setVisibility();
		$this->cbm->setVisibility();
		$this->weight_sqm->setVisibility();
		$this->price->setVisibility();
		$this->price_cs->setVisibility();
		$this->currency->setVisibility();
		$this->hsn->setVisibility();
		$this->composition->setVisibility();
		$this->status->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->gcode->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->partner_type);
		$this->setupLookupOptions($this->partner);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->hsn);
		$this->setupLookupOptions($this->composition);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->gcode);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Set up master/detail parameters
		// NOTE: must be after loadOldRecord to prevent master key values overwritten

		$this->setupMasterParms();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("partner_product_reflist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "partner_product_reflist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "partner_product_refview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->partner_type->CurrentValue = User_Category();
		$this->partner->CurrentValue = User_Company_ID();
		$this->partner_ref->CurrentValue = NULL;
		$this->partner_ref->OldValue = $this->partner_ref->CurrentValue;
		$this->_barcode->CurrentValue = NULL;
		$this->_barcode->OldValue = $this->_barcode->CurrentValue;
		$this->partner_code->CurrentValue = NULL;
		$this->partner_code->OldValue = $this->partner_code->CurrentValue;
		$this->product_type->CurrentValue = 0;
		$this->shape->CurrentValue = 1;
		$this->grp->CurrentValue = NULL;
		$this->grp->OldValue = $this->grp->CurrentValue;
		$this->s_grp->CurrentValue = NULL;
		$this->s_grp->OldValue = $this->s_grp->CurrentValue;
		$this->product->CurrentValue = NULL;
		$this->product->OldValue = $this->product->CurrentValue;
		$this->rid->CurrentValue = NULL;
		$this->rid->OldValue = $this->rid->CurrentValue;
		$this->spl_ins->CurrentValue = NULL;
		$this->spl_ins->OldValue = $this->spl_ins->CurrentValue;
		$this->packing_type->CurrentValue = NULL;
		$this->packing_type->OldValue = $this->packing_type->CurrentValue;
		$this->batch_no->CurrentValue = NULL;
		$this->batch_no->OldValue = $this->batch_no->CurrentValue;
		$this->unit->CurrentValue = 1;
		$this->w->CurrentValue = 00;
		$this->w_cm->CurrentValue = NULL;
		$this->w_cm->OldValue = $this->w_cm->CurrentValue;
		$this->l->CurrentValue = 00;
		$this->l_cm->CurrentValue = NULL;
		$this->l_cm->OldValue = $this->l_cm->CurrentValue;
		$this->h->CurrentValue = 00;
		$this->h_cm->CurrentValue = NULL;
		$this->h_cm->OldValue = $this->h_cm->CurrentValue;
		$this->partner_size->CurrentValue = NULL;
		$this->partner_size->OldValue = $this->partner_size->CurrentValue;
		$this->sqm->CurrentValue = NULL;
		$this->sqm->OldValue = $this->sqm->CurrentValue;
		$this->cbm->CurrentValue = 0.0000;
		$this->weight_sqm->CurrentValue = NULL;
		$this->weight_sqm->OldValue = $this->weight_sqm->CurrentValue;
		$this->price->CurrentValue = 0;
		$this->price_cs->CurrentValue = NULL;
		$this->price_cs->OldValue = $this->price_cs->CurrentValue;
		$this->currency->CurrentValue = 1;
		$this->hsn->CurrentValue = NULL;
		$this->hsn->OldValue = $this->hsn->CurrentValue;
		$this->composition->CurrentValue = NULL;
		$this->composition->OldValue = $this->composition->CurrentValue;
		$this->status->CurrentValue = 1;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->gcode->CurrentValue = NULL;
		$this->gcode->OldValue = $this->gcode->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'partner_type' first before field var 'x_partner_type'
		$val = $CurrentForm->hasValue("partner_type") ? $CurrentForm->getValue("partner_type") : $CurrentForm->getValue("x_partner_type");
		if (!$this->partner_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_type->Visible = FALSE; // Disable update for API request
			else
				$this->partner_type->setFormValue($val);
		}

		// Check field name 'partner' first before field var 'x_partner'
		$val = $CurrentForm->hasValue("partner") ? $CurrentForm->getValue("partner") : $CurrentForm->getValue("x_partner");
		if (!$this->partner->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner->Visible = FALSE; // Disable update for API request
			else
				$this->partner->setFormValue($val);
		}

		// Check field name 'partner_ref' first before field var 'x_partner_ref'
		$val = $CurrentForm->hasValue("partner_ref") ? $CurrentForm->getValue("partner_ref") : $CurrentForm->getValue("x_partner_ref");
		if (!$this->partner_ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_ref->Visible = FALSE; // Disable update for API request
			else
				$this->partner_ref->setFormValue($val);
		}

		// Check field name 'barcode' first before field var 'x__barcode'
		$val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
		if (!$this->_barcode->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_barcode->Visible = FALSE; // Disable update for API request
			else
				$this->_barcode->setFormValue($val);
		}

		// Check field name 'partner_code' first before field var 'x_partner_code'
		$val = $CurrentForm->hasValue("partner_code") ? $CurrentForm->getValue("partner_code") : $CurrentForm->getValue("x_partner_code");
		if (!$this->partner_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_code->Visible = FALSE; // Disable update for API request
			else
				$this->partner_code->setFormValue($val);
		}

		// Check field name 'product_type' first before field var 'x_product_type'
		$val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
		if (!$this->product_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_type->Visible = FALSE; // Disable update for API request
			else
				$this->product_type->setFormValue($val);
		}

		// Check field name 'shape' first before field var 'x_shape'
		$val = $CurrentForm->hasValue("shape") ? $CurrentForm->getValue("shape") : $CurrentForm->getValue("x_shape");
		if (!$this->shape->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shape->Visible = FALSE; // Disable update for API request
			else
				$this->shape->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid->Visible = FALSE; // Disable update for API request
			else
				$this->rid->setFormValue($val);
		}

		// Check field name 'spl_ins' first before field var 'x_spl_ins'
		$val = $CurrentForm->hasValue("spl_ins") ? $CurrentForm->getValue("spl_ins") : $CurrentForm->getValue("x_spl_ins");
		if (!$this->spl_ins->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->spl_ins->Visible = FALSE; // Disable update for API request
			else
				$this->spl_ins->setFormValue($val);
		}

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}

		// Check field name 'batch_no' first before field var 'x_batch_no'
		$val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
		if (!$this->batch_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->batch_no->Visible = FALSE; // Disable update for API request
			else
				$this->batch_no->setFormValue($val);
		}

		// Check field name 'unit' first before field var 'x_unit'
		$val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
		if (!$this->unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unit->Visible = FALSE; // Disable update for API request
			else
				$this->unit->setFormValue($val);
		}

		// Check field name 'w' first before field var 'x_w'
		$val = $CurrentForm->hasValue("w") ? $CurrentForm->getValue("w") : $CurrentForm->getValue("x_w");
		if (!$this->w->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->w->Visible = FALSE; // Disable update for API request
			else
				$this->w->setFormValue($val);
		}

		// Check field name 'w_cm' first before field var 'x_w_cm'
		$val = $CurrentForm->hasValue("w_cm") ? $CurrentForm->getValue("w_cm") : $CurrentForm->getValue("x_w_cm");
		if (!$this->w_cm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->w_cm->Visible = FALSE; // Disable update for API request
			else
				$this->w_cm->setFormValue($val);
		}

		// Check field name 'l' first before field var 'x_l'
		$val = $CurrentForm->hasValue("l") ? $CurrentForm->getValue("l") : $CurrentForm->getValue("x_l");
		if (!$this->l->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->l->Visible = FALSE; // Disable update for API request
			else
				$this->l->setFormValue($val);
		}

		// Check field name 'l_cm' first before field var 'x_l_cm'
		$val = $CurrentForm->hasValue("l_cm") ? $CurrentForm->getValue("l_cm") : $CurrentForm->getValue("x_l_cm");
		if (!$this->l_cm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->l_cm->Visible = FALSE; // Disable update for API request
			else
				$this->l_cm->setFormValue($val);
		}

		// Check field name 'h' first before field var 'x_h'
		$val = $CurrentForm->hasValue("h") ? $CurrentForm->getValue("h") : $CurrentForm->getValue("x_h");
		if (!$this->h->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->h->Visible = FALSE; // Disable update for API request
			else
				$this->h->setFormValue($val);
		}

		// Check field name 'h_cm' first before field var 'x_h_cm'
		$val = $CurrentForm->hasValue("h_cm") ? $CurrentForm->getValue("h_cm") : $CurrentForm->getValue("x_h_cm");
		if (!$this->h_cm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->h_cm->Visible = FALSE; // Disable update for API request
			else
				$this->h_cm->setFormValue($val);
		}

		// Check field name 'partner_size' first before field var 'x_partner_size'
		$val = $CurrentForm->hasValue("partner_size") ? $CurrentForm->getValue("partner_size") : $CurrentForm->getValue("x_partner_size");
		if (!$this->partner_size->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_size->Visible = FALSE; // Disable update for API request
			else
				$this->partner_size->setFormValue($val);
		}

		// Check field name 'sqm' first before field var 'x_sqm'
		$val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
		if (!$this->sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sqm->Visible = FALSE; // Disable update for API request
			else
				$this->sqm->setFormValue($val);
		}

		// Check field name 'cbm' first before field var 'x_cbm'
		$val = $CurrentForm->hasValue("cbm") ? $CurrentForm->getValue("cbm") : $CurrentForm->getValue("x_cbm");
		if (!$this->cbm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cbm->Visible = FALSE; // Disable update for API request
			else
				$this->cbm->setFormValue($val);
		}

		// Check field name 'weight_sqm' first before field var 'x_weight_sqm'
		$val = $CurrentForm->hasValue("weight_sqm") ? $CurrentForm->getValue("weight_sqm") : $CurrentForm->getValue("x_weight_sqm");
		if (!$this->weight_sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->weight_sqm->Visible = FALSE; // Disable update for API request
			else
				$this->weight_sqm->setFormValue($val);
		}

		// Check field name 'price' first before field var 'x_price'
		$val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
		if (!$this->price->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->price->Visible = FALSE; // Disable update for API request
			else
				$this->price->setFormValue($val);
		}

		// Check field name 'price_cs' first before field var 'x_price_cs'
		$val = $CurrentForm->hasValue("price_cs") ? $CurrentForm->getValue("price_cs") : $CurrentForm->getValue("x_price_cs");
		if (!$this->price_cs->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->price_cs->Visible = FALSE; // Disable update for API request
			else
				$this->price_cs->setFormValue($val);
		}

		// Check field name 'currency' first before field var 'x_currency'
		$val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
		if (!$this->currency->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->currency->Visible = FALSE; // Disable update for API request
			else
				$this->currency->setFormValue($val);
		}

		// Check field name 'hsn' first before field var 'x_hsn'
		$val = $CurrentForm->hasValue("hsn") ? $CurrentForm->getValue("hsn") : $CurrentForm->getValue("x_hsn");
		if (!$this->hsn->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->hsn->Visible = FALSE; // Disable update for API request
			else
				$this->hsn->setFormValue($val);
		}

		// Check field name 'composition' first before field var 'x_composition'
		$val = $CurrentForm->hasValue("composition") ? $CurrentForm->getValue("composition") : $CurrentForm->getValue("x_composition");
		if (!$this->composition->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->composition->Visible = FALSE; // Disable update for API request
			else
				$this->composition->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 7);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->partner_type->CurrentValue = $this->partner_type->FormValue;
		$this->partner->CurrentValue = $this->partner->FormValue;
		$this->partner_ref->CurrentValue = $this->partner_ref->FormValue;
		$this->_barcode->CurrentValue = $this->_barcode->FormValue;
		$this->partner_code->CurrentValue = $this->partner_code->FormValue;
		$this->product_type->CurrentValue = $this->product_type->FormValue;
		$this->shape->CurrentValue = $this->shape->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->rid->CurrentValue = $this->rid->FormValue;
		$this->spl_ins->CurrentValue = $this->spl_ins->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->batch_no->CurrentValue = $this->batch_no->FormValue;
		$this->unit->CurrentValue = $this->unit->FormValue;
		$this->w->CurrentValue = $this->w->FormValue;
		$this->w_cm->CurrentValue = $this->w_cm->FormValue;
		$this->l->CurrentValue = $this->l->FormValue;
		$this->l_cm->CurrentValue = $this->l_cm->FormValue;
		$this->h->CurrentValue = $this->h->FormValue;
		$this->h_cm->CurrentValue = $this->h_cm->FormValue;
		$this->partner_size->CurrentValue = $this->partner_size->FormValue;
		$this->sqm->CurrentValue = $this->sqm->FormValue;
		$this->cbm->CurrentValue = $this->cbm->FormValue;
		$this->weight_sqm->CurrentValue = $this->weight_sqm->FormValue;
		$this->price->CurrentValue = $this->price->FormValue;
		$this->price_cs->CurrentValue = $this->price_cs->FormValue;
		$this->currency->CurrentValue = $this->currency->FormValue;
		$this->hsn->CurrentValue = $this->hsn->FormValue;
		$this->composition->CurrentValue = $this->composition->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 7);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->partner_type->setDbValue($row['partner_type']);
		$this->partner->setDbValue($row['partner']);
		$this->partner_ref->setDbValue($row['partner_ref']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->partner_code->setDbValue($row['partner_code']);
		$this->product_type->setDbValue($row['product_type']);
		$this->shape->setDbValue($row['shape']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->rid->setDbValue($row['rid']);
		if (array_key_exists('EV__rid', $rs->fields)) {
			$this->rid->VirtualValue = $rs->fields('EV__rid'); // Set up virtual field value
		} else {
			$this->rid->VirtualValue = ""; // Clear value
		}
		$this->spl_ins->setDbValue($row['spl_ins']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->unit->setDbValue($row['unit']);
		$this->w->setDbValue($row['w']);
		$this->w_cm->setDbValue($row['w_cm']);
		$this->l->setDbValue($row['l']);
		$this->l_cm->setDbValue($row['l_cm']);
		$this->h->setDbValue($row['h']);
		$this->h_cm->setDbValue($row['h_cm']);
		$this->partner_size->setDbValue($row['partner_size']);
		$this->sqm->setDbValue($row['sqm']);
		$this->cbm->setDbValue($row['cbm']);
		$this->weight_sqm->setDbValue($row['weight_sqm']);
		$this->price->setDbValue($row['price']);
		$this->price_cs->setDbValue($row['price_cs']);
		$this->currency->setDbValue($row['currency']);
		$this->hsn->setDbValue($row['hsn']);
		$this->composition->setDbValue($row['composition']);
		$this->status->setDbValue($row['status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->gcode->setDbValue($row['gcode']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['partner_type'] = $this->partner_type->CurrentValue;
		$row['partner'] = $this->partner->CurrentValue;
		$row['partner_ref'] = $this->partner_ref->CurrentValue;
		$row['barcode'] = $this->_barcode->CurrentValue;
		$row['partner_code'] = $this->partner_code->CurrentValue;
		$row['product_type'] = $this->product_type->CurrentValue;
		$row['shape'] = $this->shape->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['s_grp'] = $this->s_grp->CurrentValue;
		$row['product'] = $this->product->CurrentValue;
		$row['rid'] = $this->rid->CurrentValue;
		$row['spl_ins'] = $this->spl_ins->CurrentValue;
		$row['packing_type'] = $this->packing_type->CurrentValue;
		$row['batch_no'] = $this->batch_no->CurrentValue;
		$row['unit'] = $this->unit->CurrentValue;
		$row['w'] = $this->w->CurrentValue;
		$row['w_cm'] = $this->w_cm->CurrentValue;
		$row['l'] = $this->l->CurrentValue;
		$row['l_cm'] = $this->l_cm->CurrentValue;
		$row['h'] = $this->h->CurrentValue;
		$row['h_cm'] = $this->h_cm->CurrentValue;
		$row['partner_size'] = $this->partner_size->CurrentValue;
		$row['sqm'] = $this->sqm->CurrentValue;
		$row['cbm'] = $this->cbm->CurrentValue;
		$row['weight_sqm'] = $this->weight_sqm->CurrentValue;
		$row['price'] = $this->price->CurrentValue;
		$row['price_cs'] = $this->price_cs->CurrentValue;
		$row['currency'] = $this->currency->CurrentValue;
		$row['hsn'] = $this->hsn->CurrentValue;
		$row['composition'] = $this->composition->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['gcode'] = $this->gcode->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cbm->FormValue == $this->cbm->CurrentValue && is_numeric(ConvertToFloatString($this->cbm->CurrentValue)))
			$this->cbm->CurrentValue = ConvertToFloatString($this->cbm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->weight_sqm->FormValue == $this->weight_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->weight_sqm->CurrentValue)))
			$this->weight_sqm->CurrentValue = ConvertToFloatString($this->weight_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price_cs->FormValue == $this->price_cs->CurrentValue && is_numeric(ConvertToFloatString($this->price_cs->CurrentValue)))
			$this->price_cs->CurrentValue = ConvertToFloatString($this->price_cs->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// partner_type
		// partner
		// partner_ref
		// barcode
		// partner_code
		// product_type
		// shape
		// grp
		// s_grp
		// product
		// rid
		// spl_ins
		// packing_type
		// batch_no
		// unit
		// w
		// w_cm
		// l
		// l_cm
		// h
		// h_cm
		// partner_size
		// sqm
		// cbm
		// weight_sqm
		// price
		// price_cs
		// currency
		// hsn
		// composition
		// status
		// operator
		// datetime
		// gcode

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// partner_type
			$curVal = strval($this->partner_type->CurrentValue);
			if ($curVal <> "") {
				$this->partner_type->ViewValue = $this->partner_type->lookupCacheOption($curVal);
				if ($this->partner_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return ((User_Category() == 0) ? "FIND_IN_SET(`id`, '1,2') and `status` = 1" : ((User_Category() == 1) ? "`id` = 1 and `status` = 1" : ((User_Category() == 2) ? "`id` = 2 and `status` = 1" : "FIND_IN_SET(`id`, '1,2') and `status` = 1")));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->partner_type->ViewValue = $this->partner_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_type->ViewValue = $this->partner_type->CurrentValue;
					}
				}
			} else {
				$this->partner_type->ViewValue = NULL;
			}
			$this->partner_type->ViewCustomAttributes = "";

			// partner
			$curVal = strval($this->partner->CurrentValue);
			if ($curVal <> "") {
				$this->partner->ViewValue = $this->partner->lookupCacheOption($curVal);
				if ($this->partner->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Category() == 0) ?  "`status` = 1 || `category` = 1" : "(`id` = " .  User_Company_ID()  . " and `status` = 1)  || `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->partner->ViewValue = $this->partner->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner->ViewValue = $this->partner->CurrentValue;
					}
				}
			} else {
				$this->partner->ViewValue = NULL;
			}
			$this->partner->ViewCustomAttributes = "";

			// partner_ref
			$this->partner_ref->ViewValue = $this->partner_ref->CurrentValue;
			$this->partner_ref->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewCustomAttributes = "";

			// partner_code
			$this->partner_code->ViewValue = $this->partner_code->CurrentValue;
			$this->partner_code->ViewCustomAttributes = "";

			// product_type
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `id` != 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shape->ViewValue = $this->shape->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			if ($this->rid->VirtualValue <> "") {
				$this->rid->ViewValue = $this->rid->VirtualValue;
			} else {
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// spl_ins
			$this->spl_ins->ViewValue = $this->spl_ins->CurrentValue;
			$this->spl_ins->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return ((pd_byepass() == 2) ? "`status` = 1" : ((pd_byepass() == 1) ? "(`bom_app_id` >  0 and `status` = 1) || (`a_operator` > 0 and `status` = 1)" : "(`a_operator` > 0 and `status` = 1)"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// unit
			if (strval($this->unit->CurrentValue) <> "") {
				$this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// w
			$this->w->ViewValue = $this->w->CurrentValue;
			$this->w->ViewCustomAttributes = "";

			// w_cm
			$this->w_cm->ViewValue = $this->w_cm->CurrentValue;
			$this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, 2, -2, -2, -2);
			$this->w_cm->ViewCustomAttributes = "";

			// l
			$this->l->ViewValue = $this->l->CurrentValue;
			$this->l->ViewCustomAttributes = "";

			// l_cm
			$this->l_cm->ViewValue = $this->l_cm->CurrentValue;
			$this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, 2, -2, -2, -2);
			$this->l_cm->ViewCustomAttributes = "";

			// h
			$this->h->ViewValue = $this->h->CurrentValue;
			$this->h->ViewCustomAttributes = "";

			// h_cm
			$this->h_cm->ViewValue = $this->h_cm->CurrentValue;
			$this->h_cm->ViewValue = FormatNumber($this->h_cm->ViewValue, 2, -2, -2, -2);
			$this->h_cm->ViewCustomAttributes = "";

			// partner_size
			$this->partner_size->ViewValue = $this->partner_size->CurrentValue;
			$this->partner_size->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 4, -2, -2, 0);
			$this->sqm->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 4, -2, -2, -2);
			$this->cbm->ViewCustomAttributes = "";

			// weight_sqm
			$this->weight_sqm->ViewValue = $this->weight_sqm->CurrentValue;
			$this->weight_sqm->ViewValue = FormatNumber($this->weight_sqm->ViewValue, 3, -2, -2, -2);
			$this->weight_sqm->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, 0);
			$this->price->ViewCustomAttributes = "";

			// price_cs
			$this->price_cs->ViewValue = $this->price_cs->CurrentValue;
			$this->price_cs->ViewValue = FormatNumber($this->price_cs->ViewValue, 2, -2, -2, -2);
			$this->price_cs->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// hsn
			$curVal = strval($this->hsn->CurrentValue);
			if ($curVal <> "") {
				$this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
				if ($this->hsn->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->hsn->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->hsn->ViewValue = $this->hsn->CurrentValue;
					}
				}
			} else {
				$this->hsn->ViewValue = NULL;
			}
			$this->hsn->ViewCustomAttributes = "";

			// composition
			$curVal = strval($this->composition->CurrentValue);
			if ($curVal <> "") {
				$this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
				if ($this->composition->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->composition->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->composition->ViewValue = $this->composition->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->composition->ViewValue = $this->composition->CurrentValue;
					}
				}
			} else {
				$this->composition->ViewValue = NULL;
			}
			$this->composition->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 7);
			$this->datetime->ViewCustomAttributes = "";

			// partner_type
			$this->partner_type->LinkCustomAttributes = "";
			$this->partner_type->HrefValue = "";
			$this->partner_type->TooltipValue = "";

			// partner
			$this->partner->LinkCustomAttributes = "";
			$this->partner->HrefValue = "";
			$this->partner->TooltipValue = "";

			// partner_ref
			$this->partner_ref->LinkCustomAttributes = "";
			$this->partner_ref->HrefValue = "";
			$this->partner_ref->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// partner_code
			$this->partner_code->LinkCustomAttributes = "";
			$this->partner_code->HrefValue = "";
			$this->partner_code->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "product_cart_blist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "product_cart_blist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";
			$this->rid->TooltipValue = "";

			// spl_ins
			$this->spl_ins->LinkCustomAttributes = "";
			$this->spl_ins->HrefValue = "";
			$this->spl_ins->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			if (!EmptyValue($this->unit->CurrentValue)) {
				$this->unit->HrefValue = "product_cart_blist.php?x_ref=" . $this->unit->CurrentValue; // Add prefix/suffix
				$this->unit->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
			} else {
				$this->unit->HrefValue = "";
			}
			$this->unit->TooltipValue = "";

			// w
			$this->w->LinkCustomAttributes = "";
			$this->w->HrefValue = "";
			$this->w->TooltipValue = "";

			// w_cm
			$this->w_cm->LinkCustomAttributes = "";
			$this->w_cm->HrefValue = "";
			$this->w_cm->TooltipValue = "";

			// l
			$this->l->LinkCustomAttributes = "";
			$this->l->HrefValue = "";
			$this->l->TooltipValue = "";

			// l_cm
			$this->l_cm->LinkCustomAttributes = "";
			$this->l_cm->HrefValue = "";
			$this->l_cm->TooltipValue = "";

			// h
			$this->h->LinkCustomAttributes = "";
			$this->h->HrefValue = "";
			$this->h->TooltipValue = "";

			// h_cm
			$this->h_cm->LinkCustomAttributes = "";
			$this->h_cm->HrefValue = "";
			$this->h_cm->TooltipValue = "";

			// partner_size
			$this->partner_size->LinkCustomAttributes = "";
			$this->partner_size->HrefValue = "";
			$this->partner_size->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// weight_sqm
			$this->weight_sqm->LinkCustomAttributes = "";
			$this->weight_sqm->HrefValue = "";
			$this->weight_sqm->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// price_cs
			$this->price_cs->LinkCustomAttributes = "";
			$this->price_cs->HrefValue = "";
			$this->price_cs->TooltipValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";
			$this->currency->TooltipValue = "";

			// hsn
			$this->hsn->LinkCustomAttributes = "";
			$this->hsn->HrefValue = "";
			$this->hsn->TooltipValue = "";

			// composition
			$this->composition->LinkCustomAttributes = "";
			$this->composition->HrefValue = "";
			$this->composition->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// partner_type
			$this->partner_type->EditAttrs["class"] = "form-control";
			$this->partner_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->partner_type->CurrentValue));
			if ($curVal <> "")
				$this->partner_type->ViewValue = $this->partner_type->lookupCacheOption($curVal);
			else
				$this->partner_type->ViewValue = $this->partner_type->Lookup !== NULL && is_array($this->partner_type->Lookup->Options) ? $curVal : NULL;
			if ($this->partner_type->ViewValue !== NULL) { // Load from cache
				$this->partner_type->EditValue = array_values($this->partner_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->partner_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return ((User_Category() == 0) ? "FIND_IN_SET(`id`, '1,2') and `status` = 1" : ((User_Category() == 1) ? "`id` = 1 and `status` = 1" : ((User_Category() == 2) ? "`id` = 2 and `status` = 1" : "FIND_IN_SET(`id`, '1,2') and `status` = 1")));
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->partner_type->EditValue = $arwrk;
			}

			// partner
			$this->partner->EditAttrs["class"] = "form-control";
			$this->partner->EditCustomAttributes = "";
			$curVal = trim(strval($this->partner->CurrentValue));
			if ($curVal <> "")
				$this->partner->ViewValue = $this->partner->lookupCacheOption($curVal);
			else
				$this->partner->ViewValue = $this->partner->Lookup !== NULL && is_array($this->partner->Lookup->Options) ? $curVal : NULL;
			if ($this->partner->ViewValue !== NULL) { // Load from cache
				$this->partner->EditValue = array_values($this->partner->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->partner->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (User_Category() == 0) ?  "`status` = 1 || `category` = 1" : "(`id` = " .  User_Company_ID()  . " and `status` = 1)  || `category` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->partner->EditValue = $arwrk;
			}

			// partner_ref
			$this->partner_ref->EditAttrs["class"] = "form-control";
			$this->partner_ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_ref->CurrentValue = HtmlDecode($this->partner_ref->CurrentValue);
			$this->partner_ref->EditValue = HtmlEncode($this->partner_ref->CurrentValue);
			$this->partner_ref->PlaceHolder = RemoveHtml($this->partner_ref->caption());

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_barcode->CurrentValue = HtmlDecode($this->_barcode->CurrentValue);
			$this->_barcode->EditValue = HtmlEncode($this->_barcode->CurrentValue);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

			// partner_code
			$this->partner_code->EditAttrs["class"] = "form-control";
			$this->partner_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_code->CurrentValue = HtmlDecode($this->partner_code->CurrentValue);
			$this->partner_code->EditValue = HtmlEncode($this->partner_code->CurrentValue);
			$this->partner_code->PlaceHolder = RemoveHtml($this->partner_code->caption());

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_type->CurrentValue));
			if ($curVal <> "")
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
			else
				$this->product_type->ViewValue = $this->product_type->Lookup !== NULL && is_array($this->product_type->Lookup->Options) ? $curVal : NULL;
			if ($this->product_type->ViewValue !== NULL) { // Load from cache
				$this->product_type->EditValue = array_values($this->product_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` != 9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_type->EditValue = $arwrk;
			}

			// shape
			$this->shape->EditAttrs["class"] = "form-control";
			$this->shape->EditCustomAttributes = "";
			$curVal = trim(strval($this->shape->CurrentValue));
			if ($curVal <> "")
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
			else
				$this->shape->ViewValue = $this->shape->Lookup !== NULL && is_array($this->shape->Lookup->Options) ? $curVal : NULL;
			if ($this->shape->ViewValue !== NULL) { // Load from cache
				$this->shape->EditValue = array_values($this->shape->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->shape->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->shape->EditValue = $arwrk;
			}

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->CurrentValue));
			if ($curVal <> "")
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->CurrentValue));
			if ($curVal <> "")
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			if ($this->rid->getSessionValue() <> "") {
				$this->rid->CurrentValue = $this->rid->getSessionValue();
			if ($this->rid->VirtualValue <> "") {
				$this->rid->ViewValue = $this->rid->VirtualValue;
			} else {
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";
			} else {
			$curVal = trim(strval($this->rid->CurrentValue));
			if ($curVal <> "")
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			else
				$this->rid->ViewValue = $this->rid->Lookup !== NULL && is_array($this->rid->Lookup->Options) ? $curVal : NULL;
			if ($this->rid->ViewValue !== NULL) { // Load from cache
				$this->rid->EditValue = array_values($this->rid->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->rid->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->rid->EditValue = $arwrk;
			}
			}

			// spl_ins
			$this->spl_ins->EditAttrs["class"] = "form-control";
			$this->spl_ins->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->spl_ins->CurrentValue = HtmlDecode($this->spl_ins->CurrentValue);
			$this->spl_ins->EditValue = HtmlEncode($this->spl_ins->CurrentValue);
			$this->spl_ins->PlaceHolder = RemoveHtml($this->spl_ins->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_type->CurrentValue));
			if ($curVal <> "")
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			else
				$this->packing_type->ViewValue = $this->packing_type->Lookup !== NULL && is_array($this->packing_type->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_type->ViewValue !== NULL) { // Load from cache
				$this->packing_type->EditValue = array_values($this->packing_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->packing_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->packing_type->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->packing_type->EditValue = $arwrk;
			}

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->batch_no->CurrentValue));
			if ($curVal <> "")
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			else
				$this->batch_no->ViewValue = $this->batch_no->Lookup !== NULL && is_array($this->batch_no->Lookup->Options) ? $curVal : NULL;
			if ($this->batch_no->ViewValue !== NULL) { // Load from cache
				$this->batch_no->EditValue = array_values($this->batch_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->batch_no->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return ((pd_byepass() == 2) ? "`status` = 1" : ((pd_byepass() == 1) ? "(`bom_app_id` >  0 and `status` = 1) || (`a_operator` > 0 and `status` = 1)" : "(`a_operator` > 0 and `status` = 1)"));
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->batch_no->EditValue = $arwrk;
			}

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";
			$this->unit->EditValue = $this->unit->options(TRUE);

			// w
			$this->w->EditAttrs["class"] = "form-control";
			$this->w->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->w->CurrentValue = HtmlDecode($this->w->CurrentValue);
			$this->w->EditValue = HtmlEncode($this->w->CurrentValue);
			$this->w->PlaceHolder = RemoveHtml($this->w->caption());

			// w_cm
			$this->w_cm->EditAttrs["class"] = "form-control";
			$this->w_cm->EditCustomAttributes = 'tabindex="999"';
			$this->w_cm->EditValue = HtmlEncode($this->w_cm->CurrentValue);
			$this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());

			// l
			$this->l->EditAttrs["class"] = "form-control";
			$this->l->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->l->CurrentValue = HtmlDecode($this->l->CurrentValue);
			$this->l->EditValue = HtmlEncode($this->l->CurrentValue);
			$this->l->PlaceHolder = RemoveHtml($this->l->caption());

			// l_cm
			$this->l_cm->EditAttrs["class"] = "form-control";
			$this->l_cm->EditCustomAttributes = 'tabindex="999"';
			$this->l_cm->EditValue = HtmlEncode($this->l_cm->CurrentValue);
			$this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());

			// h
			$this->h->EditAttrs["class"] = "form-control";
			$this->h->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->h->CurrentValue = HtmlDecode($this->h->CurrentValue);
			$this->h->EditValue = HtmlEncode($this->h->CurrentValue);
			$this->h->PlaceHolder = RemoveHtml($this->h->caption());

			// h_cm
			$this->h_cm->EditAttrs["class"] = "form-control";
			$this->h_cm->EditCustomAttributes = 'tabindex="999"';
			$this->h_cm->EditValue = HtmlEncode($this->h_cm->CurrentValue);
			$this->h_cm->PlaceHolder = RemoveHtml($this->h_cm->caption());

			// partner_size
			$this->partner_size->EditAttrs["class"] = "form-control";
			$this->partner_size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_size->CurrentValue = HtmlDecode($this->partner_size->CurrentValue);
			$this->partner_size->EditValue = HtmlEncode($this->partner_size->CurrentValue);
			$this->partner_size->PlaceHolder = RemoveHtml($this->partner_size->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = 'ReadOnly';
			$this->sqm->EditValue = HtmlEncode($this->sqm->CurrentValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
			if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
				$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, 0);

			// cbm
			$this->cbm->EditAttrs["class"] = "form-control";
			$this->cbm->EditCustomAttributes = "";
			$this->cbm->EditValue = HtmlEncode($this->cbm->CurrentValue);
			$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
			if (strval($this->cbm->EditValue) <> "" && is_numeric($this->cbm->EditValue))
				$this->cbm->EditValue = FormatNumber($this->cbm->EditValue, -2, -2, -2, -2);

			// weight_sqm
			$this->weight_sqm->EditAttrs["class"] = "form-control";
			$this->weight_sqm->EditCustomAttributes = "";
			$this->weight_sqm->EditValue = HtmlEncode($this->weight_sqm->CurrentValue);
			$this->weight_sqm->PlaceHolder = RemoveHtml($this->weight_sqm->caption());
			if (strval($this->weight_sqm->EditValue) <> "" && is_numeric($this->weight_sqm->EditValue))
				$this->weight_sqm->EditValue = FormatNumber($this->weight_sqm->EditValue, -2, -2, -2, -2);

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = HtmlEncode($this->price->CurrentValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());
			if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
				$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, 0);

			// price_cs
			$this->price_cs->EditAttrs["class"] = "form-control";
			$this->price_cs->EditCustomAttributes = "";
			$this->price_cs->EditValue = HtmlEncode($this->price_cs->CurrentValue);
			$this->price_cs->PlaceHolder = RemoveHtml($this->price_cs->caption());
			if (strval($this->price_cs->EditValue) <> "" && is_numeric($this->price_cs->EditValue))
				$this->price_cs->EditValue = FormatNumber($this->price_cs->EditValue, -2, -2, -2, -2);

			// currency
			$this->currency->EditAttrs["class"] = "form-control";
			$this->currency->EditCustomAttributes = "";
			$curVal = trim(strval($this->currency->CurrentValue));
			if ($curVal <> "")
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			else
				$this->currency->ViewValue = $this->currency->Lookup !== NULL && is_array($this->currency->Lookup->Options) ? $curVal : NULL;
			if ($this->currency->ViewValue !== NULL) { // Load from cache
				$this->currency->EditValue = array_values($this->currency->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->currency->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->currency->EditValue = $arwrk;
			}

			// hsn
			$this->hsn->EditAttrs["class"] = "form-control";
			$this->hsn->EditCustomAttributes = "";
			$curVal = trim(strval($this->hsn->CurrentValue));
			if ($curVal <> "")
				$this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
			else
				$this->hsn->ViewValue = $this->hsn->Lookup !== NULL && is_array($this->hsn->Lookup->Options) ? $curVal : NULL;
			if ($this->hsn->ViewValue !== NULL) { // Load from cache
				$this->hsn->EditValue = array_values($this->hsn->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->hsn->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->hsn->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
				}
				$this->hsn->EditValue = $arwrk;
			}

			// composition
			$this->composition->EditAttrs["class"] = "form-control";
			$this->composition->EditCustomAttributes = "";
			$curVal = trim(strval($this->composition->CurrentValue));
			if ($curVal <> "")
				$this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
			else
				$this->composition->ViewValue = $this->composition->Lookup !== NULL && is_array($this->composition->Lookup->Options) ? $curVal : NULL;
			if ($this->composition->ViewValue !== NULL) { // Load from cache
				$this->composition->EditValue = array_values($this->composition->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->composition->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->composition->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->composition->EditValue = $arwrk;
			}

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// operator
			// datetime
			// Add refer script
			// partner_type

			$this->partner_type->LinkCustomAttributes = "";
			$this->partner_type->HrefValue = "";

			// partner
			$this->partner->LinkCustomAttributes = "";
			$this->partner->HrefValue = "";

			// partner_ref
			$this->partner_ref->LinkCustomAttributes = "";
			$this->partner_ref->HrefValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";

			// partner_code
			$this->partner_code->LinkCustomAttributes = "";
			$this->partner_code->HrefValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "product_cart_blist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "product_cart_blist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";

			// spl_ins
			$this->spl_ins->LinkCustomAttributes = "";
			$this->spl_ins->HrefValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			if (!EmptyValue($this->unit->CurrentValue)) {
				$this->unit->HrefValue = "product_cart_blist.php?x_ref=" . $this->unit->CurrentValue; // Add prefix/suffix
				$this->unit->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
			} else {
				$this->unit->HrefValue = "";
			}

			// w
			$this->w->LinkCustomAttributes = "";
			$this->w->HrefValue = "";

			// w_cm
			$this->w_cm->LinkCustomAttributes = "";
			$this->w_cm->HrefValue = "";

			// l
			$this->l->LinkCustomAttributes = "";
			$this->l->HrefValue = "";

			// l_cm
			$this->l_cm->LinkCustomAttributes = "";
			$this->l_cm->HrefValue = "";

			// h
			$this->h->LinkCustomAttributes = "";
			$this->h->HrefValue = "";

			// h_cm
			$this->h_cm->LinkCustomAttributes = "";
			$this->h_cm->HrefValue = "";

			// partner_size
			$this->partner_size->LinkCustomAttributes = "";
			$this->partner_size->HrefValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";

			// weight_sqm
			$this->weight_sqm->LinkCustomAttributes = "";
			$this->weight_sqm->HrefValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";

			// price_cs
			$this->price_cs->LinkCustomAttributes = "";
			$this->price_cs->HrefValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";

			// hsn
			$this->hsn->LinkCustomAttributes = "";
			$this->hsn->HrefValue = "";

			// composition
			$this->composition->LinkCustomAttributes = "";
			$this->composition->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->partner_type->Required) {
			if (!$this->partner_type->IsDetailKey && $this->partner_type->FormValue != NULL && $this->partner_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_type->caption(), $this->partner_type->RequiredErrorMessage));
			}
		}
		if ($this->partner->Required) {
			if (!$this->partner->IsDetailKey && $this->partner->FormValue != NULL && $this->partner->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner->caption(), $this->partner->RequiredErrorMessage));
			}
		}
		if ($this->partner_ref->Required) {
			if (!$this->partner_ref->IsDetailKey && $this->partner_ref->FormValue != NULL && $this->partner_ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_ref->caption(), $this->partner_ref->RequiredErrorMessage));
			}
		}
		if ($this->_barcode->Required) {
			if (!$this->_barcode->IsDetailKey && $this->_barcode->FormValue != NULL && $this->_barcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
			}
		}
		if ($this->partner_code->Required) {
			if (!$this->partner_code->IsDetailKey && $this->partner_code->FormValue != NULL && $this->partner_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_code->caption(), $this->partner_code->RequiredErrorMessage));
			}
		}
		if ($this->product_type->Required) {
			if (!$this->product_type->IsDetailKey && $this->product_type->FormValue != NULL && $this->product_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
			}
		}
		if ($this->shape->Required) {
			if (!$this->shape->IsDetailKey && $this->shape->FormValue != NULL && $this->shape->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->rid->Required) {
			if (!$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if ($this->spl_ins->Required) {
			if (!$this->spl_ins->IsDetailKey && $this->spl_ins->FormValue != NULL && $this->spl_ins->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->spl_ins->caption(), $this->spl_ins->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->batch_no->Required) {
			if (!$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if ($this->unit->Required) {
			if (!$this->unit->IsDetailKey && $this->unit->FormValue != NULL && $this->unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
			}
		}
		if ($this->w->Required) {
			if (!$this->w->IsDetailKey && $this->w->FormValue != NULL && $this->w->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->w->caption(), $this->w->RequiredErrorMessage));
			}
		}
		if ($this->w_cm->Required) {
			if (!$this->w_cm->IsDetailKey && $this->w_cm->FormValue != NULL && $this->w_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->w_cm->caption(), $this->w_cm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->w_cm->FormValue)) {
			AddMessage($FormError, $this->w_cm->errorMessage());
		}
		if ($this->l->Required) {
			if (!$this->l->IsDetailKey && $this->l->FormValue != NULL && $this->l->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->l->caption(), $this->l->RequiredErrorMessage));
			}
		}
		if ($this->l_cm->Required) {
			if (!$this->l_cm->IsDetailKey && $this->l_cm->FormValue != NULL && $this->l_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->l_cm->caption(), $this->l_cm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->l_cm->FormValue)) {
			AddMessage($FormError, $this->l_cm->errorMessage());
		}
		if ($this->h->Required) {
			if (!$this->h->IsDetailKey && $this->h->FormValue != NULL && $this->h->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->h->caption(), $this->h->RequiredErrorMessage));
			}
		}
		if ($this->h_cm->Required) {
			if (!$this->h_cm->IsDetailKey && $this->h_cm->FormValue != NULL && $this->h_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->h_cm->caption(), $this->h_cm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->h_cm->FormValue)) {
			AddMessage($FormError, $this->h_cm->errorMessage());
		}
		if ($this->partner_size->Required) {
			if (!$this->partner_size->IsDetailKey && $this->partner_size->FormValue != NULL && $this->partner_size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_size->caption(), $this->partner_size->RequiredErrorMessage));
			}
		}
		if ($this->sqm->Required) {
			if (!$this->sqm->IsDetailKey && $this->sqm->FormValue != NULL && $this->sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
			}
		}
		if ($this->cbm->Required) {
			if (!$this->cbm->IsDetailKey && $this->cbm->FormValue != NULL && $this->cbm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->cbm->FormValue)) {
			AddMessage($FormError, $this->cbm->errorMessage());
		}
		if ($this->weight_sqm->Required) {
			if (!$this->weight_sqm->IsDetailKey && $this->weight_sqm->FormValue != NULL && $this->weight_sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->weight_sqm->caption(), $this->weight_sqm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->weight_sqm->FormValue)) {
			AddMessage($FormError, $this->weight_sqm->errorMessage());
		}
		if ($this->price->Required) {
			if (!$this->price->IsDetailKey && $this->price->FormValue != NULL && $this->price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->price->FormValue)) {
			AddMessage($FormError, $this->price->errorMessage());
		}
		if ($this->price_cs->Required) {
			if (!$this->price_cs->IsDetailKey && $this->price_cs->FormValue != NULL && $this->price_cs->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price_cs->caption(), $this->price_cs->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->price_cs->FormValue)) {
			AddMessage($FormError, $this->price_cs->errorMessage());
		}
		if ($this->currency->Required) {
			if (!$this->currency->IsDetailKey && $this->currency->FormValue != NULL && $this->currency->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
			}
		}
		if ($this->hsn->Required) {
			if (!$this->hsn->IsDetailKey && $this->hsn->FormValue != NULL && $this->hsn->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->hsn->caption(), $this->hsn->RequiredErrorMessage));
			}
		}
		if ($this->composition->Required) {
			if (!$this->composition->IsDetailKey && $this->composition->FormValue != NULL && $this->composition->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->composition->caption(), $this->composition->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->gcode->Required) {
			if (!$this->gcode->IsDetailKey && $this->gcode->FormValue != NULL && $this->gcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gcode->caption(), $this->gcode->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// partner_type
		$this->partner_type->setDbValueDef($rsnew, $this->partner_type->CurrentValue, 0, FALSE);

		// partner
		$this->partner->setDbValueDef($rsnew, $this->partner->CurrentValue, 0, FALSE);

		// partner_ref
		$this->partner_ref->setDbValueDef($rsnew, $this->partner_ref->CurrentValue, "", FALSE);

		// barcode
		$this->_barcode->setDbValueDef($rsnew, $this->_barcode->CurrentValue, NULL, FALSE);

		// partner_code
		$this->partner_code->setDbValueDef($rsnew, $this->partner_code->CurrentValue, NULL, FALSE);

		// product_type
		$this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, NULL, FALSE);

		// shape
		$this->shape->setDbValueDef($rsnew, $this->shape->CurrentValue, NULL, FALSE);

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, NULL, FALSE);

		// s_grp
		$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, NULL, FALSE);

		// product
		$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, NULL, FALSE);

		// rid
		$this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, NULL, FALSE);

		// spl_ins
		$this->spl_ins->setDbValueDef($rsnew, $this->spl_ins->CurrentValue, NULL, FALSE);

		// packing_type
		$this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, NULL, FALSE);

		// batch_no
		$this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, NULL, FALSE);

		// unit
		$this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, NULL, FALSE);

		// w
		$this->w->setDbValueDef($rsnew, $this->w->CurrentValue, NULL, FALSE);

		// w_cm
		$this->w_cm->setDbValueDef($rsnew, $this->w_cm->CurrentValue, NULL, FALSE);

		// l
		$this->l->setDbValueDef($rsnew, $this->l->CurrentValue, NULL, FALSE);

		// l_cm
		$this->l_cm->setDbValueDef($rsnew, $this->l_cm->CurrentValue, NULL, FALSE);

		// h
		$this->h->setDbValueDef($rsnew, $this->h->CurrentValue, NULL, FALSE);

		// h_cm
		$this->h_cm->setDbValueDef($rsnew, $this->h_cm->CurrentValue, NULL, FALSE);

		// partner_size
		$this->partner_size->setDbValueDef($rsnew, $this->partner_size->CurrentValue, NULL, FALSE);

		// sqm
		$this->sqm->setDbValueDef($rsnew, $this->sqm->CurrentValue, NULL, FALSE);

		// cbm
		$this->cbm->setDbValueDef($rsnew, $this->cbm->CurrentValue, 0, strval($this->cbm->CurrentValue) == "");

		// weight_sqm
		$this->weight_sqm->setDbValueDef($rsnew, $this->weight_sqm->CurrentValue, 0, FALSE);

		// price
		$this->price->setDbValueDef($rsnew, $this->price->CurrentValue, NULL, FALSE);

		// price_cs
		$this->price_cs->setDbValueDef($rsnew, $this->price_cs->CurrentValue, NULL, FALSE);

		// currency
		$this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, NULL, FALSE);

		// hsn
		$this->hsn->setDbValueDef($rsnew, $this->hsn->CurrentValue, NULL, FALSE);

		// composition
		$this->composition->setDbValueDef($rsnew, $this->composition->CurrentValue, NULL, FALSE);

		// status
		$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, 0, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (Get(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Get(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "ref") {
				$validMaster = TRUE;
				if (Get("fk_id") !== NULL) {
					$this->rid->setQueryStringValue(Get("fk_id"));
					$this->rid->setSessionValue($this->rid->QueryStringValue);
					if (!is_numeric($this->rid->QueryStringValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (Post(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Post(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "ref") {
				$validMaster = TRUE;
				if (Post("fk_id") !== NULL) {
					$this->rid->setFormValue(Post("fk_id"));
					$this->rid->setSessionValue($this->rid->FormValue);
					if (!is_numeric($this->rid->FormValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRec = 1;
				$this->setStartRecordNumber($this->StartRec);
			}

			// Clear previous master key from Session
			if ($masterTblVar <> "ref") {
				if ($this->rid->CurrentValue == "")
					$this->rid->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("partner_product_reflist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_partner_type":
					$lookupFilter = function() {
						return ((User_Category() == 0) ? "FIND_IN_SET(`id`, '1,2') and `status` = 1" : ((User_Category() == 1) ? "`id` = 1 and `status` = 1" : ((User_Category() == 2) ? "`id` = 2 and `status` = 1" : "FIND_IN_SET(`id`, '1,2') and `status` = 1")));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner":
					$lookupFilter = function() {
						return (User_Category() == 0) ?  "`status` = 1 || `category` = 1" : "(`id` = " .  User_Company_ID()  . " and `status` = 1)  || `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_type":
					$lookupFilter = function() {
						return "`status`=1 and `id` != 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_batch_no":
					$lookupFilter = function() {
						return ((pd_byepass() == 2) ? "`status` = 1" : ((pd_byepass() == 1) ? "(`bom_app_id` >  0 and `status` = 1) || (`a_operator` > 0 and `status` = 1)" : "(`a_operator` > 0 and `status` = 1)"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_hsn":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_composition":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_partner_type":
							break;
						case "x_partner":
							break;
						case "x_product_type":
							break;
						case "x_shape":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_packing_type":
							break;
						case "x_batch_no":
							break;
						case "x_currency":
							break;
						case "x_hsn":
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
						case "x_composition":
							break;
						case "x_operator":
							break;
						case "x_gcode":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'partner_product_ref');
		$this->w_cm->ReadOnly = True;
		$this->l_cm->ReadOnly = True;
		$this->h_cm->ReadOnly = True;
		$this->gcode->ReadOnly=TRUE;
		IF (isset($_GET['showmaster']) && isset($_GET['fk_id']))
		{
		$this->grp->Visible = False;
		$this->s_grp->Visible = False;
		$this->product->Visible = False;
		} else {
		$this->grp->Visible = True;
		$this->s_grp->Visible = True;
		$this->product->Visible = True;
		}
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>