<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class partner_product_ref_update extends partner_product_ref
{

	// Page ID
	public $PageID = "update";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'partner_product_ref';

	// Page object name
	public $PageObjName = "partner_product_ref_update";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (partner_product_ref)
		if (!isset($GLOBALS["partner_product_ref"]) || get_class($GLOBALS["partner_product_ref"]) == PROJECT_NAMESPACE . "partner_product_ref") {
			$GLOBALS["partner_product_ref"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["partner_product_ref"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Table object (ref)
		if (!isset($GLOBALS['ref']))
			$GLOBALS['ref'] = new ref();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'update');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'partner_product_ref');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $partner_product_ref;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($partner_product_ref);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "partner_product_refview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-update-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $RecKeys;
	public $Disabled;
	public $UpdateCount = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("partner_product_reflist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->partner_type->Visible = FALSE;
		$this->partner->Visible = FALSE;
		$this->partner_ref->Visible = FALSE;
		$this->_barcode->Visible = FALSE;
		$this->partner_code->Visible = FALSE;
		$this->product_type->Visible = FALSE;
		$this->shape->Visible = FALSE;
		$this->grp->setVisibility();
		$this->s_grp->Visible = FALSE;
		$this->product->Visible = FALSE;
		$this->rid->Visible = FALSE;
		$this->spl_ins->setVisibility();
		$this->packing_type->setVisibility();
		$this->batch_no->Visible = FALSE;
		$this->unit->Visible = FALSE;
		$this->w->Visible = FALSE;
		$this->w_cm->Visible = FALSE;
		$this->l->Visible = FALSE;
		$this->l_cm->Visible = FALSE;
		$this->h->Visible = FALSE;
		$this->h_cm->Visible = FALSE;
		$this->partner_size->Visible = FALSE;
		$this->sqm->Visible = FALSE;
		$this->cbm->Visible = FALSE;
		$this->weight_sqm->setVisibility();
		$this->price->setVisibility();
		$this->price_cs->setVisibility();
		$this->currency->setVisibility();
		$this->hsn->setVisibility();
		$this->composition->setVisibility();
		$this->status->Visible = FALSE;
		$this->operator->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->gcode->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->partner_type);
		$this->setupLookupOptions($this->partner);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->hsn);
		$this->setupLookupOptions($this->composition);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->gcode);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-update-form ew-horizontal";

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Try to load keys from list form
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		if (Post("action") !== NULL && Post("action") !== "") {

			// Get action
			$this->CurrentAction = Post("action");
			$this->loadFormValues(); // Get form values

			// Validate form
			if (!$this->validateForm()) {
				$this->CurrentAction = "show"; // Form error, reset action
				$this->setFailureMessage($FormError);
			}
		} else {
			$this->loadMultiUpdateValues(); // Load initial values to form
		}
		if (count($this->RecKeys) <= 0)
			$this->terminate("partner_product_reflist.php"); // No records selected, return to list
		if ($this->isUpdate()) {
				if ($this->updateRows()) { // Update Records based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
					$this->terminate($this->getReturnUrl()); // Return to caller
				} else {
					$this->restoreFormValues(); // Restore form values
				}
		}

		// Render row
		if ($this->isConfirm()) { // Confirm page
			$this->RowType = ROWTYPE_VIEW; // Render view
			$this->Disabled = " disabled";
		} else {
			$this->RowType = ROWTYPE_EDIT; // Render edit
			$this->Disabled = "";
		}
		$this->resetAttributes();
		$this->renderRow();
	}

	// Load initial values to form if field values are identical in all selected records
	protected function loadMultiUpdateValues()
	{
		$this->CurrentFilter = $this->getFilterFromRecordKeys();

		// Load recordset
		if ($this->Recordset = $this->loadRecordset()) {
			$i = 1;
			while (!$this->Recordset->EOF) {
				if ($i == 1) {
					$this->grp->setDbValue($this->Recordset->fields('grp'));
					$this->spl_ins->setDbValue($this->Recordset->fields('spl_ins'));
					$this->packing_type->setDbValue($this->Recordset->fields('packing_type'));
					$this->weight_sqm->setDbValue($this->Recordset->fields('weight_sqm'));
					$this->price->setDbValue($this->Recordset->fields('price'));
					$this->price_cs->setDbValue($this->Recordset->fields('price_cs'));
					$this->currency->setDbValue($this->Recordset->fields('currency'));
					$this->hsn->setDbValue($this->Recordset->fields('hsn'));
					$this->composition->setDbValue($this->Recordset->fields('composition'));
				} else {
					if (!CompareValue($this->grp->DbValue, $this->Recordset->fields('grp')))
						$this->grp->CurrentValue = NULL;
					if (!CompareValue($this->spl_ins->DbValue, $this->Recordset->fields('spl_ins')))
						$this->spl_ins->CurrentValue = NULL;
					if (!CompareValue($this->packing_type->DbValue, $this->Recordset->fields('packing_type')))
						$this->packing_type->CurrentValue = NULL;
					if (!CompareValue($this->weight_sqm->DbValue, $this->Recordset->fields('weight_sqm')))
						$this->weight_sqm->CurrentValue = NULL;
					if (!CompareValue($this->price->DbValue, $this->Recordset->fields('price')))
						$this->price->CurrentValue = NULL;
					if (!CompareValue($this->price_cs->DbValue, $this->Recordset->fields('price_cs')))
						$this->price_cs->CurrentValue = NULL;
					if (!CompareValue($this->currency->DbValue, $this->Recordset->fields('currency')))
						$this->currency->CurrentValue = NULL;
					if (!CompareValue($this->hsn->DbValue, $this->Recordset->fields('hsn')))
						$this->hsn->CurrentValue = NULL;
					if (!CompareValue($this->composition->DbValue, $this->Recordset->fields('composition')))
						$this->composition->CurrentValue = NULL;
				}
				$i++;
				$this->Recordset->moveNext();
			}
			$this->Recordset->close();
		}
	}

	// Set up key value
	protected function setupKeyValues($key)
	{
		$keyFld = $key;
		if (!is_numeric($keyFld))
			return FALSE;
		$this->id->CurrentValue = $keyFld;
		return TRUE;
	}

	// Update all selected rows
	protected function updateRows()
	{
		global $Language;
		$conn = &$this->getConnection();
		$conn->beginTrans();

		// Get old recordset
		$this->CurrentFilter = $this->getFilterFromRecordKeys();
		$sql = $this->getCurrentSql();
		$rsold = $conn->execute($sql);

		// Update all rows
		$key = "";
		foreach ($this->RecKeys as $reckey) {
			if ($this->setupKeyValues($reckey)) {
				$thisKey = $reckey;
				$this->SendEmail = FALSE; // Do not send email on update success
				$this->UpdateCount += 1; // Update record count for records being updated
				$updateRows = $this->editRow(); // Update this row
			} else {
				$updateRows = FALSE;
			}
			if (!$updateRows)
				break; // Update failed
			if ($key <> "")
				$key .= ", ";
			$key .= $thisKey;
		}

		// Check if all rows updated
		if ($updateRows) {
			$conn->commitTrans(); // Commit transaction

			// Get new recordset
			$rsnew = $conn->execute($sql);
		} else {
			$conn->rollbackTrans(); // Rollback transaction
		}
		return $updateRows;
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}
		$this->grp->MultiUpdate = $CurrentForm->getValue("u_grp");

		// Check field name 'spl_ins' first before field var 'x_spl_ins'
		$val = $CurrentForm->hasValue("spl_ins") ? $CurrentForm->getValue("spl_ins") : $CurrentForm->getValue("x_spl_ins");
		if (!$this->spl_ins->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->spl_ins->Visible = FALSE; // Disable update for API request
			else
				$this->spl_ins->setFormValue($val);
		}
		$this->spl_ins->MultiUpdate = $CurrentForm->getValue("u_spl_ins");

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}
		$this->packing_type->MultiUpdate = $CurrentForm->getValue("u_packing_type");

		// Check field name 'weight_sqm' first before field var 'x_weight_sqm'
		$val = $CurrentForm->hasValue("weight_sqm") ? $CurrentForm->getValue("weight_sqm") : $CurrentForm->getValue("x_weight_sqm");
		if (!$this->weight_sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->weight_sqm->Visible = FALSE; // Disable update for API request
			else
				$this->weight_sqm->setFormValue($val);
		}
		$this->weight_sqm->MultiUpdate = $CurrentForm->getValue("u_weight_sqm");

		// Check field name 'price' first before field var 'x_price'
		$val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
		if (!$this->price->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->price->Visible = FALSE; // Disable update for API request
			else
				$this->price->setFormValue($val);
		}
		$this->price->MultiUpdate = $CurrentForm->getValue("u_price");

		// Check field name 'price_cs' first before field var 'x_price_cs'
		$val = $CurrentForm->hasValue("price_cs") ? $CurrentForm->getValue("price_cs") : $CurrentForm->getValue("x_price_cs");
		if (!$this->price_cs->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->price_cs->Visible = FALSE; // Disable update for API request
			else
				$this->price_cs->setFormValue($val);
		}
		$this->price_cs->MultiUpdate = $CurrentForm->getValue("u_price_cs");

		// Check field name 'currency' first before field var 'x_currency'
		$val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
		if (!$this->currency->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->currency->Visible = FALSE; // Disable update for API request
			else
				$this->currency->setFormValue($val);
		}
		$this->currency->MultiUpdate = $CurrentForm->getValue("u_currency");

		// Check field name 'hsn' first before field var 'x_hsn'
		$val = $CurrentForm->hasValue("hsn") ? $CurrentForm->getValue("hsn") : $CurrentForm->getValue("x_hsn");
		if (!$this->hsn->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->hsn->Visible = FALSE; // Disable update for API request
			else
				$this->hsn->setFormValue($val);
		}
		$this->hsn->MultiUpdate = $CurrentForm->getValue("u_hsn");

		// Check field name 'composition' first before field var 'x_composition'
		$val = $CurrentForm->hasValue("composition") ? $CurrentForm->getValue("composition") : $CurrentForm->getValue("x_composition");
		if (!$this->composition->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->composition->Visible = FALSE; // Disable update for API request
			else
				$this->composition->setFormValue($val);
		}
		$this->composition->MultiUpdate = $CurrentForm->getValue("u_composition");

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->spl_ins->CurrentValue = $this->spl_ins->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->weight_sqm->CurrentValue = $this->weight_sqm->FormValue;
		$this->price->CurrentValue = $this->price->FormValue;
		$this->price_cs->CurrentValue = $this->price_cs->FormValue;
		$this->currency->CurrentValue = $this->currency->FormValue;
		$this->hsn->CurrentValue = $this->hsn->FormValue;
		$this->composition->CurrentValue = $this->composition->FormValue;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->partner_type->setDbValue($row['partner_type']);
		$this->partner->setDbValue($row['partner']);
		$this->partner_ref->setDbValue($row['partner_ref']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->partner_code->setDbValue($row['partner_code']);
		$this->product_type->setDbValue($row['product_type']);
		$this->shape->setDbValue($row['shape']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->rid->setDbValue($row['rid']);
		if (array_key_exists('EV__rid', $rs->fields)) {
			$this->rid->VirtualValue = $rs->fields('EV__rid'); // Set up virtual field value
		} else {
			$this->rid->VirtualValue = ""; // Clear value
		}
		$this->spl_ins->setDbValue($row['spl_ins']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->unit->setDbValue($row['unit']);
		$this->w->setDbValue($row['w']);
		$this->w_cm->setDbValue($row['w_cm']);
		$this->l->setDbValue($row['l']);
		$this->l_cm->setDbValue($row['l_cm']);
		$this->h->setDbValue($row['h']);
		$this->h_cm->setDbValue($row['h_cm']);
		$this->partner_size->setDbValue($row['partner_size']);
		$this->sqm->setDbValue($row['sqm']);
		$this->cbm->setDbValue($row['cbm']);
		$this->weight_sqm->setDbValue($row['weight_sqm']);
		$this->price->setDbValue($row['price']);
		$this->price_cs->setDbValue($row['price_cs']);
		$this->currency->setDbValue($row['currency']);
		$this->hsn->setDbValue($row['hsn']);
		$this->composition->setDbValue($row['composition']);
		$this->status->setDbValue($row['status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->gcode->setDbValue($row['gcode']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['partner_type'] = NULL;
		$row['partner'] = NULL;
		$row['partner_ref'] = NULL;
		$row['barcode'] = NULL;
		$row['partner_code'] = NULL;
		$row['product_type'] = NULL;
		$row['shape'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['rid'] = NULL;
		$row['spl_ins'] = NULL;
		$row['packing_type'] = NULL;
		$row['batch_no'] = NULL;
		$row['unit'] = NULL;
		$row['w'] = NULL;
		$row['w_cm'] = NULL;
		$row['l'] = NULL;
		$row['l_cm'] = NULL;
		$row['h'] = NULL;
		$row['h_cm'] = NULL;
		$row['partner_size'] = NULL;
		$row['sqm'] = NULL;
		$row['cbm'] = NULL;
		$row['weight_sqm'] = NULL;
		$row['price'] = NULL;
		$row['price_cs'] = NULL;
		$row['currency'] = NULL;
		$row['hsn'] = NULL;
		$row['composition'] = NULL;
		$row['status'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['gcode'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->weight_sqm->FormValue == $this->weight_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->weight_sqm->CurrentValue)))
			$this->weight_sqm->CurrentValue = ConvertToFloatString($this->weight_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price_cs->FormValue == $this->price_cs->CurrentValue && is_numeric(ConvertToFloatString($this->price_cs->CurrentValue)))
			$this->price_cs->CurrentValue = ConvertToFloatString($this->price_cs->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// partner_type
		// partner
		// partner_ref
		// barcode
		// partner_code
		// product_type
		// shape
		// grp
		// s_grp
		// product
		// rid
		// spl_ins
		// packing_type
		// batch_no
		// unit
		// w
		// w_cm
		// l
		// l_cm
		// h
		// h_cm
		// partner_size
		// sqm
		// cbm
		// weight_sqm
		// price
		// price_cs
		// currency
		// hsn
		// composition
		// status
		// operator
		// datetime
		// gcode

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// partner_type
			$curVal = strval($this->partner_type->CurrentValue);
			if ($curVal <> "") {
				$this->partner_type->ViewValue = $this->partner_type->lookupCacheOption($curVal);
				if ($this->partner_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return ((User_Category() == 0) ? "FIND_IN_SET(`id`, '1,2') and `status` = 1" : ((User_Category() == 1) ? "`id` = 1 and `status` = 1" : ((User_Category() == 2) ? "`id` = 2 and `status` = 1" : "FIND_IN_SET(`id`, '1,2') and `status` = 1")));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->partner_type->ViewValue = $this->partner_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_type->ViewValue = $this->partner_type->CurrentValue;
					}
				}
			} else {
				$this->partner_type->ViewValue = NULL;
			}
			$this->partner_type->ViewCustomAttributes = "";

			// partner
			$curVal = strval($this->partner->CurrentValue);
			if ($curVal <> "") {
				$this->partner->ViewValue = $this->partner->lookupCacheOption($curVal);
				if ($this->partner->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Category() == 0) ?  "`status` = 1 || `category` = 1" : "(`id` = " .  User_Company_ID()  . " and `status` = 1)  || `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->partner->ViewValue = $this->partner->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner->ViewValue = $this->partner->CurrentValue;
					}
				}
			} else {
				$this->partner->ViewValue = NULL;
			}
			$this->partner->ViewCustomAttributes = "";

			// partner_ref
			$this->partner_ref->ViewValue = $this->partner_ref->CurrentValue;
			$this->partner_ref->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewCustomAttributes = "";

			// partner_code
			$this->partner_code->ViewValue = $this->partner_code->CurrentValue;
			$this->partner_code->ViewCustomAttributes = "";

			// product_type
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `id` != 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shape->ViewValue = $this->shape->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			if ($this->rid->VirtualValue <> "") {
				$this->rid->ViewValue = $this->rid->VirtualValue;
			} else {
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// spl_ins
			$this->spl_ins->ViewValue = $this->spl_ins->CurrentValue;
			$this->spl_ins->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return ((pd_byepass() == 2) ? "`status` = 1" : ((pd_byepass() == 1) ? "(`bom_app_id` >  0 and `status` = 1) || (`a_operator` > 0 and `status` = 1)" : "(`a_operator` > 0 and `status` = 1)"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// unit
			if (strval($this->unit->CurrentValue) <> "") {
				$this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// w
			$this->w->ViewValue = $this->w->CurrentValue;
			$this->w->ViewCustomAttributes = "";

			// w_cm
			$this->w_cm->ViewValue = $this->w_cm->CurrentValue;
			$this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, 2, -2, -2, -2);
			$this->w_cm->ViewCustomAttributes = "";

			// l
			$this->l->ViewValue = $this->l->CurrentValue;
			$this->l->ViewCustomAttributes = "";

			// l_cm
			$this->l_cm->ViewValue = $this->l_cm->CurrentValue;
			$this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, 2, -2, -2, -2);
			$this->l_cm->ViewCustomAttributes = "";

			// h
			$this->h->ViewValue = $this->h->CurrentValue;
			$this->h->ViewCustomAttributes = "";

			// h_cm
			$this->h_cm->ViewValue = $this->h_cm->CurrentValue;
			$this->h_cm->ViewValue = FormatNumber($this->h_cm->ViewValue, 2, -2, -2, -2);
			$this->h_cm->ViewCustomAttributes = "";

			// partner_size
			$this->partner_size->ViewValue = $this->partner_size->CurrentValue;
			$this->partner_size->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 4, -2, -2, 0);
			$this->sqm->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 4, -2, -2, -2);
			$this->cbm->ViewCustomAttributes = "";

			// weight_sqm
			$this->weight_sqm->ViewValue = $this->weight_sqm->CurrentValue;
			$this->weight_sqm->ViewValue = FormatNumber($this->weight_sqm->ViewValue, 3, -2, -2, -2);
			$this->weight_sqm->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, 0);
			$this->price->ViewCustomAttributes = "";

			// price_cs
			$this->price_cs->ViewValue = $this->price_cs->CurrentValue;
			$this->price_cs->ViewValue = FormatNumber($this->price_cs->ViewValue, 2, -2, -2, -2);
			$this->price_cs->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// hsn
			$curVal = strval($this->hsn->CurrentValue);
			if ($curVal <> "") {
				$this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
				if ($this->hsn->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->hsn->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->hsn->ViewValue = $this->hsn->CurrentValue;
					}
				}
			} else {
				$this->hsn->ViewValue = NULL;
			}
			$this->hsn->ViewCustomAttributes = "";

			// composition
			$curVal = strval($this->composition->CurrentValue);
			if ($curVal <> "") {
				$this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
				if ($this->composition->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->composition->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->composition->ViewValue = $this->composition->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->composition->ViewValue = $this->composition->CurrentValue;
					}
				}
			} else {
				$this->composition->ViewValue = NULL;
			}
			$this->composition->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 7);
			$this->datetime->ViewCustomAttributes = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// spl_ins
			$this->spl_ins->LinkCustomAttributes = "";
			$this->spl_ins->HrefValue = "";
			$this->spl_ins->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// weight_sqm
			$this->weight_sqm->LinkCustomAttributes = "";
			$this->weight_sqm->HrefValue = "";
			$this->weight_sqm->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// price_cs
			$this->price_cs->LinkCustomAttributes = "";
			$this->price_cs->HrefValue = "";
			$this->price_cs->TooltipValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";
			$this->currency->TooltipValue = "";

			// hsn
			$this->hsn->LinkCustomAttributes = "";
			$this->hsn->HrefValue = "";
			$this->hsn->TooltipValue = "";

			// composition
			$this->composition->LinkCustomAttributes = "";
			$this->composition->HrefValue = "";
			$this->composition->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// spl_ins
			$this->spl_ins->EditAttrs["class"] = "form-control";
			$this->spl_ins->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->spl_ins->CurrentValue = HtmlDecode($this->spl_ins->CurrentValue);
			$this->spl_ins->EditValue = HtmlEncode($this->spl_ins->CurrentValue);
			$this->spl_ins->PlaceHolder = RemoveHtml($this->spl_ins->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_type->CurrentValue));
			if ($curVal <> "")
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			else
				$this->packing_type->ViewValue = $this->packing_type->Lookup !== NULL && is_array($this->packing_type->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_type->ViewValue !== NULL) { // Load from cache
				$this->packing_type->EditValue = array_values($this->packing_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->packing_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->packing_type->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->packing_type->EditValue = $arwrk;
			}

			// weight_sqm
			$this->weight_sqm->EditAttrs["class"] = "form-control";
			$this->weight_sqm->EditCustomAttributes = "";
			$this->weight_sqm->EditValue = HtmlEncode($this->weight_sqm->CurrentValue);
			$this->weight_sqm->PlaceHolder = RemoveHtml($this->weight_sqm->caption());
			if (strval($this->weight_sqm->EditValue) <> "" && is_numeric($this->weight_sqm->EditValue))
				$this->weight_sqm->EditValue = FormatNumber($this->weight_sqm->EditValue, -2, -2, -2, -2);

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = HtmlEncode($this->price->CurrentValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());
			if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
				$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, 0);

			// price_cs
			$this->price_cs->EditAttrs["class"] = "form-control";
			$this->price_cs->EditCustomAttributes = "";
			$this->price_cs->EditValue = HtmlEncode($this->price_cs->CurrentValue);
			$this->price_cs->PlaceHolder = RemoveHtml($this->price_cs->caption());
			if (strval($this->price_cs->EditValue) <> "" && is_numeric($this->price_cs->EditValue))
				$this->price_cs->EditValue = FormatNumber($this->price_cs->EditValue, -2, -2, -2, -2);

			// currency
			$this->currency->EditAttrs["class"] = "form-control";
			$this->currency->EditCustomAttributes = "";
			$curVal = trim(strval($this->currency->CurrentValue));
			if ($curVal <> "")
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			else
				$this->currency->ViewValue = $this->currency->Lookup !== NULL && is_array($this->currency->Lookup->Options) ? $curVal : NULL;
			if ($this->currency->ViewValue !== NULL) { // Load from cache
				$this->currency->EditValue = array_values($this->currency->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->currency->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->currency->EditValue = $arwrk;
			}

			// hsn
			$this->hsn->EditAttrs["class"] = "form-control";
			$this->hsn->EditCustomAttributes = "";
			$curVal = trim(strval($this->hsn->CurrentValue));
			if ($curVal <> "")
				$this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
			else
				$this->hsn->ViewValue = $this->hsn->Lookup !== NULL && is_array($this->hsn->Lookup->Options) ? $curVal : NULL;
			if ($this->hsn->ViewValue !== NULL) { // Load from cache
				$this->hsn->EditValue = array_values($this->hsn->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->hsn->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->hsn->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
				}
				$this->hsn->EditValue = $arwrk;
			}

			// composition
			$this->composition->EditAttrs["class"] = "form-control";
			$this->composition->EditCustomAttributes = "";
			$curVal = trim(strval($this->composition->CurrentValue));
			if ($curVal <> "")
				$this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
			else
				$this->composition->ViewValue = $this->composition->Lookup !== NULL && is_array($this->composition->Lookup->Options) ? $curVal : NULL;
			if ($this->composition->ViewValue !== NULL) { // Load from cache
				$this->composition->EditValue = array_values($this->composition->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->composition->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->composition->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->composition->EditValue = $arwrk;
			}

			// Edit refer script
			// grp

			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}

			// spl_ins
			$this->spl_ins->LinkCustomAttributes = "";
			$this->spl_ins->HrefValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";

			// weight_sqm
			$this->weight_sqm->LinkCustomAttributes = "";
			$this->weight_sqm->HrefValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";

			// price_cs
			$this->price_cs->LinkCustomAttributes = "";
			$this->price_cs->HrefValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";

			// hsn
			$this->hsn->LinkCustomAttributes = "";
			$this->hsn->HrefValue = "";

			// composition
			$this->composition->LinkCustomAttributes = "";
			$this->composition->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";
		$updateCnt = 0;
		if ($this->grp->MultiUpdate == "1")
			$updateCnt++;
		if ($this->spl_ins->MultiUpdate == "1")
			$updateCnt++;
		if ($this->packing_type->MultiUpdate == "1")
			$updateCnt++;
		if ($this->weight_sqm->MultiUpdate == "1")
			$updateCnt++;
		if ($this->price->MultiUpdate == "1")
			$updateCnt++;
		if ($this->price_cs->MultiUpdate == "1")
			$updateCnt++;
		if ($this->currency->MultiUpdate == "1")
			$updateCnt++;
		if ($this->hsn->MultiUpdate == "1")
			$updateCnt++;
		if ($this->composition->MultiUpdate == "1")
			$updateCnt++;
		if ($updateCnt == 0) {
			$FormError = $Language->phrase("NoFieldSelected");
			return FALSE;
		}

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if ($this->id->MultiUpdate <> "" && !$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->partner_type->Required) {
			if ($this->partner_type->MultiUpdate <> "" && !$this->partner_type->IsDetailKey && $this->partner_type->FormValue != NULL && $this->partner_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_type->caption(), $this->partner_type->RequiredErrorMessage));
			}
		}
		if ($this->partner->Required) {
			if ($this->partner->MultiUpdate <> "" && !$this->partner->IsDetailKey && $this->partner->FormValue != NULL && $this->partner->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner->caption(), $this->partner->RequiredErrorMessage));
			}
		}
		if ($this->partner_ref->Required) {
			if ($this->partner_ref->MultiUpdate <> "" && !$this->partner_ref->IsDetailKey && $this->partner_ref->FormValue != NULL && $this->partner_ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_ref->caption(), $this->partner_ref->RequiredErrorMessage));
			}
		}
		if ($this->_barcode->Required) {
			if ($this->_barcode->MultiUpdate <> "" && !$this->_barcode->IsDetailKey && $this->_barcode->FormValue != NULL && $this->_barcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
			}
		}
		if ($this->partner_code->Required) {
			if ($this->partner_code->MultiUpdate <> "" && !$this->partner_code->IsDetailKey && $this->partner_code->FormValue != NULL && $this->partner_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_code->caption(), $this->partner_code->RequiredErrorMessage));
			}
		}
		if ($this->product_type->Required) {
			if ($this->product_type->MultiUpdate <> "" && !$this->product_type->IsDetailKey && $this->product_type->FormValue != NULL && $this->product_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
			}
		}
		if ($this->shape->Required) {
			if ($this->shape->MultiUpdate <> "" && !$this->shape->IsDetailKey && $this->shape->FormValue != NULL && $this->shape->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if ($this->grp->MultiUpdate <> "" && !$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if ($this->s_grp->MultiUpdate <> "" && !$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if ($this->product->MultiUpdate <> "" && !$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->rid->Required) {
			if ($this->rid->MultiUpdate <> "" && !$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if ($this->spl_ins->Required) {
			if ($this->spl_ins->MultiUpdate <> "" && !$this->spl_ins->IsDetailKey && $this->spl_ins->FormValue != NULL && $this->spl_ins->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->spl_ins->caption(), $this->spl_ins->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if ($this->packing_type->MultiUpdate <> "" && !$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->batch_no->Required) {
			if ($this->batch_no->MultiUpdate <> "" && !$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if ($this->unit->Required) {
			if ($this->unit->MultiUpdate <> "" && !$this->unit->IsDetailKey && $this->unit->FormValue != NULL && $this->unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
			}
		}
		if ($this->w->Required) {
			if ($this->w->MultiUpdate <> "" && !$this->w->IsDetailKey && $this->w->FormValue != NULL && $this->w->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->w->caption(), $this->w->RequiredErrorMessage));
			}
		}
		if ($this->w_cm->Required) {
			if ($this->w_cm->MultiUpdate <> "" && !$this->w_cm->IsDetailKey && $this->w_cm->FormValue != NULL && $this->w_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->w_cm->caption(), $this->w_cm->RequiredErrorMessage));
			}
		}
		if ($this->l->Required) {
			if ($this->l->MultiUpdate <> "" && !$this->l->IsDetailKey && $this->l->FormValue != NULL && $this->l->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->l->caption(), $this->l->RequiredErrorMessage));
			}
		}
		if ($this->l_cm->Required) {
			if ($this->l_cm->MultiUpdate <> "" && !$this->l_cm->IsDetailKey && $this->l_cm->FormValue != NULL && $this->l_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->l_cm->caption(), $this->l_cm->RequiredErrorMessage));
			}
		}
		if ($this->h->Required) {
			if ($this->h->MultiUpdate <> "" && !$this->h->IsDetailKey && $this->h->FormValue != NULL && $this->h->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->h->caption(), $this->h->RequiredErrorMessage));
			}
		}
		if ($this->h_cm->Required) {
			if ($this->h_cm->MultiUpdate <> "" && !$this->h_cm->IsDetailKey && $this->h_cm->FormValue != NULL && $this->h_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->h_cm->caption(), $this->h_cm->RequiredErrorMessage));
			}
		}
		if ($this->partner_size->Required) {
			if ($this->partner_size->MultiUpdate <> "" && !$this->partner_size->IsDetailKey && $this->partner_size->FormValue != NULL && $this->partner_size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_size->caption(), $this->partner_size->RequiredErrorMessage));
			}
		}
		if ($this->sqm->Required) {
			if ($this->sqm->MultiUpdate <> "" && !$this->sqm->IsDetailKey && $this->sqm->FormValue != NULL && $this->sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
			}
		}
		if ($this->cbm->Required) {
			if ($this->cbm->MultiUpdate <> "" && !$this->cbm->IsDetailKey && $this->cbm->FormValue != NULL && $this->cbm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
			}
		}
		if ($this->weight_sqm->Required) {
			if ($this->weight_sqm->MultiUpdate <> "" && !$this->weight_sqm->IsDetailKey && $this->weight_sqm->FormValue != NULL && $this->weight_sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->weight_sqm->caption(), $this->weight_sqm->RequiredErrorMessage));
			}
		}
		if ($this->weight_sqm->MultiUpdate <> "") {
			if (!CheckNumber($this->weight_sqm->FormValue)) {
				AddMessage($FormError, $this->weight_sqm->errorMessage());
			}
		}
		if ($this->price->Required) {
			if ($this->price->MultiUpdate <> "" && !$this->price->IsDetailKey && $this->price->FormValue != NULL && $this->price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
			}
		}
		if ($this->price->MultiUpdate <> "") {
			if (!CheckNumber($this->price->FormValue)) {
				AddMessage($FormError, $this->price->errorMessage());
			}
		}
		if ($this->price_cs->Required) {
			if ($this->price_cs->MultiUpdate <> "" && !$this->price_cs->IsDetailKey && $this->price_cs->FormValue != NULL && $this->price_cs->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price_cs->caption(), $this->price_cs->RequiredErrorMessage));
			}
		}
		if ($this->price_cs->MultiUpdate <> "") {
			if (!CheckNumber($this->price_cs->FormValue)) {
				AddMessage($FormError, $this->price_cs->errorMessage());
			}
		}
		if ($this->currency->Required) {
			if ($this->currency->MultiUpdate <> "" && !$this->currency->IsDetailKey && $this->currency->FormValue != NULL && $this->currency->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
			}
		}
		if ($this->hsn->Required) {
			if ($this->hsn->MultiUpdate <> "" && !$this->hsn->IsDetailKey && $this->hsn->FormValue != NULL && $this->hsn->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->hsn->caption(), $this->hsn->RequiredErrorMessage));
			}
		}
		if ($this->composition->Required) {
			if ($this->composition->MultiUpdate <> "" && !$this->composition->IsDetailKey && $this->composition->FormValue != NULL && $this->composition->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->composition->caption(), $this->composition->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if ($this->status->MultiUpdate <> "" && !$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if ($this->operator->MultiUpdate <> "" && !$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if ($this->datetime->MultiUpdate <> "" && !$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->gcode->Required) {
			if ($this->gcode->MultiUpdate <> "" && !$this->gcode->IsDetailKey && $this->gcode->FormValue != NULL && $this->gcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gcode->caption(), $this->gcode->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// grp
			$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, NULL, $this->grp->ReadOnly || $this->grp->MultiUpdate <> "1");

			// spl_ins
			$this->spl_ins->setDbValueDef($rsnew, $this->spl_ins->CurrentValue, NULL, $this->spl_ins->ReadOnly || $this->spl_ins->MultiUpdate <> "1");

			// packing_type
			$this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, NULL, $this->packing_type->ReadOnly || $this->packing_type->MultiUpdate <> "1");

			// weight_sqm
			$this->weight_sqm->setDbValueDef($rsnew, $this->weight_sqm->CurrentValue, 0, $this->weight_sqm->ReadOnly || $this->weight_sqm->MultiUpdate <> "1");

			// price
			$this->price->setDbValueDef($rsnew, $this->price->CurrentValue, NULL, $this->price->ReadOnly || $this->price->MultiUpdate <> "1");

			// price_cs
			$this->price_cs->setDbValueDef($rsnew, $this->price_cs->CurrentValue, NULL, $this->price_cs->ReadOnly || $this->price_cs->MultiUpdate <> "1");

			// currency
			$this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, NULL, $this->currency->ReadOnly || $this->currency->MultiUpdate <> "1");

			// hsn
			$this->hsn->setDbValueDef($rsnew, $this->hsn->CurrentValue, NULL, $this->hsn->ReadOnly || $this->hsn->MultiUpdate <> "1");

			// composition
			$this->composition->setDbValueDef($rsnew, $this->composition->CurrentValue, NULL, $this->composition->ReadOnly || $this->composition->MultiUpdate <> "1");

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("partner_product_reflist.php"), "", $this->TableVar, TRUE);
		$pageId = "update";
		$Breadcrumb->add("update", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_partner_type":
					$lookupFilter = function() {
						return ((User_Category() == 0) ? "FIND_IN_SET(`id`, '1,2') and `status` = 1" : ((User_Category() == 1) ? "`id` = 1 and `status` = 1" : ((User_Category() == 2) ? "`id` = 2 and `status` = 1" : "FIND_IN_SET(`id`, '1,2') and `status` = 1")));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner":
					$lookupFilter = function() {
						return (User_Category() == 0) ?  "`status` = 1 || `category` = 1" : "(`id` = " .  User_Company_ID()  . " and `status` = 1)  || `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_type":
					$lookupFilter = function() {
						return "`status`=1 and `id` != 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_batch_no":
					$lookupFilter = function() {
						return ((pd_byepass() == 2) ? "`status` = 1" : ((pd_byepass() == 1) ? "(`bom_app_id` >  0 and `status` = 1) || (`a_operator` > 0 and `status` = 1)" : "(`a_operator` > 0 and `status` = 1)"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_hsn":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_composition":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_partner_type":
							break;
						case "x_partner":
							break;
						case "x_product_type":
							break;
						case "x_shape":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_packing_type":
							break;
						case "x_batch_no":
							break;
						case "x_currency":
							break;
						case "x_hsn":
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
						case "x_composition":
							break;
						case "x_operator":
							break;
						case "x_gcode":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'partner_product_ref');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>