<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class partner_quotation_buyer_edit extends partner_quotation_buyer
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'partner_quotation_buyer';

	// Page object name
	public $PageObjName = "partner_quotation_buyer_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (partner_quotation_buyer)
		if (!isset($GLOBALS["partner_quotation_buyer"]) || get_class($GLOBALS["partner_quotation_buyer"]) == PROJECT_NAMESPACE . "partner_quotation_buyer") {
			$GLOBALS["partner_quotation_buyer"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["partner_quotation_buyer"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'partner_quotation_buyer');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $partner_quotation_buyer;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($partner_quotation_buyer);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "partner_quotation_buyerview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("partner_quotation_buyerlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->company_id->setVisibility();
		$this->partner_id->setVisibility();
		$this->partner_details->setVisibility();
		$this->product_type->setVisibility();
		$this->product->setVisibility();
		$this->product_code->setVisibility();
		$this->partner_code->setVisibility();
		$this->packing_type->setVisibility();
		$this->unit->setVisibility();
		$this->quantity_approx->setVisibility();
		$this->quantity->setVisibility();
		$this->price->setVisibility();
		$this->amount->setVisibility();
		$this->currency->setVisibility();
		$this->total_amount->setVisibility();
		$this->remarks->setVisibility();
		$this->payment_terms->setVisibility();
		$this->tax_categories->setVisibility();
		$this->delivery_period->setVisibility();
		$this->status->setVisibility();
		$this->operator->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->pp_operator->setVisibility();
		$this->pp_datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->product_code);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->unit);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->payment_terms);
		$this->setupLookupOptions($this->tax_categories);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("partner_quotation_buyerlist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "partner_quotation_buyerlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}

		// Check field name 'partner_id' first before field var 'x_partner_id'
		$val = $CurrentForm->hasValue("partner_id") ? $CurrentForm->getValue("partner_id") : $CurrentForm->getValue("x_partner_id");
		if (!$this->partner_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_id->Visible = FALSE; // Disable update for API request
			else
				$this->partner_id->setFormValue($val);
		}

		// Check field name 'partner_details' first before field var 'x_partner_details'
		$val = $CurrentForm->hasValue("partner_details") ? $CurrentForm->getValue("partner_details") : $CurrentForm->getValue("x_partner_details");
		if (!$this->partner_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_details->Visible = FALSE; // Disable update for API request
			else
				$this->partner_details->setFormValue($val);
		}

		// Check field name 'product_type' first before field var 'x_product_type'
		$val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
		if (!$this->product_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_type->Visible = FALSE; // Disable update for API request
			else
				$this->product_type->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'product_code' first before field var 'x_product_code'
		$val = $CurrentForm->hasValue("product_code") ? $CurrentForm->getValue("product_code") : $CurrentForm->getValue("x_product_code");
		if (!$this->product_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_code->Visible = FALSE; // Disable update for API request
			else
				$this->product_code->setFormValue($val);
		}

		// Check field name 'partner_code' first before field var 'x_partner_code'
		$val = $CurrentForm->hasValue("partner_code") ? $CurrentForm->getValue("partner_code") : $CurrentForm->getValue("x_partner_code");
		if (!$this->partner_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_code->Visible = FALSE; // Disable update for API request
			else
				$this->partner_code->setFormValue($val);
		}

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}

		// Check field name 'unit' first before field var 'x_unit'
		$val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
		if (!$this->unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unit->Visible = FALSE; // Disable update for API request
			else
				$this->unit->setFormValue($val);
		}

		// Check field name 'quantity_approx' first before field var 'x_quantity_approx'
		$val = $CurrentForm->hasValue("quantity_approx") ? $CurrentForm->getValue("quantity_approx") : $CurrentForm->getValue("x_quantity_approx");
		if (!$this->quantity_approx->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity_approx->Visible = FALSE; // Disable update for API request
			else
				$this->quantity_approx->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'price' first before field var 'x_price'
		$val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
		if (!$this->price->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->price->Visible = FALSE; // Disable update for API request
			else
				$this->price->setFormValue($val);
		}

		// Check field name 'amount' first before field var 'x_amount'
		$val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
		if (!$this->amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->amount->Visible = FALSE; // Disable update for API request
			else
				$this->amount->setFormValue($val);
		}

		// Check field name 'currency' first before field var 'x_currency'
		$val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
		if (!$this->currency->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->currency->Visible = FALSE; // Disable update for API request
			else
				$this->currency->setFormValue($val);
		}

		// Check field name 'total_amount' first before field var 'x_total_amount'
		$val = $CurrentForm->hasValue("total_amount") ? $CurrentForm->getValue("total_amount") : $CurrentForm->getValue("x_total_amount");
		if (!$this->total_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->total_amount->Visible = FALSE; // Disable update for API request
			else
				$this->total_amount->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'payment_terms' first before field var 'x_payment_terms'
		$val = $CurrentForm->hasValue("payment_terms") ? $CurrentForm->getValue("payment_terms") : $CurrentForm->getValue("x_payment_terms");
		if (!$this->payment_terms->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->payment_terms->Visible = FALSE; // Disable update for API request
			else
				$this->payment_terms->setFormValue($val);
		}

		// Check field name 'tax_categories' first before field var 'x_tax_categories'
		$val = $CurrentForm->hasValue("tax_categories") ? $CurrentForm->getValue("tax_categories") : $CurrentForm->getValue("x_tax_categories");
		if (!$this->tax_categories->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tax_categories->Visible = FALSE; // Disable update for API request
			else
				$this->tax_categories->setFormValue($val);
		}

		// Check field name 'delivery_period' first before field var 'x_delivery_period'
		$val = $CurrentForm->hasValue("delivery_period") ? $CurrentForm->getValue("delivery_period") : $CurrentForm->getValue("x_delivery_period");
		if (!$this->delivery_period->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->delivery_period->Visible = FALSE; // Disable update for API request
			else
				$this->delivery_period->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'pp_operator' first before field var 'x_pp_operator'
		$val = $CurrentForm->hasValue("pp_operator") ? $CurrentForm->getValue("pp_operator") : $CurrentForm->getValue("x_pp_operator");
		if (!$this->pp_operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pp_operator->Visible = FALSE; // Disable update for API request
			else
				$this->pp_operator->setFormValue($val);
		}

		// Check field name 'pp_datetime' first before field var 'x_pp_datetime'
		$val = $CurrentForm->hasValue("pp_datetime") ? $CurrentForm->getValue("pp_datetime") : $CurrentForm->getValue("x_pp_datetime");
		if (!$this->pp_datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pp_datetime->Visible = FALSE; // Disable update for API request
			else
				$this->pp_datetime->setFormValue($val);
			$this->pp_datetime->CurrentValue = UnFormatDateTime($this->pp_datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->partner_id->CurrentValue = $this->partner_id->FormValue;
		$this->partner_details->CurrentValue = $this->partner_details->FormValue;
		$this->product_type->CurrentValue = $this->product_type->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->product_code->CurrentValue = $this->product_code->FormValue;
		$this->partner_code->CurrentValue = $this->partner_code->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->unit->CurrentValue = $this->unit->FormValue;
		$this->quantity_approx->CurrentValue = $this->quantity_approx->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->price->CurrentValue = $this->price->FormValue;
		$this->amount->CurrentValue = $this->amount->FormValue;
		$this->currency->CurrentValue = $this->currency->FormValue;
		$this->total_amount->CurrentValue = $this->total_amount->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->payment_terms->CurrentValue = $this->payment_terms->FormValue;
		$this->tax_categories->CurrentValue = $this->tax_categories->FormValue;
		$this->delivery_period->CurrentValue = $this->delivery_period->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->pp_operator->CurrentValue = $this->pp_operator->FormValue;
		$this->pp_datetime->CurrentValue = $this->pp_datetime->FormValue;
		$this->pp_datetime->CurrentValue = UnFormatDateTime($this->pp_datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->company_id->setDbValue($row['company_id']);
		$this->partner_id->setDbValue($row['partner_id']);
		$this->partner_details->setDbValue($row['partner_details']);
		$this->product_type->setDbValue($row['product_type']);
		$this->product->setDbValue($row['product']);
		$this->product_code->setDbValue($row['product_code']);
		$this->partner_code->setDbValue($row['partner_code']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->unit->setDbValue($row['unit']);
		$this->quantity_approx->setDbValue($row['quantity_approx']);
		$this->quantity->setDbValue($row['quantity']);
		$this->price->setDbValue($row['price']);
		$this->amount->setDbValue($row['amount']);
		$this->currency->setDbValue($row['currency']);
		$this->total_amount->setDbValue($row['total_amount']);
		$this->remarks->setDbValue($row['remarks']);
		$this->payment_terms->setDbValue($row['payment_terms']);
		$this->tax_categories->setDbValue($row['tax_categories']);
		$this->delivery_period->setDbValue($row['delivery_period']);
		$this->status->setDbValue($row['status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->pp_operator->setDbValue($row['pp_operator']);
		$this->pp_datetime->setDbValue($row['pp_datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['company_id'] = NULL;
		$row['partner_id'] = NULL;
		$row['partner_details'] = NULL;
		$row['product_type'] = NULL;
		$row['product'] = NULL;
		$row['product_code'] = NULL;
		$row['partner_code'] = NULL;
		$row['packing_type'] = NULL;
		$row['unit'] = NULL;
		$row['quantity_approx'] = NULL;
		$row['quantity'] = NULL;
		$row['price'] = NULL;
		$row['amount'] = NULL;
		$row['currency'] = NULL;
		$row['total_amount'] = NULL;
		$row['remarks'] = NULL;
		$row['payment_terms'] = NULL;
		$row['tax_categories'] = NULL;
		$row['delivery_period'] = NULL;
		$row['status'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['pp_operator'] = NULL;
		$row['pp_datetime'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->total_amount->FormValue == $this->total_amount->CurrentValue && is_numeric(ConvertToFloatString($this->total_amount->CurrentValue)))
			$this->total_amount->CurrentValue = ConvertToFloatString($this->total_amount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// company_id
		// partner_id
		// partner_details
		// product_type
		// product
		// product_code
		// partner_code
		// packing_type
		// unit
		// quantity_approx
		// quantity
		// price
		// amount
		// currency
		// total_amount
		// remarks
		// payment_terms
		// tax_categories
		// delivery_period
		// status
		// operator
		// datetime
		// pp_operator
		// pp_datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// partner_id
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->ViewValue = NULL;
			}
			$this->partner_id->ViewCustomAttributes = "";

			// partner_details
			$this->partner_details->ViewValue = $this->partner_details->CurrentValue;
			$this->partner_details->ViewCustomAttributes = "";

			// product_type
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// product_code
			$curVal = strval($this->product_code->CurrentValue);
			if ($curVal <> "") {
				$this->product_code->ViewValue = $this->product_code->lookupCacheOption($curVal);
				if ($this->product_code->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_code->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_code->ViewValue = $this->product_code->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_code->ViewValue = $this->product_code->CurrentValue;
					}
				}
			} else {
				$this->product_code->ViewValue = NULL;
			}
			$this->product_code->ViewCustomAttributes = "";

			// partner_code
			$this->partner_code->ViewValue = $this->partner_code->CurrentValue;
			$this->partner_code->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// unit
			$curVal = strval($this->unit->CurrentValue);
			if ($curVal <> "") {
				$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
				if ($this->unit->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->unit->ViewValue = $this->unit->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->unit->ViewValue = $this->unit->CurrentValue;
					}
				}
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// quantity_approx
			$this->quantity_approx->ViewValue = $this->quantity_approx->CurrentValue;
			$this->quantity_approx->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// total_amount
			$this->total_amount->ViewValue = $this->total_amount->CurrentValue;
			$this->total_amount->ViewValue = FormatNumber($this->total_amount->ViewValue, 2, -2, -2, -2);
			$this->total_amount->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// payment_terms
			$curVal = strval($this->payment_terms->CurrentValue);
			if ($curVal <> "") {
				$this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
				if ($this->payment_terms->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 81";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->payment_terms->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
					}
				}
			} else {
				$this->payment_terms->ViewValue = NULL;
			}
			$this->payment_terms->ViewCustomAttributes = "";

			// tax_categories
			$curVal = strval($this->tax_categories->CurrentValue);
			if ($curVal <> "") {
				$this->tax_categories->ViewValue = $this->tax_categories->lookupCacheOption($curVal);
				if ($this->tax_categories->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->tax_categories->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$this->tax_categories->ViewValue = $this->tax_categories->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->tax_categories->ViewValue = $this->tax_categories->CurrentValue;
					}
				}
			} else {
				$this->tax_categories->ViewValue = NULL;
			}
			$this->tax_categories->ViewCustomAttributes = "";

			// delivery_period
			$this->delivery_period->ViewValue = $this->delivery_period->CurrentValue;
			$this->delivery_period->ViewValue = FormatNumber($this->delivery_period->ViewValue, 0, -2, -2, -2);
			$this->delivery_period->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// pp_operator
			$this->pp_operator->ViewValue = $this->pp_operator->CurrentValue;
			$this->pp_operator->ViewValue = FormatNumber($this->pp_operator->ViewValue, 0, -2, -2, -2);
			$this->pp_operator->ViewCustomAttributes = "";

			// pp_datetime
			$this->pp_datetime->ViewValue = $this->pp_datetime->CurrentValue;
			$this->pp_datetime->ViewValue = FormatDateTime($this->pp_datetime->ViewValue, 0);
			$this->pp_datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			$this->partner_id->HrefValue = "";
			$this->partner_id->TooltipValue = "";

			// partner_details
			$this->partner_details->LinkCustomAttributes = "";
			$this->partner_details->HrefValue = "";
			$this->partner_details->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";
			$this->product->TooltipValue = "";

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			$this->product_code->HrefValue = "";
			$this->product_code->TooltipValue = "";

			// partner_code
			$this->partner_code->LinkCustomAttributes = "";
			$this->partner_code->HrefValue = "";
			$this->partner_code->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// quantity_approx
			$this->quantity_approx->LinkCustomAttributes = "";
			$this->quantity_approx->HrefValue = "";
			$this->quantity_approx->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";
			$this->currency->TooltipValue = "";

			// total_amount
			$this->total_amount->LinkCustomAttributes = "";
			$this->total_amount->HrefValue = "";
			$this->total_amount->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			$this->payment_terms->HrefValue = "";
			$this->payment_terms->TooltipValue = "";

			// tax_categories
			$this->tax_categories->LinkCustomAttributes = "";
			$this->tax_categories->HrefValue = "";
			$this->tax_categories->TooltipValue = "";

			// delivery_period
			$this->delivery_period->LinkCustomAttributes = "";
			$this->delivery_period->HrefValue = "";
			$this->delivery_period->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// pp_operator
			$this->pp_operator->LinkCustomAttributes = "";
			$this->pp_operator->HrefValue = "";
			$this->pp_operator->TooltipValue = "";

			// pp_datetime
			$this->pp_datetime->LinkCustomAttributes = "";
			$this->pp_datetime->HrefValue = "";
			$this->pp_datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->company_id->CurrentValue));
			if ($curVal <> "")
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			else
				$this->company_id->ViewValue = $this->company_id->Lookup !== NULL && is_array($this->company_id->Lookup->Options) ? $curVal : NULL;
			if ($this->company_id->ViewValue !== NULL) { // Load from cache
				$this->company_id->EditValue = array_values($this->company_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->company_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `category` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->company_id->EditValue = $arwrk;
			}

			// partner_id
			$this->partner_id->EditAttrs["class"] = "form-control";
			$this->partner_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->partner_id->CurrentValue));
			if ($curVal <> "")
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
			else
				$this->partner_id->ViewValue = $this->partner_id->Lookup !== NULL && is_array($this->partner_id->Lookup->Options) ? $curVal : NULL;
			if ($this->partner_id->ViewValue !== NULL) { // Load from cache
				$this->partner_id->EditValue = array_values($this->partner_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->partner_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->partner_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->partner_id->EditValue = $arwrk;
			}

			// partner_details
			$this->partner_details->EditAttrs["class"] = "form-control";
			$this->partner_details->EditCustomAttributes = "";
			$this->partner_details->EditValue = HtmlEncode($this->partner_details->CurrentValue);
			$this->partner_details->PlaceHolder = RemoveHtml($this->partner_details->caption());

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_type->CurrentValue));
			if ($curVal <> "")
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
			else
				$this->product_type->ViewValue = $this->product_type->Lookup !== NULL && is_array($this->product_type->Lookup->Options) ? $curVal : NULL;
			if ($this->product_type->ViewValue !== NULL) { // Load from cache
				$this->product_type->EditValue = array_values($this->product_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->product_type->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_type->EditValue = $arwrk;
			}

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->CurrentValue));
			if ($curVal <> "")
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// product_code
			$this->product_code->EditAttrs["class"] = "form-control";
			$this->product_code->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_code->CurrentValue));
			if ($curVal <> "")
				$this->product_code->ViewValue = $this->product_code->lookupCacheOption($curVal);
			else
				$this->product_code->ViewValue = $this->product_code->Lookup !== NULL && is_array($this->product_code->Lookup->Options) ? $curVal : NULL;
			if ($this->product_code->ViewValue !== NULL) { // Load from cache
				$this->product_code->EditValue = array_values($this->product_code->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product_code->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->product_code->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_code->EditValue = $arwrk;
			}

			// partner_code
			$this->partner_code->EditAttrs["class"] = "form-control";
			$this->partner_code->EditCustomAttributes = "";
			$this->partner_code->EditValue = HtmlEncode($this->partner_code->CurrentValue);
			$this->partner_code->PlaceHolder = RemoveHtml($this->partner_code->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_type->CurrentValue));
			if ($curVal <> "")
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			else
				$this->packing_type->ViewValue = $this->packing_type->Lookup !== NULL && is_array($this->packing_type->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_type->ViewValue !== NULL) { // Load from cache
				$this->packing_type->EditValue = array_values($this->packing_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->packing_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->packing_type->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->packing_type->EditValue = $arwrk;
			}

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";
			$curVal = trim(strval($this->unit->CurrentValue));
			if ($curVal <> "")
				$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
			else
				$this->unit->ViewValue = $this->unit->Lookup !== NULL && is_array($this->unit->Lookup->Options) ? $curVal : NULL;
			if ($this->unit->ViewValue !== NULL) { // Load from cache
				$this->unit->EditValue = array_values($this->unit->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->unit->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->unit->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->unit->EditValue = $arwrk;
			}

			// quantity_approx
			$this->quantity_approx->EditAttrs["class"] = "form-control";
			$this->quantity_approx->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->quantity_approx->CurrentValue = HtmlDecode($this->quantity_approx->CurrentValue);
			$this->quantity_approx->EditValue = HtmlEncode($this->quantity_approx->CurrentValue);
			$this->quantity_approx->PlaceHolder = RemoveHtml($this->quantity_approx->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
			if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
				$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = HtmlEncode($this->price->CurrentValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());
			if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
				$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, -2);

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = "";
			$this->amount->EditValue = HtmlEncode($this->amount->CurrentValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
			if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue))
				$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, -2);

			// currency
			$this->currency->EditAttrs["class"] = "form-control";
			$this->currency->EditCustomAttributes = "";
			$curVal = trim(strval($this->currency->CurrentValue));
			if ($curVal <> "")
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			else
				$this->currency->ViewValue = $this->currency->Lookup !== NULL && is_array($this->currency->Lookup->Options) ? $curVal : NULL;
			if ($this->currency->ViewValue !== NULL) { // Load from cache
				$this->currency->EditValue = array_values($this->currency->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->currency->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->currency->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->currency->EditValue = $arwrk;
			}

			// total_amount
			$this->total_amount->EditAttrs["class"] = "form-control";
			$this->total_amount->EditCustomAttributes = "";
			$this->total_amount->EditValue = HtmlEncode($this->total_amount->CurrentValue);
			$this->total_amount->PlaceHolder = RemoveHtml($this->total_amount->caption());
			if (strval($this->total_amount->EditValue) <> "" && is_numeric($this->total_amount->EditValue))
				$this->total_amount->EditValue = FormatNumber($this->total_amount->EditValue, -2, -2, -2, -2);

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// payment_terms
			$this->payment_terms->EditAttrs["class"] = "form-control";
			$this->payment_terms->EditCustomAttributes = "";
			$curVal = trim(strval($this->payment_terms->CurrentValue));
			if ($curVal <> "")
				$this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
			else
				$this->payment_terms->ViewValue = $this->payment_terms->Lookup !== NULL && is_array($this->payment_terms->Lookup->Options) ? $curVal : NULL;
			if ($this->payment_terms->ViewValue !== NULL) { // Load from cache
				$this->payment_terms->EditValue = array_values($this->payment_terms->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->payment_terms->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 81";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->payment_terms->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->payment_terms->EditValue = $arwrk;
			}

			// tax_categories
			$this->tax_categories->EditAttrs["class"] = "form-control";
			$this->tax_categories->EditCustomAttributes = "";
			$curVal = trim(strval($this->tax_categories->CurrentValue));
			if ($curVal <> "")
				$this->tax_categories->ViewValue = $this->tax_categories->lookupCacheOption($curVal);
			else
				$this->tax_categories->ViewValue = $this->tax_categories->Lookup !== NULL && is_array($this->tax_categories->Lookup->Options) ? $curVal : NULL;
			if ($this->tax_categories->ViewValue !== NULL) { // Load from cache
				$this->tax_categories->EditValue = array_values($this->tax_categories->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->tax_categories->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->tax_categories->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
				}
				$this->tax_categories->EditValue = $arwrk;
			}

			// delivery_period
			$this->delivery_period->EditAttrs["class"] = "form-control";
			$this->delivery_period->EditCustomAttributes = "";
			$this->delivery_period->EditValue = HtmlEncode($this->delivery_period->CurrentValue);
			$this->delivery_period->PlaceHolder = RemoveHtml($this->delivery_period->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// pp_operator
			// pp_datetime
			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			$this->partner_id->HrefValue = "";

			// partner_details
			$this->partner_details->LinkCustomAttributes = "";
			$this->partner_details->HrefValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			$this->product_code->HrefValue = "";

			// partner_code
			$this->partner_code->LinkCustomAttributes = "";
			$this->partner_code->HrefValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";

			// quantity_approx
			$this->quantity_approx->LinkCustomAttributes = "";
			$this->quantity_approx->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";

			// total_amount
			$this->total_amount->LinkCustomAttributes = "";
			$this->total_amount->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			$this->payment_terms->HrefValue = "";

			// tax_categories
			$this->tax_categories->LinkCustomAttributes = "";
			$this->tax_categories->HrefValue = "";

			// delivery_period
			$this->delivery_period->LinkCustomAttributes = "";
			$this->delivery_period->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// pp_operator
			$this->pp_operator->LinkCustomAttributes = "";
			$this->pp_operator->HrefValue = "";

			// pp_datetime
			$this->pp_datetime->LinkCustomAttributes = "";
			$this->pp_datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if ($this->partner_id->Required) {
			if (!$this->partner_id->IsDetailKey && $this->partner_id->FormValue != NULL && $this->partner_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
			}
		}
		if ($this->partner_details->Required) {
			if (!$this->partner_details->IsDetailKey && $this->partner_details->FormValue != NULL && $this->partner_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_details->caption(), $this->partner_details->RequiredErrorMessage));
			}
		}
		if ($this->product_type->Required) {
			if (!$this->product_type->IsDetailKey && $this->product_type->FormValue != NULL && $this->product_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->product_code->Required) {
			if (!$this->product_code->IsDetailKey && $this->product_code->FormValue != NULL && $this->product_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_code->caption(), $this->product_code->RequiredErrorMessage));
			}
		}
		if ($this->partner_code->Required) {
			if (!$this->partner_code->IsDetailKey && $this->partner_code->FormValue != NULL && $this->partner_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_code->caption(), $this->partner_code->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->unit->Required) {
			if (!$this->unit->IsDetailKey && $this->unit->FormValue != NULL && $this->unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
			}
		}
		if ($this->quantity_approx->Required) {
			if (!$this->quantity_approx->IsDetailKey && $this->quantity_approx->FormValue != NULL && $this->quantity_approx->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity_approx->caption(), $this->quantity_approx->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->quantity->FormValue)) {
			AddMessage($FormError, $this->quantity->errorMessage());
		}
		if ($this->price->Required) {
			if (!$this->price->IsDetailKey && $this->price->FormValue != NULL && $this->price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->price->FormValue)) {
			AddMessage($FormError, $this->price->errorMessage());
		}
		if ($this->amount->Required) {
			if (!$this->amount->IsDetailKey && $this->amount->FormValue != NULL && $this->amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->amount->FormValue)) {
			AddMessage($FormError, $this->amount->errorMessage());
		}
		if ($this->currency->Required) {
			if (!$this->currency->IsDetailKey && $this->currency->FormValue != NULL && $this->currency->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
			}
		}
		if ($this->total_amount->Required) {
			if (!$this->total_amount->IsDetailKey && $this->total_amount->FormValue != NULL && $this->total_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->total_amount->caption(), $this->total_amount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->total_amount->FormValue)) {
			AddMessage($FormError, $this->total_amount->errorMessage());
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->payment_terms->Required) {
			if (!$this->payment_terms->IsDetailKey && $this->payment_terms->FormValue != NULL && $this->payment_terms->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment_terms->caption(), $this->payment_terms->RequiredErrorMessage));
			}
		}
		if ($this->tax_categories->Required) {
			if (!$this->tax_categories->IsDetailKey && $this->tax_categories->FormValue != NULL && $this->tax_categories->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tax_categories->caption(), $this->tax_categories->RequiredErrorMessage));
			}
		}
		if ($this->delivery_period->Required) {
			if (!$this->delivery_period->IsDetailKey && $this->delivery_period->FormValue != NULL && $this->delivery_period->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery_period->caption(), $this->delivery_period->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->delivery_period->FormValue)) {
			AddMessage($FormError, $this->delivery_period->errorMessage());
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->pp_operator->Required) {
			if (!$this->pp_operator->IsDetailKey && $this->pp_operator->FormValue != NULL && $this->pp_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pp_operator->caption(), $this->pp_operator->RequiredErrorMessage));
			}
		}
		if ($this->pp_datetime->Required) {
			if (!$this->pp_datetime->IsDetailKey && $this->pp_datetime->FormValue != NULL && $this->pp_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pp_datetime->caption(), $this->pp_datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// company_id
			$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, NULL, $this->company_id->ReadOnly);

			// partner_id
			$this->partner_id->setDbValueDef($rsnew, $this->partner_id->CurrentValue, NULL, $this->partner_id->ReadOnly);

			// partner_details
			$this->partner_details->setDbValueDef($rsnew, $this->partner_details->CurrentValue, NULL, $this->partner_details->ReadOnly);

			// product_type
			$this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, NULL, $this->product_type->ReadOnly);

			// product
			$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, NULL, $this->product->ReadOnly);

			// product_code
			$this->product_code->setDbValueDef($rsnew, $this->product_code->CurrentValue, NULL, $this->product_code->ReadOnly);

			// partner_code
			$this->partner_code->setDbValueDef($rsnew, $this->partner_code->CurrentValue, NULL, $this->partner_code->ReadOnly);

			// packing_type
			$this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, NULL, $this->packing_type->ReadOnly);

			// unit
			$this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, NULL, $this->unit->ReadOnly);

			// quantity_approx
			$this->quantity_approx->setDbValueDef($rsnew, $this->quantity_approx->CurrentValue, NULL, $this->quantity_approx->ReadOnly);

			// quantity
			$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, NULL, $this->quantity->ReadOnly);

			// price
			$this->price->setDbValueDef($rsnew, $this->price->CurrentValue, NULL, $this->price->ReadOnly);

			// amount
			$this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, NULL, $this->amount->ReadOnly);

			// currency
			$this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, NULL, $this->currency->ReadOnly);

			// total_amount
			$this->total_amount->setDbValueDef($rsnew, $this->total_amount->CurrentValue, NULL, $this->total_amount->ReadOnly);

			// remarks
			$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, $this->remarks->ReadOnly);

			// payment_terms
			$this->payment_terms->setDbValueDef($rsnew, $this->payment_terms->CurrentValue, NULL, $this->payment_terms->ReadOnly);

			// tax_categories
			$this->tax_categories->setDbValueDef($rsnew, $this->tax_categories->CurrentValue, NULL, $this->tax_categories->ReadOnly);

			// delivery_period
			$this->delivery_period->setDbValueDef($rsnew, $this->delivery_period->CurrentValue, NULL, $this->delivery_period->ReadOnly);

			// status
			$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, NULL, $this->status->ReadOnly);

			// pp_operator
			$this->pp_operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['pp_operator'] = &$this->pp_operator->DbValue;

			// pp_datetime
			$this->pp_datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
			$rsnew['pp_datetime'] = &$this->pp_datetime->DbValue;

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("partner_quotation_buyerlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return "`status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_payment_terms":
					$lookupFilter = function() {
						return "`grp` = 81";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_tax_categories":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_partner_id":
							break;
						case "x_product_type":
							break;
						case "x_product":
							break;
						case "x_product_code":
							break;
						case "x_packing_type":
							break;
						case "x_unit":
							break;
						case "x_currency":
							break;
						case "x_payment_terms":
							break;
						case "x_tax_categories":
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>