<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class payment_plan_edit extends payment_plan
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'payment_plan';

	// Page object name
	public $PageObjName = "payment_plan_edit";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (payment_plan)
		if (!isset($GLOBALS["payment_plan"]) || get_class($GLOBALS["payment_plan"]) == PROJECT_NAMESPACE . "payment_plan") {
			$GLOBALS["payment_plan"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["payment_plan"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'payment_plan');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $payment_plan;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($payment_plan);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "payment_planview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("payment_planlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->plan_type->setVisibility();
		$this->location->setVisibility();
		$this->from_date->setVisibility();
		$this->to_date->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->process->setVisibility();
		$this->product_type->setVisibility();
		$this->shape->setVisibility();
		$this->selection->setVisibility();
		$this->gcode->setVisibility();
		$this->ref->setVisibility();
		$this->description->setVisibility();
		$this->yes_no->setVisibility();
		$this->packing_payment_type->setVisibility();
		$this->fix->setVisibility();
		$this->method->setVisibility();
		$this->sqm_method->setVisibility();
		$this->unit->setVisibility();
		$this->_40_unit->setVisibility();
		$this->_40->setVisibility();
		$this->extra_plan->setVisibility();
		$this->custom_size->setVisibility();
		$this->custom_size_below_st->setVisibility();
		$this->status->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->uploads->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->grp->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->gcode);
		$this->setupLookupOptions($this->ref);
		$this->setupLookupOptions($this->method);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("payment_planlist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "payment_planlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'plan_type' first before field var 'x_plan_type'
		$val = $CurrentForm->hasValue("plan_type") ? $CurrentForm->getValue("plan_type") : $CurrentForm->getValue("x_plan_type");
		if (!$this->plan_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->plan_type->Visible = FALSE; // Disable update for API request
			else
				$this->plan_type->setFormValue($val);
		}

		// Check field name 'location' first before field var 'x_location'
		$val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
		if (!$this->location->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->location->Visible = FALSE; // Disable update for API request
			else
				$this->location->setFormValue($val);
		}

		// Check field name 'from_date' first before field var 'x_from_date'
		$val = $CurrentForm->hasValue("from_date") ? $CurrentForm->getValue("from_date") : $CurrentForm->getValue("x_from_date");
		if (!$this->from_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->from_date->Visible = FALSE; // Disable update for API request
			else
				$this->from_date->setFormValue($val);
			$this->from_date->CurrentValue = UnFormatDateTime($this->from_date->CurrentValue, 0);
		}

		// Check field name 'to_date' first before field var 'x_to_date'
		$val = $CurrentForm->hasValue("to_date") ? $CurrentForm->getValue("to_date") : $CurrentForm->getValue("x_to_date");
		if (!$this->to_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->to_date->Visible = FALSE; // Disable update for API request
			else
				$this->to_date->setFormValue($val);
			$this->to_date->CurrentValue = UnFormatDateTime($this->to_date->CurrentValue, 0);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'process' first before field var 'x_process'
		$val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
		if (!$this->process->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process->Visible = FALSE; // Disable update for API request
			else
				$this->process->setFormValue($val);
		}

		// Check field name 'product_type' first before field var 'x_product_type'
		$val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
		if (!$this->product_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_type->Visible = FALSE; // Disable update for API request
			else
				$this->product_type->setFormValue($val);
		}

		// Check field name 'shape' first before field var 'x_shape'
		$val = $CurrentForm->hasValue("shape") ? $CurrentForm->getValue("shape") : $CurrentForm->getValue("x_shape");
		if (!$this->shape->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shape->Visible = FALSE; // Disable update for API request
			else
				$this->shape->setFormValue($val);
		}

		// Check field name 'selection' first before field var 'x_selection'
		$val = $CurrentForm->hasValue("selection") ? $CurrentForm->getValue("selection") : $CurrentForm->getValue("x_selection");
		if (!$this->selection->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->selection->Visible = FALSE; // Disable update for API request
			else
				$this->selection->setFormValue($val);
		}

		// Check field name 'gcode' first before field var 'x_gcode'
		$val = $CurrentForm->hasValue("gcode") ? $CurrentForm->getValue("gcode") : $CurrentForm->getValue("x_gcode");
		if (!$this->gcode->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gcode->Visible = FALSE; // Disable update for API request
			else
				$this->gcode->setFormValue($val);
		}

		// Check field name 'ref' first before field var 'x_ref'
		$val = $CurrentForm->hasValue("ref") ? $CurrentForm->getValue("ref") : $CurrentForm->getValue("x_ref");
		if (!$this->ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ref->Visible = FALSE; // Disable update for API request
			else
				$this->ref->setFormValue($val);
		}

		// Check field name 'description' first before field var 'x_description'
		$val = $CurrentForm->hasValue("description") ? $CurrentForm->getValue("description") : $CurrentForm->getValue("x_description");
		if (!$this->description->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description->Visible = FALSE; // Disable update for API request
			else
				$this->description->setFormValue($val);
		}

		// Check field name 'yes_no' first before field var 'x_yes_no'
		$val = $CurrentForm->hasValue("yes_no") ? $CurrentForm->getValue("yes_no") : $CurrentForm->getValue("x_yes_no");
		if (!$this->yes_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->yes_no->Visible = FALSE; // Disable update for API request
			else
				$this->yes_no->setFormValue($val);
		}

		// Check field name 'packing_payment_type' first before field var 'x_packing_payment_type'
		$val = $CurrentForm->hasValue("packing_payment_type") ? $CurrentForm->getValue("packing_payment_type") : $CurrentForm->getValue("x_packing_payment_type");
		if (!$this->packing_payment_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_payment_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_payment_type->setFormValue($val);
		}

		// Check field name 'fix' first before field var 'x_fix'
		$val = $CurrentForm->hasValue("fix") ? $CurrentForm->getValue("fix") : $CurrentForm->getValue("x_fix");
		if (!$this->fix->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fix->Visible = FALSE; // Disable update for API request
			else
				$this->fix->setFormValue($val);
		}

		// Check field name 'method' first before field var 'x_method'
		$val = $CurrentForm->hasValue("method") ? $CurrentForm->getValue("method") : $CurrentForm->getValue("x_method");
		if (!$this->method->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->method->Visible = FALSE; // Disable update for API request
			else
				$this->method->setFormValue($val);
		}

		// Check field name 'sqm_method' first before field var 'x_sqm_method'
		$val = $CurrentForm->hasValue("sqm_method") ? $CurrentForm->getValue("sqm_method") : $CurrentForm->getValue("x_sqm_method");
		if (!$this->sqm_method->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sqm_method->Visible = FALSE; // Disable update for API request
			else
				$this->sqm_method->setFormValue($val);
		}

		// Check field name 'unit' first before field var 'x_unit'
		$val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
		if (!$this->unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unit->Visible = FALSE; // Disable update for API request
			else
				$this->unit->setFormValue($val);
		}

		// Check field name '@_unit' first before field var 'x__40_unit'
		$val = $CurrentForm->hasValue("@_unit") ? $CurrentForm->getValue("@_unit") : $CurrentForm->getValue("x__40_unit");
		if (!$this->_40_unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_40_unit->Visible = FALSE; // Disable update for API request
			else
				$this->_40_unit->setFormValue($val);
		}

		// Check field name '@' first before field var 'x__40'
		$val = $CurrentForm->hasValue("@") ? $CurrentForm->getValue("@") : $CurrentForm->getValue("x__40");
		if (!$this->_40->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_40->Visible = FALSE; // Disable update for API request
			else
				$this->_40->setFormValue($val);
		}

		// Check field name 'extra_plan' first before field var 'x_extra_plan'
		$val = $CurrentForm->hasValue("extra_plan") ? $CurrentForm->getValue("extra_plan") : $CurrentForm->getValue("x_extra_plan");
		if (!$this->extra_plan->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->extra_plan->Visible = FALSE; // Disable update for API request
			else
				$this->extra_plan->setFormValue($val);
		}

		// Check field name 'custom_size' first before field var 'x_custom_size'
		$val = $CurrentForm->hasValue("custom_size") ? $CurrentForm->getValue("custom_size") : $CurrentForm->getValue("x_custom_size");
		if (!$this->custom_size->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->custom_size->Visible = FALSE; // Disable update for API request
			else
				$this->custom_size->setFormValue($val);
		}

		// Check field name 'custom_size_below_st' first before field var 'x_custom_size_below_st'
		$val = $CurrentForm->hasValue("custom_size_below_st") ? $CurrentForm->getValue("custom_size_below_st") : $CurrentForm->getValue("x_custom_size_below_st");
		if (!$this->custom_size_below_st->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->custom_size_below_st->Visible = FALSE; // Disable update for API request
			else
				$this->custom_size_below_st->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'uploads' first before field var 'x_uploads'
		$val = $CurrentForm->hasValue("uploads") ? $CurrentForm->getValue("uploads") : $CurrentForm->getValue("x_uploads");
		if (!$this->uploads->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->uploads->Visible = FALSE; // Disable update for API request
			else
				$this->uploads->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->plan_type->CurrentValue = $this->plan_type->FormValue;
		$this->location->CurrentValue = $this->location->FormValue;
		$this->from_date->CurrentValue = $this->from_date->FormValue;
		$this->from_date->CurrentValue = UnFormatDateTime($this->from_date->CurrentValue, 0);
		$this->to_date->CurrentValue = $this->to_date->FormValue;
		$this->to_date->CurrentValue = UnFormatDateTime($this->to_date->CurrentValue, 0);
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->process->CurrentValue = $this->process->FormValue;
		$this->product_type->CurrentValue = $this->product_type->FormValue;
		$this->shape->CurrentValue = $this->shape->FormValue;
		$this->selection->CurrentValue = $this->selection->FormValue;
		$this->gcode->CurrentValue = $this->gcode->FormValue;
		$this->ref->CurrentValue = $this->ref->FormValue;
		$this->description->CurrentValue = $this->description->FormValue;
		$this->yes_no->CurrentValue = $this->yes_no->FormValue;
		$this->packing_payment_type->CurrentValue = $this->packing_payment_type->FormValue;
		$this->fix->CurrentValue = $this->fix->FormValue;
		$this->method->CurrentValue = $this->method->FormValue;
		$this->sqm_method->CurrentValue = $this->sqm_method->FormValue;
		$this->unit->CurrentValue = $this->unit->FormValue;
		$this->_40_unit->CurrentValue = $this->_40_unit->FormValue;
		$this->_40->CurrentValue = $this->_40->FormValue;
		$this->extra_plan->CurrentValue = $this->extra_plan->FormValue;
		$this->custom_size->CurrentValue = $this->custom_size->FormValue;
		$this->custom_size_below_st->CurrentValue = $this->custom_size_below_st->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->uploads->CurrentValue = $this->uploads->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->plan_type->setDbValue($row['plan_type']);
		$this->location->setDbValue($row['location']);
		$this->from_date->setDbValue($row['from_date']);
		$this->to_date->setDbValue($row['to_date']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->process->setDbValue($row['process']);
		if (array_key_exists('EV__process', $rs->fields)) {
			$this->process->VirtualValue = $rs->fields('EV__process'); // Set up virtual field value
		} else {
			$this->process->VirtualValue = ""; // Clear value
		}
		$this->product_type->setDbValue($row['product_type']);
		$this->shape->setDbValue($row['shape']);
		$this->selection->setDbValue($row['selection']);
		$this->gcode->setDbValue($row['gcode']);
		$this->ref->setDbValue($row['ref']);
		if (array_key_exists('EV__ref', $rs->fields)) {
			$this->ref->VirtualValue = $rs->fields('EV__ref'); // Set up virtual field value
		} else {
			$this->ref->VirtualValue = ""; // Clear value
		}
		$this->description->setDbValue($row['description']);
		$this->yes_no->setDbValue($row['yes_no']);
		$this->packing_payment_type->setDbValue($row['packing_payment_type']);
		$this->fix->setDbValue($row['fix']);
		$this->method->setDbValue($row['method']);
		$this->sqm_method->setDbValue($row['sqm_method']);
		$this->unit->setDbValue($row['unit']);
		$this->_40_unit->setDbValue($row['@_unit']);
		$this->_40->setDbValue($row['@']);
		$this->extra_plan->setDbValue($row['extra_plan']);
		$this->custom_size->setDbValue($row['custom_size']);
		$this->custom_size_below_st->setDbValue($row['custom_size_below_st']);
		$this->status->setDbValue($row['status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->uploads->setDbValue($row['uploads']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['plan_type'] = NULL;
		$row['location'] = NULL;
		$row['from_date'] = NULL;
		$row['to_date'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['process'] = NULL;
		$row['product_type'] = NULL;
		$row['shape'] = NULL;
		$row['selection'] = NULL;
		$row['gcode'] = NULL;
		$row['ref'] = NULL;
		$row['description'] = NULL;
		$row['yes_no'] = NULL;
		$row['packing_payment_type'] = NULL;
		$row['fix'] = NULL;
		$row['method'] = NULL;
		$row['sqm_method'] = NULL;
		$row['unit'] = NULL;
		$row['@_unit'] = NULL;
		$row['@'] = NULL;
		$row['extra_plan'] = NULL;
		$row['custom_size'] = NULL;
		$row['custom_size_below_st'] = NULL;
		$row['status'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['uploads'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->_40_unit->FormValue == $this->_40_unit->CurrentValue && is_numeric(ConvertToFloatString($this->_40_unit->CurrentValue)))
			$this->_40_unit->CurrentValue = ConvertToFloatString($this->_40_unit->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_40->FormValue == $this->_40->CurrentValue && is_numeric(ConvertToFloatString($this->_40->CurrentValue)))
			$this->_40->CurrentValue = ConvertToFloatString($this->_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->custom_size->FormValue == $this->custom_size->CurrentValue && is_numeric(ConvertToFloatString($this->custom_size->CurrentValue)))
			$this->custom_size->CurrentValue = ConvertToFloatString($this->custom_size->CurrentValue);

		// Convert decimal values if posted back
		if ($this->custom_size_below_st->FormValue == $this->custom_size_below_st->CurrentValue && is_numeric(ConvertToFloatString($this->custom_size_below_st->CurrentValue)))
			$this->custom_size_below_st->CurrentValue = ConvertToFloatString($this->custom_size_below_st->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// plan_type
		// location
		// from_date
		// to_date
		// grp
		// s_grp
		// process
		// product_type
		// shape
		// selection
		// gcode
		// ref
		// description
		// yes_no
		// packing_payment_type
		// fix
		// method
		// sqm_method
		// unit
		// @_unit
		// @
		// extra_plan
		// custom_size
		// custom_size_below_st
		// status
		// operator
		// datetime
		// uploads

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// plan_type
			if (strval($this->plan_type->CurrentValue) <> "") {
				$this->plan_type->ViewValue = $this->plan_type->optionCaption($this->plan_type->CurrentValue);
			} else {
				$this->plan_type->ViewValue = NULL;
			}
			$this->plan_type->ViewCustomAttributes = "";

			// location
			$curVal = strval($this->location->CurrentValue);
			if ($curVal <> "") {
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
				if ($this->location->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1 and `id` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->location->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->location->ViewValue->add($this->location->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->location->ViewValue = $this->location->CurrentValue;
					}
				}
			} else {
				$this->location->ViewValue = NULL;
			}
			$this->location->ViewCustomAttributes = "";

			// from_date
			$this->from_date->ViewValue = $this->from_date->CurrentValue;
			$this->from_date->ViewValue = FormatDateTime($this->from_date->ViewValue, 0);
			$this->from_date->ViewCustomAttributes = "";

			// to_date
			$this->to_date->ViewValue = $this->to_date->CurrentValue;
			$this->to_date->ViewValue = FormatDateTime($this->to_date->ViewValue, 0);
			$this->to_date->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// process
			if ($this->process->VirtualValue <> "") {
				$this->process->ViewValue = $this->process->VirtualValue;
			} else {
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`type`=1 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			}
			$this->process->ViewCustomAttributes = "";

			// product_type
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1 and `id` !=9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->product_type->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->product_type->ViewValue->add($this->product_type->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1 and id < 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->shape->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->shape->ViewValue->add($this->shape->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// selection
			if (strval($this->selection->CurrentValue) <> "") {
				$this->selection->ViewValue = $this->selection->optionCaption($this->selection->CurrentValue);
			} else {
				$this->selection->ViewValue = NULL;
			}
			$this->selection->ViewCustomAttributes = "";

			// gcode
			$curVal = strval($this->gcode->CurrentValue);
			if ($curVal <> "") {
				$this->gcode->ViewValue = $this->gcode->lookupCacheOption($curVal);
				if ($this->gcode->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`gcode`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->gcode->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->gcode->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->gcode->ViewValue->add($this->gcode->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->gcode->ViewValue = $this->gcode->CurrentValue;
					}
				}
			} else {
				$this->gcode->ViewValue = NULL;
			}
			$this->gcode->ViewCustomAttributes = "";

			// ref
			if ($this->ref->VirtualValue <> "") {
				$this->ref->ViewValue = $this->ref->VirtualValue;
			} else {
			$curVal = strval($this->ref->CurrentValue);
			if ($curVal <> "") {
				$this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
				if ($this->ref->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->ref->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->ref->ViewValue->add($this->ref->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->ref->ViewValue = $this->ref->CurrentValue;
					}
				}
			} else {
				$this->ref->ViewValue = NULL;
			}
			}
			$this->ref->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// yes_no
			if (strval($this->yes_no->CurrentValue) <> "") {
				$this->yes_no->ViewValue = $this->yes_no->optionCaption($this->yes_no->CurrentValue);
			} else {
				$this->yes_no->ViewValue = NULL;
			}
			$this->yes_no->ViewCustomAttributes = "";

			// packing_payment_type
			if (strval($this->packing_payment_type->CurrentValue) <> "") {
				$this->packing_payment_type->ViewValue = $this->packing_payment_type->optionCaption($this->packing_payment_type->CurrentValue);
			} else {
				$this->packing_payment_type->ViewValue = NULL;
			}
			$this->packing_payment_type->ViewCustomAttributes = "";

			// fix
			if (strval($this->fix->CurrentValue) <> "") {
				$this->fix->ViewValue = $this->fix->optionCaption($this->fix->CurrentValue);
			} else {
				$this->fix->ViewValue = NULL;
			}
			$this->fix->ViewCustomAttributes = "";

			// method
			$curVal = strval($this->method->CurrentValue);
			if ($curVal <> "") {
				$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
				if ($this->method->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->method->ViewValue = $this->method->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->method->ViewValue = $this->method->CurrentValue;
					}
				}
			} else {
				$this->method->ViewValue = NULL;
			}
			$this->method->ViewCustomAttributes = "";

			// sqm_method
			if (strval($this->sqm_method->CurrentValue) <> "") {
				$this->sqm_method->ViewValue = $this->sqm_method->optionCaption($this->sqm_method->CurrentValue);
			} else {
				$this->sqm_method->ViewValue = NULL;
			}
			$this->sqm_method->ViewCustomAttributes = "";

			// unit
			if (strval($this->unit->CurrentValue) <> "") {
				$this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// @_unit
			$this->_40_unit->ViewValue = $this->_40_unit->CurrentValue;
			$this->_40_unit->ViewValue = FormatNumber($this->_40_unit->ViewValue, 2, -2, -2, -2);
			$this->_40_unit->ViewCustomAttributes = "";

			// @
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewValue = FormatNumber($this->_40->ViewValue, 2, -2, -2, -2);
			$this->_40->ViewCustomAttributes = "";

			// extra_plan
			if (strval($this->extra_plan->CurrentValue) <> "") {
				$this->extra_plan->ViewValue = $this->extra_plan->optionCaption($this->extra_plan->CurrentValue);
			} else {
				$this->extra_plan->ViewValue = NULL;
			}
			$this->extra_plan->ViewCustomAttributes = "";

			// custom_size
			$this->custom_size->ViewValue = $this->custom_size->CurrentValue;
			$this->custom_size->ViewValue = FormatNumber($this->custom_size->ViewValue, 2, -2, -2, -2);
			$this->custom_size->ViewCustomAttributes = "";

			// custom_size_below_st
			$this->custom_size_below_st->ViewValue = $this->custom_size_below_st->CurrentValue;
			$this->custom_size_below_st->ViewValue = FormatNumber($this->custom_size_below_st->ViewValue, 2, -2, -2, -2);
			$this->custom_size_below_st->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// uploads
			$this->uploads->ViewValue = $this->uploads->CurrentValue;
			$this->uploads->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// plan_type
			$this->plan_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->plan_type->CurrentValue)) {
				$this->plan_type->HrefValue = "payment_planlist.php?x_plan_type=" . $this->plan_type->CurrentValue; // Add prefix/suffix
				$this->plan_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->plan_type->HrefValue = FullUrl($this->plan_type->HrefValue, "href");
			} else {
				$this->plan_type->HrefValue = "";
			}
			$this->plan_type->TooltipValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			if (!EmptyValue($this->location->CurrentValue)) {
				$this->location->HrefValue = "payment_planlist.php?x_location=" . $this->location->CurrentValue; // Add prefix/suffix
				$this->location->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->location->HrefValue = FullUrl($this->location->HrefValue, "href");
			} else {
				$this->location->HrefValue = "";
			}
			$this->location->TooltipValue = "";

			// from_date
			$this->from_date->LinkCustomAttributes = "";
			$this->from_date->HrefValue = "";
			$this->from_date->TooltipValue = "";

			// to_date
			$this->to_date->LinkCustomAttributes = "";
			$this->to_date->HrefValue = "";
			$this->to_date->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "payment_planlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}
			$this->process->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// selection
			$this->selection->LinkCustomAttributes = "";
			$this->selection->HrefValue = "";
			$this->selection->TooltipValue = "";

			// gcode
			$this->gcode->LinkCustomAttributes = "";
			if (!EmptyValue($this->gcode->CurrentValue)) {
				$this->gcode->HrefValue = "payment_planlist.php?x_gcode=" . $this->gcode->CurrentValue; // Add prefix/suffix
				$this->gcode->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->gcode->HrefValue = FullUrl($this->gcode->HrefValue, "href");
			} else {
				$this->gcode->HrefValue = "";
			}
			$this->gcode->TooltipValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->gcode->CurrentValue)) {
				$this->ref->HrefValue = "payment_planlist.php?x_ref=" . $this->gcode->CurrentValue; // Add prefix/suffix
				$this->ref->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->ref->HrefValue = FullUrl($this->ref->HrefValue, "href");
			} else {
				$this->ref->HrefValue = "";
			}
			$this->ref->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";
			$this->description->TooltipValue = "";

			// yes_no
			$this->yes_no->LinkCustomAttributes = "";
			$this->yes_no->HrefValue = "";
			$this->yes_no->TooltipValue = "";

			// packing_payment_type
			$this->packing_payment_type->LinkCustomAttributes = "";
			$this->packing_payment_type->HrefValue = "";
			$this->packing_payment_type->TooltipValue = "";

			// fix
			$this->fix->LinkCustomAttributes = "";
			$this->fix->HrefValue = "";
			$this->fix->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// sqm_method
			$this->sqm_method->LinkCustomAttributes = "";
			$this->sqm_method->HrefValue = "";
			$this->sqm_method->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// @_unit
			$this->_40_unit->LinkCustomAttributes = "";
			$this->_40_unit->HrefValue = "";
			$this->_40_unit->TooltipValue = "";

			// @
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";

			// extra_plan
			$this->extra_plan->LinkCustomAttributes = "";
			$this->extra_plan->HrefValue = "";
			$this->extra_plan->TooltipValue = "";

			// custom_size
			$this->custom_size->LinkCustomAttributes = "";
			$this->custom_size->HrefValue = "";
			$this->custom_size->TooltipValue = "";

			// custom_size_below_st
			$this->custom_size_below_st->LinkCustomAttributes = "";
			$this->custom_size_below_st->HrefValue = "";
			$this->custom_size_below_st->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->HrefValue = "";
			$this->uploads->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// plan_type
			$this->plan_type->EditAttrs["class"] = "form-control";
			$this->plan_type->EditCustomAttributes = "";
			$this->plan_type->EditValue = $this->plan_type->options(TRUE);

			// location
			$this->location->EditAttrs["class"] = "form-control";
			$this->location->EditCustomAttributes = "";
			$curVal = trim(strval($this->location->CurrentValue));
			if ($curVal <> "")
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
			else
				$this->location->ViewValue = $this->location->Lookup !== NULL && is_array($this->location->Lookup->Options) ? $curVal : NULL;
			if ($this->location->ViewValue !== NULL) { // Load from cache
				$this->location->EditValue = array_values($this->location->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` > 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->location->EditValue = $arwrk;
			}

			// from_date
			$this->from_date->EditAttrs["class"] = "form-control";
			$this->from_date->EditCustomAttributes = "";
			$this->from_date->EditValue = HtmlEncode(FormatDateTime($this->from_date->CurrentValue, 8));
			$this->from_date->PlaceHolder = RemoveHtml($this->from_date->caption());

			// to_date
			$this->to_date->EditAttrs["class"] = "form-control";
			$this->to_date->EditCustomAttributes = "";
			$this->to_date->EditValue = HtmlEncode(FormatDateTime($this->to_date->CurrentValue, 8));
			$this->to_date->PlaceHolder = RemoveHtml($this->to_date->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->EditValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->EditValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->EditValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->CurrentValue));
			if ($curVal <> "")
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			$curVal = trim(strval($this->process->CurrentValue));
			if ($curVal <> "")
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			else
				$this->process->ViewValue = $this->process->Lookup !== NULL && is_array($this->process->Lookup->Options) ? $curVal : NULL;
			if ($this->process->ViewValue !== NULL) { // Load from cache
				$this->process->EditValue = array_values($this->process->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->process->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`type`=1 and `status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process->EditValue = $arwrk;
			}

			// product_type
			$this->product_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_type->CurrentValue));
			if ($curVal <> "")
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
			else
				$this->product_type->ViewValue = $this->product_type->Lookup !== NULL && is_array($this->product_type->Lookup->Options) ? $curVal : NULL;
			if ($this->product_type->ViewValue !== NULL) { // Load from cache
				$this->product_type->EditValue = array_values($this->product_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` !=9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_type->EditValue = $arwrk;
			}

			// shape
			$this->shape->EditCustomAttributes = "";
			$curVal = trim(strval($this->shape->CurrentValue));
			if ($curVal <> "")
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
			else
				$this->shape->ViewValue = $this->shape->Lookup !== NULL && is_array($this->shape->Lookup->Options) ? $curVal : NULL;
			if ($this->shape->ViewValue !== NULL) { // Load from cache
				$this->shape->EditValue = array_values($this->shape->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1 and id < 100";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->shape->EditValue = $arwrk;
			}

			// selection
			$this->selection->EditAttrs["class"] = "form-control";
			$this->selection->EditCustomAttributes = "";
			$this->selection->EditValue = $this->selection->options(TRUE);

			// gcode
			$this->gcode->EditCustomAttributes = "";
			$curVal = trim(strval($this->gcode->CurrentValue));
			if ($curVal <> "")
				$this->gcode->ViewValue = $this->gcode->lookupCacheOption($curVal);
			else
				$this->gcode->ViewValue = $this->gcode->Lookup !== NULL && is_array($this->gcode->Lookup->Options) ? $curVal : NULL;
			if ($this->gcode->ViewValue !== NULL) { // Load from cache
				$this->gcode->EditValue = array_values($this->gcode->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`gcode`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->gcode->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->gcode->EditValue = $arwrk;
			}

			// ref
			$this->ref->EditCustomAttributes = "";
			$curVal = trim(strval($this->ref->CurrentValue));
			if ($curVal <> "")
				$this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
			else
				$this->ref->ViewValue = $this->ref->Lookup !== NULL && is_array($this->ref->Lookup->Options) ? $curVal : NULL;
			if ($this->ref->ViewValue !== NULL) { // Load from cache
				$this->ref->EditValue = array_values($this->ref->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->ref->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ref->EditValue = $arwrk;
			}

			// description
			$this->description->EditAttrs["class"] = "form-control";
			$this->description->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
			$this->description->EditValue = HtmlEncode($this->description->CurrentValue);
			$this->description->PlaceHolder = RemoveHtml($this->description->caption());

			// yes_no
			$this->yes_no->EditAttrs["class"] = "form-control";
			$this->yes_no->EditCustomAttributes = "";
			$this->yes_no->EditValue = $this->yes_no->options(TRUE);

			// packing_payment_type
			$this->packing_payment_type->EditAttrs["class"] = "form-control";
			$this->packing_payment_type->EditCustomAttributes = "";
			$this->packing_payment_type->EditValue = $this->packing_payment_type->options(TRUE);

			// fix
			$this->fix->EditAttrs["class"] = "form-control";
			$this->fix->EditCustomAttributes = "";
			$this->fix->EditValue = $this->fix->options(TRUE);

			// method
			$this->method->EditAttrs["class"] = "form-control";
			$this->method->EditCustomAttributes = "";
			$curVal = trim(strval($this->method->CurrentValue));
			if ($curVal <> "")
				$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
			else
				$this->method->ViewValue = $this->method->Lookup !== NULL && is_array($this->method->Lookup->Options) ? $curVal : NULL;
			if ($this->method->ViewValue !== NULL) { // Load from cache
				$this->method->EditValue = array_values($this->method->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->method->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=11";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->method->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->method->EditValue = $arwrk;
			}

			// sqm_method
			$this->sqm_method->EditAttrs["class"] = "form-control";
			$this->sqm_method->EditCustomAttributes = "";
			$this->sqm_method->EditValue = $this->sqm_method->options(TRUE);

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";
			$this->unit->EditValue = $this->unit->options(TRUE);

			// @_unit
			$this->_40_unit->EditAttrs["class"] = "form-control";
			$this->_40_unit->EditCustomAttributes = "";
			$this->_40_unit->EditValue = HtmlEncode($this->_40_unit->CurrentValue);
			$this->_40_unit->PlaceHolder = RemoveHtml($this->_40_unit->caption());
			if (strval($this->_40_unit->EditValue) <> "" && is_numeric($this->_40_unit->EditValue))
				$this->_40_unit->EditValue = FormatNumber($this->_40_unit->EditValue, -2, -2, -2, -2);

			// @
			$this->_40->EditAttrs["class"] = "form-control";
			$this->_40->EditCustomAttributes = "";
			$this->_40->EditValue = HtmlEncode($this->_40->CurrentValue);
			$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
			if (strval($this->_40->EditValue) <> "" && is_numeric($this->_40->EditValue))
				$this->_40->EditValue = FormatNumber($this->_40->EditValue, -2, -2, -2, -2);

			// extra_plan
			$this->extra_plan->EditAttrs["class"] = "form-control";
			$this->extra_plan->EditCustomAttributes = "";
			$this->extra_plan->EditValue = $this->extra_plan->options(TRUE);

			// custom_size
			$this->custom_size->EditAttrs["class"] = "form-control";
			$this->custom_size->EditCustomAttributes = "";
			$this->custom_size->EditValue = HtmlEncode($this->custom_size->CurrentValue);
			$this->custom_size->PlaceHolder = RemoveHtml($this->custom_size->caption());
			if (strval($this->custom_size->EditValue) <> "" && is_numeric($this->custom_size->EditValue))
				$this->custom_size->EditValue = FormatNumber($this->custom_size->EditValue, -2, -2, -2, -2);

			// custom_size_below_st
			$this->custom_size_below_st->EditAttrs["class"] = "form-control";
			$this->custom_size_below_st->EditCustomAttributes = "";
			$this->custom_size_below_st->EditValue = HtmlEncode($this->custom_size_below_st->CurrentValue);
			$this->custom_size_below_st->PlaceHolder = RemoveHtml($this->custom_size_below_st->caption());
			if (strval($this->custom_size_below_st->EditValue) <> "" && is_numeric($this->custom_size_below_st->EditValue))
				$this->custom_size_below_st->EditValue = FormatNumber($this->custom_size_below_st->EditValue, -2, -2, -2, -2);

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// operator
			// datetime
			// uploads

			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			$this->uploads->EditValue = HtmlEncode($this->uploads->CurrentValue);
			$this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// plan_type
			$this->plan_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->plan_type->CurrentValue)) {
				$this->plan_type->HrefValue = "payment_planlist.php?x_plan_type=" . $this->plan_type->CurrentValue; // Add prefix/suffix
				$this->plan_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->plan_type->HrefValue = FullUrl($this->plan_type->HrefValue, "href");
			} else {
				$this->plan_type->HrefValue = "";
			}

			// location
			$this->location->LinkCustomAttributes = "";
			if (!EmptyValue($this->location->CurrentValue)) {
				$this->location->HrefValue = "payment_planlist.php?x_location=" . $this->location->CurrentValue; // Add prefix/suffix
				$this->location->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->location->HrefValue = FullUrl($this->location->HrefValue, "href");
			} else {
				$this->location->HrefValue = "";
			}

			// from_date
			$this->from_date->LinkCustomAttributes = "";
			$this->from_date->HrefValue = "";

			// to_date
			$this->to_date->LinkCustomAttributes = "";
			$this->to_date->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "payment_planlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";

			// selection
			$this->selection->LinkCustomAttributes = "";
			$this->selection->HrefValue = "";

			// gcode
			$this->gcode->LinkCustomAttributes = "";
			if (!EmptyValue($this->gcode->CurrentValue)) {
				$this->gcode->HrefValue = "payment_planlist.php?x_gcode=" . $this->gcode->CurrentValue; // Add prefix/suffix
				$this->gcode->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->gcode->HrefValue = FullUrl($this->gcode->HrefValue, "href");
			} else {
				$this->gcode->HrefValue = "";
			}

			// ref
			$this->ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->gcode->CurrentValue)) {
				$this->ref->HrefValue = "payment_planlist.php?x_ref=" . $this->gcode->CurrentValue; // Add prefix/suffix
				$this->ref->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->ref->HrefValue = FullUrl($this->ref->HrefValue, "href");
			} else {
				$this->ref->HrefValue = "";
			}

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";

			// yes_no
			$this->yes_no->LinkCustomAttributes = "";
			$this->yes_no->HrefValue = "";

			// packing_payment_type
			$this->packing_payment_type->LinkCustomAttributes = "";
			$this->packing_payment_type->HrefValue = "";

			// fix
			$this->fix->LinkCustomAttributes = "";
			$this->fix->HrefValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";

			// sqm_method
			$this->sqm_method->LinkCustomAttributes = "";
			$this->sqm_method->HrefValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";

			// @_unit
			$this->_40_unit->LinkCustomAttributes = "";
			$this->_40_unit->HrefValue = "";

			// @
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";

			// extra_plan
			$this->extra_plan->LinkCustomAttributes = "";
			$this->extra_plan->HrefValue = "";

			// custom_size
			$this->custom_size->LinkCustomAttributes = "";
			$this->custom_size->HrefValue = "";

			// custom_size_below_st
			$this->custom_size_below_st->LinkCustomAttributes = "";
			$this->custom_size_below_st->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->plan_type->Required) {
			if (!$this->plan_type->IsDetailKey && $this->plan_type->FormValue != NULL && $this->plan_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->plan_type->caption(), $this->plan_type->RequiredErrorMessage));
			}
		}
		if ($this->location->Required) {
			if ($this->location->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
			}
		}
		if ($this->from_date->Required) {
			if (!$this->from_date->IsDetailKey && $this->from_date->FormValue != NULL && $this->from_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->from_date->caption(), $this->from_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->from_date->FormValue)) {
			AddMessage($FormError, $this->from_date->errorMessage());
		}
		if ($this->to_date->Required) {
			if (!$this->to_date->IsDetailKey && $this->to_date->FormValue != NULL && $this->to_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->to_date->caption(), $this->to_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->to_date->FormValue)) {
			AddMessage($FormError, $this->to_date->errorMessage());
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->process->Required) {
			if (!$this->process->IsDetailKey && $this->process->FormValue != NULL && $this->process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
			}
		}
		if ($this->product_type->Required) {
			if ($this->product_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
			}
		}
		if ($this->shape->Required) {
			if ($this->shape->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
			}
		}
		if ($this->selection->Required) {
			if (!$this->selection->IsDetailKey && $this->selection->FormValue != NULL && $this->selection->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->selection->caption(), $this->selection->RequiredErrorMessage));
			}
		}
		if ($this->gcode->Required) {
			if ($this->gcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gcode->caption(), $this->gcode->RequiredErrorMessage));
			}
		}
		if ($this->ref->Required) {
			if ($this->ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ref->caption(), $this->ref->RequiredErrorMessage));
			}
		}
		if ($this->description->Required) {
			if (!$this->description->IsDetailKey && $this->description->FormValue != NULL && $this->description->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description->caption(), $this->description->RequiredErrorMessage));
			}
		}
		if ($this->yes_no->Required) {
			if (!$this->yes_no->IsDetailKey && $this->yes_no->FormValue != NULL && $this->yes_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->yes_no->caption(), $this->yes_no->RequiredErrorMessage));
			}
		}
		if ($this->packing_payment_type->Required) {
			if (!$this->packing_payment_type->IsDetailKey && $this->packing_payment_type->FormValue != NULL && $this->packing_payment_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_payment_type->caption(), $this->packing_payment_type->RequiredErrorMessage));
			}
		}
		if ($this->fix->Required) {
			if (!$this->fix->IsDetailKey && $this->fix->FormValue != NULL && $this->fix->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fix->caption(), $this->fix->RequiredErrorMessage));
			}
		}
		if ($this->method->Required) {
			if (!$this->method->IsDetailKey && $this->method->FormValue != NULL && $this->method->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->method->caption(), $this->method->RequiredErrorMessage));
			}
		}
		if ($this->sqm_method->Required) {
			if (!$this->sqm_method->IsDetailKey && $this->sqm_method->FormValue != NULL && $this->sqm_method->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm_method->caption(), $this->sqm_method->RequiredErrorMessage));
			}
		}
		if ($this->unit->Required) {
			if (!$this->unit->IsDetailKey && $this->unit->FormValue != NULL && $this->unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
			}
		}
		if ($this->_40_unit->Required) {
			if (!$this->_40_unit->IsDetailKey && $this->_40_unit->FormValue != NULL && $this->_40_unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_40_unit->caption(), $this->_40_unit->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->_40_unit->FormValue)) {
			AddMessage($FormError, $this->_40_unit->errorMessage());
		}
		if ($this->_40->Required) {
			if (!$this->_40->IsDetailKey && $this->_40->FormValue != NULL && $this->_40->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_40->caption(), $this->_40->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->_40->FormValue)) {
			AddMessage($FormError, $this->_40->errorMessage());
		}
		if ($this->extra_plan->Required) {
			if (!$this->extra_plan->IsDetailKey && $this->extra_plan->FormValue != NULL && $this->extra_plan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->extra_plan->caption(), $this->extra_plan->RequiredErrorMessage));
			}
		}
		if ($this->custom_size->Required) {
			if (!$this->custom_size->IsDetailKey && $this->custom_size->FormValue != NULL && $this->custom_size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->custom_size->caption(), $this->custom_size->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->custom_size->FormValue)) {
			AddMessage($FormError, $this->custom_size->errorMessage());
		}
		if ($this->custom_size_below_st->Required) {
			if (!$this->custom_size_below_st->IsDetailKey && $this->custom_size_below_st->FormValue != NULL && $this->custom_size_below_st->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->custom_size_below_st->caption(), $this->custom_size_below_st->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->custom_size_below_st->FormValue)) {
			AddMessage($FormError, $this->custom_size_below_st->errorMessage());
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->uploads->Required) {
			if (!$this->uploads->IsDetailKey && $this->uploads->FormValue != NULL && $this->uploads->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// plan_type
			$this->plan_type->setDbValueDef($rsnew, $this->plan_type->CurrentValue, NULL, $this->plan_type->ReadOnly);

			// location
			$this->location->setDbValueDef($rsnew, $this->location->CurrentValue, NULL, $this->location->ReadOnly);

			// from_date
			$this->from_date->setDbValueDef($rsnew, UnFormatDateTime($this->from_date->CurrentValue, 0), CurrentDate(), $this->from_date->ReadOnly);

			// to_date
			$this->to_date->setDbValueDef($rsnew, UnFormatDateTime($this->to_date->CurrentValue, 0), CurrentDate(), $this->to_date->ReadOnly);

			// s_grp
			$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, NULL, $this->s_grp->ReadOnly);

			// process
			$this->process->setDbValueDef($rsnew, $this->process->CurrentValue, NULL, $this->process->ReadOnly);

			// product_type
			$this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, NULL, $this->product_type->ReadOnly);

			// shape
			$this->shape->setDbValueDef($rsnew, $this->shape->CurrentValue, NULL, $this->shape->ReadOnly);

			// selection
			$this->selection->setDbValueDef($rsnew, $this->selection->CurrentValue, NULL, $this->selection->ReadOnly);

			// gcode
			$this->gcode->setDbValueDef($rsnew, $this->gcode->CurrentValue, NULL, $this->gcode->ReadOnly);

			// ref
			$this->ref->setDbValueDef($rsnew, $this->ref->CurrentValue, NULL, $this->ref->ReadOnly);

			// description
			$this->description->setDbValueDef($rsnew, $this->description->CurrentValue, "", $this->description->ReadOnly);

			// yes_no
			$this->yes_no->setDbValueDef($rsnew, $this->yes_no->CurrentValue, 0, $this->yes_no->ReadOnly);

			// packing_payment_type
			$this->packing_payment_type->setDbValueDef($rsnew, $this->packing_payment_type->CurrentValue, NULL, $this->packing_payment_type->ReadOnly);

			// fix
			$this->fix->setDbValueDef($rsnew, $this->fix->CurrentValue, NULL, $this->fix->ReadOnly);

			// method
			$this->method->setDbValueDef($rsnew, $this->method->CurrentValue, "", $this->method->ReadOnly);

			// sqm_method
			$this->sqm_method->setDbValueDef($rsnew, $this->sqm_method->CurrentValue, 0, $this->sqm_method->ReadOnly);

			// unit
			$this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, NULL, $this->unit->ReadOnly);

			// @_unit
			$this->_40_unit->setDbValueDef($rsnew, $this->_40_unit->CurrentValue, NULL, $this->_40_unit->ReadOnly);

			// @
			$this->_40->setDbValueDef($rsnew, $this->_40->CurrentValue, 0, $this->_40->ReadOnly);

			// extra_plan
			$this->extra_plan->setDbValueDef($rsnew, $this->extra_plan->CurrentValue, 0, $this->extra_plan->ReadOnly);

			// custom_size
			$this->custom_size->setDbValueDef($rsnew, $this->custom_size->CurrentValue, 0, $this->custom_size->ReadOnly);

			// custom_size_below_st
			$this->custom_size_below_st->setDbValueDef($rsnew, $this->custom_size_below_st->CurrentValue, 0, $this->custom_size_below_st->ReadOnly);

			// status
			$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, 0, $this->status->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// uploads
			$this->uploads->setDbValueDef($rsnew, $this->uploads->CurrentValue, NULL, $this->uploads->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("payment_planlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_location":
					$lookupFilter = function() {
						return "`status`=1 and `id` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`type`=1 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_type":
					$lookupFilter = function() {
						return "`status`=1 and `id` !=9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status`=1 and id < 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_gcode":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_method":
					$lookupFilter = function() {
						return "`grp`=11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_location":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_process":
							break;
						case "x_product_type":
							break;
						case "x_shape":
							break;
						case "x_gcode":
							break;
						case "x_ref":
							break;
						case "x_method":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) 
	{

		// Return error message in CustomError
		extract($_POST,EXTR_OVERWRITE);
		$_SESSION[SESSION_MESSAGE] = '';
		$x_ref == null ? $refc = 0 : $refc = count($x_ref);
		$plt = $x_plan_type;
		$x_location = explode(',', $x_location[0]);
		$LCount = count($x_location);
		for ($il=0; $il<$LCount; $il++) 
		{
			$l = $x_location[$il];		
			$x_shape = explode(',', $x_shape[0]);
			$SCount = count($x_shape);
			for ($is=0; $is<$SCount; $is++) 
			{
				$s = $x_shape[$is];
				$x_product_type = explode(',', $x_product_type[0]);
				$ptCount = count($x_product_type);
				for ($pt=0; $pt<$ptCount; $pt++) 
				{
					$p = $x_product_type[$pt];
					if ($x_selection == 0)
					{
						$row = ExecuteRow("SELECT group_concat(`id`) as `id`,  count(`id`) as count FROM `payment_plan` WHERE  $x_status = 1 and `status` = 1 and (STR_TO_DATE('$x_from_date', '%d/%m/%Y') BETWEEN `from_date` and `to_date` or STR_TO_DATE('$x_to_date', '%d/%m/%Y') BETWEEN `from_date` and `to_date`) and $plt = `plan_type` and FIND_IN_SET($l, `location`) and FIND_IN_SET($p, `product_type`) and FIND_IN_SET($s, `shape`) and process = $x_process  and `s_grp` = $x_s_grp and `id` != $x_id LIMIT 1");
						$c = $row['count'];
						if ($c > 0)
						{
							$_SESSION[SESSION_WARNING_MESSAGE].= 'Same Combination exist for Process in ID No. ' . $row['id'] . '<BR>';
						}
					}
					else		
					{
						if ($refc > 0)
						{
							$Dref = count($x_ref);
							for ($id=0; $id<$Dref; $id++) 
							{
							$d = $x_ref[$id];
								$row1 = ExecuteRow("SELECT `id`,  count(`id`) as count,  `ref`,  `status` FROM `payment_plan` WHERE  $x_status = 1 and `status` = 1 and (STR_TO_DATE('$x_from_date', '%d/%m/%Y') BETWEEN `from_date` and `to_date` or STR_TO_DATE('$x_to_date', '%d/%m/%Y') BETWEEN `from_date` and `to_date`) and $plt = `plan_type` and FIND_IN_SET($l, `location`) and FIND_IN_SET($p, `product_type`) and FIND_IN_SET($s, `shape`) and FIND_IN_SET($d, `ref`) and process = $x_process and `id` != $x_id LIMIT 1");
								$c1 = $row1['count'];
								if ($c1 > 0)
								{
									$_SESSION[SESSION_WARNING_MESSAGE].= 'Same Combination exist for Design ID: ' .$d. ' in ID No. ' . $row1['id'] . '<BR>';
								}
								if ($plt == 1)
								{
								$row2 = ExecuteRow("SELECT `id`,  count(`id`) as count,  `ref`,  `status` FROM `payment_plan` WHERE  $x_status = 1 and `status` = 1 and (STR_TO_DATE('$x_from_date', '%d/%m/%Y') BETWEEN `from_date` and `to_date` or STR_TO_DATE('$x_to_date', '%d/%m/%Y') BETWEEN `from_date` and `to_date`) and 0 = `plan_type` and FIND_IN_SET($l, `location`) and FIND_IN_SET($p, `product_type`) and FIND_IN_SET($s, `shape`) and FIND_IN_SET($d, `ref`) and process = $x_process and `id` != $x_id LIMIT 1");
								$c2 = $row2['count'];
									if ($c2 > 0)
									{
										$_SESSION[SESSION_WARNING_MESSAGE].= '';
									}
									else
									{
										$_SESSION[SESSION_WARNING_MESSAGE].= 'Create Required Basic Plan for Design ID: ' .$d. ' First.<BR>';
									}
								}									
							}
						}
						else
						{
							$_SESSION[SESSION_WARNING_MESSAGE].= 'Select One or more Designs for Payment Plan<BR>';
						}								
					}	
				}		
			}
		}
			if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
			{return TRUE;}
			else
			{return false;}
	}
}
?>