<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class payment_plan_search extends payment_plan
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'payment_plan';

	// Page object name
	public $PageObjName = "payment_plan_search";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (payment_plan)
		if (!isset($GLOBALS["payment_plan"]) || get_class($GLOBALS["payment_plan"]) == PROJECT_NAMESPACE . "payment_plan") {
			$GLOBALS["payment_plan"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["payment_plan"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'payment_plan');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $payment_plan;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($payment_plan);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "payment_planview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("payment_planlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->plan_type->setVisibility();
		$this->location->setVisibility();
		$this->from_date->setVisibility();
		$this->to_date->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->process->setVisibility();
		$this->product_type->setVisibility();
		$this->shape->setVisibility();
		$this->selection->setVisibility();
		$this->gcode->setVisibility();
		$this->ref->setVisibility();
		$this->description->setVisibility();
		$this->yes_no->setVisibility();
		$this->packing_payment_type->setVisibility();
		$this->fix->setVisibility();
		$this->method->setVisibility();
		$this->sqm_method->setVisibility();
		$this->unit->setVisibility();
		$this->_40_unit->setVisibility();
		$this->_40->setVisibility();
		$this->extra_plan->setVisibility();
		$this->custom_size->setVisibility();
		$this->custom_size_below_st->setVisibility();
		$this->status->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->uploads->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->gcode);
		$this->setupLookupOptions($this->ref);
		$this->setupLookupOptions($this->method);
		$this->setupLookupOptions($this->operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "payment_planlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->plan_type); // plan_type
		$this->buildSearchUrl($srchUrl, $this->location); // location
		$this->buildSearchUrl($srchUrl, $this->from_date); // from_date
		$this->buildSearchUrl($srchUrl, $this->to_date); // to_date
		$this->buildSearchUrl($srchUrl, $this->grp); // grp
		$this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
		$this->buildSearchUrl($srchUrl, $this->process); // process
		$this->buildSearchUrl($srchUrl, $this->product_type); // product_type
		$this->buildSearchUrl($srchUrl, $this->shape); // shape
		$this->buildSearchUrl($srchUrl, $this->selection); // selection
		$this->buildSearchUrl($srchUrl, $this->gcode); // gcode
		$this->buildSearchUrl($srchUrl, $this->ref); // ref
		$this->buildSearchUrl($srchUrl, $this->description); // description
		$this->buildSearchUrl($srchUrl, $this->yes_no); // yes_no
		$this->buildSearchUrl($srchUrl, $this->packing_payment_type); // packing_payment_type
		$this->buildSearchUrl($srchUrl, $this->fix); // fix
		$this->buildSearchUrl($srchUrl, $this->method); // method
		$this->buildSearchUrl($srchUrl, $this->sqm_method); // sqm_method
		$this->buildSearchUrl($srchUrl, $this->unit); // unit
		$this->buildSearchUrl($srchUrl, $this->_40_unit); // @_unit
		$this->buildSearchUrl($srchUrl, $this->_40); // @
		$this->buildSearchUrl($srchUrl, $this->extra_plan); // extra_plan
		$this->buildSearchUrl($srchUrl, $this->custom_size); // custom_size
		$this->buildSearchUrl($srchUrl, $this->custom_size_below_st); // custom_size_below_st
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->uploads); // uploads
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// plan_type
		if (!$this->isAddOrEdit())
			$this->plan_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_plan_type"));
		$this->plan_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_plan_type"));

		// location
		if (!$this->isAddOrEdit())
			$this->location->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_location"));
		$this->location->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_location"));
		if (is_array($this->location->AdvancedSearch->SearchValue))
			$this->location->AdvancedSearch->SearchValue = implode(",", $this->location->AdvancedSearch->SearchValue);
		if (is_array($this->location->AdvancedSearch->SearchValue2))
			$this->location->AdvancedSearch->SearchValue2 = implode(",", $this->location->AdvancedSearch->SearchValue2);

		// from_date
		if (!$this->isAddOrEdit())
			$this->from_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_from_date"));
		$this->from_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_from_date"));

		// to_date
		if (!$this->isAddOrEdit())
			$this->to_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_to_date"));
		$this->to_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_to_date"));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_grp"));
		$this->grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_grp"));

		// s_grp
		if (!$this->isAddOrEdit())
			$this->s_grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_grp"));
		$this->s_grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_grp"));

		// process
		if (!$this->isAddOrEdit())
			$this->process->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process"));
		$this->process->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process"));

		// product_type
		if (!$this->isAddOrEdit())
			$this->product_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_type"));
		$this->product_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_type"));
		$this->product_type->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_product_type"));
		$this->product_type->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_product_type"));
		$this->product_type->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_product_type"));
		if (is_array($this->product_type->AdvancedSearch->SearchValue))
			$this->product_type->AdvancedSearch->SearchValue = implode(",", $this->product_type->AdvancedSearch->SearchValue);
		if (is_array($this->product_type->AdvancedSearch->SearchValue2))
			$this->product_type->AdvancedSearch->SearchValue2 = implode(",", $this->product_type->AdvancedSearch->SearchValue2);

		// shape
		if (!$this->isAddOrEdit())
			$this->shape->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_shape"));
		$this->shape->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_shape"));
		if (is_array($this->shape->AdvancedSearch->SearchValue))
			$this->shape->AdvancedSearch->SearchValue = implode(",", $this->shape->AdvancedSearch->SearchValue);
		if (is_array($this->shape->AdvancedSearch->SearchValue2))
			$this->shape->AdvancedSearch->SearchValue2 = implode(",", $this->shape->AdvancedSearch->SearchValue2);

		// selection
		if (!$this->isAddOrEdit())
			$this->selection->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_selection"));
		$this->selection->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_selection"));

		// gcode
		if (!$this->isAddOrEdit())
			$this->gcode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_gcode"));
		$this->gcode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_gcode"));
		if (is_array($this->gcode->AdvancedSearch->SearchValue))
			$this->gcode->AdvancedSearch->SearchValue = implode(",", $this->gcode->AdvancedSearch->SearchValue);
		if (is_array($this->gcode->AdvancedSearch->SearchValue2))
			$this->gcode->AdvancedSearch->SearchValue2 = implode(",", $this->gcode->AdvancedSearch->SearchValue2);

		// ref
		if (!$this->isAddOrEdit())
			$this->ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ref"));
		$this->ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ref"));
		if (is_array($this->ref->AdvancedSearch->SearchValue))
			$this->ref->AdvancedSearch->SearchValue = implode(",", $this->ref->AdvancedSearch->SearchValue);
		if (is_array($this->ref->AdvancedSearch->SearchValue2))
			$this->ref->AdvancedSearch->SearchValue2 = implode(",", $this->ref->AdvancedSearch->SearchValue2);

		// description
		if (!$this->isAddOrEdit())
			$this->description->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description"));
		$this->description->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description"));

		// yes_no
		if (!$this->isAddOrEdit())
			$this->yes_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_yes_no"));
		$this->yes_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_yes_no"));

		// packing_payment_type
		if (!$this->isAddOrEdit())
			$this->packing_payment_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_packing_payment_type"));
		$this->packing_payment_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_packing_payment_type"));

		// fix
		if (!$this->isAddOrEdit())
			$this->fix->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_fix"));
		$this->fix->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_fix"));

		// method
		if (!$this->isAddOrEdit())
			$this->method->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_method"));
		$this->method->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_method"));

		// sqm_method
		if (!$this->isAddOrEdit())
			$this->sqm_method->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sqm_method"));
		$this->sqm_method->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sqm_method"));

		// unit
		if (!$this->isAddOrEdit())
			$this->unit->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_unit"));
		$this->unit->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_unit"));

		// @_unit
		if (!$this->isAddOrEdit())
			$this->_40_unit->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__40_unit"));
		$this->_40_unit->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__40_unit"));

		// @
		if (!$this->isAddOrEdit())
			$this->_40->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__40"));
		$this->_40->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__40"));

		// extra_plan
		if (!$this->isAddOrEdit())
			$this->extra_plan->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_extra_plan"));
		$this->extra_plan->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_extra_plan"));

		// custom_size
		if (!$this->isAddOrEdit())
			$this->custom_size->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_custom_size"));
		$this->custom_size->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_custom_size"));

		// custom_size_below_st
		if (!$this->isAddOrEdit())
			$this->custom_size_below_st->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_custom_size_below_st"));
		$this->custom_size_below_st->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_custom_size_below_st"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// uploads
		if (!$this->isAddOrEdit())
			$this->uploads->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_uploads"));
		$this->uploads->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_uploads"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->_40_unit->FormValue == $this->_40_unit->CurrentValue && is_numeric(ConvertToFloatString($this->_40_unit->CurrentValue)))
			$this->_40_unit->CurrentValue = ConvertToFloatString($this->_40_unit->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_40->FormValue == $this->_40->CurrentValue && is_numeric(ConvertToFloatString($this->_40->CurrentValue)))
			$this->_40->CurrentValue = ConvertToFloatString($this->_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->custom_size->FormValue == $this->custom_size->CurrentValue && is_numeric(ConvertToFloatString($this->custom_size->CurrentValue)))
			$this->custom_size->CurrentValue = ConvertToFloatString($this->custom_size->CurrentValue);

		// Convert decimal values if posted back
		if ($this->custom_size_below_st->FormValue == $this->custom_size_below_st->CurrentValue && is_numeric(ConvertToFloatString($this->custom_size_below_st->CurrentValue)))
			$this->custom_size_below_st->CurrentValue = ConvertToFloatString($this->custom_size_below_st->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// plan_type
		// location
		// from_date
		// to_date
		// grp
		// s_grp
		// process
		// product_type
		// shape
		// selection
		// gcode
		// ref
		// description
		// yes_no
		// packing_payment_type
		// fix
		// method
		// sqm_method
		// unit
		// @_unit
		// @
		// extra_plan
		// custom_size
		// custom_size_below_st
		// status
		// operator
		// datetime
		// uploads

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// plan_type
			if (strval($this->plan_type->CurrentValue) <> "") {
				$this->plan_type->ViewValue = $this->plan_type->optionCaption($this->plan_type->CurrentValue);
			} else {
				$this->plan_type->ViewValue = NULL;
			}
			$this->plan_type->ViewCustomAttributes = "";

			// location
			$curVal = strval($this->location->CurrentValue);
			if ($curVal <> "") {
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
				if ($this->location->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1 and `id` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->location->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->location->ViewValue->add($this->location->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->location->ViewValue = $this->location->CurrentValue;
					}
				}
			} else {
				$this->location->ViewValue = NULL;
			}
			$this->location->ViewCustomAttributes = "";

			// from_date
			$this->from_date->ViewValue = $this->from_date->CurrentValue;
			$this->from_date->ViewValue = FormatDateTime($this->from_date->ViewValue, 0);
			$this->from_date->ViewCustomAttributes = "";

			// to_date
			$this->to_date->ViewValue = $this->to_date->CurrentValue;
			$this->to_date->ViewValue = FormatDateTime($this->to_date->ViewValue, 0);
			$this->to_date->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// process
			if ($this->process->VirtualValue <> "") {
				$this->process->ViewValue = $this->process->VirtualValue;
			} else {
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`type`=1 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			}
			$this->process->ViewCustomAttributes = "";

			// product_type
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1 and `id` !=9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->product_type->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->product_type->ViewValue->add($this->product_type->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1 and id < 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->shape->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->shape->ViewValue->add($this->shape->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// selection
			if (strval($this->selection->CurrentValue) <> "") {
				$this->selection->ViewValue = $this->selection->optionCaption($this->selection->CurrentValue);
			} else {
				$this->selection->ViewValue = NULL;
			}
			$this->selection->ViewCustomAttributes = "";

			// gcode
			$curVal = strval($this->gcode->CurrentValue);
			if ($curVal <> "") {
				$this->gcode->ViewValue = $this->gcode->lookupCacheOption($curVal);
				if ($this->gcode->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`gcode`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->gcode->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->gcode->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->gcode->ViewValue->add($this->gcode->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->gcode->ViewValue = $this->gcode->CurrentValue;
					}
				}
			} else {
				$this->gcode->ViewValue = NULL;
			}
			$this->gcode->ViewCustomAttributes = "";

			// ref
			if ($this->ref->VirtualValue <> "") {
				$this->ref->ViewValue = $this->ref->VirtualValue;
			} else {
			$curVal = strval($this->ref->CurrentValue);
			if ($curVal <> "") {
				$this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
				if ($this->ref->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->ref->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->ref->ViewValue->add($this->ref->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->ref->ViewValue = $this->ref->CurrentValue;
					}
				}
			} else {
				$this->ref->ViewValue = NULL;
			}
			}
			$this->ref->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// yes_no
			if (strval($this->yes_no->CurrentValue) <> "") {
				$this->yes_no->ViewValue = $this->yes_no->optionCaption($this->yes_no->CurrentValue);
			} else {
				$this->yes_no->ViewValue = NULL;
			}
			$this->yes_no->ViewCustomAttributes = "";

			// packing_payment_type
			if (strval($this->packing_payment_type->CurrentValue) <> "") {
				$this->packing_payment_type->ViewValue = $this->packing_payment_type->optionCaption($this->packing_payment_type->CurrentValue);
			} else {
				$this->packing_payment_type->ViewValue = NULL;
			}
			$this->packing_payment_type->ViewCustomAttributes = "";

			// fix
			if (strval($this->fix->CurrentValue) <> "") {
				$this->fix->ViewValue = $this->fix->optionCaption($this->fix->CurrentValue);
			} else {
				$this->fix->ViewValue = NULL;
			}
			$this->fix->ViewCustomAttributes = "";

			// method
			$curVal = strval($this->method->CurrentValue);
			if ($curVal <> "") {
				$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
				if ($this->method->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->method->ViewValue = $this->method->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->method->ViewValue = $this->method->CurrentValue;
					}
				}
			} else {
				$this->method->ViewValue = NULL;
			}
			$this->method->ViewCustomAttributes = "";

			// sqm_method
			if (strval($this->sqm_method->CurrentValue) <> "") {
				$this->sqm_method->ViewValue = $this->sqm_method->optionCaption($this->sqm_method->CurrentValue);
			} else {
				$this->sqm_method->ViewValue = NULL;
			}
			$this->sqm_method->ViewCustomAttributes = "";

			// unit
			if (strval($this->unit->CurrentValue) <> "") {
				$this->unit->ViewValue = $this->unit->optionCaption($this->unit->CurrentValue);
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// @_unit
			$this->_40_unit->ViewValue = $this->_40_unit->CurrentValue;
			$this->_40_unit->ViewValue = FormatNumber($this->_40_unit->ViewValue, 2, -2, -2, -2);
			$this->_40_unit->ViewCustomAttributes = "";

			// @
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewValue = FormatNumber($this->_40->ViewValue, 2, -2, -2, -2);
			$this->_40->ViewCustomAttributes = "";

			// extra_plan
			if (strval($this->extra_plan->CurrentValue) <> "") {
				$this->extra_plan->ViewValue = $this->extra_plan->optionCaption($this->extra_plan->CurrentValue);
			} else {
				$this->extra_plan->ViewValue = NULL;
			}
			$this->extra_plan->ViewCustomAttributes = "";

			// custom_size
			$this->custom_size->ViewValue = $this->custom_size->CurrentValue;
			$this->custom_size->ViewValue = FormatNumber($this->custom_size->ViewValue, 2, -2, -2, -2);
			$this->custom_size->ViewCustomAttributes = "";

			// custom_size_below_st
			$this->custom_size_below_st->ViewValue = $this->custom_size_below_st->CurrentValue;
			$this->custom_size_below_st->ViewValue = FormatNumber($this->custom_size_below_st->ViewValue, 2, -2, -2, -2);
			$this->custom_size_below_st->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// uploads
			$this->uploads->ViewValue = $this->uploads->CurrentValue;
			$this->uploads->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// plan_type
			$this->plan_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->plan_type->CurrentValue)) {
				$this->plan_type->HrefValue = "payment_planlist.php?x_plan_type=" . $this->plan_type->CurrentValue; // Add prefix/suffix
				$this->plan_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->plan_type->HrefValue = FullUrl($this->plan_type->HrefValue, "href");
			} else {
				$this->plan_type->HrefValue = "";
			}
			$this->plan_type->TooltipValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			if (!EmptyValue($this->location->CurrentValue)) {
				$this->location->HrefValue = "payment_planlist.php?x_location=" . $this->location->CurrentValue; // Add prefix/suffix
				$this->location->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->location->HrefValue = FullUrl($this->location->HrefValue, "href");
			} else {
				$this->location->HrefValue = "";
			}
			$this->location->TooltipValue = "";

			// from_date
			$this->from_date->LinkCustomAttributes = "";
			$this->from_date->HrefValue = "";
			$this->from_date->TooltipValue = "";

			// to_date
			$this->to_date->LinkCustomAttributes = "";
			$this->to_date->HrefValue = "";
			$this->to_date->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "payment_planlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}
			$this->process->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// selection
			$this->selection->LinkCustomAttributes = "";
			$this->selection->HrefValue = "";
			$this->selection->TooltipValue = "";

			// gcode
			$this->gcode->LinkCustomAttributes = "";
			if (!EmptyValue($this->gcode->CurrentValue)) {
				$this->gcode->HrefValue = "payment_planlist.php?x_gcode=" . $this->gcode->CurrentValue; // Add prefix/suffix
				$this->gcode->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->gcode->HrefValue = FullUrl($this->gcode->HrefValue, "href");
			} else {
				$this->gcode->HrefValue = "";
			}
			$this->gcode->TooltipValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->gcode->CurrentValue)) {
				$this->ref->HrefValue = "payment_planlist.php?x_ref=" . $this->gcode->CurrentValue; // Add prefix/suffix
				$this->ref->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->ref->HrefValue = FullUrl($this->ref->HrefValue, "href");
			} else {
				$this->ref->HrefValue = "";
			}
			$this->ref->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";
			$this->description->TooltipValue = "";

			// yes_no
			$this->yes_no->LinkCustomAttributes = "";
			$this->yes_no->HrefValue = "";
			$this->yes_no->TooltipValue = "";

			// packing_payment_type
			$this->packing_payment_type->LinkCustomAttributes = "";
			$this->packing_payment_type->HrefValue = "";
			$this->packing_payment_type->TooltipValue = "";

			// fix
			$this->fix->LinkCustomAttributes = "";
			$this->fix->HrefValue = "";
			$this->fix->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// sqm_method
			$this->sqm_method->LinkCustomAttributes = "";
			$this->sqm_method->HrefValue = "";
			$this->sqm_method->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// @_unit
			$this->_40_unit->LinkCustomAttributes = "";
			$this->_40_unit->HrefValue = "";
			$this->_40_unit->TooltipValue = "";

			// @
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";

			// extra_plan
			$this->extra_plan->LinkCustomAttributes = "";
			$this->extra_plan->HrefValue = "";
			$this->extra_plan->TooltipValue = "";

			// custom_size
			$this->custom_size->LinkCustomAttributes = "";
			$this->custom_size->HrefValue = "";
			$this->custom_size->TooltipValue = "";

			// custom_size_below_st
			$this->custom_size_below_st->LinkCustomAttributes = "";
			$this->custom_size_below_st->HrefValue = "";
			$this->custom_size_below_st->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->HrefValue = "";
			$this->uploads->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// plan_type
			$this->plan_type->EditAttrs["class"] = "form-control";
			$this->plan_type->EditCustomAttributes = "";
			$this->plan_type->EditValue = $this->plan_type->options(TRUE);

			// location
			$this->location->EditAttrs["class"] = "form-control";
			$this->location->EditCustomAttributes = "";
			$curVal = trim(strval($this->location->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->location->AdvancedSearch->ViewValue = $this->location->lookupCacheOption($curVal);
			else
				$this->location->AdvancedSearch->ViewValue = $this->location->Lookup !== NULL && is_array($this->location->Lookup->Options) ? $curVal : NULL;
			if ($this->location->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->location->EditValue = array_values($this->location->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` > 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->location->EditValue = $arwrk;
			}

			// from_date
			$this->from_date->EditAttrs["class"] = "form-control";
			$this->from_date->EditCustomAttributes = "";
			$this->from_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->from_date->AdvancedSearch->SearchValue, 0), 8));
			$this->from_date->PlaceHolder = RemoveHtml($this->from_date->caption());

			// to_date
			$this->to_date->EditAttrs["class"] = "form-control";
			$this->to_date->EditCustomAttributes = "";
			$this->to_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->to_date->AdvancedSearch->SearchValue, 0), 8));
			$this->to_date->PlaceHolder = RemoveHtml($this->to_date->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			$this->process->EditValue = HtmlEncode($this->process->AdvancedSearch->SearchValue);
			$this->process->PlaceHolder = RemoveHtml($this->process->caption());

			// product_type
			$this->product_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_type->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->product_type->AdvancedSearch->ViewValue = $this->product_type->lookupCacheOption($curVal);
			else
				$this->product_type->AdvancedSearch->ViewValue = $this->product_type->Lookup !== NULL && is_array($this->product_type->Lookup->Options) ? $curVal : NULL;
			if ($this->product_type->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->product_type->EditValue = array_values($this->product_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` !=9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_type->EditValue = $arwrk;
			}
			$this->product_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_type->AdvancedSearch->SearchValue2));
			if ($curVal <> "")
				$this->product_type->AdvancedSearch->ViewValue2 = $this->product_type->lookupCacheOption($curVal);
			else
				$this->product_type->AdvancedSearch->ViewValue2 = $this->product_type->Lookup !== NULL && is_array($this->product_type->Lookup->Options) ? $curVal : NULL;
			if ($this->product_type->AdvancedSearch->ViewValue2 !== NULL) { // Load from cache
				$this->product_type->EditValue2 = array_values($this->product_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` !=9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_type->EditValue2 = $arwrk;
			}

			// shape
			$this->shape->EditCustomAttributes = "";
			$curVal = trim(strval($this->shape->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->shape->AdvancedSearch->ViewValue = $this->shape->lookupCacheOption($curVal);
			else
				$this->shape->AdvancedSearch->ViewValue = $this->shape->Lookup !== NULL && is_array($this->shape->Lookup->Options) ? $curVal : NULL;
			if ($this->shape->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->shape->EditValue = array_values($this->shape->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1 and id < 100";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->shape->EditValue = $arwrk;
			}

			// selection
			$this->selection->EditAttrs["class"] = "form-control";
			$this->selection->EditCustomAttributes = "";
			$this->selection->EditValue = $this->selection->options(TRUE);

			// gcode
			$this->gcode->EditCustomAttributes = "";
			$curVal = trim(strval($this->gcode->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->gcode->AdvancedSearch->ViewValue = $this->gcode->lookupCacheOption($curVal);
			else
				$this->gcode->AdvancedSearch->ViewValue = $this->gcode->Lookup !== NULL && is_array($this->gcode->Lookup->Options) ? $curVal : NULL;
			if ($this->gcode->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->gcode->EditValue = array_values($this->gcode->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`gcode`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->gcode->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->gcode->EditValue = $arwrk;
			}

			// ref
			$this->ref->EditAttrs["class"] = "form-control";
			$this->ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->ref->AdvancedSearch->SearchValue = HtmlDecode($this->ref->AdvancedSearch->SearchValue);
			$this->ref->EditValue = HtmlEncode($this->ref->AdvancedSearch->SearchValue);
			$this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

			// description
			$this->description->EditAttrs["class"] = "form-control";
			$this->description->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description->AdvancedSearch->SearchValue = HtmlDecode($this->description->AdvancedSearch->SearchValue);
			$this->description->EditValue = HtmlEncode($this->description->AdvancedSearch->SearchValue);
			$this->description->PlaceHolder = RemoveHtml($this->description->caption());

			// yes_no
			$this->yes_no->EditAttrs["class"] = "form-control";
			$this->yes_no->EditCustomAttributes = "";
			$this->yes_no->EditValue = $this->yes_no->options(TRUE);

			// packing_payment_type
			$this->packing_payment_type->EditAttrs["class"] = "form-control";
			$this->packing_payment_type->EditCustomAttributes = "";
			$this->packing_payment_type->EditValue = $this->packing_payment_type->options(TRUE);

			// fix
			$this->fix->EditAttrs["class"] = "form-control";
			$this->fix->EditCustomAttributes = "";
			$this->fix->EditValue = $this->fix->options(TRUE);

			// method
			$this->method->EditAttrs["class"] = "form-control";
			$this->method->EditCustomAttributes = "";
			$curVal = trim(strval($this->method->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->method->AdvancedSearch->ViewValue = $this->method->lookupCacheOption($curVal);
			else
				$this->method->AdvancedSearch->ViewValue = $this->method->Lookup !== NULL && is_array($this->method->Lookup->Options) ? $curVal : NULL;
			if ($this->method->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->method->EditValue = array_values($this->method->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->method->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=11";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->method->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->method->EditValue = $arwrk;
			}

			// sqm_method
			$this->sqm_method->EditAttrs["class"] = "form-control";
			$this->sqm_method->EditCustomAttributes = "";
			$this->sqm_method->EditValue = $this->sqm_method->options(TRUE);

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";
			$this->unit->EditValue = $this->unit->options(TRUE);

			// @_unit
			$this->_40_unit->EditAttrs["class"] = "form-control";
			$this->_40_unit->EditCustomAttributes = "";
			$this->_40_unit->EditValue = HtmlEncode($this->_40_unit->AdvancedSearch->SearchValue);
			$this->_40_unit->PlaceHolder = RemoveHtml($this->_40_unit->caption());

			// @
			$this->_40->EditAttrs["class"] = "form-control";
			$this->_40->EditCustomAttributes = "";
			$this->_40->EditValue = HtmlEncode($this->_40->AdvancedSearch->SearchValue);
			$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

			// extra_plan
			$this->extra_plan->EditAttrs["class"] = "form-control";
			$this->extra_plan->EditCustomAttributes = "";
			$this->extra_plan->EditValue = $this->extra_plan->options(TRUE);

			// custom_size
			$this->custom_size->EditAttrs["class"] = "form-control";
			$this->custom_size->EditCustomAttributes = "";
			$this->custom_size->EditValue = HtmlEncode($this->custom_size->AdvancedSearch->SearchValue);
			$this->custom_size->PlaceHolder = RemoveHtml($this->custom_size->caption());

			// custom_size_below_st
			$this->custom_size_below_st->EditAttrs["class"] = "form-control";
			$this->custom_size_below_st->EditCustomAttributes = "";
			$this->custom_size_below_st->EditValue = HtmlEncode($this->custom_size_below_st->AdvancedSearch->SearchValue);
			$this->custom_size_below_st->PlaceHolder = RemoveHtml($this->custom_size_below_st->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			$this->uploads->EditValue = HtmlEncode($this->uploads->AdvancedSearch->SearchValue);
			$this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckDate($this->from_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->from_date->errorMessage());
		}
		if (!CheckDate($this->to_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->to_date->errorMessage());
		}
		if (!CheckNumber($this->_40_unit->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->_40_unit->errorMessage());
		}
		if (!CheckNumber($this->_40->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->_40->errorMessage());
		}
		if (!CheckNumber($this->custom_size->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->custom_size->errorMessage());
		}
		if (!CheckNumber($this->custom_size_below_st->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->custom_size_below_st->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->plan_type->AdvancedSearch->load();
		$this->location->AdvancedSearch->load();
		$this->from_date->AdvancedSearch->load();
		$this->to_date->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->process->AdvancedSearch->load();
		$this->product_type->AdvancedSearch->load();
		$this->shape->AdvancedSearch->load();
		$this->selection->AdvancedSearch->load();
		$this->gcode->AdvancedSearch->load();
		$this->ref->AdvancedSearch->load();
		$this->description->AdvancedSearch->load();
		$this->yes_no->AdvancedSearch->load();
		$this->packing_payment_type->AdvancedSearch->load();
		$this->fix->AdvancedSearch->load();
		$this->method->AdvancedSearch->load();
		$this->sqm_method->AdvancedSearch->load();
		$this->unit->AdvancedSearch->load();
		$this->_40_unit->AdvancedSearch->load();
		$this->_40->AdvancedSearch->load();
		$this->extra_plan->AdvancedSearch->load();
		$this->custom_size->AdvancedSearch->load();
		$this->custom_size_below_st->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->uploads->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("payment_planlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_location":
					$lookupFilter = function() {
						return "`status`=1 and `id` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`type`=1 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_type":
					$lookupFilter = function() {
						return "`status`=1 and `id` !=9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status`=1 and id < 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_gcode":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_method":
					$lookupFilter = function() {
						return "`grp`=11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_location":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_process":
							break;
						case "x_product_type":
							break;
						case "x_shape":
							break;
						case "x_gcode":
							break;
						case "x_ref":
							break;
						case "x_method":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>