<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for payment_response
 */
class payment_response extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $type;
	public $status;
	public $_userid;
	public $pg_order_number;
	public $remarks;
	public $cart_number;
	public $order_id;
	public $tracking_id;
	public $bank_ref_no;
	public $order_status;
	public $failure_message;
	public $payment_mode;
	public $card_name;
	public $status_code;
	public $status_message;
	public $amount;
	public $trans_date;
	public $datetime;
	public $payment_gateway;
	public $payment_signature;
	public $currency_id;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'payment_response';
		$this->TableName = 'payment_response';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`payment_response`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('payment_response', 'payment_response', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// type
		$this->type = new DbField('payment_response', 'payment_response', 'x_type', 'type', '`type`', '`type`', 17, -1, FALSE, '`type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->type->Nullable = FALSE; // NOT NULL field
		$this->type->Required = TRUE; // Required field
		$this->type->Sortable = TRUE; // Allow sort
		$this->type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['type'] = &$this->type;

		// status
		$this->status = new DbField('payment_response', 'payment_response', 'x_status', 'status', '`status`', '`status`', 16, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'payment_response', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 6;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// userid
		$this->_userid = new DbField('payment_response', 'payment_response', 'x__userid', 'userid', '`userid`', '`userid`', 18, -1, FALSE, '`userid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_userid->Nullable = FALSE; // NOT NULL field
		$this->_userid->Required = TRUE; // Required field
		$this->_userid->Sortable = TRUE; // Allow sort
		$this->_userid->Lookup = new Lookup('userid', 'buyer', FALSE, 'id', ["name","mobile","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->_userid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['userid'] = &$this->_userid;

		// pg_order_number
		$this->pg_order_number = new DbField('payment_response', 'payment_response', 'x_pg_order_number', 'pg_order_number', '`pg_order_number`', '`pg_order_number`', 200, -1, FALSE, '`pg_order_number`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pg_order_number->Nullable = FALSE; // NOT NULL field
		$this->pg_order_number->Required = TRUE; // Required field
		$this->pg_order_number->Sortable = TRUE; // Allow sort
		$this->fields['pg_order_number'] = &$this->pg_order_number;

		// remarks
		$this->remarks = new DbField('payment_response', 'payment_response', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks->Nullable = FALSE; // NOT NULL field
		$this->remarks->Required = TRUE; // Required field
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// cart_number
		$this->cart_number = new DbField('payment_response', 'payment_response', 'x_cart_number', 'cart_number', '`cart_number`', '`cart_number`', 19, -1, FALSE, '`cart_number`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cart_number->Nullable = FALSE; // NOT NULL field
		$this->cart_number->Required = TRUE; // Required field
		$this->cart_number->Sortable = TRUE; // Allow sort
		$this->cart_number->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['cart_number'] = &$this->cart_number;

		// order_id
		$this->order_id = new DbField('payment_response', 'payment_response', 'x_order_id', 'order_id', '`order_id`', '`order_id`', 18, -1, FALSE, '`order_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->order_id->Nullable = FALSE; // NOT NULL field
		$this->order_id->Required = TRUE; // Required field
		$this->order_id->Sortable = TRUE; // Allow sort
		$this->order_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['order_id'] = &$this->order_id;

		// tracking_id
		$this->tracking_id = new DbField('payment_response', 'payment_response', 'x_tracking_id', 'tracking_id', '`tracking_id`', '`tracking_id`', 200, -1, FALSE, '`tracking_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tracking_id->Nullable = FALSE; // NOT NULL field
		$this->tracking_id->Required = TRUE; // Required field
		$this->tracking_id->Sortable = TRUE; // Allow sort
		$this->fields['tracking_id'] = &$this->tracking_id;

		// bank_ref_no
		$this->bank_ref_no = new DbField('payment_response', 'payment_response', 'x_bank_ref_no', 'bank_ref_no', '`bank_ref_no`', '`bank_ref_no`', 200, -1, FALSE, '`bank_ref_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bank_ref_no->Nullable = FALSE; // NOT NULL field
		$this->bank_ref_no->Required = TRUE; // Required field
		$this->bank_ref_no->Sortable = TRUE; // Allow sort
		$this->fields['bank_ref_no'] = &$this->bank_ref_no;

		// order_status
		$this->order_status = new DbField('payment_response', 'payment_response', 'x_order_status', 'order_status', '`order_status`', '`order_status`', 200, -1, FALSE, '`order_status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->order_status->Nullable = FALSE; // NOT NULL field
		$this->order_status->Required = TRUE; // Required field
		$this->order_status->Sortable = TRUE; // Allow sort
		$this->fields['order_status'] = &$this->order_status;

		// failure_message
		$this->failure_message = new DbField('payment_response', 'payment_response', 'x_failure_message', 'failure_message', '`failure_message`', '`failure_message`', 200, -1, FALSE, '`failure_message`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->failure_message->Nullable = FALSE; // NOT NULL field
		$this->failure_message->Required = TRUE; // Required field
		$this->failure_message->Sortable = TRUE; // Allow sort
		$this->fields['failure_message'] = &$this->failure_message;

		// payment_mode
		$this->payment_mode = new DbField('payment_response', 'payment_response', 'x_payment_mode', 'payment_mode', '`payment_mode`', '`payment_mode`', 200, -1, FALSE, '`payment_mode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->payment_mode->Nullable = FALSE; // NOT NULL field
		$this->payment_mode->Required = TRUE; // Required field
		$this->payment_mode->Sortable = TRUE; // Allow sort
		$this->fields['payment_mode'] = &$this->payment_mode;

		// card_name
		$this->card_name = new DbField('payment_response', 'payment_response', 'x_card_name', 'card_name', '`card_name`', '`card_name`', 200, -1, FALSE, '`card_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->card_name->Nullable = FALSE; // NOT NULL field
		$this->card_name->Required = TRUE; // Required field
		$this->card_name->Sortable = TRUE; // Allow sort
		$this->fields['card_name'] = &$this->card_name;

		// status_code
		$this->status_code = new DbField('payment_response', 'payment_response', 'x_status_code', 'status_code', '`status_code`', '`status_code`', 200, -1, FALSE, '`status_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->status_code->Nullable = FALSE; // NOT NULL field
		$this->status_code->Required = TRUE; // Required field
		$this->status_code->Sortable = TRUE; // Allow sort
		$this->fields['status_code'] = &$this->status_code;

		// status_message
		$this->status_message = new DbField('payment_response', 'payment_response', 'x_status_message', 'status_message', '`status_message`', '`status_message`', 200, -1, FALSE, '`status_message`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->status_message->Nullable = FALSE; // NOT NULL field
		$this->status_message->Required = TRUE; // Required field
		$this->status_message->Sortable = TRUE; // Allow sort
		$this->fields['status_message'] = &$this->status_message;

		// amount
		$this->amount = new DbField('payment_response', 'payment_response', 'x_amount', 'amount', '`amount`', '`amount`', 5, -1, FALSE, '`amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount->Sortable = TRUE; // Allow sort
		$this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amount'] = &$this->amount;

		// trans_date
		$this->trans_date = new DbField('payment_response', 'payment_response', 'x_trans_date', 'trans_date', '`trans_date`', '`trans_date`', 200, -1, FALSE, '`trans_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->trans_date->Nullable = FALSE; // NOT NULL field
		$this->trans_date->Required = TRUE; // Required field
		$this->trans_date->Sortable = TRUE; // Allow sort
		$this->fields['trans_date'] = &$this->trans_date;

		// datetime
		$this->datetime = new DbField('payment_response', 'payment_response', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// payment_gateway
		$this->payment_gateway = new DbField('payment_response', 'payment_response', 'x_payment_gateway', 'payment_gateway', '`payment_gateway`', '`payment_gateway`', 200, -1, FALSE, '`payment_gateway`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->payment_gateway->Nullable = FALSE; // NOT NULL field
		$this->payment_gateway->Required = TRUE; // Required field
		$this->payment_gateway->Sortable = TRUE; // Allow sort
		$this->fields['payment_gateway'] = &$this->payment_gateway;

		// payment_signature
		$this->payment_signature = new DbField('payment_response', 'payment_response', 'x_payment_signature', 'payment_signature', '`payment_signature`', '`payment_signature`', 200, -1, FALSE, '`payment_signature`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->payment_signature->Nullable = FALSE; // NOT NULL field
		$this->payment_signature->Required = TRUE; // Required field
		$this->payment_signature->Sortable = TRUE; // Allow sort
		$this->fields['payment_signature'] = &$this->payment_signature;

		// currency_id
		$this->currency_id = new DbField('payment_response', 'payment_response', 'x_currency_id', 'currency_id', '`currency_id`', '`currency_id`', 19, -1, FALSE, '`currency_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->currency_id->Nullable = FALSE; // NOT NULL field
		$this->currency_id->Required = TRUE; // Required field
		$this->currency_id->Sortable = TRUE; // Allow sort
		$this->currency_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->currency_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->currency_id->Lookup = new Lookup('currency_id', 'currency', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->currency_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['currency_id'] = &$this->currency_id;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`payment_response`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->type->DbValue = $row['type'];
		$this->status->DbValue = $row['status'];
		$this->_userid->DbValue = $row['userid'];
		$this->pg_order_number->DbValue = $row['pg_order_number'];
		$this->remarks->DbValue = $row['remarks'];
		$this->cart_number->DbValue = $row['cart_number'];
		$this->order_id->DbValue = $row['order_id'];
		$this->tracking_id->DbValue = $row['tracking_id'];
		$this->bank_ref_no->DbValue = $row['bank_ref_no'];
		$this->order_status->DbValue = $row['order_status'];
		$this->failure_message->DbValue = $row['failure_message'];
		$this->payment_mode->DbValue = $row['payment_mode'];
		$this->card_name->DbValue = $row['card_name'];
		$this->status_code->DbValue = $row['status_code'];
		$this->status_message->DbValue = $row['status_message'];
		$this->amount->DbValue = $row['amount'];
		$this->trans_date->DbValue = $row['trans_date'];
		$this->datetime->DbValue = $row['datetime'];
		$this->payment_gateway->DbValue = $row['payment_gateway'];
		$this->payment_signature->DbValue = $row['payment_signature'];
		$this->currency_id->DbValue = $row['currency_id'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "payment_responselist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "payment_responseview.php")
			return $Language->phrase("View");
		elseif ($pageName == "payment_responseedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "payment_responseadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "payment_responselist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("payment_responseview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("payment_responseview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "payment_responseadd.php?" . $this->getUrlParm($parm);
		else
			$url = "payment_responseadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("payment_responseedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("payment_responseadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("payment_responsedelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->type->setDbValue($rs->fields('type'));
		$this->status->setDbValue($rs->fields('status'));
		$this->_userid->setDbValue($rs->fields('userid'));
		$this->pg_order_number->setDbValue($rs->fields('pg_order_number'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->cart_number->setDbValue($rs->fields('cart_number'));
		$this->order_id->setDbValue($rs->fields('order_id'));
		$this->tracking_id->setDbValue($rs->fields('tracking_id'));
		$this->bank_ref_no->setDbValue($rs->fields('bank_ref_no'));
		$this->order_status->setDbValue($rs->fields('order_status'));
		$this->failure_message->setDbValue($rs->fields('failure_message'));
		$this->payment_mode->setDbValue($rs->fields('payment_mode'));
		$this->card_name->setDbValue($rs->fields('card_name'));
		$this->status_code->setDbValue($rs->fields('status_code'));
		$this->status_message->setDbValue($rs->fields('status_message'));
		$this->amount->setDbValue($rs->fields('amount'));
		$this->trans_date->setDbValue($rs->fields('trans_date'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->payment_gateway->setDbValue($rs->fields('payment_gateway'));
		$this->payment_signature->setDbValue($rs->fields('payment_signature'));
		$this->currency_id->setDbValue($rs->fields('currency_id'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// type
		// status
		// userid
		// pg_order_number
		// remarks
		// cart_number
		// order_id
		// tracking_id
		// bank_ref_no
		// order_status
		// failure_message
		// payment_mode
		// card_name
		// status_code
		// status_message
		// amount
		// trans_date
		// datetime
		// payment_gateway
		// payment_signature
		// currency_id
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// type
		$this->type->ViewValue = $this->type->CurrentValue;
		$this->type->ViewValue = FormatNumber($this->type->ViewValue, 0, -2, -2, -2);
		$this->type->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// userid
		$this->_userid->ViewValue = $this->_userid->CurrentValue;
		$curVal = strval($this->_userid->CurrentValue);
		if ($curVal <> "") {
			$this->_userid->ViewValue = $this->_userid->lookupCacheOption($curVal);
			if ($this->_userid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->_userid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->_userid->ViewValue = $this->_userid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->_userid->ViewValue = $this->_userid->CurrentValue;
				}
			}
		} else {
			$this->_userid->ViewValue = NULL;
		}
		$this->_userid->ViewCustomAttributes = "";

		// pg_order_number
		$this->pg_order_number->ViewValue = $this->pg_order_number->CurrentValue;
		$this->pg_order_number->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// cart_number
		$this->cart_number->ViewValue = $this->cart_number->CurrentValue;
		$this->cart_number->ViewValue = FormatNumber($this->cart_number->ViewValue, 0, -2, -2, -2);
		$this->cart_number->ViewCustomAttributes = "";

		// order_id
		$this->order_id->ViewValue = $this->order_id->CurrentValue;
		$this->order_id->ViewValue = FormatNumber($this->order_id->ViewValue, 0, -2, -2, -2);
		$this->order_id->ViewCustomAttributes = "";

		// tracking_id
		$this->tracking_id->ViewValue = $this->tracking_id->CurrentValue;
		$this->tracking_id->ViewCustomAttributes = "";

		// bank_ref_no
		$this->bank_ref_no->ViewValue = $this->bank_ref_no->CurrentValue;
		$this->bank_ref_no->ViewCustomAttributes = "";

		// order_status
		$this->order_status->ViewValue = $this->order_status->CurrentValue;
		$this->order_status->ViewCustomAttributes = "";

		// failure_message
		$this->failure_message->ViewValue = $this->failure_message->CurrentValue;
		$this->failure_message->ViewCustomAttributes = "";

		// payment_mode
		$this->payment_mode->ViewValue = $this->payment_mode->CurrentValue;
		$this->payment_mode->ViewCustomAttributes = "";

		// card_name
		$this->card_name->ViewValue = $this->card_name->CurrentValue;
		$this->card_name->ViewCustomAttributes = "";

		// status_code
		$this->status_code->ViewValue = $this->status_code->CurrentValue;
		$this->status_code->ViewCustomAttributes = "";

		// status_message
		$this->status_message->ViewValue = $this->status_message->CurrentValue;
		$this->status_message->ViewCustomAttributes = "";

		// amount
		$this->amount->ViewValue = $this->amount->CurrentValue;
		$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
		$this->amount->ViewCustomAttributes = "";

		// trans_date
		$this->trans_date->ViewValue = $this->trans_date->CurrentValue;
		$this->trans_date->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// payment_gateway
		$this->payment_gateway->ViewValue = $this->payment_gateway->CurrentValue;
		$this->payment_gateway->ViewCustomAttributes = "";

		// payment_signature
		$this->payment_signature->ViewValue = $this->payment_signature->CurrentValue;
		$this->payment_signature->ViewCustomAttributes = "";

		// currency_id
		$curVal = strval($this->currency_id->CurrentValue);
		if ($curVal <> "") {
			$this->currency_id->ViewValue = $this->currency_id->lookupCacheOption($curVal);
			if ($this->currency_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->currency_id->ViewValue = $this->currency_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->currency_id->ViewValue = $this->currency_id->CurrentValue;
				}
			}
		} else {
			$this->currency_id->ViewValue = NULL;
		}
		$this->currency_id->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// type
		$this->type->LinkCustomAttributes = "";
		if (!EmptyValue($this->type->CurrentValue)) {
			$this->type->HrefValue = "payment_responselist.php?x_type=" . ((!empty($this->type->ViewValue) && !is_array($this->type->ViewValue)) ? RemoveHtml($this->type->ViewValue) : $this->type->CurrentValue); // Add prefix/suffix
			$this->type->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->type->HrefValue = FullUrl($this->type->HrefValue, "href");
		} else {
			$this->type->HrefValue = "";
		}
		$this->type->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		if (!EmptyValue($this->status->CurrentValue)) {
			$this->status->HrefValue = "payment_responselist.php?x_status=" . $this->status->CurrentValue; // Add prefix/suffix
			$this->status->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
		} else {
			$this->status->HrefValue = "";
		}
		$this->status->TooltipValue = "";

		// userid
		$this->_userid->LinkCustomAttributes = "";
		if (!EmptyValue($this->_userid->CurrentValue)) {
			$this->_userid->HrefValue = "payment_responselist.php?x__userid=" . $this->_userid->CurrentValue; // Add prefix/suffix
			$this->_userid->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->_userid->HrefValue = FullUrl($this->_userid->HrefValue, "href");
		} else {
			$this->_userid->HrefValue = "";
		}
		$this->_userid->TooltipValue = "";

		// pg_order_number
		$this->pg_order_number->LinkCustomAttributes = "";
		$this->pg_order_number->HrefValue = "";
		$this->pg_order_number->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// cart_number
		$this->cart_number->LinkCustomAttributes = "";
		$this->cart_number->HrefValue = "";
		$this->cart_number->TooltipValue = "";

		// order_id
		$this->order_id->LinkCustomAttributes = "";
		$this->order_id->HrefValue = "";
		$this->order_id->TooltipValue = "";

		// tracking_id
		$this->tracking_id->LinkCustomAttributes = "";
		$this->tracking_id->HrefValue = "";
		$this->tracking_id->TooltipValue = "";

		// bank_ref_no
		$this->bank_ref_no->LinkCustomAttributes = "";
		$this->bank_ref_no->HrefValue = "";
		$this->bank_ref_no->TooltipValue = "";

		// order_status
		$this->order_status->LinkCustomAttributes = "";
		$this->order_status->HrefValue = "";
		$this->order_status->TooltipValue = "";

		// failure_message
		$this->failure_message->LinkCustomAttributes = "";
		$this->failure_message->HrefValue = "";
		$this->failure_message->TooltipValue = "";

		// payment_mode
		$this->payment_mode->LinkCustomAttributes = "";
		$this->payment_mode->HrefValue = "";
		$this->payment_mode->TooltipValue = "";

		// card_name
		$this->card_name->LinkCustomAttributes = "";
		$this->card_name->HrefValue = "";
		$this->card_name->TooltipValue = "";

		// status_code
		$this->status_code->LinkCustomAttributes = "";
		$this->status_code->HrefValue = "";
		$this->status_code->TooltipValue = "";

		// status_message
		$this->status_message->LinkCustomAttributes = "";
		$this->status_message->HrefValue = "";
		$this->status_message->TooltipValue = "";

		// amount
		$this->amount->LinkCustomAttributes = "";
		$this->amount->HrefValue = "";
		$this->amount->TooltipValue = "";

		// trans_date
		$this->trans_date->LinkCustomAttributes = "";
		$this->trans_date->HrefValue = "";
		$this->trans_date->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// payment_gateway
		$this->payment_gateway->LinkCustomAttributes = "";
		$this->payment_gateway->HrefValue = "";
		$this->payment_gateway->TooltipValue = "";

		// payment_signature
		$this->payment_signature->LinkCustomAttributes = "";
		$this->payment_signature->HrefValue = "";
		$this->payment_signature->TooltipValue = "";

		// currency_id
		$this->currency_id->LinkCustomAttributes = "";
		$this->currency_id->HrefValue = "";
		$this->currency_id->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// type
		$this->type->EditAttrs["class"] = "form-control";
		$this->type->EditCustomAttributes = "";
		$this->type->EditValue = $this->type->CurrentValue;
		$this->type->PlaceHolder = RemoveHtml($this->type->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// userid
		$this->_userid->EditAttrs["class"] = "form-control";
		$this->_userid->EditCustomAttributes = "";
		$this->_userid->EditValue = $this->_userid->CurrentValue;
		$this->_userid->PlaceHolder = RemoveHtml($this->_userid->caption());

		// pg_order_number
		$this->pg_order_number->EditAttrs["class"] = "form-control";
		$this->pg_order_number->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pg_order_number->CurrentValue = HtmlDecode($this->pg_order_number->CurrentValue);
		$this->pg_order_number->EditValue = $this->pg_order_number->CurrentValue;
		$this->pg_order_number->PlaceHolder = RemoveHtml($this->pg_order_number->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// cart_number
		$this->cart_number->EditAttrs["class"] = "form-control";
		$this->cart_number->EditCustomAttributes = "";
		$this->cart_number->EditValue = $this->cart_number->CurrentValue;
		$this->cart_number->PlaceHolder = RemoveHtml($this->cart_number->caption());

		// order_id
		$this->order_id->EditAttrs["class"] = "form-control";
		$this->order_id->EditCustomAttributes = "";
		$this->order_id->EditValue = $this->order_id->CurrentValue;
		$this->order_id->PlaceHolder = RemoveHtml($this->order_id->caption());

		// tracking_id
		$this->tracking_id->EditAttrs["class"] = "form-control";
		$this->tracking_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->tracking_id->CurrentValue = HtmlDecode($this->tracking_id->CurrentValue);
		$this->tracking_id->EditValue = $this->tracking_id->CurrentValue;
		$this->tracking_id->PlaceHolder = RemoveHtml($this->tracking_id->caption());

		// bank_ref_no
		$this->bank_ref_no->EditAttrs["class"] = "form-control";
		$this->bank_ref_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->bank_ref_no->CurrentValue = HtmlDecode($this->bank_ref_no->CurrentValue);
		$this->bank_ref_no->EditValue = $this->bank_ref_no->CurrentValue;
		$this->bank_ref_no->PlaceHolder = RemoveHtml($this->bank_ref_no->caption());

		// order_status
		$this->order_status->EditAttrs["class"] = "form-control";
		$this->order_status->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->order_status->CurrentValue = HtmlDecode($this->order_status->CurrentValue);
		$this->order_status->EditValue = $this->order_status->CurrentValue;
		$this->order_status->PlaceHolder = RemoveHtml($this->order_status->caption());

		// failure_message
		$this->failure_message->EditAttrs["class"] = "form-control";
		$this->failure_message->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->failure_message->CurrentValue = HtmlDecode($this->failure_message->CurrentValue);
		$this->failure_message->EditValue = $this->failure_message->CurrentValue;
		$this->failure_message->PlaceHolder = RemoveHtml($this->failure_message->caption());

		// payment_mode
		$this->payment_mode->EditAttrs["class"] = "form-control";
		$this->payment_mode->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->payment_mode->CurrentValue = HtmlDecode($this->payment_mode->CurrentValue);
		$this->payment_mode->EditValue = $this->payment_mode->CurrentValue;
		$this->payment_mode->PlaceHolder = RemoveHtml($this->payment_mode->caption());

		// card_name
		$this->card_name->EditAttrs["class"] = "form-control";
		$this->card_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->card_name->CurrentValue = HtmlDecode($this->card_name->CurrentValue);
		$this->card_name->EditValue = $this->card_name->CurrentValue;
		$this->card_name->PlaceHolder = RemoveHtml($this->card_name->caption());

		// status_code
		$this->status_code->EditAttrs["class"] = "form-control";
		$this->status_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->status_code->CurrentValue = HtmlDecode($this->status_code->CurrentValue);
		$this->status_code->EditValue = $this->status_code->CurrentValue;
		$this->status_code->PlaceHolder = RemoveHtml($this->status_code->caption());

		// status_message
		$this->status_message->EditAttrs["class"] = "form-control";
		$this->status_message->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->status_message->CurrentValue = HtmlDecode($this->status_message->CurrentValue);
		$this->status_message->EditValue = $this->status_message->CurrentValue;
		$this->status_message->PlaceHolder = RemoveHtml($this->status_message->caption());

		// amount
		$this->amount->EditAttrs["class"] = "form-control";
		$this->amount->EditCustomAttributes = "";
		$this->amount->EditValue = $this->amount->CurrentValue;
		$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
		if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue))
			$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, -2);

		// trans_date
		$this->trans_date->EditAttrs["class"] = "form-control";
		$this->trans_date->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->trans_date->CurrentValue = HtmlDecode($this->trans_date->CurrentValue);
		$this->trans_date->EditValue = $this->trans_date->CurrentValue;
		$this->trans_date->PlaceHolder = RemoveHtml($this->trans_date->caption());

		// datetime
		// payment_gateway

		$this->payment_gateway->EditAttrs["class"] = "form-control";
		$this->payment_gateway->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->payment_gateway->CurrentValue = HtmlDecode($this->payment_gateway->CurrentValue);
		$this->payment_gateway->EditValue = $this->payment_gateway->CurrentValue;
		$this->payment_gateway->PlaceHolder = RemoveHtml($this->payment_gateway->caption());

		// payment_signature
		$this->payment_signature->EditAttrs["class"] = "form-control";
		$this->payment_signature->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->payment_signature->CurrentValue = HtmlDecode($this->payment_signature->CurrentValue);
		$this->payment_signature->EditValue = $this->payment_signature->CurrentValue;
		$this->payment_signature->PlaceHolder = RemoveHtml($this->payment_signature->caption());

		// currency_id
		$this->currency_id->EditAttrs["class"] = "form-control";
		$this->currency_id->EditCustomAttributes = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->type);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->_userid);
					$doc->exportCaption($this->pg_order_number);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->cart_number);
					$doc->exportCaption($this->order_id);
					$doc->exportCaption($this->tracking_id);
					$doc->exportCaption($this->bank_ref_no);
					$doc->exportCaption($this->order_status);
					$doc->exportCaption($this->failure_message);
					$doc->exportCaption($this->payment_mode);
					$doc->exportCaption($this->card_name);
					$doc->exportCaption($this->status_code);
					$doc->exportCaption($this->status_message);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->trans_date);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->payment_gateway);
					$doc->exportCaption($this->payment_signature);
					$doc->exportCaption($this->currency_id);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->type);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->_userid);
					$doc->exportCaption($this->pg_order_number);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->cart_number);
					$doc->exportCaption($this->order_id);
					$doc->exportCaption($this->tracking_id);
					$doc->exportCaption($this->bank_ref_no);
					$doc->exportCaption($this->order_status);
					$doc->exportCaption($this->failure_message);
					$doc->exportCaption($this->payment_mode);
					$doc->exportCaption($this->card_name);
					$doc->exportCaption($this->status_code);
					$doc->exportCaption($this->status_message);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->trans_date);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->payment_gateway);
					$doc->exportCaption($this->payment_signature);
					$doc->exportCaption($this->currency_id);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->type);
						$doc->exportField($this->status);
						$doc->exportField($this->_userid);
						$doc->exportField($this->pg_order_number);
						$doc->exportField($this->remarks);
						$doc->exportField($this->cart_number);
						$doc->exportField($this->order_id);
						$doc->exportField($this->tracking_id);
						$doc->exportField($this->bank_ref_no);
						$doc->exportField($this->order_status);
						$doc->exportField($this->failure_message);
						$doc->exportField($this->payment_mode);
						$doc->exportField($this->card_name);
						$doc->exportField($this->status_code);
						$doc->exportField($this->status_message);
						$doc->exportField($this->amount);
						$doc->exportField($this->trans_date);
						$doc->exportField($this->datetime);
						$doc->exportField($this->payment_gateway);
						$doc->exportField($this->payment_signature);
						$doc->exportField($this->currency_id);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->type);
						$doc->exportField($this->status);
						$doc->exportField($this->_userid);
						$doc->exportField($this->pg_order_number);
						$doc->exportField($this->remarks);
						$doc->exportField($this->cart_number);
						$doc->exportField($this->order_id);
						$doc->exportField($this->tracking_id);
						$doc->exportField($this->bank_ref_no);
						$doc->exportField($this->order_status);
						$doc->exportField($this->failure_message);
						$doc->exportField($this->payment_mode);
						$doc->exportField($this->card_name);
						$doc->exportField($this->status_code);
						$doc->exportField($this->status_message);
						$doc->exportField($this->amount);
						$doc->exportField($this->trans_date);
						$doc->exportField($this->datetime);
						$doc->exportField($this->payment_gateway);
						$doc->exportField($this->payment_signature);
						$doc->exportField($this->currency_id);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>