<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class payment_response_add extends payment_response
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'payment_response';

	// Page object name
	public $PageObjName = "payment_response_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (payment_response)
		if (!isset($GLOBALS["payment_response"]) || get_class($GLOBALS["payment_response"]) == PROJECT_NAMESPACE . "payment_response") {
			$GLOBALS["payment_response"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["payment_response"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'payment_response');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $payment_response;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($payment_response);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "payment_responseview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("payment_responselist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->type->setVisibility();
		$this->status->setVisibility();
		$this->_userid->setVisibility();
		$this->pg_order_number->setVisibility();
		$this->remarks->setVisibility();
		$this->cart_number->setVisibility();
		$this->order_id->setVisibility();
		$this->tracking_id->setVisibility();
		$this->bank_ref_no->setVisibility();
		$this->order_status->setVisibility();
		$this->failure_message->setVisibility();
		$this->payment_mode->setVisibility();
		$this->card_name->setVisibility();
		$this->status_code->setVisibility();
		$this->status_message->setVisibility();
		$this->amount->setVisibility();
		$this->trans_date->setVisibility();
		$this->datetime->setVisibility();
		$this->payment_gateway->setVisibility();
		$this->payment_signature->setVisibility();
		$this->currency_id->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->_userid);
		$this->setupLookupOptions($this->currency_id);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("payment_responselist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "payment_responselist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "payment_responseview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->type->CurrentValue = NULL;
		$this->type->OldValue = $this->type->CurrentValue;
		$this->status->CurrentValue = 0;
		$this->_userid->CurrentValue = NULL;
		$this->_userid->OldValue = $this->_userid->CurrentValue;
		$this->pg_order_number->CurrentValue = NULL;
		$this->pg_order_number->OldValue = $this->pg_order_number->CurrentValue;
		$this->remarks->CurrentValue = NULL;
		$this->remarks->OldValue = $this->remarks->CurrentValue;
		$this->cart_number->CurrentValue = NULL;
		$this->cart_number->OldValue = $this->cart_number->CurrentValue;
		$this->order_id->CurrentValue = NULL;
		$this->order_id->OldValue = $this->order_id->CurrentValue;
		$this->tracking_id->CurrentValue = NULL;
		$this->tracking_id->OldValue = $this->tracking_id->CurrentValue;
		$this->bank_ref_no->CurrentValue = NULL;
		$this->bank_ref_no->OldValue = $this->bank_ref_no->CurrentValue;
		$this->order_status->CurrentValue = NULL;
		$this->order_status->OldValue = $this->order_status->CurrentValue;
		$this->failure_message->CurrentValue = NULL;
		$this->failure_message->OldValue = $this->failure_message->CurrentValue;
		$this->payment_mode->CurrentValue = NULL;
		$this->payment_mode->OldValue = $this->payment_mode->CurrentValue;
		$this->card_name->CurrentValue = NULL;
		$this->card_name->OldValue = $this->card_name->CurrentValue;
		$this->status_code->CurrentValue = NULL;
		$this->status_code->OldValue = $this->status_code->CurrentValue;
		$this->status_message->CurrentValue = NULL;
		$this->status_message->OldValue = $this->status_message->CurrentValue;
		$this->amount->CurrentValue = NULL;
		$this->amount->OldValue = $this->amount->CurrentValue;
		$this->trans_date->CurrentValue = NULL;
		$this->trans_date->OldValue = $this->trans_date->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->payment_gateway->CurrentValue = NULL;
		$this->payment_gateway->OldValue = $this->payment_gateway->CurrentValue;
		$this->payment_signature->CurrentValue = NULL;
		$this->payment_signature->OldValue = $this->payment_signature->CurrentValue;
		$this->currency_id->CurrentValue = NULL;
		$this->currency_id->OldValue = $this->currency_id->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'type' first before field var 'x_type'
		$val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
		if (!$this->type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->type->Visible = FALSE; // Disable update for API request
			else
				$this->type->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'userid' first before field var 'x__userid'
		$val = $CurrentForm->hasValue("userid") ? $CurrentForm->getValue("userid") : $CurrentForm->getValue("x__userid");
		if (!$this->_userid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_userid->Visible = FALSE; // Disable update for API request
			else
				$this->_userid->setFormValue($val);
		}

		// Check field name 'pg_order_number' first before field var 'x_pg_order_number'
		$val = $CurrentForm->hasValue("pg_order_number") ? $CurrentForm->getValue("pg_order_number") : $CurrentForm->getValue("x_pg_order_number");
		if (!$this->pg_order_number->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pg_order_number->Visible = FALSE; // Disable update for API request
			else
				$this->pg_order_number->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'cart_number' first before field var 'x_cart_number'
		$val = $CurrentForm->hasValue("cart_number") ? $CurrentForm->getValue("cart_number") : $CurrentForm->getValue("x_cart_number");
		if (!$this->cart_number->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cart_number->Visible = FALSE; // Disable update for API request
			else
				$this->cart_number->setFormValue($val);
		}

		// Check field name 'order_id' first before field var 'x_order_id'
		$val = $CurrentForm->hasValue("order_id") ? $CurrentForm->getValue("order_id") : $CurrentForm->getValue("x_order_id");
		if (!$this->order_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->order_id->Visible = FALSE; // Disable update for API request
			else
				$this->order_id->setFormValue($val);
		}

		// Check field name 'tracking_id' first before field var 'x_tracking_id'
		$val = $CurrentForm->hasValue("tracking_id") ? $CurrentForm->getValue("tracking_id") : $CurrentForm->getValue("x_tracking_id");
		if (!$this->tracking_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tracking_id->Visible = FALSE; // Disable update for API request
			else
				$this->tracking_id->setFormValue($val);
		}

		// Check field name 'bank_ref_no' first before field var 'x_bank_ref_no'
		$val = $CurrentForm->hasValue("bank_ref_no") ? $CurrentForm->getValue("bank_ref_no") : $CurrentForm->getValue("x_bank_ref_no");
		if (!$this->bank_ref_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bank_ref_no->Visible = FALSE; // Disable update for API request
			else
				$this->bank_ref_no->setFormValue($val);
		}

		// Check field name 'order_status' first before field var 'x_order_status'
		$val = $CurrentForm->hasValue("order_status") ? $CurrentForm->getValue("order_status") : $CurrentForm->getValue("x_order_status");
		if (!$this->order_status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->order_status->Visible = FALSE; // Disable update for API request
			else
				$this->order_status->setFormValue($val);
		}

		// Check field name 'failure_message' first before field var 'x_failure_message'
		$val = $CurrentForm->hasValue("failure_message") ? $CurrentForm->getValue("failure_message") : $CurrentForm->getValue("x_failure_message");
		if (!$this->failure_message->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->failure_message->Visible = FALSE; // Disable update for API request
			else
				$this->failure_message->setFormValue($val);
		}

		// Check field name 'payment_mode' first before field var 'x_payment_mode'
		$val = $CurrentForm->hasValue("payment_mode") ? $CurrentForm->getValue("payment_mode") : $CurrentForm->getValue("x_payment_mode");
		if (!$this->payment_mode->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->payment_mode->Visible = FALSE; // Disable update for API request
			else
				$this->payment_mode->setFormValue($val);
		}

		// Check field name 'card_name' first before field var 'x_card_name'
		$val = $CurrentForm->hasValue("card_name") ? $CurrentForm->getValue("card_name") : $CurrentForm->getValue("x_card_name");
		if (!$this->card_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->card_name->Visible = FALSE; // Disable update for API request
			else
				$this->card_name->setFormValue($val);
		}

		// Check field name 'status_code' first before field var 'x_status_code'
		$val = $CurrentForm->hasValue("status_code") ? $CurrentForm->getValue("status_code") : $CurrentForm->getValue("x_status_code");
		if (!$this->status_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status_code->Visible = FALSE; // Disable update for API request
			else
				$this->status_code->setFormValue($val);
		}

		// Check field name 'status_message' first before field var 'x_status_message'
		$val = $CurrentForm->hasValue("status_message") ? $CurrentForm->getValue("status_message") : $CurrentForm->getValue("x_status_message");
		if (!$this->status_message->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status_message->Visible = FALSE; // Disable update for API request
			else
				$this->status_message->setFormValue($val);
		}

		// Check field name 'amount' first before field var 'x_amount'
		$val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
		if (!$this->amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->amount->Visible = FALSE; // Disable update for API request
			else
				$this->amount->setFormValue($val);
		}

		// Check field name 'trans_date' first before field var 'x_trans_date'
		$val = $CurrentForm->hasValue("trans_date") ? $CurrentForm->getValue("trans_date") : $CurrentForm->getValue("x_trans_date");
		if (!$this->trans_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->trans_date->Visible = FALSE; // Disable update for API request
			else
				$this->trans_date->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'payment_gateway' first before field var 'x_payment_gateway'
		$val = $CurrentForm->hasValue("payment_gateway") ? $CurrentForm->getValue("payment_gateway") : $CurrentForm->getValue("x_payment_gateway");
		if (!$this->payment_gateway->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->payment_gateway->Visible = FALSE; // Disable update for API request
			else
				$this->payment_gateway->setFormValue($val);
		}

		// Check field name 'payment_signature' first before field var 'x_payment_signature'
		$val = $CurrentForm->hasValue("payment_signature") ? $CurrentForm->getValue("payment_signature") : $CurrentForm->getValue("x_payment_signature");
		if (!$this->payment_signature->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->payment_signature->Visible = FALSE; // Disable update for API request
			else
				$this->payment_signature->setFormValue($val);
		}

		// Check field name 'currency_id' first before field var 'x_currency_id'
		$val = $CurrentForm->hasValue("currency_id") ? $CurrentForm->getValue("currency_id") : $CurrentForm->getValue("x_currency_id");
		if (!$this->currency_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->currency_id->Visible = FALSE; // Disable update for API request
			else
				$this->currency_id->setFormValue($val);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->type->CurrentValue = $this->type->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->_userid->CurrentValue = $this->_userid->FormValue;
		$this->pg_order_number->CurrentValue = $this->pg_order_number->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->cart_number->CurrentValue = $this->cart_number->FormValue;
		$this->order_id->CurrentValue = $this->order_id->FormValue;
		$this->tracking_id->CurrentValue = $this->tracking_id->FormValue;
		$this->bank_ref_no->CurrentValue = $this->bank_ref_no->FormValue;
		$this->order_status->CurrentValue = $this->order_status->FormValue;
		$this->failure_message->CurrentValue = $this->failure_message->FormValue;
		$this->payment_mode->CurrentValue = $this->payment_mode->FormValue;
		$this->card_name->CurrentValue = $this->card_name->FormValue;
		$this->status_code->CurrentValue = $this->status_code->FormValue;
		$this->status_message->CurrentValue = $this->status_message->FormValue;
		$this->amount->CurrentValue = $this->amount->FormValue;
		$this->trans_date->CurrentValue = $this->trans_date->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->payment_gateway->CurrentValue = $this->payment_gateway->FormValue;
		$this->payment_signature->CurrentValue = $this->payment_signature->FormValue;
		$this->currency_id->CurrentValue = $this->currency_id->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->type->setDbValue($row['type']);
		$this->status->setDbValue($row['status']);
		$this->_userid->setDbValue($row['userid']);
		$this->pg_order_number->setDbValue($row['pg_order_number']);
		$this->remarks->setDbValue($row['remarks']);
		$this->cart_number->setDbValue($row['cart_number']);
		$this->order_id->setDbValue($row['order_id']);
		$this->tracking_id->setDbValue($row['tracking_id']);
		$this->bank_ref_no->setDbValue($row['bank_ref_no']);
		$this->order_status->setDbValue($row['order_status']);
		$this->failure_message->setDbValue($row['failure_message']);
		$this->payment_mode->setDbValue($row['payment_mode']);
		$this->card_name->setDbValue($row['card_name']);
		$this->status_code->setDbValue($row['status_code']);
		$this->status_message->setDbValue($row['status_message']);
		$this->amount->setDbValue($row['amount']);
		$this->trans_date->setDbValue($row['trans_date']);
		$this->datetime->setDbValue($row['datetime']);
		$this->payment_gateway->setDbValue($row['payment_gateway']);
		$this->payment_signature->setDbValue($row['payment_signature']);
		$this->currency_id->setDbValue($row['currency_id']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['type'] = $this->type->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['userid'] = $this->_userid->CurrentValue;
		$row['pg_order_number'] = $this->pg_order_number->CurrentValue;
		$row['remarks'] = $this->remarks->CurrentValue;
		$row['cart_number'] = $this->cart_number->CurrentValue;
		$row['order_id'] = $this->order_id->CurrentValue;
		$row['tracking_id'] = $this->tracking_id->CurrentValue;
		$row['bank_ref_no'] = $this->bank_ref_no->CurrentValue;
		$row['order_status'] = $this->order_status->CurrentValue;
		$row['failure_message'] = $this->failure_message->CurrentValue;
		$row['payment_mode'] = $this->payment_mode->CurrentValue;
		$row['card_name'] = $this->card_name->CurrentValue;
		$row['status_code'] = $this->status_code->CurrentValue;
		$row['status_message'] = $this->status_message->CurrentValue;
		$row['amount'] = $this->amount->CurrentValue;
		$row['trans_date'] = $this->trans_date->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['payment_gateway'] = $this->payment_gateway->CurrentValue;
		$row['payment_signature'] = $this->payment_signature->CurrentValue;
		$row['currency_id'] = $this->currency_id->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// type
		// status
		// userid
		// pg_order_number
		// remarks
		// cart_number
		// order_id
		// tracking_id
		// bank_ref_no
		// order_status
		// failure_message
		// payment_mode
		// card_name
		// status_code
		// status_message
		// amount
		// trans_date
		// datetime
		// payment_gateway
		// payment_signature
		// currency_id

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// type
			$this->type->ViewValue = $this->type->CurrentValue;
			$this->type->ViewValue = FormatNumber($this->type->ViewValue, 0, -2, -2, -2);
			$this->type->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// userid
			$this->_userid->ViewValue = $this->_userid->CurrentValue;
			$curVal = strval($this->_userid->CurrentValue);
			if ($curVal <> "") {
				$this->_userid->ViewValue = $this->_userid->lookupCacheOption($curVal);
				if ($this->_userid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->_userid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->_userid->ViewValue = $this->_userid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_userid->ViewValue = $this->_userid->CurrentValue;
					}
				}
			} else {
				$this->_userid->ViewValue = NULL;
			}
			$this->_userid->ViewCustomAttributes = "";

			// pg_order_number
			$this->pg_order_number->ViewValue = $this->pg_order_number->CurrentValue;
			$this->pg_order_number->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// cart_number
			$this->cart_number->ViewValue = $this->cart_number->CurrentValue;
			$this->cart_number->ViewValue = FormatNumber($this->cart_number->ViewValue, 0, -2, -2, -2);
			$this->cart_number->ViewCustomAttributes = "";

			// order_id
			$this->order_id->ViewValue = $this->order_id->CurrentValue;
			$this->order_id->ViewValue = FormatNumber($this->order_id->ViewValue, 0, -2, -2, -2);
			$this->order_id->ViewCustomAttributes = "";

			// tracking_id
			$this->tracking_id->ViewValue = $this->tracking_id->CurrentValue;
			$this->tracking_id->ViewCustomAttributes = "";

			// bank_ref_no
			$this->bank_ref_no->ViewValue = $this->bank_ref_no->CurrentValue;
			$this->bank_ref_no->ViewCustomAttributes = "";

			// order_status
			$this->order_status->ViewValue = $this->order_status->CurrentValue;
			$this->order_status->ViewCustomAttributes = "";

			// failure_message
			$this->failure_message->ViewValue = $this->failure_message->CurrentValue;
			$this->failure_message->ViewCustomAttributes = "";

			// payment_mode
			$this->payment_mode->ViewValue = $this->payment_mode->CurrentValue;
			$this->payment_mode->ViewCustomAttributes = "";

			// card_name
			$this->card_name->ViewValue = $this->card_name->CurrentValue;
			$this->card_name->ViewCustomAttributes = "";

			// status_code
			$this->status_code->ViewValue = $this->status_code->CurrentValue;
			$this->status_code->ViewCustomAttributes = "";

			// status_message
			$this->status_message->ViewValue = $this->status_message->CurrentValue;
			$this->status_message->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// trans_date
			$this->trans_date->ViewValue = $this->trans_date->CurrentValue;
			$this->trans_date->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// payment_gateway
			$this->payment_gateway->ViewValue = $this->payment_gateway->CurrentValue;
			$this->payment_gateway->ViewCustomAttributes = "";

			// payment_signature
			$this->payment_signature->ViewValue = $this->payment_signature->CurrentValue;
			$this->payment_signature->ViewCustomAttributes = "";

			// currency_id
			$curVal = strval($this->currency_id->CurrentValue);
			if ($curVal <> "") {
				$this->currency_id->ViewValue = $this->currency_id->lookupCacheOption($curVal);
				if ($this->currency_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->currency_id->ViewValue = $this->currency_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency_id->ViewValue = $this->currency_id->CurrentValue;
					}
				}
			} else {
				$this->currency_id->ViewValue = NULL;
			}
			$this->currency_id->ViewCustomAttributes = "";

			// type
			$this->type->LinkCustomAttributes = "";
			if (!EmptyValue($this->type->CurrentValue)) {
				$this->type->HrefValue = "payment_responselist.php?x_type=" . ((!empty($this->type->ViewValue) && !is_array($this->type->ViewValue)) ? RemoveHtml($this->type->ViewValue) : $this->type->CurrentValue); // Add prefix/suffix
				$this->type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->type->HrefValue = FullUrl($this->type->HrefValue, "href");
			} else {
				$this->type->HrefValue = "";
			}
			$this->type->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			if (!EmptyValue($this->status->CurrentValue)) {
				$this->status->HrefValue = "payment_responselist.php?x_status=" . $this->status->CurrentValue; // Add prefix/suffix
				$this->status->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
			} else {
				$this->status->HrefValue = "";
			}
			$this->status->TooltipValue = "";

			// userid
			$this->_userid->LinkCustomAttributes = "";
			if (!EmptyValue($this->_userid->CurrentValue)) {
				$this->_userid->HrefValue = "payment_responselist.php?x__userid=" . $this->_userid->CurrentValue; // Add prefix/suffix
				$this->_userid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->_userid->HrefValue = FullUrl($this->_userid->HrefValue, "href");
			} else {
				$this->_userid->HrefValue = "";
			}
			$this->_userid->TooltipValue = "";

			// pg_order_number
			$this->pg_order_number->LinkCustomAttributes = "";
			$this->pg_order_number->HrefValue = "";
			$this->pg_order_number->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// cart_number
			$this->cart_number->LinkCustomAttributes = "";
			$this->cart_number->HrefValue = "";
			$this->cart_number->TooltipValue = "";

			// order_id
			$this->order_id->LinkCustomAttributes = "";
			$this->order_id->HrefValue = "";
			$this->order_id->TooltipValue = "";

			// tracking_id
			$this->tracking_id->LinkCustomAttributes = "";
			$this->tracking_id->HrefValue = "";
			$this->tracking_id->TooltipValue = "";

			// bank_ref_no
			$this->bank_ref_no->LinkCustomAttributes = "";
			$this->bank_ref_no->HrefValue = "";
			$this->bank_ref_no->TooltipValue = "";

			// order_status
			$this->order_status->LinkCustomAttributes = "";
			$this->order_status->HrefValue = "";
			$this->order_status->TooltipValue = "";

			// failure_message
			$this->failure_message->LinkCustomAttributes = "";
			$this->failure_message->HrefValue = "";
			$this->failure_message->TooltipValue = "";

			// payment_mode
			$this->payment_mode->LinkCustomAttributes = "";
			$this->payment_mode->HrefValue = "";
			$this->payment_mode->TooltipValue = "";

			// card_name
			$this->card_name->LinkCustomAttributes = "";
			$this->card_name->HrefValue = "";
			$this->card_name->TooltipValue = "";

			// status_code
			$this->status_code->LinkCustomAttributes = "";
			$this->status_code->HrefValue = "";
			$this->status_code->TooltipValue = "";

			// status_message
			$this->status_message->LinkCustomAttributes = "";
			$this->status_message->HrefValue = "";
			$this->status_message->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// trans_date
			$this->trans_date->LinkCustomAttributes = "";
			$this->trans_date->HrefValue = "";
			$this->trans_date->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// payment_gateway
			$this->payment_gateway->LinkCustomAttributes = "";
			$this->payment_gateway->HrefValue = "";
			$this->payment_gateway->TooltipValue = "";

			// payment_signature
			$this->payment_signature->LinkCustomAttributes = "";
			$this->payment_signature->HrefValue = "";
			$this->payment_signature->TooltipValue = "";

			// currency_id
			$this->currency_id->LinkCustomAttributes = "";
			$this->currency_id->HrefValue = "";
			$this->currency_id->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// type
			$this->type->EditAttrs["class"] = "form-control";
			$this->type->EditCustomAttributes = "";
			$this->type->EditValue = HtmlEncode($this->type->CurrentValue);
			$this->type->PlaceHolder = RemoveHtml($this->type->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// userid
			$this->_userid->EditAttrs["class"] = "form-control";
			$this->_userid->EditCustomAttributes = "";
			$this->_userid->EditValue = HtmlEncode($this->_userid->CurrentValue);
			$curVal = strval($this->_userid->CurrentValue);
			if ($curVal <> "") {
				$this->_userid->EditValue = $this->_userid->lookupCacheOption($curVal);
				if ($this->_userid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->_userid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->_userid->EditValue = $this->_userid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_userid->EditValue = HtmlEncode($this->_userid->CurrentValue);
					}
				}
			} else {
				$this->_userid->EditValue = NULL;
			}
			$this->_userid->PlaceHolder = RemoveHtml($this->_userid->caption());

			// pg_order_number
			$this->pg_order_number->EditAttrs["class"] = "form-control";
			$this->pg_order_number->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pg_order_number->CurrentValue = HtmlDecode($this->pg_order_number->CurrentValue);
			$this->pg_order_number->EditValue = HtmlEncode($this->pg_order_number->CurrentValue);
			$this->pg_order_number->PlaceHolder = RemoveHtml($this->pg_order_number->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// cart_number
			$this->cart_number->EditAttrs["class"] = "form-control";
			$this->cart_number->EditCustomAttributes = "";
			$this->cart_number->EditValue = HtmlEncode($this->cart_number->CurrentValue);
			$this->cart_number->PlaceHolder = RemoveHtml($this->cart_number->caption());

			// order_id
			$this->order_id->EditAttrs["class"] = "form-control";
			$this->order_id->EditCustomAttributes = "";
			$this->order_id->EditValue = HtmlEncode($this->order_id->CurrentValue);
			$this->order_id->PlaceHolder = RemoveHtml($this->order_id->caption());

			// tracking_id
			$this->tracking_id->EditAttrs["class"] = "form-control";
			$this->tracking_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->tracking_id->CurrentValue = HtmlDecode($this->tracking_id->CurrentValue);
			$this->tracking_id->EditValue = HtmlEncode($this->tracking_id->CurrentValue);
			$this->tracking_id->PlaceHolder = RemoveHtml($this->tracking_id->caption());

			// bank_ref_no
			$this->bank_ref_no->EditAttrs["class"] = "form-control";
			$this->bank_ref_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_ref_no->CurrentValue = HtmlDecode($this->bank_ref_no->CurrentValue);
			$this->bank_ref_no->EditValue = HtmlEncode($this->bank_ref_no->CurrentValue);
			$this->bank_ref_no->PlaceHolder = RemoveHtml($this->bank_ref_no->caption());

			// order_status
			$this->order_status->EditAttrs["class"] = "form-control";
			$this->order_status->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->order_status->CurrentValue = HtmlDecode($this->order_status->CurrentValue);
			$this->order_status->EditValue = HtmlEncode($this->order_status->CurrentValue);
			$this->order_status->PlaceHolder = RemoveHtml($this->order_status->caption());

			// failure_message
			$this->failure_message->EditAttrs["class"] = "form-control";
			$this->failure_message->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->failure_message->CurrentValue = HtmlDecode($this->failure_message->CurrentValue);
			$this->failure_message->EditValue = HtmlEncode($this->failure_message->CurrentValue);
			$this->failure_message->PlaceHolder = RemoveHtml($this->failure_message->caption());

			// payment_mode
			$this->payment_mode->EditAttrs["class"] = "form-control";
			$this->payment_mode->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->payment_mode->CurrentValue = HtmlDecode($this->payment_mode->CurrentValue);
			$this->payment_mode->EditValue = HtmlEncode($this->payment_mode->CurrentValue);
			$this->payment_mode->PlaceHolder = RemoveHtml($this->payment_mode->caption());

			// card_name
			$this->card_name->EditAttrs["class"] = "form-control";
			$this->card_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->card_name->CurrentValue = HtmlDecode($this->card_name->CurrentValue);
			$this->card_name->EditValue = HtmlEncode($this->card_name->CurrentValue);
			$this->card_name->PlaceHolder = RemoveHtml($this->card_name->caption());

			// status_code
			$this->status_code->EditAttrs["class"] = "form-control";
			$this->status_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->status_code->CurrentValue = HtmlDecode($this->status_code->CurrentValue);
			$this->status_code->EditValue = HtmlEncode($this->status_code->CurrentValue);
			$this->status_code->PlaceHolder = RemoveHtml($this->status_code->caption());

			// status_message
			$this->status_message->EditAttrs["class"] = "form-control";
			$this->status_message->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->status_message->CurrentValue = HtmlDecode($this->status_message->CurrentValue);
			$this->status_message->EditValue = HtmlEncode($this->status_message->CurrentValue);
			$this->status_message->PlaceHolder = RemoveHtml($this->status_message->caption());

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = "";
			$this->amount->EditValue = HtmlEncode($this->amount->CurrentValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
			if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue))
				$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, -2);

			// trans_date
			$this->trans_date->EditAttrs["class"] = "form-control";
			$this->trans_date->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->trans_date->CurrentValue = HtmlDecode($this->trans_date->CurrentValue);
			$this->trans_date->EditValue = HtmlEncode($this->trans_date->CurrentValue);
			$this->trans_date->PlaceHolder = RemoveHtml($this->trans_date->caption());

			// datetime
			// payment_gateway

			$this->payment_gateway->EditAttrs["class"] = "form-control";
			$this->payment_gateway->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->payment_gateway->CurrentValue = HtmlDecode($this->payment_gateway->CurrentValue);
			$this->payment_gateway->EditValue = HtmlEncode($this->payment_gateway->CurrentValue);
			$this->payment_gateway->PlaceHolder = RemoveHtml($this->payment_gateway->caption());

			// payment_signature
			$this->payment_signature->EditAttrs["class"] = "form-control";
			$this->payment_signature->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->payment_signature->CurrentValue = HtmlDecode($this->payment_signature->CurrentValue);
			$this->payment_signature->EditValue = HtmlEncode($this->payment_signature->CurrentValue);
			$this->payment_signature->PlaceHolder = RemoveHtml($this->payment_signature->caption());

			// currency_id
			$this->currency_id->EditAttrs["class"] = "form-control";
			$this->currency_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->currency_id->CurrentValue));
			if ($curVal <> "")
				$this->currency_id->ViewValue = $this->currency_id->lookupCacheOption($curVal);
			else
				$this->currency_id->ViewValue = $this->currency_id->Lookup !== NULL && is_array($this->currency_id->Lookup->Options) ? $curVal : NULL;
			if ($this->currency_id->ViewValue !== NULL) { // Load from cache
				$this->currency_id->EditValue = array_values($this->currency_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->currency_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->currency_id->EditValue = $arwrk;
			}

			// Add refer script
			// type

			$this->type->LinkCustomAttributes = "";
			if (!EmptyValue($this->type->CurrentValue)) {
				$this->type->HrefValue = "payment_responselist.php?x_type=" . ((!empty($this->type->EditValue) && !is_array($this->type->EditValue)) ? RemoveHtml($this->type->EditValue) : $this->type->CurrentValue); // Add prefix/suffix
				$this->type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->type->HrefValue = FullUrl($this->type->HrefValue, "href");
			} else {
				$this->type->HrefValue = "";
			}

			// status
			$this->status->LinkCustomAttributes = "";
			if (!EmptyValue($this->status->CurrentValue)) {
				$this->status->HrefValue = "payment_responselist.php?x_status=" . $this->status->CurrentValue; // Add prefix/suffix
				$this->status->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
			} else {
				$this->status->HrefValue = "";
			}

			// userid
			$this->_userid->LinkCustomAttributes = "";
			if (!EmptyValue($this->_userid->CurrentValue)) {
				$this->_userid->HrefValue = "payment_responselist.php?x__userid=" . $this->_userid->CurrentValue; // Add prefix/suffix
				$this->_userid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->_userid->HrefValue = FullUrl($this->_userid->HrefValue, "href");
			} else {
				$this->_userid->HrefValue = "";
			}

			// pg_order_number
			$this->pg_order_number->LinkCustomAttributes = "";
			$this->pg_order_number->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// cart_number
			$this->cart_number->LinkCustomAttributes = "";
			$this->cart_number->HrefValue = "";

			// order_id
			$this->order_id->LinkCustomAttributes = "";
			$this->order_id->HrefValue = "";

			// tracking_id
			$this->tracking_id->LinkCustomAttributes = "";
			$this->tracking_id->HrefValue = "";

			// bank_ref_no
			$this->bank_ref_no->LinkCustomAttributes = "";
			$this->bank_ref_no->HrefValue = "";

			// order_status
			$this->order_status->LinkCustomAttributes = "";
			$this->order_status->HrefValue = "";

			// failure_message
			$this->failure_message->LinkCustomAttributes = "";
			$this->failure_message->HrefValue = "";

			// payment_mode
			$this->payment_mode->LinkCustomAttributes = "";
			$this->payment_mode->HrefValue = "";

			// card_name
			$this->card_name->LinkCustomAttributes = "";
			$this->card_name->HrefValue = "";

			// status_code
			$this->status_code->LinkCustomAttributes = "";
			$this->status_code->HrefValue = "";

			// status_message
			$this->status_message->LinkCustomAttributes = "";
			$this->status_message->HrefValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";

			// trans_date
			$this->trans_date->LinkCustomAttributes = "";
			$this->trans_date->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// payment_gateway
			$this->payment_gateway->LinkCustomAttributes = "";
			$this->payment_gateway->HrefValue = "";

			// payment_signature
			$this->payment_signature->LinkCustomAttributes = "";
			$this->payment_signature->HrefValue = "";

			// currency_id
			$this->currency_id->LinkCustomAttributes = "";
			$this->currency_id->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->type->Required) {
			if (!$this->type->IsDetailKey && $this->type->FormValue != NULL && $this->type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->type->FormValue)) {
			AddMessage($FormError, $this->type->errorMessage());
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->_userid->Required) {
			if (!$this->_userid->IsDetailKey && $this->_userid->FormValue != NULL && $this->_userid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_userid->caption(), $this->_userid->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->_userid->FormValue)) {
			AddMessage($FormError, $this->_userid->errorMessage());
		}
		if ($this->pg_order_number->Required) {
			if (!$this->pg_order_number->IsDetailKey && $this->pg_order_number->FormValue != NULL && $this->pg_order_number->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pg_order_number->caption(), $this->pg_order_number->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->cart_number->Required) {
			if (!$this->cart_number->IsDetailKey && $this->cart_number->FormValue != NULL && $this->cart_number->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cart_number->caption(), $this->cart_number->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->cart_number->FormValue)) {
			AddMessage($FormError, $this->cart_number->errorMessage());
		}
		if ($this->order_id->Required) {
			if (!$this->order_id->IsDetailKey && $this->order_id->FormValue != NULL && $this->order_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->order_id->caption(), $this->order_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->order_id->FormValue)) {
			AddMessage($FormError, $this->order_id->errorMessage());
		}
		if ($this->tracking_id->Required) {
			if (!$this->tracking_id->IsDetailKey && $this->tracking_id->FormValue != NULL && $this->tracking_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tracking_id->caption(), $this->tracking_id->RequiredErrorMessage));
			}
		}
		if ($this->bank_ref_no->Required) {
			if (!$this->bank_ref_no->IsDetailKey && $this->bank_ref_no->FormValue != NULL && $this->bank_ref_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bank_ref_no->caption(), $this->bank_ref_no->RequiredErrorMessage));
			}
		}
		if ($this->order_status->Required) {
			if (!$this->order_status->IsDetailKey && $this->order_status->FormValue != NULL && $this->order_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->order_status->caption(), $this->order_status->RequiredErrorMessage));
			}
		}
		if ($this->failure_message->Required) {
			if (!$this->failure_message->IsDetailKey && $this->failure_message->FormValue != NULL && $this->failure_message->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->failure_message->caption(), $this->failure_message->RequiredErrorMessage));
			}
		}
		if ($this->payment_mode->Required) {
			if (!$this->payment_mode->IsDetailKey && $this->payment_mode->FormValue != NULL && $this->payment_mode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment_mode->caption(), $this->payment_mode->RequiredErrorMessage));
			}
		}
		if ($this->card_name->Required) {
			if (!$this->card_name->IsDetailKey && $this->card_name->FormValue != NULL && $this->card_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->card_name->caption(), $this->card_name->RequiredErrorMessage));
			}
		}
		if ($this->status_code->Required) {
			if (!$this->status_code->IsDetailKey && $this->status_code->FormValue != NULL && $this->status_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status_code->caption(), $this->status_code->RequiredErrorMessage));
			}
		}
		if ($this->status_message->Required) {
			if (!$this->status_message->IsDetailKey && $this->status_message->FormValue != NULL && $this->status_message->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status_message->caption(), $this->status_message->RequiredErrorMessage));
			}
		}
		if ($this->amount->Required) {
			if (!$this->amount->IsDetailKey && $this->amount->FormValue != NULL && $this->amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->amount->FormValue)) {
			AddMessage($FormError, $this->amount->errorMessage());
		}
		if ($this->trans_date->Required) {
			if (!$this->trans_date->IsDetailKey && $this->trans_date->FormValue != NULL && $this->trans_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->trans_date->caption(), $this->trans_date->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->payment_gateway->Required) {
			if (!$this->payment_gateway->IsDetailKey && $this->payment_gateway->FormValue != NULL && $this->payment_gateway->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment_gateway->caption(), $this->payment_gateway->RequiredErrorMessage));
			}
		}
		if ($this->payment_signature->Required) {
			if (!$this->payment_signature->IsDetailKey && $this->payment_signature->FormValue != NULL && $this->payment_signature->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment_signature->caption(), $this->payment_signature->RequiredErrorMessage));
			}
		}
		if ($this->currency_id->Required) {
			if (!$this->currency_id->IsDetailKey && $this->currency_id->FormValue != NULL && $this->currency_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->currency_id->caption(), $this->currency_id->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		if ($this->pg_order_number->CurrentValue <> "") { // Check field with unique index
			$filter = "(pg_order_number = '" . AdjustSql($this->pg_order_number->CurrentValue, $this->Dbid) . "')";
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->pg_order_number->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->pg_order_number->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
		}
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// type
		$this->type->setDbValueDef($rsnew, $this->type->CurrentValue, 0, FALSE);

		// status
		$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, 0, strval($this->status->CurrentValue) == "");

		// userid
		$this->_userid->setDbValueDef($rsnew, $this->_userid->CurrentValue, 0, FALSE);

		// pg_order_number
		$this->pg_order_number->setDbValueDef($rsnew, $this->pg_order_number->CurrentValue, "", FALSE);

		// remarks
		$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, "", FALSE);

		// cart_number
		$this->cart_number->setDbValueDef($rsnew, $this->cart_number->CurrentValue, 0, FALSE);

		// order_id
		$this->order_id->setDbValueDef($rsnew, $this->order_id->CurrentValue, 0, FALSE);

		// tracking_id
		$this->tracking_id->setDbValueDef($rsnew, $this->tracking_id->CurrentValue, "", FALSE);

		// bank_ref_no
		$this->bank_ref_no->setDbValueDef($rsnew, $this->bank_ref_no->CurrentValue, "", FALSE);

		// order_status
		$this->order_status->setDbValueDef($rsnew, $this->order_status->CurrentValue, "", FALSE);

		// failure_message
		$this->failure_message->setDbValueDef($rsnew, $this->failure_message->CurrentValue, "", FALSE);

		// payment_mode
		$this->payment_mode->setDbValueDef($rsnew, $this->payment_mode->CurrentValue, "", FALSE);

		// card_name
		$this->card_name->setDbValueDef($rsnew, $this->card_name->CurrentValue, "", FALSE);

		// status_code
		$this->status_code->setDbValueDef($rsnew, $this->status_code->CurrentValue, "", FALSE);

		// status_message
		$this->status_message->setDbValueDef($rsnew, $this->status_message->CurrentValue, "", FALSE);

		// amount
		$this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, NULL, FALSE);

		// trans_date
		$this->trans_date->setDbValueDef($rsnew, $this->trans_date->CurrentValue, "", FALSE);

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentUserID(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// payment_gateway
		$this->payment_gateway->setDbValueDef($rsnew, $this->payment_gateway->CurrentValue, "", FALSE);

		// payment_signature
		$this->payment_signature->setDbValueDef($rsnew, $this->payment_signature->CurrentValue, "", FALSE);

		// currency_id
		$this->currency_id->setDbValueDef($rsnew, $this->currency_id->CurrentValue, 0, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("payment_responselist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_currency_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x__userid":
							break;
						case "x_currency_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>