<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class payment_response_search extends payment_response
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'payment_response';

	// Page object name
	public $PageObjName = "payment_response_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (payment_response)
		if (!isset($GLOBALS["payment_response"]) || get_class($GLOBALS["payment_response"]) == PROJECT_NAMESPACE . "payment_response") {
			$GLOBALS["payment_response"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["payment_response"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'payment_response');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $payment_response;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($payment_response);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "payment_responseview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("payment_responselist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->type->setVisibility();
		$this->status->setVisibility();
		$this->_userid->setVisibility();
		$this->pg_order_number->setVisibility();
		$this->remarks->setVisibility();
		$this->cart_number->setVisibility();
		$this->order_id->setVisibility();
		$this->tracking_id->setVisibility();
		$this->bank_ref_no->setVisibility();
		$this->order_status->setVisibility();
		$this->failure_message->setVisibility();
		$this->payment_mode->setVisibility();
		$this->card_name->setVisibility();
		$this->status_code->setVisibility();
		$this->status_message->setVisibility();
		$this->amount->setVisibility();
		$this->trans_date->setVisibility();
		$this->datetime->setVisibility();
		$this->payment_gateway->setVisibility();
		$this->payment_signature->setVisibility();
		$this->currency_id->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->_userid);
		$this->setupLookupOptions($this->currency_id);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "payment_responselist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->type); // type
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->_userid); // userid
		$this->buildSearchUrl($srchUrl, $this->pg_order_number); // pg_order_number
		$this->buildSearchUrl($srchUrl, $this->remarks); // remarks
		$this->buildSearchUrl($srchUrl, $this->cart_number); // cart_number
		$this->buildSearchUrl($srchUrl, $this->order_id); // order_id
		$this->buildSearchUrl($srchUrl, $this->tracking_id); // tracking_id
		$this->buildSearchUrl($srchUrl, $this->bank_ref_no); // bank_ref_no
		$this->buildSearchUrl($srchUrl, $this->order_status); // order_status
		$this->buildSearchUrl($srchUrl, $this->failure_message); // failure_message
		$this->buildSearchUrl($srchUrl, $this->payment_mode); // payment_mode
		$this->buildSearchUrl($srchUrl, $this->card_name); // card_name
		$this->buildSearchUrl($srchUrl, $this->status_code); // status_code
		$this->buildSearchUrl($srchUrl, $this->status_message); // status_message
		$this->buildSearchUrl($srchUrl, $this->amount); // amount
		$this->buildSearchUrl($srchUrl, $this->trans_date); // trans_date
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->payment_gateway); // payment_gateway
		$this->buildSearchUrl($srchUrl, $this->payment_signature); // payment_signature
		$this->buildSearchUrl($srchUrl, $this->currency_id); // currency_id
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// type
		if (!$this->isAddOrEdit())
			$this->type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_type"));
		$this->type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_type"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// userid
		if (!$this->isAddOrEdit())
			$this->_userid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__userid"));
		$this->_userid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__userid"));
		$this->_userid->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v__userid"));
		$this->_userid->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y__userid"));
		$this->_userid->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w__userid"));

		// pg_order_number
		if (!$this->isAddOrEdit())
			$this->pg_order_number->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pg_order_number"));
		$this->pg_order_number->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pg_order_number"));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remarks"));
		$this->remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remarks"));

		// cart_number
		if (!$this->isAddOrEdit())
			$this->cart_number->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cart_number"));
		$this->cart_number->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cart_number"));

		// order_id
		if (!$this->isAddOrEdit())
			$this->order_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_order_id"));
		$this->order_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_order_id"));

		// tracking_id
		if (!$this->isAddOrEdit())
			$this->tracking_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_tracking_id"));
		$this->tracking_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_tracking_id"));

		// bank_ref_no
		if (!$this->isAddOrEdit())
			$this->bank_ref_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_bank_ref_no"));
		$this->bank_ref_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_bank_ref_no"));

		// order_status
		if (!$this->isAddOrEdit())
			$this->order_status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_order_status"));
		$this->order_status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_order_status"));

		// failure_message
		if (!$this->isAddOrEdit())
			$this->failure_message->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_failure_message"));
		$this->failure_message->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_failure_message"));

		// payment_mode
		if (!$this->isAddOrEdit())
			$this->payment_mode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_payment_mode"));
		$this->payment_mode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_payment_mode"));

		// card_name
		if (!$this->isAddOrEdit())
			$this->card_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_card_name"));
		$this->card_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_card_name"));

		// status_code
		if (!$this->isAddOrEdit())
			$this->status_code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status_code"));
		$this->status_code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status_code"));

		// status_message
		if (!$this->isAddOrEdit())
			$this->status_message->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status_message"));
		$this->status_message->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status_message"));

		// amount
		if (!$this->isAddOrEdit())
			$this->amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_amount"));
		$this->amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_amount"));

		// trans_date
		if (!$this->isAddOrEdit())
			$this->trans_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_trans_date"));
		$this->trans_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_trans_date"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// payment_gateway
		if (!$this->isAddOrEdit())
			$this->payment_gateway->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_payment_gateway"));
		$this->payment_gateway->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_payment_gateway"));

		// payment_signature
		if (!$this->isAddOrEdit())
			$this->payment_signature->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_payment_signature"));
		$this->payment_signature->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_payment_signature"));

		// currency_id
		if (!$this->isAddOrEdit())
			$this->currency_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_currency_id"));
		$this->currency_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_currency_id"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// type
		// status
		// userid
		// pg_order_number
		// remarks
		// cart_number
		// order_id
		// tracking_id
		// bank_ref_no
		// order_status
		// failure_message
		// payment_mode
		// card_name
		// status_code
		// status_message
		// amount
		// trans_date
		// datetime
		// payment_gateway
		// payment_signature
		// currency_id

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// type
			$this->type->ViewValue = $this->type->CurrentValue;
			$this->type->ViewValue = FormatNumber($this->type->ViewValue, 0, -2, -2, -2);
			$this->type->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// userid
			$this->_userid->ViewValue = $this->_userid->CurrentValue;
			$curVal = strval($this->_userid->CurrentValue);
			if ($curVal <> "") {
				$this->_userid->ViewValue = $this->_userid->lookupCacheOption($curVal);
				if ($this->_userid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->_userid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->_userid->ViewValue = $this->_userid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_userid->ViewValue = $this->_userid->CurrentValue;
					}
				}
			} else {
				$this->_userid->ViewValue = NULL;
			}
			$this->_userid->ViewCustomAttributes = "";

			// pg_order_number
			$this->pg_order_number->ViewValue = $this->pg_order_number->CurrentValue;
			$this->pg_order_number->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// cart_number
			$this->cart_number->ViewValue = $this->cart_number->CurrentValue;
			$this->cart_number->ViewValue = FormatNumber($this->cart_number->ViewValue, 0, -2, -2, -2);
			$this->cart_number->ViewCustomAttributes = "";

			// order_id
			$this->order_id->ViewValue = $this->order_id->CurrentValue;
			$this->order_id->ViewValue = FormatNumber($this->order_id->ViewValue, 0, -2, -2, -2);
			$this->order_id->ViewCustomAttributes = "";

			// tracking_id
			$this->tracking_id->ViewValue = $this->tracking_id->CurrentValue;
			$this->tracking_id->ViewCustomAttributes = "";

			// bank_ref_no
			$this->bank_ref_no->ViewValue = $this->bank_ref_no->CurrentValue;
			$this->bank_ref_no->ViewCustomAttributes = "";

			// order_status
			$this->order_status->ViewValue = $this->order_status->CurrentValue;
			$this->order_status->ViewCustomAttributes = "";

			// failure_message
			$this->failure_message->ViewValue = $this->failure_message->CurrentValue;
			$this->failure_message->ViewCustomAttributes = "";

			// payment_mode
			$this->payment_mode->ViewValue = $this->payment_mode->CurrentValue;
			$this->payment_mode->ViewCustomAttributes = "";

			// card_name
			$this->card_name->ViewValue = $this->card_name->CurrentValue;
			$this->card_name->ViewCustomAttributes = "";

			// status_code
			$this->status_code->ViewValue = $this->status_code->CurrentValue;
			$this->status_code->ViewCustomAttributes = "";

			// status_message
			$this->status_message->ViewValue = $this->status_message->CurrentValue;
			$this->status_message->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// trans_date
			$this->trans_date->ViewValue = $this->trans_date->CurrentValue;
			$this->trans_date->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// payment_gateway
			$this->payment_gateway->ViewValue = $this->payment_gateway->CurrentValue;
			$this->payment_gateway->ViewCustomAttributes = "";

			// payment_signature
			$this->payment_signature->ViewValue = $this->payment_signature->CurrentValue;
			$this->payment_signature->ViewCustomAttributes = "";

			// currency_id
			$curVal = strval($this->currency_id->CurrentValue);
			if ($curVal <> "") {
				$this->currency_id->ViewValue = $this->currency_id->lookupCacheOption($curVal);
				if ($this->currency_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->currency_id->ViewValue = $this->currency_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency_id->ViewValue = $this->currency_id->CurrentValue;
					}
				}
			} else {
				$this->currency_id->ViewValue = NULL;
			}
			$this->currency_id->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			if (!EmptyValue($this->type->CurrentValue)) {
				$this->type->HrefValue = "payment_responselist.php?x_type=" . ((!empty($this->type->ViewValue) && !is_array($this->type->ViewValue)) ? RemoveHtml($this->type->ViewValue) : $this->type->CurrentValue); // Add prefix/suffix
				$this->type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->type->HrefValue = FullUrl($this->type->HrefValue, "href");
			} else {
				$this->type->HrefValue = "";
			}
			$this->type->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			if (!EmptyValue($this->status->CurrentValue)) {
				$this->status->HrefValue = "payment_responselist.php?x_status=" . $this->status->CurrentValue; // Add prefix/suffix
				$this->status->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->status->HrefValue = FullUrl($this->status->HrefValue, "href");
			} else {
				$this->status->HrefValue = "";
			}
			$this->status->TooltipValue = "";

			// userid
			$this->_userid->LinkCustomAttributes = "";
			if (!EmptyValue($this->_userid->CurrentValue)) {
				$this->_userid->HrefValue = "payment_responselist.php?x__userid=" . $this->_userid->CurrentValue; // Add prefix/suffix
				$this->_userid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->_userid->HrefValue = FullUrl($this->_userid->HrefValue, "href");
			} else {
				$this->_userid->HrefValue = "";
			}
			$this->_userid->TooltipValue = "";

			// pg_order_number
			$this->pg_order_number->LinkCustomAttributes = "";
			$this->pg_order_number->HrefValue = "";
			$this->pg_order_number->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// cart_number
			$this->cart_number->LinkCustomAttributes = "";
			$this->cart_number->HrefValue = "";
			$this->cart_number->TooltipValue = "";

			// order_id
			$this->order_id->LinkCustomAttributes = "";
			$this->order_id->HrefValue = "";
			$this->order_id->TooltipValue = "";

			// tracking_id
			$this->tracking_id->LinkCustomAttributes = "";
			$this->tracking_id->HrefValue = "";
			$this->tracking_id->TooltipValue = "";

			// bank_ref_no
			$this->bank_ref_no->LinkCustomAttributes = "";
			$this->bank_ref_no->HrefValue = "";
			$this->bank_ref_no->TooltipValue = "";

			// order_status
			$this->order_status->LinkCustomAttributes = "";
			$this->order_status->HrefValue = "";
			$this->order_status->TooltipValue = "";

			// failure_message
			$this->failure_message->LinkCustomAttributes = "";
			$this->failure_message->HrefValue = "";
			$this->failure_message->TooltipValue = "";

			// payment_mode
			$this->payment_mode->LinkCustomAttributes = "";
			$this->payment_mode->HrefValue = "";
			$this->payment_mode->TooltipValue = "";

			// card_name
			$this->card_name->LinkCustomAttributes = "";
			$this->card_name->HrefValue = "";
			$this->card_name->TooltipValue = "";

			// status_code
			$this->status_code->LinkCustomAttributes = "";
			$this->status_code->HrefValue = "";
			$this->status_code->TooltipValue = "";

			// status_message
			$this->status_message->LinkCustomAttributes = "";
			$this->status_message->HrefValue = "";
			$this->status_message->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// trans_date
			$this->trans_date->LinkCustomAttributes = "";
			$this->trans_date->HrefValue = "";
			$this->trans_date->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// payment_gateway
			$this->payment_gateway->LinkCustomAttributes = "";
			$this->payment_gateway->HrefValue = "";
			$this->payment_gateway->TooltipValue = "";

			// payment_signature
			$this->payment_signature->LinkCustomAttributes = "";
			$this->payment_signature->HrefValue = "";
			$this->payment_signature->TooltipValue = "";

			// currency_id
			$this->currency_id->LinkCustomAttributes = "";
			$this->currency_id->HrefValue = "";
			$this->currency_id->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// type
			$this->type->EditAttrs["class"] = "form-control";
			$this->type->EditCustomAttributes = "";
			$this->type->EditValue = HtmlEncode($this->type->AdvancedSearch->SearchValue);
			$this->type->PlaceHolder = RemoveHtml($this->type->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// userid
			$this->_userid->EditAttrs["class"] = "form-control";
			$this->_userid->EditCustomAttributes = "";
			$this->_userid->EditValue = HtmlEncode($this->_userid->AdvancedSearch->SearchValue);
			$curVal = strval($this->_userid->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->_userid->EditValue = $this->_userid->lookupCacheOption($curVal);
				if ($this->_userid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->_userid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->_userid->EditValue = $this->_userid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_userid->EditValue = HtmlEncode($this->_userid->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->_userid->EditValue = NULL;
			}
			$this->_userid->PlaceHolder = RemoveHtml($this->_userid->caption());
			$this->_userid->EditAttrs["class"] = "form-control";
			$this->_userid->EditCustomAttributes = "";
			$this->_userid->EditValue2 = HtmlEncode($this->_userid->AdvancedSearch->SearchValue2);
			$curVal = strval($this->_userid->AdvancedSearch->SearchValue2);
			if ($curVal <> "") {
				$this->_userid->EditValue2 = $this->_userid->lookupCacheOption($curVal);
				if ($this->_userid->EditValue2 === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->_userid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->_userid->EditValue2 = $this->_userid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_userid->EditValue2 = HtmlEncode($this->_userid->AdvancedSearch->SearchValue2);
					}
				}
			} else {
				$this->_userid->EditValue2 = NULL;
			}
			$this->_userid->PlaceHolder = RemoveHtml($this->_userid->caption());

			// pg_order_number
			$this->pg_order_number->EditAttrs["class"] = "form-control";
			$this->pg_order_number->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pg_order_number->AdvancedSearch->SearchValue = HtmlDecode($this->pg_order_number->AdvancedSearch->SearchValue);
			$this->pg_order_number->EditValue = HtmlEncode($this->pg_order_number->AdvancedSearch->SearchValue);
			$this->pg_order_number->PlaceHolder = RemoveHtml($this->pg_order_number->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// cart_number
			$this->cart_number->EditAttrs["class"] = "form-control";
			$this->cart_number->EditCustomAttributes = "";
			$this->cart_number->EditValue = HtmlEncode($this->cart_number->AdvancedSearch->SearchValue);
			$this->cart_number->PlaceHolder = RemoveHtml($this->cart_number->caption());

			// order_id
			$this->order_id->EditAttrs["class"] = "form-control";
			$this->order_id->EditCustomAttributes = "";
			$this->order_id->EditValue = HtmlEncode($this->order_id->AdvancedSearch->SearchValue);
			$this->order_id->PlaceHolder = RemoveHtml($this->order_id->caption());

			// tracking_id
			$this->tracking_id->EditAttrs["class"] = "form-control";
			$this->tracking_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->tracking_id->AdvancedSearch->SearchValue = HtmlDecode($this->tracking_id->AdvancedSearch->SearchValue);
			$this->tracking_id->EditValue = HtmlEncode($this->tracking_id->AdvancedSearch->SearchValue);
			$this->tracking_id->PlaceHolder = RemoveHtml($this->tracking_id->caption());

			// bank_ref_no
			$this->bank_ref_no->EditAttrs["class"] = "form-control";
			$this->bank_ref_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_ref_no->AdvancedSearch->SearchValue = HtmlDecode($this->bank_ref_no->AdvancedSearch->SearchValue);
			$this->bank_ref_no->EditValue = HtmlEncode($this->bank_ref_no->AdvancedSearch->SearchValue);
			$this->bank_ref_no->PlaceHolder = RemoveHtml($this->bank_ref_no->caption());

			// order_status
			$this->order_status->EditAttrs["class"] = "form-control";
			$this->order_status->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->order_status->AdvancedSearch->SearchValue = HtmlDecode($this->order_status->AdvancedSearch->SearchValue);
			$this->order_status->EditValue = HtmlEncode($this->order_status->AdvancedSearch->SearchValue);
			$this->order_status->PlaceHolder = RemoveHtml($this->order_status->caption());

			// failure_message
			$this->failure_message->EditAttrs["class"] = "form-control";
			$this->failure_message->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->failure_message->AdvancedSearch->SearchValue = HtmlDecode($this->failure_message->AdvancedSearch->SearchValue);
			$this->failure_message->EditValue = HtmlEncode($this->failure_message->AdvancedSearch->SearchValue);
			$this->failure_message->PlaceHolder = RemoveHtml($this->failure_message->caption());

			// payment_mode
			$this->payment_mode->EditAttrs["class"] = "form-control";
			$this->payment_mode->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->payment_mode->AdvancedSearch->SearchValue = HtmlDecode($this->payment_mode->AdvancedSearch->SearchValue);
			$this->payment_mode->EditValue = HtmlEncode($this->payment_mode->AdvancedSearch->SearchValue);
			$this->payment_mode->PlaceHolder = RemoveHtml($this->payment_mode->caption());

			// card_name
			$this->card_name->EditAttrs["class"] = "form-control";
			$this->card_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->card_name->AdvancedSearch->SearchValue = HtmlDecode($this->card_name->AdvancedSearch->SearchValue);
			$this->card_name->EditValue = HtmlEncode($this->card_name->AdvancedSearch->SearchValue);
			$this->card_name->PlaceHolder = RemoveHtml($this->card_name->caption());

			// status_code
			$this->status_code->EditAttrs["class"] = "form-control";
			$this->status_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->status_code->AdvancedSearch->SearchValue = HtmlDecode($this->status_code->AdvancedSearch->SearchValue);
			$this->status_code->EditValue = HtmlEncode($this->status_code->AdvancedSearch->SearchValue);
			$this->status_code->PlaceHolder = RemoveHtml($this->status_code->caption());

			// status_message
			$this->status_message->EditAttrs["class"] = "form-control";
			$this->status_message->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->status_message->AdvancedSearch->SearchValue = HtmlDecode($this->status_message->AdvancedSearch->SearchValue);
			$this->status_message->EditValue = HtmlEncode($this->status_message->AdvancedSearch->SearchValue);
			$this->status_message->PlaceHolder = RemoveHtml($this->status_message->caption());

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = "";
			$this->amount->EditValue = HtmlEncode($this->amount->AdvancedSearch->SearchValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

			// trans_date
			$this->trans_date->EditAttrs["class"] = "form-control";
			$this->trans_date->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->trans_date->AdvancedSearch->SearchValue = HtmlDecode($this->trans_date->AdvancedSearch->SearchValue);
			$this->trans_date->EditValue = HtmlEncode($this->trans_date->AdvancedSearch->SearchValue);
			$this->trans_date->PlaceHolder = RemoveHtml($this->trans_date->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// payment_gateway
			$this->payment_gateway->EditAttrs["class"] = "form-control";
			$this->payment_gateway->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->payment_gateway->AdvancedSearch->SearchValue = HtmlDecode($this->payment_gateway->AdvancedSearch->SearchValue);
			$this->payment_gateway->EditValue = HtmlEncode($this->payment_gateway->AdvancedSearch->SearchValue);
			$this->payment_gateway->PlaceHolder = RemoveHtml($this->payment_gateway->caption());

			// payment_signature
			$this->payment_signature->EditAttrs["class"] = "form-control";
			$this->payment_signature->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->payment_signature->AdvancedSearch->SearchValue = HtmlDecode($this->payment_signature->AdvancedSearch->SearchValue);
			$this->payment_signature->EditValue = HtmlEncode($this->payment_signature->AdvancedSearch->SearchValue);
			$this->payment_signature->PlaceHolder = RemoveHtml($this->payment_signature->caption());

			// currency_id
			$this->currency_id->EditAttrs["class"] = "form-control";
			$this->currency_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->currency_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->currency_id->AdvancedSearch->ViewValue = $this->currency_id->lookupCacheOption($curVal);
			else
				$this->currency_id->AdvancedSearch->ViewValue = $this->currency_id->Lookup !== NULL && is_array($this->currency_id->Lookup->Options) ? $curVal : NULL;
			if ($this->currency_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->currency_id->EditValue = array_values($this->currency_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->currency_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->currency_id->EditValue = $arwrk;
			}
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->type->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->type->errorMessage());
		}
		if (!CheckInteger($this->_userid->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->_userid->errorMessage());
		}
		if (!CheckInteger($this->_userid->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->_userid->errorMessage());
		}
		if (!CheckInteger($this->cart_number->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->cart_number->errorMessage());
		}
		if (!CheckInteger($this->order_id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->order_id->errorMessage());
		}
		if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->amount->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->type->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->_userid->AdvancedSearch->load();
		$this->pg_order_number->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->cart_number->AdvancedSearch->load();
		$this->order_id->AdvancedSearch->load();
		$this->tracking_id->AdvancedSearch->load();
		$this->bank_ref_no->AdvancedSearch->load();
		$this->order_status->AdvancedSearch->load();
		$this->failure_message->AdvancedSearch->load();
		$this->payment_mode->AdvancedSearch->load();
		$this->card_name->AdvancedSearch->load();
		$this->status_code->AdvancedSearch->load();
		$this->status_message->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->trans_date->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->payment_gateway->AdvancedSearch->load();
		$this->payment_signature->AdvancedSearch->load();
		$this->currency_id->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("payment_responselist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_currency_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x__userid":
							break;
						case "x_currency_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>