<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for payroll_fix_details
 */
class payroll_fix_details extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $employee_id;
	public $remarks;
	public $daily_in;
	public $daily_out;
	public $lunch_break_min;
	public $daily_min;
	public $weekly_off;
	public $offsets_benifit_min;
	public $next_increment;
	public $current_payroll_startdate;
	public $base_salary;
	public $additional_benefits;
	public $extra_min_plan;
	public $office_holidays;
	public $paid_annual_leave;
	public $employee_pf;
	public $operator;
	public $datetime;
	public $employee_am_id;
	public $job_title;
	public $month_min;
	public $calculation_plan;
	public $status;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'payroll_fix_details';
		$this->TableName = 'payroll_fix_details';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`payroll_fix_details`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id
		$this->id = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_id', 'id', '`id`', '`id`', 2, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// employee_id
		$this->employee_id = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_employee_id', 'employee_id', '`employee_id`', '`employee_id`', 3, -1, FALSE, '`employee_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->employee_id->Nullable = FALSE; // NOT NULL field
		$this->employee_id->Required = TRUE; // Required field
		$this->employee_id->Sortable = TRUE; // Allow sort
		$this->employee_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['employee_id'] = &$this->employee_id;

		// remarks
		$this->remarks = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 201, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks->Required = TRUE; // Required field
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// daily_in
		$this->daily_in = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_daily_in', 'daily_in', '`daily_in`', CastDateFieldForLike('`daily_in`', 4, "DB"), 134, 4, FALSE, '`daily_in`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->daily_in->Nullable = FALSE; // NOT NULL field
		$this->daily_in->Required = TRUE; // Required field
		$this->daily_in->Sortable = TRUE; // Allow sort
		$this->daily_in->DefaultErrorMessage = str_replace("%s", $GLOBALS["TIME_SEPARATOR"], $Language->phrase("IncorrectTime"));
		$this->fields['daily_in'] = &$this->daily_in;

		// daily_out
		$this->daily_out = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_daily_out', 'daily_out', '`daily_out`', CastDateFieldForLike('`daily_out`', 4, "DB"), 134, 4, FALSE, '`daily_out`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->daily_out->Nullable = FALSE; // NOT NULL field
		$this->daily_out->Required = TRUE; // Required field
		$this->daily_out->Sortable = TRUE; // Allow sort
		$this->daily_out->DefaultErrorMessage = str_replace("%s", $GLOBALS["TIME_SEPARATOR"], $Language->phrase("IncorrectTime"));
		$this->fields['daily_out'] = &$this->daily_out;

		// lunch_break_min
		$this->lunch_break_min = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_lunch_break_min', 'lunch_break_min', '`lunch_break_min`', '`lunch_break_min`', 2, -1, FALSE, '`lunch_break_min`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lunch_break_min->Nullable = FALSE; // NOT NULL field
		$this->lunch_break_min->Required = TRUE; // Required field
		$this->lunch_break_min->Sortable = TRUE; // Allow sort
		$this->lunch_break_min->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['lunch_break_min'] = &$this->lunch_break_min;

		// daily_min
		$this->daily_min = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_daily_min', 'daily_min', '`daily_min`', '`daily_min`', 2, -1, FALSE, '`daily_min`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->daily_min->Nullable = FALSE; // NOT NULL field
		$this->daily_min->Required = TRUE; // Required field
		$this->daily_min->Sortable = TRUE; // Allow sort
		$this->daily_min->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['daily_min'] = &$this->daily_min;

		// weekly_off
		$this->weekly_off = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_weekly_off', 'weekly_off', '`weekly_off`', '`weekly_off`', 200, -1, FALSE, '`weekly_off`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->weekly_off->Nullable = FALSE; // NOT NULL field
		$this->weekly_off->Required = TRUE; // Required field
		$this->weekly_off->Sortable = TRUE; // Allow sort
		$this->weekly_off->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->weekly_off->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->weekly_off->Lookup = new Lookup('weekly_off', 'payroll_fix_details', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->weekly_off->OptionCount = 7;
		$this->fields['weekly_off'] = &$this->weekly_off;

		// offsets_benifit_min
		$this->offsets_benifit_min = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_offsets_benifit_min', 'offsets_benifit_min', '`offsets_benifit_min`', '`offsets_benifit_min`', 2, -1, FALSE, '`offsets_benifit_min`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->offsets_benifit_min->Nullable = FALSE; // NOT NULL field
		$this->offsets_benifit_min->Required = TRUE; // Required field
		$this->offsets_benifit_min->Sortable = TRUE; // Allow sort
		$this->offsets_benifit_min->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['offsets_benifit_min'] = &$this->offsets_benifit_min;

		// next_increment
		$this->next_increment = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_next_increment', 'next_increment', '`next_increment`', CastDateFieldForLike('`next_increment`', 0, "DB"), 133, 0, FALSE, '`next_increment`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->next_increment->Nullable = FALSE; // NOT NULL field
		$this->next_increment->Required = TRUE; // Required field
		$this->next_increment->Sortable = TRUE; // Allow sort
		$this->next_increment->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['next_increment'] = &$this->next_increment;

		// current_payroll_startdate
		$this->current_payroll_startdate = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_current_payroll_startdate', 'current_payroll_startdate', '`current_payroll_startdate`', CastDateFieldForLike('`current_payroll_startdate`', 0, "DB"), 133, 0, FALSE, '`current_payroll_startdate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->current_payroll_startdate->Nullable = FALSE; // NOT NULL field
		$this->current_payroll_startdate->Required = TRUE; // Required field
		$this->current_payroll_startdate->Sortable = TRUE; // Allow sort
		$this->current_payroll_startdate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['current_payroll_startdate'] = &$this->current_payroll_startdate;

		// base_salary
		$this->base_salary = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_base_salary', 'base_salary', '`base_salary`', '`base_salary`', 131, -1, FALSE, '`base_salary`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->base_salary->Nullable = FALSE; // NOT NULL field
		$this->base_salary->Required = TRUE; // Required field
		$this->base_salary->Sortable = TRUE; // Allow sort
		$this->base_salary->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['base_salary'] = &$this->base_salary;

		// additional_benefits
		$this->additional_benefits = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_additional_benefits', 'additional_benefits', '`additional_benefits`', '`additional_benefits`', 200, -1, FALSE, '`additional_benefits`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->additional_benefits->Required = TRUE; // Required field
		$this->additional_benefits->Sortable = TRUE; // Allow sort
		$this->additional_benefits->SelectMultiple = TRUE; // Multiple select
		$this->fields['additional_benefits'] = &$this->additional_benefits;

		// extra_min_plan
		$this->extra_min_plan = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_extra_min_plan', 'extra_min_plan', '`extra_min_plan`', '`extra_min_plan`', 2, -1, FALSE, '`extra_min_plan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->extra_min_plan->Nullable = FALSE; // NOT NULL field
		$this->extra_min_plan->Required = TRUE; // Required field
		$this->extra_min_plan->Sortable = TRUE; // Allow sort
		$this->extra_min_plan->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->extra_min_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->extra_min_plan->Lookup = new Lookup('extra_min_plan', 'payroll_fix_details', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->extra_min_plan->OptionCount = 2;
		$this->extra_min_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['extra_min_plan'] = &$this->extra_min_plan;

		// office_holidays
		$this->office_holidays = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_office_holidays', 'office_holidays', '`office_holidays`', '`office_holidays`', 16, -1, FALSE, '`office_holidays`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->office_holidays->Nullable = FALSE; // NOT NULL field
		$this->office_holidays->Required = TRUE; // Required field
		$this->office_holidays->Sortable = TRUE; // Allow sort
		$this->office_holidays->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->office_holidays->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->office_holidays->Lookup = new Lookup('office_holidays', 'payroll_fix_details', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->office_holidays->OptionCount = 2;
		$this->office_holidays->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['office_holidays'] = &$this->office_holidays;

		// paid_annual_leave
		$this->paid_annual_leave = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_paid_annual_leave', 'paid_annual_leave', '`paid_annual_leave`', '`paid_annual_leave`', 16, -1, FALSE, '`paid_annual_leave`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->paid_annual_leave->Nullable = FALSE; // NOT NULL field
		$this->paid_annual_leave->Required = TRUE; // Required field
		$this->paid_annual_leave->Sortable = TRUE; // Allow sort
		$this->paid_annual_leave->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['paid_annual_leave'] = &$this->paid_annual_leave;

		// employee_pf
		$this->employee_pf = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_employee_pf', 'employee_pf', '`employee_pf`', '`employee_pf`', 2, -1, FALSE, '`employee_pf`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->employee_pf->Nullable = FALSE; // NOT NULL field
		$this->employee_pf->Required = TRUE; // Required field
		$this->employee_pf->Sortable = TRUE; // Allow sort
		$this->employee_pf->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->employee_pf->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->employee_pf->Lookup = new Lookup('employee_pf', 'payroll_fix_details', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->employee_pf->OptionCount = 2;
		$this->employee_pf->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['employee_pf'] = &$this->employee_pf;

		// operator
		$this->operator = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Nullable = FALSE; // NOT NULL field
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// employee_am_id
		$this->employee_am_id = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_employee_am_id', 'employee_am_id', '`employee_am_id`', '`employee_am_id`', 2, -1, FALSE, '`employee_am_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->employee_am_id->Sortable = TRUE; // Allow sort
		$this->employee_am_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['employee_am_id'] = &$this->employee_am_id;

		// job_title
		$this->job_title = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_job_title', 'job_title', '`job_title`', '`job_title`', 200, -1, FALSE, '`job_title`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->job_title->Nullable = FALSE; // NOT NULL field
		$this->job_title->Required = TRUE; // Required field
		$this->job_title->Sortable = TRUE; // Allow sort
		$this->fields['job_title'] = &$this->job_title;

		// month_min
		$this->month_min = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_month_min', 'month_min', '`month_min`', '`month_min`', 2, -1, FALSE, '`month_min`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->month_min->Sortable = TRUE; // Allow sort
		$this->month_min->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['month_min'] = &$this->month_min;

		// calculation_plan
		$this->calculation_plan = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_calculation_plan', 'calculation_plan', '`calculation_plan`', '`calculation_plan`', 2, -1, FALSE, '`calculation_plan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->calculation_plan->Nullable = FALSE; // NOT NULL field
		$this->calculation_plan->Sortable = TRUE; // Allow sort
		$this->calculation_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['calculation_plan'] = &$this->calculation_plan;

		// status
		$this->status = new DbField('payroll_fix_details', 'payroll_fix_details', 'x_status', 'status', '`status`', '`status`', 2, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`payroll_fix_details`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->employee_id->DbValue = $row['employee_id'];
		$this->remarks->DbValue = $row['remarks'];
		$this->daily_in->DbValue = $row['daily_in'];
		$this->daily_out->DbValue = $row['daily_out'];
		$this->lunch_break_min->DbValue = $row['lunch_break_min'];
		$this->daily_min->DbValue = $row['daily_min'];
		$this->weekly_off->DbValue = $row['weekly_off'];
		$this->offsets_benifit_min->DbValue = $row['offsets_benifit_min'];
		$this->next_increment->DbValue = $row['next_increment'];
		$this->current_payroll_startdate->DbValue = $row['current_payroll_startdate'];
		$this->base_salary->DbValue = $row['base_salary'];
		$this->additional_benefits->DbValue = $row['additional_benefits'];
		$this->extra_min_plan->DbValue = $row['extra_min_plan'];
		$this->office_holidays->DbValue = $row['office_holidays'];
		$this->paid_annual_leave->DbValue = $row['paid_annual_leave'];
		$this->employee_pf->DbValue = $row['employee_pf'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->employee_am_id->DbValue = $row['employee_am_id'];
		$this->job_title->DbValue = $row['job_title'];
		$this->month_min->DbValue = $row['month_min'];
		$this->calculation_plan->DbValue = $row['calculation_plan'];
		$this->status->DbValue = $row['status'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "payroll_fix_detailslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "payroll_fix_detailsview.php")
			return $Language->phrase("View");
		elseif ($pageName == "payroll_fix_detailsedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "payroll_fix_detailsadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "payroll_fix_detailslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("payroll_fix_detailsview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("payroll_fix_detailsview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "payroll_fix_detailsadd.php?" . $this->getUrlParm($parm);
		else
			$url = "payroll_fix_detailsadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("payroll_fix_detailsedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("payroll_fix_detailsadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("payroll_fix_detailsdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->employee_id->setDbValue($rs->fields('employee_id'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->daily_in->setDbValue($rs->fields('daily_in'));
		$this->daily_out->setDbValue($rs->fields('daily_out'));
		$this->lunch_break_min->setDbValue($rs->fields('lunch_break_min'));
		$this->daily_min->setDbValue($rs->fields('daily_min'));
		$this->weekly_off->setDbValue($rs->fields('weekly_off'));
		$this->offsets_benifit_min->setDbValue($rs->fields('offsets_benifit_min'));
		$this->next_increment->setDbValue($rs->fields('next_increment'));
		$this->current_payroll_startdate->setDbValue($rs->fields('current_payroll_startdate'));
		$this->base_salary->setDbValue($rs->fields('base_salary'));
		$this->additional_benefits->setDbValue($rs->fields('additional_benefits'));
		$this->extra_min_plan->setDbValue($rs->fields('extra_min_plan'));
		$this->office_holidays->setDbValue($rs->fields('office_holidays'));
		$this->paid_annual_leave->setDbValue($rs->fields('paid_annual_leave'));
		$this->employee_pf->setDbValue($rs->fields('employee_pf'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->employee_am_id->setDbValue($rs->fields('employee_am_id'));
		$this->job_title->setDbValue($rs->fields('job_title'));
		$this->month_min->setDbValue($rs->fields('month_min'));
		$this->calculation_plan->setDbValue($rs->fields('calculation_plan'));
		$this->status->setDbValue($rs->fields('status'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// employee_id
		// remarks
		// daily_in
		// daily_out
		// lunch_break_min
		// daily_min
		// weekly_off
		// offsets_benifit_min
		// next_increment
		// current_payroll_startdate
		// base_salary
		// additional_benefits
		// extra_min_plan
		// office_holidays
		// paid_annual_leave
		// employee_pf
		// operator
		// datetime
		// employee_am_id
		// job_title
		// month_min
		// calculation_plan
		// status
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// employee_id
		$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
		$this->employee_id->ViewValue = FormatNumber($this->employee_id->ViewValue, 0, -2, -2, -2);
		$this->employee_id->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// daily_in
		$this->daily_in->ViewValue = $this->daily_in->CurrentValue;
		$this->daily_in->ViewValue = FormatDateTime($this->daily_in->ViewValue, 4);
		$this->daily_in->ViewCustomAttributes = "";

		// daily_out
		$this->daily_out->ViewValue = $this->daily_out->CurrentValue;
		$this->daily_out->ViewValue = FormatDateTime($this->daily_out->ViewValue, 4);
		$this->daily_out->ViewCustomAttributes = "";

		// lunch_break_min
		$this->lunch_break_min->ViewValue = $this->lunch_break_min->CurrentValue;
		$this->lunch_break_min->ViewValue = FormatNumber($this->lunch_break_min->ViewValue, 0, -2, -2, -2);
		$this->lunch_break_min->ViewCustomAttributes = "";

		// daily_min
		$this->daily_min->ViewValue = $this->daily_min->CurrentValue;
		$this->daily_min->ViewValue = FormatNumber($this->daily_min->ViewValue, 0, -2, -2, -2);
		$this->daily_min->ViewCustomAttributes = "";

		// weekly_off
		if (strval($this->weekly_off->CurrentValue) <> "") {
			$this->weekly_off->ViewValue = $this->weekly_off->optionCaption($this->weekly_off->CurrentValue);
		} else {
			$this->weekly_off->ViewValue = NULL;
		}
		$this->weekly_off->ViewCustomAttributes = "";

		// offsets_benifit_min
		$this->offsets_benifit_min->ViewValue = $this->offsets_benifit_min->CurrentValue;
		$this->offsets_benifit_min->ViewValue = FormatNumber($this->offsets_benifit_min->ViewValue, 0, -2, -2, -2);
		$this->offsets_benifit_min->ViewCustomAttributes = "";

		// next_increment
		$this->next_increment->ViewValue = $this->next_increment->CurrentValue;
		$this->next_increment->ViewValue = FormatDateTime($this->next_increment->ViewValue, 0);
		$this->next_increment->ViewCustomAttributes = "";

		// current_payroll_startdate
		$this->current_payroll_startdate->ViewValue = $this->current_payroll_startdate->CurrentValue;
		$this->current_payroll_startdate->ViewValue = FormatDateTime($this->current_payroll_startdate->ViewValue, 0);
		$this->current_payroll_startdate->ViewCustomAttributes = "";

		// base_salary
		$this->base_salary->ViewValue = $this->base_salary->CurrentValue;
		$this->base_salary->ViewValue = FormatNumber($this->base_salary->ViewValue, 2, -2, -2, -2);
		$this->base_salary->ViewCustomAttributes = "";

		// additional_benefits
		$this->additional_benefits->ViewCustomAttributes = "";

		// extra_min_plan
		if (strval($this->extra_min_plan->CurrentValue) <> "") {
			$this->extra_min_plan->ViewValue = $this->extra_min_plan->optionCaption($this->extra_min_plan->CurrentValue);
		} else {
			$this->extra_min_plan->ViewValue = NULL;
		}
		$this->extra_min_plan->ViewCustomAttributes = "";

		// office_holidays
		if (strval($this->office_holidays->CurrentValue) <> "") {
			$this->office_holidays->ViewValue = $this->office_holidays->optionCaption($this->office_holidays->CurrentValue);
		} else {
			$this->office_holidays->ViewValue = NULL;
		}
		$this->office_holidays->ViewCustomAttributes = "";

		// paid_annual_leave
		$this->paid_annual_leave->ViewValue = $this->paid_annual_leave->CurrentValue;
		$this->paid_annual_leave->ViewValue = FormatNumber($this->paid_annual_leave->ViewValue, 0, -2, -2, -2);
		$this->paid_annual_leave->ViewCustomAttributes = "";

		// employee_pf
		if (strval($this->employee_pf->CurrentValue) <> "") {
			$this->employee_pf->ViewValue = $this->employee_pf->optionCaption($this->employee_pf->CurrentValue);
		} else {
			$this->employee_pf->ViewValue = NULL;
		}
		$this->employee_pf->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`activated`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// employee_am_id
		$this->employee_am_id->ViewValue = $this->employee_am_id->CurrentValue;
		$this->employee_am_id->ViewValue = FormatNumber($this->employee_am_id->ViewValue, 0, -2, -2, -2);
		$this->employee_am_id->ViewCustomAttributes = "";

		// job_title
		$this->job_title->ViewValue = $this->job_title->CurrentValue;
		$this->job_title->ViewCustomAttributes = "";

		// month_min
		$this->month_min->ViewValue = $this->month_min->CurrentValue;
		$this->month_min->ViewValue = FormatNumber($this->month_min->ViewValue, 0, -2, -2, -2);
		$this->month_min->ViewCustomAttributes = "";

		// calculation_plan
		$this->calculation_plan->ViewValue = $this->calculation_plan->CurrentValue;
		$this->calculation_plan->ViewValue = FormatNumber($this->calculation_plan->ViewValue, 0, -2, -2, -2);
		$this->calculation_plan->ViewCustomAttributes = "";

		// status
		$this->status->ViewValue = $this->status->CurrentValue;
		$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
		$this->status->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// employee_id
		$this->employee_id->LinkCustomAttributes = "";
		$this->employee_id->HrefValue = "";
		$this->employee_id->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// daily_in
		$this->daily_in->LinkCustomAttributes = "";
		$this->daily_in->HrefValue = "";
		$this->daily_in->TooltipValue = "";

		// daily_out
		$this->daily_out->LinkCustomAttributes = "";
		$this->daily_out->HrefValue = "";
		$this->daily_out->TooltipValue = "";

		// lunch_break_min
		$this->lunch_break_min->LinkCustomAttributes = "";
		$this->lunch_break_min->HrefValue = "";
		$this->lunch_break_min->TooltipValue = "";

		// daily_min
		$this->daily_min->LinkCustomAttributes = "";
		$this->daily_min->HrefValue = "";
		$this->daily_min->TooltipValue = "";

		// weekly_off
		$this->weekly_off->LinkCustomAttributes = "";
		$this->weekly_off->HrefValue = "";
		$this->weekly_off->TooltipValue = "";

		// offsets_benifit_min
		$this->offsets_benifit_min->LinkCustomAttributes = "";
		$this->offsets_benifit_min->HrefValue = "";
		$this->offsets_benifit_min->TooltipValue = "";

		// next_increment
		$this->next_increment->LinkCustomAttributes = "";
		$this->next_increment->HrefValue = "";
		$this->next_increment->TooltipValue = "";

		// current_payroll_startdate
		$this->current_payroll_startdate->LinkCustomAttributes = "";
		$this->current_payroll_startdate->HrefValue = "";
		$this->current_payroll_startdate->TooltipValue = "";

		// base_salary
		$this->base_salary->LinkCustomAttributes = "";
		$this->base_salary->HrefValue = "";
		$this->base_salary->TooltipValue = "";

		// additional_benefits
		$this->additional_benefits->LinkCustomAttributes = "";
		$this->additional_benefits->HrefValue = "";
		$this->additional_benefits->TooltipValue = "";

		// extra_min_plan
		$this->extra_min_plan->LinkCustomAttributes = "";
		$this->extra_min_plan->HrefValue = "";
		$this->extra_min_plan->TooltipValue = "";

		// office_holidays
		$this->office_holidays->LinkCustomAttributes = "";
		$this->office_holidays->HrefValue = "";
		$this->office_holidays->TooltipValue = "";

		// paid_annual_leave
		$this->paid_annual_leave->LinkCustomAttributes = "";
		$this->paid_annual_leave->HrefValue = "";
		$this->paid_annual_leave->TooltipValue = "";

		// employee_pf
		$this->employee_pf->LinkCustomAttributes = "";
		$this->employee_pf->HrefValue = "";
		$this->employee_pf->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// employee_am_id
		$this->employee_am_id->LinkCustomAttributes = "";
		$this->employee_am_id->HrefValue = "";
		$this->employee_am_id->TooltipValue = "";

		// job_title
		$this->job_title->LinkCustomAttributes = "";
		$this->job_title->HrefValue = "";
		$this->job_title->TooltipValue = "";

		// month_min
		$this->month_min->LinkCustomAttributes = "";
		$this->month_min->HrefValue = "";
		$this->month_min->TooltipValue = "";

		// calculation_plan
		$this->calculation_plan->LinkCustomAttributes = "";
		$this->calculation_plan->HrefValue = "";
		$this->calculation_plan->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// employee_id
		$this->employee_id->EditAttrs["class"] = "form-control";
		$this->employee_id->EditCustomAttributes = "";
		$this->employee_id->EditValue = $this->employee_id->CurrentValue;
		$this->employee_id->PlaceHolder = RemoveHtml($this->employee_id->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// daily_in
		$this->daily_in->EditAttrs["class"] = "form-control";
		$this->daily_in->EditCustomAttributes = "";
		$this->daily_in->EditValue = $this->daily_in->CurrentValue;
		$this->daily_in->PlaceHolder = RemoveHtml($this->daily_in->caption());

		// daily_out
		$this->daily_out->EditAttrs["class"] = "form-control";
		$this->daily_out->EditCustomAttributes = "";
		$this->daily_out->EditValue = $this->daily_out->CurrentValue;
		$this->daily_out->PlaceHolder = RemoveHtml($this->daily_out->caption());

		// lunch_break_min
		$this->lunch_break_min->EditAttrs["class"] = "form-control";
		$this->lunch_break_min->EditCustomAttributes = "";
		$this->lunch_break_min->EditValue = $this->lunch_break_min->CurrentValue;
		$this->lunch_break_min->PlaceHolder = RemoveHtml($this->lunch_break_min->caption());

		// daily_min
		$this->daily_min->EditAttrs["class"] = "form-control";
		$this->daily_min->EditCustomAttributes = "";
		$this->daily_min->EditValue = $this->daily_min->CurrentValue;
		$this->daily_min->PlaceHolder = RemoveHtml($this->daily_min->caption());

		// weekly_off
		$this->weekly_off->EditAttrs["class"] = "form-control";
		$this->weekly_off->EditCustomAttributes = "";
		$this->weekly_off->EditValue = $this->weekly_off->options(TRUE);

		// offsets_benifit_min
		$this->offsets_benifit_min->EditAttrs["class"] = "form-control";
		$this->offsets_benifit_min->EditCustomAttributes = "";
		$this->offsets_benifit_min->EditValue = $this->offsets_benifit_min->CurrentValue;
		$this->offsets_benifit_min->PlaceHolder = RemoveHtml($this->offsets_benifit_min->caption());

		// next_increment
		$this->next_increment->EditAttrs["class"] = "form-control";
		$this->next_increment->EditCustomAttributes = "";
		$this->next_increment->EditValue = FormatDateTime($this->next_increment->CurrentValue, 8);
		$this->next_increment->PlaceHolder = RemoveHtml($this->next_increment->caption());

		// current_payroll_startdate
		$this->current_payroll_startdate->EditAttrs["class"] = "form-control";
		$this->current_payroll_startdate->EditCustomAttributes = "";
		$this->current_payroll_startdate->EditValue = FormatDateTime($this->current_payroll_startdate->CurrentValue, 8);
		$this->current_payroll_startdate->PlaceHolder = RemoveHtml($this->current_payroll_startdate->caption());

		// base_salary
		$this->base_salary->EditAttrs["class"] = "form-control";
		$this->base_salary->EditCustomAttributes = "";
		$this->base_salary->EditValue = $this->base_salary->CurrentValue;
		$this->base_salary->PlaceHolder = RemoveHtml($this->base_salary->caption());
		if (strval($this->base_salary->EditValue) <> "" && is_numeric($this->base_salary->EditValue))
			$this->base_salary->EditValue = FormatNumber($this->base_salary->EditValue, -2, -2, -2, -2);

		// additional_benefits
		$this->additional_benefits->EditAttrs["class"] = "form-control";
		$this->additional_benefits->EditCustomAttributes = "";

		// extra_min_plan
		$this->extra_min_plan->EditAttrs["class"] = "form-control";
		$this->extra_min_plan->EditCustomAttributes = "";
		$this->extra_min_plan->EditValue = $this->extra_min_plan->options(TRUE);

		// office_holidays
		$this->office_holidays->EditAttrs["class"] = "form-control";
		$this->office_holidays->EditCustomAttributes = "";
		$this->office_holidays->EditValue = $this->office_holidays->options(TRUE);

		// paid_annual_leave
		$this->paid_annual_leave->EditAttrs["class"] = "form-control";
		$this->paid_annual_leave->EditCustomAttributes = "";
		$this->paid_annual_leave->EditValue = $this->paid_annual_leave->CurrentValue;
		$this->paid_annual_leave->PlaceHolder = RemoveHtml($this->paid_annual_leave->caption());

		// employee_pf
		$this->employee_pf->EditAttrs["class"] = "form-control";
		$this->employee_pf->EditCustomAttributes = "";
		$this->employee_pf->EditValue = $this->employee_pf->options(TRUE);

		// operator
		// datetime
		// employee_am_id

		$this->employee_am_id->EditAttrs["class"] = "form-control";
		$this->employee_am_id->EditCustomAttributes = "";
		$this->employee_am_id->EditValue = $this->employee_am_id->CurrentValue;
		$this->employee_am_id->PlaceHolder = RemoveHtml($this->employee_am_id->caption());

		// job_title
		$this->job_title->EditAttrs["class"] = "form-control";
		$this->job_title->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->job_title->CurrentValue = HtmlDecode($this->job_title->CurrentValue);
		$this->job_title->EditValue = $this->job_title->CurrentValue;
		$this->job_title->PlaceHolder = RemoveHtml($this->job_title->caption());

		// month_min
		$this->month_min->EditAttrs["class"] = "form-control";
		$this->month_min->EditCustomAttributes = "";
		$this->month_min->EditValue = $this->month_min->CurrentValue;
		$this->month_min->PlaceHolder = RemoveHtml($this->month_min->caption());

		// calculation_plan
		$this->calculation_plan->EditAttrs["class"] = "form-control";
		$this->calculation_plan->EditCustomAttributes = "";
		$this->calculation_plan->EditValue = $this->calculation_plan->CurrentValue;
		$this->calculation_plan->PlaceHolder = RemoveHtml($this->calculation_plan->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->CurrentValue;
		$this->status->PlaceHolder = RemoveHtml($this->status->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->employee_id);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->daily_in);
					$doc->exportCaption($this->daily_out);
					$doc->exportCaption($this->lunch_break_min);
					$doc->exportCaption($this->daily_min);
					$doc->exportCaption($this->weekly_off);
					$doc->exportCaption($this->offsets_benifit_min);
					$doc->exportCaption($this->next_increment);
					$doc->exportCaption($this->current_payroll_startdate);
					$doc->exportCaption($this->base_salary);
					$doc->exportCaption($this->additional_benefits);
					$doc->exportCaption($this->extra_min_plan);
					$doc->exportCaption($this->office_holidays);
					$doc->exportCaption($this->paid_annual_leave);
					$doc->exportCaption($this->employee_pf);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->employee_am_id);
					$doc->exportCaption($this->job_title);
					$doc->exportCaption($this->month_min);
					$doc->exportCaption($this->calculation_plan);
					$doc->exportCaption($this->status);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->employee_id);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->daily_in);
					$doc->exportCaption($this->daily_out);
					$doc->exportCaption($this->lunch_break_min);
					$doc->exportCaption($this->daily_min);
					$doc->exportCaption($this->weekly_off);
					$doc->exportCaption($this->offsets_benifit_min);
					$doc->exportCaption($this->next_increment);
					$doc->exportCaption($this->current_payroll_startdate);
					$doc->exportCaption($this->base_salary);
					$doc->exportCaption($this->additional_benefits);
					$doc->exportCaption($this->extra_min_plan);
					$doc->exportCaption($this->office_holidays);
					$doc->exportCaption($this->paid_annual_leave);
					$doc->exportCaption($this->employee_pf);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->employee_am_id);
					$doc->exportCaption($this->job_title);
					$doc->exportCaption($this->month_min);
					$doc->exportCaption($this->calculation_plan);
					$doc->exportCaption($this->status);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->employee_id);
						$doc->exportField($this->remarks);
						$doc->exportField($this->daily_in);
						$doc->exportField($this->daily_out);
						$doc->exportField($this->lunch_break_min);
						$doc->exportField($this->daily_min);
						$doc->exportField($this->weekly_off);
						$doc->exportField($this->offsets_benifit_min);
						$doc->exportField($this->next_increment);
						$doc->exportField($this->current_payroll_startdate);
						$doc->exportField($this->base_salary);
						$doc->exportField($this->additional_benefits);
						$doc->exportField($this->extra_min_plan);
						$doc->exportField($this->office_holidays);
						$doc->exportField($this->paid_annual_leave);
						$doc->exportField($this->employee_pf);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->employee_am_id);
						$doc->exportField($this->job_title);
						$doc->exportField($this->month_min);
						$doc->exportField($this->calculation_plan);
						$doc->exportField($this->status);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->employee_id);
						$doc->exportField($this->remarks);
						$doc->exportField($this->daily_in);
						$doc->exportField($this->daily_out);
						$doc->exportField($this->lunch_break_min);
						$doc->exportField($this->daily_min);
						$doc->exportField($this->weekly_off);
						$doc->exportField($this->offsets_benifit_min);
						$doc->exportField($this->next_increment);
						$doc->exportField($this->current_payroll_startdate);
						$doc->exportField($this->base_salary);
						$doc->exportField($this->additional_benefits);
						$doc->exportField($this->extra_min_plan);
						$doc->exportField($this->office_holidays);
						$doc->exportField($this->paid_annual_leave);
						$doc->exportField($this->employee_pf);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->employee_am_id);
						$doc->exportField($this->job_title);
						$doc->exportField($this->month_min);
						$doc->exportField($this->calculation_plan);
						$doc->exportField($this->status);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>