<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for personal_info
 */
class personal_info extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $formal_name;
	public $gender;
	public $mobile;
	public $_email;
	public $address;
	public $country;
	public $state;
	public $city;
	public $city_name;
	public $dob;
	public $dom;
	public $marital_status;
	public $spouse_details;
	public $image;
	public $father_name;
	public $mother_name;
	public $permanent_address;
	public $mobile_other;
	public $mobile_family;
	public $emergency_details;
	public $annual_income;
	public $work_details;
	public $status;
	public $gst;
	public $aadhaar_no;
	public $pan_no;
	public $id_proof;
	public $reference_details;
	public $other_details;
	public $bank_name;
	public $bank_ifsc_code;
	public $bank_account_no;
	public $operator;
	public $datetime;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'personal_info';
		$this->TableName = 'personal_info';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`personal_info`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('personal_info', 'personal_info', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->fields['id'] = &$this->id;

		// formal_name
		$this->formal_name = new DbField('personal_info', 'personal_info', 'x_formal_name', 'formal_name', '`formal_name`', '`formal_name`', 200, -1, FALSE, '`formal_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->formal_name->Sortable = TRUE; // Allow sort
		$this->fields['formal_name'] = &$this->formal_name;

		// gender
		$this->gender = new DbField('personal_info', 'personal_info', 'x_gender', 'gender', '`gender`', '`gender`', 17, -1, FALSE, '`gender`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->gender->Sortable = TRUE; // Allow sort
		$this->gender->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->gender->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->gender->Lookup = new Lookup('gender', 'personal_info', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->gender->OptionCount = 4;
		$this->gender->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['gender'] = &$this->gender;

		// mobile
		$this->mobile = new DbField('personal_info', 'personal_info', 'x_mobile', 'mobile', '`mobile`', '`mobile`', 21, -1, FALSE, '`mobile`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mobile->Sortable = TRUE; // Allow sort
		$this->mobile->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['mobile'] = &$this->mobile;

		// email
		$this->_email = new DbField('personal_info', 'personal_info', 'x__email', 'email', '`email`', '`email`', 200, -1, FALSE, '`email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_email->Sortable = TRUE; // Allow sort
		$this->_email->DefaultErrorMessage = $Language->phrase("IncorrectEmail");
		$this->fields['email'] = &$this->_email;

		// address
		$this->address = new DbField('personal_info', 'personal_info', 'x_address', 'address', '`address`', '`address`', 200, -1, FALSE, '`address`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->address->Sortable = TRUE; // Allow sort
		$this->fields['address'] = &$this->address;

		// country
		$this->country = new DbField('personal_info', 'personal_info', 'x_country', 'country', '`country`', '`country`', 18, -1, FALSE, '`country`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->country->Sortable = TRUE; // Allow sort
		$this->country->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->country->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->country->Lookup = new Lookup('country', 'world_country', FALSE, 'id', ["name","","",""], [], ["x_state"], [], [], [], [], '`name` ASC', '');
		$this->country->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['country'] = &$this->country;

		// state
		$this->state = new DbField('personal_info', 'personal_info', 'x_state', 'state', '`state`', '`state`', 18, -1, FALSE, '`state`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->state->Sortable = TRUE; // Allow sort
		$this->state->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->state->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->state->Lookup = new Lookup('state', 'world_state', FALSE, 'id', ["name","","",""], ["x_country"], ["x_city"], ["country_id"], ["x_country_id"], [], [], '`name` ASC', '');
		$this->state->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['state'] = &$this->state;

		// city
		$this->city = new DbField('personal_info', 'personal_info', 'x_city', 'city', '`city`', '`city`', 2, -1, FALSE, '`city`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->city->Sortable = TRUE; // Allow sort
		$this->city->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->city->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->city->Lookup = new Lookup('city', 'world_city', FALSE, 'id', ["name","","",""], ["x_state"], [], ["state_id"], ["x_state_id"], ["name"], ["x_city_name"], '`name` ASC', '');
		$this->city->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['city'] = &$this->city;

		// city_name
		$this->city_name = new DbField('personal_info', 'personal_info', 'x_city_name', 'city_name', '`city_name`', '`city_name`', 200, -1, FALSE, '`city_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->city_name->Sortable = TRUE; // Allow sort
		$this->fields['city_name'] = &$this->city_name;

		// dob
		$this->dob = new DbField('personal_info', 'personal_info', 'x_dob', 'dob', '`dob`', CastDateFieldForLike('`dob`', 2, "DB"), 133, 2, FALSE, '`dob`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dob->Sortable = TRUE; // Allow sort
		$this->dob->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dob'] = &$this->dob;

		// dom
		$this->dom = new DbField('personal_info', 'personal_info', 'x_dom', 'dom', '`dom`', CastDateFieldForLike('`dom`', 2, "DB"), 133, 2, FALSE, '`dom`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dom->Sortable = TRUE; // Allow sort
		$this->dom->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dom'] = &$this->dom;

		// marital_status
		$this->marital_status = new DbField('personal_info', 'personal_info', 'x_marital_status', 'marital_status', '`marital_status`', '`marital_status`', 18, -1, FALSE, '`marital_status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->marital_status->Sortable = TRUE; // Allow sort
		$this->marital_status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->marital_status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->marital_status->Lookup = new Lookup('marital_status', 'personal_info', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->marital_status->OptionCount = 3;
		$this->marital_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['marital_status'] = &$this->marital_status;

		// spouse_details
		$this->spouse_details = new DbField('personal_info', 'personal_info', 'x_spouse_details', 'spouse_details', '`spouse_details`', '`spouse_details`', 200, -1, FALSE, '`spouse_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->spouse_details->Sortable = TRUE; // Allow sort
		$this->fields['spouse_details'] = &$this->spouse_details;

		// image
		$this->image = new DbField('personal_info', 'personal_info', 'x_image', 'image', '`image`', '`image`', 200, -1, TRUE, '`image`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->image->Sortable = TRUE; // Allow sort
		$this->fields['image'] = &$this->image;

		// father_name
		$this->father_name = new DbField('personal_info', 'personal_info', 'x_father_name', 'father_name', '`father_name`', '`father_name`', 200, -1, FALSE, '`father_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->father_name->Sortable = TRUE; // Allow sort
		$this->fields['father_name'] = &$this->father_name;

		// mother_name
		$this->mother_name = new DbField('personal_info', 'personal_info', 'x_mother_name', 'mother_name', '`mother_name`', '`mother_name`', 200, -1, FALSE, '`mother_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mother_name->Sortable = TRUE; // Allow sort
		$this->fields['mother_name'] = &$this->mother_name;

		// permanent_address
		$this->permanent_address = new DbField('personal_info', 'personal_info', 'x_permanent_address', 'permanent_address', '`permanent_address`', '`permanent_address`', 200, -1, FALSE, '`permanent_address`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->permanent_address->Sortable = TRUE; // Allow sort
		$this->fields['permanent_address'] = &$this->permanent_address;

		// mobile_other
		$this->mobile_other = new DbField('personal_info', 'personal_info', 'x_mobile_other', 'mobile_other', '`mobile_other`', '`mobile_other`', 200, -1, FALSE, '`mobile_other`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mobile_other->Sortable = TRUE; // Allow sort
		$this->fields['mobile_other'] = &$this->mobile_other;

		// mobile_family
		$this->mobile_family = new DbField('personal_info', 'personal_info', 'x_mobile_family', 'mobile_family', '`mobile_family`', '`mobile_family`', 200, -1, FALSE, '`mobile_family`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mobile_family->Sortable = TRUE; // Allow sort
		$this->fields['mobile_family'] = &$this->mobile_family;

		// emergency_details
		$this->emergency_details = new DbField('personal_info', 'personal_info', 'x_emergency_details', 'emergency_details', '`emergency_details`', '`emergency_details`', 200, -1, FALSE, '`emergency_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->emergency_details->Sortable = TRUE; // Allow sort
		$this->fields['emergency_details'] = &$this->emergency_details;

		// annual_income
		$this->annual_income = new DbField('personal_info', 'personal_info', 'x_annual_income', 'annual_income', '`annual_income`', '`annual_income`', 3, -1, FALSE, '`annual_income`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->annual_income->Sortable = TRUE; // Allow sort
		$this->annual_income->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['annual_income'] = &$this->annual_income;

		// work_details
		$this->work_details = new DbField('personal_info', 'personal_info', 'x_work_details', 'work_details', '`work_details`', '`work_details`', 200, -1, FALSE, '`work_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->work_details->Sortable = TRUE; // Allow sort
		$this->fields['work_details'] = &$this->work_details;

		// status
		$this->status = new DbField('personal_info', 'personal_info', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'personal_info', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 2;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// gst
		$this->gst = new DbField('personal_info', 'personal_info', 'x_gst', 'gst', '`gst`', '`gst`', 200, -1, FALSE, '`gst`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->gst->Sortable = TRUE; // Allow sort
		$this->fields['gst'] = &$this->gst;

		// aadhaar_no
		$this->aadhaar_no = new DbField('personal_info', 'personal_info', 'x_aadhaar_no', 'aadhaar_no', '`aadhaar_no`', '`aadhaar_no`', 200, -1, FALSE, '`aadhaar_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->aadhaar_no->Sortable = TRUE; // Allow sort
		$this->aadhaar_no->DefaultErrorMessage = $Language->phrase("IncorrectField");
		$this->fields['aadhaar_no'] = &$this->aadhaar_no;

		// pan_no
		$this->pan_no = new DbField('personal_info', 'personal_info', 'x_pan_no', 'pan_no', '`pan_no`', '`pan_no`', 200, -1, FALSE, '`pan_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pan_no->Sortable = TRUE; // Allow sort
		$this->pan_no->DefaultErrorMessage = $Language->phrase("IncorrectField");
		$this->fields['pan_no'] = &$this->pan_no;

		// id_proof
		$this->id_proof = new DbField('personal_info', 'personal_info', 'x_id_proof', 'id_proof', '`id_proof`', '`id_proof`', 200, -1, TRUE, '`id_proof`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->id_proof->Sortable = TRUE; // Allow sort
		$this->id_proof->UploadMultiple = TRUE;
		$this->id_proof->Upload->UploadMultiple = TRUE;
		$this->id_proof->UploadMaxFileCount = 0;
		$this->fields['id_proof'] = &$this->id_proof;

		// reference_details
		$this->reference_details = new DbField('personal_info', 'personal_info', 'x_reference_details', 'reference_details', '`reference_details`', '`reference_details`', 200, -1, FALSE, '`reference_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->reference_details->Sortable = TRUE; // Allow sort
		$this->fields['reference_details'] = &$this->reference_details;

		// other_details
		$this->other_details = new DbField('personal_info', 'personal_info', 'x_other_details', 'other_details', '`other_details`', '`other_details`', 201, -1, FALSE, '`other_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->other_details->Sortable = TRUE; // Allow sort
		$this->fields['other_details'] = &$this->other_details;

		// bank_name
		$this->bank_name = new DbField('personal_info', 'personal_info', 'x_bank_name', 'bank_name', '`bank_name`', '`bank_name`', 200, -1, FALSE, '`bank_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bank_name->Sortable = TRUE; // Allow sort
		$this->fields['bank_name'] = &$this->bank_name;

		// bank_ifsc_code
		$this->bank_ifsc_code = new DbField('personal_info', 'personal_info', 'x_bank_ifsc_code', 'bank_ifsc_code', '`bank_ifsc_code`', '`bank_ifsc_code`', 200, -1, FALSE, '`bank_ifsc_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bank_ifsc_code->Sortable = TRUE; // Allow sort
		$this->fields['bank_ifsc_code'] = &$this->bank_ifsc_code;

		// bank_account_no
		$this->bank_account_no = new DbField('personal_info', 'personal_info', 'x_bank_account_no', 'bank_account_no', '`bank_account_no`', '`bank_account_no`', 200, -1, FALSE, '`bank_account_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bank_account_no->Sortable = TRUE; // Allow sort
		$this->fields['bank_account_no'] = &$this->bank_account_no;

		// operator
		$this->operator = new DbField('personal_info', 'personal_info', 'x_operator', 'operator', '`operator`', '`operator`', 18, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('personal_info', 'personal_info', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`personal_info`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->formal_name->DbValue = $row['formal_name'];
		$this->gender->DbValue = $row['gender'];
		$this->mobile->DbValue = $row['mobile'];
		$this->_email->DbValue = $row['email'];
		$this->address->DbValue = $row['address'];
		$this->country->DbValue = $row['country'];
		$this->state->DbValue = $row['state'];
		$this->city->DbValue = $row['city'];
		$this->city_name->DbValue = $row['city_name'];
		$this->dob->DbValue = $row['dob'];
		$this->dom->DbValue = $row['dom'];
		$this->marital_status->DbValue = $row['marital_status'];
		$this->spouse_details->DbValue = $row['spouse_details'];
		$this->image->Upload->DbValue = $row['image'];
		$this->father_name->DbValue = $row['father_name'];
		$this->mother_name->DbValue = $row['mother_name'];
		$this->permanent_address->DbValue = $row['permanent_address'];
		$this->mobile_other->DbValue = $row['mobile_other'];
		$this->mobile_family->DbValue = $row['mobile_family'];
		$this->emergency_details->DbValue = $row['emergency_details'];
		$this->annual_income->DbValue = $row['annual_income'];
		$this->work_details->DbValue = $row['work_details'];
		$this->status->DbValue = $row['status'];
		$this->gst->DbValue = $row['gst'];
		$this->aadhaar_no->DbValue = $row['aadhaar_no'];
		$this->pan_no->DbValue = $row['pan_no'];
		$this->id_proof->Upload->DbValue = $row['id_proof'];
		$this->reference_details->DbValue = $row['reference_details'];
		$this->other_details->DbValue = $row['other_details'];
		$this->bank_name->DbValue = $row['bank_name'];
		$this->bank_ifsc_code->DbValue = $row['bank_ifsc_code'];
		$this->bank_account_no->DbValue = $row['bank_account_no'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->image->OldUploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
		$oldFiles = EmptyValue($row['image']) ? [] : [$row['image']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->image->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->image->oldPhysicalUploadPath() . $oldFile);
		}
		$this->id_proof->OldUploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
		$oldFiles = EmptyValue($row['id_proof']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['id_proof']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->id_proof->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->id_proof->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "personal_infolist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "personal_infoview.php")
			return $Language->phrase("View");
		elseif ($pageName == "personal_infoedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "personal_infoadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "personal_infolist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("personal_infoview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("personal_infoview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "personal_infoadd.php?" . $this->getUrlParm($parm);
		else
			$url = "personal_infoadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("personal_infoedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("personal_infoadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("personal_infodelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->formal_name->setDbValue($rs->fields('formal_name'));
		$this->gender->setDbValue($rs->fields('gender'));
		$this->mobile->setDbValue($rs->fields('mobile'));
		$this->_email->setDbValue($rs->fields('email'));
		$this->address->setDbValue($rs->fields('address'));
		$this->country->setDbValue($rs->fields('country'));
		$this->state->setDbValue($rs->fields('state'));
		$this->city->setDbValue($rs->fields('city'));
		$this->city_name->setDbValue($rs->fields('city_name'));
		$this->dob->setDbValue($rs->fields('dob'));
		$this->dom->setDbValue($rs->fields('dom'));
		$this->marital_status->setDbValue($rs->fields('marital_status'));
		$this->spouse_details->setDbValue($rs->fields('spouse_details'));
		$this->image->Upload->DbValue = $rs->fields('image');
		$this->father_name->setDbValue($rs->fields('father_name'));
		$this->mother_name->setDbValue($rs->fields('mother_name'));
		$this->permanent_address->setDbValue($rs->fields('permanent_address'));
		$this->mobile_other->setDbValue($rs->fields('mobile_other'));
		$this->mobile_family->setDbValue($rs->fields('mobile_family'));
		$this->emergency_details->setDbValue($rs->fields('emergency_details'));
		$this->annual_income->setDbValue($rs->fields('annual_income'));
		$this->work_details->setDbValue($rs->fields('work_details'));
		$this->status->setDbValue($rs->fields('status'));
		$this->gst->setDbValue($rs->fields('gst'));
		$this->aadhaar_no->setDbValue($rs->fields('aadhaar_no'));
		$this->pan_no->setDbValue($rs->fields('pan_no'));
		$this->id_proof->Upload->DbValue = $rs->fields('id_proof');
		$this->reference_details->setDbValue($rs->fields('reference_details'));
		$this->other_details->setDbValue($rs->fields('other_details'));
		$this->bank_name->setDbValue($rs->fields('bank_name'));
		$this->bank_ifsc_code->setDbValue($rs->fields('bank_ifsc_code'));
		$this->bank_account_no->setDbValue($rs->fields('bank_account_no'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// formal_name
		// gender
		// mobile
		// email
		// address
		// country
		// state
		// city
		// city_name
		// dob
		// dom
		// marital_status
		// spouse_details
		// image
		// father_name
		// mother_name
		// permanent_address
		// mobile_other
		// mobile_family
		// emergency_details
		// annual_income
		// work_details
		// status
		// gst
		// aadhaar_no
		// pan_no
		// id_proof
		// reference_details
		// other_details
		// bank_name
		// bank_ifsc_code
		// bank_account_no
		// operator
		// datetime
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// formal_name
		$this->formal_name->ViewValue = $this->formal_name->CurrentValue;
		$this->formal_name->ViewCustomAttributes = "";

		// gender
		if (strval($this->gender->CurrentValue) <> "") {
			$this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
		} else {
			$this->gender->ViewValue = NULL;
		}
		$this->gender->ViewCustomAttributes = "";

		// mobile
		$this->mobile->ViewValue = $this->mobile->CurrentValue;
		$this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, 0, -2, -2, -2);
		$this->mobile->ViewCustomAttributes = "";

		// email
		$this->_email->ViewValue = $this->_email->CurrentValue;
		$this->_email->ViewCustomAttributes = "";

		// address
		$this->address->ViewValue = $this->address->CurrentValue;
		$this->address->ViewCustomAttributes = "";

		// country
		$curVal = strval($this->country->CurrentValue);
		if ($curVal <> "") {
			$this->country->ViewValue = $this->country->lookupCacheOption($curVal);
			if ($this->country->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->country->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->country->ViewValue = $this->country->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->country->ViewValue = $this->country->CurrentValue;
				}
			}
		} else {
			$this->country->ViewValue = NULL;
		}
		$this->country->ViewCustomAttributes = "";

		// state
		$curVal = strval($this->state->CurrentValue);
		if ($curVal <> "") {
			$this->state->ViewValue = $this->state->lookupCacheOption($curVal);
			if ($this->state->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->state->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->state->ViewValue = $this->state->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->state->ViewValue = $this->state->CurrentValue;
				}
			}
		} else {
			$this->state->ViewValue = NULL;
		}
		$this->state->ViewCustomAttributes = "";

		// city
		$curVal = strval($this->city->CurrentValue);
		if ($curVal <> "") {
			$this->city->ViewValue = $this->city->lookupCacheOption($curVal);
			if ($this->city->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->city->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->city->ViewValue = $this->city->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->city->ViewValue = $this->city->CurrentValue;
				}
			}
		} else {
			$this->city->ViewValue = NULL;
		}
		$this->city->ViewCustomAttributes = "";

		// city_name
		$this->city_name->ViewValue = $this->city_name->CurrentValue;
		$this->city_name->ViewCustomAttributes = "";

		// dob
		$this->dob->ViewValue = $this->dob->CurrentValue;
		$this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, 2);
		$this->dob->ViewCustomAttributes = "";

		// dom
		$this->dom->ViewValue = $this->dom->CurrentValue;
		$this->dom->ViewValue = FormatDateTime($this->dom->ViewValue, 2);
		$this->dom->ViewCustomAttributes = "";

		// marital_status
		if (strval($this->marital_status->CurrentValue) <> "") {
			$this->marital_status->ViewValue = $this->marital_status->optionCaption($this->marital_status->CurrentValue);
		} else {
			$this->marital_status->ViewValue = NULL;
		}
		$this->marital_status->ViewCustomAttributes = "";

		// spouse_details
		$this->spouse_details->ViewValue = $this->spouse_details->CurrentValue;
		$this->spouse_details->ViewCustomAttributes = "";

		// image
		$this->image->UploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->ViewValue = $this->image->Upload->DbValue;
		} else {
			$this->image->ViewValue = "";
		}
		$this->image->ViewCustomAttributes = "";

		// father_name
		$this->father_name->ViewValue = $this->father_name->CurrentValue;
		$this->father_name->ViewCustomAttributes = "";

		// mother_name
		$this->mother_name->ViewValue = $this->mother_name->CurrentValue;
		$this->mother_name->ViewCustomAttributes = "";

		// permanent_address
		$this->permanent_address->ViewValue = $this->permanent_address->CurrentValue;
		$this->permanent_address->ViewCustomAttributes = "";

		// mobile_other
		$this->mobile_other->ViewValue = $this->mobile_other->CurrentValue;
		$this->mobile_other->ViewCustomAttributes = "";

		// mobile_family
		$this->mobile_family->ViewValue = $this->mobile_family->CurrentValue;
		$this->mobile_family->ViewCustomAttributes = "";

		// emergency_details
		$this->emergency_details->ViewValue = $this->emergency_details->CurrentValue;
		$this->emergency_details->ViewCustomAttributes = "";

		// annual_income
		$this->annual_income->ViewValue = $this->annual_income->CurrentValue;
		$this->annual_income->ViewValue = FormatNumber($this->annual_income->ViewValue, 0, -2, -2, -2);
		$this->annual_income->ViewCustomAttributes = "";

		// work_details
		$this->work_details->ViewValue = $this->work_details->CurrentValue;
		$this->work_details->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// gst
		$this->gst->ViewValue = $this->gst->CurrentValue;
		$this->gst->ViewCustomAttributes = "";

		// aadhaar_no
		$this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;
		$this->aadhaar_no->ViewCustomAttributes = "";

		// pan_no
		$this->pan_no->ViewValue = $this->pan_no->CurrentValue;
		$this->pan_no->ViewCustomAttributes = "";

		// id_proof
		$this->id_proof->UploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
		if (!EmptyValue($this->id_proof->Upload->DbValue)) {
			$this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
		} else {
			$this->id_proof->ViewValue = "";
		}
		$this->id_proof->ViewCustomAttributes = "";

		// reference_details
		$this->reference_details->ViewValue = $this->reference_details->CurrentValue;
		$this->reference_details->ViewCustomAttributes = "";

		// other_details
		$this->other_details->ViewValue = $this->other_details->CurrentValue;
		$this->other_details->ViewCustomAttributes = "";

		// bank_name
		$this->bank_name->ViewValue = $this->bank_name->CurrentValue;
		$this->bank_name->ViewCustomAttributes = "";

		// bank_ifsc_code
		$this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;
		$this->bank_ifsc_code->ViewCustomAttributes = "";

		// bank_account_no
		$this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;
		$this->bank_account_no->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// formal_name
		$this->formal_name->LinkCustomAttributes = "";
		$this->formal_name->HrefValue = "";
		$this->formal_name->TooltipValue = "";

		// gender
		$this->gender->LinkCustomAttributes = "";
		$this->gender->HrefValue = "";
		$this->gender->TooltipValue = "";

		// mobile
		$this->mobile->LinkCustomAttributes = "";
		$this->mobile->HrefValue = "";
		$this->mobile->TooltipValue = "";

		// email
		$this->_email->LinkCustomAttributes = "";
		$this->_email->HrefValue = "";
		$this->_email->TooltipValue = "";

		// address
		$this->address->LinkCustomAttributes = "";
		$this->address->HrefValue = "";
		$this->address->TooltipValue = "";

		// country
		$this->country->LinkCustomAttributes = "";
		$this->country->HrefValue = "";
		$this->country->TooltipValue = "";

		// state
		$this->state->LinkCustomAttributes = "";
		$this->state->HrefValue = "";
		$this->state->TooltipValue = "";

		// city
		$this->city->LinkCustomAttributes = "";
		$this->city->HrefValue = "";
		$this->city->TooltipValue = "";

		// city_name
		$this->city_name->LinkCustomAttributes = "";
		$this->city_name->HrefValue = "";
		$this->city_name->TooltipValue = "";

		// dob
		$this->dob->LinkCustomAttributes = "";
		$this->dob->HrefValue = "";
		$this->dob->TooltipValue = "";

		// dom
		$this->dom->LinkCustomAttributes = "";
		$this->dom->HrefValue = "";
		$this->dom->TooltipValue = "";

		// marital_status
		$this->marital_status->LinkCustomAttributes = "";
		$this->marital_status->HrefValue = "";
		$this->marital_status->TooltipValue = "";

		// spouse_details
		$this->spouse_details->LinkCustomAttributes = "";
		$this->spouse_details->HrefValue = "";
		$this->spouse_details->TooltipValue = "";

		// image
		$this->image->LinkCustomAttributes = "";
		$this->image->HrefValue = "";
		$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
		$this->image->TooltipValue = "";

		// father_name
		$this->father_name->LinkCustomAttributes = "";
		$this->father_name->HrefValue = "";
		$this->father_name->TooltipValue = "";

		// mother_name
		$this->mother_name->LinkCustomAttributes = "";
		$this->mother_name->HrefValue = "";
		$this->mother_name->TooltipValue = "";

		// permanent_address
		$this->permanent_address->LinkCustomAttributes = "";
		$this->permanent_address->HrefValue = "";
		$this->permanent_address->TooltipValue = "";

		// mobile_other
		$this->mobile_other->LinkCustomAttributes = "";
		$this->mobile_other->HrefValue = "";
		$this->mobile_other->TooltipValue = "";

		// mobile_family
		$this->mobile_family->LinkCustomAttributes = "";
		$this->mobile_family->HrefValue = "";
		$this->mobile_family->TooltipValue = "";

		// emergency_details
		$this->emergency_details->LinkCustomAttributes = "";
		$this->emergency_details->HrefValue = "";
		$this->emergency_details->TooltipValue = "";

		// annual_income
		$this->annual_income->LinkCustomAttributes = "";
		$this->annual_income->HrefValue = "";
		$this->annual_income->TooltipValue = "";

		// work_details
		$this->work_details->LinkCustomAttributes = "";
		$this->work_details->HrefValue = "";
		$this->work_details->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// gst
		$this->gst->LinkCustomAttributes = "";
		$this->gst->HrefValue = "";
		$this->gst->TooltipValue = "";

		// aadhaar_no
		$this->aadhaar_no->LinkCustomAttributes = "";
		$this->aadhaar_no->HrefValue = "";
		$this->aadhaar_no->TooltipValue = "";

		// pan_no
		$this->pan_no->LinkCustomAttributes = "";
		$this->pan_no->HrefValue = "";
		$this->pan_no->TooltipValue = "";

		// id_proof
		$this->id_proof->LinkCustomAttributes = "";
		$this->id_proof->HrefValue = "";
		$this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;
		$this->id_proof->TooltipValue = "";

		// reference_details
		$this->reference_details->LinkCustomAttributes = "";
		$this->reference_details->HrefValue = "";
		$this->reference_details->TooltipValue = "";

		// other_details
		$this->other_details->LinkCustomAttributes = "";
		$this->other_details->HrefValue = "";
		$this->other_details->TooltipValue = "";

		// bank_name
		$this->bank_name->LinkCustomAttributes = "";
		$this->bank_name->HrefValue = "";
		$this->bank_name->TooltipValue = "";

		// bank_ifsc_code
		$this->bank_ifsc_code->LinkCustomAttributes = "";
		$this->bank_ifsc_code->HrefValue = "";
		$this->bank_ifsc_code->TooltipValue = "";

		// bank_account_no
		$this->bank_account_no->LinkCustomAttributes = "";
		$this->bank_account_no->HrefValue = "";
		$this->bank_account_no->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// formal_name
		$this->formal_name->EditAttrs["class"] = "form-control";
		$this->formal_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->formal_name->CurrentValue = HtmlDecode($this->formal_name->CurrentValue);
		$this->formal_name->EditValue = $this->formal_name->CurrentValue;
		$this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

		// gender
		$this->gender->EditAttrs["class"] = "form-control";
		$this->gender->EditCustomAttributes = "";
		$this->gender->EditValue = $this->gender->options(TRUE);

		// mobile
		$this->mobile->EditAttrs["class"] = "form-control";
		$this->mobile->EditCustomAttributes = "";
		$this->mobile->EditValue = $this->mobile->CurrentValue;
		$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

		// email
		$this->_email->EditAttrs["class"] = "form-control";
		$this->_email->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
		$this->_email->EditValue = $this->_email->CurrentValue;
		$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

		// address
		$this->address->EditAttrs["class"] = "form-control";
		$this->address->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->address->CurrentValue = HtmlDecode($this->address->CurrentValue);
		$this->address->EditValue = $this->address->CurrentValue;
		$this->address->PlaceHolder = RemoveHtml($this->address->caption());

		// country
		$this->country->EditAttrs["class"] = "form-control";
		$this->country->EditCustomAttributes = "";

		// state
		$this->state->EditAttrs["class"] = "form-control";
		$this->state->EditCustomAttributes = "";

		// city
		$this->city->EditAttrs["class"] = "form-control";
		$this->city->EditCustomAttributes = "";

		// city_name
		$this->city_name->EditAttrs["class"] = "form-control";
		$this->city_name->EditCustomAttributes = 'ReadOnly';
		if (REMOVE_XSS)
			$this->city_name->CurrentValue = HtmlDecode($this->city_name->CurrentValue);
		$this->city_name->EditValue = $this->city_name->CurrentValue;
		$this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

		// dob
		$this->dob->EditAttrs["class"] = "form-control";
		$this->dob->EditCustomAttributes = "";
		$this->dob->EditValue = FormatDateTime($this->dob->CurrentValue, 2);
		$this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

		// dom
		$this->dom->EditAttrs["class"] = "form-control";
		$this->dom->EditCustomAttributes = "";
		$this->dom->EditValue = FormatDateTime($this->dom->CurrentValue, 2);
		$this->dom->PlaceHolder = RemoveHtml($this->dom->caption());

		// marital_status
		$this->marital_status->EditAttrs["class"] = "form-control";
		$this->marital_status->EditCustomAttributes = "";
		$this->marital_status->EditValue = $this->marital_status->options(TRUE);

		// spouse_details
		$this->spouse_details->EditAttrs["class"] = "form-control";
		$this->spouse_details->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->spouse_details->CurrentValue = HtmlDecode($this->spouse_details->CurrentValue);
		$this->spouse_details->EditValue = $this->spouse_details->CurrentValue;
		$this->spouse_details->PlaceHolder = RemoveHtml($this->spouse_details->caption());

		// image
		$this->image->EditAttrs["class"] = "form-control";
		$this->image->EditCustomAttributes = "";
		$this->image->UploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->EditValue = $this->image->Upload->DbValue;
		} else {
			$this->image->EditValue = "";
		}
		if (!EmptyValue($this->image->CurrentValue))
				$this->image->Upload->FileName = $this->image->CurrentValue;

		// father_name
		$this->father_name->EditAttrs["class"] = "form-control";
		$this->father_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->father_name->CurrentValue = HtmlDecode($this->father_name->CurrentValue);
		$this->father_name->EditValue = $this->father_name->CurrentValue;
		$this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

		// mother_name
		$this->mother_name->EditAttrs["class"] = "form-control";
		$this->mother_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->mother_name->CurrentValue = HtmlDecode($this->mother_name->CurrentValue);
		$this->mother_name->EditValue = $this->mother_name->CurrentValue;
		$this->mother_name->PlaceHolder = RemoveHtml($this->mother_name->caption());

		// permanent_address
		$this->permanent_address->EditAttrs["class"] = "form-control";
		$this->permanent_address->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->permanent_address->CurrentValue = HtmlDecode($this->permanent_address->CurrentValue);
		$this->permanent_address->EditValue = $this->permanent_address->CurrentValue;
		$this->permanent_address->PlaceHolder = RemoveHtml($this->permanent_address->caption());

		// mobile_other
		$this->mobile_other->EditAttrs["class"] = "form-control";
		$this->mobile_other->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->mobile_other->CurrentValue = HtmlDecode($this->mobile_other->CurrentValue);
		$this->mobile_other->EditValue = $this->mobile_other->CurrentValue;
		$this->mobile_other->PlaceHolder = RemoveHtml($this->mobile_other->caption());

		// mobile_family
		$this->mobile_family->EditAttrs["class"] = "form-control";
		$this->mobile_family->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->mobile_family->CurrentValue = HtmlDecode($this->mobile_family->CurrentValue);
		$this->mobile_family->EditValue = $this->mobile_family->CurrentValue;
		$this->mobile_family->PlaceHolder = RemoveHtml($this->mobile_family->caption());

		// emergency_details
		$this->emergency_details->EditAttrs["class"] = "form-control";
		$this->emergency_details->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->emergency_details->CurrentValue = HtmlDecode($this->emergency_details->CurrentValue);
		$this->emergency_details->EditValue = $this->emergency_details->CurrentValue;
		$this->emergency_details->PlaceHolder = RemoveHtml($this->emergency_details->caption());

		// annual_income
		$this->annual_income->EditAttrs["class"] = "form-control";
		$this->annual_income->EditCustomAttributes = "";
		$this->annual_income->EditValue = $this->annual_income->CurrentValue;
		$this->annual_income->PlaceHolder = RemoveHtml($this->annual_income->caption());

		// work_details
		$this->work_details->EditAttrs["class"] = "form-control";
		$this->work_details->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->work_details->CurrentValue = HtmlDecode($this->work_details->CurrentValue);
		$this->work_details->EditValue = $this->work_details->CurrentValue;
		$this->work_details->PlaceHolder = RemoveHtml($this->work_details->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// gst
		$this->gst->EditAttrs["class"] = "form-control";
		$this->gst->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->gst->CurrentValue = HtmlDecode($this->gst->CurrentValue);
		$this->gst->EditValue = $this->gst->CurrentValue;
		$this->gst->PlaceHolder = RemoveHtml($this->gst->caption());

		// aadhaar_no
		$this->aadhaar_no->EditAttrs["class"] = "form-control";
		$this->aadhaar_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
		$this->aadhaar_no->EditValue = $this->aadhaar_no->CurrentValue;
		$this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

		// pan_no
		$this->pan_no->EditAttrs["class"] = "form-control";
		$this->pan_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pan_no->CurrentValue = HtmlDecode($this->pan_no->CurrentValue);
		$this->pan_no->EditValue = $this->pan_no->CurrentValue;
		$this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

		// id_proof
		$this->id_proof->EditAttrs["class"] = "form-control";
		$this->id_proof->EditCustomAttributes = "";
		$this->id_proof->UploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
		if (!EmptyValue($this->id_proof->Upload->DbValue)) {
			$this->id_proof->EditValue = $this->id_proof->Upload->DbValue;
		} else {
			$this->id_proof->EditValue = "";
		}
		if (!EmptyValue($this->id_proof->CurrentValue))
				$this->id_proof->Upload->FileName = $this->id_proof->CurrentValue;

		// reference_details
		$this->reference_details->EditAttrs["class"] = "form-control";
		$this->reference_details->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->reference_details->CurrentValue = HtmlDecode($this->reference_details->CurrentValue);
		$this->reference_details->EditValue = $this->reference_details->CurrentValue;
		$this->reference_details->PlaceHolder = RemoveHtml($this->reference_details->caption());

		// other_details
		$this->other_details->EditAttrs["class"] = "form-control";
		$this->other_details->EditCustomAttributes = "";
		$this->other_details->EditValue = $this->other_details->CurrentValue;
		$this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

		// bank_name
		$this->bank_name->EditAttrs["class"] = "form-control";
		$this->bank_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->bank_name->CurrentValue = HtmlDecode($this->bank_name->CurrentValue);
		$this->bank_name->EditValue = $this->bank_name->CurrentValue;
		$this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

		// bank_ifsc_code
		$this->bank_ifsc_code->EditAttrs["class"] = "form-control";
		$this->bank_ifsc_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->bank_ifsc_code->CurrentValue = HtmlDecode($this->bank_ifsc_code->CurrentValue);
		$this->bank_ifsc_code->EditValue = $this->bank_ifsc_code->CurrentValue;
		$this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

		// bank_account_no
		$this->bank_account_no->EditAttrs["class"] = "form-control";
		$this->bank_account_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->bank_account_no->CurrentValue = HtmlDecode($this->bank_account_no->CurrentValue);
		$this->bank_account_no->EditValue = $this->bank_account_no->CurrentValue;
		$this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

		// operator
		// datetime
		// Call Row Rendered event

		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->formal_name);
					$doc->exportCaption($this->gender);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->_email);
					$doc->exportCaption($this->address);
					$doc->exportCaption($this->country);
					$doc->exportCaption($this->state);
					$doc->exportCaption($this->city);
					$doc->exportCaption($this->city_name);
					$doc->exportCaption($this->dob);
					$doc->exportCaption($this->dom);
					$doc->exportCaption($this->marital_status);
					$doc->exportCaption($this->spouse_details);
					$doc->exportCaption($this->image);
					$doc->exportCaption($this->father_name);
					$doc->exportCaption($this->mother_name);
					$doc->exportCaption($this->permanent_address);
					$doc->exportCaption($this->mobile_other);
					$doc->exportCaption($this->mobile_family);
					$doc->exportCaption($this->emergency_details);
					$doc->exportCaption($this->annual_income);
					$doc->exportCaption($this->work_details);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->gst);
					$doc->exportCaption($this->aadhaar_no);
					$doc->exportCaption($this->pan_no);
					$doc->exportCaption($this->id_proof);
					$doc->exportCaption($this->reference_details);
					$doc->exportCaption($this->other_details);
					$doc->exportCaption($this->bank_name);
					$doc->exportCaption($this->bank_ifsc_code);
					$doc->exportCaption($this->bank_account_no);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->formal_name);
					$doc->exportCaption($this->gender);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->_email);
					$doc->exportCaption($this->address);
					$doc->exportCaption($this->country);
					$doc->exportCaption($this->state);
					$doc->exportCaption($this->city);
					$doc->exportCaption($this->city_name);
					$doc->exportCaption($this->dob);
					$doc->exportCaption($this->dom);
					$doc->exportCaption($this->marital_status);
					$doc->exportCaption($this->spouse_details);
					$doc->exportCaption($this->image);
					$doc->exportCaption($this->father_name);
					$doc->exportCaption($this->mother_name);
					$doc->exportCaption($this->permanent_address);
					$doc->exportCaption($this->mobile_other);
					$doc->exportCaption($this->mobile_family);
					$doc->exportCaption($this->emergency_details);
					$doc->exportCaption($this->annual_income);
					$doc->exportCaption($this->work_details);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->gst);
					$doc->exportCaption($this->aadhaar_no);
					$doc->exportCaption($this->pan_no);
					$doc->exportCaption($this->id_proof);
					$doc->exportCaption($this->reference_details);
					$doc->exportCaption($this->bank_name);
					$doc->exportCaption($this->bank_ifsc_code);
					$doc->exportCaption($this->bank_account_no);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->formal_name);
						$doc->exportField($this->gender);
						$doc->exportField($this->mobile);
						$doc->exportField($this->_email);
						$doc->exportField($this->address);
						$doc->exportField($this->country);
						$doc->exportField($this->state);
						$doc->exportField($this->city);
						$doc->exportField($this->city_name);
						$doc->exportField($this->dob);
						$doc->exportField($this->dom);
						$doc->exportField($this->marital_status);
						$doc->exportField($this->spouse_details);
						$doc->exportField($this->image);
						$doc->exportField($this->father_name);
						$doc->exportField($this->mother_name);
						$doc->exportField($this->permanent_address);
						$doc->exportField($this->mobile_other);
						$doc->exportField($this->mobile_family);
						$doc->exportField($this->emergency_details);
						$doc->exportField($this->annual_income);
						$doc->exportField($this->work_details);
						$doc->exportField($this->status);
						$doc->exportField($this->gst);
						$doc->exportField($this->aadhaar_no);
						$doc->exportField($this->pan_no);
						$doc->exportField($this->id_proof);
						$doc->exportField($this->reference_details);
						$doc->exportField($this->other_details);
						$doc->exportField($this->bank_name);
						$doc->exportField($this->bank_ifsc_code);
						$doc->exportField($this->bank_account_no);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->formal_name);
						$doc->exportField($this->gender);
						$doc->exportField($this->mobile);
						$doc->exportField($this->_email);
						$doc->exportField($this->address);
						$doc->exportField($this->country);
						$doc->exportField($this->state);
						$doc->exportField($this->city);
						$doc->exportField($this->city_name);
						$doc->exportField($this->dob);
						$doc->exportField($this->dom);
						$doc->exportField($this->marital_status);
						$doc->exportField($this->spouse_details);
						$doc->exportField($this->image);
						$doc->exportField($this->father_name);
						$doc->exportField($this->mother_name);
						$doc->exportField($this->permanent_address);
						$doc->exportField($this->mobile_other);
						$doc->exportField($this->mobile_family);
						$doc->exportField($this->emergency_details);
						$doc->exportField($this->annual_income);
						$doc->exportField($this->work_details);
						$doc->exportField($this->status);
						$doc->exportField($this->gst);
						$doc->exportField($this->aadhaar_no);
						$doc->exportField($this->pan_no);
						$doc->exportField($this->id_proof);
						$doc->exportField($this->reference_details);
						$doc->exportField($this->bank_name);
						$doc->exportField($this->bank_ifsc_code);
						$doc->exportField($this->bank_account_no);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'image') {
			$fldName = "image";
			$fileNameFld = "image";
		} elseif ($fldparm == 'id_proof') {
			$fldName = "id_proof";
			$fileNameFld = "id_proof";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'personal_info';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'personal_info';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'personal_info';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'personal_info';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>