<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class personal_info_edit extends personal_info
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'personal_info';

	// Page object name
	public $PageObjName = "personal_info_edit";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (personal_info)
		if (!isset($GLOBALS["personal_info"]) || get_class($GLOBALS["personal_info"]) == PROJECT_NAMESPACE . "personal_info") {
			$GLOBALS["personal_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["personal_info"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'personal_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $personal_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($personal_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "personal_infoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $DisplayRecs = 1;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $RecCnt;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("personal_infolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->formal_name->setVisibility();
		$this->gender->setVisibility();
		$this->mobile->setVisibility();
		$this->_email->setVisibility();
		$this->address->setVisibility();
		$this->country->setVisibility();
		$this->state->setVisibility();
		$this->city->setVisibility();
		$this->city_name->setVisibility();
		$this->dob->setVisibility();
		$this->dom->setVisibility();
		$this->marital_status->setVisibility();
		$this->spouse_details->setVisibility();
		$this->image->setVisibility();
		$this->father_name->setVisibility();
		$this->mother_name->setVisibility();
		$this->permanent_address->setVisibility();
		$this->mobile_other->setVisibility();
		$this->mobile_family->setVisibility();
		$this->emergency_details->setVisibility();
		$this->annual_income->setVisibility();
		$this->work_details->setVisibility();
		$this->status->setVisibility();
		$this->gst->setVisibility();
		$this->aadhaar_no->setVisibility();
		$this->pan_no->setVisibility();
		$this->id_proof->setVisibility();
		$this->reference_details->setVisibility();
		$this->other_details->setVisibility();
		$this->bank_name->setVisibility();
		$this->bank_ifsc_code->setVisibility();
		$this->bank_account_no->setVisibility();
		$this->operator->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->country);
		$this->setupLookupOptions($this->state);
		$this->setupLookupOptions($this->city);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";

		// Load record by position
		$loadByPosition = FALSE;
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
			if (!$loadByQuery)
				$loadByPosition = TRUE;
		}

		// Load recordset
		$this->StartRec = 1; // Initialize start position
		if ($rs = $this->loadRecordset()) // Load records
			$this->TotalRecs = $rs->RecordCount(); // Get record count
		if ($this->TotalRecs <= 0) { // No record found
			if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$this->terminate("personal_infolist.php"); // Return to list page
		} elseif ($loadByPosition) { // Load record by position
			$this->setupStartRec(); // Set up start record position

			// Point to current record
			if ($this->StartRec <= $this->TotalRecs) {
				$rs->move($this->StartRec - 1);
				$loaded = TRUE;
			}
		} else { // Match key values
			if ($this->id->CurrentValue != NULL) {
				while (!$rs->EOF) {
					if (SameString($this->id->CurrentValue, $rs->fields('id'))) {
						$this->setStartRecordNumber($this->StartRec); // Save record position
						$loaded = TRUE;
						break;
					} else {
						$this->StartRec++;
						$rs->moveNext();
					}
				}
			}
		}

		// Load current row values
		if ($loaded)
			$this->loadRowValues($rs);

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) {
					if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
					$this->terminate("personal_infolist.php"); // Return to list page
				} else {
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "personal_infolist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->image->Upload->Index = $CurrentForm->Index;
		$this->image->Upload->uploadFile();
		$this->image->CurrentValue = $this->image->Upload->FileName;
		$this->id_proof->Upload->Index = $CurrentForm->Index;
		$this->id_proof->Upload->uploadFile();
		$this->id_proof->CurrentValue = $this->id_proof->Upload->FileName;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'formal_name' first before field var 'x_formal_name'
		$val = $CurrentForm->hasValue("formal_name") ? $CurrentForm->getValue("formal_name") : $CurrentForm->getValue("x_formal_name");
		if (!$this->formal_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->formal_name->Visible = FALSE; // Disable update for API request
			else
				$this->formal_name->setFormValue($val);
		}

		// Check field name 'gender' first before field var 'x_gender'
		$val = $CurrentForm->hasValue("gender") ? $CurrentForm->getValue("gender") : $CurrentForm->getValue("x_gender");
		if (!$this->gender->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gender->Visible = FALSE; // Disable update for API request
			else
				$this->gender->setFormValue($val);
		}

		// Check field name 'mobile' first before field var 'x_mobile'
		$val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
		if (!$this->mobile->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile->Visible = FALSE; // Disable update for API request
			else
				$this->mobile->setFormValue($val);
		}

		// Check field name 'email' first before field var 'x__email'
		$val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
		if (!$this->_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_email->Visible = FALSE; // Disable update for API request
			else
				$this->_email->setFormValue($val);
		}

		// Check field name 'address' first before field var 'x_address'
		$val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
		if (!$this->address->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->address->Visible = FALSE; // Disable update for API request
			else
				$this->address->setFormValue($val);
		}

		// Check field name 'country' first before field var 'x_country'
		$val = $CurrentForm->hasValue("country") ? $CurrentForm->getValue("country") : $CurrentForm->getValue("x_country");
		if (!$this->country->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->country->Visible = FALSE; // Disable update for API request
			else
				$this->country->setFormValue($val);
		}

		// Check field name 'state' first before field var 'x_state'
		$val = $CurrentForm->hasValue("state") ? $CurrentForm->getValue("state") : $CurrentForm->getValue("x_state");
		if (!$this->state->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->state->Visible = FALSE; // Disable update for API request
			else
				$this->state->setFormValue($val);
		}

		// Check field name 'city' first before field var 'x_city'
		$val = $CurrentForm->hasValue("city") ? $CurrentForm->getValue("city") : $CurrentForm->getValue("x_city");
		if (!$this->city->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->city->Visible = FALSE; // Disable update for API request
			else
				$this->city->setFormValue($val);
		}

		// Check field name 'city_name' first before field var 'x_city_name'
		$val = $CurrentForm->hasValue("city_name") ? $CurrentForm->getValue("city_name") : $CurrentForm->getValue("x_city_name");
		if (!$this->city_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->city_name->Visible = FALSE; // Disable update for API request
			else
				$this->city_name->setFormValue($val);
		}

		// Check field name 'dob' first before field var 'x_dob'
		$val = $CurrentForm->hasValue("dob") ? $CurrentForm->getValue("dob") : $CurrentForm->getValue("x_dob");
		if (!$this->dob->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dob->Visible = FALSE; // Disable update for API request
			else
				$this->dob->setFormValue($val);
			$this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, 2);
		}

		// Check field name 'dom' first before field var 'x_dom'
		$val = $CurrentForm->hasValue("dom") ? $CurrentForm->getValue("dom") : $CurrentForm->getValue("x_dom");
		if (!$this->dom->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dom->Visible = FALSE; // Disable update for API request
			else
				$this->dom->setFormValue($val);
			$this->dom->CurrentValue = UnFormatDateTime($this->dom->CurrentValue, 2);
		}

		// Check field name 'marital_status' first before field var 'x_marital_status'
		$val = $CurrentForm->hasValue("marital_status") ? $CurrentForm->getValue("marital_status") : $CurrentForm->getValue("x_marital_status");
		if (!$this->marital_status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->marital_status->Visible = FALSE; // Disable update for API request
			else
				$this->marital_status->setFormValue($val);
		}

		// Check field name 'spouse_details' first before field var 'x_spouse_details'
		$val = $CurrentForm->hasValue("spouse_details") ? $CurrentForm->getValue("spouse_details") : $CurrentForm->getValue("x_spouse_details");
		if (!$this->spouse_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->spouse_details->Visible = FALSE; // Disable update for API request
			else
				$this->spouse_details->setFormValue($val);
		}

		// Check field name 'father_name' first before field var 'x_father_name'
		$val = $CurrentForm->hasValue("father_name") ? $CurrentForm->getValue("father_name") : $CurrentForm->getValue("x_father_name");
		if (!$this->father_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->father_name->Visible = FALSE; // Disable update for API request
			else
				$this->father_name->setFormValue($val);
		}

		// Check field name 'mother_name' first before field var 'x_mother_name'
		$val = $CurrentForm->hasValue("mother_name") ? $CurrentForm->getValue("mother_name") : $CurrentForm->getValue("x_mother_name");
		if (!$this->mother_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mother_name->Visible = FALSE; // Disable update for API request
			else
				$this->mother_name->setFormValue($val);
		}

		// Check field name 'permanent_address' first before field var 'x_permanent_address'
		$val = $CurrentForm->hasValue("permanent_address") ? $CurrentForm->getValue("permanent_address") : $CurrentForm->getValue("x_permanent_address");
		if (!$this->permanent_address->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->permanent_address->Visible = FALSE; // Disable update for API request
			else
				$this->permanent_address->setFormValue($val);
		}

		// Check field name 'mobile_other' first before field var 'x_mobile_other'
		$val = $CurrentForm->hasValue("mobile_other") ? $CurrentForm->getValue("mobile_other") : $CurrentForm->getValue("x_mobile_other");
		if (!$this->mobile_other->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile_other->Visible = FALSE; // Disable update for API request
			else
				$this->mobile_other->setFormValue($val);
		}

		// Check field name 'mobile_family' first before field var 'x_mobile_family'
		$val = $CurrentForm->hasValue("mobile_family") ? $CurrentForm->getValue("mobile_family") : $CurrentForm->getValue("x_mobile_family");
		if (!$this->mobile_family->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile_family->Visible = FALSE; // Disable update for API request
			else
				$this->mobile_family->setFormValue($val);
		}

		// Check field name 'emergency_details' first before field var 'x_emergency_details'
		$val = $CurrentForm->hasValue("emergency_details") ? $CurrentForm->getValue("emergency_details") : $CurrentForm->getValue("x_emergency_details");
		if (!$this->emergency_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->emergency_details->Visible = FALSE; // Disable update for API request
			else
				$this->emergency_details->setFormValue($val);
		}

		// Check field name 'annual_income' first before field var 'x_annual_income'
		$val = $CurrentForm->hasValue("annual_income") ? $CurrentForm->getValue("annual_income") : $CurrentForm->getValue("x_annual_income");
		if (!$this->annual_income->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->annual_income->Visible = FALSE; // Disable update for API request
			else
				$this->annual_income->setFormValue($val);
		}

		// Check field name 'work_details' first before field var 'x_work_details'
		$val = $CurrentForm->hasValue("work_details") ? $CurrentForm->getValue("work_details") : $CurrentForm->getValue("x_work_details");
		if (!$this->work_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->work_details->Visible = FALSE; // Disable update for API request
			else
				$this->work_details->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'gst' first before field var 'x_gst'
		$val = $CurrentForm->hasValue("gst") ? $CurrentForm->getValue("gst") : $CurrentForm->getValue("x_gst");
		if (!$this->gst->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gst->Visible = FALSE; // Disable update for API request
			else
				$this->gst->setFormValue($val);
		}

		// Check field name 'aadhaar_no' first before field var 'x_aadhaar_no'
		$val = $CurrentForm->hasValue("aadhaar_no") ? $CurrentForm->getValue("aadhaar_no") : $CurrentForm->getValue("x_aadhaar_no");
		if (!$this->aadhaar_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->aadhaar_no->Visible = FALSE; // Disable update for API request
			else
				$this->aadhaar_no->setFormValue($val);
		}

		// Check field name 'pan_no' first before field var 'x_pan_no'
		$val = $CurrentForm->hasValue("pan_no") ? $CurrentForm->getValue("pan_no") : $CurrentForm->getValue("x_pan_no");
		if (!$this->pan_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pan_no->Visible = FALSE; // Disable update for API request
			else
				$this->pan_no->setFormValue($val);
		}

		// Check field name 'reference_details' first before field var 'x_reference_details'
		$val = $CurrentForm->hasValue("reference_details") ? $CurrentForm->getValue("reference_details") : $CurrentForm->getValue("x_reference_details");
		if (!$this->reference_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->reference_details->Visible = FALSE; // Disable update for API request
			else
				$this->reference_details->setFormValue($val);
		}

		// Check field name 'other_details' first before field var 'x_other_details'
		$val = $CurrentForm->hasValue("other_details") ? $CurrentForm->getValue("other_details") : $CurrentForm->getValue("x_other_details");
		if (!$this->other_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->other_details->Visible = FALSE; // Disable update for API request
			else
				$this->other_details->setFormValue($val);
		}

		// Check field name 'bank_name' first before field var 'x_bank_name'
		$val = $CurrentForm->hasValue("bank_name") ? $CurrentForm->getValue("bank_name") : $CurrentForm->getValue("x_bank_name");
		if (!$this->bank_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bank_name->Visible = FALSE; // Disable update for API request
			else
				$this->bank_name->setFormValue($val);
		}

		// Check field name 'bank_ifsc_code' first before field var 'x_bank_ifsc_code'
		$val = $CurrentForm->hasValue("bank_ifsc_code") ? $CurrentForm->getValue("bank_ifsc_code") : $CurrentForm->getValue("x_bank_ifsc_code");
		if (!$this->bank_ifsc_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bank_ifsc_code->Visible = FALSE; // Disable update for API request
			else
				$this->bank_ifsc_code->setFormValue($val);
		}

		// Check field name 'bank_account_no' first before field var 'x_bank_account_no'
		$val = $CurrentForm->hasValue("bank_account_no") ? $CurrentForm->getValue("bank_account_no") : $CurrentForm->getValue("x_bank_account_no");
		if (!$this->bank_account_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bank_account_no->Visible = FALSE; // Disable update for API request
			else
				$this->bank_account_no->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->formal_name->CurrentValue = $this->formal_name->FormValue;
		$this->gender->CurrentValue = $this->gender->FormValue;
		$this->mobile->CurrentValue = $this->mobile->FormValue;
		$this->_email->CurrentValue = $this->_email->FormValue;
		$this->address->CurrentValue = $this->address->FormValue;
		$this->country->CurrentValue = $this->country->FormValue;
		$this->state->CurrentValue = $this->state->FormValue;
		$this->city->CurrentValue = $this->city->FormValue;
		$this->city_name->CurrentValue = $this->city_name->FormValue;
		$this->dob->CurrentValue = $this->dob->FormValue;
		$this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, 2);
		$this->dom->CurrentValue = $this->dom->FormValue;
		$this->dom->CurrentValue = UnFormatDateTime($this->dom->CurrentValue, 2);
		$this->marital_status->CurrentValue = $this->marital_status->FormValue;
		$this->spouse_details->CurrentValue = $this->spouse_details->FormValue;
		$this->father_name->CurrentValue = $this->father_name->FormValue;
		$this->mother_name->CurrentValue = $this->mother_name->FormValue;
		$this->permanent_address->CurrentValue = $this->permanent_address->FormValue;
		$this->mobile_other->CurrentValue = $this->mobile_other->FormValue;
		$this->mobile_family->CurrentValue = $this->mobile_family->FormValue;
		$this->emergency_details->CurrentValue = $this->emergency_details->FormValue;
		$this->annual_income->CurrentValue = $this->annual_income->FormValue;
		$this->work_details->CurrentValue = $this->work_details->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->gst->CurrentValue = $this->gst->FormValue;
		$this->aadhaar_no->CurrentValue = $this->aadhaar_no->FormValue;
		$this->pan_no->CurrentValue = $this->pan_no->FormValue;
		$this->reference_details->CurrentValue = $this->reference_details->FormValue;
		$this->other_details->CurrentValue = $this->other_details->FormValue;
		$this->bank_name->CurrentValue = $this->bank_name->FormValue;
		$this->bank_ifsc_code->CurrentValue = $this->bank_ifsc_code->FormValue;
		$this->bank_account_no->CurrentValue = $this->bank_account_no->FormValue;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->formal_name->setDbValue($row['formal_name']);
		$this->gender->setDbValue($row['gender']);
		$this->mobile->setDbValue($row['mobile']);
		$this->_email->setDbValue($row['email']);
		$this->address->setDbValue($row['address']);
		$this->country->setDbValue($row['country']);
		$this->state->setDbValue($row['state']);
		$this->city->setDbValue($row['city']);
		$this->city_name->setDbValue($row['city_name']);
		$this->dob->setDbValue($row['dob']);
		$this->dom->setDbValue($row['dom']);
		$this->marital_status->setDbValue($row['marital_status']);
		$this->spouse_details->setDbValue($row['spouse_details']);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
		$this->father_name->setDbValue($row['father_name']);
		$this->mother_name->setDbValue($row['mother_name']);
		$this->permanent_address->setDbValue($row['permanent_address']);
		$this->mobile_other->setDbValue($row['mobile_other']);
		$this->mobile_family->setDbValue($row['mobile_family']);
		$this->emergency_details->setDbValue($row['emergency_details']);
		$this->annual_income->setDbValue($row['annual_income']);
		$this->work_details->setDbValue($row['work_details']);
		$this->status->setDbValue($row['status']);
		$this->gst->setDbValue($row['gst']);
		$this->aadhaar_no->setDbValue($row['aadhaar_no']);
		$this->pan_no->setDbValue($row['pan_no']);
		$this->id_proof->Upload->DbValue = $row['id_proof'];
		$this->id_proof->setDbValue($this->id_proof->Upload->DbValue);
		$this->reference_details->setDbValue($row['reference_details']);
		$this->other_details->setDbValue($row['other_details']);
		$this->bank_name->setDbValue($row['bank_name']);
		$this->bank_ifsc_code->setDbValue($row['bank_ifsc_code']);
		$this->bank_account_no->setDbValue($row['bank_account_no']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['formal_name'] = NULL;
		$row['gender'] = NULL;
		$row['mobile'] = NULL;
		$row['email'] = NULL;
		$row['address'] = NULL;
		$row['country'] = NULL;
		$row['state'] = NULL;
		$row['city'] = NULL;
		$row['city_name'] = NULL;
		$row['dob'] = NULL;
		$row['dom'] = NULL;
		$row['marital_status'] = NULL;
		$row['spouse_details'] = NULL;
		$row['image'] = NULL;
		$row['father_name'] = NULL;
		$row['mother_name'] = NULL;
		$row['permanent_address'] = NULL;
		$row['mobile_other'] = NULL;
		$row['mobile_family'] = NULL;
		$row['emergency_details'] = NULL;
		$row['annual_income'] = NULL;
		$row['work_details'] = NULL;
		$row['status'] = NULL;
		$row['gst'] = NULL;
		$row['aadhaar_no'] = NULL;
		$row['pan_no'] = NULL;
		$row['id_proof'] = NULL;
		$row['reference_details'] = NULL;
		$row['other_details'] = NULL;
		$row['bank_name'] = NULL;
		$row['bank_ifsc_code'] = NULL;
		$row['bank_account_no'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// formal_name
		// gender
		// mobile
		// email
		// address
		// country
		// state
		// city
		// city_name
		// dob
		// dom
		// marital_status
		// spouse_details
		// image
		// father_name
		// mother_name
		// permanent_address
		// mobile_other
		// mobile_family
		// emergency_details
		// annual_income
		// work_details
		// status
		// gst
		// aadhaar_no
		// pan_no
		// id_proof
		// reference_details
		// other_details
		// bank_name
		// bank_ifsc_code
		// bank_account_no
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// formal_name
			$this->formal_name->ViewValue = $this->formal_name->CurrentValue;
			$this->formal_name->ViewCustomAttributes = "";

			// gender
			if (strval($this->gender->CurrentValue) <> "") {
				$this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
			} else {
				$this->gender->ViewValue = NULL;
			}
			$this->gender->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, 0, -2, -2, -2);
			$this->mobile->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// address
			$this->address->ViewValue = $this->address->CurrentValue;
			$this->address->ViewCustomAttributes = "";

			// country
			$curVal = strval($this->country->CurrentValue);
			if ($curVal <> "") {
				$this->country->ViewValue = $this->country->lookupCacheOption($curVal);
				if ($this->country->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->country->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->country->ViewValue = $this->country->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->country->ViewValue = $this->country->CurrentValue;
					}
				}
			} else {
				$this->country->ViewValue = NULL;
			}
			$this->country->ViewCustomAttributes = "";

			// state
			$curVal = strval($this->state->CurrentValue);
			if ($curVal <> "") {
				$this->state->ViewValue = $this->state->lookupCacheOption($curVal);
				if ($this->state->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->state->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->state->ViewValue = $this->state->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->state->ViewValue = $this->state->CurrentValue;
					}
				}
			} else {
				$this->state->ViewValue = NULL;
			}
			$this->state->ViewCustomAttributes = "";

			// city
			$curVal = strval($this->city->CurrentValue);
			if ($curVal <> "") {
				$this->city->ViewValue = $this->city->lookupCacheOption($curVal);
				if ($this->city->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->city->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->city->ViewValue = $this->city->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->city->ViewValue = $this->city->CurrentValue;
					}
				}
			} else {
				$this->city->ViewValue = NULL;
			}
			$this->city->ViewCustomAttributes = "";

			// city_name
			$this->city_name->ViewValue = $this->city_name->CurrentValue;
			$this->city_name->ViewCustomAttributes = "";

			// dob
			$this->dob->ViewValue = $this->dob->CurrentValue;
			$this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, 2);
			$this->dob->ViewCustomAttributes = "";

			// dom
			$this->dom->ViewValue = $this->dom->CurrentValue;
			$this->dom->ViewValue = FormatDateTime($this->dom->ViewValue, 2);
			$this->dom->ViewCustomAttributes = "";

			// marital_status
			if (strval($this->marital_status->CurrentValue) <> "") {
				$this->marital_status->ViewValue = $this->marital_status->optionCaption($this->marital_status->CurrentValue);
			} else {
				$this->marital_status->ViewValue = NULL;
			}
			$this->marital_status->ViewCustomAttributes = "";

			// spouse_details
			$this->spouse_details->ViewValue = $this->spouse_details->CurrentValue;
			$this->spouse_details->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// father_name
			$this->father_name->ViewValue = $this->father_name->CurrentValue;
			$this->father_name->ViewCustomAttributes = "";

			// mother_name
			$this->mother_name->ViewValue = $this->mother_name->CurrentValue;
			$this->mother_name->ViewCustomAttributes = "";

			// permanent_address
			$this->permanent_address->ViewValue = $this->permanent_address->CurrentValue;
			$this->permanent_address->ViewCustomAttributes = "";

			// mobile_other
			$this->mobile_other->ViewValue = $this->mobile_other->CurrentValue;
			$this->mobile_other->ViewCustomAttributes = "";

			// mobile_family
			$this->mobile_family->ViewValue = $this->mobile_family->CurrentValue;
			$this->mobile_family->ViewCustomAttributes = "";

			// emergency_details
			$this->emergency_details->ViewValue = $this->emergency_details->CurrentValue;
			$this->emergency_details->ViewCustomAttributes = "";

			// annual_income
			$this->annual_income->ViewValue = $this->annual_income->CurrentValue;
			$this->annual_income->ViewValue = FormatNumber($this->annual_income->ViewValue, 0, -2, -2, -2);
			$this->annual_income->ViewCustomAttributes = "";

			// work_details
			$this->work_details->ViewValue = $this->work_details->CurrentValue;
			$this->work_details->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// gst
			$this->gst->ViewValue = $this->gst->CurrentValue;
			$this->gst->ViewCustomAttributes = "";

			// aadhaar_no
			$this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;
			$this->aadhaar_no->ViewCustomAttributes = "";

			// pan_no
			$this->pan_no->ViewValue = $this->pan_no->CurrentValue;
			$this->pan_no->ViewCustomAttributes = "";

			// id_proof
			$this->id_proof->UploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
			if (!EmptyValue($this->id_proof->Upload->DbValue)) {
				$this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
			} else {
				$this->id_proof->ViewValue = "";
			}
			$this->id_proof->ViewCustomAttributes = "";

			// reference_details
			$this->reference_details->ViewValue = $this->reference_details->CurrentValue;
			$this->reference_details->ViewCustomAttributes = "";

			// other_details
			$this->other_details->ViewValue = $this->other_details->CurrentValue;
			$this->other_details->ViewCustomAttributes = "";

			// bank_name
			$this->bank_name->ViewValue = $this->bank_name->CurrentValue;
			$this->bank_name->ViewCustomAttributes = "";

			// bank_ifsc_code
			$this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;
			$this->bank_ifsc_code->ViewCustomAttributes = "";

			// bank_account_no
			$this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;
			$this->bank_account_no->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// formal_name
			$this->formal_name->LinkCustomAttributes = "";
			$this->formal_name->HrefValue = "";
			$this->formal_name->TooltipValue = "";

			// gender
			$this->gender->LinkCustomAttributes = "";
			$this->gender->HrefValue = "";
			$this->gender->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";
			$this->address->TooltipValue = "";

			// country
			$this->country->LinkCustomAttributes = "";
			$this->country->HrefValue = "";
			$this->country->TooltipValue = "";

			// state
			$this->state->LinkCustomAttributes = "";
			$this->state->HrefValue = "";
			$this->state->TooltipValue = "";

			// city
			$this->city->LinkCustomAttributes = "";
			$this->city->HrefValue = "";
			$this->city->TooltipValue = "";

			// city_name
			$this->city_name->LinkCustomAttributes = "";
			$this->city_name->HrefValue = "";
			$this->city_name->TooltipValue = "";

			// dob
			$this->dob->LinkCustomAttributes = "";
			$this->dob->HrefValue = "";
			$this->dob->TooltipValue = "";

			// dom
			$this->dom->LinkCustomAttributes = "";
			$this->dom->HrefValue = "";
			$this->dom->TooltipValue = "";

			// marital_status
			$this->marital_status->LinkCustomAttributes = "";
			$this->marital_status->HrefValue = "";
			$this->marital_status->TooltipValue = "";

			// spouse_details
			$this->spouse_details->LinkCustomAttributes = "";
			$this->spouse_details->HrefValue = "";
			$this->spouse_details->TooltipValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->HrefValue = "";
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
			$this->image->TooltipValue = "";

			// father_name
			$this->father_name->LinkCustomAttributes = "";
			$this->father_name->HrefValue = "";
			$this->father_name->TooltipValue = "";

			// mother_name
			$this->mother_name->LinkCustomAttributes = "";
			$this->mother_name->HrefValue = "";
			$this->mother_name->TooltipValue = "";

			// permanent_address
			$this->permanent_address->LinkCustomAttributes = "";
			$this->permanent_address->HrefValue = "";
			$this->permanent_address->TooltipValue = "";

			// mobile_other
			$this->mobile_other->LinkCustomAttributes = "";
			$this->mobile_other->HrefValue = "";
			$this->mobile_other->TooltipValue = "";

			// mobile_family
			$this->mobile_family->LinkCustomAttributes = "";
			$this->mobile_family->HrefValue = "";
			$this->mobile_family->TooltipValue = "";

			// emergency_details
			$this->emergency_details->LinkCustomAttributes = "";
			$this->emergency_details->HrefValue = "";
			$this->emergency_details->TooltipValue = "";

			// annual_income
			$this->annual_income->LinkCustomAttributes = "";
			$this->annual_income->HrefValue = "";
			$this->annual_income->TooltipValue = "";

			// work_details
			$this->work_details->LinkCustomAttributes = "";
			$this->work_details->HrefValue = "";
			$this->work_details->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// gst
			$this->gst->LinkCustomAttributes = "";
			$this->gst->HrefValue = "";
			$this->gst->TooltipValue = "";

			// aadhaar_no
			$this->aadhaar_no->LinkCustomAttributes = "";
			$this->aadhaar_no->HrefValue = "";
			$this->aadhaar_no->TooltipValue = "";

			// pan_no
			$this->pan_no->LinkCustomAttributes = "";
			$this->pan_no->HrefValue = "";
			$this->pan_no->TooltipValue = "";

			// id_proof
			$this->id_proof->LinkCustomAttributes = "";
			$this->id_proof->HrefValue = "";
			$this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;
			$this->id_proof->TooltipValue = "";

			// reference_details
			$this->reference_details->LinkCustomAttributes = "";
			$this->reference_details->HrefValue = "";
			$this->reference_details->TooltipValue = "";

			// other_details
			$this->other_details->LinkCustomAttributes = "";
			$this->other_details->HrefValue = "";
			$this->other_details->TooltipValue = "";

			// bank_name
			$this->bank_name->LinkCustomAttributes = "";
			$this->bank_name->HrefValue = "";
			$this->bank_name->TooltipValue = "";

			// bank_ifsc_code
			$this->bank_ifsc_code->LinkCustomAttributes = "";
			$this->bank_ifsc_code->HrefValue = "";
			$this->bank_ifsc_code->TooltipValue = "";

			// bank_account_no
			$this->bank_account_no->LinkCustomAttributes = "";
			$this->bank_account_no->HrefValue = "";
			$this->bank_account_no->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// formal_name
			$this->formal_name->EditAttrs["class"] = "form-control";
			$this->formal_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->formal_name->CurrentValue = HtmlDecode($this->formal_name->CurrentValue);
			$this->formal_name->EditValue = HtmlEncode($this->formal_name->CurrentValue);
			$this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

			// gender
			$this->gender->EditAttrs["class"] = "form-control";
			$this->gender->EditCustomAttributes = "";
			$this->gender->EditValue = $this->gender->options(TRUE);

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			$this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// email
			$this->_email->EditAttrs["class"] = "form-control";
			$this->_email->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
			$this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
			$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

			// address
			$this->address->EditAttrs["class"] = "form-control";
			$this->address->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->address->CurrentValue = HtmlDecode($this->address->CurrentValue);
			$this->address->EditValue = HtmlEncode($this->address->CurrentValue);
			$this->address->PlaceHolder = RemoveHtml($this->address->caption());

			// country
			$this->country->EditAttrs["class"] = "form-control";
			$this->country->EditCustomAttributes = "";
			$curVal = trim(strval($this->country->CurrentValue));
			if ($curVal <> "")
				$this->country->ViewValue = $this->country->lookupCacheOption($curVal);
			else
				$this->country->ViewValue = $this->country->Lookup !== NULL && is_array($this->country->Lookup->Options) ? $curVal : NULL;
			if ($this->country->ViewValue !== NULL) { // Load from cache
				$this->country->EditValue = array_values($this->country->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->country->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->country->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->country->EditValue = $arwrk;
			}

			// state
			$this->state->EditAttrs["class"] = "form-control";
			$this->state->EditCustomAttributes = "";
			$curVal = trim(strval($this->state->CurrentValue));
			if ($curVal <> "")
				$this->state->ViewValue = $this->state->lookupCacheOption($curVal);
			else
				$this->state->ViewValue = $this->state->Lookup !== NULL && is_array($this->state->Lookup->Options) ? $curVal : NULL;
			if ($this->state->ViewValue !== NULL) { // Load from cache
				$this->state->EditValue = array_values($this->state->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->state->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->state->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->state->EditValue = $arwrk;
			}

			// city
			$this->city->EditAttrs["class"] = "form-control";
			$this->city->EditCustomAttributes = "";
			$curVal = trim(strval($this->city->CurrentValue));
			if ($curVal <> "")
				$this->city->ViewValue = $this->city->lookupCacheOption($curVal);
			else
				$this->city->ViewValue = $this->city->Lookup !== NULL && is_array($this->city->Lookup->Options) ? $curVal : NULL;
			if ($this->city->ViewValue !== NULL) { // Load from cache
				$this->city->EditValue = array_values($this->city->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->city->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->city->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->city->EditValue = $arwrk;
			}

			// city_name
			$this->city_name->EditAttrs["class"] = "form-control";
			$this->city_name->EditCustomAttributes = 'ReadOnly';
			if (REMOVE_XSS)
				$this->city_name->CurrentValue = HtmlDecode($this->city_name->CurrentValue);
			$this->city_name->EditValue = HtmlEncode($this->city_name->CurrentValue);
			$this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

			// dob
			$this->dob->EditAttrs["class"] = "form-control";
			$this->dob->EditCustomAttributes = "";
			$this->dob->EditValue = HtmlEncode(FormatDateTime($this->dob->CurrentValue, 2));
			$this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

			// dom
			$this->dom->EditAttrs["class"] = "form-control";
			$this->dom->EditCustomAttributes = "";
			$this->dom->EditValue = HtmlEncode(FormatDateTime($this->dom->CurrentValue, 2));
			$this->dom->PlaceHolder = RemoveHtml($this->dom->caption());

			// marital_status
			$this->marital_status->EditAttrs["class"] = "form-control";
			$this->marital_status->EditCustomAttributes = "";
			$this->marital_status->EditValue = $this->marital_status->options(TRUE);

			// spouse_details
			$this->spouse_details->EditAttrs["class"] = "form-control";
			$this->spouse_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->spouse_details->CurrentValue = HtmlDecode($this->spouse_details->CurrentValue);
			$this->spouse_details->EditValue = HtmlEncode($this->spouse_details->CurrentValue);
			$this->spouse_details->PlaceHolder = RemoveHtml($this->spouse_details->caption());

			// image
			$this->image->EditAttrs["class"] = "form-control";
			$this->image->EditCustomAttributes = "";
			$this->image->UploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->EditValue = $this->image->Upload->DbValue;
			} else {
				$this->image->EditValue = "";
			}
			if (!EmptyValue($this->image->CurrentValue))
					$this->image->Upload->FileName = $this->image->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->image);

			// father_name
			$this->father_name->EditAttrs["class"] = "form-control";
			$this->father_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->father_name->CurrentValue = HtmlDecode($this->father_name->CurrentValue);
			$this->father_name->EditValue = HtmlEncode($this->father_name->CurrentValue);
			$this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

			// mother_name
			$this->mother_name->EditAttrs["class"] = "form-control";
			$this->mother_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mother_name->CurrentValue = HtmlDecode($this->mother_name->CurrentValue);
			$this->mother_name->EditValue = HtmlEncode($this->mother_name->CurrentValue);
			$this->mother_name->PlaceHolder = RemoveHtml($this->mother_name->caption());

			// permanent_address
			$this->permanent_address->EditAttrs["class"] = "form-control";
			$this->permanent_address->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->permanent_address->CurrentValue = HtmlDecode($this->permanent_address->CurrentValue);
			$this->permanent_address->EditValue = HtmlEncode($this->permanent_address->CurrentValue);
			$this->permanent_address->PlaceHolder = RemoveHtml($this->permanent_address->caption());

			// mobile_other
			$this->mobile_other->EditAttrs["class"] = "form-control";
			$this->mobile_other->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile_other->CurrentValue = HtmlDecode($this->mobile_other->CurrentValue);
			$this->mobile_other->EditValue = HtmlEncode($this->mobile_other->CurrentValue);
			$this->mobile_other->PlaceHolder = RemoveHtml($this->mobile_other->caption());

			// mobile_family
			$this->mobile_family->EditAttrs["class"] = "form-control";
			$this->mobile_family->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile_family->CurrentValue = HtmlDecode($this->mobile_family->CurrentValue);
			$this->mobile_family->EditValue = HtmlEncode($this->mobile_family->CurrentValue);
			$this->mobile_family->PlaceHolder = RemoveHtml($this->mobile_family->caption());

			// emergency_details
			$this->emergency_details->EditAttrs["class"] = "form-control";
			$this->emergency_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->emergency_details->CurrentValue = HtmlDecode($this->emergency_details->CurrentValue);
			$this->emergency_details->EditValue = HtmlEncode($this->emergency_details->CurrentValue);
			$this->emergency_details->PlaceHolder = RemoveHtml($this->emergency_details->caption());

			// annual_income
			$this->annual_income->EditAttrs["class"] = "form-control";
			$this->annual_income->EditCustomAttributes = "";
			$this->annual_income->EditValue = HtmlEncode($this->annual_income->CurrentValue);
			$this->annual_income->PlaceHolder = RemoveHtml($this->annual_income->caption());

			// work_details
			$this->work_details->EditAttrs["class"] = "form-control";
			$this->work_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->work_details->CurrentValue = HtmlDecode($this->work_details->CurrentValue);
			$this->work_details->EditValue = HtmlEncode($this->work_details->CurrentValue);
			$this->work_details->PlaceHolder = RemoveHtml($this->work_details->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// gst
			$this->gst->EditAttrs["class"] = "form-control";
			$this->gst->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->gst->CurrentValue = HtmlDecode($this->gst->CurrentValue);
			$this->gst->EditValue = HtmlEncode($this->gst->CurrentValue);
			$this->gst->PlaceHolder = RemoveHtml($this->gst->caption());

			// aadhaar_no
			$this->aadhaar_no->EditAttrs["class"] = "form-control";
			$this->aadhaar_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
			$this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->CurrentValue);
			$this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

			// pan_no
			$this->pan_no->EditAttrs["class"] = "form-control";
			$this->pan_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pan_no->CurrentValue = HtmlDecode($this->pan_no->CurrentValue);
			$this->pan_no->EditValue = HtmlEncode($this->pan_no->CurrentValue);
			$this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

			// id_proof
			$this->id_proof->EditAttrs["class"] = "form-control";
			$this->id_proof->EditCustomAttributes = "";
			$this->id_proof->UploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
			if (!EmptyValue($this->id_proof->Upload->DbValue)) {
				$this->id_proof->EditValue = $this->id_proof->Upload->DbValue;
			} else {
				$this->id_proof->EditValue = "";
			}
			if (!EmptyValue($this->id_proof->CurrentValue))
					$this->id_proof->Upload->FileName = $this->id_proof->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->id_proof);

			// reference_details
			$this->reference_details->EditAttrs["class"] = "form-control";
			$this->reference_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->reference_details->CurrentValue = HtmlDecode($this->reference_details->CurrentValue);
			$this->reference_details->EditValue = HtmlEncode($this->reference_details->CurrentValue);
			$this->reference_details->PlaceHolder = RemoveHtml($this->reference_details->caption());

			// other_details
			$this->other_details->EditAttrs["class"] = "form-control";
			$this->other_details->EditCustomAttributes = "";
			$this->other_details->EditValue = HtmlEncode($this->other_details->CurrentValue);
			$this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

			// bank_name
			$this->bank_name->EditAttrs["class"] = "form-control";
			$this->bank_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_name->CurrentValue = HtmlDecode($this->bank_name->CurrentValue);
			$this->bank_name->EditValue = HtmlEncode($this->bank_name->CurrentValue);
			$this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

			// bank_ifsc_code
			$this->bank_ifsc_code->EditAttrs["class"] = "form-control";
			$this->bank_ifsc_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_ifsc_code->CurrentValue = HtmlDecode($this->bank_ifsc_code->CurrentValue);
			$this->bank_ifsc_code->EditValue = HtmlEncode($this->bank_ifsc_code->CurrentValue);
			$this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

			// bank_account_no
			$this->bank_account_no->EditAttrs["class"] = "form-control";
			$this->bank_account_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_account_no->CurrentValue = HtmlDecode($this->bank_account_no->CurrentValue);
			$this->bank_account_no->EditValue = HtmlEncode($this->bank_account_no->CurrentValue);
			$this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// formal_name
			$this->formal_name->LinkCustomAttributes = "";
			$this->formal_name->HrefValue = "";

			// gender
			$this->gender->LinkCustomAttributes = "";
			$this->gender->HrefValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";

			// country
			$this->country->LinkCustomAttributes = "";
			$this->country->HrefValue = "";

			// state
			$this->state->LinkCustomAttributes = "";
			$this->state->HrefValue = "";

			// city
			$this->city->LinkCustomAttributes = "";
			$this->city->HrefValue = "";

			// city_name
			$this->city_name->LinkCustomAttributes = "";
			$this->city_name->HrefValue = "";

			// dob
			$this->dob->LinkCustomAttributes = "";
			$this->dob->HrefValue = "";

			// dom
			$this->dom->LinkCustomAttributes = "";
			$this->dom->HrefValue = "";

			// marital_status
			$this->marital_status->LinkCustomAttributes = "";
			$this->marital_status->HrefValue = "";

			// spouse_details
			$this->spouse_details->LinkCustomAttributes = "";
			$this->spouse_details->HrefValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->HrefValue = "";
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

			// father_name
			$this->father_name->LinkCustomAttributes = "";
			$this->father_name->HrefValue = "";

			// mother_name
			$this->mother_name->LinkCustomAttributes = "";
			$this->mother_name->HrefValue = "";

			// permanent_address
			$this->permanent_address->LinkCustomAttributes = "";
			$this->permanent_address->HrefValue = "";

			// mobile_other
			$this->mobile_other->LinkCustomAttributes = "";
			$this->mobile_other->HrefValue = "";

			// mobile_family
			$this->mobile_family->LinkCustomAttributes = "";
			$this->mobile_family->HrefValue = "";

			// emergency_details
			$this->emergency_details->LinkCustomAttributes = "";
			$this->emergency_details->HrefValue = "";

			// annual_income
			$this->annual_income->LinkCustomAttributes = "";
			$this->annual_income->HrefValue = "";

			// work_details
			$this->work_details->LinkCustomAttributes = "";
			$this->work_details->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// gst
			$this->gst->LinkCustomAttributes = "";
			$this->gst->HrefValue = "";

			// aadhaar_no
			$this->aadhaar_no->LinkCustomAttributes = "";
			$this->aadhaar_no->HrefValue = "";

			// pan_no
			$this->pan_no->LinkCustomAttributes = "";
			$this->pan_no->HrefValue = "";

			// id_proof
			$this->id_proof->LinkCustomAttributes = "";
			$this->id_proof->HrefValue = "";
			$this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;

			// reference_details
			$this->reference_details->LinkCustomAttributes = "";
			$this->reference_details->HrefValue = "";

			// other_details
			$this->other_details->LinkCustomAttributes = "";
			$this->other_details->HrefValue = "";

			// bank_name
			$this->bank_name->LinkCustomAttributes = "";
			$this->bank_name->HrefValue = "";

			// bank_ifsc_code
			$this->bank_ifsc_code->LinkCustomAttributes = "";
			$this->bank_ifsc_code->HrefValue = "";

			// bank_account_no
			$this->bank_account_no->LinkCustomAttributes = "";
			$this->bank_account_no->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->formal_name->Required) {
			if (!$this->formal_name->IsDetailKey && $this->formal_name->FormValue != NULL && $this->formal_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->formal_name->caption(), $this->formal_name->RequiredErrorMessage));
			}
		}
		if ($this->gender->Required) {
			if (!$this->gender->IsDetailKey && $this->gender->FormValue != NULL && $this->gender->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gender->caption(), $this->gender->RequiredErrorMessage));
			}
		}
		if ($this->mobile->Required) {
			if (!$this->mobile->IsDetailKey && $this->mobile->FormValue != NULL && $this->mobile->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->mobile->FormValue)) {
			AddMessage($FormError, $this->mobile->errorMessage());
		}
		if ($this->_email->Required) {
			if (!$this->_email->IsDetailKey && $this->_email->FormValue != NULL && $this->_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
			}
		}
		if (!CheckEmail($this->_email->FormValue)) {
			AddMessage($FormError, $this->_email->errorMessage());
		}
		if ($this->address->Required) {
			if (!$this->address->IsDetailKey && $this->address->FormValue != NULL && $this->address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
			}
		}
		if ($this->country->Required) {
			if (!$this->country->IsDetailKey && $this->country->FormValue != NULL && $this->country->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->country->caption(), $this->country->RequiredErrorMessage));
			}
		}
		if ($this->state->Required) {
			if (!$this->state->IsDetailKey && $this->state->FormValue != NULL && $this->state->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->state->caption(), $this->state->RequiredErrorMessage));
			}
		}
		if ($this->city->Required) {
			if (!$this->city->IsDetailKey && $this->city->FormValue != NULL && $this->city->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->city->caption(), $this->city->RequiredErrorMessage));
			}
		}
		if ($this->city_name->Required) {
			if (!$this->city_name->IsDetailKey && $this->city_name->FormValue != NULL && $this->city_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->city_name->caption(), $this->city_name->RequiredErrorMessage));
			}
		}
		if ($this->dob->Required) {
			if (!$this->dob->IsDetailKey && $this->dob->FormValue != NULL && $this->dob->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dob->caption(), $this->dob->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->dob->FormValue)) {
			AddMessage($FormError, $this->dob->errorMessage());
		}
		if ($this->dom->Required) {
			if (!$this->dom->IsDetailKey && $this->dom->FormValue != NULL && $this->dom->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dom->caption(), $this->dom->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->dom->FormValue)) {
			AddMessage($FormError, $this->dom->errorMessage());
		}
		if ($this->marital_status->Required) {
			if (!$this->marital_status->IsDetailKey && $this->marital_status->FormValue != NULL && $this->marital_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->marital_status->caption(), $this->marital_status->RequiredErrorMessage));
			}
		}
		if ($this->spouse_details->Required) {
			if (!$this->spouse_details->IsDetailKey && $this->spouse_details->FormValue != NULL && $this->spouse_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->spouse_details->caption(), $this->spouse_details->RequiredErrorMessage));
			}
		}
		if ($this->image->Required) {
			if ($this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
			}
		}
		if ($this->father_name->Required) {
			if (!$this->father_name->IsDetailKey && $this->father_name->FormValue != NULL && $this->father_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->father_name->caption(), $this->father_name->RequiredErrorMessage));
			}
		}
		if ($this->mother_name->Required) {
			if (!$this->mother_name->IsDetailKey && $this->mother_name->FormValue != NULL && $this->mother_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mother_name->caption(), $this->mother_name->RequiredErrorMessage));
			}
		}
		if ($this->permanent_address->Required) {
			if (!$this->permanent_address->IsDetailKey && $this->permanent_address->FormValue != NULL && $this->permanent_address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->permanent_address->caption(), $this->permanent_address->RequiredErrorMessage));
			}
		}
		if ($this->mobile_other->Required) {
			if (!$this->mobile_other->IsDetailKey && $this->mobile_other->FormValue != NULL && $this->mobile_other->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile_other->caption(), $this->mobile_other->RequiredErrorMessage));
			}
		}
		if ($this->mobile_family->Required) {
			if (!$this->mobile_family->IsDetailKey && $this->mobile_family->FormValue != NULL && $this->mobile_family->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile_family->caption(), $this->mobile_family->RequiredErrorMessage));
			}
		}
		if ($this->emergency_details->Required) {
			if (!$this->emergency_details->IsDetailKey && $this->emergency_details->FormValue != NULL && $this->emergency_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emergency_details->caption(), $this->emergency_details->RequiredErrorMessage));
			}
		}
		if ($this->annual_income->Required) {
			if (!$this->annual_income->IsDetailKey && $this->annual_income->FormValue != NULL && $this->annual_income->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->annual_income->caption(), $this->annual_income->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->annual_income->FormValue)) {
			AddMessage($FormError, $this->annual_income->errorMessage());
		}
		if ($this->work_details->Required) {
			if (!$this->work_details->IsDetailKey && $this->work_details->FormValue != NULL && $this->work_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->work_details->caption(), $this->work_details->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->gst->Required) {
			if (!$this->gst->IsDetailKey && $this->gst->FormValue != NULL && $this->gst->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gst->caption(), $this->gst->RequiredErrorMessage));
			}
		}
		if ($this->aadhaar_no->Required) {
			if (!$this->aadhaar_no->IsDetailKey && $this->aadhaar_no->FormValue != NULL && $this->aadhaar_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->aadhaar_no->caption(), $this->aadhaar_no->RequiredErrorMessage));
			}
		}
		if ($this->pan_no->Required) {
			if (!$this->pan_no->IsDetailKey && $this->pan_no->FormValue != NULL && $this->pan_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pan_no->caption(), $this->pan_no->RequiredErrorMessage));
			}
		}
		if ($this->id_proof->Required) {
			if ($this->id_proof->Upload->FileName == "" && !$this->id_proof->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->id_proof->caption(), $this->id_proof->RequiredErrorMessage));
			}
		}
		if ($this->reference_details->Required) {
			if (!$this->reference_details->IsDetailKey && $this->reference_details->FormValue != NULL && $this->reference_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reference_details->caption(), $this->reference_details->RequiredErrorMessage));
			}
		}
		if ($this->other_details->Required) {
			if (!$this->other_details->IsDetailKey && $this->other_details->FormValue != NULL && $this->other_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other_details->caption(), $this->other_details->RequiredErrorMessage));
			}
		}
		if ($this->bank_name->Required) {
			if (!$this->bank_name->IsDetailKey && $this->bank_name->FormValue != NULL && $this->bank_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bank_name->caption(), $this->bank_name->RequiredErrorMessage));
			}
		}
		if ($this->bank_ifsc_code->Required) {
			if (!$this->bank_ifsc_code->IsDetailKey && $this->bank_ifsc_code->FormValue != NULL && $this->bank_ifsc_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bank_ifsc_code->caption(), $this->bank_ifsc_code->RequiredErrorMessage));
			}
		}
		if ($this->bank_account_no->Required) {
			if (!$this->bank_account_no->IsDetailKey && $this->bank_account_no->FormValue != NULL && $this->bank_account_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bank_account_no->caption(), $this->bank_account_no->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$this->image->OldUploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
			$this->image->UploadPath = $this->image->OldUploadPath;
			$this->id_proof->OldUploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
			$this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
			$rsnew = [];

			// formal_name
			$this->formal_name->setDbValueDef($rsnew, $this->formal_name->CurrentValue, NULL, $this->formal_name->ReadOnly);

			// gender
			$this->gender->setDbValueDef($rsnew, $this->gender->CurrentValue, NULL, $this->gender->ReadOnly);

			// mobile
			$this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, NULL, $this->mobile->ReadOnly);

			// email
			$this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, NULL, $this->_email->ReadOnly);

			// address
			$this->address->setDbValueDef($rsnew, $this->address->CurrentValue, NULL, $this->address->ReadOnly);

			// country
			$this->country->setDbValueDef($rsnew, $this->country->CurrentValue, NULL, $this->country->ReadOnly);

			// state
			$this->state->setDbValueDef($rsnew, $this->state->CurrentValue, NULL, $this->state->ReadOnly);

			// city
			$this->city->setDbValueDef($rsnew, $this->city->CurrentValue, NULL, $this->city->ReadOnly);

			// city_name
			$this->city_name->setDbValueDef($rsnew, $this->city_name->CurrentValue, NULL, $this->city_name->ReadOnly);

			// dob
			$this->dob->setDbValueDef($rsnew, UnFormatDateTime($this->dob->CurrentValue, 2), NULL, $this->dob->ReadOnly);

			// dom
			$this->dom->setDbValueDef($rsnew, UnFormatDateTime($this->dom->CurrentValue, 2), NULL, $this->dom->ReadOnly);

			// marital_status
			$this->marital_status->setDbValueDef($rsnew, $this->marital_status->CurrentValue, NULL, $this->marital_status->ReadOnly);

			// spouse_details
			$this->spouse_details->setDbValueDef($rsnew, $this->spouse_details->CurrentValue, NULL, $this->spouse_details->ReadOnly);

			// image
			if ($this->image->Visible && !$this->image->ReadOnly && !$this->image->Upload->KeepFile) {
				$this->image->Upload->DbValue = $rsold['image']; // Get original value
				if ($this->image->Upload->FileName == "") {
					$rsnew['image'] = NULL;
				} else {
					$rsnew['image'] = $this->image->Upload->FileName;
				}
				$this->image->ImageWidth = 600; // Resize width
				$this->image->ImageHeight = 600; // Resize height
			}

			// father_name
			$this->father_name->setDbValueDef($rsnew, $this->father_name->CurrentValue, NULL, $this->father_name->ReadOnly);

			// mother_name
			$this->mother_name->setDbValueDef($rsnew, $this->mother_name->CurrentValue, NULL, $this->mother_name->ReadOnly);

			// permanent_address
			$this->permanent_address->setDbValueDef($rsnew, $this->permanent_address->CurrentValue, NULL, $this->permanent_address->ReadOnly);

			// mobile_other
			$this->mobile_other->setDbValueDef($rsnew, $this->mobile_other->CurrentValue, NULL, $this->mobile_other->ReadOnly);

			// mobile_family
			$this->mobile_family->setDbValueDef($rsnew, $this->mobile_family->CurrentValue, NULL, $this->mobile_family->ReadOnly);

			// emergency_details
			$this->emergency_details->setDbValueDef($rsnew, $this->emergency_details->CurrentValue, NULL, $this->emergency_details->ReadOnly);

			// annual_income
			$this->annual_income->setDbValueDef($rsnew, $this->annual_income->CurrentValue, NULL, $this->annual_income->ReadOnly);

			// work_details
			$this->work_details->setDbValueDef($rsnew, $this->work_details->CurrentValue, NULL, $this->work_details->ReadOnly);

			// status
			$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, NULL, $this->status->ReadOnly);

			// gst
			$this->gst->setDbValueDef($rsnew, $this->gst->CurrentValue, NULL, $this->gst->ReadOnly);

			// aadhaar_no
			$this->aadhaar_no->setDbValueDef($rsnew, $this->aadhaar_no->CurrentValue, NULL, $this->aadhaar_no->ReadOnly);

			// pan_no
			$this->pan_no->setDbValueDef($rsnew, $this->pan_no->CurrentValue, NULL, $this->pan_no->ReadOnly);

			// id_proof
			if ($this->id_proof->Visible && !$this->id_proof->ReadOnly && !$this->id_proof->Upload->KeepFile) {
				$this->id_proof->Upload->DbValue = $rsold['id_proof']; // Get original value
				if ($this->id_proof->Upload->FileName == "") {
					$rsnew['id_proof'] = NULL;
				} else {
					$rsnew['id_proof'] = $this->id_proof->Upload->FileName;
				}
				$this->id_proof->ImageWidth = 600; // Resize width
				$this->id_proof->ImageHeight = 600; // Resize height
			}

			// reference_details
			$this->reference_details->setDbValueDef($rsnew, $this->reference_details->CurrentValue, NULL, $this->reference_details->ReadOnly);

			// other_details
			$this->other_details->setDbValueDef($rsnew, $this->other_details->CurrentValue, NULL, $this->other_details->ReadOnly);

			// bank_name
			$this->bank_name->setDbValueDef($rsnew, $this->bank_name->CurrentValue, NULL, $this->bank_name->ReadOnly);

			// bank_ifsc_code
			$this->bank_ifsc_code->setDbValueDef($rsnew, $this->bank_ifsc_code->CurrentValue, NULL, $this->bank_ifsc_code->ReadOnly);

			// bank_account_no
			$this->bank_account_no->setDbValueDef($rsnew, $this->bank_account_no->CurrentValue, NULL, $this->bank_account_no->ReadOnly);
			if ($this->image->Visible && !$this->image->Upload->KeepFile) {
				$this->image->UploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
				$oldFiles = EmptyValue($this->image->Upload->DbValue) ? array() : array($this->image->Upload->DbValue);
				if (!EmptyValue($this->image->Upload->FileName)) {
					$newFiles = array($this->image->Upload->FileName);
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->image, $this->image->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->image->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->image, $this->image->Upload->Index) . $file1) || file_exists($this->image->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->image->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->image, $this->image->Upload->Index) . $file, UploadTempPath($this->image, $this->image->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->image->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->image->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->image->setDbValueDef($rsnew, $this->image->Upload->FileName, NULL, $this->image->ReadOnly);
				}
			}
			if ($this->id_proof->Visible && !$this->id_proof->Upload->KeepFile) {
				$this->id_proof->UploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
				$oldFiles = EmptyValue($this->id_proof->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->id_proof->Upload->DbValue));
				if (!EmptyValue($this->id_proof->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->id_proof->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->id_proof, $this->id_proof->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->id_proof->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->id_proof, $this->id_proof->Upload->Index) . $file1) || file_exists($this->id_proof->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->id_proof->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->id_proof, $this->id_proof->Upload->Index) . $file, UploadTempPath($this->id_proof, $this->id_proof->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->id_proof->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->id_proof->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->id_proof->setDbValueDef($rsnew, $this->id_proof->Upload->FileName, NULL, $this->id_proof->ReadOnly);
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
					if ($this->image->Visible && !$this->image->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->image->Upload->DbValue) ? array() : array($this->image->Upload->DbValue);
						if (!EmptyValue($this->image->Upload->FileName)) {
							$newFiles = array($this->image->Upload->FileName);
							$newFiles2 = array($rsnew['image']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->image, $this->image->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->image->Upload->resizeAndSaveToFile($this->image->ImageWidth, $this->image->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->image->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->id_proof->Visible && !$this->id_proof->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->id_proof->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->id_proof->Upload->DbValue));
						if (!EmptyValue($this->id_proof->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->id_proof->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['id_proof']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->id_proof, $this->id_proof->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->id_proof->Upload->resizeAndSaveToFile($this->id_proof->ImageWidth, $this->id_proof->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->id_proof->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// image
		if ($this->image->Upload->FileToken <> "")
			CleanUploadTempPath($this->image->Upload->FileToken, $this->image->Upload->Index);
		else
			CleanUploadTempPath($this->image, $this->image->Upload->Index);

		// id_proof
		if ($this->id_proof->Upload->FileToken <> "")
			CleanUploadTempPath($this->id_proof->Upload->FileToken, $this->id_proof->Upload->Index);
		else
			CleanUploadTempPath($this->id_proof, $this->id_proof->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("personal_infolist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_country":
							break;
						case "x_state":
							break;
						case "x_city":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'personal_info');		
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>