<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class personal_info_search extends personal_info
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'personal_info';

	// Page object name
	public $PageObjName = "personal_info_search";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (personal_info)
		if (!isset($GLOBALS["personal_info"]) || get_class($GLOBALS["personal_info"]) == PROJECT_NAMESPACE . "personal_info") {
			$GLOBALS["personal_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["personal_info"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'personal_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $personal_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($personal_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "personal_infoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("personal_infolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->formal_name->setVisibility();
		$this->gender->setVisibility();
		$this->mobile->setVisibility();
		$this->_email->setVisibility();
		$this->address->setVisibility();
		$this->country->setVisibility();
		$this->state->setVisibility();
		$this->city->setVisibility();
		$this->city_name->setVisibility();
		$this->dob->setVisibility();
		$this->dom->setVisibility();
		$this->marital_status->setVisibility();
		$this->spouse_details->setVisibility();
		$this->image->setVisibility();
		$this->father_name->setVisibility();
		$this->mother_name->setVisibility();
		$this->permanent_address->setVisibility();
		$this->mobile_other->setVisibility();
		$this->mobile_family->setVisibility();
		$this->emergency_details->setVisibility();
		$this->annual_income->setVisibility();
		$this->work_details->setVisibility();
		$this->status->setVisibility();
		$this->gst->setVisibility();
		$this->aadhaar_no->setVisibility();
		$this->pan_no->setVisibility();
		$this->id_proof->setVisibility();
		$this->reference_details->setVisibility();
		$this->other_details->setVisibility();
		$this->bank_name->setVisibility();
		$this->bank_ifsc_code->setVisibility();
		$this->bank_account_no->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->country);
		$this->setupLookupOptions($this->state);
		$this->setupLookupOptions($this->city);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "personal_infolist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->formal_name); // formal_name
		$this->buildSearchUrl($srchUrl, $this->gender); // gender
		$this->buildSearchUrl($srchUrl, $this->mobile); // mobile
		$this->buildSearchUrl($srchUrl, $this->_email); // email
		$this->buildSearchUrl($srchUrl, $this->address); // address
		$this->buildSearchUrl($srchUrl, $this->country); // country
		$this->buildSearchUrl($srchUrl, $this->state); // state
		$this->buildSearchUrl($srchUrl, $this->city); // city
		$this->buildSearchUrl($srchUrl, $this->city_name); // city_name
		$this->buildSearchUrl($srchUrl, $this->dob); // dob
		$this->buildSearchUrl($srchUrl, $this->dom); // dom
		$this->buildSearchUrl($srchUrl, $this->marital_status); // marital_status
		$this->buildSearchUrl($srchUrl, $this->spouse_details); // spouse_details
		$this->buildSearchUrl($srchUrl, $this->image); // image
		$this->buildSearchUrl($srchUrl, $this->father_name); // father_name
		$this->buildSearchUrl($srchUrl, $this->mother_name); // mother_name
		$this->buildSearchUrl($srchUrl, $this->permanent_address); // permanent_address
		$this->buildSearchUrl($srchUrl, $this->mobile_other); // mobile_other
		$this->buildSearchUrl($srchUrl, $this->mobile_family); // mobile_family
		$this->buildSearchUrl($srchUrl, $this->emergency_details); // emergency_details
		$this->buildSearchUrl($srchUrl, $this->annual_income); // annual_income
		$this->buildSearchUrl($srchUrl, $this->work_details); // work_details
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->gst); // gst
		$this->buildSearchUrl($srchUrl, $this->aadhaar_no); // aadhaar_no
		$this->buildSearchUrl($srchUrl, $this->pan_no); // pan_no
		$this->buildSearchUrl($srchUrl, $this->id_proof); // id_proof
		$this->buildSearchUrl($srchUrl, $this->reference_details); // reference_details
		$this->buildSearchUrl($srchUrl, $this->other_details); // other_details
		$this->buildSearchUrl($srchUrl, $this->bank_name); // bank_name
		$this->buildSearchUrl($srchUrl, $this->bank_ifsc_code); // bank_ifsc_code
		$this->buildSearchUrl($srchUrl, $this->bank_account_no); // bank_account_no
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// formal_name

		if (!$this->isAddOrEdit())
			$this->formal_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_formal_name"));
		$this->formal_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_formal_name"));

		// gender
		if (!$this->isAddOrEdit())
			$this->gender->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_gender"));
		$this->gender->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_gender"));

		// mobile
		if (!$this->isAddOrEdit())
			$this->mobile->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_mobile"));
		$this->mobile->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_mobile"));

		// email
		if (!$this->isAddOrEdit())
			$this->_email->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__email"));
		$this->_email->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__email"));

		// address
		if (!$this->isAddOrEdit())
			$this->address->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_address"));
		$this->address->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_address"));

		// country
		if (!$this->isAddOrEdit())
			$this->country->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_country"));
		$this->country->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_country"));

		// state
		if (!$this->isAddOrEdit())
			$this->state->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_state"));
		$this->state->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_state"));

		// city
		if (!$this->isAddOrEdit())
			$this->city->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_city"));
		$this->city->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_city"));

		// city_name
		if (!$this->isAddOrEdit())
			$this->city_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_city_name"));
		$this->city_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_city_name"));

		// dob
		if (!$this->isAddOrEdit())
			$this->dob->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_dob"));
		$this->dob->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_dob"));

		// dom
		if (!$this->isAddOrEdit())
			$this->dom->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_dom"));
		$this->dom->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_dom"));

		// marital_status
		if (!$this->isAddOrEdit())
			$this->marital_status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_marital_status"));
		$this->marital_status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_marital_status"));

		// spouse_details
		if (!$this->isAddOrEdit())
			$this->spouse_details->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_spouse_details"));
		$this->spouse_details->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_spouse_details"));

		// image
		if (!$this->isAddOrEdit())
			$this->image->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_image"));
		$this->image->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_image"));

		// father_name
		if (!$this->isAddOrEdit())
			$this->father_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_father_name"));
		$this->father_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_father_name"));

		// mother_name
		if (!$this->isAddOrEdit())
			$this->mother_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_mother_name"));
		$this->mother_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_mother_name"));

		// permanent_address
		if (!$this->isAddOrEdit())
			$this->permanent_address->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_permanent_address"));
		$this->permanent_address->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_permanent_address"));

		// mobile_other
		if (!$this->isAddOrEdit())
			$this->mobile_other->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_mobile_other"));
		$this->mobile_other->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_mobile_other"));

		// mobile_family
		if (!$this->isAddOrEdit())
			$this->mobile_family->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_mobile_family"));
		$this->mobile_family->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_mobile_family"));

		// emergency_details
		if (!$this->isAddOrEdit())
			$this->emergency_details->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_emergency_details"));
		$this->emergency_details->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_emergency_details"));

		// annual_income
		if (!$this->isAddOrEdit())
			$this->annual_income->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_annual_income"));
		$this->annual_income->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_annual_income"));

		// work_details
		if (!$this->isAddOrEdit())
			$this->work_details->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_work_details"));
		$this->work_details->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_work_details"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// gst
		if (!$this->isAddOrEdit())
			$this->gst->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_gst"));
		$this->gst->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_gst"));

		// aadhaar_no
		if (!$this->isAddOrEdit())
			$this->aadhaar_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_aadhaar_no"));
		$this->aadhaar_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_aadhaar_no"));

		// pan_no
		if (!$this->isAddOrEdit())
			$this->pan_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pan_no"));
		$this->pan_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pan_no"));

		// id_proof
		if (!$this->isAddOrEdit())
			$this->id_proof->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id_proof"));
		$this->id_proof->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id_proof"));

		// reference_details
		if (!$this->isAddOrEdit())
			$this->reference_details->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_reference_details"));
		$this->reference_details->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_reference_details"));

		// other_details
		if (!$this->isAddOrEdit())
			$this->other_details->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_other_details"));
		$this->other_details->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_other_details"));

		// bank_name
		if (!$this->isAddOrEdit())
			$this->bank_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_bank_name"));
		$this->bank_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_bank_name"));

		// bank_ifsc_code
		if (!$this->isAddOrEdit())
			$this->bank_ifsc_code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_bank_ifsc_code"));
		$this->bank_ifsc_code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_bank_ifsc_code"));

		// bank_account_no
		if (!$this->isAddOrEdit())
			$this->bank_account_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_bank_account_no"));
		$this->bank_account_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_bank_account_no"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// formal_name
		// gender
		// mobile
		// email
		// address
		// country
		// state
		// city
		// city_name
		// dob
		// dom
		// marital_status
		// spouse_details
		// image
		// father_name
		// mother_name
		// permanent_address
		// mobile_other
		// mobile_family
		// emergency_details
		// annual_income
		// work_details
		// status
		// gst
		// aadhaar_no
		// pan_no
		// id_proof
		// reference_details
		// other_details
		// bank_name
		// bank_ifsc_code
		// bank_account_no
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// formal_name
			$this->formal_name->ViewValue = $this->formal_name->CurrentValue;
			$this->formal_name->ViewCustomAttributes = "";

			// gender
			if (strval($this->gender->CurrentValue) <> "") {
				$this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
			} else {
				$this->gender->ViewValue = NULL;
			}
			$this->gender->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, 0, -2, -2, -2);
			$this->mobile->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// address
			$this->address->ViewValue = $this->address->CurrentValue;
			$this->address->ViewCustomAttributes = "";

			// country
			$curVal = strval($this->country->CurrentValue);
			if ($curVal <> "") {
				$this->country->ViewValue = $this->country->lookupCacheOption($curVal);
				if ($this->country->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->country->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->country->ViewValue = $this->country->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->country->ViewValue = $this->country->CurrentValue;
					}
				}
			} else {
				$this->country->ViewValue = NULL;
			}
			$this->country->ViewCustomAttributes = "";

			// state
			$curVal = strval($this->state->CurrentValue);
			if ($curVal <> "") {
				$this->state->ViewValue = $this->state->lookupCacheOption($curVal);
				if ($this->state->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->state->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->state->ViewValue = $this->state->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->state->ViewValue = $this->state->CurrentValue;
					}
				}
			} else {
				$this->state->ViewValue = NULL;
			}
			$this->state->ViewCustomAttributes = "";

			// city
			$curVal = strval($this->city->CurrentValue);
			if ($curVal <> "") {
				$this->city->ViewValue = $this->city->lookupCacheOption($curVal);
				if ($this->city->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->city->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->city->ViewValue = $this->city->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->city->ViewValue = $this->city->CurrentValue;
					}
				}
			} else {
				$this->city->ViewValue = NULL;
			}
			$this->city->ViewCustomAttributes = "";

			// city_name
			$this->city_name->ViewValue = $this->city_name->CurrentValue;
			$this->city_name->ViewCustomAttributes = "";

			// dob
			$this->dob->ViewValue = $this->dob->CurrentValue;
			$this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, 2);
			$this->dob->ViewCustomAttributes = "";

			// dom
			$this->dom->ViewValue = $this->dom->CurrentValue;
			$this->dom->ViewValue = FormatDateTime($this->dom->ViewValue, 2);
			$this->dom->ViewCustomAttributes = "";

			// marital_status
			if (strval($this->marital_status->CurrentValue) <> "") {
				$this->marital_status->ViewValue = $this->marital_status->optionCaption($this->marital_status->CurrentValue);
			} else {
				$this->marital_status->ViewValue = NULL;
			}
			$this->marital_status->ViewCustomAttributes = "";

			// spouse_details
			$this->spouse_details->ViewValue = $this->spouse_details->CurrentValue;
			$this->spouse_details->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// father_name
			$this->father_name->ViewValue = $this->father_name->CurrentValue;
			$this->father_name->ViewCustomAttributes = "";

			// mother_name
			$this->mother_name->ViewValue = $this->mother_name->CurrentValue;
			$this->mother_name->ViewCustomAttributes = "";

			// permanent_address
			$this->permanent_address->ViewValue = $this->permanent_address->CurrentValue;
			$this->permanent_address->ViewCustomAttributes = "";

			// mobile_other
			$this->mobile_other->ViewValue = $this->mobile_other->CurrentValue;
			$this->mobile_other->ViewCustomAttributes = "";

			// mobile_family
			$this->mobile_family->ViewValue = $this->mobile_family->CurrentValue;
			$this->mobile_family->ViewCustomAttributes = "";

			// emergency_details
			$this->emergency_details->ViewValue = $this->emergency_details->CurrentValue;
			$this->emergency_details->ViewCustomAttributes = "";

			// annual_income
			$this->annual_income->ViewValue = $this->annual_income->CurrentValue;
			$this->annual_income->ViewValue = FormatNumber($this->annual_income->ViewValue, 0, -2, -2, -2);
			$this->annual_income->ViewCustomAttributes = "";

			// work_details
			$this->work_details->ViewValue = $this->work_details->CurrentValue;
			$this->work_details->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// gst
			$this->gst->ViewValue = $this->gst->CurrentValue;
			$this->gst->ViewCustomAttributes = "";

			// aadhaar_no
			$this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;
			$this->aadhaar_no->ViewCustomAttributes = "";

			// pan_no
			$this->pan_no->ViewValue = $this->pan_no->CurrentValue;
			$this->pan_no->ViewCustomAttributes = "";

			// id_proof
			$this->id_proof->UploadPath = '.p_uploads/personal_info/'.  $this->id->CurrentValue . '/';
			if (!EmptyValue($this->id_proof->Upload->DbValue)) {
				$this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
			} else {
				$this->id_proof->ViewValue = "";
			}
			$this->id_proof->ViewCustomAttributes = "";

			// reference_details
			$this->reference_details->ViewValue = $this->reference_details->CurrentValue;
			$this->reference_details->ViewCustomAttributes = "";

			// other_details
			$this->other_details->ViewValue = $this->other_details->CurrentValue;
			$this->other_details->ViewCustomAttributes = "";

			// bank_name
			$this->bank_name->ViewValue = $this->bank_name->CurrentValue;
			$this->bank_name->ViewCustomAttributes = "";

			// bank_ifsc_code
			$this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;
			$this->bank_ifsc_code->ViewCustomAttributes = "";

			// bank_account_no
			$this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;
			$this->bank_account_no->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// formal_name
			$this->formal_name->LinkCustomAttributes = "";
			$this->formal_name->HrefValue = "";
			$this->formal_name->TooltipValue = "";

			// gender
			$this->gender->LinkCustomAttributes = "";
			$this->gender->HrefValue = "";
			$this->gender->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";
			$this->address->TooltipValue = "";

			// country
			$this->country->LinkCustomAttributes = "";
			$this->country->HrefValue = "";
			$this->country->TooltipValue = "";

			// state
			$this->state->LinkCustomAttributes = "";
			$this->state->HrefValue = "";
			$this->state->TooltipValue = "";

			// city
			$this->city->LinkCustomAttributes = "";
			$this->city->HrefValue = "";
			$this->city->TooltipValue = "";

			// city_name
			$this->city_name->LinkCustomAttributes = "";
			$this->city_name->HrefValue = "";
			$this->city_name->TooltipValue = "";

			// dob
			$this->dob->LinkCustomAttributes = "";
			$this->dob->HrefValue = "";
			$this->dob->TooltipValue = "";

			// dom
			$this->dom->LinkCustomAttributes = "";
			$this->dom->HrefValue = "";
			$this->dom->TooltipValue = "";

			// marital_status
			$this->marital_status->LinkCustomAttributes = "";
			$this->marital_status->HrefValue = "";
			$this->marital_status->TooltipValue = "";

			// spouse_details
			$this->spouse_details->LinkCustomAttributes = "";
			$this->spouse_details->HrefValue = "";
			$this->spouse_details->TooltipValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->HrefValue = "";
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
			$this->image->TooltipValue = "";

			// father_name
			$this->father_name->LinkCustomAttributes = "";
			$this->father_name->HrefValue = "";
			$this->father_name->TooltipValue = "";

			// mother_name
			$this->mother_name->LinkCustomAttributes = "";
			$this->mother_name->HrefValue = "";
			$this->mother_name->TooltipValue = "";

			// permanent_address
			$this->permanent_address->LinkCustomAttributes = "";
			$this->permanent_address->HrefValue = "";
			$this->permanent_address->TooltipValue = "";

			// mobile_other
			$this->mobile_other->LinkCustomAttributes = "";
			$this->mobile_other->HrefValue = "";
			$this->mobile_other->TooltipValue = "";

			// mobile_family
			$this->mobile_family->LinkCustomAttributes = "";
			$this->mobile_family->HrefValue = "";
			$this->mobile_family->TooltipValue = "";

			// emergency_details
			$this->emergency_details->LinkCustomAttributes = "";
			$this->emergency_details->HrefValue = "";
			$this->emergency_details->TooltipValue = "";

			// annual_income
			$this->annual_income->LinkCustomAttributes = "";
			$this->annual_income->HrefValue = "";
			$this->annual_income->TooltipValue = "";

			// work_details
			$this->work_details->LinkCustomAttributes = "";
			$this->work_details->HrefValue = "";
			$this->work_details->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// gst
			$this->gst->LinkCustomAttributes = "";
			$this->gst->HrefValue = "";
			$this->gst->TooltipValue = "";

			// aadhaar_no
			$this->aadhaar_no->LinkCustomAttributes = "";
			$this->aadhaar_no->HrefValue = "";
			$this->aadhaar_no->TooltipValue = "";

			// pan_no
			$this->pan_no->LinkCustomAttributes = "";
			$this->pan_no->HrefValue = "";
			$this->pan_no->TooltipValue = "";

			// id_proof
			$this->id_proof->LinkCustomAttributes = "";
			$this->id_proof->HrefValue = "";
			$this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;
			$this->id_proof->TooltipValue = "";

			// reference_details
			$this->reference_details->LinkCustomAttributes = "";
			$this->reference_details->HrefValue = "";
			$this->reference_details->TooltipValue = "";

			// other_details
			$this->other_details->LinkCustomAttributes = "";
			$this->other_details->HrefValue = "";
			$this->other_details->TooltipValue = "";

			// bank_name
			$this->bank_name->LinkCustomAttributes = "";
			$this->bank_name->HrefValue = "";
			$this->bank_name->TooltipValue = "";

			// bank_ifsc_code
			$this->bank_ifsc_code->LinkCustomAttributes = "";
			$this->bank_ifsc_code->HrefValue = "";
			$this->bank_ifsc_code->TooltipValue = "";

			// bank_account_no
			$this->bank_account_no->LinkCustomAttributes = "";
			$this->bank_account_no->HrefValue = "";
			$this->bank_account_no->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// formal_name
			$this->formal_name->EditAttrs["class"] = "form-control";
			$this->formal_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->formal_name->AdvancedSearch->SearchValue = HtmlDecode($this->formal_name->AdvancedSearch->SearchValue);
			$this->formal_name->EditValue = HtmlEncode($this->formal_name->AdvancedSearch->SearchValue);
			$this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

			// gender
			$this->gender->EditAttrs["class"] = "form-control";
			$this->gender->EditCustomAttributes = "";
			$this->gender->EditValue = $this->gender->options(TRUE);

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			$this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// email
			$this->_email->EditAttrs["class"] = "form-control";
			$this->_email->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_email->AdvancedSearch->SearchValue = HtmlDecode($this->_email->AdvancedSearch->SearchValue);
			$this->_email->EditValue = HtmlEncode($this->_email->AdvancedSearch->SearchValue);
			$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

			// address
			$this->address->EditAttrs["class"] = "form-control";
			$this->address->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->address->AdvancedSearch->SearchValue = HtmlDecode($this->address->AdvancedSearch->SearchValue);
			$this->address->EditValue = HtmlEncode($this->address->AdvancedSearch->SearchValue);
			$this->address->PlaceHolder = RemoveHtml($this->address->caption());

			// country
			$this->country->EditAttrs["class"] = "form-control";
			$this->country->EditCustomAttributes = "";
			$curVal = trim(strval($this->country->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->country->AdvancedSearch->ViewValue = $this->country->lookupCacheOption($curVal);
			else
				$this->country->AdvancedSearch->ViewValue = $this->country->Lookup !== NULL && is_array($this->country->Lookup->Options) ? $curVal : NULL;
			if ($this->country->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->country->EditValue = array_values($this->country->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->country->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->country->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->country->EditValue = $arwrk;
			}

			// state
			$this->state->EditAttrs["class"] = "form-control";
			$this->state->EditCustomAttributes = "";
			$curVal = trim(strval($this->state->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->state->AdvancedSearch->ViewValue = $this->state->lookupCacheOption($curVal);
			else
				$this->state->AdvancedSearch->ViewValue = $this->state->Lookup !== NULL && is_array($this->state->Lookup->Options) ? $curVal : NULL;
			if ($this->state->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->state->EditValue = array_values($this->state->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->state->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->state->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->state->EditValue = $arwrk;
			}

			// city
			$this->city->EditAttrs["class"] = "form-control";
			$this->city->EditCustomAttributes = "";
			$curVal = trim(strval($this->city->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->city->AdvancedSearch->ViewValue = $this->city->lookupCacheOption($curVal);
			else
				$this->city->AdvancedSearch->ViewValue = $this->city->Lookup !== NULL && is_array($this->city->Lookup->Options) ? $curVal : NULL;
			if ($this->city->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->city->EditValue = array_values($this->city->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->city->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->city->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->city->EditValue = $arwrk;
			}

			// city_name
			$this->city_name->EditAttrs["class"] = "form-control";
			$this->city_name->EditCustomAttributes = 'ReadOnly';
			if (REMOVE_XSS)
				$this->city_name->AdvancedSearch->SearchValue = HtmlDecode($this->city_name->AdvancedSearch->SearchValue);
			$this->city_name->EditValue = HtmlEncode($this->city_name->AdvancedSearch->SearchValue);
			$this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

			// dob
			$this->dob->EditAttrs["class"] = "form-control";
			$this->dob->EditCustomAttributes = "";
			$this->dob->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dob->AdvancedSearch->SearchValue, 2), 2));
			$this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

			// dom
			$this->dom->EditAttrs["class"] = "form-control";
			$this->dom->EditCustomAttributes = "";
			$this->dom->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dom->AdvancedSearch->SearchValue, 2), 2));
			$this->dom->PlaceHolder = RemoveHtml($this->dom->caption());

			// marital_status
			$this->marital_status->EditAttrs["class"] = "form-control";
			$this->marital_status->EditCustomAttributes = "";
			$this->marital_status->EditValue = $this->marital_status->options(TRUE);

			// spouse_details
			$this->spouse_details->EditAttrs["class"] = "form-control";
			$this->spouse_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->spouse_details->AdvancedSearch->SearchValue = HtmlDecode($this->spouse_details->AdvancedSearch->SearchValue);
			$this->spouse_details->EditValue = HtmlEncode($this->spouse_details->AdvancedSearch->SearchValue);
			$this->spouse_details->PlaceHolder = RemoveHtml($this->spouse_details->caption());

			// image
			$this->image->EditAttrs["class"] = "form-control";
			$this->image->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->image->AdvancedSearch->SearchValue = HtmlDecode($this->image->AdvancedSearch->SearchValue);
			$this->image->EditValue = HtmlEncode($this->image->AdvancedSearch->SearchValue);
			$this->image->PlaceHolder = RemoveHtml($this->image->caption());

			// father_name
			$this->father_name->EditAttrs["class"] = "form-control";
			$this->father_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->father_name->AdvancedSearch->SearchValue = HtmlDecode($this->father_name->AdvancedSearch->SearchValue);
			$this->father_name->EditValue = HtmlEncode($this->father_name->AdvancedSearch->SearchValue);
			$this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

			// mother_name
			$this->mother_name->EditAttrs["class"] = "form-control";
			$this->mother_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mother_name->AdvancedSearch->SearchValue = HtmlDecode($this->mother_name->AdvancedSearch->SearchValue);
			$this->mother_name->EditValue = HtmlEncode($this->mother_name->AdvancedSearch->SearchValue);
			$this->mother_name->PlaceHolder = RemoveHtml($this->mother_name->caption());

			// permanent_address
			$this->permanent_address->EditAttrs["class"] = "form-control";
			$this->permanent_address->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->permanent_address->AdvancedSearch->SearchValue = HtmlDecode($this->permanent_address->AdvancedSearch->SearchValue);
			$this->permanent_address->EditValue = HtmlEncode($this->permanent_address->AdvancedSearch->SearchValue);
			$this->permanent_address->PlaceHolder = RemoveHtml($this->permanent_address->caption());

			// mobile_other
			$this->mobile_other->EditAttrs["class"] = "form-control";
			$this->mobile_other->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile_other->AdvancedSearch->SearchValue = HtmlDecode($this->mobile_other->AdvancedSearch->SearchValue);
			$this->mobile_other->EditValue = HtmlEncode($this->mobile_other->AdvancedSearch->SearchValue);
			$this->mobile_other->PlaceHolder = RemoveHtml($this->mobile_other->caption());

			// mobile_family
			$this->mobile_family->EditAttrs["class"] = "form-control";
			$this->mobile_family->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile_family->AdvancedSearch->SearchValue = HtmlDecode($this->mobile_family->AdvancedSearch->SearchValue);
			$this->mobile_family->EditValue = HtmlEncode($this->mobile_family->AdvancedSearch->SearchValue);
			$this->mobile_family->PlaceHolder = RemoveHtml($this->mobile_family->caption());

			// emergency_details
			$this->emergency_details->EditAttrs["class"] = "form-control";
			$this->emergency_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->emergency_details->AdvancedSearch->SearchValue = HtmlDecode($this->emergency_details->AdvancedSearch->SearchValue);
			$this->emergency_details->EditValue = HtmlEncode($this->emergency_details->AdvancedSearch->SearchValue);
			$this->emergency_details->PlaceHolder = RemoveHtml($this->emergency_details->caption());

			// annual_income
			$this->annual_income->EditAttrs["class"] = "form-control";
			$this->annual_income->EditCustomAttributes = "";
			$this->annual_income->EditValue = HtmlEncode($this->annual_income->AdvancedSearch->SearchValue);
			$this->annual_income->PlaceHolder = RemoveHtml($this->annual_income->caption());

			// work_details
			$this->work_details->EditAttrs["class"] = "form-control";
			$this->work_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->work_details->AdvancedSearch->SearchValue = HtmlDecode($this->work_details->AdvancedSearch->SearchValue);
			$this->work_details->EditValue = HtmlEncode($this->work_details->AdvancedSearch->SearchValue);
			$this->work_details->PlaceHolder = RemoveHtml($this->work_details->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// gst
			$this->gst->EditAttrs["class"] = "form-control";
			$this->gst->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->gst->AdvancedSearch->SearchValue = HtmlDecode($this->gst->AdvancedSearch->SearchValue);
			$this->gst->EditValue = HtmlEncode($this->gst->AdvancedSearch->SearchValue);
			$this->gst->PlaceHolder = RemoveHtml($this->gst->caption());

			// aadhaar_no
			$this->aadhaar_no->EditAttrs["class"] = "form-control";
			$this->aadhaar_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->aadhaar_no->AdvancedSearch->SearchValue = HtmlDecode($this->aadhaar_no->AdvancedSearch->SearchValue);
			$this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->AdvancedSearch->SearchValue);
			$this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

			// pan_no
			$this->pan_no->EditAttrs["class"] = "form-control";
			$this->pan_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pan_no->AdvancedSearch->SearchValue = HtmlDecode($this->pan_no->AdvancedSearch->SearchValue);
			$this->pan_no->EditValue = HtmlEncode($this->pan_no->AdvancedSearch->SearchValue);
			$this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

			// id_proof
			$this->id_proof->EditAttrs["class"] = "form-control";
			$this->id_proof->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->id_proof->AdvancedSearch->SearchValue = HtmlDecode($this->id_proof->AdvancedSearch->SearchValue);
			$this->id_proof->EditValue = HtmlEncode($this->id_proof->AdvancedSearch->SearchValue);
			$this->id_proof->PlaceHolder = RemoveHtml($this->id_proof->caption());

			// reference_details
			$this->reference_details->EditAttrs["class"] = "form-control";
			$this->reference_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->reference_details->AdvancedSearch->SearchValue = HtmlDecode($this->reference_details->AdvancedSearch->SearchValue);
			$this->reference_details->EditValue = HtmlEncode($this->reference_details->AdvancedSearch->SearchValue);
			$this->reference_details->PlaceHolder = RemoveHtml($this->reference_details->caption());

			// other_details
			$this->other_details->EditAttrs["class"] = "form-control";
			$this->other_details->EditCustomAttributes = "";
			$this->other_details->EditValue = HtmlEncode($this->other_details->AdvancedSearch->SearchValue);
			$this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

			// bank_name
			$this->bank_name->EditAttrs["class"] = "form-control";
			$this->bank_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_name->AdvancedSearch->SearchValue = HtmlDecode($this->bank_name->AdvancedSearch->SearchValue);
			$this->bank_name->EditValue = HtmlEncode($this->bank_name->AdvancedSearch->SearchValue);
			$this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

			// bank_ifsc_code
			$this->bank_ifsc_code->EditAttrs["class"] = "form-control";
			$this->bank_ifsc_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_ifsc_code->AdvancedSearch->SearchValue = HtmlDecode($this->bank_ifsc_code->AdvancedSearch->SearchValue);
			$this->bank_ifsc_code->EditValue = HtmlEncode($this->bank_ifsc_code->AdvancedSearch->SearchValue);
			$this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

			// bank_account_no
			$this->bank_account_no->EditAttrs["class"] = "form-control";
			$this->bank_account_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_account_no->AdvancedSearch->SearchValue = HtmlDecode($this->bank_account_no->AdvancedSearch->SearchValue);
			$this->bank_account_no->EditValue = HtmlEncode($this->bank_account_no->AdvancedSearch->SearchValue);
			$this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->AdvancedSearch->SearchValue);
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->mobile->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->mobile->errorMessage());
		}
		if (!CheckDate($this->dob->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->dob->errorMessage());
		}
		if (!CheckDate($this->dom->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->dom->errorMessage());
		}
		if (!CheckInteger($this->annual_income->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->annual_income->errorMessage());
		}
		if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->operator->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->formal_name->AdvancedSearch->load();
		$this->gender->AdvancedSearch->load();
		$this->mobile->AdvancedSearch->load();
		$this->_email->AdvancedSearch->load();
		$this->address->AdvancedSearch->load();
		$this->country->AdvancedSearch->load();
		$this->state->AdvancedSearch->load();
		$this->city->AdvancedSearch->load();
		$this->city_name->AdvancedSearch->load();
		$this->dob->AdvancedSearch->load();
		$this->dom->AdvancedSearch->load();
		$this->marital_status->AdvancedSearch->load();
		$this->spouse_details->AdvancedSearch->load();
		$this->image->AdvancedSearch->load();
		$this->father_name->AdvancedSearch->load();
		$this->mother_name->AdvancedSearch->load();
		$this->permanent_address->AdvancedSearch->load();
		$this->mobile_other->AdvancedSearch->load();
		$this->mobile_family->AdvancedSearch->load();
		$this->emergency_details->AdvancedSearch->load();
		$this->annual_income->AdvancedSearch->load();
		$this->work_details->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->gst->AdvancedSearch->load();
		$this->aadhaar_no->AdvancedSearch->load();
		$this->pan_no->AdvancedSearch->load();
		$this->id_proof->AdvancedSearch->load();
		$this->reference_details->AdvancedSearch->load();
		$this->other_details->AdvancedSearch->load();
		$this->bank_name->AdvancedSearch->load();
		$this->bank_ifsc_code->AdvancedSearch->load();
		$this->bank_account_no->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("personal_infolist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_country":
							break;
						case "x_state":
							break;
						case "x_city":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'personal_info');		
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>