<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for po
 */
class po extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $order_type;
	public $buyer_id;
	public $buyer_order_no;
	public $buyer_order_date;
	public $cart_id;
	public $buyer_product_ref;
	public $grp;
	public $s_grp;
	public $product;
	public $rid;
	public $despatch_date;
	public $despatch_week;
	public $fob_date;
	public $part_dispatch;
	public $payment_terms;
	public $transport_terms;
	public $buyer_shipping__id;
	public $description_04;
	public $description_03;
	public $description_01;
	public $description_02;
	public $description_07;
	public $description_20;
	public $description_17;
	public $description_18;
	public $description_19;
	public $quantity;
	public $price;
	public $currency;
	public $amount;
	public $cbm;
	public $buyer_size;
	public $description_05;
	public $description_06;
	public $description_08;
	public $remarks;
	public $operator;
	public $datetime;
	public $a_operator;
	public $a_datetime;
	public $jc_no;
	public $buyer_instruction;
	public $d_09_head;
	public $description_09;
	public $d_10_head;
	public $description_10;
	public $d_11_head;
	public $description_11;
	public $d_12_head;
	public $description_12;
	public $po;
	public $production_site;
	public $c_total;
	public $production_plan;
	public $lot_no;
	public $product_gcode;
	public $batch_no;
	public $uploads;
	public $d_01_head;
	public $d_02_head;
	public $d_03_head;
	public $d_04_head;
	public $d_05_head;
	public $d_06_head;
	public $d_07_head;
	public $d_08_head;
	public $sample;
	public $balance_quantity;
	public $_action;
	public $url;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'po';
		$this->TableName = 'po';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`po`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('po', 'po', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// order_type
		$this->order_type = new DbField('po', 'po', 'x_order_type', 'order_type', '`order_type`', '`order_type`', 17, -1, FALSE, '`order_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->order_type->Nullable = FALSE; // NOT NULL field
		$this->order_type->Required = TRUE; // Required field
		$this->order_type->Sortable = TRUE; // Allow sort
		$this->order_type->Lookup = new Lookup('order_type', 'po', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->order_type->OptionCount = 2;
		$this->order_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['order_type'] = &$this->order_type;

		// buyer_id
		$this->buyer_id = new DbField('po', 'po', 'x_buyer_id', 'buyer_id', '`buyer_id`', '`buyer_id`', 17, -1, FALSE, '`buyer_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->buyer_id->Nullable = FALSE; // NOT NULL field
		$this->buyer_id->Required = TRUE; // Required field
		$this->buyer_id->Sortable = TRUE; // Allow sort
		$this->buyer_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyer_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyer_id->Lookup = new Lookup('buyer_id', 'buyer', FALSE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyer_id'] = &$this->buyer_id;

		// buyer_order_no
		$this->buyer_order_no = new DbField('po', 'po', 'x_buyer_order_no', 'buyer_order_no', '`buyer_order_no`', '`buyer_order_no`', 200, -1, FALSE, '`buyer_order_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_order_no->Sortable = TRUE; // Allow sort
		$this->fields['buyer_order_no'] = &$this->buyer_order_no;

		// buyer_order_date
		$this->buyer_order_date = new DbField('po', 'po', 'x_buyer_order_date', 'buyer_order_date', '`buyer_order_date`', CastDateFieldForLike('`buyer_order_date`', 0, "DB"), 133, 0, FALSE, '`buyer_order_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_order_date->Required = TRUE; // Required field
		$this->buyer_order_date->Sortable = TRUE; // Allow sort
		$this->buyer_order_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['buyer_order_date'] = &$this->buyer_order_date;

		// cart_id
		$this->cart_id = new DbField('po', 'po', 'x_cart_id', 'cart_id', '`cart_id`', '`cart_id`', 201, -1, FALSE, '`cart_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->cart_id->Sortable = TRUE; // Allow sort
		$this->cart_id->Lookup = new Lookup('cart_id', 'product_cart_s', FALSE, 'id', ["rid_1","quantity","price","amount"], [], [], [], [], [], [], '', '<span class="text-info">Product : {{:df1}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span>');
		$this->fields['cart_id'] = &$this->cart_id;

		// buyer_product_ref
		$this->buyer_product_ref = new DbField('po', 'po', 'x_buyer_product_ref', 'buyer_product_ref', '`buyer_product_ref`', '`buyer_product_ref`', 201, -1, FALSE, '`buyer_product_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_product_ref->Sortable = TRUE; // Allow sort
		$this->fields['buyer_product_ref'] = &$this->buyer_product_ref;

		// grp
		$this->grp = new DbField('po', 'po', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_s_grp","x_description_05","x_description_06","x_d_09_head"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('po', 'po', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], ["x_product","x_d_10_head","x_d_11_head","x_d_12_head"], ["grp"], ["x_grp"], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('po', 'po', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', 'product', FALSE, 'id', ["product","","",""], ["x_s_grp"], ["x_rid"], ["s_grp"], ["x_s_grp[]"], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// rid
		$this->rid = new DbField('po', 'po', 'x_rid', 'rid', '`rid`', '`rid`', 18, -1, FALSE, '`rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->Lookup = new Lookup('rid', 'ref', TRUE, 'id', ["product_code","","",""], ["x_product"], [], ["product"], ["x_product"], ["last_price","b_01","currency"], ["x_price","x_cbm","x_currency"], '`gcode` ASC', '');
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// despatch_date
		$this->despatch_date = new DbField('po', 'po', 'x_despatch_date', 'despatch_date', '`despatch_date`', CastDateFieldForLike('`despatch_date`', 0, "DB"), 133, 0, FALSE, '`despatch_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->despatch_date->Nullable = FALSE; // NOT NULL field
		$this->despatch_date->Required = TRUE; // Required field
		$this->despatch_date->Sortable = TRUE; // Allow sort
		$this->despatch_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['despatch_date'] = &$this->despatch_date;

		// despatch_week
		$this->despatch_week = new DbField('po', 'po', 'x_despatch_week', 'despatch_week', '`despatch_week`', '`despatch_week`', 18, 7, FALSE, '`despatch_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->despatch_week->Required = TRUE; // Required field
		$this->despatch_week->Sortable = TRUE; // Allow sort
		$this->despatch_week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->despatch_week->Lookup = new Lookup('despatch_week', 'not_week', TRUE, 'id', ["wid","wed","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->despatch_week->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['despatch_week'] = &$this->despatch_week;

		// fob_date
		$this->fob_date = new DbField('po', 'po', 'x_fob_date', 'fob_date', '`fob_date`', CastDateFieldForLike('`fob_date`', 0, "DB"), 133, 0, FALSE, '`fob_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fob_date->Nullable = FALSE; // NOT NULL field
		$this->fob_date->Required = TRUE; // Required field
		$this->fob_date->Sortable = TRUE; // Allow sort
		$this->fob_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['fob_date'] = &$this->fob_date;

		// part_dispatch
		$this->part_dispatch = new DbField('po', 'po', 'x_part_dispatch', 'part_dispatch', '`part_dispatch`', '`part_dispatch`', 18, -1, FALSE, '`part_dispatch`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->part_dispatch->Nullable = FALSE; // NOT NULL field
		$this->part_dispatch->Required = TRUE; // Required field
		$this->part_dispatch->Sortable = TRUE; // Allow sort
		$this->part_dispatch->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->part_dispatch->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->part_dispatch->Lookup = new Lookup('part_dispatch', 'po', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->part_dispatch->OptionCount = 2;
		$this->part_dispatch->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['part_dispatch'] = &$this->part_dispatch;

		// payment_terms
		$this->payment_terms = new DbField('po', 'po', 'x_payment_terms', 'payment_terms', '`payment_terms`', '`payment_terms`', 200, -1, FALSE, '`payment_terms`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->payment_terms->Nullable = FALSE; // NOT NULL field
		$this->payment_terms->Required = TRUE; // Required field
		$this->payment_terms->Sortable = TRUE; // Allow sort
		$this->payment_terms->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->payment_terms->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->payment_terms->Lookup = new Lookup('payment_terms', 'misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['payment_terms'] = &$this->payment_terms;

		// transport_terms
		$this->transport_terms = new DbField('po', 'po', 'x_transport_terms', 'transport_terms', '`transport_terms`', '`transport_terms`', 200, -1, FALSE, '`transport_terms`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->transport_terms->Nullable = FALSE; // NOT NULL field
		$this->transport_terms->Required = TRUE; // Required field
		$this->transport_terms->Sortable = TRUE; // Allow sort
		$this->fields['transport_terms'] = &$this->transport_terms;

		// buyer_shipping _id
		$this->buyer_shipping__id = new DbField('po', 'po', 'x_buyer_shipping__id', 'buyer_shipping _id', '`buyer_shipping _id`', '`buyer_shipping _id`', 2, -1, FALSE, '`buyer_shipping _id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_shipping__id->Nullable = FALSE; // NOT NULL field
		$this->buyer_shipping__id->Required = TRUE; // Required field
		$this->buyer_shipping__id->Sortable = TRUE; // Allow sort
		$this->buyer_shipping__id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyer_shipping _id'] = &$this->buyer_shipping__id;

		// description_04
		$this->description_04 = new DbField('po', 'po', 'x_description_04', 'description_04', '`description_04`', '`description_04`', 4, -1, FALSE, '`description_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->description_04->Required = TRUE; // Required field
		$this->description_04->Sortable = TRUE; // Allow sort
		$this->description_04->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->description_04->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->description_04->Lookup = new Lookup('description_04', 'd_04', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '', '');
		$this->description_04->OptionCount = 3;
		$this->description_04->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['description_04'] = &$this->description_04;

		// description_03
		$this->description_03 = new DbField('po', 'po', 'x_description_03', 'description_03', '`description_03`', '`description_03`', 4, -1, FALSE, '`description_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->description_03->Required = TRUE; // Required field
		$this->description_03->Sortable = TRUE; // Allow sort
		$this->description_03->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->description_03->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->description_03->Lookup = new Lookup('description_03', 'po', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->description_03->OptionCount = 4;
		$this->description_03->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['description_03'] = &$this->description_03;

		// description_01
		$this->description_01 = new DbField('po', 'po', 'x_description_01', 'description_01', '`description_01`', '`description_01`', 4, -1, FALSE, '`description_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_01->Required = TRUE; // Required field
		$this->description_01->Sortable = FALSE; // Allow sort
		$this->description_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_01'] = &$this->description_01;

		// description_02
		$this->description_02 = new DbField('po', 'po', 'x_description_02', 'description_02', '`description_02`', '`description_02`', 4, -1, FALSE, '`description_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_02->Required = TRUE; // Required field
		$this->description_02->Sortable = FALSE; // Allow sort
		$this->description_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_02'] = &$this->description_02;

		// description_07
		$this->description_07 = new DbField('po', 'po', 'x_description_07', 'description_07', '`description_07`', '`description_07`', 18, -1, FALSE, '`description_07`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_07->Sortable = TRUE; // Allow sort
		$this->description_07->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_07'] = &$this->description_07;

		// description_20
		$this->description_20 = new DbField('po', 'po', 'x_description_20', 'description_20', '`description_20`', '`description_20`', 18, -1, FALSE, '`description_20`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->description_20->Nullable = FALSE; // NOT NULL field
		$this->description_20->Required = TRUE; // Required field
		$this->description_20->Sortable = TRUE; // Allow sort
		$this->description_20->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->description_20->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->description_20->Lookup = new Lookup('description_20', 'po', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->description_20->OptionCount = 4;
		$this->description_20->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['description_20'] = &$this->description_20;

		// description_17
		$this->description_17 = new DbField('po', 'po', 'x_description_17', 'description_17', '`description_17`', '`description_17`', 4, -1, FALSE, '`description_17`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_17->Nullable = FALSE; // NOT NULL field
		$this->description_17->Required = TRUE; // Required field
		$this->description_17->Sortable = TRUE; // Allow sort
		$this->description_17->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_17'] = &$this->description_17;

		// description_18
		$this->description_18 = new DbField('po', 'po', 'x_description_18', 'description_18', '`description_18`', '`description_18`', 4, -1, FALSE, '`description_18`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_18->Nullable = FALSE; // NOT NULL field
		$this->description_18->Required = TRUE; // Required field
		$this->description_18->Sortable = TRUE; // Allow sort
		$this->description_18->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_18'] = &$this->description_18;

		// description_19
		$this->description_19 = new DbField('po', 'po', 'x_description_19', 'description_19', '`description_19`', '`description_19`', 4, -1, FALSE, '`description_19`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_19->Nullable = FALSE; // NOT NULL field
		$this->description_19->Required = TRUE; // Required field
		$this->description_19->Sortable = TRUE; // Allow sort
		$this->description_19->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_19'] = &$this->description_19;

		// quantity
		$this->quantity = new DbField('po', 'po', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 18, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->fields['quantity'] = &$this->quantity;

		// price
		$this->price = new DbField('po', 'po', 'x_price', 'price', '`price`', '`price`', 131, -1, FALSE, '`price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price->Sortable = TRUE; // Allow sort
		$this->fields['price'] = &$this->price;

		// currency
		$this->currency = new DbField('po', 'po', 'x_currency', 'currency', '`currency`', '`currency`', 2, -1, FALSE, '`currency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->currency->Nullable = FALSE; // NOT NULL field
		$this->currency->Required = TRUE; // Required field
		$this->currency->Sortable = FALSE; // Allow sort
		$this->currency->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->currency->Lookup = new Lookup('currency', 'currency', FALSE, 'id', ["code","name","",""], [], [], [], [], [], [], '`code` ASC', '');
		$this->currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['currency'] = &$this->currency;

		// amount
		$this->amount = new DbField('po', 'po', 'x_amount', 'amount', '`amount`', '`amount`', 4, -1, FALSE, '`amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount->Nullable = FALSE; // NOT NULL field
		$this->amount->Required = TRUE; // Required field
		$this->amount->Sortable = TRUE; // Allow sort
		$this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amount'] = &$this->amount;

		// cbm
		$this->cbm = new DbField('po', 'po', 'x_cbm', 'cbm', '`cbm`', '`cbm`', 4, -1, FALSE, '`cbm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cbm->Nullable = FALSE; // NOT NULL field
		$this->cbm->Required = TRUE; // Required field
		$this->cbm->Sortable = TRUE; // Allow sort
		$this->cbm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cbm'] = &$this->cbm;

		// buyer_size
		$this->buyer_size = new DbField('po', 'po', 'x_buyer_size', 'buyer_size', '`buyer_size`', '`buyer_size`', 200, -1, FALSE, '`buyer_size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_size->Nullable = FALSE; // NOT NULL field
		$this->buyer_size->Required = TRUE; // Required field
		$this->buyer_size->Sortable = TRUE; // Allow sort
		$this->fields['buyer_size'] = &$this->buyer_size;

		// description_05
		$this->description_05 = new DbField('po', 'po', 'x_description_05', 'description_05', '`description_05`', '`description_05`', 18, -1, FALSE, '`description_05`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->description_05->Sortable = TRUE; // Allow sort
		$this->description_05->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->description_05->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->description_05->Lookup = new Lookup('description_05', 'd_05', FALSE, 'id', ["item","","",""], ["x_grp"], [], ["grp"], ["x_grp"], [], [], '`item` ASC', '');
		$this->fields['description_05'] = &$this->description_05;

		// description_06
		$this->description_06 = new DbField('po', 'po', 'x_description_06', 'description_06', '`description_06`', '`description_06`', 18, -1, FALSE, '`description_06`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->description_06->Sortable = TRUE; // Allow sort
		$this->description_06->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->description_06->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->description_06->Lookup = new Lookup('description_06', 'd_06', FALSE, 'id', ["item","","",""], ["x_grp"], [], ["grp"], ["x_grp"], [], [], '`item` ASC', '');
		$this->fields['description_06'] = &$this->description_06;

		// description_08
		$this->description_08 = new DbField('po', 'po', 'x_description_08', 'description_08', '`description_08`', '`description_08`', 18, -1, FALSE, '`description_08`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_08->Required = TRUE; // Required field
		$this->description_08->Sortable = TRUE; // Allow sort
		$this->description_08->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_08'] = &$this->description_08;

		// remarks
		$this->remarks = new DbField('po', 'po', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 201, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// operator
		$this->operator = new DbField('po', 'po', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('po', 'po', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// a_operator
		$this->a_operator = new DbField('po', 'po', 'x_a_operator', 'a_operator', '`a_operator`', '`a_operator`', 18, -1, FALSE, '`a_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->a_operator->Sortable = TRUE; // Allow sort
		$this->a_operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->a_operator->Lookup = new Lookup('a_operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['a_operator'] = &$this->a_operator;

		// a_datetime
		$this->a_datetime = new DbField('po', 'po', 'x_a_datetime', 'a_datetime', '`a_datetime`', CastDateFieldForLike('`a_datetime`', 0, "DB"), 135, 0, FALSE, '`a_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->a_datetime->Sortable = TRUE; // Allow sort
		$this->fields['a_datetime'] = &$this->a_datetime;

		// jc_no
		$this->jc_no = new DbField('po', 'po', 'x_jc_no', 'jc_no', '`jc_no`', '`jc_no`', 200, -1, FALSE, '`jc_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_no->Sortable = FALSE; // Allow sort
		$this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no'] = &$this->jc_no;

		// buyer_instruction
		$this->buyer_instruction = new DbField('po', 'po', 'x_buyer_instruction', 'buyer_instruction', '`buyer_instruction`', '`buyer_instruction`', 201, -1, FALSE, '`buyer_instruction`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->buyer_instruction->Sortable = TRUE; // Allow sort
		$this->fields['buyer_instruction'] = &$this->buyer_instruction;

		// d_09_head
		$this->d_09_head = new DbField('po', 'po', 'x_d_09_head', 'd_09_head', '`d_09_head`', '`d_09_head`', 2, -1, FALSE, '`d_09_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->d_09_head->Sortable = TRUE; // Allow sort
		$this->d_09_head->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->d_09_head->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->d_09_head->Lookup = new Lookup('d_09_head', 'po_desc', FALSE, 'id', ["description","","",""], ["x_grp"], [], ["grp"], ["x_grp"], [], [], '`description` ASC', '');
		$this->d_09_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_09_head'] = &$this->d_09_head;

		// description_09
		$this->description_09 = new DbField('po', 'po', 'x_description_09', 'description_09', '`description_09`', '`description_09`', 200, -1, FALSE, '`description_09`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_09->Sortable = TRUE; // Allow sort
		$this->fields['description_09'] = &$this->description_09;

		// d_10_head
		$this->d_10_head = new DbField('po', 'po', 'x_d_10_head', 'd_10_head', '`d_10_head`', '`d_10_head`', 2, -1, FALSE, '`d_10_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->d_10_head->Sortable = TRUE; // Allow sort
		$this->d_10_head->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->d_10_head->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->d_10_head->Lookup = new Lookup('d_10_head', 'po_desc', FALSE, 'id', ["description","","",""], ["x_s_grp"], [], ["grp"], ["x_grp"], [], [], '`description` ASC', '');
		$this->d_10_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_10_head'] = &$this->d_10_head;

		// description_10
		$this->description_10 = new DbField('po', 'po', 'x_description_10', 'description_10', '`description_10`', '`description_10`', 200, -1, FALSE, '`description_10`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_10->Sortable = TRUE; // Allow sort
		$this->fields['description_10'] = &$this->description_10;

		// d_11_head
		$this->d_11_head = new DbField('po', 'po', 'x_d_11_head', 'd_11_head', '`d_11_head`', '`d_11_head`', 2, -1, FALSE, '`d_11_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->d_11_head->Sortable = TRUE; // Allow sort
		$this->d_11_head->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->d_11_head->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->d_11_head->Lookup = new Lookup('d_11_head', 'po_desc', FALSE, 'id', ["description","","",""], ["x_s_grp"], [], ["grp"], ["x_grp"], [], [], '`description` ASC', '');
		$this->d_11_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_11_head'] = &$this->d_11_head;

		// description_11
		$this->description_11 = new DbField('po', 'po', 'x_description_11', 'description_11', '`description_11`', '`description_11`', 200, -1, FALSE, '`description_11`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_11->Sortable = TRUE; // Allow sort
		$this->fields['description_11'] = &$this->description_11;

		// d_12_head
		$this->d_12_head = new DbField('po', 'po', 'x_d_12_head', 'd_12_head', '`d_12_head`', '`d_12_head`', 2, -1, FALSE, '`d_12_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->d_12_head->Sortable = TRUE; // Allow sort
		$this->d_12_head->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->d_12_head->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->d_12_head->Lookup = new Lookup('d_12_head', 'po_desc', FALSE, 'id', ["description","","",""], ["x_s_grp"], [], ["grp"], ["x_grp"], [], [], '`description` ASC', '');
		$this->d_12_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_12_head'] = &$this->d_12_head;

		// description_12
		$this->description_12 = new DbField('po', 'po', 'x_description_12', 'description_12', '`description_12`', '`description_12`', 200, -1, FALSE, '`description_12`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_12->Sortable = TRUE; // Allow sort
		$this->fields['description_12'] = &$this->description_12;

		// po
		$this->po = new DbField('po', 'po', 'x_po', 'po', '`po`', '`po`', 18, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Nullable = FALSE; // NOT NULL field
		$this->po->Required = TRUE; // Required field
		$this->po->Sortable = FALSE; // Allow sort
		$this->po->DefaultErrorMessage = str_replace(array("%1", "%2"), array("10001", "99999"), $Language->phrase("IncorrectRange"));
		$this->fields['po'] = &$this->po;

		// production_site
		$this->production_site = new DbField('po', 'po', 'x_production_site', 'production_site', '`production_site`', '`production_site`', 18, -1, FALSE, '`production_site`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->production_site->Nullable = FALSE; // NOT NULL field
		$this->production_site->Required = TRUE; // Required field
		$this->production_site->Sortable = FALSE; // Allow sort
		$this->production_site->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->production_site->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->production_site->Lookup = new Lookup('production_site', 'godown', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->production_site->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['production_site'] = &$this->production_site;

		// c_total
		$this->c_total = new DbField('po', 'po', 'x_c_total', 'c_total', '`c_total`', '`c_total`', 18, -1, FALSE, '`c_total`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->c_total->Nullable = FALSE; // NOT NULL field
		$this->c_total->Required = TRUE; // Required field
		$this->c_total->Sortable = FALSE; // Allow sort
		$this->c_total->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['c_total'] = &$this->c_total;

		// production_plan
		$this->production_plan = new DbField('po', 'po', 'x_production_plan', 'production_plan', '`production_plan`', '`production_plan`', 18, -1, FALSE, '`production_plan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->production_plan->Required = TRUE; // Required field
		$this->production_plan->Sortable = FALSE; // Allow sort
		$this->production_plan->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->production_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->production_plan->Lookup = new Lookup('production_plan', 'po', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->production_plan->OptionCount = 6;
		$this->production_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['production_plan'] = &$this->production_plan;

		// lot_no
		$this->lot_no = new DbField('po', 'po', 'x_lot_no', 'lot_no', '`lot_no`', '`lot_no`', 200, -1, FALSE, '`lot_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lot_no->Sortable = FALSE; // Allow sort
		$this->fields['lot_no'] = &$this->lot_no;

		// product_gcode
		$this->product_gcode = new DbField('po', 'po', 'x_product_gcode', 'product_gcode', '`product_gcode`', '`product_gcode`', 200, -1, FALSE, '`product_gcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_gcode->Sortable = FALSE; // Allow sort
		$this->fields['product_gcode'] = &$this->product_gcode;

		// batch_no
		$this->batch_no = new DbField('po', 'po', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 18, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->batch_no->Nullable = FALSE; // NOT NULL field
		$this->batch_no->Required = TRUE; // Required field
		$this->batch_no->Sortable = FALSE; // Allow sort
		$this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_no'] = &$this->batch_no;

		// uploads
		$this->uploads = new DbField('po', 'po', 'x_uploads', 'uploads', '`uploads`', '`uploads`', 201, -1, FALSE, '`uploads`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->uploads->Sortable = FALSE; // Allow sort
		$this->fields['uploads'] = &$this->uploads;

		// d_01_head
		$this->d_01_head = new DbField('po', 'po', 'x_d_01_head', 'd_01_head', '`d_01_head`', '`d_01_head`', 18, -1, FALSE, '`d_01_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_01_head->Sortable = FALSE; // Allow sort
		$this->d_01_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_01_head'] = &$this->d_01_head;

		// d_02_head
		$this->d_02_head = new DbField('po', 'po', 'x_d_02_head', 'd_02_head', '`d_02_head`', '`d_02_head`', 18, -1, FALSE, '`d_02_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_02_head->Sortable = FALSE; // Allow sort
		$this->d_02_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_02_head'] = &$this->d_02_head;

		// d_03_head
		$this->d_03_head = new DbField('po', 'po', 'x_d_03_head', 'd_03_head', '`d_03_head`', '`d_03_head`', 18, -1, FALSE, '`d_03_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_03_head->Sortable = FALSE; // Allow sort
		$this->d_03_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_03_head'] = &$this->d_03_head;

		// d_04_head
		$this->d_04_head = new DbField('po', 'po', 'x_d_04_head', 'd_04_head', '`d_04_head`', '`d_04_head`', 18, -1, FALSE, '`d_04_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_04_head->Sortable = FALSE; // Allow sort
		$this->d_04_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_04_head'] = &$this->d_04_head;

		// d_05_head
		$this->d_05_head = new DbField('po', 'po', 'x_d_05_head', 'd_05_head', '`d_05_head`', '`d_05_head`', 18, -1, FALSE, '`d_05_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_05_head->Sortable = FALSE; // Allow sort
		$this->d_05_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_05_head'] = &$this->d_05_head;

		// d_06_head
		$this->d_06_head = new DbField('po', 'po', 'x_d_06_head', 'd_06_head', '`d_06_head`', '`d_06_head`', 18, -1, FALSE, '`d_06_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_06_head->Sortable = FALSE; // Allow sort
		$this->d_06_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_06_head'] = &$this->d_06_head;

		// d_07_head
		$this->d_07_head = new DbField('po', 'po', 'x_d_07_head', 'd_07_head', '`d_07_head`', '`d_07_head`', 18, -1, FALSE, '`d_07_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_07_head->Sortable = FALSE; // Allow sort
		$this->d_07_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_07_head'] = &$this->d_07_head;

		// d_08_head
		$this->d_08_head = new DbField('po', 'po', 'x_d_08_head', 'd_08_head', '`d_08_head`', '`d_08_head`', 18, -1, FALSE, '`d_08_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_08_head->Sortable = FALSE; // Allow sort
		$this->d_08_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_08_head'] = &$this->d_08_head;

		// sample
		$this->sample = new DbField('po', 'po', 'x_sample', 'sample', '`sample`', '`sample`', 18, -1, FALSE, '`sample`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sample->Nullable = FALSE; // NOT NULL field
		$this->sample->Required = TRUE; // Required field
		$this->sample->Sortable = FALSE; // Allow sort
		$this->sample->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['sample'] = &$this->sample;

		// balance_quantity
		$this->balance_quantity = new DbField('po', 'po', 'x_balance_quantity', 'balance_quantity', '`balance_quantity`', '`balance_quantity`', 131, -1, FALSE, '`balance_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->balance_quantity->Sortable = FALSE; // Allow sort
		$this->balance_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['balance_quantity'] = &$this->balance_quantity;

		// action
		$this->_action = new DbField('po', 'po', 'x__action', 'action', 'if(((SELECT  `a_operator` FROM `batch_no` ) = 0), \'Update <BR>Batch Details\', if(`po`.`a_operator` = 0,  \'Authorize and Create <BR>Material Requirement\', \'Authorized\'))', 'if(((SELECT  `a_operator` FROM `batch_no` ) = 0), \'Update <BR>Batch Details\', if(`po`.`a_operator` = 0,  \'Authorize and Create <BR>Material Requirement\', \'Authorized\'))', 200, -1, FALSE, 'if(((SELECT  `a_operator` FROM `batch_no` ) = 0), \'Update <BR>Batch Details\', if(`po`.`a_operator` = 0,  \'Authorize and Create <BR>Material Requirement\', \'Authorized\'))', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_action->IsCustom = TRUE; // Custom field
		$this->_action->Sortable = TRUE; // Allow sort
		$this->fields['action'] = &$this->_action;

		// url
		$this->url = new DbField('po', 'po', 'x_url', 'url', 'if(((SELECT  `a_operator` FROM `batch_no` ) = 0), concat(\'batch_nolist.php?x_id=\',`batch_no`), if(`po`.`a_operator` = 0,  concat(\'apc.php?apcid=101&ID=\',`id`), \'\'))', 'if(((SELECT  `a_operator` FROM `batch_no` ) = 0), concat(\'batch_nolist.php?x_id=\',`batch_no`), if(`po`.`a_operator` = 0,  concat(\'apc.php?apcid=101&ID=\',`id`), \'\'))', 200, -1, FALSE, 'if(((SELECT  `a_operator` FROM `batch_no` ) = 0), concat(\'batch_nolist.php?x_id=\',`batch_no`), if(`po`.`a_operator` = 0,  concat(\'apc.php?apcid=101&ID=\',`id`), \'\'))', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->url->IsCustom = TRUE; // Custom field
		$this->url->Sortable = FALSE; // Allow sort
		$this->fields['url'] = &$this->url;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`po`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, if(((SELECT  `a_operator` FROM `batch_no` ) = 0), 'Update <BR>Batch Details', if(`po`.`a_operator` = 0,  'Authorize and Create <BR>Material Requirement', 'Authorized')) AS `action`, if(((SELECT  `a_operator` FROM `batch_no` ) = 0), concat('batch_nolist.php?x_id=',`batch_no`), if(`po`.`a_operator` = 0,  concat('apc.php?apcid=101&ID=',`id`), '')) AS `url` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->order_type->DbValue = $row['order_type'];
		$this->buyer_id->DbValue = $row['buyer_id'];
		$this->buyer_order_no->DbValue = $row['buyer_order_no'];
		$this->buyer_order_date->DbValue = $row['buyer_order_date'];
		$this->cart_id->DbValue = $row['cart_id'];
		$this->buyer_product_ref->DbValue = $row['buyer_product_ref'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->rid->DbValue = $row['rid'];
		$this->despatch_date->DbValue = $row['despatch_date'];
		$this->despatch_week->DbValue = $row['despatch_week'];
		$this->fob_date->DbValue = $row['fob_date'];
		$this->part_dispatch->DbValue = $row['part_dispatch'];
		$this->payment_terms->DbValue = $row['payment_terms'];
		$this->transport_terms->DbValue = $row['transport_terms'];
		$this->buyer_shipping__id->DbValue = $row['buyer_shipping _id'];
		$this->description_04->DbValue = $row['description_04'];
		$this->description_03->DbValue = $row['description_03'];
		$this->description_01->DbValue = $row['description_01'];
		$this->description_02->DbValue = $row['description_02'];
		$this->description_07->DbValue = $row['description_07'];
		$this->description_20->DbValue = $row['description_20'];
		$this->description_17->DbValue = $row['description_17'];
		$this->description_18->DbValue = $row['description_18'];
		$this->description_19->DbValue = $row['description_19'];
		$this->quantity->DbValue = $row['quantity'];
		$this->price->DbValue = $row['price'];
		$this->currency->DbValue = $row['currency'];
		$this->amount->DbValue = $row['amount'];
		$this->cbm->DbValue = $row['cbm'];
		$this->buyer_size->DbValue = $row['buyer_size'];
		$this->description_05->DbValue = $row['description_05'];
		$this->description_06->DbValue = $row['description_06'];
		$this->description_08->DbValue = $row['description_08'];
		$this->remarks->DbValue = $row['remarks'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->a_operator->DbValue = $row['a_operator'];
		$this->a_datetime->DbValue = $row['a_datetime'];
		$this->jc_no->DbValue = $row['jc_no'];
		$this->buyer_instruction->DbValue = $row['buyer_instruction'];
		$this->d_09_head->DbValue = $row['d_09_head'];
		$this->description_09->DbValue = $row['description_09'];
		$this->d_10_head->DbValue = $row['d_10_head'];
		$this->description_10->DbValue = $row['description_10'];
		$this->d_11_head->DbValue = $row['d_11_head'];
		$this->description_11->DbValue = $row['description_11'];
		$this->d_12_head->DbValue = $row['d_12_head'];
		$this->description_12->DbValue = $row['description_12'];
		$this->po->DbValue = $row['po'];
		$this->production_site->DbValue = $row['production_site'];
		$this->c_total->DbValue = $row['c_total'];
		$this->production_plan->DbValue = $row['production_plan'];
		$this->lot_no->DbValue = $row['lot_no'];
		$this->product_gcode->DbValue = $row['product_gcode'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->uploads->DbValue = $row['uploads'];
		$this->d_01_head->DbValue = $row['d_01_head'];
		$this->d_02_head->DbValue = $row['d_02_head'];
		$this->d_03_head->DbValue = $row['d_03_head'];
		$this->d_04_head->DbValue = $row['d_04_head'];
		$this->d_05_head->DbValue = $row['d_05_head'];
		$this->d_06_head->DbValue = $row['d_06_head'];
		$this->d_07_head->DbValue = $row['d_07_head'];
		$this->d_08_head->DbValue = $row['d_08_head'];
		$this->sample->DbValue = $row['sample'];
		$this->balance_quantity->DbValue = $row['balance_quantity'];
		$this->_action->DbValue = $row['action'];
		$this->url->DbValue = $row['url'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "polist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "poview.php")
			return $Language->phrase("View");
		elseif ($pageName == "poedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "poadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "polist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("poview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("poview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "poadd.php?" . $this->getUrlParm($parm);
		else
			$url = "poadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("poedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("poadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("podelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->order_type->setDbValue($rs->fields('order_type'));
		$this->buyer_id->setDbValue($rs->fields('buyer_id'));
		$this->buyer_order_no->setDbValue($rs->fields('buyer_order_no'));
		$this->buyer_order_date->setDbValue($rs->fields('buyer_order_date'));
		$this->cart_id->setDbValue($rs->fields('cart_id'));
		$this->buyer_product_ref->setDbValue($rs->fields('buyer_product_ref'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->despatch_date->setDbValue($rs->fields('despatch_date'));
		$this->despatch_week->setDbValue($rs->fields('despatch_week'));
		$this->fob_date->setDbValue($rs->fields('fob_date'));
		$this->part_dispatch->setDbValue($rs->fields('part_dispatch'));
		$this->payment_terms->setDbValue($rs->fields('payment_terms'));
		$this->transport_terms->setDbValue($rs->fields('transport_terms'));
		$this->buyer_shipping__id->setDbValue($rs->fields('buyer_shipping _id'));
		$this->description_04->setDbValue($rs->fields('description_04'));
		$this->description_03->setDbValue($rs->fields('description_03'));
		$this->description_01->setDbValue($rs->fields('description_01'));
		$this->description_02->setDbValue($rs->fields('description_02'));
		$this->description_07->setDbValue($rs->fields('description_07'));
		$this->description_20->setDbValue($rs->fields('description_20'));
		$this->description_17->setDbValue($rs->fields('description_17'));
		$this->description_18->setDbValue($rs->fields('description_18'));
		$this->description_19->setDbValue($rs->fields('description_19'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->price->setDbValue($rs->fields('price'));
		$this->currency->setDbValue($rs->fields('currency'));
		$this->amount->setDbValue($rs->fields('amount'));
		$this->cbm->setDbValue($rs->fields('cbm'));
		$this->buyer_size->setDbValue($rs->fields('buyer_size'));
		$this->description_05->setDbValue($rs->fields('description_05'));
		$this->description_06->setDbValue($rs->fields('description_06'));
		$this->description_08->setDbValue($rs->fields('description_08'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->a_operator->setDbValue($rs->fields('a_operator'));
		$this->a_datetime->setDbValue($rs->fields('a_datetime'));
		$this->jc_no->setDbValue($rs->fields('jc_no'));
		$this->buyer_instruction->setDbValue($rs->fields('buyer_instruction'));
		$this->d_09_head->setDbValue($rs->fields('d_09_head'));
		$this->description_09->setDbValue($rs->fields('description_09'));
		$this->d_10_head->setDbValue($rs->fields('d_10_head'));
		$this->description_10->setDbValue($rs->fields('description_10'));
		$this->d_11_head->setDbValue($rs->fields('d_11_head'));
		$this->description_11->setDbValue($rs->fields('description_11'));
		$this->d_12_head->setDbValue($rs->fields('d_12_head'));
		$this->description_12->setDbValue($rs->fields('description_12'));
		$this->po->setDbValue($rs->fields('po'));
		$this->production_site->setDbValue($rs->fields('production_site'));
		$this->c_total->setDbValue($rs->fields('c_total'));
		$this->production_plan->setDbValue($rs->fields('production_plan'));
		$this->lot_no->setDbValue($rs->fields('lot_no'));
		$this->product_gcode->setDbValue($rs->fields('product_gcode'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->uploads->setDbValue($rs->fields('uploads'));
		$this->d_01_head->setDbValue($rs->fields('d_01_head'));
		$this->d_02_head->setDbValue($rs->fields('d_02_head'));
		$this->d_03_head->setDbValue($rs->fields('d_03_head'));
		$this->d_04_head->setDbValue($rs->fields('d_04_head'));
		$this->d_05_head->setDbValue($rs->fields('d_05_head'));
		$this->d_06_head->setDbValue($rs->fields('d_06_head'));
		$this->d_07_head->setDbValue($rs->fields('d_07_head'));
		$this->d_08_head->setDbValue($rs->fields('d_08_head'));
		$this->sample->setDbValue($rs->fields('sample'));
		$this->balance_quantity->setDbValue($rs->fields('balance_quantity'));
		$this->_action->setDbValue($rs->fields('action'));
		$this->url->setDbValue($rs->fields('url'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// order_type
		// buyer_id
		// buyer_order_no
		// buyer_order_date
		// cart_id
		// buyer_product_ref
		// grp
		// s_grp
		// product
		// rid
		// despatch_date
		// despatch_week
		// fob_date
		// part_dispatch
		// payment_terms
		// transport_terms
		// buyer_shipping _id
		// description_04
		// description_03
		// description_01

		$this->description_01->CellCssStyle = "white-space: nowrap;";

		// description_02
		$this->description_02->CellCssStyle = "white-space: nowrap;";

		// description_07
		// description_20
		// description_17
		// description_18
		// description_19
		// quantity
		// price
		// currency

		$this->currency->CellCssStyle = "white-space: nowrap;";

		// amount
		// cbm
		// buyer_size
		// description_05
		// description_06
		// description_08
		// remarks
		// operator
		// datetime
		// a_operator
		// a_datetime
		// jc_no

		$this->jc_no->CellCssStyle = "white-space: nowrap;";

		// buyer_instruction
		// d_09_head
		// description_09
		// d_10_head
		// description_10
		// d_11_head
		// description_11
		// d_12_head
		// description_12
		// po

		$this->po->CellCssStyle = "white-space: nowrap;";

		// production_site
		$this->production_site->CellCssStyle = "white-space: nowrap;";

		// c_total
		$this->c_total->CellCssStyle = "white-space: nowrap;";

		// production_plan
		$this->production_plan->CellCssStyle = "white-space: nowrap;";

		// lot_no
		$this->lot_no->CellCssStyle = "white-space: nowrap;";

		// product_gcode
		$this->product_gcode->CellCssStyle = "white-space: nowrap;";

		// batch_no
		$this->batch_no->CellCssStyle = "white-space: nowrap;";

		// uploads
		$this->uploads->CellCssStyle = "white-space: nowrap;";

		// d_01_head
		$this->d_01_head->CellCssStyle = "white-space: nowrap;";

		// d_02_head
		$this->d_02_head->CellCssStyle = "white-space: nowrap;";

		// d_03_head
		$this->d_03_head->CellCssStyle = "white-space: nowrap;";

		// d_04_head
		$this->d_04_head->CellCssStyle = "white-space: nowrap;";

		// d_05_head
		$this->d_05_head->CellCssStyle = "white-space: nowrap;";

		// d_06_head
		$this->d_06_head->CellCssStyle = "white-space: nowrap;";

		// d_07_head
		$this->d_07_head->CellCssStyle = "white-space: nowrap;";

		// d_08_head
		$this->d_08_head->CellCssStyle = "white-space: nowrap;";

		// sample
		$this->sample->CellCssStyle = "white-space: nowrap;";

		// balance_quantity
		$this->balance_quantity->CellCssStyle = "white-space: nowrap;";

		// action
		// url

		$this->url->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// order_type
		if (strval($this->order_type->CurrentValue) <> "") {
			$this->order_type->ViewValue = $this->order_type->optionCaption($this->order_type->CurrentValue);
		} else {
			$this->order_type->ViewValue = NULL;
		}
		$this->order_type->ViewCustomAttributes = "";

		// buyer_id
		$curVal = strval($this->buyer_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
			if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` > 1000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
				}
			}
		} else {
			$this->buyer_id->ViewValue = NULL;
		}
		$this->buyer_id->ViewCustomAttributes = "";

		// buyer_order_no
		$this->buyer_order_no->ViewValue = $this->buyer_order_no->CurrentValue;
		$this->buyer_order_no->ViewCustomAttributes = "";

		// buyer_order_date
		$this->buyer_order_date->ViewValue = $this->buyer_order_date->CurrentValue;
		$this->buyer_order_date->ViewValue = FormatDateTime($this->buyer_order_date->ViewValue, 0);
		$this->buyer_order_date->ViewCustomAttributes = "";

		// cart_id
		$curVal = strval($this->cart_id->CurrentValue);
		if ($curVal <> "") {
			$this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
			if ($this->cart_id->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` = NULL || `po_id` = '' || `po_id` = '0'" : "`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue;
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->cart_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->cart_id->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, 0);
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, 0);
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, 0);
						$this->cart_id->ViewValue->add($this->cart_id->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->cart_id->ViewValue = $this->cart_id->CurrentValue;
				}
			}
		} else {
			$this->cart_id->ViewValue = NULL;
		}
		$this->cart_id->ViewCustomAttributes = "";

		// buyer_product_ref
		$this->buyer_product_ref->ViewValue = $this->buyer_product_ref->CurrentValue;
		$this->buyer_product_ref->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 ";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// rid
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `product_type`=0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		$this->rid->ViewCustomAttributes = "";

		// despatch_date
		$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
		$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
		$this->despatch_date->ViewCustomAttributes = "";

		// despatch_week
		$curVal = strval($this->despatch_week->CurrentValue);
		if ($curVal <> "") {
			$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
				}
			}
		} else {
			$this->despatch_week->ViewValue = NULL;
		}
		$this->despatch_week->ViewCustomAttributes = "";

		// fob_date
		$this->fob_date->ViewValue = $this->fob_date->CurrentValue;
		$this->fob_date->ViewValue = FormatDateTime($this->fob_date->ViewValue, 0);
		$this->fob_date->ViewCustomAttributes = "";

		// part_dispatch
		if (strval($this->part_dispatch->CurrentValue) <> "") {
			$this->part_dispatch->ViewValue = $this->part_dispatch->optionCaption($this->part_dispatch->CurrentValue);
		} else {
			$this->part_dispatch->ViewValue = NULL;
		}
		$this->part_dispatch->ViewCustomAttributes = "";

		// payment_terms
		$curVal = strval($this->payment_terms->CurrentValue);
		if ($curVal <> "") {
			$this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
			if ($this->payment_terms->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 81";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->payment_terms->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
				}
			}
		} else {
			$this->payment_terms->ViewValue = NULL;
		}
		$this->payment_terms->ViewCustomAttributes = "";

		// transport_terms
		$this->transport_terms->ViewValue = $this->transport_terms->CurrentValue;
		$this->transport_terms->ViewCustomAttributes = "";

		// buyer_shipping _id
		$this->buyer_shipping__id->ViewValue = $this->buyer_shipping__id->CurrentValue;
		$this->buyer_shipping__id->ViewValue = FormatNumber($this->buyer_shipping__id->ViewValue, 0, -2, -2, -2);
		$this->buyer_shipping__id->ViewCustomAttributes = "";

		// description_04
		if (strval($this->description_04->CurrentValue) <> "") {
			$this->description_04->ViewValue = $this->description_04->optionCaption($this->description_04->CurrentValue);
		} else {
			$this->description_04->ViewValue = NULL;
		}
		$this->description_04->ViewCustomAttributes = "";

		// description_03
		if (strval($this->description_03->CurrentValue) <> "") {
			$this->description_03->ViewValue = $this->description_03->optionCaption($this->description_03->CurrentValue);
		} else {
			$this->description_03->ViewValue = NULL;
		}
		$this->description_03->ViewCustomAttributes = "";

		// description_01
		$this->description_01->ViewValue = $this->description_01->CurrentValue;
		$this->description_01->ViewValue = FormatNumber($this->description_01->ViewValue, 3, -2, -2, -2);
		$this->description_01->ViewCustomAttributes = "";

		// description_02
		$this->description_02->ViewValue = $this->description_02->CurrentValue;
		$this->description_02->ViewValue = FormatNumber($this->description_02->ViewValue, 3, -2, -2, -2);
		$this->description_02->ViewCustomAttributes = "";

		// description_07
		$this->description_07->ViewValue = $this->description_07->CurrentValue;
		$this->description_07->ViewCustomAttributes = "";

		// description_20
		if (strval($this->description_20->CurrentValue) <> "") {
			$this->description_20->ViewValue = $this->description_20->optionCaption($this->description_20->CurrentValue);
		} else {
			$this->description_20->ViewValue = NULL;
		}
		$this->description_20->ViewCustomAttributes = "";

		// description_17
		$this->description_17->ViewValue = $this->description_17->CurrentValue;
		$this->description_17->ViewValue = FormatNumber($this->description_17->ViewValue, 2, -2, -2, -2);
		$this->description_17->ViewCustomAttributes = "";

		// description_18
		$this->description_18->ViewValue = $this->description_18->CurrentValue;
		$this->description_18->ViewValue = FormatNumber($this->description_18->ViewValue, 2, -2, -2, -2);
		$this->description_18->ViewCustomAttributes = "";

		// description_19
		$this->description_19->ViewValue = $this->description_19->CurrentValue;
		$this->description_19->ViewValue = FormatNumber($this->description_19->ViewValue, 2, -2, -2, -2);
		$this->description_19->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// price
		$this->price->ViewValue = $this->price->CurrentValue;
		$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
		$this->price->ViewCustomAttributes = "";

		// currency
		$curVal = strval($this->currency->CurrentValue);
		if ($curVal <> "") {
			$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			if ($this->currency->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->currency->ViewValue = $this->currency->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->currency->ViewValue = $this->currency->CurrentValue;
				}
			}
		} else {
			$this->currency->ViewValue = NULL;
		}
		$this->currency->ViewCustomAttributes = "";

		// amount
		$this->amount->ViewValue = $this->amount->CurrentValue;
		$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
		$this->amount->ViewCustomAttributes = "";

		// cbm
		$this->cbm->ViewValue = $this->cbm->CurrentValue;
		$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 2, -2, -2, -2);
		$this->cbm->ViewCustomAttributes = "";

		// buyer_size
		$this->buyer_size->ViewValue = $this->buyer_size->CurrentValue;
		$this->buyer_size->ViewCustomAttributes = "";

		// description_05
		$curVal = strval($this->description_05->CurrentValue);
		if ($curVal <> "") {
			$this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
			if ($this->description_05->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->description_05->ViewValue = $this->description_05->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->description_05->ViewValue = $this->description_05->CurrentValue;
				}
			}
		} else {
			$this->description_05->ViewValue = NULL;
		}
		$this->description_05->ViewCustomAttributes = "";

		// description_06
		$curVal = strval($this->description_06->CurrentValue);
		if ($curVal <> "") {
			$this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
			if ($this->description_06->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->description_06->ViewValue = $this->description_06->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->description_06->ViewValue = $this->description_06->CurrentValue;
				}
			}
		} else {
			$this->description_06->ViewValue = NULL;
		}
		$this->description_06->ViewCustomAttributes = "";

		// description_08
		$this->description_08->ViewValue = $this->description_08->CurrentValue;
		$this->description_08->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// a_operator
		$curVal = strval($this->a_operator->CurrentValue);
		if ($curVal <> "") {
			$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
			if ($this->a_operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
				}
			}
		} else {
			$this->a_operator->ViewValue = NULL;
		}
		$this->a_operator->ViewCustomAttributes = "";

		// a_datetime
		$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
		$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 0);
		$this->a_datetime->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
		$this->jc_no->ViewCustomAttributes = "";

		// buyer_instruction
		$this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;
		$this->buyer_instruction->ViewCustomAttributes = "";

		// d_09_head
		$curVal = strval($this->d_09_head->CurrentValue);
		if ($curVal <> "") {
			$this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
			if ($this->d_09_head->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->d_09_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->d_09_head->ViewValue = $this->d_09_head->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->d_09_head->ViewValue = $this->d_09_head->CurrentValue;
				}
			}
		} else {
			$this->d_09_head->ViewValue = NULL;
		}
		$this->d_09_head->ViewCustomAttributes = "";

		// description_09
		$this->description_09->ViewValue = $this->description_09->CurrentValue;
		$this->description_09->ViewCustomAttributes = "";

		// d_10_head
		$curVal = strval($this->d_10_head->CurrentValue);
		if ($curVal <> "") {
			$this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
			if ($this->d_10_head->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->d_10_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->d_10_head->ViewValue = $this->d_10_head->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->d_10_head->ViewValue = $this->d_10_head->CurrentValue;
				}
			}
		} else {
			$this->d_10_head->ViewValue = NULL;
		}
		$this->d_10_head->ViewCustomAttributes = "";

		// description_10
		$this->description_10->ViewValue = $this->description_10->CurrentValue;
		$this->description_10->ViewCustomAttributes = "";

		// d_11_head
		$curVal = strval($this->d_11_head->CurrentValue);
		if ($curVal <> "") {
			$this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
			if ($this->d_11_head->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->d_11_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->d_11_head->ViewValue = $this->d_11_head->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->d_11_head->ViewValue = $this->d_11_head->CurrentValue;
				}
			}
		} else {
			$this->d_11_head->ViewValue = NULL;
		}
		$this->d_11_head->ViewCustomAttributes = "";

		// description_11
		$this->description_11->ViewValue = $this->description_11->CurrentValue;
		$this->description_11->ViewCustomAttributes = "";

		// d_12_head
		$curVal = strval($this->d_12_head->CurrentValue);
		if ($curVal <> "") {
			$this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
			if ($this->d_12_head->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->d_12_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->d_12_head->ViewValue = $this->d_12_head->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->d_12_head->ViewValue = $this->d_12_head->CurrentValue;
				}
			}
		} else {
			$this->d_12_head->ViewValue = NULL;
		}
		$this->d_12_head->ViewCustomAttributes = "";

		// description_12
		$this->description_12->ViewValue = $this->description_12->CurrentValue;
		$this->description_12->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewCustomAttributes = "";

		// production_site
		$curVal = strval($this->production_site->CurrentValue);
		if ($curVal <> "") {
			$this->production_site->ViewValue = $this->production_site->lookupCacheOption($curVal);
			if ($this->production_site->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` IN (0,3)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->production_site->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->production_site->ViewValue = $this->production_site->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->production_site->ViewValue = $this->production_site->CurrentValue;
				}
			}
		} else {
			$this->production_site->ViewValue = NULL;
		}
		$this->production_site->ViewCustomAttributes = "";

		// c_total
		$this->c_total->ViewValue = $this->c_total->CurrentValue;
		$this->c_total->ViewValue = FormatNumber($this->c_total->ViewValue, 0, -2, -2, -2);
		$this->c_total->ViewCustomAttributes = "";

		// production_plan
		if (strval($this->production_plan->CurrentValue) <> "") {
			$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
		} else {
			$this->production_plan->ViewValue = NULL;
		}
		$this->production_plan->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
		$this->lot_no->ViewCustomAttributes = "";

		// product_gcode
		$this->product_gcode->ViewValue = $this->product_gcode->CurrentValue;
		$this->product_gcode->ViewCustomAttributes = "";

		// batch_no
		$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
		$this->batch_no->ViewCustomAttributes = "";

		// uploads
		$this->uploads->ViewValue = $this->uploads->CurrentValue;
		$this->uploads->ViewCustomAttributes = "";

		// d_01_head
		$this->d_01_head->ViewValue = $this->d_01_head->CurrentValue;
		$this->d_01_head->ViewValue = FormatNumber($this->d_01_head->ViewValue, 0, -2, -2, -2);
		$this->d_01_head->ViewCustomAttributes = "";

		// d_02_head
		$this->d_02_head->ViewValue = $this->d_02_head->CurrentValue;
		$this->d_02_head->ViewValue = FormatNumber($this->d_02_head->ViewValue, 0, -2, -2, -2);
		$this->d_02_head->ViewCustomAttributes = "";

		// d_03_head
		$this->d_03_head->ViewValue = $this->d_03_head->CurrentValue;
		$this->d_03_head->ViewValue = FormatNumber($this->d_03_head->ViewValue, 0, -2, -2, -2);
		$this->d_03_head->ViewCustomAttributes = "";

		// d_04_head
		$this->d_04_head->ViewValue = $this->d_04_head->CurrentValue;
		$this->d_04_head->ViewValue = FormatNumber($this->d_04_head->ViewValue, 0, -2, -2, -2);
		$this->d_04_head->ViewCustomAttributes = "";

		// d_05_head
		$this->d_05_head->ViewValue = $this->d_05_head->CurrentValue;
		$this->d_05_head->ViewValue = FormatNumber($this->d_05_head->ViewValue, 0, -2, -2, -2);
		$this->d_05_head->ViewCustomAttributes = "";

		// d_06_head
		$this->d_06_head->ViewValue = $this->d_06_head->CurrentValue;
		$this->d_06_head->ViewValue = FormatNumber($this->d_06_head->ViewValue, 0, -2, -2, -2);
		$this->d_06_head->ViewCustomAttributes = "";

		// d_07_head
		$this->d_07_head->ViewValue = $this->d_07_head->CurrentValue;
		$this->d_07_head->ViewValue = FormatNumber($this->d_07_head->ViewValue, 0, -2, -2, -2);
		$this->d_07_head->ViewCustomAttributes = "";

		// d_08_head
		$this->d_08_head->ViewValue = $this->d_08_head->CurrentValue;
		$this->d_08_head->ViewValue = FormatNumber($this->d_08_head->ViewValue, 0, -2, -2, -2);
		$this->d_08_head->ViewCustomAttributes = "";

		// sample
		$this->sample->ViewValue = $this->sample->CurrentValue;
		$this->sample->ViewValue = FormatNumber($this->sample->ViewValue, 0, -2, -2, -2);
		$this->sample->ViewCustomAttributes = "";

		// balance_quantity
		$this->balance_quantity->ViewValue = $this->balance_quantity->CurrentValue;
		$this->balance_quantity->ViewValue = FormatNumber($this->balance_quantity->ViewValue, 2, -2, -2, -2);
		$this->balance_quantity->ViewCustomAttributes = "";

		// action
		$this->_action->ViewValue = $this->_action->CurrentValue;
		$this->_action->CssClass = "font-weight-bold";
		$this->_action->ViewCustomAttributes = 'class = "btn btn-default"';

		// url
		$this->url->ViewValue = $this->url->CurrentValue;
		$this->url->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// order_type
		$this->order_type->LinkCustomAttributes = "";
		$this->order_type->HrefValue = "";
		$this->order_type->TooltipValue = "";

		// buyer_id
		$this->buyer_id->LinkCustomAttributes = "";
		$this->buyer_id->HrefValue = "";
		$this->buyer_id->TooltipValue = "";

		// buyer_order_no
		$this->buyer_order_no->LinkCustomAttributes = "";
		$this->buyer_order_no->HrefValue = "";
		$this->buyer_order_no->TooltipValue = "";

		// buyer_order_date
		$this->buyer_order_date->LinkCustomAttributes = "";
		$this->buyer_order_date->HrefValue = "";
		$this->buyer_order_date->TooltipValue = "";

		// cart_id
		$this->cart_id->LinkCustomAttributes = "";
		$this->cart_id->HrefValue = "";
		$this->cart_id->TooltipValue = "";

		// buyer_product_ref
		$this->buyer_product_ref->LinkCustomAttributes = "";
		$this->buyer_product_ref->HrefValue = "";
		$this->buyer_product_ref->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->s_grp->CurrentValue)) {
			$this->s_grp->HrefValue = "po_clist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
			$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
		} else {
			$this->s_grp->HrefValue = "";
		}
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "po_clist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		if (!EmptyValue($this->rid->CurrentValue)) {
			$this->rid->HrefValue = "po_clist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
			$this->rid->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
		} else {
			$this->rid->HrefValue = "";
		}
		$this->rid->TooltipValue = "";

		// despatch_date
		$this->despatch_date->LinkCustomAttributes = "";
		$this->despatch_date->HrefValue = "";
		$this->despatch_date->TooltipValue = "";

		// despatch_week
		$this->despatch_week->LinkCustomAttributes = "";
		$this->despatch_week->HrefValue = "";
		$this->despatch_week->TooltipValue = "";

		// fob_date
		$this->fob_date->LinkCustomAttributes = "";
		$this->fob_date->HrefValue = "";
		$this->fob_date->TooltipValue = "";

		// part_dispatch
		$this->part_dispatch->LinkCustomAttributes = "";
		$this->part_dispatch->HrefValue = "";
		$this->part_dispatch->TooltipValue = "";

		// payment_terms
		$this->payment_terms->LinkCustomAttributes = "";
		$this->payment_terms->HrefValue = "";
		$this->payment_terms->TooltipValue = "";

		// transport_terms
		$this->transport_terms->LinkCustomAttributes = "";
		$this->transport_terms->HrefValue = "";
		$this->transport_terms->TooltipValue = "";

		// buyer_shipping _id
		$this->buyer_shipping__id->LinkCustomAttributes = "";
		$this->buyer_shipping__id->HrefValue = "";
		$this->buyer_shipping__id->TooltipValue = "";

		// description_04
		$this->description_04->LinkCustomAttributes = "";
		$this->description_04->HrefValue = "";
		$this->description_04->TooltipValue = "";

		// description_03
		$this->description_03->LinkCustomAttributes = "";
		$this->description_03->HrefValue = "";
		$this->description_03->TooltipValue = "";

		// description_01
		$this->description_01->LinkCustomAttributes = "";
		$this->description_01->HrefValue = "";
		$this->description_01->TooltipValue = "";

		// description_02
		$this->description_02->LinkCustomAttributes = "";
		$this->description_02->HrefValue = "";
		$this->description_02->TooltipValue = "";

		// description_07
		$this->description_07->LinkCustomAttributes = "";
		$this->description_07->HrefValue = "";
		$this->description_07->TooltipValue = "";

		// description_20
		$this->description_20->LinkCustomAttributes = "";
		$this->description_20->HrefValue = "";
		$this->description_20->TooltipValue = "";

		// description_17
		$this->description_17->LinkCustomAttributes = "";
		$this->description_17->HrefValue = "";
		$this->description_17->TooltipValue = "";

		// description_18
		$this->description_18->LinkCustomAttributes = "";
		$this->description_18->HrefValue = "";
		$this->description_18->TooltipValue = "";

		// description_19
		$this->description_19->LinkCustomAttributes = "";
		$this->description_19->HrefValue = "";
		$this->description_19->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// price
		$this->price->LinkCustomAttributes = "";
		$this->price->HrefValue = "";
		$this->price->TooltipValue = "";

		// currency
		$this->currency->LinkCustomAttributes = "";
		$this->currency->HrefValue = "";
		$this->currency->TooltipValue = "";

		// amount
		$this->amount->LinkCustomAttributes = "";
		$this->amount->HrefValue = "";
		$this->amount->TooltipValue = "";

		// cbm
		$this->cbm->LinkCustomAttributes = "";
		$this->cbm->HrefValue = "";
		$this->cbm->TooltipValue = "";

		// buyer_size
		$this->buyer_size->LinkCustomAttributes = "";
		$this->buyer_size->HrefValue = "";
		$this->buyer_size->TooltipValue = "";

		// description_05
		$this->description_05->LinkCustomAttributes = "";
		$this->description_05->HrefValue = "";
		$this->description_05->TooltipValue = "";

		// description_06
		$this->description_06->LinkCustomAttributes = "";
		$this->description_06->HrefValue = "";
		$this->description_06->TooltipValue = "";

		// description_08
		$this->description_08->LinkCustomAttributes = "";
		$this->description_08->HrefValue = "";
		$this->description_08->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// a_operator
		$this->a_operator->LinkCustomAttributes = "";
		$this->a_operator->HrefValue = "";
		$this->a_operator->TooltipValue = "";

		// a_datetime
		$this->a_datetime->LinkCustomAttributes = "";
		$this->a_datetime->HrefValue = "";
		$this->a_datetime->TooltipValue = "";

		// jc_no
		$this->jc_no->LinkCustomAttributes = "";
		$this->jc_no->HrefValue = "";
		$this->jc_no->TooltipValue = "";

		// buyer_instruction
		$this->buyer_instruction->LinkCustomAttributes = "";
		$this->buyer_instruction->HrefValue = "";
		$this->buyer_instruction->TooltipValue = "";

		// d_09_head
		$this->d_09_head->LinkCustomAttributes = "";
		$this->d_09_head->HrefValue = "";
		$this->d_09_head->TooltipValue = "";

		// description_09
		$this->description_09->LinkCustomAttributes = "";
		$this->description_09->HrefValue = "";
		$this->description_09->TooltipValue = "";

		// d_10_head
		$this->d_10_head->LinkCustomAttributes = "";
		$this->d_10_head->HrefValue = "";
		$this->d_10_head->TooltipValue = "";

		// description_10
		$this->description_10->LinkCustomAttributes = "";
		$this->description_10->HrefValue = "";
		$this->description_10->TooltipValue = "";

		// d_11_head
		$this->d_11_head->LinkCustomAttributes = "";
		$this->d_11_head->HrefValue = "";
		$this->d_11_head->TooltipValue = "";

		// description_11
		$this->description_11->LinkCustomAttributes = "";
		$this->description_11->HrefValue = "";
		$this->description_11->TooltipValue = "";

		// d_12_head
		$this->d_12_head->LinkCustomAttributes = "";
		$this->d_12_head->HrefValue = "";
		$this->d_12_head->TooltipValue = "";

		// description_12
		$this->description_12->LinkCustomAttributes = "";
		$this->description_12->HrefValue = "";
		$this->description_12->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		if (!EmptyValue($this->po->CurrentValue)) {
			$this->po->HrefValue = "po_clist.php?x_po=" . $this->po->CurrentValue; // Add prefix/suffix
			$this->po->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
		} else {
			$this->po->HrefValue = "";
		}
		$this->po->TooltipValue = "";

		// production_site
		$this->production_site->LinkCustomAttributes = "";
		$this->production_site->HrefValue = "";
		$this->production_site->TooltipValue = "";

		// c_total
		$this->c_total->LinkCustomAttributes = "";
		$this->c_total->HrefValue = "";
		$this->c_total->TooltipValue = "";

		// production_plan
		$this->production_plan->LinkCustomAttributes = "";
		$this->production_plan->HrefValue = "";
		$this->production_plan->TooltipValue = "";

		// lot_no
		$this->lot_no->LinkCustomAttributes = "";
		$this->lot_no->HrefValue = "";
		$this->lot_no->TooltipValue = "";

		// product_gcode
		$this->product_gcode->LinkCustomAttributes = "";
		$this->product_gcode->HrefValue = "";
		$this->product_gcode->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		$this->batch_no->HrefValue = "";
		$this->batch_no->TooltipValue = "";

		// uploads
		$this->uploads->LinkCustomAttributes = "";
		$this->uploads->HrefValue = "";
		$this->uploads->TooltipValue = "";

		// d_01_head
		$this->d_01_head->LinkCustomAttributes = "";
		$this->d_01_head->HrefValue = "";
		$this->d_01_head->TooltipValue = "";

		// d_02_head
		$this->d_02_head->LinkCustomAttributes = "";
		$this->d_02_head->HrefValue = "";
		$this->d_02_head->TooltipValue = "";

		// d_03_head
		$this->d_03_head->LinkCustomAttributes = "";
		$this->d_03_head->HrefValue = "";
		$this->d_03_head->TooltipValue = "";

		// d_04_head
		$this->d_04_head->LinkCustomAttributes = "";
		$this->d_04_head->HrefValue = "";
		$this->d_04_head->TooltipValue = "";

		// d_05_head
		$this->d_05_head->LinkCustomAttributes = "";
		$this->d_05_head->HrefValue = "";
		$this->d_05_head->TooltipValue = "";

		// d_06_head
		$this->d_06_head->LinkCustomAttributes = "";
		$this->d_06_head->HrefValue = "";
		$this->d_06_head->TooltipValue = "";

		// d_07_head
		$this->d_07_head->LinkCustomAttributes = "";
		$this->d_07_head->HrefValue = "";
		$this->d_07_head->TooltipValue = "";

		// d_08_head
		$this->d_08_head->LinkCustomAttributes = "";
		$this->d_08_head->HrefValue = "";
		$this->d_08_head->TooltipValue = "";

		// sample
		$this->sample->LinkCustomAttributes = "";
		$this->sample->HrefValue = "";
		$this->sample->TooltipValue = "";

		// balance_quantity
		$this->balance_quantity->LinkCustomAttributes = "";
		$this->balance_quantity->HrefValue = "";
		$this->balance_quantity->TooltipValue = "";

		// action
		$this->_action->LinkCustomAttributes = "";
		if (!EmptyValue($this->url->CurrentValue)) {
			$this->_action->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
			$this->_action->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->_action->HrefValue = FullUrl($this->_action->HrefValue, "href");
		} else {
			$this->_action->HrefValue = "";
		}
		$this->_action->TooltipValue = "";

		// url
		$this->url->LinkCustomAttributes = "";
		$this->url->HrefValue = "";
		$this->url->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// order_type
		$this->order_type->EditCustomAttributes = "";
		$this->order_type->EditValue = $this->order_type->options(FALSE);

		// buyer_id
		$this->buyer_id->EditAttrs["class"] = "form-control";
		$this->buyer_id->EditCustomAttributes = "";

		// buyer_order_no
		$this->buyer_order_no->EditAttrs["class"] = "form-control";
		$this->buyer_order_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_order_no->CurrentValue = HtmlDecode($this->buyer_order_no->CurrentValue);
		$this->buyer_order_no->EditValue = $this->buyer_order_no->CurrentValue;
		$this->buyer_order_no->PlaceHolder = RemoveHtml($this->buyer_order_no->caption());

		// buyer_order_date
		$this->buyer_order_date->EditAttrs["class"] = "form-control";
		$this->buyer_order_date->EditCustomAttributes = "";
		$this->buyer_order_date->EditValue = FormatDateTime($this->buyer_order_date->CurrentValue, 8);
		$this->buyer_order_date->PlaceHolder = RemoveHtml($this->buyer_order_date->caption());

		// cart_id
		$this->cart_id->EditCustomAttributes = "";

		// buyer_product_ref
		$this->buyer_product_ref->EditAttrs["class"] = "form-control";
		$this->buyer_product_ref->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_product_ref->CurrentValue = HtmlDecode($this->buyer_product_ref->CurrentValue);
		$this->buyer_product_ref->EditValue = $this->buyer_product_ref->CurrentValue;
		$this->buyer_product_ref->PlaceHolder = RemoveHtml($this->buyer_product_ref->caption());

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";

		// rid
		$this->rid->EditCustomAttributes = "";

		// despatch_date
		$this->despatch_date->EditAttrs["class"] = "form-control";
		$this->despatch_date->EditCustomAttributes = "";
		$this->despatch_date->EditValue = FormatDateTime($this->despatch_date->CurrentValue, 8);
		$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

		// despatch_week
		$this->despatch_week->EditAttrs["class"] = "form-control";
		$this->despatch_week->EditCustomAttributes = "";

		// fob_date
		$this->fob_date->EditAttrs["class"] = "form-control";
		$this->fob_date->EditCustomAttributes = "";
		$this->fob_date->EditValue = FormatDateTime($this->fob_date->CurrentValue, 8);
		$this->fob_date->PlaceHolder = RemoveHtml($this->fob_date->caption());

		// part_dispatch
		$this->part_dispatch->EditAttrs["class"] = "form-control";
		$this->part_dispatch->EditCustomAttributes = "";
		$this->part_dispatch->EditValue = $this->part_dispatch->options(TRUE);

		// payment_terms
		$this->payment_terms->EditAttrs["class"] = "form-control";
		$this->payment_terms->EditCustomAttributes = "";

		// transport_terms
		$this->transport_terms->EditAttrs["class"] = "form-control";
		$this->transport_terms->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->transport_terms->CurrentValue = HtmlDecode($this->transport_terms->CurrentValue);
		$this->transport_terms->EditValue = $this->transport_terms->CurrentValue;
		$this->transport_terms->PlaceHolder = RemoveHtml($this->transport_terms->caption());

		// buyer_shipping _id
		$this->buyer_shipping__id->EditAttrs["class"] = "form-control";
		$this->buyer_shipping__id->EditCustomAttributes = "";
		$this->buyer_shipping__id->EditValue = $this->buyer_shipping__id->CurrentValue;
		$this->buyer_shipping__id->PlaceHolder = RemoveHtml($this->buyer_shipping__id->caption());

		// description_04
		$this->description_04->EditAttrs["class"] = "form-control";
		$this->description_04->EditCustomAttributes = "";
		$this->description_04->EditValue = $this->description_04->options(TRUE);

		// description_03
		$this->description_03->EditAttrs["class"] = "form-control";
		$this->description_03->EditCustomAttributes = "";
		$this->description_03->EditValue = $this->description_03->options(TRUE);

		// description_01
		$this->description_01->EditAttrs["class"] = "form-control";
		$this->description_01->EditCustomAttributes = "";
		$this->description_01->EditValue = $this->description_01->CurrentValue;
		$this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());
		if (strval($this->description_01->EditValue) <> "" && is_numeric($this->description_01->EditValue))
			$this->description_01->EditValue = FormatNumber($this->description_01->EditValue, -2, -2, -2, -2);

		// description_02
		$this->description_02->EditAttrs["class"] = "form-control";
		$this->description_02->EditCustomAttributes = "";
		$this->description_02->EditValue = $this->description_02->CurrentValue;
		$this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());
		if (strval($this->description_02->EditValue) <> "" && is_numeric($this->description_02->EditValue))
			$this->description_02->EditValue = FormatNumber($this->description_02->EditValue, -2, -2, -2, -2);

		// description_07
		$this->description_07->EditAttrs["class"] = "form-control";
		$this->description_07->EditCustomAttributes = "";
		$this->description_07->EditValue = $this->description_07->CurrentValue;
		$this->description_07->PlaceHolder = RemoveHtml($this->description_07->caption());

		// description_20
		$this->description_20->EditAttrs["class"] = "form-control";
		$this->description_20->EditCustomAttributes = "";
		$this->description_20->EditValue = $this->description_20->options(TRUE);

		// description_17
		$this->description_17->EditAttrs["class"] = "form-control";
		$this->description_17->EditCustomAttributes = 'ReadOnly';
		$this->description_17->EditValue = $this->description_17->CurrentValue;
		$this->description_17->PlaceHolder = RemoveHtml($this->description_17->caption());
		if (strval($this->description_17->EditValue) <> "" && is_numeric($this->description_17->EditValue))
			$this->description_17->EditValue = FormatNumber($this->description_17->EditValue, -2, -2, -2, -2);

		// description_18
		$this->description_18->EditAttrs["class"] = "form-control";
		$this->description_18->EditCustomAttributes = 'ReadOnly';
		$this->description_18->EditValue = $this->description_18->CurrentValue;
		$this->description_18->PlaceHolder = RemoveHtml($this->description_18->caption());
		if (strval($this->description_18->EditValue) <> "" && is_numeric($this->description_18->EditValue))
			$this->description_18->EditValue = FormatNumber($this->description_18->EditValue, -2, -2, -2, -2);

		// description_19
		$this->description_19->EditAttrs["class"] = "form-control";
		$this->description_19->EditCustomAttributes = 'ReadOnly';
		$this->description_19->EditValue = $this->description_19->CurrentValue;
		$this->description_19->PlaceHolder = RemoveHtml($this->description_19->caption());
		if (strval($this->description_19->EditValue) <> "" && is_numeric($this->description_19->EditValue))
			$this->description_19->EditValue = FormatNumber($this->description_19->EditValue, -2, -2, -2, -2);

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

		// price
		$this->price->EditAttrs["class"] = "form-control";
		$this->price->EditCustomAttributes = 'ReadOnly';
		$this->price->EditValue = $this->price->CurrentValue;
		$this->price->PlaceHolder = RemoveHtml($this->price->caption());
		if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
			$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, -2);

		// currency
		$this->currency->EditAttrs["class"] = "form-control";
		$this->currency->EditCustomAttributes = 'ReadOnly';

		// amount
		$this->amount->EditAttrs["class"] = "form-control";
		$this->amount->EditCustomAttributes = 'ReadOnly';
		$this->amount->EditValue = $this->amount->CurrentValue;
		$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
		if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue))
			$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, -2);

		// cbm
		$this->cbm->EditAttrs["class"] = "form-control";
		$this->cbm->EditCustomAttributes = 'ReadOnly';
		$this->cbm->EditValue = $this->cbm->CurrentValue;
		$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
		if (strval($this->cbm->EditValue) <> "" && is_numeric($this->cbm->EditValue))
			$this->cbm->EditValue = FormatNumber($this->cbm->EditValue, -2, -2, -2, -2);

		// buyer_size
		$this->buyer_size->EditAttrs["class"] = "form-control";
		$this->buyer_size->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_size->CurrentValue = HtmlDecode($this->buyer_size->CurrentValue);
		$this->buyer_size->EditValue = $this->buyer_size->CurrentValue;
		$this->buyer_size->PlaceHolder = RemoveHtml($this->buyer_size->caption());

		// description_05
		$this->description_05->EditAttrs["class"] = "form-control";
		$this->description_05->EditCustomAttributes = "";

		// description_06
		$this->description_06->EditAttrs["class"] = "form-control";
		$this->description_06->EditCustomAttributes = "";

		// description_08
		$this->description_08->EditAttrs["class"] = "form-control";
		$this->description_08->EditCustomAttributes = "";
		$this->description_08->EditValue = $this->description_08->CurrentValue;
		$this->description_08->PlaceHolder = RemoveHtml($this->description_08->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// operator
		// datetime
		// a_operator
		// a_datetime
		// jc_no

		$this->jc_no->EditAttrs["class"] = "form-control";
		$this->jc_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->jc_no->CurrentValue = HtmlDecode($this->jc_no->CurrentValue);
		$this->jc_no->EditValue = $this->jc_no->CurrentValue;
		$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

		// buyer_instruction
		$this->buyer_instruction->EditAttrs["class"] = "form-control";
		$this->buyer_instruction->EditCustomAttributes = "";
		$this->buyer_instruction->EditValue = $this->buyer_instruction->CurrentValue;
		$this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

		// d_09_head
		$this->d_09_head->EditAttrs["class"] = "form-control";
		$this->d_09_head->EditCustomAttributes = "";

		// description_09
		$this->description_09->EditAttrs["class"] = "form-control";
		$this->description_09->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->description_09->CurrentValue = HtmlDecode($this->description_09->CurrentValue);
		$this->description_09->EditValue = $this->description_09->CurrentValue;
		$this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

		// d_10_head
		$this->d_10_head->EditAttrs["class"] = "form-control";
		$this->d_10_head->EditCustomAttributes = "";

		// description_10
		$this->description_10->EditAttrs["class"] = "form-control";
		$this->description_10->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->description_10->CurrentValue = HtmlDecode($this->description_10->CurrentValue);
		$this->description_10->EditValue = $this->description_10->CurrentValue;
		$this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());

		// d_11_head
		$this->d_11_head->EditAttrs["class"] = "form-control";
		$this->d_11_head->EditCustomAttributes = "";

		// description_11
		$this->description_11->EditAttrs["class"] = "form-control";
		$this->description_11->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->description_11->CurrentValue = HtmlDecode($this->description_11->CurrentValue);
		$this->description_11->EditValue = $this->description_11->CurrentValue;
		$this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

		// d_12_head
		$this->d_12_head->EditAttrs["class"] = "form-control";
		$this->d_12_head->EditCustomAttributes = "";

		// description_12
		$this->description_12->EditAttrs["class"] = "form-control";
		$this->description_12->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->description_12->CurrentValue = HtmlDecode($this->description_12->CurrentValue);
		$this->description_12->EditValue = $this->description_12->CurrentValue;
		$this->description_12->PlaceHolder = RemoveHtml($this->description_12->caption());

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->PlaceHolder = RemoveHtml($this->po->caption());

		// production_site
		$this->production_site->EditAttrs["class"] = "form-control";
		$this->production_site->EditCustomAttributes = "";

		// c_total
		$this->c_total->EditAttrs["class"] = "form-control";
		$this->c_total->EditCustomAttributes = "";
		$this->c_total->EditValue = $this->c_total->CurrentValue;
		$this->c_total->PlaceHolder = RemoveHtml($this->c_total->caption());

		// production_plan
		$this->production_plan->EditAttrs["class"] = "form-control";
		$this->production_plan->EditCustomAttributes = "";
		$this->production_plan->EditValue = $this->production_plan->options(TRUE);

		// lot_no
		$this->lot_no->EditAttrs["class"] = "form-control";
		$this->lot_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
		$this->lot_no->EditValue = $this->lot_no->CurrentValue;
		$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

		// product_gcode
		$this->product_gcode->EditAttrs["class"] = "form-control";
		$this->product_gcode->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->product_gcode->CurrentValue = HtmlDecode($this->product_gcode->CurrentValue);
		$this->product_gcode->EditValue = $this->product_gcode->CurrentValue;
		$this->product_gcode->PlaceHolder = RemoveHtml($this->product_gcode->caption());

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";
		$this->batch_no->EditValue = $this->batch_no->CurrentValue;
		$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

		// uploads
		$this->uploads->EditAttrs["class"] = "form-control";
		$this->uploads->EditCustomAttributes = "";
		$this->uploads->EditValue = $this->uploads->CurrentValue;
		$this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());

		// d_01_head
		$this->d_01_head->EditAttrs["class"] = "form-control";
		$this->d_01_head->EditCustomAttributes = "";
		$this->d_01_head->EditValue = $this->d_01_head->CurrentValue;
		$this->d_01_head->PlaceHolder = RemoveHtml($this->d_01_head->caption());

		// d_02_head
		$this->d_02_head->EditAttrs["class"] = "form-control";
		$this->d_02_head->EditCustomAttributes = "";
		$this->d_02_head->EditValue = $this->d_02_head->CurrentValue;
		$this->d_02_head->PlaceHolder = RemoveHtml($this->d_02_head->caption());

		// d_03_head
		$this->d_03_head->EditAttrs["class"] = "form-control";
		$this->d_03_head->EditCustomAttributes = "";
		$this->d_03_head->EditValue = $this->d_03_head->CurrentValue;
		$this->d_03_head->PlaceHolder = RemoveHtml($this->d_03_head->caption());

		// d_04_head
		$this->d_04_head->EditAttrs["class"] = "form-control";
		$this->d_04_head->EditCustomAttributes = "";
		$this->d_04_head->EditValue = $this->d_04_head->CurrentValue;
		$this->d_04_head->PlaceHolder = RemoveHtml($this->d_04_head->caption());

		// d_05_head
		$this->d_05_head->EditAttrs["class"] = "form-control";
		$this->d_05_head->EditCustomAttributes = "";
		$this->d_05_head->EditValue = $this->d_05_head->CurrentValue;
		$this->d_05_head->PlaceHolder = RemoveHtml($this->d_05_head->caption());

		// d_06_head
		$this->d_06_head->EditAttrs["class"] = "form-control";
		$this->d_06_head->EditCustomAttributes = "";
		$this->d_06_head->EditValue = $this->d_06_head->CurrentValue;
		$this->d_06_head->PlaceHolder = RemoveHtml($this->d_06_head->caption());

		// d_07_head
		$this->d_07_head->EditAttrs["class"] = "form-control";
		$this->d_07_head->EditCustomAttributes = "";
		$this->d_07_head->EditValue = $this->d_07_head->CurrentValue;
		$this->d_07_head->PlaceHolder = RemoveHtml($this->d_07_head->caption());

		// d_08_head
		$this->d_08_head->EditAttrs["class"] = "form-control";
		$this->d_08_head->EditCustomAttributes = "";
		$this->d_08_head->EditValue = $this->d_08_head->CurrentValue;
		$this->d_08_head->PlaceHolder = RemoveHtml($this->d_08_head->caption());

		// sample
		$this->sample->EditAttrs["class"] = "form-control";
		$this->sample->EditCustomAttributes = "";
		$this->sample->EditValue = $this->sample->CurrentValue;
		$this->sample->PlaceHolder = RemoveHtml($this->sample->caption());

		// balance_quantity
		$this->balance_quantity->EditAttrs["class"] = "form-control";
		$this->balance_quantity->EditCustomAttributes = "";
		$this->balance_quantity->EditValue = $this->balance_quantity->CurrentValue;
		$this->balance_quantity->PlaceHolder = RemoveHtml($this->balance_quantity->caption());
		if (strval($this->balance_quantity->EditValue) <> "" && is_numeric($this->balance_quantity->EditValue))
			$this->balance_quantity->EditValue = FormatNumber($this->balance_quantity->EditValue, -2, -2, -2, -2);

		// action
		$this->_action->EditAttrs["class"] = "form-control";
		$this->_action->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_action->CurrentValue = HtmlDecode($this->_action->CurrentValue);
		$this->_action->EditValue = $this->_action->CurrentValue;
		$this->_action->PlaceHolder = RemoveHtml($this->_action->caption());

		// url
		$this->url->EditAttrs["class"] = "form-control";
		$this->url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
		$this->url->EditValue = $this->url->CurrentValue;
		$this->url->PlaceHolder = RemoveHtml($this->url->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->order_type);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->buyer_order_no);
					$doc->exportCaption($this->buyer_order_date);
					$doc->exportCaption($this->cart_id);
					$doc->exportCaption($this->buyer_product_ref);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->fob_date);
					$doc->exportCaption($this->part_dispatch);
					$doc->exportCaption($this->payment_terms);
					$doc->exportCaption($this->transport_terms);
					$doc->exportCaption($this->buyer_shipping__id);
					$doc->exportCaption($this->description_07);
					$doc->exportCaption($this->description_20);
					$doc->exportCaption($this->description_17);
					$doc->exportCaption($this->description_18);
					$doc->exportCaption($this->description_19);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->buyer_size);
					$doc->exportCaption($this->description_05);
					$doc->exportCaption($this->description_06);
					$doc->exportCaption($this->description_08);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->a_datetime);
					$doc->exportCaption($this->buyer_instruction);
					$doc->exportCaption($this->d_09_head);
					$doc->exportCaption($this->description_09);
					$doc->exportCaption($this->d_10_head);
					$doc->exportCaption($this->description_10);
					$doc->exportCaption($this->d_11_head);
					$doc->exportCaption($this->description_11);
					$doc->exportCaption($this->d_12_head);
					$doc->exportCaption($this->description_12);
					$doc->exportCaption($this->_action);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->order_type);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->buyer_order_no);
					$doc->exportCaption($this->buyer_order_date);
					$doc->exportCaption($this->buyer_product_ref);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->payment_terms);
					$doc->exportCaption($this->transport_terms);
					$doc->exportCaption($this->buyer_shipping__id);
					$doc->exportCaption($this->description_04);
					$doc->exportCaption($this->description_03);
					$doc->exportCaption($this->description_07);
					$doc->exportCaption($this->description_20);
					$doc->exportCaption($this->description_17);
					$doc->exportCaption($this->description_18);
					$doc->exportCaption($this->description_19);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->buyer_size);
					$doc->exportCaption($this->description_05);
					$doc->exportCaption($this->description_06);
					$doc->exportCaption($this->description_08);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->a_datetime);
					$doc->exportCaption($this->d_09_head);
					$doc->exportCaption($this->description_09);
					$doc->exportCaption($this->d_10_head);
					$doc->exportCaption($this->description_10);
					$doc->exportCaption($this->d_11_head);
					$doc->exportCaption($this->description_11);
					$doc->exportCaption($this->d_12_head);
					$doc->exportCaption($this->description_12);
					$doc->exportCaption($this->_action);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->order_type);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->buyer_order_no);
						$doc->exportField($this->buyer_order_date);
						$doc->exportField($this->cart_id);
						$doc->exportField($this->buyer_product_ref);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->fob_date);
						$doc->exportField($this->part_dispatch);
						$doc->exportField($this->payment_terms);
						$doc->exportField($this->transport_terms);
						$doc->exportField($this->buyer_shipping__id);
						$doc->exportField($this->description_07);
						$doc->exportField($this->description_20);
						$doc->exportField($this->description_17);
						$doc->exportField($this->description_18);
						$doc->exportField($this->description_19);
						$doc->exportField($this->quantity);
						$doc->exportField($this->price);
						$doc->exportField($this->amount);
						$doc->exportField($this->cbm);
						$doc->exportField($this->buyer_size);
						$doc->exportField($this->description_05);
						$doc->exportField($this->description_06);
						$doc->exportField($this->description_08);
						$doc->exportField($this->remarks);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->a_datetime);
						$doc->exportField($this->buyer_instruction);
						$doc->exportField($this->d_09_head);
						$doc->exportField($this->description_09);
						$doc->exportField($this->d_10_head);
						$doc->exportField($this->description_10);
						$doc->exportField($this->d_11_head);
						$doc->exportField($this->description_11);
						$doc->exportField($this->d_12_head);
						$doc->exportField($this->description_12);
						$doc->exportField($this->_action);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->order_type);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->buyer_order_no);
						$doc->exportField($this->buyer_order_date);
						$doc->exportField($this->buyer_product_ref);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->payment_terms);
						$doc->exportField($this->transport_terms);
						$doc->exportField($this->buyer_shipping__id);
						$doc->exportField($this->description_04);
						$doc->exportField($this->description_03);
						$doc->exportField($this->description_07);
						$doc->exportField($this->description_20);
						$doc->exportField($this->description_17);
						$doc->exportField($this->description_18);
						$doc->exportField($this->description_19);
						$doc->exportField($this->quantity);
						$doc->exportField($this->buyer_size);
						$doc->exportField($this->description_05);
						$doc->exportField($this->description_06);
						$doc->exportField($this->description_08);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->a_datetime);
						$doc->exportField($this->d_09_head);
						$doc->exportField($this->description_09);
						$doc->exportField($this->d_10_head);
						$doc->exportField($this->description_10);
						$doc->exportField($this->d_11_head);
						$doc->exportField($this->description_11);
						$doc->exportField($this->d_12_head);
						$doc->exportField($this->description_12);
						$doc->exportField($this->_action);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>