<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class po_add extends po
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'po';

	// Page object name
	public $PageObjName = "po_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (po)
		if (!isset($GLOBALS["po"]) || get_class($GLOBALS["po"]) == PROJECT_NAMESPACE . "po") {
			$GLOBALS["po"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["po"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'po');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $po;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($po);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "poview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("polist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->order_type->setVisibility();
		$this->buyer_id->setVisibility();
		$this->buyer_order_no->setVisibility();
		$this->buyer_order_date->setVisibility();
		$this->cart_id->setVisibility();
		$this->buyer_product_ref->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid->setVisibility();
		$this->despatch_date->setVisibility();
		$this->despatch_week->setVisibility();
		$this->fob_date->setVisibility();
		$this->part_dispatch->setVisibility();
		$this->payment_terms->setVisibility();
		$this->transport_terms->setVisibility();
		$this->buyer_shipping__id->setVisibility();
		$this->description_04->setVisibility();
		$this->description_03->setVisibility();
		$this->description_01->setVisibility();
		$this->description_02->setVisibility();
		$this->description_07->setVisibility();
		$this->description_20->setVisibility();
		$this->description_17->setVisibility();
		$this->description_18->setVisibility();
		$this->description_19->setVisibility();
		$this->quantity->setVisibility();
		$this->price->setVisibility();
		$this->currency->setVisibility();
		$this->amount->setVisibility();
		$this->cbm->setVisibility();
		$this->buyer_size->setVisibility();
		$this->description_05->setVisibility();
		$this->description_06->setVisibility();
		$this->description_08->setVisibility();
		$this->remarks->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->a_operator->Visible = FALSE;
		$this->a_datetime->Visible = FALSE;
		$this->jc_no->Visible = FALSE;
		$this->buyer_instruction->setVisibility();
		$this->d_09_head->setVisibility();
		$this->description_09->setVisibility();
		$this->d_10_head->setVisibility();
		$this->description_10->setVisibility();
		$this->d_11_head->setVisibility();
		$this->description_11->setVisibility();
		$this->d_12_head->setVisibility();
		$this->description_12->setVisibility();
		$this->po->Visible = FALSE;
		$this->production_site->Visible = FALSE;
		$this->c_total->Visible = FALSE;
		$this->production_plan->Visible = FALSE;
		$this->lot_no->Visible = FALSE;
		$this->product_gcode->Visible = FALSE;
		$this->batch_no->Visible = FALSE;
		$this->uploads->Visible = FALSE;
		$this->d_01_head->Visible = FALSE;
		$this->d_02_head->Visible = FALSE;
		$this->d_03_head->Visible = FALSE;
		$this->d_04_head->Visible = FALSE;
		$this->d_05_head->Visible = FALSE;
		$this->d_06_head->Visible = FALSE;
		$this->d_07_head->Visible = FALSE;
		$this->d_08_head->Visible = FALSE;
		$this->sample->Visible = FALSE;
		$this->balance_quantity->Visible = FALSE;
		$this->_action->Visible = FALSE;
		$this->url->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->cart_id);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->payment_terms);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->description_05);
		$this->setupLookupOptions($this->description_06);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->a_operator);
		$this->setupLookupOptions($this->d_09_head);
		$this->setupLookupOptions($this->d_10_head);
		$this->setupLookupOptions($this->d_11_head);
		$this->setupLookupOptions($this->d_12_head);
		$this->setupLookupOptions($this->production_site);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("polist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "polist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "poview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->order_type->CurrentValue = 0;
		$this->buyer_id->CurrentValue = NULL;
		$this->buyer_id->OldValue = $this->buyer_id->CurrentValue;
		$this->buyer_order_no->CurrentValue = NULL;
		$this->buyer_order_no->OldValue = $this->buyer_order_no->CurrentValue;
		$this->buyer_order_date->CurrentValue = CurrentDate();
		$this->cart_id->CurrentValue = NULL;
		$this->cart_id->OldValue = $this->cart_id->CurrentValue;
		$this->buyer_product_ref->CurrentValue = NULL;
		$this->buyer_product_ref->OldValue = $this->buyer_product_ref->CurrentValue;
		$this->grp->CurrentValue = NULL;
		$this->grp->OldValue = $this->grp->CurrentValue;
		$this->s_grp->CurrentValue = NULL;
		$this->s_grp->OldValue = $this->s_grp->CurrentValue;
		$this->product->CurrentValue = NULL;
		$this->product->OldValue = $this->product->CurrentValue;
		$this->rid->CurrentValue = NULL;
		$this->rid->OldValue = $this->rid->CurrentValue;
		$this->despatch_date->CurrentValue = NULL;
		$this->despatch_date->OldValue = $this->despatch_date->CurrentValue;
		$this->despatch_week->CurrentValue = date('W');
		$this->fob_date->CurrentValue = NULL;
		$this->fob_date->OldValue = $this->fob_date->CurrentValue;
		$this->part_dispatch->CurrentValue = NULL;
		$this->part_dispatch->OldValue = $this->part_dispatch->CurrentValue;
		$this->payment_terms->CurrentValue = NULL;
		$this->payment_terms->OldValue = $this->payment_terms->CurrentValue;
		$this->transport_terms->CurrentValue = NULL;
		$this->transport_terms->OldValue = $this->transport_terms->CurrentValue;
		$this->buyer_shipping__id->CurrentValue = NULL;
		$this->buyer_shipping__id->OldValue = $this->buyer_shipping__id->CurrentValue;
		$this->description_04->CurrentValue = 0;
		$this->description_03->CurrentValue = 1;
		$this->description_01->CurrentValue = NULL;
		$this->description_01->OldValue = $this->description_01->CurrentValue;
		$this->description_02->CurrentValue = NULL;
		$this->description_02->OldValue = $this->description_02->CurrentValue;
		$this->description_07->CurrentValue = NULL;
		$this->description_07->OldValue = $this->description_07->CurrentValue;
		$this->description_20->CurrentValue = 1;
		$this->description_17->CurrentValue = NULL;
		$this->description_17->OldValue = $this->description_17->CurrentValue;
		$this->description_18->CurrentValue = NULL;
		$this->description_18->OldValue = $this->description_18->CurrentValue;
		$this->description_19->CurrentValue = NULL;
		$this->description_19->OldValue = $this->description_19->CurrentValue;
		$this->quantity->CurrentValue = NULL;
		$this->quantity->OldValue = $this->quantity->CurrentValue;
		$this->price->CurrentValue = NULL;
		$this->price->OldValue = $this->price->CurrentValue;
		$this->currency->CurrentValue = NULL;
		$this->currency->OldValue = $this->currency->CurrentValue;
		$this->amount->CurrentValue = NULL;
		$this->amount->OldValue = $this->amount->CurrentValue;
		$this->cbm->CurrentValue = NULL;
		$this->cbm->OldValue = $this->cbm->CurrentValue;
		$this->buyer_size->CurrentValue = NULL;
		$this->buyer_size->OldValue = $this->buyer_size->CurrentValue;
		$this->description_05->CurrentValue = NULL;
		$this->description_05->OldValue = $this->description_05->CurrentValue;
		$this->description_06->CurrentValue = NULL;
		$this->description_06->OldValue = $this->description_06->CurrentValue;
		$this->description_08->CurrentValue = NULL;
		$this->description_08->OldValue = $this->description_08->CurrentValue;
		$this->remarks->CurrentValue = NULL;
		$this->remarks->OldValue = $this->remarks->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->a_operator->CurrentValue = NULL;
		$this->a_operator->OldValue = $this->a_operator->CurrentValue;
		$this->a_datetime->CurrentValue = NULL;
		$this->a_datetime->OldValue = $this->a_datetime->CurrentValue;
		$this->jc_no->CurrentValue = NULL;
		$this->jc_no->OldValue = $this->jc_no->CurrentValue;
		$this->buyer_instruction->CurrentValue = NULL;
		$this->buyer_instruction->OldValue = $this->buyer_instruction->CurrentValue;
		$this->d_09_head->CurrentValue = NULL;
		$this->d_09_head->OldValue = $this->d_09_head->CurrentValue;
		$this->description_09->CurrentValue = NULL;
		$this->description_09->OldValue = $this->description_09->CurrentValue;
		$this->d_10_head->CurrentValue = NULL;
		$this->d_10_head->OldValue = $this->d_10_head->CurrentValue;
		$this->description_10->CurrentValue = NULL;
		$this->description_10->OldValue = $this->description_10->CurrentValue;
		$this->d_11_head->CurrentValue = NULL;
		$this->d_11_head->OldValue = $this->d_11_head->CurrentValue;
		$this->description_11->CurrentValue = NULL;
		$this->description_11->OldValue = $this->description_11->CurrentValue;
		$this->d_12_head->CurrentValue = NULL;
		$this->d_12_head->OldValue = $this->d_12_head->CurrentValue;
		$this->description_12->CurrentValue = NULL;
		$this->description_12->OldValue = $this->description_12->CurrentValue;
		$this->po->CurrentValue = 0000;
		$this->production_site->CurrentValue = NULL;
		$this->production_site->OldValue = $this->production_site->CurrentValue;
		$this->c_total->CurrentValue = NULL;
		$this->c_total->OldValue = $this->c_total->CurrentValue;
		$this->production_plan->CurrentValue = NULL;
		$this->production_plan->OldValue = $this->production_plan->CurrentValue;
		$this->lot_no->CurrentValue = NULL;
		$this->lot_no->OldValue = $this->lot_no->CurrentValue;
		$this->product_gcode->CurrentValue = NULL;
		$this->product_gcode->OldValue = $this->product_gcode->CurrentValue;
		$this->batch_no->CurrentValue = NULL;
		$this->batch_no->OldValue = $this->batch_no->CurrentValue;
		$this->uploads->CurrentValue = NULL;
		$this->uploads->OldValue = $this->uploads->CurrentValue;
		$this->d_01_head->CurrentValue = NULL;
		$this->d_01_head->OldValue = $this->d_01_head->CurrentValue;
		$this->d_02_head->CurrentValue = NULL;
		$this->d_02_head->OldValue = $this->d_02_head->CurrentValue;
		$this->d_03_head->CurrentValue = NULL;
		$this->d_03_head->OldValue = $this->d_03_head->CurrentValue;
		$this->d_04_head->CurrentValue = NULL;
		$this->d_04_head->OldValue = $this->d_04_head->CurrentValue;
		$this->d_05_head->CurrentValue = NULL;
		$this->d_05_head->OldValue = $this->d_05_head->CurrentValue;
		$this->d_06_head->CurrentValue = NULL;
		$this->d_06_head->OldValue = $this->d_06_head->CurrentValue;
		$this->d_07_head->CurrentValue = NULL;
		$this->d_07_head->OldValue = $this->d_07_head->CurrentValue;
		$this->d_08_head->CurrentValue = NULL;
		$this->d_08_head->OldValue = $this->d_08_head->CurrentValue;
		$this->sample->CurrentValue = NULL;
		$this->sample->OldValue = $this->sample->CurrentValue;
		$this->balance_quantity->CurrentValue = 0.00;
		$this->_action->CurrentValue = NULL;
		$this->_action->OldValue = $this->_action->CurrentValue;
		$this->url->CurrentValue = NULL;
		$this->url->OldValue = $this->url->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'order_type' first before field var 'x_order_type'
		$val = $CurrentForm->hasValue("order_type") ? $CurrentForm->getValue("order_type") : $CurrentForm->getValue("x_order_type");
		if (!$this->order_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->order_type->Visible = FALSE; // Disable update for API request
			else
				$this->order_type->setFormValue($val);
		}

		// Check field name 'buyer_id' first before field var 'x_buyer_id'
		$val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
		if (!$this->buyer_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_id->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_id->setFormValue($val);
		}

		// Check field name 'buyer_order_no' first before field var 'x_buyer_order_no'
		$val = $CurrentForm->hasValue("buyer_order_no") ? $CurrentForm->getValue("buyer_order_no") : $CurrentForm->getValue("x_buyer_order_no");
		if (!$this->buyer_order_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_order_no->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_order_no->setFormValue($val);
		}

		// Check field name 'buyer_order_date' first before field var 'x_buyer_order_date'
		$val = $CurrentForm->hasValue("buyer_order_date") ? $CurrentForm->getValue("buyer_order_date") : $CurrentForm->getValue("x_buyer_order_date");
		if (!$this->buyer_order_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_order_date->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_order_date->setFormValue($val);
			$this->buyer_order_date->CurrentValue = UnFormatDateTime($this->buyer_order_date->CurrentValue, 0);
		}

		// Check field name 'cart_id' first before field var 'x_cart_id'
		$val = $CurrentForm->hasValue("cart_id") ? $CurrentForm->getValue("cart_id") : $CurrentForm->getValue("x_cart_id");
		if (!$this->cart_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cart_id->Visible = FALSE; // Disable update for API request
			else
				$this->cart_id->setFormValue($val);
		}

		// Check field name 'buyer_product_ref' first before field var 'x_buyer_product_ref'
		$val = $CurrentForm->hasValue("buyer_product_ref") ? $CurrentForm->getValue("buyer_product_ref") : $CurrentForm->getValue("x_buyer_product_ref");
		if (!$this->buyer_product_ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_product_ref->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_product_ref->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid->Visible = FALSE; // Disable update for API request
			else
				$this->rid->setFormValue($val);
		}

		// Check field name 'despatch_date' first before field var 'x_despatch_date'
		$val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
		if (!$this->despatch_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_date->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_date->setFormValue($val);
			$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		}

		// Check field name 'despatch_week' first before field var 'x_despatch_week'
		$val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
		if (!$this->despatch_week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_week->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_week->setFormValue($val);
		}

		// Check field name 'fob_date' first before field var 'x_fob_date'
		$val = $CurrentForm->hasValue("fob_date") ? $CurrentForm->getValue("fob_date") : $CurrentForm->getValue("x_fob_date");
		if (!$this->fob_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fob_date->Visible = FALSE; // Disable update for API request
			else
				$this->fob_date->setFormValue($val);
			$this->fob_date->CurrentValue = UnFormatDateTime($this->fob_date->CurrentValue, 0);
		}

		// Check field name 'part_dispatch' first before field var 'x_part_dispatch'
		$val = $CurrentForm->hasValue("part_dispatch") ? $CurrentForm->getValue("part_dispatch") : $CurrentForm->getValue("x_part_dispatch");
		if (!$this->part_dispatch->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->part_dispatch->Visible = FALSE; // Disable update for API request
			else
				$this->part_dispatch->setFormValue($val);
		}

		// Check field name 'payment_terms' first before field var 'x_payment_terms'
		$val = $CurrentForm->hasValue("payment_terms") ? $CurrentForm->getValue("payment_terms") : $CurrentForm->getValue("x_payment_terms");
		if (!$this->payment_terms->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->payment_terms->Visible = FALSE; // Disable update for API request
			else
				$this->payment_terms->setFormValue($val);
		}

		// Check field name 'transport_terms' first before field var 'x_transport_terms'
		$val = $CurrentForm->hasValue("transport_terms") ? $CurrentForm->getValue("transport_terms") : $CurrentForm->getValue("x_transport_terms");
		if (!$this->transport_terms->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->transport_terms->Visible = FALSE; // Disable update for API request
			else
				$this->transport_terms->setFormValue($val);
		}

		// Check field name 'buyer_shipping _id' first before field var 'x_buyer_shipping__id'
		$val = $CurrentForm->hasValue("buyer_shipping _id") ? $CurrentForm->getValue("buyer_shipping _id") : $CurrentForm->getValue("x_buyer_shipping__id");
		if (!$this->buyer_shipping__id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_shipping__id->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_shipping__id->setFormValue($val);
		}

		// Check field name 'description_04' first before field var 'x_description_04'
		$val = $CurrentForm->hasValue("description_04") ? $CurrentForm->getValue("description_04") : $CurrentForm->getValue("x_description_04");
		if (!$this->description_04->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_04->Visible = FALSE; // Disable update for API request
			else
				$this->description_04->setFormValue($val);
		}

		// Check field name 'description_03' first before field var 'x_description_03'
		$val = $CurrentForm->hasValue("description_03") ? $CurrentForm->getValue("description_03") : $CurrentForm->getValue("x_description_03");
		if (!$this->description_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_03->Visible = FALSE; // Disable update for API request
			else
				$this->description_03->setFormValue($val);
		}

		// Check field name 'description_01' first before field var 'x_description_01'
		$val = $CurrentForm->hasValue("description_01") ? $CurrentForm->getValue("description_01") : $CurrentForm->getValue("x_description_01");
		if (!$this->description_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_01->Visible = FALSE; // Disable update for API request
			else
				$this->description_01->setFormValue($val);
		}

		// Check field name 'description_02' first before field var 'x_description_02'
		$val = $CurrentForm->hasValue("description_02") ? $CurrentForm->getValue("description_02") : $CurrentForm->getValue("x_description_02");
		if (!$this->description_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_02->Visible = FALSE; // Disable update for API request
			else
				$this->description_02->setFormValue($val);
		}

		// Check field name 'description_07' first before field var 'x_description_07'
		$val = $CurrentForm->hasValue("description_07") ? $CurrentForm->getValue("description_07") : $CurrentForm->getValue("x_description_07");
		if (!$this->description_07->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_07->Visible = FALSE; // Disable update for API request
			else
				$this->description_07->setFormValue($val);
		}

		// Check field name 'description_20' first before field var 'x_description_20'
		$val = $CurrentForm->hasValue("description_20") ? $CurrentForm->getValue("description_20") : $CurrentForm->getValue("x_description_20");
		if (!$this->description_20->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_20->Visible = FALSE; // Disable update for API request
			else
				$this->description_20->setFormValue($val);
		}

		// Check field name 'description_17' first before field var 'x_description_17'
		$val = $CurrentForm->hasValue("description_17") ? $CurrentForm->getValue("description_17") : $CurrentForm->getValue("x_description_17");
		if (!$this->description_17->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_17->Visible = FALSE; // Disable update for API request
			else
				$this->description_17->setFormValue($val);
		}

		// Check field name 'description_18' first before field var 'x_description_18'
		$val = $CurrentForm->hasValue("description_18") ? $CurrentForm->getValue("description_18") : $CurrentForm->getValue("x_description_18");
		if (!$this->description_18->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_18->Visible = FALSE; // Disable update for API request
			else
				$this->description_18->setFormValue($val);
		}

		// Check field name 'description_19' first before field var 'x_description_19'
		$val = $CurrentForm->hasValue("description_19") ? $CurrentForm->getValue("description_19") : $CurrentForm->getValue("x_description_19");
		if (!$this->description_19->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_19->Visible = FALSE; // Disable update for API request
			else
				$this->description_19->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'price' first before field var 'x_price'
		$val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
		if (!$this->price->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->price->Visible = FALSE; // Disable update for API request
			else
				$this->price->setFormValue($val);
		}

		// Check field name 'currency' first before field var 'x_currency'
		$val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
		if (!$this->currency->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->currency->Visible = FALSE; // Disable update for API request
			else
				$this->currency->setFormValue($val);
		}

		// Check field name 'amount' first before field var 'x_amount'
		$val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
		if (!$this->amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->amount->Visible = FALSE; // Disable update for API request
			else
				$this->amount->setFormValue($val);
		}

		// Check field name 'cbm' first before field var 'x_cbm'
		$val = $CurrentForm->hasValue("cbm") ? $CurrentForm->getValue("cbm") : $CurrentForm->getValue("x_cbm");
		if (!$this->cbm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cbm->Visible = FALSE; // Disable update for API request
			else
				$this->cbm->setFormValue($val);
		}

		// Check field name 'buyer_size' first before field var 'x_buyer_size'
		$val = $CurrentForm->hasValue("buyer_size") ? $CurrentForm->getValue("buyer_size") : $CurrentForm->getValue("x_buyer_size");
		if (!$this->buyer_size->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_size->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_size->setFormValue($val);
		}

		// Check field name 'description_05' first before field var 'x_description_05'
		$val = $CurrentForm->hasValue("description_05") ? $CurrentForm->getValue("description_05") : $CurrentForm->getValue("x_description_05");
		if (!$this->description_05->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_05->Visible = FALSE; // Disable update for API request
			else
				$this->description_05->setFormValue($val);
		}

		// Check field name 'description_06' first before field var 'x_description_06'
		$val = $CurrentForm->hasValue("description_06") ? $CurrentForm->getValue("description_06") : $CurrentForm->getValue("x_description_06");
		if (!$this->description_06->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_06->Visible = FALSE; // Disable update for API request
			else
				$this->description_06->setFormValue($val);
		}

		// Check field name 'description_08' first before field var 'x_description_08'
		$val = $CurrentForm->hasValue("description_08") ? $CurrentForm->getValue("description_08") : $CurrentForm->getValue("x_description_08");
		if (!$this->description_08->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_08->Visible = FALSE; // Disable update for API request
			else
				$this->description_08->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'buyer_instruction' first before field var 'x_buyer_instruction'
		$val = $CurrentForm->hasValue("buyer_instruction") ? $CurrentForm->getValue("buyer_instruction") : $CurrentForm->getValue("x_buyer_instruction");
		if (!$this->buyer_instruction->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_instruction->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_instruction->setFormValue($val);
		}

		// Check field name 'd_09_head' first before field var 'x_d_09_head'
		$val = $CurrentForm->hasValue("d_09_head") ? $CurrentForm->getValue("d_09_head") : $CurrentForm->getValue("x_d_09_head");
		if (!$this->d_09_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_09_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_09_head->setFormValue($val);
		}

		// Check field name 'description_09' first before field var 'x_description_09'
		$val = $CurrentForm->hasValue("description_09") ? $CurrentForm->getValue("description_09") : $CurrentForm->getValue("x_description_09");
		if (!$this->description_09->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_09->Visible = FALSE; // Disable update for API request
			else
				$this->description_09->setFormValue($val);
		}

		// Check field name 'd_10_head' first before field var 'x_d_10_head'
		$val = $CurrentForm->hasValue("d_10_head") ? $CurrentForm->getValue("d_10_head") : $CurrentForm->getValue("x_d_10_head");
		if (!$this->d_10_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_10_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_10_head->setFormValue($val);
		}

		// Check field name 'description_10' first before field var 'x_description_10'
		$val = $CurrentForm->hasValue("description_10") ? $CurrentForm->getValue("description_10") : $CurrentForm->getValue("x_description_10");
		if (!$this->description_10->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_10->Visible = FALSE; // Disable update for API request
			else
				$this->description_10->setFormValue($val);
		}

		// Check field name 'd_11_head' first before field var 'x_d_11_head'
		$val = $CurrentForm->hasValue("d_11_head") ? $CurrentForm->getValue("d_11_head") : $CurrentForm->getValue("x_d_11_head");
		if (!$this->d_11_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_11_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_11_head->setFormValue($val);
		}

		// Check field name 'description_11' first before field var 'x_description_11'
		$val = $CurrentForm->hasValue("description_11") ? $CurrentForm->getValue("description_11") : $CurrentForm->getValue("x_description_11");
		if (!$this->description_11->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_11->Visible = FALSE; // Disable update for API request
			else
				$this->description_11->setFormValue($val);
		}

		// Check field name 'd_12_head' first before field var 'x_d_12_head'
		$val = $CurrentForm->hasValue("d_12_head") ? $CurrentForm->getValue("d_12_head") : $CurrentForm->getValue("x_d_12_head");
		if (!$this->d_12_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_12_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_12_head->setFormValue($val);
		}

		// Check field name 'description_12' first before field var 'x_description_12'
		$val = $CurrentForm->hasValue("description_12") ? $CurrentForm->getValue("description_12") : $CurrentForm->getValue("x_description_12");
		if (!$this->description_12->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_12->Visible = FALSE; // Disable update for API request
			else
				$this->description_12->setFormValue($val);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->order_type->CurrentValue = $this->order_type->FormValue;
		$this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
		$this->buyer_order_no->CurrentValue = $this->buyer_order_no->FormValue;
		$this->buyer_order_date->CurrentValue = $this->buyer_order_date->FormValue;
		$this->buyer_order_date->CurrentValue = UnFormatDateTime($this->buyer_order_date->CurrentValue, 0);
		$this->cart_id->CurrentValue = $this->cart_id->FormValue;
		$this->buyer_product_ref->CurrentValue = $this->buyer_product_ref->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->rid->CurrentValue = $this->rid->FormValue;
		$this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
		$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		$this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
		$this->fob_date->CurrentValue = $this->fob_date->FormValue;
		$this->fob_date->CurrentValue = UnFormatDateTime($this->fob_date->CurrentValue, 0);
		$this->part_dispatch->CurrentValue = $this->part_dispatch->FormValue;
		$this->payment_terms->CurrentValue = $this->payment_terms->FormValue;
		$this->transport_terms->CurrentValue = $this->transport_terms->FormValue;
		$this->buyer_shipping__id->CurrentValue = $this->buyer_shipping__id->FormValue;
		$this->description_04->CurrentValue = $this->description_04->FormValue;
		$this->description_03->CurrentValue = $this->description_03->FormValue;
		$this->description_01->CurrentValue = $this->description_01->FormValue;
		$this->description_02->CurrentValue = $this->description_02->FormValue;
		$this->description_07->CurrentValue = $this->description_07->FormValue;
		$this->description_20->CurrentValue = $this->description_20->FormValue;
		$this->description_17->CurrentValue = $this->description_17->FormValue;
		$this->description_18->CurrentValue = $this->description_18->FormValue;
		$this->description_19->CurrentValue = $this->description_19->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->price->CurrentValue = $this->price->FormValue;
		$this->currency->CurrentValue = $this->currency->FormValue;
		$this->amount->CurrentValue = $this->amount->FormValue;
		$this->cbm->CurrentValue = $this->cbm->FormValue;
		$this->buyer_size->CurrentValue = $this->buyer_size->FormValue;
		$this->description_05->CurrentValue = $this->description_05->FormValue;
		$this->description_06->CurrentValue = $this->description_06->FormValue;
		$this->description_08->CurrentValue = $this->description_08->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->buyer_instruction->CurrentValue = $this->buyer_instruction->FormValue;
		$this->d_09_head->CurrentValue = $this->d_09_head->FormValue;
		$this->description_09->CurrentValue = $this->description_09->FormValue;
		$this->d_10_head->CurrentValue = $this->d_10_head->FormValue;
		$this->description_10->CurrentValue = $this->description_10->FormValue;
		$this->d_11_head->CurrentValue = $this->d_11_head->FormValue;
		$this->description_11->CurrentValue = $this->description_11->FormValue;
		$this->d_12_head->CurrentValue = $this->d_12_head->FormValue;
		$this->description_12->CurrentValue = $this->description_12->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->order_type->setDbValue($row['order_type']);
		$this->buyer_id->setDbValue($row['buyer_id']);
		$this->buyer_order_no->setDbValue($row['buyer_order_no']);
		$this->buyer_order_date->setDbValue($row['buyer_order_date']);
		$this->cart_id->setDbValue($row['cart_id']);
		$this->buyer_product_ref->setDbValue($row['buyer_product_ref']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->rid->setDbValue($row['rid']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->despatch_week->setDbValue($row['despatch_week']);
		$this->fob_date->setDbValue($row['fob_date']);
		$this->part_dispatch->setDbValue($row['part_dispatch']);
		$this->payment_terms->setDbValue($row['payment_terms']);
		$this->transport_terms->setDbValue($row['transport_terms']);
		$this->buyer_shipping__id->setDbValue($row['buyer_shipping _id']);
		$this->description_04->setDbValue($row['description_04']);
		$this->description_03->setDbValue($row['description_03']);
		$this->description_01->setDbValue($row['description_01']);
		$this->description_02->setDbValue($row['description_02']);
		$this->description_07->setDbValue($row['description_07']);
		$this->description_20->setDbValue($row['description_20']);
		$this->description_17->setDbValue($row['description_17']);
		$this->description_18->setDbValue($row['description_18']);
		$this->description_19->setDbValue($row['description_19']);
		$this->quantity->setDbValue($row['quantity']);
		$this->price->setDbValue($row['price']);
		$this->currency->setDbValue($row['currency']);
		$this->amount->setDbValue($row['amount']);
		$this->cbm->setDbValue($row['cbm']);
		$this->buyer_size->setDbValue($row['buyer_size']);
		$this->description_05->setDbValue($row['description_05']);
		$this->description_06->setDbValue($row['description_06']);
		$this->description_08->setDbValue($row['description_08']);
		$this->remarks->setDbValue($row['remarks']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->a_datetime->setDbValue($row['a_datetime']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->buyer_instruction->setDbValue($row['buyer_instruction']);
		$this->d_09_head->setDbValue($row['d_09_head']);
		$this->description_09->setDbValue($row['description_09']);
		$this->d_10_head->setDbValue($row['d_10_head']);
		$this->description_10->setDbValue($row['description_10']);
		$this->d_11_head->setDbValue($row['d_11_head']);
		$this->description_11->setDbValue($row['description_11']);
		$this->d_12_head->setDbValue($row['d_12_head']);
		$this->description_12->setDbValue($row['description_12']);
		$this->po->setDbValue($row['po']);
		$this->production_site->setDbValue($row['production_site']);
		$this->c_total->setDbValue($row['c_total']);
		$this->production_plan->setDbValue($row['production_plan']);
		$this->lot_no->setDbValue($row['lot_no']);
		$this->product_gcode->setDbValue($row['product_gcode']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->uploads->setDbValue($row['uploads']);
		$this->d_01_head->setDbValue($row['d_01_head']);
		$this->d_02_head->setDbValue($row['d_02_head']);
		$this->d_03_head->setDbValue($row['d_03_head']);
		$this->d_04_head->setDbValue($row['d_04_head']);
		$this->d_05_head->setDbValue($row['d_05_head']);
		$this->d_06_head->setDbValue($row['d_06_head']);
		$this->d_07_head->setDbValue($row['d_07_head']);
		$this->d_08_head->setDbValue($row['d_08_head']);
		$this->sample->setDbValue($row['sample']);
		$this->balance_quantity->setDbValue($row['balance_quantity']);
		$this->_action->setDbValue($row['action']);
		$this->url->setDbValue($row['url']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['order_type'] = $this->order_type->CurrentValue;
		$row['buyer_id'] = $this->buyer_id->CurrentValue;
		$row['buyer_order_no'] = $this->buyer_order_no->CurrentValue;
		$row['buyer_order_date'] = $this->buyer_order_date->CurrentValue;
		$row['cart_id'] = $this->cart_id->CurrentValue;
		$row['buyer_product_ref'] = $this->buyer_product_ref->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['s_grp'] = $this->s_grp->CurrentValue;
		$row['product'] = $this->product->CurrentValue;
		$row['rid'] = $this->rid->CurrentValue;
		$row['despatch_date'] = $this->despatch_date->CurrentValue;
		$row['despatch_week'] = $this->despatch_week->CurrentValue;
		$row['fob_date'] = $this->fob_date->CurrentValue;
		$row['part_dispatch'] = $this->part_dispatch->CurrentValue;
		$row['payment_terms'] = $this->payment_terms->CurrentValue;
		$row['transport_terms'] = $this->transport_terms->CurrentValue;
		$row['buyer_shipping _id'] = $this->buyer_shipping__id->CurrentValue;
		$row['description_04'] = $this->description_04->CurrentValue;
		$row['description_03'] = $this->description_03->CurrentValue;
		$row['description_01'] = $this->description_01->CurrentValue;
		$row['description_02'] = $this->description_02->CurrentValue;
		$row['description_07'] = $this->description_07->CurrentValue;
		$row['description_20'] = $this->description_20->CurrentValue;
		$row['description_17'] = $this->description_17->CurrentValue;
		$row['description_18'] = $this->description_18->CurrentValue;
		$row['description_19'] = $this->description_19->CurrentValue;
		$row['quantity'] = $this->quantity->CurrentValue;
		$row['price'] = $this->price->CurrentValue;
		$row['currency'] = $this->currency->CurrentValue;
		$row['amount'] = $this->amount->CurrentValue;
		$row['cbm'] = $this->cbm->CurrentValue;
		$row['buyer_size'] = $this->buyer_size->CurrentValue;
		$row['description_05'] = $this->description_05->CurrentValue;
		$row['description_06'] = $this->description_06->CurrentValue;
		$row['description_08'] = $this->description_08->CurrentValue;
		$row['remarks'] = $this->remarks->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['a_operator'] = $this->a_operator->CurrentValue;
		$row['a_datetime'] = $this->a_datetime->CurrentValue;
		$row['jc_no'] = $this->jc_no->CurrentValue;
		$row['buyer_instruction'] = $this->buyer_instruction->CurrentValue;
		$row['d_09_head'] = $this->d_09_head->CurrentValue;
		$row['description_09'] = $this->description_09->CurrentValue;
		$row['d_10_head'] = $this->d_10_head->CurrentValue;
		$row['description_10'] = $this->description_10->CurrentValue;
		$row['d_11_head'] = $this->d_11_head->CurrentValue;
		$row['description_11'] = $this->description_11->CurrentValue;
		$row['d_12_head'] = $this->d_12_head->CurrentValue;
		$row['description_12'] = $this->description_12->CurrentValue;
		$row['po'] = $this->po->CurrentValue;
		$row['production_site'] = $this->production_site->CurrentValue;
		$row['c_total'] = $this->c_total->CurrentValue;
		$row['production_plan'] = $this->production_plan->CurrentValue;
		$row['lot_no'] = $this->lot_no->CurrentValue;
		$row['product_gcode'] = $this->product_gcode->CurrentValue;
		$row['batch_no'] = $this->batch_no->CurrentValue;
		$row['uploads'] = $this->uploads->CurrentValue;
		$row['d_01_head'] = $this->d_01_head->CurrentValue;
		$row['d_02_head'] = $this->d_02_head->CurrentValue;
		$row['d_03_head'] = $this->d_03_head->CurrentValue;
		$row['d_04_head'] = $this->d_04_head->CurrentValue;
		$row['d_05_head'] = $this->d_05_head->CurrentValue;
		$row['d_06_head'] = $this->d_06_head->CurrentValue;
		$row['d_07_head'] = $this->d_07_head->CurrentValue;
		$row['d_08_head'] = $this->d_08_head->CurrentValue;
		$row['sample'] = $this->sample->CurrentValue;
		$row['balance_quantity'] = $this->balance_quantity->CurrentValue;
		$row['action'] = $this->_action->CurrentValue;
		$row['url'] = $this->url->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->description_01->FormValue == $this->description_01->CurrentValue && is_numeric(ConvertToFloatString($this->description_01->CurrentValue)))
			$this->description_01->CurrentValue = ConvertToFloatString($this->description_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->description_02->FormValue == $this->description_02->CurrentValue && is_numeric(ConvertToFloatString($this->description_02->CurrentValue)))
			$this->description_02->CurrentValue = ConvertToFloatString($this->description_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->description_17->FormValue == $this->description_17->CurrentValue && is_numeric(ConvertToFloatString($this->description_17->CurrentValue)))
			$this->description_17->CurrentValue = ConvertToFloatString($this->description_17->CurrentValue);

		// Convert decimal values if posted back
		if ($this->description_18->FormValue == $this->description_18->CurrentValue && is_numeric(ConvertToFloatString($this->description_18->CurrentValue)))
			$this->description_18->CurrentValue = ConvertToFloatString($this->description_18->CurrentValue);

		// Convert decimal values if posted back
		if ($this->description_19->FormValue == $this->description_19->CurrentValue && is_numeric(ConvertToFloatString($this->description_19->CurrentValue)))
			$this->description_19->CurrentValue = ConvertToFloatString($this->description_19->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cbm->FormValue == $this->cbm->CurrentValue && is_numeric(ConvertToFloatString($this->cbm->CurrentValue)))
			$this->cbm->CurrentValue = ConvertToFloatString($this->cbm->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// order_type
		// buyer_id
		// buyer_order_no
		// buyer_order_date
		// cart_id
		// buyer_product_ref
		// grp
		// s_grp
		// product
		// rid
		// despatch_date
		// despatch_week
		// fob_date
		// part_dispatch
		// payment_terms
		// transport_terms
		// buyer_shipping _id
		// description_04
		// description_03
		// description_01
		// description_02
		// description_07
		// description_20
		// description_17
		// description_18
		// description_19
		// quantity
		// price
		// currency
		// amount
		// cbm
		// buyer_size
		// description_05
		// description_06
		// description_08
		// remarks
		// operator
		// datetime
		// a_operator
		// a_datetime
		// jc_no
		// buyer_instruction
		// d_09_head
		// description_09
		// d_10_head
		// description_10
		// d_11_head
		// description_11
		// d_12_head
		// description_12
		// po
		// production_site
		// c_total
		// production_plan
		// lot_no
		// product_gcode
		// batch_no
		// uploads
		// d_01_head
		// d_02_head
		// d_03_head
		// d_04_head
		// d_05_head
		// d_06_head
		// d_07_head
		// d_08_head
		// sample
		// balance_quantity
		// action
		// url

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// order_type
			if (strval($this->order_type->CurrentValue) <> "") {
				$this->order_type->ViewValue = $this->order_type->optionCaption($this->order_type->CurrentValue);
			} else {
				$this->order_type->ViewValue = NULL;
			}
			$this->order_type->ViewCustomAttributes = "";

			// buyer_id
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// buyer_order_no
			$this->buyer_order_no->ViewValue = $this->buyer_order_no->CurrentValue;
			$this->buyer_order_no->ViewCustomAttributes = "";

			// buyer_order_date
			$this->buyer_order_date->ViewValue = $this->buyer_order_date->CurrentValue;
			$this->buyer_order_date->ViewValue = FormatDateTime($this->buyer_order_date->ViewValue, 0);
			$this->buyer_order_date->ViewCustomAttributes = "";

			// cart_id
			$curVal = strval($this->cart_id->CurrentValue);
			if ($curVal <> "") {
				$this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
				if ($this->cart_id->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` = NULL || `po_id` = '' || `po_id` = '0'" : "`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue;
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->cart_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->cart_id->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, 0);
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, 0);
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, 0);
							$this->cart_id->ViewValue->add($this->cart_id->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->cart_id->ViewValue = $this->cart_id->CurrentValue;
					}
				}
			} else {
				$this->cart_id->ViewValue = NULL;
			}
			$this->cart_id->ViewCustomAttributes = "";

			// buyer_product_ref
			$this->buyer_product_ref->ViewValue = $this->buyer_product_ref->CurrentValue;
			$this->buyer_product_ref->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 ";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `product_type`=0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// fob_date
			$this->fob_date->ViewValue = $this->fob_date->CurrentValue;
			$this->fob_date->ViewValue = FormatDateTime($this->fob_date->ViewValue, 0);
			$this->fob_date->ViewCustomAttributes = "";

			// part_dispatch
			if (strval($this->part_dispatch->CurrentValue) <> "") {
				$this->part_dispatch->ViewValue = $this->part_dispatch->optionCaption($this->part_dispatch->CurrentValue);
			} else {
				$this->part_dispatch->ViewValue = NULL;
			}
			$this->part_dispatch->ViewCustomAttributes = "";

			// payment_terms
			$curVal = strval($this->payment_terms->CurrentValue);
			if ($curVal <> "") {
				$this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
				if ($this->payment_terms->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 81";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->payment_terms->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
					}
				}
			} else {
				$this->payment_terms->ViewValue = NULL;
			}
			$this->payment_terms->ViewCustomAttributes = "";

			// transport_terms
			$this->transport_terms->ViewValue = $this->transport_terms->CurrentValue;
			$this->transport_terms->ViewCustomAttributes = "";

			// buyer_shipping _id
			$this->buyer_shipping__id->ViewValue = $this->buyer_shipping__id->CurrentValue;
			$this->buyer_shipping__id->ViewValue = FormatNumber($this->buyer_shipping__id->ViewValue, 0, -2, -2, -2);
			$this->buyer_shipping__id->ViewCustomAttributes = "";

			// description_04
			if (strval($this->description_04->CurrentValue) <> "") {
				$this->description_04->ViewValue = $this->description_04->optionCaption($this->description_04->CurrentValue);
			} else {
				$this->description_04->ViewValue = NULL;
			}
			$this->description_04->ViewCustomAttributes = "";

			// description_03
			if (strval($this->description_03->CurrentValue) <> "") {
				$this->description_03->ViewValue = $this->description_03->optionCaption($this->description_03->CurrentValue);
			} else {
				$this->description_03->ViewValue = NULL;
			}
			$this->description_03->ViewCustomAttributes = "";

			// description_01
			$this->description_01->ViewValue = $this->description_01->CurrentValue;
			$this->description_01->ViewValue = FormatNumber($this->description_01->ViewValue, 3, -2, -2, -2);
			$this->description_01->ViewCustomAttributes = "";

			// description_02
			$this->description_02->ViewValue = $this->description_02->CurrentValue;
			$this->description_02->ViewValue = FormatNumber($this->description_02->ViewValue, 3, -2, -2, -2);
			$this->description_02->ViewCustomAttributes = "";

			// description_07
			$this->description_07->ViewValue = $this->description_07->CurrentValue;
			$this->description_07->ViewCustomAttributes = "";

			// description_20
			if (strval($this->description_20->CurrentValue) <> "") {
				$this->description_20->ViewValue = $this->description_20->optionCaption($this->description_20->CurrentValue);
			} else {
				$this->description_20->ViewValue = NULL;
			}
			$this->description_20->ViewCustomAttributes = "";

			// description_17
			$this->description_17->ViewValue = $this->description_17->CurrentValue;
			$this->description_17->ViewValue = FormatNumber($this->description_17->ViewValue, 2, -2, -2, -2);
			$this->description_17->ViewCustomAttributes = "";

			// description_18
			$this->description_18->ViewValue = $this->description_18->CurrentValue;
			$this->description_18->ViewValue = FormatNumber($this->description_18->ViewValue, 2, -2, -2, -2);
			$this->description_18->ViewCustomAttributes = "";

			// description_19
			$this->description_19->ViewValue = $this->description_19->CurrentValue;
			$this->description_19->ViewValue = FormatNumber($this->description_19->ViewValue, 2, -2, -2, -2);
			$this->description_19->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 2, -2, -2, -2);
			$this->cbm->ViewCustomAttributes = "";

			// buyer_size
			$this->buyer_size->ViewValue = $this->buyer_size->CurrentValue;
			$this->buyer_size->ViewCustomAttributes = "";

			// description_05
			$curVal = strval($this->description_05->CurrentValue);
			if ($curVal <> "") {
				$this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
				if ($this->description_05->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_05->ViewValue = $this->description_05->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_05->ViewValue = $this->description_05->CurrentValue;
					}
				}
			} else {
				$this->description_05->ViewValue = NULL;
			}
			$this->description_05->ViewCustomAttributes = "";

			// description_06
			$curVal = strval($this->description_06->CurrentValue);
			if ($curVal <> "") {
				$this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
				if ($this->description_06->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_06->ViewValue = $this->description_06->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_06->ViewValue = $this->description_06->CurrentValue;
					}
				}
			} else {
				$this->description_06->ViewValue = NULL;
			}
			$this->description_06->ViewCustomAttributes = "";

			// description_08
			$this->description_08->ViewValue = $this->description_08->CurrentValue;
			$this->description_08->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// a_operator
			$curVal = strval($this->a_operator->CurrentValue);
			if ($curVal <> "") {
				$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
				if ($this->a_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
					}
				}
			} else {
				$this->a_operator->ViewValue = NULL;
			}
			$this->a_operator->ViewCustomAttributes = "";

			// a_datetime
			$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
			$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 0);
			$this->a_datetime->ViewCustomAttributes = "";

			// buyer_instruction
			$this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;
			$this->buyer_instruction->ViewCustomAttributes = "";

			// d_09_head
			$curVal = strval($this->d_09_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
				if ($this->d_09_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_09_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_09_head->ViewValue = $this->d_09_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_09_head->ViewValue = $this->d_09_head->CurrentValue;
					}
				}
			} else {
				$this->d_09_head->ViewValue = NULL;
			}
			$this->d_09_head->ViewCustomAttributes = "";

			// description_09
			$this->description_09->ViewValue = $this->description_09->CurrentValue;
			$this->description_09->ViewCustomAttributes = "";

			// d_10_head
			$curVal = strval($this->d_10_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
				if ($this->d_10_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_10_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_10_head->ViewValue = $this->d_10_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_10_head->ViewValue = $this->d_10_head->CurrentValue;
					}
				}
			} else {
				$this->d_10_head->ViewValue = NULL;
			}
			$this->d_10_head->ViewCustomAttributes = "";

			// description_10
			$this->description_10->ViewValue = $this->description_10->CurrentValue;
			$this->description_10->ViewCustomAttributes = "";

			// d_11_head
			$curVal = strval($this->d_11_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
				if ($this->d_11_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_11_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_11_head->ViewValue = $this->d_11_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_11_head->ViewValue = $this->d_11_head->CurrentValue;
					}
				}
			} else {
				$this->d_11_head->ViewValue = NULL;
			}
			$this->d_11_head->ViewCustomAttributes = "";

			// description_11
			$this->description_11->ViewValue = $this->description_11->CurrentValue;
			$this->description_11->ViewCustomAttributes = "";

			// d_12_head
			$curVal = strval($this->d_12_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
				if ($this->d_12_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_12_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_12_head->ViewValue = $this->d_12_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_12_head->ViewValue = $this->d_12_head->CurrentValue;
					}
				}
			} else {
				$this->d_12_head->ViewValue = NULL;
			}
			$this->d_12_head->ViewCustomAttributes = "";

			// description_12
			$this->description_12->ViewValue = $this->description_12->CurrentValue;
			$this->description_12->ViewCustomAttributes = "";

			// action
			$this->_action->ViewValue = $this->_action->CurrentValue;
			$this->_action->CssClass = "font-weight-bold";
			$this->_action->ViewCustomAttributes = 'class = "btn btn-default"';

			// order_type
			$this->order_type->LinkCustomAttributes = "";
			$this->order_type->HrefValue = "";
			$this->order_type->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// buyer_order_no
			$this->buyer_order_no->LinkCustomAttributes = "";
			$this->buyer_order_no->HrefValue = "";
			$this->buyer_order_no->TooltipValue = "";

			// buyer_order_date
			$this->buyer_order_date->LinkCustomAttributes = "";
			$this->buyer_order_date->HrefValue = "";
			$this->buyer_order_date->TooltipValue = "";

			// cart_id
			$this->cart_id->LinkCustomAttributes = "";
			$this->cart_id->HrefValue = "";
			$this->cart_id->TooltipValue = "";

			// buyer_product_ref
			$this->buyer_product_ref->LinkCustomAttributes = "";
			$this->buyer_product_ref->HrefValue = "";
			$this->buyer_product_ref->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "po_clist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "po_clist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "po_clist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// fob_date
			$this->fob_date->LinkCustomAttributes = "";
			$this->fob_date->HrefValue = "";
			$this->fob_date->TooltipValue = "";

			// part_dispatch
			$this->part_dispatch->LinkCustomAttributes = "";
			$this->part_dispatch->HrefValue = "";
			$this->part_dispatch->TooltipValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			$this->payment_terms->HrefValue = "";
			$this->payment_terms->TooltipValue = "";

			// transport_terms
			$this->transport_terms->LinkCustomAttributes = "";
			$this->transport_terms->HrefValue = "";
			$this->transport_terms->TooltipValue = "";

			// buyer_shipping _id
			$this->buyer_shipping__id->LinkCustomAttributes = "";
			$this->buyer_shipping__id->HrefValue = "";
			$this->buyer_shipping__id->TooltipValue = "";

			// description_04
			$this->description_04->LinkCustomAttributes = "";
			$this->description_04->HrefValue = "";
			$this->description_04->TooltipValue = "";

			// description_03
			$this->description_03->LinkCustomAttributes = "";
			$this->description_03->HrefValue = "";
			$this->description_03->TooltipValue = "";

			// description_01
			$this->description_01->LinkCustomAttributes = "";
			$this->description_01->HrefValue = "";
			$this->description_01->TooltipValue = "";

			// description_02
			$this->description_02->LinkCustomAttributes = "";
			$this->description_02->HrefValue = "";
			$this->description_02->TooltipValue = "";

			// description_07
			$this->description_07->LinkCustomAttributes = "";
			$this->description_07->HrefValue = "";
			$this->description_07->TooltipValue = "";

			// description_20
			$this->description_20->LinkCustomAttributes = "";
			$this->description_20->HrefValue = "";
			$this->description_20->TooltipValue = "";

			// description_17
			$this->description_17->LinkCustomAttributes = "";
			$this->description_17->HrefValue = "";
			$this->description_17->TooltipValue = "";

			// description_18
			$this->description_18->LinkCustomAttributes = "";
			$this->description_18->HrefValue = "";
			$this->description_18->TooltipValue = "";

			// description_19
			$this->description_19->LinkCustomAttributes = "";
			$this->description_19->HrefValue = "";
			$this->description_19->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";
			$this->currency->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// buyer_size
			$this->buyer_size->LinkCustomAttributes = "";
			$this->buyer_size->HrefValue = "";
			$this->buyer_size->TooltipValue = "";

			// description_05
			$this->description_05->LinkCustomAttributes = "";
			$this->description_05->HrefValue = "";
			$this->description_05->TooltipValue = "";

			// description_06
			$this->description_06->LinkCustomAttributes = "";
			$this->description_06->HrefValue = "";
			$this->description_06->TooltipValue = "";

			// description_08
			$this->description_08->LinkCustomAttributes = "";
			$this->description_08->HrefValue = "";
			$this->description_08->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// buyer_instruction
			$this->buyer_instruction->LinkCustomAttributes = "";
			$this->buyer_instruction->HrefValue = "";
			$this->buyer_instruction->TooltipValue = "";

			// d_09_head
			$this->d_09_head->LinkCustomAttributes = "";
			$this->d_09_head->HrefValue = "";
			$this->d_09_head->TooltipValue = "";

			// description_09
			$this->description_09->LinkCustomAttributes = "";
			$this->description_09->HrefValue = "";
			$this->description_09->TooltipValue = "";

			// d_10_head
			$this->d_10_head->LinkCustomAttributes = "";
			$this->d_10_head->HrefValue = "";
			$this->d_10_head->TooltipValue = "";

			// description_10
			$this->description_10->LinkCustomAttributes = "";
			$this->description_10->HrefValue = "";
			$this->description_10->TooltipValue = "";

			// d_11_head
			$this->d_11_head->LinkCustomAttributes = "";
			$this->d_11_head->HrefValue = "";
			$this->d_11_head->TooltipValue = "";

			// description_11
			$this->description_11->LinkCustomAttributes = "";
			$this->description_11->HrefValue = "";
			$this->description_11->TooltipValue = "";

			// d_12_head
			$this->d_12_head->LinkCustomAttributes = "";
			$this->d_12_head->HrefValue = "";
			$this->d_12_head->TooltipValue = "";

			// description_12
			$this->description_12->LinkCustomAttributes = "";
			$this->description_12->HrefValue = "";
			$this->description_12->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// order_type
			$this->order_type->EditCustomAttributes = "";
			$this->order_type->EditValue = $this->order_type->options(FALSE);

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->buyer_id->CurrentValue));
			if ($curVal <> "")
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
			else
				$this->buyer_id->ViewValue = $this->buyer_id->Lookup !== NULL && is_array($this->buyer_id->Lookup->Options) ? $curVal : NULL;
			if ($this->buyer_id->ViewValue !== NULL) { // Load from cache
				$this->buyer_id->EditValue = array_values($this->buyer_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->buyer_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` > 1000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->buyer_id->EditValue = $arwrk;
			}

			// buyer_order_no
			$this->buyer_order_no->EditAttrs["class"] = "form-control";
			$this->buyer_order_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_order_no->CurrentValue = HtmlDecode($this->buyer_order_no->CurrentValue);
			$this->buyer_order_no->EditValue = HtmlEncode($this->buyer_order_no->CurrentValue);
			$this->buyer_order_no->PlaceHolder = RemoveHtml($this->buyer_order_no->caption());

			// buyer_order_date
			$this->buyer_order_date->EditAttrs["class"] = "form-control";
			$this->buyer_order_date->EditCustomAttributes = "";
			$this->buyer_order_date->EditValue = HtmlEncode(FormatDateTime($this->buyer_order_date->CurrentValue, 8));
			$this->buyer_order_date->PlaceHolder = RemoveHtml($this->buyer_order_date->caption());

			// cart_id
			$this->cart_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->cart_id->CurrentValue));
			if ($curVal <> "")
				$this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
			else
				$this->cart_id->ViewValue = $this->cart_id->Lookup !== NULL && is_array($this->cart_id->Lookup->Options) ? $curVal : NULL;
			if ($this->cart_id->ViewValue !== NULL) { // Load from cache
				$this->cart_id->EditValue = array_values($this->cart_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` = NULL || `po_id` = '' || `po_id` = '0'" : "`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue;
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->cart_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, 0);
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, 0);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, 0);
				}
				$this->cart_id->EditValue = $arwrk;
			}

			// buyer_product_ref
			$this->buyer_product_ref->EditAttrs["class"] = "form-control";
			$this->buyer_product_ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_product_ref->CurrentValue = HtmlDecode($this->buyer_product_ref->CurrentValue);
			$this->buyer_product_ref->EditValue = HtmlEncode($this->buyer_product_ref->CurrentValue);
			$this->buyer_product_ref->PlaceHolder = RemoveHtml($this->buyer_product_ref->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 ";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->CurrentValue));
			if ($curVal <> "")
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->CurrentValue));
			if ($curVal <> "")
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// rid
			$this->rid->EditCustomAttributes = "";
			$curVal = trim(strval($this->rid->CurrentValue));
			if ($curVal <> "")
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			else
				$this->rid->ViewValue = $this->rid->Lookup !== NULL && is_array($this->rid->Lookup->Options) ? $curVal : NULL;
			if ($this->rid->ViewValue !== NULL) { // Load from cache
				$this->rid->EditValue = array_values($this->rid->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->rid->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `product_type`=0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->rid->EditValue = $arwrk;
			}

			// despatch_date
			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = HtmlEncode(FormatDateTime($this->despatch_date->CurrentValue, 8));
			$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$curVal = trim(strval($this->despatch_week->CurrentValue));
			if ($curVal <> "")
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			else
				$this->despatch_week->ViewValue = $this->despatch_week->Lookup !== NULL && is_array($this->despatch_week->Lookup->Options) ? $curVal : NULL;
			if ($this->despatch_week->ViewValue !== NULL) { // Load from cache
				$this->despatch_week->EditValue = array_values($this->despatch_week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->despatch_week->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->despatch_week->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->despatch_week->EditValue = $arwrk;
			}

			// fob_date
			$this->fob_date->EditAttrs["class"] = "form-control";
			$this->fob_date->EditCustomAttributes = "";
			$this->fob_date->EditValue = HtmlEncode(FormatDateTime($this->fob_date->CurrentValue, 8));
			$this->fob_date->PlaceHolder = RemoveHtml($this->fob_date->caption());

			// part_dispatch
			$this->part_dispatch->EditAttrs["class"] = "form-control";
			$this->part_dispatch->EditCustomAttributes = "";
			$this->part_dispatch->EditValue = $this->part_dispatch->options(TRUE);

			// payment_terms
			$this->payment_terms->EditAttrs["class"] = "form-control";
			$this->payment_terms->EditCustomAttributes = "";
			$curVal = trim(strval($this->payment_terms->CurrentValue));
			if ($curVal <> "")
				$this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
			else
				$this->payment_terms->ViewValue = $this->payment_terms->Lookup !== NULL && is_array($this->payment_terms->Lookup->Options) ? $curVal : NULL;
			if ($this->payment_terms->ViewValue !== NULL) { // Load from cache
				$this->payment_terms->EditValue = array_values($this->payment_terms->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->payment_terms->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 81";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->payment_terms->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->payment_terms->EditValue = $arwrk;
			}

			// transport_terms
			$this->transport_terms->EditAttrs["class"] = "form-control";
			$this->transport_terms->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->transport_terms->CurrentValue = HtmlDecode($this->transport_terms->CurrentValue);
			$this->transport_terms->EditValue = HtmlEncode($this->transport_terms->CurrentValue);
			$this->transport_terms->PlaceHolder = RemoveHtml($this->transport_terms->caption());

			// buyer_shipping _id
			$this->buyer_shipping__id->EditAttrs["class"] = "form-control";
			$this->buyer_shipping__id->EditCustomAttributes = "";
			$this->buyer_shipping__id->EditValue = HtmlEncode($this->buyer_shipping__id->CurrentValue);
			$this->buyer_shipping__id->PlaceHolder = RemoveHtml($this->buyer_shipping__id->caption());

			// description_04
			$this->description_04->EditAttrs["class"] = "form-control";
			$this->description_04->EditCustomAttributes = "";
			$this->description_04->EditValue = $this->description_04->options(TRUE);

			// description_03
			$this->description_03->EditAttrs["class"] = "form-control";
			$this->description_03->EditCustomAttributes = "";
			$this->description_03->EditValue = $this->description_03->options(TRUE);

			// description_01
			$this->description_01->EditAttrs["class"] = "form-control";
			$this->description_01->EditCustomAttributes = "";
			$this->description_01->EditValue = HtmlEncode($this->description_01->CurrentValue);
			$this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());
			if (strval($this->description_01->EditValue) <> "" && is_numeric($this->description_01->EditValue))
				$this->description_01->EditValue = FormatNumber($this->description_01->EditValue, -2, -2, -2, -2);

			// description_02
			$this->description_02->EditAttrs["class"] = "form-control";
			$this->description_02->EditCustomAttributes = "";
			$this->description_02->EditValue = HtmlEncode($this->description_02->CurrentValue);
			$this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());
			if (strval($this->description_02->EditValue) <> "" && is_numeric($this->description_02->EditValue))
				$this->description_02->EditValue = FormatNumber($this->description_02->EditValue, -2, -2, -2, -2);

			// description_07
			$this->description_07->EditAttrs["class"] = "form-control";
			$this->description_07->EditCustomAttributes = "";
			$this->description_07->EditValue = HtmlEncode($this->description_07->CurrentValue);
			$this->description_07->PlaceHolder = RemoveHtml($this->description_07->caption());

			// description_20
			$this->description_20->EditAttrs["class"] = "form-control";
			$this->description_20->EditCustomAttributes = "";
			$this->description_20->EditValue = $this->description_20->options(TRUE);

			// description_17
			$this->description_17->EditAttrs["class"] = "form-control";
			$this->description_17->EditCustomAttributes = 'ReadOnly';
			$this->description_17->EditValue = HtmlEncode($this->description_17->CurrentValue);
			$this->description_17->PlaceHolder = RemoveHtml($this->description_17->caption());
			if (strval($this->description_17->EditValue) <> "" && is_numeric($this->description_17->EditValue))
				$this->description_17->EditValue = FormatNumber($this->description_17->EditValue, -2, -2, -2, -2);

			// description_18
			$this->description_18->EditAttrs["class"] = "form-control";
			$this->description_18->EditCustomAttributes = 'ReadOnly';
			$this->description_18->EditValue = HtmlEncode($this->description_18->CurrentValue);
			$this->description_18->PlaceHolder = RemoveHtml($this->description_18->caption());
			if (strval($this->description_18->EditValue) <> "" && is_numeric($this->description_18->EditValue))
				$this->description_18->EditValue = FormatNumber($this->description_18->EditValue, -2, -2, -2, -2);

			// description_19
			$this->description_19->EditAttrs["class"] = "form-control";
			$this->description_19->EditCustomAttributes = 'ReadOnly';
			$this->description_19->EditValue = HtmlEncode($this->description_19->CurrentValue);
			$this->description_19->PlaceHolder = RemoveHtml($this->description_19->caption());
			if (strval($this->description_19->EditValue) <> "" && is_numeric($this->description_19->EditValue))
				$this->description_19->EditValue = FormatNumber($this->description_19->EditValue, -2, -2, -2, -2);

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = 'ReadOnly';
			$this->price->EditValue = HtmlEncode($this->price->CurrentValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());
			if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
				$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, -2);

			// currency
			$this->currency->EditAttrs["class"] = "form-control";
			$this->currency->EditCustomAttributes = 'ReadOnly';
			$curVal = trim(strval($this->currency->CurrentValue));
			if ($curVal <> "")
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			else
				$this->currency->ViewValue = $this->currency->Lookup !== NULL && is_array($this->currency->Lookup->Options) ? $curVal : NULL;
			if ($this->currency->ViewValue !== NULL) { // Load from cache
				$this->currency->EditValue = array_values($this->currency->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->currency->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->currency->EditValue = $arwrk;
			}

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = 'ReadOnly';
			$this->amount->EditValue = HtmlEncode($this->amount->CurrentValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
			if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue))
				$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, -2);

			// cbm
			$this->cbm->EditAttrs["class"] = "form-control";
			$this->cbm->EditCustomAttributes = 'ReadOnly';
			$this->cbm->EditValue = HtmlEncode($this->cbm->CurrentValue);
			$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
			if (strval($this->cbm->EditValue) <> "" && is_numeric($this->cbm->EditValue))
				$this->cbm->EditValue = FormatNumber($this->cbm->EditValue, -2, -2, -2, -2);

			// buyer_size
			$this->buyer_size->EditAttrs["class"] = "form-control";
			$this->buyer_size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_size->CurrentValue = HtmlDecode($this->buyer_size->CurrentValue);
			$this->buyer_size->EditValue = HtmlEncode($this->buyer_size->CurrentValue);
			$this->buyer_size->PlaceHolder = RemoveHtml($this->buyer_size->caption());

			// description_05
			$this->description_05->EditAttrs["class"] = "form-control";
			$this->description_05->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_05->CurrentValue));
			if ($curVal <> "")
				$this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
			else
				$this->description_05->ViewValue = $this->description_05->Lookup !== NULL && is_array($this->description_05->Lookup->Options) ? $curVal : NULL;
			if ($this->description_05->ViewValue !== NULL) { // Load from cache
				$this->description_05->EditValue = array_values($this->description_05->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->description_05->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_05->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->description_05->EditValue = $arwrk;
			}

			// description_06
			$this->description_06->EditAttrs["class"] = "form-control";
			$this->description_06->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_06->CurrentValue));
			if ($curVal <> "")
				$this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
			else
				$this->description_06->ViewValue = $this->description_06->Lookup !== NULL && is_array($this->description_06->Lookup->Options) ? $curVal : NULL;
			if ($this->description_06->ViewValue !== NULL) { // Load from cache
				$this->description_06->EditValue = array_values($this->description_06->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->description_06->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_06->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->description_06->EditValue = $arwrk;
			}

			// description_08
			$this->description_08->EditAttrs["class"] = "form-control";
			$this->description_08->EditCustomAttributes = "";
			$this->description_08->EditValue = HtmlEncode($this->description_08->CurrentValue);
			$this->description_08->PlaceHolder = RemoveHtml($this->description_08->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// operator
			// datetime
			// buyer_instruction

			$this->buyer_instruction->EditAttrs["class"] = "form-control";
			$this->buyer_instruction->EditCustomAttributes = "";
			$this->buyer_instruction->EditValue = HtmlEncode($this->buyer_instruction->CurrentValue);
			$this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

			// d_09_head
			$this->d_09_head->EditAttrs["class"] = "form-control";
			$this->d_09_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_09_head->CurrentValue));
			if ($curVal <> "")
				$this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
			else
				$this->d_09_head->ViewValue = $this->d_09_head->Lookup !== NULL && is_array($this->d_09_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_09_head->ViewValue !== NULL) { // Load from cache
				$this->d_09_head->EditValue = array_values($this->d_09_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_09_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_09_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_09_head->EditValue = $arwrk;
			}

			// description_09
			$this->description_09->EditAttrs["class"] = "form-control";
			$this->description_09->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_09->CurrentValue = HtmlDecode($this->description_09->CurrentValue);
			$this->description_09->EditValue = HtmlEncode($this->description_09->CurrentValue);
			$this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

			// d_10_head
			$this->d_10_head->EditAttrs["class"] = "form-control";
			$this->d_10_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_10_head->CurrentValue));
			if ($curVal <> "")
				$this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
			else
				$this->d_10_head->ViewValue = $this->d_10_head->Lookup !== NULL && is_array($this->d_10_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_10_head->ViewValue !== NULL) { // Load from cache
				$this->d_10_head->EditValue = array_values($this->d_10_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_10_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_10_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_10_head->EditValue = $arwrk;
			}

			// description_10
			$this->description_10->EditAttrs["class"] = "form-control";
			$this->description_10->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_10->CurrentValue = HtmlDecode($this->description_10->CurrentValue);
			$this->description_10->EditValue = HtmlEncode($this->description_10->CurrentValue);
			$this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());

			// d_11_head
			$this->d_11_head->EditAttrs["class"] = "form-control";
			$this->d_11_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_11_head->CurrentValue));
			if ($curVal <> "")
				$this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
			else
				$this->d_11_head->ViewValue = $this->d_11_head->Lookup !== NULL && is_array($this->d_11_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_11_head->ViewValue !== NULL) { // Load from cache
				$this->d_11_head->EditValue = array_values($this->d_11_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_11_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_11_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_11_head->EditValue = $arwrk;
			}

			// description_11
			$this->description_11->EditAttrs["class"] = "form-control";
			$this->description_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_11->CurrentValue = HtmlDecode($this->description_11->CurrentValue);
			$this->description_11->EditValue = HtmlEncode($this->description_11->CurrentValue);
			$this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

			// d_12_head
			$this->d_12_head->EditAttrs["class"] = "form-control";
			$this->d_12_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_12_head->CurrentValue));
			if ($curVal <> "")
				$this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
			else
				$this->d_12_head->ViewValue = $this->d_12_head->Lookup !== NULL && is_array($this->d_12_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_12_head->ViewValue !== NULL) { // Load from cache
				$this->d_12_head->EditValue = array_values($this->d_12_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_12_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_12_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_12_head->EditValue = $arwrk;
			}

			// description_12
			$this->description_12->EditAttrs["class"] = "form-control";
			$this->description_12->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_12->CurrentValue = HtmlDecode($this->description_12->CurrentValue);
			$this->description_12->EditValue = HtmlEncode($this->description_12->CurrentValue);
			$this->description_12->PlaceHolder = RemoveHtml($this->description_12->caption());

			// Add refer script
			// order_type

			$this->order_type->LinkCustomAttributes = "";
			$this->order_type->HrefValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";

			// buyer_order_no
			$this->buyer_order_no->LinkCustomAttributes = "";
			$this->buyer_order_no->HrefValue = "";

			// buyer_order_date
			$this->buyer_order_date->LinkCustomAttributes = "";
			$this->buyer_order_date->HrefValue = "";

			// cart_id
			$this->cart_id->LinkCustomAttributes = "";
			$this->cart_id->HrefValue = "";

			// buyer_product_ref
			$this->buyer_product_ref->LinkCustomAttributes = "";
			$this->buyer_product_ref->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "po_clist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "po_clist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "po_clist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";

			// fob_date
			$this->fob_date->LinkCustomAttributes = "";
			$this->fob_date->HrefValue = "";

			// part_dispatch
			$this->part_dispatch->LinkCustomAttributes = "";
			$this->part_dispatch->HrefValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			$this->payment_terms->HrefValue = "";

			// transport_terms
			$this->transport_terms->LinkCustomAttributes = "";
			$this->transport_terms->HrefValue = "";

			// buyer_shipping _id
			$this->buyer_shipping__id->LinkCustomAttributes = "";
			$this->buyer_shipping__id->HrefValue = "";

			// description_04
			$this->description_04->LinkCustomAttributes = "";
			$this->description_04->HrefValue = "";

			// description_03
			$this->description_03->LinkCustomAttributes = "";
			$this->description_03->HrefValue = "";

			// description_01
			$this->description_01->LinkCustomAttributes = "";
			$this->description_01->HrefValue = "";

			// description_02
			$this->description_02->LinkCustomAttributes = "";
			$this->description_02->HrefValue = "";

			// description_07
			$this->description_07->LinkCustomAttributes = "";
			$this->description_07->HrefValue = "";

			// description_20
			$this->description_20->LinkCustomAttributes = "";
			$this->description_20->HrefValue = "";

			// description_17
			$this->description_17->LinkCustomAttributes = "";
			$this->description_17->HrefValue = "";

			// description_18
			$this->description_18->LinkCustomAttributes = "";
			$this->description_18->HrefValue = "";

			// description_19
			$this->description_19->LinkCustomAttributes = "";
			$this->description_19->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";

			// buyer_size
			$this->buyer_size->LinkCustomAttributes = "";
			$this->buyer_size->HrefValue = "";

			// description_05
			$this->description_05->LinkCustomAttributes = "";
			$this->description_05->HrefValue = "";

			// description_06
			$this->description_06->LinkCustomAttributes = "";
			$this->description_06->HrefValue = "";

			// description_08
			$this->description_08->LinkCustomAttributes = "";
			$this->description_08->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// buyer_instruction
			$this->buyer_instruction->LinkCustomAttributes = "";
			$this->buyer_instruction->HrefValue = "";

			// d_09_head
			$this->d_09_head->LinkCustomAttributes = "";
			$this->d_09_head->HrefValue = "";

			// description_09
			$this->description_09->LinkCustomAttributes = "";
			$this->description_09->HrefValue = "";

			// d_10_head
			$this->d_10_head->LinkCustomAttributes = "";
			$this->d_10_head->HrefValue = "";

			// description_10
			$this->description_10->LinkCustomAttributes = "";
			$this->description_10->HrefValue = "";

			// d_11_head
			$this->d_11_head->LinkCustomAttributes = "";
			$this->d_11_head->HrefValue = "";

			// description_11
			$this->description_11->LinkCustomAttributes = "";
			$this->description_11->HrefValue = "";

			// d_12_head
			$this->d_12_head->LinkCustomAttributes = "";
			$this->d_12_head->HrefValue = "";

			// description_12
			$this->description_12->LinkCustomAttributes = "";
			$this->description_12->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->order_type->Required) {
			if ($this->order_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->order_type->caption(), $this->order_type->RequiredErrorMessage));
			}
		}
		if ($this->buyer_id->Required) {
			if (!$this->buyer_id->IsDetailKey && $this->buyer_id->FormValue != NULL && $this->buyer_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
			}
		}
		if ($this->buyer_order_no->Required) {
			if (!$this->buyer_order_no->IsDetailKey && $this->buyer_order_no->FormValue != NULL && $this->buyer_order_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_order_no->caption(), $this->buyer_order_no->RequiredErrorMessage));
			}
		}
		if ($this->buyer_order_date->Required) {
			if (!$this->buyer_order_date->IsDetailKey && $this->buyer_order_date->FormValue != NULL && $this->buyer_order_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_order_date->caption(), $this->buyer_order_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->buyer_order_date->FormValue)) {
			AddMessage($FormError, $this->buyer_order_date->errorMessage());
		}
		if ($this->cart_id->Required) {
			if ($this->cart_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cart_id->caption(), $this->cart_id->RequiredErrorMessage));
			}
		}
		if ($this->buyer_product_ref->Required) {
			if (!$this->buyer_product_ref->IsDetailKey && $this->buyer_product_ref->FormValue != NULL && $this->buyer_product_ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_product_ref->caption(), $this->buyer_product_ref->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->rid->Required) {
			if ($this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if ($this->despatch_date->Required) {
			if (!$this->despatch_date->IsDetailKey && $this->despatch_date->FormValue != NULL && $this->despatch_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->despatch_date->FormValue)) {
			AddMessage($FormError, $this->despatch_date->errorMessage());
		}
		if ($this->despatch_week->Required) {
			if (!$this->despatch_week->IsDetailKey && $this->despatch_week->FormValue != NULL && $this->despatch_week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
			}
		}
		if ($this->fob_date->Required) {
			if (!$this->fob_date->IsDetailKey && $this->fob_date->FormValue != NULL && $this->fob_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fob_date->caption(), $this->fob_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->fob_date->FormValue)) {
			AddMessage($FormError, $this->fob_date->errorMessage());
		}
		if ($this->part_dispatch->Required) {
			if (!$this->part_dispatch->IsDetailKey && $this->part_dispatch->FormValue != NULL && $this->part_dispatch->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->part_dispatch->caption(), $this->part_dispatch->RequiredErrorMessage));
			}
		}
		if ($this->payment_terms->Required) {
			if (!$this->payment_terms->IsDetailKey && $this->payment_terms->FormValue != NULL && $this->payment_terms->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment_terms->caption(), $this->payment_terms->RequiredErrorMessage));
			}
		}
		if ($this->transport_terms->Required) {
			if (!$this->transport_terms->IsDetailKey && $this->transport_terms->FormValue != NULL && $this->transport_terms->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->transport_terms->caption(), $this->transport_terms->RequiredErrorMessage));
			}
		}
		if ($this->buyer_shipping__id->Required) {
			if (!$this->buyer_shipping__id->IsDetailKey && $this->buyer_shipping__id->FormValue != NULL && $this->buyer_shipping__id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_shipping__id->caption(), $this->buyer_shipping__id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->buyer_shipping__id->FormValue)) {
			AddMessage($FormError, $this->buyer_shipping__id->errorMessage());
		}
		if ($this->description_04->Required) {
			if (!$this->description_04->IsDetailKey && $this->description_04->FormValue != NULL && $this->description_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_04->caption(), $this->description_04->RequiredErrorMessage));
			}
		}
		if ($this->description_03->Required) {
			if (!$this->description_03->IsDetailKey && $this->description_03->FormValue != NULL && $this->description_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_03->caption(), $this->description_03->RequiredErrorMessage));
			}
		}
		if ($this->description_01->Required) {
			if (!$this->description_01->IsDetailKey && $this->description_01->FormValue != NULL && $this->description_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_01->caption(), $this->description_01->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->description_01->FormValue)) {
			AddMessage($FormError, $this->description_01->errorMessage());
		}
		if ($this->description_02->Required) {
			if (!$this->description_02->IsDetailKey && $this->description_02->FormValue != NULL && $this->description_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_02->caption(), $this->description_02->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->description_02->FormValue)) {
			AddMessage($FormError, $this->description_02->errorMessage());
		}
		if ($this->description_07->Required) {
			if (!$this->description_07->IsDetailKey && $this->description_07->FormValue != NULL && $this->description_07->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_07->caption(), $this->description_07->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->description_07->FormValue)) {
			AddMessage($FormError, $this->description_07->errorMessage());
		}
		if ($this->description_20->Required) {
			if (!$this->description_20->IsDetailKey && $this->description_20->FormValue != NULL && $this->description_20->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_20->caption(), $this->description_20->RequiredErrorMessage));
			}
		}
		if ($this->description_17->Required) {
			if (!$this->description_17->IsDetailKey && $this->description_17->FormValue != NULL && $this->description_17->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_17->caption(), $this->description_17->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->description_17->FormValue)) {
			AddMessage($FormError, $this->description_17->errorMessage());
		}
		if ($this->description_18->Required) {
			if (!$this->description_18->IsDetailKey && $this->description_18->FormValue != NULL && $this->description_18->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_18->caption(), $this->description_18->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->description_18->FormValue)) {
			AddMessage($FormError, $this->description_18->errorMessage());
		}
		if ($this->description_19->Required) {
			if (!$this->description_19->IsDetailKey && $this->description_19->FormValue != NULL && $this->description_19->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_19->caption(), $this->description_19->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->description_19->FormValue)) {
			AddMessage($FormError, $this->description_19->errorMessage());
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if ($this->price->Required) {
			if (!$this->price->IsDetailKey && $this->price->FormValue != NULL && $this->price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
			}
		}
		if ($this->currency->Required) {
			if (!$this->currency->IsDetailKey && $this->currency->FormValue != NULL && $this->currency->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
			}
		}
		if ($this->amount->Required) {
			if (!$this->amount->IsDetailKey && $this->amount->FormValue != NULL && $this->amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->amount->FormValue)) {
			AddMessage($FormError, $this->amount->errorMessage());
		}
		if ($this->cbm->Required) {
			if (!$this->cbm->IsDetailKey && $this->cbm->FormValue != NULL && $this->cbm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->cbm->FormValue)) {
			AddMessage($FormError, $this->cbm->errorMessage());
		}
		if ($this->buyer_size->Required) {
			if (!$this->buyer_size->IsDetailKey && $this->buyer_size->FormValue != NULL && $this->buyer_size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_size->caption(), $this->buyer_size->RequiredErrorMessage));
			}
		}
		if ($this->description_05->Required) {
			if (!$this->description_05->IsDetailKey && $this->description_05->FormValue != NULL && $this->description_05->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_05->caption(), $this->description_05->RequiredErrorMessage));
			}
		}
		if ($this->description_06->Required) {
			if (!$this->description_06->IsDetailKey && $this->description_06->FormValue != NULL && $this->description_06->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_06->caption(), $this->description_06->RequiredErrorMessage));
			}
		}
		if ($this->description_08->Required) {
			if (!$this->description_08->IsDetailKey && $this->description_08->FormValue != NULL && $this->description_08->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_08->caption(), $this->description_08->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->description_08->FormValue)) {
			AddMessage($FormError, $this->description_08->errorMessage());
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->a_operator->Required) {
			if (!$this->a_operator->IsDetailKey && $this->a_operator->FormValue != NULL && $this->a_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_operator->caption(), $this->a_operator->RequiredErrorMessage));
			}
		}
		if ($this->a_datetime->Required) {
			if (!$this->a_datetime->IsDetailKey && $this->a_datetime->FormValue != NULL && $this->a_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_datetime->caption(), $this->a_datetime->RequiredErrorMessage));
			}
		}
		if ($this->jc_no->Required) {
			if (!$this->jc_no->IsDetailKey && $this->jc_no->FormValue != NULL && $this->jc_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
			}
		}
		if ($this->buyer_instruction->Required) {
			if (!$this->buyer_instruction->IsDetailKey && $this->buyer_instruction->FormValue != NULL && $this->buyer_instruction->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_instruction->caption(), $this->buyer_instruction->RequiredErrorMessage));
			}
		}
		if ($this->d_09_head->Required) {
			if (!$this->d_09_head->IsDetailKey && $this->d_09_head->FormValue != NULL && $this->d_09_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_09_head->caption(), $this->d_09_head->RequiredErrorMessage));
			}
		}
		if ($this->description_09->Required) {
			if (!$this->description_09->IsDetailKey && $this->description_09->FormValue != NULL && $this->description_09->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_09->caption(), $this->description_09->RequiredErrorMessage));
			}
		}
		if ($this->d_10_head->Required) {
			if (!$this->d_10_head->IsDetailKey && $this->d_10_head->FormValue != NULL && $this->d_10_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_10_head->caption(), $this->d_10_head->RequiredErrorMessage));
			}
		}
		if ($this->description_10->Required) {
			if (!$this->description_10->IsDetailKey && $this->description_10->FormValue != NULL && $this->description_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_10->caption(), $this->description_10->RequiredErrorMessage));
			}
		}
		if ($this->d_11_head->Required) {
			if (!$this->d_11_head->IsDetailKey && $this->d_11_head->FormValue != NULL && $this->d_11_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_11_head->caption(), $this->d_11_head->RequiredErrorMessage));
			}
		}
		if ($this->description_11->Required) {
			if (!$this->description_11->IsDetailKey && $this->description_11->FormValue != NULL && $this->description_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_11->caption(), $this->description_11->RequiredErrorMessage));
			}
		}
		if ($this->d_12_head->Required) {
			if (!$this->d_12_head->IsDetailKey && $this->d_12_head->FormValue != NULL && $this->d_12_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_12_head->caption(), $this->d_12_head->RequiredErrorMessage));
			}
		}
		if ($this->description_12->Required) {
			if (!$this->description_12->IsDetailKey && $this->description_12->FormValue != NULL && $this->description_12->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_12->caption(), $this->description_12->RequiredErrorMessage));
			}
		}
		if ($this->po->Required) {
			if (!$this->po->IsDetailKey && $this->po->FormValue != NULL && $this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if ($this->production_site->Required) {
			if (!$this->production_site->IsDetailKey && $this->production_site->FormValue != NULL && $this->production_site->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_site->caption(), $this->production_site->RequiredErrorMessage));
			}
		}
		if ($this->c_total->Required) {
			if (!$this->c_total->IsDetailKey && $this->c_total->FormValue != NULL && $this->c_total->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->c_total->caption(), $this->c_total->RequiredErrorMessage));
			}
		}
		if ($this->production_plan->Required) {
			if (!$this->production_plan->IsDetailKey && $this->production_plan->FormValue != NULL && $this->production_plan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_plan->caption(), $this->production_plan->RequiredErrorMessage));
			}
		}
		if ($this->lot_no->Required) {
			if (!$this->lot_no->IsDetailKey && $this->lot_no->FormValue != NULL && $this->lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
			}
		}
		if ($this->product_gcode->Required) {
			if (!$this->product_gcode->IsDetailKey && $this->product_gcode->FormValue != NULL && $this->product_gcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_gcode->caption(), $this->product_gcode->RequiredErrorMessage));
			}
		}
		if ($this->batch_no->Required) {
			if (!$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if ($this->uploads->Required) {
			if (!$this->uploads->IsDetailKey && $this->uploads->FormValue != NULL && $this->uploads->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
			}
		}
		if ($this->d_01_head->Required) {
			if (!$this->d_01_head->IsDetailKey && $this->d_01_head->FormValue != NULL && $this->d_01_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_01_head->caption(), $this->d_01_head->RequiredErrorMessage));
			}
		}
		if ($this->d_02_head->Required) {
			if (!$this->d_02_head->IsDetailKey && $this->d_02_head->FormValue != NULL && $this->d_02_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_02_head->caption(), $this->d_02_head->RequiredErrorMessage));
			}
		}
		if ($this->d_03_head->Required) {
			if (!$this->d_03_head->IsDetailKey && $this->d_03_head->FormValue != NULL && $this->d_03_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_03_head->caption(), $this->d_03_head->RequiredErrorMessage));
			}
		}
		if ($this->d_04_head->Required) {
			if (!$this->d_04_head->IsDetailKey && $this->d_04_head->FormValue != NULL && $this->d_04_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_04_head->caption(), $this->d_04_head->RequiredErrorMessage));
			}
		}
		if ($this->d_05_head->Required) {
			if (!$this->d_05_head->IsDetailKey && $this->d_05_head->FormValue != NULL && $this->d_05_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_05_head->caption(), $this->d_05_head->RequiredErrorMessage));
			}
		}
		if ($this->d_06_head->Required) {
			if (!$this->d_06_head->IsDetailKey && $this->d_06_head->FormValue != NULL && $this->d_06_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_06_head->caption(), $this->d_06_head->RequiredErrorMessage));
			}
		}
		if ($this->d_07_head->Required) {
			if (!$this->d_07_head->IsDetailKey && $this->d_07_head->FormValue != NULL && $this->d_07_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_07_head->caption(), $this->d_07_head->RequiredErrorMessage));
			}
		}
		if ($this->d_08_head->Required) {
			if (!$this->d_08_head->IsDetailKey && $this->d_08_head->FormValue != NULL && $this->d_08_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_08_head->caption(), $this->d_08_head->RequiredErrorMessage));
			}
		}
		if ($this->sample->Required) {
			if (!$this->sample->IsDetailKey && $this->sample->FormValue != NULL && $this->sample->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sample->caption(), $this->sample->RequiredErrorMessage));
			}
		}
		if ($this->balance_quantity->Required) {
			if (!$this->balance_quantity->IsDetailKey && $this->balance_quantity->FormValue != NULL && $this->balance_quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->balance_quantity->caption(), $this->balance_quantity->RequiredErrorMessage));
			}
		}
		if ($this->_action->Required) {
			if (!$this->_action->IsDetailKey && $this->_action->FormValue != NULL && $this->_action->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_action->caption(), $this->_action->RequiredErrorMessage));
			}
		}
		if ($this->url->Required) {
			if (!$this->url->IsDetailKey && $this->url->FormValue != NULL && $this->url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->url->caption(), $this->url->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// order_type
		$this->order_type->setDbValueDef($rsnew, $this->order_type->CurrentValue, 0, FALSE);

		// buyer_id
		$this->buyer_id->setDbValueDef($rsnew, $this->buyer_id->CurrentValue, 0, FALSE);

		// buyer_order_no
		$this->buyer_order_no->setDbValueDef($rsnew, $this->buyer_order_no->CurrentValue, NULL, FALSE);

		// buyer_order_date
		$this->buyer_order_date->setDbValueDef($rsnew, UnFormatDateTime($this->buyer_order_date->CurrentValue, 0), NULL, FALSE);

		// cart_id
		$this->cart_id->setDbValueDef($rsnew, $this->cart_id->CurrentValue, NULL, FALSE);

		// buyer_product_ref
		$this->buyer_product_ref->setDbValueDef($rsnew, $this->buyer_product_ref->CurrentValue, NULL, FALSE);

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, 0, strval($this->grp->CurrentValue) == "");

		// s_grp
		$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, 0, strval($this->s_grp->CurrentValue) == "");

		// product
		$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, NULL, FALSE);

		// rid
		$this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, NULL, FALSE);

		// despatch_date
		$this->despatch_date->setDbValueDef($rsnew, UnFormatDateTime($this->despatch_date->CurrentValue, 0), CurrentDate(), FALSE);

		// despatch_week
		$this->despatch_week->setDbValueDef($rsnew, $this->despatch_week->CurrentValue, NULL, FALSE);

		// fob_date
		$this->fob_date->setDbValueDef($rsnew, UnFormatDateTime($this->fob_date->CurrentValue, 0), CurrentDate(), FALSE);

		// part_dispatch
		$this->part_dispatch->setDbValueDef($rsnew, $this->part_dispatch->CurrentValue, 0, FALSE);

		// payment_terms
		$this->payment_terms->setDbValueDef($rsnew, $this->payment_terms->CurrentValue, "", FALSE);

		// transport_terms
		$this->transport_terms->setDbValueDef($rsnew, $this->transport_terms->CurrentValue, "", FALSE);

		// buyer_shipping _id
		$this->buyer_shipping__id->setDbValueDef($rsnew, $this->buyer_shipping__id->CurrentValue, 0, FALSE);

		// description_04
		$this->description_04->setDbValueDef($rsnew, $this->description_04->CurrentValue, NULL, FALSE);

		// description_03
		$this->description_03->setDbValueDef($rsnew, $this->description_03->CurrentValue, NULL, FALSE);

		// description_01
		$this->description_01->setDbValueDef($rsnew, $this->description_01->CurrentValue, NULL, FALSE);

		// description_02
		$this->description_02->setDbValueDef($rsnew, $this->description_02->CurrentValue, NULL, FALSE);

		// description_07
		$this->description_07->setDbValueDef($rsnew, $this->description_07->CurrentValue, NULL, FALSE);

		// description_20
		$this->description_20->setDbValueDef($rsnew, $this->description_20->CurrentValue, 0, FALSE);

		// description_17
		$this->description_17->setDbValueDef($rsnew, $this->description_17->CurrentValue, 0, FALSE);

		// description_18
		$this->description_18->setDbValueDef($rsnew, $this->description_18->CurrentValue, 0, FALSE);

		// description_19
		$this->description_19->setDbValueDef($rsnew, $this->description_19->CurrentValue, 0, FALSE);

		// quantity
		$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, NULL, FALSE);

		// price
		$this->price->setDbValueDef($rsnew, $this->price->CurrentValue, NULL, FALSE);

		// currency
		$this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, 0, FALSE);

		// amount
		$this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, 0, FALSE);

		// cbm
		$this->cbm->setDbValueDef($rsnew, $this->cbm->CurrentValue, 0, FALSE);

		// buyer_size
		$this->buyer_size->setDbValueDef($rsnew, $this->buyer_size->CurrentValue, "", FALSE);

		// description_05
		$this->description_05->setDbValueDef($rsnew, $this->description_05->CurrentValue, NULL, FALSE);

		// description_06
		$this->description_06->setDbValueDef($rsnew, $this->description_06->CurrentValue, NULL, FALSE);

		// description_08
		$this->description_08->setDbValueDef($rsnew, $this->description_08->CurrentValue, NULL, FALSE);

		// remarks
		$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// buyer_instruction
		$this->buyer_instruction->setDbValueDef($rsnew, $this->buyer_instruction->CurrentValue, NULL, FALSE);

		// d_09_head
		$this->d_09_head->setDbValueDef($rsnew, $this->d_09_head->CurrentValue, NULL, FALSE);

		// description_09
		$this->description_09->setDbValueDef($rsnew, $this->description_09->CurrentValue, NULL, FALSE);

		// d_10_head
		$this->d_10_head->setDbValueDef($rsnew, $this->d_10_head->CurrentValue, NULL, FALSE);

		// description_10
		$this->description_10->setDbValueDef($rsnew, $this->description_10->CurrentValue, NULL, FALSE);

		// d_11_head
		$this->d_11_head->setDbValueDef($rsnew, $this->d_11_head->CurrentValue, NULL, FALSE);

		// description_11
		$this->description_11->setDbValueDef($rsnew, $this->description_11->CurrentValue, NULL, FALSE);

		// d_12_head
		$this->d_12_head->setDbValueDef($rsnew, $this->d_12_head->CurrentValue, NULL, FALSE);

		// description_12
		$this->description_12->setDbValueDef($rsnew, $this->description_12->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("polist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_buyer_id":
					$lookupFilter = function() {
						return "`id` > 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_cart_id":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` = NULL || `po_id` = '' || `po_id` = '0'" : "`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue;
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1 ";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`status`=1 and `product_type`=0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_payment_terms":
					$lookupFilter = function() {
						return "`grp` = 81";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_05":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_06":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_production_site":
					$lookupFilter = function() {
						return "`grp` IN (0,3)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyer_id":
							break;
						case "x_cart_id":
							$row[2] = FormatNumber($row[2], 2, -2, -2, 0);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, 0);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, 0);
							$row['df4'] = $row[4];
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_despatch_week":
							break;
						case "x_payment_terms":
							break;
						case "x_currency":
							break;
						case "x_description_05":
							break;
						case "x_description_06":
							break;
						case "x_operator":
							break;
						case "x_a_operator":
							break;
						case "x_d_09_head":
							break;
						case "x_d_10_head":
							break;
						case "x_d_11_head":
							break;
						case "x_d_12_head":
							break;
						case "x_production_site":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'po');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>