<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for po_b
 */
class po_b extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $location;
	public $grp;
	public $po;
	public $company_id;
	public $partner_id;
	public $s_grp;
	public $cart_id;
	public $quantity;
	public $sqm;
	public $amount;
	public $cbm;
	public $gst;
	public $partner_order_no;
	public $partner_order_date;
	public $despatch_date;
	public $despatch_week;
	public $fob_date;
	public $production_plan;
	public $part_dispatch;
	public $payment_terms;
	public $transport_type;
	public $partner_shipping_id;
	public $remarks;
	public $buyer_instruction;
	public $uploads;
	public $description_01;
	public $description_02;
	public $description_03;
	public $description_04;
	public $description_05;
	public $description_06;
	public $description_07;
	public $description_08;
	public $description_17;
	public $description_18;
	public $description_19;
	public $description_20;
	public $d_09_head;
	public $description_09;
	public $d_10_head;
	public $description_10;
	public $d_11_head;
	public $description_11;
	public $d_12_head;
	public $description_12;
	public $production_site;
	public $jc_no;
	public $__request;
	public $balance_quantity;
	public $e_mail;
	public $billing_address_id;
	public $shipping_address_id;
	public $status;
	public $operator;
	public $datetime;
	public $a_operator;
	public $a_datetime;
	public $c_operator;
	public $c_datetime;
	public $app_operator;
	public $app_datetime;
	public $reports_to;
	public $grp_type;
	public $order_file;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'po_b';
		$this->TableName = 'po_b';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`po_b`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('po_b', 'po_b', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->IsForeignKey = TRUE; // Foreign key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// location
		$this->location = new DbField('po_b', 'po_b', 'x_location', 'location', '`location`', '`location`', 2, -1, FALSE, '`location`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->location->Required = TRUE; // Required field
		$this->location->Sortable = FALSE; // Allow sort
		$this->location->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->location->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->location->Lookup = new Lookup('location', 'godown', TRUE, 'id', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->location->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['location'] = &$this->location;

		// grp
		$this->grp = new DbField('po_b', 'po_b', 'x_grp', 'grp', '`grp`', '`grp`', 200, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Sortable = FALSE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_s_grp[]","x_cart_id[]"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// po
		$this->po = new DbField('po_b', 'po_b', 'x_po', 'po', '`po`', '`po`', 18, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Nullable = FALSE; // NOT NULL field
		$this->po->Required = TRUE; // Required field
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// company_id
		$this->company_id = new DbField('po_b', 'po_b', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 19, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->company_id->Required = TRUE; // Required field
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->company_id->Lookup = new Lookup('company_id', 'buyer_seller_view', TRUE, 'id', ["name","","",""], [], ["x_cart_id[]","x_partner_shipping_id"], [], [], [], [], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// partner_id
		$this->partner_id = new DbField('po_b', 'po_b', 'x_partner_id', 'partner_id', '`partner_id`', '`partner_id`', 19, -1, FALSE, '`EV__partner_id`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_id->Required = TRUE; // Required field
		$this->partner_id->Sortable = TRUE; // Allow sort
		$this->partner_id->Lookup = new Lookup('partner_id', 'buyer_seller_view', TRUE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->partner_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['partner_id'] = &$this->partner_id;

		// s_grp
		$this->s_grp = new DbField('po_b', 'po_b', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 200, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Sortable = FALSE; // Allow sort
		$this->s_grp->SelectMultiple = TRUE; // Multiple select
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], [], ["grp"], ["x_grp"], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// cart_id
		$this->cart_id = new DbField('po_b', 'po_b', 'x_cart_id', 'cart_id', '`cart_id`', '`cart_id`', 201, -1, FALSE, '`cart_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->cart_id->Sortable = TRUE; // Allow sort
		$this->cart_id->Lookup = new Lookup('cart_id', 'product_cart_b', FALSE, 'id', ["rid_1","partner_size","quantity","price"], ["x_company_id","x_grp"], [], ["company_id","grp"], ["x_company_id","x_grp"], [], [], '`id` ASC', '<span class="text-info">Product : {{:df1}}, Size : {{:df2}}, Qty : {{:df3}}, Price : {{:df4}}</span>');
		$this->fields['cart_id'] = &$this->cart_id;

		// quantity
		$this->quantity = new DbField('po_b', 'po_b', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 18, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->fields['quantity'] = &$this->quantity;

		// sqm
		$this->sqm = new DbField('po_b', 'po_b', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 4, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Nullable = FALSE; // NOT NULL field
		$this->sqm->Required = TRUE; // Required field
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// amount
		$this->amount = new DbField('po_b', 'po_b', 'x_amount', 'amount', '`amount`', '`amount`', 200, -1, FALSE, '`amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount->Nullable = FALSE; // NOT NULL field
		$this->amount->Required = TRUE; // Required field
		$this->amount->Sortable = TRUE; // Allow sort
		$this->fields['amount'] = &$this->amount;

		// cbm
		$this->cbm = new DbField('po_b', 'po_b', 'x_cbm', 'cbm', '`cbm`', '`cbm`', 4, -1, FALSE, '`cbm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cbm->Nullable = FALSE; // NOT NULL field
		$this->cbm->Required = TRUE; // Required field
		$this->cbm->Sortable = TRUE; // Allow sort
		$this->cbm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cbm'] = &$this->cbm;

		// gst
		$this->gst = new DbField('po_b', 'po_b', 'x_gst', 'gst', '`gst`', '`gst`', 18, -1, FALSE, '`gst`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->gst->Nullable = FALSE; // NOT NULL field
		$this->gst->Required = TRUE; // Required field
		$this->gst->Sortable = TRUE; // Allow sort
		$this->gst->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->gst->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->gst->Lookup = new Lookup('gst', 'tax_category', FALSE, 'id', ["item","tax_percent","hsn_code",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->gst->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['gst'] = &$this->gst;

		// partner_order_no
		$this->partner_order_no = new DbField('po_b', 'po_b', 'x_partner_order_no', 'partner_order_no', '`partner_order_no`', '`partner_order_no`', 200, -1, FALSE, '`partner_order_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_order_no->Sortable = FALSE; // Allow sort
		$this->fields['partner_order_no'] = &$this->partner_order_no;

		// partner_order_date
		$this->partner_order_date = new DbField('po_b', 'po_b', 'x_partner_order_date', 'partner_order_date', '`partner_order_date`', CastDateFieldForLike('`partner_order_date`', 0, "DB"), 133, 0, FALSE, '`partner_order_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_order_date->Sortable = FALSE; // Allow sort
		$this->partner_order_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['partner_order_date'] = &$this->partner_order_date;

		// despatch_date
		$this->despatch_date = new DbField('po_b', 'po_b', 'x_despatch_date', 'despatch_date', '`despatch_date`', CastDateFieldForLike('`despatch_date`', 0, "DB"), 133, 0, FALSE, '`despatch_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->despatch_date->Sortable = TRUE; // Allow sort
		$this->despatch_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['despatch_date'] = &$this->despatch_date;

		// despatch_week
		$this->despatch_week = new DbField('po_b', 'po_b', 'x_despatch_week', 'despatch_week', '`despatch_week`', '`despatch_week`', 18, 7, FALSE, '`despatch_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->despatch_week->Required = TRUE; // Required field
		$this->despatch_week->Sortable = TRUE; // Allow sort
		$this->despatch_week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->despatch_week->Lookup = new Lookup('despatch_week', 'not_week', FALSE, 'id', ["wid","wed","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->despatch_week->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['despatch_week'] = &$this->despatch_week;

		// fob_date
		$this->fob_date = new DbField('po_b', 'po_b', 'x_fob_date', 'fob_date', '`fob_date`', CastDateFieldForLike('`fob_date`', 0, "DB"), 133, 0, FALSE, '`fob_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fob_date->Sortable = TRUE; // Allow sort
		$this->fob_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['fob_date'] = &$this->fob_date;

		// production_plan
		$this->production_plan = new DbField('po_b', 'po_b', 'x_production_plan', 'production_plan', '`production_plan`', '`production_plan`', 18, -1, FALSE, '`production_plan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->production_plan->Required = TRUE; // Required field
		$this->production_plan->Sortable = TRUE; // Allow sort
		$this->production_plan->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->production_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->production_plan->Lookup = new Lookup('production_plan', 'production_plan_head', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->production_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['production_plan'] = &$this->production_plan;

		// part_dispatch
		$this->part_dispatch = new DbField('po_b', 'po_b', 'x_part_dispatch', 'part_dispatch', '`part_dispatch`', '`part_dispatch`', 18, -1, FALSE, '`part_dispatch`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->part_dispatch->Sortable = TRUE; // Allow sort
		$this->part_dispatch->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->part_dispatch->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->part_dispatch->Lookup = new Lookup('part_dispatch', 'po_b', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->part_dispatch->OptionCount = 2;
		$this->part_dispatch->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['part_dispatch'] = &$this->part_dispatch;

		// payment_terms
		$this->payment_terms = new DbField('po_b', 'po_b', 'x_payment_terms', 'payment_terms', '`payment_terms`', '`payment_terms`', 200, -1, FALSE, '`payment_terms`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->payment_terms->Sortable = TRUE; // Allow sort
		$this->payment_terms->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->payment_terms->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->payment_terms->Lookup = new Lookup('payment_terms', 'misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['payment_terms'] = &$this->payment_terms;

		// transport_type
		$this->transport_type = new DbField('po_b', 'po_b', 'x_transport_type', 'transport_type', '`transport_type`', '`transport_type`', 200, -1, FALSE, '`transport_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->transport_type->Sortable = TRUE; // Allow sort
		$this->transport_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->transport_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->transport_type->Lookup = new Lookup('transport_type', 'misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['transport_type'] = &$this->transport_type;

		// partner_shipping_id
		$this->partner_shipping_id = new DbField('po_b', 'po_b', 'x_partner_shipping_id', 'partner_shipping_id', '`partner_shipping_id`', '`partner_shipping_id`', 2, -1, FALSE, '`partner_shipping_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->partner_shipping_id->Sortable = TRUE; // Allow sort
		$this->partner_shipping_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->partner_shipping_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->partner_shipping_id->Lookup = new Lookup('partner_shipping_id', 'shipping_address', FALSE, 'id', ["name","address","city_name","gst_number"], ["x_company_id"], [], ["userid"], ["x__userid"], [], [], '`name` ASC', '');
		$this->partner_shipping_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['partner_shipping_id'] = &$this->partner_shipping_id;

		// remarks
		$this->remarks = new DbField('po_b', 'po_b', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 201, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// buyer_instruction
		$this->buyer_instruction = new DbField('po_b', 'po_b', 'x_buyer_instruction', 'buyer_instruction', '`buyer_instruction`', '`buyer_instruction`', 201, -1, FALSE, '`buyer_instruction`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->buyer_instruction->Sortable = TRUE; // Allow sort
		$this->fields['buyer_instruction'] = &$this->buyer_instruction;

		// uploads
		$this->uploads = new DbField('po_b', 'po_b', 'x_uploads', 'uploads', '`uploads`', '`uploads`', 201, -1, TRUE, '`uploads`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->uploads->Sortable = FALSE; // Allow sort
		$this->uploads->UploadMultiple = TRUE;
		$this->uploads->Upload->UploadMultiple = TRUE;
		$this->uploads->UploadMaxFileCount = 0;
		$this->fields['uploads'] = &$this->uploads;

		// description_01
		$this->description_01 = new DbField('po_b', 'po_b', 'x_description_01', 'description_01', '`description_01`', '`description_01`', 4, -1, FALSE, '`description_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_01->Required = TRUE; // Required field
		$this->description_01->Sortable = FALSE; // Allow sort
		$this->description_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_01'] = &$this->description_01;

		// description_02
		$this->description_02 = new DbField('po_b', 'po_b', 'x_description_02', 'description_02', '`description_02`', '`description_02`', 4, -1, FALSE, '`description_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_02->Required = TRUE; // Required field
		$this->description_02->Sortable = FALSE; // Allow sort
		$this->description_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_02'] = &$this->description_02;

		// description_03
		$this->description_03 = new DbField('po_b', 'po_b', 'x_description_03', 'description_03', '`description_03`', '`description_03`', 4, -1, FALSE, '`description_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->description_03->Required = TRUE; // Required field
		$this->description_03->Sortable = FALSE; // Allow sort
		$this->description_03->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->description_03->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->description_03->Lookup = new Lookup('description_03', 'po_b', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->description_03->OptionCount = 4;
		$this->description_03->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['description_03'] = &$this->description_03;

		// description_04
		$this->description_04 = new DbField('po_b', 'po_b', 'x_description_04', 'description_04', '`description_04`', '`description_04`', 4, -1, FALSE, '`description_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->description_04->Required = TRUE; // Required field
		$this->description_04->Sortable = FALSE; // Allow sort
		$this->description_04->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->description_04->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->description_04->Lookup = new Lookup('description_04', 'd_04', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '', '');
		$this->description_04->OptionCount = 3;
		$this->description_04->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['description_04'] = &$this->description_04;

		// description_05
		$this->description_05 = new DbField('po_b', 'po_b', 'x_description_05', 'description_05', '`description_05`', '`description_05`', 18, -1, FALSE, '`description_05`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->description_05->Sortable = FALSE; // Allow sort
		$this->description_05->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->description_05->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->description_05->Lookup = new Lookup('description_05', 'd_05', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['description_05'] = &$this->description_05;

		// description_06
		$this->description_06 = new DbField('po_b', 'po_b', 'x_description_06', 'description_06', '`description_06`', '`description_06`', 18, -1, FALSE, '`description_06`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->description_06->Sortable = FALSE; // Allow sort
		$this->description_06->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->description_06->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->description_06->Lookup = new Lookup('description_06', 'd_06', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['description_06'] = &$this->description_06;

		// description_07
		$this->description_07 = new DbField('po_b', 'po_b', 'x_description_07', 'description_07', '`description_07`', '`description_07`', 18, -1, FALSE, '`description_07`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_07->Sortable = FALSE; // Allow sort
		$this->description_07->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_07'] = &$this->description_07;

		// description_08
		$this->description_08 = new DbField('po_b', 'po_b', 'x_description_08', 'description_08', '`description_08`', '`description_08`', 18, -1, FALSE, '`description_08`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_08->Required = TRUE; // Required field
		$this->description_08->Sortable = FALSE; // Allow sort
		$this->description_08->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_08'] = &$this->description_08;

		// description_17
		$this->description_17 = new DbField('po_b', 'po_b', 'x_description_17', 'description_17', '`description_17`', '`description_17`', 4, -1, FALSE, '`description_17`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_17->Nullable = FALSE; // NOT NULL field
		$this->description_17->Required = TRUE; // Required field
		$this->description_17->Sortable = FALSE; // Allow sort
		$this->description_17->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_17'] = &$this->description_17;

		// description_18
		$this->description_18 = new DbField('po_b', 'po_b', 'x_description_18', 'description_18', '`description_18`', '`description_18`', 4, -1, FALSE, '`description_18`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_18->Nullable = FALSE; // NOT NULL field
		$this->description_18->Required = TRUE; // Required field
		$this->description_18->Sortable = FALSE; // Allow sort
		$this->description_18->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_18'] = &$this->description_18;

		// description_19
		$this->description_19 = new DbField('po_b', 'po_b', 'x_description_19', 'description_19', '`description_19`', '`description_19`', 4, -1, FALSE, '`description_19`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_19->Nullable = FALSE; // NOT NULL field
		$this->description_19->Required = TRUE; // Required field
		$this->description_19->Sortable = FALSE; // Allow sort
		$this->description_19->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_19'] = &$this->description_19;

		// description_20
		$this->description_20 = new DbField('po_b', 'po_b', 'x_description_20', 'description_20', '`description_20`', '`description_20`', 18, -1, FALSE, '`description_20`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->description_20->Nullable = FALSE; // NOT NULL field
		$this->description_20->Required = TRUE; // Required field
		$this->description_20->Sortable = FALSE; // Allow sort
		$this->description_20->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->description_20->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->description_20->Lookup = new Lookup('description_20', 'po_b', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->description_20->OptionCount = 4;
		$this->description_20->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['description_20'] = &$this->description_20;

		// d_09_head
		$this->d_09_head = new DbField('po_b', 'po_b', 'x_d_09_head', 'd_09_head', '`d_09_head`', '`d_09_head`', 2, -1, FALSE, '`d_09_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->d_09_head->Sortable = FALSE; // Allow sort
		$this->d_09_head->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->d_09_head->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->d_09_head->Lookup = new Lookup('d_09_head', 'po_desc', FALSE, 'id', ["description","","",""], [], [], [], [], [], [], '`description` ASC', '');
		$this->d_09_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_09_head'] = &$this->d_09_head;

		// description_09
		$this->description_09 = new DbField('po_b', 'po_b', 'x_description_09', 'description_09', '`description_09`', '`description_09`', 200, -1, FALSE, '`description_09`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_09->Sortable = FALSE; // Allow sort
		$this->fields['description_09'] = &$this->description_09;

		// d_10_head
		$this->d_10_head = new DbField('po_b', 'po_b', 'x_d_10_head', 'd_10_head', '`d_10_head`', '`d_10_head`', 2, -1, FALSE, '`d_10_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->d_10_head->Sortable = FALSE; // Allow sort
		$this->d_10_head->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->d_10_head->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->d_10_head->Lookup = new Lookup('d_10_head', 'po_desc', FALSE, 'id', ["description","","",""], [], [], [], [], [], [], '`description` ASC', '');
		$this->d_10_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_10_head'] = &$this->d_10_head;

		// description_10
		$this->description_10 = new DbField('po_b', 'po_b', 'x_description_10', 'description_10', '`description_10`', '`description_10`', 200, -1, FALSE, '`description_10`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_10->Sortable = FALSE; // Allow sort
		$this->fields['description_10'] = &$this->description_10;

		// d_11_head
		$this->d_11_head = new DbField('po_b', 'po_b', 'x_d_11_head', 'd_11_head', '`d_11_head`', '`d_11_head`', 2, -1, FALSE, '`d_11_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->d_11_head->Sortable = FALSE; // Allow sort
		$this->d_11_head->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->d_11_head->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->d_11_head->Lookup = new Lookup('d_11_head', 'po_desc', FALSE, 'id', ["description","","",""], [], [], [], [], [], [], '`description` ASC', '');
		$this->d_11_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_11_head'] = &$this->d_11_head;

		// description_11
		$this->description_11 = new DbField('po_b', 'po_b', 'x_description_11', 'description_11', '`description_11`', '`description_11`', 200, -1, FALSE, '`description_11`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_11->Sortable = FALSE; // Allow sort
		$this->fields['description_11'] = &$this->description_11;

		// d_12_head
		$this->d_12_head = new DbField('po_b', 'po_b', 'x_d_12_head', 'd_12_head', '`d_12_head`', '`d_12_head`', 2, -1, FALSE, '`d_12_head`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->d_12_head->Sortable = FALSE; // Allow sort
		$this->d_12_head->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->d_12_head->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->d_12_head->Lookup = new Lookup('d_12_head', 'po_desc', FALSE, 'id', ["description","","",""], [], [], [], [], [], [], '`description` ASC', '');
		$this->d_12_head->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_12_head'] = &$this->d_12_head;

		// description_12
		$this->description_12 = new DbField('po_b', 'po_b', 'x_description_12', 'description_12', '`description_12`', '`description_12`', 200, -1, FALSE, '`description_12`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_12->Sortable = FALSE; // Allow sort
		$this->fields['description_12'] = &$this->description_12;

		// production_site
		$this->production_site = new DbField('po_b', 'po_b', 'x_production_site', 'production_site', '`production_site`', '`production_site`', 18, -1, FALSE, '`production_site`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->production_site->Nullable = FALSE; // NOT NULL field
		$this->production_site->Required = TRUE; // Required field
		$this->production_site->Sortable = FALSE; // Allow sort
		$this->production_site->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->production_site->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->production_site->Lookup = new Lookup('production_site', 'godown', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->production_site->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['production_site'] = &$this->production_site;

		// jc_no
		$this->jc_no = new DbField('po_b', 'po_b', 'x_jc_no', 'jc_no', '`jc_no`', '`jc_no`', 200, -1, FALSE, '`jc_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_no->Sortable = FALSE; // Allow sort
		$this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no'] = &$this->jc_no;

		// request
		$this->__request = new DbField('po_b', 'po_b', 'x___request', 'request', '`request`', '`request`', 18, -1, FALSE, '`request`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->__request->Nullable = FALSE; // NOT NULL field
		$this->__request->Sortable = FALSE; // Allow sort
		$this->__request->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['request'] = &$this->__request;

		// balance_quantity
		$this->balance_quantity = new DbField('po_b', 'po_b', 'x_balance_quantity', 'balance_quantity', '`balance_quantity`', '`balance_quantity`', 131, -1, FALSE, '`balance_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->balance_quantity->Sortable = FALSE; // Allow sort
		$this->balance_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['balance_quantity'] = &$this->balance_quantity;

		// e_mail
		$this->e_mail = new DbField('po_b', 'po_b', 'x_e_mail', 'e_mail', '`e_mail`', '`e_mail`', 16, -1, FALSE, '`e_mail`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->e_mail->Nullable = FALSE; // NOT NULL field
		$this->e_mail->Sortable = FALSE; // Allow sort
		$this->e_mail->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['e_mail'] = &$this->e_mail;

		// billing_address_id
		$this->billing_address_id = new DbField('po_b', 'po_b', 'x_billing_address_id', 'billing_address_id', '`billing_address_id`', '`billing_address_id`', 18, -1, FALSE, '`billing_address_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->billing_address_id->Sortable = FALSE; // Allow sort
		$this->billing_address_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['billing_address_id'] = &$this->billing_address_id;

		// shipping_address_id
		$this->shipping_address_id = new DbField('po_b', 'po_b', 'x_shipping_address_id', 'shipping_address_id', '`shipping_address_id`', '`shipping_address_id`', 18, -1, FALSE, '`shipping_address_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->shipping_address_id->Sortable = FALSE; // Allow sort
		$this->shipping_address_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['shipping_address_id'] = &$this->shipping_address_id;

		// status
		$this->status = new DbField('po_b', 'po_b', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Sortable = FALSE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'po_b', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 3;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// operator
		$this->operator = new DbField('po_b', 'po_b', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('po_b', 'po_b', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 11, "DB"), 135, 11, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// a_operator
		$this->a_operator = new DbField('po_b', 'po_b', 'x_a_operator', 'a_operator', '`a_operator`', '`a_operator`', 2, -1, FALSE, '`a_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->a_operator->Sortable = TRUE; // Allow sort
		$this->a_operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->a_operator->Lookup = new Lookup('a_operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['a_operator'] = &$this->a_operator;

		// a_datetime
		$this->a_datetime = new DbField('po_b', 'po_b', 'x_a_datetime', 'a_datetime', '`a_datetime`', CastDateFieldForLike('`a_datetime`', 11, "DB"), 135, 11, FALSE, '`a_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->a_datetime->Sortable = TRUE; // Allow sort
		$this->fields['a_datetime'] = &$this->a_datetime;

		// c_operator
		$this->c_operator = new DbField('po_b', 'po_b', 'x_c_operator', 'c_operator', '`c_operator`', '`c_operator`', 18, -1, FALSE, '`c_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->c_operator->Sortable = FALSE; // Allow sort
		$this->c_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['c_operator'] = &$this->c_operator;

		// c_datetime
		$this->c_datetime = new DbField('po_b', 'po_b', 'x_c_datetime', 'c_datetime', '`c_datetime`', CastDateFieldForLike('`c_datetime`', 11, "DB"), 135, 11, FALSE, '`c_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->c_datetime->Sortable = FALSE; // Allow sort
		$this->c_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['c_datetime'] = &$this->c_datetime;

		// app_operator
		$this->app_operator = new DbField('po_b', 'po_b', 'x_app_operator', 'app_operator', '`app_operator`', '`app_operator`', 2, -1, FALSE, '`app_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->app_operator->Sortable = TRUE; // Allow sort
		$this->app_operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->app_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->app_operator->Lookup = new Lookup('app_operator', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->app_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['app_operator'] = &$this->app_operator;

		// app_datetime
		$this->app_datetime = new DbField('po_b', 'po_b', 'x_app_datetime', 'app_datetime', '`app_datetime`', CastDateFieldForLike('`app_datetime`', 11, "DB"), 135, 11, FALSE, '`app_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->app_datetime->Sortable = TRUE; // Allow sort
		$this->app_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['app_datetime'] = &$this->app_datetime;

		// reports_to
		$this->reports_to = new DbField('po_b', 'po_b', 'x_reports_to', 'reports_to', '`reports_to`', '`reports_to`', 200, -1, FALSE, '`reports_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->reports_to->Nullable = FALSE; // NOT NULL field
		$this->reports_to->Required = TRUE; // Required field
		$this->reports_to->Sortable = FALSE; // Allow sort
		$this->reports_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['reports_to'] = &$this->reports_to;

		// grp_type
		$this->grp_type = new DbField('po_b', 'po_b', 'x_grp_type', 'grp_type', '`grp_type`', '`grp_type`', 2, -1, FALSE, '`grp_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->grp_type->Sortable = FALSE; // Allow sort
		$this->grp_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp_type'] = &$this->grp_type;

		// order_file
		$this->order_file = new DbField('po_b', 'po_b', 'x_order_file', 'order_file', '`order_file`', '`order_file`', 200, -1, FALSE, '`order_file`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->order_file->Sortable = TRUE; // Allow sort
		$this->fields['order_file'] = &$this->order_file;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "product_cart_b") {
			$detailUrl = $GLOBALS["product_cart_b"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_id=" . urlencode($this->id->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "po_blist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`po_b`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT DISTINCT `name` FROM `buyer_seller_view` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `po_b`.`partner_id` LIMIT 1) AS `EV__partner_id` FROM `po_b`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "CONCAT_ws(' AND ', " . (isset($_COOKIE['po_bcond']) ? $_COOKIE['po_bcond'] : ' 1=1  and grp_type = 1') .",".  ((User_Company_ID() == 0) ? ((User_Site() == 0) ? ' 1=1  and grp_type = 1 ' : "`operator` = ".CurrentUserID() ." and grp_type = 1") : ("`company_id` = ".User_Company_ID()." || `operator` = ".CurrentUserID() ." || `partner_id` = ".User_Company_ID() . "")). ") and `grp_type` = 1";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->partner_id->AdvancedSearch->SearchValue <> "" ||
			$this->partner_id->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->location->DbValue = $row['location'];
		$this->grp->DbValue = $row['grp'];
		$this->po->DbValue = $row['po'];
		$this->company_id->DbValue = $row['company_id'];
		$this->partner_id->DbValue = $row['partner_id'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->cart_id->DbValue = $row['cart_id'];
		$this->quantity->DbValue = $row['quantity'];
		$this->sqm->DbValue = $row['sqm'];
		$this->amount->DbValue = $row['amount'];
		$this->cbm->DbValue = $row['cbm'];
		$this->gst->DbValue = $row['gst'];
		$this->partner_order_no->DbValue = $row['partner_order_no'];
		$this->partner_order_date->DbValue = $row['partner_order_date'];
		$this->despatch_date->DbValue = $row['despatch_date'];
		$this->despatch_week->DbValue = $row['despatch_week'];
		$this->fob_date->DbValue = $row['fob_date'];
		$this->production_plan->DbValue = $row['production_plan'];
		$this->part_dispatch->DbValue = $row['part_dispatch'];
		$this->payment_terms->DbValue = $row['payment_terms'];
		$this->transport_type->DbValue = $row['transport_type'];
		$this->partner_shipping_id->DbValue = $row['partner_shipping_id'];
		$this->remarks->DbValue = $row['remarks'];
		$this->buyer_instruction->DbValue = $row['buyer_instruction'];
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->description_01->DbValue = $row['description_01'];
		$this->description_02->DbValue = $row['description_02'];
		$this->description_03->DbValue = $row['description_03'];
		$this->description_04->DbValue = $row['description_04'];
		$this->description_05->DbValue = $row['description_05'];
		$this->description_06->DbValue = $row['description_06'];
		$this->description_07->DbValue = $row['description_07'];
		$this->description_08->DbValue = $row['description_08'];
		$this->description_17->DbValue = $row['description_17'];
		$this->description_18->DbValue = $row['description_18'];
		$this->description_19->DbValue = $row['description_19'];
		$this->description_20->DbValue = $row['description_20'];
		$this->d_09_head->DbValue = $row['d_09_head'];
		$this->description_09->DbValue = $row['description_09'];
		$this->d_10_head->DbValue = $row['d_10_head'];
		$this->description_10->DbValue = $row['description_10'];
		$this->d_11_head->DbValue = $row['d_11_head'];
		$this->description_11->DbValue = $row['description_11'];
		$this->d_12_head->DbValue = $row['d_12_head'];
		$this->description_12->DbValue = $row['description_12'];
		$this->production_site->DbValue = $row['production_site'];
		$this->jc_no->DbValue = $row['jc_no'];
		$this->__request->DbValue = $row['request'];
		$this->balance_quantity->DbValue = $row['balance_quantity'];
		$this->e_mail->DbValue = $row['e_mail'];
		$this->billing_address_id->DbValue = $row['billing_address_id'];
		$this->shipping_address_id->DbValue = $row['shipping_address_id'];
		$this->status->DbValue = $row['status'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->a_operator->DbValue = $row['a_operator'];
		$this->a_datetime->DbValue = $row['a_datetime'];
		$this->c_operator->DbValue = $row['c_operator'];
		$this->c_datetime->DbValue = $row['c_datetime'];
		$this->app_operator->DbValue = $row['app_operator'];
		$this->app_datetime->DbValue = $row['app_datetime'];
		$this->reports_to->DbValue = $row['reports_to'];
		$this->grp_type->DbValue = $row['grp_type'];
		$this->order_file->DbValue = $row['order_file'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->uploads->OldUploadPath = '/.p_uploads/sppo/' . $this->id->CurrentValue . '/' ;
		$oldFiles = EmptyValue($row['uploads']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['uploads']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "po_blist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "po_bview.php")
			return $Language->phrase("View");
		elseif ($pageName == "po_bedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "po_badd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "po_blist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("po_bview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("po_bview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "po_badd.php?" . $this->getUrlParm($parm);
		else
			$url = "po_badd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("po_bedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("po_bedit.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("po_badd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("po_badd.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("po_bdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->location->setDbValue($rs->fields('location'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->po->setDbValue($rs->fields('po'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->partner_id->setDbValue($rs->fields('partner_id'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->cart_id->setDbValue($rs->fields('cart_id'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->amount->setDbValue($rs->fields('amount'));
		$this->cbm->setDbValue($rs->fields('cbm'));
		$this->gst->setDbValue($rs->fields('gst'));
		$this->partner_order_no->setDbValue($rs->fields('partner_order_no'));
		$this->partner_order_date->setDbValue($rs->fields('partner_order_date'));
		$this->despatch_date->setDbValue($rs->fields('despatch_date'));
		$this->despatch_week->setDbValue($rs->fields('despatch_week'));
		$this->fob_date->setDbValue($rs->fields('fob_date'));
		$this->production_plan->setDbValue($rs->fields('production_plan'));
		$this->part_dispatch->setDbValue($rs->fields('part_dispatch'));
		$this->payment_terms->setDbValue($rs->fields('payment_terms'));
		$this->transport_type->setDbValue($rs->fields('transport_type'));
		$this->partner_shipping_id->setDbValue($rs->fields('partner_shipping_id'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->buyer_instruction->setDbValue($rs->fields('buyer_instruction'));
		$this->uploads->Upload->DbValue = $rs->fields('uploads');
		$this->description_01->setDbValue($rs->fields('description_01'));
		$this->description_02->setDbValue($rs->fields('description_02'));
		$this->description_03->setDbValue($rs->fields('description_03'));
		$this->description_04->setDbValue($rs->fields('description_04'));
		$this->description_05->setDbValue($rs->fields('description_05'));
		$this->description_06->setDbValue($rs->fields('description_06'));
		$this->description_07->setDbValue($rs->fields('description_07'));
		$this->description_08->setDbValue($rs->fields('description_08'));
		$this->description_17->setDbValue($rs->fields('description_17'));
		$this->description_18->setDbValue($rs->fields('description_18'));
		$this->description_19->setDbValue($rs->fields('description_19'));
		$this->description_20->setDbValue($rs->fields('description_20'));
		$this->d_09_head->setDbValue($rs->fields('d_09_head'));
		$this->description_09->setDbValue($rs->fields('description_09'));
		$this->d_10_head->setDbValue($rs->fields('d_10_head'));
		$this->description_10->setDbValue($rs->fields('description_10'));
		$this->d_11_head->setDbValue($rs->fields('d_11_head'));
		$this->description_11->setDbValue($rs->fields('description_11'));
		$this->d_12_head->setDbValue($rs->fields('d_12_head'));
		$this->description_12->setDbValue($rs->fields('description_12'));
		$this->production_site->setDbValue($rs->fields('production_site'));
		$this->jc_no->setDbValue($rs->fields('jc_no'));
		$this->__request->setDbValue($rs->fields('request'));
		$this->balance_quantity->setDbValue($rs->fields('balance_quantity'));
		$this->e_mail->setDbValue($rs->fields('e_mail'));
		$this->billing_address_id->setDbValue($rs->fields('billing_address_id'));
		$this->shipping_address_id->setDbValue($rs->fields('shipping_address_id'));
		$this->status->setDbValue($rs->fields('status'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->a_operator->setDbValue($rs->fields('a_operator'));
		$this->a_datetime->setDbValue($rs->fields('a_datetime'));
		$this->c_operator->setDbValue($rs->fields('c_operator'));
		$this->c_datetime->setDbValue($rs->fields('c_datetime'));
		$this->app_operator->setDbValue($rs->fields('app_operator'));
		$this->app_datetime->setDbValue($rs->fields('app_datetime'));
		$this->reports_to->setDbValue($rs->fields('reports_to'));
		$this->grp_type->setDbValue($rs->fields('grp_type'));
		$this->order_file->setDbValue($rs->fields('order_file'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// location

		$this->location->CellCssStyle = "white-space: nowrap;";

		// grp
		$this->grp->CellCssStyle = "white-space: nowrap;";

		// po
		// company_id
		// partner_id
		// s_grp

		$this->s_grp->CellCssStyle = "white-space: nowrap;";

		// cart_id
		// quantity
		// sqm
		// amount
		// cbm
		// gst
		// partner_order_no

		$this->partner_order_no->CellCssStyle = "white-space: nowrap;";

		// partner_order_date
		$this->partner_order_date->CellCssStyle = "white-space: nowrap;";

		// despatch_date
		// despatch_week
		// fob_date
		// production_plan
		// part_dispatch
		// payment_terms
		// transport_type
		// partner_shipping_id
		// remarks
		// buyer_instruction
		// uploads

		$this->uploads->CellCssStyle = "white-space: nowrap;";

		// description_01
		$this->description_01->CellCssStyle = "white-space: nowrap;";

		// description_02
		$this->description_02->CellCssStyle = "white-space: nowrap;";

		// description_03
		$this->description_03->CellCssStyle = "white-space: nowrap;";

		// description_04
		$this->description_04->CellCssStyle = "white-space: nowrap;";

		// description_05
		$this->description_05->CellCssStyle = "white-space: nowrap;";

		// description_06
		$this->description_06->CellCssStyle = "white-space: nowrap;";

		// description_07
		$this->description_07->CellCssStyle = "white-space: nowrap;";

		// description_08
		$this->description_08->CellCssStyle = "white-space: nowrap;";

		// description_17
		$this->description_17->CellCssStyle = "white-space: nowrap;";

		// description_18
		$this->description_18->CellCssStyle = "white-space: nowrap;";

		// description_19
		$this->description_19->CellCssStyle = "white-space: nowrap;";

		// description_20
		$this->description_20->CellCssStyle = "white-space: nowrap;";

		// d_09_head
		$this->d_09_head->CellCssStyle = "white-space: nowrap;";

		// description_09
		$this->description_09->CellCssStyle = "white-space: nowrap;";

		// d_10_head
		$this->d_10_head->CellCssStyle = "white-space: nowrap;";

		// description_10
		$this->description_10->CellCssStyle = "white-space: nowrap;";

		// d_11_head
		$this->d_11_head->CellCssStyle = "white-space: nowrap;";

		// description_11
		$this->description_11->CellCssStyle = "white-space: nowrap;";

		// d_12_head
		$this->d_12_head->CellCssStyle = "white-space: nowrap;";

		// description_12
		$this->description_12->CellCssStyle = "white-space: nowrap;";

		// production_site
		$this->production_site->CellCssStyle = "white-space: nowrap;";

		// jc_no
		$this->jc_no->CellCssStyle = "white-space: nowrap;";

		// request
		$this->__request->CellCssStyle = "white-space: nowrap;";

		// balance_quantity
		$this->balance_quantity->CellCssStyle = "white-space: nowrap;";

		// e_mail
		$this->e_mail->CellCssStyle = "white-space: nowrap;";

		// billing_address_id
		$this->billing_address_id->CellCssStyle = "white-space: nowrap;";

		// shipping_address_id
		$this->shipping_address_id->CellCssStyle = "white-space: nowrap;";

		// status
		$this->status->CellCssStyle = "white-space: nowrap;";

		// operator
		// datetime
		// a_operator
		// a_datetime
		// c_operator

		$this->c_operator->CellCssStyle = "white-space: nowrap;";

		// c_datetime
		$this->c_datetime->CellCssStyle = "white-space: nowrap;";

		// app_operator
		// app_datetime
		// reports_to

		$this->reports_to->CellCssStyle = "white-space: nowrap;";

		// grp_type
		$this->grp_type->CellCssStyle = "white-space: nowrap;";

		// order_file
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// location
		$curVal = strval($this->location->CurrentValue);
		if ($curVal <> "") {
			$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
			if ($this->location->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return ((CurrentPageID() == "add") || (CurrentPageID() == "edit")) ? (User_Site() == 0) ? "" : "FIND_IN_SET(`id`," . User_Site() . ")" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->location->ViewValue = $this->location->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->location->ViewValue = $this->location->CurrentValue;
				}
			}
		} else {
			$this->location->ViewValue = NULL;
		}
		$this->location->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// company_id
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Company_ID() == 0) ? ((User_Site() == 0) ? "`status` = 1" : "((`status` = 1 and `id` >= 1000 and FIND_IN_SET(" . CurrentUserID() . " , `merchant`)) || (`category` = 1))") : "((`id` = " .  User_Company_ID() ." and `status` = 1 and `id` >= 1000) || (`category` = 1))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// partner_id
		if ($this->partner_id->VirtualValue <> "") {
			$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
		} else {
			$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
		$curVal = strval($this->partner_id->CurrentValue);
		if ($curVal <> "") {
			$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
			if ($this->partner_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return User_Company_ID() == 0 ? "`status` = 1 and `category` = 1" : "id= ".  User_Company_ID() . "  and `status` = 1 and `category` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
				}
			}
		} else {
			$this->partner_id->ViewValue = NULL;
		}
		}
		$this->partner_id->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->s_grp->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue->add($this->s_grp->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// cart_id
		$curVal = strval($this->cart_id->CurrentValue);
		if ($curVal <> "") {
			$this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
			if ($this->cart_id->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "(`po_id` = 0 and `batch_no` > 0)" :  "(`po_id` = 0 and `batch_no` > 0) || FIND_IN_SET(" . $this->id->CurrentValue . ", `po_id`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->cart_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->cart_id->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, 0);
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, 0);
						$this->cart_id->ViewValue->add($this->cart_id->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->cart_id->ViewValue = $this->cart_id->CurrentValue;
				}
			}
		} else {
			$this->cart_id->ViewValue = NULL;
		}
		$this->cart_id->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// amount
		$this->amount->ViewValue = $this->amount->CurrentValue;
		$this->amount->ViewCustomAttributes = "";

		// cbm
		$this->cbm->ViewValue = $this->cbm->CurrentValue;
		$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 2, -2, -2, -2);
		$this->cbm->ViewCustomAttributes = "";

		// gst
		$curVal = strval($this->gst->CurrentValue);
		if ($curVal <> "") {
			$this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
			if ($this->gst->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->gst->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
					$arwrk[3] = $rswrk->fields('df3');
					$this->gst->ViewValue = $this->gst->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->gst->ViewValue = $this->gst->CurrentValue;
				}
			}
		} else {
			$this->gst->ViewValue = NULL;
		}
		$this->gst->ViewCustomAttributes = "";

		// partner_order_no
		$this->partner_order_no->ViewValue = $this->partner_order_no->CurrentValue;
		$this->partner_order_no->ViewCustomAttributes = "";

		// partner_order_date
		$this->partner_order_date->ViewValue = $this->partner_order_date->CurrentValue;
		$this->partner_order_date->ViewValue = FormatDateTime($this->partner_order_date->ViewValue, 0);
		$this->partner_order_date->ViewCustomAttributes = "";

		// despatch_date
		$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
		$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
		$this->despatch_date->ViewCustomAttributes = "";

		// despatch_week
		$curVal = strval($this->despatch_week->CurrentValue);
		if ($curVal <> "") {
			$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`weekstartday` >= NOW()" : '';
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
				}
			}
		} else {
			$this->despatch_week->ViewValue = NULL;
		}
		$this->despatch_week->ViewCustomAttributes = "";

		// fob_date
		$this->fob_date->ViewValue = $this->fob_date->CurrentValue;
		$this->fob_date->ViewValue = FormatDateTime($this->fob_date->ViewValue, 0);
		$this->fob_date->ViewCustomAttributes = "";

		// production_plan
		$curVal = strval($this->production_plan->CurrentValue);
		if ($curVal <> "") {
			$this->production_plan->ViewValue = $this->production_plan->lookupCacheOption($curVal);
			if ($this->production_plan->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =1 and `grp` = 2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->production_plan->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->production_plan->ViewValue = $this->production_plan->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->production_plan->ViewValue = $this->production_plan->CurrentValue;
				}
			}
		} else {
			$this->production_plan->ViewValue = NULL;
		}
		$this->production_plan->ViewCustomAttributes = "";

		// part_dispatch
		if (strval($this->part_dispatch->CurrentValue) <> "") {
			$this->part_dispatch->ViewValue = $this->part_dispatch->optionCaption($this->part_dispatch->CurrentValue);
		} else {
			$this->part_dispatch->ViewValue = NULL;
		}
		$this->part_dispatch->ViewCustomAttributes = "";

		// payment_terms
		$curVal = strval($this->payment_terms->CurrentValue);
		if ($curVal <> "") {
			$this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
			if ($this->payment_terms->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 81";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->payment_terms->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
				}
			}
		} else {
			$this->payment_terms->ViewValue = NULL;
		}
		$this->payment_terms->ViewCustomAttributes = "";

		// transport_type
		$curVal = strval($this->transport_type->CurrentValue);
		if ($curVal <> "") {
			$this->transport_type->ViewValue = $this->transport_type->lookupCacheOption($curVal);
			if ($this->transport_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 82";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->transport_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->transport_type->ViewValue = $this->transport_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->transport_type->ViewValue = $this->transport_type->CurrentValue;
				}
			}
		} else {
			$this->transport_type->ViewValue = NULL;
		}
		$this->transport_type->ViewCustomAttributes = "";

		// partner_shipping_id
		$curVal = strval($this->partner_shipping_id->CurrentValue);
		if ($curVal <> "") {
			$this->partner_shipping_id->ViewValue = $this->partner_shipping_id->lookupCacheOption($curVal);
			if ($this->partner_shipping_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` < 3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_shipping_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = $rswrk->fields('df4');
					$this->partner_shipping_id->ViewValue = $this->partner_shipping_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_shipping_id->ViewValue = $this->partner_shipping_id->CurrentValue;
				}
			}
		} else {
			$this->partner_shipping_id->ViewValue = NULL;
		}
		$this->partner_shipping_id->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// buyer_instruction
		$this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;
		$this->buyer_instruction->ViewCustomAttributes = "";

		// uploads
		$this->uploads->UploadPath = '/.p_uploads/sppo/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->ImageWidth = 0;
			$this->uploads->ImageHeight = 50;
			$this->uploads->ImageAlt = $this->uploads->alt();
			$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->ViewValue = "";
		}
		$this->uploads->CssClass = "font-italic";
		$this->uploads->ViewCustomAttributes = "";

		// description_01
		$this->description_01->ViewValue = $this->description_01->CurrentValue;
		$this->description_01->ViewValue = FormatNumber($this->description_01->ViewValue, 3, -2, -2, -2);
		$this->description_01->ViewCustomAttributes = "";

		// description_02
		$this->description_02->ViewValue = $this->description_02->CurrentValue;
		$this->description_02->ViewValue = FormatNumber($this->description_02->ViewValue, 3, -2, -2, -2);
		$this->description_02->ViewCustomAttributes = "";

		// description_03
		if (strval($this->description_03->CurrentValue) <> "") {
			$this->description_03->ViewValue = $this->description_03->optionCaption($this->description_03->CurrentValue);
		} else {
			$this->description_03->ViewValue = NULL;
		}
		$this->description_03->ViewCustomAttributes = "";

		// description_04
		if (strval($this->description_04->CurrentValue) <> "") {
			$this->description_04->ViewValue = $this->description_04->optionCaption($this->description_04->CurrentValue);
		} else {
			$this->description_04->ViewValue = NULL;
		}
		$this->description_04->ViewCustomAttributes = "";

		// description_05
		$curVal = strval($this->description_05->CurrentValue);
		if ($curVal <> "") {
			$this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
			if ($this->description_05->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->description_05->ViewValue = $this->description_05->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->description_05->ViewValue = $this->description_05->CurrentValue;
				}
			}
		} else {
			$this->description_05->ViewValue = NULL;
		}
		$this->description_05->ViewCustomAttributes = "";

		// description_06
		$curVal = strval($this->description_06->CurrentValue);
		if ($curVal <> "") {
			$this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
			if ($this->description_06->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->description_06->ViewValue = $this->description_06->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->description_06->ViewValue = $this->description_06->CurrentValue;
				}
			}
		} else {
			$this->description_06->ViewValue = NULL;
		}
		$this->description_06->ViewCustomAttributes = "";

		// description_07
		$this->description_07->ViewValue = $this->description_07->CurrentValue;
		$this->description_07->ViewCustomAttributes = "";

		// description_08
		$this->description_08->ViewValue = $this->description_08->CurrentValue;
		$this->description_08->ViewCustomAttributes = "";

		// description_17
		$this->description_17->ViewValue = $this->description_17->CurrentValue;
		$this->description_17->ViewValue = FormatNumber($this->description_17->ViewValue, 2, -2, -2, -2);
		$this->description_17->ViewCustomAttributes = "";

		// description_18
		$this->description_18->ViewValue = $this->description_18->CurrentValue;
		$this->description_18->ViewValue = FormatNumber($this->description_18->ViewValue, 2, -2, -2, -2);
		$this->description_18->ViewCustomAttributes = "";

		// description_19
		$this->description_19->ViewValue = $this->description_19->CurrentValue;
		$this->description_19->ViewValue = FormatNumber($this->description_19->ViewValue, 2, -2, -2, -2);
		$this->description_19->ViewCustomAttributes = "";

		// description_20
		if (strval($this->description_20->CurrentValue) <> "") {
			$this->description_20->ViewValue = $this->description_20->optionCaption($this->description_20->CurrentValue);
		} else {
			$this->description_20->ViewValue = NULL;
		}
		$this->description_20->ViewCustomAttributes = "";

		// d_09_head
		$curVal = strval($this->d_09_head->CurrentValue);
		if ($curVal <> "") {
			$this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
			if ($this->d_09_head->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->d_09_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->d_09_head->ViewValue = $this->d_09_head->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->d_09_head->ViewValue = $this->d_09_head->CurrentValue;
				}
			}
		} else {
			$this->d_09_head->ViewValue = NULL;
		}
		$this->d_09_head->ViewCustomAttributes = "";

		// description_09
		$this->description_09->ViewValue = $this->description_09->CurrentValue;
		$this->description_09->ViewCustomAttributes = "";

		// d_10_head
		$curVal = strval($this->d_10_head->CurrentValue);
		if ($curVal <> "") {
			$this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
			if ($this->d_10_head->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->d_10_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->d_10_head->ViewValue = $this->d_10_head->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->d_10_head->ViewValue = $this->d_10_head->CurrentValue;
				}
			}
		} else {
			$this->d_10_head->ViewValue = NULL;
		}
		$this->d_10_head->ViewCustomAttributes = "";

		// description_10
		$this->description_10->ViewValue = $this->description_10->CurrentValue;
		$this->description_10->ViewCustomAttributes = "";

		// d_11_head
		$curVal = strval($this->d_11_head->CurrentValue);
		if ($curVal <> "") {
			$this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
			if ($this->d_11_head->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->d_11_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->d_11_head->ViewValue = $this->d_11_head->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->d_11_head->ViewValue = $this->d_11_head->CurrentValue;
				}
			}
		} else {
			$this->d_11_head->ViewValue = NULL;
		}
		$this->d_11_head->ViewCustomAttributes = "";

		// description_11
		$this->description_11->ViewValue = $this->description_11->CurrentValue;
		$this->description_11->ViewCustomAttributes = "";

		// d_12_head
		$curVal = strval($this->d_12_head->CurrentValue);
		if ($curVal <> "") {
			$this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
			if ($this->d_12_head->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->d_12_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->d_12_head->ViewValue = $this->d_12_head->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->d_12_head->ViewValue = $this->d_12_head->CurrentValue;
				}
			}
		} else {
			$this->d_12_head->ViewValue = NULL;
		}
		$this->d_12_head->ViewCustomAttributes = "";

		// description_12
		$this->description_12->ViewValue = $this->description_12->CurrentValue;
		$this->description_12->ViewCustomAttributes = "";

		// production_site
		$curVal = strval($this->production_site->CurrentValue);
		if ($curVal <> "") {
			$this->production_site->ViewValue = $this->production_site->lookupCacheOption($curVal);
			if ($this->production_site->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` IN (0,3)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->production_site->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->production_site->ViewValue = $this->production_site->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->production_site->ViewValue = $this->production_site->CurrentValue;
				}
			}
		} else {
			$this->production_site->ViewValue = NULL;
		}
		$this->production_site->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
		$this->jc_no->ViewCustomAttributes = "";

		// request
		$this->__request->ViewValue = $this->__request->CurrentValue;
		$this->__request->ViewValue = FormatNumber($this->__request->ViewValue, 0, -2, -2, -2);
		$this->__request->ViewCustomAttributes = "";

		// balance_quantity
		$this->balance_quantity->ViewValue = $this->balance_quantity->CurrentValue;
		$this->balance_quantity->ViewValue = FormatNumber($this->balance_quantity->ViewValue, 2, -2, -2, -2);
		$this->balance_quantity->ViewCustomAttributes = "";

		// e_mail
		$this->e_mail->ViewValue = $this->e_mail->CurrentValue;
		$this->e_mail->ViewValue = FormatNumber($this->e_mail->ViewValue, 0, -2, -2, -2);
		$this->e_mail->ViewCustomAttributes = "";

		// billing_address_id
		$this->billing_address_id->ViewValue = $this->billing_address_id->CurrentValue;
		$this->billing_address_id->ViewValue = FormatNumber($this->billing_address_id->ViewValue, 0, -2, -2, -2);
		$this->billing_address_id->ViewCustomAttributes = "";

		// shipping_address_id
		$this->shipping_address_id->ViewValue = $this->shipping_address_id->CurrentValue;
		$this->shipping_address_id->ViewValue = FormatNumber($this->shipping_address_id->ViewValue, 0, -2, -2, -2);
		$this->shipping_address_id->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 11);
		$this->datetime->ViewCustomAttributes = "";

		// a_operator
		$curVal = strval($this->a_operator->CurrentValue);
		if ($curVal <> "") {
			$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
			if ($this->a_operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
				}
			}
		} else {
			$this->a_operator->ViewValue = NULL;
		}
		$this->a_operator->ViewCustomAttributes = "";

		// a_datetime
		$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
		$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 11);
		$this->a_datetime->ViewCustomAttributes = "";

		// c_operator
		$this->c_operator->ViewValue = $this->c_operator->CurrentValue;
		$this->c_operator->ViewValue = FormatNumber($this->c_operator->ViewValue, 0, -2, -2, -2);
		$this->c_operator->ViewCustomAttributes = "";

		// c_datetime
		$this->c_datetime->ViewValue = $this->c_datetime->CurrentValue;
		$this->c_datetime->ViewValue = FormatDateTime($this->c_datetime->ViewValue, 11);
		$this->c_datetime->ViewCustomAttributes = "";

		// app_operator
		$curVal = strval($this->app_operator->CurrentValue);
		if ($curVal <> "") {
			$this->app_operator->ViewValue = $this->app_operator->lookupCacheOption($curVal);
			if ($this->app_operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->app_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->app_operator->ViewValue = $this->app_operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->app_operator->ViewValue = $this->app_operator->CurrentValue;
				}
			}
		} else {
			$this->app_operator->ViewValue = NULL;
		}
		$this->app_operator->ViewCustomAttributes = "";

		// app_datetime
		$this->app_datetime->ViewValue = $this->app_datetime->CurrentValue;
		$this->app_datetime->ViewValue = FormatDateTime($this->app_datetime->ViewValue, 11);
		$this->app_datetime->ViewCustomAttributes = "";

		// reports_to
		$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
		$this->reports_to->ViewCustomAttributes = "";

		// grp_type
		$this->grp_type->ViewValue = $this->grp_type->CurrentValue;
		$this->grp_type->ViewValue = FormatNumber($this->grp_type->ViewValue, 0, -2, -2, -2);
		$this->grp_type->ViewCustomAttributes = "";

		// order_file
		$this->order_file->ViewValue = $this->order_file->CurrentValue;
		$this->order_file->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// location
		$this->location->LinkCustomAttributes = "";
		$this->location->HrefValue = "";
		$this->location->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		if (!EmptyValue($this->po->CurrentValue)) {
			$this->po->HrefValue = "po_blist.php?x_po=" . $this->po->CurrentValue; // Add prefix/suffix
			$this->po->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
		} else {
			$this->po->HrefValue = "";
		}
		$this->po->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// partner_id
		$this->partner_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->partner_id->CurrentValue)) {
			$this->partner_id->HrefValue = "po_blist.php?x_partner_id=" . $this->partner_id->CurrentValue; // Add prefix/suffix
			$this->partner_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
		} else {
			$this->partner_id->HrefValue = "";
		}
		$this->partner_id->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// cart_id
		$this->cart_id->LinkCustomAttributes = "";
		$this->cart_id->HrefValue = "";
		$this->cart_id->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// amount
		$this->amount->LinkCustomAttributes = "";
		$this->amount->HrefValue = "";
		$this->amount->TooltipValue = "";

		// cbm
		$this->cbm->LinkCustomAttributes = "";
		$this->cbm->HrefValue = "";
		$this->cbm->TooltipValue = "";

		// gst
		$this->gst->LinkCustomAttributes = "";
		$this->gst->HrefValue = "";
		$this->gst->TooltipValue = "";

		// partner_order_no
		$this->partner_order_no->LinkCustomAttributes = "";
		$this->partner_order_no->HrefValue = "";
		$this->partner_order_no->TooltipValue = "";

		// partner_order_date
		$this->partner_order_date->LinkCustomAttributes = "";
		$this->partner_order_date->HrefValue = "";
		$this->partner_order_date->TooltipValue = "";

		// despatch_date
		$this->despatch_date->LinkCustomAttributes = "";
		$this->despatch_date->HrefValue = "";
		$this->despatch_date->TooltipValue = "";

		// despatch_week
		$this->despatch_week->LinkCustomAttributes = "";
		$this->despatch_week->HrefValue = "";
		$this->despatch_week->TooltipValue = "";

		// fob_date
		$this->fob_date->LinkCustomAttributes = "";
		$this->fob_date->HrefValue = "";
		$this->fob_date->TooltipValue = "";

		// production_plan
		$this->production_plan->LinkCustomAttributes = "";
		$this->production_plan->HrefValue = "";
		$this->production_plan->TooltipValue = "";

		// part_dispatch
		$this->part_dispatch->LinkCustomAttributes = "";
		if (!EmptyValue($this->part_dispatch->CurrentValue)) {
			$this->part_dispatch->HrefValue = "po_blist.php?x_part_dispatch=" . $this->part_dispatch->CurrentValue; // Add prefix/suffix
			$this->part_dispatch->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->part_dispatch->HrefValue = FullUrl($this->part_dispatch->HrefValue, "href");
		} else {
			$this->part_dispatch->HrefValue = "";
		}
		$this->part_dispatch->TooltipValue = "";

		// payment_terms
		$this->payment_terms->LinkCustomAttributes = "";
		if (!EmptyValue($this->payment_terms->CurrentValue)) {
			$this->payment_terms->HrefValue = "po_blist.php?x_payment_terms=" . $this->payment_terms->CurrentValue; // Add prefix/suffix
			$this->payment_terms->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->payment_terms->HrefValue = FullUrl($this->payment_terms->HrefValue, "href");
		} else {
			$this->payment_terms->HrefValue = "";
		}
		$this->payment_terms->TooltipValue = "";

		// transport_type
		$this->transport_type->LinkCustomAttributes = "";
		if (!EmptyValue($this->transport_type->CurrentValue)) {
			$this->transport_type->HrefValue = "po_blist.php?x_transport_type=" . $this->transport_type->CurrentValue; // Add prefix/suffix
			$this->transport_type->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->transport_type->HrefValue = FullUrl($this->transport_type->HrefValue, "href");
		} else {
			$this->transport_type->HrefValue = "";
		}
		$this->transport_type->TooltipValue = "";

		// partner_shipping_id
		$this->partner_shipping_id->LinkCustomAttributes = "";
		$this->partner_shipping_id->HrefValue = "";
		$this->partner_shipping_id->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// buyer_instruction
		$this->buyer_instruction->LinkCustomAttributes = "";
		$this->buyer_instruction->HrefValue = "";
		$this->buyer_instruction->TooltipValue = "";

		// uploads
		$this->uploads->LinkCustomAttributes = "";
		$this->uploads->UploadPath = '/.p_uploads/sppo/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->HrefValue = "%u"; // Add prefix/suffix
			$this->uploads->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
		} else {
			$this->uploads->HrefValue = "";
		}
		$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
		$this->uploads->TooltipValue = "";
		if ($this->uploads->UseColorbox) {
			if (EmptyValue($this->uploads->TooltipValue))
				$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->uploads->LinkAttrs["data-rel"] = "po_b_x_uploads";
			AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
		}

		// description_01
		$this->description_01->LinkCustomAttributes = "";
		$this->description_01->HrefValue = "";
		$this->description_01->TooltipValue = "";

		// description_02
		$this->description_02->LinkCustomAttributes = "";
		$this->description_02->HrefValue = "";
		$this->description_02->TooltipValue = "";

		// description_03
		$this->description_03->LinkCustomAttributes = "";
		$this->description_03->HrefValue = "";
		$this->description_03->TooltipValue = "";

		// description_04
		$this->description_04->LinkCustomAttributes = "";
		$this->description_04->HrefValue = "";
		$this->description_04->TooltipValue = "";

		// description_05
		$this->description_05->LinkCustomAttributes = "";
		$this->description_05->HrefValue = "";
		$this->description_05->TooltipValue = "";

		// description_06
		$this->description_06->LinkCustomAttributes = "";
		$this->description_06->HrefValue = "";
		$this->description_06->TooltipValue = "";

		// description_07
		$this->description_07->LinkCustomAttributes = "";
		$this->description_07->HrefValue = "";
		$this->description_07->TooltipValue = "";

		// description_08
		$this->description_08->LinkCustomAttributes = "";
		$this->description_08->HrefValue = "";
		$this->description_08->TooltipValue = "";

		// description_17
		$this->description_17->LinkCustomAttributes = "";
		$this->description_17->HrefValue = "";
		$this->description_17->TooltipValue = "";

		// description_18
		$this->description_18->LinkCustomAttributes = "";
		$this->description_18->HrefValue = "";
		$this->description_18->TooltipValue = "";

		// description_19
		$this->description_19->LinkCustomAttributes = "";
		$this->description_19->HrefValue = "";
		$this->description_19->TooltipValue = "";

		// description_20
		$this->description_20->LinkCustomAttributes = "";
		$this->description_20->HrefValue = "";
		$this->description_20->TooltipValue = "";

		// d_09_head
		$this->d_09_head->LinkCustomAttributes = "";
		$this->d_09_head->HrefValue = "";
		$this->d_09_head->TooltipValue = "";

		// description_09
		$this->description_09->LinkCustomAttributes = "";
		$this->description_09->HrefValue = "";
		$this->description_09->TooltipValue = "";

		// d_10_head
		$this->d_10_head->LinkCustomAttributes = "";
		$this->d_10_head->HrefValue = "";
		$this->d_10_head->TooltipValue = "";

		// description_10
		$this->description_10->LinkCustomAttributes = "";
		$this->description_10->HrefValue = "";
		$this->description_10->TooltipValue = "";

		// d_11_head
		$this->d_11_head->LinkCustomAttributes = "";
		$this->d_11_head->HrefValue = "";
		$this->d_11_head->TooltipValue = "";

		// description_11
		$this->description_11->LinkCustomAttributes = "";
		$this->description_11->HrefValue = "";
		$this->description_11->TooltipValue = "";

		// d_12_head
		$this->d_12_head->LinkCustomAttributes = "";
		$this->d_12_head->HrefValue = "";
		$this->d_12_head->TooltipValue = "";

		// description_12
		$this->description_12->LinkCustomAttributes = "";
		$this->description_12->HrefValue = "";
		$this->description_12->TooltipValue = "";

		// production_site
		$this->production_site->LinkCustomAttributes = "";
		$this->production_site->HrefValue = "";
		$this->production_site->TooltipValue = "";

		// jc_no
		$this->jc_no->LinkCustomAttributes = "";
		$this->jc_no->HrefValue = "";
		$this->jc_no->TooltipValue = "";

		// request
		$this->__request->LinkCustomAttributes = "";
		$this->__request->HrefValue = "";
		$this->__request->TooltipValue = "";

		// balance_quantity
		$this->balance_quantity->LinkCustomAttributes = "";
		$this->balance_quantity->HrefValue = "";
		$this->balance_quantity->TooltipValue = "";

		// e_mail
		$this->e_mail->LinkCustomAttributes = "";
		$this->e_mail->HrefValue = "";
		$this->e_mail->TooltipValue = "";

		// billing_address_id
		$this->billing_address_id->LinkCustomAttributes = "";
		$this->billing_address_id->HrefValue = "";
		$this->billing_address_id->TooltipValue = "";

		// shipping_address_id
		$this->shipping_address_id->LinkCustomAttributes = "";
		$this->shipping_address_id->HrefValue = "";
		$this->shipping_address_id->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// a_operator
		$this->a_operator->LinkCustomAttributes = "";
		$this->a_operator->HrefValue = "";
		$this->a_operator->TooltipValue = "";

		// a_datetime
		$this->a_datetime->LinkCustomAttributes = "";
		$this->a_datetime->HrefValue = "";
		$this->a_datetime->TooltipValue = "";

		// c_operator
		$this->c_operator->LinkCustomAttributes = "";
		$this->c_operator->HrefValue = "";
		$this->c_operator->TooltipValue = "";

		// c_datetime
		$this->c_datetime->LinkCustomAttributes = "";
		$this->c_datetime->HrefValue = "";
		$this->c_datetime->TooltipValue = "";

		// app_operator
		$this->app_operator->LinkCustomAttributes = "";
		$this->app_operator->HrefValue = "";
		$this->app_operator->TooltipValue = "";

		// app_datetime
		$this->app_datetime->LinkCustomAttributes = "";
		$this->app_datetime->HrefValue = "";
		$this->app_datetime->TooltipValue = "";

		// reports_to
		$this->reports_to->LinkCustomAttributes = "";
		$this->reports_to->HrefValue = "";
		$this->reports_to->TooltipValue = "";

		// grp_type
		$this->grp_type->LinkCustomAttributes = "";
		$this->grp_type->HrefValue = "";
		$this->grp_type->TooltipValue = "";

		// order_file
		$this->order_file->LinkCustomAttributes = "";
		$this->order_file->HrefValue = "";
		$this->order_file->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// location
		$this->location->EditAttrs["class"] = "form-control";
		$this->location->EditCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->EditValue = FormatNumber($this->po->EditValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";

		// partner_id
		$this->partner_id->EditAttrs["class"] = "form-control";
		$this->partner_id->EditCustomAttributes = "";
		$this->partner_id->EditValue = $this->partner_id->CurrentValue;
		$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";

		// cart_id
		$this->cart_id->EditCustomAttributes = "";

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = 'ReadOnly';
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = 'ReadOnly';
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
		if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
			$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, -2);

		// amount
		$this->amount->EditAttrs["class"] = "form-control";
		$this->amount->EditCustomAttributes = 'ReadOnly';
		if (REMOVE_XSS)
			$this->amount->CurrentValue = HtmlDecode($this->amount->CurrentValue);
		$this->amount->EditValue = $this->amount->CurrentValue;
		$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

		// cbm
		$this->cbm->EditAttrs["class"] = "form-control";
		$this->cbm->EditCustomAttributes = 'ReadOnly';
		$this->cbm->EditValue = $this->cbm->CurrentValue;
		$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
		if (strval($this->cbm->EditValue) <> "" && is_numeric($this->cbm->EditValue))
			$this->cbm->EditValue = FormatNumber($this->cbm->EditValue, -2, -2, -2, -2);

		// gst
		$this->gst->EditAttrs["class"] = "form-control";
		$this->gst->EditCustomAttributes = "";

		// partner_order_no
		$this->partner_order_no->EditAttrs["class"] = "form-control";
		$this->partner_order_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->partner_order_no->CurrentValue = HtmlDecode($this->partner_order_no->CurrentValue);
		$this->partner_order_no->EditValue = $this->partner_order_no->CurrentValue;
		$this->partner_order_no->PlaceHolder = RemoveHtml($this->partner_order_no->caption());

		// partner_order_date
		$this->partner_order_date->EditAttrs["class"] = "form-control";
		$this->partner_order_date->EditCustomAttributes = "";
		$this->partner_order_date->EditValue = FormatDateTime($this->partner_order_date->CurrentValue, 8);
		$this->partner_order_date->PlaceHolder = RemoveHtml($this->partner_order_date->caption());

		// despatch_date
		$this->despatch_date->EditAttrs["class"] = "form-control";
		$this->despatch_date->EditCustomAttributes = "";
		$this->despatch_date->EditValue = FormatDateTime($this->despatch_date->CurrentValue, 8);
		$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

		// despatch_week
		$this->despatch_week->EditAttrs["class"] = "form-control";
		$this->despatch_week->EditCustomAttributes = "";

		// fob_date
		$this->fob_date->EditAttrs["class"] = "form-control";
		$this->fob_date->EditCustomAttributes = "";
		$this->fob_date->EditValue = FormatDateTime($this->fob_date->CurrentValue, 8);
		$this->fob_date->PlaceHolder = RemoveHtml($this->fob_date->caption());

		// production_plan
		$this->production_plan->EditAttrs["class"] = "form-control";
		$this->production_plan->EditCustomAttributes = "";

		// part_dispatch
		$this->part_dispatch->EditAttrs["class"] = "form-control";
		$this->part_dispatch->EditCustomAttributes = "";
		$this->part_dispatch->EditValue = $this->part_dispatch->options(TRUE);

		// payment_terms
		$this->payment_terms->EditAttrs["class"] = "form-control";
		$this->payment_terms->EditCustomAttributes = "";

		// transport_type
		$this->transport_type->EditAttrs["class"] = "form-control";
		$this->transport_type->EditCustomAttributes = "";

		// partner_shipping_id
		$this->partner_shipping_id->EditAttrs["class"] = "form-control";
		$this->partner_shipping_id->EditCustomAttributes = "";

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// buyer_instruction
		$this->buyer_instruction->EditAttrs["class"] = "form-control";
		$this->buyer_instruction->EditCustomAttributes = "";
		$this->buyer_instruction->EditValue = $this->buyer_instruction->CurrentValue;
		$this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

		// uploads
		$this->uploads->EditAttrs["class"] = "form-control";
		$this->uploads->EditCustomAttributes = "";
		$this->uploads->UploadPath = '/.p_uploads/sppo/' . $this->id->CurrentValue . '/' ;
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->ImageWidth = 0;
			$this->uploads->ImageHeight = 50;
			$this->uploads->ImageAlt = $this->uploads->alt();
			$this->uploads->EditValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->EditValue = "";
		}
		if (!EmptyValue($this->uploads->CurrentValue))
				$this->uploads->Upload->FileName = $this->uploads->CurrentValue;

		// description_01
		$this->description_01->EditAttrs["class"] = "form-control";
		$this->description_01->EditCustomAttributes = "";
		$this->description_01->EditValue = $this->description_01->CurrentValue;
		$this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());
		if (strval($this->description_01->EditValue) <> "" && is_numeric($this->description_01->EditValue))
			$this->description_01->EditValue = FormatNumber($this->description_01->EditValue, -2, -2, -2, -2);

		// description_02
		$this->description_02->EditAttrs["class"] = "form-control";
		$this->description_02->EditCustomAttributes = "";
		$this->description_02->EditValue = $this->description_02->CurrentValue;
		$this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());
		if (strval($this->description_02->EditValue) <> "" && is_numeric($this->description_02->EditValue))
			$this->description_02->EditValue = FormatNumber($this->description_02->EditValue, -2, -2, -2, -2);

		// description_03
		$this->description_03->EditAttrs["class"] = "form-control";
		$this->description_03->EditCustomAttributes = "";
		$this->description_03->EditValue = $this->description_03->options(TRUE);

		// description_04
		$this->description_04->EditAttrs["class"] = "form-control";
		$this->description_04->EditCustomAttributes = "";
		$this->description_04->EditValue = $this->description_04->options(TRUE);

		// description_05
		$this->description_05->EditAttrs["class"] = "form-control";
		$this->description_05->EditCustomAttributes = "";

		// description_06
		$this->description_06->EditAttrs["class"] = "form-control";
		$this->description_06->EditCustomAttributes = "";

		// description_07
		$this->description_07->EditAttrs["class"] = "form-control";
		$this->description_07->EditCustomAttributes = "";
		$this->description_07->EditValue = $this->description_07->CurrentValue;
		$this->description_07->PlaceHolder = RemoveHtml($this->description_07->caption());

		// description_08
		$this->description_08->EditAttrs["class"] = "form-control";
		$this->description_08->EditCustomAttributes = "";
		$this->description_08->EditValue = $this->description_08->CurrentValue;
		$this->description_08->PlaceHolder = RemoveHtml($this->description_08->caption());

		// description_17
		$this->description_17->EditAttrs["class"] = "form-control";
		$this->description_17->EditCustomAttributes = 'ReadOnly';
		$this->description_17->EditValue = $this->description_17->CurrentValue;
		$this->description_17->PlaceHolder = RemoveHtml($this->description_17->caption());
		if (strval($this->description_17->EditValue) <> "" && is_numeric($this->description_17->EditValue))
			$this->description_17->EditValue = FormatNumber($this->description_17->EditValue, -2, -2, -2, -2);

		// description_18
		$this->description_18->EditAttrs["class"] = "form-control";
		$this->description_18->EditCustomAttributes = 'ReadOnly';
		$this->description_18->EditValue = $this->description_18->CurrentValue;
		$this->description_18->PlaceHolder = RemoveHtml($this->description_18->caption());
		if (strval($this->description_18->EditValue) <> "" && is_numeric($this->description_18->EditValue))
			$this->description_18->EditValue = FormatNumber($this->description_18->EditValue, -2, -2, -2, -2);

		// description_19
		$this->description_19->EditAttrs["class"] = "form-control";
		$this->description_19->EditCustomAttributes = 'ReadOnly';
		$this->description_19->EditValue = $this->description_19->CurrentValue;
		$this->description_19->PlaceHolder = RemoveHtml($this->description_19->caption());
		if (strval($this->description_19->EditValue) <> "" && is_numeric($this->description_19->EditValue))
			$this->description_19->EditValue = FormatNumber($this->description_19->EditValue, -2, -2, -2, -2);

		// description_20
		$this->description_20->EditAttrs["class"] = "form-control";
		$this->description_20->EditCustomAttributes = "";
		$this->description_20->EditValue = $this->description_20->options(TRUE);

		// d_09_head
		$this->d_09_head->EditAttrs["class"] = "form-control";
		$this->d_09_head->EditCustomAttributes = "";

		// description_09
		$this->description_09->EditAttrs["class"] = "form-control";
		$this->description_09->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->description_09->CurrentValue = HtmlDecode($this->description_09->CurrentValue);
		$this->description_09->EditValue = $this->description_09->CurrentValue;
		$this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

		// d_10_head
		$this->d_10_head->EditAttrs["class"] = "form-control";
		$this->d_10_head->EditCustomAttributes = "";

		// description_10
		$this->description_10->EditAttrs["class"] = "form-control";
		$this->description_10->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->description_10->CurrentValue = HtmlDecode($this->description_10->CurrentValue);
		$this->description_10->EditValue = $this->description_10->CurrentValue;
		$this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());

		// d_11_head
		$this->d_11_head->EditAttrs["class"] = "form-control";
		$this->d_11_head->EditCustomAttributes = "";

		// description_11
		$this->description_11->EditAttrs["class"] = "form-control";
		$this->description_11->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->description_11->CurrentValue = HtmlDecode($this->description_11->CurrentValue);
		$this->description_11->EditValue = $this->description_11->CurrentValue;
		$this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

		// d_12_head
		$this->d_12_head->EditAttrs["class"] = "form-control";
		$this->d_12_head->EditCustomAttributes = "";

		// description_12
		$this->description_12->EditAttrs["class"] = "form-control";
		$this->description_12->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->description_12->CurrentValue = HtmlDecode($this->description_12->CurrentValue);
		$this->description_12->EditValue = $this->description_12->CurrentValue;
		$this->description_12->PlaceHolder = RemoveHtml($this->description_12->caption());

		// production_site
		$this->production_site->EditAttrs["class"] = "form-control";
		$this->production_site->EditCustomAttributes = "";
		$curVal = strval($this->production_site->CurrentValue);
		if ($curVal <> "") {
			$this->production_site->EditValue = $this->production_site->lookupCacheOption($curVal);
			if ($this->production_site->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` IN (0,3)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->production_site->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->production_site->EditValue = $this->production_site->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->production_site->EditValue = $this->production_site->CurrentValue;
				}
			}
		} else {
			$this->production_site->EditValue = NULL;
		}
		$this->production_site->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->EditAttrs["class"] = "form-control";
		$this->jc_no->EditCustomAttributes = "";
		$this->jc_no->EditValue = $this->jc_no->CurrentValue;
		$this->jc_no->ViewCustomAttributes = "";

		// request
		$this->__request->EditAttrs["class"] = "form-control";
		$this->__request->EditCustomAttributes = "";
		$this->__request->EditValue = $this->__request->CurrentValue;
		$this->__request->PlaceHolder = RemoveHtml($this->__request->caption());

		// balance_quantity
		$this->balance_quantity->EditAttrs["class"] = "form-control";
		$this->balance_quantity->EditCustomAttributes = "";
		$this->balance_quantity->EditValue = $this->balance_quantity->CurrentValue;
		$this->balance_quantity->EditValue = FormatNumber($this->balance_quantity->EditValue, 2, -2, -2, -2);
		$this->balance_quantity->ViewCustomAttributes = "";

		// e_mail
		$this->e_mail->EditAttrs["class"] = "form-control";
		$this->e_mail->EditCustomAttributes = "";
		$this->e_mail->EditValue = $this->e_mail->CurrentValue;
		$this->e_mail->EditValue = FormatNumber($this->e_mail->EditValue, 0, -2, -2, -2);
		$this->e_mail->ViewCustomAttributes = "";

		// billing_address_id
		$this->billing_address_id->EditAttrs["class"] = "form-control";
		$this->billing_address_id->EditCustomAttributes = "";
		$this->billing_address_id->EditValue = $this->billing_address_id->CurrentValue;
		$this->billing_address_id->EditValue = FormatNumber($this->billing_address_id->EditValue, 0, -2, -2, -2);
		$this->billing_address_id->ViewCustomAttributes = "";

		// shipping_address_id
		$this->shipping_address_id->EditAttrs["class"] = "form-control";
		$this->shipping_address_id->EditCustomAttributes = "";
		$this->shipping_address_id->EditValue = $this->shipping_address_id->CurrentValue;
		$this->shipping_address_id->EditValue = FormatNumber($this->shipping_address_id->EditValue, 0, -2, -2, -2);
		$this->shipping_address_id->ViewCustomAttributes = "";

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->EditValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// operator
		// datetime
		// a_operator
		// a_datetime
		// c_operator
		// c_datetime

		$this->c_datetime->EditAttrs["class"] = "form-control";
		$this->c_datetime->EditCustomAttributes = "";
		$this->c_datetime->EditValue = FormatDateTime($this->c_datetime->CurrentValue, 11);
		$this->c_datetime->PlaceHolder = RemoveHtml($this->c_datetime->caption());

		// app_operator
		$this->app_operator->EditAttrs["class"] = "form-control";
		$this->app_operator->EditCustomAttributes = "";

		// app_datetime
		$this->app_datetime->EditAttrs["class"] = "form-control";
		$this->app_datetime->EditCustomAttributes = "";
		$this->app_datetime->EditValue = FormatDateTime($this->app_datetime->CurrentValue, 11);
		$this->app_datetime->PlaceHolder = RemoveHtml($this->app_datetime->caption());

		// reports_to
		$this->reports_to->EditAttrs["class"] = "form-control";
		$this->reports_to->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->reports_to->CurrentValue = HtmlDecode($this->reports_to->CurrentValue);
		$this->reports_to->EditValue = $this->reports_to->CurrentValue;
		$this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

		// grp_type
		$this->grp_type->EditAttrs["class"] = "form-control";
		$this->grp_type->EditCustomAttributes = "";
		$this->grp_type->EditValue = $this->grp_type->CurrentValue;
		$this->grp_type->PlaceHolder = RemoveHtml($this->grp_type->caption());

		// order_file
		$this->order_file->EditAttrs["class"] = "form-control";
		$this->order_file->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->order_file->CurrentValue = HtmlDecode($this->order_file->CurrentValue);
		$this->order_file->EditValue = $this->order_file->CurrentValue;
		$this->order_file->PlaceHolder = RemoveHtml($this->order_file->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->cart_id);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->gst);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->fob_date);
					$doc->exportCaption($this->production_plan);
					$doc->exportCaption($this->part_dispatch);
					$doc->exportCaption($this->payment_terms);
					$doc->exportCaption($this->transport_type);
					$doc->exportCaption($this->partner_shipping_id);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->buyer_instruction);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->a_datetime);
					$doc->exportCaption($this->app_operator);
					$doc->exportCaption($this->app_datetime);
					$doc->exportCaption($this->order_file);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->cart_id);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->gst);
					$doc->exportCaption($this->partner_order_no);
					$doc->exportCaption($this->partner_order_date);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->fob_date);
					$doc->exportCaption($this->production_plan);
					$doc->exportCaption($this->part_dispatch);
					$doc->exportCaption($this->payment_terms);
					$doc->exportCaption($this->transport_type);
					$doc->exportCaption($this->partner_shipping_id);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->buyer_instruction);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->a_datetime);
					$doc->exportCaption($this->app_operator);
					$doc->exportCaption($this->app_datetime);
					$doc->exportCaption($this->order_file);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->po);
						$doc->exportField($this->company_id);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->cart_id);
						$doc->exportField($this->quantity);
						$doc->exportField($this->sqm);
						$doc->exportField($this->amount);
						$doc->exportField($this->cbm);
						$doc->exportField($this->gst);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->fob_date);
						$doc->exportField($this->production_plan);
						$doc->exportField($this->part_dispatch);
						$doc->exportField($this->payment_terms);
						$doc->exportField($this->transport_type);
						$doc->exportField($this->partner_shipping_id);
						$doc->exportField($this->remarks);
						$doc->exportField($this->buyer_instruction);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->a_datetime);
						$doc->exportField($this->app_operator);
						$doc->exportField($this->app_datetime);
						$doc->exportField($this->order_file);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->po);
						$doc->exportField($this->company_id);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->cart_id);
						$doc->exportField($this->quantity);
						$doc->exportField($this->sqm);
						$doc->exportField($this->amount);
						$doc->exportField($this->cbm);
						$doc->exportField($this->gst);
						$doc->exportField($this->partner_order_no);
						$doc->exportField($this->partner_order_date);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->fob_date);
						$doc->exportField($this->production_plan);
						$doc->exportField($this->part_dispatch);
						$doc->exportField($this->payment_terms);
						$doc->exportField($this->transport_type);
						$doc->exportField($this->partner_shipping_id);
						$doc->exportField($this->remarks);
						$doc->exportField($this->buyer_instruction);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->a_datetime);
						$doc->exportField($this->app_operator);
						$doc->exportField($this->app_datetime);
						$doc->exportField($this->order_file);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'uploads') {
			$fldName = "uploads";
			$fileNameFld = "uploads";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'po_b';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'po_b';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'po_b';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'po_b';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>