<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class po_b_wbc_list extends po_b_wbc
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'po_b_wbc';

	// Page object name
	public $PageObjName = "po_b_wbc_list";

	// Grid form hidden field names
	public $FormName = "fpo_b_wbclist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (po_b_wbc)
		if (!isset($GLOBALS["po_b_wbc"]) || get_class($GLOBALS["po_b_wbc"]) == PROJECT_NAMESPACE . "po_b_wbc") {
			$GLOBALS["po_b_wbc"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["po_b_wbc"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "po_b_wbcadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "po_b_wbcdelete.php";
		$this->MultiUpdateUrl = "po_b_wbcupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_b_wbc');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fpo_b_wbclistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $po_b_wbc;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($po_b_wbc);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->a_operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->a_datetime->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->c_operator->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->company_id->setVisibility();
		$this->grp->Visible = FALSE;
		$this->reports_to->Visible = FALSE;
		$this->s_grp->Visible = FALSE;
		$this->location->Visible = FALSE;
		$this->po->setVisibility();
		$this->partner_id->setVisibility();
		$this->cart_id->Visible = FALSE;
		$this->sqm->setVisibility();
		$this->quantity->setVisibility();
		$this->amount->setVisibility();
		$this->cbm->setVisibility();
		$this->gst->setVisibility();
		$this->partner_order_no->setVisibility();
		$this->partner_order_date->Visible = FALSE;
		$this->despatch_date->setVisibility();
		$this->despatch_week->setVisibility();
		$this->fob_date->setVisibility();
		$this->production_plan->Visible = FALSE;
		$this->part_dispatch->Visible = FALSE;
		$this->payment_terms->setVisibility();
		$this->transport_type->setVisibility();
		$this->partner_shipping_id->setVisibility();
		$this->remarks->Visible = FALSE;
		$this->buyer_instruction->Visible = FALSE;
		$this->uploads->setVisibility();
		$this->description_01->Visible = FALSE;
		$this->description_02->Visible = FALSE;
		$this->description_03->Visible = FALSE;
		$this->description_04->Visible = FALSE;
		$this->description_05->Visible = FALSE;
		$this->description_06->Visible = FALSE;
		$this->description_07->Visible = FALSE;
		$this->description_08->Visible = FALSE;
		$this->d_09_head->Visible = FALSE;
		$this->description_09->Visible = FALSE;
		$this->d_10_head->Visible = FALSE;
		$this->description_10->Visible = FALSE;
		$this->d_11_head->Visible = FALSE;
		$this->description_11->Visible = FALSE;
		$this->d_12_head->Visible = FALSE;
		$this->description_12->Visible = FALSE;
		$this->description_17->Visible = FALSE;
		$this->description_18->Visible = FALSE;
		$this->description_19->Visible = FALSE;
		$this->description_20->Visible = FALSE;
		$this->production_site->Visible = FALSE;
		$this->jc_no->Visible = FALSE;
		$this->__request->Visible = FALSE;
		$this->balance_quantity->Visible = FALSE;
		$this->operator->setVisibility();
		$this->e_mail->Visible = FALSE;
		$this->billing_address_id->Visible = FALSE;
		$this->shipping_address_id->Visible = FALSE;
		$this->status->Visible = FALSE;
		$this->datetime->setVisibility();
		$this->a_operator->setVisibility();
		$this->a_datetime->setVisibility();
		$this->app_operator->setVisibility();
		$this->app_datetime->setVisibility();
		$this->c_operator->Visible = FALSE;
		$this->c_datetime->Visible = FALSE;
		$this->grp_type->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->cart_id);
		$this->setupLookupOptions($this->gst);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->production_plan);
		$this->setupLookupOptions($this->payment_terms);
		$this->setupLookupOptions($this->transport_type);
		$this->setupLookupOptions($this->partner_shipping_id);
		$this->setupLookupOptions($this->description_05);
		$this->setupLookupOptions($this->description_06);
		$this->setupLookupOptions($this->d_09_head);
		$this->setupLookupOptions($this->d_10_head);
		$this->setupLookupOptions($this->d_11_head);
		$this->setupLookupOptions($this->d_12_head);
		$this->setupLookupOptions($this->production_site);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->a_operator);
		$this->setupLookupOptions($this->app_operator);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}

			// Audit trail on search
			if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
				$searchParm = ServerVar("QUERY_STRING");
				$searchSql = $this->getSessionWhere();
				$this->writeAuditTrailOnSearch($searchParm, $searchSql);
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fpo_b_wbclistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->company_id->AdvancedSearch->toJson(), ","); // Field company_id
		$filterList = Concat($filterList, $this->po->AdvancedSearch->toJson(), ","); // Field po
		$filterList = Concat($filterList, $this->partner_id->AdvancedSearch->toJson(), ","); // Field partner_id
		$filterList = Concat($filterList, $this->cart_id->AdvancedSearch->toJson(), ","); // Field cart_id
		$filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
		$filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
		$filterList = Concat($filterList, $this->amount->AdvancedSearch->toJson(), ","); // Field amount
		$filterList = Concat($filterList, $this->cbm->AdvancedSearch->toJson(), ","); // Field cbm
		$filterList = Concat($filterList, $this->gst->AdvancedSearch->toJson(), ","); // Field gst
		$filterList = Concat($filterList, $this->partner_order_no->AdvancedSearch->toJson(), ","); // Field partner_order_no
		$filterList = Concat($filterList, $this->despatch_week->AdvancedSearch->toJson(), ","); // Field despatch_week
		$filterList = Concat($filterList, $this->payment_terms->AdvancedSearch->toJson(), ","); // Field payment_terms
		$filterList = Concat($filterList, $this->transport_type->AdvancedSearch->toJson(), ","); // Field transport_type
		$filterList = Concat($filterList, $this->partner_shipping_id->AdvancedSearch->toJson(), ","); // Field partner_shipping_id
		$filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
		$filterList = Concat($filterList, $this->buyer_instruction->AdvancedSearch->toJson(), ","); // Field buyer_instruction
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fpo_b_wbclistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field company_id
		$this->company_id->AdvancedSearch->SearchValue = @$filter["x_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator = @$filter["z_company_id"];
		$this->company_id->AdvancedSearch->SearchCondition = @$filter["v_company_id"];
		$this->company_id->AdvancedSearch->SearchValue2 = @$filter["y_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator2 = @$filter["w_company_id"];
		$this->company_id->AdvancedSearch->save();

		// Field po
		$this->po->AdvancedSearch->SearchValue = @$filter["x_po"];
		$this->po->AdvancedSearch->SearchOperator = @$filter["z_po"];
		$this->po->AdvancedSearch->SearchCondition = @$filter["v_po"];
		$this->po->AdvancedSearch->SearchValue2 = @$filter["y_po"];
		$this->po->AdvancedSearch->SearchOperator2 = @$filter["w_po"];
		$this->po->AdvancedSearch->save();

		// Field partner_id
		$this->partner_id->AdvancedSearch->SearchValue = @$filter["x_partner_id"];
		$this->partner_id->AdvancedSearch->SearchOperator = @$filter["z_partner_id"];
		$this->partner_id->AdvancedSearch->SearchCondition = @$filter["v_partner_id"];
		$this->partner_id->AdvancedSearch->SearchValue2 = @$filter["y_partner_id"];
		$this->partner_id->AdvancedSearch->SearchOperator2 = @$filter["w_partner_id"];
		$this->partner_id->AdvancedSearch->save();

		// Field cart_id
		$this->cart_id->AdvancedSearch->SearchValue = @$filter["x_cart_id"];
		$this->cart_id->AdvancedSearch->SearchOperator = @$filter["z_cart_id"];
		$this->cart_id->AdvancedSearch->SearchCondition = @$filter["v_cart_id"];
		$this->cart_id->AdvancedSearch->SearchValue2 = @$filter["y_cart_id"];
		$this->cart_id->AdvancedSearch->SearchOperator2 = @$filter["w_cart_id"];
		$this->cart_id->AdvancedSearch->save();

		// Field sqm
		$this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
		$this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
		$this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
		$this->sqm->AdvancedSearch->save();

		// Field quantity
		$this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
		$this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
		$this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
		$this->quantity->AdvancedSearch->save();

		// Field amount
		$this->amount->AdvancedSearch->SearchValue = @$filter["x_amount"];
		$this->amount->AdvancedSearch->SearchOperator = @$filter["z_amount"];
		$this->amount->AdvancedSearch->SearchCondition = @$filter["v_amount"];
		$this->amount->AdvancedSearch->SearchValue2 = @$filter["y_amount"];
		$this->amount->AdvancedSearch->SearchOperator2 = @$filter["w_amount"];
		$this->amount->AdvancedSearch->save();

		// Field cbm
		$this->cbm->AdvancedSearch->SearchValue = @$filter["x_cbm"];
		$this->cbm->AdvancedSearch->SearchOperator = @$filter["z_cbm"];
		$this->cbm->AdvancedSearch->SearchCondition = @$filter["v_cbm"];
		$this->cbm->AdvancedSearch->SearchValue2 = @$filter["y_cbm"];
		$this->cbm->AdvancedSearch->SearchOperator2 = @$filter["w_cbm"];
		$this->cbm->AdvancedSearch->save();

		// Field gst
		$this->gst->AdvancedSearch->SearchValue = @$filter["x_gst"];
		$this->gst->AdvancedSearch->SearchOperator = @$filter["z_gst"];
		$this->gst->AdvancedSearch->SearchCondition = @$filter["v_gst"];
		$this->gst->AdvancedSearch->SearchValue2 = @$filter["y_gst"];
		$this->gst->AdvancedSearch->SearchOperator2 = @$filter["w_gst"];
		$this->gst->AdvancedSearch->save();

		// Field partner_order_no
		$this->partner_order_no->AdvancedSearch->SearchValue = @$filter["x_partner_order_no"];
		$this->partner_order_no->AdvancedSearch->SearchOperator = @$filter["z_partner_order_no"];
		$this->partner_order_no->AdvancedSearch->SearchCondition = @$filter["v_partner_order_no"];
		$this->partner_order_no->AdvancedSearch->SearchValue2 = @$filter["y_partner_order_no"];
		$this->partner_order_no->AdvancedSearch->SearchOperator2 = @$filter["w_partner_order_no"];
		$this->partner_order_no->AdvancedSearch->save();

		// Field despatch_week
		$this->despatch_week->AdvancedSearch->SearchValue = @$filter["x_despatch_week"];
		$this->despatch_week->AdvancedSearch->SearchOperator = @$filter["z_despatch_week"];
		$this->despatch_week->AdvancedSearch->SearchCondition = @$filter["v_despatch_week"];
		$this->despatch_week->AdvancedSearch->SearchValue2 = @$filter["y_despatch_week"];
		$this->despatch_week->AdvancedSearch->SearchOperator2 = @$filter["w_despatch_week"];
		$this->despatch_week->AdvancedSearch->save();

		// Field payment_terms
		$this->payment_terms->AdvancedSearch->SearchValue = @$filter["x_payment_terms"];
		$this->payment_terms->AdvancedSearch->SearchOperator = @$filter["z_payment_terms"];
		$this->payment_terms->AdvancedSearch->SearchCondition = @$filter["v_payment_terms"];
		$this->payment_terms->AdvancedSearch->SearchValue2 = @$filter["y_payment_terms"];
		$this->payment_terms->AdvancedSearch->SearchOperator2 = @$filter["w_payment_terms"];
		$this->payment_terms->AdvancedSearch->save();

		// Field transport_type
		$this->transport_type->AdvancedSearch->SearchValue = @$filter["x_transport_type"];
		$this->transport_type->AdvancedSearch->SearchOperator = @$filter["z_transport_type"];
		$this->transport_type->AdvancedSearch->SearchCondition = @$filter["v_transport_type"];
		$this->transport_type->AdvancedSearch->SearchValue2 = @$filter["y_transport_type"];
		$this->transport_type->AdvancedSearch->SearchOperator2 = @$filter["w_transport_type"];
		$this->transport_type->AdvancedSearch->save();

		// Field partner_shipping_id
		$this->partner_shipping_id->AdvancedSearch->SearchValue = @$filter["x_partner_shipping_id"];
		$this->partner_shipping_id->AdvancedSearch->SearchOperator = @$filter["z_partner_shipping_id"];
		$this->partner_shipping_id->AdvancedSearch->SearchCondition = @$filter["v_partner_shipping_id"];
		$this->partner_shipping_id->AdvancedSearch->SearchValue2 = @$filter["y_partner_shipping_id"];
		$this->partner_shipping_id->AdvancedSearch->SearchOperator2 = @$filter["w_partner_shipping_id"];
		$this->partner_shipping_id->AdvancedSearch->save();

		// Field remarks
		$this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
		$this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
		$this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
		$this->remarks->AdvancedSearch->save();

		// Field buyer_instruction
		$this->buyer_instruction->AdvancedSearch->SearchValue = @$filter["x_buyer_instruction"];
		$this->buyer_instruction->AdvancedSearch->SearchOperator = @$filter["z_buyer_instruction"];
		$this->buyer_instruction->AdvancedSearch->SearchCondition = @$filter["v_buyer_instruction"];
		$this->buyer_instruction->AdvancedSearch->SearchValue2 = @$filter["y_buyer_instruction"];
		$this->buyer_instruction->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_instruction"];
		$this->buyer_instruction->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->company_id, $default, FALSE); // company_id
		$this->buildSearchSql($where, $this->po, $default, FALSE); // po
		$this->buildSearchSql($where, $this->partner_id, $default, FALSE); // partner_id
		$this->buildSearchSql($where, $this->cart_id, $default, TRUE); // cart_id
		$this->buildSearchSql($where, $this->sqm, $default, FALSE); // sqm
		$this->buildSearchSql($where, $this->quantity, $default, FALSE); // quantity
		$this->buildSearchSql($where, $this->amount, $default, FALSE); // amount
		$this->buildSearchSql($where, $this->cbm, $default, FALSE); // cbm
		$this->buildSearchSql($where, $this->gst, $default, FALSE); // gst
		$this->buildSearchSql($where, $this->partner_order_no, $default, FALSE); // partner_order_no
		$this->buildSearchSql($where, $this->despatch_week, $default, FALSE); // despatch_week
		$this->buildSearchSql($where, $this->payment_terms, $default, FALSE); // payment_terms
		$this->buildSearchSql($where, $this->transport_type, $default, FALSE); // transport_type
		$this->buildSearchSql($where, $this->partner_shipping_id, $default, FALSE); // partner_shipping_id
		$this->buildSearchSql($where, $this->remarks, $default, FALSE); // remarks
		$this->buildSearchSql($where, $this->buyer_instruction, $default, FALSE); // buyer_instruction

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->company_id->AdvancedSearch->save(); // company_id
			$this->po->AdvancedSearch->save(); // po
			$this->partner_id->AdvancedSearch->save(); // partner_id
			$this->cart_id->AdvancedSearch->save(); // cart_id
			$this->sqm->AdvancedSearch->save(); // sqm
			$this->quantity->AdvancedSearch->save(); // quantity
			$this->amount->AdvancedSearch->save(); // amount
			$this->cbm->AdvancedSearch->save(); // cbm
			$this->gst->AdvancedSearch->save(); // gst
			$this->partner_order_no->AdvancedSearch->save(); // partner_order_no
			$this->despatch_week->AdvancedSearch->save(); // despatch_week
			$this->payment_terms->AdvancedSearch->save(); // payment_terms
			$this->transport_type->AdvancedSearch->save(); // transport_type
			$this->partner_shipping_id->AdvancedSearch->save(); // partner_shipping_id
			$this->remarks->AdvancedSearch->save(); // remarks
			$this->buyer_instruction->AdvancedSearch->save(); // buyer_instruction
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->company_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->s_grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->location, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->partner_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->cart_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->sqm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->quantity, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->amount, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->cbm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->gst, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->partner_order_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->partner_order_date, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->despatch_date, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->despatch_week, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->fob_date, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->production_plan, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->part_dispatch, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->payment_terms, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->transport_type, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->partner_shipping_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->remarks, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_instruction, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->uploads, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_02, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_03, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_04, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_05, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_06, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_07, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_08, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->d_09_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_09, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->d_10_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_10, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->d_11_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_11, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->d_12_head, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_12, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_17, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_18, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_19, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_20, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->production_site, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->jc_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->__request, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->balance_quantity, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->operator, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->e_mail, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->billing_address_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->shipping_address_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->status, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->datetime, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->a_operator, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->a_datetime, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->app_operator, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->app_datetime, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->c_operator, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->c_datetime, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->company_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->partner_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cart_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sqm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->quantity->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cbm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->gst->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->partner_order_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->despatch_week->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->payment_terms->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->transport_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->partner_shipping_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->remarks->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_instruction->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->company_id->AdvancedSearch->unsetSession();
		$this->po->AdvancedSearch->unsetSession();
		$this->partner_id->AdvancedSearch->unsetSession();
		$this->cart_id->AdvancedSearch->unsetSession();
		$this->sqm->AdvancedSearch->unsetSession();
		$this->quantity->AdvancedSearch->unsetSession();
		$this->amount->AdvancedSearch->unsetSession();
		$this->cbm->AdvancedSearch->unsetSession();
		$this->gst->AdvancedSearch->unsetSession();
		$this->partner_order_no->AdvancedSearch->unsetSession();
		$this->despatch_week->AdvancedSearch->unsetSession();
		$this->payment_terms->AdvancedSearch->unsetSession();
		$this->transport_type->AdvancedSearch->unsetSession();
		$this->partner_shipping_id->AdvancedSearch->unsetSession();
		$this->remarks->AdvancedSearch->unsetSession();
		$this->buyer_instruction->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->partner_id->AdvancedSearch->load();
		$this->cart_id->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->gst->AdvancedSearch->load();
		$this->partner_order_no->AdvancedSearch->load();
		$this->despatch_week->AdvancedSearch->load();
		$this->payment_terms->AdvancedSearch->load();
		$this->transport_type->AdvancedSearch->load();
		$this->partner_shipping_id->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->buyer_instruction->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->company_id, $ctrl); // company_id
			$this->updateSort($this->po, $ctrl); // po
			$this->updateSort($this->partner_id, $ctrl); // partner_id
			$this->updateSort($this->sqm, $ctrl); // sqm
			$this->updateSort($this->quantity, $ctrl); // quantity
			$this->updateSort($this->amount, $ctrl); // amount
			$this->updateSort($this->cbm, $ctrl); // cbm
			$this->updateSort($this->gst, $ctrl); // gst
			$this->updateSort($this->partner_order_no, $ctrl); // partner_order_no
			$this->updateSort($this->despatch_date, $ctrl); // despatch_date
			$this->updateSort($this->despatch_week, $ctrl); // despatch_week
			$this->updateSort($this->fob_date, $ctrl); // fob_date
			$this->updateSort($this->payment_terms, $ctrl); // payment_terms
			$this->updateSort($this->transport_type, $ctrl); // transport_type
			$this->updateSort($this->partner_shipping_id, $ctrl); // partner_shipping_id
			$this->updateSort($this->uploads, $ctrl); // uploads
			$this->updateSort($this->operator, $ctrl); // operator
			$this->updateSort($this->datetime, $ctrl); // datetime
			$this->updateSort($this->a_operator, $ctrl); // a_operator
			$this->updateSort($this->a_datetime, $ctrl); // a_datetime
			$this->updateSort($this->app_operator, $ctrl); // app_operator
			$this->updateSort($this->app_datetime, $ctrl); // app_datetime
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
				$this->id->setSort("");
				$this->company_id->setSort("");
				$this->po->setSort("");
				$this->partner_id->setSort("");
				$this->sqm->setSort("");
				$this->quantity->setSort("");
				$this->amount->setSort("");
				$this->cbm->setSort("");
				$this->gst->setSort("");
				$this->partner_order_no->setSort("");
				$this->despatch_date->setSort("");
				$this->despatch_week->setSort("");
				$this->fob_date->setSort("");
				$this->payment_terms->setSort("");
				$this->transport_type->setSort("");
				$this->partner_shipping_id->setSort("");
				$this->uploads->setSort("");
				$this->operator->setSort("");
				$this->datetime->setSort("");
				$this->a_operator->setSort("");
				$this->a_datetime->setSort("");
				$this->app_operator->setSort("");
				$this->app_datetime->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canAdd();
		$item->OnLeft = TRUE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canDelete();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = &$this->ListOptions->Items["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->canAdd()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = &$this->ListOptions->Items["delete"];
		if ($Security->canDelete())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fpo_b_wbclistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fpo_b_wbclistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fpo_b_wbclist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fpo_b_wbclistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"po_b_wbcsrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"po_b_wbc\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'po_b_wbcsrch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fpo_b_wbclistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// company_id
		if (!$this->isAddOrEdit())
			$this->company_id->AdvancedSearch->setSearchValue(Get("x_company_id", Get("company_id", "")));
		if ($this->company_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->company_id->AdvancedSearch->setSearchOperator(Get("z_company_id", ""));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue(Get("x_po", Get("po", "")));
		if ($this->po->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po->AdvancedSearch->setSearchOperator(Get("z_po", ""));

		// partner_id
		if (!$this->isAddOrEdit())
			$this->partner_id->AdvancedSearch->setSearchValue(Get("x_partner_id", Get("partner_id", "")));
		if ($this->partner_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->partner_id->AdvancedSearch->setSearchOperator(Get("z_partner_id", ""));

		// cart_id
		if (!$this->isAddOrEdit())
			$this->cart_id->AdvancedSearch->setSearchValue(Get("x_cart_id", Get("cart_id", "")));
		if ($this->cart_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cart_id->AdvancedSearch->setSearchOperator(Get("z_cart_id", ""));
		if (is_array($this->cart_id->AdvancedSearch->SearchValue))
			$this->cart_id->AdvancedSearch->SearchValue = implode(",", $this->cart_id->AdvancedSearch->SearchValue);
		if (is_array($this->cart_id->AdvancedSearch->SearchValue2))
			$this->cart_id->AdvancedSearch->SearchValue2 = implode(",", $this->cart_id->AdvancedSearch->SearchValue2);

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue(Get("x_sqm", Get("sqm", "")));
		if ($this->sqm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sqm->AdvancedSearch->setSearchOperator(Get("z_sqm", ""));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue(Get("x_quantity", Get("quantity", "")));
		if ($this->quantity->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->quantity->AdvancedSearch->setSearchOperator(Get("z_quantity", ""));

		// amount
		if (!$this->isAddOrEdit())
			$this->amount->AdvancedSearch->setSearchValue(Get("x_amount", Get("amount", "")));
		if ($this->amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->amount->AdvancedSearch->setSearchOperator(Get("z_amount", ""));

		// cbm
		if (!$this->isAddOrEdit())
			$this->cbm->AdvancedSearch->setSearchValue(Get("x_cbm", Get("cbm", "")));
		if ($this->cbm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cbm->AdvancedSearch->setSearchOperator(Get("z_cbm", ""));

		// gst
		if (!$this->isAddOrEdit())
			$this->gst->AdvancedSearch->setSearchValue(Get("x_gst", Get("gst", "")));
		if ($this->gst->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->gst->AdvancedSearch->setSearchOperator(Get("z_gst", ""));

		// partner_order_no
		if (!$this->isAddOrEdit())
			$this->partner_order_no->AdvancedSearch->setSearchValue(Get("x_partner_order_no", Get("partner_order_no", "")));
		if ($this->partner_order_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->partner_order_no->AdvancedSearch->setSearchOperator(Get("z_partner_order_no", ""));

		// despatch_week
		if (!$this->isAddOrEdit())
			$this->despatch_week->AdvancedSearch->setSearchValue(Get("x_despatch_week", Get("despatch_week", "")));
		if ($this->despatch_week->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->despatch_week->AdvancedSearch->setSearchOperator(Get("z_despatch_week", ""));

		// payment_terms
		if (!$this->isAddOrEdit())
			$this->payment_terms->AdvancedSearch->setSearchValue(Get("x_payment_terms", Get("payment_terms", "")));
		if ($this->payment_terms->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->payment_terms->AdvancedSearch->setSearchOperator(Get("z_payment_terms", ""));

		// transport_type
		if (!$this->isAddOrEdit())
			$this->transport_type->AdvancedSearch->setSearchValue(Get("x_transport_type", Get("transport_type", "")));
		if ($this->transport_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->transport_type->AdvancedSearch->setSearchOperator(Get("z_transport_type", ""));

		// partner_shipping_id
		if (!$this->isAddOrEdit())
			$this->partner_shipping_id->AdvancedSearch->setSearchValue(Get("x_partner_shipping_id", Get("partner_shipping_id", "")));
		if ($this->partner_shipping_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->partner_shipping_id->AdvancedSearch->setSearchOperator(Get("z_partner_shipping_id", ""));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue(Get("x_remarks", Get("remarks", "")));
		if ($this->remarks->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->remarks->AdvancedSearch->setSearchOperator(Get("z_remarks", ""));

		// buyer_instruction
		if (!$this->isAddOrEdit())
			$this->buyer_instruction->AdvancedSearch->setSearchValue(Get("x_buyer_instruction", Get("buyer_instruction", "")));
		if ($this->buyer_instruction->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_instruction->AdvancedSearch->setSearchOperator(Get("z_buyer_instruction", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->company_id->setDbValue($row['company_id']);
		$this->grp->setDbValue($row['grp']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->location->setDbValue($row['location']);
		$this->po->setDbValue($row['po']);
		$this->partner_id->setDbValue($row['partner_id']);
		if (array_key_exists('EV__partner_id', $rs->fields)) {
			$this->partner_id->VirtualValue = $rs->fields('EV__partner_id'); // Set up virtual field value
		} else {
			$this->partner_id->VirtualValue = ""; // Clear value
		}
		$this->cart_id->setDbValue($row['cart_id']);
		$this->sqm->setDbValue($row['sqm']);
		$this->quantity->setDbValue($row['quantity']);
		$this->amount->setDbValue($row['amount']);
		$this->cbm->setDbValue($row['cbm']);
		$this->gst->setDbValue($row['gst']);
		$this->partner_order_no->setDbValue($row['partner_order_no']);
		$this->partner_order_date->setDbValue($row['partner_order_date']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->despatch_week->setDbValue($row['despatch_week']);
		$this->fob_date->setDbValue($row['fob_date']);
		$this->production_plan->setDbValue($row['production_plan']);
		$this->part_dispatch->setDbValue($row['part_dispatch']);
		$this->payment_terms->setDbValue($row['payment_terms']);
		$this->transport_type->setDbValue($row['transport_type']);
		$this->partner_shipping_id->setDbValue($row['partner_shipping_id']);
		$this->remarks->setDbValue($row['remarks']);
		$this->buyer_instruction->setDbValue($row['buyer_instruction']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->description_01->setDbValue($row['description_01']);
		$this->description_02->setDbValue($row['description_02']);
		$this->description_03->setDbValue($row['description_03']);
		$this->description_04->setDbValue($row['description_04']);
		$this->description_05->setDbValue($row['description_05']);
		$this->description_06->setDbValue($row['description_06']);
		$this->description_07->setDbValue($row['description_07']);
		$this->description_08->setDbValue($row['description_08']);
		$this->d_09_head->setDbValue($row['d_09_head']);
		$this->description_09->setDbValue($row['description_09']);
		$this->d_10_head->setDbValue($row['d_10_head']);
		$this->description_10->setDbValue($row['description_10']);
		$this->d_11_head->setDbValue($row['d_11_head']);
		$this->description_11->setDbValue($row['description_11']);
		$this->d_12_head->setDbValue($row['d_12_head']);
		$this->description_12->setDbValue($row['description_12']);
		$this->description_17->setDbValue($row['description_17']);
		$this->description_18->setDbValue($row['description_18']);
		$this->description_19->setDbValue($row['description_19']);
		$this->description_20->setDbValue($row['description_20']);
		$this->production_site->setDbValue($row['production_site']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->__request->setDbValue($row['request']);
		$this->balance_quantity->setDbValue($row['balance_quantity']);
		$this->operator->setDbValue($row['operator']);
		$this->e_mail->setDbValue($row['e_mail']);
		$this->billing_address_id->setDbValue($row['billing_address_id']);
		$this->shipping_address_id->setDbValue($row['shipping_address_id']);
		$this->status->setDbValue($row['status']);
		$this->datetime->setDbValue($row['datetime']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->a_datetime->setDbValue($row['a_datetime']);
		$this->app_operator->setDbValue($row['app_operator']);
		$this->app_datetime->setDbValue($row['app_datetime']);
		$this->c_operator->setDbValue($row['c_operator']);
		$this->c_datetime->setDbValue($row['c_datetime']);
		$this->grp_type->setDbValue($row['grp_type']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['company_id'] = NULL;
		$row['grp'] = NULL;
		$row['reports_to'] = NULL;
		$row['s_grp'] = NULL;
		$row['location'] = NULL;
		$row['po'] = NULL;
		$row['partner_id'] = NULL;
		$row['cart_id'] = NULL;
		$row['sqm'] = NULL;
		$row['quantity'] = NULL;
		$row['amount'] = NULL;
		$row['cbm'] = NULL;
		$row['gst'] = NULL;
		$row['partner_order_no'] = NULL;
		$row['partner_order_date'] = NULL;
		$row['despatch_date'] = NULL;
		$row['despatch_week'] = NULL;
		$row['fob_date'] = NULL;
		$row['production_plan'] = NULL;
		$row['part_dispatch'] = NULL;
		$row['payment_terms'] = NULL;
		$row['transport_type'] = NULL;
		$row['partner_shipping_id'] = NULL;
		$row['remarks'] = NULL;
		$row['buyer_instruction'] = NULL;
		$row['uploads'] = NULL;
		$row['description_01'] = NULL;
		$row['description_02'] = NULL;
		$row['description_03'] = NULL;
		$row['description_04'] = NULL;
		$row['description_05'] = NULL;
		$row['description_06'] = NULL;
		$row['description_07'] = NULL;
		$row['description_08'] = NULL;
		$row['d_09_head'] = NULL;
		$row['description_09'] = NULL;
		$row['d_10_head'] = NULL;
		$row['description_10'] = NULL;
		$row['d_11_head'] = NULL;
		$row['description_11'] = NULL;
		$row['d_12_head'] = NULL;
		$row['description_12'] = NULL;
		$row['description_17'] = NULL;
		$row['description_18'] = NULL;
		$row['description_19'] = NULL;
		$row['description_20'] = NULL;
		$row['production_site'] = NULL;
		$row['jc_no'] = NULL;
		$row['request'] = NULL;
		$row['balance_quantity'] = NULL;
		$row['operator'] = NULL;
		$row['e_mail'] = NULL;
		$row['billing_address_id'] = NULL;
		$row['shipping_address_id'] = NULL;
		$row['status'] = NULL;
		$row['datetime'] = NULL;
		$row['a_operator'] = NULL;
		$row['a_datetime'] = NULL;
		$row['app_operator'] = NULL;
		$row['app_datetime'] = NULL;
		$row['c_operator'] = NULL;
		$row['c_datetime'] = NULL;
		$row['grp_type'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cbm->FormValue == $this->cbm->CurrentValue && is_numeric(ConvertToFloatString($this->cbm->CurrentValue)))
			$this->cbm->CurrentValue = ConvertToFloatString($this->cbm->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// company_id
		// grp

		$this->grp->CellCssStyle = "white-space: nowrap;";

		// reports_to
		$this->reports_to->CellCssStyle = "white-space: nowrap;";

		// s_grp
		$this->s_grp->CellCssStyle = "white-space: nowrap;";

		// location
		$this->location->CellCssStyle = "white-space: nowrap;";

		// po
		// partner_id
		// cart_id
		// sqm
		// quantity
		// amount
		// cbm
		// gst
		// partner_order_no

		$this->partner_order_no->CellCssStyle = "white-space: nowrap;";

		// partner_order_date
		$this->partner_order_date->CellCssStyle = "white-space: nowrap;";

		// despatch_date
		// despatch_week
		// fob_date
		// production_plan
		// part_dispatch
		// payment_terms
		// transport_type
		// partner_shipping_id
		// remarks
		// buyer_instruction
		// uploads

		$this->uploads->CellCssStyle = "white-space: nowrap;";

		// description_01
		$this->description_01->CellCssStyle = "white-space: nowrap;";

		// description_02
		$this->description_02->CellCssStyle = "white-space: nowrap;";

		// description_03
		$this->description_03->CellCssStyle = "white-space: nowrap;";

		// description_04
		$this->description_04->CellCssStyle = "white-space: nowrap;";

		// description_05
		$this->description_05->CellCssStyle = "white-space: nowrap;";

		// description_06
		$this->description_06->CellCssStyle = "white-space: nowrap;";

		// description_07
		$this->description_07->CellCssStyle = "white-space: nowrap;";

		// description_08
		$this->description_08->CellCssStyle = "white-space: nowrap;";

		// d_09_head
		$this->d_09_head->CellCssStyle = "white-space: nowrap;";

		// description_09
		$this->description_09->CellCssStyle = "white-space: nowrap;";

		// d_10_head
		$this->d_10_head->CellCssStyle = "white-space: nowrap;";

		// description_10
		$this->description_10->CellCssStyle = "white-space: nowrap;";

		// d_11_head
		$this->d_11_head->CellCssStyle = "white-space: nowrap;";

		// description_11
		$this->description_11->CellCssStyle = "white-space: nowrap;";

		// d_12_head
		$this->d_12_head->CellCssStyle = "white-space: nowrap;";

		// description_12
		$this->description_12->CellCssStyle = "white-space: nowrap;";

		// description_17
		$this->description_17->CellCssStyle = "white-space: nowrap;";

		// description_18
		$this->description_18->CellCssStyle = "white-space: nowrap;";

		// description_19
		$this->description_19->CellCssStyle = "white-space: nowrap;";

		// description_20
		$this->description_20->CellCssStyle = "white-space: nowrap;";

		// production_site
		$this->production_site->CellCssStyle = "white-space: nowrap;";

		// jc_no
		$this->jc_no->CellCssStyle = "white-space: nowrap;";

		// request
		$this->__request->CellCssStyle = "white-space: nowrap;";

		// balance_quantity
		$this->balance_quantity->CellCssStyle = "white-space: nowrap;";

		// operator
		// e_mail

		$this->e_mail->CellCssStyle = "white-space: nowrap;";

		// billing_address_id
		$this->billing_address_id->CellCssStyle = "white-space: nowrap;";

		// shipping_address_id
		$this->shipping_address_id->CellCssStyle = "white-space: nowrap;";

		// status
		$this->status->CellCssStyle = "white-space: nowrap;";

		// datetime
		// a_operator
		// a_datetime
		// app_operator
		// app_datetime
		// c_operator

		$this->c_operator->CellCssStyle = "white-space: nowrap;";

		// c_datetime
		$this->c_datetime->CellCssStyle = "white-space: nowrap;";

		// grp_type
		$this->grp_type->CellCssStyle = "white-space: nowrap;";
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// partner_id
			if ($this->partner_id->VirtualValue <> "") {
				$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
			} else {
				$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return User_Company_ID() == 0 ? "`status` = 1 and `category` = 1" : "id= ".  User_Company_ID() . "  and `status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->ViewValue = NULL;
			}
			}
			$this->partner_id->ViewCustomAttributes = "";

			// cart_id
			$curVal = strval($this->cart_id->CurrentValue);
			if ($curVal <> "") {
				$this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
				if ($this->cart_id->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "(`po_id` = NULL || `po_id` = '' || `po_id` = '0') and `batch_no` > 0" : "(`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue . ") and  `batch_no` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->cart_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->cart_id->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, 0);
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, 0);
							$this->cart_id->ViewValue->add($this->cart_id->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->cart_id->ViewValue = $this->cart_id->CurrentValue;
					}
				}
			} else {
				$this->cart_id->ViewValue = NULL;
			}
			$this->cart_id->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 2, -2, -2, -2);
			$this->cbm->ViewCustomAttributes = "";

			// gst
			$curVal = strval($this->gst->CurrentValue);
			if ($curVal <> "") {
				$this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
				if ($this->gst->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->gst->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
						$arwrk[3] = $rswrk->fields('df3');
						$this->gst->ViewValue = $this->gst->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->gst->ViewValue = $this->gst->CurrentValue;
					}
				}
			} else {
				$this->gst->ViewValue = NULL;
			}
			$this->gst->ViewCustomAttributes = "";

			// partner_order_no
			$this->partner_order_no->ViewValue = $this->partner_order_no->CurrentValue;
			$this->partner_order_no->ViewCustomAttributes = "";

			// partner_order_date
			$this->partner_order_date->ViewValue = $this->partner_order_date->CurrentValue;
			$this->partner_order_date->ViewValue = FormatDateTime($this->partner_order_date->ViewValue, 0);
			$this->partner_order_date->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// fob_date
			$this->fob_date->ViewValue = $this->fob_date->CurrentValue;
			$this->fob_date->ViewValue = FormatDateTime($this->fob_date->ViewValue, 0);
			$this->fob_date->ViewCustomAttributes = "";

			// production_plan
			$curVal = strval($this->production_plan->CurrentValue);
			if ($curVal <> "") {
				$this->production_plan->ViewValue = $this->production_plan->lookupCacheOption($curVal);
				if ($this->production_plan->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->production_plan->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->production_plan->ViewValue = $this->production_plan->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->production_plan->ViewValue = $this->production_plan->CurrentValue;
					}
				}
			} else {
				$this->production_plan->ViewValue = NULL;
			}
			$this->production_plan->ViewCustomAttributes = "";

			// part_dispatch
			if (strval($this->part_dispatch->CurrentValue) <> "") {
				$this->part_dispatch->ViewValue = $this->part_dispatch->optionCaption($this->part_dispatch->CurrentValue);
			} else {
				$this->part_dispatch->ViewValue = NULL;
			}
			$this->part_dispatch->ViewCustomAttributes = "";

			// payment_terms
			$curVal = strval($this->payment_terms->CurrentValue);
			if ($curVal <> "") {
				$this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
				if ($this->payment_terms->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 81";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->payment_terms->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
					}
				}
			} else {
				$this->payment_terms->ViewValue = NULL;
			}
			$this->payment_terms->ViewCustomAttributes = "";

			// transport_type
			$curVal = strval($this->transport_type->CurrentValue);
			if ($curVal <> "") {
				$this->transport_type->ViewValue = $this->transport_type->lookupCacheOption($curVal);
				if ($this->transport_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 82";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->transport_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->transport_type->ViewValue = $this->transport_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->transport_type->ViewValue = $this->transport_type->CurrentValue;
					}
				}
			} else {
				$this->transport_type->ViewValue = NULL;
			}
			$this->transport_type->ViewCustomAttributes = "";

			// partner_shipping_id
			$curVal = strval($this->partner_shipping_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_shipping_id->ViewValue = $this->partner_shipping_id->lookupCacheOption($curVal);
				if ($this->partner_shipping_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` < 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_shipping_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->partner_shipping_id->ViewValue = $this->partner_shipping_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_shipping_id->ViewValue = $this->partner_shipping_id->CurrentValue;
					}
				}
			} else {
				$this->partner_shipping_id->ViewValue = NULL;
			}
			$this->partner_shipping_id->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// buyer_instruction
			$this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;
			$this->buyer_instruction->ViewCustomAttributes = "";

			// uploads
			$this->uploads->UploadPath = '/.p_uploads/sppo/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->ViewValue = "";
			}
			$this->uploads->CssClass = "font-italic";
			$this->uploads->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 11);
			$this->datetime->ViewCustomAttributes = "";

			// a_operator
			$curVal = strval($this->a_operator->CurrentValue);
			if ($curVal <> "") {
				$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
				if ($this->a_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
					}
				}
			} else {
				$this->a_operator->ViewValue = NULL;
			}
			$this->a_operator->ViewCustomAttributes = "";

			// a_datetime
			$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
			$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 11);
			$this->a_datetime->ViewCustomAttributes = "";

			// app_operator
			$curVal = strval($this->app_operator->CurrentValue);
			if ($curVal <> "") {
				$this->app_operator->ViewValue = $this->app_operator->lookupCacheOption($curVal);
				if ($this->app_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->app_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->app_operator->ViewValue = $this->app_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->app_operator->ViewValue = $this->app_operator->CurrentValue;
					}
				}
			} else {
				$this->app_operator->ViewValue = NULL;
			}
			$this->app_operator->ViewCustomAttributes = "";

			// app_datetime
			$this->app_datetime->ViewValue = $this->app_datetime->CurrentValue;
			$this->app_datetime->ViewValue = FormatDateTime($this->app_datetime->ViewValue, 11);
			$this->app_datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			if (!EmptyValue($this->po->CurrentValue)) {
				$this->po->HrefValue = "po_blist.php?x_po=" . $this->po->CurrentValue; // Add prefix/suffix
				$this->po->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
			} else {
				$this->po->HrefValue = "";
			}
			$this->po->TooltipValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->partner_id->CurrentValue)) {
				$this->partner_id->HrefValue = "po_blist.php?x_partner_id=" . $this->partner_id->CurrentValue; // Add prefix/suffix
				$this->partner_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
			} else {
				$this->partner_id->HrefValue = "";
			}
			$this->partner_id->TooltipValue = "";
			if (!$this->isExport())
				$this->partner_id->ViewValue = $this->highlightValue($this->partner_id);

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";
			if (!$this->isExport())
				$this->amount->ViewValue = $this->highlightValue($this->amount);

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// gst
			$this->gst->LinkCustomAttributes = "";
			$this->gst->HrefValue = "";
			$this->gst->TooltipValue = "";

			// partner_order_no
			$this->partner_order_no->LinkCustomAttributes = "";
			$this->partner_order_no->HrefValue = "";
			$this->partner_order_no->TooltipValue = "";
			if (!$this->isExport())
				$this->partner_order_no->ViewValue = $this->highlightValue($this->partner_order_no);

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// fob_date
			$this->fob_date->LinkCustomAttributes = "";
			$this->fob_date->HrefValue = "";
			$this->fob_date->TooltipValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			if (!EmptyValue($this->payment_terms->CurrentValue)) {
				$this->payment_terms->HrefValue = "po_blist.php?x_payment_terms=" . $this->payment_terms->CurrentValue; // Add prefix/suffix
				$this->payment_terms->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->payment_terms->HrefValue = FullUrl($this->payment_terms->HrefValue, "href");
			} else {
				$this->payment_terms->HrefValue = "";
			}
			$this->payment_terms->TooltipValue = "";

			// transport_type
			$this->transport_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->transport_type->CurrentValue)) {
				$this->transport_type->HrefValue = "po_blist.php?x_transport_type=" . $this->transport_type->CurrentValue; // Add prefix/suffix
				$this->transport_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->transport_type->HrefValue = FullUrl($this->transport_type->HrefValue, "href");
			} else {
				$this->transport_type->HrefValue = "";
			}
			$this->transport_type->TooltipValue = "";

			// partner_shipping_id
			$this->partner_shipping_id->LinkCustomAttributes = "";
			$this->partner_shipping_id->HrefValue = "";
			$this->partner_shipping_id->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->UploadPath = '/.p_uploads/sppo/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = "%u"; // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
			$this->uploads->TooltipValue = "";
			if ($this->uploads->UseColorbox) {
				if (EmptyValue($this->uploads->TooltipValue))
					$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->uploads->LinkAttrs["data-rel"] = "po_b_wbc_x" . $this->RowCnt . "_uploads";
				AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
			}

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// a_operator
			$this->a_operator->LinkCustomAttributes = "";
			$this->a_operator->HrefValue = "";
			$this->a_operator->TooltipValue = "";

			// a_datetime
			$this->a_datetime->LinkCustomAttributes = "";
			$this->a_datetime->HrefValue = "";
			$this->a_datetime->TooltipValue = "";

			// app_operator
			$this->app_operator->LinkCustomAttributes = "";
			$this->app_operator->HrefValue = "";
			$this->app_operator->TooltipValue = "";

			// app_datetime
			$this->app_datetime->LinkCustomAttributes = "";
			$this->app_datetime->HrefValue = "";
			$this->app_datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
			else
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== NULL && is_array($this->company_id->Lookup->Options) ? $curVal : NULL;
			if ($this->company_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->company_id->EditValue = array_values($this->company_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->company_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`category`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->company_id->EditValue = $arwrk;
			}

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// partner_id
			$this->partner_id->EditAttrs["class"] = "form-control";
			$this->partner_id->EditCustomAttributes = "";
			$this->partner_id->EditValue = HtmlEncode($this->partner_id->AdvancedSearch->SearchValue);
			$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = 'ReadOnly';
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = 'ReadOnly';
			$this->quantity->EditValue = HtmlEncode($this->quantity->AdvancedSearch->SearchValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = 'ReadOnly';
			if (REMOVE_XSS)
				$this->amount->AdvancedSearch->SearchValue = HtmlDecode($this->amount->AdvancedSearch->SearchValue);
			$this->amount->EditValue = HtmlEncode($this->amount->AdvancedSearch->SearchValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

			// cbm
			$this->cbm->EditAttrs["class"] = "form-control";
			$this->cbm->EditCustomAttributes = 'ReadOnly';
			$this->cbm->EditValue = HtmlEncode($this->cbm->AdvancedSearch->SearchValue);
			$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

			// gst
			$this->gst->EditAttrs["class"] = "form-control";
			$this->gst->EditCustomAttributes = "";

			// partner_order_no
			$this->partner_order_no->EditAttrs["class"] = "form-control";
			$this->partner_order_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_order_no->AdvancedSearch->SearchValue = HtmlDecode($this->partner_order_no->AdvancedSearch->SearchValue);
			$this->partner_order_no->EditValue = HtmlEncode($this->partner_order_no->AdvancedSearch->SearchValue);
			$this->partner_order_no->PlaceHolder = RemoveHtml($this->partner_order_no->caption());

			// despatch_date
			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->despatch_date->AdvancedSearch->SearchValue, 0), 8));
			$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";

			// fob_date
			$this->fob_date->EditAttrs["class"] = "form-control";
			$this->fob_date->EditCustomAttributes = "";
			$this->fob_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->fob_date->AdvancedSearch->SearchValue, 0), 8));
			$this->fob_date->PlaceHolder = RemoveHtml($this->fob_date->caption());

			// payment_terms
			$this->payment_terms->EditAttrs["class"] = "form-control";
			$this->payment_terms->EditCustomAttributes = "";

			// transport_type
			$this->transport_type->EditAttrs["class"] = "form-control";
			$this->transport_type->EditCustomAttributes = "";

			// partner_shipping_id
			$this->partner_shipping_id->EditAttrs["class"] = "form-control";
			$this->partner_shipping_id->EditCustomAttributes = "";

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->uploads->AdvancedSearch->SearchValue = HtmlDecode($this->uploads->AdvancedSearch->SearchValue);
			$this->uploads->EditValue = HtmlEncode($this->uploads->AdvancedSearch->SearchValue);
			$this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 11), 11));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// a_operator
			$this->a_operator->EditAttrs["class"] = "form-control";
			$this->a_operator->EditCustomAttributes = "";

			// a_datetime
			$this->a_datetime->EditAttrs["class"] = "form-control";
			$this->a_datetime->EditCustomAttributes = "";
			$this->a_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->a_datetime->AdvancedSearch->SearchValue, 11), 11));
			$this->a_datetime->PlaceHolder = RemoveHtml($this->a_datetime->caption());

			// app_operator
			$this->app_operator->EditAttrs["class"] = "form-control";
			$this->app_operator->EditCustomAttributes = "";

			// app_datetime
			$this->app_datetime->EditAttrs["class"] = "form-control";
			$this->app_datetime->EditCustomAttributes = "";
			$this->app_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->app_datetime->AdvancedSearch->SearchValue, 11), 11));
			$this->app_datetime->PlaceHolder = RemoveHtml($this->app_datetime->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->partner_id->AdvancedSearch->load();
		$this->cart_id->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->gst->AdvancedSearch->load();
		$this->partner_order_no->AdvancedSearch->load();
		$this->despatch_week->AdvancedSearch->load();
		$this->payment_terms->AdvancedSearch->load();
		$this->transport_type->AdvancedSearch->load();
		$this->partner_shipping_id->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->buyer_instruction->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fpo_b_wbclist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fpo_b_wbclist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fpo_b_wbclist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_po_b_wbc\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_po_b_wbc',hdr:ew.language.phrase('ExportToEmailText'),f:document.fpo_b_wbclist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return "`category`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1 and type = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_location":
					$lookupFilter = function() {
						return ((CurrentPageID() == "add") || (CurrentPageID() == "edit")) ? (User_Site() == 0) ? "" : "FIND_IN_SET(`id`," . User_Site() . ")" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_id":
					$lookupFilter = function() {
						return User_Company_ID() == 0 ? "`status` = 1 and `category` = 1" : "id= ".  User_Company_ID() . "  and `status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_cart_id":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "(`po_id` = NULL || `po_id` = '' || `po_id` = '0') and `batch_no` > 0" : "(`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue . ") and  `batch_no` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_gst":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_despatch_week":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_production_plan":
					$lookupFilter = function() {
						return "`status` =1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_payment_terms":
					$lookupFilter = function() {
						return "`grp` = 81";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_transport_type":
					$lookupFilter = function() {
						return "`grp` = 82";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_shipping_id":
					$lookupFilter = function() {
						return "`status` < 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_05":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_06":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_production_site":
					$lookupFilter = function() {
						return "`grp` IN (0,3)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_location":
							break;
						case "x_partner_id":
							break;
						case "x_cart_id":
							$row[3] = FormatNumber($row[3], 2, -2, -2, 0);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, 0);
							$row['df4'] = $row[4];
							break;
						case "x_gst":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							break;
						case "x_despatch_week":
							break;
						case "x_production_plan":
							break;
						case "x_payment_terms":
							break;
						case "x_transport_type":
							break;
						case "x_partner_shipping_id":
							break;
						case "x_description_05":
							break;
						case "x_description_06":
							break;
						case "x_d_09_head":
							break;
						case "x_d_10_head":
							break;
						case "x_d_11_head":
							break;
						case "x_d_12_head":
							break;
						case "x_production_site":
							break;
						case "x_operator":
							break;
						case "x_a_operator":
							break;
						case "x_app_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'po_b_wbc');		
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

		if ($this->app_operator->CurrentValue > 0 ) {
			$this->ListOptions->Items['edit']->Visible=False;
			$this->ListOptions->Items['delete']->Visible=False;
		} else {
			$this->ListOptions->Items['edit']->Visible=True;
			$this->ListOptions->Items['delete']->Visible=True;
		}
		$this->ListOptions->Add("Print Adm. Order"); // Replace abclink with your name of the link
		$this->ListOptions->Items["Print Adm. Order"]->Body =
			'<a href="print_po.php?id=' . $this->id->CurrentValue . '&type=5e6e3606e452613c501b807195167443&sp=s" data-original-title ="Print Adm. Order"><i data-phrase="Print Adm. Order"  class="fa fa-print ew-icon" ></i></a>'; 
				if (!empty($this->app_operator->CurrentValue))	
				{
				$this->ListOptions->Add("Print Prod. Order"); // Replace abclink with your name of the link
				$this->ListOptions->Items["Print Prod. Order"]->Body =
					'<a href="print_po.php?id=' . $this->id->CurrentValue . '&type=d6e4a9b6646c62fc48baa6dd6150d1f7&sp=s" data-original-title ="Print Prod. Order"><i data-phrase="Print Prod. Order"  class="fa fa-print ew-icon" ></i></a>';
				}
	}			

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>