<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class po_b_wbc_search extends po_b_wbc
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'po_b_wbc';

	// Page object name
	public $PageObjName = "po_b_wbc_search";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (po_b_wbc)
		if (!isset($GLOBALS["po_b_wbc"]) || get_class($GLOBALS["po_b_wbc"]) == PROJECT_NAMESPACE . "po_b_wbc") {
			$GLOBALS["po_b_wbc"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["po_b_wbc"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_b_wbc');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $po_b_wbc;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($po_b_wbc);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "po_b_wbcview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("po_b_wbclist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->company_id->setVisibility();
		$this->grp->Visible = FALSE;
		$this->reports_to->Visible = FALSE;
		$this->s_grp->Visible = FALSE;
		$this->location->Visible = FALSE;
		$this->po->setVisibility();
		$this->partner_id->setVisibility();
		$this->cart_id->setVisibility();
		$this->sqm->setVisibility();
		$this->quantity->setVisibility();
		$this->amount->setVisibility();
		$this->cbm->setVisibility();
		$this->gst->setVisibility();
		$this->partner_order_no->setVisibility();
		$this->partner_order_date->Visible = FALSE;
		$this->despatch_date->Visible = FALSE;
		$this->despatch_week->setVisibility();
		$this->fob_date->Visible = FALSE;
		$this->production_plan->Visible = FALSE;
		$this->part_dispatch->Visible = FALSE;
		$this->payment_terms->setVisibility();
		$this->transport_type->setVisibility();
		$this->partner_shipping_id->setVisibility();
		$this->remarks->setVisibility();
		$this->buyer_instruction->setVisibility();
		$this->uploads->Visible = FALSE;
		$this->description_01->Visible = FALSE;
		$this->description_02->Visible = FALSE;
		$this->description_03->Visible = FALSE;
		$this->description_04->Visible = FALSE;
		$this->description_05->Visible = FALSE;
		$this->description_06->Visible = FALSE;
		$this->description_07->Visible = FALSE;
		$this->description_08->Visible = FALSE;
		$this->d_09_head->Visible = FALSE;
		$this->description_09->Visible = FALSE;
		$this->d_10_head->Visible = FALSE;
		$this->description_10->Visible = FALSE;
		$this->d_11_head->Visible = FALSE;
		$this->description_11->Visible = FALSE;
		$this->d_12_head->Visible = FALSE;
		$this->description_12->Visible = FALSE;
		$this->description_17->Visible = FALSE;
		$this->description_18->Visible = FALSE;
		$this->description_19->Visible = FALSE;
		$this->description_20->Visible = FALSE;
		$this->production_site->Visible = FALSE;
		$this->jc_no->Visible = FALSE;
		$this->__request->Visible = FALSE;
		$this->balance_quantity->Visible = FALSE;
		$this->operator->Visible = FALSE;
		$this->e_mail->Visible = FALSE;
		$this->billing_address_id->Visible = FALSE;
		$this->shipping_address_id->Visible = FALSE;
		$this->status->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->a_operator->Visible = FALSE;
		$this->a_datetime->Visible = FALSE;
		$this->app_operator->Visible = FALSE;
		$this->app_datetime->Visible = FALSE;
		$this->c_operator->Visible = FALSE;
		$this->c_datetime->Visible = FALSE;
		$this->grp_type->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->cart_id);
		$this->setupLookupOptions($this->gst);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->production_plan);
		$this->setupLookupOptions($this->payment_terms);
		$this->setupLookupOptions($this->transport_type);
		$this->setupLookupOptions($this->partner_shipping_id);
		$this->setupLookupOptions($this->description_05);
		$this->setupLookupOptions($this->description_06);
		$this->setupLookupOptions($this->d_09_head);
		$this->setupLookupOptions($this->d_10_head);
		$this->setupLookupOptions($this->d_11_head);
		$this->setupLookupOptions($this->d_12_head);
		$this->setupLookupOptions($this->production_site);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->a_operator);
		$this->setupLookupOptions($this->app_operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "po_b_wbclist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->company_id); // company_id
		$this->buildSearchUrl($srchUrl, $this->po); // po
		$this->buildSearchUrl($srchUrl, $this->partner_id); // partner_id
		$this->buildSearchUrl($srchUrl, $this->cart_id); // cart_id
		$this->buildSearchUrl($srchUrl, $this->sqm); // sqm
		$this->buildSearchUrl($srchUrl, $this->quantity); // quantity
		$this->buildSearchUrl($srchUrl, $this->amount); // amount
		$this->buildSearchUrl($srchUrl, $this->cbm); // cbm
		$this->buildSearchUrl($srchUrl, $this->gst); // gst
		$this->buildSearchUrl($srchUrl, $this->partner_order_no); // partner_order_no
		$this->buildSearchUrl($srchUrl, $this->despatch_week); // despatch_week
		$this->buildSearchUrl($srchUrl, $this->payment_terms); // payment_terms
		$this->buildSearchUrl($srchUrl, $this->transport_type); // transport_type
		$this->buildSearchUrl($srchUrl, $this->partner_shipping_id); // partner_shipping_id
		$this->buildSearchUrl($srchUrl, $this->remarks); // remarks
		$this->buildSearchUrl($srchUrl, $this->buyer_instruction); // buyer_instruction
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// company_id
		if (!$this->isAddOrEdit())
			$this->company_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_company_id"));
		$this->company_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_company_id"));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po"));
		$this->po->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po"));

		// partner_id
		if (!$this->isAddOrEdit())
			$this->partner_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_partner_id"));
		$this->partner_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_partner_id"));

		// cart_id
		if (!$this->isAddOrEdit())
			$this->cart_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cart_id"));
		$this->cart_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cart_id"));
		if (is_array($this->cart_id->AdvancedSearch->SearchValue))
			$this->cart_id->AdvancedSearch->SearchValue = implode(",", $this->cart_id->AdvancedSearch->SearchValue);
		if (is_array($this->cart_id->AdvancedSearch->SearchValue2))
			$this->cart_id->AdvancedSearch->SearchValue2 = implode(",", $this->cart_id->AdvancedSearch->SearchValue2);

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sqm"));
		$this->sqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sqm"));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_quantity"));
		$this->quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_quantity"));

		// amount
		if (!$this->isAddOrEdit())
			$this->amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_amount"));
		$this->amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_amount"));

		// cbm
		if (!$this->isAddOrEdit())
			$this->cbm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cbm"));
		$this->cbm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cbm"));

		// gst
		if (!$this->isAddOrEdit())
			$this->gst->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_gst"));
		$this->gst->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_gst"));

		// partner_order_no
		if (!$this->isAddOrEdit())
			$this->partner_order_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_partner_order_no"));
		$this->partner_order_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_partner_order_no"));

		// despatch_week
		if (!$this->isAddOrEdit())
			$this->despatch_week->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_despatch_week"));
		$this->despatch_week->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_despatch_week"));

		// payment_terms
		if (!$this->isAddOrEdit())
			$this->payment_terms->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_payment_terms"));
		$this->payment_terms->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_payment_terms"));

		// transport_type
		if (!$this->isAddOrEdit())
			$this->transport_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_transport_type"));
		$this->transport_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_transport_type"));

		// partner_shipping_id
		if (!$this->isAddOrEdit())
			$this->partner_shipping_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_partner_shipping_id"));
		$this->partner_shipping_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_partner_shipping_id"));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remarks"));
		$this->remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remarks"));

		// buyer_instruction
		if (!$this->isAddOrEdit())
			$this->buyer_instruction->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_instruction"));
		$this->buyer_instruction->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_instruction"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cbm->FormValue == $this->cbm->CurrentValue && is_numeric(ConvertToFloatString($this->cbm->CurrentValue)))
			$this->cbm->CurrentValue = ConvertToFloatString($this->cbm->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// company_id
		// grp
		// reports_to
		// s_grp
		// location
		// po
		// partner_id
		// cart_id
		// sqm
		// quantity
		// amount
		// cbm
		// gst
		// partner_order_no
		// partner_order_date
		// despatch_date
		// despatch_week
		// fob_date
		// production_plan
		// part_dispatch
		// payment_terms
		// transport_type
		// partner_shipping_id
		// remarks
		// buyer_instruction
		// uploads
		// description_01
		// description_02
		// description_03
		// description_04
		// description_05
		// description_06
		// description_07
		// description_08
		// d_09_head
		// description_09
		// d_10_head
		// description_10
		// d_11_head
		// description_11
		// d_12_head
		// description_12
		// description_17
		// description_18
		// description_19
		// description_20
		// production_site
		// jc_no
		// request
		// balance_quantity
		// operator
		// e_mail
		// billing_address_id
		// shipping_address_id
		// status
		// datetime
		// a_operator
		// a_datetime
		// app_operator
		// app_datetime
		// c_operator
		// c_datetime
		// grp_type

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// partner_id
			if ($this->partner_id->VirtualValue <> "") {
				$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
			} else {
				$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return User_Company_ID() == 0 ? "`status` = 1 and `category` = 1" : "id= ".  User_Company_ID() . "  and `status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->ViewValue = NULL;
			}
			}
			$this->partner_id->ViewCustomAttributes = "";

			// cart_id
			$curVal = strval($this->cart_id->CurrentValue);
			if ($curVal <> "") {
				$this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
				if ($this->cart_id->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "(`po_id` = NULL || `po_id` = '' || `po_id` = '0') and `batch_no` > 0" : "(`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue . ") and  `batch_no` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->cart_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->cart_id->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, 0);
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, 0);
							$this->cart_id->ViewValue->add($this->cart_id->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->cart_id->ViewValue = $this->cart_id->CurrentValue;
					}
				}
			} else {
				$this->cart_id->ViewValue = NULL;
			}
			$this->cart_id->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 2, -2, -2, -2);
			$this->cbm->ViewCustomAttributes = "";

			// gst
			$curVal = strval($this->gst->CurrentValue);
			if ($curVal <> "") {
				$this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
				if ($this->gst->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->gst->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
						$arwrk[3] = $rswrk->fields('df3');
						$this->gst->ViewValue = $this->gst->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->gst->ViewValue = $this->gst->CurrentValue;
					}
				}
			} else {
				$this->gst->ViewValue = NULL;
			}
			$this->gst->ViewCustomAttributes = "";

			// partner_order_no
			$this->partner_order_no->ViewValue = $this->partner_order_no->CurrentValue;
			$this->partner_order_no->ViewCustomAttributes = "";

			// partner_order_date
			$this->partner_order_date->ViewValue = $this->partner_order_date->CurrentValue;
			$this->partner_order_date->ViewValue = FormatDateTime($this->partner_order_date->ViewValue, 0);
			$this->partner_order_date->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// fob_date
			$this->fob_date->ViewValue = $this->fob_date->CurrentValue;
			$this->fob_date->ViewValue = FormatDateTime($this->fob_date->ViewValue, 0);
			$this->fob_date->ViewCustomAttributes = "";

			// production_plan
			$curVal = strval($this->production_plan->CurrentValue);
			if ($curVal <> "") {
				$this->production_plan->ViewValue = $this->production_plan->lookupCacheOption($curVal);
				if ($this->production_plan->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->production_plan->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->production_plan->ViewValue = $this->production_plan->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->production_plan->ViewValue = $this->production_plan->CurrentValue;
					}
				}
			} else {
				$this->production_plan->ViewValue = NULL;
			}
			$this->production_plan->ViewCustomAttributes = "";

			// part_dispatch
			if (strval($this->part_dispatch->CurrentValue) <> "") {
				$this->part_dispatch->ViewValue = $this->part_dispatch->optionCaption($this->part_dispatch->CurrentValue);
			} else {
				$this->part_dispatch->ViewValue = NULL;
			}
			$this->part_dispatch->ViewCustomAttributes = "";

			// payment_terms
			$curVal = strval($this->payment_terms->CurrentValue);
			if ($curVal <> "") {
				$this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
				if ($this->payment_terms->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 81";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->payment_terms->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
					}
				}
			} else {
				$this->payment_terms->ViewValue = NULL;
			}
			$this->payment_terms->ViewCustomAttributes = "";

			// transport_type
			$curVal = strval($this->transport_type->CurrentValue);
			if ($curVal <> "") {
				$this->transport_type->ViewValue = $this->transport_type->lookupCacheOption($curVal);
				if ($this->transport_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 82";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->transport_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->transport_type->ViewValue = $this->transport_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->transport_type->ViewValue = $this->transport_type->CurrentValue;
					}
				}
			} else {
				$this->transport_type->ViewValue = NULL;
			}
			$this->transport_type->ViewCustomAttributes = "";

			// partner_shipping_id
			$curVal = strval($this->partner_shipping_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_shipping_id->ViewValue = $this->partner_shipping_id->lookupCacheOption($curVal);
				if ($this->partner_shipping_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` < 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_shipping_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->partner_shipping_id->ViewValue = $this->partner_shipping_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_shipping_id->ViewValue = $this->partner_shipping_id->CurrentValue;
					}
				}
			} else {
				$this->partner_shipping_id->ViewValue = NULL;
			}
			$this->partner_shipping_id->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// buyer_instruction
			$this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;
			$this->buyer_instruction->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 11);
			$this->datetime->ViewCustomAttributes = "";

			// a_operator
			$curVal = strval($this->a_operator->CurrentValue);
			if ($curVal <> "") {
				$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
				if ($this->a_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
					}
				}
			} else {
				$this->a_operator->ViewValue = NULL;
			}
			$this->a_operator->ViewCustomAttributes = "";

			// a_datetime
			$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
			$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 11);
			$this->a_datetime->ViewCustomAttributes = "";

			// app_operator
			$curVal = strval($this->app_operator->CurrentValue);
			if ($curVal <> "") {
				$this->app_operator->ViewValue = $this->app_operator->lookupCacheOption($curVal);
				if ($this->app_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->app_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->app_operator->ViewValue = $this->app_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->app_operator->ViewValue = $this->app_operator->CurrentValue;
					}
				}
			} else {
				$this->app_operator->ViewValue = NULL;
			}
			$this->app_operator->ViewCustomAttributes = "";

			// app_datetime
			$this->app_datetime->ViewValue = $this->app_datetime->CurrentValue;
			$this->app_datetime->ViewValue = FormatDateTime($this->app_datetime->ViewValue, 11);
			$this->app_datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			if (!EmptyValue($this->po->CurrentValue)) {
				$this->po->HrefValue = "po_blist.php?x_po=" . $this->po->CurrentValue; // Add prefix/suffix
				$this->po->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
			} else {
				$this->po->HrefValue = "";
			}
			$this->po->TooltipValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->partner_id->CurrentValue)) {
				$this->partner_id->HrefValue = "po_blist.php?x_partner_id=" . $this->partner_id->CurrentValue; // Add prefix/suffix
				$this->partner_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
			} else {
				$this->partner_id->HrefValue = "";
			}
			$this->partner_id->TooltipValue = "";

			// cart_id
			$this->cart_id->LinkCustomAttributes = "";
			$this->cart_id->HrefValue = "";
			$this->cart_id->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// gst
			$this->gst->LinkCustomAttributes = "";
			$this->gst->HrefValue = "";
			$this->gst->TooltipValue = "";

			// partner_order_no
			$this->partner_order_no->LinkCustomAttributes = "";
			$this->partner_order_no->HrefValue = "";
			$this->partner_order_no->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			if (!EmptyValue($this->payment_terms->CurrentValue)) {
				$this->payment_terms->HrefValue = "po_blist.php?x_payment_terms=" . $this->payment_terms->CurrentValue; // Add prefix/suffix
				$this->payment_terms->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->payment_terms->HrefValue = FullUrl($this->payment_terms->HrefValue, "href");
			} else {
				$this->payment_terms->HrefValue = "";
			}
			$this->payment_terms->TooltipValue = "";

			// transport_type
			$this->transport_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->transport_type->CurrentValue)) {
				$this->transport_type->HrefValue = "po_blist.php?x_transport_type=" . $this->transport_type->CurrentValue; // Add prefix/suffix
				$this->transport_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->transport_type->HrefValue = FullUrl($this->transport_type->HrefValue, "href");
			} else {
				$this->transport_type->HrefValue = "";
			}
			$this->transport_type->TooltipValue = "";

			// partner_shipping_id
			$this->partner_shipping_id->LinkCustomAttributes = "";
			$this->partner_shipping_id->HrefValue = "";
			$this->partner_shipping_id->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// buyer_instruction
			$this->buyer_instruction->LinkCustomAttributes = "";
			$this->buyer_instruction->HrefValue = "";
			$this->buyer_instruction->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
			else
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== NULL && is_array($this->company_id->Lookup->Options) ? $curVal : NULL;
			if ($this->company_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->company_id->EditValue = array_values($this->company_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->company_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`category`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->company_id->EditValue = $arwrk;
			}

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// partner_id
			$this->partner_id->EditAttrs["class"] = "form-control";
			$this->partner_id->EditCustomAttributes = "";
			$this->partner_id->EditValue = HtmlEncode($this->partner_id->AdvancedSearch->SearchValue);
			$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

			// cart_id
			$this->cart_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->cart_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->cart_id->AdvancedSearch->ViewValue = $this->cart_id->lookupCacheOption($curVal);
			else
				$this->cart_id->AdvancedSearch->ViewValue = $this->cart_id->Lookup !== NULL && is_array($this->cart_id->Lookup->Options) ? $curVal : NULL;
			if ($this->cart_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->cart_id->EditValue = array_values($this->cart_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "(`po_id` = NULL || `po_id` = '' || `po_id` = '0') and `batch_no` > 0" : "(`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue . ") and  `batch_no` > 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->cart_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, 0);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, 0);
				}
				$this->cart_id->EditValue = $arwrk;
			}

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = 'ReadOnly';
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = 'ReadOnly';
			$this->quantity->EditValue = HtmlEncode($this->quantity->AdvancedSearch->SearchValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = 'ReadOnly';
			if (REMOVE_XSS)
				$this->amount->AdvancedSearch->SearchValue = HtmlDecode($this->amount->AdvancedSearch->SearchValue);
			$this->amount->EditValue = HtmlEncode($this->amount->AdvancedSearch->SearchValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

			// cbm
			$this->cbm->EditAttrs["class"] = "form-control";
			$this->cbm->EditCustomAttributes = 'ReadOnly';
			$this->cbm->EditValue = HtmlEncode($this->cbm->AdvancedSearch->SearchValue);
			$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

			// gst
			$this->gst->EditAttrs["class"] = "form-control";
			$this->gst->EditCustomAttributes = "";
			$curVal = trim(strval($this->gst->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->gst->AdvancedSearch->ViewValue = $this->gst->lookupCacheOption($curVal);
			else
				$this->gst->AdvancedSearch->ViewValue = $this->gst->Lookup !== NULL && is_array($this->gst->Lookup->Options) ? $curVal : NULL;
			if ($this->gst->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->gst->EditValue = array_values($this->gst->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->gst->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->gst->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, -2);
				}
				$this->gst->EditValue = $arwrk;
			}

			// partner_order_no
			$this->partner_order_no->EditAttrs["class"] = "form-control";
			$this->partner_order_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_order_no->AdvancedSearch->SearchValue = HtmlDecode($this->partner_order_no->AdvancedSearch->SearchValue);
			$this->partner_order_no->EditValue = HtmlEncode($this->partner_order_no->AdvancedSearch->SearchValue);
			$this->partner_order_no->PlaceHolder = RemoveHtml($this->partner_order_no->caption());

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$curVal = trim(strval($this->despatch_week->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			else
				$this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->Lookup !== NULL && is_array($this->despatch_week->Lookup->Options) ? $curVal : NULL;
			if ($this->despatch_week->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->despatch_week->EditValue = array_values($this->despatch_week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->despatch_week->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->despatch_week->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->despatch_week->EditValue = $arwrk;
			}

			// payment_terms
			$this->payment_terms->EditAttrs["class"] = "form-control";
			$this->payment_terms->EditCustomAttributes = "";
			$curVal = trim(strval($this->payment_terms->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->payment_terms->AdvancedSearch->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
			else
				$this->payment_terms->AdvancedSearch->ViewValue = $this->payment_terms->Lookup !== NULL && is_array($this->payment_terms->Lookup->Options) ? $curVal : NULL;
			if ($this->payment_terms->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->payment_terms->EditValue = array_values($this->payment_terms->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->payment_terms->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 81";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->payment_terms->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->payment_terms->EditValue = $arwrk;
			}

			// transport_type
			$this->transport_type->EditAttrs["class"] = "form-control";
			$this->transport_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->transport_type->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->transport_type->AdvancedSearch->ViewValue = $this->transport_type->lookupCacheOption($curVal);
			else
				$this->transport_type->AdvancedSearch->ViewValue = $this->transport_type->Lookup !== NULL && is_array($this->transport_type->Lookup->Options) ? $curVal : NULL;
			if ($this->transport_type->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->transport_type->EditValue = array_values($this->transport_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->transport_type->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 82";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->transport_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->transport_type->EditValue = $arwrk;
			}

			// partner_shipping_id
			$this->partner_shipping_id->EditAttrs["class"] = "form-control";
			$this->partner_shipping_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->partner_shipping_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->partner_shipping_id->AdvancedSearch->ViewValue = $this->partner_shipping_id->lookupCacheOption($curVal);
			else
				$this->partner_shipping_id->AdvancedSearch->ViewValue = $this->partner_shipping_id->Lookup !== NULL && is_array($this->partner_shipping_id->Lookup->Options) ? $curVal : NULL;
			if ($this->partner_shipping_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->partner_shipping_id->EditValue = array_values($this->partner_shipping_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->partner_shipping_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` < 3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_shipping_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->partner_shipping_id->EditValue = $arwrk;
			}

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// buyer_instruction
			$this->buyer_instruction->EditAttrs["class"] = "form-control";
			$this->buyer_instruction->EditCustomAttributes = "";
			$this->buyer_instruction->EditValue = HtmlEncode($this->buyer_instruction->AdvancedSearch->SearchValue);
			$this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->sqm->errorMessage());
		}
		if (!CheckNumber($this->cbm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->cbm->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->partner_id->AdvancedSearch->load();
		$this->cart_id->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->gst->AdvancedSearch->load();
		$this->partner_order_no->AdvancedSearch->load();
		$this->despatch_week->AdvancedSearch->load();
		$this->payment_terms->AdvancedSearch->load();
		$this->transport_type->AdvancedSearch->load();
		$this->partner_shipping_id->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->buyer_instruction->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("po_b_wbclist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return "`category`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1 and type = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_location":
					$lookupFilter = function() {
						return ((CurrentPageID() == "add") || (CurrentPageID() == "edit")) ? (User_Site() == 0) ? "" : "FIND_IN_SET(`id`," . User_Site() . ")" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_id":
					$lookupFilter = function() {
						return User_Company_ID() == 0 ? "`status` = 1 and `category` = 1" : "id= ".  User_Company_ID() . "  and `status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_cart_id":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "(`po_id` = NULL || `po_id` = '' || `po_id` = '0') and `batch_no` > 0" : "(`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue . ") and  `batch_no` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_gst":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_despatch_week":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_production_plan":
					$lookupFilter = function() {
						return "`status` =1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_payment_terms":
					$lookupFilter = function() {
						return "`grp` = 81";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_transport_type":
					$lookupFilter = function() {
						return "`grp` = 82";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_shipping_id":
					$lookupFilter = function() {
						return "`status` < 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_05":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_06":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_production_site":
					$lookupFilter = function() {
						return "`grp` IN (0,3)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_location":
							break;
						case "x_partner_id":
							break;
						case "x_cart_id":
							$row[3] = FormatNumber($row[3], 2, -2, -2, 0);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, 0);
							$row['df4'] = $row[4];
							break;
						case "x_gst":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							break;
						case "x_despatch_week":
							break;
						case "x_production_plan":
							break;
						case "x_payment_terms":
							break;
						case "x_transport_type":
							break;
						case "x_partner_shipping_id":
							break;
						case "x_description_05":
							break;
						case "x_description_06":
							break;
						case "x_d_09_head":
							break;
						case "x_d_10_head":
							break;
						case "x_d_11_head":
							break;
						case "x_d_12_head":
							break;
						case "x_production_site":
							break;
						case "x_operator":
							break;
						case "x_a_operator":
							break;
						case "x_app_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'po_b_wbc');		
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>