<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class po_fp_edit extends po_fp
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'po_fp';

	// Page object name
	public $PageObjName = "po_fp_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (po_fp)
		if (!isset($GLOBALS["po_fp"]) || get_class($GLOBALS["po_fp"]) == PROJECT_NAMESPACE . "po_fp") {
			$GLOBALS["po_fp"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["po_fp"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_fp');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $po_fp;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($po_fp);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "po_fpview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("po_fplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->grp->setVisibility();
		$this->po->setVisibility();
		$this->buyer_id->setVisibility();
		$this->buyer_product_ref->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid->setVisibility();
		$this->product_gcode->setVisibility();
		$this->batch_no->setVisibility();
		$this->quantity->setVisibility();
		$this->jc_no->Visible = FALSE;
		$this->balance_quantity->Visible = FALSE;
		$this->price->setVisibility();
		$this->buyer_order_no->setVisibility();
		$this->buyer_order_date->setVisibility();
		$this->buyer_instruction->setVisibility();
		$this->despatch_date->setVisibility();
		$this->despatch_week->setVisibility();
		$this->production_plan->setVisibility();
		$this->lot_no->setVisibility();
		$this->d_01_head->setVisibility();
		$this->description_01->setVisibility();
		$this->d_02_head->setVisibility();
		$this->description_02->setVisibility();
		$this->d_03_head->setVisibility();
		$this->description_03->setVisibility();
		$this->d_04_head->setVisibility();
		$this->description_04->setVisibility();
		$this->d_05_head->setVisibility();
		$this->description_05->setVisibility();
		$this->d_06_head->setVisibility();
		$this->description_06->setVisibility();
		$this->d_07_head->setVisibility();
		$this->description_07->setVisibility();
		$this->d_08_head->setVisibility();
		$this->description_08->setVisibility();
		$this->d_09_head->setVisibility();
		$this->description_09->setVisibility();
		$this->d_10_head->setVisibility();
		$this->description_10->setVisibility();
		$this->d_11_head->setVisibility();
		$this->description_11->setVisibility();
		$this->d_12_head->setVisibility();
		$this->description_12->setVisibility();
		$this->remarks->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->a_operator->Visible = FALSE;
		$this->a_datetime->Visible = FALSE;
		$this->production_site->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->grp->Required = FALSE;
		$this->product_gcode->Required = FALSE;
		$this->batch_no->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->buyer_product_ref);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->product_gcode);
		$this->setupLookupOptions($this->d_01_head);
		$this->setupLookupOptions($this->d_02_head);
		$this->setupLookupOptions($this->d_03_head);
		$this->setupLookupOptions($this->description_03);
		$this->setupLookupOptions($this->d_04_head);
		$this->setupLookupOptions($this->description_04);
		$this->setupLookupOptions($this->d_05_head);
		$this->setupLookupOptions($this->description_05);
		$this->setupLookupOptions($this->d_06_head);
		$this->setupLookupOptions($this->description_06);
		$this->setupLookupOptions($this->d_07_head);
		$this->setupLookupOptions($this->d_08_head);
		$this->setupLookupOptions($this->d_09_head);
		$this->setupLookupOptions($this->d_10_head);
		$this->setupLookupOptions($this->d_11_head);
		$this->setupLookupOptions($this->d_12_head);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->a_operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("po_fplist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "po_fplist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 'po' first before field var 'x_po'
		$val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
		if (!$this->po->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po->Visible = FALSE; // Disable update for API request
			else
				$this->po->setFormValue($val);
		}

		// Check field name 'buyer_id' first before field var 'x_buyer_id'
		$val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
		if (!$this->buyer_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_id->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_id->setFormValue($val);
		}

		// Check field name 'buyer_product_ref' first before field var 'x_buyer_product_ref'
		$val = $CurrentForm->hasValue("buyer_product_ref") ? $CurrentForm->getValue("buyer_product_ref") : $CurrentForm->getValue("x_buyer_product_ref");
		if (!$this->buyer_product_ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_product_ref->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_product_ref->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid->Visible = FALSE; // Disable update for API request
			else
				$this->rid->setFormValue($val);
		}

		// Check field name 'product_gcode' first before field var 'x_product_gcode'
		$val = $CurrentForm->hasValue("product_gcode") ? $CurrentForm->getValue("product_gcode") : $CurrentForm->getValue("x_product_gcode");
		if (!$this->product_gcode->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_gcode->Visible = FALSE; // Disable update for API request
			else
				$this->product_gcode->setFormValue($val);
		}

		// Check field name 'batch_no' first before field var 'x_batch_no'
		$val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
		if (!$this->batch_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->batch_no->Visible = FALSE; // Disable update for API request
			else
				$this->batch_no->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'price' first before field var 'x_price'
		$val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
		if (!$this->price->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->price->Visible = FALSE; // Disable update for API request
			else
				$this->price->setFormValue($val);
		}

		// Check field name 'buyer_order_no' first before field var 'x_buyer_order_no'
		$val = $CurrentForm->hasValue("buyer_order_no") ? $CurrentForm->getValue("buyer_order_no") : $CurrentForm->getValue("x_buyer_order_no");
		if (!$this->buyer_order_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_order_no->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_order_no->setFormValue($val);
		}

		// Check field name 'buyer_order_date' first before field var 'x_buyer_order_date'
		$val = $CurrentForm->hasValue("buyer_order_date") ? $CurrentForm->getValue("buyer_order_date") : $CurrentForm->getValue("x_buyer_order_date");
		if (!$this->buyer_order_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_order_date->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_order_date->setFormValue($val);
			$this->buyer_order_date->CurrentValue = UnFormatDateTime($this->buyer_order_date->CurrentValue, 0);
		}

		// Check field name 'buyer_instruction' first before field var 'x_buyer_instruction'
		$val = $CurrentForm->hasValue("buyer_instruction") ? $CurrentForm->getValue("buyer_instruction") : $CurrentForm->getValue("x_buyer_instruction");
		if (!$this->buyer_instruction->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_instruction->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_instruction->setFormValue($val);
		}

		// Check field name 'despatch_date' first before field var 'x_despatch_date'
		$val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
		if (!$this->despatch_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_date->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_date->setFormValue($val);
			$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		}

		// Check field name 'despatch_week' first before field var 'x_despatch_week'
		$val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
		if (!$this->despatch_week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_week->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_week->setFormValue($val);
		}

		// Check field name 'production_plan' first before field var 'x_production_plan'
		$val = $CurrentForm->hasValue("production_plan") ? $CurrentForm->getValue("production_plan") : $CurrentForm->getValue("x_production_plan");
		if (!$this->production_plan->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->production_plan->Visible = FALSE; // Disable update for API request
			else
				$this->production_plan->setFormValue($val);
		}

		// Check field name 'lot_no' first before field var 'x_lot_no'
		$val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
		if (!$this->lot_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lot_no->Visible = FALSE; // Disable update for API request
			else
				$this->lot_no->setFormValue($val);
		}

		// Check field name 'd_01_head' first before field var 'x_d_01_head'
		$val = $CurrentForm->hasValue("d_01_head") ? $CurrentForm->getValue("d_01_head") : $CurrentForm->getValue("x_d_01_head");
		if (!$this->d_01_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_01_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_01_head->setFormValue($val);
		}

		// Check field name 'description_01' first before field var 'x_description_01'
		$val = $CurrentForm->hasValue("description_01") ? $CurrentForm->getValue("description_01") : $CurrentForm->getValue("x_description_01");
		if (!$this->description_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_01->Visible = FALSE; // Disable update for API request
			else
				$this->description_01->setFormValue($val);
		}

		// Check field name 'd_02_head' first before field var 'x_d_02_head'
		$val = $CurrentForm->hasValue("d_02_head") ? $CurrentForm->getValue("d_02_head") : $CurrentForm->getValue("x_d_02_head");
		if (!$this->d_02_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_02_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_02_head->setFormValue($val);
		}

		// Check field name 'description_02' first before field var 'x_description_02'
		$val = $CurrentForm->hasValue("description_02") ? $CurrentForm->getValue("description_02") : $CurrentForm->getValue("x_description_02");
		if (!$this->description_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_02->Visible = FALSE; // Disable update for API request
			else
				$this->description_02->setFormValue($val);
		}

		// Check field name 'd_03_head' first before field var 'x_d_03_head'
		$val = $CurrentForm->hasValue("d_03_head") ? $CurrentForm->getValue("d_03_head") : $CurrentForm->getValue("x_d_03_head");
		if (!$this->d_03_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_03_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_03_head->setFormValue($val);
		}

		// Check field name 'description_03' first before field var 'x_description_03'
		$val = $CurrentForm->hasValue("description_03") ? $CurrentForm->getValue("description_03") : $CurrentForm->getValue("x_description_03");
		if (!$this->description_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_03->Visible = FALSE; // Disable update for API request
			else
				$this->description_03->setFormValue($val);
		}

		// Check field name 'd_04_head' first before field var 'x_d_04_head'
		$val = $CurrentForm->hasValue("d_04_head") ? $CurrentForm->getValue("d_04_head") : $CurrentForm->getValue("x_d_04_head");
		if (!$this->d_04_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_04_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_04_head->setFormValue($val);
		}

		// Check field name 'description_04' first before field var 'x_description_04'
		$val = $CurrentForm->hasValue("description_04") ? $CurrentForm->getValue("description_04") : $CurrentForm->getValue("x_description_04");
		if (!$this->description_04->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_04->Visible = FALSE; // Disable update for API request
			else
				$this->description_04->setFormValue($val);
		}

		// Check field name 'd_05_head' first before field var 'x_d_05_head'
		$val = $CurrentForm->hasValue("d_05_head") ? $CurrentForm->getValue("d_05_head") : $CurrentForm->getValue("x_d_05_head");
		if (!$this->d_05_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_05_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_05_head->setFormValue($val);
		}

		// Check field name 'description_05' first before field var 'x_description_05'
		$val = $CurrentForm->hasValue("description_05") ? $CurrentForm->getValue("description_05") : $CurrentForm->getValue("x_description_05");
		if (!$this->description_05->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_05->Visible = FALSE; // Disable update for API request
			else
				$this->description_05->setFormValue($val);
		}

		// Check field name 'd_06_head' first before field var 'x_d_06_head'
		$val = $CurrentForm->hasValue("d_06_head") ? $CurrentForm->getValue("d_06_head") : $CurrentForm->getValue("x_d_06_head");
		if (!$this->d_06_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_06_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_06_head->setFormValue($val);
		}

		// Check field name 'description_06' first before field var 'x_description_06'
		$val = $CurrentForm->hasValue("description_06") ? $CurrentForm->getValue("description_06") : $CurrentForm->getValue("x_description_06");
		if (!$this->description_06->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_06->Visible = FALSE; // Disable update for API request
			else
				$this->description_06->setFormValue($val);
		}

		// Check field name 'd_07_head' first before field var 'x_d_07_head'
		$val = $CurrentForm->hasValue("d_07_head") ? $CurrentForm->getValue("d_07_head") : $CurrentForm->getValue("x_d_07_head");
		if (!$this->d_07_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_07_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_07_head->setFormValue($val);
		}

		// Check field name 'description_07' first before field var 'x_description_07'
		$val = $CurrentForm->hasValue("description_07") ? $CurrentForm->getValue("description_07") : $CurrentForm->getValue("x_description_07");
		if (!$this->description_07->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_07->Visible = FALSE; // Disable update for API request
			else
				$this->description_07->setFormValue($val);
		}

		// Check field name 'd_08_head' first before field var 'x_d_08_head'
		$val = $CurrentForm->hasValue("d_08_head") ? $CurrentForm->getValue("d_08_head") : $CurrentForm->getValue("x_d_08_head");
		if (!$this->d_08_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_08_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_08_head->setFormValue($val);
		}

		// Check field name 'description_08' first before field var 'x_description_08'
		$val = $CurrentForm->hasValue("description_08") ? $CurrentForm->getValue("description_08") : $CurrentForm->getValue("x_description_08");
		if (!$this->description_08->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_08->Visible = FALSE; // Disable update for API request
			else
				$this->description_08->setFormValue($val);
		}

		// Check field name 'd_09_head' first before field var 'x_d_09_head'
		$val = $CurrentForm->hasValue("d_09_head") ? $CurrentForm->getValue("d_09_head") : $CurrentForm->getValue("x_d_09_head");
		if (!$this->d_09_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_09_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_09_head->setFormValue($val);
		}

		// Check field name 'description_09' first before field var 'x_description_09'
		$val = $CurrentForm->hasValue("description_09") ? $CurrentForm->getValue("description_09") : $CurrentForm->getValue("x_description_09");
		if (!$this->description_09->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_09->Visible = FALSE; // Disable update for API request
			else
				$this->description_09->setFormValue($val);
		}

		// Check field name 'd_10_head' first before field var 'x_d_10_head'
		$val = $CurrentForm->hasValue("d_10_head") ? $CurrentForm->getValue("d_10_head") : $CurrentForm->getValue("x_d_10_head");
		if (!$this->d_10_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_10_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_10_head->setFormValue($val);
		}

		// Check field name 'description_10' first before field var 'x_description_10'
		$val = $CurrentForm->hasValue("description_10") ? $CurrentForm->getValue("description_10") : $CurrentForm->getValue("x_description_10");
		if (!$this->description_10->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_10->Visible = FALSE; // Disable update for API request
			else
				$this->description_10->setFormValue($val);
		}

		// Check field name 'd_11_head' first before field var 'x_d_11_head'
		$val = $CurrentForm->hasValue("d_11_head") ? $CurrentForm->getValue("d_11_head") : $CurrentForm->getValue("x_d_11_head");
		if (!$this->d_11_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_11_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_11_head->setFormValue($val);
		}

		// Check field name 'description_11' first before field var 'x_description_11'
		$val = $CurrentForm->hasValue("description_11") ? $CurrentForm->getValue("description_11") : $CurrentForm->getValue("x_description_11");
		if (!$this->description_11->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_11->Visible = FALSE; // Disable update for API request
			else
				$this->description_11->setFormValue($val);
		}

		// Check field name 'd_12_head' first before field var 'x_d_12_head'
		$val = $CurrentForm->hasValue("d_12_head") ? $CurrentForm->getValue("d_12_head") : $CurrentForm->getValue("x_d_12_head");
		if (!$this->d_12_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_12_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_12_head->setFormValue($val);
		}

		// Check field name 'description_12' first before field var 'x_description_12'
		$val = $CurrentForm->hasValue("description_12") ? $CurrentForm->getValue("description_12") : $CurrentForm->getValue("x_description_12");
		if (!$this->description_12->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_12->Visible = FALSE; // Disable update for API request
			else
				$this->description_12->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'production_site' first before field var 'x_production_site'
		$val = $CurrentForm->hasValue("production_site") ? $CurrentForm->getValue("production_site") : $CurrentForm->getValue("x_production_site");
		if (!$this->production_site->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->production_site->Visible = FALSE; // Disable update for API request
			else
				$this->production_site->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->po->CurrentValue = $this->po->FormValue;
		$this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
		$this->buyer_product_ref->CurrentValue = $this->buyer_product_ref->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->rid->CurrentValue = $this->rid->FormValue;
		$this->product_gcode->CurrentValue = $this->product_gcode->FormValue;
		$this->batch_no->CurrentValue = $this->batch_no->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->price->CurrentValue = $this->price->FormValue;
		$this->buyer_order_no->CurrentValue = $this->buyer_order_no->FormValue;
		$this->buyer_order_date->CurrentValue = $this->buyer_order_date->FormValue;
		$this->buyer_order_date->CurrentValue = UnFormatDateTime($this->buyer_order_date->CurrentValue, 0);
		$this->buyer_instruction->CurrentValue = $this->buyer_instruction->FormValue;
		$this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
		$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		$this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
		$this->production_plan->CurrentValue = $this->production_plan->FormValue;
		$this->lot_no->CurrentValue = $this->lot_no->FormValue;
		$this->d_01_head->CurrentValue = $this->d_01_head->FormValue;
		$this->description_01->CurrentValue = $this->description_01->FormValue;
		$this->d_02_head->CurrentValue = $this->d_02_head->FormValue;
		$this->description_02->CurrentValue = $this->description_02->FormValue;
		$this->d_03_head->CurrentValue = $this->d_03_head->FormValue;
		$this->description_03->CurrentValue = $this->description_03->FormValue;
		$this->d_04_head->CurrentValue = $this->d_04_head->FormValue;
		$this->description_04->CurrentValue = $this->description_04->FormValue;
		$this->d_05_head->CurrentValue = $this->d_05_head->FormValue;
		$this->description_05->CurrentValue = $this->description_05->FormValue;
		$this->d_06_head->CurrentValue = $this->d_06_head->FormValue;
		$this->description_06->CurrentValue = $this->description_06->FormValue;
		$this->d_07_head->CurrentValue = $this->d_07_head->FormValue;
		$this->description_07->CurrentValue = $this->description_07->FormValue;
		$this->d_08_head->CurrentValue = $this->d_08_head->FormValue;
		$this->description_08->CurrentValue = $this->description_08->FormValue;
		$this->d_09_head->CurrentValue = $this->d_09_head->FormValue;
		$this->description_09->CurrentValue = $this->description_09->FormValue;
		$this->d_10_head->CurrentValue = $this->d_10_head->FormValue;
		$this->description_10->CurrentValue = $this->description_10->FormValue;
		$this->d_11_head->CurrentValue = $this->d_11_head->FormValue;
		$this->description_11->CurrentValue = $this->description_11->FormValue;
		$this->d_12_head->CurrentValue = $this->d_12_head->FormValue;
		$this->description_12->CurrentValue = $this->description_12->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->production_site->CurrentValue = $this->production_site->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->grp->setDbValue($row['grp']);
		$this->po->setDbValue($row['po']);
		$this->buyer_id->setDbValue($row['buyer_id']);
		$this->buyer_product_ref->setDbValue($row['buyer_product_ref']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->rid->setDbValue($row['rid']);
		$this->product_gcode->setDbValue($row['product_gcode']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->quantity->setDbValue($row['quantity']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->balance_quantity->setDbValue($row['balance_quantity']);
		$this->price->setDbValue($row['price']);
		$this->buyer_order_no->setDbValue($row['buyer_order_no']);
		$this->buyer_order_date->setDbValue($row['buyer_order_date']);
		$this->buyer_instruction->setDbValue($row['buyer_instruction']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->despatch_week->setDbValue($row['despatch_week']);
		$this->production_plan->setDbValue($row['production_plan']);
		$this->lot_no->setDbValue($row['lot_no']);
		$this->d_01_head->setDbValue($row['d_01_head']);
		$this->description_01->setDbValue($row['description_01']);
		$this->d_02_head->setDbValue($row['d_02_head']);
		$this->description_02->setDbValue($row['description_02']);
		$this->d_03_head->setDbValue($row['d_03_head']);
		$this->description_03->setDbValue($row['description_03']);
		$this->d_04_head->setDbValue($row['d_04_head']);
		$this->description_04->setDbValue($row['description_04']);
		$this->d_05_head->setDbValue($row['d_05_head']);
		$this->description_05->setDbValue($row['description_05']);
		$this->d_06_head->setDbValue($row['d_06_head']);
		$this->description_06->setDbValue($row['description_06']);
		$this->d_07_head->setDbValue($row['d_07_head']);
		$this->description_07->setDbValue($row['description_07']);
		$this->d_08_head->setDbValue($row['d_08_head']);
		$this->description_08->setDbValue($row['description_08']);
		$this->d_09_head->setDbValue($row['d_09_head']);
		$this->description_09->setDbValue($row['description_09']);
		$this->d_10_head->setDbValue($row['d_10_head']);
		$this->description_10->setDbValue($row['description_10']);
		$this->d_11_head->setDbValue($row['d_11_head']);
		$this->description_11->setDbValue($row['description_11']);
		$this->d_12_head->setDbValue($row['d_12_head']);
		$this->description_12->setDbValue($row['description_12']);
		$this->remarks->setDbValue($row['remarks']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->a_datetime->setDbValue($row['a_datetime']);
		$this->production_site->setDbValue($row['production_site']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['grp'] = NULL;
		$row['po'] = NULL;
		$row['buyer_id'] = NULL;
		$row['buyer_product_ref'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['rid'] = NULL;
		$row['product_gcode'] = NULL;
		$row['batch_no'] = NULL;
		$row['quantity'] = NULL;
		$row['jc_no'] = NULL;
		$row['balance_quantity'] = NULL;
		$row['price'] = NULL;
		$row['buyer_order_no'] = NULL;
		$row['buyer_order_date'] = NULL;
		$row['buyer_instruction'] = NULL;
		$row['despatch_date'] = NULL;
		$row['despatch_week'] = NULL;
		$row['production_plan'] = NULL;
		$row['lot_no'] = NULL;
		$row['d_01_head'] = NULL;
		$row['description_01'] = NULL;
		$row['d_02_head'] = NULL;
		$row['description_02'] = NULL;
		$row['d_03_head'] = NULL;
		$row['description_03'] = NULL;
		$row['d_04_head'] = NULL;
		$row['description_04'] = NULL;
		$row['d_05_head'] = NULL;
		$row['description_05'] = NULL;
		$row['d_06_head'] = NULL;
		$row['description_06'] = NULL;
		$row['d_07_head'] = NULL;
		$row['description_07'] = NULL;
		$row['d_08_head'] = NULL;
		$row['description_08'] = NULL;
		$row['d_09_head'] = NULL;
		$row['description_09'] = NULL;
		$row['d_10_head'] = NULL;
		$row['description_10'] = NULL;
		$row['d_11_head'] = NULL;
		$row['description_11'] = NULL;
		$row['d_12_head'] = NULL;
		$row['description_12'] = NULL;
		$row['remarks'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['a_operator'] = NULL;
		$row['a_datetime'] = NULL;
		$row['production_site'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->description_01->FormValue == $this->description_01->CurrentValue && is_numeric(ConvertToFloatString($this->description_01->CurrentValue)))
			$this->description_01->CurrentValue = ConvertToFloatString($this->description_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->description_02->FormValue == $this->description_02->CurrentValue && is_numeric(ConvertToFloatString($this->description_02->CurrentValue)))
			$this->description_02->CurrentValue = ConvertToFloatString($this->description_02->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// po
		// buyer_id
		// buyer_product_ref
		// s_grp
		// product
		// rid
		// product_gcode
		// batch_no
		// quantity
		// jc_no
		// balance_quantity
		// price
		// buyer_order_no
		// buyer_order_date
		// buyer_instruction
		// despatch_date
		// despatch_week
		// production_plan
		// lot_no
		// d_01_head
		// description_01
		// d_02_head
		// description_02
		// d_03_head
		// description_03
		// d_04_head
		// description_04
		// d_05_head
		// description_05
		// d_06_head
		// description_06
		// d_07_head
		// description_07
		// d_08_head
		// description_08
		// d_09_head
		// description_09
		// d_10_head
		// description_10
		// d_11_head
		// description_11
		// d_12_head
		// description_12
		// remarks
		// operator
		// datetime
		// a_operator
		// a_datetime
		// production_site

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			if (strval($this->grp->CurrentValue) <> "") {
				$this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";

			// buyer_id
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 1000 AND `grp`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// buyer_product_ref
			$curVal = strval($this->buyer_product_ref->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_product_ref->ViewValue = $this->buyer_product_ref->lookupCacheOption($curVal);
				if ($this->buyer_product_ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer_product_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_product_ref->ViewValue = $this->buyer_product_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_product_ref->ViewValue = $this->buyer_product_ref->CurrentValue;
					}
				}
			} else {
				$this->buyer_product_ref->ViewValue = NULL;
			}
			$this->buyer_product_ref->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$this->product->ViewValue = $this->product->CurrentValue;
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// product_gcode
			$curVal = strval($this->product_gcode->CurrentValue);
			if ($curVal <> "") {
				$this->product_gcode->ViewValue = $this->product_gcode->lookupCacheOption($curVal);
				if ($this->product_gcode->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`gcode`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->product_gcode->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_gcode->ViewValue = $this->product_gcode->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_gcode->ViewValue = $this->product_gcode->CurrentValue;
					}
				}
			} else {
				$this->product_gcode->ViewValue = NULL;
			}
			$this->product_gcode->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
			$this->batch_no->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewCustomAttributes = "";

			// balance_quantity
			$this->balance_quantity->ViewValue = $this->balance_quantity->CurrentValue;
			$this->balance_quantity->ViewValue = FormatNumber($this->balance_quantity->ViewValue, 2, -2, -2, -2);
			$this->balance_quantity->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// buyer_order_no
			$this->buyer_order_no->ViewValue = $this->buyer_order_no->CurrentValue;
			$this->buyer_order_no->ViewCustomAttributes = "";

			// buyer_order_date
			$this->buyer_order_date->ViewValue = $this->buyer_order_date->CurrentValue;
			$this->buyer_order_date->ViewValue = FormatDateTime($this->buyer_order_date->ViewValue, 0);
			$this->buyer_order_date->ViewCustomAttributes = "";

			// buyer_instruction
			$this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;
			$this->buyer_instruction->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// despatch_week
			$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
			$this->despatch_week->ViewCustomAttributes = "";

			// production_plan
			if (strval($this->production_plan->CurrentValue) <> "") {
				$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
			} else {
				$this->production_plan->ViewValue = NULL;
			}
			$this->production_plan->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// d_01_head
			$curVal = strval($this->d_01_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_01_head->ViewValue = $this->d_01_head->lookupCacheOption($curVal);
				if ($this->d_01_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_01_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_01_head->ViewValue = $this->d_01_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_01_head->ViewValue = $this->d_01_head->CurrentValue;
					}
				}
			} else {
				$this->d_01_head->ViewValue = NULL;
			}
			$this->d_01_head->ViewCustomAttributes = "";

			// description_01
			$this->description_01->ViewValue = $this->description_01->CurrentValue;
			$this->description_01->ViewValue = FormatNumber($this->description_01->ViewValue, 3, -2, -2, -2);
			$this->description_01->ViewCustomAttributes = "";

			// d_02_head
			$curVal = strval($this->d_02_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_02_head->ViewValue = $this->d_02_head->lookupCacheOption($curVal);
				if ($this->d_02_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_02_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_02_head->ViewValue = $this->d_02_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_02_head->ViewValue = $this->d_02_head->CurrentValue;
					}
				}
			} else {
				$this->d_02_head->ViewValue = NULL;
			}
			$this->d_02_head->ViewCustomAttributes = "";

			// description_02
			$this->description_02->ViewValue = $this->description_02->CurrentValue;
			$this->description_02->ViewValue = FormatNumber($this->description_02->ViewValue, 3, -2, -2, -2);
			$this->description_02->ViewCustomAttributes = "";

			// d_03_head
			$curVal = strval($this->d_03_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_03_head->ViewValue = $this->d_03_head->lookupCacheOption($curVal);
				if ($this->d_03_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_03_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_03_head->ViewValue = $this->d_03_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_03_head->ViewValue = $this->d_03_head->CurrentValue;
					}
				}
			} else {
				$this->d_03_head->ViewValue = NULL;
			}
			$this->d_03_head->ViewCustomAttributes = "";

			// description_03
			$curVal = strval($this->description_03->CurrentValue);
			if ($curVal <> "") {
				$this->description_03->ViewValue = $this->description_03->lookupCacheOption($curVal);
				if ($this->description_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_03->ViewValue = $this->description_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_03->ViewValue = $this->description_03->CurrentValue;
					}
				}
			} else {
				$this->description_03->ViewValue = NULL;
			}
			$this->description_03->ViewCustomAttributes = "";

			// d_04_head
			$curVal = strval($this->d_04_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_04_head->ViewValue = $this->d_04_head->lookupCacheOption($curVal);
				if ($this->d_04_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_04_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_04_head->ViewValue = $this->d_04_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_04_head->ViewValue = $this->d_04_head->CurrentValue;
					}
				}
			} else {
				$this->d_04_head->ViewValue = NULL;
			}
			$this->d_04_head->ViewCustomAttributes = "";

			// description_04
			$curVal = strval($this->description_04->CurrentValue);
			if ($curVal <> "") {
				$this->description_04->ViewValue = $this->description_04->lookupCacheOption($curVal);
				if ($this->description_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_04->ViewValue = $this->description_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_04->ViewValue = $this->description_04->CurrentValue;
					}
				}
			} else {
				$this->description_04->ViewValue = NULL;
			}
			$this->description_04->ViewCustomAttributes = "";

			// d_05_head
			$curVal = strval($this->d_05_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_05_head->ViewValue = $this->d_05_head->lookupCacheOption($curVal);
				if ($this->d_05_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_05_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_05_head->ViewValue = $this->d_05_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_05_head->ViewValue = $this->d_05_head->CurrentValue;
					}
				}
			} else {
				$this->d_05_head->ViewValue = NULL;
			}
			$this->d_05_head->ViewCustomAttributes = "";

			// description_05
			$curVal = strval($this->description_05->CurrentValue);
			if ($curVal <> "") {
				$this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
				if ($this->description_05->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_05->ViewValue = $this->description_05->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_05->ViewValue = $this->description_05->CurrentValue;
					}
				}
			} else {
				$this->description_05->ViewValue = NULL;
			}
			$this->description_05->ViewCustomAttributes = "";

			// d_06_head
			$curVal = strval($this->d_06_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_06_head->ViewValue = $this->d_06_head->lookupCacheOption($curVal);
				if ($this->d_06_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_06_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_06_head->ViewValue = $this->d_06_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_06_head->ViewValue = $this->d_06_head->CurrentValue;
					}
				}
			} else {
				$this->d_06_head->ViewValue = NULL;
			}
			$this->d_06_head->ViewCustomAttributes = "";

			// description_06
			$curVal = strval($this->description_06->CurrentValue);
			if ($curVal <> "") {
				$this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
				if ($this->description_06->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_06->ViewValue = $this->description_06->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_06->ViewValue = $this->description_06->CurrentValue;
					}
				}
			} else {
				$this->description_06->ViewValue = NULL;
			}
			$this->description_06->ViewCustomAttributes = "";

			// d_07_head
			$curVal = strval($this->d_07_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_07_head->ViewValue = $this->d_07_head->lookupCacheOption($curVal);
				if ($this->d_07_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_07_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_07_head->ViewValue = $this->d_07_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_07_head->ViewValue = $this->d_07_head->CurrentValue;
					}
				}
			} else {
				$this->d_07_head->ViewValue = NULL;
			}
			$this->d_07_head->ViewCustomAttributes = "";

			// description_07
			$this->description_07->ViewValue = $this->description_07->CurrentValue;
			$this->description_07->ViewCustomAttributes = "";

			// d_08_head
			$curVal = strval($this->d_08_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_08_head->ViewValue = $this->d_08_head->lookupCacheOption($curVal);
				if ($this->d_08_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_08_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_08_head->ViewValue = $this->d_08_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_08_head->ViewValue = $this->d_08_head->CurrentValue;
					}
				}
			} else {
				$this->d_08_head->ViewValue = NULL;
			}
			$this->d_08_head->ViewCustomAttributes = "";

			// description_08
			$this->description_08->ViewValue = $this->description_08->CurrentValue;
			$this->description_08->ViewCustomAttributes = "";

			// d_09_head
			$curVal = strval($this->d_09_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
				if ($this->d_09_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_09_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_09_head->ViewValue = $this->d_09_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_09_head->ViewValue = $this->d_09_head->CurrentValue;
					}
				}
			} else {
				$this->d_09_head->ViewValue = NULL;
			}
			$this->d_09_head->ViewCustomAttributes = "";

			// description_09
			$this->description_09->ViewValue = $this->description_09->CurrentValue;
			$this->description_09->ViewCustomAttributes = "";

			// d_10_head
			$curVal = strval($this->d_10_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
				if ($this->d_10_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_10_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_10_head->ViewValue = $this->d_10_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_10_head->ViewValue = $this->d_10_head->CurrentValue;
					}
				}
			} else {
				$this->d_10_head->ViewValue = NULL;
			}
			$this->d_10_head->ViewCustomAttributes = "";

			// description_10
			$this->description_10->ViewValue = $this->description_10->CurrentValue;
			$this->description_10->ViewCustomAttributes = "";

			// d_11_head
			$curVal = strval($this->d_11_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
				if ($this->d_11_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_11_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_11_head->ViewValue = $this->d_11_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_11_head->ViewValue = $this->d_11_head->CurrentValue;
					}
				}
			} else {
				$this->d_11_head->ViewValue = NULL;
			}
			$this->d_11_head->ViewCustomAttributes = "";

			// description_11
			$this->description_11->ViewValue = $this->description_11->CurrentValue;
			$this->description_11->ViewCustomAttributes = "";

			// d_12_head
			$curVal = strval($this->d_12_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
				if ($this->d_12_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_12_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_12_head->ViewValue = $this->d_12_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_12_head->ViewValue = $this->d_12_head->CurrentValue;
					}
				}
			} else {
				$this->d_12_head->ViewValue = NULL;
			}
			$this->d_12_head->ViewCustomAttributes = "";

			// description_12
			$this->description_12->ViewValue = $this->description_12->CurrentValue;
			$this->description_12->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// a_operator
			$curVal = strval($this->a_operator->CurrentValue);
			if ($curVal <> "") {
				$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
				if ($this->a_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
					}
				}
			} else {
				$this->a_operator->ViewValue = NULL;
			}
			$this->a_operator->ViewCustomAttributes = "";

			// a_datetime
			$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
			$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 0);
			$this->a_datetime->ViewCustomAttributes = "";

			// production_site
			$this->production_site->ViewValue = $this->production_site->CurrentValue;
			$this->production_site->ViewValue = FormatNumber($this->production_site->ViewValue, 0, -2, -2, -2);
			$this->production_site->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "po_fplist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// buyer_product_ref
			$this->buyer_product_ref->LinkCustomAttributes = "";
			$this->buyer_product_ref->HrefValue = "";
			$this->buyer_product_ref->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "po_fplist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "po_fplist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "po_fplist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";

			// product_gcode
			$this->product_gcode->LinkCustomAttributes = "";
			$this->product_gcode->HrefValue = "";
			$this->product_gcode->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// buyer_order_no
			$this->buyer_order_no->LinkCustomAttributes = "";
			$this->buyer_order_no->HrefValue = "";
			$this->buyer_order_no->TooltipValue = "";

			// buyer_order_date
			$this->buyer_order_date->LinkCustomAttributes = "";
			$this->buyer_order_date->HrefValue = "";
			$this->buyer_order_date->TooltipValue = "";

			// buyer_instruction
			$this->buyer_instruction->LinkCustomAttributes = "";
			$this->buyer_instruction->HrefValue = "";
			$this->buyer_instruction->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";
			$this->production_plan->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// d_01_head
			$this->d_01_head->LinkCustomAttributes = "";
			$this->d_01_head->HrefValue = "";
			$this->d_01_head->TooltipValue = "";

			// description_01
			$this->description_01->LinkCustomAttributes = "";
			$this->description_01->HrefValue = "";
			$this->description_01->TooltipValue = "";

			// d_02_head
			$this->d_02_head->LinkCustomAttributes = "";
			$this->d_02_head->HrefValue = "";
			$this->d_02_head->TooltipValue = "";

			// description_02
			$this->description_02->LinkCustomAttributes = "";
			$this->description_02->HrefValue = "";
			$this->description_02->TooltipValue = "";

			// d_03_head
			$this->d_03_head->LinkCustomAttributes = "";
			$this->d_03_head->HrefValue = "";
			$this->d_03_head->TooltipValue = "";

			// description_03
			$this->description_03->LinkCustomAttributes = "";
			$this->description_03->HrefValue = "";
			$this->description_03->TooltipValue = "";

			// d_04_head
			$this->d_04_head->LinkCustomAttributes = "";
			$this->d_04_head->HrefValue = "";
			$this->d_04_head->TooltipValue = "";

			// description_04
			$this->description_04->LinkCustomAttributes = "";
			$this->description_04->HrefValue = "";
			$this->description_04->TooltipValue = "";

			// d_05_head
			$this->d_05_head->LinkCustomAttributes = "";
			$this->d_05_head->HrefValue = "";
			$this->d_05_head->TooltipValue = "";

			// description_05
			$this->description_05->LinkCustomAttributes = "";
			$this->description_05->HrefValue = "";
			$this->description_05->TooltipValue = "";

			// d_06_head
			$this->d_06_head->LinkCustomAttributes = "";
			$this->d_06_head->HrefValue = "";
			$this->d_06_head->TooltipValue = "";

			// description_06
			$this->description_06->LinkCustomAttributes = "";
			$this->description_06->HrefValue = "";
			$this->description_06->TooltipValue = "";

			// d_07_head
			$this->d_07_head->LinkCustomAttributes = "";
			$this->d_07_head->HrefValue = "";
			$this->d_07_head->TooltipValue = "";

			// description_07
			$this->description_07->LinkCustomAttributes = "";
			$this->description_07->HrefValue = "";
			$this->description_07->TooltipValue = "";

			// d_08_head
			$this->d_08_head->LinkCustomAttributes = "";
			$this->d_08_head->HrefValue = "";
			$this->d_08_head->TooltipValue = "";

			// description_08
			$this->description_08->LinkCustomAttributes = "";
			$this->description_08->HrefValue = "";
			$this->description_08->TooltipValue = "";

			// d_09_head
			$this->d_09_head->LinkCustomAttributes = "";
			$this->d_09_head->HrefValue = "";
			$this->d_09_head->TooltipValue = "";

			// description_09
			$this->description_09->LinkCustomAttributes = "";
			$this->description_09->HrefValue = "";
			$this->description_09->TooltipValue = "";

			// d_10_head
			$this->d_10_head->LinkCustomAttributes = "";
			$this->d_10_head->HrefValue = "";
			$this->d_10_head->TooltipValue = "";

			// description_10
			$this->description_10->LinkCustomAttributes = "";
			$this->description_10->HrefValue = "";
			$this->description_10->TooltipValue = "";

			// d_11_head
			$this->d_11_head->LinkCustomAttributes = "";
			$this->d_11_head->HrefValue = "";
			$this->d_11_head->TooltipValue = "";

			// description_11
			$this->description_11->LinkCustomAttributes = "";
			$this->description_11->HrefValue = "";
			$this->description_11->TooltipValue = "";

			// d_12_head
			$this->d_12_head->LinkCustomAttributes = "";
			$this->d_12_head->HrefValue = "";
			$this->d_12_head->TooltipValue = "";

			// description_12
			$this->description_12->LinkCustomAttributes = "";
			$this->description_12->HrefValue = "";
			$this->description_12->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// production_site
			$this->production_site->LinkCustomAttributes = "";
			$this->production_site->HrefValue = "";
			$this->production_site->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			if (strval($this->grp->CurrentValue) <> "") {
				$this->grp->EditValue = $this->grp->optionCaption($this->grp->CurrentValue);
			} else {
				$this->grp->EditValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->CurrentValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->buyer_id->CurrentValue));
			if ($curVal <> "")
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
			else
				$this->buyer_id->ViewValue = $this->buyer_id->Lookup !== NULL && is_array($this->buyer_id->Lookup->Options) ? $curVal : NULL;
			if ($this->buyer_id->ViewValue !== NULL) { // Load from cache
				$this->buyer_id->EditValue = array_values($this->buyer_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->buyer_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` > 1000 AND `grp`=2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->buyer_id->EditValue = $arwrk;
			}

			// buyer_product_ref
			$this->buyer_product_ref->EditAttrs["class"] = "form-control";
			$this->buyer_product_ref->EditCustomAttributes = "";
			$curVal = trim(strval($this->buyer_product_ref->CurrentValue));
			if ($curVal <> "")
				$this->buyer_product_ref->ViewValue = $this->buyer_product_ref->lookupCacheOption($curVal);
			else
				$this->buyer_product_ref->ViewValue = $this->buyer_product_ref->Lookup !== NULL && is_array($this->buyer_product_ref->Lookup->Options) ? $curVal : NULL;
			if ($this->buyer_product_ref->ViewValue !== NULL) { // Load from cache
				$this->buyer_product_ref->EditValue = array_values($this->buyer_product_ref->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->buyer_product_ref->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->buyer_product_ref->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->buyer_product_ref->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$this->s_grp->EditValue = HtmlEncode($this->s_grp->CurrentValue);
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->EditValue = HtmlEncode($this->s_grp->CurrentValue);
					}
				}
			} else {
				$this->s_grp->EditValue = NULL;
			}
			$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$this->product->EditValue = HtmlEncode($this->product->CurrentValue);
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->EditValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->product->EditValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->EditValue = HtmlEncode($this->product->CurrentValue);
					}
				}
			} else {
				$this->product->EditValue = NULL;
			}
			$this->product->PlaceHolder = RemoveHtml($this->product->caption());

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->rid->EditValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
					}
				}
			} else {
				$this->rid->EditValue = NULL;
			}
			$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

			// product_gcode
			$this->product_gcode->EditAttrs["class"] = "form-control";
			$this->product_gcode->EditCustomAttributes = "";
			$curVal = strval($this->product_gcode->CurrentValue);
			if ($curVal <> "") {
				$this->product_gcode->EditValue = $this->product_gcode->lookupCacheOption($curVal);
				if ($this->product_gcode->EditValue === NULL) { // Lookup from database
					$filterWrk = "`gcode`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->product_gcode->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_gcode->EditValue = $this->product_gcode->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_gcode->EditValue = $this->product_gcode->CurrentValue;
					}
				}
			} else {
				$this->product_gcode->EditValue = NULL;
			}
			$this->product_gcode->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$this->batch_no->EditValue = $this->batch_no->CurrentValue;
			$this->batch_no->ViewCustomAttributes = "";

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = HtmlEncode($this->price->CurrentValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());
			if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
				$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, -2);

			// buyer_order_no
			$this->buyer_order_no->EditAttrs["class"] = "form-control";
			$this->buyer_order_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_order_no->CurrentValue = HtmlDecode($this->buyer_order_no->CurrentValue);
			$this->buyer_order_no->EditValue = HtmlEncode($this->buyer_order_no->CurrentValue);
			$this->buyer_order_no->PlaceHolder = RemoveHtml($this->buyer_order_no->caption());

			// buyer_order_date
			$this->buyer_order_date->EditAttrs["class"] = "form-control";
			$this->buyer_order_date->EditCustomAttributes = "";
			$this->buyer_order_date->EditValue = HtmlEncode(FormatDateTime($this->buyer_order_date->CurrentValue, 8));
			$this->buyer_order_date->PlaceHolder = RemoveHtml($this->buyer_order_date->caption());

			// buyer_instruction
			$this->buyer_instruction->EditAttrs["class"] = "form-control";
			$this->buyer_instruction->EditCustomAttributes = "";
			$this->buyer_instruction->EditValue = HtmlEncode($this->buyer_instruction->CurrentValue);
			$this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

			// despatch_date
			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = HtmlEncode(FormatDateTime($this->despatch_date->CurrentValue, 8));
			$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$this->despatch_week->EditValue = HtmlEncode($this->despatch_week->CurrentValue);
			$this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

			// production_plan
			$this->production_plan->EditAttrs["class"] = "form-control";
			$this->production_plan->EditCustomAttributes = "";
			$this->production_plan->EditValue = $this->production_plan->options(TRUE);

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
			$this->lot_no->EditValue = HtmlEncode($this->lot_no->CurrentValue);
			$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

			// d_01_head
			$this->d_01_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_01_head->CurrentValue));
			if ($curVal <> "")
				$this->d_01_head->ViewValue = $this->d_01_head->lookupCacheOption($curVal);
			else
				$this->d_01_head->ViewValue = $this->d_01_head->Lookup !== NULL && is_array($this->d_01_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_01_head->ViewValue !== NULL) { // Load from cache
				$this->d_01_head->EditValue = array_values($this->d_01_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_01_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_01_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_01_head->EditValue = $arwrk;
			}

			// description_01
			$this->description_01->EditAttrs["class"] = "form-control";
			$this->description_01->EditCustomAttributes = "";
			$this->description_01->EditValue = HtmlEncode($this->description_01->CurrentValue);
			$this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());
			if (strval($this->description_01->EditValue) <> "" && is_numeric($this->description_01->EditValue))
				$this->description_01->EditValue = FormatNumber($this->description_01->EditValue, -2, -2, -2, -2);

			// d_02_head
			$this->d_02_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_02_head->CurrentValue));
			if ($curVal <> "")
				$this->d_02_head->ViewValue = $this->d_02_head->lookupCacheOption($curVal);
			else
				$this->d_02_head->ViewValue = $this->d_02_head->Lookup !== NULL && is_array($this->d_02_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_02_head->ViewValue !== NULL) { // Load from cache
				$this->d_02_head->EditValue = array_values($this->d_02_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_02_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_02_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_02_head->EditValue = $arwrk;
			}

			// description_02
			$this->description_02->EditAttrs["class"] = "form-control";
			$this->description_02->EditCustomAttributes = "";
			$this->description_02->EditValue = HtmlEncode($this->description_02->CurrentValue);
			$this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());
			if (strval($this->description_02->EditValue) <> "" && is_numeric($this->description_02->EditValue))
				$this->description_02->EditValue = FormatNumber($this->description_02->EditValue, -2, -2, -2, -2);

			// d_03_head
			$this->d_03_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_03_head->CurrentValue));
			if ($curVal <> "")
				$this->d_03_head->ViewValue = $this->d_03_head->lookupCacheOption($curVal);
			else
				$this->d_03_head->ViewValue = $this->d_03_head->Lookup !== NULL && is_array($this->d_03_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_03_head->ViewValue !== NULL) { // Load from cache
				$this->d_03_head->EditValue = array_values($this->d_03_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_03_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_03_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_03_head->EditValue = $arwrk;
			}

			// description_03
			$this->description_03->EditAttrs["class"] = "form-control";
			$this->description_03->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_03->CurrentValue));
			if ($curVal <> "")
				$this->description_03->ViewValue = $this->description_03->lookupCacheOption($curVal);
			else
				$this->description_03->ViewValue = $this->description_03->Lookup !== NULL && is_array($this->description_03->Lookup->Options) ? $curVal : NULL;
			if ($this->description_03->ViewValue !== NULL) { // Load from cache
				$this->description_03->EditValue = array_values($this->description_03->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->description_03->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_03->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->description_03->EditValue = $arwrk;
			}

			// d_04_head
			$this->d_04_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_04_head->CurrentValue));
			if ($curVal <> "")
				$this->d_04_head->ViewValue = $this->d_04_head->lookupCacheOption($curVal);
			else
				$this->d_04_head->ViewValue = $this->d_04_head->Lookup !== NULL && is_array($this->d_04_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_04_head->ViewValue !== NULL) { // Load from cache
				$this->d_04_head->EditValue = array_values($this->d_04_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_04_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_04_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_04_head->EditValue = $arwrk;
			}

			// description_04
			$this->description_04->EditAttrs["class"] = "form-control";
			$this->description_04->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_04->CurrentValue));
			if ($curVal <> "")
				$this->description_04->ViewValue = $this->description_04->lookupCacheOption($curVal);
			else
				$this->description_04->ViewValue = $this->description_04->Lookup !== NULL && is_array($this->description_04->Lookup->Options) ? $curVal : NULL;
			if ($this->description_04->ViewValue !== NULL) { // Load from cache
				$this->description_04->EditValue = array_values($this->description_04->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->description_04->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_04->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->description_04->EditValue = $arwrk;
			}

			// d_05_head
			$this->d_05_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_05_head->CurrentValue));
			if ($curVal <> "")
				$this->d_05_head->ViewValue = $this->d_05_head->lookupCacheOption($curVal);
			else
				$this->d_05_head->ViewValue = $this->d_05_head->Lookup !== NULL && is_array($this->d_05_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_05_head->ViewValue !== NULL) { // Load from cache
				$this->d_05_head->EditValue = array_values($this->d_05_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_05_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_05_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_05_head->EditValue = $arwrk;
			}

			// description_05
			$this->description_05->EditAttrs["class"] = "form-control";
			$this->description_05->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_05->CurrentValue));
			if ($curVal <> "")
				$this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
			else
				$this->description_05->ViewValue = $this->description_05->Lookup !== NULL && is_array($this->description_05->Lookup->Options) ? $curVal : NULL;
			if ($this->description_05->ViewValue !== NULL) { // Load from cache
				$this->description_05->EditValue = array_values($this->description_05->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->description_05->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_05->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->description_05->EditValue = $arwrk;
			}

			// d_06_head
			$this->d_06_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_06_head->CurrentValue));
			if ($curVal <> "")
				$this->d_06_head->ViewValue = $this->d_06_head->lookupCacheOption($curVal);
			else
				$this->d_06_head->ViewValue = $this->d_06_head->Lookup !== NULL && is_array($this->d_06_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_06_head->ViewValue !== NULL) { // Load from cache
				$this->d_06_head->EditValue = array_values($this->d_06_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_06_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_06_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_06_head->EditValue = $arwrk;
			}

			// description_06
			$this->description_06->EditAttrs["class"] = "form-control";
			$this->description_06->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_06->CurrentValue));
			if ($curVal <> "")
				$this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
			else
				$this->description_06->ViewValue = $this->description_06->Lookup !== NULL && is_array($this->description_06->Lookup->Options) ? $curVal : NULL;
			if ($this->description_06->ViewValue !== NULL) { // Load from cache
				$this->description_06->EditValue = array_values($this->description_06->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->description_06->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_06->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->description_06->EditValue = $arwrk;
			}

			// d_07_head
			$this->d_07_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_07_head->CurrentValue));
			if ($curVal <> "")
				$this->d_07_head->ViewValue = $this->d_07_head->lookupCacheOption($curVal);
			else
				$this->d_07_head->ViewValue = $this->d_07_head->Lookup !== NULL && is_array($this->d_07_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_07_head->ViewValue !== NULL) { // Load from cache
				$this->d_07_head->EditValue = array_values($this->d_07_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_07_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_07_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_07_head->EditValue = $arwrk;
			}

			// description_07
			$this->description_07->EditAttrs["class"] = "form-control";
			$this->description_07->EditCustomAttributes = "";
			$this->description_07->EditValue = HtmlEncode($this->description_07->CurrentValue);
			$this->description_07->PlaceHolder = RemoveHtml($this->description_07->caption());

			// d_08_head
			$this->d_08_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_08_head->CurrentValue));
			if ($curVal <> "")
				$this->d_08_head->ViewValue = $this->d_08_head->lookupCacheOption($curVal);
			else
				$this->d_08_head->ViewValue = $this->d_08_head->Lookup !== NULL && is_array($this->d_08_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_08_head->ViewValue !== NULL) { // Load from cache
				$this->d_08_head->EditValue = array_values($this->d_08_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_08_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_08_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_08_head->EditValue = $arwrk;
			}

			// description_08
			$this->description_08->EditAttrs["class"] = "form-control";
			$this->description_08->EditCustomAttributes = "";
			$this->description_08->EditValue = HtmlEncode($this->description_08->CurrentValue);
			$this->description_08->PlaceHolder = RemoveHtml($this->description_08->caption());

			// d_09_head
			$this->d_09_head->EditAttrs["class"] = "form-control";
			$this->d_09_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_09_head->CurrentValue));
			if ($curVal <> "")
				$this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
			else
				$this->d_09_head->ViewValue = $this->d_09_head->Lookup !== NULL && is_array($this->d_09_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_09_head->ViewValue !== NULL) { // Load from cache
				$this->d_09_head->EditValue = array_values($this->d_09_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_09_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_09_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_09_head->EditValue = $arwrk;
			}

			// description_09
			$this->description_09->EditAttrs["class"] = "form-control";
			$this->description_09->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_09->CurrentValue = HtmlDecode($this->description_09->CurrentValue);
			$this->description_09->EditValue = HtmlEncode($this->description_09->CurrentValue);
			$this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

			// d_10_head
			$this->d_10_head->EditAttrs["class"] = "form-control";
			$this->d_10_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_10_head->CurrentValue));
			if ($curVal <> "")
				$this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
			else
				$this->d_10_head->ViewValue = $this->d_10_head->Lookup !== NULL && is_array($this->d_10_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_10_head->ViewValue !== NULL) { // Load from cache
				$this->d_10_head->EditValue = array_values($this->d_10_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_10_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_10_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_10_head->EditValue = $arwrk;
			}

			// description_10
			$this->description_10->EditAttrs["class"] = "form-control";
			$this->description_10->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_10->CurrentValue = HtmlDecode($this->description_10->CurrentValue);
			$this->description_10->EditValue = HtmlEncode($this->description_10->CurrentValue);
			$this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());

			// d_11_head
			$this->d_11_head->EditAttrs["class"] = "form-control";
			$this->d_11_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_11_head->CurrentValue));
			if ($curVal <> "")
				$this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
			else
				$this->d_11_head->ViewValue = $this->d_11_head->Lookup !== NULL && is_array($this->d_11_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_11_head->ViewValue !== NULL) { // Load from cache
				$this->d_11_head->EditValue = array_values($this->d_11_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_11_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_11_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_11_head->EditValue = $arwrk;
			}

			// description_11
			$this->description_11->EditAttrs["class"] = "form-control";
			$this->description_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_11->CurrentValue = HtmlDecode($this->description_11->CurrentValue);
			$this->description_11->EditValue = HtmlEncode($this->description_11->CurrentValue);
			$this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

			// d_12_head
			$this->d_12_head->EditAttrs["class"] = "form-control";
			$this->d_12_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_12_head->CurrentValue));
			if ($curVal <> "")
				$this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
			else
				$this->d_12_head->ViewValue = $this->d_12_head->Lookup !== NULL && is_array($this->d_12_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_12_head->ViewValue !== NULL) { // Load from cache
				$this->d_12_head->EditValue = array_values($this->d_12_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_12_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_12_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_12_head->EditValue = $arwrk;
			}

			// description_12
			$this->description_12->EditAttrs["class"] = "form-control";
			$this->description_12->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_12->CurrentValue = HtmlDecode($this->description_12->CurrentValue);
			$this->description_12->EditValue = HtmlEncode($this->description_12->CurrentValue);
			$this->description_12->PlaceHolder = RemoveHtml($this->description_12->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// operator
			// datetime
			// production_site

			$this->production_site->EditAttrs["class"] = "form-control";
			$this->production_site->EditCustomAttributes = "";
			$this->production_site->EditValue = HtmlEncode($this->production_site->CurrentValue);
			$this->production_site->PlaceHolder = RemoveHtml($this->production_site->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "po_fplist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";

			// buyer_product_ref
			$this->buyer_product_ref->LinkCustomAttributes = "";
			$this->buyer_product_ref->HrefValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "po_fplist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "po_fplist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "po_fplist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}

			// product_gcode
			$this->product_gcode->LinkCustomAttributes = "";
			$this->product_gcode->HrefValue = "";
			$this->product_gcode->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";

			// buyer_order_no
			$this->buyer_order_no->LinkCustomAttributes = "";
			$this->buyer_order_no->HrefValue = "";

			// buyer_order_date
			$this->buyer_order_date->LinkCustomAttributes = "";
			$this->buyer_order_date->HrefValue = "";

			// buyer_instruction
			$this->buyer_instruction->LinkCustomAttributes = "";
			$this->buyer_instruction->HrefValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";

			// d_01_head
			$this->d_01_head->LinkCustomAttributes = "";
			$this->d_01_head->HrefValue = "";

			// description_01
			$this->description_01->LinkCustomAttributes = "";
			$this->description_01->HrefValue = "";

			// d_02_head
			$this->d_02_head->LinkCustomAttributes = "";
			$this->d_02_head->HrefValue = "";

			// description_02
			$this->description_02->LinkCustomAttributes = "";
			$this->description_02->HrefValue = "";

			// d_03_head
			$this->d_03_head->LinkCustomAttributes = "";
			$this->d_03_head->HrefValue = "";

			// description_03
			$this->description_03->LinkCustomAttributes = "";
			$this->description_03->HrefValue = "";

			// d_04_head
			$this->d_04_head->LinkCustomAttributes = "";
			$this->d_04_head->HrefValue = "";

			// description_04
			$this->description_04->LinkCustomAttributes = "";
			$this->description_04->HrefValue = "";

			// d_05_head
			$this->d_05_head->LinkCustomAttributes = "";
			$this->d_05_head->HrefValue = "";

			// description_05
			$this->description_05->LinkCustomAttributes = "";
			$this->description_05->HrefValue = "";

			// d_06_head
			$this->d_06_head->LinkCustomAttributes = "";
			$this->d_06_head->HrefValue = "";

			// description_06
			$this->description_06->LinkCustomAttributes = "";
			$this->description_06->HrefValue = "";

			// d_07_head
			$this->d_07_head->LinkCustomAttributes = "";
			$this->d_07_head->HrefValue = "";

			// description_07
			$this->description_07->LinkCustomAttributes = "";
			$this->description_07->HrefValue = "";

			// d_08_head
			$this->d_08_head->LinkCustomAttributes = "";
			$this->d_08_head->HrefValue = "";

			// description_08
			$this->description_08->LinkCustomAttributes = "";
			$this->description_08->HrefValue = "";

			// d_09_head
			$this->d_09_head->LinkCustomAttributes = "";
			$this->d_09_head->HrefValue = "";

			// description_09
			$this->description_09->LinkCustomAttributes = "";
			$this->description_09->HrefValue = "";

			// d_10_head
			$this->d_10_head->LinkCustomAttributes = "";
			$this->d_10_head->HrefValue = "";

			// description_10
			$this->description_10->LinkCustomAttributes = "";
			$this->description_10->HrefValue = "";

			// d_11_head
			$this->d_11_head->LinkCustomAttributes = "";
			$this->d_11_head->HrefValue = "";

			// description_11
			$this->description_11->LinkCustomAttributes = "";
			$this->description_11->HrefValue = "";

			// d_12_head
			$this->d_12_head->LinkCustomAttributes = "";
			$this->d_12_head->HrefValue = "";

			// description_12
			$this->description_12->LinkCustomAttributes = "";
			$this->description_12->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// production_site
			$this->production_site->LinkCustomAttributes = "";
			$this->production_site->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->po->Required) {
			if (!$this->po->IsDetailKey && $this->po->FormValue != NULL && $this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if ($this->buyer_id->Required) {
			if (!$this->buyer_id->IsDetailKey && $this->buyer_id->FormValue != NULL && $this->buyer_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
			}
		}
		if ($this->buyer_product_ref->Required) {
			if (!$this->buyer_product_ref->IsDetailKey && $this->buyer_product_ref->FormValue != NULL && $this->buyer_product_ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_product_ref->caption(), $this->buyer_product_ref->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->s_grp->FormValue)) {
			AddMessage($FormError, $this->s_grp->errorMessage());
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->product->FormValue)) {
			AddMessage($FormError, $this->product->errorMessage());
		}
		if ($this->rid->Required) {
			if (!$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->rid->FormValue)) {
			AddMessage($FormError, $this->rid->errorMessage());
		}
		if ($this->product_gcode->Required) {
			if (!$this->product_gcode->IsDetailKey && $this->product_gcode->FormValue != NULL && $this->product_gcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_gcode->caption(), $this->product_gcode->RequiredErrorMessage));
			}
		}
		if ($this->batch_no->Required) {
			if (!$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if ($this->jc_no->Required) {
			if (!$this->jc_no->IsDetailKey && $this->jc_no->FormValue != NULL && $this->jc_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
			}
		}
		if ($this->balance_quantity->Required) {
			if (!$this->balance_quantity->IsDetailKey && $this->balance_quantity->FormValue != NULL && $this->balance_quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->balance_quantity->caption(), $this->balance_quantity->RequiredErrorMessage));
			}
		}
		if ($this->price->Required) {
			if (!$this->price->IsDetailKey && $this->price->FormValue != NULL && $this->price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
			}
		}
		if ($this->buyer_order_no->Required) {
			if (!$this->buyer_order_no->IsDetailKey && $this->buyer_order_no->FormValue != NULL && $this->buyer_order_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_order_no->caption(), $this->buyer_order_no->RequiredErrorMessage));
			}
		}
		if ($this->buyer_order_date->Required) {
			if (!$this->buyer_order_date->IsDetailKey && $this->buyer_order_date->FormValue != NULL && $this->buyer_order_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_order_date->caption(), $this->buyer_order_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->buyer_order_date->FormValue)) {
			AddMessage($FormError, $this->buyer_order_date->errorMessage());
		}
		if ($this->buyer_instruction->Required) {
			if (!$this->buyer_instruction->IsDetailKey && $this->buyer_instruction->FormValue != NULL && $this->buyer_instruction->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_instruction->caption(), $this->buyer_instruction->RequiredErrorMessage));
			}
		}
		if ($this->despatch_date->Required) {
			if (!$this->despatch_date->IsDetailKey && $this->despatch_date->FormValue != NULL && $this->despatch_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->despatch_date->FormValue)) {
			AddMessage($FormError, $this->despatch_date->errorMessage());
		}
		if ($this->despatch_week->Required) {
			if (!$this->despatch_week->IsDetailKey && $this->despatch_week->FormValue != NULL && $this->despatch_week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->despatch_week->FormValue)) {
			AddMessage($FormError, $this->despatch_week->errorMessage());
		}
		if ($this->production_plan->Required) {
			if (!$this->production_plan->IsDetailKey && $this->production_plan->FormValue != NULL && $this->production_plan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_plan->caption(), $this->production_plan->RequiredErrorMessage));
			}
		}
		if ($this->lot_no->Required) {
			if (!$this->lot_no->IsDetailKey && $this->lot_no->FormValue != NULL && $this->lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
			}
		}
		if ($this->d_01_head->Required) {
			if ($this->d_01_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_01_head->caption(), $this->d_01_head->RequiredErrorMessage));
			}
		}
		if ($this->description_01->Required) {
			if (!$this->description_01->IsDetailKey && $this->description_01->FormValue != NULL && $this->description_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_01->caption(), $this->description_01->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->description_01->FormValue)) {
			AddMessage($FormError, $this->description_01->errorMessage());
		}
		if ($this->d_02_head->Required) {
			if ($this->d_02_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_02_head->caption(), $this->d_02_head->RequiredErrorMessage));
			}
		}
		if ($this->description_02->Required) {
			if (!$this->description_02->IsDetailKey && $this->description_02->FormValue != NULL && $this->description_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_02->caption(), $this->description_02->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->description_02->FormValue)) {
			AddMessage($FormError, $this->description_02->errorMessage());
		}
		if ($this->d_03_head->Required) {
			if ($this->d_03_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_03_head->caption(), $this->d_03_head->RequiredErrorMessage));
			}
		}
		if ($this->description_03->Required) {
			if (!$this->description_03->IsDetailKey && $this->description_03->FormValue != NULL && $this->description_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_03->caption(), $this->description_03->RequiredErrorMessage));
			}
		}
		if ($this->d_04_head->Required) {
			if ($this->d_04_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_04_head->caption(), $this->d_04_head->RequiredErrorMessage));
			}
		}
		if ($this->description_04->Required) {
			if (!$this->description_04->IsDetailKey && $this->description_04->FormValue != NULL && $this->description_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_04->caption(), $this->description_04->RequiredErrorMessage));
			}
		}
		if ($this->d_05_head->Required) {
			if ($this->d_05_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_05_head->caption(), $this->d_05_head->RequiredErrorMessage));
			}
		}
		if ($this->description_05->Required) {
			if (!$this->description_05->IsDetailKey && $this->description_05->FormValue != NULL && $this->description_05->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_05->caption(), $this->description_05->RequiredErrorMessage));
			}
		}
		if ($this->d_06_head->Required) {
			if ($this->d_06_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_06_head->caption(), $this->d_06_head->RequiredErrorMessage));
			}
		}
		if ($this->description_06->Required) {
			if (!$this->description_06->IsDetailKey && $this->description_06->FormValue != NULL && $this->description_06->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_06->caption(), $this->description_06->RequiredErrorMessage));
			}
		}
		if ($this->d_07_head->Required) {
			if ($this->d_07_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_07_head->caption(), $this->d_07_head->RequiredErrorMessage));
			}
		}
		if ($this->description_07->Required) {
			if (!$this->description_07->IsDetailKey && $this->description_07->FormValue != NULL && $this->description_07->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_07->caption(), $this->description_07->RequiredErrorMessage));
			}
		}
		if ($this->d_08_head->Required) {
			if ($this->d_08_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_08_head->caption(), $this->d_08_head->RequiredErrorMessage));
			}
		}
		if ($this->description_08->Required) {
			if (!$this->description_08->IsDetailKey && $this->description_08->FormValue != NULL && $this->description_08->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_08->caption(), $this->description_08->RequiredErrorMessage));
			}
		}
		if ($this->d_09_head->Required) {
			if (!$this->d_09_head->IsDetailKey && $this->d_09_head->FormValue != NULL && $this->d_09_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_09_head->caption(), $this->d_09_head->RequiredErrorMessage));
			}
		}
		if ($this->description_09->Required) {
			if (!$this->description_09->IsDetailKey && $this->description_09->FormValue != NULL && $this->description_09->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_09->caption(), $this->description_09->RequiredErrorMessage));
			}
		}
		if ($this->d_10_head->Required) {
			if (!$this->d_10_head->IsDetailKey && $this->d_10_head->FormValue != NULL && $this->d_10_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_10_head->caption(), $this->d_10_head->RequiredErrorMessage));
			}
		}
		if ($this->description_10->Required) {
			if (!$this->description_10->IsDetailKey && $this->description_10->FormValue != NULL && $this->description_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_10->caption(), $this->description_10->RequiredErrorMessage));
			}
		}
		if ($this->d_11_head->Required) {
			if (!$this->d_11_head->IsDetailKey && $this->d_11_head->FormValue != NULL && $this->d_11_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_11_head->caption(), $this->d_11_head->RequiredErrorMessage));
			}
		}
		if ($this->description_11->Required) {
			if (!$this->description_11->IsDetailKey && $this->description_11->FormValue != NULL && $this->description_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_11->caption(), $this->description_11->RequiredErrorMessage));
			}
		}
		if ($this->d_12_head->Required) {
			if (!$this->d_12_head->IsDetailKey && $this->d_12_head->FormValue != NULL && $this->d_12_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_12_head->caption(), $this->d_12_head->RequiredErrorMessage));
			}
		}
		if ($this->description_12->Required) {
			if (!$this->description_12->IsDetailKey && $this->description_12->FormValue != NULL && $this->description_12->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_12->caption(), $this->description_12->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->a_operator->Required) {
			if (!$this->a_operator->IsDetailKey && $this->a_operator->FormValue != NULL && $this->a_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_operator->caption(), $this->a_operator->RequiredErrorMessage));
			}
		}
		if ($this->a_datetime->Required) {
			if (!$this->a_datetime->IsDetailKey && $this->a_datetime->FormValue != NULL && $this->a_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_datetime->caption(), $this->a_datetime->RequiredErrorMessage));
			}
		}
		if ($this->production_site->Required) {
			if (!$this->production_site->IsDetailKey && $this->production_site->FormValue != NULL && $this->production_site->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_site->caption(), $this->production_site->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->production_site->FormValue)) {
			AddMessage($FormError, $this->production_site->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// po
			$this->po->setDbValueDef($rsnew, $this->po->CurrentValue, 0, $this->po->ReadOnly);

			// buyer_id
			$this->buyer_id->setDbValueDef($rsnew, $this->buyer_id->CurrentValue, 0, $this->buyer_id->ReadOnly);

			// buyer_product_ref
			$this->buyer_product_ref->setDbValueDef($rsnew, $this->buyer_product_ref->CurrentValue, NULL, $this->buyer_product_ref->ReadOnly);

			// s_grp
			$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, 0, $this->s_grp->ReadOnly);

			// product
			$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, NULL, $this->product->ReadOnly);

			// rid
			$this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, NULL, $this->rid->ReadOnly);

			// quantity
			$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, NULL, $this->quantity->ReadOnly);

			// price
			$this->price->setDbValueDef($rsnew, $this->price->CurrentValue, NULL, $this->price->ReadOnly);

			// buyer_order_no
			$this->buyer_order_no->setDbValueDef($rsnew, $this->buyer_order_no->CurrentValue, NULL, $this->buyer_order_no->ReadOnly);

			// buyer_order_date
			$this->buyer_order_date->setDbValueDef($rsnew, UnFormatDateTime($this->buyer_order_date->CurrentValue, 0), NULL, $this->buyer_order_date->ReadOnly);

			// buyer_instruction
			$this->buyer_instruction->setDbValueDef($rsnew, $this->buyer_instruction->CurrentValue, NULL, $this->buyer_instruction->ReadOnly);

			// despatch_date
			$this->despatch_date->setDbValueDef($rsnew, UnFormatDateTime($this->despatch_date->CurrentValue, 0), CurrentDate(), $this->despatch_date->ReadOnly);

			// despatch_week
			$this->despatch_week->setDbValueDef($rsnew, $this->despatch_week->CurrentValue, NULL, $this->despatch_week->ReadOnly);

			// production_plan
			$this->production_plan->setDbValueDef($rsnew, $this->production_plan->CurrentValue, NULL, $this->production_plan->ReadOnly);

			// lot_no
			$this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, NULL, $this->lot_no->ReadOnly);

			// d_01_head
			$this->d_01_head->setDbValueDef($rsnew, $this->d_01_head->CurrentValue, NULL, $this->d_01_head->ReadOnly);

			// description_01
			$this->description_01->setDbValueDef($rsnew, $this->description_01->CurrentValue, NULL, $this->description_01->ReadOnly);

			// d_02_head
			$this->d_02_head->setDbValueDef($rsnew, $this->d_02_head->CurrentValue, NULL, $this->d_02_head->ReadOnly);

			// description_02
			$this->description_02->setDbValueDef($rsnew, $this->description_02->CurrentValue, NULL, $this->description_02->ReadOnly);

			// d_03_head
			$this->d_03_head->setDbValueDef($rsnew, $this->d_03_head->CurrentValue, NULL, $this->d_03_head->ReadOnly);

			// description_03
			$this->description_03->setDbValueDef($rsnew, $this->description_03->CurrentValue, NULL, $this->description_03->ReadOnly);

			// d_04_head
			$this->d_04_head->setDbValueDef($rsnew, $this->d_04_head->CurrentValue, NULL, $this->d_04_head->ReadOnly);

			// description_04
			$this->description_04->setDbValueDef($rsnew, $this->description_04->CurrentValue, NULL, $this->description_04->ReadOnly);

			// d_05_head
			$this->d_05_head->setDbValueDef($rsnew, $this->d_05_head->CurrentValue, NULL, $this->d_05_head->ReadOnly);

			// description_05
			$this->description_05->setDbValueDef($rsnew, $this->description_05->CurrentValue, NULL, $this->description_05->ReadOnly);

			// d_06_head
			$this->d_06_head->setDbValueDef($rsnew, $this->d_06_head->CurrentValue, NULL, $this->d_06_head->ReadOnly);

			// description_06
			$this->description_06->setDbValueDef($rsnew, $this->description_06->CurrentValue, NULL, $this->description_06->ReadOnly);

			// d_07_head
			$this->d_07_head->setDbValueDef($rsnew, $this->d_07_head->CurrentValue, NULL, $this->d_07_head->ReadOnly);

			// description_07
			$this->description_07->setDbValueDef($rsnew, $this->description_07->CurrentValue, NULL, $this->description_07->ReadOnly);

			// d_08_head
			$this->d_08_head->setDbValueDef($rsnew, $this->d_08_head->CurrentValue, NULL, $this->d_08_head->ReadOnly);

			// description_08
			$this->description_08->setDbValueDef($rsnew, $this->description_08->CurrentValue, NULL, $this->description_08->ReadOnly);

			// d_09_head
			$this->d_09_head->setDbValueDef($rsnew, $this->d_09_head->CurrentValue, NULL, $this->d_09_head->ReadOnly);

			// description_09
			$this->description_09->setDbValueDef($rsnew, $this->description_09->CurrentValue, NULL, $this->description_09->ReadOnly);

			// d_10_head
			$this->d_10_head->setDbValueDef($rsnew, $this->d_10_head->CurrentValue, NULL, $this->d_10_head->ReadOnly);

			// description_10
			$this->description_10->setDbValueDef($rsnew, $this->description_10->CurrentValue, NULL, $this->description_10->ReadOnly);

			// d_11_head
			$this->d_11_head->setDbValueDef($rsnew, $this->d_11_head->CurrentValue, NULL, $this->d_11_head->ReadOnly);

			// description_11
			$this->description_11->setDbValueDef($rsnew, $this->description_11->CurrentValue, NULL, $this->description_11->ReadOnly);

			// d_12_head
			$this->d_12_head->setDbValueDef($rsnew, $this->d_12_head->CurrentValue, NULL, $this->d_12_head->ReadOnly);

			// description_12
			$this->description_12->setDbValueDef($rsnew, $this->description_12->CurrentValue, NULL, $this->description_12->ReadOnly);

			// remarks
			$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, $this->remarks->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// production_site
			$this->production_site->setDbValueDef($rsnew, $this->production_site->CurrentValue, 0, $this->production_site->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("po_fplist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Style = "tabs";
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_buyer_id":
					$lookupFilter = function() {
						return "`id` > 1000 AND `grp`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_03":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_04":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_05":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_06":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyer_id":
							break;
						case "x_buyer_product_ref":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_product_gcode":
							break;
						case "x_d_01_head":
							break;
						case "x_d_02_head":
							break;
						case "x_d_03_head":
							break;
						case "x_description_03":
							break;
						case "x_d_04_head":
							break;
						case "x_description_04":
							break;
						case "x_d_05_head":
							break;
						case "x_description_05":
							break;
						case "x_d_06_head":
							break;
						case "x_description_06":
							break;
						case "x_d_07_head":
							break;
						case "x_d_08_head":
							break;
						case "x_d_09_head":
							break;
						case "x_d_10_head":
							break;
						case "x_d_11_head":
							break;
						case "x_d_12_head":
							break;
						case "x_operator":
							break;
						case "x_a_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
			PageFieldValidate($this,'po_fp');
			$this->grp->ReadOnly = True;
			$this->product_gcode->ReadOnly = True;
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>