<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class po_fp_list extends po_fp
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'po_fp';

	// Page object name
	public $PageObjName = "po_fp_list";

	// Grid form hidden field names
	public $FormName = "fpo_fplist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (po_fp)
		if (!isset($GLOBALS["po_fp"]) || get_class($GLOBALS["po_fp"]) == PROJECT_NAMESPACE . "po_fp") {
			$GLOBALS["po_fp"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["po_fp"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "po_fpadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "po_fpdelete.php";
		$this->MultiUpdateUrl = "po_fpupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_fp');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fpo_fplistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $po_fp;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($po_fp);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->a_operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->a_datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->grp->Visible = FALSE;
		$this->po->setVisibility();
		$this->buyer_id->setVisibility();
		$this->buyer_product_ref->setVisibility();
		$this->s_grp->Visible = FALSE;
		$this->product->Visible = FALSE;
		$this->rid->setVisibility();
		$this->product_gcode->Visible = FALSE;
		$this->batch_no->setVisibility();
		$this->quantity->setVisibility();
		$this->jc_no->Visible = FALSE;
		$this->balance_quantity->setVisibility();
		$this->price->setVisibility();
		$this->buyer_order_no->setVisibility();
		$this->buyer_order_date->setVisibility();
		$this->buyer_instruction->Visible = FALSE;
		$this->despatch_date->setVisibility();
		$this->despatch_week->setVisibility();
		$this->production_plan->setVisibility();
		$this->lot_no->setVisibility();
		$this->d_01_head->Visible = FALSE;
		$this->description_01->Visible = FALSE;
		$this->d_02_head->Visible = FALSE;
		$this->description_02->Visible = FALSE;
		$this->d_03_head->Visible = FALSE;
		$this->description_03->Visible = FALSE;
		$this->d_04_head->Visible = FALSE;
		$this->description_04->Visible = FALSE;
		$this->d_05_head->Visible = FALSE;
		$this->description_05->Visible = FALSE;
		$this->d_06_head->Visible = FALSE;
		$this->description_06->Visible = FALSE;
		$this->d_07_head->Visible = FALSE;
		$this->description_07->Visible = FALSE;
		$this->d_08_head->Visible = FALSE;
		$this->description_08->Visible = FALSE;
		$this->d_09_head->Visible = FALSE;
		$this->description_09->Visible = FALSE;
		$this->d_10_head->Visible = FALSE;
		$this->description_10->Visible = FALSE;
		$this->d_11_head->Visible = FALSE;
		$this->description_11->Visible = FALSE;
		$this->d_12_head->Visible = FALSE;
		$this->description_12->Visible = FALSE;
		$this->remarks->Visible = FALSE;
		$this->operator->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->a_operator->Visible = FALSE;
		$this->a_datetime->Visible = FALSE;
		$this->production_site->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->buyer_product_ref);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->product_gcode);
		$this->setupLookupOptions($this->d_01_head);
		$this->setupLookupOptions($this->d_02_head);
		$this->setupLookupOptions($this->d_03_head);
		$this->setupLookupOptions($this->description_03);
		$this->setupLookupOptions($this->d_04_head);
		$this->setupLookupOptions($this->description_04);
		$this->setupLookupOptions($this->d_05_head);
		$this->setupLookupOptions($this->description_05);
		$this->setupLookupOptions($this->d_06_head);
		$this->setupLookupOptions($this->description_06);
		$this->setupLookupOptions($this->d_07_head);
		$this->setupLookupOptions($this->d_08_head);
		$this->setupLookupOptions($this->d_09_head);
		$this->setupLookupOptions($this->d_10_head);
		$this->setupLookupOptions($this->d_11_head);
		$this->setupLookupOptions($this->d_12_head);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->a_operator);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fpo_fplistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
		$filterList = Concat($filterList, $this->po->AdvancedSearch->toJson(), ","); // Field po
		$filterList = Concat($filterList, $this->buyer_id->AdvancedSearch->toJson(), ","); // Field buyer_id
		$filterList = Concat($filterList, $this->buyer_product_ref->AdvancedSearch->toJson(), ","); // Field buyer_product_ref
		$filterList = Concat($filterList, $this->s_grp->AdvancedSearch->toJson(), ","); // Field s_grp
		$filterList = Concat($filterList, $this->product->AdvancedSearch->toJson(), ","); // Field product
		$filterList = Concat($filterList, $this->rid->AdvancedSearch->toJson(), ","); // Field rid
		$filterList = Concat($filterList, $this->product_gcode->AdvancedSearch->toJson(), ","); // Field product_gcode
		$filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
		$filterList = Concat($filterList, $this->balance_quantity->AdvancedSearch->toJson(), ","); // Field balance_quantity
		$filterList = Concat($filterList, $this->price->AdvancedSearch->toJson(), ","); // Field price
		$filterList = Concat($filterList, $this->buyer_order_no->AdvancedSearch->toJson(), ","); // Field buyer_order_no
		$filterList = Concat($filterList, $this->buyer_order_date->AdvancedSearch->toJson(), ","); // Field buyer_order_date
		$filterList = Concat($filterList, $this->buyer_instruction->AdvancedSearch->toJson(), ","); // Field buyer_instruction
		$filterList = Concat($filterList, $this->despatch_date->AdvancedSearch->toJson(), ","); // Field despatch_date
		$filterList = Concat($filterList, $this->production_plan->AdvancedSearch->toJson(), ","); // Field production_plan
		$filterList = Concat($filterList, $this->lot_no->AdvancedSearch->toJson(), ","); // Field lot_no
		$filterList = Concat($filterList, $this->d_01_head->AdvancedSearch->toJson(), ","); // Field d_01_head
		$filterList = Concat($filterList, $this->description_01->AdvancedSearch->toJson(), ","); // Field description_01
		$filterList = Concat($filterList, $this->d_02_head->AdvancedSearch->toJson(), ","); // Field d_02_head
		$filterList = Concat($filterList, $this->description_02->AdvancedSearch->toJson(), ","); // Field description_02
		$filterList = Concat($filterList, $this->d_03_head->AdvancedSearch->toJson(), ","); // Field d_03_head
		$filterList = Concat($filterList, $this->description_03->AdvancedSearch->toJson(), ","); // Field description_03
		$filterList = Concat($filterList, $this->d_04_head->AdvancedSearch->toJson(), ","); // Field d_04_head
		$filterList = Concat($filterList, $this->description_04->AdvancedSearch->toJson(), ","); // Field description_04
		$filterList = Concat($filterList, $this->d_05_head->AdvancedSearch->toJson(), ","); // Field d_05_head
		$filterList = Concat($filterList, $this->description_05->AdvancedSearch->toJson(), ","); // Field description_05
		$filterList = Concat($filterList, $this->d_06_head->AdvancedSearch->toJson(), ","); // Field d_06_head
		$filterList = Concat($filterList, $this->description_06->AdvancedSearch->toJson(), ","); // Field description_06
		$filterList = Concat($filterList, $this->d_07_head->AdvancedSearch->toJson(), ","); // Field d_07_head
		$filterList = Concat($filterList, $this->description_07->AdvancedSearch->toJson(), ","); // Field description_07
		$filterList = Concat($filterList, $this->d_08_head->AdvancedSearch->toJson(), ","); // Field d_08_head
		$filterList = Concat($filterList, $this->description_08->AdvancedSearch->toJson(), ","); // Field description_08
		$filterList = Concat($filterList, $this->d_09_head->AdvancedSearch->toJson(), ","); // Field d_09_head
		$filterList = Concat($filterList, $this->description_09->AdvancedSearch->toJson(), ","); // Field description_09
		$filterList = Concat($filterList, $this->d_10_head->AdvancedSearch->toJson(), ","); // Field d_10_head
		$filterList = Concat($filterList, $this->description_10->AdvancedSearch->toJson(), ","); // Field description_10
		$filterList = Concat($filterList, $this->d_11_head->AdvancedSearch->toJson(), ","); // Field d_11_head
		$filterList = Concat($filterList, $this->description_11->AdvancedSearch->toJson(), ","); // Field description_11
		$filterList = Concat($filterList, $this->d_12_head->AdvancedSearch->toJson(), ","); // Field d_12_head
		$filterList = Concat($filterList, $this->description_12->AdvancedSearch->toJson(), ","); // Field description_12
		$filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		$filterList = Concat($filterList, $this->a_operator->AdvancedSearch->toJson(), ","); // Field a_operator
		$filterList = Concat($filterList, $this->a_datetime->AdvancedSearch->toJson(), ","); // Field a_datetime
		$filterList = Concat($filterList, $this->production_site->AdvancedSearch->toJson(), ","); // Field production_site
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fpo_fplistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field grp
		$this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
		$this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
		$this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
		$this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
		$this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
		$this->grp->AdvancedSearch->save();

		// Field po
		$this->po->AdvancedSearch->SearchValue = @$filter["x_po"];
		$this->po->AdvancedSearch->SearchOperator = @$filter["z_po"];
		$this->po->AdvancedSearch->SearchCondition = @$filter["v_po"];
		$this->po->AdvancedSearch->SearchValue2 = @$filter["y_po"];
		$this->po->AdvancedSearch->SearchOperator2 = @$filter["w_po"];
		$this->po->AdvancedSearch->save();

		// Field buyer_id
		$this->buyer_id->AdvancedSearch->SearchValue = @$filter["x_buyer_id"];
		$this->buyer_id->AdvancedSearch->SearchOperator = @$filter["z_buyer_id"];
		$this->buyer_id->AdvancedSearch->SearchCondition = @$filter["v_buyer_id"];
		$this->buyer_id->AdvancedSearch->SearchValue2 = @$filter["y_buyer_id"];
		$this->buyer_id->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_id"];
		$this->buyer_id->AdvancedSearch->save();

		// Field buyer_product_ref
		$this->buyer_product_ref->AdvancedSearch->SearchValue = @$filter["x_buyer_product_ref"];
		$this->buyer_product_ref->AdvancedSearch->SearchOperator = @$filter["z_buyer_product_ref"];
		$this->buyer_product_ref->AdvancedSearch->SearchCondition = @$filter["v_buyer_product_ref"];
		$this->buyer_product_ref->AdvancedSearch->SearchValue2 = @$filter["y_buyer_product_ref"];
		$this->buyer_product_ref->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_product_ref"];
		$this->buyer_product_ref->AdvancedSearch->save();

		// Field s_grp
		$this->s_grp->AdvancedSearch->SearchValue = @$filter["x_s_grp"];
		$this->s_grp->AdvancedSearch->SearchOperator = @$filter["z_s_grp"];
		$this->s_grp->AdvancedSearch->SearchCondition = @$filter["v_s_grp"];
		$this->s_grp->AdvancedSearch->SearchValue2 = @$filter["y_s_grp"];
		$this->s_grp->AdvancedSearch->SearchOperator2 = @$filter["w_s_grp"];
		$this->s_grp->AdvancedSearch->save();

		// Field product
		$this->product->AdvancedSearch->SearchValue = @$filter["x_product"];
		$this->product->AdvancedSearch->SearchOperator = @$filter["z_product"];
		$this->product->AdvancedSearch->SearchCondition = @$filter["v_product"];
		$this->product->AdvancedSearch->SearchValue2 = @$filter["y_product"];
		$this->product->AdvancedSearch->SearchOperator2 = @$filter["w_product"];
		$this->product->AdvancedSearch->save();

		// Field rid
		$this->rid->AdvancedSearch->SearchValue = @$filter["x_rid"];
		$this->rid->AdvancedSearch->SearchOperator = @$filter["z_rid"];
		$this->rid->AdvancedSearch->SearchCondition = @$filter["v_rid"];
		$this->rid->AdvancedSearch->SearchValue2 = @$filter["y_rid"];
		$this->rid->AdvancedSearch->SearchOperator2 = @$filter["w_rid"];
		$this->rid->AdvancedSearch->save();

		// Field product_gcode
		$this->product_gcode->AdvancedSearch->SearchValue = @$filter["x_product_gcode"];
		$this->product_gcode->AdvancedSearch->SearchOperator = @$filter["z_product_gcode"];
		$this->product_gcode->AdvancedSearch->SearchCondition = @$filter["v_product_gcode"];
		$this->product_gcode->AdvancedSearch->SearchValue2 = @$filter["y_product_gcode"];
		$this->product_gcode->AdvancedSearch->SearchOperator2 = @$filter["w_product_gcode"];
		$this->product_gcode->AdvancedSearch->save();

		// Field quantity
		$this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
		$this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
		$this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
		$this->quantity->AdvancedSearch->save();

		// Field balance_quantity
		$this->balance_quantity->AdvancedSearch->SearchValue = @$filter["x_balance_quantity"];
		$this->balance_quantity->AdvancedSearch->SearchOperator = @$filter["z_balance_quantity"];
		$this->balance_quantity->AdvancedSearch->SearchCondition = @$filter["v_balance_quantity"];
		$this->balance_quantity->AdvancedSearch->SearchValue2 = @$filter["y_balance_quantity"];
		$this->balance_quantity->AdvancedSearch->SearchOperator2 = @$filter["w_balance_quantity"];
		$this->balance_quantity->AdvancedSearch->save();

		// Field price
		$this->price->AdvancedSearch->SearchValue = @$filter["x_price"];
		$this->price->AdvancedSearch->SearchOperator = @$filter["z_price"];
		$this->price->AdvancedSearch->SearchCondition = @$filter["v_price"];
		$this->price->AdvancedSearch->SearchValue2 = @$filter["y_price"];
		$this->price->AdvancedSearch->SearchOperator2 = @$filter["w_price"];
		$this->price->AdvancedSearch->save();

		// Field buyer_order_no
		$this->buyer_order_no->AdvancedSearch->SearchValue = @$filter["x_buyer_order_no"];
		$this->buyer_order_no->AdvancedSearch->SearchOperator = @$filter["z_buyer_order_no"];
		$this->buyer_order_no->AdvancedSearch->SearchCondition = @$filter["v_buyer_order_no"];
		$this->buyer_order_no->AdvancedSearch->SearchValue2 = @$filter["y_buyer_order_no"];
		$this->buyer_order_no->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_order_no"];
		$this->buyer_order_no->AdvancedSearch->save();

		// Field buyer_order_date
		$this->buyer_order_date->AdvancedSearch->SearchValue = @$filter["x_buyer_order_date"];
		$this->buyer_order_date->AdvancedSearch->SearchOperator = @$filter["z_buyer_order_date"];
		$this->buyer_order_date->AdvancedSearch->SearchCondition = @$filter["v_buyer_order_date"];
		$this->buyer_order_date->AdvancedSearch->SearchValue2 = @$filter["y_buyer_order_date"];
		$this->buyer_order_date->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_order_date"];
		$this->buyer_order_date->AdvancedSearch->save();

		// Field buyer_instruction
		$this->buyer_instruction->AdvancedSearch->SearchValue = @$filter["x_buyer_instruction"];
		$this->buyer_instruction->AdvancedSearch->SearchOperator = @$filter["z_buyer_instruction"];
		$this->buyer_instruction->AdvancedSearch->SearchCondition = @$filter["v_buyer_instruction"];
		$this->buyer_instruction->AdvancedSearch->SearchValue2 = @$filter["y_buyer_instruction"];
		$this->buyer_instruction->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_instruction"];
		$this->buyer_instruction->AdvancedSearch->save();

		// Field despatch_date
		$this->despatch_date->AdvancedSearch->SearchValue = @$filter["x_despatch_date"];
		$this->despatch_date->AdvancedSearch->SearchOperator = @$filter["z_despatch_date"];
		$this->despatch_date->AdvancedSearch->SearchCondition = @$filter["v_despatch_date"];
		$this->despatch_date->AdvancedSearch->SearchValue2 = @$filter["y_despatch_date"];
		$this->despatch_date->AdvancedSearch->SearchOperator2 = @$filter["w_despatch_date"];
		$this->despatch_date->AdvancedSearch->save();

		// Field production_plan
		$this->production_plan->AdvancedSearch->SearchValue = @$filter["x_production_plan"];
		$this->production_plan->AdvancedSearch->SearchOperator = @$filter["z_production_plan"];
		$this->production_plan->AdvancedSearch->SearchCondition = @$filter["v_production_plan"];
		$this->production_plan->AdvancedSearch->SearchValue2 = @$filter["y_production_plan"];
		$this->production_plan->AdvancedSearch->SearchOperator2 = @$filter["w_production_plan"];
		$this->production_plan->AdvancedSearch->save();

		// Field lot_no
		$this->lot_no->AdvancedSearch->SearchValue = @$filter["x_lot_no"];
		$this->lot_no->AdvancedSearch->SearchOperator = @$filter["z_lot_no"];
		$this->lot_no->AdvancedSearch->SearchCondition = @$filter["v_lot_no"];
		$this->lot_no->AdvancedSearch->SearchValue2 = @$filter["y_lot_no"];
		$this->lot_no->AdvancedSearch->SearchOperator2 = @$filter["w_lot_no"];
		$this->lot_no->AdvancedSearch->save();

		// Field d_01_head
		$this->d_01_head->AdvancedSearch->SearchValue = @$filter["x_d_01_head"];
		$this->d_01_head->AdvancedSearch->SearchOperator = @$filter["z_d_01_head"];
		$this->d_01_head->AdvancedSearch->SearchCondition = @$filter["v_d_01_head"];
		$this->d_01_head->AdvancedSearch->SearchValue2 = @$filter["y_d_01_head"];
		$this->d_01_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_01_head"];
		$this->d_01_head->AdvancedSearch->save();

		// Field description_01
		$this->description_01->AdvancedSearch->SearchValue = @$filter["x_description_01"];
		$this->description_01->AdvancedSearch->SearchOperator = @$filter["z_description_01"];
		$this->description_01->AdvancedSearch->SearchCondition = @$filter["v_description_01"];
		$this->description_01->AdvancedSearch->SearchValue2 = @$filter["y_description_01"];
		$this->description_01->AdvancedSearch->SearchOperator2 = @$filter["w_description_01"];
		$this->description_01->AdvancedSearch->save();

		// Field d_02_head
		$this->d_02_head->AdvancedSearch->SearchValue = @$filter["x_d_02_head"];
		$this->d_02_head->AdvancedSearch->SearchOperator = @$filter["z_d_02_head"];
		$this->d_02_head->AdvancedSearch->SearchCondition = @$filter["v_d_02_head"];
		$this->d_02_head->AdvancedSearch->SearchValue2 = @$filter["y_d_02_head"];
		$this->d_02_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_02_head"];
		$this->d_02_head->AdvancedSearch->save();

		// Field description_02
		$this->description_02->AdvancedSearch->SearchValue = @$filter["x_description_02"];
		$this->description_02->AdvancedSearch->SearchOperator = @$filter["z_description_02"];
		$this->description_02->AdvancedSearch->SearchCondition = @$filter["v_description_02"];
		$this->description_02->AdvancedSearch->SearchValue2 = @$filter["y_description_02"];
		$this->description_02->AdvancedSearch->SearchOperator2 = @$filter["w_description_02"];
		$this->description_02->AdvancedSearch->save();

		// Field d_03_head
		$this->d_03_head->AdvancedSearch->SearchValue = @$filter["x_d_03_head"];
		$this->d_03_head->AdvancedSearch->SearchOperator = @$filter["z_d_03_head"];
		$this->d_03_head->AdvancedSearch->SearchCondition = @$filter["v_d_03_head"];
		$this->d_03_head->AdvancedSearch->SearchValue2 = @$filter["y_d_03_head"];
		$this->d_03_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_03_head"];
		$this->d_03_head->AdvancedSearch->save();

		// Field description_03
		$this->description_03->AdvancedSearch->SearchValue = @$filter["x_description_03"];
		$this->description_03->AdvancedSearch->SearchOperator = @$filter["z_description_03"];
		$this->description_03->AdvancedSearch->SearchCondition = @$filter["v_description_03"];
		$this->description_03->AdvancedSearch->SearchValue2 = @$filter["y_description_03"];
		$this->description_03->AdvancedSearch->SearchOperator2 = @$filter["w_description_03"];
		$this->description_03->AdvancedSearch->save();

		// Field d_04_head
		$this->d_04_head->AdvancedSearch->SearchValue = @$filter["x_d_04_head"];
		$this->d_04_head->AdvancedSearch->SearchOperator = @$filter["z_d_04_head"];
		$this->d_04_head->AdvancedSearch->SearchCondition = @$filter["v_d_04_head"];
		$this->d_04_head->AdvancedSearch->SearchValue2 = @$filter["y_d_04_head"];
		$this->d_04_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_04_head"];
		$this->d_04_head->AdvancedSearch->save();

		// Field description_04
		$this->description_04->AdvancedSearch->SearchValue = @$filter["x_description_04"];
		$this->description_04->AdvancedSearch->SearchOperator = @$filter["z_description_04"];
		$this->description_04->AdvancedSearch->SearchCondition = @$filter["v_description_04"];
		$this->description_04->AdvancedSearch->SearchValue2 = @$filter["y_description_04"];
		$this->description_04->AdvancedSearch->SearchOperator2 = @$filter["w_description_04"];
		$this->description_04->AdvancedSearch->save();

		// Field d_05_head
		$this->d_05_head->AdvancedSearch->SearchValue = @$filter["x_d_05_head"];
		$this->d_05_head->AdvancedSearch->SearchOperator = @$filter["z_d_05_head"];
		$this->d_05_head->AdvancedSearch->SearchCondition = @$filter["v_d_05_head"];
		$this->d_05_head->AdvancedSearch->SearchValue2 = @$filter["y_d_05_head"];
		$this->d_05_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_05_head"];
		$this->d_05_head->AdvancedSearch->save();

		// Field description_05
		$this->description_05->AdvancedSearch->SearchValue = @$filter["x_description_05"];
		$this->description_05->AdvancedSearch->SearchOperator = @$filter["z_description_05"];
		$this->description_05->AdvancedSearch->SearchCondition = @$filter["v_description_05"];
		$this->description_05->AdvancedSearch->SearchValue2 = @$filter["y_description_05"];
		$this->description_05->AdvancedSearch->SearchOperator2 = @$filter["w_description_05"];
		$this->description_05->AdvancedSearch->save();

		// Field d_06_head
		$this->d_06_head->AdvancedSearch->SearchValue = @$filter["x_d_06_head"];
		$this->d_06_head->AdvancedSearch->SearchOperator = @$filter["z_d_06_head"];
		$this->d_06_head->AdvancedSearch->SearchCondition = @$filter["v_d_06_head"];
		$this->d_06_head->AdvancedSearch->SearchValue2 = @$filter["y_d_06_head"];
		$this->d_06_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_06_head"];
		$this->d_06_head->AdvancedSearch->save();

		// Field description_06
		$this->description_06->AdvancedSearch->SearchValue = @$filter["x_description_06"];
		$this->description_06->AdvancedSearch->SearchOperator = @$filter["z_description_06"];
		$this->description_06->AdvancedSearch->SearchCondition = @$filter["v_description_06"];
		$this->description_06->AdvancedSearch->SearchValue2 = @$filter["y_description_06"];
		$this->description_06->AdvancedSearch->SearchOperator2 = @$filter["w_description_06"];
		$this->description_06->AdvancedSearch->save();

		// Field d_07_head
		$this->d_07_head->AdvancedSearch->SearchValue = @$filter["x_d_07_head"];
		$this->d_07_head->AdvancedSearch->SearchOperator = @$filter["z_d_07_head"];
		$this->d_07_head->AdvancedSearch->SearchCondition = @$filter["v_d_07_head"];
		$this->d_07_head->AdvancedSearch->SearchValue2 = @$filter["y_d_07_head"];
		$this->d_07_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_07_head"];
		$this->d_07_head->AdvancedSearch->save();

		// Field description_07
		$this->description_07->AdvancedSearch->SearchValue = @$filter["x_description_07"];
		$this->description_07->AdvancedSearch->SearchOperator = @$filter["z_description_07"];
		$this->description_07->AdvancedSearch->SearchCondition = @$filter["v_description_07"];
		$this->description_07->AdvancedSearch->SearchValue2 = @$filter["y_description_07"];
		$this->description_07->AdvancedSearch->SearchOperator2 = @$filter["w_description_07"];
		$this->description_07->AdvancedSearch->save();

		// Field d_08_head
		$this->d_08_head->AdvancedSearch->SearchValue = @$filter["x_d_08_head"];
		$this->d_08_head->AdvancedSearch->SearchOperator = @$filter["z_d_08_head"];
		$this->d_08_head->AdvancedSearch->SearchCondition = @$filter["v_d_08_head"];
		$this->d_08_head->AdvancedSearch->SearchValue2 = @$filter["y_d_08_head"];
		$this->d_08_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_08_head"];
		$this->d_08_head->AdvancedSearch->save();

		// Field description_08
		$this->description_08->AdvancedSearch->SearchValue = @$filter["x_description_08"];
		$this->description_08->AdvancedSearch->SearchOperator = @$filter["z_description_08"];
		$this->description_08->AdvancedSearch->SearchCondition = @$filter["v_description_08"];
		$this->description_08->AdvancedSearch->SearchValue2 = @$filter["y_description_08"];
		$this->description_08->AdvancedSearch->SearchOperator2 = @$filter["w_description_08"];
		$this->description_08->AdvancedSearch->save();

		// Field d_09_head
		$this->d_09_head->AdvancedSearch->SearchValue = @$filter["x_d_09_head"];
		$this->d_09_head->AdvancedSearch->SearchOperator = @$filter["z_d_09_head"];
		$this->d_09_head->AdvancedSearch->SearchCondition = @$filter["v_d_09_head"];
		$this->d_09_head->AdvancedSearch->SearchValue2 = @$filter["y_d_09_head"];
		$this->d_09_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_09_head"];
		$this->d_09_head->AdvancedSearch->save();

		// Field description_09
		$this->description_09->AdvancedSearch->SearchValue = @$filter["x_description_09"];
		$this->description_09->AdvancedSearch->SearchOperator = @$filter["z_description_09"];
		$this->description_09->AdvancedSearch->SearchCondition = @$filter["v_description_09"];
		$this->description_09->AdvancedSearch->SearchValue2 = @$filter["y_description_09"];
		$this->description_09->AdvancedSearch->SearchOperator2 = @$filter["w_description_09"];
		$this->description_09->AdvancedSearch->save();

		// Field d_10_head
		$this->d_10_head->AdvancedSearch->SearchValue = @$filter["x_d_10_head"];
		$this->d_10_head->AdvancedSearch->SearchOperator = @$filter["z_d_10_head"];
		$this->d_10_head->AdvancedSearch->SearchCondition = @$filter["v_d_10_head"];
		$this->d_10_head->AdvancedSearch->SearchValue2 = @$filter["y_d_10_head"];
		$this->d_10_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_10_head"];
		$this->d_10_head->AdvancedSearch->save();

		// Field description_10
		$this->description_10->AdvancedSearch->SearchValue = @$filter["x_description_10"];
		$this->description_10->AdvancedSearch->SearchOperator = @$filter["z_description_10"];
		$this->description_10->AdvancedSearch->SearchCondition = @$filter["v_description_10"];
		$this->description_10->AdvancedSearch->SearchValue2 = @$filter["y_description_10"];
		$this->description_10->AdvancedSearch->SearchOperator2 = @$filter["w_description_10"];
		$this->description_10->AdvancedSearch->save();

		// Field d_11_head
		$this->d_11_head->AdvancedSearch->SearchValue = @$filter["x_d_11_head"];
		$this->d_11_head->AdvancedSearch->SearchOperator = @$filter["z_d_11_head"];
		$this->d_11_head->AdvancedSearch->SearchCondition = @$filter["v_d_11_head"];
		$this->d_11_head->AdvancedSearch->SearchValue2 = @$filter["y_d_11_head"];
		$this->d_11_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_11_head"];
		$this->d_11_head->AdvancedSearch->save();

		// Field description_11
		$this->description_11->AdvancedSearch->SearchValue = @$filter["x_description_11"];
		$this->description_11->AdvancedSearch->SearchOperator = @$filter["z_description_11"];
		$this->description_11->AdvancedSearch->SearchCondition = @$filter["v_description_11"];
		$this->description_11->AdvancedSearch->SearchValue2 = @$filter["y_description_11"];
		$this->description_11->AdvancedSearch->SearchOperator2 = @$filter["w_description_11"];
		$this->description_11->AdvancedSearch->save();

		// Field d_12_head
		$this->d_12_head->AdvancedSearch->SearchValue = @$filter["x_d_12_head"];
		$this->d_12_head->AdvancedSearch->SearchOperator = @$filter["z_d_12_head"];
		$this->d_12_head->AdvancedSearch->SearchCondition = @$filter["v_d_12_head"];
		$this->d_12_head->AdvancedSearch->SearchValue2 = @$filter["y_d_12_head"];
		$this->d_12_head->AdvancedSearch->SearchOperator2 = @$filter["w_d_12_head"];
		$this->d_12_head->AdvancedSearch->save();

		// Field description_12
		$this->description_12->AdvancedSearch->SearchValue = @$filter["x_description_12"];
		$this->description_12->AdvancedSearch->SearchOperator = @$filter["z_description_12"];
		$this->description_12->AdvancedSearch->SearchCondition = @$filter["v_description_12"];
		$this->description_12->AdvancedSearch->SearchValue2 = @$filter["y_description_12"];
		$this->description_12->AdvancedSearch->SearchOperator2 = @$filter["w_description_12"];
		$this->description_12->AdvancedSearch->save();

		// Field remarks
		$this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
		$this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
		$this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
		$this->remarks->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();

		// Field a_operator
		$this->a_operator->AdvancedSearch->SearchValue = @$filter["x_a_operator"];
		$this->a_operator->AdvancedSearch->SearchOperator = @$filter["z_a_operator"];
		$this->a_operator->AdvancedSearch->SearchCondition = @$filter["v_a_operator"];
		$this->a_operator->AdvancedSearch->SearchValue2 = @$filter["y_a_operator"];
		$this->a_operator->AdvancedSearch->SearchOperator2 = @$filter["w_a_operator"];
		$this->a_operator->AdvancedSearch->save();

		// Field a_datetime
		$this->a_datetime->AdvancedSearch->SearchValue = @$filter["x_a_datetime"];
		$this->a_datetime->AdvancedSearch->SearchOperator = @$filter["z_a_datetime"];
		$this->a_datetime->AdvancedSearch->SearchCondition = @$filter["v_a_datetime"];
		$this->a_datetime->AdvancedSearch->SearchValue2 = @$filter["y_a_datetime"];
		$this->a_datetime->AdvancedSearch->SearchOperator2 = @$filter["w_a_datetime"];
		$this->a_datetime->AdvancedSearch->save();

		// Field production_site
		$this->production_site->AdvancedSearch->SearchValue = @$filter["x_production_site"];
		$this->production_site->AdvancedSearch->SearchOperator = @$filter["z_production_site"];
		$this->production_site->AdvancedSearch->SearchCondition = @$filter["v_production_site"];
		$this->production_site->AdvancedSearch->SearchValue2 = @$filter["y_production_site"];
		$this->production_site->AdvancedSearch->SearchOperator2 = @$filter["w_production_site"];
		$this->production_site->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->grp, $default, FALSE); // grp
		$this->buildSearchSql($where, $this->po, $default, FALSE); // po
		$this->buildSearchSql($where, $this->buyer_id, $default, FALSE); // buyer_id
		$this->buildSearchSql($where, $this->buyer_product_ref, $default, FALSE); // buyer_product_ref
		$this->buildSearchSql($where, $this->s_grp, $default, FALSE); // s_grp
		$this->buildSearchSql($where, $this->product, $default, FALSE); // product
		$this->buildSearchSql($where, $this->rid, $default, FALSE); // rid
		$this->buildSearchSql($where, $this->product_gcode, $default, FALSE); // product_gcode
		$this->buildSearchSql($where, $this->quantity, $default, FALSE); // quantity
		$this->buildSearchSql($where, $this->balance_quantity, $default, FALSE); // balance_quantity
		$this->buildSearchSql($where, $this->price, $default, FALSE); // price
		$this->buildSearchSql($where, $this->buyer_order_no, $default, FALSE); // buyer_order_no
		$this->buildSearchSql($where, $this->buyer_order_date, $default, FALSE); // buyer_order_date
		$this->buildSearchSql($where, $this->buyer_instruction, $default, FALSE); // buyer_instruction
		$this->buildSearchSql($where, $this->despatch_date, $default, FALSE); // despatch_date
		$this->buildSearchSql($where, $this->production_plan, $default, FALSE); // production_plan
		$this->buildSearchSql($where, $this->lot_no, $default, FALSE); // lot_no
		$this->buildSearchSql($where, $this->d_01_head, $default, FALSE); // d_01_head
		$this->buildSearchSql($where, $this->description_01, $default, FALSE); // description_01
		$this->buildSearchSql($where, $this->d_02_head, $default, FALSE); // d_02_head
		$this->buildSearchSql($where, $this->description_02, $default, FALSE); // description_02
		$this->buildSearchSql($where, $this->d_03_head, $default, FALSE); // d_03_head
		$this->buildSearchSql($where, $this->description_03, $default, FALSE); // description_03
		$this->buildSearchSql($where, $this->d_04_head, $default, FALSE); // d_04_head
		$this->buildSearchSql($where, $this->description_04, $default, FALSE); // description_04
		$this->buildSearchSql($where, $this->d_05_head, $default, FALSE); // d_05_head
		$this->buildSearchSql($where, $this->description_05, $default, FALSE); // description_05
		$this->buildSearchSql($where, $this->d_06_head, $default, FALSE); // d_06_head
		$this->buildSearchSql($where, $this->description_06, $default, FALSE); // description_06
		$this->buildSearchSql($where, $this->d_07_head, $default, FALSE); // d_07_head
		$this->buildSearchSql($where, $this->description_07, $default, FALSE); // description_07
		$this->buildSearchSql($where, $this->d_08_head, $default, FALSE); // d_08_head
		$this->buildSearchSql($where, $this->description_08, $default, FALSE); // description_08
		$this->buildSearchSql($where, $this->d_09_head, $default, FALSE); // d_09_head
		$this->buildSearchSql($where, $this->description_09, $default, FALSE); // description_09
		$this->buildSearchSql($where, $this->d_10_head, $default, FALSE); // d_10_head
		$this->buildSearchSql($where, $this->description_10, $default, FALSE); // description_10
		$this->buildSearchSql($where, $this->d_11_head, $default, FALSE); // d_11_head
		$this->buildSearchSql($where, $this->description_11, $default, FALSE); // description_11
		$this->buildSearchSql($where, $this->d_12_head, $default, FALSE); // d_12_head
		$this->buildSearchSql($where, $this->description_12, $default, FALSE); // description_12
		$this->buildSearchSql($where, $this->remarks, $default, FALSE); // remarks
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime
		$this->buildSearchSql($where, $this->a_operator, $default, FALSE); // a_operator
		$this->buildSearchSql($where, $this->a_datetime, $default, FALSE); // a_datetime
		$this->buildSearchSql($where, $this->production_site, $default, FALSE); // production_site

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->grp->AdvancedSearch->save(); // grp
			$this->po->AdvancedSearch->save(); // po
			$this->buyer_id->AdvancedSearch->save(); // buyer_id
			$this->buyer_product_ref->AdvancedSearch->save(); // buyer_product_ref
			$this->s_grp->AdvancedSearch->save(); // s_grp
			$this->product->AdvancedSearch->save(); // product
			$this->rid->AdvancedSearch->save(); // rid
			$this->product_gcode->AdvancedSearch->save(); // product_gcode
			$this->quantity->AdvancedSearch->save(); // quantity
			$this->balance_quantity->AdvancedSearch->save(); // balance_quantity
			$this->price->AdvancedSearch->save(); // price
			$this->buyer_order_no->AdvancedSearch->save(); // buyer_order_no
			$this->buyer_order_date->AdvancedSearch->save(); // buyer_order_date
			$this->buyer_instruction->AdvancedSearch->save(); // buyer_instruction
			$this->despatch_date->AdvancedSearch->save(); // despatch_date
			$this->production_plan->AdvancedSearch->save(); // production_plan
			$this->lot_no->AdvancedSearch->save(); // lot_no
			$this->d_01_head->AdvancedSearch->save(); // d_01_head
			$this->description_01->AdvancedSearch->save(); // description_01
			$this->d_02_head->AdvancedSearch->save(); // d_02_head
			$this->description_02->AdvancedSearch->save(); // description_02
			$this->d_03_head->AdvancedSearch->save(); // d_03_head
			$this->description_03->AdvancedSearch->save(); // description_03
			$this->d_04_head->AdvancedSearch->save(); // d_04_head
			$this->description_04->AdvancedSearch->save(); // description_04
			$this->d_05_head->AdvancedSearch->save(); // d_05_head
			$this->description_05->AdvancedSearch->save(); // description_05
			$this->d_06_head->AdvancedSearch->save(); // d_06_head
			$this->description_06->AdvancedSearch->save(); // description_06
			$this->d_07_head->AdvancedSearch->save(); // d_07_head
			$this->description_07->AdvancedSearch->save(); // description_07
			$this->d_08_head->AdvancedSearch->save(); // d_08_head
			$this->description_08->AdvancedSearch->save(); // description_08
			$this->d_09_head->AdvancedSearch->save(); // d_09_head
			$this->description_09->AdvancedSearch->save(); // description_09
			$this->d_10_head->AdvancedSearch->save(); // d_10_head
			$this->description_10->AdvancedSearch->save(); // description_10
			$this->d_11_head->AdvancedSearch->save(); // d_11_head
			$this->description_11->AdvancedSearch->save(); // description_11
			$this->d_12_head->AdvancedSearch->save(); // d_12_head
			$this->description_12->AdvancedSearch->save(); // description_12
			$this->remarks->AdvancedSearch->save(); // remarks
			$this->operator->AdvancedSearch->save(); // operator
			$this->datetime->AdvancedSearch->save(); // datetime
			$this->a_operator->AdvancedSearch->save(); // a_operator
			$this->a_datetime->AdvancedSearch->save(); // a_datetime
			$this->production_site->AdvancedSearch->save(); // production_site
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->buyer_product_ref, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_order_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_instruction, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->lot_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_05, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_06, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_07, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_08, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_09, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_10, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_11, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_12, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->remarks, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_product_ref->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->s_grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->product->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->rid->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->product_gcode->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->quantity->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->balance_quantity->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->price->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_order_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_order_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_instruction->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->despatch_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->production_plan->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->lot_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_01_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_02_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_03_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_03->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_04_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_04->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_05_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_05->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_06_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_06->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_07_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_07->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_08_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_08->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_09_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_09->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_10_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_10->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_11_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_11->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_12_head->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_12->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->remarks->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->a_operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->a_datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->production_site->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->grp->AdvancedSearch->unsetSession();
		$this->po->AdvancedSearch->unsetSession();
		$this->buyer_id->AdvancedSearch->unsetSession();
		$this->buyer_product_ref->AdvancedSearch->unsetSession();
		$this->s_grp->AdvancedSearch->unsetSession();
		$this->product->AdvancedSearch->unsetSession();
		$this->rid->AdvancedSearch->unsetSession();
		$this->product_gcode->AdvancedSearch->unsetSession();
		$this->quantity->AdvancedSearch->unsetSession();
		$this->balance_quantity->AdvancedSearch->unsetSession();
		$this->price->AdvancedSearch->unsetSession();
		$this->buyer_order_no->AdvancedSearch->unsetSession();
		$this->buyer_order_date->AdvancedSearch->unsetSession();
		$this->buyer_instruction->AdvancedSearch->unsetSession();
		$this->despatch_date->AdvancedSearch->unsetSession();
		$this->production_plan->AdvancedSearch->unsetSession();
		$this->lot_no->AdvancedSearch->unsetSession();
		$this->d_01_head->AdvancedSearch->unsetSession();
		$this->description_01->AdvancedSearch->unsetSession();
		$this->d_02_head->AdvancedSearch->unsetSession();
		$this->description_02->AdvancedSearch->unsetSession();
		$this->d_03_head->AdvancedSearch->unsetSession();
		$this->description_03->AdvancedSearch->unsetSession();
		$this->d_04_head->AdvancedSearch->unsetSession();
		$this->description_04->AdvancedSearch->unsetSession();
		$this->d_05_head->AdvancedSearch->unsetSession();
		$this->description_05->AdvancedSearch->unsetSession();
		$this->d_06_head->AdvancedSearch->unsetSession();
		$this->description_06->AdvancedSearch->unsetSession();
		$this->d_07_head->AdvancedSearch->unsetSession();
		$this->description_07->AdvancedSearch->unsetSession();
		$this->d_08_head->AdvancedSearch->unsetSession();
		$this->description_08->AdvancedSearch->unsetSession();
		$this->d_09_head->AdvancedSearch->unsetSession();
		$this->description_09->AdvancedSearch->unsetSession();
		$this->d_10_head->AdvancedSearch->unsetSession();
		$this->description_10->AdvancedSearch->unsetSession();
		$this->d_11_head->AdvancedSearch->unsetSession();
		$this->description_11->AdvancedSearch->unsetSession();
		$this->d_12_head->AdvancedSearch->unsetSession();
		$this->description_12->AdvancedSearch->unsetSession();
		$this->remarks->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
		$this->a_operator->AdvancedSearch->unsetSession();
		$this->a_datetime->AdvancedSearch->unsetSession();
		$this->production_site->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->buyer_id->AdvancedSearch->load();
		$this->buyer_product_ref->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->rid->AdvancedSearch->load();
		$this->product_gcode->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->balance_quantity->AdvancedSearch->load();
		$this->price->AdvancedSearch->load();
		$this->buyer_order_no->AdvancedSearch->load();
		$this->buyer_order_date->AdvancedSearch->load();
		$this->buyer_instruction->AdvancedSearch->load();
		$this->despatch_date->AdvancedSearch->load();
		$this->production_plan->AdvancedSearch->load();
		$this->lot_no->AdvancedSearch->load();
		$this->d_01_head->AdvancedSearch->load();
		$this->description_01->AdvancedSearch->load();
		$this->d_02_head->AdvancedSearch->load();
		$this->description_02->AdvancedSearch->load();
		$this->d_03_head->AdvancedSearch->load();
		$this->description_03->AdvancedSearch->load();
		$this->d_04_head->AdvancedSearch->load();
		$this->description_04->AdvancedSearch->load();
		$this->d_05_head->AdvancedSearch->load();
		$this->description_05->AdvancedSearch->load();
		$this->d_06_head->AdvancedSearch->load();
		$this->description_06->AdvancedSearch->load();
		$this->d_07_head->AdvancedSearch->load();
		$this->description_07->AdvancedSearch->load();
		$this->d_08_head->AdvancedSearch->load();
		$this->description_08->AdvancedSearch->load();
		$this->d_09_head->AdvancedSearch->load();
		$this->description_09->AdvancedSearch->load();
		$this->d_10_head->AdvancedSearch->load();
		$this->description_10->AdvancedSearch->load();
		$this->d_11_head->AdvancedSearch->load();
		$this->description_11->AdvancedSearch->load();
		$this->d_12_head->AdvancedSearch->load();
		$this->description_12->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->a_operator->AdvancedSearch->load();
		$this->a_datetime->AdvancedSearch->load();
		$this->production_site->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->po, $ctrl); // po
			$this->updateSort($this->buyer_id, $ctrl); // buyer_id
			$this->updateSort($this->buyer_product_ref, $ctrl); // buyer_product_ref
			$this->updateSort($this->rid, $ctrl); // rid
			$this->updateSort($this->batch_no, $ctrl); // batch_no
			$this->updateSort($this->quantity, $ctrl); // quantity
			$this->updateSort($this->balance_quantity, $ctrl); // balance_quantity
			$this->updateSort($this->price, $ctrl); // price
			$this->updateSort($this->buyer_order_no, $ctrl); // buyer_order_no
			$this->updateSort($this->buyer_order_date, $ctrl); // buyer_order_date
			$this->updateSort($this->despatch_date, $ctrl); // despatch_date
			$this->updateSort($this->despatch_week, $ctrl); // despatch_week
			$this->updateSort($this->production_plan, $ctrl); // production_plan
			$this->updateSort($this->lot_no, $ctrl); // lot_no
			$this->updateSort($this->production_site, $ctrl); // production_site
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("");
				$this->po->setSort("");
				$this->buyer_id->setSort("");
				$this->buyer_product_ref->setSort("");
				$this->rid->setSort("");
				$this->batch_no->setSort("");
				$this->quantity->setSort("");
				$this->balance_quantity->setSort("");
				$this->price->setSort("");
				$this->buyer_order_no->setSort("");
				$this->buyer_order_date->setSort("");
				$this->despatch_date->setSort("");
				$this->despatch_week->setSort("");
				$this->production_plan->setSort("");
				$this->lot_no->setSort("");
				$this->production_site->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canAdd();
		$item->OnLeft = TRUE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canDelete();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = &$this->ListOptions->Items["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->canAdd()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = &$this->ListOptions->Items["delete"];
		if ($Security->canDelete())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fpo_fplistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fpo_fplistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fpo_fplist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fpo_fplistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		$item->Body = "<a class=\"btn btn-default ew-advanced-aearch\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"po_fpsrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fpo_fplistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue(Get("x_grp", Get("grp", "")));
		if ($this->grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->grp->AdvancedSearch->setSearchOperator(Get("z_grp", ""));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue(Get("x_po", Get("po", "")));
		if ($this->po->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po->AdvancedSearch->setSearchOperator(Get("z_po", ""));

		// buyer_id
		if (!$this->isAddOrEdit())
			$this->buyer_id->AdvancedSearch->setSearchValue(Get("x_buyer_id", Get("buyer_id", "")));
		if ($this->buyer_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_id->AdvancedSearch->setSearchOperator(Get("z_buyer_id", ""));

		// buyer_product_ref
		if (!$this->isAddOrEdit())
			$this->buyer_product_ref->AdvancedSearch->setSearchValue(Get("x_buyer_product_ref", Get("buyer_product_ref", "")));
		if ($this->buyer_product_ref->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_product_ref->AdvancedSearch->setSearchOperator(Get("z_buyer_product_ref", ""));

		// s_grp
		if (!$this->isAddOrEdit())
			$this->s_grp->AdvancedSearch->setSearchValue(Get("x_s_grp", Get("s_grp", "")));
		if ($this->s_grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->s_grp->AdvancedSearch->setSearchOperator(Get("z_s_grp", ""));

		// product
		if (!$this->isAddOrEdit())
			$this->product->AdvancedSearch->setSearchValue(Get("x_product", Get("product", "")));
		if ($this->product->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->product->AdvancedSearch->setSearchOperator(Get("z_product", ""));

		// rid
		if (!$this->isAddOrEdit())
			$this->rid->AdvancedSearch->setSearchValue(Get("x_rid", Get("rid", "")));
		if ($this->rid->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->rid->AdvancedSearch->setSearchOperator(Get("z_rid", ""));

		// product_gcode
		if (!$this->isAddOrEdit())
			$this->product_gcode->AdvancedSearch->setSearchValue(Get("x_product_gcode", Get("product_gcode", "")));
		if ($this->product_gcode->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->product_gcode->AdvancedSearch->setSearchOperator(Get("z_product_gcode", ""));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue(Get("x_quantity", Get("quantity", "")));
		if ($this->quantity->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->quantity->AdvancedSearch->setSearchOperator(Get("z_quantity", ""));

		// balance_quantity
		if (!$this->isAddOrEdit())
			$this->balance_quantity->AdvancedSearch->setSearchValue(Get("x_balance_quantity", Get("balance_quantity", "")));
		if ($this->balance_quantity->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->balance_quantity->AdvancedSearch->setSearchOperator(Get("z_balance_quantity", ""));

		// price
		if (!$this->isAddOrEdit())
			$this->price->AdvancedSearch->setSearchValue(Get("x_price", Get("price", "")));
		if ($this->price->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->price->AdvancedSearch->setSearchOperator(Get("z_price", ""));

		// buyer_order_no
		if (!$this->isAddOrEdit())
			$this->buyer_order_no->AdvancedSearch->setSearchValue(Get("x_buyer_order_no", Get("buyer_order_no", "")));
		if ($this->buyer_order_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_order_no->AdvancedSearch->setSearchOperator(Get("z_buyer_order_no", ""));

		// buyer_order_date
		if (!$this->isAddOrEdit())
			$this->buyer_order_date->AdvancedSearch->setSearchValue(Get("x_buyer_order_date", Get("buyer_order_date", "")));
		if ($this->buyer_order_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_order_date->AdvancedSearch->setSearchOperator(Get("z_buyer_order_date", ""));

		// buyer_instruction
		if (!$this->isAddOrEdit())
			$this->buyer_instruction->AdvancedSearch->setSearchValue(Get("x_buyer_instruction", Get("buyer_instruction", "")));
		if ($this->buyer_instruction->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_instruction->AdvancedSearch->setSearchOperator(Get("z_buyer_instruction", ""));

		// despatch_date
		if (!$this->isAddOrEdit())
			$this->despatch_date->AdvancedSearch->setSearchValue(Get("x_despatch_date", Get("despatch_date", "")));
		if ($this->despatch_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->despatch_date->AdvancedSearch->setSearchOperator(Get("z_despatch_date", ""));

		// production_plan
		if (!$this->isAddOrEdit())
			$this->production_plan->AdvancedSearch->setSearchValue(Get("x_production_plan", Get("production_plan", "")));
		if ($this->production_plan->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->production_plan->AdvancedSearch->setSearchOperator(Get("z_production_plan", ""));

		// lot_no
		if (!$this->isAddOrEdit())
			$this->lot_no->AdvancedSearch->setSearchValue(Get("x_lot_no", Get("lot_no", "")));
		if ($this->lot_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->lot_no->AdvancedSearch->setSearchOperator(Get("z_lot_no", ""));

		// d_01_head
		if (!$this->isAddOrEdit())
			$this->d_01_head->AdvancedSearch->setSearchValue(Get("x_d_01_head", Get("d_01_head", "")));
		if ($this->d_01_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_01_head->AdvancedSearch->setSearchOperator(Get("z_d_01_head", ""));

		// description_01
		if (!$this->isAddOrEdit())
			$this->description_01->AdvancedSearch->setSearchValue(Get("x_description_01", Get("description_01", "")));
		if ($this->description_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_01->AdvancedSearch->setSearchOperator(Get("z_description_01", ""));

		// d_02_head
		if (!$this->isAddOrEdit())
			$this->d_02_head->AdvancedSearch->setSearchValue(Get("x_d_02_head", Get("d_02_head", "")));
		if ($this->d_02_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_02_head->AdvancedSearch->setSearchOperator(Get("z_d_02_head", ""));

		// description_02
		if (!$this->isAddOrEdit())
			$this->description_02->AdvancedSearch->setSearchValue(Get("x_description_02", Get("description_02", "")));
		if ($this->description_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_02->AdvancedSearch->setSearchOperator(Get("z_description_02", ""));

		// d_03_head
		if (!$this->isAddOrEdit())
			$this->d_03_head->AdvancedSearch->setSearchValue(Get("x_d_03_head", Get("d_03_head", "")));
		if ($this->d_03_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_03_head->AdvancedSearch->setSearchOperator(Get("z_d_03_head", ""));

		// description_03
		if (!$this->isAddOrEdit())
			$this->description_03->AdvancedSearch->setSearchValue(Get("x_description_03", Get("description_03", "")));
		if ($this->description_03->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_03->AdvancedSearch->setSearchOperator(Get("z_description_03", ""));

		// d_04_head
		if (!$this->isAddOrEdit())
			$this->d_04_head->AdvancedSearch->setSearchValue(Get("x_d_04_head", Get("d_04_head", "")));
		if ($this->d_04_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_04_head->AdvancedSearch->setSearchOperator(Get("z_d_04_head", ""));

		// description_04
		if (!$this->isAddOrEdit())
			$this->description_04->AdvancedSearch->setSearchValue(Get("x_description_04", Get("description_04", "")));
		if ($this->description_04->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_04->AdvancedSearch->setSearchOperator(Get("z_description_04", ""));

		// d_05_head
		if (!$this->isAddOrEdit())
			$this->d_05_head->AdvancedSearch->setSearchValue(Get("x_d_05_head", Get("d_05_head", "")));
		if ($this->d_05_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_05_head->AdvancedSearch->setSearchOperator(Get("z_d_05_head", ""));

		// description_05
		if (!$this->isAddOrEdit())
			$this->description_05->AdvancedSearch->setSearchValue(Get("x_description_05", Get("description_05", "")));
		if ($this->description_05->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_05->AdvancedSearch->setSearchOperator(Get("z_description_05", ""));

		// d_06_head
		if (!$this->isAddOrEdit())
			$this->d_06_head->AdvancedSearch->setSearchValue(Get("x_d_06_head", Get("d_06_head", "")));
		if ($this->d_06_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_06_head->AdvancedSearch->setSearchOperator(Get("z_d_06_head", ""));

		// description_06
		if (!$this->isAddOrEdit())
			$this->description_06->AdvancedSearch->setSearchValue(Get("x_description_06", Get("description_06", "")));
		if ($this->description_06->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_06->AdvancedSearch->setSearchOperator(Get("z_description_06", ""));

		// d_07_head
		if (!$this->isAddOrEdit())
			$this->d_07_head->AdvancedSearch->setSearchValue(Get("x_d_07_head", Get("d_07_head", "")));
		if ($this->d_07_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_07_head->AdvancedSearch->setSearchOperator(Get("z_d_07_head", ""));

		// description_07
		if (!$this->isAddOrEdit())
			$this->description_07->AdvancedSearch->setSearchValue(Get("x_description_07", Get("description_07", "")));
		if ($this->description_07->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_07->AdvancedSearch->setSearchOperator(Get("z_description_07", ""));

		// d_08_head
		if (!$this->isAddOrEdit())
			$this->d_08_head->AdvancedSearch->setSearchValue(Get("x_d_08_head", Get("d_08_head", "")));
		if ($this->d_08_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_08_head->AdvancedSearch->setSearchOperator(Get("z_d_08_head", ""));

		// description_08
		if (!$this->isAddOrEdit())
			$this->description_08->AdvancedSearch->setSearchValue(Get("x_description_08", Get("description_08", "")));
		if ($this->description_08->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_08->AdvancedSearch->setSearchOperator(Get("z_description_08", ""));

		// d_09_head
		if (!$this->isAddOrEdit())
			$this->d_09_head->AdvancedSearch->setSearchValue(Get("x_d_09_head", Get("d_09_head", "")));
		if ($this->d_09_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_09_head->AdvancedSearch->setSearchOperator(Get("z_d_09_head", ""));

		// description_09
		if (!$this->isAddOrEdit())
			$this->description_09->AdvancedSearch->setSearchValue(Get("x_description_09", Get("description_09", "")));
		if ($this->description_09->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_09->AdvancedSearch->setSearchOperator(Get("z_description_09", ""));

		// d_10_head
		if (!$this->isAddOrEdit())
			$this->d_10_head->AdvancedSearch->setSearchValue(Get("x_d_10_head", Get("d_10_head", "")));
		if ($this->d_10_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_10_head->AdvancedSearch->setSearchOperator(Get("z_d_10_head", ""));

		// description_10
		if (!$this->isAddOrEdit())
			$this->description_10->AdvancedSearch->setSearchValue(Get("x_description_10", Get("description_10", "")));
		if ($this->description_10->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_10->AdvancedSearch->setSearchOperator(Get("z_description_10", ""));

		// d_11_head
		if (!$this->isAddOrEdit())
			$this->d_11_head->AdvancedSearch->setSearchValue(Get("x_d_11_head", Get("d_11_head", "")));
		if ($this->d_11_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_11_head->AdvancedSearch->setSearchOperator(Get("z_d_11_head", ""));

		// description_11
		if (!$this->isAddOrEdit())
			$this->description_11->AdvancedSearch->setSearchValue(Get("x_description_11", Get("description_11", "")));
		if ($this->description_11->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_11->AdvancedSearch->setSearchOperator(Get("z_description_11", ""));

		// d_12_head
		if (!$this->isAddOrEdit())
			$this->d_12_head->AdvancedSearch->setSearchValue(Get("x_d_12_head", Get("d_12_head", "")));
		if ($this->d_12_head->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_12_head->AdvancedSearch->setSearchOperator(Get("z_d_12_head", ""));

		// description_12
		if (!$this->isAddOrEdit())
			$this->description_12->AdvancedSearch->setSearchValue(Get("x_description_12", Get("description_12", "")));
		if ($this->description_12->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_12->AdvancedSearch->setSearchOperator(Get("z_description_12", ""));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue(Get("x_remarks", Get("remarks", "")));
		if ($this->remarks->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->remarks->AdvancedSearch->setSearchOperator(Get("z_remarks", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));

		// a_operator
		if (!$this->isAddOrEdit())
			$this->a_operator->AdvancedSearch->setSearchValue(Get("x_a_operator", Get("a_operator", "")));
		if ($this->a_operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->a_operator->AdvancedSearch->setSearchOperator(Get("z_a_operator", ""));

		// a_datetime
		if (!$this->isAddOrEdit())
			$this->a_datetime->AdvancedSearch->setSearchValue(Get("x_a_datetime", Get("a_datetime", "")));
		if ($this->a_datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->a_datetime->AdvancedSearch->setSearchOperator(Get("z_a_datetime", ""));

		// production_site
		if (!$this->isAddOrEdit())
			$this->production_site->AdvancedSearch->setSearchValue(Get("x_production_site", Get("production_site", "")));
		if ($this->production_site->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->production_site->AdvancedSearch->setSearchOperator(Get("z_production_site", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->grp->setDbValue($row['grp']);
		$this->po->setDbValue($row['po']);
		$this->buyer_id->setDbValue($row['buyer_id']);
		$this->buyer_product_ref->setDbValue($row['buyer_product_ref']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->rid->setDbValue($row['rid']);
		$this->product_gcode->setDbValue($row['product_gcode']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->quantity->setDbValue($row['quantity']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->balance_quantity->setDbValue($row['balance_quantity']);
		$this->price->setDbValue($row['price']);
		$this->buyer_order_no->setDbValue($row['buyer_order_no']);
		$this->buyer_order_date->setDbValue($row['buyer_order_date']);
		$this->buyer_instruction->setDbValue($row['buyer_instruction']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->despatch_week->setDbValue($row['despatch_week']);
		$this->production_plan->setDbValue($row['production_plan']);
		$this->lot_no->setDbValue($row['lot_no']);
		$this->d_01_head->setDbValue($row['d_01_head']);
		$this->description_01->setDbValue($row['description_01']);
		$this->d_02_head->setDbValue($row['d_02_head']);
		$this->description_02->setDbValue($row['description_02']);
		$this->d_03_head->setDbValue($row['d_03_head']);
		$this->description_03->setDbValue($row['description_03']);
		$this->d_04_head->setDbValue($row['d_04_head']);
		$this->description_04->setDbValue($row['description_04']);
		$this->d_05_head->setDbValue($row['d_05_head']);
		$this->description_05->setDbValue($row['description_05']);
		$this->d_06_head->setDbValue($row['d_06_head']);
		$this->description_06->setDbValue($row['description_06']);
		$this->d_07_head->setDbValue($row['d_07_head']);
		$this->description_07->setDbValue($row['description_07']);
		$this->d_08_head->setDbValue($row['d_08_head']);
		$this->description_08->setDbValue($row['description_08']);
		$this->d_09_head->setDbValue($row['d_09_head']);
		$this->description_09->setDbValue($row['description_09']);
		$this->d_10_head->setDbValue($row['d_10_head']);
		$this->description_10->setDbValue($row['description_10']);
		$this->d_11_head->setDbValue($row['d_11_head']);
		$this->description_11->setDbValue($row['description_11']);
		$this->d_12_head->setDbValue($row['d_12_head']);
		$this->description_12->setDbValue($row['description_12']);
		$this->remarks->setDbValue($row['remarks']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->a_datetime->setDbValue($row['a_datetime']);
		$this->production_site->setDbValue($row['production_site']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['grp'] = NULL;
		$row['po'] = NULL;
		$row['buyer_id'] = NULL;
		$row['buyer_product_ref'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['rid'] = NULL;
		$row['product_gcode'] = NULL;
		$row['batch_no'] = NULL;
		$row['quantity'] = NULL;
		$row['jc_no'] = NULL;
		$row['balance_quantity'] = NULL;
		$row['price'] = NULL;
		$row['buyer_order_no'] = NULL;
		$row['buyer_order_date'] = NULL;
		$row['buyer_instruction'] = NULL;
		$row['despatch_date'] = NULL;
		$row['despatch_week'] = NULL;
		$row['production_plan'] = NULL;
		$row['lot_no'] = NULL;
		$row['d_01_head'] = NULL;
		$row['description_01'] = NULL;
		$row['d_02_head'] = NULL;
		$row['description_02'] = NULL;
		$row['d_03_head'] = NULL;
		$row['description_03'] = NULL;
		$row['d_04_head'] = NULL;
		$row['description_04'] = NULL;
		$row['d_05_head'] = NULL;
		$row['description_05'] = NULL;
		$row['d_06_head'] = NULL;
		$row['description_06'] = NULL;
		$row['d_07_head'] = NULL;
		$row['description_07'] = NULL;
		$row['d_08_head'] = NULL;
		$row['description_08'] = NULL;
		$row['d_09_head'] = NULL;
		$row['description_09'] = NULL;
		$row['d_10_head'] = NULL;
		$row['description_10'] = NULL;
		$row['d_11_head'] = NULL;
		$row['description_11'] = NULL;
		$row['d_12_head'] = NULL;
		$row['description_12'] = NULL;
		$row['remarks'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['a_operator'] = NULL;
		$row['a_datetime'] = NULL;
		$row['production_site'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->balance_quantity->FormValue == $this->balance_quantity->CurrentValue && is_numeric(ConvertToFloatString($this->balance_quantity->CurrentValue)))
			$this->balance_quantity->CurrentValue = ConvertToFloatString($this->balance_quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// po
		// buyer_id
		// buyer_product_ref
		// s_grp
		// product
		// rid
		// product_gcode

		$this->product_gcode->CellCssStyle = "white-space: nowrap;";

		// batch_no
		$this->batch_no->CellCssStyle = "white-space: nowrap;";

		// quantity
		// jc_no
		// balance_quantity
		// price
		// buyer_order_no
		// buyer_order_date
		// buyer_instruction
		// despatch_date
		// despatch_week
		// production_plan
		// lot_no
		// d_01_head
		// description_01
		// d_02_head
		// description_02
		// d_03_head
		// description_03
		// d_04_head
		// description_04
		// d_05_head
		// description_05
		// d_06_head
		// description_06
		// d_07_head
		// description_07
		// d_08_head
		// description_08
		// d_09_head
		// description_09
		// d_10_head
		// description_10
		// d_11_head
		// description_11
		// d_12_head
		// description_12
		// remarks
		// operator
		// datetime
		// a_operator
		// a_datetime
		// production_site

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			if (strval($this->grp->CurrentValue) <> "") {
				$this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";

			// buyer_id
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 1000 AND `grp`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// buyer_product_ref
			$curVal = strval($this->buyer_product_ref->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_product_ref->ViewValue = $this->buyer_product_ref->lookupCacheOption($curVal);
				if ($this->buyer_product_ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer_product_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_product_ref->ViewValue = $this->buyer_product_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_product_ref->ViewValue = $this->buyer_product_ref->CurrentValue;
					}
				}
			} else {
				$this->buyer_product_ref->ViewValue = NULL;
			}
			$this->buyer_product_ref->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$this->product->ViewValue = $this->product->CurrentValue;
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
			$this->batch_no->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewCustomAttributes = "";

			// balance_quantity
			$this->balance_quantity->ViewValue = $this->balance_quantity->CurrentValue;
			$this->balance_quantity->ViewValue = FormatNumber($this->balance_quantity->ViewValue, 2, -2, -2, -2);
			$this->balance_quantity->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// buyer_order_no
			$this->buyer_order_no->ViewValue = $this->buyer_order_no->CurrentValue;
			$this->buyer_order_no->ViewCustomAttributes = "";

			// buyer_order_date
			$this->buyer_order_date->ViewValue = $this->buyer_order_date->CurrentValue;
			$this->buyer_order_date->ViewValue = FormatDateTime($this->buyer_order_date->ViewValue, 0);
			$this->buyer_order_date->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// despatch_week
			$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
			$this->despatch_week->ViewCustomAttributes = "";

			// production_plan
			if (strval($this->production_plan->CurrentValue) <> "") {
				$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
			} else {
				$this->production_plan->ViewValue = NULL;
			}
			$this->production_plan->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// d_01_head
			$curVal = strval($this->d_01_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_01_head->ViewValue = $this->d_01_head->lookupCacheOption($curVal);
				if ($this->d_01_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_01_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_01_head->ViewValue = $this->d_01_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_01_head->ViewValue = $this->d_01_head->CurrentValue;
					}
				}
			} else {
				$this->d_01_head->ViewValue = NULL;
			}
			$this->d_01_head->ViewCustomAttributes = "";

			// description_01
			$this->description_01->ViewValue = $this->description_01->CurrentValue;
			$this->description_01->ViewValue = FormatNumber($this->description_01->ViewValue, 3, -2, -2, -2);
			$this->description_01->ViewCustomAttributes = "";

			// d_02_head
			$curVal = strval($this->d_02_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_02_head->ViewValue = $this->d_02_head->lookupCacheOption($curVal);
				if ($this->d_02_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_02_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_02_head->ViewValue = $this->d_02_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_02_head->ViewValue = $this->d_02_head->CurrentValue;
					}
				}
			} else {
				$this->d_02_head->ViewValue = NULL;
			}
			$this->d_02_head->ViewCustomAttributes = "";

			// description_02
			$this->description_02->ViewValue = $this->description_02->CurrentValue;
			$this->description_02->ViewValue = FormatNumber($this->description_02->ViewValue, 3, -2, -2, -2);
			$this->description_02->ViewCustomAttributes = "";

			// d_03_head
			$curVal = strval($this->d_03_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_03_head->ViewValue = $this->d_03_head->lookupCacheOption($curVal);
				if ($this->d_03_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_03_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_03_head->ViewValue = $this->d_03_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_03_head->ViewValue = $this->d_03_head->CurrentValue;
					}
				}
			} else {
				$this->d_03_head->ViewValue = NULL;
			}
			$this->d_03_head->ViewCustomAttributes = "";

			// description_03
			$curVal = strval($this->description_03->CurrentValue);
			if ($curVal <> "") {
				$this->description_03->ViewValue = $this->description_03->lookupCacheOption($curVal);
				if ($this->description_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_03->ViewValue = $this->description_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_03->ViewValue = $this->description_03->CurrentValue;
					}
				}
			} else {
				$this->description_03->ViewValue = NULL;
			}
			$this->description_03->ViewCustomAttributes = "";

			// d_04_head
			$curVal = strval($this->d_04_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_04_head->ViewValue = $this->d_04_head->lookupCacheOption($curVal);
				if ($this->d_04_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_04_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_04_head->ViewValue = $this->d_04_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_04_head->ViewValue = $this->d_04_head->CurrentValue;
					}
				}
			} else {
				$this->d_04_head->ViewValue = NULL;
			}
			$this->d_04_head->ViewCustomAttributes = "";

			// description_04
			$curVal = strval($this->description_04->CurrentValue);
			if ($curVal <> "") {
				$this->description_04->ViewValue = $this->description_04->lookupCacheOption($curVal);
				if ($this->description_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_04->ViewValue = $this->description_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_04->ViewValue = $this->description_04->CurrentValue;
					}
				}
			} else {
				$this->description_04->ViewValue = NULL;
			}
			$this->description_04->ViewCustomAttributes = "";

			// d_05_head
			$curVal = strval($this->d_05_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_05_head->ViewValue = $this->d_05_head->lookupCacheOption($curVal);
				if ($this->d_05_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_05_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_05_head->ViewValue = $this->d_05_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_05_head->ViewValue = $this->d_05_head->CurrentValue;
					}
				}
			} else {
				$this->d_05_head->ViewValue = NULL;
			}
			$this->d_05_head->ViewCustomAttributes = "";

			// description_05
			$curVal = strval($this->description_05->CurrentValue);
			if ($curVal <> "") {
				$this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
				if ($this->description_05->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_05->ViewValue = $this->description_05->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_05->ViewValue = $this->description_05->CurrentValue;
					}
				}
			} else {
				$this->description_05->ViewValue = NULL;
			}
			$this->description_05->ViewCustomAttributes = "";

			// d_06_head
			$curVal = strval($this->d_06_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_06_head->ViewValue = $this->d_06_head->lookupCacheOption($curVal);
				if ($this->d_06_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_06_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_06_head->ViewValue = $this->d_06_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_06_head->ViewValue = $this->d_06_head->CurrentValue;
					}
				}
			} else {
				$this->d_06_head->ViewValue = NULL;
			}
			$this->d_06_head->ViewCustomAttributes = "";

			// description_06
			$curVal = strval($this->description_06->CurrentValue);
			if ($curVal <> "") {
				$this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
				if ($this->description_06->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_06->ViewValue = $this->description_06->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_06->ViewValue = $this->description_06->CurrentValue;
					}
				}
			} else {
				$this->description_06->ViewValue = NULL;
			}
			$this->description_06->ViewCustomAttributes = "";

			// d_07_head
			$curVal = strval($this->d_07_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_07_head->ViewValue = $this->d_07_head->lookupCacheOption($curVal);
				if ($this->d_07_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_07_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_07_head->ViewValue = $this->d_07_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_07_head->ViewValue = $this->d_07_head->CurrentValue;
					}
				}
			} else {
				$this->d_07_head->ViewValue = NULL;
			}
			$this->d_07_head->ViewCustomAttributes = "";

			// description_07
			$this->description_07->ViewValue = $this->description_07->CurrentValue;
			$this->description_07->ViewCustomAttributes = "";

			// d_08_head
			$curVal = strval($this->d_08_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_08_head->ViewValue = $this->d_08_head->lookupCacheOption($curVal);
				if ($this->d_08_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_08_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_08_head->ViewValue = $this->d_08_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_08_head->ViewValue = $this->d_08_head->CurrentValue;
					}
				}
			} else {
				$this->d_08_head->ViewValue = NULL;
			}
			$this->d_08_head->ViewCustomAttributes = "";

			// description_08
			$this->description_08->ViewValue = $this->description_08->CurrentValue;
			$this->description_08->ViewCustomAttributes = "";

			// d_09_head
			$curVal = strval($this->d_09_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
				if ($this->d_09_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_09_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_09_head->ViewValue = $this->d_09_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_09_head->ViewValue = $this->d_09_head->CurrentValue;
					}
				}
			} else {
				$this->d_09_head->ViewValue = NULL;
			}
			$this->d_09_head->ViewCustomAttributes = "";

			// description_09
			$this->description_09->ViewValue = $this->description_09->CurrentValue;
			$this->description_09->ViewCustomAttributes = "";

			// d_10_head
			$curVal = strval($this->d_10_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
				if ($this->d_10_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_10_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_10_head->ViewValue = $this->d_10_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_10_head->ViewValue = $this->d_10_head->CurrentValue;
					}
				}
			} else {
				$this->d_10_head->ViewValue = NULL;
			}
			$this->d_10_head->ViewCustomAttributes = "";

			// description_10
			$this->description_10->ViewValue = $this->description_10->CurrentValue;
			$this->description_10->ViewCustomAttributes = "";

			// d_11_head
			$curVal = strval($this->d_11_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
				if ($this->d_11_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_11_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_11_head->ViewValue = $this->d_11_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_11_head->ViewValue = $this->d_11_head->CurrentValue;
					}
				}
			} else {
				$this->d_11_head->ViewValue = NULL;
			}
			$this->d_11_head->ViewCustomAttributes = "";

			// description_11
			$this->description_11->ViewValue = $this->description_11->CurrentValue;
			$this->description_11->ViewCustomAttributes = "";

			// d_12_head
			$curVal = strval($this->d_12_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
				if ($this->d_12_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_12_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_12_head->ViewValue = $this->d_12_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_12_head->ViewValue = $this->d_12_head->CurrentValue;
					}
				}
			} else {
				$this->d_12_head->ViewValue = NULL;
			}
			$this->d_12_head->ViewCustomAttributes = "";

			// description_12
			$this->description_12->ViewValue = $this->description_12->CurrentValue;
			$this->description_12->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// a_operator
			$curVal = strval($this->a_operator->CurrentValue);
			if ($curVal <> "") {
				$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
				if ($this->a_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
					}
				}
			} else {
				$this->a_operator->ViewValue = NULL;
			}
			$this->a_operator->ViewCustomAttributes = "";

			// a_datetime
			$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
			$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 0);
			$this->a_datetime->ViewCustomAttributes = "";

			// production_site
			$this->production_site->ViewValue = $this->production_site->CurrentValue;
			$this->production_site->ViewValue = FormatNumber($this->production_site->ViewValue, 0, -2, -2, -2);
			$this->production_site->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";
			if (!$this->isExport())
				$this->po->ViewValue = $this->highlightValue($this->po);

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// buyer_product_ref
			$this->buyer_product_ref->LinkCustomAttributes = "";
			$this->buyer_product_ref->HrefValue = "";
			$this->buyer_product_ref->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "po_fplist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";
			if (!$this->isExport())
				$this->rid->ViewValue = $this->highlightValue($this->rid);

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// balance_quantity
			$this->balance_quantity->LinkCustomAttributes = "";
			$this->balance_quantity->HrefValue = "";
			$this->balance_quantity->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// buyer_order_no
			$this->buyer_order_no->LinkCustomAttributes = "";
			$this->buyer_order_no->HrefValue = "";
			$this->buyer_order_no->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer_order_no->ViewValue = $this->highlightValue($this->buyer_order_no);

			// buyer_order_date
			$this->buyer_order_date->LinkCustomAttributes = "";
			$this->buyer_order_date->HrefValue = "";
			$this->buyer_order_date->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";
			$this->production_plan->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";
			if (!$this->isExport())
				$this->lot_no->ViewValue = $this->highlightValue($this->lot_no);

			// production_site
			$this->production_site->LinkCustomAttributes = "";
			$this->production_site->HrefValue = "";
			$this->production_site->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->buyer_id->AdvancedSearch->load();
		$this->buyer_product_ref->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->rid->AdvancedSearch->load();
		$this->product_gcode->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->balance_quantity->AdvancedSearch->load();
		$this->price->AdvancedSearch->load();
		$this->buyer_order_no->AdvancedSearch->load();
		$this->buyer_order_date->AdvancedSearch->load();
		$this->buyer_instruction->AdvancedSearch->load();
		$this->despatch_date->AdvancedSearch->load();
		$this->production_plan->AdvancedSearch->load();
		$this->lot_no->AdvancedSearch->load();
		$this->d_01_head->AdvancedSearch->load();
		$this->description_01->AdvancedSearch->load();
		$this->d_02_head->AdvancedSearch->load();
		$this->description_02->AdvancedSearch->load();
		$this->d_03_head->AdvancedSearch->load();
		$this->description_03->AdvancedSearch->load();
		$this->d_04_head->AdvancedSearch->load();
		$this->description_04->AdvancedSearch->load();
		$this->d_05_head->AdvancedSearch->load();
		$this->description_05->AdvancedSearch->load();
		$this->d_06_head->AdvancedSearch->load();
		$this->description_06->AdvancedSearch->load();
		$this->d_07_head->AdvancedSearch->load();
		$this->description_07->AdvancedSearch->load();
		$this->d_08_head->AdvancedSearch->load();
		$this->description_08->AdvancedSearch->load();
		$this->d_09_head->AdvancedSearch->load();
		$this->description_09->AdvancedSearch->load();
		$this->d_10_head->AdvancedSearch->load();
		$this->description_10->AdvancedSearch->load();
		$this->d_11_head->AdvancedSearch->load();
		$this->description_11->AdvancedSearch->load();
		$this->d_12_head->AdvancedSearch->load();
		$this->description_12->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->a_operator->AdvancedSearch->load();
		$this->a_datetime->AdvancedSearch->load();
		$this->production_site->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fpo_fplist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fpo_fplist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fpo_fplist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_po_fp\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_po_fp',hdr:ew.language.phrase('ExportToEmailText'),f:document.fpo_fplist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_buyer_id":
					$lookupFilter = function() {
						return "`id` > 1000 AND `grp`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_03":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_04":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_05":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_06":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyer_id":
							break;
						case "x_buyer_product_ref":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_product_gcode":
							break;
						case "x_d_01_head":
							break;
						case "x_d_02_head":
							break;
						case "x_d_03_head":
							break;
						case "x_description_03":
							break;
						case "x_d_04_head":
							break;
						case "x_description_04":
							break;
						case "x_d_05_head":
							break;
						case "x_description_05":
							break;
						case "x_d_06_head":
							break;
						case "x_description_06":
							break;
						case "x_d_07_head":
							break;
						case "x_d_08_head":
							break;
						case "x_d_09_head":
							break;
						case "x_d_10_head":
							break;
						case "x_d_11_head":
							break;
						case "x_d_12_head":
							break;
						case "x_operator":
							break;
						case "x_a_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
			PageFieldValidate($this,'po_fp');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

			if (($this->a_operator->CurrentValue == 0 ) || (empty($this->a_operator->CurrentValue))) {
			$this->ListOptions->Add("Approve"); // Replace abclink with your name of the link
			$txtBtn = 'Approved';
			if($this->a_operator->CurrentValue==0)
			{
			$txtBtn = 'Approve';
			}
			$this->ListOptions->Items["Approve"]->Body =
			'<a href="autoprogramme.php?apcid=854d6fae5ee42911677c739ee1734486&POID=' . $this->id->CurrentValue . '" data-original-title ="'.$txtBtn.'"><i data-phrase="Approve"  class="fa fa-thumbs-up ew-icon" ></i></a>';
	}
	if($this->a_operator->CurrentValue>0)
			{
				$this->ListOptions->Items['edit']->Visible=FALSE;
				$this->ListOptions->Items['delete']->Visible=FALSE;
			}
	$this->ListOptions->Add("Print"); // Replace abclink with your name of the link
		$this->ListOptions->Items["Print"]->Body =
			'<a href="print_po_fp.php?id=' . $this->id->CurrentValue . '" data-original-title ="Print"><i data-phrase="Print"  class="fa fa-print ew-icon" ></i></a>';
	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>