<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class po_fp_search extends po_fp
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'po_fp';

	// Page object name
	public $PageObjName = "po_fp_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (po_fp)
		if (!isset($GLOBALS["po_fp"]) || get_class($GLOBALS["po_fp"]) == PROJECT_NAMESPACE . "po_fp") {
			$GLOBALS["po_fp"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["po_fp"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_fp');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $po_fp;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($po_fp);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "po_fpview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("po_fplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->grp->setVisibility();
		$this->po->setVisibility();
		$this->buyer_id->setVisibility();
		$this->buyer_product_ref->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid->setVisibility();
		$this->product_gcode->setVisibility();
		$this->batch_no->Visible = FALSE;
		$this->quantity->setVisibility();
		$this->jc_no->Visible = FALSE;
		$this->balance_quantity->setVisibility();
		$this->price->setVisibility();
		$this->buyer_order_no->setVisibility();
		$this->buyer_order_date->setVisibility();
		$this->buyer_instruction->setVisibility();
		$this->despatch_date->setVisibility();
		$this->despatch_week->Visible = FALSE;
		$this->production_plan->setVisibility();
		$this->lot_no->setVisibility();
		$this->d_01_head->setVisibility();
		$this->description_01->setVisibility();
		$this->d_02_head->setVisibility();
		$this->description_02->setVisibility();
		$this->d_03_head->setVisibility();
		$this->description_03->setVisibility();
		$this->d_04_head->setVisibility();
		$this->description_04->setVisibility();
		$this->d_05_head->setVisibility();
		$this->description_05->setVisibility();
		$this->d_06_head->setVisibility();
		$this->description_06->setVisibility();
		$this->d_07_head->setVisibility();
		$this->description_07->setVisibility();
		$this->d_08_head->setVisibility();
		$this->description_08->setVisibility();
		$this->d_09_head->setVisibility();
		$this->description_09->setVisibility();
		$this->d_10_head->setVisibility();
		$this->description_10->setVisibility();
		$this->d_11_head->setVisibility();
		$this->description_11->setVisibility();
		$this->d_12_head->setVisibility();
		$this->description_12->setVisibility();
		$this->remarks->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->a_operator->setVisibility();
		$this->a_datetime->setVisibility();
		$this->production_site->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->buyer_product_ref);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->product_gcode);
		$this->setupLookupOptions($this->d_01_head);
		$this->setupLookupOptions($this->d_02_head);
		$this->setupLookupOptions($this->d_03_head);
		$this->setupLookupOptions($this->description_03);
		$this->setupLookupOptions($this->d_04_head);
		$this->setupLookupOptions($this->description_04);
		$this->setupLookupOptions($this->d_05_head);
		$this->setupLookupOptions($this->description_05);
		$this->setupLookupOptions($this->d_06_head);
		$this->setupLookupOptions($this->description_06);
		$this->setupLookupOptions($this->d_07_head);
		$this->setupLookupOptions($this->d_08_head);
		$this->setupLookupOptions($this->d_09_head);
		$this->setupLookupOptions($this->d_10_head);
		$this->setupLookupOptions($this->d_11_head);
		$this->setupLookupOptions($this->d_12_head);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->a_operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "po_fplist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->grp); // grp
		$this->buildSearchUrl($srchUrl, $this->po); // po
		$this->buildSearchUrl($srchUrl, $this->buyer_id); // buyer_id
		$this->buildSearchUrl($srchUrl, $this->buyer_product_ref); // buyer_product_ref
		$this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
		$this->buildSearchUrl($srchUrl, $this->product); // product
		$this->buildSearchUrl($srchUrl, $this->rid); // rid
		$this->buildSearchUrl($srchUrl, $this->product_gcode); // product_gcode
		$this->buildSearchUrl($srchUrl, $this->quantity); // quantity
		$this->buildSearchUrl($srchUrl, $this->balance_quantity); // balance_quantity
		$this->buildSearchUrl($srchUrl, $this->price); // price
		$this->buildSearchUrl($srchUrl, $this->buyer_order_no); // buyer_order_no
		$this->buildSearchUrl($srchUrl, $this->buyer_order_date); // buyer_order_date
		$this->buildSearchUrl($srchUrl, $this->buyer_instruction); // buyer_instruction
		$this->buildSearchUrl($srchUrl, $this->despatch_date); // despatch_date
		$this->buildSearchUrl($srchUrl, $this->production_plan); // production_plan
		$this->buildSearchUrl($srchUrl, $this->lot_no); // lot_no
		$this->buildSearchUrl($srchUrl, $this->d_01_head); // d_01_head
		$this->buildSearchUrl($srchUrl, $this->description_01); // description_01
		$this->buildSearchUrl($srchUrl, $this->d_02_head); // d_02_head
		$this->buildSearchUrl($srchUrl, $this->description_02); // description_02
		$this->buildSearchUrl($srchUrl, $this->d_03_head); // d_03_head
		$this->buildSearchUrl($srchUrl, $this->description_03); // description_03
		$this->buildSearchUrl($srchUrl, $this->d_04_head); // d_04_head
		$this->buildSearchUrl($srchUrl, $this->description_04); // description_04
		$this->buildSearchUrl($srchUrl, $this->d_05_head); // d_05_head
		$this->buildSearchUrl($srchUrl, $this->description_05); // description_05
		$this->buildSearchUrl($srchUrl, $this->d_06_head); // d_06_head
		$this->buildSearchUrl($srchUrl, $this->description_06); // description_06
		$this->buildSearchUrl($srchUrl, $this->d_07_head); // d_07_head
		$this->buildSearchUrl($srchUrl, $this->description_07); // description_07
		$this->buildSearchUrl($srchUrl, $this->d_08_head); // d_08_head
		$this->buildSearchUrl($srchUrl, $this->description_08); // description_08
		$this->buildSearchUrl($srchUrl, $this->d_09_head); // d_09_head
		$this->buildSearchUrl($srchUrl, $this->description_09); // description_09
		$this->buildSearchUrl($srchUrl, $this->d_10_head); // d_10_head
		$this->buildSearchUrl($srchUrl, $this->description_10); // description_10
		$this->buildSearchUrl($srchUrl, $this->d_11_head); // d_11_head
		$this->buildSearchUrl($srchUrl, $this->description_11); // description_11
		$this->buildSearchUrl($srchUrl, $this->d_12_head); // d_12_head
		$this->buildSearchUrl($srchUrl, $this->description_12); // description_12
		$this->buildSearchUrl($srchUrl, $this->remarks); // remarks
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->a_operator); // a_operator
		$this->buildSearchUrl($srchUrl, $this->a_datetime); // a_datetime
		$this->buildSearchUrl($srchUrl, $this->production_site); // production_site
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_grp"));
		$this->grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_grp"));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po"));
		$this->po->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po"));

		// buyer_id
		if (!$this->isAddOrEdit())
			$this->buyer_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_id"));
		$this->buyer_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_id"));

		// buyer_product_ref
		if (!$this->isAddOrEdit())
			$this->buyer_product_ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_product_ref"));
		$this->buyer_product_ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_product_ref"));

		// s_grp
		if (!$this->isAddOrEdit())
			$this->s_grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_grp"));
		$this->s_grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_grp"));

		// product
		if (!$this->isAddOrEdit())
			$this->product->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product"));
		$this->product->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product"));

		// rid
		if (!$this->isAddOrEdit())
			$this->rid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_rid"));
		$this->rid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_rid"));

		// product_gcode
		if (!$this->isAddOrEdit())
			$this->product_gcode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_gcode"));
		$this->product_gcode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_gcode"));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_quantity"));
		$this->quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_quantity"));

		// balance_quantity
		if (!$this->isAddOrEdit())
			$this->balance_quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_balance_quantity"));
		$this->balance_quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_balance_quantity"));

		// price
		if (!$this->isAddOrEdit())
			$this->price->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_price"));
		$this->price->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_price"));

		// buyer_order_no
		if (!$this->isAddOrEdit())
			$this->buyer_order_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_order_no"));
		$this->buyer_order_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_order_no"));

		// buyer_order_date
		if (!$this->isAddOrEdit())
			$this->buyer_order_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_order_date"));
		$this->buyer_order_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_order_date"));

		// buyer_instruction
		if (!$this->isAddOrEdit())
			$this->buyer_instruction->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_instruction"));
		$this->buyer_instruction->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_instruction"));

		// despatch_date
		if (!$this->isAddOrEdit())
			$this->despatch_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_despatch_date"));
		$this->despatch_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_despatch_date"));

		// production_plan
		if (!$this->isAddOrEdit())
			$this->production_plan->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_production_plan"));
		$this->production_plan->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_production_plan"));

		// lot_no
		if (!$this->isAddOrEdit())
			$this->lot_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_lot_no"));
		$this->lot_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_lot_no"));

		// d_01_head
		if (!$this->isAddOrEdit())
			$this->d_01_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_01_head"));
		$this->d_01_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_01_head"));

		// description_01
		if (!$this->isAddOrEdit())
			$this->description_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_01"));
		$this->description_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_01"));

		// d_02_head
		if (!$this->isAddOrEdit())
			$this->d_02_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_02_head"));
		$this->d_02_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_02_head"));

		// description_02
		if (!$this->isAddOrEdit())
			$this->description_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_02"));
		$this->description_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_02"));

		// d_03_head
		if (!$this->isAddOrEdit())
			$this->d_03_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_03_head"));
		$this->d_03_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_03_head"));

		// description_03
		if (!$this->isAddOrEdit())
			$this->description_03->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_03"));
		$this->description_03->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_03"));

		// d_04_head
		if (!$this->isAddOrEdit())
			$this->d_04_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_04_head"));
		$this->d_04_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_04_head"));

		// description_04
		if (!$this->isAddOrEdit())
			$this->description_04->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_04"));
		$this->description_04->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_04"));

		// d_05_head
		if (!$this->isAddOrEdit())
			$this->d_05_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_05_head"));
		$this->d_05_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_05_head"));

		// description_05
		if (!$this->isAddOrEdit())
			$this->description_05->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_05"));
		$this->description_05->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_05"));

		// d_06_head
		if (!$this->isAddOrEdit())
			$this->d_06_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_06_head"));
		$this->d_06_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_06_head"));

		// description_06
		if (!$this->isAddOrEdit())
			$this->description_06->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_06"));
		$this->description_06->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_06"));

		// d_07_head
		if (!$this->isAddOrEdit())
			$this->d_07_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_07_head"));
		$this->d_07_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_07_head"));

		// description_07
		if (!$this->isAddOrEdit())
			$this->description_07->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_07"));
		$this->description_07->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_07"));

		// d_08_head
		if (!$this->isAddOrEdit())
			$this->d_08_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_08_head"));
		$this->d_08_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_08_head"));

		// description_08
		if (!$this->isAddOrEdit())
			$this->description_08->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_08"));
		$this->description_08->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_08"));

		// d_09_head
		if (!$this->isAddOrEdit())
			$this->d_09_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_09_head"));
		$this->d_09_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_09_head"));

		// description_09
		if (!$this->isAddOrEdit())
			$this->description_09->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_09"));
		$this->description_09->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_09"));

		// d_10_head
		if (!$this->isAddOrEdit())
			$this->d_10_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_10_head"));
		$this->d_10_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_10_head"));

		// description_10
		if (!$this->isAddOrEdit())
			$this->description_10->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_10"));
		$this->description_10->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_10"));

		// d_11_head
		if (!$this->isAddOrEdit())
			$this->d_11_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_11_head"));
		$this->d_11_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_11_head"));

		// description_11
		if (!$this->isAddOrEdit())
			$this->description_11->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_11"));
		$this->description_11->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_11"));

		// d_12_head
		if (!$this->isAddOrEdit())
			$this->d_12_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_12_head"));
		$this->d_12_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_12_head"));

		// description_12
		if (!$this->isAddOrEdit())
			$this->description_12->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_12"));
		$this->description_12->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_12"));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remarks"));
		$this->remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remarks"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// a_operator
		if (!$this->isAddOrEdit())
			$this->a_operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_a_operator"));
		$this->a_operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_a_operator"));

		// a_datetime
		if (!$this->isAddOrEdit())
			$this->a_datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_a_datetime"));
		$this->a_datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_a_datetime"));

		// production_site
		if (!$this->isAddOrEdit())
			$this->production_site->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_production_site"));
		$this->production_site->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_production_site"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->balance_quantity->FormValue == $this->balance_quantity->CurrentValue && is_numeric(ConvertToFloatString($this->balance_quantity->CurrentValue)))
			$this->balance_quantity->CurrentValue = ConvertToFloatString($this->balance_quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->description_01->FormValue == $this->description_01->CurrentValue && is_numeric(ConvertToFloatString($this->description_01->CurrentValue)))
			$this->description_01->CurrentValue = ConvertToFloatString($this->description_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->description_02->FormValue == $this->description_02->CurrentValue && is_numeric(ConvertToFloatString($this->description_02->CurrentValue)))
			$this->description_02->CurrentValue = ConvertToFloatString($this->description_02->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// po
		// buyer_id
		// buyer_product_ref
		// s_grp
		// product
		// rid
		// product_gcode
		// batch_no
		// quantity
		// jc_no
		// balance_quantity
		// price
		// buyer_order_no
		// buyer_order_date
		// buyer_instruction
		// despatch_date
		// despatch_week
		// production_plan
		// lot_no
		// d_01_head
		// description_01
		// d_02_head
		// description_02
		// d_03_head
		// description_03
		// d_04_head
		// description_04
		// d_05_head
		// description_05
		// d_06_head
		// description_06
		// d_07_head
		// description_07
		// d_08_head
		// description_08
		// d_09_head
		// description_09
		// d_10_head
		// description_10
		// d_11_head
		// description_11
		// d_12_head
		// description_12
		// remarks
		// operator
		// datetime
		// a_operator
		// a_datetime
		// production_site

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			if (strval($this->grp->CurrentValue) <> "") {
				$this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";

			// buyer_id
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 1000 AND `grp`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// buyer_product_ref
			$curVal = strval($this->buyer_product_ref->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_product_ref->ViewValue = $this->buyer_product_ref->lookupCacheOption($curVal);
				if ($this->buyer_product_ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer_product_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_product_ref->ViewValue = $this->buyer_product_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_product_ref->ViewValue = $this->buyer_product_ref->CurrentValue;
					}
				}
			} else {
				$this->buyer_product_ref->ViewValue = NULL;
			}
			$this->buyer_product_ref->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$this->product->ViewValue = $this->product->CurrentValue;
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// product_gcode
			$curVal = strval($this->product_gcode->CurrentValue);
			if ($curVal <> "") {
				$this->product_gcode->ViewValue = $this->product_gcode->lookupCacheOption($curVal);
				if ($this->product_gcode->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`gcode`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->product_gcode->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_gcode->ViewValue = $this->product_gcode->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_gcode->ViewValue = $this->product_gcode->CurrentValue;
					}
				}
			} else {
				$this->product_gcode->ViewValue = NULL;
			}
			$this->product_gcode->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewCustomAttributes = "";

			// balance_quantity
			$this->balance_quantity->ViewValue = $this->balance_quantity->CurrentValue;
			$this->balance_quantity->ViewValue = FormatNumber($this->balance_quantity->ViewValue, 2, -2, -2, -2);
			$this->balance_quantity->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// buyer_order_no
			$this->buyer_order_no->ViewValue = $this->buyer_order_no->CurrentValue;
			$this->buyer_order_no->ViewCustomAttributes = "";

			// buyer_order_date
			$this->buyer_order_date->ViewValue = $this->buyer_order_date->CurrentValue;
			$this->buyer_order_date->ViewValue = FormatDateTime($this->buyer_order_date->ViewValue, 0);
			$this->buyer_order_date->ViewCustomAttributes = "";

			// buyer_instruction
			$this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;
			$this->buyer_instruction->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// production_plan
			if (strval($this->production_plan->CurrentValue) <> "") {
				$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
			} else {
				$this->production_plan->ViewValue = NULL;
			}
			$this->production_plan->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// d_01_head
			$curVal = strval($this->d_01_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_01_head->ViewValue = $this->d_01_head->lookupCacheOption($curVal);
				if ($this->d_01_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_01_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_01_head->ViewValue = $this->d_01_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_01_head->ViewValue = $this->d_01_head->CurrentValue;
					}
				}
			} else {
				$this->d_01_head->ViewValue = NULL;
			}
			$this->d_01_head->ViewCustomAttributes = "";

			// description_01
			$this->description_01->ViewValue = $this->description_01->CurrentValue;
			$this->description_01->ViewValue = FormatNumber($this->description_01->ViewValue, 3, -2, -2, -2);
			$this->description_01->ViewCustomAttributes = "";

			// d_02_head
			$curVal = strval($this->d_02_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_02_head->ViewValue = $this->d_02_head->lookupCacheOption($curVal);
				if ($this->d_02_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_02_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_02_head->ViewValue = $this->d_02_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_02_head->ViewValue = $this->d_02_head->CurrentValue;
					}
				}
			} else {
				$this->d_02_head->ViewValue = NULL;
			}
			$this->d_02_head->ViewCustomAttributes = "";

			// description_02
			$this->description_02->ViewValue = $this->description_02->CurrentValue;
			$this->description_02->ViewValue = FormatNumber($this->description_02->ViewValue, 3, -2, -2, -2);
			$this->description_02->ViewCustomAttributes = "";

			// d_03_head
			$curVal = strval($this->d_03_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_03_head->ViewValue = $this->d_03_head->lookupCacheOption($curVal);
				if ($this->d_03_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_03_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_03_head->ViewValue = $this->d_03_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_03_head->ViewValue = $this->d_03_head->CurrentValue;
					}
				}
			} else {
				$this->d_03_head->ViewValue = NULL;
			}
			$this->d_03_head->ViewCustomAttributes = "";

			// description_03
			$curVal = strval($this->description_03->CurrentValue);
			if ($curVal <> "") {
				$this->description_03->ViewValue = $this->description_03->lookupCacheOption($curVal);
				if ($this->description_03->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_03->ViewValue = $this->description_03->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_03->ViewValue = $this->description_03->CurrentValue;
					}
				}
			} else {
				$this->description_03->ViewValue = NULL;
			}
			$this->description_03->ViewCustomAttributes = "";

			// d_04_head
			$curVal = strval($this->d_04_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_04_head->ViewValue = $this->d_04_head->lookupCacheOption($curVal);
				if ($this->d_04_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_04_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_04_head->ViewValue = $this->d_04_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_04_head->ViewValue = $this->d_04_head->CurrentValue;
					}
				}
			} else {
				$this->d_04_head->ViewValue = NULL;
			}
			$this->d_04_head->ViewCustomAttributes = "";

			// description_04
			$curVal = strval($this->description_04->CurrentValue);
			if ($curVal <> "") {
				$this->description_04->ViewValue = $this->description_04->lookupCacheOption($curVal);
				if ($this->description_04->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_04->ViewValue = $this->description_04->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_04->ViewValue = $this->description_04->CurrentValue;
					}
				}
			} else {
				$this->description_04->ViewValue = NULL;
			}
			$this->description_04->ViewCustomAttributes = "";

			// d_05_head
			$curVal = strval($this->d_05_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_05_head->ViewValue = $this->d_05_head->lookupCacheOption($curVal);
				if ($this->d_05_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_05_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_05_head->ViewValue = $this->d_05_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_05_head->ViewValue = $this->d_05_head->CurrentValue;
					}
				}
			} else {
				$this->d_05_head->ViewValue = NULL;
			}
			$this->d_05_head->ViewCustomAttributes = "";

			// description_05
			$curVal = strval($this->description_05->CurrentValue);
			if ($curVal <> "") {
				$this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
				if ($this->description_05->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_05->ViewValue = $this->description_05->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_05->ViewValue = $this->description_05->CurrentValue;
					}
				}
			} else {
				$this->description_05->ViewValue = NULL;
			}
			$this->description_05->ViewCustomAttributes = "";

			// d_06_head
			$curVal = strval($this->d_06_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_06_head->ViewValue = $this->d_06_head->lookupCacheOption($curVal);
				if ($this->d_06_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_06_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_06_head->ViewValue = $this->d_06_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_06_head->ViewValue = $this->d_06_head->CurrentValue;
					}
				}
			} else {
				$this->d_06_head->ViewValue = NULL;
			}
			$this->d_06_head->ViewCustomAttributes = "";

			// description_06
			$curVal = strval($this->description_06->CurrentValue);
			if ($curVal <> "") {
				$this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
				if ($this->description_06->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_06->ViewValue = $this->description_06->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_06->ViewValue = $this->description_06->CurrentValue;
					}
				}
			} else {
				$this->description_06->ViewValue = NULL;
			}
			$this->description_06->ViewCustomAttributes = "";

			// d_07_head
			$curVal = strval($this->d_07_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_07_head->ViewValue = $this->d_07_head->lookupCacheOption($curVal);
				if ($this->d_07_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_07_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_07_head->ViewValue = $this->d_07_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_07_head->ViewValue = $this->d_07_head->CurrentValue;
					}
				}
			} else {
				$this->d_07_head->ViewValue = NULL;
			}
			$this->d_07_head->ViewCustomAttributes = "";

			// description_07
			$this->description_07->ViewValue = $this->description_07->CurrentValue;
			$this->description_07->ViewCustomAttributes = "";

			// d_08_head
			$curVal = strval($this->d_08_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_08_head->ViewValue = $this->d_08_head->lookupCacheOption($curVal);
				if ($this->d_08_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_08_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_08_head->ViewValue = $this->d_08_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_08_head->ViewValue = $this->d_08_head->CurrentValue;
					}
				}
			} else {
				$this->d_08_head->ViewValue = NULL;
			}
			$this->d_08_head->ViewCustomAttributes = "";

			// description_08
			$this->description_08->ViewValue = $this->description_08->CurrentValue;
			$this->description_08->ViewCustomAttributes = "";

			// d_09_head
			$curVal = strval($this->d_09_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
				if ($this->d_09_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_09_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_09_head->ViewValue = $this->d_09_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_09_head->ViewValue = $this->d_09_head->CurrentValue;
					}
				}
			} else {
				$this->d_09_head->ViewValue = NULL;
			}
			$this->d_09_head->ViewCustomAttributes = "";

			// description_09
			$this->description_09->ViewValue = $this->description_09->CurrentValue;
			$this->description_09->ViewCustomAttributes = "";

			// d_10_head
			$curVal = strval($this->d_10_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
				if ($this->d_10_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_10_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_10_head->ViewValue = $this->d_10_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_10_head->ViewValue = $this->d_10_head->CurrentValue;
					}
				}
			} else {
				$this->d_10_head->ViewValue = NULL;
			}
			$this->d_10_head->ViewCustomAttributes = "";

			// description_10
			$this->description_10->ViewValue = $this->description_10->CurrentValue;
			$this->description_10->ViewCustomAttributes = "";

			// d_11_head
			$curVal = strval($this->d_11_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
				if ($this->d_11_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_11_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_11_head->ViewValue = $this->d_11_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_11_head->ViewValue = $this->d_11_head->CurrentValue;
					}
				}
			} else {
				$this->d_11_head->ViewValue = NULL;
			}
			$this->d_11_head->ViewCustomAttributes = "";

			// description_11
			$this->description_11->ViewValue = $this->description_11->CurrentValue;
			$this->description_11->ViewCustomAttributes = "";

			// d_12_head
			$curVal = strval($this->d_12_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
				if ($this->d_12_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_12_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_12_head->ViewValue = $this->d_12_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_12_head->ViewValue = $this->d_12_head->CurrentValue;
					}
				}
			} else {
				$this->d_12_head->ViewValue = NULL;
			}
			$this->d_12_head->ViewCustomAttributes = "";

			// description_12
			$this->description_12->ViewValue = $this->description_12->CurrentValue;
			$this->description_12->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// a_operator
			$curVal = strval($this->a_operator->CurrentValue);
			if ($curVal <> "") {
				$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
				if ($this->a_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
					}
				}
			} else {
				$this->a_operator->ViewValue = NULL;
			}
			$this->a_operator->ViewCustomAttributes = "";

			// a_datetime
			$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
			$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 0);
			$this->a_datetime->ViewCustomAttributes = "";

			// production_site
			$this->production_site->ViewValue = $this->production_site->CurrentValue;
			$this->production_site->ViewValue = FormatNumber($this->production_site->ViewValue, 0, -2, -2, -2);
			$this->production_site->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "po_fplist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// buyer_product_ref
			$this->buyer_product_ref->LinkCustomAttributes = "";
			$this->buyer_product_ref->HrefValue = "";
			$this->buyer_product_ref->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "po_fplist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "po_fplist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "po_fplist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";

			// product_gcode
			$this->product_gcode->LinkCustomAttributes = "";
			$this->product_gcode->HrefValue = "";
			$this->product_gcode->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// balance_quantity
			$this->balance_quantity->LinkCustomAttributes = "";
			$this->balance_quantity->HrefValue = "";
			$this->balance_quantity->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// buyer_order_no
			$this->buyer_order_no->LinkCustomAttributes = "";
			$this->buyer_order_no->HrefValue = "";
			$this->buyer_order_no->TooltipValue = "";

			// buyer_order_date
			$this->buyer_order_date->LinkCustomAttributes = "";
			$this->buyer_order_date->HrefValue = "";
			$this->buyer_order_date->TooltipValue = "";

			// buyer_instruction
			$this->buyer_instruction->LinkCustomAttributes = "";
			$this->buyer_instruction->HrefValue = "";
			$this->buyer_instruction->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";
			$this->production_plan->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// d_01_head
			$this->d_01_head->LinkCustomAttributes = "";
			$this->d_01_head->HrefValue = "";
			$this->d_01_head->TooltipValue = "";

			// description_01
			$this->description_01->LinkCustomAttributes = "";
			$this->description_01->HrefValue = "";
			$this->description_01->TooltipValue = "";

			// d_02_head
			$this->d_02_head->LinkCustomAttributes = "";
			$this->d_02_head->HrefValue = "";
			$this->d_02_head->TooltipValue = "";

			// description_02
			$this->description_02->LinkCustomAttributes = "";
			$this->description_02->HrefValue = "";
			$this->description_02->TooltipValue = "";

			// d_03_head
			$this->d_03_head->LinkCustomAttributes = "";
			$this->d_03_head->HrefValue = "";
			$this->d_03_head->TooltipValue = "";

			// description_03
			$this->description_03->LinkCustomAttributes = "";
			$this->description_03->HrefValue = "";
			$this->description_03->TooltipValue = "";

			// d_04_head
			$this->d_04_head->LinkCustomAttributes = "";
			$this->d_04_head->HrefValue = "";
			$this->d_04_head->TooltipValue = "";

			// description_04
			$this->description_04->LinkCustomAttributes = "";
			$this->description_04->HrefValue = "";
			$this->description_04->TooltipValue = "";

			// d_05_head
			$this->d_05_head->LinkCustomAttributes = "";
			$this->d_05_head->HrefValue = "";
			$this->d_05_head->TooltipValue = "";

			// description_05
			$this->description_05->LinkCustomAttributes = "";
			$this->description_05->HrefValue = "";
			$this->description_05->TooltipValue = "";

			// d_06_head
			$this->d_06_head->LinkCustomAttributes = "";
			$this->d_06_head->HrefValue = "";
			$this->d_06_head->TooltipValue = "";

			// description_06
			$this->description_06->LinkCustomAttributes = "";
			$this->description_06->HrefValue = "";
			$this->description_06->TooltipValue = "";

			// d_07_head
			$this->d_07_head->LinkCustomAttributes = "";
			$this->d_07_head->HrefValue = "";
			$this->d_07_head->TooltipValue = "";

			// description_07
			$this->description_07->LinkCustomAttributes = "";
			$this->description_07->HrefValue = "";
			$this->description_07->TooltipValue = "";

			// d_08_head
			$this->d_08_head->LinkCustomAttributes = "";
			$this->d_08_head->HrefValue = "";
			$this->d_08_head->TooltipValue = "";

			// description_08
			$this->description_08->LinkCustomAttributes = "";
			$this->description_08->HrefValue = "";
			$this->description_08->TooltipValue = "";

			// d_09_head
			$this->d_09_head->LinkCustomAttributes = "";
			$this->d_09_head->HrefValue = "";
			$this->d_09_head->TooltipValue = "";

			// description_09
			$this->description_09->LinkCustomAttributes = "";
			$this->description_09->HrefValue = "";
			$this->description_09->TooltipValue = "";

			// d_10_head
			$this->d_10_head->LinkCustomAttributes = "";
			$this->d_10_head->HrefValue = "";
			$this->d_10_head->TooltipValue = "";

			// description_10
			$this->description_10->LinkCustomAttributes = "";
			$this->description_10->HrefValue = "";
			$this->description_10->TooltipValue = "";

			// d_11_head
			$this->d_11_head->LinkCustomAttributes = "";
			$this->d_11_head->HrefValue = "";
			$this->d_11_head->TooltipValue = "";

			// description_11
			$this->description_11->LinkCustomAttributes = "";
			$this->description_11->HrefValue = "";
			$this->description_11->TooltipValue = "";

			// d_12_head
			$this->d_12_head->LinkCustomAttributes = "";
			$this->d_12_head->HrefValue = "";
			$this->d_12_head->TooltipValue = "";

			// description_12
			$this->description_12->LinkCustomAttributes = "";
			$this->description_12->HrefValue = "";
			$this->description_12->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// a_operator
			$this->a_operator->LinkCustomAttributes = "";
			$this->a_operator->HrefValue = "";
			$this->a_operator->TooltipValue = "";

			// a_datetime
			$this->a_datetime->LinkCustomAttributes = "";
			$this->a_datetime->HrefValue = "";
			$this->a_datetime->TooltipValue = "";

			// production_site
			$this->production_site->LinkCustomAttributes = "";
			$this->production_site->HrefValue = "";
			$this->production_site->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$this->grp->EditValue = $this->grp->options(TRUE);

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->buyer_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->buyer_id->AdvancedSearch->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
			else
				$this->buyer_id->AdvancedSearch->ViewValue = $this->buyer_id->Lookup !== NULL && is_array($this->buyer_id->Lookup->Options) ? $curVal : NULL;
			if ($this->buyer_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->buyer_id->EditValue = array_values($this->buyer_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->buyer_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` > 1000 AND `grp`=2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->buyer_id->EditValue = $arwrk;
			}

			// buyer_product_ref
			$this->buyer_product_ref->EditAttrs["class"] = "form-control";
			$this->buyer_product_ref->EditCustomAttributes = "";
			$curVal = trim(strval($this->buyer_product_ref->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->buyer_product_ref->AdvancedSearch->ViewValue = $this->buyer_product_ref->lookupCacheOption($curVal);
			else
				$this->buyer_product_ref->AdvancedSearch->ViewValue = $this->buyer_product_ref->Lookup !== NULL && is_array($this->buyer_product_ref->Lookup->Options) ? $curVal : NULL;
			if ($this->buyer_product_ref->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->buyer_product_ref->EditValue = array_values($this->buyer_product_ref->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->buyer_product_ref->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->buyer_product_ref->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->buyer_product_ref->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$this->s_grp->EditValue = HtmlEncode($this->s_grp->AdvancedSearch->SearchValue);
			$curVal = strval($this->s_grp->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->EditValue = HtmlEncode($this->s_grp->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->s_grp->EditValue = NULL;
			}
			$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$this->product->EditValue = HtmlEncode($this->product->AdvancedSearch->SearchValue);
			$curVal = strval($this->product->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->product->EditValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->product->EditValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->EditValue = HtmlEncode($this->product->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->product->EditValue = NULL;
			}
			$this->product->PlaceHolder = RemoveHtml($this->product->caption());

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			$this->rid->EditValue = HtmlEncode($this->rid->AdvancedSearch->SearchValue);
			$curVal = strval($this->rid->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->rid->EditValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->EditValue = HtmlEncode($this->rid->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->rid->EditValue = NULL;
			}
			$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

			// product_gcode
			$this->product_gcode->EditAttrs["class"] = "form-control";
			$this->product_gcode->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_gcode->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->product_gcode->AdvancedSearch->ViewValue = $this->product_gcode->lookupCacheOption($curVal);
			else
				$this->product_gcode->AdvancedSearch->ViewValue = $this->product_gcode->Lookup !== NULL && is_array($this->product_gcode->Lookup->Options) ? $curVal : NULL;
			if ($this->product_gcode->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->product_gcode->EditValue = array_values($this->product_gcode->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`gcode`" . SearchString("=", $this->product_gcode->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->product_gcode->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_gcode->EditValue = $arwrk;
			}

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->AdvancedSearch->SearchValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// balance_quantity
			$this->balance_quantity->EditAttrs["class"] = "form-control";
			$this->balance_quantity->EditCustomAttributes = "";
			$this->balance_quantity->EditValue = HtmlEncode($this->balance_quantity->AdvancedSearch->SearchValue);
			$this->balance_quantity->PlaceHolder = RemoveHtml($this->balance_quantity->caption());

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = HtmlEncode($this->price->AdvancedSearch->SearchValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());

			// buyer_order_no
			$this->buyer_order_no->EditAttrs["class"] = "form-control";
			$this->buyer_order_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_order_no->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_order_no->AdvancedSearch->SearchValue);
			$this->buyer_order_no->EditValue = HtmlEncode($this->buyer_order_no->AdvancedSearch->SearchValue);
			$this->buyer_order_no->PlaceHolder = RemoveHtml($this->buyer_order_no->caption());

			// buyer_order_date
			$this->buyer_order_date->EditAttrs["class"] = "form-control";
			$this->buyer_order_date->EditCustomAttributes = "";
			$this->buyer_order_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->buyer_order_date->AdvancedSearch->SearchValue, 0), 8));
			$this->buyer_order_date->PlaceHolder = RemoveHtml($this->buyer_order_date->caption());

			// buyer_instruction
			$this->buyer_instruction->EditAttrs["class"] = "form-control";
			$this->buyer_instruction->EditCustomAttributes = "";
			$this->buyer_instruction->EditValue = HtmlEncode($this->buyer_instruction->AdvancedSearch->SearchValue);
			$this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

			// despatch_date
			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->despatch_date->AdvancedSearch->SearchValue, 0), 8));
			$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

			// production_plan
			$this->production_plan->EditAttrs["class"] = "form-control";
			$this->production_plan->EditCustomAttributes = "";
			$this->production_plan->EditValue = $this->production_plan->options(TRUE);

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lot_no->AdvancedSearch->SearchValue = HtmlDecode($this->lot_no->AdvancedSearch->SearchValue);
			$this->lot_no->EditValue = HtmlEncode($this->lot_no->AdvancedSearch->SearchValue);
			$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

			// d_01_head
			$this->d_01_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_01_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_01_head->AdvancedSearch->ViewValue = $this->d_01_head->lookupCacheOption($curVal);
			else
				$this->d_01_head->AdvancedSearch->ViewValue = $this->d_01_head->Lookup !== NULL && is_array($this->d_01_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_01_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_01_head->EditValue = array_values($this->d_01_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_01_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_01_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_01_head->EditValue = $arwrk;
			}

			// description_01
			$this->description_01->EditAttrs["class"] = "form-control";
			$this->description_01->EditCustomAttributes = "";
			$this->description_01->EditValue = HtmlEncode($this->description_01->AdvancedSearch->SearchValue);
			$this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());

			// d_02_head
			$this->d_02_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_02_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_02_head->AdvancedSearch->ViewValue = $this->d_02_head->lookupCacheOption($curVal);
			else
				$this->d_02_head->AdvancedSearch->ViewValue = $this->d_02_head->Lookup !== NULL && is_array($this->d_02_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_02_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_02_head->EditValue = array_values($this->d_02_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_02_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_02_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_02_head->EditValue = $arwrk;
			}

			// description_02
			$this->description_02->EditAttrs["class"] = "form-control";
			$this->description_02->EditCustomAttributes = "";
			$this->description_02->EditValue = HtmlEncode($this->description_02->AdvancedSearch->SearchValue);
			$this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());

			// d_03_head
			$this->d_03_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_03_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_03_head->AdvancedSearch->ViewValue = $this->d_03_head->lookupCacheOption($curVal);
			else
				$this->d_03_head->AdvancedSearch->ViewValue = $this->d_03_head->Lookup !== NULL && is_array($this->d_03_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_03_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_03_head->EditValue = array_values($this->d_03_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_03_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_03_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_03_head->EditValue = $arwrk;
			}

			// description_03
			$this->description_03->EditAttrs["class"] = "form-control";
			$this->description_03->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_03->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->description_03->AdvancedSearch->ViewValue = $this->description_03->lookupCacheOption($curVal);
			else
				$this->description_03->AdvancedSearch->ViewValue = $this->description_03->Lookup !== NULL && is_array($this->description_03->Lookup->Options) ? $curVal : NULL;
			if ($this->description_03->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->description_03->EditValue = array_values($this->description_03->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->description_03->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_03->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->description_03->EditValue = $arwrk;
			}

			// d_04_head
			$this->d_04_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_04_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_04_head->AdvancedSearch->ViewValue = $this->d_04_head->lookupCacheOption($curVal);
			else
				$this->d_04_head->AdvancedSearch->ViewValue = $this->d_04_head->Lookup !== NULL && is_array($this->d_04_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_04_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_04_head->EditValue = array_values($this->d_04_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_04_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_04_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_04_head->EditValue = $arwrk;
			}

			// description_04
			$this->description_04->EditAttrs["class"] = "form-control";
			$this->description_04->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_04->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->description_04->AdvancedSearch->ViewValue = $this->description_04->lookupCacheOption($curVal);
			else
				$this->description_04->AdvancedSearch->ViewValue = $this->description_04->Lookup !== NULL && is_array($this->description_04->Lookup->Options) ? $curVal : NULL;
			if ($this->description_04->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->description_04->EditValue = array_values($this->description_04->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->description_04->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_04->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->description_04->EditValue = $arwrk;
			}

			// d_05_head
			$this->d_05_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_05_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_05_head->AdvancedSearch->ViewValue = $this->d_05_head->lookupCacheOption($curVal);
			else
				$this->d_05_head->AdvancedSearch->ViewValue = $this->d_05_head->Lookup !== NULL && is_array($this->d_05_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_05_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_05_head->EditValue = array_values($this->d_05_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_05_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_05_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_05_head->EditValue = $arwrk;
			}

			// description_05
			$this->description_05->EditAttrs["class"] = "form-control";
			$this->description_05->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_05->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->description_05->AdvancedSearch->ViewValue = $this->description_05->lookupCacheOption($curVal);
			else
				$this->description_05->AdvancedSearch->ViewValue = $this->description_05->Lookup !== NULL && is_array($this->description_05->Lookup->Options) ? $curVal : NULL;
			if ($this->description_05->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->description_05->EditValue = array_values($this->description_05->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->description_05->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_05->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->description_05->EditValue = $arwrk;
			}

			// d_06_head
			$this->d_06_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_06_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_06_head->AdvancedSearch->ViewValue = $this->d_06_head->lookupCacheOption($curVal);
			else
				$this->d_06_head->AdvancedSearch->ViewValue = $this->d_06_head->Lookup !== NULL && is_array($this->d_06_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_06_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_06_head->EditValue = array_values($this->d_06_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_06_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_06_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_06_head->EditValue = $arwrk;
			}

			// description_06
			$this->description_06->EditAttrs["class"] = "form-control";
			$this->description_06->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_06->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->description_06->AdvancedSearch->ViewValue = $this->description_06->lookupCacheOption($curVal);
			else
				$this->description_06->AdvancedSearch->ViewValue = $this->description_06->Lookup !== NULL && is_array($this->description_06->Lookup->Options) ? $curVal : NULL;
			if ($this->description_06->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->description_06->EditValue = array_values($this->description_06->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->description_06->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_06->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->description_06->EditValue = $arwrk;
			}

			// d_07_head
			$this->d_07_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_07_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_07_head->AdvancedSearch->ViewValue = $this->d_07_head->lookupCacheOption($curVal);
			else
				$this->d_07_head->AdvancedSearch->ViewValue = $this->d_07_head->Lookup !== NULL && is_array($this->d_07_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_07_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_07_head->EditValue = array_values($this->d_07_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_07_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_07_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_07_head->EditValue = $arwrk;
			}

			// description_07
			$this->description_07->EditAttrs["class"] = "form-control";
			$this->description_07->EditCustomAttributes = "";
			$this->description_07->EditValue = HtmlEncode($this->description_07->AdvancedSearch->SearchValue);
			$this->description_07->PlaceHolder = RemoveHtml($this->description_07->caption());

			// d_08_head
			$this->d_08_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_08_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_08_head->AdvancedSearch->ViewValue = $this->d_08_head->lookupCacheOption($curVal);
			else
				$this->d_08_head->AdvancedSearch->ViewValue = $this->d_08_head->Lookup !== NULL && is_array($this->d_08_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_08_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_08_head->EditValue = array_values($this->d_08_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_08_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_08_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_08_head->EditValue = $arwrk;
			}

			// description_08
			$this->description_08->EditAttrs["class"] = "form-control";
			$this->description_08->EditCustomAttributes = "";
			$this->description_08->EditValue = HtmlEncode($this->description_08->AdvancedSearch->SearchValue);
			$this->description_08->PlaceHolder = RemoveHtml($this->description_08->caption());

			// d_09_head
			$this->d_09_head->EditAttrs["class"] = "form-control";
			$this->d_09_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_09_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_09_head->AdvancedSearch->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
			else
				$this->d_09_head->AdvancedSearch->ViewValue = $this->d_09_head->Lookup !== NULL && is_array($this->d_09_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_09_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_09_head->EditValue = array_values($this->d_09_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_09_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_09_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_09_head->EditValue = $arwrk;
			}

			// description_09
			$this->description_09->EditAttrs["class"] = "form-control";
			$this->description_09->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_09->AdvancedSearch->SearchValue = HtmlDecode($this->description_09->AdvancedSearch->SearchValue);
			$this->description_09->EditValue = HtmlEncode($this->description_09->AdvancedSearch->SearchValue);
			$this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

			// d_10_head
			$this->d_10_head->EditAttrs["class"] = "form-control";
			$this->d_10_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_10_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_10_head->AdvancedSearch->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
			else
				$this->d_10_head->AdvancedSearch->ViewValue = $this->d_10_head->Lookup !== NULL && is_array($this->d_10_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_10_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_10_head->EditValue = array_values($this->d_10_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_10_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_10_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_10_head->EditValue = $arwrk;
			}

			// description_10
			$this->description_10->EditAttrs["class"] = "form-control";
			$this->description_10->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_10->AdvancedSearch->SearchValue = HtmlDecode($this->description_10->AdvancedSearch->SearchValue);
			$this->description_10->EditValue = HtmlEncode($this->description_10->AdvancedSearch->SearchValue);
			$this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());

			// d_11_head
			$this->d_11_head->EditAttrs["class"] = "form-control";
			$this->d_11_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_11_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_11_head->AdvancedSearch->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
			else
				$this->d_11_head->AdvancedSearch->ViewValue = $this->d_11_head->Lookup !== NULL && is_array($this->d_11_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_11_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_11_head->EditValue = array_values($this->d_11_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_11_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_11_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_11_head->EditValue = $arwrk;
			}

			// description_11
			$this->description_11->EditAttrs["class"] = "form-control";
			$this->description_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_11->AdvancedSearch->SearchValue = HtmlDecode($this->description_11->AdvancedSearch->SearchValue);
			$this->description_11->EditValue = HtmlEncode($this->description_11->AdvancedSearch->SearchValue);
			$this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

			// d_12_head
			$this->d_12_head->EditAttrs["class"] = "form-control";
			$this->d_12_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_12_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_12_head->AdvancedSearch->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
			else
				$this->d_12_head->AdvancedSearch->ViewValue = $this->d_12_head->Lookup !== NULL && is_array($this->d_12_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_12_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_12_head->EditValue = array_values($this->d_12_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_12_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_12_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_12_head->EditValue = $arwrk;
			}

			// description_12
			$this->description_12->EditAttrs["class"] = "form-control";
			$this->description_12->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_12->AdvancedSearch->SearchValue = HtmlDecode($this->description_12->AdvancedSearch->SearchValue);
			$this->description_12->EditValue = HtmlEncode($this->description_12->AdvancedSearch->SearchValue);
			$this->description_12->PlaceHolder = RemoveHtml($this->description_12->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// a_operator
			$this->a_operator->EditAttrs["class"] = "form-control";
			$this->a_operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->a_operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->lookupCacheOption($curVal);
			else
				$this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->Lookup !== NULL && is_array($this->a_operator->Lookup->Options) ? $curVal : NULL;
			if ($this->a_operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->a_operator->EditValue = array_values($this->a_operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->a_operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->a_operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->a_operator->EditValue = $arwrk;
			}

			// a_datetime
			$this->a_datetime->EditAttrs["class"] = "form-control";
			$this->a_datetime->EditCustomAttributes = "";
			$this->a_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->a_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->a_datetime->PlaceHolder = RemoveHtml($this->a_datetime->caption());

			// production_site
			$this->production_site->EditAttrs["class"] = "form-control";
			$this->production_site->EditCustomAttributes = "";
			$this->production_site->EditValue = HtmlEncode($this->production_site->AdvancedSearch->SearchValue);
			$this->production_site->PlaceHolder = RemoveHtml($this->production_site->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->s_grp->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->s_grp->errorMessage());
		}
		if (!CheckInteger($this->product->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->product->errorMessage());
		}
		if (!CheckInteger($this->rid->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->rid->errorMessage());
		}
		if (!CheckNumber($this->balance_quantity->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->balance_quantity->errorMessage());
		}
		if (!CheckDate($this->buyer_order_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->buyer_order_date->errorMessage());
		}
		if (!CheckDate($this->despatch_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->despatch_date->errorMessage());
		}
		if (!CheckNumber($this->description_01->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->description_01->errorMessage());
		}
		if (!CheckNumber($this->description_02->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->description_02->errorMessage());
		}
		if (!CheckInteger($this->production_site->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->production_site->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->buyer_id->AdvancedSearch->load();
		$this->buyer_product_ref->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->rid->AdvancedSearch->load();
		$this->product_gcode->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->balance_quantity->AdvancedSearch->load();
		$this->price->AdvancedSearch->load();
		$this->buyer_order_no->AdvancedSearch->load();
		$this->buyer_order_date->AdvancedSearch->load();
		$this->buyer_instruction->AdvancedSearch->load();
		$this->despatch_date->AdvancedSearch->load();
		$this->production_plan->AdvancedSearch->load();
		$this->lot_no->AdvancedSearch->load();
		$this->d_01_head->AdvancedSearch->load();
		$this->description_01->AdvancedSearch->load();
		$this->d_02_head->AdvancedSearch->load();
		$this->description_02->AdvancedSearch->load();
		$this->d_03_head->AdvancedSearch->load();
		$this->description_03->AdvancedSearch->load();
		$this->d_04_head->AdvancedSearch->load();
		$this->description_04->AdvancedSearch->load();
		$this->d_05_head->AdvancedSearch->load();
		$this->description_05->AdvancedSearch->load();
		$this->d_06_head->AdvancedSearch->load();
		$this->description_06->AdvancedSearch->load();
		$this->d_07_head->AdvancedSearch->load();
		$this->description_07->AdvancedSearch->load();
		$this->d_08_head->AdvancedSearch->load();
		$this->description_08->AdvancedSearch->load();
		$this->d_09_head->AdvancedSearch->load();
		$this->description_09->AdvancedSearch->load();
		$this->d_10_head->AdvancedSearch->load();
		$this->description_10->AdvancedSearch->load();
		$this->d_11_head->AdvancedSearch->load();
		$this->description_11->AdvancedSearch->load();
		$this->d_12_head->AdvancedSearch->load();
		$this->description_12->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->a_operator->AdvancedSearch->load();
		$this->a_datetime->AdvancedSearch->load();
		$this->production_site->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("po_fplist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Style = "tabs";
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_buyer_id":
					$lookupFilter = function() {
						return "`id` > 1000 AND `grp`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1 and `grp` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_03":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_04":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_05":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_06":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyer_id":
							break;
						case "x_buyer_product_ref":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_product_gcode":
							break;
						case "x_d_01_head":
							break;
						case "x_d_02_head":
							break;
						case "x_d_03_head":
							break;
						case "x_description_03":
							break;
						case "x_d_04_head":
							break;
						case "x_description_04":
							break;
						case "x_d_05_head":
							break;
						case "x_description_05":
							break;
						case "x_d_06_head":
							break;
						case "x_description_06":
							break;
						case "x_d_07_head":
							break;
						case "x_d_08_head":
							break;
						case "x_d_09_head":
							break;
						case "x_d_10_head":
							break;
						case "x_d_11_head":
							break;
						case "x_d_12_head":
							break;
						case "x_operator":
							break;
						case "x_a_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
			PageFieldValidate($this,'po_fp');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>