<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class po_overall_cross_search extends po_overall_cross
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'po_overall_cross';

	// Page object name
	public $PageObjName = "po_overall_cross_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (po_overall_cross)
		if (!isset($GLOBALS["po_overall_cross"]) || get_class($GLOBALS["po_overall_cross"]) == PROJECT_NAMESPACE . "po_overall_cross") {
			$GLOBALS["po_overall_cross"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["po_overall_cross"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_overall_cross');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $po_overall_cross;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($po_overall_cross);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "po_overall_crossview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("po_overall_crosslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Buyer->setVisibility();
		$this->Month->setVisibility();
		$this->SQM_CY->setVisibility();
		$this->Amount_CY->setVisibility();
		$this->SQM_PY->setVisibility();
		$this->Amount_PY->setVisibility();
		$this->SQM_BPY->setVisibility();
		$this->Amount_BPY->setVisibility();
		$this->SQM_BBPY->setVisibility();
		$this->Amount_BBPY->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->Buyer);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "po_overall_crosslist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->Buyer); // Buyer
		$this->buildSearchUrl($srchUrl, $this->Month); // Month
		$this->buildSearchUrl($srchUrl, $this->SQM_CY); // SQM_CY
		$this->buildSearchUrl($srchUrl, $this->Amount_CY); // Amount_CY
		$this->buildSearchUrl($srchUrl, $this->SQM_PY); // SQM_PY
		$this->buildSearchUrl($srchUrl, $this->Amount_PY); // Amount_PY
		$this->buildSearchUrl($srchUrl, $this->SQM_BPY); // SQM_BPY
		$this->buildSearchUrl($srchUrl, $this->Amount_BPY); // Amount_BPY
		$this->buildSearchUrl($srchUrl, $this->SQM_BBPY); // SQM_BBPY
		$this->buildSearchUrl($srchUrl, $this->Amount_BBPY); // Amount_BBPY
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// Buyer

		if (!$this->isAddOrEdit())
			$this->Buyer->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Buyer"));
		$this->Buyer->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Buyer"));

		// Month
		if (!$this->isAddOrEdit())
			$this->Month->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Month"));
		$this->Month->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Month"));

		// SQM_CY
		if (!$this->isAddOrEdit())
			$this->SQM_CY->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_SQM_CY"));
		$this->SQM_CY->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_SQM_CY"));

		// Amount_CY
		if (!$this->isAddOrEdit())
			$this->Amount_CY->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Amount_CY"));
		$this->Amount_CY->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Amount_CY"));

		// SQM_PY
		if (!$this->isAddOrEdit())
			$this->SQM_PY->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_SQM_PY"));
		$this->SQM_PY->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_SQM_PY"));

		// Amount_PY
		if (!$this->isAddOrEdit())
			$this->Amount_PY->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Amount_PY"));
		$this->Amount_PY->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Amount_PY"));

		// SQM_BPY
		if (!$this->isAddOrEdit())
			$this->SQM_BPY->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_SQM_BPY"));
		$this->SQM_BPY->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_SQM_BPY"));

		// Amount_BPY
		if (!$this->isAddOrEdit())
			$this->Amount_BPY->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Amount_BPY"));
		$this->Amount_BPY->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Amount_BPY"));

		// SQM_BBPY
		if (!$this->isAddOrEdit())
			$this->SQM_BBPY->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_SQM_BBPY"));
		$this->SQM_BBPY->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_SQM_BBPY"));

		// Amount_BBPY
		if (!$this->isAddOrEdit())
			$this->Amount_BBPY->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Amount_BBPY"));
		$this->Amount_BBPY->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Amount_BBPY"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->SQM_CY->FormValue == $this->SQM_CY->CurrentValue && is_numeric(ConvertToFloatString($this->SQM_CY->CurrentValue)))
			$this->SQM_CY->CurrentValue = ConvertToFloatString($this->SQM_CY->CurrentValue);

		// Convert decimal values if posted back
		if ($this->SQM_PY->FormValue == $this->SQM_PY->CurrentValue && is_numeric(ConvertToFloatString($this->SQM_PY->CurrentValue)))
			$this->SQM_PY->CurrentValue = ConvertToFloatString($this->SQM_PY->CurrentValue);

		// Convert decimal values if posted back
		if ($this->SQM_BPY->FormValue == $this->SQM_BPY->CurrentValue && is_numeric(ConvertToFloatString($this->SQM_BPY->CurrentValue)))
			$this->SQM_BPY->CurrentValue = ConvertToFloatString($this->SQM_BPY->CurrentValue);

		// Convert decimal values if posted back
		if ($this->SQM_BBPY->FormValue == $this->SQM_BBPY->CurrentValue && is_numeric(ConvertToFloatString($this->SQM_BBPY->CurrentValue)))
			$this->SQM_BBPY->CurrentValue = ConvertToFloatString($this->SQM_BBPY->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Buyer
		// Month
		// SQM_CY
		// Amount_CY
		// SQM_PY
		// Amount_PY
		// SQM_BPY
		// Amount_BPY
		// SQM_BBPY
		// Amount_BBPY

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Buyer
			$curVal = strval($this->Buyer->CurrentValue);
			if ($curVal <> "") {
				$this->Buyer->ViewValue = $this->Buyer->lookupCacheOption($curVal);
				if ($this->Buyer->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->Buyer->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->Buyer->ViewValue = $this->Buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Buyer->ViewValue = $this->Buyer->CurrentValue;
					}
				}
			} else {
				$this->Buyer->ViewValue = NULL;
			}
			$this->Buyer->ViewCustomAttributes = "";

			// Month
			$this->Month->ViewValue = $this->Month->CurrentValue;
			$this->Month->ViewCustomAttributes = "";

			// SQM_CY
			$this->SQM_CY->ViewValue = $this->SQM_CY->CurrentValue;
			$this->SQM_CY->ViewValue = FormatNumber($this->SQM_CY->ViewValue, 2, -2, -2, -2);
			$this->SQM_CY->ViewCustomAttributes = "";

			// Amount_CY
			$this->Amount_CY->ViewValue = $this->Amount_CY->CurrentValue;
			$this->Amount_CY->ViewCustomAttributes = "";

			// SQM_PY
			$this->SQM_PY->ViewValue = $this->SQM_PY->CurrentValue;
			$this->SQM_PY->ViewValue = FormatNumber($this->SQM_PY->ViewValue, 2, -2, -2, -2);
			$this->SQM_PY->ViewCustomAttributes = "";

			// Amount_PY
			$this->Amount_PY->ViewValue = $this->Amount_PY->CurrentValue;
			$this->Amount_PY->ViewCustomAttributes = "";

			// SQM_BPY
			$this->SQM_BPY->ViewValue = $this->SQM_BPY->CurrentValue;
			$this->SQM_BPY->ViewValue = FormatNumber($this->SQM_BPY->ViewValue, 2, -2, -2, -2);
			$this->SQM_BPY->ViewCustomAttributes = "";

			// Amount_BPY
			$this->Amount_BPY->ViewValue = $this->Amount_BPY->CurrentValue;
			$this->Amount_BPY->ViewCustomAttributes = "";

			// SQM_BBPY
			$this->SQM_BBPY->ViewValue = $this->SQM_BBPY->CurrentValue;
			$this->SQM_BBPY->ViewValue = FormatNumber($this->SQM_BBPY->ViewValue, 2, -2, -2, -2);
			$this->SQM_BBPY->ViewCustomAttributes = "";

			// Amount_BBPY
			$this->Amount_BBPY->ViewValue = $this->Amount_BBPY->CurrentValue;
			$this->Amount_BBPY->ViewCustomAttributes = "";

			// Buyer
			$this->Buyer->LinkCustomAttributes = "";
			$this->Buyer->HrefValue = "";
			$this->Buyer->TooltipValue = "";

			// Month
			$this->Month->LinkCustomAttributes = "";
			$this->Month->HrefValue = "";
			$this->Month->TooltipValue = "";

			// SQM_CY
			$this->SQM_CY->LinkCustomAttributes = "";
			$this->SQM_CY->HrefValue = "";
			$this->SQM_CY->TooltipValue = "";

			// Amount_CY
			$this->Amount_CY->LinkCustomAttributes = "";
			$this->Amount_CY->HrefValue = "";
			$this->Amount_CY->TooltipValue = "";

			// SQM_PY
			$this->SQM_PY->LinkCustomAttributes = "";
			$this->SQM_PY->HrefValue = "";
			$this->SQM_PY->TooltipValue = "";

			// Amount_PY
			$this->Amount_PY->LinkCustomAttributes = "";
			$this->Amount_PY->HrefValue = "";
			$this->Amount_PY->TooltipValue = "";

			// SQM_BPY
			$this->SQM_BPY->LinkCustomAttributes = "";
			$this->SQM_BPY->HrefValue = "";
			$this->SQM_BPY->TooltipValue = "";

			// Amount_BPY
			$this->Amount_BPY->LinkCustomAttributes = "";
			$this->Amount_BPY->HrefValue = "";
			$this->Amount_BPY->TooltipValue = "";

			// SQM_BBPY
			$this->SQM_BBPY->LinkCustomAttributes = "";
			$this->SQM_BBPY->HrefValue = "";
			$this->SQM_BBPY->TooltipValue = "";

			// Amount_BBPY
			$this->Amount_BBPY->LinkCustomAttributes = "";
			$this->Amount_BBPY->HrefValue = "";
			$this->Amount_BBPY->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// Buyer
			$this->Buyer->EditAttrs["class"] = "form-control";
			$this->Buyer->EditCustomAttributes = "";
			$curVal = trim(strval($this->Buyer->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->Buyer->AdvancedSearch->ViewValue = $this->Buyer->lookupCacheOption($curVal);
			else
				$this->Buyer->AdvancedSearch->ViewValue = $this->Buyer->Lookup !== NULL && is_array($this->Buyer->Lookup->Options) ? $curVal : NULL;
			if ($this->Buyer->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->Buyer->EditValue = array_values($this->Buyer->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->Buyer->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->Buyer->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->Buyer->EditValue = $arwrk;
			}

			// Month
			$this->Month->EditAttrs["class"] = "form-control";
			$this->Month->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->Month->AdvancedSearch->SearchValue = HtmlDecode($this->Month->AdvancedSearch->SearchValue);
			$this->Month->EditValue = HtmlEncode($this->Month->AdvancedSearch->SearchValue);
			$this->Month->PlaceHolder = RemoveHtml($this->Month->caption());

			// SQM_CY
			$this->SQM_CY->EditAttrs["class"] = "form-control";
			$this->SQM_CY->EditCustomAttributes = "";
			$this->SQM_CY->EditValue = HtmlEncode($this->SQM_CY->AdvancedSearch->SearchValue);
			$this->SQM_CY->PlaceHolder = RemoveHtml($this->SQM_CY->caption());

			// Amount_CY
			$this->Amount_CY->EditAttrs["class"] = "form-control";
			$this->Amount_CY->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->Amount_CY->AdvancedSearch->SearchValue = HtmlDecode($this->Amount_CY->AdvancedSearch->SearchValue);
			$this->Amount_CY->EditValue = HtmlEncode($this->Amount_CY->AdvancedSearch->SearchValue);
			$this->Amount_CY->PlaceHolder = RemoveHtml($this->Amount_CY->caption());

			// SQM_PY
			$this->SQM_PY->EditAttrs["class"] = "form-control";
			$this->SQM_PY->EditCustomAttributes = "";
			$this->SQM_PY->EditValue = HtmlEncode($this->SQM_PY->AdvancedSearch->SearchValue);
			$this->SQM_PY->PlaceHolder = RemoveHtml($this->SQM_PY->caption());

			// Amount_PY
			$this->Amount_PY->EditAttrs["class"] = "form-control";
			$this->Amount_PY->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->Amount_PY->AdvancedSearch->SearchValue = HtmlDecode($this->Amount_PY->AdvancedSearch->SearchValue);
			$this->Amount_PY->EditValue = HtmlEncode($this->Amount_PY->AdvancedSearch->SearchValue);
			$this->Amount_PY->PlaceHolder = RemoveHtml($this->Amount_PY->caption());

			// SQM_BPY
			$this->SQM_BPY->EditAttrs["class"] = "form-control";
			$this->SQM_BPY->EditCustomAttributes = "";
			$this->SQM_BPY->EditValue = HtmlEncode($this->SQM_BPY->AdvancedSearch->SearchValue);
			$this->SQM_BPY->PlaceHolder = RemoveHtml($this->SQM_BPY->caption());

			// Amount_BPY
			$this->Amount_BPY->EditAttrs["class"] = "form-control";
			$this->Amount_BPY->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->Amount_BPY->AdvancedSearch->SearchValue = HtmlDecode($this->Amount_BPY->AdvancedSearch->SearchValue);
			$this->Amount_BPY->EditValue = HtmlEncode($this->Amount_BPY->AdvancedSearch->SearchValue);
			$this->Amount_BPY->PlaceHolder = RemoveHtml($this->Amount_BPY->caption());

			// SQM_BBPY
			$this->SQM_BBPY->EditAttrs["class"] = "form-control";
			$this->SQM_BBPY->EditCustomAttributes = "";
			$this->SQM_BBPY->EditValue = HtmlEncode($this->SQM_BBPY->AdvancedSearch->SearchValue);
			$this->SQM_BBPY->PlaceHolder = RemoveHtml($this->SQM_BBPY->caption());

			// Amount_BBPY
			$this->Amount_BBPY->EditAttrs["class"] = "form-control";
			$this->Amount_BBPY->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->Amount_BBPY->AdvancedSearch->SearchValue = HtmlDecode($this->Amount_BBPY->AdvancedSearch->SearchValue);
			$this->Amount_BBPY->EditValue = HtmlEncode($this->Amount_BBPY->AdvancedSearch->SearchValue);
			$this->Amount_BBPY->PlaceHolder = RemoveHtml($this->Amount_BBPY->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckNumber($this->SQM_CY->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->SQM_CY->errorMessage());
		}
		if (!CheckNumber($this->SQM_PY->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->SQM_PY->errorMessage());
		}
		if (!CheckNumber($this->SQM_BPY->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->SQM_BPY->errorMessage());
		}
		if (!CheckNumber($this->SQM_BBPY->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->SQM_BBPY->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->Buyer->AdvancedSearch->load();
		$this->Month->AdvancedSearch->load();
		$this->SQM_CY->AdvancedSearch->load();
		$this->Amount_CY->AdvancedSearch->load();
		$this->SQM_PY->AdvancedSearch->load();
		$this->Amount_PY->AdvancedSearch->load();
		$this->SQM_BPY->AdvancedSearch->load();
		$this->Amount_BPY->AdvancedSearch->load();
		$this->SQM_BBPY->AdvancedSearch->load();
		$this->Amount_BBPY->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("po_overall_crosslist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Buyer":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>