<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for po_pending
 */
class po_pending extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $cart_id;
	public $po_id;
	public $partner_order_no;
	public $status;
	public $company_id;
	public $ref;
	public $product_code;
	public $quantity;
	public $stock;
	public $despatch_date;
	public $grp;
	public $product;
	public $partner_id;
	public $avg_quantity;
	public $s_grp;
	public $packing_type;
	public $m_out_id;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'po_pending';
		$this->TableName = 'po_pending';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`po_pending`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// cart_id
		$this->cart_id = new DbField('po_pending', 'po_pending', 'x_cart_id', 'cart_id', '`cart_id`', '`cart_id`', 19, -1, FALSE, '`cart_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cart_id->IsPrimaryKey = TRUE; // Primary key field
		$this->cart_id->Nullable = FALSE; // NOT NULL field
		$this->cart_id->Sortable = TRUE; // Allow sort
		$this->cart_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['cart_id'] = &$this->cart_id;

		// po_id
		$this->po_id = new DbField('po_pending', 'po_pending', 'x_po_id', 'po_id', '`po_id`', '`po_id`', 18, -1, FALSE, '`po_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_id->Sortable = TRUE; // Allow sort
		$this->po_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_id'] = &$this->po_id;

		// partner_order_no
		$this->partner_order_no = new DbField('po_pending', 'po_pending', 'x_partner_order_no', 'partner_order_no', '`partner_order_no`', '`partner_order_no`', 200, -1, FALSE, '`partner_order_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_order_no->Sortable = TRUE; // Allow sort
		$this->fields['partner_order_no'] = &$this->partner_order_no;

		// status
		$this->status = new DbField('po_pending', 'po_pending', 'x_status', 'status', '`status`', '`status`', 16, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'po_pending', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 4;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// company_id
		$this->company_id = new DbField('po_pending', 'po_pending', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 19, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->company_id->Lookup = new Lookup('company_id', 'buyer_seller_view', FALSE, 'id', ["name","mobile","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// ref
		$this->ref = new DbField('po_pending', 'po_pending', 'x_ref', 'ref', '`ref`', '`ref`', 18, -1, FALSE, '`ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ref->Sortable = TRUE; // Allow sort
		$this->ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ref'] = &$this->ref;

		// product_code
		$this->product_code = new DbField('po_pending', 'po_pending', 'x_product_code', 'product_code', '`product_code`', '`product_code`', 201, -1, FALSE, '`product_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_code->Sortable = TRUE; // Allow sort
		$this->fields['product_code'] = &$this->product_code;

		// quantity
		$this->quantity = new DbField('po_pending', 'po_pending', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Nullable = FALSE; // NOT NULL field
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// stock
		$this->stock = new DbField('po_pending', 'po_pending', 'x_stock', 'stock', '`stock`', '`stock`', 131, -1, FALSE, '`stock`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->stock->Sortable = TRUE; // Allow sort
		$this->stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['stock'] = &$this->stock;

		// despatch_date
		$this->despatch_date = new DbField('po_pending', 'po_pending', 'x_despatch_date', 'despatch_date', '`despatch_date`', CastDateFieldForLike('`despatch_date`', 0, "DB"), 133, 0, FALSE, '`despatch_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->despatch_date->Sortable = TRUE; // Allow sort
		$this->despatch_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['despatch_date'] = &$this->despatch_date;

		// grp
		$this->grp = new DbField('po_pending', 'po_pending', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_product","x_s_grp"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// product
		$this->product = new DbField('po_pending', 'po_pending', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', '_product_view', FALSE, 'id', ["product","","",""], ["x_grp"], [], ["grp"], ["x_grp"], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// partner_id
		$this->partner_id = new DbField('po_pending', 'po_pending', 'x_partner_id', 'partner_id', '`partner_id`', '`partner_id`', 19, -1, FALSE, '`partner_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->partner_id->Sortable = TRUE; // Allow sort
		$this->partner_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->partner_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->partner_id->Lookup = new Lookup('partner_id', 'buyer_seller_view', FALSE, 'id', ["name","mobile","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->partner_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['partner_id'] = &$this->partner_id;

		// avg_quantity
		$this->avg_quantity = new DbField('po_pending', 'po_pending', 'x_avg_quantity', 'avg_quantity', '`avg_quantity`', '`avg_quantity`', 5, -1, FALSE, '`avg_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->avg_quantity->Sortable = FALSE; // Allow sort
		$this->avg_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['avg_quantity'] = &$this->avg_quantity;

		// s_grp
		$this->s_grp = new DbField('po_pending', 'po_pending', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = FALSE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], [], ["grp"], ["x_grp"], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// packing_type
		$this->packing_type = new DbField('po_pending', 'po_pending', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 131, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packing_type->Sortable = FALSE; // Allow sort
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// m_out_id
		$this->m_out_id = new DbField('po_pending', 'po_pending', 'x_m_out_id', 'm_out_id', '`m_out_id`', '`m_out_id`', 201, -1, FALSE, '`m_out_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->m_out_id->Sortable = TRUE; // Allow sort
		$this->fields['m_out_id'] = &$this->m_out_id;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`po_pending`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('cart_id', $rs))
				AddFilter($where, QuotedName('cart_id', $this->Dbid) . '=' . QuotedValue($rs['cart_id'], $this->cart_id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->cart_id->DbValue = $row['cart_id'];
		$this->po_id->DbValue = $row['po_id'];
		$this->partner_order_no->DbValue = $row['partner_order_no'];
		$this->status->DbValue = $row['status'];
		$this->company_id->DbValue = $row['company_id'];
		$this->ref->DbValue = $row['ref'];
		$this->product_code->DbValue = $row['product_code'];
		$this->quantity->DbValue = $row['quantity'];
		$this->stock->DbValue = $row['stock'];
		$this->despatch_date->DbValue = $row['despatch_date'];
		$this->grp->DbValue = $row['grp'];
		$this->product->DbValue = $row['product'];
		$this->partner_id->DbValue = $row['partner_id'];
		$this->avg_quantity->DbValue = $row['avg_quantity'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->m_out_id->DbValue = $row['m_out_id'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`cart_id` = @cart_id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('cart_id', $row) ? $row['cart_id'] : NULL) : $this->cart_id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@cart_id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "po_pendinglist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "po_pendingview.php")
			return $Language->phrase("View");
		elseif ($pageName == "po_pendingedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "po_pendingadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "po_pendinglist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("po_pendingview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("po_pendingview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "po_pendingadd.php?" . $this->getUrlParm($parm);
		else
			$url = "po_pendingadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("po_pendingedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("po_pendingadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("po_pendingdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "cart_id:" . JsonEncode($this->cart_id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->cart_id->CurrentValue != NULL) {
			$url .= "cart_id=" . urlencode($this->cart_id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("cart_id") !== NULL)
				$arKeys[] = Param("cart_id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->cart_id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->cart_id->setDbValue($rs->fields('cart_id'));
		$this->po_id->setDbValue($rs->fields('po_id'));
		$this->partner_order_no->setDbValue($rs->fields('partner_order_no'));
		$this->status->setDbValue($rs->fields('status'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->ref->setDbValue($rs->fields('ref'));
		$this->product_code->setDbValue($rs->fields('product_code'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->stock->setDbValue($rs->fields('stock'));
		$this->despatch_date->setDbValue($rs->fields('despatch_date'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->partner_id->setDbValue($rs->fields('partner_id'));
		$this->avg_quantity->setDbValue($rs->fields('avg_quantity'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->m_out_id->setDbValue($rs->fields('m_out_id'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// cart_id
		// po_id
		// partner_order_no
		// status
		// company_id
		// ref
		// product_code
		// quantity
		// stock
		// despatch_date
		// grp
		// product
		// partner_id
		// avg_quantity

		$this->avg_quantity->CellCssStyle = "white-space: nowrap;";

		// s_grp
		$this->s_grp->CellCssStyle = "white-space: nowrap;";

		// packing_type
		$this->packing_type->CellCssStyle = "white-space: nowrap;";

		// m_out_id
		// cart_id

		$this->cart_id->ViewValue = $this->cart_id->CurrentValue;
		$this->cart_id->ViewCustomAttributes = "";

		// po_id
		$this->po_id->ViewValue = $this->po_id->CurrentValue;
		$this->po_id->ViewValue = FormatNumber($this->po_id->ViewValue, 0, -2, -2, -2);
		$this->po_id->ViewCustomAttributes = "";

		// partner_order_no
		$this->partner_order_no->ViewValue = $this->partner_order_no->CurrentValue;
		$this->partner_order_no->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// company_id
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`partner_type` = 2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// ref
		$this->ref->ViewValue = $this->ref->CurrentValue;
		$this->ref->ViewCustomAttributes = "";

		// product_code
		$this->product_code->ViewValue = $this->product_code->CurrentValue;
		$this->product_code->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// stock
		$this->stock->ViewValue = $this->stock->CurrentValue;
		$this->stock->ViewValue = FormatNumber($this->stock->ViewValue, 2, -2, -2, -2);
		$this->stock->ViewCustomAttributes = "";

		// despatch_date
		$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
		$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
		$this->despatch_date->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// partner_id
		$curVal = strval($this->partner_id->CurrentValue);
		if ($curVal <> "") {
			$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
			if ($this->partner_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`partner_type`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
				}
			}
		} else {
			$this->partner_id->ViewValue = NULL;
		}
		$this->partner_id->ViewCustomAttributes = "";

		// avg_quantity
		$this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->ViewValue = FormatNumber($this->avg_quantity->ViewValue, 2, -2, -2, -2);
		$this->avg_quantity->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// packing_type
		$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
		$this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, 0, -2, -2, -2);
		$this->packing_type->ViewCustomAttributes = "";

		// m_out_id
		$this->m_out_id->ViewValue = $this->m_out_id->CurrentValue;
		$this->m_out_id->ViewCustomAttributes = "";

		// cart_id
		$this->cart_id->LinkCustomAttributes = "";
		$this->cart_id->HrefValue = "";
		$this->cart_id->TooltipValue = "";

		// po_id
		$this->po_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->po_id->CurrentValue)) {
			$this->po_id->HrefValue = "po_pendinglist.php?x_po_id=" . $this->po_id->CurrentValue; // Add prefix/suffix
			$this->po_id->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->po_id->HrefValue = FullUrl($this->po_id->HrefValue, "href");
		} else {
			$this->po_id->HrefValue = "";
		}
		$this->po_id->TooltipValue = "";

		// partner_order_no
		$this->partner_order_no->LinkCustomAttributes = "";
		if (!EmptyValue($this->partner_order_no->CurrentValue)) {
			$this->partner_order_no->HrefValue = "payment_responselist.php?x_pg_order_number=" . $this->partner_order_no->CurrentValue; // Add prefix/suffix
			$this->partner_order_no->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->partner_order_no->HrefValue = FullUrl($this->partner_order_no->HrefValue, "href");
		} else {
			$this->partner_order_no->HrefValue = "";
		}
		$this->partner_order_no->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->company_id->CurrentValue)) {
			$this->company_id->HrefValue = "po_pendinglist.php?x_company_id=" . $this->company_id->CurrentValue; // Add prefix/suffix
			$this->company_id->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->company_id->HrefValue = FullUrl($this->company_id->HrefValue, "href");
		} else {
			$this->company_id->HrefValue = "";
		}
		$this->company_id->TooltipValue = "";

		// ref
		$this->ref->LinkCustomAttributes = "";
		$this->ref->HrefValue = "";
		$this->ref->TooltipValue = "";

		// product_code
		$this->product_code->LinkCustomAttributes = "";
		$this->product_code->HrefValue = "";
		$this->product_code->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// stock
		$this->stock->LinkCustomAttributes = "";
		$this->stock->HrefValue = "";
		$this->stock->TooltipValue = "";

		// despatch_date
		$this->despatch_date->LinkCustomAttributes = "";
		$this->despatch_date->HrefValue = "";
		$this->despatch_date->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->grp->CurrentValue)) {
			$this->grp->HrefValue = "po_pendinglist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
			$this->grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
		} else {
			$this->grp->HrefValue = "";
		}
		$this->grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "po_pendinglist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// partner_id
		$this->partner_id->LinkCustomAttributes = "";
		$this->partner_id->HrefValue = "";
		$this->partner_id->TooltipValue = "";

		// avg_quantity
		$this->avg_quantity->LinkCustomAttributes = "";
		$this->avg_quantity->HrefValue = "";
		$this->avg_quantity->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// m_out_id
		$this->m_out_id->LinkCustomAttributes = "";
		$this->m_out_id->HrefValue = "";
		$this->m_out_id->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// cart_id
		$this->cart_id->EditAttrs["class"] = "form-control";
		$this->cart_id->EditCustomAttributes = "";
		$this->cart_id->EditValue = $this->cart_id->CurrentValue;
		$this->cart_id->ViewCustomAttributes = "";

		// po_id
		$this->po_id->EditAttrs["class"] = "form-control";
		$this->po_id->EditCustomAttributes = "";
		$this->po_id->EditValue = $this->po_id->CurrentValue;
		$this->po_id->PlaceHolder = RemoveHtml($this->po_id->caption());

		// partner_order_no
		$this->partner_order_no->EditAttrs["class"] = "form-control";
		$this->partner_order_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->partner_order_no->CurrentValue = HtmlDecode($this->partner_order_no->CurrentValue);
		$this->partner_order_no->EditValue = $this->partner_order_no->CurrentValue;
		$this->partner_order_no->PlaceHolder = RemoveHtml($this->partner_order_no->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";

		// ref
		$this->ref->EditAttrs["class"] = "form-control";
		$this->ref->EditCustomAttributes = "";
		$this->ref->EditValue = $this->ref->CurrentValue;
		$this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

		// product_code
		$this->product_code->EditAttrs["class"] = "form-control";
		$this->product_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->product_code->CurrentValue = HtmlDecode($this->product_code->CurrentValue);
		$this->product_code->EditValue = $this->product_code->CurrentValue;
		$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

		// stock
		$this->stock->EditAttrs["class"] = "form-control";
		$this->stock->EditCustomAttributes = "";
		$this->stock->EditValue = $this->stock->CurrentValue;
		$this->stock->PlaceHolder = RemoveHtml($this->stock->caption());
		if (strval($this->stock->EditValue) <> "" && is_numeric($this->stock->EditValue))
			$this->stock->EditValue = FormatNumber($this->stock->EditValue, -2, -2, -2, -2);

		// despatch_date
		$this->despatch_date->EditAttrs["class"] = "form-control";
		$this->despatch_date->EditCustomAttributes = "";
		$this->despatch_date->EditValue = FormatDateTime($this->despatch_date->CurrentValue, 8);
		$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";

		// partner_id
		$this->partner_id->EditAttrs["class"] = "form-control";
		$this->partner_id->EditCustomAttributes = "";

		// avg_quantity
		$this->avg_quantity->EditAttrs["class"] = "form-control";
		$this->avg_quantity->EditCustomAttributes = "";
		$this->avg_quantity->EditValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->PlaceHolder = RemoveHtml($this->avg_quantity->caption());
		if (strval($this->avg_quantity->EditValue) <> "" && is_numeric($this->avg_quantity->EditValue))
			$this->avg_quantity->EditValue = FormatNumber($this->avg_quantity->EditValue, -2, -2, -2, -2);

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";
		$this->packing_type->EditValue = $this->packing_type->CurrentValue;
		$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());
		if (strval($this->packing_type->EditValue) <> "" && is_numeric($this->packing_type->EditValue))
			$this->packing_type->EditValue = FormatNumber($this->packing_type->EditValue, -2, -2, -2, -2);

		// m_out_id
		$this->m_out_id->EditAttrs["class"] = "form-control";
		$this->m_out_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->m_out_id->CurrentValue = HtmlDecode($this->m_out_id->CurrentValue);
		$this->m_out_id->EditValue = $this->m_out_id->CurrentValue;
		$this->m_out_id->PlaceHolder = RemoveHtml($this->m_out_id->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->cart_id);
					$doc->exportCaption($this->po_id);
					$doc->exportCaption($this->partner_order_no);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->stock);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->avg_quantity);
					$doc->exportCaption($this->m_out_id);
				} else {
					$doc->exportCaption($this->cart_id);
					$doc->exportCaption($this->po_id);
					$doc->exportCaption($this->partner_order_no);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->stock);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->m_out_id);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->cart_id);
						$doc->exportField($this->po_id);
						$doc->exportField($this->partner_order_no);
						$doc->exportField($this->status);
						$doc->exportField($this->company_id);
						$doc->exportField($this->ref);
						$doc->exportField($this->product_code);
						$doc->exportField($this->quantity);
						$doc->exportField($this->stock);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->grp);
						$doc->exportField($this->product);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->avg_quantity);
						$doc->exportField($this->m_out_id);
					} else {
						$doc->exportField($this->cart_id);
						$doc->exportField($this->po_id);
						$doc->exportField($this->partner_order_no);
						$doc->exportField($this->status);
						$doc->exportField($this->company_id);
						$doc->exportField($this->ref);
						$doc->exportField($this->product_code);
						$doc->exportField($this->quantity);
						$doc->exportField($this->stock);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->grp);
						$doc->exportField($this->product);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->m_out_id);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>