<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for po_pending_wbc_internal
 */
class po_pending_wbc_internal extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $po;
	public $pod;
	public $grp;
	public $s_grp;
	public $product;
	public $rid;
	public $product_code;
	public $packing_type;
	public $gcode;
	public $batch_no;
	public $process;
	public $cart_quantity;
	public $jc_quantity;
	public $pending_qty;
	public $despatch_week;
	public $despatch_date;
	public $jc_no;
	public $issue_to;
	public $pam_id;
	public $pam_qty;
	public $pp_qty;
	public $company_id;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'po_pending_wbc_internal';
		$this->TableName = 'po_pending_wbc_internal';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`po_pending_wbc_internal`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id
		$this->id = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->Nullable = FALSE; // NOT NULL field
		$this->id->Required = TRUE; // Required field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// po
		$this->po = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_po', 'po', '`po`', '`po`', 19, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Nullable = FALSE; // NOT NULL field
		$this->po->Required = TRUE; // Required field
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// pod
		$this->pod = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_pod', 'pod', '`pod`', '`pod`', 201, -1, FALSE, '`pod`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->pod->Nullable = FALSE; // NOT NULL field
		$this->pod->Required = TRUE; // Required field
		$this->pod->Sortable = TRUE; // Allow sort
		$this->fields['pod'] = &$this->pod;

		// grp
		$this->grp = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product->Nullable = FALSE; // NOT NULL field
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// rid
		$this->rid = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_rid', 'rid', '`rid`', '`rid`', 2, -1, FALSE, '`rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// product_code
		$this->product_code = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_product_code', 'product_code', '`product_code`', '`product_code`', 201, -1, FALSE, '`product_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->product_code->Sortable = TRUE; // Allow sort
		$this->fields['product_code'] = &$this->product_code;

		// packing_type
		$this->packing_type = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 3, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packing_type->Nullable = FALSE; // NOT NULL field
		$this->packing_type->Required = TRUE; // Required field
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// gcode
		$this->gcode = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_gcode', 'gcode', '`gcode`', '`gcode`', 201, -1, FALSE, '`gcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->gcode->Nullable = FALSE; // NOT NULL field
		$this->gcode->Required = TRUE; // Required field
		$this->gcode->Sortable = TRUE; // Allow sort
		$this->fields['gcode'] = &$this->gcode;

		// batch_no
		$this->batch_no = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 3, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->batch_no->Nullable = FALSE; // NOT NULL field
		$this->batch_no->Required = TRUE; // Required field
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_no'] = &$this->batch_no;

		// process
		$this->process = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_process', 'process', '`process`', '`process`', 200, -1, FALSE, '`process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->process->Sortable = TRUE; // Allow sort
		$this->fields['process'] = &$this->process;

		// cart_quantity
		$this->cart_quantity = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_cart_quantity', 'cart_quantity', '`cart_quantity`', '`cart_quantity`', 131, -1, FALSE, '`cart_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cart_quantity->Sortable = TRUE; // Allow sort
		$this->cart_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cart_quantity'] = &$this->cart_quantity;

		// jc_quantity
		$this->jc_quantity = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_jc_quantity', 'jc_quantity', '`jc_quantity`', '`jc_quantity`', 3, -1, FALSE, '`jc_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_quantity->Nullable = FALSE; // NOT NULL field
		$this->jc_quantity->Required = TRUE; // Required field
		$this->jc_quantity->Sortable = TRUE; // Allow sort
		$this->jc_quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_quantity'] = &$this->jc_quantity;

		// pending_qty
		$this->pending_qty = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_pending_qty', 'pending_qty', '`pending_qty`', '`pending_qty`', 3, -1, FALSE, '`pending_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pending_qty->Nullable = FALSE; // NOT NULL field
		$this->pending_qty->Required = TRUE; // Required field
		$this->pending_qty->Sortable = TRUE; // Allow sort
		$this->pending_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pending_qty'] = &$this->pending_qty;

		// despatch_week
		$this->despatch_week = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_despatch_week', 'despatch_week', '`despatch_week`', '`despatch_week`', 3, -1, FALSE, '`despatch_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->despatch_week->Nullable = FALSE; // NOT NULL field
		$this->despatch_week->Required = TRUE; // Required field
		$this->despatch_week->Sortable = TRUE; // Allow sort
		$this->despatch_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['despatch_week'] = &$this->despatch_week;

		// despatch_date
		$this->despatch_date = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_despatch_date', 'despatch_date', '`despatch_date`', CastDateFieldForLike('`despatch_date`', 0, "DB"), 133, 0, FALSE, '`despatch_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->despatch_date->Sortable = TRUE; // Allow sort
		$this->despatch_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['despatch_date'] = &$this->despatch_date;

		// jc_no
		$this->jc_no = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_jc_no', 'jc_no', '`jc_no`', '`jc_no`', 200, -1, FALSE, '`jc_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_no->Nullable = FALSE; // NOT NULL field
		$this->jc_no->Required = TRUE; // Required field
		$this->jc_no->Sortable = TRUE; // Allow sort
		$this->fields['jc_no'] = &$this->jc_no;

		// issue_to
		$this->issue_to = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_issue_to', 'issue_to', '`issue_to`', '`issue_to`', 19, -1, FALSE, '`issue_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->issue_to->Sortable = TRUE; // Allow sort
		$this->issue_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['issue_to'] = &$this->issue_to;

		// pam_id
		$this->pam_id = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_pam_id', 'pam_id', '`pam_id`', '`pam_id`', 201, -1, FALSE, '`pam_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->pam_id->Sortable = TRUE; // Allow sort
		$this->fields['pam_id'] = &$this->pam_id;

		// pam_qty
		$this->pam_qty = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_pam_qty', 'pam_qty', '`pam_qty`', '`pam_qty`', 131, -1, FALSE, '`pam_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pam_qty->Sortable = TRUE; // Allow sort
		$this->pam_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['pam_qty'] = &$this->pam_qty;

		// pp_qty
		$this->pp_qty = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_pp_qty', 'pp_qty', '`pp_qty`', '`pp_qty`', 131, -1, FALSE, '`pp_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pp_qty->Nullable = FALSE; // NOT NULL field
		$this->pp_qty->Required = TRUE; // Required field
		$this->pp_qty->Sortable = TRUE; // Allow sort
		$this->pp_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['pp_qty'] = &$this->pp_qty;

		// company_id
		$this->company_id = new DbField('po_pending_wbc_internal', 'po_pending_wbc_internal', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 3, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`po_pending_wbc_internal`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->po->DbValue = $row['po'];
		$this->pod->DbValue = $row['pod'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->rid->DbValue = $row['rid'];
		$this->product_code->DbValue = $row['product_code'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->gcode->DbValue = $row['gcode'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->process->DbValue = $row['process'];
		$this->cart_quantity->DbValue = $row['cart_quantity'];
		$this->jc_quantity->DbValue = $row['jc_quantity'];
		$this->pending_qty->DbValue = $row['pending_qty'];
		$this->despatch_week->DbValue = $row['despatch_week'];
		$this->despatch_date->DbValue = $row['despatch_date'];
		$this->jc_no->DbValue = $row['jc_no'];
		$this->issue_to->DbValue = $row['issue_to'];
		$this->pam_id->DbValue = $row['pam_id'];
		$this->pam_qty->DbValue = $row['pam_qty'];
		$this->pp_qty->DbValue = $row['pp_qty'];
		$this->company_id->DbValue = $row['company_id'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "po_pending_wbc_internallist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "po_pending_wbc_internalview.php")
			return $Language->phrase("View");
		elseif ($pageName == "po_pending_wbc_internaledit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "po_pending_wbc_internaladd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "po_pending_wbc_internallist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("po_pending_wbc_internalview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("po_pending_wbc_internalview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "po_pending_wbc_internaladd.php?" . $this->getUrlParm($parm);
		else
			$url = "po_pending_wbc_internaladd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("po_pending_wbc_internaledit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("po_pending_wbc_internaladd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("po_pending_wbc_internaldelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->po->setDbValue($rs->fields('po'));
		$this->pod->setDbValue($rs->fields('pod'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->product_code->setDbValue($rs->fields('product_code'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->gcode->setDbValue($rs->fields('gcode'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->process->setDbValue($rs->fields('process'));
		$this->cart_quantity->setDbValue($rs->fields('cart_quantity'));
		$this->jc_quantity->setDbValue($rs->fields('jc_quantity'));
		$this->pending_qty->setDbValue($rs->fields('pending_qty'));
		$this->despatch_week->setDbValue($rs->fields('despatch_week'));
		$this->despatch_date->setDbValue($rs->fields('despatch_date'));
		$this->jc_no->setDbValue($rs->fields('jc_no'));
		$this->issue_to->setDbValue($rs->fields('issue_to'));
		$this->pam_id->setDbValue($rs->fields('pam_id'));
		$this->pam_qty->setDbValue($rs->fields('pam_qty'));
		$this->pp_qty->setDbValue($rs->fields('pp_qty'));
		$this->company_id->setDbValue($rs->fields('company_id'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// po
		// pod
		// grp
		// s_grp
		// product
		// rid
		// product_code
		// packing_type
		// gcode
		// batch_no
		// process
		// cart_quantity
		// jc_quantity
		// pending_qty
		// despatch_week
		// despatch_date
		// jc_no
		// issue_to
		// pam_id
		// pam_qty
		// pp_qty
		// company_id
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// pod
		$this->pod->ViewValue = $this->pod->CurrentValue;
		$this->pod->ViewCustomAttributes = "";

		// grp
		$this->grp->ViewValue = $this->grp->CurrentValue;
		$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
		$this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, 0, -2, -2, -2);
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$this->product->ViewValue = $this->product->CurrentValue;
		$this->product->ViewValue = FormatNumber($this->product->ViewValue, 0, -2, -2, -2);
		$this->product->ViewCustomAttributes = "";

		// rid
		$this->rid->ViewValue = $this->rid->CurrentValue;
		$this->rid->ViewValue = FormatNumber($this->rid->ViewValue, 0, -2, -2, -2);
		$this->rid->ViewCustomAttributes = "";

		// product_code
		$this->product_code->ViewValue = $this->product_code->CurrentValue;
		$this->product_code->ViewCustomAttributes = "";

		// packing_type
		$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
		$this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, 0, -2, -2, -2);
		$this->packing_type->ViewCustomAttributes = "";

		// gcode
		$this->gcode->ViewValue = $this->gcode->CurrentValue;
		$this->gcode->ViewCustomAttributes = "";

		// batch_no
		$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
		$this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, 0, -2, -2, -2);
		$this->batch_no->ViewCustomAttributes = "";

		// process
		$this->process->ViewValue = $this->process->CurrentValue;
		$this->process->ViewCustomAttributes = "";

		// cart_quantity
		$this->cart_quantity->ViewValue = $this->cart_quantity->CurrentValue;
		$this->cart_quantity->ViewValue = FormatNumber($this->cart_quantity->ViewValue, 2, -2, -2, -2);
		$this->cart_quantity->ViewCustomAttributes = "";

		// jc_quantity
		$this->jc_quantity->ViewValue = $this->jc_quantity->CurrentValue;
		$this->jc_quantity->ViewValue = FormatNumber($this->jc_quantity->ViewValue, 0, -2, -2, -2);
		$this->jc_quantity->ViewCustomAttributes = "";

		// pending_qty
		$this->pending_qty->ViewValue = $this->pending_qty->CurrentValue;
		$this->pending_qty->ViewValue = FormatNumber($this->pending_qty->ViewValue, 0, -2, -2, -2);
		$this->pending_qty->ViewCustomAttributes = "";

		// despatch_week
		$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
		$this->despatch_week->ViewValue = FormatNumber($this->despatch_week->ViewValue, 0, -2, -2, -2);
		$this->despatch_week->ViewCustomAttributes = "";

		// despatch_date
		$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
		$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
		$this->despatch_date->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
		$this->jc_no->ViewCustomAttributes = "";

		// issue_to
		$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
		$this->issue_to->ViewValue = FormatNumber($this->issue_to->ViewValue, 0, -2, -2, -2);
		$this->issue_to->ViewCustomAttributes = "";

		// pam_id
		$this->pam_id->ViewValue = $this->pam_id->CurrentValue;
		$this->pam_id->ViewCustomAttributes = "";

		// pam_qty
		$this->pam_qty->ViewValue = $this->pam_qty->CurrentValue;
		$this->pam_qty->ViewValue = FormatNumber($this->pam_qty->ViewValue, 2, -2, -2, -2);
		$this->pam_qty->ViewCustomAttributes = "";

		// pp_qty
		$this->pp_qty->ViewValue = $this->pp_qty->CurrentValue;
		$this->pp_qty->ViewValue = FormatNumber($this->pp_qty->ViewValue, 2, -2, -2, -2);
		$this->pp_qty->ViewCustomAttributes = "";

		// company_id
		$this->company_id->ViewValue = $this->company_id->CurrentValue;
		$this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, 0, -2, -2, -2);
		$this->company_id->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// pod
		$this->pod->LinkCustomAttributes = "";
		$this->pod->HrefValue = "";
		$this->pod->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		$this->product->HrefValue = "";
		$this->product->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		$this->rid->HrefValue = "";
		$this->rid->TooltipValue = "";

		// product_code
		$this->product_code->LinkCustomAttributes = "";
		$this->product_code->HrefValue = "";
		$this->product_code->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// gcode
		$this->gcode->LinkCustomAttributes = "";
		$this->gcode->HrefValue = "";
		$this->gcode->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		$this->batch_no->HrefValue = "";
		$this->batch_no->TooltipValue = "";

		// process
		$this->process->LinkCustomAttributes = "";
		$this->process->HrefValue = "";
		$this->process->TooltipValue = "";

		// cart_quantity
		$this->cart_quantity->LinkCustomAttributes = "";
		$this->cart_quantity->HrefValue = "";
		$this->cart_quantity->TooltipValue = "";

		// jc_quantity
		$this->jc_quantity->LinkCustomAttributes = "";
		$this->jc_quantity->HrefValue = "";
		$this->jc_quantity->TooltipValue = "";

		// pending_qty
		$this->pending_qty->LinkCustomAttributes = "";
		$this->pending_qty->HrefValue = "";
		$this->pending_qty->TooltipValue = "";

		// despatch_week
		$this->despatch_week->LinkCustomAttributes = "";
		$this->despatch_week->HrefValue = "";
		$this->despatch_week->TooltipValue = "";

		// despatch_date
		$this->despatch_date->LinkCustomAttributes = "";
		$this->despatch_date->HrefValue = "";
		$this->despatch_date->TooltipValue = "";

		// jc_no
		$this->jc_no->LinkCustomAttributes = "";
		$this->jc_no->HrefValue = "";
		$this->jc_no->TooltipValue = "";

		// issue_to
		$this->issue_to->LinkCustomAttributes = "";
		$this->issue_to->HrefValue = "";
		$this->issue_to->TooltipValue = "";

		// pam_id
		$this->pam_id->LinkCustomAttributes = "";
		$this->pam_id->HrefValue = "";
		$this->pam_id->TooltipValue = "";

		// pam_qty
		$this->pam_qty->LinkCustomAttributes = "";
		$this->pam_qty->HrefValue = "";
		$this->pam_qty->TooltipValue = "";

		// pp_qty
		$this->pp_qty->LinkCustomAttributes = "";
		$this->pp_qty->HrefValue = "";
		$this->pp_qty->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->PlaceHolder = RemoveHtml($this->id->caption());

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->PlaceHolder = RemoveHtml($this->po->caption());

		// pod
		$this->pod->EditAttrs["class"] = "form-control";
		$this->pod->EditCustomAttributes = "";
		$this->pod->EditValue = $this->pod->CurrentValue;
		$this->pod->PlaceHolder = RemoveHtml($this->pod->caption());

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$this->grp->EditValue = $this->grp->CurrentValue;
		$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		$this->s_grp->EditValue = $this->s_grp->CurrentValue;
		$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		$this->product->EditValue = $this->product->CurrentValue;
		$this->product->PlaceHolder = RemoveHtml($this->product->caption());

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		$this->rid->EditValue = $this->rid->CurrentValue;
		$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

		// product_code
		$this->product_code->EditAttrs["class"] = "form-control";
		$this->product_code->EditCustomAttributes = "";
		$this->product_code->EditValue = $this->product_code->CurrentValue;
		$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";
		$this->packing_type->EditValue = $this->packing_type->CurrentValue;
		$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

		// gcode
		$this->gcode->EditAttrs["class"] = "form-control";
		$this->gcode->EditCustomAttributes = "";
		$this->gcode->EditValue = $this->gcode->CurrentValue;
		$this->gcode->PlaceHolder = RemoveHtml($this->gcode->caption());

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";
		$this->batch_no->EditValue = $this->batch_no->CurrentValue;
		$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

		// process
		$this->process->EditAttrs["class"] = "form-control";
		$this->process->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->process->CurrentValue = HtmlDecode($this->process->CurrentValue);
		$this->process->EditValue = $this->process->CurrentValue;
		$this->process->PlaceHolder = RemoveHtml($this->process->caption());

		// cart_quantity
		$this->cart_quantity->EditAttrs["class"] = "form-control";
		$this->cart_quantity->EditCustomAttributes = "";
		$this->cart_quantity->EditValue = $this->cart_quantity->CurrentValue;
		$this->cart_quantity->PlaceHolder = RemoveHtml($this->cart_quantity->caption());
		if (strval($this->cart_quantity->EditValue) <> "" && is_numeric($this->cart_quantity->EditValue))
			$this->cart_quantity->EditValue = FormatNumber($this->cart_quantity->EditValue, -2, -2, -2, -2);

		// jc_quantity
		$this->jc_quantity->EditAttrs["class"] = "form-control";
		$this->jc_quantity->EditCustomAttributes = "";
		$this->jc_quantity->EditValue = $this->jc_quantity->CurrentValue;
		$this->jc_quantity->PlaceHolder = RemoveHtml($this->jc_quantity->caption());

		// pending_qty
		$this->pending_qty->EditAttrs["class"] = "form-control";
		$this->pending_qty->EditCustomAttributes = "";
		$this->pending_qty->EditValue = $this->pending_qty->CurrentValue;
		$this->pending_qty->PlaceHolder = RemoveHtml($this->pending_qty->caption());

		// despatch_week
		$this->despatch_week->EditAttrs["class"] = "form-control";
		$this->despatch_week->EditCustomAttributes = "";
		$this->despatch_week->EditValue = $this->despatch_week->CurrentValue;
		$this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

		// despatch_date
		$this->despatch_date->EditAttrs["class"] = "form-control";
		$this->despatch_date->EditCustomAttributes = "";
		$this->despatch_date->EditValue = FormatDateTime($this->despatch_date->CurrentValue, 8);
		$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

		// jc_no
		$this->jc_no->EditAttrs["class"] = "form-control";
		$this->jc_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->jc_no->CurrentValue = HtmlDecode($this->jc_no->CurrentValue);
		$this->jc_no->EditValue = $this->jc_no->CurrentValue;
		$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

		// issue_to
		$this->issue_to->EditAttrs["class"] = "form-control";
		$this->issue_to->EditCustomAttributes = "";
		$this->issue_to->EditValue = $this->issue_to->CurrentValue;
		$this->issue_to->PlaceHolder = RemoveHtml($this->issue_to->caption());

		// pam_id
		$this->pam_id->EditAttrs["class"] = "form-control";
		$this->pam_id->EditCustomAttributes = "";
		$this->pam_id->EditValue = $this->pam_id->CurrentValue;
		$this->pam_id->PlaceHolder = RemoveHtml($this->pam_id->caption());

		// pam_qty
		$this->pam_qty->EditAttrs["class"] = "form-control";
		$this->pam_qty->EditCustomAttributes = "";
		$this->pam_qty->EditValue = $this->pam_qty->CurrentValue;
		$this->pam_qty->PlaceHolder = RemoveHtml($this->pam_qty->caption());
		if (strval($this->pam_qty->EditValue) <> "" && is_numeric($this->pam_qty->EditValue))
			$this->pam_qty->EditValue = FormatNumber($this->pam_qty->EditValue, -2, -2, -2, -2);

		// pp_qty
		$this->pp_qty->EditAttrs["class"] = "form-control";
		$this->pp_qty->EditCustomAttributes = "";
		$this->pp_qty->EditValue = $this->pp_qty->CurrentValue;
		$this->pp_qty->PlaceHolder = RemoveHtml($this->pp_qty->caption());
		if (strval($this->pp_qty->EditValue) <> "" && is_numeric($this->pp_qty->EditValue))
			$this->pp_qty->EditValue = FormatNumber($this->pp_qty->EditValue, -2, -2, -2, -2);

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";
		$this->company_id->EditValue = $this->company_id->CurrentValue;
		$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->pod);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->gcode);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->cart_quantity);
					$doc->exportCaption($this->jc_quantity);
					$doc->exportCaption($this->pending_qty);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->pam_id);
					$doc->exportCaption($this->pam_qty);
					$doc->exportCaption($this->pp_qty);
					$doc->exportCaption($this->company_id);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->cart_quantity);
					$doc->exportCaption($this->jc_quantity);
					$doc->exportCaption($this->pending_qty);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->pam_qty);
					$doc->exportCaption($this->pp_qty);
					$doc->exportCaption($this->company_id);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->po);
						$doc->exportField($this->pod);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->product_code);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->gcode);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->process);
						$doc->exportField($this->cart_quantity);
						$doc->exportField($this->jc_quantity);
						$doc->exportField($this->pending_qty);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->pam_id);
						$doc->exportField($this->pam_qty);
						$doc->exportField($this->pp_qty);
						$doc->exportField($this->company_id);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->po);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->process);
						$doc->exportField($this->cart_quantity);
						$doc->exportField($this->jc_quantity);
						$doc->exportField($this->pending_qty);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->pam_qty);
						$doc->exportField($this->pp_qty);
						$doc->exportField($this->company_id);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>