<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class po_pending_wbc_search extends po_pending_wbc
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'po_pending_wbc';

	// Page object name
	public $PageObjName = "po_pending_wbc_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (po_pending_wbc)
		if (!isset($GLOBALS["po_pending_wbc"]) || get_class($GLOBALS["po_pending_wbc"]) == PROJECT_NAMESPACE . "po_pending_wbc") {
			$GLOBALS["po_pending_wbc"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["po_pending_wbc"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_pending_wbc');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $po_pending_wbc;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($po_pending_wbc);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "po_pending_wbcview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("po_pending_wbclist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->po->setVisibility();
		$this->pod->setVisibility();
		$this->jc_no->setVisibility();
		$this->gcode->Visible = FALSE;
		$this->product_code->setVisibility();
		$this->batch_no->setVisibility();
		$this->cart_quantity->setVisibility();
		$this->pam_qty->setVisibility();
		$this->pending_qty->setVisibility();
		$this->despatch_week->setVisibility();
		$this->s_grp->Visible = FALSE;
		$this->rid->Visible = FALSE;
		$this->despatch_date->Visible = FALSE;
		$this->packing_type->setVisibility();
		$this->grp->Visible = FALSE;
		$this->product->Visible = FALSE;
		$this->process->setVisibility();
		$this->pam_id->setVisibility();
		$this->issue_to->setVisibility();
		$this->pp_qty->setVisibility();
		$this->company_id->setVisibility();
		$this->jc_quantity->setVisibility();
		$this->status->setVisibility();
		$this->level->setVisibility();
		$this->buyer_id->setVisibility();
		$this->balance->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->cart_quantity);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->issue_to);
		$this->setupLookupOptions($this->company_id);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "po_pending_wbclist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->po); // po
		$this->buildSearchUrl($srchUrl, $this->pod); // pod
		$this->buildSearchUrl($srchUrl, $this->jc_no); // jc_no
		$this->buildSearchUrl($srchUrl, $this->product_code); // product_code
		$this->buildSearchUrl($srchUrl, $this->batch_no); // batch_no
		$this->buildSearchUrl($srchUrl, $this->cart_quantity); // cart_quantity
		$this->buildSearchUrl($srchUrl, $this->pam_qty); // pam_qty
		$this->buildSearchUrl($srchUrl, $this->pending_qty); // pending_qty
		$this->buildSearchUrl($srchUrl, $this->despatch_week); // despatch_week
		$this->buildSearchUrl($srchUrl, $this->packing_type); // packing_type
		$this->buildSearchUrl($srchUrl, $this->process); // process
		$this->buildSearchUrl($srchUrl, $this->pam_id); // pam_id
		$this->buildSearchUrl($srchUrl, $this->issue_to); // issue_to
		$this->buildSearchUrl($srchUrl, $this->pp_qty); // pp_qty
		$this->buildSearchUrl($srchUrl, $this->company_id); // company_id
		$this->buildSearchUrl($srchUrl, $this->jc_quantity); // jc_quantity
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->level); // level
		$this->buildSearchUrl($srchUrl, $this->buyer_id); // buyer_id
		$this->buildSearchUrl($srchUrl, $this->balance); // balance
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po"));
		$this->po->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po"));

		// pod
		if (!$this->isAddOrEdit())
			$this->pod->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pod"));
		$this->pod->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pod"));

		// jc_no
		if (!$this->isAddOrEdit())
			$this->jc_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_no"));
		$this->jc_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_no"));

		// product_code
		if (!$this->isAddOrEdit())
			$this->product_code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_code"));
		$this->product_code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_code"));

		// batch_no
		if (!$this->isAddOrEdit())
			$this->batch_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_batch_no"));
		$this->batch_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_batch_no"));

		// cart_quantity
		if (!$this->isAddOrEdit())
			$this->cart_quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cart_quantity"));
		$this->cart_quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cart_quantity"));

		// pam_qty
		if (!$this->isAddOrEdit())
			$this->pam_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pam_qty"));
		$this->pam_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pam_qty"));

		// pending_qty
		if (!$this->isAddOrEdit())
			$this->pending_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pending_qty"));
		$this->pending_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pending_qty"));

		// despatch_week
		if (!$this->isAddOrEdit())
			$this->despatch_week->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_despatch_week"));
		$this->despatch_week->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_despatch_week"));

		// packing_type
		if (!$this->isAddOrEdit())
			$this->packing_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_packing_type"));
		$this->packing_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_packing_type"));

		// process
		if (!$this->isAddOrEdit())
			$this->process->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process"));
		$this->process->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process"));

		// pam_id
		if (!$this->isAddOrEdit())
			$this->pam_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pam_id"));
		$this->pam_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pam_id"));

		// issue_to
		if (!$this->isAddOrEdit())
			$this->issue_to->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_issue_to"));
		$this->issue_to->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_issue_to"));

		// pp_qty
		if (!$this->isAddOrEdit())
			$this->pp_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pp_qty"));
		$this->pp_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pp_qty"));

		// company_id
		if (!$this->isAddOrEdit())
			$this->company_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_company_id"));
		$this->company_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_company_id"));

		// jc_quantity
		if (!$this->isAddOrEdit())
			$this->jc_quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_quantity"));
		$this->jc_quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_quantity"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// level
		if (!$this->isAddOrEdit())
			$this->level->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_level"));
		$this->level->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_level"));

		// buyer_id
		if (!$this->isAddOrEdit())
			$this->buyer_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_id"));
		$this->buyer_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_id"));

		// balance
		if (!$this->isAddOrEdit())
			$this->balance->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_balance"));
		$this->balance->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_balance"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->pam_qty->FormValue == $this->pam_qty->CurrentValue && is_numeric(ConvertToFloatString($this->pam_qty->CurrentValue)))
			$this->pam_qty->CurrentValue = ConvertToFloatString($this->pam_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pending_qty->FormValue == $this->pending_qty->CurrentValue && is_numeric(ConvertToFloatString($this->pending_qty->CurrentValue)))
			$this->pending_qty->CurrentValue = ConvertToFloatString($this->pending_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pp_qty->FormValue == $this->pp_qty->CurrentValue && is_numeric(ConvertToFloatString($this->pp_qty->CurrentValue)))
			$this->pp_qty->CurrentValue = ConvertToFloatString($this->pp_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->jc_quantity->FormValue == $this->jc_quantity->CurrentValue && is_numeric(ConvertToFloatString($this->jc_quantity->CurrentValue)))
			$this->jc_quantity->CurrentValue = ConvertToFloatString($this->jc_quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->balance->FormValue == $this->balance->CurrentValue && is_numeric(ConvertToFloatString($this->balance->CurrentValue)))
			$this->balance->CurrentValue = ConvertToFloatString($this->balance->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// po
		// pod
		// jc_no
		// gcode
		// product_code
		// batch_no
		// cart_quantity
		// pam_qty
		// pending_qty
		// despatch_week
		// s_grp
		// rid
		// despatch_date
		// packing_type
		// grp
		// product
		// process
		// pam_id
		// issue_to
		// pp_qty
		// company_id
		// jc_quantity
		// status
		// level
		// buyer_id
		// balance

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// pod
			$this->pod->ViewValue = $this->pod->CurrentValue;
			$this->pod->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewCustomAttributes = "";

			// product_code
			$this->product_code->ViewValue = $this->product_code->CurrentValue;
			$this->product_code->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
			$this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, 0, -2, -2, -2);
			$this->batch_no->ViewCustomAttributes = "";

			// cart_quantity
			$curVal = strval($this->cart_quantity->CurrentValue);
			if ($curVal <> "") {
				$this->cart_quantity->ViewValue = $this->cart_quantity->lookupCacheOption($curVal);
				if ($this->cart_quantity->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`quantity`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->cart_quantity->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 3, -2, -2, -2);
						$this->cart_quantity->ViewValue = $this->cart_quantity->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->cart_quantity->ViewValue = $this->cart_quantity->CurrentValue;
					}
				}
			} else {
				$this->cart_quantity->ViewValue = NULL;
			}
			$this->cart_quantity->ViewCustomAttributes = "";

			// pam_qty
			$this->pam_qty->ViewValue = $this->pam_qty->CurrentValue;
			$this->pam_qty->ViewValue = FormatNumber($this->pam_qty->ViewValue, 2, -2, -2, -2);
			$this->pam_qty->ViewCustomAttributes = "";

			// pending_qty
			$this->pending_qty->ViewValue = $this->pending_qty->CurrentValue;
			$this->pending_qty->ViewValue = FormatNumber($this->pending_qty->ViewValue, 2, -2, -2, -2);
			$this->pending_qty->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// pam_id
			$this->pam_id->ViewValue = $this->pam_id->CurrentValue;
			$this->pam_id->ViewCustomAttributes = "";

			// issue_to
			$curVal = strval($this->issue_to->CurrentValue);
			if ($curVal <> "") {
				$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
				if ($this->issue_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category`=999";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
					}
				}
			} else {
				$this->issue_to->ViewValue = NULL;
			}
			$this->issue_to->ViewCustomAttributes = "";

			// pp_qty
			$this->pp_qty->ViewValue = $this->pp_qty->CurrentValue;
			$this->pp_qty->ViewValue = FormatNumber($this->pp_qty->ViewValue, 2, -2, -2, -2);
			$this->pp_qty->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// jc_quantity
			$this->jc_quantity->ViewValue = $this->jc_quantity->CurrentValue;
			$this->jc_quantity->ViewValue = FormatNumber($this->jc_quantity->ViewValue, 2, -2, -2, -2);
			$this->jc_quantity->ViewCustomAttributes = "";

			// status
			$this->status->ViewValue = $this->status->CurrentValue;
			$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
			$this->status->ViewCustomAttributes = "";

			// level
			$this->level->ViewValue = $this->level->CurrentValue;
			$this->level->ViewValue = FormatNumber($this->level->ViewValue, 0, -2, -2, -2);
			$this->level->ViewCustomAttributes = "";

			// buyer_id
			$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
			$this->buyer_id->ViewValue = FormatNumber($this->buyer_id->ViewValue, 0, -2, -2, -2);
			$this->buyer_id->ViewCustomAttributes = "";

			// balance
			$this->balance->ViewValue = $this->balance->CurrentValue;
			$this->balance->ViewValue = FormatNumber($this->balance->ViewValue, 2, -2, -2, -2);
			$this->balance->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// pod
			$this->pod->LinkCustomAttributes = "";
			$this->pod->HrefValue = "";
			$this->pod->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			$this->product_code->HrefValue = "";
			$this->product_code->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// cart_quantity
			$this->cart_quantity->LinkCustomAttributes = "";
			$this->cart_quantity->HrefValue = "";
			$this->cart_quantity->TooltipValue = "";

			// pam_qty
			$this->pam_qty->LinkCustomAttributes = "";
			$this->pam_qty->HrefValue = "";
			$this->pam_qty->TooltipValue = "";

			// pending_qty
			$this->pending_qty->LinkCustomAttributes = "";
			$this->pending_qty->HrefValue = "";
			$this->pending_qty->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";
			$this->process->TooltipValue = "";

			// pam_id
			$this->pam_id->LinkCustomAttributes = "";
			$this->pam_id->HrefValue = "";
			$this->pam_id->TooltipValue = "";

			// issue_to
			$this->issue_to->LinkCustomAttributes = "";
			$this->issue_to->HrefValue = "";
			$this->issue_to->TooltipValue = "";

			// pp_qty
			$this->pp_qty->LinkCustomAttributes = "";
			$this->pp_qty->HrefValue = "";
			$this->pp_qty->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// jc_quantity
			$this->jc_quantity->LinkCustomAttributes = "";
			$this->jc_quantity->HrefValue = "";
			$this->jc_quantity->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// level
			$this->level->LinkCustomAttributes = "";
			$this->level->HrefValue = "";
			$this->level->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// balance
			$this->balance->LinkCustomAttributes = "";
			$this->balance->HrefValue = "";
			$this->balance->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// pod
			$this->pod->EditAttrs["class"] = "form-control";
			$this->pod->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pod->AdvancedSearch->SearchValue = HtmlDecode($this->pod->AdvancedSearch->SearchValue);
			$this->pod->EditValue = HtmlEncode($this->pod->AdvancedSearch->SearchValue);
			$this->pod->PlaceHolder = RemoveHtml($this->pod->caption());

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_no->AdvancedSearch->SearchValue = HtmlDecode($this->jc_no->AdvancedSearch->SearchValue);
			$this->jc_no->EditValue = HtmlEncode($this->jc_no->AdvancedSearch->SearchValue);
			$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

			// product_code
			$this->product_code->EditAttrs["class"] = "form-control";
			$this->product_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->product_code->AdvancedSearch->SearchValue = HtmlDecode($this->product_code->AdvancedSearch->SearchValue);
			$this->product_code->EditValue = HtmlEncode($this->product_code->AdvancedSearch->SearchValue);
			$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$this->batch_no->EditValue = HtmlEncode($this->batch_no->AdvancedSearch->SearchValue);
			$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

			// cart_quantity
			$this->cart_quantity->EditAttrs["class"] = "form-control";
			$this->cart_quantity->EditCustomAttributes = "";
			$curVal = trim(strval($this->cart_quantity->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->cart_quantity->AdvancedSearch->ViewValue = $this->cart_quantity->lookupCacheOption($curVal);
			else
				$this->cart_quantity->AdvancedSearch->ViewValue = $this->cart_quantity->Lookup !== NULL && is_array($this->cart_quantity->Lookup->Options) ? $curVal : NULL;
			if ($this->cart_quantity->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->cart_quantity->EditValue = array_values($this->cart_quantity->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`quantity`" . SearchString("=", $this->cart_quantity->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->cart_quantity->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 3, -2, -2, -2);
				}
				$this->cart_quantity->EditValue = $arwrk;
			}

			// pam_qty
			$this->pam_qty->EditAttrs["class"] = "form-control";
			$this->pam_qty->EditCustomAttributes = "";
			$this->pam_qty->EditValue = HtmlEncode($this->pam_qty->AdvancedSearch->SearchValue);
			$this->pam_qty->PlaceHolder = RemoveHtml($this->pam_qty->caption());

			// pending_qty
			$this->pending_qty->EditAttrs["class"] = "form-control";
			$this->pending_qty->EditCustomAttributes = "";
			$this->pending_qty->EditValue = HtmlEncode($this->pending_qty->AdvancedSearch->SearchValue);
			$this->pending_qty->PlaceHolder = RemoveHtml($this->pending_qty->caption());

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$curVal = trim(strval($this->despatch_week->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			else
				$this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->Lookup !== NULL && is_array($this->despatch_week->Lookup->Options) ? $curVal : NULL;
			if ($this->despatch_week->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->despatch_week->EditValue = array_values($this->despatch_week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->despatch_week->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->despatch_week->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->despatch_week->EditValue = $arwrk;
			}

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_type->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			else
				$this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->Lookup !== NULL && is_array($this->packing_type->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_type->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->packing_type->EditValue = array_values($this->packing_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->packing_type->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->packing_type->EditValue = $arwrk;
			}

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			$curVal = trim(strval($this->process->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->process->AdvancedSearch->ViewValue = $this->process->lookupCacheOption($curVal);
			else
				$this->process->AdvancedSearch->ViewValue = $this->process->Lookup !== NULL && is_array($this->process->Lookup->Options) ? $curVal : NULL;
			if ($this->process->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->process->EditValue = array_values($this->process->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->process->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process->EditValue = $arwrk;
			}

			// pam_id
			$this->pam_id->EditAttrs["class"] = "form-control";
			$this->pam_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pam_id->AdvancedSearch->SearchValue = HtmlDecode($this->pam_id->AdvancedSearch->SearchValue);
			$this->pam_id->EditValue = HtmlEncode($this->pam_id->AdvancedSearch->SearchValue);
			$this->pam_id->PlaceHolder = RemoveHtml($this->pam_id->caption());

			// issue_to
			$this->issue_to->EditAttrs["class"] = "form-control";
			$this->issue_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->issue_to->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->issue_to->AdvancedSearch->ViewValue = $this->issue_to->lookupCacheOption($curVal);
			else
				$this->issue_to->AdvancedSearch->ViewValue = $this->issue_to->Lookup !== NULL && is_array($this->issue_to->Lookup->Options) ? $curVal : NULL;
			if ($this->issue_to->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->issue_to->EditValue = array_values($this->issue_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->issue_to->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`category`=999";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->issue_to->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->issue_to->EditValue = $arwrk;
			}

			// pp_qty
			$this->pp_qty->EditAttrs["class"] = "form-control";
			$this->pp_qty->EditCustomAttributes = "";
			$this->pp_qty->EditValue = HtmlEncode($this->pp_qty->AdvancedSearch->SearchValue);
			$this->pp_qty->PlaceHolder = RemoveHtml($this->pp_qty->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
			else
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== NULL && is_array($this->company_id->Lookup->Options) ? $curVal : NULL;
			if ($this->company_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->company_id->EditValue = array_values($this->company_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->company_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`category`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->company_id->EditValue = $arwrk;
			}

			// jc_quantity
			$this->jc_quantity->EditAttrs["class"] = "form-control";
			$this->jc_quantity->EditCustomAttributes = "";
			$this->jc_quantity->EditValue = HtmlEncode($this->jc_quantity->AdvancedSearch->SearchValue);
			$this->jc_quantity->PlaceHolder = RemoveHtml($this->jc_quantity->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = HtmlEncode($this->status->AdvancedSearch->SearchValue);
			$this->status->PlaceHolder = RemoveHtml($this->status->caption());

			// level
			$this->level->EditAttrs["class"] = "form-control";
			$this->level->EditCustomAttributes = "";
			$this->level->EditValue = HtmlEncode($this->level->AdvancedSearch->SearchValue);
			$this->level->PlaceHolder = RemoveHtml($this->level->caption());

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$this->buyer_id->EditValue = HtmlEncode($this->buyer_id->AdvancedSearch->SearchValue);
			$this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

			// balance
			$this->balance->EditAttrs["class"] = "form-control";
			$this->balance->EditCustomAttributes = "";
			$this->balance->EditValue = HtmlEncode($this->balance->AdvancedSearch->SearchValue);
			$this->balance->PlaceHolder = RemoveHtml($this->balance->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckInteger($this->jc_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->jc_no->errorMessage());
		}
		if (!CheckInteger($this->batch_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->batch_no->errorMessage());
		}
		if (!CheckNumber($this->pam_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pam_qty->errorMessage());
		}
		if (!CheckNumber($this->pending_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pending_qty->errorMessage());
		}
		if (!CheckNumber($this->pp_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pp_qty->errorMessage());
		}
		if (!CheckNumber($this->jc_quantity->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->jc_quantity->errorMessage());
		}
		if (!CheckInteger($this->status->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->status->errorMessage());
		}
		if (!CheckInteger($this->level->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->level->errorMessage());
		}
		if (!CheckInteger($this->buyer_id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->buyer_id->errorMessage());
		}
		if (!CheckNumber($this->balance->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->balance->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->pod->AdvancedSearch->load();
		$this->jc_no->AdvancedSearch->load();
		$this->product_code->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->cart_quantity->AdvancedSearch->load();
		$this->pam_qty->AdvancedSearch->load();
		$this->pending_qty->AdvancedSearch->load();
		$this->despatch_week->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
		$this->process->AdvancedSearch->load();
		$this->pam_id->AdvancedSearch->load();
		$this->issue_to->AdvancedSearch->load();
		$this->pp_qty->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->jc_quantity->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->level->AdvancedSearch->load();
		$this->buyer_id->AdvancedSearch->load();
		$this->balance->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("po_pending_wbclist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_packing_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_issue_to":
					$lookupFilter = function() {
						return "`category`=999";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_company_id":
					$lookupFilter = function() {
						return "`category`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_cart_quantity":
							$row[1] = FormatNumber($row[1], 3, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_despatch_week":
							break;
						case "x_packing_type":
							break;
						case "x_process":
							break;
						case "x_issue_to":
							break;
						case "x_company_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>