<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for po_s_auth
 */
class po_s_auth extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $po;
	public $company_id;
	public $partner_id;
	public $quantity;
	public $sqm;
	public $cbm;
	public $amount;
	public $a_operator;
	public $a_datetime;
	public $e_mail;
	public $app_operator;
	public $app_datetime;
	public $__request;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'po_s_auth';
		$this->TableName = 'po_s_auth';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`po_s_auth`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('po_s_auth', 'po_s_auth', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// po
		$this->po = new DbField('po_s_auth', 'po_s_auth', 'x_po', 'po', '`po`', '`po`', 18, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Nullable = FALSE; // NOT NULL field
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// company_id
		$this->company_id = new DbField('po_s_auth', 'po_s_auth', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 19, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->company_id->Lookup = new Lookup('company_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// partner_id
		$this->partner_id = new DbField('po_s_auth', 'po_s_auth', 'x_partner_id', 'partner_id', '`partner_id`', '`partner_id`', 19, -1, FALSE, '`partner_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->partner_id->Sortable = TRUE; // Allow sort
		$this->partner_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->partner_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->partner_id->Lookup = new Lookup('partner_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->partner_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['partner_id'] = &$this->partner_id;

		// quantity
		$this->quantity = new DbField('po_s_auth', 'po_s_auth', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['quantity'] = &$this->quantity;

		// sqm
		$this->sqm = new DbField('po_s_auth', 'po_s_auth', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 4, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Nullable = FALSE; // NOT NULL field
		$this->sqm->Required = TRUE; // Required field
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// cbm
		$this->cbm = new DbField('po_s_auth', 'po_s_auth', 'x_cbm', 'cbm', '`cbm`', '`cbm`', 4, -1, FALSE, '`cbm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cbm->Nullable = FALSE; // NOT NULL field
		$this->cbm->Required = TRUE; // Required field
		$this->cbm->Sortable = TRUE; // Allow sort
		$this->cbm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cbm'] = &$this->cbm;

		// amount
		$this->amount = new DbField('po_s_auth', 'po_s_auth', 'x_amount', 'amount', '`amount`', '`amount`', 200, -1, FALSE, '`amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount->Nullable = FALSE; // NOT NULL field
		$this->amount->Required = TRUE; // Required field
		$this->amount->Sortable = TRUE; // Allow sort
		$this->fields['amount'] = &$this->amount;

		// a_operator
		$this->a_operator = new DbField('po_s_auth', 'po_s_auth', 'x_a_operator', 'a_operator', '`a_operator`', '`a_operator`', 2, -1, FALSE, '`EV__a_operator`', TRUE, FALSE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->a_operator->Sortable = TRUE; // Allow sort
		$this->a_operator->Lookup = new Lookup('a_operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['a_operator'] = &$this->a_operator;

		// a_datetime
		$this->a_datetime = new DbField('po_s_auth', 'po_s_auth', 'x_a_datetime', 'a_datetime', '`a_datetime`', CastDateFieldForLike('`a_datetime`', 0, "DB"), 135, 0, FALSE, '`a_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->a_datetime->Sortable = TRUE; // Allow sort
		$this->a_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['a_datetime'] = &$this->a_datetime;

		// e_mail
		$this->e_mail = new DbField('po_s_auth', 'po_s_auth', 'x_e_mail', 'e_mail', '`e_mail`', '`e_mail`', 16, -1, FALSE, '`e_mail`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->e_mail->Nullable = FALSE; // NOT NULL field
		$this->e_mail->Sortable = TRUE; // Allow sort
		$this->e_mail->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->e_mail->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->e_mail->Lookup = new Lookup('e_mail', 'po_s_auth', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->e_mail->OptionCount = 2;
		$this->e_mail->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['e_mail'] = &$this->e_mail;

		// app_operator
		$this->app_operator = new DbField('po_s_auth', 'po_s_auth', 'x_app_operator', 'app_operator', '`app_operator`', '`app_operator`', 2, -1, FALSE, '`EV__app_operator`', TRUE, FALSE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->app_operator->Sortable = TRUE; // Allow sort
		$this->app_operator->Lookup = new Lookup('app_operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->fields['app_operator'] = &$this->app_operator;

		// app_datetime
		$this->app_datetime = new DbField('po_s_auth', 'po_s_auth', 'x_app_datetime', 'app_datetime', '`app_datetime`', CastDateFieldForLike('`app_datetime`', 0, "DB"), 135, 0, FALSE, '`app_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->app_datetime->Sortable = TRUE; // Allow sort
		$this->app_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['app_datetime'] = &$this->app_datetime;

		// request
		$this->__request = new DbField('po_s_auth', 'po_s_auth', 'x___request', 'request', '`request`', '`request`', 18, -1, FALSE, '`request`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->__request->Nullable = FALSE; // NOT NULL field
		$this->__request->Sortable = FALSE; // Allow sort
		$this->__request->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['request'] = &$this->__request;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`po_s_auth`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `user_name` FROM `admin_office` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `po_s_auth`.`a_operator` LIMIT 1) AS `EV__a_operator`, (SELECT `user_name` FROM `admin_office` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `po_s_auth`.`app_operator` LIMIT 1) AS `EV__app_operator` FROM `po_s_auth`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->a_operator->AdvancedSearch->SearchValue <> "" ||
			$this->a_operator->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->a_operator->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->a_operator->VirtualExpression . " "))
			return TRUE;
		if ($this->app_operator->AdvancedSearch->SearchValue <> "" ||
			$this->app_operator->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->app_operator->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->app_operator->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->po->DbValue = $row['po'];
		$this->company_id->DbValue = $row['company_id'];
		$this->partner_id->DbValue = $row['partner_id'];
		$this->quantity->DbValue = $row['quantity'];
		$this->sqm->DbValue = $row['sqm'];
		$this->cbm->DbValue = $row['cbm'];
		$this->amount->DbValue = $row['amount'];
		$this->a_operator->DbValue = $row['a_operator'];
		$this->a_datetime->DbValue = $row['a_datetime'];
		$this->e_mail->DbValue = $row['e_mail'];
		$this->app_operator->DbValue = $row['app_operator'];
		$this->app_datetime->DbValue = $row['app_datetime'];
		$this->__request->DbValue = $row['request'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "po_s_authlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "po_s_authview.php")
			return $Language->phrase("View");
		elseif ($pageName == "po_s_authedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "po_s_authadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "po_s_authlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("po_s_authview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("po_s_authview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "po_s_authadd.php?" . $this->getUrlParm($parm);
		else
			$url = "po_s_authadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("po_s_authedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("po_s_authadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("po_s_authdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->po->setDbValue($rs->fields('po'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->partner_id->setDbValue($rs->fields('partner_id'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->cbm->setDbValue($rs->fields('cbm'));
		$this->amount->setDbValue($rs->fields('amount'));
		$this->a_operator->setDbValue($rs->fields('a_operator'));
		$this->a_datetime->setDbValue($rs->fields('a_datetime'));
		$this->e_mail->setDbValue($rs->fields('e_mail'));
		$this->app_operator->setDbValue($rs->fields('app_operator'));
		$this->app_datetime->setDbValue($rs->fields('app_datetime'));
		$this->__request->setDbValue($rs->fields('request'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// po
		// company_id
		// partner_id
		// quantity
		// sqm
		// cbm
		// amount
		// a_operator
		// a_datetime
		// e_mail
		// app_operator
		// app_datetime
		// request

		$this->__request->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// company_id
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return User_Company_ID() == 0 ? "`status`=1 and `partner_type`=2" : "id= ".  User_Company_ID() . "  and `partner_type`=2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// partner_id
		$curVal = strval($this->partner_id->CurrentValue);
		if ($curVal <> "") {
			$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
			if ($this->partner_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`partner_type`=1 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
				}
			}
		} else {
			$this->partner_id->ViewValue = NULL;
		}
		$this->partner_id->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// cbm
		$this->cbm->ViewValue = $this->cbm->CurrentValue;
		$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 2, -2, -2, -2);
		$this->cbm->ViewCustomAttributes = "";

		// amount
		$this->amount->ViewValue = $this->amount->CurrentValue;
		$this->amount->ViewCustomAttributes = "";

		// a_operator
		if ($this->a_operator->VirtualValue <> "") {
			$this->a_operator->ViewValue = $this->a_operator->VirtualValue;
		} else {
			$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
		$curVal = strval($this->a_operator->CurrentValue);
		if ($curVal <> "") {
			$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
			if ($this->a_operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
				}
			}
		} else {
			$this->a_operator->ViewValue = NULL;
		}
		}
		$this->a_operator->ViewCustomAttributes = "";

		// a_datetime
		$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
		$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 0);
		$this->a_datetime->ViewCustomAttributes = "";

		// e_mail
		if (strval($this->e_mail->CurrentValue) <> "") {
			$this->e_mail->ViewValue = $this->e_mail->optionCaption($this->e_mail->CurrentValue);
		} else {
			$this->e_mail->ViewValue = NULL;
		}
		$this->e_mail->ViewCustomAttributes = "";

		// app_operator
		if ($this->app_operator->VirtualValue <> "") {
			$this->app_operator->ViewValue = $this->app_operator->VirtualValue;
		} else {
			$this->app_operator->ViewValue = $this->app_operator->CurrentValue;
		$curVal = strval($this->app_operator->CurrentValue);
		if ($curVal <> "") {
			$this->app_operator->ViewValue = $this->app_operator->lookupCacheOption($curVal);
			if ($this->app_operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->app_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->app_operator->ViewValue = $this->app_operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->app_operator->ViewValue = $this->app_operator->CurrentValue;
				}
			}
		} else {
			$this->app_operator->ViewValue = NULL;
		}
		}
		$this->app_operator->ViewCustomAttributes = "";

		// app_datetime
		$this->app_datetime->ViewValue = $this->app_datetime->CurrentValue;
		$this->app_datetime->ViewValue = FormatDateTime($this->app_datetime->ViewValue, 0);
		$this->app_datetime->ViewCustomAttributes = "";

		// request
		$this->__request->ViewValue = $this->__request->CurrentValue;
		$this->__request->ViewValue = FormatNumber($this->__request->ViewValue, 0, -2, -2, -2);
		$this->__request->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// partner_id
		$this->partner_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->partner_id->CurrentValue)) {
			$this->partner_id->HrefValue = "po_b_authlist.php?x_partner_id=" . $this->partner_id->CurrentValue; // Add prefix/suffix
			$this->partner_id->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
		} else {
			$this->partner_id->HrefValue = "";
		}
		$this->partner_id->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// cbm
		$this->cbm->LinkCustomAttributes = "";
		$this->cbm->HrefValue = "";
		$this->cbm->TooltipValue = "";

		// amount
		$this->amount->LinkCustomAttributes = "";
		$this->amount->HrefValue = "";
		$this->amount->TooltipValue = "";

		// a_operator
		$this->a_operator->LinkCustomAttributes = "";
		$this->a_operator->HrefValue = "";
		$this->a_operator->TooltipValue = "";

		// a_datetime
		$this->a_datetime->LinkCustomAttributes = "";
		$this->a_datetime->HrefValue = "";
		$this->a_datetime->TooltipValue = "";

		// e_mail
		$this->e_mail->LinkCustomAttributes = "";
		$this->e_mail->HrefValue = "";
		$this->e_mail->TooltipValue = "";

		// app_operator
		$this->app_operator->LinkCustomAttributes = "";
		$this->app_operator->HrefValue = "";
		$this->app_operator->TooltipValue = "";

		// app_datetime
		$this->app_datetime->LinkCustomAttributes = "";
		$this->app_datetime->HrefValue = "";
		$this->app_datetime->TooltipValue = "";

		// request
		$this->__request->LinkCustomAttributes = "";
		$this->__request->HrefValue = "";
		$this->__request->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->PlaceHolder = RemoveHtml($this->po->caption());

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";

		// partner_id
		$this->partner_id->EditAttrs["class"] = "form-control";
		$this->partner_id->EditCustomAttributes = "";

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = "";
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
		if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
			$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, -2);

		// cbm
		$this->cbm->EditAttrs["class"] = "form-control";
		$this->cbm->EditCustomAttributes = "";
		$this->cbm->EditValue = $this->cbm->CurrentValue;
		$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
		if (strval($this->cbm->EditValue) <> "" && is_numeric($this->cbm->EditValue))
			$this->cbm->EditValue = FormatNumber($this->cbm->EditValue, -2, -2, -2, -2);

		// amount
		$this->amount->EditAttrs["class"] = "form-control";
		$this->amount->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->amount->CurrentValue = HtmlDecode($this->amount->CurrentValue);
		$this->amount->EditValue = $this->amount->CurrentValue;
		$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

		// a_operator
		$this->a_operator->EditAttrs["class"] = "form-control";
		$this->a_operator->EditCustomAttributes = "";
		$this->a_operator->EditValue = $this->a_operator->CurrentValue;
		$this->a_operator->PlaceHolder = RemoveHtml($this->a_operator->caption());

		// a_datetime
		$this->a_datetime->EditAttrs["class"] = "form-control";
		$this->a_datetime->EditCustomAttributes = "";
		$this->a_datetime->EditValue = FormatDateTime($this->a_datetime->CurrentValue, 8);
		$this->a_datetime->PlaceHolder = RemoveHtml($this->a_datetime->caption());

		// e_mail
		$this->e_mail->EditAttrs["class"] = "form-control";
		$this->e_mail->EditCustomAttributes = "";
		$this->e_mail->EditValue = $this->e_mail->options(TRUE);

		// app_operator
		$this->app_operator->EditAttrs["class"] = "form-control";
		$this->app_operator->EditCustomAttributes = "";
		$this->app_operator->EditValue = $this->app_operator->CurrentValue;
		$this->app_operator->PlaceHolder = RemoveHtml($this->app_operator->caption());

		// app_datetime
		$this->app_datetime->EditAttrs["class"] = "form-control";
		$this->app_datetime->EditCustomAttributes = "";
		$this->app_datetime->EditValue = FormatDateTime($this->app_datetime->CurrentValue, 8);
		$this->app_datetime->PlaceHolder = RemoveHtml($this->app_datetime->caption());

		// request
		$this->__request->EditAttrs["class"] = "form-control";
		$this->__request->EditCustomAttributes = "";
		$this->__request->EditValue = $this->__request->CurrentValue;
		$this->__request->PlaceHolder = RemoveHtml($this->__request->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->quantity->CurrentValue))
				$this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
			if (is_numeric($this->sqm->CurrentValue))
				$this->sqm->Total += $this->sqm->CurrentValue; // Accumulate total
			if (is_numeric($this->cbm->CurrentValue))
				$this->cbm->Total += $this->cbm->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->quantity->CurrentValue = $this->quantity->Total;
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";
			$this->quantity->HrefValue = ""; // Clear href value
			$this->sqm->CurrentValue = $this->sqm->Total;
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";
			$this->sqm->HrefValue = ""; // Clear href value
			$this->cbm->CurrentValue = $this->cbm->Total;
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 2, -2, -2, -2);
			$this->cbm->ViewCustomAttributes = "";
			$this->cbm->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->a_datetime);
					$doc->exportCaption($this->e_mail);
					$doc->exportCaption($this->app_operator);
					$doc->exportCaption($this->app_datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->a_datetime);
					$doc->exportCaption($this->e_mail);
					$doc->exportCaption($this->app_operator);
					$doc->exportCaption($this->app_datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->po);
						$doc->exportField($this->company_id);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->quantity);
						$doc->exportField($this->sqm);
						$doc->exportField($this->cbm);
						$doc->exportField($this->amount);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->a_datetime);
						$doc->exportField($this->e_mail);
						$doc->exportField($this->app_operator);
						$doc->exportField($this->app_datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->po);
						$doc->exportField($this->company_id);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->quantity);
						$doc->exportField($this->sqm);
						$doc->exportField($this->cbm);
						$doc->exportField($this->amount);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->a_datetime);
						$doc->exportField($this->e_mail);
						$doc->exportField($this->app_operator);
						$doc->exportField($this->app_datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->po, '');
				$doc->exportAggregate($this->company_id, '');
				$doc->exportAggregate($this->partner_id, '');
				$doc->exportAggregate($this->quantity, 'TOTAL');
				$doc->exportAggregate($this->sqm, 'TOTAL');
				$doc->exportAggregate($this->cbm, 'TOTAL');
				$doc->exportAggregate($this->amount, '');
				$doc->exportAggregate($this->a_operator, '');
				$doc->exportAggregate($this->a_datetime, '');
				$doc->exportAggregate($this->e_mail, '');
				$doc->exportAggregate($this->app_operator, '');
				$doc->exportAggregate($this->app_datetime, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>