<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class po_s_edit extends po_s
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'po_s';

	// Page object name
	public $PageObjName = "po_s_edit";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (po_s)
		if (!isset($GLOBALS["po_s"]) || get_class($GLOBALS["po_s"]) == PROJECT_NAMESPACE . "po_s") {
			$GLOBALS["po_s"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["po_s"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_s');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $po_s;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($po_s);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "po_sview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("po_slist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->po->setVisibility();
		$this->company_id->setVisibility();
		$this->partner_id->setVisibility();
		$this->grp->Visible = FALSE;
		$this->s_grp->Visible = FALSE;
		$this->location->Visible = FALSE;
		$this->copy->setVisibility();
		$this->cart_id->setVisibility();
		$this->quantity->setVisibility();
		$this->sqm->setVisibility();
		$this->amount->setVisibility();
		$this->cbm->setVisibility();
		$this->gst->setVisibility();
		$this->partner_order_no->setVisibility();
		$this->partner_order_date->setVisibility();
		$this->despatch_date->setVisibility();
		$this->despatch_week->setVisibility();
		$this->fob_date->setVisibility();
		$this->part_dispatch->setVisibility();
		$this->payment_terms->setVisibility();
		$this->transport_type->setVisibility();
		$this->partner_shipping_id->setVisibility();
		$this->description_04->Visible = FALSE;
		$this->description_03->Visible = FALSE;
		$this->description_20->Visible = FALSE;
		$this->description_01->setVisibility();
		$this->description_02->Visible = FALSE;
		$this->description_07->Visible = FALSE;
		$this->description_17->Visible = FALSE;
		$this->description_18->Visible = FALSE;
		$this->description_19->Visible = FALSE;
		$this->description_05->Visible = FALSE;
		$this->description_06->Visible = FALSE;
		$this->description_08->Visible = FALSE;
		$this->remarks->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->a_operator->Visible = FALSE;
		$this->a_datetime->Visible = FALSE;
		$this->jc_no->setVisibility();
		$this->buyer_instruction->setVisibility();
		$this->d_09_head->setVisibility();
		$this->description_09->setVisibility();
		$this->d_10_head->setVisibility();
		$this->description_10->setVisibility();
		$this->d_11_head->setVisibility();
		$this->description_11->setVisibility();
		$this->d_12_head->setVisibility();
		$this->description_12->setVisibility();
		$this->production_site->setVisibility();
		$this->__request->Visible = FALSE;
		$this->production_plan->setVisibility();
		$this->uploads->setVisibility();
		$this->balance_quantity->setVisibility();
		$this->e_mail->setVisibility();
		$this->billing_address_id->setVisibility();
		$this->shipping_address_id->setVisibility();
		$this->status->setVisibility();
		$this->app_operator->Visible = FALSE;
		$this->app_datetime->Visible = FALSE;
		$this->reports_to->Visible = FALSE;
		$this->c_operator->Visible = FALSE;
		$this->c_datetime->Visible = FALSE;
		$this->hideFieldsForAddEdit();
		$this->production_site->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->copy);
		$this->setupLookupOptions($this->cart_id);
		$this->setupLookupOptions($this->gst);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->payment_terms);
		$this->setupLookupOptions($this->transport_type);
		$this->setupLookupOptions($this->partner_shipping_id);
		$this->setupLookupOptions($this->description_05);
		$this->setupLookupOptions($this->description_06);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->a_operator);
		$this->setupLookupOptions($this->d_09_head);
		$this->setupLookupOptions($this->d_10_head);
		$this->setupLookupOptions($this->d_11_head);
		$this->setupLookupOptions($this->d_12_head);
		$this->setupLookupOptions($this->production_site);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("po_slist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = 'autoprogramme.php?apcid=3e89ebdb49f712c7d90d1b39e348bbbf&type=pp';
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->uploads->Upload->Index = $CurrentForm->Index;
		$this->uploads->Upload->uploadFile();
		$this->uploads->CurrentValue = $this->uploads->Upload->FileName;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'po' first before field var 'x_po'
		$val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
		if (!$this->po->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po->Visible = FALSE; // Disable update for API request
			else
				$this->po->setFormValue($val);
		}

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}

		// Check field name 'partner_id' first before field var 'x_partner_id'
		$val = $CurrentForm->hasValue("partner_id") ? $CurrentForm->getValue("partner_id") : $CurrentForm->getValue("x_partner_id");
		if (!$this->partner_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_id->Visible = FALSE; // Disable update for API request
			else
				$this->partner_id->setFormValue($val);
		}

		// Check field name 'copy' first before field var 'x_copy'
		$val = $CurrentForm->hasValue("copy") ? $CurrentForm->getValue("copy") : $CurrentForm->getValue("x_copy");
		if (!$this->copy->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->copy->Visible = FALSE; // Disable update for API request
			else
				$this->copy->setFormValue($val);
		}

		// Check field name 'cart_id' first before field var 'x_cart_id'
		$val = $CurrentForm->hasValue("cart_id") ? $CurrentForm->getValue("cart_id") : $CurrentForm->getValue("x_cart_id");
		if (!$this->cart_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cart_id->Visible = FALSE; // Disable update for API request
			else
				$this->cart_id->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'sqm' first before field var 'x_sqm'
		$val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
		if (!$this->sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sqm->Visible = FALSE; // Disable update for API request
			else
				$this->sqm->setFormValue($val);
		}

		// Check field name 'amount' first before field var 'x_amount'
		$val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
		if (!$this->amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->amount->Visible = FALSE; // Disable update for API request
			else
				$this->amount->setFormValue($val);
		}

		// Check field name 'cbm' first before field var 'x_cbm'
		$val = $CurrentForm->hasValue("cbm") ? $CurrentForm->getValue("cbm") : $CurrentForm->getValue("x_cbm");
		if (!$this->cbm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cbm->Visible = FALSE; // Disable update for API request
			else
				$this->cbm->setFormValue($val);
		}

		// Check field name 'gst' first before field var 'x_gst'
		$val = $CurrentForm->hasValue("gst") ? $CurrentForm->getValue("gst") : $CurrentForm->getValue("x_gst");
		if (!$this->gst->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gst->Visible = FALSE; // Disable update for API request
			else
				$this->gst->setFormValue($val);
		}

		// Check field name 'partner_order_no' first before field var 'x_partner_order_no'
		$val = $CurrentForm->hasValue("partner_order_no") ? $CurrentForm->getValue("partner_order_no") : $CurrentForm->getValue("x_partner_order_no");
		if (!$this->partner_order_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_order_no->Visible = FALSE; // Disable update for API request
			else
				$this->partner_order_no->setFormValue($val);
		}

		// Check field name 'partner_order_date' first before field var 'x_partner_order_date'
		$val = $CurrentForm->hasValue("partner_order_date") ? $CurrentForm->getValue("partner_order_date") : $CurrentForm->getValue("x_partner_order_date");
		if (!$this->partner_order_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_order_date->Visible = FALSE; // Disable update for API request
			else
				$this->partner_order_date->setFormValue($val);
			$this->partner_order_date->CurrentValue = UnFormatDateTime($this->partner_order_date->CurrentValue, 0);
		}

		// Check field name 'despatch_date' first before field var 'x_despatch_date'
		$val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
		if (!$this->despatch_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_date->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_date->setFormValue($val);
			$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		}

		// Check field name 'despatch_week' first before field var 'x_despatch_week'
		$val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
		if (!$this->despatch_week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_week->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_week->setFormValue($val);
		}

		// Check field name 'fob_date' first before field var 'x_fob_date'
		$val = $CurrentForm->hasValue("fob_date") ? $CurrentForm->getValue("fob_date") : $CurrentForm->getValue("x_fob_date");
		if (!$this->fob_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fob_date->Visible = FALSE; // Disable update for API request
			else
				$this->fob_date->setFormValue($val);
			$this->fob_date->CurrentValue = UnFormatDateTime($this->fob_date->CurrentValue, 0);
		}

		// Check field name 'part_dispatch' first before field var 'x_part_dispatch'
		$val = $CurrentForm->hasValue("part_dispatch") ? $CurrentForm->getValue("part_dispatch") : $CurrentForm->getValue("x_part_dispatch");
		if (!$this->part_dispatch->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->part_dispatch->Visible = FALSE; // Disable update for API request
			else
				$this->part_dispatch->setFormValue($val);
		}

		// Check field name 'payment_terms' first before field var 'x_payment_terms'
		$val = $CurrentForm->hasValue("payment_terms") ? $CurrentForm->getValue("payment_terms") : $CurrentForm->getValue("x_payment_terms");
		if (!$this->payment_terms->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->payment_terms->Visible = FALSE; // Disable update for API request
			else
				$this->payment_terms->setFormValue($val);
		}

		// Check field name 'transport_type' first before field var 'x_transport_type'
		$val = $CurrentForm->hasValue("transport_type") ? $CurrentForm->getValue("transport_type") : $CurrentForm->getValue("x_transport_type");
		if (!$this->transport_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->transport_type->Visible = FALSE; // Disable update for API request
			else
				$this->transport_type->setFormValue($val);
		}

		// Check field name 'partner_shipping_id' first before field var 'x_partner_shipping_id'
		$val = $CurrentForm->hasValue("partner_shipping_id") ? $CurrentForm->getValue("partner_shipping_id") : $CurrentForm->getValue("x_partner_shipping_id");
		if (!$this->partner_shipping_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_shipping_id->Visible = FALSE; // Disable update for API request
			else
				$this->partner_shipping_id->setFormValue($val);
		}

		// Check field name 'description_01' first before field var 'x_description_01'
		$val = $CurrentForm->hasValue("description_01") ? $CurrentForm->getValue("description_01") : $CurrentForm->getValue("x_description_01");
		if (!$this->description_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_01->Visible = FALSE; // Disable update for API request
			else
				$this->description_01->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'jc_no' first before field var 'x_jc_no'
		$val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
		if (!$this->jc_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_no->Visible = FALSE; // Disable update for API request
			else
				$this->jc_no->setFormValue($val);
		}

		// Check field name 'buyer_instruction' first before field var 'x_buyer_instruction'
		$val = $CurrentForm->hasValue("buyer_instruction") ? $CurrentForm->getValue("buyer_instruction") : $CurrentForm->getValue("x_buyer_instruction");
		if (!$this->buyer_instruction->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_instruction->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_instruction->setFormValue($val);
		}

		// Check field name 'd_09_head' first before field var 'x_d_09_head'
		$val = $CurrentForm->hasValue("d_09_head") ? $CurrentForm->getValue("d_09_head") : $CurrentForm->getValue("x_d_09_head");
		if (!$this->d_09_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_09_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_09_head->setFormValue($val);
		}

		// Check field name 'description_09' first before field var 'x_description_09'
		$val = $CurrentForm->hasValue("description_09") ? $CurrentForm->getValue("description_09") : $CurrentForm->getValue("x_description_09");
		if (!$this->description_09->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_09->Visible = FALSE; // Disable update for API request
			else
				$this->description_09->setFormValue($val);
		}

		// Check field name 'd_10_head' first before field var 'x_d_10_head'
		$val = $CurrentForm->hasValue("d_10_head") ? $CurrentForm->getValue("d_10_head") : $CurrentForm->getValue("x_d_10_head");
		if (!$this->d_10_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_10_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_10_head->setFormValue($val);
		}

		// Check field name 'description_10' first before field var 'x_description_10'
		$val = $CurrentForm->hasValue("description_10") ? $CurrentForm->getValue("description_10") : $CurrentForm->getValue("x_description_10");
		if (!$this->description_10->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_10->Visible = FALSE; // Disable update for API request
			else
				$this->description_10->setFormValue($val);
		}

		// Check field name 'd_11_head' first before field var 'x_d_11_head'
		$val = $CurrentForm->hasValue("d_11_head") ? $CurrentForm->getValue("d_11_head") : $CurrentForm->getValue("x_d_11_head");
		if (!$this->d_11_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_11_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_11_head->setFormValue($val);
		}

		// Check field name 'description_11' first before field var 'x_description_11'
		$val = $CurrentForm->hasValue("description_11") ? $CurrentForm->getValue("description_11") : $CurrentForm->getValue("x_description_11");
		if (!$this->description_11->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_11->Visible = FALSE; // Disable update for API request
			else
				$this->description_11->setFormValue($val);
		}

		// Check field name 'd_12_head' first before field var 'x_d_12_head'
		$val = $CurrentForm->hasValue("d_12_head") ? $CurrentForm->getValue("d_12_head") : $CurrentForm->getValue("x_d_12_head");
		if (!$this->d_12_head->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_12_head->Visible = FALSE; // Disable update for API request
			else
				$this->d_12_head->setFormValue($val);
		}

		// Check field name 'description_12' first before field var 'x_description_12'
		$val = $CurrentForm->hasValue("description_12") ? $CurrentForm->getValue("description_12") : $CurrentForm->getValue("x_description_12");
		if (!$this->description_12->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_12->Visible = FALSE; // Disable update for API request
			else
				$this->description_12->setFormValue($val);
		}

		// Check field name 'production_site' first before field var 'x_production_site'
		$val = $CurrentForm->hasValue("production_site") ? $CurrentForm->getValue("production_site") : $CurrentForm->getValue("x_production_site");
		if (!$this->production_site->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->production_site->Visible = FALSE; // Disable update for API request
			else
				$this->production_site->setFormValue($val);
		}

		// Check field name 'production_plan' first before field var 'x_production_plan'
		$val = $CurrentForm->hasValue("production_plan") ? $CurrentForm->getValue("production_plan") : $CurrentForm->getValue("x_production_plan");
		if (!$this->production_plan->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->production_plan->Visible = FALSE; // Disable update for API request
			else
				$this->production_plan->setFormValue($val);
		}

		// Check field name 'balance_quantity' first before field var 'x_balance_quantity'
		$val = $CurrentForm->hasValue("balance_quantity") ? $CurrentForm->getValue("balance_quantity") : $CurrentForm->getValue("x_balance_quantity");
		if (!$this->balance_quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->balance_quantity->Visible = FALSE; // Disable update for API request
			else
				$this->balance_quantity->setFormValue($val);
		}

		// Check field name 'e_mail' first before field var 'x_e_mail'
		$val = $CurrentForm->hasValue("e_mail") ? $CurrentForm->getValue("e_mail") : $CurrentForm->getValue("x_e_mail");
		if (!$this->e_mail->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->e_mail->Visible = FALSE; // Disable update for API request
			else
				$this->e_mail->setFormValue($val);
		}

		// Check field name 'billing_address_id' first before field var 'x_billing_address_id'
		$val = $CurrentForm->hasValue("billing_address_id") ? $CurrentForm->getValue("billing_address_id") : $CurrentForm->getValue("x_billing_address_id");
		if (!$this->billing_address_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->billing_address_id->Visible = FALSE; // Disable update for API request
			else
				$this->billing_address_id->setFormValue($val);
		}

		// Check field name 'shipping_address_id' first before field var 'x_shipping_address_id'
		$val = $CurrentForm->hasValue("shipping_address_id") ? $CurrentForm->getValue("shipping_address_id") : $CurrentForm->getValue("x_shipping_address_id");
		if (!$this->shipping_address_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shipping_address_id->Visible = FALSE; // Disable update for API request
			else
				$this->shipping_address_id->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->po->CurrentValue = $this->po->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->partner_id->CurrentValue = $this->partner_id->FormValue;
		$this->copy->CurrentValue = $this->copy->FormValue;
		$this->cart_id->CurrentValue = $this->cart_id->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->sqm->CurrentValue = $this->sqm->FormValue;
		$this->amount->CurrentValue = $this->amount->FormValue;
		$this->cbm->CurrentValue = $this->cbm->FormValue;
		$this->gst->CurrentValue = $this->gst->FormValue;
		$this->partner_order_no->CurrentValue = $this->partner_order_no->FormValue;
		$this->partner_order_date->CurrentValue = $this->partner_order_date->FormValue;
		$this->partner_order_date->CurrentValue = UnFormatDateTime($this->partner_order_date->CurrentValue, 0);
		$this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
		$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		$this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
		$this->fob_date->CurrentValue = $this->fob_date->FormValue;
		$this->fob_date->CurrentValue = UnFormatDateTime($this->fob_date->CurrentValue, 0);
		$this->part_dispatch->CurrentValue = $this->part_dispatch->FormValue;
		$this->payment_terms->CurrentValue = $this->payment_terms->FormValue;
		$this->transport_type->CurrentValue = $this->transport_type->FormValue;
		$this->partner_shipping_id->CurrentValue = $this->partner_shipping_id->FormValue;
		$this->description_01->CurrentValue = $this->description_01->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->jc_no->CurrentValue = $this->jc_no->FormValue;
		$this->buyer_instruction->CurrentValue = $this->buyer_instruction->FormValue;
		$this->d_09_head->CurrentValue = $this->d_09_head->FormValue;
		$this->description_09->CurrentValue = $this->description_09->FormValue;
		$this->d_10_head->CurrentValue = $this->d_10_head->FormValue;
		$this->description_10->CurrentValue = $this->description_10->FormValue;
		$this->d_11_head->CurrentValue = $this->d_11_head->FormValue;
		$this->description_11->CurrentValue = $this->description_11->FormValue;
		$this->d_12_head->CurrentValue = $this->d_12_head->FormValue;
		$this->description_12->CurrentValue = $this->description_12->FormValue;
		$this->production_site->CurrentValue = $this->production_site->FormValue;
		$this->production_plan->CurrentValue = $this->production_plan->FormValue;
		$this->balance_quantity->CurrentValue = $this->balance_quantity->FormValue;
		$this->e_mail->CurrentValue = $this->e_mail->FormValue;
		$this->billing_address_id->CurrentValue = $this->billing_address_id->FormValue;
		$this->shipping_address_id->CurrentValue = $this->shipping_address_id->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->po->setDbValue($row['po']);
		$this->company_id->setDbValue($row['company_id']);
		$this->partner_id->setDbValue($row['partner_id']);
		if (array_key_exists('EV__partner_id', $rs->fields)) {
			$this->partner_id->VirtualValue = $rs->fields('EV__partner_id'); // Set up virtual field value
		} else {
			$this->partner_id->VirtualValue = ""; // Clear value
		}
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->location->setDbValue($row['location']);
		$this->copy->setDbValue($row['copy']);
		$this->cart_id->setDbValue($row['cart_id']);
		$this->quantity->setDbValue($row['quantity']);
		$this->sqm->setDbValue($row['sqm']);
		$this->amount->setDbValue($row['amount']);
		$this->cbm->setDbValue($row['cbm']);
		$this->gst->setDbValue($row['gst']);
		$this->partner_order_no->setDbValue($row['partner_order_no']);
		$this->partner_order_date->setDbValue($row['partner_order_date']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->despatch_week->setDbValue($row['despatch_week']);
		$this->fob_date->setDbValue($row['fob_date']);
		$this->part_dispatch->setDbValue($row['part_dispatch']);
		$this->payment_terms->setDbValue($row['payment_terms']);
		$this->transport_type->setDbValue($row['transport_type']);
		$this->partner_shipping_id->setDbValue($row['partner_shipping_id']);
		$this->description_04->setDbValue($row['description_04']);
		$this->description_03->setDbValue($row['description_03']);
		$this->description_20->setDbValue($row['description_20']);
		$this->description_01->setDbValue($row['description_01']);
		$this->description_02->setDbValue($row['description_02']);
		$this->description_07->setDbValue($row['description_07']);
		$this->description_17->setDbValue($row['description_17']);
		$this->description_18->setDbValue($row['description_18']);
		$this->description_19->setDbValue($row['description_19']);
		$this->description_05->setDbValue($row['description_05']);
		$this->description_06->setDbValue($row['description_06']);
		$this->description_08->setDbValue($row['description_08']);
		$this->remarks->setDbValue($row['remarks']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->a_datetime->setDbValue($row['a_datetime']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->buyer_instruction->setDbValue($row['buyer_instruction']);
		$this->d_09_head->setDbValue($row['d_09_head']);
		$this->description_09->setDbValue($row['description_09']);
		$this->d_10_head->setDbValue($row['d_10_head']);
		$this->description_10->setDbValue($row['description_10']);
		$this->d_11_head->setDbValue($row['d_11_head']);
		$this->description_11->setDbValue($row['description_11']);
		$this->d_12_head->setDbValue($row['d_12_head']);
		$this->description_12->setDbValue($row['description_12']);
		$this->production_site->setDbValue($row['production_site']);
		$this->__request->setDbValue($row['request']);
		$this->production_plan->setDbValue($row['production_plan']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->balance_quantity->setDbValue($row['balance_quantity']);
		$this->e_mail->setDbValue($row['e_mail']);
		$this->billing_address_id->setDbValue($row['billing_address_id']);
		$this->shipping_address_id->setDbValue($row['shipping_address_id']);
		$this->status->setDbValue($row['status']);
		$this->app_operator->setDbValue($row['app_operator']);
		$this->app_datetime->setDbValue($row['app_datetime']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->c_operator->setDbValue($row['c_operator']);
		$this->c_datetime->setDbValue($row['c_datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['po'] = NULL;
		$row['company_id'] = NULL;
		$row['partner_id'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['location'] = NULL;
		$row['copy'] = NULL;
		$row['cart_id'] = NULL;
		$row['quantity'] = NULL;
		$row['sqm'] = NULL;
		$row['amount'] = NULL;
		$row['cbm'] = NULL;
		$row['gst'] = NULL;
		$row['partner_order_no'] = NULL;
		$row['partner_order_date'] = NULL;
		$row['despatch_date'] = NULL;
		$row['despatch_week'] = NULL;
		$row['fob_date'] = NULL;
		$row['part_dispatch'] = NULL;
		$row['payment_terms'] = NULL;
		$row['transport_type'] = NULL;
		$row['partner_shipping_id'] = NULL;
		$row['description_04'] = NULL;
		$row['description_03'] = NULL;
		$row['description_20'] = NULL;
		$row['description_01'] = NULL;
		$row['description_02'] = NULL;
		$row['description_07'] = NULL;
		$row['description_17'] = NULL;
		$row['description_18'] = NULL;
		$row['description_19'] = NULL;
		$row['description_05'] = NULL;
		$row['description_06'] = NULL;
		$row['description_08'] = NULL;
		$row['remarks'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['a_operator'] = NULL;
		$row['a_datetime'] = NULL;
		$row['jc_no'] = NULL;
		$row['buyer_instruction'] = NULL;
		$row['d_09_head'] = NULL;
		$row['description_09'] = NULL;
		$row['d_10_head'] = NULL;
		$row['description_10'] = NULL;
		$row['d_11_head'] = NULL;
		$row['description_11'] = NULL;
		$row['d_12_head'] = NULL;
		$row['description_12'] = NULL;
		$row['production_site'] = NULL;
		$row['request'] = NULL;
		$row['production_plan'] = NULL;
		$row['uploads'] = NULL;
		$row['balance_quantity'] = NULL;
		$row['e_mail'] = NULL;
		$row['billing_address_id'] = NULL;
		$row['shipping_address_id'] = NULL;
		$row['status'] = NULL;
		$row['app_operator'] = NULL;
		$row['app_datetime'] = NULL;
		$row['reports_to'] = NULL;
		$row['c_operator'] = NULL;
		$row['c_datetime'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cbm->FormValue == $this->cbm->CurrentValue && is_numeric(ConvertToFloatString($this->cbm->CurrentValue)))
			$this->cbm->CurrentValue = ConvertToFloatString($this->cbm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->description_01->FormValue == $this->description_01->CurrentValue && is_numeric(ConvertToFloatString($this->description_01->CurrentValue)))
			$this->description_01->CurrentValue = ConvertToFloatString($this->description_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->balance_quantity->FormValue == $this->balance_quantity->CurrentValue && is_numeric(ConvertToFloatString($this->balance_quantity->CurrentValue)))
			$this->balance_quantity->CurrentValue = ConvertToFloatString($this->balance_quantity->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// po
		// company_id
		// partner_id
		// grp
		// s_grp
		// location
		// copy
		// cart_id
		// quantity
		// sqm
		// amount
		// cbm
		// gst
		// partner_order_no
		// partner_order_date
		// despatch_date
		// despatch_week
		// fob_date
		// part_dispatch
		// payment_terms
		// transport_type
		// partner_shipping_id
		// description_04
		// description_03
		// description_20
		// description_01
		// description_02
		// description_07
		// description_17
		// description_18
		// description_19
		// description_05
		// description_06
		// description_08
		// remarks
		// operator
		// datetime
		// a_operator
		// a_datetime
		// jc_no
		// buyer_instruction
		// d_09_head
		// description_09
		// d_10_head
		// description_10
		// d_11_head
		// description_11
		// d_12_head
		// description_12
		// production_site
		// request
		// production_plan
		// uploads
		// balance_quantity
		// e_mail
		// billing_address_id
		// shipping_address_id
		// status
		// app_operator
		// app_datetime
		// reports_to
		// c_operator
		// c_datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return User_Company_ID() == 0 ? "`status` = 1 and `category` = 1" : "id= ".  User_Company_ID() . "  and `status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// partner_id
			if ($this->partner_id->VirtualValue <> "") {
				$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
			} else {
				$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `partner_type`=1 and `id` > 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->ViewValue = NULL;
			}
			}
			$this->partner_id->ViewCustomAttributes = "";

			// copy
			$curVal = strval($this->copy->CurrentValue);
			if ($curVal <> "") {
				$this->copy->ViewValue = $this->copy->lookupCacheOption($curVal);
				if ($this->copy->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`po` = " . $_GET['OLDPO']. "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->copy->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$this->copy->ViewValue = $this->copy->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->copy->ViewValue = $this->copy->CurrentValue;
					}
				}
			} else {
				$this->copy->ViewValue = NULL;
			}
			$this->copy->ViewCustomAttributes = "";

			// cart_id
			$curVal = strval($this->cart_id->CurrentValue);
			if ($curVal <> "") {
				$this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
				if ($this->cart_id->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` = NULL || `po_id` = '' || `po_id` = '0'" : "`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue;
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->cart_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->cart_id->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, 0);
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, 0);
							$this->cart_id->ViewValue->add($this->cart_id->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->cart_id->ViewValue = $this->cart_id->CurrentValue;
					}
				}
			} else {
				$this->cart_id->ViewValue = NULL;
			}
			$this->cart_id->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 2, -2, -2, -2);
			$this->cbm->ViewCustomAttributes = "";

			// gst
			$curVal = strval($this->gst->CurrentValue);
			if ($curVal <> "") {
				$this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
				if ($this->gst->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->gst->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
						$arwrk[3] = $rswrk->fields('df3');
						$this->gst->ViewValue = $this->gst->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->gst->ViewValue = $this->gst->CurrentValue;
					}
				}
			} else {
				$this->gst->ViewValue = NULL;
			}
			$this->gst->ViewCustomAttributes = "";

			// partner_order_no
			$this->partner_order_no->ViewValue = $this->partner_order_no->CurrentValue;
			$this->partner_order_no->ViewCustomAttributes = "";

			// partner_order_date
			$this->partner_order_date->ViewValue = $this->partner_order_date->CurrentValue;
			$this->partner_order_date->ViewValue = FormatDateTime($this->partner_order_date->ViewValue, 0);
			$this->partner_order_date->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// fob_date
			$this->fob_date->ViewValue = $this->fob_date->CurrentValue;
			$this->fob_date->ViewValue = FormatDateTime($this->fob_date->ViewValue, 0);
			$this->fob_date->ViewCustomAttributes = "";

			// part_dispatch
			if (strval($this->part_dispatch->CurrentValue) <> "") {
				$this->part_dispatch->ViewValue = $this->part_dispatch->optionCaption($this->part_dispatch->CurrentValue);
			} else {
				$this->part_dispatch->ViewValue = NULL;
			}
			$this->part_dispatch->ViewCustomAttributes = "";

			// payment_terms
			$curVal = strval($this->payment_terms->CurrentValue);
			if ($curVal <> "") {
				$this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
				if ($this->payment_terms->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 81";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->payment_terms->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
					}
				}
			} else {
				$this->payment_terms->ViewValue = NULL;
			}
			$this->payment_terms->ViewCustomAttributes = "";

			// transport_type
			$curVal = strval($this->transport_type->CurrentValue);
			if ($curVal <> "") {
				$this->transport_type->ViewValue = $this->transport_type->lookupCacheOption($curVal);
				if ($this->transport_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 82";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->transport_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->transport_type->ViewValue = $this->transport_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->transport_type->ViewValue = $this->transport_type->CurrentValue;
					}
				}
			} else {
				$this->transport_type->ViewValue = NULL;
			}
			$this->transport_type->ViewCustomAttributes = "";

			// partner_shipping_id
			$curVal = strval($this->partner_shipping_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_shipping_id->ViewValue = $this->partner_shipping_id->lookupCacheOption($curVal);
				if ($this->partner_shipping_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_shipping_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->partner_shipping_id->ViewValue = $this->partner_shipping_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_shipping_id->ViewValue = $this->partner_shipping_id->CurrentValue;
					}
				}
			} else {
				$this->partner_shipping_id->ViewValue = NULL;
			}
			$this->partner_shipping_id->ViewCustomAttributes = "";

			// description_01
			$this->description_01->ViewValue = $this->description_01->CurrentValue;
			$this->description_01->ViewValue = FormatNumber($this->description_01->ViewValue, 3, -2, -2, -2);
			$this->description_01->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// a_operator
			$curVal = strval($this->a_operator->CurrentValue);
			if ($curVal <> "") {
				$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
				if ($this->a_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
					}
				}
			} else {
				$this->a_operator->ViewValue = NULL;
			}
			$this->a_operator->ViewCustomAttributes = "";

			// a_datetime
			$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
			$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 0);
			$this->a_datetime->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewCustomAttributes = "";

			// buyer_instruction
			$this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;
			$this->buyer_instruction->ViewCustomAttributes = "";

			// d_09_head
			$curVal = strval($this->d_09_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
				if ($this->d_09_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_09_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_09_head->ViewValue = $this->d_09_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_09_head->ViewValue = $this->d_09_head->CurrentValue;
					}
				}
			} else {
				$this->d_09_head->ViewValue = NULL;
			}
			$this->d_09_head->ViewCustomAttributes = "";

			// description_09
			$this->description_09->ViewValue = $this->description_09->CurrentValue;
			$this->description_09->ViewCustomAttributes = "";

			// d_10_head
			$curVal = strval($this->d_10_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
				if ($this->d_10_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_10_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_10_head->ViewValue = $this->d_10_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_10_head->ViewValue = $this->d_10_head->CurrentValue;
					}
				}
			} else {
				$this->d_10_head->ViewValue = NULL;
			}
			$this->d_10_head->ViewCustomAttributes = "";

			// description_10
			$this->description_10->ViewValue = $this->description_10->CurrentValue;
			$this->description_10->ViewCustomAttributes = "";

			// d_11_head
			$curVal = strval($this->d_11_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
				if ($this->d_11_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_11_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_11_head->ViewValue = $this->d_11_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_11_head->ViewValue = $this->d_11_head->CurrentValue;
					}
				}
			} else {
				$this->d_11_head->ViewValue = NULL;
			}
			$this->d_11_head->ViewCustomAttributes = "";

			// description_11
			$this->description_11->ViewValue = $this->description_11->CurrentValue;
			$this->description_11->ViewCustomAttributes = "";

			// d_12_head
			$curVal = strval($this->d_12_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
				if ($this->d_12_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_12_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_12_head->ViewValue = $this->d_12_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_12_head->ViewValue = $this->d_12_head->CurrentValue;
					}
				}
			} else {
				$this->d_12_head->ViewValue = NULL;
			}
			$this->d_12_head->ViewCustomAttributes = "";

			// description_12
			$this->description_12->ViewValue = $this->description_12->CurrentValue;
			$this->description_12->ViewCustomAttributes = "";

			// production_site
			$curVal = strval($this->production_site->CurrentValue);
			if ($curVal <> "") {
				$this->production_site->ViewValue = $this->production_site->lookupCacheOption($curVal);
				if ($this->production_site->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` IN (0,3)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->production_site->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->production_site->ViewValue = $this->production_site->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->production_site->ViewValue = $this->production_site->CurrentValue;
					}
				}
			} else {
				$this->production_site->ViewValue = NULL;
			}
			$this->production_site->ViewCustomAttributes = "";

			// production_plan
			if (strval($this->production_plan->CurrentValue) <> "") {
				$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
			} else {
				$this->production_plan->ViewValue = NULL;
			}
			$this->production_plan->ViewCustomAttributes = "";

			// uploads
			$this->uploads->UploadPath = '/.p_uploads/pppo/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->ViewValue = "";
			}
			$this->uploads->ViewCustomAttributes = "";

			// balance_quantity
			$this->balance_quantity->ViewValue = $this->balance_quantity->CurrentValue;
			$this->balance_quantity->ViewValue = FormatNumber($this->balance_quantity->ViewValue, 2, -2, -2, -2);
			$this->balance_quantity->ViewCustomAttributes = "";

			// e_mail
			$this->e_mail->ViewValue = $this->e_mail->CurrentValue;
			$this->e_mail->ViewValue = FormatNumber($this->e_mail->ViewValue, 0, -2, -2, -2);
			$this->e_mail->ViewCustomAttributes = "";

			// billing_address_id
			$this->billing_address_id->ViewValue = $this->billing_address_id->CurrentValue;
			$this->billing_address_id->ViewValue = FormatNumber($this->billing_address_id->ViewValue, 0, -2, -2, -2);
			$this->billing_address_id->ViewCustomAttributes = "";

			// shipping_address_id
			$this->shipping_address_id->ViewValue = $this->shipping_address_id->CurrentValue;
			$this->shipping_address_id->ViewValue = FormatNumber($this->shipping_address_id->ViewValue, 0, -2, -2, -2);
			$this->shipping_address_id->ViewCustomAttributes = "";

			// status
			$this->status->ViewValue = $this->status->CurrentValue;
			$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
			$this->status->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			if (!EmptyValue($this->po->CurrentValue)) {
				$this->po->HrefValue = "po_clist.php?x_po=" . $this->po->CurrentValue; // Add prefix/suffix
				$this->po->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
			} else {
				$this->po->HrefValue = "";
			}
			$this->po->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->partner_id->CurrentValue)) {
				$this->partner_id->HrefValue = "po_blist.php?x_partner_id=" . $this->partner_id->CurrentValue; // Add prefix/suffix
				$this->partner_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
			} else {
				$this->partner_id->HrefValue = "";
			}
			$this->partner_id->TooltipValue = "";

			// copy
			$this->copy->LinkCustomAttributes = "";
			$this->copy->HrefValue = "";
			$this->copy->TooltipValue = "";

			// cart_id
			$this->cart_id->LinkCustomAttributes = "";
			$this->cart_id->HrefValue = "";
			$this->cart_id->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// gst
			$this->gst->LinkCustomAttributes = "";
			$this->gst->HrefValue = "";
			$this->gst->TooltipValue = "";

			// partner_order_no
			$this->partner_order_no->LinkCustomAttributes = "";
			$this->partner_order_no->HrefValue = "";
			$this->partner_order_no->TooltipValue = "";

			// partner_order_date
			$this->partner_order_date->LinkCustomAttributes = "";
			$this->partner_order_date->HrefValue = "";
			$this->partner_order_date->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// fob_date
			$this->fob_date->LinkCustomAttributes = "";
			$this->fob_date->HrefValue = "";
			$this->fob_date->TooltipValue = "";

			// part_dispatch
			$this->part_dispatch->LinkCustomAttributes = "";
			if (!EmptyValue($this->part_dispatch->CurrentValue)) {
				$this->part_dispatch->HrefValue = "po_blist.php?x_part_dispatch=" . $this->part_dispatch->CurrentValue; // Add prefix/suffix
				$this->part_dispatch->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->part_dispatch->HrefValue = FullUrl($this->part_dispatch->HrefValue, "href");
			} else {
				$this->part_dispatch->HrefValue = "";
			}
			$this->part_dispatch->TooltipValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			if (!EmptyValue($this->payment_terms->CurrentValue)) {
				$this->payment_terms->HrefValue = "po_blist.php?x_payment_terms=" . $this->payment_terms->CurrentValue; // Add prefix/suffix
				$this->payment_terms->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->payment_terms->HrefValue = FullUrl($this->payment_terms->HrefValue, "href");
			} else {
				$this->payment_terms->HrefValue = "";
			}
			$this->payment_terms->TooltipValue = "";

			// transport_type
			$this->transport_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->transport_type->CurrentValue)) {
				$this->transport_type->HrefValue = "po_blist.php?x_transport_type=" . $this->transport_type->CurrentValue; // Add prefix/suffix
				$this->transport_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->transport_type->HrefValue = FullUrl($this->transport_type->HrefValue, "href");
			} else {
				$this->transport_type->HrefValue = "";
			}
			$this->transport_type->TooltipValue = "";

			// partner_shipping_id
			$this->partner_shipping_id->LinkCustomAttributes = "";
			$this->partner_shipping_id->HrefValue = "";
			$this->partner_shipping_id->TooltipValue = "";

			// description_01
			$this->description_01->LinkCustomAttributes = "";
			$this->description_01->HrefValue = "";
			$this->description_01->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// buyer_instruction
			$this->buyer_instruction->LinkCustomAttributes = "";
			$this->buyer_instruction->HrefValue = "";
			$this->buyer_instruction->TooltipValue = "";

			// d_09_head
			$this->d_09_head->LinkCustomAttributes = "";
			$this->d_09_head->HrefValue = "";
			$this->d_09_head->TooltipValue = "";

			// description_09
			$this->description_09->LinkCustomAttributes = "";
			$this->description_09->HrefValue = "";
			$this->description_09->TooltipValue = "";

			// d_10_head
			$this->d_10_head->LinkCustomAttributes = "";
			$this->d_10_head->HrefValue = "";
			$this->d_10_head->TooltipValue = "";

			// description_10
			$this->description_10->LinkCustomAttributes = "";
			$this->description_10->HrefValue = "";
			$this->description_10->TooltipValue = "";

			// d_11_head
			$this->d_11_head->LinkCustomAttributes = "";
			$this->d_11_head->HrefValue = "";
			$this->d_11_head->TooltipValue = "";

			// description_11
			$this->description_11->LinkCustomAttributes = "";
			$this->description_11->HrefValue = "";
			$this->description_11->TooltipValue = "";

			// d_12_head
			$this->d_12_head->LinkCustomAttributes = "";
			$this->d_12_head->HrefValue = "";
			$this->d_12_head->TooltipValue = "";

			// description_12
			$this->description_12->LinkCustomAttributes = "";
			$this->description_12->HrefValue = "";
			$this->description_12->TooltipValue = "";

			// production_site
			$this->production_site->LinkCustomAttributes = "";
			$this->production_site->HrefValue = "";
			$this->production_site->TooltipValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";
			$this->production_plan->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->HrefValue = "";
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
			$this->uploads->TooltipValue = "";

			// balance_quantity
			$this->balance_quantity->LinkCustomAttributes = "";
			$this->balance_quantity->HrefValue = "";
			$this->balance_quantity->TooltipValue = "";

			// e_mail
			$this->e_mail->LinkCustomAttributes = "";
			$this->e_mail->HrefValue = "";
			$this->e_mail->TooltipValue = "";

			// billing_address_id
			$this->billing_address_id->LinkCustomAttributes = "";
			$this->billing_address_id->HrefValue = "";
			$this->billing_address_id->TooltipValue = "";

			// shipping_address_id
			$this->shipping_address_id->LinkCustomAttributes = "";
			$this->shipping_address_id->HrefValue = "";
			$this->shipping_address_id->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->company_id->CurrentValue));
			if ($curVal <> "")
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			else
				$this->company_id->ViewValue = $this->company_id->Lookup !== NULL && is_array($this->company_id->Lookup->Options) ? $curVal : NULL;
			if ($this->company_id->ViewValue !== NULL) { // Load from cache
				$this->company_id->EditValue = array_values($this->company_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->company_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return User_Company_ID() == 0 ? "`status` = 1 and `category` = 1" : "id= ".  User_Company_ID() . "  and `status` = 1 and `category` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->company_id->EditValue = $arwrk;
			}

			// partner_id
			$this->partner_id->EditAttrs["class"] = "form-control";
			$this->partner_id->EditCustomAttributes = "";
			$this->partner_id->EditValue = HtmlEncode($this->partner_id->CurrentValue);
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `partner_type`=1 and `id` > 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->EditValue = HtmlEncode($this->partner_id->CurrentValue);
					}
				}
			} else {
				$this->partner_id->EditValue = NULL;
			}
			$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

			// copy
			$this->copy->EditAttrs["class"] = "form-control";
			$this->copy->EditCustomAttributes = "";
			$curVal = trim(strval($this->copy->CurrentValue));
			if ($curVal <> "")
				$this->copy->ViewValue = $this->copy->lookupCacheOption($curVal);
			else
				$this->copy->ViewValue = $this->copy->Lookup !== NULL && is_array($this->copy->Lookup->Options) ? $curVal : NULL;
			if ($this->copy->ViewValue !== NULL) { // Load from cache
				$this->copy->EditValue = array_values($this->copy->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->copy->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`po` = " . $_GET['OLDPO']. "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->copy->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->copy->EditValue = $arwrk;
			}

			// cart_id
			$this->cart_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->cart_id->CurrentValue));
			if ($curVal <> "")
				$this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
			else
				$this->cart_id->ViewValue = $this->cart_id->Lookup !== NULL && is_array($this->cart_id->Lookup->Options) ? $curVal : NULL;
			if ($this->cart_id->ViewValue !== NULL) { // Load from cache
				$this->cart_id->EditValue = array_values($this->cart_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` = NULL || `po_id` = '' || `po_id` = '0'" : "`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue;
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->cart_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, 0);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, 0);
				}
				$this->cart_id->EditValue = $arwrk;
			}

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = 'ReadOnly';
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
			if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
				$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = 'ReadOnly';
			$this->sqm->EditValue = HtmlEncode($this->sqm->CurrentValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
			if (strval($this->sqm->EditValue) <> "" && is_numeric($this->sqm->EditValue))
				$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, -2, -2, -2, -2);

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = 'ReadOnly';
			if (REMOVE_XSS)
				$this->amount->CurrentValue = HtmlDecode($this->amount->CurrentValue);
			$this->amount->EditValue = HtmlEncode($this->amount->CurrentValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

			// cbm
			$this->cbm->EditAttrs["class"] = "form-control";
			$this->cbm->EditCustomAttributes = 'ReadOnly';
			$this->cbm->EditValue = HtmlEncode($this->cbm->CurrentValue);
			$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
			if (strval($this->cbm->EditValue) <> "" && is_numeric($this->cbm->EditValue))
				$this->cbm->EditValue = FormatNumber($this->cbm->EditValue, -2, -2, -2, -2);

			// gst
			$this->gst->EditAttrs["class"] = "form-control";
			$this->gst->EditCustomAttributes = "";
			$curVal = trim(strval($this->gst->CurrentValue));
			if ($curVal <> "")
				$this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
			else
				$this->gst->ViewValue = $this->gst->Lookup !== NULL && is_array($this->gst->Lookup->Options) ? $curVal : NULL;
			if ($this->gst->ViewValue !== NULL) { // Load from cache
				$this->gst->EditValue = array_values($this->gst->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->gst->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->gst->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, -2);
				}
				$this->gst->EditValue = $arwrk;
			}

			// partner_order_no
			$this->partner_order_no->EditAttrs["class"] = "form-control";
			$this->partner_order_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->partner_order_no->CurrentValue = HtmlDecode($this->partner_order_no->CurrentValue);
			$this->partner_order_no->EditValue = HtmlEncode($this->partner_order_no->CurrentValue);
			$this->partner_order_no->PlaceHolder = RemoveHtml($this->partner_order_no->caption());

			// partner_order_date
			$this->partner_order_date->EditAttrs["class"] = "form-control";
			$this->partner_order_date->EditCustomAttributes = "";
			$this->partner_order_date->EditValue = HtmlEncode(FormatDateTime($this->partner_order_date->CurrentValue, 8));
			$this->partner_order_date->PlaceHolder = RemoveHtml($this->partner_order_date->caption());

			// despatch_date
			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = HtmlEncode(FormatDateTime($this->despatch_date->CurrentValue, 8));
			$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$curVal = trim(strval($this->despatch_week->CurrentValue));
			if ($curVal <> "")
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			else
				$this->despatch_week->ViewValue = $this->despatch_week->Lookup !== NULL && is_array($this->despatch_week->Lookup->Options) ? $curVal : NULL;
			if ($this->despatch_week->ViewValue !== NULL) { // Load from cache
				$this->despatch_week->EditValue = array_values($this->despatch_week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->despatch_week->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->despatch_week->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->despatch_week->EditValue = $arwrk;
			}

			// fob_date
			$this->fob_date->EditAttrs["class"] = "form-control";
			$this->fob_date->EditCustomAttributes = "";
			$this->fob_date->EditValue = HtmlEncode(FormatDateTime($this->fob_date->CurrentValue, 8));
			$this->fob_date->PlaceHolder = RemoveHtml($this->fob_date->caption());

			// part_dispatch
			$this->part_dispatch->EditAttrs["class"] = "form-control";
			$this->part_dispatch->EditCustomAttributes = "";
			$this->part_dispatch->EditValue = $this->part_dispatch->options(TRUE);

			// payment_terms
			$this->payment_terms->EditAttrs["class"] = "form-control";
			$this->payment_terms->EditCustomAttributes = "";
			$curVal = trim(strval($this->payment_terms->CurrentValue));
			if ($curVal <> "")
				$this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
			else
				$this->payment_terms->ViewValue = $this->payment_terms->Lookup !== NULL && is_array($this->payment_terms->Lookup->Options) ? $curVal : NULL;
			if ($this->payment_terms->ViewValue !== NULL) { // Load from cache
				$this->payment_terms->EditValue = array_values($this->payment_terms->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->payment_terms->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 81";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->payment_terms->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->payment_terms->EditValue = $arwrk;
			}

			// transport_type
			$this->transport_type->EditAttrs["class"] = "form-control";
			$this->transport_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->transport_type->CurrentValue));
			if ($curVal <> "")
				$this->transport_type->ViewValue = $this->transport_type->lookupCacheOption($curVal);
			else
				$this->transport_type->ViewValue = $this->transport_type->Lookup !== NULL && is_array($this->transport_type->Lookup->Options) ? $curVal : NULL;
			if ($this->transport_type->ViewValue !== NULL) { // Load from cache
				$this->transport_type->EditValue = array_values($this->transport_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->transport_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 82";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->transport_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->transport_type->EditValue = $arwrk;
			}

			// partner_shipping_id
			$this->partner_shipping_id->EditAttrs["class"] = "form-control";
			$this->partner_shipping_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->partner_shipping_id->CurrentValue));
			if ($curVal <> "")
				$this->partner_shipping_id->ViewValue = $this->partner_shipping_id->lookupCacheOption($curVal);
			else
				$this->partner_shipping_id->ViewValue = $this->partner_shipping_id->Lookup !== NULL && is_array($this->partner_shipping_id->Lookup->Options) ? $curVal : NULL;
			if ($this->partner_shipping_id->ViewValue !== NULL) { // Load from cache
				$this->partner_shipping_id->EditValue = array_values($this->partner_shipping_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->partner_shipping_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_shipping_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->partner_shipping_id->EditValue = $arwrk;
			}

			// description_01
			$this->description_01->EditAttrs["class"] = "form-control";
			$this->description_01->EditCustomAttributes = "";
			$this->description_01->EditValue = HtmlEncode($this->description_01->CurrentValue);
			$this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());
			if (strval($this->description_01->EditValue) <> "" && is_numeric($this->description_01->EditValue))
				$this->description_01->EditValue = FormatNumber($this->description_01->EditValue, -2, -2, -2, -2);

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// operator
			// datetime
			// jc_no

			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			$this->jc_no->EditValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewCustomAttributes = "";

			// buyer_instruction
			$this->buyer_instruction->EditAttrs["class"] = "form-control";
			$this->buyer_instruction->EditCustomAttributes = "";
			$this->buyer_instruction->EditValue = HtmlEncode($this->buyer_instruction->CurrentValue);
			$this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

			// d_09_head
			$this->d_09_head->EditAttrs["class"] = "form-control";
			$this->d_09_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_09_head->CurrentValue));
			if ($curVal <> "")
				$this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
			else
				$this->d_09_head->ViewValue = $this->d_09_head->Lookup !== NULL && is_array($this->d_09_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_09_head->ViewValue !== NULL) { // Load from cache
				$this->d_09_head->EditValue = array_values($this->d_09_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_09_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_09_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_09_head->EditValue = $arwrk;
			}

			// description_09
			$this->description_09->EditAttrs["class"] = "form-control";
			$this->description_09->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_09->CurrentValue = HtmlDecode($this->description_09->CurrentValue);
			$this->description_09->EditValue = HtmlEncode($this->description_09->CurrentValue);
			$this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

			// d_10_head
			$this->d_10_head->EditAttrs["class"] = "form-control";
			$this->d_10_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_10_head->CurrentValue));
			if ($curVal <> "")
				$this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
			else
				$this->d_10_head->ViewValue = $this->d_10_head->Lookup !== NULL && is_array($this->d_10_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_10_head->ViewValue !== NULL) { // Load from cache
				$this->d_10_head->EditValue = array_values($this->d_10_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_10_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_10_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_10_head->EditValue = $arwrk;
			}

			// description_10
			$this->description_10->EditAttrs["class"] = "form-control";
			$this->description_10->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_10->CurrentValue = HtmlDecode($this->description_10->CurrentValue);
			$this->description_10->EditValue = HtmlEncode($this->description_10->CurrentValue);
			$this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());

			// d_11_head
			$this->d_11_head->EditAttrs["class"] = "form-control";
			$this->d_11_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_11_head->CurrentValue));
			if ($curVal <> "")
				$this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
			else
				$this->d_11_head->ViewValue = $this->d_11_head->Lookup !== NULL && is_array($this->d_11_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_11_head->ViewValue !== NULL) { // Load from cache
				$this->d_11_head->EditValue = array_values($this->d_11_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_11_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_11_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_11_head->EditValue = $arwrk;
			}

			// description_11
			$this->description_11->EditAttrs["class"] = "form-control";
			$this->description_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_11->CurrentValue = HtmlDecode($this->description_11->CurrentValue);
			$this->description_11->EditValue = HtmlEncode($this->description_11->CurrentValue);
			$this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

			// d_12_head
			$this->d_12_head->EditAttrs["class"] = "form-control";
			$this->d_12_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_12_head->CurrentValue));
			if ($curVal <> "")
				$this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
			else
				$this->d_12_head->ViewValue = $this->d_12_head->Lookup !== NULL && is_array($this->d_12_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_12_head->ViewValue !== NULL) { // Load from cache
				$this->d_12_head->EditValue = array_values($this->d_12_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_12_head->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_12_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_12_head->EditValue = $arwrk;
			}

			// description_12
			$this->description_12->EditAttrs["class"] = "form-control";
			$this->description_12->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_12->CurrentValue = HtmlDecode($this->description_12->CurrentValue);
			$this->description_12->EditValue = HtmlEncode($this->description_12->CurrentValue);
			$this->description_12->PlaceHolder = RemoveHtml($this->description_12->caption());

			// production_site
			$this->production_site->EditAttrs["class"] = "form-control";
			$this->production_site->EditCustomAttributes = "";
			$curVal = strval($this->production_site->CurrentValue);
			if ($curVal <> "") {
				$this->production_site->EditValue = $this->production_site->lookupCacheOption($curVal);
				if ($this->production_site->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` IN (0,3)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->production_site->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->production_site->EditValue = $this->production_site->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->production_site->EditValue = $this->production_site->CurrentValue;
					}
				}
			} else {
				$this->production_site->EditValue = NULL;
			}
			$this->production_site->ViewCustomAttributes = "";

			// production_plan
			$this->production_plan->EditAttrs["class"] = "form-control";
			$this->production_plan->EditCustomAttributes = "";
			$this->production_plan->EditValue = $this->production_plan->options(TRUE);

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			$this->uploads->UploadPath = '/.p_uploads/pppo/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->EditValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->EditValue = "";
			}
			if (!EmptyValue($this->uploads->CurrentValue))
					$this->uploads->Upload->FileName = $this->uploads->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->uploads);

			// balance_quantity
			$this->balance_quantity->EditAttrs["class"] = "form-control";
			$this->balance_quantity->EditCustomAttributes = "";
			$this->balance_quantity->EditValue = HtmlEncode($this->balance_quantity->CurrentValue);
			$this->balance_quantity->PlaceHolder = RemoveHtml($this->balance_quantity->caption());
			if (strval($this->balance_quantity->EditValue) <> "" && is_numeric($this->balance_quantity->EditValue))
				$this->balance_quantity->EditValue = FormatNumber($this->balance_quantity->EditValue, -2, -2, -2, -2);

			// e_mail
			$this->e_mail->EditAttrs["class"] = "form-control";
			$this->e_mail->EditCustomAttributes = "";
			$this->e_mail->EditValue = HtmlEncode($this->e_mail->CurrentValue);
			$this->e_mail->PlaceHolder = RemoveHtml($this->e_mail->caption());

			// billing_address_id
			$this->billing_address_id->EditAttrs["class"] = "form-control";
			$this->billing_address_id->EditCustomAttributes = "";
			$this->billing_address_id->EditValue = HtmlEncode($this->billing_address_id->CurrentValue);
			$this->billing_address_id->PlaceHolder = RemoveHtml($this->billing_address_id->caption());

			// shipping_address_id
			$this->shipping_address_id->EditAttrs["class"] = "form-control";
			$this->shipping_address_id->EditCustomAttributes = "";
			$this->shipping_address_id->EditValue = HtmlEncode($this->shipping_address_id->CurrentValue);
			$this->shipping_address_id->PlaceHolder = RemoveHtml($this->shipping_address_id->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = HtmlEncode($this->status->CurrentValue);
			$this->status->PlaceHolder = RemoveHtml($this->status->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			if (!EmptyValue($this->po->CurrentValue)) {
				$this->po->HrefValue = "po_clist.php?x_po=" . $this->po->CurrentValue; // Add prefix/suffix
				$this->po->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
			} else {
				$this->po->HrefValue = "";
			}
			$this->po->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->partner_id->CurrentValue)) {
				$this->partner_id->HrefValue = "po_blist.php?x_partner_id=" . $this->partner_id->CurrentValue; // Add prefix/suffix
				$this->partner_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
			} else {
				$this->partner_id->HrefValue = "";
			}

			// copy
			$this->copy->LinkCustomAttributes = "";
			$this->copy->HrefValue = "";

			// cart_id
			$this->cart_id->LinkCustomAttributes = "";
			$this->cart_id->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";

			// gst
			$this->gst->LinkCustomAttributes = "";
			$this->gst->HrefValue = "";

			// partner_order_no
			$this->partner_order_no->LinkCustomAttributes = "";
			$this->partner_order_no->HrefValue = "";

			// partner_order_date
			$this->partner_order_date->LinkCustomAttributes = "";
			$this->partner_order_date->HrefValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";

			// fob_date
			$this->fob_date->LinkCustomAttributes = "";
			$this->fob_date->HrefValue = "";

			// part_dispatch
			$this->part_dispatch->LinkCustomAttributes = "";
			if (!EmptyValue($this->part_dispatch->CurrentValue)) {
				$this->part_dispatch->HrefValue = "po_blist.php?x_part_dispatch=" . $this->part_dispatch->CurrentValue; // Add prefix/suffix
				$this->part_dispatch->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->part_dispatch->HrefValue = FullUrl($this->part_dispatch->HrefValue, "href");
			} else {
				$this->part_dispatch->HrefValue = "";
			}

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			if (!EmptyValue($this->payment_terms->CurrentValue)) {
				$this->payment_terms->HrefValue = "po_blist.php?x_payment_terms=" . $this->payment_terms->CurrentValue; // Add prefix/suffix
				$this->payment_terms->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->payment_terms->HrefValue = FullUrl($this->payment_terms->HrefValue, "href");
			} else {
				$this->payment_terms->HrefValue = "";
			}

			// transport_type
			$this->transport_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->transport_type->CurrentValue)) {
				$this->transport_type->HrefValue = "po_blist.php?x_transport_type=" . $this->transport_type->CurrentValue; // Add prefix/suffix
				$this->transport_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->transport_type->HrefValue = FullUrl($this->transport_type->HrefValue, "href");
			} else {
				$this->transport_type->HrefValue = "";
			}

			// partner_shipping_id
			$this->partner_shipping_id->LinkCustomAttributes = "";
			$this->partner_shipping_id->HrefValue = "";

			// description_01
			$this->description_01->LinkCustomAttributes = "";
			$this->description_01->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// buyer_instruction
			$this->buyer_instruction->LinkCustomAttributes = "";
			$this->buyer_instruction->HrefValue = "";

			// d_09_head
			$this->d_09_head->LinkCustomAttributes = "";
			$this->d_09_head->HrefValue = "";

			// description_09
			$this->description_09->LinkCustomAttributes = "";
			$this->description_09->HrefValue = "";

			// d_10_head
			$this->d_10_head->LinkCustomAttributes = "";
			$this->d_10_head->HrefValue = "";

			// description_10
			$this->description_10->LinkCustomAttributes = "";
			$this->description_10->HrefValue = "";

			// d_11_head
			$this->d_11_head->LinkCustomAttributes = "";
			$this->d_11_head->HrefValue = "";

			// description_11
			$this->description_11->LinkCustomAttributes = "";
			$this->description_11->HrefValue = "";

			// d_12_head
			$this->d_12_head->LinkCustomAttributes = "";
			$this->d_12_head->HrefValue = "";

			// description_12
			$this->description_12->LinkCustomAttributes = "";
			$this->description_12->HrefValue = "";

			// production_site
			$this->production_site->LinkCustomAttributes = "";
			$this->production_site->HrefValue = "";
			$this->production_site->TooltipValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->HrefValue = "";
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

			// balance_quantity
			$this->balance_quantity->LinkCustomAttributes = "";
			$this->balance_quantity->HrefValue = "";

			// e_mail
			$this->e_mail->LinkCustomAttributes = "";
			$this->e_mail->HrefValue = "";

			// billing_address_id
			$this->billing_address_id->LinkCustomAttributes = "";
			$this->billing_address_id->HrefValue = "";

			// shipping_address_id
			$this->shipping_address_id->LinkCustomAttributes = "";
			$this->shipping_address_id->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->po->Required) {
			if (!$this->po->IsDetailKey && $this->po->FormValue != NULL && $this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if ($this->partner_id->Required) {
			if (!$this->partner_id->IsDetailKey && $this->partner_id->FormValue != NULL && $this->partner_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if ($this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->location->Required) {
			if (!$this->location->IsDetailKey && $this->location->FormValue != NULL && $this->location->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
			}
		}
		if ($this->copy->Required) {
			if (!$this->copy->IsDetailKey && $this->copy->FormValue != NULL && $this->copy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->copy->caption(), $this->copy->RequiredErrorMessage));
			}
		}
		if ($this->cart_id->Required) {
			if ($this->cart_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cart_id->caption(), $this->cart_id->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if ($this->sqm->Required) {
			if (!$this->sqm->IsDetailKey && $this->sqm->FormValue != NULL && $this->sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->sqm->FormValue)) {
			AddMessage($FormError, $this->sqm->errorMessage());
		}
		if ($this->amount->Required) {
			if (!$this->amount->IsDetailKey && $this->amount->FormValue != NULL && $this->amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
			}
		}
		if ($this->cbm->Required) {
			if (!$this->cbm->IsDetailKey && $this->cbm->FormValue != NULL && $this->cbm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->cbm->FormValue)) {
			AddMessage($FormError, $this->cbm->errorMessage());
		}
		if ($this->gst->Required) {
			if (!$this->gst->IsDetailKey && $this->gst->FormValue != NULL && $this->gst->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gst->caption(), $this->gst->RequiredErrorMessage));
			}
		}
		if ($this->partner_order_no->Required) {
			if (!$this->partner_order_no->IsDetailKey && $this->partner_order_no->FormValue != NULL && $this->partner_order_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_order_no->caption(), $this->partner_order_no->RequiredErrorMessage));
			}
		}
		if ($this->partner_order_date->Required) {
			if (!$this->partner_order_date->IsDetailKey && $this->partner_order_date->FormValue != NULL && $this->partner_order_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_order_date->caption(), $this->partner_order_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->partner_order_date->FormValue)) {
			AddMessage($FormError, $this->partner_order_date->errorMessage());
		}
		if ($this->despatch_date->Required) {
			if (!$this->despatch_date->IsDetailKey && $this->despatch_date->FormValue != NULL && $this->despatch_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->despatch_date->FormValue)) {
			AddMessage($FormError, $this->despatch_date->errorMessage());
		}
		if ($this->despatch_week->Required) {
			if (!$this->despatch_week->IsDetailKey && $this->despatch_week->FormValue != NULL && $this->despatch_week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
			}
		}
		if ($this->fob_date->Required) {
			if (!$this->fob_date->IsDetailKey && $this->fob_date->FormValue != NULL && $this->fob_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fob_date->caption(), $this->fob_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->fob_date->FormValue)) {
			AddMessage($FormError, $this->fob_date->errorMessage());
		}
		if ($this->part_dispatch->Required) {
			if (!$this->part_dispatch->IsDetailKey && $this->part_dispatch->FormValue != NULL && $this->part_dispatch->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->part_dispatch->caption(), $this->part_dispatch->RequiredErrorMessage));
			}
		}
		if ($this->payment_terms->Required) {
			if (!$this->payment_terms->IsDetailKey && $this->payment_terms->FormValue != NULL && $this->payment_terms->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment_terms->caption(), $this->payment_terms->RequiredErrorMessage));
			}
		}
		if ($this->transport_type->Required) {
			if (!$this->transport_type->IsDetailKey && $this->transport_type->FormValue != NULL && $this->transport_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->transport_type->caption(), $this->transport_type->RequiredErrorMessage));
			}
		}
		if ($this->partner_shipping_id->Required) {
			if (!$this->partner_shipping_id->IsDetailKey && $this->partner_shipping_id->FormValue != NULL && $this->partner_shipping_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_shipping_id->caption(), $this->partner_shipping_id->RequiredErrorMessage));
			}
		}
		if ($this->description_04->Required) {
			if (!$this->description_04->IsDetailKey && $this->description_04->FormValue != NULL && $this->description_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_04->caption(), $this->description_04->RequiredErrorMessage));
			}
		}
		if ($this->description_03->Required) {
			if (!$this->description_03->IsDetailKey && $this->description_03->FormValue != NULL && $this->description_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_03->caption(), $this->description_03->RequiredErrorMessage));
			}
		}
		if ($this->description_20->Required) {
			if (!$this->description_20->IsDetailKey && $this->description_20->FormValue != NULL && $this->description_20->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_20->caption(), $this->description_20->RequiredErrorMessage));
			}
		}
		if ($this->description_01->Required) {
			if (!$this->description_01->IsDetailKey && $this->description_01->FormValue != NULL && $this->description_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_01->caption(), $this->description_01->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->description_01->FormValue)) {
			AddMessage($FormError, $this->description_01->errorMessage());
		}
		if ($this->description_02->Required) {
			if (!$this->description_02->IsDetailKey && $this->description_02->FormValue != NULL && $this->description_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_02->caption(), $this->description_02->RequiredErrorMessage));
			}
		}
		if ($this->description_07->Required) {
			if (!$this->description_07->IsDetailKey && $this->description_07->FormValue != NULL && $this->description_07->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_07->caption(), $this->description_07->RequiredErrorMessage));
			}
		}
		if ($this->description_17->Required) {
			if (!$this->description_17->IsDetailKey && $this->description_17->FormValue != NULL && $this->description_17->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_17->caption(), $this->description_17->RequiredErrorMessage));
			}
		}
		if ($this->description_18->Required) {
			if (!$this->description_18->IsDetailKey && $this->description_18->FormValue != NULL && $this->description_18->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_18->caption(), $this->description_18->RequiredErrorMessage));
			}
		}
		if ($this->description_19->Required) {
			if (!$this->description_19->IsDetailKey && $this->description_19->FormValue != NULL && $this->description_19->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_19->caption(), $this->description_19->RequiredErrorMessage));
			}
		}
		if ($this->description_05->Required) {
			if (!$this->description_05->IsDetailKey && $this->description_05->FormValue != NULL && $this->description_05->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_05->caption(), $this->description_05->RequiredErrorMessage));
			}
		}
		if ($this->description_06->Required) {
			if (!$this->description_06->IsDetailKey && $this->description_06->FormValue != NULL && $this->description_06->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_06->caption(), $this->description_06->RequiredErrorMessage));
			}
		}
		if ($this->description_08->Required) {
			if (!$this->description_08->IsDetailKey && $this->description_08->FormValue != NULL && $this->description_08->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_08->caption(), $this->description_08->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->a_operator->Required) {
			if (!$this->a_operator->IsDetailKey && $this->a_operator->FormValue != NULL && $this->a_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_operator->caption(), $this->a_operator->RequiredErrorMessage));
			}
		}
		if ($this->a_datetime->Required) {
			if (!$this->a_datetime->IsDetailKey && $this->a_datetime->FormValue != NULL && $this->a_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_datetime->caption(), $this->a_datetime->RequiredErrorMessage));
			}
		}
		if ($this->jc_no->Required) {
			if (!$this->jc_no->IsDetailKey && $this->jc_no->FormValue != NULL && $this->jc_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
			}
		}
		if ($this->buyer_instruction->Required) {
			if (!$this->buyer_instruction->IsDetailKey && $this->buyer_instruction->FormValue != NULL && $this->buyer_instruction->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_instruction->caption(), $this->buyer_instruction->RequiredErrorMessage));
			}
		}
		if ($this->d_09_head->Required) {
			if (!$this->d_09_head->IsDetailKey && $this->d_09_head->FormValue != NULL && $this->d_09_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_09_head->caption(), $this->d_09_head->RequiredErrorMessage));
			}
		}
		if ($this->description_09->Required) {
			if (!$this->description_09->IsDetailKey && $this->description_09->FormValue != NULL && $this->description_09->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_09->caption(), $this->description_09->RequiredErrorMessage));
			}
		}
		if ($this->d_10_head->Required) {
			if (!$this->d_10_head->IsDetailKey && $this->d_10_head->FormValue != NULL && $this->d_10_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_10_head->caption(), $this->d_10_head->RequiredErrorMessage));
			}
		}
		if ($this->description_10->Required) {
			if (!$this->description_10->IsDetailKey && $this->description_10->FormValue != NULL && $this->description_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_10->caption(), $this->description_10->RequiredErrorMessage));
			}
		}
		if ($this->d_11_head->Required) {
			if (!$this->d_11_head->IsDetailKey && $this->d_11_head->FormValue != NULL && $this->d_11_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_11_head->caption(), $this->d_11_head->RequiredErrorMessage));
			}
		}
		if ($this->description_11->Required) {
			if (!$this->description_11->IsDetailKey && $this->description_11->FormValue != NULL && $this->description_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_11->caption(), $this->description_11->RequiredErrorMessage));
			}
		}
		if ($this->d_12_head->Required) {
			if (!$this->d_12_head->IsDetailKey && $this->d_12_head->FormValue != NULL && $this->d_12_head->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_12_head->caption(), $this->d_12_head->RequiredErrorMessage));
			}
		}
		if ($this->description_12->Required) {
			if (!$this->description_12->IsDetailKey && $this->description_12->FormValue != NULL && $this->description_12->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_12->caption(), $this->description_12->RequiredErrorMessage));
			}
		}
		if ($this->production_site->Required) {
			if (!$this->production_site->IsDetailKey && $this->production_site->FormValue != NULL && $this->production_site->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_site->caption(), $this->production_site->RequiredErrorMessage));
			}
		}
		if ($this->__request->Required) {
			if (!$this->__request->IsDetailKey && $this->__request->FormValue != NULL && $this->__request->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->__request->caption(), $this->__request->RequiredErrorMessage));
			}
		}
		if ($this->production_plan->Required) {
			if (!$this->production_plan->IsDetailKey && $this->production_plan->FormValue != NULL && $this->production_plan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_plan->caption(), $this->production_plan->RequiredErrorMessage));
			}
		}
		if ($this->uploads->Required) {
			if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
			}
		}
		if ($this->balance_quantity->Required) {
			if (!$this->balance_quantity->IsDetailKey && $this->balance_quantity->FormValue != NULL && $this->balance_quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->balance_quantity->caption(), $this->balance_quantity->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->balance_quantity->FormValue)) {
			AddMessage($FormError, $this->balance_quantity->errorMessage());
		}
		if ($this->e_mail->Required) {
			if (!$this->e_mail->IsDetailKey && $this->e_mail->FormValue != NULL && $this->e_mail->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->e_mail->caption(), $this->e_mail->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->e_mail->FormValue)) {
			AddMessage($FormError, $this->e_mail->errorMessage());
		}
		if ($this->billing_address_id->Required) {
			if (!$this->billing_address_id->IsDetailKey && $this->billing_address_id->FormValue != NULL && $this->billing_address_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->billing_address_id->caption(), $this->billing_address_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->billing_address_id->FormValue)) {
			AddMessage($FormError, $this->billing_address_id->errorMessage());
		}
		if ($this->shipping_address_id->Required) {
			if (!$this->shipping_address_id->IsDetailKey && $this->shipping_address_id->FormValue != NULL && $this->shipping_address_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_address_id->caption(), $this->shipping_address_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->shipping_address_id->FormValue)) {
			AddMessage($FormError, $this->shipping_address_id->errorMessage());
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->status->FormValue)) {
			AddMessage($FormError, $this->status->errorMessage());
		}
		if ($this->app_operator->Required) {
			if (!$this->app_operator->IsDetailKey && $this->app_operator->FormValue != NULL && $this->app_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->app_operator->caption(), $this->app_operator->RequiredErrorMessage));
			}
		}
		if ($this->app_datetime->Required) {
			if (!$this->app_datetime->IsDetailKey && $this->app_datetime->FormValue != NULL && $this->app_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->app_datetime->caption(), $this->app_datetime->RequiredErrorMessage));
			}
		}
		if ($this->reports_to->Required) {
			if (!$this->reports_to->IsDetailKey && $this->reports_to->FormValue != NULL && $this->reports_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
			}
		}
		if ($this->c_operator->Required) {
			if (!$this->c_operator->IsDetailKey && $this->c_operator->FormValue != NULL && $this->c_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->c_operator->caption(), $this->c_operator->RequiredErrorMessage));
			}
		}
		if ($this->c_datetime->Required) {
			if (!$this->c_datetime->IsDetailKey && $this->c_datetime->FormValue != NULL && $this->c_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->c_datetime->caption(), $this->c_datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		if ($this->po->CurrentValue <> "") { // Check field with unique index
			$filterChk = "(`po` = " . AdjustSql($this->po->CurrentValue, $this->Dbid) . ")";
			$filterChk .= " AND NOT (" . $filter . ")";
			$this->CurrentFilter = $filterChk;
			$sqlChk = $this->getCurrentSql();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rsChk = $conn->Execute($sqlChk);
			$conn->raiseErrorFn = '';
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->po->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->po->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
			$rsChk->close();
		}
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$this->uploads->OldUploadPath = '/.p_uploads/pppo/' . $this->id->CurrentValue . '/' ;
			$this->uploads->UploadPath = $this->uploads->OldUploadPath;
			$rsnew = [];

			// company_id
			$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, NULL, $this->company_id->ReadOnly);

			// partner_id
			$this->partner_id->setDbValueDef($rsnew, $this->partner_id->CurrentValue, NULL, $this->partner_id->ReadOnly);

			// copy
			$this->copy->setDbValueDef($rsnew, $this->copy->CurrentValue, 0, $this->copy->ReadOnly);

			// cart_id
			$this->cart_id->setDbValueDef($rsnew, $this->cart_id->CurrentValue, NULL, $this->cart_id->ReadOnly);

			// quantity
			$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, NULL, $this->quantity->ReadOnly);

			// sqm
			$this->sqm->setDbValueDef($rsnew, $this->sqm->CurrentValue, 0, $this->sqm->ReadOnly);

			// amount
			$this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, "", $this->amount->ReadOnly);

			// cbm
			$this->cbm->setDbValueDef($rsnew, $this->cbm->CurrentValue, 0, $this->cbm->ReadOnly);

			// gst
			$this->gst->setDbValueDef($rsnew, $this->gst->CurrentValue, 0, $this->gst->ReadOnly);

			// partner_order_no
			$this->partner_order_no->setDbValueDef($rsnew, $this->partner_order_no->CurrentValue, NULL, $this->partner_order_no->ReadOnly);

			// partner_order_date
			$this->partner_order_date->setDbValueDef($rsnew, UnFormatDateTime($this->partner_order_date->CurrentValue, 0), NULL, $this->partner_order_date->ReadOnly);

			// despatch_date
			$this->despatch_date->setDbValueDef($rsnew, UnFormatDateTime($this->despatch_date->CurrentValue, 0), NULL, $this->despatch_date->ReadOnly);

			// despatch_week
			$this->despatch_week->setDbValueDef($rsnew, $this->despatch_week->CurrentValue, NULL, $this->despatch_week->ReadOnly);

			// fob_date
			$this->fob_date->setDbValueDef($rsnew, UnFormatDateTime($this->fob_date->CurrentValue, 0), NULL, $this->fob_date->ReadOnly);

			// part_dispatch
			$this->part_dispatch->setDbValueDef($rsnew, $this->part_dispatch->CurrentValue, NULL, $this->part_dispatch->ReadOnly);

			// payment_terms
			$this->payment_terms->setDbValueDef($rsnew, $this->payment_terms->CurrentValue, NULL, $this->payment_terms->ReadOnly);

			// transport_type
			$this->transport_type->setDbValueDef($rsnew, $this->transport_type->CurrentValue, NULL, $this->transport_type->ReadOnly);

			// partner_shipping_id
			$this->partner_shipping_id->setDbValueDef($rsnew, $this->partner_shipping_id->CurrentValue, NULL, $this->partner_shipping_id->ReadOnly);

			// description_01
			$this->description_01->setDbValueDef($rsnew, $this->description_01->CurrentValue, NULL, $this->description_01->ReadOnly);

			// remarks
			$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, $this->remarks->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// buyer_instruction
			$this->buyer_instruction->setDbValueDef($rsnew, $this->buyer_instruction->CurrentValue, NULL, $this->buyer_instruction->ReadOnly);

			// d_09_head
			$this->d_09_head->setDbValueDef($rsnew, $this->d_09_head->CurrentValue, NULL, $this->d_09_head->ReadOnly);

			// description_09
			$this->description_09->setDbValueDef($rsnew, $this->description_09->CurrentValue, NULL, $this->description_09->ReadOnly);

			// d_10_head
			$this->d_10_head->setDbValueDef($rsnew, $this->d_10_head->CurrentValue, NULL, $this->d_10_head->ReadOnly);

			// description_10
			$this->description_10->setDbValueDef($rsnew, $this->description_10->CurrentValue, NULL, $this->description_10->ReadOnly);

			// d_11_head
			$this->d_11_head->setDbValueDef($rsnew, $this->d_11_head->CurrentValue, NULL, $this->d_11_head->ReadOnly);

			// description_11
			$this->description_11->setDbValueDef($rsnew, $this->description_11->CurrentValue, NULL, $this->description_11->ReadOnly);

			// d_12_head
			$this->d_12_head->setDbValueDef($rsnew, $this->d_12_head->CurrentValue, NULL, $this->d_12_head->ReadOnly);

			// description_12
			$this->description_12->setDbValueDef($rsnew, $this->description_12->CurrentValue, NULL, $this->description_12->ReadOnly);

			// production_plan
			$this->production_plan->setDbValueDef($rsnew, $this->production_plan->CurrentValue, NULL, $this->production_plan->ReadOnly);

			// uploads
			if ($this->uploads->Visible && !$this->uploads->ReadOnly && !$this->uploads->Upload->KeepFile) {
				$this->uploads->Upload->DbValue = $rsold['uploads']; // Get original value
				if ($this->uploads->Upload->FileName == "") {
					$rsnew['uploads'] = NULL;
				} else {
					$rsnew['uploads'] = $this->uploads->Upload->FileName;
				}
				$this->uploads->ImageWidth = 640; // Resize width
				$this->uploads->ImageHeight = 640; // Resize height
			}

			// balance_quantity
			$this->balance_quantity->setDbValueDef($rsnew, $this->balance_quantity->CurrentValue, NULL, $this->balance_quantity->ReadOnly);

			// e_mail
			$this->e_mail->setDbValueDef($rsnew, $this->e_mail->CurrentValue, 0, $this->e_mail->ReadOnly);

			// billing_address_id
			$this->billing_address_id->setDbValueDef($rsnew, $this->billing_address_id->CurrentValue, NULL, $this->billing_address_id->ReadOnly);

			// shipping_address_id
			$this->shipping_address_id->setDbValueDef($rsnew, $this->shipping_address_id->CurrentValue, NULL, $this->shipping_address_id->ReadOnly);

			// status
			$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, 0, $this->status->ReadOnly);
			if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
				$this->uploads->UploadPath = '/.p_uploads/pppo/' . $this->id->CurrentValue . '/' ;
				$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : array($this->uploads->Upload->DbValue);
				if (!EmptyValue($this->uploads->Upload->FileName)) {
					$newFiles = array($this->uploads->Upload->FileName);
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1) || file_exists($this->uploads->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file, UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->uploads->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->uploads->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, NULL, $this->uploads->ReadOnly);
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
					if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : array($this->uploads->Upload->DbValue);
						if (!EmptyValue($this->uploads->Upload->FileName)) {
							$newFiles = array($this->uploads->Upload->FileName);
							$newFiles2 = array($rsnew['uploads']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->uploads->Upload->resizeAndSaveToFile($this->uploads->ImageWidth, $this->uploads->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// uploads
		if ($this->uploads->Upload->FileToken <> "")
			CleanUploadTempPath($this->uploads->Upload->FileToken, $this->uploads->Upload->Index);
		else
			CleanUploadTempPath($this->uploads, $this->uploads->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("po_slist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return User_Company_ID() == 0 ? "`status` = 1 and `category` = 1" : "id= ".  User_Company_ID() . "  and `status` = 1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_id":
					$lookupFilter = function() {
						return "`status`=1 and `partner_type`=1 and `id` > 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_location":
					$lookupFilter = function() {
						return ((CurrentPageID() == "add") || (CurrentPageID() == "edit")) ? (User_Site() == 0) ? "" : "FIND_IN_SET(`id`," . User_Site() . ")" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_copy":
					$lookupFilter = function() {
						return "`po` = " . $_GET['OLDPO']. "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_cart_id":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` = NULL || `po_id` = '' || `po_id` = '0'" : "`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue;
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_gst":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_despatch_week":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_payment_terms":
					$lookupFilter = function() {
						return "`grp` = 81";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_transport_type":
					$lookupFilter = function() {
						return "`grp` = 82";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_shipping_id":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_05":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_06":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_production_site":
					$lookupFilter = function() {
						return "`grp` IN (0,3)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_partner_id":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_location":
							break;
						case "x_copy":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_cart_id":
							$row[3] = FormatNumber($row[3], 2, -2, -2, 0);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, 0);
							$row['df4'] = $row[4];
							break;
						case "x_gst":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							break;
						case "x_despatch_week":
							break;
						case "x_payment_terms":
							break;
						case "x_transport_type":
							break;
						case "x_partner_shipping_id":
							break;
						case "x_description_05":
							break;
						case "x_description_06":
							break;
						case "x_operator":
							break;
						case "x_a_operator":
							break;
						case "x_d_09_head":
							break;
						case "x_d_10_head":
							break;
						case "x_d_11_head":
							break;
						case "x_d_12_head":
							break;
						case "x_production_site":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'po_s');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>