<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for po_s_pending
 */
class po_s_pending extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $cart_id;
	public $po_id;
	public $company_id;
	public $partner_id;
	public $partner_order_no;
	public $remarks;
	public $grp;
	public $s_grp;
	public $product;
	public $ref;
	public $product_code;
	public $order_quantity;
	public $purchase;
	public $pending_qty;
	public $order_date;
	public $despatch_date;
	public $avg_quantity;
	public $packing_type;
	public $status;
	public $p_id;
	public $partner_name;
	public $p_qty;
	public $p_remarks;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'po_s_pending';
		$this->TableName = 'po_s_pending';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`po_s_pending`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// cart_id
		$this->cart_id = new DbField('po_s_pending', 'po_s_pending', 'x_cart_id', 'cart_id', '`cart_id`', '`cart_id`', 19, -1, FALSE, '`cart_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cart_id->IsPrimaryKey = TRUE; // Primary key field
		$this->cart_id->Nullable = FALSE; // NOT NULL field
		$this->cart_id->Required = TRUE; // Required field
		$this->cart_id->Sortable = TRUE; // Allow sort
		$this->cart_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['cart_id'] = &$this->cart_id;

		// po_id
		$this->po_id = new DbField('po_s_pending', 'po_s_pending', 'x_po_id', 'po_id', '`po_id`', '`po_id`', 18, -1, FALSE, '`po_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->po_id->Required = TRUE; // Required field
		$this->po_id->Sortable = TRUE; // Allow sort
		$this->po_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->po_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->po_id->Lookup = new Lookup('po_id', 'po_s', FALSE, 'id', ["po","","",""], [], [], [], [], [], [], '`po` ASC', '');
		$this->po_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_id'] = &$this->po_id;

		// company_id
		$this->company_id = new DbField('po_s_pending', 'po_s_pending', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 19, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->company_id->Lookup = new Lookup('company_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// partner_id
		$this->partner_id = new DbField('po_s_pending', 'po_s_pending', 'x_partner_id', 'partner_id', '`partner_id`', '`partner_id`', 19, -1, FALSE, '`EV__partner_id`', TRUE, FALSE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_id->Required = TRUE; // Required field
		$this->partner_id->Sortable = TRUE; // Allow sort
		$this->partner_id->Lookup = new Lookup('partner_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['partner_id'] = &$this->partner_id;

		// partner_order_no
		$this->partner_order_no = new DbField('po_s_pending', 'po_s_pending', 'x_partner_order_no', 'partner_order_no', '`partner_order_no`', '`partner_order_no`', 200, -1, FALSE, '`partner_order_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_order_no->Sortable = TRUE; // Allow sort
		$this->fields['partner_order_no'] = &$this->partner_order_no;

		// remarks
		$this->remarks = new DbField('po_s_pending', 'po_s_pending', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// grp
		$this->grp = new DbField('po_s_pending', 'po_s_pending', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], [], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('po_s_pending', 'po_s_pending', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Sortable = FALSE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], [], [], [], [], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('po_s_pending', 'po_s_pending', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', 'product', FALSE, 'id', ["product","","",""], [], [], [], [], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// ref
		$this->ref = new DbField('po_s_pending', 'po_s_pending', 'x_ref', 'ref', '`ref`', '`ref`', 18, -1, FALSE, '`EV__ref`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->ref->Sortable = TRUE; // Allow sort
		$this->ref->Lookup = new Lookup('ref', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->fields['ref'] = &$this->ref;

		// product_code
		$this->product_code = new DbField('po_s_pending', 'po_s_pending', 'x_product_code', 'product_code', '`product_code`', '`product_code`', 201, -1, FALSE, '`product_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_code->Sortable = TRUE; // Allow sort
		$this->fields['product_code'] = &$this->product_code;

		// order_quantity
		$this->order_quantity = new DbField('po_s_pending', 'po_s_pending', 'x_order_quantity', 'order_quantity', '`order_quantity`', '`order_quantity`', 131, -1, FALSE, '`order_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->order_quantity->Nullable = FALSE; // NOT NULL field
		$this->order_quantity->Required = TRUE; // Required field
		$this->order_quantity->Sortable = TRUE; // Allow sort
		$this->order_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['order_quantity'] = &$this->order_quantity;

		// purchase
		$this->purchase = new DbField('po_s_pending', 'po_s_pending', 'x_purchase', 'purchase', '`purchase`', '`purchase`', 131, -1, FALSE, '`purchase`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->purchase->Nullable = FALSE; // NOT NULL field
		$this->purchase->Sortable = TRUE; // Allow sort
		$this->purchase->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['purchase'] = &$this->purchase;

		// pending_qty
		$this->pending_qty = new DbField('po_s_pending', 'po_s_pending', 'x_pending_qty', 'pending_qty', '`pending_qty`', '`pending_qty`', 131, -1, FALSE, '`pending_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pending_qty->Nullable = FALSE; // NOT NULL field
		$this->pending_qty->Required = TRUE; // Required field
		$this->pending_qty->Sortable = TRUE; // Allow sort
		$this->pending_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['pending_qty'] = &$this->pending_qty;

		// order_date
		$this->order_date = new DbField('po_s_pending', 'po_s_pending', 'x_order_date', 'order_date', '`order_date`', CastDateFieldForLike('`order_date`', 0, "DB"), 135, 0, FALSE, '`order_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->order_date->Sortable = TRUE; // Allow sort
		$this->order_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['order_date'] = &$this->order_date;

		// despatch_date
		$this->despatch_date = new DbField('po_s_pending', 'po_s_pending', 'x_despatch_date', 'despatch_date', '`despatch_date`', CastDateFieldForLike('`despatch_date`', 7, "DB"), 133, 7, FALSE, '`despatch_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->despatch_date->Sortable = TRUE; // Allow sort
		$this->despatch_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['despatch_date'] = &$this->despatch_date;

		// avg_quantity
		$this->avg_quantity = new DbField('po_s_pending', 'po_s_pending', 'x_avg_quantity', 'avg_quantity', '`avg_quantity`', '`avg_quantity`', 18, -1, FALSE, '`avg_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->avg_quantity->Sortable = TRUE; // Allow sort
		$this->avg_quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['avg_quantity'] = &$this->avg_quantity;

		// packing_type
		$this->packing_type = new DbField('po_s_pending', 'po_s_pending', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 18, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->packing_type->Lookup = new Lookup('packing_type', 'packing_type_table', FALSE, 'id', ["packing","code","",""], [], [], [], [], [], [], '`packing` ASC', '');
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// status
		$this->status = new DbField('po_s_pending', 'po_s_pending', 'x_status', 'status', '`status`', '`status`', 16, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// p_id
		$this->p_id = new DbField('po_s_pending', 'po_s_pending', 'x_p_id', 'p_id', '`p_id`', '`p_id`', 200, -1, FALSE, '`p_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->p_id->Sortable = FALSE; // Allow sort
		$this->fields['p_id'] = &$this->p_id;

		// partner_name
		$this->partner_name = new DbField('po_s_pending', 'po_s_pending', 'x_partner_name', 'partner_name', '`partner_name`', '`partner_name`', 200, -1, FALSE, '`partner_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_name->Sortable = FALSE; // Allow sort
		$this->fields['partner_name'] = &$this->partner_name;

		// p_qty
		$this->p_qty = new DbField('po_s_pending', 'po_s_pending', 'x_p_qty', 'p_qty', '`p_qty`', '`p_qty`', 131, -1, FALSE, '`p_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->p_qty->Nullable = FALSE; // NOT NULL field
		$this->p_qty->Sortable = TRUE; // Allow sort
		$this->p_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['p_qty'] = &$this->p_qty;

		// p_remarks
		$this->p_remarks = new DbField('po_s_pending', 'po_s_pending', 'x_p_remarks', 'p_remarks', '`p_remarks`', '`p_remarks`', 201, -1, FALSE, '`p_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->p_remarks->Sortable = TRUE; // Allow sort
		$this->fields['p_remarks'] = &$this->p_remarks;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`po_s_pending`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `name` FROM `buyer_seller_view` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `po_s_pending`.`partner_id` LIMIT 1) AS `EV__partner_id`, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `po_s_pending`.`ref` LIMIT 1) AS `EV__ref` FROM `po_s_pending`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->partner_id->AdvancedSearch->SearchValue <> "" ||
			$this->partner_id->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		if ($this->ref->AdvancedSearch->SearchValue <> "" ||
			$this->ref->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->ref->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->ref->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('cart_id', $rs))
				AddFilter($where, QuotedName('cart_id', $this->Dbid) . '=' . QuotedValue($rs['cart_id'], $this->cart_id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->cart_id->DbValue = $row['cart_id'];
		$this->po_id->DbValue = $row['po_id'];
		$this->company_id->DbValue = $row['company_id'];
		$this->partner_id->DbValue = $row['partner_id'];
		$this->partner_order_no->DbValue = $row['partner_order_no'];
		$this->remarks->DbValue = $row['remarks'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->ref->DbValue = $row['ref'];
		$this->product_code->DbValue = $row['product_code'];
		$this->order_quantity->DbValue = $row['order_quantity'];
		$this->purchase->DbValue = $row['purchase'];
		$this->pending_qty->DbValue = $row['pending_qty'];
		$this->order_date->DbValue = $row['order_date'];
		$this->despatch_date->DbValue = $row['despatch_date'];
		$this->avg_quantity->DbValue = $row['avg_quantity'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->status->DbValue = $row['status'];
		$this->p_id->DbValue = $row['p_id'];
		$this->partner_name->DbValue = $row['partner_name'];
		$this->p_qty->DbValue = $row['p_qty'];
		$this->p_remarks->DbValue = $row['p_remarks'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`cart_id` = @cart_id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('cart_id', $row) ? $row['cart_id'] : NULL) : $this->cart_id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@cart_id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "po_s_pendinglist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "po_s_pendingview.php")
			return $Language->phrase("View");
		elseif ($pageName == "po_s_pendingedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "po_s_pendingadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "po_s_pendinglist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("po_s_pendingview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("po_s_pendingview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "po_s_pendingadd.php?" . $this->getUrlParm($parm);
		else
			$url = "po_s_pendingadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("po_s_pendingedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("po_s_pendingadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("po_s_pendingdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "cart_id:" . JsonEncode($this->cart_id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->cart_id->CurrentValue != NULL) {
			$url .= "cart_id=" . urlencode($this->cart_id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("cart_id") !== NULL)
				$arKeys[] = Param("cart_id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->cart_id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->cart_id->setDbValue($rs->fields('cart_id'));
		$this->po_id->setDbValue($rs->fields('po_id'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->partner_id->setDbValue($rs->fields('partner_id'));
		$this->partner_order_no->setDbValue($rs->fields('partner_order_no'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->ref->setDbValue($rs->fields('ref'));
		$this->product_code->setDbValue($rs->fields('product_code'));
		$this->order_quantity->setDbValue($rs->fields('order_quantity'));
		$this->purchase->setDbValue($rs->fields('purchase'));
		$this->pending_qty->setDbValue($rs->fields('pending_qty'));
		$this->order_date->setDbValue($rs->fields('order_date'));
		$this->despatch_date->setDbValue($rs->fields('despatch_date'));
		$this->avg_quantity->setDbValue($rs->fields('avg_quantity'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->status->setDbValue($rs->fields('status'));
		$this->p_id->setDbValue($rs->fields('p_id'));
		$this->partner_name->setDbValue($rs->fields('partner_name'));
		$this->p_qty->setDbValue($rs->fields('p_qty'));
		$this->p_remarks->setDbValue($rs->fields('p_remarks'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// cart_id
		// po_id
		// company_id
		// partner_id
		// partner_order_no
		// remarks
		// grp
		// s_grp
		// product
		// ref
		// product_code
		// order_quantity
		// purchase
		// pending_qty
		// order_date
		// despatch_date
		// avg_quantity
		// packing_type
		// status
		// p_id

		$this->p_id->CellCssStyle = "white-space: nowrap;";

		// partner_name
		$this->partner_name->CellCssStyle = "white-space: nowrap;";

		// p_qty
		// p_remarks
		// cart_id

		$this->cart_id->ViewValue = $this->cart_id->CurrentValue;
		$this->cart_id->ViewValue = FormatNumber($this->cart_id->ViewValue, 0, -2, -2, -2);
		$this->cart_id->ViewCustomAttributes = "";

		// po_id
		$curVal = strval($this->po_id->CurrentValue);
		if ($curVal <> "") {
			$this->po_id->ViewValue = $this->po_id->lookupCacheOption($curVal);
			if ($this->po_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->po_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->po_id->ViewValue = $this->po_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->po_id->ViewValue = $this->po_id->CurrentValue;
				}
			}
		} else {
			$this->po_id->ViewValue = NULL;
		}
		$this->po_id->ViewCustomAttributes = "";

		// company_id
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// partner_id
		if ($this->partner_id->VirtualValue <> "") {
			$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
		} else {
			$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
		$curVal = strval($this->partner_id->CurrentValue);
		if ($curVal <> "") {
			$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
			if ($this->partner_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
				}
			}
		} else {
			$this->partner_id->ViewValue = NULL;
		}
		}
		$this->partner_id->ViewCustomAttributes = "";

		// partner_order_no
		$this->partner_order_no->ViewValue = $this->partner_order_no->CurrentValue;
		$this->partner_order_no->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// ref
		if ($this->ref->VirtualValue <> "") {
			$this->ref->ViewValue = $this->ref->VirtualValue;
		} else {
			$this->ref->ViewValue = $this->ref->CurrentValue;
		$curVal = strval($this->ref->CurrentValue);
		if ($curVal <> "") {
			$this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
			if ($this->ref->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->ref->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->ref->ViewValue = $this->ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ref->ViewValue = $this->ref->CurrentValue;
				}
			}
		} else {
			$this->ref->ViewValue = NULL;
		}
		}
		$this->ref->ViewCustomAttributes = "";

		// product_code
		$this->product_code->ViewValue = $this->product_code->CurrentValue;
		$this->product_code->ViewCustomAttributes = "";

		// order_quantity
		$this->order_quantity->ViewValue = $this->order_quantity->CurrentValue;
		$this->order_quantity->ViewValue = FormatNumber($this->order_quantity->ViewValue, 2, -2, -2, -2);
		$this->order_quantity->ViewCustomAttributes = "";

		// purchase
		$this->purchase->ViewValue = $this->purchase->CurrentValue;
		$this->purchase->ViewValue = FormatNumber($this->purchase->ViewValue, 2, -2, -2, -2);
		$this->purchase->ViewCustomAttributes = "";

		// pending_qty
		$this->pending_qty->ViewValue = $this->pending_qty->CurrentValue;
		$this->pending_qty->ViewValue = FormatNumber($this->pending_qty->ViewValue, 2, -2, -2, -2);
		$this->pending_qty->ViewCustomAttributes = "";

		// order_date
		$this->order_date->ViewValue = $this->order_date->CurrentValue;
		$this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, 0);
		$this->order_date->ViewCustomAttributes = "";

		// despatch_date
		$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
		$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 7);
		$this->despatch_date->ViewCustomAttributes = "";

		// avg_quantity
		$this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->ViewValue = FormatNumber($this->avg_quantity->ViewValue, 0, -2, -2, -2);
		$this->avg_quantity->ViewCustomAttributes = "";

		// packing_type
		$curVal = strval($this->packing_type->CurrentValue);
		if ($curVal <> "") {
			$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			if ($this->packing_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
				}
			}
		} else {
			$this->packing_type->ViewValue = NULL;
		}
		$this->packing_type->ViewCustomAttributes = "";

		// status
		$this->status->ViewValue = $this->status->CurrentValue;
		$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
		$this->status->ViewCustomAttributes = "";

		// p_id
		$this->p_id->ViewValue = $this->p_id->CurrentValue;
		$this->p_id->ViewCustomAttributes = "";

		// partner_name
		$this->partner_name->ViewValue = $this->partner_name->CurrentValue;
		$this->partner_name->ViewCustomAttributes = "";

		// p_qty
		$this->p_qty->ViewValue = $this->p_qty->CurrentValue;
		$this->p_qty->ViewValue = FormatNumber($this->p_qty->ViewValue, 2, -2, -2, -2);
		$this->p_qty->ViewCustomAttributes = "";

		// p_remarks
		$this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;
		$this->p_remarks->ViewCustomAttributes = "";

		// cart_id
		$this->cart_id->LinkCustomAttributes = "";
		$this->cart_id->HrefValue = "";
		$this->cart_id->TooltipValue = "";

		// po_id
		$this->po_id->LinkCustomAttributes = "";
		$this->po_id->HrefValue = "";
		$this->po_id->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// partner_id
		$this->partner_id->LinkCustomAttributes = "";
		$this->partner_id->HrefValue = "";
		$this->partner_id->TooltipValue = "";

		// partner_order_no
		$this->partner_order_no->LinkCustomAttributes = "";
		$this->partner_order_no->HrefValue = "";
		$this->partner_order_no->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		$this->product->HrefValue = "";
		$this->product->TooltipValue = "";

		// ref
		$this->ref->LinkCustomAttributes = "";
		$this->ref->HrefValue = "";
		$this->ref->TooltipValue = "";

		// product_code
		$this->product_code->LinkCustomAttributes = "";
		$this->product_code->HrefValue = "";
		$this->product_code->TooltipValue = "";

		// order_quantity
		$this->order_quantity->LinkCustomAttributes = "";
		$this->order_quantity->HrefValue = "";
		$this->order_quantity->TooltipValue = "";

		// purchase
		$this->purchase->LinkCustomAttributes = "";
		$this->purchase->HrefValue = "";
		$this->purchase->TooltipValue = "";

		// pending_qty
		$this->pending_qty->LinkCustomAttributes = "";
		$this->pending_qty->HrefValue = "";
		$this->pending_qty->TooltipValue = "";

		// order_date
		$this->order_date->LinkCustomAttributes = "";
		$this->order_date->HrefValue = "";
		$this->order_date->TooltipValue = "";

		// despatch_date
		$this->despatch_date->LinkCustomAttributes = "";
		$this->despatch_date->HrefValue = "";
		$this->despatch_date->TooltipValue = "";

		// avg_quantity
		$this->avg_quantity->LinkCustomAttributes = "";
		$this->avg_quantity->HrefValue = "";
		$this->avg_quantity->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// p_id
		$this->p_id->LinkCustomAttributes = "";
		$this->p_id->HrefValue = "";
		$this->p_id->TooltipValue = "";

		// partner_name
		$this->partner_name->LinkCustomAttributes = "";
		$this->partner_name->HrefValue = "";
		$this->partner_name->TooltipValue = "";

		// p_qty
		$this->p_qty->LinkCustomAttributes = "";
		$this->p_qty->HrefValue = "";
		$this->p_qty->TooltipValue = "";

		// p_remarks
		$this->p_remarks->LinkCustomAttributes = "";
		$this->p_remarks->HrefValue = "";
		$this->p_remarks->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// cart_id
		$this->cart_id->EditAttrs["class"] = "form-control";
		$this->cart_id->EditCustomAttributes = "";
		$this->cart_id->EditValue = $this->cart_id->CurrentValue;
		$this->cart_id->EditValue = FormatNumber($this->cart_id->EditValue, 0, -2, -2, -2);
		$this->cart_id->ViewCustomAttributes = "";

		// po_id
		$this->po_id->EditAttrs["class"] = "form-control";
		$this->po_id->EditCustomAttributes = "";

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";

		// partner_id
		$this->partner_id->EditAttrs["class"] = "form-control";
		$this->partner_id->EditCustomAttributes = "";
		$this->partner_id->EditValue = $this->partner_id->CurrentValue;
		$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

		// partner_order_no
		$this->partner_order_no->EditAttrs["class"] = "form-control";
		$this->partner_order_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->partner_order_no->CurrentValue = HtmlDecode($this->partner_order_no->CurrentValue);
		$this->partner_order_no->EditValue = $this->partner_order_no->CurrentValue;
		$this->partner_order_no->PlaceHolder = RemoveHtml($this->partner_order_no->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";

		// ref
		$this->ref->EditAttrs["class"] = "form-control";
		$this->ref->EditCustomAttributes = "";
		$this->ref->EditValue = $this->ref->CurrentValue;
		$this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

		// product_code
		$this->product_code->EditAttrs["class"] = "form-control";
		$this->product_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->product_code->CurrentValue = HtmlDecode($this->product_code->CurrentValue);
		$this->product_code->EditValue = $this->product_code->CurrentValue;
		$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

		// order_quantity
		$this->order_quantity->EditAttrs["class"] = "form-control";
		$this->order_quantity->EditCustomAttributes = "";
		$this->order_quantity->EditValue = $this->order_quantity->CurrentValue;
		$this->order_quantity->PlaceHolder = RemoveHtml($this->order_quantity->caption());
		if (strval($this->order_quantity->EditValue) <> "" && is_numeric($this->order_quantity->EditValue))
			$this->order_quantity->EditValue = FormatNumber($this->order_quantity->EditValue, -2, -2, -2, -2);

		// purchase
		$this->purchase->EditAttrs["class"] = "form-control";
		$this->purchase->EditCustomAttributes = "";
		$this->purchase->EditValue = $this->purchase->CurrentValue;
		$this->purchase->PlaceHolder = RemoveHtml($this->purchase->caption());
		if (strval($this->purchase->EditValue) <> "" && is_numeric($this->purchase->EditValue))
			$this->purchase->EditValue = FormatNumber($this->purchase->EditValue, -2, -2, -2, -2);

		// pending_qty
		$this->pending_qty->EditAttrs["class"] = "form-control";
		$this->pending_qty->EditCustomAttributes = "";
		$this->pending_qty->EditValue = $this->pending_qty->CurrentValue;
		$this->pending_qty->PlaceHolder = RemoveHtml($this->pending_qty->caption());
		if (strval($this->pending_qty->EditValue) <> "" && is_numeric($this->pending_qty->EditValue))
			$this->pending_qty->EditValue = FormatNumber($this->pending_qty->EditValue, -2, -2, -2, -2);

		// order_date
		$this->order_date->EditAttrs["class"] = "form-control";
		$this->order_date->EditCustomAttributes = "";
		$this->order_date->EditValue = FormatDateTime($this->order_date->CurrentValue, 8);
		$this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

		// despatch_date
		$this->despatch_date->EditAttrs["class"] = "form-control";
		$this->despatch_date->EditCustomAttributes = "";
		$this->despatch_date->EditValue = FormatDateTime($this->despatch_date->CurrentValue, 7);
		$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

		// avg_quantity
		$this->avg_quantity->EditAttrs["class"] = "form-control";
		$this->avg_quantity->EditCustomAttributes = "";
		$this->avg_quantity->EditValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->PlaceHolder = RemoveHtml($this->avg_quantity->caption());

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->CurrentValue;
		$this->status->PlaceHolder = RemoveHtml($this->status->caption());

		// p_id
		$this->p_id->EditAttrs["class"] = "form-control";
		$this->p_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->p_id->CurrentValue = HtmlDecode($this->p_id->CurrentValue);
		$this->p_id->EditValue = $this->p_id->CurrentValue;
		$this->p_id->PlaceHolder = RemoveHtml($this->p_id->caption());

		// partner_name
		$this->partner_name->EditAttrs["class"] = "form-control";
		$this->partner_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->partner_name->CurrentValue = HtmlDecode($this->partner_name->CurrentValue);
		$this->partner_name->EditValue = $this->partner_name->CurrentValue;
		$this->partner_name->PlaceHolder = RemoveHtml($this->partner_name->caption());

		// p_qty
		$this->p_qty->EditAttrs["class"] = "form-control";
		$this->p_qty->EditCustomAttributes = "";
		$this->p_qty->EditValue = $this->p_qty->CurrentValue;
		$this->p_qty->PlaceHolder = RemoveHtml($this->p_qty->caption());
		if (strval($this->p_qty->EditValue) <> "" && is_numeric($this->p_qty->EditValue))
			$this->p_qty->EditValue = FormatNumber($this->p_qty->EditValue, -2, -2, -2, -2);

		// p_remarks
		$this->p_remarks->EditAttrs["class"] = "form-control";
		$this->p_remarks->EditCustomAttributes = "";
		$this->p_remarks->EditValue = $this->p_remarks->CurrentValue;
		$this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->order_quantity->CurrentValue))
				$this->order_quantity->Total += $this->order_quantity->CurrentValue; // Accumulate total
			if (is_numeric($this->purchase->CurrentValue))
				$this->purchase->Total += $this->purchase->CurrentValue; // Accumulate total
			if (is_numeric($this->pending_qty->CurrentValue))
				$this->pending_qty->Total += $this->pending_qty->CurrentValue; // Accumulate total
			$this->avg_quantity->Count++; // Increment count
			if (is_numeric($this->avg_quantity->CurrentValue))
				$this->avg_quantity->Total += $this->avg_quantity->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->order_quantity->CurrentValue = $this->order_quantity->Total;
			$this->order_quantity->ViewValue = $this->order_quantity->CurrentValue;
			$this->order_quantity->ViewValue = FormatNumber($this->order_quantity->ViewValue, 2, -2, -2, -2);
			$this->order_quantity->ViewCustomAttributes = "";
			$this->order_quantity->HrefValue = ""; // Clear href value
			$this->purchase->CurrentValue = $this->purchase->Total;
			$this->purchase->ViewValue = $this->purchase->CurrentValue;
			$this->purchase->ViewValue = FormatNumber($this->purchase->ViewValue, 2, -2, -2, -2);
			$this->purchase->ViewCustomAttributes = "";
			$this->purchase->HrefValue = ""; // Clear href value
			$this->pending_qty->CurrentValue = $this->pending_qty->Total;
			$this->pending_qty->ViewValue = $this->pending_qty->CurrentValue;
			$this->pending_qty->ViewValue = FormatNumber($this->pending_qty->ViewValue, 2, -2, -2, -2);
			$this->pending_qty->ViewCustomAttributes = "";
			$this->pending_qty->HrefValue = ""; // Clear href value
			if ($this->avg_quantity->Count > 0) {
				$this->avg_quantity->CurrentValue = $this->avg_quantity->Total / $this->avg_quantity->Count;
			}
			$this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
			$this->avg_quantity->ViewValue = FormatNumber($this->avg_quantity->ViewValue, 0, -2, -2, -2);
			$this->avg_quantity->ViewCustomAttributes = "";
			$this->avg_quantity->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->cart_id);
					$doc->exportCaption($this->po_id);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->partner_order_no);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->order_quantity);
					$doc->exportCaption($this->purchase);
					$doc->exportCaption($this->pending_qty);
					$doc->exportCaption($this->order_date);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->avg_quantity);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->p_qty);
					$doc->exportCaption($this->p_remarks);
				} else {
					$doc->exportCaption($this->cart_id);
					$doc->exportCaption($this->po_id);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->partner_order_no);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->order_quantity);
					$doc->exportCaption($this->purchase);
					$doc->exportCaption($this->pending_qty);
					$doc->exportCaption($this->order_date);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->avg_quantity);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->p_qty);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->cart_id);
						$doc->exportField($this->po_id);
						$doc->exportField($this->company_id);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->partner_order_no);
						$doc->exportField($this->remarks);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->ref);
						$doc->exportField($this->product_code);
						$doc->exportField($this->order_quantity);
						$doc->exportField($this->purchase);
						$doc->exportField($this->pending_qty);
						$doc->exportField($this->order_date);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->avg_quantity);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->status);
						$doc->exportField($this->p_qty);
						$doc->exportField($this->p_remarks);
					} else {
						$doc->exportField($this->cart_id);
						$doc->exportField($this->po_id);
						$doc->exportField($this->company_id);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->partner_order_no);
						$doc->exportField($this->remarks);
						$doc->exportField($this->grp);
						$doc->exportField($this->product);
						$doc->exportField($this->ref);
						$doc->exportField($this->order_quantity);
						$doc->exportField($this->purchase);
						$doc->exportField($this->pending_qty);
						$doc->exportField($this->order_date);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->avg_quantity);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->status);
						$doc->exportField($this->p_qty);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->cart_id, '');
				$doc->exportAggregate($this->po_id, '');
				$doc->exportAggregate($this->company_id, '');
				$doc->exportAggregate($this->partner_id, '');
				$doc->exportAggregate($this->partner_order_no, '');
				$doc->exportAggregate($this->remarks, '');
				$doc->exportAggregate($this->grp, '');
				$doc->exportAggregate($this->product, '');
				$doc->exportAggregate($this->ref, '');
				$doc->exportAggregate($this->order_quantity, 'TOTAL');
				$doc->exportAggregate($this->purchase, 'TOTAL');
				$doc->exportAggregate($this->pending_qty, 'TOTAL');
				$doc->exportAggregate($this->order_date, '');
				$doc->exportAggregate($this->despatch_date, '');
				$doc->exportAggregate($this->avg_quantity, 'AVERAGE');
				$doc->exportAggregate($this->packing_type, '');
				$doc->exportAggregate($this->status, '');
				$doc->exportAggregate($this->p_qty, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>