<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class po_search extends po
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'po';

	// Page object name
	public $PageObjName = "po_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (po)
		if (!isset($GLOBALS["po"]) || get_class($GLOBALS["po"]) == PROJECT_NAMESPACE . "po") {
			$GLOBALS["po"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["po"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'po');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $po;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($po);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "poview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("polist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->order_type->setVisibility();
		$this->buyer_id->setVisibility();
		$this->buyer_order_no->setVisibility();
		$this->buyer_order_date->setVisibility();
		$this->cart_id->setVisibility();
		$this->buyer_product_ref->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid->setVisibility();
		$this->despatch_date->Visible = FALSE;
		$this->despatch_week->setVisibility();
		$this->fob_date->Visible = FALSE;
		$this->part_dispatch->Visible = FALSE;
		$this->payment_terms->setVisibility();
		$this->transport_terms->setVisibility();
		$this->buyer_shipping__id->setVisibility();
		$this->description_04->Visible = FALSE;
		$this->description_03->setVisibility();
		$this->description_01->Visible = FALSE;
		$this->description_02->Visible = FALSE;
		$this->description_07->setVisibility();
		$this->description_20->setVisibility();
		$this->description_17->setVisibility();
		$this->description_18->setVisibility();
		$this->description_19->setVisibility();
		$this->quantity->setVisibility();
		$this->price->setVisibility();
		$this->currency->setVisibility();
		$this->amount->setVisibility();
		$this->cbm->setVisibility();
		$this->buyer_size->setVisibility();
		$this->description_05->setVisibility();
		$this->description_06->setVisibility();
		$this->description_08->setVisibility();
		$this->remarks->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->a_operator->setVisibility();
		$this->a_datetime->setVisibility();
		$this->jc_no->Visible = FALSE;
		$this->buyer_instruction->setVisibility();
		$this->d_09_head->setVisibility();
		$this->description_09->setVisibility();
		$this->d_10_head->setVisibility();
		$this->description_10->setVisibility();
		$this->d_11_head->setVisibility();
		$this->description_11->setVisibility();
		$this->d_12_head->setVisibility();
		$this->description_12->setVisibility();
		$this->po->Visible = FALSE;
		$this->production_site->Visible = FALSE;
		$this->c_total->Visible = FALSE;
		$this->production_plan->Visible = FALSE;
		$this->lot_no->Visible = FALSE;
		$this->product_gcode->Visible = FALSE;
		$this->batch_no->Visible = FALSE;
		$this->uploads->Visible = FALSE;
		$this->d_01_head->Visible = FALSE;
		$this->d_02_head->Visible = FALSE;
		$this->d_03_head->Visible = FALSE;
		$this->d_04_head->Visible = FALSE;
		$this->d_05_head->Visible = FALSE;
		$this->d_06_head->Visible = FALSE;
		$this->d_07_head->Visible = FALSE;
		$this->d_08_head->Visible = FALSE;
		$this->sample->Visible = FALSE;
		$this->balance_quantity->Visible = FALSE;
		$this->_action->setVisibility();
		$this->url->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->cart_id);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->payment_terms);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->description_05);
		$this->setupLookupOptions($this->description_06);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->a_operator);
		$this->setupLookupOptions($this->d_09_head);
		$this->setupLookupOptions($this->d_10_head);
		$this->setupLookupOptions($this->d_11_head);
		$this->setupLookupOptions($this->d_12_head);
		$this->setupLookupOptions($this->production_site);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "polist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->order_type); // order_type
		$this->buildSearchUrl($srchUrl, $this->buyer_id); // buyer_id
		$this->buildSearchUrl($srchUrl, $this->buyer_order_no); // buyer_order_no
		$this->buildSearchUrl($srchUrl, $this->buyer_order_date); // buyer_order_date
		$this->buildSearchUrl($srchUrl, $this->cart_id); // cart_id
		$this->buildSearchUrl($srchUrl, $this->buyer_product_ref); // buyer_product_ref
		$this->buildSearchUrl($srchUrl, $this->grp); // grp
		$this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
		$this->buildSearchUrl($srchUrl, $this->product); // product
		$this->buildSearchUrl($srchUrl, $this->rid); // rid
		$this->buildSearchUrl($srchUrl, $this->despatch_week); // despatch_week
		$this->buildSearchUrl($srchUrl, $this->payment_terms); // payment_terms
		$this->buildSearchUrl($srchUrl, $this->transport_terms); // transport_terms
		$this->buildSearchUrl($srchUrl, $this->buyer_shipping__id); // buyer_shipping _id
		$this->buildSearchUrl($srchUrl, $this->description_03); // description_03
		$this->buildSearchUrl($srchUrl, $this->description_07); // description_07
		$this->buildSearchUrl($srchUrl, $this->description_20); // description_20
		$this->buildSearchUrl($srchUrl, $this->description_17); // description_17
		$this->buildSearchUrl($srchUrl, $this->description_18); // description_18
		$this->buildSearchUrl($srchUrl, $this->description_19); // description_19
		$this->buildSearchUrl($srchUrl, $this->quantity); // quantity
		$this->buildSearchUrl($srchUrl, $this->price); // price
		$this->buildSearchUrl($srchUrl, $this->currency); // currency
		$this->buildSearchUrl($srchUrl, $this->amount); // amount
		$this->buildSearchUrl($srchUrl, $this->cbm); // cbm
		$this->buildSearchUrl($srchUrl, $this->buyer_size); // buyer_size
		$this->buildSearchUrl($srchUrl, $this->description_05); // description_05
		$this->buildSearchUrl($srchUrl, $this->description_06); // description_06
		$this->buildSearchUrl($srchUrl, $this->description_08); // description_08
		$this->buildSearchUrl($srchUrl, $this->remarks); // remarks
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->a_operator); // a_operator
		$this->buildSearchUrl($srchUrl, $this->a_datetime); // a_datetime
		$this->buildSearchUrl($srchUrl, $this->buyer_instruction); // buyer_instruction
		$this->buildSearchUrl($srchUrl, $this->d_09_head); // d_09_head
		$this->buildSearchUrl($srchUrl, $this->description_09); // description_09
		$this->buildSearchUrl($srchUrl, $this->d_10_head); // d_10_head
		$this->buildSearchUrl($srchUrl, $this->description_10); // description_10
		$this->buildSearchUrl($srchUrl, $this->d_11_head); // d_11_head
		$this->buildSearchUrl($srchUrl, $this->description_11); // description_11
		$this->buildSearchUrl($srchUrl, $this->d_12_head); // d_12_head
		$this->buildSearchUrl($srchUrl, $this->description_12); // description_12
		$this->buildSearchUrl($srchUrl, $this->_action); // action
		$this->buildSearchUrl($srchUrl, $this->url); // url
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// order_type
		if (!$this->isAddOrEdit())
			$this->order_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_order_type"));
		$this->order_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_order_type"));

		// buyer_id
		if (!$this->isAddOrEdit())
			$this->buyer_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_id"));
		$this->buyer_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_id"));

		// buyer_order_no
		if (!$this->isAddOrEdit())
			$this->buyer_order_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_order_no"));
		$this->buyer_order_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_order_no"));

		// buyer_order_date
		if (!$this->isAddOrEdit())
			$this->buyer_order_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_order_date"));
		$this->buyer_order_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_order_date"));

		// cart_id
		if (!$this->isAddOrEdit())
			$this->cart_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cart_id"));
		$this->cart_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cart_id"));
		if (is_array($this->cart_id->AdvancedSearch->SearchValue))
			$this->cart_id->AdvancedSearch->SearchValue = implode(",", $this->cart_id->AdvancedSearch->SearchValue);
		if (is_array($this->cart_id->AdvancedSearch->SearchValue2))
			$this->cart_id->AdvancedSearch->SearchValue2 = implode(",", $this->cart_id->AdvancedSearch->SearchValue2);

		// buyer_product_ref
		if (!$this->isAddOrEdit())
			$this->buyer_product_ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_product_ref"));
		$this->buyer_product_ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_product_ref"));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_grp"));
		$this->grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_grp"));

		// s_grp
		if (!$this->isAddOrEdit())
			$this->s_grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_grp"));
		$this->s_grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_grp"));

		// product
		if (!$this->isAddOrEdit())
			$this->product->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product"));
		$this->product->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product"));

		// rid
		if (!$this->isAddOrEdit())
			$this->rid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_rid"));
		$this->rid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_rid"));

		// despatch_week
		if (!$this->isAddOrEdit())
			$this->despatch_week->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_despatch_week"));
		$this->despatch_week->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_despatch_week"));

		// payment_terms
		if (!$this->isAddOrEdit())
			$this->payment_terms->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_payment_terms"));
		$this->payment_terms->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_payment_terms"));

		// transport_terms
		if (!$this->isAddOrEdit())
			$this->transport_terms->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_transport_terms"));
		$this->transport_terms->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_transport_terms"));

		// buyer_shipping _id
		if (!$this->isAddOrEdit())
			$this->buyer_shipping__id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_shipping__id"));
		$this->buyer_shipping__id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_shipping__id"));

		// description_03
		if (!$this->isAddOrEdit())
			$this->description_03->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_03"));
		$this->description_03->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_03"));

		// description_07
		if (!$this->isAddOrEdit())
			$this->description_07->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_07"));
		$this->description_07->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_07"));

		// description_20
		if (!$this->isAddOrEdit())
			$this->description_20->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_20"));
		$this->description_20->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_20"));

		// description_17
		if (!$this->isAddOrEdit())
			$this->description_17->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_17"));
		$this->description_17->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_17"));

		// description_18
		if (!$this->isAddOrEdit())
			$this->description_18->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_18"));
		$this->description_18->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_18"));

		// description_19
		if (!$this->isAddOrEdit())
			$this->description_19->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_19"));
		$this->description_19->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_19"));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_quantity"));
		$this->quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_quantity"));

		// price
		if (!$this->isAddOrEdit())
			$this->price->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_price"));
		$this->price->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_price"));

		// currency
		if (!$this->isAddOrEdit())
			$this->currency->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_currency"));
		$this->currency->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_currency"));

		// amount
		if (!$this->isAddOrEdit())
			$this->amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_amount"));
		$this->amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_amount"));

		// cbm
		if (!$this->isAddOrEdit())
			$this->cbm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cbm"));
		$this->cbm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cbm"));

		// buyer_size
		if (!$this->isAddOrEdit())
			$this->buyer_size->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_size"));
		$this->buyer_size->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_size"));

		// description_05
		if (!$this->isAddOrEdit())
			$this->description_05->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_05"));
		$this->description_05->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_05"));

		// description_06
		if (!$this->isAddOrEdit())
			$this->description_06->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_06"));
		$this->description_06->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_06"));

		// description_08
		if (!$this->isAddOrEdit())
			$this->description_08->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_08"));
		$this->description_08->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_08"));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remarks"));
		$this->remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remarks"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// a_operator
		if (!$this->isAddOrEdit())
			$this->a_operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_a_operator"));
		$this->a_operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_a_operator"));

		// a_datetime
		if (!$this->isAddOrEdit())
			$this->a_datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_a_datetime"));
		$this->a_datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_a_datetime"));

		// buyer_instruction
		if (!$this->isAddOrEdit())
			$this->buyer_instruction->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_instruction"));
		$this->buyer_instruction->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_instruction"));

		// d_09_head
		if (!$this->isAddOrEdit())
			$this->d_09_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_09_head"));
		$this->d_09_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_09_head"));

		// description_09
		if (!$this->isAddOrEdit())
			$this->description_09->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_09"));
		$this->description_09->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_09"));

		// d_10_head
		if (!$this->isAddOrEdit())
			$this->d_10_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_10_head"));
		$this->d_10_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_10_head"));

		// description_10
		if (!$this->isAddOrEdit())
			$this->description_10->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_10"));
		$this->description_10->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_10"));

		// d_11_head
		if (!$this->isAddOrEdit())
			$this->d_11_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_11_head"));
		$this->d_11_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_11_head"));

		// description_11
		if (!$this->isAddOrEdit())
			$this->description_11->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_11"));
		$this->description_11->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_11"));

		// d_12_head
		if (!$this->isAddOrEdit())
			$this->d_12_head->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_12_head"));
		$this->d_12_head->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_12_head"));

		// description_12
		if (!$this->isAddOrEdit())
			$this->description_12->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_description_12"));
		$this->description_12->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_description_12"));

		// action
		if (!$this->isAddOrEdit())
			$this->_action->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__action"));
		$this->_action->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__action"));

		// url
		if (!$this->isAddOrEdit())
			$this->url->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_url"));
		$this->url->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_url"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->description_17->FormValue == $this->description_17->CurrentValue && is_numeric(ConvertToFloatString($this->description_17->CurrentValue)))
			$this->description_17->CurrentValue = ConvertToFloatString($this->description_17->CurrentValue);

		// Convert decimal values if posted back
		if ($this->description_18->FormValue == $this->description_18->CurrentValue && is_numeric(ConvertToFloatString($this->description_18->CurrentValue)))
			$this->description_18->CurrentValue = ConvertToFloatString($this->description_18->CurrentValue);

		// Convert decimal values if posted back
		if ($this->description_19->FormValue == $this->description_19->CurrentValue && is_numeric(ConvertToFloatString($this->description_19->CurrentValue)))
			$this->description_19->CurrentValue = ConvertToFloatString($this->description_19->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cbm->FormValue == $this->cbm->CurrentValue && is_numeric(ConvertToFloatString($this->cbm->CurrentValue)))
			$this->cbm->CurrentValue = ConvertToFloatString($this->cbm->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// order_type
		// buyer_id
		// buyer_order_no
		// buyer_order_date
		// cart_id
		// buyer_product_ref
		// grp
		// s_grp
		// product
		// rid
		// despatch_date
		// despatch_week
		// fob_date
		// part_dispatch
		// payment_terms
		// transport_terms
		// buyer_shipping _id
		// description_04
		// description_03
		// description_01
		// description_02
		// description_07
		// description_20
		// description_17
		// description_18
		// description_19
		// quantity
		// price
		// currency
		// amount
		// cbm
		// buyer_size
		// description_05
		// description_06
		// description_08
		// remarks
		// operator
		// datetime
		// a_operator
		// a_datetime
		// jc_no
		// buyer_instruction
		// d_09_head
		// description_09
		// d_10_head
		// description_10
		// d_11_head
		// description_11
		// d_12_head
		// description_12
		// po
		// production_site
		// c_total
		// production_plan
		// lot_no
		// product_gcode
		// batch_no
		// uploads
		// d_01_head
		// d_02_head
		// d_03_head
		// d_04_head
		// d_05_head
		// d_06_head
		// d_07_head
		// d_08_head
		// sample
		// balance_quantity
		// action
		// url

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// order_type
			if (strval($this->order_type->CurrentValue) <> "") {
				$this->order_type->ViewValue = $this->order_type->optionCaption($this->order_type->CurrentValue);
			} else {
				$this->order_type->ViewValue = NULL;
			}
			$this->order_type->ViewCustomAttributes = "";

			// buyer_id
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// buyer_order_no
			$this->buyer_order_no->ViewValue = $this->buyer_order_no->CurrentValue;
			$this->buyer_order_no->ViewCustomAttributes = "";

			// buyer_order_date
			$this->buyer_order_date->ViewValue = $this->buyer_order_date->CurrentValue;
			$this->buyer_order_date->ViewValue = FormatDateTime($this->buyer_order_date->ViewValue, 0);
			$this->buyer_order_date->ViewCustomAttributes = "";

			// cart_id
			$curVal = strval($this->cart_id->CurrentValue);
			if ($curVal <> "") {
				$this->cart_id->ViewValue = $this->cart_id->lookupCacheOption($curVal);
				if ($this->cart_id->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` = NULL || `po_id` = '' || `po_id` = '0'" : "`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue;
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->cart_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->cart_id->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, 0);
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, 0);
							$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, 0);
							$this->cart_id->ViewValue->add($this->cart_id->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->cart_id->ViewValue = $this->cart_id->CurrentValue;
					}
				}
			} else {
				$this->cart_id->ViewValue = NULL;
			}
			$this->cart_id->ViewCustomAttributes = "";

			// buyer_product_ref
			$this->buyer_product_ref->ViewValue = $this->buyer_product_ref->CurrentValue;
			$this->buyer_product_ref->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 ";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `product_type`=0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// payment_terms
			$curVal = strval($this->payment_terms->CurrentValue);
			if ($curVal <> "") {
				$this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
				if ($this->payment_terms->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 81";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->payment_terms->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
					}
				}
			} else {
				$this->payment_terms->ViewValue = NULL;
			}
			$this->payment_terms->ViewCustomAttributes = "";

			// transport_terms
			$this->transport_terms->ViewValue = $this->transport_terms->CurrentValue;
			$this->transport_terms->ViewCustomAttributes = "";

			// buyer_shipping _id
			$this->buyer_shipping__id->ViewValue = $this->buyer_shipping__id->CurrentValue;
			$this->buyer_shipping__id->ViewValue = FormatNumber($this->buyer_shipping__id->ViewValue, 0, -2, -2, -2);
			$this->buyer_shipping__id->ViewCustomAttributes = "";

			// description_04
			if (strval($this->description_04->CurrentValue) <> "") {
				$this->description_04->ViewValue = $this->description_04->optionCaption($this->description_04->CurrentValue);
			} else {
				$this->description_04->ViewValue = NULL;
			}
			$this->description_04->ViewCustomAttributes = "";

			// description_03
			if (strval($this->description_03->CurrentValue) <> "") {
				$this->description_03->ViewValue = $this->description_03->optionCaption($this->description_03->CurrentValue);
			} else {
				$this->description_03->ViewValue = NULL;
			}
			$this->description_03->ViewCustomAttributes = "";

			// description_07
			$this->description_07->ViewValue = $this->description_07->CurrentValue;
			$this->description_07->ViewCustomAttributes = "";

			// description_20
			if (strval($this->description_20->CurrentValue) <> "") {
				$this->description_20->ViewValue = $this->description_20->optionCaption($this->description_20->CurrentValue);
			} else {
				$this->description_20->ViewValue = NULL;
			}
			$this->description_20->ViewCustomAttributes = "";

			// description_17
			$this->description_17->ViewValue = $this->description_17->CurrentValue;
			$this->description_17->ViewValue = FormatNumber($this->description_17->ViewValue, 2, -2, -2, -2);
			$this->description_17->ViewCustomAttributes = "";

			// description_18
			$this->description_18->ViewValue = $this->description_18->CurrentValue;
			$this->description_18->ViewValue = FormatNumber($this->description_18->ViewValue, 2, -2, -2, -2);
			$this->description_18->ViewCustomAttributes = "";

			// description_19
			$this->description_19->ViewValue = $this->description_19->CurrentValue;
			$this->description_19->ViewValue = FormatNumber($this->description_19->ViewValue, 2, -2, -2, -2);
			$this->description_19->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 3, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, 2, -2, -2, -2);
			$this->cbm->ViewCustomAttributes = "";

			// buyer_size
			$this->buyer_size->ViewValue = $this->buyer_size->CurrentValue;
			$this->buyer_size->ViewCustomAttributes = "";

			// description_05
			$curVal = strval($this->description_05->CurrentValue);
			if ($curVal <> "") {
				$this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
				if ($this->description_05->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_05->ViewValue = $this->description_05->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_05->ViewValue = $this->description_05->CurrentValue;
					}
				}
			} else {
				$this->description_05->ViewValue = NULL;
			}
			$this->description_05->ViewCustomAttributes = "";

			// description_06
			$curVal = strval($this->description_06->CurrentValue);
			if ($curVal <> "") {
				$this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
				if ($this->description_06->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->description_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_06->ViewValue = $this->description_06->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->description_06->ViewValue = $this->description_06->CurrentValue;
					}
				}
			} else {
				$this->description_06->ViewValue = NULL;
			}
			$this->description_06->ViewCustomAttributes = "";

			// description_08
			$this->description_08->ViewValue = $this->description_08->CurrentValue;
			$this->description_08->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// a_operator
			$curVal = strval($this->a_operator->CurrentValue);
			if ($curVal <> "") {
				$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
				if ($this->a_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
					}
				}
			} else {
				$this->a_operator->ViewValue = NULL;
			}
			$this->a_operator->ViewCustomAttributes = "";

			// a_datetime
			$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
			$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 0);
			$this->a_datetime->ViewCustomAttributes = "";

			// buyer_instruction
			$this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;
			$this->buyer_instruction->ViewCustomAttributes = "";

			// d_09_head
			$curVal = strval($this->d_09_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_09_head->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
				if ($this->d_09_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_09_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_09_head->ViewValue = $this->d_09_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_09_head->ViewValue = $this->d_09_head->CurrentValue;
					}
				}
			} else {
				$this->d_09_head->ViewValue = NULL;
			}
			$this->d_09_head->ViewCustomAttributes = "";

			// description_09
			$this->description_09->ViewValue = $this->description_09->CurrentValue;
			$this->description_09->ViewCustomAttributes = "";

			// d_10_head
			$curVal = strval($this->d_10_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_10_head->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
				if ($this->d_10_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_10_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_10_head->ViewValue = $this->d_10_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_10_head->ViewValue = $this->d_10_head->CurrentValue;
					}
				}
			} else {
				$this->d_10_head->ViewValue = NULL;
			}
			$this->d_10_head->ViewCustomAttributes = "";

			// description_10
			$this->description_10->ViewValue = $this->description_10->CurrentValue;
			$this->description_10->ViewCustomAttributes = "";

			// d_11_head
			$curVal = strval($this->d_11_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_11_head->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
				if ($this->d_11_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_11_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_11_head->ViewValue = $this->d_11_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_11_head->ViewValue = $this->d_11_head->CurrentValue;
					}
				}
			} else {
				$this->d_11_head->ViewValue = NULL;
			}
			$this->d_11_head->ViewCustomAttributes = "";

			// description_11
			$this->description_11->ViewValue = $this->description_11->CurrentValue;
			$this->description_11->ViewCustomAttributes = "";

			// d_12_head
			$curVal = strval($this->d_12_head->CurrentValue);
			if ($curVal <> "") {
				$this->d_12_head->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
				if ($this->d_12_head->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_12_head->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_12_head->ViewValue = $this->d_12_head->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_12_head->ViewValue = $this->d_12_head->CurrentValue;
					}
				}
			} else {
				$this->d_12_head->ViewValue = NULL;
			}
			$this->d_12_head->ViewCustomAttributes = "";

			// description_12
			$this->description_12->ViewValue = $this->description_12->CurrentValue;
			$this->description_12->ViewCustomAttributes = "";

			// action
			$this->_action->ViewValue = $this->_action->CurrentValue;
			$this->_action->CssClass = "font-weight-bold";
			$this->_action->ViewCustomAttributes = 'class = "btn btn-default"';

			// url
			$this->url->ViewValue = $this->url->CurrentValue;
			$this->url->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// order_type
			$this->order_type->LinkCustomAttributes = "";
			$this->order_type->HrefValue = "";
			$this->order_type->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// buyer_order_no
			$this->buyer_order_no->LinkCustomAttributes = "";
			$this->buyer_order_no->HrefValue = "";
			$this->buyer_order_no->TooltipValue = "";

			// buyer_order_date
			$this->buyer_order_date->LinkCustomAttributes = "";
			$this->buyer_order_date->HrefValue = "";
			$this->buyer_order_date->TooltipValue = "";

			// cart_id
			$this->cart_id->LinkCustomAttributes = "";
			$this->cart_id->HrefValue = "";
			$this->cart_id->TooltipValue = "";

			// buyer_product_ref
			$this->buyer_product_ref->LinkCustomAttributes = "";
			$this->buyer_product_ref->HrefValue = "";
			$this->buyer_product_ref->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "po_clist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "po_clist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "po_clist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			$this->payment_terms->HrefValue = "";
			$this->payment_terms->TooltipValue = "";

			// transport_terms
			$this->transport_terms->LinkCustomAttributes = "";
			$this->transport_terms->HrefValue = "";
			$this->transport_terms->TooltipValue = "";

			// buyer_shipping _id
			$this->buyer_shipping__id->LinkCustomAttributes = "";
			$this->buyer_shipping__id->HrefValue = "";
			$this->buyer_shipping__id->TooltipValue = "";

			// description_03
			$this->description_03->LinkCustomAttributes = "";
			$this->description_03->HrefValue = "";
			$this->description_03->TooltipValue = "";

			// description_07
			$this->description_07->LinkCustomAttributes = "";
			$this->description_07->HrefValue = "";
			$this->description_07->TooltipValue = "";

			// description_20
			$this->description_20->LinkCustomAttributes = "";
			$this->description_20->HrefValue = "";
			$this->description_20->TooltipValue = "";

			// description_17
			$this->description_17->LinkCustomAttributes = "";
			$this->description_17->HrefValue = "";
			$this->description_17->TooltipValue = "";

			// description_18
			$this->description_18->LinkCustomAttributes = "";
			$this->description_18->HrefValue = "";
			$this->description_18->TooltipValue = "";

			// description_19
			$this->description_19->LinkCustomAttributes = "";
			$this->description_19->HrefValue = "";
			$this->description_19->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";
			$this->currency->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// buyer_size
			$this->buyer_size->LinkCustomAttributes = "";
			$this->buyer_size->HrefValue = "";
			$this->buyer_size->TooltipValue = "";

			// description_05
			$this->description_05->LinkCustomAttributes = "";
			$this->description_05->HrefValue = "";
			$this->description_05->TooltipValue = "";

			// description_06
			$this->description_06->LinkCustomAttributes = "";
			$this->description_06->HrefValue = "";
			$this->description_06->TooltipValue = "";

			// description_08
			$this->description_08->LinkCustomAttributes = "";
			$this->description_08->HrefValue = "";
			$this->description_08->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// a_operator
			$this->a_operator->LinkCustomAttributes = "";
			$this->a_operator->HrefValue = "";
			$this->a_operator->TooltipValue = "";

			// a_datetime
			$this->a_datetime->LinkCustomAttributes = "";
			$this->a_datetime->HrefValue = "";
			$this->a_datetime->TooltipValue = "";

			// buyer_instruction
			$this->buyer_instruction->LinkCustomAttributes = "";
			$this->buyer_instruction->HrefValue = "";
			$this->buyer_instruction->TooltipValue = "";

			// d_09_head
			$this->d_09_head->LinkCustomAttributes = "";
			$this->d_09_head->HrefValue = "";
			$this->d_09_head->TooltipValue = "";

			// description_09
			$this->description_09->LinkCustomAttributes = "";
			$this->description_09->HrefValue = "";
			$this->description_09->TooltipValue = "";

			// d_10_head
			$this->d_10_head->LinkCustomAttributes = "";
			$this->d_10_head->HrefValue = "";
			$this->d_10_head->TooltipValue = "";

			// description_10
			$this->description_10->LinkCustomAttributes = "";
			$this->description_10->HrefValue = "";
			$this->description_10->TooltipValue = "";

			// d_11_head
			$this->d_11_head->LinkCustomAttributes = "";
			$this->d_11_head->HrefValue = "";
			$this->d_11_head->TooltipValue = "";

			// description_11
			$this->description_11->LinkCustomAttributes = "";
			$this->description_11->HrefValue = "";
			$this->description_11->TooltipValue = "";

			// d_12_head
			$this->d_12_head->LinkCustomAttributes = "";
			$this->d_12_head->HrefValue = "";
			$this->d_12_head->TooltipValue = "";

			// description_12
			$this->description_12->LinkCustomAttributes = "";
			$this->description_12->HrefValue = "";
			$this->description_12->TooltipValue = "";

			// action
			$this->_action->LinkCustomAttributes = "";
			if (!EmptyValue($this->url->CurrentValue)) {
				$this->_action->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
				$this->_action->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->_action->HrefValue = FullUrl($this->_action->HrefValue, "href");
			} else {
				$this->_action->HrefValue = "";
			}
			$this->_action->TooltipValue = "";

			// url
			$this->url->LinkCustomAttributes = "";
			$this->url->HrefValue = "";
			$this->url->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// order_type
			$this->order_type->EditCustomAttributes = "";
			$this->order_type->EditValue = $this->order_type->options(FALSE);

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->buyer_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->buyer_id->AdvancedSearch->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
			else
				$this->buyer_id->AdvancedSearch->ViewValue = $this->buyer_id->Lookup !== NULL && is_array($this->buyer_id->Lookup->Options) ? $curVal : NULL;
			if ($this->buyer_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->buyer_id->EditValue = array_values($this->buyer_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->buyer_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` > 1000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->buyer_id->EditValue = $arwrk;
			}

			// buyer_order_no
			$this->buyer_order_no->EditAttrs["class"] = "form-control";
			$this->buyer_order_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_order_no->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_order_no->AdvancedSearch->SearchValue);
			$this->buyer_order_no->EditValue = HtmlEncode($this->buyer_order_no->AdvancedSearch->SearchValue);
			$this->buyer_order_no->PlaceHolder = RemoveHtml($this->buyer_order_no->caption());

			// buyer_order_date
			$this->buyer_order_date->EditAttrs["class"] = "form-control";
			$this->buyer_order_date->EditCustomAttributes = "";
			$this->buyer_order_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->buyer_order_date->AdvancedSearch->SearchValue, 0), 8));
			$this->buyer_order_date->PlaceHolder = RemoveHtml($this->buyer_order_date->caption());

			// cart_id
			$this->cart_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->cart_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->cart_id->AdvancedSearch->ViewValue = $this->cart_id->lookupCacheOption($curVal);
			else
				$this->cart_id->AdvancedSearch->ViewValue = $this->cart_id->Lookup !== NULL && is_array($this->cart_id->Lookup->Options) ? $curVal : NULL;
			if ($this->cart_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->cart_id->EditValue = array_values($this->cart_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` = NULL || `po_id` = '' || `po_id` = '0'" : "`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue;
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->cart_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 2, -2, -2, 0);
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, 0);
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, 0);
				}
				$this->cart_id->EditValue = $arwrk;
			}

			// buyer_product_ref
			$this->buyer_product_ref->EditAttrs["class"] = "form-control";
			$this->buyer_product_ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_product_ref->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_product_ref->AdvancedSearch->SearchValue);
			$this->buyer_product_ref->EditValue = HtmlEncode($this->buyer_product_ref->AdvancedSearch->SearchValue);
			$this->buyer_product_ref->PlaceHolder = RemoveHtml($this->buyer_product_ref->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 ";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->product->AdvancedSearch->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->AdvancedSearch->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// rid
			$this->rid->EditCustomAttributes = "";
			$curVal = trim(strval($this->rid->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->rid->AdvancedSearch->ViewValue = $this->rid->lookupCacheOption($curVal);
			else
				$this->rid->AdvancedSearch->ViewValue = $this->rid->Lookup !== NULL && is_array($this->rid->Lookup->Options) ? $curVal : NULL;
			if ($this->rid->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->rid->EditValue = array_values($this->rid->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->rid->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `product_type`=0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->rid->EditValue = $arwrk;
			}

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$curVal = trim(strval($this->despatch_week->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			else
				$this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->Lookup !== NULL && is_array($this->despatch_week->Lookup->Options) ? $curVal : NULL;
			if ($this->despatch_week->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->despatch_week->EditValue = array_values($this->despatch_week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->despatch_week->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->despatch_week->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->despatch_week->EditValue = $arwrk;
			}

			// payment_terms
			$this->payment_terms->EditAttrs["class"] = "form-control";
			$this->payment_terms->EditCustomAttributes = "";
			$curVal = trim(strval($this->payment_terms->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->payment_terms->AdvancedSearch->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
			else
				$this->payment_terms->AdvancedSearch->ViewValue = $this->payment_terms->Lookup !== NULL && is_array($this->payment_terms->Lookup->Options) ? $curVal : NULL;
			if ($this->payment_terms->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->payment_terms->EditValue = array_values($this->payment_terms->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->payment_terms->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 81";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->payment_terms->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->payment_terms->EditValue = $arwrk;
			}

			// transport_terms
			$this->transport_terms->EditAttrs["class"] = "form-control";
			$this->transport_terms->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->transport_terms->AdvancedSearch->SearchValue = HtmlDecode($this->transport_terms->AdvancedSearch->SearchValue);
			$this->transport_terms->EditValue = HtmlEncode($this->transport_terms->AdvancedSearch->SearchValue);
			$this->transport_terms->PlaceHolder = RemoveHtml($this->transport_terms->caption());

			// buyer_shipping _id
			$this->buyer_shipping__id->EditAttrs["class"] = "form-control";
			$this->buyer_shipping__id->EditCustomAttributes = "";
			$this->buyer_shipping__id->EditValue = HtmlEncode($this->buyer_shipping__id->AdvancedSearch->SearchValue);
			$this->buyer_shipping__id->PlaceHolder = RemoveHtml($this->buyer_shipping__id->caption());

			// description_03
			$this->description_03->EditAttrs["class"] = "form-control";
			$this->description_03->EditCustomAttributes = "";
			$this->description_03->EditValue = $this->description_03->options(TRUE);

			// description_07
			$this->description_07->EditAttrs["class"] = "form-control";
			$this->description_07->EditCustomAttributes = "";
			$this->description_07->EditValue = HtmlEncode($this->description_07->AdvancedSearch->SearchValue);
			$this->description_07->PlaceHolder = RemoveHtml($this->description_07->caption());

			// description_20
			$this->description_20->EditAttrs["class"] = "form-control";
			$this->description_20->EditCustomAttributes = "";
			$this->description_20->EditValue = $this->description_20->options(TRUE);

			// description_17
			$this->description_17->EditAttrs["class"] = "form-control";
			$this->description_17->EditCustomAttributes = 'ReadOnly';
			$this->description_17->EditValue = HtmlEncode($this->description_17->AdvancedSearch->SearchValue);
			$this->description_17->PlaceHolder = RemoveHtml($this->description_17->caption());

			// description_18
			$this->description_18->EditAttrs["class"] = "form-control";
			$this->description_18->EditCustomAttributes = 'ReadOnly';
			$this->description_18->EditValue = HtmlEncode($this->description_18->AdvancedSearch->SearchValue);
			$this->description_18->PlaceHolder = RemoveHtml($this->description_18->caption());

			// description_19
			$this->description_19->EditAttrs["class"] = "form-control";
			$this->description_19->EditCustomAttributes = 'ReadOnly';
			$this->description_19->EditValue = HtmlEncode($this->description_19->AdvancedSearch->SearchValue);
			$this->description_19->PlaceHolder = RemoveHtml($this->description_19->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->AdvancedSearch->SearchValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = 'ReadOnly';
			$this->price->EditValue = HtmlEncode($this->price->AdvancedSearch->SearchValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());

			// currency
			$this->currency->EditAttrs["class"] = "form-control";
			$this->currency->EditCustomAttributes = 'ReadOnly';
			$curVal = trim(strval($this->currency->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->currency->AdvancedSearch->ViewValue = $this->currency->lookupCacheOption($curVal);
			else
				$this->currency->AdvancedSearch->ViewValue = $this->currency->Lookup !== NULL && is_array($this->currency->Lookup->Options) ? $curVal : NULL;
			if ($this->currency->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->currency->EditValue = array_values($this->currency->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->currency->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->currency->EditValue = $arwrk;
			}

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = 'ReadOnly';
			$this->amount->EditValue = HtmlEncode($this->amount->AdvancedSearch->SearchValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

			// cbm
			$this->cbm->EditAttrs["class"] = "form-control";
			$this->cbm->EditCustomAttributes = 'ReadOnly';
			$this->cbm->EditValue = HtmlEncode($this->cbm->AdvancedSearch->SearchValue);
			$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

			// buyer_size
			$this->buyer_size->EditAttrs["class"] = "form-control";
			$this->buyer_size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_size->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_size->AdvancedSearch->SearchValue);
			$this->buyer_size->EditValue = HtmlEncode($this->buyer_size->AdvancedSearch->SearchValue);
			$this->buyer_size->PlaceHolder = RemoveHtml($this->buyer_size->caption());

			// description_05
			$this->description_05->EditAttrs["class"] = "form-control";
			$this->description_05->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_05->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->description_05->AdvancedSearch->ViewValue = $this->description_05->lookupCacheOption($curVal);
			else
				$this->description_05->AdvancedSearch->ViewValue = $this->description_05->Lookup !== NULL && is_array($this->description_05->Lookup->Options) ? $curVal : NULL;
			if ($this->description_05->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->description_05->EditValue = array_values($this->description_05->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->description_05->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_05->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->description_05->EditValue = $arwrk;
			}

			// description_06
			$this->description_06->EditAttrs["class"] = "form-control";
			$this->description_06->EditCustomAttributes = "";
			$curVal = trim(strval($this->description_06->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->description_06->AdvancedSearch->ViewValue = $this->description_06->lookupCacheOption($curVal);
			else
				$this->description_06->AdvancedSearch->ViewValue = $this->description_06->Lookup !== NULL && is_array($this->description_06->Lookup->Options) ? $curVal : NULL;
			if ($this->description_06->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->description_06->EditValue = array_values($this->description_06->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->description_06->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_06->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->description_06->EditValue = $arwrk;
			}

			// description_08
			$this->description_08->EditAttrs["class"] = "form-control";
			$this->description_08->EditCustomAttributes = "";
			$this->description_08->EditValue = HtmlEncode($this->description_08->AdvancedSearch->SearchValue);
			$this->description_08->PlaceHolder = RemoveHtml($this->description_08->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// a_operator
			$this->a_operator->EditAttrs["class"] = "form-control";
			$this->a_operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->a_operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->lookupCacheOption($curVal);
			else
				$this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->Lookup !== NULL && is_array($this->a_operator->Lookup->Options) ? $curVal : NULL;
			if ($this->a_operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->a_operator->EditValue = array_values($this->a_operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->a_operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->a_operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->a_operator->EditValue = $arwrk;
			}

			// a_datetime
			$this->a_datetime->EditAttrs["class"] = "form-control";
			$this->a_datetime->EditCustomAttributes = "";
			$this->a_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->a_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->a_datetime->PlaceHolder = RemoveHtml($this->a_datetime->caption());

			// buyer_instruction
			$this->buyer_instruction->EditAttrs["class"] = "form-control";
			$this->buyer_instruction->EditCustomAttributes = "";
			$this->buyer_instruction->EditValue = HtmlEncode($this->buyer_instruction->AdvancedSearch->SearchValue);
			$this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

			// d_09_head
			$this->d_09_head->EditAttrs["class"] = "form-control";
			$this->d_09_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_09_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_09_head->AdvancedSearch->ViewValue = $this->d_09_head->lookupCacheOption($curVal);
			else
				$this->d_09_head->AdvancedSearch->ViewValue = $this->d_09_head->Lookup !== NULL && is_array($this->d_09_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_09_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_09_head->EditValue = array_values($this->d_09_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_09_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_09_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_09_head->EditValue = $arwrk;
			}

			// description_09
			$this->description_09->EditAttrs["class"] = "form-control";
			$this->description_09->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_09->AdvancedSearch->SearchValue = HtmlDecode($this->description_09->AdvancedSearch->SearchValue);
			$this->description_09->EditValue = HtmlEncode($this->description_09->AdvancedSearch->SearchValue);
			$this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

			// d_10_head
			$this->d_10_head->EditAttrs["class"] = "form-control";
			$this->d_10_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_10_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_10_head->AdvancedSearch->ViewValue = $this->d_10_head->lookupCacheOption($curVal);
			else
				$this->d_10_head->AdvancedSearch->ViewValue = $this->d_10_head->Lookup !== NULL && is_array($this->d_10_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_10_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_10_head->EditValue = array_values($this->d_10_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_10_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_10_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_10_head->EditValue = $arwrk;
			}

			// description_10
			$this->description_10->EditAttrs["class"] = "form-control";
			$this->description_10->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_10->AdvancedSearch->SearchValue = HtmlDecode($this->description_10->AdvancedSearch->SearchValue);
			$this->description_10->EditValue = HtmlEncode($this->description_10->AdvancedSearch->SearchValue);
			$this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());

			// d_11_head
			$this->d_11_head->EditAttrs["class"] = "form-control";
			$this->d_11_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_11_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_11_head->AdvancedSearch->ViewValue = $this->d_11_head->lookupCacheOption($curVal);
			else
				$this->d_11_head->AdvancedSearch->ViewValue = $this->d_11_head->Lookup !== NULL && is_array($this->d_11_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_11_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_11_head->EditValue = array_values($this->d_11_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_11_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_11_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_11_head->EditValue = $arwrk;
			}

			// description_11
			$this->description_11->EditAttrs["class"] = "form-control";
			$this->description_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_11->AdvancedSearch->SearchValue = HtmlDecode($this->description_11->AdvancedSearch->SearchValue);
			$this->description_11->EditValue = HtmlEncode($this->description_11->AdvancedSearch->SearchValue);
			$this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

			// d_12_head
			$this->d_12_head->EditAttrs["class"] = "form-control";
			$this->d_12_head->EditCustomAttributes = "";
			$curVal = trim(strval($this->d_12_head->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->d_12_head->AdvancedSearch->ViewValue = $this->d_12_head->lookupCacheOption($curVal);
			else
				$this->d_12_head->AdvancedSearch->ViewValue = $this->d_12_head->Lookup !== NULL && is_array($this->d_12_head->Lookup->Options) ? $curVal : NULL;
			if ($this->d_12_head->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->d_12_head->EditValue = array_values($this->d_12_head->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->d_12_head->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->d_12_head->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->d_12_head->EditValue = $arwrk;
			}

			// description_12
			$this->description_12->EditAttrs["class"] = "form-control";
			$this->description_12->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_12->AdvancedSearch->SearchValue = HtmlDecode($this->description_12->AdvancedSearch->SearchValue);
			$this->description_12->EditValue = HtmlEncode($this->description_12->AdvancedSearch->SearchValue);
			$this->description_12->PlaceHolder = RemoveHtml($this->description_12->caption());

			// action
			$this->_action->EditAttrs["class"] = "form-control";
			$this->_action->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_action->AdvancedSearch->SearchValue = HtmlDecode($this->_action->AdvancedSearch->SearchValue);
			$this->_action->EditValue = HtmlEncode($this->_action->AdvancedSearch->SearchValue);
			$this->_action->PlaceHolder = RemoveHtml($this->_action->caption());

			// url
			$this->url->EditAttrs["class"] = "form-control";
			$this->url->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->url->AdvancedSearch->SearchValue = HtmlDecode($this->url->AdvancedSearch->SearchValue);
			$this->url->EditValue = HtmlEncode($this->url->AdvancedSearch->SearchValue);
			$this->url->PlaceHolder = RemoveHtml($this->url->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckDate($this->buyer_order_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->buyer_order_date->errorMessage());
		}
		if (!CheckInteger($this->buyer_shipping__id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->buyer_shipping__id->errorMessage());
		}
		if (!CheckNumber($this->description_07->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->description_07->errorMessage());
		}
		if (!CheckNumber($this->description_17->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->description_17->errorMessage());
		}
		if (!CheckNumber($this->description_18->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->description_18->errorMessage());
		}
		if (!CheckNumber($this->description_19->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->description_19->errorMessage());
		}
		if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->amount->errorMessage());
		}
		if (!CheckNumber($this->cbm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->cbm->errorMessage());
		}
		if (!CheckNumber($this->description_08->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->description_08->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->order_type->AdvancedSearch->load();
		$this->buyer_id->AdvancedSearch->load();
		$this->buyer_order_no->AdvancedSearch->load();
		$this->buyer_order_date->AdvancedSearch->load();
		$this->cart_id->AdvancedSearch->load();
		$this->buyer_product_ref->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->rid->AdvancedSearch->load();
		$this->despatch_week->AdvancedSearch->load();
		$this->payment_terms->AdvancedSearch->load();
		$this->transport_terms->AdvancedSearch->load();
		$this->buyer_shipping__id->AdvancedSearch->load();
		$this->description_03->AdvancedSearch->load();
		$this->description_07->AdvancedSearch->load();
		$this->description_20->AdvancedSearch->load();
		$this->description_17->AdvancedSearch->load();
		$this->description_18->AdvancedSearch->load();
		$this->description_19->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->price->AdvancedSearch->load();
		$this->currency->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->buyer_size->AdvancedSearch->load();
		$this->description_05->AdvancedSearch->load();
		$this->description_06->AdvancedSearch->load();
		$this->description_08->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->a_operator->AdvancedSearch->load();
		$this->a_datetime->AdvancedSearch->load();
		$this->buyer_instruction->AdvancedSearch->load();
		$this->d_09_head->AdvancedSearch->load();
		$this->description_09->AdvancedSearch->load();
		$this->d_10_head->AdvancedSearch->load();
		$this->description_10->AdvancedSearch->load();
		$this->d_11_head->AdvancedSearch->load();
		$this->description_11->AdvancedSearch->load();
		$this->d_12_head->AdvancedSearch->load();
		$this->description_12->AdvancedSearch->load();
		$this->_action->AdvancedSearch->load();
		$this->url->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("polist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_buyer_id":
					$lookupFilter = function() {
						return "`id` > 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_cart_id":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` = NULL || `po_id` = '' || `po_id` = '0'" : "`po_id` = NULL || `po_id` = '' || `po_id` = '0' || `po_id` = " . $this->id->CurrentValue;
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1 ";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`status`=1 and `product_type`=0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_payment_terms":
					$lookupFilter = function() {
						return "`grp` = 81";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_05":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_06":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_production_site":
					$lookupFilter = function() {
						return "`grp` IN (0,3)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyer_id":
							break;
						case "x_cart_id":
							$row[2] = FormatNumber($row[2], 2, -2, -2, 0);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, 0);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, 0);
							$row['df4'] = $row[4];
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_despatch_week":
							break;
						case "x_payment_terms":
							break;
						case "x_currency":
							break;
						case "x_description_05":
							break;
						case "x_description_06":
							break;
						case "x_operator":
							break;
						case "x_a_operator":
							break;
						case "x_d_09_head":
							break;
						case "x_d_10_head":
							break;
						case "x_d_11_head":
							break;
						case "x_d_12_head":
							break;
						case "x_production_site":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'po');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>