<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for po_setup
 */
class po_setup extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $gst_included;
	public $po_b_transfer;
	public $po_b_sample_auto_auth;
	public $po_s_sample_auto_auth;
	public $po_cbm;
	public $po_buyer_uid;
	public $po_gst;
	public $po_sqm;
	public $po_prod_price;
	public $po_size;
	public $po_bom;
	public $po_process;
	public $po_buyer_code_prod;
	public $mr_live_datetime;
	public $po_b_unauthorize;
	public $cart_b_password;
	public $cart_s_password;
	public $jc_po_yesno;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'po_setup';
		$this->TableName = 'po_setup';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`po_setup`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id
		$this->id = new DbField('po_setup', 'po_setup', 'x_id', 'id', '`id`', '`id`', 16, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Nullable = FALSE; // NOT NULL field
		$this->id->Required = TRUE; // Required field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// gst_included
		$this->gst_included = new DbField('po_setup', 'po_setup', 'x_gst_included', 'gst_included', '`gst_included`', '`gst_included`', 16, -1, FALSE, '`gst_included`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->gst_included->Nullable = FALSE; // NOT NULL field
		$this->gst_included->Required = TRUE; // Required field
		$this->gst_included->Sortable = TRUE; // Allow sort
		$this->gst_included->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->gst_included->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->gst_included->Lookup = new Lookup('gst_included', 'po_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->gst_included->OptionCount = 2;
		$this->gst_included->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['gst_included'] = &$this->gst_included;

		// po_b_transfer
		$this->po_b_transfer = new DbField('po_setup', 'po_setup', 'x_po_b_transfer', 'po_b_transfer', '`po_b_transfer`', '`po_b_transfer`', 17, -1, FALSE, '`po_b_transfer`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->po_b_transfer->Nullable = FALSE; // NOT NULL field
		$this->po_b_transfer->Sortable = TRUE; // Allow sort
		$this->po_b_transfer->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->po_b_transfer->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->po_b_transfer->Lookup = new Lookup('po_b_transfer', 'po_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->po_b_transfer->OptionCount = 2;
		$this->po_b_transfer->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_b_transfer'] = &$this->po_b_transfer;

		// po_b_sample_auto_auth
		$this->po_b_sample_auto_auth = new DbField('po_setup', 'po_setup', 'x_po_b_sample_auto_auth', 'po_b_sample_auto_auth', '`po_b_sample_auto_auth`', '`po_b_sample_auto_auth`', 17, -1, FALSE, '`po_b_sample_auto_auth`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->po_b_sample_auto_auth->Nullable = FALSE; // NOT NULL field
		$this->po_b_sample_auto_auth->Sortable = TRUE; // Allow sort
		$this->po_b_sample_auto_auth->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->po_b_sample_auto_auth->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->po_b_sample_auto_auth->Lookup = new Lookup('po_b_sample_auto_auth', 'po_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->po_b_sample_auto_auth->OptionCount = 2;
		$this->po_b_sample_auto_auth->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_b_sample_auto_auth'] = &$this->po_b_sample_auto_auth;

		// po_s_sample_auto_auth
		$this->po_s_sample_auto_auth = new DbField('po_setup', 'po_setup', 'x_po_s_sample_auto_auth', 'po_s_sample_auto_auth', '`po_s_sample_auto_auth`', '`po_s_sample_auto_auth`', 17, -1, FALSE, '`po_s_sample_auto_auth`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->po_s_sample_auto_auth->Nullable = FALSE; // NOT NULL field
		$this->po_s_sample_auto_auth->Sortable = TRUE; // Allow sort
		$this->po_s_sample_auto_auth->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->po_s_sample_auto_auth->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->po_s_sample_auto_auth->Lookup = new Lookup('po_s_sample_auto_auth', 'po_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->po_s_sample_auto_auth->OptionCount = 2;
		$this->po_s_sample_auto_auth->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_s_sample_auto_auth'] = &$this->po_s_sample_auto_auth;

		// po_cbm
		$this->po_cbm = new DbField('po_setup', 'po_setup', 'x_po_cbm', 'po_cbm', '`po_cbm`', '`po_cbm`', 16, -1, FALSE, '`po_cbm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->po_cbm->Nullable = FALSE; // NOT NULL field
		$this->po_cbm->Required = TRUE; // Required field
		$this->po_cbm->Sortable = TRUE; // Allow sort
		$this->po_cbm->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->po_cbm->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->po_cbm->Lookup = new Lookup('po_cbm', 'po_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->po_cbm->OptionCount = 2;
		$this->po_cbm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_cbm'] = &$this->po_cbm;

		// po_buyer_uid
		$this->po_buyer_uid = new DbField('po_setup', 'po_setup', 'x_po_buyer_uid', 'po_buyer_uid', '`po_buyer_uid`', '`po_buyer_uid`', 16, -1, FALSE, '`po_buyer_uid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->po_buyer_uid->Nullable = FALSE; // NOT NULL field
		$this->po_buyer_uid->Required = TRUE; // Required field
		$this->po_buyer_uid->Sortable = TRUE; // Allow sort
		$this->po_buyer_uid->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->po_buyer_uid->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->po_buyer_uid->Lookup = new Lookup('po_buyer_uid', 'po_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->po_buyer_uid->OptionCount = 2;
		$this->po_buyer_uid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_buyer_uid'] = &$this->po_buyer_uid;

		// po_gst
		$this->po_gst = new DbField('po_setup', 'po_setup', 'x_po_gst', 'po_gst', '`po_gst`', '`po_gst`', 16, -1, FALSE, '`po_gst`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->po_gst->Nullable = FALSE; // NOT NULL field
		$this->po_gst->Required = TRUE; // Required field
		$this->po_gst->Sortable = TRUE; // Allow sort
		$this->po_gst->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->po_gst->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->po_gst->Lookup = new Lookup('po_gst', 'po_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->po_gst->OptionCount = 2;
		$this->po_gst->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_gst'] = &$this->po_gst;

		// po_sqm
		$this->po_sqm = new DbField('po_setup', 'po_setup', 'x_po_sqm', 'po_sqm', '`po_sqm`', '`po_sqm`', 17, -1, FALSE, '`po_sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->po_sqm->Nullable = FALSE; // NOT NULL field
		$this->po_sqm->Required = TRUE; // Required field
		$this->po_sqm->Sortable = TRUE; // Allow sort
		$this->po_sqm->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->po_sqm->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->po_sqm->Lookup = new Lookup('po_sqm', 'po_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->po_sqm->OptionCount = 2;
		$this->po_sqm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_sqm'] = &$this->po_sqm;

		// po_prod_price
		$this->po_prod_price = new DbField('po_setup', 'po_setup', 'x_po_prod_price', 'po_prod_price', '`po_prod_price`', '`po_prod_price`', 17, -1, FALSE, '`po_prod_price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->po_prod_price->Nullable = FALSE; // NOT NULL field
		$this->po_prod_price->Required = TRUE; // Required field
		$this->po_prod_price->Sortable = TRUE; // Allow sort
		$this->po_prod_price->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->po_prod_price->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->po_prod_price->Lookup = new Lookup('po_prod_price', 'po_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->po_prod_price->OptionCount = 2;
		$this->po_prod_price->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_prod_price'] = &$this->po_prod_price;

		// po_size
		$this->po_size = new DbField('po_setup', 'po_setup', 'x_po_size', 'po_size', '`po_size`', '`po_size`', 17, -1, FALSE, '`po_size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_size->Nullable = FALSE; // NOT NULL field
		$this->po_size->Sortable = TRUE; // Allow sort
		$this->po_size->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_size'] = &$this->po_size;

		// po_bom
		$this->po_bom = new DbField('po_setup', 'po_setup', 'x_po_bom', 'po_bom', '`po_bom`', '`po_bom`', 2, -1, FALSE, '`po_bom`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_bom->Nullable = FALSE; // NOT NULL field
		$this->po_bom->Required = TRUE; // Required field
		$this->po_bom->Sortable = TRUE; // Allow sort
		$this->po_bom->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_bom'] = &$this->po_bom;

		// po_process
		$this->po_process = new DbField('po_setup', 'po_setup', 'x_po_process', 'po_process', '`po_process`', '`po_process`', 3, -1, FALSE, '`po_process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_process->Nullable = FALSE; // NOT NULL field
		$this->po_process->Required = TRUE; // Required field
		$this->po_process->Sortable = TRUE; // Allow sort
		$this->po_process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_process'] = &$this->po_process;

		// po_buyer_code_prod
		$this->po_buyer_code_prod = new DbField('po_setup', 'po_setup', 'x_po_buyer_code_prod', 'po_buyer_code_prod', '`po_buyer_code_prod`', '`po_buyer_code_prod`', 17, -1, FALSE, '`po_buyer_code_prod`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_buyer_code_prod->Nullable = FALSE; // NOT NULL field
		$this->po_buyer_code_prod->Sortable = TRUE; // Allow sort
		$this->po_buyer_code_prod->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_buyer_code_prod'] = &$this->po_buyer_code_prod;

		// mr_live_datetime
		$this->mr_live_datetime = new DbField('po_setup', 'po_setup', 'x_mr_live_datetime', 'mr_live_datetime', '`mr_live_datetime`', CastDateFieldForLike('`mr_live_datetime`', 0, "DB"), 135, 0, FALSE, '`mr_live_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mr_live_datetime->Sortable = TRUE; // Allow sort
		$this->mr_live_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['mr_live_datetime'] = &$this->mr_live_datetime;

		// po_b_unauthorize
		$this->po_b_unauthorize = new DbField('po_setup', 'po_setup', 'x_po_b_unauthorize', 'po_b_unauthorize', '`po_b_unauthorize`', '`po_b_unauthorize`', 200, -1, FALSE, '`po_b_unauthorize`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->po_b_unauthorize->Sortable = TRUE; // Allow sort
		$this->po_b_unauthorize->SelectMultiple = TRUE; // Multiple select
		$this->po_b_unauthorize->Lookup = new Lookup('po_b_unauthorize', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->fields['po_b_unauthorize'] = &$this->po_b_unauthorize;

		// cart_b_password
		$this->cart_b_password = new DbField('po_setup', 'po_setup', 'x_cart_b_password', 'cart_b_password', '`cart_b_password`', '`cart_b_password`', 200, -1, FALSE, '`cart_b_password`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cart_b_password->Sortable = TRUE; // Allow sort
		$this->fields['cart_b_password'] = &$this->cart_b_password;

		// cart_s_password
		$this->cart_s_password = new DbField('po_setup', 'po_setup', 'x_cart_s_password', 'cart_s_password', '`cart_s_password`', '`cart_s_password`', 200, -1, FALSE, '`cart_s_password`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cart_s_password->Sortable = TRUE; // Allow sort
		$this->fields['cart_s_password'] = &$this->cart_s_password;

		// jc_po_yesno
		$this->jc_po_yesno = new DbField('po_setup', 'po_setup', 'x_jc_po_yesno', 'jc_po_yesno', '`jc_po_yesno`', '`jc_po_yesno`', 17, -1, FALSE, '`jc_po_yesno`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_po_yesno->Nullable = FALSE; // NOT NULL field
		$this->jc_po_yesno->Sortable = TRUE; // Allow sort
		$this->jc_po_yesno->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_po_yesno'] = &$this->jc_po_yesno;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`po_setup`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->gst_included->DbValue = $row['gst_included'];
		$this->po_b_transfer->DbValue = $row['po_b_transfer'];
		$this->po_b_sample_auto_auth->DbValue = $row['po_b_sample_auto_auth'];
		$this->po_s_sample_auto_auth->DbValue = $row['po_s_sample_auto_auth'];
		$this->po_cbm->DbValue = $row['po_cbm'];
		$this->po_buyer_uid->DbValue = $row['po_buyer_uid'];
		$this->po_gst->DbValue = $row['po_gst'];
		$this->po_sqm->DbValue = $row['po_sqm'];
		$this->po_prod_price->DbValue = $row['po_prod_price'];
		$this->po_size->DbValue = $row['po_size'];
		$this->po_bom->DbValue = $row['po_bom'];
		$this->po_process->DbValue = $row['po_process'];
		$this->po_buyer_code_prod->DbValue = $row['po_buyer_code_prod'];
		$this->mr_live_datetime->DbValue = $row['mr_live_datetime'];
		$this->po_b_unauthorize->DbValue = $row['po_b_unauthorize'];
		$this->cart_b_password->DbValue = $row['cart_b_password'];
		$this->cart_s_password->DbValue = $row['cart_s_password'];
		$this->jc_po_yesno->DbValue = $row['jc_po_yesno'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "po_setuplist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "po_setupview.php")
			return $Language->phrase("View");
		elseif ($pageName == "po_setupedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "po_setupadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "po_setuplist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("po_setupview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("po_setupview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "po_setupadd.php?" . $this->getUrlParm($parm);
		else
			$url = "po_setupadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("po_setupedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("po_setupadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("po_setupdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->gst_included->setDbValue($rs->fields('gst_included'));
		$this->po_b_transfer->setDbValue($rs->fields('po_b_transfer'));
		$this->po_b_sample_auto_auth->setDbValue($rs->fields('po_b_sample_auto_auth'));
		$this->po_s_sample_auto_auth->setDbValue($rs->fields('po_s_sample_auto_auth'));
		$this->po_cbm->setDbValue($rs->fields('po_cbm'));
		$this->po_buyer_uid->setDbValue($rs->fields('po_buyer_uid'));
		$this->po_gst->setDbValue($rs->fields('po_gst'));
		$this->po_sqm->setDbValue($rs->fields('po_sqm'));
		$this->po_prod_price->setDbValue($rs->fields('po_prod_price'));
		$this->po_size->setDbValue($rs->fields('po_size'));
		$this->po_bom->setDbValue($rs->fields('po_bom'));
		$this->po_process->setDbValue($rs->fields('po_process'));
		$this->po_buyer_code_prod->setDbValue($rs->fields('po_buyer_code_prod'));
		$this->mr_live_datetime->setDbValue($rs->fields('mr_live_datetime'));
		$this->po_b_unauthorize->setDbValue($rs->fields('po_b_unauthorize'));
		$this->cart_b_password->setDbValue($rs->fields('cart_b_password'));
		$this->cart_s_password->setDbValue($rs->fields('cart_s_password'));
		$this->jc_po_yesno->setDbValue($rs->fields('jc_po_yesno'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// gst_included
		// po_b_transfer
		// po_b_sample_auto_auth
		// po_s_sample_auto_auth
		// po_cbm
		// po_buyer_uid
		// po_gst
		// po_sqm
		// po_prod_price
		// po_size
		// po_bom
		// po_process
		// po_buyer_code_prod
		// mr_live_datetime
		// po_b_unauthorize
		// cart_b_password
		// cart_s_password
		// jc_po_yesno
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// gst_included
		if (strval($this->gst_included->CurrentValue) <> "") {
			$this->gst_included->ViewValue = $this->gst_included->optionCaption($this->gst_included->CurrentValue);
		} else {
			$this->gst_included->ViewValue = NULL;
		}
		$this->gst_included->ViewCustomAttributes = "";

		// po_b_transfer
		if (strval($this->po_b_transfer->CurrentValue) <> "") {
			$this->po_b_transfer->ViewValue = $this->po_b_transfer->optionCaption($this->po_b_transfer->CurrentValue);
		} else {
			$this->po_b_transfer->ViewValue = NULL;
		}
		$this->po_b_transfer->ViewCustomAttributes = "";

		// po_b_sample_auto_auth
		if (strval($this->po_b_sample_auto_auth->CurrentValue) <> "") {
			$this->po_b_sample_auto_auth->ViewValue = $this->po_b_sample_auto_auth->optionCaption($this->po_b_sample_auto_auth->CurrentValue);
		} else {
			$this->po_b_sample_auto_auth->ViewValue = NULL;
		}
		$this->po_b_sample_auto_auth->ViewCustomAttributes = "";

		// po_s_sample_auto_auth
		if (strval($this->po_s_sample_auto_auth->CurrentValue) <> "") {
			$this->po_s_sample_auto_auth->ViewValue = $this->po_s_sample_auto_auth->optionCaption($this->po_s_sample_auto_auth->CurrentValue);
		} else {
			$this->po_s_sample_auto_auth->ViewValue = NULL;
		}
		$this->po_s_sample_auto_auth->ViewCustomAttributes = "";

		// po_cbm
		if (strval($this->po_cbm->CurrentValue) <> "") {
			$this->po_cbm->ViewValue = $this->po_cbm->optionCaption($this->po_cbm->CurrentValue);
		} else {
			$this->po_cbm->ViewValue = NULL;
		}
		$this->po_cbm->ViewCustomAttributes = "";

		// po_buyer_uid
		if (strval($this->po_buyer_uid->CurrentValue) <> "") {
			$this->po_buyer_uid->ViewValue = $this->po_buyer_uid->optionCaption($this->po_buyer_uid->CurrentValue);
		} else {
			$this->po_buyer_uid->ViewValue = NULL;
		}
		$this->po_buyer_uid->ViewCustomAttributes = "";

		// po_gst
		if (strval($this->po_gst->CurrentValue) <> "") {
			$this->po_gst->ViewValue = $this->po_gst->optionCaption($this->po_gst->CurrentValue);
		} else {
			$this->po_gst->ViewValue = NULL;
		}
		$this->po_gst->ViewCustomAttributes = "";

		// po_sqm
		if (strval($this->po_sqm->CurrentValue) <> "") {
			$this->po_sqm->ViewValue = $this->po_sqm->optionCaption($this->po_sqm->CurrentValue);
		} else {
			$this->po_sqm->ViewValue = NULL;
		}
		$this->po_sqm->ViewCustomAttributes = "";

		// po_prod_price
		if (strval($this->po_prod_price->CurrentValue) <> "") {
			$this->po_prod_price->ViewValue = $this->po_prod_price->optionCaption($this->po_prod_price->CurrentValue);
		} else {
			$this->po_prod_price->ViewValue = NULL;
		}
		$this->po_prod_price->ViewCustomAttributes = "";

		// po_size
		$this->po_size->ViewValue = $this->po_size->CurrentValue;
		$this->po_size->ViewValue = FormatNumber($this->po_size->ViewValue, 0, -2, -2, -2);
		$this->po_size->ViewCustomAttributes = "";

		// po_bom
		$this->po_bom->ViewValue = $this->po_bom->CurrentValue;
		$this->po_bom->ViewValue = FormatNumber($this->po_bom->ViewValue, 0, -2, -2, -2);
		$this->po_bom->ViewCustomAttributes = "";

		// po_process
		$this->po_process->ViewValue = $this->po_process->CurrentValue;
		$this->po_process->ViewValue = FormatNumber($this->po_process->ViewValue, 0, -2, -2, -2);
		$this->po_process->ViewCustomAttributes = "";

		// po_buyer_code_prod
		$this->po_buyer_code_prod->ViewValue = $this->po_buyer_code_prod->CurrentValue;
		$this->po_buyer_code_prod->ViewValue = FormatNumber($this->po_buyer_code_prod->ViewValue, 0, -2, -2, -2);
		$this->po_buyer_code_prod->ViewCustomAttributes = "";

		// mr_live_datetime
		$this->mr_live_datetime->ViewValue = $this->mr_live_datetime->CurrentValue;
		$this->mr_live_datetime->ViewValue = FormatDateTime($this->mr_live_datetime->ViewValue, 0);
		$this->mr_live_datetime->ViewCustomAttributes = "";

		// po_b_unauthorize
		$curVal = strval($this->po_b_unauthorize->CurrentValue);
		if ($curVal <> "") {
			$this->po_b_unauthorize->ViewValue = $this->po_b_unauthorize->lookupCacheOption($curVal);
			if ($this->po_b_unauthorize->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`activated`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->po_b_unauthorize->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->po_b_unauthorize->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->po_b_unauthorize->ViewValue->add($this->po_b_unauthorize->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->po_b_unauthorize->ViewValue = $this->po_b_unauthorize->CurrentValue;
				}
			}
		} else {
			$this->po_b_unauthorize->ViewValue = NULL;
		}
		$this->po_b_unauthorize->ViewCustomAttributes = "";

		// cart_b_password
		$this->cart_b_password->ViewValue = $this->cart_b_password->CurrentValue;
		$this->cart_b_password->ViewCustomAttributes = "";

		// cart_s_password
		$this->cart_s_password->ViewValue = $this->cart_s_password->CurrentValue;
		$this->cart_s_password->ViewCustomAttributes = "";

		// jc_po_yesno
		$this->jc_po_yesno->ViewValue = $this->jc_po_yesno->CurrentValue;
		$this->jc_po_yesno->ViewValue = FormatNumber($this->jc_po_yesno->ViewValue, 0, -2, -2, -2);
		$this->jc_po_yesno->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// gst_included
		$this->gst_included->LinkCustomAttributes = "";
		$this->gst_included->HrefValue = "";
		$this->gst_included->TooltipValue = "";

		// po_b_transfer
		$this->po_b_transfer->LinkCustomAttributes = "";
		$this->po_b_transfer->HrefValue = "";
		$this->po_b_transfer->TooltipValue = "";

		// po_b_sample_auto_auth
		$this->po_b_sample_auto_auth->LinkCustomAttributes = "";
		$this->po_b_sample_auto_auth->HrefValue = "";
		$this->po_b_sample_auto_auth->TooltipValue = "";

		// po_s_sample_auto_auth
		$this->po_s_sample_auto_auth->LinkCustomAttributes = "";
		$this->po_s_sample_auto_auth->HrefValue = "";
		$this->po_s_sample_auto_auth->TooltipValue = "";

		// po_cbm
		$this->po_cbm->LinkCustomAttributes = "";
		$this->po_cbm->HrefValue = "";
		$this->po_cbm->TooltipValue = "";

		// po_buyer_uid
		$this->po_buyer_uid->LinkCustomAttributes = "";
		$this->po_buyer_uid->HrefValue = "";
		$this->po_buyer_uid->TooltipValue = "";

		// po_gst
		$this->po_gst->LinkCustomAttributes = "";
		$this->po_gst->HrefValue = "";
		$this->po_gst->TooltipValue = "";

		// po_sqm
		$this->po_sqm->LinkCustomAttributes = "";
		$this->po_sqm->HrefValue = "";
		$this->po_sqm->TooltipValue = "";

		// po_prod_price
		$this->po_prod_price->LinkCustomAttributes = "";
		$this->po_prod_price->HrefValue = "";
		$this->po_prod_price->TooltipValue = "";

		// po_size
		$this->po_size->LinkCustomAttributes = "";
		$this->po_size->HrefValue = "";
		$this->po_size->TooltipValue = "";

		// po_bom
		$this->po_bom->LinkCustomAttributes = "";
		$this->po_bom->HrefValue = "";
		$this->po_bom->TooltipValue = "";

		// po_process
		$this->po_process->LinkCustomAttributes = "";
		$this->po_process->HrefValue = "";
		$this->po_process->TooltipValue = "";

		// po_buyer_code_prod
		$this->po_buyer_code_prod->LinkCustomAttributes = "";
		$this->po_buyer_code_prod->HrefValue = "";
		$this->po_buyer_code_prod->TooltipValue = "";

		// mr_live_datetime
		$this->mr_live_datetime->LinkCustomAttributes = "";
		$this->mr_live_datetime->HrefValue = "";
		$this->mr_live_datetime->TooltipValue = "";

		// po_b_unauthorize
		$this->po_b_unauthorize->LinkCustomAttributes = "";
		$this->po_b_unauthorize->HrefValue = "";
		$this->po_b_unauthorize->TooltipValue = "";

		// cart_b_password
		$this->cart_b_password->LinkCustomAttributes = "";
		$this->cart_b_password->HrefValue = "";
		$this->cart_b_password->TooltipValue = "";

		// cart_s_password
		$this->cart_s_password->LinkCustomAttributes = "";
		$this->cart_s_password->HrefValue = "";
		$this->cart_s_password->TooltipValue = "";

		// jc_po_yesno
		$this->jc_po_yesno->LinkCustomAttributes = "";
		$this->jc_po_yesno->HrefValue = "";
		$this->jc_po_yesno->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// gst_included
		$this->gst_included->EditAttrs["class"] = "form-control";
		$this->gst_included->EditCustomAttributes = "";
		$this->gst_included->EditValue = $this->gst_included->options(TRUE);

		// po_b_transfer
		$this->po_b_transfer->EditAttrs["class"] = "form-control";
		$this->po_b_transfer->EditCustomAttributes = "";
		$this->po_b_transfer->EditValue = $this->po_b_transfer->options(TRUE);

		// po_b_sample_auto_auth
		$this->po_b_sample_auto_auth->EditAttrs["class"] = "form-control";
		$this->po_b_sample_auto_auth->EditCustomAttributes = "";
		$this->po_b_sample_auto_auth->EditValue = $this->po_b_sample_auto_auth->options(TRUE);

		// po_s_sample_auto_auth
		$this->po_s_sample_auto_auth->EditAttrs["class"] = "form-control";
		$this->po_s_sample_auto_auth->EditCustomAttributes = "";
		$this->po_s_sample_auto_auth->EditValue = $this->po_s_sample_auto_auth->options(TRUE);

		// po_cbm
		$this->po_cbm->EditAttrs["class"] = "form-control";
		$this->po_cbm->EditCustomAttributes = "";
		$this->po_cbm->EditValue = $this->po_cbm->options(TRUE);

		// po_buyer_uid
		$this->po_buyer_uid->EditAttrs["class"] = "form-control";
		$this->po_buyer_uid->EditCustomAttributes = "";
		$this->po_buyer_uid->EditValue = $this->po_buyer_uid->options(TRUE);

		// po_gst
		$this->po_gst->EditAttrs["class"] = "form-control";
		$this->po_gst->EditCustomAttributes = "";
		$this->po_gst->EditValue = $this->po_gst->options(TRUE);

		// po_sqm
		$this->po_sqm->EditAttrs["class"] = "form-control";
		$this->po_sqm->EditCustomAttributes = "";
		$this->po_sqm->EditValue = $this->po_sqm->options(TRUE);

		// po_prod_price
		$this->po_prod_price->EditAttrs["class"] = "form-control";
		$this->po_prod_price->EditCustomAttributes = "";
		$this->po_prod_price->EditValue = $this->po_prod_price->options(TRUE);

		// po_size
		$this->po_size->EditAttrs["class"] = "form-control";
		$this->po_size->EditCustomAttributes = "";
		$this->po_size->EditValue = $this->po_size->CurrentValue;
		$this->po_size->PlaceHolder = RemoveHtml($this->po_size->caption());

		// po_bom
		$this->po_bom->EditAttrs["class"] = "form-control";
		$this->po_bom->EditCustomAttributes = "";
		$this->po_bom->EditValue = $this->po_bom->CurrentValue;
		$this->po_bom->PlaceHolder = RemoveHtml($this->po_bom->caption());

		// po_process
		$this->po_process->EditAttrs["class"] = "form-control";
		$this->po_process->EditCustomAttributes = "";
		$this->po_process->EditValue = $this->po_process->CurrentValue;
		$this->po_process->PlaceHolder = RemoveHtml($this->po_process->caption());

		// po_buyer_code_prod
		$this->po_buyer_code_prod->EditAttrs["class"] = "form-control";
		$this->po_buyer_code_prod->EditCustomAttributes = "";
		$this->po_buyer_code_prod->EditValue = $this->po_buyer_code_prod->CurrentValue;
		$this->po_buyer_code_prod->PlaceHolder = RemoveHtml($this->po_buyer_code_prod->caption());

		// mr_live_datetime
		$this->mr_live_datetime->EditAttrs["class"] = "form-control";
		$this->mr_live_datetime->EditCustomAttributes = "";
		$this->mr_live_datetime->EditValue = FormatDateTime($this->mr_live_datetime->CurrentValue, 8);
		$this->mr_live_datetime->PlaceHolder = RemoveHtml($this->mr_live_datetime->caption());

		// po_b_unauthorize
		$this->po_b_unauthorize->EditAttrs["class"] = "form-control";
		$this->po_b_unauthorize->EditCustomAttributes = "";

		// cart_b_password
		$this->cart_b_password->EditAttrs["class"] = "form-control";
		$this->cart_b_password->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->cart_b_password->CurrentValue = HtmlDecode($this->cart_b_password->CurrentValue);
		$this->cart_b_password->EditValue = $this->cart_b_password->CurrentValue;
		$this->cart_b_password->PlaceHolder = RemoveHtml($this->cart_b_password->caption());

		// cart_s_password
		$this->cart_s_password->EditAttrs["class"] = "form-control";
		$this->cart_s_password->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->cart_s_password->CurrentValue = HtmlDecode($this->cart_s_password->CurrentValue);
		$this->cart_s_password->EditValue = $this->cart_s_password->CurrentValue;
		$this->cart_s_password->PlaceHolder = RemoveHtml($this->cart_s_password->caption());

		// jc_po_yesno
		$this->jc_po_yesno->EditAttrs["class"] = "form-control";
		$this->jc_po_yesno->EditCustomAttributes = "";
		$this->jc_po_yesno->EditValue = $this->jc_po_yesno->CurrentValue;
		$this->jc_po_yesno->PlaceHolder = RemoveHtml($this->jc_po_yesno->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->gst_included);
					$doc->exportCaption($this->po_b_transfer);
					$doc->exportCaption($this->po_b_sample_auto_auth);
					$doc->exportCaption($this->po_s_sample_auto_auth);
					$doc->exportCaption($this->po_cbm);
					$doc->exportCaption($this->po_buyer_uid);
					$doc->exportCaption($this->po_gst);
					$doc->exportCaption($this->po_sqm);
					$doc->exportCaption($this->po_prod_price);
					$doc->exportCaption($this->po_size);
					$doc->exportCaption($this->po_bom);
					$doc->exportCaption($this->po_process);
					$doc->exportCaption($this->po_buyer_code_prod);
					$doc->exportCaption($this->mr_live_datetime);
					$doc->exportCaption($this->po_b_unauthorize);
					$doc->exportCaption($this->cart_b_password);
					$doc->exportCaption($this->cart_s_password);
					$doc->exportCaption($this->jc_po_yesno);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->gst_included);
					$doc->exportCaption($this->po_b_transfer);
					$doc->exportCaption($this->po_b_sample_auto_auth);
					$doc->exportCaption($this->po_s_sample_auto_auth);
					$doc->exportCaption($this->po_cbm);
					$doc->exportCaption($this->po_buyer_uid);
					$doc->exportCaption($this->po_gst);
					$doc->exportCaption($this->po_sqm);
					$doc->exportCaption($this->po_prod_price);
					$doc->exportCaption($this->po_size);
					$doc->exportCaption($this->po_bom);
					$doc->exportCaption($this->po_process);
					$doc->exportCaption($this->po_buyer_code_prod);
					$doc->exportCaption($this->mr_live_datetime);
					$doc->exportCaption($this->po_b_unauthorize);
					$doc->exportCaption($this->cart_b_password);
					$doc->exportCaption($this->cart_s_password);
					$doc->exportCaption($this->jc_po_yesno);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->gst_included);
						$doc->exportField($this->po_b_transfer);
						$doc->exportField($this->po_b_sample_auto_auth);
						$doc->exportField($this->po_s_sample_auto_auth);
						$doc->exportField($this->po_cbm);
						$doc->exportField($this->po_buyer_uid);
						$doc->exportField($this->po_gst);
						$doc->exportField($this->po_sqm);
						$doc->exportField($this->po_prod_price);
						$doc->exportField($this->po_size);
						$doc->exportField($this->po_bom);
						$doc->exportField($this->po_process);
						$doc->exportField($this->po_buyer_code_prod);
						$doc->exportField($this->mr_live_datetime);
						$doc->exportField($this->po_b_unauthorize);
						$doc->exportField($this->cart_b_password);
						$doc->exportField($this->cart_s_password);
						$doc->exportField($this->jc_po_yesno);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->gst_included);
						$doc->exportField($this->po_b_transfer);
						$doc->exportField($this->po_b_sample_auto_auth);
						$doc->exportField($this->po_s_sample_auto_auth);
						$doc->exportField($this->po_cbm);
						$doc->exportField($this->po_buyer_uid);
						$doc->exportField($this->po_gst);
						$doc->exportField($this->po_sqm);
						$doc->exportField($this->po_prod_price);
						$doc->exportField($this->po_size);
						$doc->exportField($this->po_bom);
						$doc->exportField($this->po_process);
						$doc->exportField($this->po_buyer_code_prod);
						$doc->exportField($this->mr_live_datetime);
						$doc->exportField($this->po_b_unauthorize);
						$doc->exportField($this->cart_b_password);
						$doc->exportField($this->cart_s_password);
						$doc->exportField($this->jc_po_yesno);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>