<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class po_setup_add extends po_setup
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'po_setup';

	// Page object name
	public $PageObjName = "po_setup_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (po_setup)
		if (!isset($GLOBALS["po_setup"]) || get_class($GLOBALS["po_setup"]) == PROJECT_NAMESPACE . "po_setup") {
			$GLOBALS["po_setup"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["po_setup"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_setup');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $po_setup;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($po_setup);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "po_setupview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("po_setuplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->gst_included->setVisibility();
		$this->po_b_transfer->setVisibility();
		$this->po_b_sample_auto_auth->setVisibility();
		$this->po_s_sample_auto_auth->setVisibility();
		$this->po_cbm->setVisibility();
		$this->po_buyer_uid->setVisibility();
		$this->po_gst->setVisibility();
		$this->po_sqm->setVisibility();
		$this->po_prod_price->setVisibility();
		$this->po_size->setVisibility();
		$this->po_bom->setVisibility();
		$this->po_process->setVisibility();
		$this->po_buyer_code_prod->setVisibility();
		$this->mr_live_datetime->setVisibility();
		$this->po_b_unauthorize->setVisibility();
		$this->cart_b_password->setVisibility();
		$this->cart_s_password->setVisibility();
		$this->jc_po_yesno->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->po_b_unauthorize);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("po_setuplist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "po_setuplist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "po_setupview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->gst_included->CurrentValue = 0;
		$this->po_b_transfer->CurrentValue = NULL;
		$this->po_b_transfer->OldValue = $this->po_b_transfer->CurrentValue;
		$this->po_b_sample_auto_auth->CurrentValue = 0;
		$this->po_s_sample_auto_auth->CurrentValue = 0;
		$this->po_cbm->CurrentValue = 0;
		$this->po_buyer_uid->CurrentValue = 1;
		$this->po_gst->CurrentValue = 1;
		$this->po_sqm->CurrentValue = NULL;
		$this->po_sqm->OldValue = $this->po_sqm->CurrentValue;
		$this->po_prod_price->CurrentValue = NULL;
		$this->po_prod_price->OldValue = $this->po_prod_price->CurrentValue;
		$this->po_size->CurrentValue = 0;
		$this->po_bom->CurrentValue = NULL;
		$this->po_bom->OldValue = $this->po_bom->CurrentValue;
		$this->po_process->CurrentValue = NULL;
		$this->po_process->OldValue = $this->po_process->CurrentValue;
		$this->po_buyer_code_prod->CurrentValue = 0;
		$this->mr_live_datetime->CurrentValue = NULL;
		$this->mr_live_datetime->OldValue = $this->mr_live_datetime->CurrentValue;
		$this->po_b_unauthorize->CurrentValue = NULL;
		$this->po_b_unauthorize->OldValue = $this->po_b_unauthorize->CurrentValue;
		$this->cart_b_password->CurrentValue = NULL;
		$this->cart_b_password->OldValue = $this->cart_b_password->CurrentValue;
		$this->cart_s_password->CurrentValue = NULL;
		$this->cart_s_password->OldValue = $this->cart_s_password->CurrentValue;
		$this->jc_po_yesno->CurrentValue = 0;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id->Visible = FALSE; // Disable update for API request
			else
				$this->id->setFormValue($val);
		}

		// Check field name 'gst_included' first before field var 'x_gst_included'
		$val = $CurrentForm->hasValue("gst_included") ? $CurrentForm->getValue("gst_included") : $CurrentForm->getValue("x_gst_included");
		if (!$this->gst_included->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gst_included->Visible = FALSE; // Disable update for API request
			else
				$this->gst_included->setFormValue($val);
		}

		// Check field name 'po_b_transfer' first before field var 'x_po_b_transfer'
		$val = $CurrentForm->hasValue("po_b_transfer") ? $CurrentForm->getValue("po_b_transfer") : $CurrentForm->getValue("x_po_b_transfer");
		if (!$this->po_b_transfer->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_b_transfer->Visible = FALSE; // Disable update for API request
			else
				$this->po_b_transfer->setFormValue($val);
		}

		// Check field name 'po_b_sample_auto_auth' first before field var 'x_po_b_sample_auto_auth'
		$val = $CurrentForm->hasValue("po_b_sample_auto_auth") ? $CurrentForm->getValue("po_b_sample_auto_auth") : $CurrentForm->getValue("x_po_b_sample_auto_auth");
		if (!$this->po_b_sample_auto_auth->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_b_sample_auto_auth->Visible = FALSE; // Disable update for API request
			else
				$this->po_b_sample_auto_auth->setFormValue($val);
		}

		// Check field name 'po_s_sample_auto_auth' first before field var 'x_po_s_sample_auto_auth'
		$val = $CurrentForm->hasValue("po_s_sample_auto_auth") ? $CurrentForm->getValue("po_s_sample_auto_auth") : $CurrentForm->getValue("x_po_s_sample_auto_auth");
		if (!$this->po_s_sample_auto_auth->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_s_sample_auto_auth->Visible = FALSE; // Disable update for API request
			else
				$this->po_s_sample_auto_auth->setFormValue($val);
		}

		// Check field name 'po_cbm' first before field var 'x_po_cbm'
		$val = $CurrentForm->hasValue("po_cbm") ? $CurrentForm->getValue("po_cbm") : $CurrentForm->getValue("x_po_cbm");
		if (!$this->po_cbm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_cbm->Visible = FALSE; // Disable update for API request
			else
				$this->po_cbm->setFormValue($val);
		}

		// Check field name 'po_buyer_uid' first before field var 'x_po_buyer_uid'
		$val = $CurrentForm->hasValue("po_buyer_uid") ? $CurrentForm->getValue("po_buyer_uid") : $CurrentForm->getValue("x_po_buyer_uid");
		if (!$this->po_buyer_uid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_buyer_uid->Visible = FALSE; // Disable update for API request
			else
				$this->po_buyer_uid->setFormValue($val);
		}

		// Check field name 'po_gst' first before field var 'x_po_gst'
		$val = $CurrentForm->hasValue("po_gst") ? $CurrentForm->getValue("po_gst") : $CurrentForm->getValue("x_po_gst");
		if (!$this->po_gst->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_gst->Visible = FALSE; // Disable update for API request
			else
				$this->po_gst->setFormValue($val);
		}

		// Check field name 'po_sqm' first before field var 'x_po_sqm'
		$val = $CurrentForm->hasValue("po_sqm") ? $CurrentForm->getValue("po_sqm") : $CurrentForm->getValue("x_po_sqm");
		if (!$this->po_sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_sqm->Visible = FALSE; // Disable update for API request
			else
				$this->po_sqm->setFormValue($val);
		}

		// Check field name 'po_prod_price' first before field var 'x_po_prod_price'
		$val = $CurrentForm->hasValue("po_prod_price") ? $CurrentForm->getValue("po_prod_price") : $CurrentForm->getValue("x_po_prod_price");
		if (!$this->po_prod_price->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_prod_price->Visible = FALSE; // Disable update for API request
			else
				$this->po_prod_price->setFormValue($val);
		}

		// Check field name 'po_size' first before field var 'x_po_size'
		$val = $CurrentForm->hasValue("po_size") ? $CurrentForm->getValue("po_size") : $CurrentForm->getValue("x_po_size");
		if (!$this->po_size->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_size->Visible = FALSE; // Disable update for API request
			else
				$this->po_size->setFormValue($val);
		}

		// Check field name 'po_bom' first before field var 'x_po_bom'
		$val = $CurrentForm->hasValue("po_bom") ? $CurrentForm->getValue("po_bom") : $CurrentForm->getValue("x_po_bom");
		if (!$this->po_bom->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_bom->Visible = FALSE; // Disable update for API request
			else
				$this->po_bom->setFormValue($val);
		}

		// Check field name 'po_process' first before field var 'x_po_process'
		$val = $CurrentForm->hasValue("po_process") ? $CurrentForm->getValue("po_process") : $CurrentForm->getValue("x_po_process");
		if (!$this->po_process->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_process->Visible = FALSE; // Disable update for API request
			else
				$this->po_process->setFormValue($val);
		}

		// Check field name 'po_buyer_code_prod' first before field var 'x_po_buyer_code_prod'
		$val = $CurrentForm->hasValue("po_buyer_code_prod") ? $CurrentForm->getValue("po_buyer_code_prod") : $CurrentForm->getValue("x_po_buyer_code_prod");
		if (!$this->po_buyer_code_prod->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_buyer_code_prod->Visible = FALSE; // Disable update for API request
			else
				$this->po_buyer_code_prod->setFormValue($val);
		}

		// Check field name 'mr_live_datetime' first before field var 'x_mr_live_datetime'
		$val = $CurrentForm->hasValue("mr_live_datetime") ? $CurrentForm->getValue("mr_live_datetime") : $CurrentForm->getValue("x_mr_live_datetime");
		if (!$this->mr_live_datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mr_live_datetime->Visible = FALSE; // Disable update for API request
			else
				$this->mr_live_datetime->setFormValue($val);
			$this->mr_live_datetime->CurrentValue = UnFormatDateTime($this->mr_live_datetime->CurrentValue, 0);
		}

		// Check field name 'po_b_unauthorize' first before field var 'x_po_b_unauthorize'
		$val = $CurrentForm->hasValue("po_b_unauthorize") ? $CurrentForm->getValue("po_b_unauthorize") : $CurrentForm->getValue("x_po_b_unauthorize");
		if (!$this->po_b_unauthorize->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_b_unauthorize->Visible = FALSE; // Disable update for API request
			else
				$this->po_b_unauthorize->setFormValue($val);
		}

		// Check field name 'cart_b_password' first before field var 'x_cart_b_password'
		$val = $CurrentForm->hasValue("cart_b_password") ? $CurrentForm->getValue("cart_b_password") : $CurrentForm->getValue("x_cart_b_password");
		if (!$this->cart_b_password->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cart_b_password->Visible = FALSE; // Disable update for API request
			else
				$this->cart_b_password->setFormValue($val);
		}

		// Check field name 'cart_s_password' first before field var 'x_cart_s_password'
		$val = $CurrentForm->hasValue("cart_s_password") ? $CurrentForm->getValue("cart_s_password") : $CurrentForm->getValue("x_cart_s_password");
		if (!$this->cart_s_password->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cart_s_password->Visible = FALSE; // Disable update for API request
			else
				$this->cart_s_password->setFormValue($val);
		}

		// Check field name 'jc_po_yesno' first before field var 'x_jc_po_yesno'
		$val = $CurrentForm->hasValue("jc_po_yesno") ? $CurrentForm->getValue("jc_po_yesno") : $CurrentForm->getValue("x_jc_po_yesno");
		if (!$this->jc_po_yesno->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_po_yesno->Visible = FALSE; // Disable update for API request
			else
				$this->jc_po_yesno->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->gst_included->CurrentValue = $this->gst_included->FormValue;
		$this->po_b_transfer->CurrentValue = $this->po_b_transfer->FormValue;
		$this->po_b_sample_auto_auth->CurrentValue = $this->po_b_sample_auto_auth->FormValue;
		$this->po_s_sample_auto_auth->CurrentValue = $this->po_s_sample_auto_auth->FormValue;
		$this->po_cbm->CurrentValue = $this->po_cbm->FormValue;
		$this->po_buyer_uid->CurrentValue = $this->po_buyer_uid->FormValue;
		$this->po_gst->CurrentValue = $this->po_gst->FormValue;
		$this->po_sqm->CurrentValue = $this->po_sqm->FormValue;
		$this->po_prod_price->CurrentValue = $this->po_prod_price->FormValue;
		$this->po_size->CurrentValue = $this->po_size->FormValue;
		$this->po_bom->CurrentValue = $this->po_bom->FormValue;
		$this->po_process->CurrentValue = $this->po_process->FormValue;
		$this->po_buyer_code_prod->CurrentValue = $this->po_buyer_code_prod->FormValue;
		$this->mr_live_datetime->CurrentValue = $this->mr_live_datetime->FormValue;
		$this->mr_live_datetime->CurrentValue = UnFormatDateTime($this->mr_live_datetime->CurrentValue, 0);
		$this->po_b_unauthorize->CurrentValue = $this->po_b_unauthorize->FormValue;
		$this->cart_b_password->CurrentValue = $this->cart_b_password->FormValue;
		$this->cart_s_password->CurrentValue = $this->cart_s_password->FormValue;
		$this->jc_po_yesno->CurrentValue = $this->jc_po_yesno->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->gst_included->setDbValue($row['gst_included']);
		$this->po_b_transfer->setDbValue($row['po_b_transfer']);
		$this->po_b_sample_auto_auth->setDbValue($row['po_b_sample_auto_auth']);
		$this->po_s_sample_auto_auth->setDbValue($row['po_s_sample_auto_auth']);
		$this->po_cbm->setDbValue($row['po_cbm']);
		$this->po_buyer_uid->setDbValue($row['po_buyer_uid']);
		$this->po_gst->setDbValue($row['po_gst']);
		$this->po_sqm->setDbValue($row['po_sqm']);
		$this->po_prod_price->setDbValue($row['po_prod_price']);
		$this->po_size->setDbValue($row['po_size']);
		$this->po_bom->setDbValue($row['po_bom']);
		$this->po_process->setDbValue($row['po_process']);
		$this->po_buyer_code_prod->setDbValue($row['po_buyer_code_prod']);
		$this->mr_live_datetime->setDbValue($row['mr_live_datetime']);
		$this->po_b_unauthorize->setDbValue($row['po_b_unauthorize']);
		$this->cart_b_password->setDbValue($row['cart_b_password']);
		$this->cart_s_password->setDbValue($row['cart_s_password']);
		$this->jc_po_yesno->setDbValue($row['jc_po_yesno']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['gst_included'] = $this->gst_included->CurrentValue;
		$row['po_b_transfer'] = $this->po_b_transfer->CurrentValue;
		$row['po_b_sample_auto_auth'] = $this->po_b_sample_auto_auth->CurrentValue;
		$row['po_s_sample_auto_auth'] = $this->po_s_sample_auto_auth->CurrentValue;
		$row['po_cbm'] = $this->po_cbm->CurrentValue;
		$row['po_buyer_uid'] = $this->po_buyer_uid->CurrentValue;
		$row['po_gst'] = $this->po_gst->CurrentValue;
		$row['po_sqm'] = $this->po_sqm->CurrentValue;
		$row['po_prod_price'] = $this->po_prod_price->CurrentValue;
		$row['po_size'] = $this->po_size->CurrentValue;
		$row['po_bom'] = $this->po_bom->CurrentValue;
		$row['po_process'] = $this->po_process->CurrentValue;
		$row['po_buyer_code_prod'] = $this->po_buyer_code_prod->CurrentValue;
		$row['mr_live_datetime'] = $this->mr_live_datetime->CurrentValue;
		$row['po_b_unauthorize'] = $this->po_b_unauthorize->CurrentValue;
		$row['cart_b_password'] = $this->cart_b_password->CurrentValue;
		$row['cart_s_password'] = $this->cart_s_password->CurrentValue;
		$row['jc_po_yesno'] = $this->jc_po_yesno->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// gst_included
		// po_b_transfer
		// po_b_sample_auto_auth
		// po_s_sample_auto_auth
		// po_cbm
		// po_buyer_uid
		// po_gst
		// po_sqm
		// po_prod_price
		// po_size
		// po_bom
		// po_process
		// po_buyer_code_prod
		// mr_live_datetime
		// po_b_unauthorize
		// cart_b_password
		// cart_s_password
		// jc_po_yesno

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// gst_included
			if (strval($this->gst_included->CurrentValue) <> "") {
				$this->gst_included->ViewValue = $this->gst_included->optionCaption($this->gst_included->CurrentValue);
			} else {
				$this->gst_included->ViewValue = NULL;
			}
			$this->gst_included->ViewCustomAttributes = "";

			// po_b_transfer
			if (strval($this->po_b_transfer->CurrentValue) <> "") {
				$this->po_b_transfer->ViewValue = $this->po_b_transfer->optionCaption($this->po_b_transfer->CurrentValue);
			} else {
				$this->po_b_transfer->ViewValue = NULL;
			}
			$this->po_b_transfer->ViewCustomAttributes = "";

			// po_b_sample_auto_auth
			if (strval($this->po_b_sample_auto_auth->CurrentValue) <> "") {
				$this->po_b_sample_auto_auth->ViewValue = $this->po_b_sample_auto_auth->optionCaption($this->po_b_sample_auto_auth->CurrentValue);
			} else {
				$this->po_b_sample_auto_auth->ViewValue = NULL;
			}
			$this->po_b_sample_auto_auth->ViewCustomAttributes = "";

			// po_s_sample_auto_auth
			if (strval($this->po_s_sample_auto_auth->CurrentValue) <> "") {
				$this->po_s_sample_auto_auth->ViewValue = $this->po_s_sample_auto_auth->optionCaption($this->po_s_sample_auto_auth->CurrentValue);
			} else {
				$this->po_s_sample_auto_auth->ViewValue = NULL;
			}
			$this->po_s_sample_auto_auth->ViewCustomAttributes = "";

			// po_cbm
			if (strval($this->po_cbm->CurrentValue) <> "") {
				$this->po_cbm->ViewValue = $this->po_cbm->optionCaption($this->po_cbm->CurrentValue);
			} else {
				$this->po_cbm->ViewValue = NULL;
			}
			$this->po_cbm->ViewCustomAttributes = "";

			// po_buyer_uid
			if (strval($this->po_buyer_uid->CurrentValue) <> "") {
				$this->po_buyer_uid->ViewValue = $this->po_buyer_uid->optionCaption($this->po_buyer_uid->CurrentValue);
			} else {
				$this->po_buyer_uid->ViewValue = NULL;
			}
			$this->po_buyer_uid->ViewCustomAttributes = "";

			// po_gst
			if (strval($this->po_gst->CurrentValue) <> "") {
				$this->po_gst->ViewValue = $this->po_gst->optionCaption($this->po_gst->CurrentValue);
			} else {
				$this->po_gst->ViewValue = NULL;
			}
			$this->po_gst->ViewCustomAttributes = "";

			// po_sqm
			if (strval($this->po_sqm->CurrentValue) <> "") {
				$this->po_sqm->ViewValue = $this->po_sqm->optionCaption($this->po_sqm->CurrentValue);
			} else {
				$this->po_sqm->ViewValue = NULL;
			}
			$this->po_sqm->ViewCustomAttributes = "";

			// po_prod_price
			if (strval($this->po_prod_price->CurrentValue) <> "") {
				$this->po_prod_price->ViewValue = $this->po_prod_price->optionCaption($this->po_prod_price->CurrentValue);
			} else {
				$this->po_prod_price->ViewValue = NULL;
			}
			$this->po_prod_price->ViewCustomAttributes = "";

			// po_size
			$this->po_size->ViewValue = $this->po_size->CurrentValue;
			$this->po_size->ViewValue = FormatNumber($this->po_size->ViewValue, 0, -2, -2, -2);
			$this->po_size->ViewCustomAttributes = "";

			// po_bom
			$this->po_bom->ViewValue = $this->po_bom->CurrentValue;
			$this->po_bom->ViewValue = FormatNumber($this->po_bom->ViewValue, 0, -2, -2, -2);
			$this->po_bom->ViewCustomAttributes = "";

			// po_process
			$this->po_process->ViewValue = $this->po_process->CurrentValue;
			$this->po_process->ViewValue = FormatNumber($this->po_process->ViewValue, 0, -2, -2, -2);
			$this->po_process->ViewCustomAttributes = "";

			// po_buyer_code_prod
			$this->po_buyer_code_prod->ViewValue = $this->po_buyer_code_prod->CurrentValue;
			$this->po_buyer_code_prod->ViewValue = FormatNumber($this->po_buyer_code_prod->ViewValue, 0, -2, -2, -2);
			$this->po_buyer_code_prod->ViewCustomAttributes = "";

			// mr_live_datetime
			$this->mr_live_datetime->ViewValue = $this->mr_live_datetime->CurrentValue;
			$this->mr_live_datetime->ViewValue = FormatDateTime($this->mr_live_datetime->ViewValue, 0);
			$this->mr_live_datetime->ViewCustomAttributes = "";

			// po_b_unauthorize
			$curVal = strval($this->po_b_unauthorize->CurrentValue);
			if ($curVal <> "") {
				$this->po_b_unauthorize->ViewValue = $this->po_b_unauthorize->lookupCacheOption($curVal);
				if ($this->po_b_unauthorize->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->po_b_unauthorize->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->po_b_unauthorize->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->po_b_unauthorize->ViewValue->add($this->po_b_unauthorize->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->po_b_unauthorize->ViewValue = $this->po_b_unauthorize->CurrentValue;
					}
				}
			} else {
				$this->po_b_unauthorize->ViewValue = NULL;
			}
			$this->po_b_unauthorize->ViewCustomAttributes = "";

			// cart_b_password
			$this->cart_b_password->ViewValue = $this->cart_b_password->CurrentValue;
			$this->cart_b_password->ViewCustomAttributes = "";

			// cart_s_password
			$this->cart_s_password->ViewValue = $this->cart_s_password->CurrentValue;
			$this->cart_s_password->ViewCustomAttributes = "";

			// jc_po_yesno
			$this->jc_po_yesno->ViewValue = $this->jc_po_yesno->CurrentValue;
			$this->jc_po_yesno->ViewValue = FormatNumber($this->jc_po_yesno->ViewValue, 0, -2, -2, -2);
			$this->jc_po_yesno->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// gst_included
			$this->gst_included->LinkCustomAttributes = "";
			$this->gst_included->HrefValue = "";
			$this->gst_included->TooltipValue = "";

			// po_b_transfer
			$this->po_b_transfer->LinkCustomAttributes = "";
			$this->po_b_transfer->HrefValue = "";
			$this->po_b_transfer->TooltipValue = "";

			// po_b_sample_auto_auth
			$this->po_b_sample_auto_auth->LinkCustomAttributes = "";
			$this->po_b_sample_auto_auth->HrefValue = "";
			$this->po_b_sample_auto_auth->TooltipValue = "";

			// po_s_sample_auto_auth
			$this->po_s_sample_auto_auth->LinkCustomAttributes = "";
			$this->po_s_sample_auto_auth->HrefValue = "";
			$this->po_s_sample_auto_auth->TooltipValue = "";

			// po_cbm
			$this->po_cbm->LinkCustomAttributes = "";
			$this->po_cbm->HrefValue = "";
			$this->po_cbm->TooltipValue = "";

			// po_buyer_uid
			$this->po_buyer_uid->LinkCustomAttributes = "";
			$this->po_buyer_uid->HrefValue = "";
			$this->po_buyer_uid->TooltipValue = "";

			// po_gst
			$this->po_gst->LinkCustomAttributes = "";
			$this->po_gst->HrefValue = "";
			$this->po_gst->TooltipValue = "";

			// po_sqm
			$this->po_sqm->LinkCustomAttributes = "";
			$this->po_sqm->HrefValue = "";
			$this->po_sqm->TooltipValue = "";

			// po_prod_price
			$this->po_prod_price->LinkCustomAttributes = "";
			$this->po_prod_price->HrefValue = "";
			$this->po_prod_price->TooltipValue = "";

			// po_size
			$this->po_size->LinkCustomAttributes = "";
			$this->po_size->HrefValue = "";
			$this->po_size->TooltipValue = "";

			// po_bom
			$this->po_bom->LinkCustomAttributes = "";
			$this->po_bom->HrefValue = "";
			$this->po_bom->TooltipValue = "";

			// po_process
			$this->po_process->LinkCustomAttributes = "";
			$this->po_process->HrefValue = "";
			$this->po_process->TooltipValue = "";

			// po_buyer_code_prod
			$this->po_buyer_code_prod->LinkCustomAttributes = "";
			$this->po_buyer_code_prod->HrefValue = "";
			$this->po_buyer_code_prod->TooltipValue = "";

			// mr_live_datetime
			$this->mr_live_datetime->LinkCustomAttributes = "";
			$this->mr_live_datetime->HrefValue = "";
			$this->mr_live_datetime->TooltipValue = "";

			// po_b_unauthorize
			$this->po_b_unauthorize->LinkCustomAttributes = "";
			$this->po_b_unauthorize->HrefValue = "";
			$this->po_b_unauthorize->TooltipValue = "";

			// cart_b_password
			$this->cart_b_password->LinkCustomAttributes = "";
			$this->cart_b_password->HrefValue = "";
			$this->cart_b_password->TooltipValue = "";

			// cart_s_password
			$this->cart_s_password->LinkCustomAttributes = "";
			$this->cart_s_password->HrefValue = "";
			$this->cart_s_password->TooltipValue = "";

			// jc_po_yesno
			$this->jc_po_yesno->LinkCustomAttributes = "";
			$this->jc_po_yesno->HrefValue = "";
			$this->jc_po_yesno->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->CurrentValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// gst_included
			$this->gst_included->EditAttrs["class"] = "form-control";
			$this->gst_included->EditCustomAttributes = "";
			$this->gst_included->EditValue = $this->gst_included->options(TRUE);

			// po_b_transfer
			$this->po_b_transfer->EditAttrs["class"] = "form-control";
			$this->po_b_transfer->EditCustomAttributes = "";
			$this->po_b_transfer->EditValue = $this->po_b_transfer->options(TRUE);

			// po_b_sample_auto_auth
			$this->po_b_sample_auto_auth->EditAttrs["class"] = "form-control";
			$this->po_b_sample_auto_auth->EditCustomAttributes = "";
			$this->po_b_sample_auto_auth->EditValue = $this->po_b_sample_auto_auth->options(TRUE);

			// po_s_sample_auto_auth
			$this->po_s_sample_auto_auth->EditAttrs["class"] = "form-control";
			$this->po_s_sample_auto_auth->EditCustomAttributes = "";
			$this->po_s_sample_auto_auth->EditValue = $this->po_s_sample_auto_auth->options(TRUE);

			// po_cbm
			$this->po_cbm->EditAttrs["class"] = "form-control";
			$this->po_cbm->EditCustomAttributes = "";
			$this->po_cbm->EditValue = $this->po_cbm->options(TRUE);

			// po_buyer_uid
			$this->po_buyer_uid->EditAttrs["class"] = "form-control";
			$this->po_buyer_uid->EditCustomAttributes = "";
			$this->po_buyer_uid->EditValue = $this->po_buyer_uid->options(TRUE);

			// po_gst
			$this->po_gst->EditAttrs["class"] = "form-control";
			$this->po_gst->EditCustomAttributes = "";
			$this->po_gst->EditValue = $this->po_gst->options(TRUE);

			// po_sqm
			$this->po_sqm->EditAttrs["class"] = "form-control";
			$this->po_sqm->EditCustomAttributes = "";
			$this->po_sqm->EditValue = $this->po_sqm->options(TRUE);

			// po_prod_price
			$this->po_prod_price->EditAttrs["class"] = "form-control";
			$this->po_prod_price->EditCustomAttributes = "";
			$this->po_prod_price->EditValue = $this->po_prod_price->options(TRUE);

			// po_size
			$this->po_size->EditAttrs["class"] = "form-control";
			$this->po_size->EditCustomAttributes = "";
			$this->po_size->EditValue = HtmlEncode($this->po_size->CurrentValue);
			$this->po_size->PlaceHolder = RemoveHtml($this->po_size->caption());

			// po_bom
			$this->po_bom->EditAttrs["class"] = "form-control";
			$this->po_bom->EditCustomAttributes = "";
			$this->po_bom->EditValue = HtmlEncode($this->po_bom->CurrentValue);
			$this->po_bom->PlaceHolder = RemoveHtml($this->po_bom->caption());

			// po_process
			$this->po_process->EditAttrs["class"] = "form-control";
			$this->po_process->EditCustomAttributes = "";
			$this->po_process->EditValue = HtmlEncode($this->po_process->CurrentValue);
			$this->po_process->PlaceHolder = RemoveHtml($this->po_process->caption());

			// po_buyer_code_prod
			$this->po_buyer_code_prod->EditAttrs["class"] = "form-control";
			$this->po_buyer_code_prod->EditCustomAttributes = "";
			$this->po_buyer_code_prod->EditValue = HtmlEncode($this->po_buyer_code_prod->CurrentValue);
			$this->po_buyer_code_prod->PlaceHolder = RemoveHtml($this->po_buyer_code_prod->caption());

			// mr_live_datetime
			$this->mr_live_datetime->EditAttrs["class"] = "form-control";
			$this->mr_live_datetime->EditCustomAttributes = "";
			$this->mr_live_datetime->EditValue = HtmlEncode(FormatDateTime($this->mr_live_datetime->CurrentValue, 8));
			$this->mr_live_datetime->PlaceHolder = RemoveHtml($this->mr_live_datetime->caption());

			// po_b_unauthorize
			$this->po_b_unauthorize->EditAttrs["class"] = "form-control";
			$this->po_b_unauthorize->EditCustomAttributes = "";
			$curVal = trim(strval($this->po_b_unauthorize->CurrentValue));
			if ($curVal <> "")
				$this->po_b_unauthorize->ViewValue = $this->po_b_unauthorize->lookupCacheOption($curVal);
			else
				$this->po_b_unauthorize->ViewValue = $this->po_b_unauthorize->Lookup !== NULL && is_array($this->po_b_unauthorize->Lookup->Options) ? $curVal : NULL;
			if ($this->po_b_unauthorize->ViewValue !== NULL) { // Load from cache
				$this->po_b_unauthorize->EditValue = array_values($this->po_b_unauthorize->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`activated`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->po_b_unauthorize->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->po_b_unauthorize->EditValue = $arwrk;
			}

			// cart_b_password
			$this->cart_b_password->EditAttrs["class"] = "form-control";
			$this->cart_b_password->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->cart_b_password->CurrentValue = HtmlDecode($this->cart_b_password->CurrentValue);
			$this->cart_b_password->EditValue = HtmlEncode($this->cart_b_password->CurrentValue);
			$this->cart_b_password->PlaceHolder = RemoveHtml($this->cart_b_password->caption());

			// cart_s_password
			$this->cart_s_password->EditAttrs["class"] = "form-control";
			$this->cart_s_password->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->cart_s_password->CurrentValue = HtmlDecode($this->cart_s_password->CurrentValue);
			$this->cart_s_password->EditValue = HtmlEncode($this->cart_s_password->CurrentValue);
			$this->cart_s_password->PlaceHolder = RemoveHtml($this->cart_s_password->caption());

			// jc_po_yesno
			$this->jc_po_yesno->EditAttrs["class"] = "form-control";
			$this->jc_po_yesno->EditCustomAttributes = "";
			$this->jc_po_yesno->EditValue = HtmlEncode($this->jc_po_yesno->CurrentValue);
			$this->jc_po_yesno->PlaceHolder = RemoveHtml($this->jc_po_yesno->caption());

			// Add refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// gst_included
			$this->gst_included->LinkCustomAttributes = "";
			$this->gst_included->HrefValue = "";

			// po_b_transfer
			$this->po_b_transfer->LinkCustomAttributes = "";
			$this->po_b_transfer->HrefValue = "";

			// po_b_sample_auto_auth
			$this->po_b_sample_auto_auth->LinkCustomAttributes = "";
			$this->po_b_sample_auto_auth->HrefValue = "";

			// po_s_sample_auto_auth
			$this->po_s_sample_auto_auth->LinkCustomAttributes = "";
			$this->po_s_sample_auto_auth->HrefValue = "";

			// po_cbm
			$this->po_cbm->LinkCustomAttributes = "";
			$this->po_cbm->HrefValue = "";

			// po_buyer_uid
			$this->po_buyer_uid->LinkCustomAttributes = "";
			$this->po_buyer_uid->HrefValue = "";

			// po_gst
			$this->po_gst->LinkCustomAttributes = "";
			$this->po_gst->HrefValue = "";

			// po_sqm
			$this->po_sqm->LinkCustomAttributes = "";
			$this->po_sqm->HrefValue = "";

			// po_prod_price
			$this->po_prod_price->LinkCustomAttributes = "";
			$this->po_prod_price->HrefValue = "";

			// po_size
			$this->po_size->LinkCustomAttributes = "";
			$this->po_size->HrefValue = "";

			// po_bom
			$this->po_bom->LinkCustomAttributes = "";
			$this->po_bom->HrefValue = "";

			// po_process
			$this->po_process->LinkCustomAttributes = "";
			$this->po_process->HrefValue = "";

			// po_buyer_code_prod
			$this->po_buyer_code_prod->LinkCustomAttributes = "";
			$this->po_buyer_code_prod->HrefValue = "";

			// mr_live_datetime
			$this->mr_live_datetime->LinkCustomAttributes = "";
			$this->mr_live_datetime->HrefValue = "";

			// po_b_unauthorize
			$this->po_b_unauthorize->LinkCustomAttributes = "";
			$this->po_b_unauthorize->HrefValue = "";

			// cart_b_password
			$this->cart_b_password->LinkCustomAttributes = "";
			$this->cart_b_password->HrefValue = "";

			// cart_s_password
			$this->cart_s_password->LinkCustomAttributes = "";
			$this->cart_s_password->HrefValue = "";

			// jc_po_yesno
			$this->jc_po_yesno->LinkCustomAttributes = "";
			$this->jc_po_yesno->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->id->FormValue)) {
			AddMessage($FormError, $this->id->errorMessage());
		}
		if ($this->gst_included->Required) {
			if (!$this->gst_included->IsDetailKey && $this->gst_included->FormValue != NULL && $this->gst_included->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gst_included->caption(), $this->gst_included->RequiredErrorMessage));
			}
		}
		if ($this->po_b_transfer->Required) {
			if (!$this->po_b_transfer->IsDetailKey && $this->po_b_transfer->FormValue != NULL && $this->po_b_transfer->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_b_transfer->caption(), $this->po_b_transfer->RequiredErrorMessage));
			}
		}
		if ($this->po_b_sample_auto_auth->Required) {
			if (!$this->po_b_sample_auto_auth->IsDetailKey && $this->po_b_sample_auto_auth->FormValue != NULL && $this->po_b_sample_auto_auth->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_b_sample_auto_auth->caption(), $this->po_b_sample_auto_auth->RequiredErrorMessage));
			}
		}
		if ($this->po_s_sample_auto_auth->Required) {
			if (!$this->po_s_sample_auto_auth->IsDetailKey && $this->po_s_sample_auto_auth->FormValue != NULL && $this->po_s_sample_auto_auth->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_s_sample_auto_auth->caption(), $this->po_s_sample_auto_auth->RequiredErrorMessage));
			}
		}
		if ($this->po_cbm->Required) {
			if (!$this->po_cbm->IsDetailKey && $this->po_cbm->FormValue != NULL && $this->po_cbm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_cbm->caption(), $this->po_cbm->RequiredErrorMessage));
			}
		}
		if ($this->po_buyer_uid->Required) {
			if (!$this->po_buyer_uid->IsDetailKey && $this->po_buyer_uid->FormValue != NULL && $this->po_buyer_uid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_buyer_uid->caption(), $this->po_buyer_uid->RequiredErrorMessage));
			}
		}
		if ($this->po_gst->Required) {
			if (!$this->po_gst->IsDetailKey && $this->po_gst->FormValue != NULL && $this->po_gst->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_gst->caption(), $this->po_gst->RequiredErrorMessage));
			}
		}
		if ($this->po_sqm->Required) {
			if (!$this->po_sqm->IsDetailKey && $this->po_sqm->FormValue != NULL && $this->po_sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_sqm->caption(), $this->po_sqm->RequiredErrorMessage));
			}
		}
		if ($this->po_prod_price->Required) {
			if (!$this->po_prod_price->IsDetailKey && $this->po_prod_price->FormValue != NULL && $this->po_prod_price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_prod_price->caption(), $this->po_prod_price->RequiredErrorMessage));
			}
		}
		if ($this->po_size->Required) {
			if (!$this->po_size->IsDetailKey && $this->po_size->FormValue != NULL && $this->po_size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_size->caption(), $this->po_size->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->po_size->FormValue)) {
			AddMessage($FormError, $this->po_size->errorMessage());
		}
		if ($this->po_bom->Required) {
			if (!$this->po_bom->IsDetailKey && $this->po_bom->FormValue != NULL && $this->po_bom->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_bom->caption(), $this->po_bom->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->po_bom->FormValue)) {
			AddMessage($FormError, $this->po_bom->errorMessage());
		}
		if ($this->po_process->Required) {
			if (!$this->po_process->IsDetailKey && $this->po_process->FormValue != NULL && $this->po_process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_process->caption(), $this->po_process->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->po_process->FormValue)) {
			AddMessage($FormError, $this->po_process->errorMessage());
		}
		if ($this->po_buyer_code_prod->Required) {
			if (!$this->po_buyer_code_prod->IsDetailKey && $this->po_buyer_code_prod->FormValue != NULL && $this->po_buyer_code_prod->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_buyer_code_prod->caption(), $this->po_buyer_code_prod->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->po_buyer_code_prod->FormValue)) {
			AddMessage($FormError, $this->po_buyer_code_prod->errorMessage());
		}
		if ($this->mr_live_datetime->Required) {
			if (!$this->mr_live_datetime->IsDetailKey && $this->mr_live_datetime->FormValue != NULL && $this->mr_live_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mr_live_datetime->caption(), $this->mr_live_datetime->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->mr_live_datetime->FormValue)) {
			AddMessage($FormError, $this->mr_live_datetime->errorMessage());
		}
		if ($this->po_b_unauthorize->Required) {
			if ($this->po_b_unauthorize->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_b_unauthorize->caption(), $this->po_b_unauthorize->RequiredErrorMessage));
			}
		}
		if ($this->cart_b_password->Required) {
			if (!$this->cart_b_password->IsDetailKey && $this->cart_b_password->FormValue != NULL && $this->cart_b_password->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cart_b_password->caption(), $this->cart_b_password->RequiredErrorMessage));
			}
		}
		if ($this->cart_s_password->Required) {
			if (!$this->cart_s_password->IsDetailKey && $this->cart_s_password->FormValue != NULL && $this->cart_s_password->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cart_s_password->caption(), $this->cart_s_password->RequiredErrorMessage));
			}
		}
		if ($this->jc_po_yesno->Required) {
			if (!$this->jc_po_yesno->IsDetailKey && $this->jc_po_yesno->FormValue != NULL && $this->jc_po_yesno->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_po_yesno->caption(), $this->jc_po_yesno->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->jc_po_yesno->FormValue)) {
			AddMessage($FormError, $this->jc_po_yesno->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// id
		$this->id->setDbValueDef($rsnew, $this->id->CurrentValue, 0, FALSE);

		// gst_included
		$this->gst_included->setDbValueDef($rsnew, $this->gst_included->CurrentValue, 0, strval($this->gst_included->CurrentValue) == "");

		// po_b_transfer
		$this->po_b_transfer->setDbValueDef($rsnew, $this->po_b_transfer->CurrentValue, 0, strval($this->po_b_transfer->CurrentValue) == "");

		// po_b_sample_auto_auth
		$this->po_b_sample_auto_auth->setDbValueDef($rsnew, $this->po_b_sample_auto_auth->CurrentValue, 0, strval($this->po_b_sample_auto_auth->CurrentValue) == "");

		// po_s_sample_auto_auth
		$this->po_s_sample_auto_auth->setDbValueDef($rsnew, $this->po_s_sample_auto_auth->CurrentValue, 0, strval($this->po_s_sample_auto_auth->CurrentValue) == "");

		// po_cbm
		$this->po_cbm->setDbValueDef($rsnew, $this->po_cbm->CurrentValue, 0, strval($this->po_cbm->CurrentValue) == "");

		// po_buyer_uid
		$this->po_buyer_uid->setDbValueDef($rsnew, $this->po_buyer_uid->CurrentValue, 0, strval($this->po_buyer_uid->CurrentValue) == "");

		// po_gst
		$this->po_gst->setDbValueDef($rsnew, $this->po_gst->CurrentValue, 0, strval($this->po_gst->CurrentValue) == "");

		// po_sqm
		$this->po_sqm->setDbValueDef($rsnew, $this->po_sqm->CurrentValue, 0, FALSE);

		// po_prod_price
		$this->po_prod_price->setDbValueDef($rsnew, $this->po_prod_price->CurrentValue, 0, FALSE);

		// po_size
		$this->po_size->setDbValueDef($rsnew, $this->po_size->CurrentValue, 0, strval($this->po_size->CurrentValue) == "");

		// po_bom
		$this->po_bom->setDbValueDef($rsnew, $this->po_bom->CurrentValue, 0, FALSE);

		// po_process
		$this->po_process->setDbValueDef($rsnew, $this->po_process->CurrentValue, 0, FALSE);

		// po_buyer_code_prod
		$this->po_buyer_code_prod->setDbValueDef($rsnew, $this->po_buyer_code_prod->CurrentValue, 0, strval($this->po_buyer_code_prod->CurrentValue) == "");

		// mr_live_datetime
		$this->mr_live_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->mr_live_datetime->CurrentValue, 0), NULL, FALSE);

		// po_b_unauthorize
		$this->po_b_unauthorize->setDbValueDef($rsnew, $this->po_b_unauthorize->CurrentValue, NULL, strval($this->po_b_unauthorize->CurrentValue) == "");

		// cart_b_password
		$this->cart_b_password->setDbValueDef($rsnew, $this->cart_b_password->CurrentValue, NULL, FALSE);

		// cart_s_password
		$this->cart_s_password->setDbValueDef($rsnew, $this->cart_s_password->CurrentValue, NULL, FALSE);

		// jc_po_yesno
		$this->jc_po_yesno->setDbValueDef($rsnew, $this->jc_po_yesno->CurrentValue, 0, strval($this->jc_po_yesno->CurrentValue) == "");

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['id']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check for duplicate key
		if ($insertRow && $this->ValidateKey) {
			$filter = $this->getRecordFilter();
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
				$this->setFailureMessage($keyErrMsg);
				$rsChk->close();
				$insertRow = FALSE;
			}
		}
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("po_setuplist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_po_b_unauthorize":
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_po_b_unauthorize":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>