<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class po_setup_delete extends po_setup
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'po_setup';

	// Page object name
	public $PageObjName = "po_setup_delete";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (po_setup)
		if (!isset($GLOBALS["po_setup"]) || get_class($GLOBALS["po_setup"]) == PROJECT_NAMESPACE . "po_setup") {
			$GLOBALS["po_setup"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["po_setup"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_setup');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $po_setup;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($po_setup);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $TotalRecs = 0;
	public $RecCnt;
	public $RecKeys = array();
	public $StartRowCnt = 1;
	public $RowCnt = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("po_setuplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->gst_included->setVisibility();
		$this->po_b_transfer->setVisibility();
		$this->po_b_sample_auto_auth->setVisibility();
		$this->po_s_sample_auto_auth->setVisibility();
		$this->po_cbm->setVisibility();
		$this->po_buyer_uid->setVisibility();
		$this->po_gst->setVisibility();
		$this->po_sqm->setVisibility();
		$this->po_prod_price->setVisibility();
		$this->po_size->setVisibility();
		$this->po_bom->setVisibility();
		$this->po_process->setVisibility();
		$this->po_buyer_code_prod->setVisibility();
		$this->mr_live_datetime->setVisibility();
		$this->po_b_unauthorize->setVisibility();
		$this->cart_b_password->setVisibility();
		$this->cart_s_password->setVisibility();
		$this->jc_po_yesno->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->po_b_unauthorize);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("po_setuplist.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecs <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("po_setuplist.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->gst_included->setDbValue($row['gst_included']);
		$this->po_b_transfer->setDbValue($row['po_b_transfer']);
		$this->po_b_sample_auto_auth->setDbValue($row['po_b_sample_auto_auth']);
		$this->po_s_sample_auto_auth->setDbValue($row['po_s_sample_auto_auth']);
		$this->po_cbm->setDbValue($row['po_cbm']);
		$this->po_buyer_uid->setDbValue($row['po_buyer_uid']);
		$this->po_gst->setDbValue($row['po_gst']);
		$this->po_sqm->setDbValue($row['po_sqm']);
		$this->po_prod_price->setDbValue($row['po_prod_price']);
		$this->po_size->setDbValue($row['po_size']);
		$this->po_bom->setDbValue($row['po_bom']);
		$this->po_process->setDbValue($row['po_process']);
		$this->po_buyer_code_prod->setDbValue($row['po_buyer_code_prod']);
		$this->mr_live_datetime->setDbValue($row['mr_live_datetime']);
		$this->po_b_unauthorize->setDbValue($row['po_b_unauthorize']);
		$this->cart_b_password->setDbValue($row['cart_b_password']);
		$this->cart_s_password->setDbValue($row['cart_s_password']);
		$this->jc_po_yesno->setDbValue($row['jc_po_yesno']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['gst_included'] = NULL;
		$row['po_b_transfer'] = NULL;
		$row['po_b_sample_auto_auth'] = NULL;
		$row['po_s_sample_auto_auth'] = NULL;
		$row['po_cbm'] = NULL;
		$row['po_buyer_uid'] = NULL;
		$row['po_gst'] = NULL;
		$row['po_sqm'] = NULL;
		$row['po_prod_price'] = NULL;
		$row['po_size'] = NULL;
		$row['po_bom'] = NULL;
		$row['po_process'] = NULL;
		$row['po_buyer_code_prod'] = NULL;
		$row['mr_live_datetime'] = NULL;
		$row['po_b_unauthorize'] = NULL;
		$row['cart_b_password'] = NULL;
		$row['cart_s_password'] = NULL;
		$row['jc_po_yesno'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// gst_included
		// po_b_transfer
		// po_b_sample_auto_auth
		// po_s_sample_auto_auth
		// po_cbm
		// po_buyer_uid
		// po_gst
		// po_sqm
		// po_prod_price
		// po_size
		// po_bom
		// po_process
		// po_buyer_code_prod
		// mr_live_datetime
		// po_b_unauthorize
		// cart_b_password
		// cart_s_password
		// jc_po_yesno

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// gst_included
			if (strval($this->gst_included->CurrentValue) <> "") {
				$this->gst_included->ViewValue = $this->gst_included->optionCaption($this->gst_included->CurrentValue);
			} else {
				$this->gst_included->ViewValue = NULL;
			}
			$this->gst_included->ViewCustomAttributes = "";

			// po_b_transfer
			if (strval($this->po_b_transfer->CurrentValue) <> "") {
				$this->po_b_transfer->ViewValue = $this->po_b_transfer->optionCaption($this->po_b_transfer->CurrentValue);
			} else {
				$this->po_b_transfer->ViewValue = NULL;
			}
			$this->po_b_transfer->ViewCustomAttributes = "";

			// po_b_sample_auto_auth
			if (strval($this->po_b_sample_auto_auth->CurrentValue) <> "") {
				$this->po_b_sample_auto_auth->ViewValue = $this->po_b_sample_auto_auth->optionCaption($this->po_b_sample_auto_auth->CurrentValue);
			} else {
				$this->po_b_sample_auto_auth->ViewValue = NULL;
			}
			$this->po_b_sample_auto_auth->ViewCustomAttributes = "";

			// po_s_sample_auto_auth
			if (strval($this->po_s_sample_auto_auth->CurrentValue) <> "") {
				$this->po_s_sample_auto_auth->ViewValue = $this->po_s_sample_auto_auth->optionCaption($this->po_s_sample_auto_auth->CurrentValue);
			} else {
				$this->po_s_sample_auto_auth->ViewValue = NULL;
			}
			$this->po_s_sample_auto_auth->ViewCustomAttributes = "";

			// po_cbm
			if (strval($this->po_cbm->CurrentValue) <> "") {
				$this->po_cbm->ViewValue = $this->po_cbm->optionCaption($this->po_cbm->CurrentValue);
			} else {
				$this->po_cbm->ViewValue = NULL;
			}
			$this->po_cbm->ViewCustomAttributes = "";

			// po_buyer_uid
			if (strval($this->po_buyer_uid->CurrentValue) <> "") {
				$this->po_buyer_uid->ViewValue = $this->po_buyer_uid->optionCaption($this->po_buyer_uid->CurrentValue);
			} else {
				$this->po_buyer_uid->ViewValue = NULL;
			}
			$this->po_buyer_uid->ViewCustomAttributes = "";

			// po_gst
			if (strval($this->po_gst->CurrentValue) <> "") {
				$this->po_gst->ViewValue = $this->po_gst->optionCaption($this->po_gst->CurrentValue);
			} else {
				$this->po_gst->ViewValue = NULL;
			}
			$this->po_gst->ViewCustomAttributes = "";

			// po_sqm
			if (strval($this->po_sqm->CurrentValue) <> "") {
				$this->po_sqm->ViewValue = $this->po_sqm->optionCaption($this->po_sqm->CurrentValue);
			} else {
				$this->po_sqm->ViewValue = NULL;
			}
			$this->po_sqm->ViewCustomAttributes = "";

			// po_prod_price
			if (strval($this->po_prod_price->CurrentValue) <> "") {
				$this->po_prod_price->ViewValue = $this->po_prod_price->optionCaption($this->po_prod_price->CurrentValue);
			} else {
				$this->po_prod_price->ViewValue = NULL;
			}
			$this->po_prod_price->ViewCustomAttributes = "";

			// po_size
			$this->po_size->ViewValue = $this->po_size->CurrentValue;
			$this->po_size->ViewValue = FormatNumber($this->po_size->ViewValue, 0, -2, -2, -2);
			$this->po_size->ViewCustomAttributes = "";

			// po_bom
			$this->po_bom->ViewValue = $this->po_bom->CurrentValue;
			$this->po_bom->ViewValue = FormatNumber($this->po_bom->ViewValue, 0, -2, -2, -2);
			$this->po_bom->ViewCustomAttributes = "";

			// po_process
			$this->po_process->ViewValue = $this->po_process->CurrentValue;
			$this->po_process->ViewValue = FormatNumber($this->po_process->ViewValue, 0, -2, -2, -2);
			$this->po_process->ViewCustomAttributes = "";

			// po_buyer_code_prod
			$this->po_buyer_code_prod->ViewValue = $this->po_buyer_code_prod->CurrentValue;
			$this->po_buyer_code_prod->ViewValue = FormatNumber($this->po_buyer_code_prod->ViewValue, 0, -2, -2, -2);
			$this->po_buyer_code_prod->ViewCustomAttributes = "";

			// mr_live_datetime
			$this->mr_live_datetime->ViewValue = $this->mr_live_datetime->CurrentValue;
			$this->mr_live_datetime->ViewValue = FormatDateTime($this->mr_live_datetime->ViewValue, 0);
			$this->mr_live_datetime->ViewCustomAttributes = "";

			// po_b_unauthorize
			$curVal = strval($this->po_b_unauthorize->CurrentValue);
			if ($curVal <> "") {
				$this->po_b_unauthorize->ViewValue = $this->po_b_unauthorize->lookupCacheOption($curVal);
				if ($this->po_b_unauthorize->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->po_b_unauthorize->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->po_b_unauthorize->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->po_b_unauthorize->ViewValue->add($this->po_b_unauthorize->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->po_b_unauthorize->ViewValue = $this->po_b_unauthorize->CurrentValue;
					}
				}
			} else {
				$this->po_b_unauthorize->ViewValue = NULL;
			}
			$this->po_b_unauthorize->ViewCustomAttributes = "";

			// cart_b_password
			$this->cart_b_password->ViewValue = $this->cart_b_password->CurrentValue;
			$this->cart_b_password->ViewCustomAttributes = "";

			// cart_s_password
			$this->cart_s_password->ViewValue = $this->cart_s_password->CurrentValue;
			$this->cart_s_password->ViewCustomAttributes = "";

			// jc_po_yesno
			$this->jc_po_yesno->ViewValue = $this->jc_po_yesno->CurrentValue;
			$this->jc_po_yesno->ViewValue = FormatNumber($this->jc_po_yesno->ViewValue, 0, -2, -2, -2);
			$this->jc_po_yesno->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// gst_included
			$this->gst_included->LinkCustomAttributes = "";
			$this->gst_included->HrefValue = "";
			$this->gst_included->TooltipValue = "";

			// po_b_transfer
			$this->po_b_transfer->LinkCustomAttributes = "";
			$this->po_b_transfer->HrefValue = "";
			$this->po_b_transfer->TooltipValue = "";

			// po_b_sample_auto_auth
			$this->po_b_sample_auto_auth->LinkCustomAttributes = "";
			$this->po_b_sample_auto_auth->HrefValue = "";
			$this->po_b_sample_auto_auth->TooltipValue = "";

			// po_s_sample_auto_auth
			$this->po_s_sample_auto_auth->LinkCustomAttributes = "";
			$this->po_s_sample_auto_auth->HrefValue = "";
			$this->po_s_sample_auto_auth->TooltipValue = "";

			// po_cbm
			$this->po_cbm->LinkCustomAttributes = "";
			$this->po_cbm->HrefValue = "";
			$this->po_cbm->TooltipValue = "";

			// po_buyer_uid
			$this->po_buyer_uid->LinkCustomAttributes = "";
			$this->po_buyer_uid->HrefValue = "";
			$this->po_buyer_uid->TooltipValue = "";

			// po_gst
			$this->po_gst->LinkCustomAttributes = "";
			$this->po_gst->HrefValue = "";
			$this->po_gst->TooltipValue = "";

			// po_sqm
			$this->po_sqm->LinkCustomAttributes = "";
			$this->po_sqm->HrefValue = "";
			$this->po_sqm->TooltipValue = "";

			// po_prod_price
			$this->po_prod_price->LinkCustomAttributes = "";
			$this->po_prod_price->HrefValue = "";
			$this->po_prod_price->TooltipValue = "";

			// po_size
			$this->po_size->LinkCustomAttributes = "";
			$this->po_size->HrefValue = "";
			$this->po_size->TooltipValue = "";

			// po_bom
			$this->po_bom->LinkCustomAttributes = "";
			$this->po_bom->HrefValue = "";
			$this->po_bom->TooltipValue = "";

			// po_process
			$this->po_process->LinkCustomAttributes = "";
			$this->po_process->HrefValue = "";
			$this->po_process->TooltipValue = "";

			// po_buyer_code_prod
			$this->po_buyer_code_prod->LinkCustomAttributes = "";
			$this->po_buyer_code_prod->HrefValue = "";
			$this->po_buyer_code_prod->TooltipValue = "";

			// mr_live_datetime
			$this->mr_live_datetime->LinkCustomAttributes = "";
			$this->mr_live_datetime->HrefValue = "";
			$this->mr_live_datetime->TooltipValue = "";

			// po_b_unauthorize
			$this->po_b_unauthorize->LinkCustomAttributes = "";
			$this->po_b_unauthorize->HrefValue = "";
			$this->po_b_unauthorize->TooltipValue = "";

			// cart_b_password
			$this->cart_b_password->LinkCustomAttributes = "";
			$this->cart_b_password->HrefValue = "";
			$this->cart_b_password->TooltipValue = "";

			// cart_s_password
			$this->cart_s_password->LinkCustomAttributes = "";
			$this->cart_s_password->HrefValue = "";
			$this->cart_s_password->TooltipValue = "";

			// jc_po_yesno
			$this->jc_po_yesno->LinkCustomAttributes = "";
			$this->jc_po_yesno->HrefValue = "";
			$this->jc_po_yesno->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey <> "")
					$thisKey .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
				$thisKey .= $row['id'];
				if (DELETE_UPLOADED_FILES) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($deleteRows === FALSE)
					break;
				if ($key <> "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
		} else {
			$conn->rollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("po_setuplist.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_po_b_unauthorize":
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_po_b_unauthorize":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>