<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class po_status_add extends po_status
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'po_status';

	// Page object name
	public $PageObjName = "po_status_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (po_status)
		if (!isset($GLOBALS["po_status"]) || get_class($GLOBALS["po_status"]) == PROJECT_NAMESPACE . "po_status") {
			$GLOBALS["po_status"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["po_status"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'po_status');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $po_status;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($po_status);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "po_statusview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("po_statuslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->po->setVisibility();
		$this->delivery_date->setVisibility();
		$this->reminder_date->setVisibility();
		$this->reminder_for->setVisibility();
		$this->po_current_status->setVisibility();
		$this->pp_operator->setVisibility();
		$this->pp_datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("po_statuslist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "po_statuslist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "po_statusview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->po->CurrentValue = NULL;
		$this->po->OldValue = $this->po->CurrentValue;
		$this->delivery_date->CurrentValue = NULL;
		$this->delivery_date->OldValue = $this->delivery_date->CurrentValue;
		$this->reminder_date->CurrentValue = NULL;
		$this->reminder_date->OldValue = $this->reminder_date->CurrentValue;
		$this->reminder_for->CurrentValue = NULL;
		$this->reminder_for->OldValue = $this->reminder_for->CurrentValue;
		$this->po_current_status->CurrentValue = NULL;
		$this->po_current_status->OldValue = $this->po_current_status->CurrentValue;
		$this->pp_operator->CurrentValue = NULL;
		$this->pp_operator->OldValue = $this->pp_operator->CurrentValue;
		$this->pp_datetime->CurrentValue = NULL;
		$this->pp_datetime->OldValue = $this->pp_datetime->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'po' first before field var 'x_po'
		$val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
		if (!$this->po->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po->Visible = FALSE; // Disable update for API request
			else
				$this->po->setFormValue($val);
		}

		// Check field name 'delivery_date' first before field var 'x_delivery_date'
		$val = $CurrentForm->hasValue("delivery_date") ? $CurrentForm->getValue("delivery_date") : $CurrentForm->getValue("x_delivery_date");
		if (!$this->delivery_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->delivery_date->Visible = FALSE; // Disable update for API request
			else
				$this->delivery_date->setFormValue($val);
			$this->delivery_date->CurrentValue = UnFormatDateTime($this->delivery_date->CurrentValue, 0);
		}

		// Check field name 'reminder_date' first before field var 'x_reminder_date'
		$val = $CurrentForm->hasValue("reminder_date") ? $CurrentForm->getValue("reminder_date") : $CurrentForm->getValue("x_reminder_date");
		if (!$this->reminder_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->reminder_date->Visible = FALSE; // Disable update for API request
			else
				$this->reminder_date->setFormValue($val);
			$this->reminder_date->CurrentValue = UnFormatDateTime($this->reminder_date->CurrentValue, 0);
		}

		// Check field name 'reminder_for' first before field var 'x_reminder_for'
		$val = $CurrentForm->hasValue("reminder_for") ? $CurrentForm->getValue("reminder_for") : $CurrentForm->getValue("x_reminder_for");
		if (!$this->reminder_for->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->reminder_for->Visible = FALSE; // Disable update for API request
			else
				$this->reminder_for->setFormValue($val);
		}

		// Check field name 'po_current_status' first before field var 'x_po_current_status'
		$val = $CurrentForm->hasValue("po_current_status") ? $CurrentForm->getValue("po_current_status") : $CurrentForm->getValue("x_po_current_status");
		if (!$this->po_current_status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_current_status->Visible = FALSE; // Disable update for API request
			else
				$this->po_current_status->setFormValue($val);
		}

		// Check field name 'pp_operator' first before field var 'x_pp_operator'
		$val = $CurrentForm->hasValue("pp_operator") ? $CurrentForm->getValue("pp_operator") : $CurrentForm->getValue("x_pp_operator");
		if (!$this->pp_operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pp_operator->Visible = FALSE; // Disable update for API request
			else
				$this->pp_operator->setFormValue($val);
		}

		// Check field name 'pp_datetime' first before field var 'x_pp_datetime'
		$val = $CurrentForm->hasValue("pp_datetime") ? $CurrentForm->getValue("pp_datetime") : $CurrentForm->getValue("x_pp_datetime");
		if (!$this->pp_datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pp_datetime->Visible = FALSE; // Disable update for API request
			else
				$this->pp_datetime->setFormValue($val);
			$this->pp_datetime->CurrentValue = UnFormatDateTime($this->pp_datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->po->CurrentValue = $this->po->FormValue;
		$this->delivery_date->CurrentValue = $this->delivery_date->FormValue;
		$this->delivery_date->CurrentValue = UnFormatDateTime($this->delivery_date->CurrentValue, 0);
		$this->reminder_date->CurrentValue = $this->reminder_date->FormValue;
		$this->reminder_date->CurrentValue = UnFormatDateTime($this->reminder_date->CurrentValue, 0);
		$this->reminder_for->CurrentValue = $this->reminder_for->FormValue;
		$this->po_current_status->CurrentValue = $this->po_current_status->FormValue;
		$this->pp_operator->CurrentValue = $this->pp_operator->FormValue;
		$this->pp_datetime->CurrentValue = $this->pp_datetime->FormValue;
		$this->pp_datetime->CurrentValue = UnFormatDateTime($this->pp_datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->po->setDbValue($row['po']);
		$this->delivery_date->setDbValue($row['delivery_date']);
		$this->reminder_date->setDbValue($row['reminder_date']);
		$this->reminder_for->setDbValue($row['reminder_for']);
		$this->po_current_status->setDbValue($row['po_current_status']);
		$this->pp_operator->setDbValue($row['pp_operator']);
		$this->pp_datetime->setDbValue($row['pp_datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['po'] = $this->po->CurrentValue;
		$row['delivery_date'] = $this->delivery_date->CurrentValue;
		$row['reminder_date'] = $this->reminder_date->CurrentValue;
		$row['reminder_for'] = $this->reminder_for->CurrentValue;
		$row['po_current_status'] = $this->po_current_status->CurrentValue;
		$row['pp_operator'] = $this->pp_operator->CurrentValue;
		$row['pp_datetime'] = $this->pp_datetime->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// po
		// delivery_date
		// reminder_date
		// reminder_for
		// po_current_status
		// pp_operator
		// pp_datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// delivery_date
			$this->delivery_date->ViewValue = $this->delivery_date->CurrentValue;
			$this->delivery_date->ViewValue = FormatDateTime($this->delivery_date->ViewValue, 0);
			$this->delivery_date->ViewCustomAttributes = "";

			// reminder_date
			$this->reminder_date->ViewValue = $this->reminder_date->CurrentValue;
			$this->reminder_date->ViewValue = FormatDateTime($this->reminder_date->ViewValue, 0);
			$this->reminder_date->ViewCustomAttributes = "";

			// reminder_for
			$this->reminder_for->ViewValue = $this->reminder_for->CurrentValue;
			$this->reminder_for->ViewCustomAttributes = "";

			// po_current_status
			$this->po_current_status->ViewValue = $this->po_current_status->CurrentValue;
			$this->po_current_status->ViewCustomAttributes = "";

			// pp_operator
			$this->pp_operator->ViewValue = $this->pp_operator->CurrentValue;
			$this->pp_operator->ViewValue = FormatNumber($this->pp_operator->ViewValue, 0, -2, -2, -2);
			$this->pp_operator->ViewCustomAttributes = "";

			// pp_datetime
			$this->pp_datetime->ViewValue = $this->pp_datetime->CurrentValue;
			$this->pp_datetime->ViewValue = FormatDateTime($this->pp_datetime->ViewValue, 0);
			$this->pp_datetime->ViewCustomAttributes = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// delivery_date
			$this->delivery_date->LinkCustomAttributes = "";
			$this->delivery_date->HrefValue = "";
			$this->delivery_date->TooltipValue = "";

			// reminder_date
			$this->reminder_date->LinkCustomAttributes = "";
			$this->reminder_date->HrefValue = "";
			$this->reminder_date->TooltipValue = "";

			// reminder_for
			$this->reminder_for->LinkCustomAttributes = "";
			$this->reminder_for->HrefValue = "";
			$this->reminder_for->TooltipValue = "";

			// po_current_status
			$this->po_current_status->LinkCustomAttributes = "";
			$this->po_current_status->HrefValue = "";
			$this->po_current_status->TooltipValue = "";

			// pp_operator
			$this->pp_operator->LinkCustomAttributes = "";
			$this->pp_operator->HrefValue = "";
			$this->pp_operator->TooltipValue = "";

			// pp_datetime
			$this->pp_datetime->LinkCustomAttributes = "";
			$this->pp_datetime->HrefValue = "";
			$this->pp_datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->CurrentValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// delivery_date
			$this->delivery_date->EditAttrs["class"] = "form-control";
			$this->delivery_date->EditCustomAttributes = "";
			$this->delivery_date->EditValue = HtmlEncode(FormatDateTime($this->delivery_date->CurrentValue, 8));
			$this->delivery_date->PlaceHolder = RemoveHtml($this->delivery_date->caption());

			// reminder_date
			$this->reminder_date->EditAttrs["class"] = "form-control";
			$this->reminder_date->EditCustomAttributes = "";
			$this->reminder_date->EditValue = HtmlEncode(FormatDateTime($this->reminder_date->CurrentValue, 8));
			$this->reminder_date->PlaceHolder = RemoveHtml($this->reminder_date->caption());

			// reminder_for
			$this->reminder_for->EditAttrs["class"] = "form-control";
			$this->reminder_for->EditCustomAttributes = "";
			$this->reminder_for->EditValue = HtmlEncode($this->reminder_for->CurrentValue);
			$this->reminder_for->PlaceHolder = RemoveHtml($this->reminder_for->caption());

			// po_current_status
			$this->po_current_status->EditAttrs["class"] = "form-control";
			$this->po_current_status->EditCustomAttributes = "";
			$this->po_current_status->EditValue = HtmlEncode($this->po_current_status->CurrentValue);
			$this->po_current_status->PlaceHolder = RemoveHtml($this->po_current_status->caption());

			// pp_operator
			// pp_datetime
			// Add refer script
			// po

			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";

			// delivery_date
			$this->delivery_date->LinkCustomAttributes = "";
			$this->delivery_date->HrefValue = "";

			// reminder_date
			$this->reminder_date->LinkCustomAttributes = "";
			$this->reminder_date->HrefValue = "";

			// reminder_for
			$this->reminder_for->LinkCustomAttributes = "";
			$this->reminder_for->HrefValue = "";

			// po_current_status
			$this->po_current_status->LinkCustomAttributes = "";
			$this->po_current_status->HrefValue = "";

			// pp_operator
			$this->pp_operator->LinkCustomAttributes = "";
			$this->pp_operator->HrefValue = "";

			// pp_datetime
			$this->pp_datetime->LinkCustomAttributes = "";
			$this->pp_datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->po->Required) {
			if (!$this->po->IsDetailKey && $this->po->FormValue != NULL && $this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->po->FormValue)) {
			AddMessage($FormError, $this->po->errorMessage());
		}
		if ($this->delivery_date->Required) {
			if (!$this->delivery_date->IsDetailKey && $this->delivery_date->FormValue != NULL && $this->delivery_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery_date->caption(), $this->delivery_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->delivery_date->FormValue)) {
			AddMessage($FormError, $this->delivery_date->errorMessage());
		}
		if ($this->reminder_date->Required) {
			if (!$this->reminder_date->IsDetailKey && $this->reminder_date->FormValue != NULL && $this->reminder_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reminder_date->caption(), $this->reminder_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->reminder_date->FormValue)) {
			AddMessage($FormError, $this->reminder_date->errorMessage());
		}
		if ($this->reminder_for->Required) {
			if (!$this->reminder_for->IsDetailKey && $this->reminder_for->FormValue != NULL && $this->reminder_for->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reminder_for->caption(), $this->reminder_for->RequiredErrorMessage));
			}
		}
		if ($this->po_current_status->Required) {
			if (!$this->po_current_status->IsDetailKey && $this->po_current_status->FormValue != NULL && $this->po_current_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_current_status->caption(), $this->po_current_status->RequiredErrorMessage));
			}
		}
		if ($this->pp_operator->Required) {
			if (!$this->pp_operator->IsDetailKey && $this->pp_operator->FormValue != NULL && $this->pp_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pp_operator->caption(), $this->pp_operator->RequiredErrorMessage));
			}
		}
		if ($this->pp_datetime->Required) {
			if (!$this->pp_datetime->IsDetailKey && $this->pp_datetime->FormValue != NULL && $this->pp_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pp_datetime->caption(), $this->pp_datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// po
		$this->po->setDbValueDef($rsnew, $this->po->CurrentValue, 0, FALSE);

		// delivery_date
		$this->delivery_date->setDbValueDef($rsnew, UnFormatDateTime($this->delivery_date->CurrentValue, 0), CurrentDate(), FALSE);

		// reminder_date
		$this->reminder_date->setDbValueDef($rsnew, UnFormatDateTime($this->reminder_date->CurrentValue, 0), CurrentDate(), FALSE);

		// reminder_for
		$this->reminder_for->setDbValueDef($rsnew, $this->reminder_for->CurrentValue, "", FALSE);

		// po_current_status
		$this->po_current_status->setDbValueDef($rsnew, $this->po_current_status->CurrentValue, NULL, FALSE);

		// pp_operator
		$this->pp_operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['pp_operator'] = &$this->pp_operator->DbValue;

		// pp_datetime
		$this->pp_datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['pp_datetime'] = &$this->pp_datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("po_statuslist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>