<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class portal_info_edit extends portal_info
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'portal_info';

	// Page object name
	public $PageObjName = "portal_info_edit";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (portal_info)
		if (!isset($GLOBALS["portal_info"]) || get_class($GLOBALS["portal_info"]) == PROJECT_NAMESPACE . "portal_info") {
			$GLOBALS["portal_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["portal_info"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'portal_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $portal_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($portal_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "portal_infoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("portal_infolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->logo->setVisibility();
		$this->mobile_logo->setVisibility();
		$this->fav_icon->Visible = FALSE;
		$this->name->setVisibility();
		$this->address->setVisibility();
		$this->_email->setVisibility();
		$this->mobile->setVisibility();
		$this->gst->setVisibility();
		$this->other->setVisibility();
		$this->admin_mobile->setVisibility();
		$this->header->setVisibility();
		$this->footer->setVisibility();
		$this->tag_line->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->r_text->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("portal_infolist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = 'autoprogramme.php?apcid=c3daba8ba04565423e12eb8cb6237b46';
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->logo->Upload->Index = $CurrentForm->Index;
		$this->logo->Upload->uploadFile();
		$this->logo->CurrentValue = $this->logo->Upload->FileName;
		$this->mobile_logo->Upload->Index = $CurrentForm->Index;
		$this->mobile_logo->Upload->uploadFile();
		$this->mobile_logo->CurrentValue = $this->mobile_logo->Upload->FileName;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'name' first before field var 'x_name'
		$val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
		if (!$this->name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->name->Visible = FALSE; // Disable update for API request
			else
				$this->name->setFormValue($val);
		}

		// Check field name 'address' first before field var 'x_address'
		$val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
		if (!$this->address->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->address->Visible = FALSE; // Disable update for API request
			else
				$this->address->setFormValue($val);
		}

		// Check field name 'email' first before field var 'x__email'
		$val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
		if (!$this->_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_email->Visible = FALSE; // Disable update for API request
			else
				$this->_email->setFormValue($val);
		}

		// Check field name 'mobile' first before field var 'x_mobile'
		$val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
		if (!$this->mobile->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile->Visible = FALSE; // Disable update for API request
			else
				$this->mobile->setFormValue($val);
		}

		// Check field name 'gst' first before field var 'x_gst'
		$val = $CurrentForm->hasValue("gst") ? $CurrentForm->getValue("gst") : $CurrentForm->getValue("x_gst");
		if (!$this->gst->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gst->Visible = FALSE; // Disable update for API request
			else
				$this->gst->setFormValue($val);
		}

		// Check field name 'other' first before field var 'x_other'
		$val = $CurrentForm->hasValue("other") ? $CurrentForm->getValue("other") : $CurrentForm->getValue("x_other");
		if (!$this->other->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->other->Visible = FALSE; // Disable update for API request
			else
				$this->other->setFormValue($val);
		}

		// Check field name 'admin_mobile' first before field var 'x_admin_mobile'
		$val = $CurrentForm->hasValue("admin_mobile") ? $CurrentForm->getValue("admin_mobile") : $CurrentForm->getValue("x_admin_mobile");
		if (!$this->admin_mobile->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->admin_mobile->Visible = FALSE; // Disable update for API request
			else
				$this->admin_mobile->setFormValue($val);
		}

		// Check field name 'header' first before field var 'x_header'
		$val = $CurrentForm->hasValue("header") ? $CurrentForm->getValue("header") : $CurrentForm->getValue("x_header");
		if (!$this->header->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->header->Visible = FALSE; // Disable update for API request
			else
				$this->header->setFormValue($val);
		}

		// Check field name 'footer' first before field var 'x_footer'
		$val = $CurrentForm->hasValue("footer") ? $CurrentForm->getValue("footer") : $CurrentForm->getValue("x_footer");
		if (!$this->footer->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->footer->Visible = FALSE; // Disable update for API request
			else
				$this->footer->setFormValue($val);
		}

		// Check field name 'tag_line' first before field var 'x_tag_line'
		$val = $CurrentForm->hasValue("tag_line") ? $CurrentForm->getValue("tag_line") : $CurrentForm->getValue("x_tag_line");
		if (!$this->tag_line->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tag_line->Visible = FALSE; // Disable update for API request
			else
				$this->tag_line->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->name->CurrentValue = $this->name->FormValue;
		$this->address->CurrentValue = $this->address->FormValue;
		$this->_email->CurrentValue = $this->_email->FormValue;
		$this->mobile->CurrentValue = $this->mobile->FormValue;
		$this->gst->CurrentValue = $this->gst->FormValue;
		$this->other->CurrentValue = $this->other->FormValue;
		$this->admin_mobile->CurrentValue = $this->admin_mobile->FormValue;
		$this->header->CurrentValue = $this->header->FormValue;
		$this->footer->CurrentValue = $this->footer->FormValue;
		$this->tag_line->CurrentValue = $this->tag_line->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->logo->Upload->DbValue = $row['logo'];
		$this->logo->setDbValue($this->logo->Upload->DbValue);
		$this->mobile_logo->Upload->DbValue = $row['mobile_logo'];
		$this->mobile_logo->setDbValue($this->mobile_logo->Upload->DbValue);
		$this->fav_icon->Upload->DbValue = $row['fav_icon'];
		$this->fav_icon->setDbValue($this->fav_icon->Upload->DbValue);
		$this->name->setDbValue($row['name']);
		$this->address->setDbValue($row['address']);
		$this->_email->setDbValue($row['email']);
		$this->mobile->setDbValue($row['mobile']);
		$this->gst->setDbValue($row['gst']);
		$this->other->setDbValue($row['other']);
		$this->admin_mobile->setDbValue($row['admin_mobile']);
		$this->header->setDbValue($row['header']);
		$this->footer->setDbValue($row['footer']);
		$this->tag_line->setDbValue($row['tag_line']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->r_text->setDbValue($row['r_text']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['logo'] = NULL;
		$row['mobile_logo'] = NULL;
		$row['fav_icon'] = NULL;
		$row['name'] = NULL;
		$row['address'] = NULL;
		$row['email'] = NULL;
		$row['mobile'] = NULL;
		$row['gst'] = NULL;
		$row['other'] = NULL;
		$row['admin_mobile'] = NULL;
		$row['header'] = NULL;
		$row['footer'] = NULL;
		$row['tag_line'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['r_text'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// logo
		// mobile_logo
		// fav_icon
		// name
		// address
		// email
		// mobile
		// gst
		// other
		// admin_mobile
		// header
		// footer
		// tag_line
		// operator
		// datetime
		// r_text

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// logo
			$this->logo->UploadPath = '.p_uploads/pi';
			if (!EmptyValue($this->logo->Upload->DbValue)) {
				$this->logo->ViewValue = $this->logo->Upload->DbValue;
			} else {
				$this->logo->ViewValue = "";
			}
			$this->logo->ViewCustomAttributes = "";

			// mobile_logo
			$this->mobile_logo->UploadPath = '.p_uploads/pi';
			if (!EmptyValue($this->mobile_logo->Upload->DbValue)) {
				$this->mobile_logo->ViewValue = $this->mobile_logo->Upload->DbValue;
			} else {
				$this->mobile_logo->ViewValue = "";
			}
			$this->mobile_logo->ViewCustomAttributes = "";

			// name
			$this->name->ViewValue = $this->name->CurrentValue;
			$this->name->ViewCustomAttributes = "";

			// address
			$this->address->ViewValue = $this->address->CurrentValue;
			$this->address->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewCustomAttributes = "";

			// gst
			$this->gst->ViewValue = $this->gst->CurrentValue;
			$this->gst->ViewCustomAttributes = "";

			// other
			$this->other->ViewValue = $this->other->CurrentValue;
			$this->other->ViewCustomAttributes = "";

			// admin_mobile
			$this->admin_mobile->ViewValue = $this->admin_mobile->CurrentValue;
			$this->admin_mobile->ViewCustomAttributes = "";

			// header
			$this->header->ViewValue = $this->header->CurrentValue;
			$this->header->ViewCustomAttributes = "";

			// footer
			$this->footer->ViewValue = $this->footer->CurrentValue;
			$this->footer->ViewCustomAttributes = "";

			// tag_line
			$this->tag_line->ViewValue = $this->tag_line->CurrentValue;
			$this->tag_line->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// logo
			$this->logo->LinkCustomAttributes = "";
			$this->logo->HrefValue = "";
			$this->logo->ExportHrefValue = $this->logo->UploadPath . $this->logo->Upload->DbValue;
			$this->logo->TooltipValue = "";

			// mobile_logo
			$this->mobile_logo->LinkCustomAttributes = "";
			$this->mobile_logo->HrefValue = "";
			$this->mobile_logo->ExportHrefValue = $this->mobile_logo->UploadPath . $this->mobile_logo->Upload->DbValue;
			$this->mobile_logo->TooltipValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";
			$this->name->TooltipValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";
			$this->address->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// gst
			$this->gst->LinkCustomAttributes = "";
			$this->gst->HrefValue = "";
			$this->gst->TooltipValue = "";

			// other
			$this->other->LinkCustomAttributes = "";
			$this->other->HrefValue = "";
			$this->other->TooltipValue = "";

			// admin_mobile
			$this->admin_mobile->LinkCustomAttributes = "";
			$this->admin_mobile->HrefValue = "";
			$this->admin_mobile->TooltipValue = "";

			// header
			$this->header->LinkCustomAttributes = "";
			$this->header->HrefValue = "";
			$this->header->TooltipValue = "";

			// footer
			$this->footer->LinkCustomAttributes = "";
			$this->footer->HrefValue = "";
			$this->footer->TooltipValue = "";

			// tag_line
			$this->tag_line->LinkCustomAttributes = "";
			$this->tag_line->HrefValue = "";
			$this->tag_line->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// logo
			$this->logo->EditAttrs["class"] = "form-control";
			$this->logo->EditCustomAttributes = "";
			$this->logo->UploadPath = '.p_uploads/pi';
			if (!EmptyValue($this->logo->Upload->DbValue)) {
				$this->logo->EditValue = $this->logo->Upload->DbValue;
			} else {
				$this->logo->EditValue = "";
			}
			if (!EmptyValue($this->logo->CurrentValue))
					$this->logo->Upload->FileName = $this->logo->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->logo);

			// mobile_logo
			$this->mobile_logo->EditAttrs["class"] = "form-control";
			$this->mobile_logo->EditCustomAttributes = "";
			$this->mobile_logo->UploadPath = '.p_uploads/pi';
			if (!EmptyValue($this->mobile_logo->Upload->DbValue)) {
				$this->mobile_logo->EditValue = $this->mobile_logo->Upload->DbValue;
			} else {
				$this->mobile_logo->EditValue = "";
			}
			if (!EmptyValue($this->mobile_logo->CurrentValue))
					$this->mobile_logo->Upload->FileName = $this->mobile_logo->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->mobile_logo);

			// name
			$this->name->EditAttrs["class"] = "form-control";
			$this->name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
			$this->name->EditValue = HtmlEncode($this->name->CurrentValue);
			$this->name->PlaceHolder = RemoveHtml($this->name->caption());

			// address
			$this->address->EditAttrs["class"] = "form-control";
			$this->address->EditCustomAttributes = "";
			$this->address->EditValue = HtmlEncode($this->address->CurrentValue);
			$this->address->PlaceHolder = RemoveHtml($this->address->caption());

			// email
			$this->_email->EditAttrs["class"] = "form-control";
			$this->_email->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
			$this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
			$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
			$this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// gst
			$this->gst->EditAttrs["class"] = "form-control";
			$this->gst->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->gst->CurrentValue = HtmlDecode($this->gst->CurrentValue);
			$this->gst->EditValue = HtmlEncode($this->gst->CurrentValue);
			$this->gst->PlaceHolder = RemoveHtml($this->gst->caption());

			// other
			$this->other->EditAttrs["class"] = "form-control";
			$this->other->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->other->CurrentValue = HtmlDecode($this->other->CurrentValue);
			$this->other->EditValue = HtmlEncode($this->other->CurrentValue);
			$this->other->PlaceHolder = RemoveHtml($this->other->caption());

			// admin_mobile
			$this->admin_mobile->EditAttrs["class"] = "form-control";
			$this->admin_mobile->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->admin_mobile->CurrentValue = HtmlDecode($this->admin_mobile->CurrentValue);
			$this->admin_mobile->EditValue = HtmlEncode($this->admin_mobile->CurrentValue);
			$this->admin_mobile->PlaceHolder = RemoveHtml($this->admin_mobile->caption());

			// header
			$this->header->EditAttrs["class"] = "form-control";
			$this->header->EditCustomAttributes = "";
			$this->header->EditValue = HtmlEncode($this->header->CurrentValue);
			$this->header->PlaceHolder = RemoveHtml($this->header->caption());

			// footer
			$this->footer->EditAttrs["class"] = "form-control";
			$this->footer->EditCustomAttributes = "";
			$this->footer->EditValue = HtmlEncode($this->footer->CurrentValue);
			$this->footer->PlaceHolder = RemoveHtml($this->footer->caption());

			// tag_line
			$this->tag_line->EditAttrs["class"] = "form-control";
			$this->tag_line->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->tag_line->CurrentValue = HtmlDecode($this->tag_line->CurrentValue);
			$this->tag_line->EditValue = HtmlEncode($this->tag_line->CurrentValue);
			$this->tag_line->PlaceHolder = RemoveHtml($this->tag_line->caption());

			// operator
			// datetime
			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// logo
			$this->logo->LinkCustomAttributes = "";
			$this->logo->HrefValue = "";
			$this->logo->ExportHrefValue = $this->logo->UploadPath . $this->logo->Upload->DbValue;

			// mobile_logo
			$this->mobile_logo->LinkCustomAttributes = "";
			$this->mobile_logo->HrefValue = "";
			$this->mobile_logo->ExportHrefValue = $this->mobile_logo->UploadPath . $this->mobile_logo->Upload->DbValue;

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";

			// gst
			$this->gst->LinkCustomAttributes = "";
			$this->gst->HrefValue = "";

			// other
			$this->other->LinkCustomAttributes = "";
			$this->other->HrefValue = "";

			// admin_mobile
			$this->admin_mobile->LinkCustomAttributes = "";
			$this->admin_mobile->HrefValue = "";

			// header
			$this->header->LinkCustomAttributes = "";
			$this->header->HrefValue = "";

			// footer
			$this->footer->LinkCustomAttributes = "";
			$this->footer->HrefValue = "";

			// tag_line
			$this->tag_line->LinkCustomAttributes = "";
			$this->tag_line->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->logo->Required) {
			if ($this->logo->Upload->FileName == "" && !$this->logo->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->logo->caption(), $this->logo->RequiredErrorMessage));
			}
		}
		if ($this->mobile_logo->Required) {
			if ($this->mobile_logo->Upload->FileName == "" && !$this->mobile_logo->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->mobile_logo->caption(), $this->mobile_logo->RequiredErrorMessage));
			}
		}
		if ($this->fav_icon->Required) {
			if ($this->fav_icon->Upload->FileName == "" && !$this->fav_icon->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->fav_icon->caption(), $this->fav_icon->RequiredErrorMessage));
			}
		}
		if ($this->name->Required) {
			if (!$this->name->IsDetailKey && $this->name->FormValue != NULL && $this->name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
			}
		}
		if ($this->address->Required) {
			if (!$this->address->IsDetailKey && $this->address->FormValue != NULL && $this->address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
			}
		}
		if ($this->_email->Required) {
			if (!$this->_email->IsDetailKey && $this->_email->FormValue != NULL && $this->_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
			}
		}
		if ($this->mobile->Required) {
			if (!$this->mobile->IsDetailKey && $this->mobile->FormValue != NULL && $this->mobile->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
			}
		}
		if ($this->gst->Required) {
			if (!$this->gst->IsDetailKey && $this->gst->FormValue != NULL && $this->gst->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gst->caption(), $this->gst->RequiredErrorMessage));
			}
		}
		if ($this->other->Required) {
			if (!$this->other->IsDetailKey && $this->other->FormValue != NULL && $this->other->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other->caption(), $this->other->RequiredErrorMessage));
			}
		}
		if ($this->admin_mobile->Required) {
			if (!$this->admin_mobile->IsDetailKey && $this->admin_mobile->FormValue != NULL && $this->admin_mobile->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->admin_mobile->caption(), $this->admin_mobile->RequiredErrorMessage));
			}
		}
		if ($this->header->Required) {
			if (!$this->header->IsDetailKey && $this->header->FormValue != NULL && $this->header->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->header->caption(), $this->header->RequiredErrorMessage));
			}
		}
		if ($this->footer->Required) {
			if (!$this->footer->IsDetailKey && $this->footer->FormValue != NULL && $this->footer->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->footer->caption(), $this->footer->RequiredErrorMessage));
			}
		}
		if ($this->tag_line->Required) {
			if (!$this->tag_line->IsDetailKey && $this->tag_line->FormValue != NULL && $this->tag_line->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tag_line->caption(), $this->tag_line->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->r_text->Required) {
			if (!$this->r_text->IsDetailKey && $this->r_text->FormValue != NULL && $this->r_text->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_text->caption(), $this->r_text->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$this->logo->OldUploadPath = '.p_uploads/pi';
			$this->logo->UploadPath = $this->logo->OldUploadPath;
			$this->mobile_logo->OldUploadPath = '.p_uploads/pi';
			$this->mobile_logo->UploadPath = $this->mobile_logo->OldUploadPath;
			$this->fav_icon->OldUploadPath = '.p_uploads/pi';
			$this->fav_icon->UploadPath = $this->fav_icon->OldUploadPath;
			$rsnew = [];

			// logo
			if ($this->logo->Visible && !$this->logo->ReadOnly && !$this->logo->Upload->KeepFile) {
				$this->logo->Upload->DbValue = $rsold['logo']; // Get original value
				if ($this->logo->Upload->FileName == "") {
					$rsnew['logo'] = NULL;
				} else {
					$rsnew['logo'] = $this->logo->Upload->FileName;
				}
			}

			// mobile_logo
			if ($this->mobile_logo->Visible && !$this->mobile_logo->ReadOnly && !$this->mobile_logo->Upload->KeepFile) {
				$this->mobile_logo->Upload->DbValue = $rsold['mobile_logo']; // Get original value
				if ($this->mobile_logo->Upload->FileName == "") {
					$rsnew['mobile_logo'] = NULL;
				} else {
					$rsnew['mobile_logo'] = $this->mobile_logo->Upload->FileName;
				}
			}

			// name
			$this->name->setDbValueDef($rsnew, $this->name->CurrentValue, "", $this->name->ReadOnly);

			// address
			$this->address->setDbValueDef($rsnew, $this->address->CurrentValue, "", $this->address->ReadOnly);

			// email
			$this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, "", $this->_email->ReadOnly);

			// mobile
			$this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, "", $this->mobile->ReadOnly);

			// gst
			$this->gst->setDbValueDef($rsnew, $this->gst->CurrentValue, NULL, $this->gst->ReadOnly);

			// other
			$this->other->setDbValueDef($rsnew, $this->other->CurrentValue, NULL, $this->other->ReadOnly);

			// admin_mobile
			$this->admin_mobile->setDbValueDef($rsnew, $this->admin_mobile->CurrentValue, NULL, $this->admin_mobile->ReadOnly);

			// header
			$this->header->setDbValueDef($rsnew, $this->header->CurrentValue, NULL, $this->header->ReadOnly);

			// footer
			$this->footer->setDbValueDef($rsnew, $this->footer->CurrentValue, NULL, $this->footer->ReadOnly);

			// tag_line
			$this->tag_line->setDbValueDef($rsnew, $this->tag_line->CurrentValue, NULL, $this->tag_line->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;
			if ($this->logo->Visible && !$this->logo->Upload->KeepFile) {
				$this->logo->UploadPath = '.p_uploads/pi';
				$oldFiles = EmptyValue($this->logo->Upload->DbValue) ? array() : array($this->logo->Upload->DbValue);
				if (!EmptyValue($this->logo->Upload->FileName)) {
					$newFiles = array($this->logo->Upload->FileName);
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->logo, $this->logo->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->logo->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->logo, $this->logo->Upload->Index) . $file1) || file_exists($this->logo->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->logo->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->logo, $this->logo->Upload->Index) . $file, UploadTempPath($this->logo, $this->logo->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->logo->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->logo->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->logo->setDbValueDef($rsnew, $this->logo->Upload->FileName, NULL, $this->logo->ReadOnly);
				}
			}
			if ($this->mobile_logo->Visible && !$this->mobile_logo->Upload->KeepFile) {
				$this->mobile_logo->UploadPath = '.p_uploads/pi';
				$oldFiles = EmptyValue($this->mobile_logo->Upload->DbValue) ? array() : array($this->mobile_logo->Upload->DbValue);
				if (!EmptyValue($this->mobile_logo->Upload->FileName)) {
					$newFiles = array($this->mobile_logo->Upload->FileName);
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->mobile_logo, $this->mobile_logo->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->mobile_logo->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->mobile_logo, $this->mobile_logo->Upload->Index) . $file1) || file_exists($this->mobile_logo->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->mobile_logo->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->mobile_logo, $this->mobile_logo->Upload->Index) . $file, UploadTempPath($this->mobile_logo, $this->mobile_logo->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->mobile_logo->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->mobile_logo->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->mobile_logo->setDbValueDef($rsnew, $this->mobile_logo->Upload->FileName, NULL, $this->mobile_logo->ReadOnly);
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
					if ($this->logo->Visible && !$this->logo->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->logo->Upload->DbValue) ? array() : array($this->logo->Upload->DbValue);
						if (!EmptyValue($this->logo->Upload->FileName)) {
							$newFiles = array($this->logo->Upload->FileName);
							$newFiles2 = array($rsnew['logo']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->logo, $this->logo->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->logo->Upload->saveToFile($newFiles[$i], TRUE, $i)) { // Just replace
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->logo->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->mobile_logo->Visible && !$this->mobile_logo->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->mobile_logo->Upload->DbValue) ? array() : array($this->mobile_logo->Upload->DbValue);
						if (!EmptyValue($this->mobile_logo->Upload->FileName)) {
							$newFiles = array($this->mobile_logo->Upload->FileName);
							$newFiles2 = array($rsnew['mobile_logo']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->mobile_logo, $this->mobile_logo->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->mobile_logo->Upload->saveToFile($newFiles[$i], TRUE, $i)) { // Just replace
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->mobile_logo->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// logo
		if ($this->logo->Upload->FileToken <> "")
			CleanUploadTempPath($this->logo->Upload->FileToken, $this->logo->Upload->Index);
		else
			CleanUploadTempPath($this->logo, $this->logo->Upload->Index);

		// mobile_logo
		if ($this->mobile_logo->Upload->FileToken <> "")
			CleanUploadTempPath($this->mobile_logo->Upload->FileToken, $this->mobile_logo->Upload->Index);
		else
			CleanUploadTempPath($this->mobile_logo, $this->mobile_logo->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("portal_infolist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

	//echo "Page Unload";
	$arr = Array (
				"icons" => Array (
					Array (
					"src" => ".p_uploads/pi/icons/android-icon-36x36.png",
					"sizes" => "36x36",
					"type" => "image/png",
					"density" => "0.75"			 	
					),
					Array (
					"src" => ".p_uploads/pi/icons/android-icon-48x48.png",
					"sizes" => "48x48",
					"type" => "image/png",
					"density" => "1.0"			 	
					),
					Array (
					"src" => ".p_uploads/pi/icons/android-icon-72x72.png",
					"sizes" => "72x72",
					"type" => "image/png",
					"density" => "1.5"			 	
					),
					Array (
					"src" => ".p_uploads/pi/icons/android-icon-96x96.png",
					"sizes" => "96x96",
					"type" => "image/png",
					"density" => "2.0"			 	
					),
					Array (
					"src" => ".p_uploads/pi/icons/android-icon-144x144.png",
					"sizes" => "144x144",
					"type" => "image/png",
					"density" => "3.0"			 	
					),
					Array (
					"src" => ".p_uploads/pi/icons/android-icon-192x192.png",
					"sizes" => "192x192",
					"type" => "image/png",
					"density" => "4.0"			 	
					)
				),
			"name" => $this->name->CurrentValue,
			"short_name" => $this->name->CurrentValue,
			"start_url" => "db.php",
			"background_color" => "purple",
			"description" => "Integer Systems. All rights reserved. Helpline +91 9829221171",
			"display" => "standalone"	
		);
		$json = json_encode(($arr), JSON_PRETTY_PRINT);
		$file = fopen('manifest.json','w+') or die("File not found");
		fwrite($file, $json);
		fclose($file);
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>