<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for portal_setup
 */
class portal_setup extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $url;
	public $admin_url;
	public $mail_code;
	public $footer_line;
	public $portal_category;
	public $mcu;
	public $fcm_server_key;
	public $app_version;
	public $pd_byepass;
	public $operator;
	public $google_map_api;
	public $material_payment_type;
	public $material_payment_varient;
	public $footer_line_be;
	public $allow_reg;
	public $login_remember;
	public $gp_p_check;
	public $fe_version;
	public $admin_version;
	public $dashboard;
	public $developer_upi_id;
	public $developer_company;
	public $default_page;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'portal_setup';
		$this->TableName = 'portal_setup';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`portal_setup`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id
		$this->id = new DbField('portal_setup', 'portal_setup', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// url
		$this->url = new DbField('portal_setup', 'portal_setup', 'x_url', 'url', '`url`', '`url`', 200, -1, FALSE, '`url`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->url->Nullable = FALSE; // NOT NULL field
		$this->url->Required = TRUE; // Required field
		$this->url->Sortable = TRUE; // Allow sort
		$this->fields['url'] = &$this->url;

		// admin_url
		$this->admin_url = new DbField('portal_setup', 'portal_setup', 'x_admin_url', 'admin_url', '`admin_url`', '`admin_url`', 200, -1, FALSE, '`admin_url`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->admin_url->Nullable = FALSE; // NOT NULL field
		$this->admin_url->Required = TRUE; // Required field
		$this->admin_url->Sortable = TRUE; // Allow sort
		$this->fields['admin_url'] = &$this->admin_url;

		// mail_code
		$this->mail_code = new DbField('portal_setup', 'portal_setup', 'x_mail_code', 'mail_code', '`mail_code`', '`mail_code`', 201, -1, FALSE, '`mail_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->mail_code->Nullable = FALSE; // NOT NULL field
		$this->mail_code->Required = TRUE; // Required field
		$this->mail_code->Sortable = TRUE; // Allow sort
		$this->fields['mail_code'] = &$this->mail_code;

		// footer_line
		$this->footer_line = new DbField('portal_setup', 'portal_setup', 'x_footer_line', 'footer_line', '`footer_line`', '`footer_line`', 201, -1, FALSE, '`footer_line`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->footer_line->Nullable = FALSE; // NOT NULL field
		$this->footer_line->Required = TRUE; // Required field
		$this->footer_line->Sortable = TRUE; // Allow sort
		$this->fields['footer_line'] = &$this->footer_line;

		// portal_category
		$this->portal_category = new DbField('portal_setup', 'portal_setup', 'x_portal_category', 'portal_category', '`portal_category`', '`portal_category`', 200, -1, FALSE, '`portal_category`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->portal_category->Sortable = TRUE; // Allow sort
		$this->portal_category->Lookup = new Lookup('portal_category', 'int_portal_list', TRUE, 'category', ["category","","",""], [], [], [], [], [], [], '`category` ASC', '');
		$this->fields['portal_category'] = &$this->portal_category;

		// mcu
		$this->mcu = new DbField('portal_setup', 'portal_setup', 'x_mcu', 'mcu', '`mcu`', '`mcu`', 17, -1, FALSE, '`mcu`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mcu->Nullable = FALSE; // NOT NULL field
		$this->mcu->Required = TRUE; // Required field
		$this->mcu->Sortable = TRUE; // Allow sort
		$this->mcu->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['mcu'] = &$this->mcu;

		// fcm_server_key
		$this->fcm_server_key = new DbField('portal_setup', 'portal_setup', 'x_fcm_server_key', 'fcm_server_key', '`fcm_server_key`', '`fcm_server_key`', 200, -1, FALSE, '`fcm_server_key`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fcm_server_key->Nullable = FALSE; // NOT NULL field
		$this->fcm_server_key->Required = TRUE; // Required field
		$this->fcm_server_key->Sortable = TRUE; // Allow sort
		$this->fields['fcm_server_key'] = &$this->fcm_server_key;

		// app_version
		$this->app_version = new DbField('portal_setup', 'portal_setup', 'x_app_version', 'app_version', '`app_version`', '`app_version`', 17, -1, FALSE, '`app_version`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->app_version->Nullable = FALSE; // NOT NULL field
		$this->app_version->Required = TRUE; // Required field
		$this->app_version->Sortable = TRUE; // Allow sort
		$this->app_version->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['app_version'] = &$this->app_version;

		// pd_byepass
		$this->pd_byepass = new DbField('portal_setup', 'portal_setup', 'x_pd_byepass', 'pd_byepass', '`pd_byepass`', '`pd_byepass`', 17, -1, FALSE, '`pd_byepass`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->pd_byepass->Nullable = FALSE; // NOT NULL field
		$this->pd_byepass->Required = TRUE; // Required field
		$this->pd_byepass->Sortable = TRUE; // Allow sort
		$this->pd_byepass->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->pd_byepass->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->pd_byepass->Lookup = new Lookup('pd_byepass', 'portal_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->pd_byepass->OptionCount = 3;
		$this->pd_byepass->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pd_byepass'] = &$this->pd_byepass;

		// operator
		$this->operator = new DbField('portal_setup', 'portal_setup', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// google_map_api
		$this->google_map_api = new DbField('portal_setup', 'portal_setup', 'x_google_map_api', 'google_map_api', '`google_map_api`', '`google_map_api`', 200, -1, FALSE, '`google_map_api`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->google_map_api->Nullable = FALSE; // NOT NULL field
		$this->google_map_api->Required = TRUE; // Required field
		$this->google_map_api->Sortable = TRUE; // Allow sort
		$this->fields['google_map_api'] = &$this->google_map_api;

		// material_payment_type
		$this->material_payment_type = new DbField('portal_setup', 'portal_setup', 'x_material_payment_type', 'material_payment_type', '`material_payment_type`', '`material_payment_type`', 3, -1, FALSE, '`material_payment_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->material_payment_type->Nullable = FALSE; // NOT NULL field
		$this->material_payment_type->Required = TRUE; // Required field
		$this->material_payment_type->Sortable = TRUE; // Allow sort
		$this->material_payment_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['material_payment_type'] = &$this->material_payment_type;

		// material_payment_varient
		$this->material_payment_varient = new DbField('portal_setup', 'portal_setup', 'x_material_payment_varient', 'material_payment_varient', '`material_payment_varient`', '`material_payment_varient`', 3, -1, FALSE, '`material_payment_varient`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->material_payment_varient->Nullable = FALSE; // NOT NULL field
		$this->material_payment_varient->Required = TRUE; // Required field
		$this->material_payment_varient->Sortable = TRUE; // Allow sort
		$this->material_payment_varient->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['material_payment_varient'] = &$this->material_payment_varient;

		// footer_line_be
		$this->footer_line_be = new DbField('portal_setup', 'portal_setup', 'x_footer_line_be', 'footer_line_be', '`footer_line_be`', '`footer_line_be`', 200, -1, FALSE, '`footer_line_be`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->footer_line_be->Nullable = FALSE; // NOT NULL field
		$this->footer_line_be->Required = TRUE; // Required field
		$this->footer_line_be->Sortable = TRUE; // Allow sort
		$this->fields['footer_line_be'] = &$this->footer_line_be;

		// allow_reg
		$this->allow_reg = new DbField('portal_setup', 'portal_setup', 'x_allow_reg', 'allow_reg', '`allow_reg`', '`allow_reg`', 18, -1, FALSE, '`allow_reg`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->allow_reg->Nullable = FALSE; // NOT NULL field
		$this->allow_reg->Sortable = TRUE; // Allow sort
		$this->allow_reg->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['allow_reg'] = &$this->allow_reg;

		// login_remember
		$this->login_remember = new DbField('portal_setup', 'portal_setup', 'x_login_remember', 'login_remember', '`login_remember`', '`login_remember`', 16, -1, FALSE, '`login_remember`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->login_remember->Sortable = TRUE; // Allow sort
		$this->login_remember->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['login_remember'] = &$this->login_remember;

		// gp_p_check
		$this->gp_p_check = new DbField('portal_setup', 'portal_setup', 'x_gp_p_check', 'gp_p_check', '`gp_p_check`', '`gp_p_check`', 17, -1, FALSE, '`gp_p_check`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->gp_p_check->Nullable = FALSE; // NOT NULL field
		$this->gp_p_check->Sortable = TRUE; // Allow sort
		$this->gp_p_check->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['gp_p_check'] = &$this->gp_p_check;

		// fe_version
		$this->fe_version = new DbField('portal_setup', 'portal_setup', 'x_fe_version', 'fe_version', '`fe_version`', '`fe_version`', 200, -1, FALSE, '`fe_version`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fe_version->Nullable = FALSE; // NOT NULL field
		$this->fe_version->Required = TRUE; // Required field
		$this->fe_version->Sortable = TRUE; // Allow sort
		$this->fields['fe_version'] = &$this->fe_version;

		// admin_version
		$this->admin_version = new DbField('portal_setup', 'portal_setup', 'x_admin_version', 'admin_version', '`admin_version`', '`admin_version`', 200, -1, FALSE, '`admin_version`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->admin_version->Sortable = TRUE; // Allow sort
		$this->fields['admin_version'] = &$this->admin_version;

		// dashboard
		$this->dashboard = new DbField('portal_setup', 'portal_setup', 'x_dashboard', 'dashboard', '`dashboard`', '`dashboard`', 18, -1, FALSE, '`dashboard`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->dashboard->Nullable = FALSE; // NOT NULL field
		$this->dashboard->Sortable = TRUE; // Allow sort
		$this->dashboard->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->dashboard->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->dashboard->Lookup = new Lookup('dashboard', 'portal_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->dashboard->OptionCount = 2;
		$this->dashboard->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['dashboard'] = &$this->dashboard;

		// developer_upi_id
		$this->developer_upi_id = new DbField('portal_setup', 'portal_setup', 'x_developer_upi_id', 'developer_upi_id', '`developer_upi_id`', '`developer_upi_id`', 200, -1, FALSE, '`developer_upi_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->developer_upi_id->Sortable = TRUE; // Allow sort
		$this->fields['developer_upi_id'] = &$this->developer_upi_id;

		// developer_company
		$this->developer_company = new DbField('portal_setup', 'portal_setup', 'x_developer_company', 'developer_company', '`developer_company`', '`developer_company`', 200, -1, FALSE, '`developer_company`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->developer_company->Sortable = TRUE; // Allow sort
		$this->fields['developer_company'] = &$this->developer_company;

		// default_page
		$this->default_page = new DbField('portal_setup', 'portal_setup', 'x_default_page', 'default_page', '`default_page`', '`default_page`', 200, -1, FALSE, '`default_page`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->default_page->Nullable = FALSE; // NOT NULL field
		$this->default_page->Sortable = TRUE; // Allow sort
		$this->fields['default_page'] = &$this->default_page;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`portal_setup`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "`operator` = " . CurrentUserID()." AND `operator`=-1";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->url->DbValue = $row['url'];
		$this->admin_url->DbValue = $row['admin_url'];
		$this->mail_code->DbValue = $row['mail_code'];
		$this->footer_line->DbValue = $row['footer_line'];
		$this->portal_category->DbValue = $row['portal_category'];
		$this->mcu->DbValue = $row['mcu'];
		$this->fcm_server_key->DbValue = $row['fcm_server_key'];
		$this->app_version->DbValue = $row['app_version'];
		$this->pd_byepass->DbValue = $row['pd_byepass'];
		$this->operator->DbValue = $row['operator'];
		$this->google_map_api->DbValue = $row['google_map_api'];
		$this->material_payment_type->DbValue = $row['material_payment_type'];
		$this->material_payment_varient->DbValue = $row['material_payment_varient'];
		$this->footer_line_be->DbValue = $row['footer_line_be'];
		$this->allow_reg->DbValue = $row['allow_reg'];
		$this->login_remember->DbValue = $row['login_remember'];
		$this->gp_p_check->DbValue = $row['gp_p_check'];
		$this->fe_version->DbValue = $row['fe_version'];
		$this->admin_version->DbValue = $row['admin_version'];
		$this->dashboard->DbValue = $row['dashboard'];
		$this->developer_upi_id->DbValue = $row['developer_upi_id'];
		$this->developer_company->DbValue = $row['developer_company'];
		$this->default_page->DbValue = $row['default_page'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "portal_setuplist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "portal_setupview.php")
			return $Language->phrase("View");
		elseif ($pageName == "portal_setupedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "portal_setupadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "portal_setuplist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("portal_setupview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("portal_setupview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "portal_setupadd.php?" . $this->getUrlParm($parm);
		else
			$url = "portal_setupadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("portal_setupedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("portal_setupadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("portal_setupdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->url->setDbValue($rs->fields('url'));
		$this->admin_url->setDbValue($rs->fields('admin_url'));
		$this->mail_code->setDbValue($rs->fields('mail_code'));
		$this->footer_line->setDbValue($rs->fields('footer_line'));
		$this->portal_category->setDbValue($rs->fields('portal_category'));
		$this->mcu->setDbValue($rs->fields('mcu'));
		$this->fcm_server_key->setDbValue($rs->fields('fcm_server_key'));
		$this->app_version->setDbValue($rs->fields('app_version'));
		$this->pd_byepass->setDbValue($rs->fields('pd_byepass'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->google_map_api->setDbValue($rs->fields('google_map_api'));
		$this->material_payment_type->setDbValue($rs->fields('material_payment_type'));
		$this->material_payment_varient->setDbValue($rs->fields('material_payment_varient'));
		$this->footer_line_be->setDbValue($rs->fields('footer_line_be'));
		$this->allow_reg->setDbValue($rs->fields('allow_reg'));
		$this->login_remember->setDbValue($rs->fields('login_remember'));
		$this->gp_p_check->setDbValue($rs->fields('gp_p_check'));
		$this->fe_version->setDbValue($rs->fields('fe_version'));
		$this->admin_version->setDbValue($rs->fields('admin_version'));
		$this->dashboard->setDbValue($rs->fields('dashboard'));
		$this->developer_upi_id->setDbValue($rs->fields('developer_upi_id'));
		$this->developer_company->setDbValue($rs->fields('developer_company'));
		$this->default_page->setDbValue($rs->fields('default_page'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// url
		// admin_url
		// mail_code
		// footer_line
		// portal_category
		// mcu
		// fcm_server_key
		// app_version
		// pd_byepass
		// operator
		// google_map_api
		// material_payment_type
		// material_payment_varient
		// footer_line_be
		// allow_reg
		// login_remember
		// gp_p_check
		// fe_version
		// admin_version
		// dashboard
		// developer_upi_id
		// developer_company
		// default_page
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// url
		$this->url->ViewValue = $this->url->CurrentValue;
		$this->url->ViewCustomAttributes = "";

		// admin_url
		$this->admin_url->ViewValue = $this->admin_url->CurrentValue;
		$this->admin_url->ViewCustomAttributes = "";

		// mail_code
		$this->mail_code->ViewValue = $this->mail_code->CurrentValue;
		$this->mail_code->ViewCustomAttributes = "";

		// footer_line
		$this->footer_line->ViewValue = $this->footer_line->CurrentValue;
		$this->footer_line->ViewCustomAttributes = "";

		// portal_category
		$curVal = strval($this->portal_category->CurrentValue);
		if ($curVal <> "") {
			$this->portal_category->ViewValue = $this->portal_category->lookupCacheOption($curVal);
			if ($this->portal_category->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`category`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
				}
				$sqlWrk = $this->portal_category->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->portal_category->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->portal_category->ViewValue->add($this->portal_category->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->portal_category->ViewValue = $this->portal_category->CurrentValue;
				}
			}
		} else {
			$this->portal_category->ViewValue = NULL;
		}
		$this->portal_category->ViewCustomAttributes = "";

		// mcu
		$this->mcu->ViewValue = $this->mcu->CurrentValue;
		$this->mcu->ViewValue = FormatNumber($this->mcu->ViewValue, 0, -2, -2, -2);
		$this->mcu->ViewCustomAttributes = "";

		// fcm_server_key
		$this->fcm_server_key->ViewValue = $this->fcm_server_key->CurrentValue;
		$this->fcm_server_key->ViewCustomAttributes = "";

		// app_version
		$this->app_version->ViewValue = $this->app_version->CurrentValue;
		$this->app_version->ViewValue = FormatNumber($this->app_version->ViewValue, 0, -2, -2, -2);
		$this->app_version->ViewCustomAttributes = "";

		// pd_byepass
		if (strval($this->pd_byepass->CurrentValue) <> "") {
			$this->pd_byepass->ViewValue = $this->pd_byepass->optionCaption($this->pd_byepass->CurrentValue);
		} else {
			$this->pd_byepass->ViewValue = NULL;
		}
		$this->pd_byepass->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// google_map_api
		$this->google_map_api->ViewValue = $this->google_map_api->CurrentValue;
		$this->google_map_api->ViewCustomAttributes = "";

		// material_payment_type
		$this->material_payment_type->ViewValue = $this->material_payment_type->CurrentValue;
		$this->material_payment_type->ViewValue = FormatNumber($this->material_payment_type->ViewValue, 0, -2, -2, -2);
		$this->material_payment_type->ViewCustomAttributes = "";

		// material_payment_varient
		$this->material_payment_varient->ViewValue = $this->material_payment_varient->CurrentValue;
		$this->material_payment_varient->ViewValue = FormatNumber($this->material_payment_varient->ViewValue, 0, -2, -2, -2);
		$this->material_payment_varient->ViewCustomAttributes = "";

		// footer_line_be
		$this->footer_line_be->ViewValue = $this->footer_line_be->CurrentValue;
		$this->footer_line_be->ViewCustomAttributes = "";

		// allow_reg
		$this->allow_reg->ViewValue = $this->allow_reg->CurrentValue;
		$this->allow_reg->ViewValue = FormatNumber($this->allow_reg->ViewValue, 0, -2, -2, -2);
		$this->allow_reg->ViewCustomAttributes = "";

		// login_remember
		$this->login_remember->ViewValue = $this->login_remember->CurrentValue;
		$this->login_remember->ViewValue = FormatNumber($this->login_remember->ViewValue, 0, -2, -2, -2);
		$this->login_remember->ViewCustomAttributes = "";

		// gp_p_check
		$this->gp_p_check->ViewValue = $this->gp_p_check->CurrentValue;
		$this->gp_p_check->ViewValue = FormatNumber($this->gp_p_check->ViewValue, 0, -2, -2, -2);
		$this->gp_p_check->ViewCustomAttributes = "";

		// fe_version
		$this->fe_version->ViewValue = $this->fe_version->CurrentValue;
		$this->fe_version->ViewCustomAttributes = "";

		// admin_version
		$this->admin_version->ViewValue = $this->admin_version->CurrentValue;
		$this->admin_version->ViewCustomAttributes = "";

		// dashboard
		if (strval($this->dashboard->CurrentValue) <> "") {
			$this->dashboard->ViewValue = $this->dashboard->optionCaption($this->dashboard->CurrentValue);
		} else {
			$this->dashboard->ViewValue = NULL;
		}
		$this->dashboard->ViewCustomAttributes = "";

		// developer_upi_id
		$this->developer_upi_id->ViewValue = $this->developer_upi_id->CurrentValue;
		$this->developer_upi_id->ViewCustomAttributes = "";

		// developer_company
		$this->developer_company->ViewValue = $this->developer_company->CurrentValue;
		$this->developer_company->ViewCustomAttributes = "";

		// default_page
		$this->default_page->ViewValue = $this->default_page->CurrentValue;
		$this->default_page->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// url
		$this->url->LinkCustomAttributes = "";
		$this->url->HrefValue = "";
		$this->url->TooltipValue = "";

		// admin_url
		$this->admin_url->LinkCustomAttributes = "";
		$this->admin_url->HrefValue = "";
		$this->admin_url->TooltipValue = "";

		// mail_code
		$this->mail_code->LinkCustomAttributes = "";
		$this->mail_code->HrefValue = "";
		$this->mail_code->TooltipValue = "";

		// footer_line
		$this->footer_line->LinkCustomAttributes = "";
		$this->footer_line->HrefValue = "";
		$this->footer_line->TooltipValue = "";

		// portal_category
		$this->portal_category->LinkCustomAttributes = "";
		$this->portal_category->HrefValue = "";
		$this->portal_category->TooltipValue = "";

		// mcu
		$this->mcu->LinkCustomAttributes = "";
		$this->mcu->HrefValue = "";
		$this->mcu->TooltipValue = "";

		// fcm_server_key
		$this->fcm_server_key->LinkCustomAttributes = "";
		$this->fcm_server_key->HrefValue = "";
		$this->fcm_server_key->TooltipValue = "";

		// app_version
		$this->app_version->LinkCustomAttributes = "";
		$this->app_version->HrefValue = "";
		$this->app_version->TooltipValue = "";

		// pd_byepass
		$this->pd_byepass->LinkCustomAttributes = "";
		$this->pd_byepass->HrefValue = "";
		$this->pd_byepass->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// google_map_api
		$this->google_map_api->LinkCustomAttributes = "";
		$this->google_map_api->HrefValue = "";
		$this->google_map_api->TooltipValue = "";

		// material_payment_type
		$this->material_payment_type->LinkCustomAttributes = "";
		$this->material_payment_type->HrefValue = "";
		$this->material_payment_type->TooltipValue = "";

		// material_payment_varient
		$this->material_payment_varient->LinkCustomAttributes = "";
		$this->material_payment_varient->HrefValue = "";
		$this->material_payment_varient->TooltipValue = "";

		// footer_line_be
		$this->footer_line_be->LinkCustomAttributes = "";
		$this->footer_line_be->HrefValue = "";
		$this->footer_line_be->TooltipValue = "";

		// allow_reg
		$this->allow_reg->LinkCustomAttributes = "";
		$this->allow_reg->HrefValue = "";
		$this->allow_reg->TooltipValue = "";

		// login_remember
		$this->login_remember->LinkCustomAttributes = "";
		$this->login_remember->HrefValue = "";
		$this->login_remember->TooltipValue = "";

		// gp_p_check
		$this->gp_p_check->LinkCustomAttributes = "";
		$this->gp_p_check->HrefValue = "";
		$this->gp_p_check->TooltipValue = "";

		// fe_version
		$this->fe_version->LinkCustomAttributes = "";
		$this->fe_version->HrefValue = "";
		$this->fe_version->TooltipValue = "";

		// admin_version
		$this->admin_version->LinkCustomAttributes = "";
		$this->admin_version->HrefValue = "";
		$this->admin_version->TooltipValue = "";

		// dashboard
		$this->dashboard->LinkCustomAttributes = "";
		$this->dashboard->HrefValue = "";
		$this->dashboard->TooltipValue = "";

		// developer_upi_id
		$this->developer_upi_id->LinkCustomAttributes = "";
		$this->developer_upi_id->HrefValue = "";
		$this->developer_upi_id->TooltipValue = "";

		// developer_company
		$this->developer_company->LinkCustomAttributes = "";
		$this->developer_company->HrefValue = "";
		$this->developer_company->TooltipValue = "";

		// default_page
		$this->default_page->LinkCustomAttributes = "";
		$this->default_page->HrefValue = "";
		$this->default_page->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// url
		$this->url->EditAttrs["class"] = "form-control";
		$this->url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
		$this->url->EditValue = $this->url->CurrentValue;
		$this->url->PlaceHolder = RemoveHtml($this->url->caption());

		// admin_url
		$this->admin_url->EditAttrs["class"] = "form-control";
		$this->admin_url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->admin_url->CurrentValue = HtmlDecode($this->admin_url->CurrentValue);
		$this->admin_url->EditValue = $this->admin_url->CurrentValue;
		$this->admin_url->PlaceHolder = RemoveHtml($this->admin_url->caption());

		// mail_code
		$this->mail_code->EditAttrs["class"] = "form-control";
		$this->mail_code->EditCustomAttributes = "";
		$this->mail_code->EditValue = $this->mail_code->CurrentValue;
		$this->mail_code->PlaceHolder = RemoveHtml($this->mail_code->caption());

		// footer_line
		$this->footer_line->EditAttrs["class"] = "form-control";
		$this->footer_line->EditCustomAttributes = "";
		$this->footer_line->EditValue = $this->footer_line->CurrentValue;
		$this->footer_line->PlaceHolder = RemoveHtml($this->footer_line->caption());

		// portal_category
		$this->portal_category->EditCustomAttributes = "";

		// mcu
		$this->mcu->EditAttrs["class"] = "form-control";
		$this->mcu->EditCustomAttributes = "";
		$this->mcu->EditValue = $this->mcu->CurrentValue;
		$this->mcu->PlaceHolder = RemoveHtml($this->mcu->caption());

		// fcm_server_key
		$this->fcm_server_key->EditAttrs["class"] = "form-control";
		$this->fcm_server_key->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->fcm_server_key->CurrentValue = HtmlDecode($this->fcm_server_key->CurrentValue);
		$this->fcm_server_key->EditValue = $this->fcm_server_key->CurrentValue;
		$this->fcm_server_key->PlaceHolder = RemoveHtml($this->fcm_server_key->caption());

		// app_version
		$this->app_version->EditAttrs["class"] = "form-control";
		$this->app_version->EditCustomAttributes = "";
		$this->app_version->EditValue = $this->app_version->CurrentValue;
		$this->app_version->PlaceHolder = RemoveHtml($this->app_version->caption());

		// pd_byepass
		$this->pd_byepass->EditAttrs["class"] = "form-control";
		$this->pd_byepass->EditCustomAttributes = "";
		$this->pd_byepass->EditValue = $this->pd_byepass->options(TRUE);

		// operator
		$this->operator->EditAttrs["class"] = "form-control";
		$this->operator->EditCustomAttributes = "";
		$this->operator->EditValue = $this->operator->CurrentValue;
		$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

		// google_map_api
		$this->google_map_api->EditAttrs["class"] = "form-control";
		$this->google_map_api->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->google_map_api->CurrentValue = HtmlDecode($this->google_map_api->CurrentValue);
		$this->google_map_api->EditValue = $this->google_map_api->CurrentValue;
		$this->google_map_api->PlaceHolder = RemoveHtml($this->google_map_api->caption());

		// material_payment_type
		$this->material_payment_type->EditAttrs["class"] = "form-control";
		$this->material_payment_type->EditCustomAttributes = "";
		$this->material_payment_type->EditValue = $this->material_payment_type->CurrentValue;
		$this->material_payment_type->PlaceHolder = RemoveHtml($this->material_payment_type->caption());

		// material_payment_varient
		$this->material_payment_varient->EditAttrs["class"] = "form-control";
		$this->material_payment_varient->EditCustomAttributes = "";
		$this->material_payment_varient->EditValue = $this->material_payment_varient->CurrentValue;
		$this->material_payment_varient->PlaceHolder = RemoveHtml($this->material_payment_varient->caption());

		// footer_line_be
		$this->footer_line_be->EditAttrs["class"] = "form-control";
		$this->footer_line_be->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->footer_line_be->CurrentValue = HtmlDecode($this->footer_line_be->CurrentValue);
		$this->footer_line_be->EditValue = $this->footer_line_be->CurrentValue;
		$this->footer_line_be->PlaceHolder = RemoveHtml($this->footer_line_be->caption());

		// allow_reg
		$this->allow_reg->EditAttrs["class"] = "form-control";
		$this->allow_reg->EditCustomAttributes = "";
		$this->allow_reg->EditValue = $this->allow_reg->CurrentValue;
		$this->allow_reg->PlaceHolder = RemoveHtml($this->allow_reg->caption());

		// login_remember
		$this->login_remember->EditAttrs["class"] = "form-control";
		$this->login_remember->EditCustomAttributes = "";
		$this->login_remember->EditValue = $this->login_remember->CurrentValue;
		$this->login_remember->PlaceHolder = RemoveHtml($this->login_remember->caption());

		// gp_p_check
		$this->gp_p_check->EditAttrs["class"] = "form-control";
		$this->gp_p_check->EditCustomAttributes = "";
		$this->gp_p_check->EditValue = $this->gp_p_check->CurrentValue;
		$this->gp_p_check->PlaceHolder = RemoveHtml($this->gp_p_check->caption());

		// fe_version
		$this->fe_version->EditAttrs["class"] = "form-control";
		$this->fe_version->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->fe_version->CurrentValue = HtmlDecode($this->fe_version->CurrentValue);
		$this->fe_version->EditValue = $this->fe_version->CurrentValue;
		$this->fe_version->PlaceHolder = RemoveHtml($this->fe_version->caption());

		// admin_version
		$this->admin_version->EditAttrs["class"] = "form-control";
		$this->admin_version->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->admin_version->CurrentValue = HtmlDecode($this->admin_version->CurrentValue);
		$this->admin_version->EditValue = $this->admin_version->CurrentValue;
		$this->admin_version->PlaceHolder = RemoveHtml($this->admin_version->caption());

		// dashboard
		$this->dashboard->EditAttrs["class"] = "form-control";
		$this->dashboard->EditCustomAttributes = "";
		$this->dashboard->EditValue = $this->dashboard->options(TRUE);

		// developer_upi_id
		$this->developer_upi_id->EditAttrs["class"] = "form-control";
		$this->developer_upi_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->developer_upi_id->CurrentValue = HtmlDecode($this->developer_upi_id->CurrentValue);
		$this->developer_upi_id->EditValue = $this->developer_upi_id->CurrentValue;
		$this->developer_upi_id->PlaceHolder = RemoveHtml($this->developer_upi_id->caption());

		// developer_company
		$this->developer_company->EditAttrs["class"] = "form-control";
		$this->developer_company->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->developer_company->CurrentValue = HtmlDecode($this->developer_company->CurrentValue);
		$this->developer_company->EditValue = $this->developer_company->CurrentValue;
		$this->developer_company->PlaceHolder = RemoveHtml($this->developer_company->caption());

		// default_page
		$this->default_page->EditAttrs["class"] = "form-control";
		$this->default_page->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->default_page->CurrentValue = HtmlDecode($this->default_page->CurrentValue);
		$this->default_page->EditValue = $this->default_page->CurrentValue;
		$this->default_page->PlaceHolder = RemoveHtml($this->default_page->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->url);
					$doc->exportCaption($this->admin_url);
					$doc->exportCaption($this->mail_code);
					$doc->exportCaption($this->footer_line);
					$doc->exportCaption($this->portal_category);
					$doc->exportCaption($this->mcu);
					$doc->exportCaption($this->fcm_server_key);
					$doc->exportCaption($this->app_version);
					$doc->exportCaption($this->pd_byepass);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->google_map_api);
					$doc->exportCaption($this->material_payment_type);
					$doc->exportCaption($this->material_payment_varient);
					$doc->exportCaption($this->footer_line_be);
					$doc->exportCaption($this->allow_reg);
					$doc->exportCaption($this->login_remember);
					$doc->exportCaption($this->gp_p_check);
					$doc->exportCaption($this->fe_version);
					$doc->exportCaption($this->admin_version);
					$doc->exportCaption($this->dashboard);
					$doc->exportCaption($this->developer_upi_id);
					$doc->exportCaption($this->developer_company);
					$doc->exportCaption($this->default_page);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->url);
					$doc->exportCaption($this->admin_url);
					$doc->exportCaption($this->portal_category);
					$doc->exportCaption($this->mcu);
					$doc->exportCaption($this->fcm_server_key);
					$doc->exportCaption($this->app_version);
					$doc->exportCaption($this->pd_byepass);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->google_map_api);
					$doc->exportCaption($this->material_payment_type);
					$doc->exportCaption($this->material_payment_varient);
					$doc->exportCaption($this->footer_line_be);
					$doc->exportCaption($this->allow_reg);
					$doc->exportCaption($this->login_remember);
					$doc->exportCaption($this->gp_p_check);
					$doc->exportCaption($this->fe_version);
					$doc->exportCaption($this->admin_version);
					$doc->exportCaption($this->dashboard);
					$doc->exportCaption($this->developer_upi_id);
					$doc->exportCaption($this->developer_company);
					$doc->exportCaption($this->default_page);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->url);
						$doc->exportField($this->admin_url);
						$doc->exportField($this->mail_code);
						$doc->exportField($this->footer_line);
						$doc->exportField($this->portal_category);
						$doc->exportField($this->mcu);
						$doc->exportField($this->fcm_server_key);
						$doc->exportField($this->app_version);
						$doc->exportField($this->pd_byepass);
						$doc->exportField($this->operator);
						$doc->exportField($this->google_map_api);
						$doc->exportField($this->material_payment_type);
						$doc->exportField($this->material_payment_varient);
						$doc->exportField($this->footer_line_be);
						$doc->exportField($this->allow_reg);
						$doc->exportField($this->login_remember);
						$doc->exportField($this->gp_p_check);
						$doc->exportField($this->fe_version);
						$doc->exportField($this->admin_version);
						$doc->exportField($this->dashboard);
						$doc->exportField($this->developer_upi_id);
						$doc->exportField($this->developer_company);
						$doc->exportField($this->default_page);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->url);
						$doc->exportField($this->admin_url);
						$doc->exportField($this->portal_category);
						$doc->exportField($this->mcu);
						$doc->exportField($this->fcm_server_key);
						$doc->exportField($this->app_version);
						$doc->exportField($this->pd_byepass);
						$doc->exportField($this->operator);
						$doc->exportField($this->google_map_api);
						$doc->exportField($this->material_payment_type);
						$doc->exportField($this->material_payment_varient);
						$doc->exportField($this->footer_line_be);
						$doc->exportField($this->allow_reg);
						$doc->exportField($this->login_remember);
						$doc->exportField($this->gp_p_check);
						$doc->exportField($this->fe_version);
						$doc->exportField($this->admin_version);
						$doc->exportField($this->dashboard);
						$doc->exportField($this->developer_upi_id);
						$doc->exportField($this->developer_company);
						$doc->exportField($this->default_page);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>