<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class portal_setup_edit extends portal_setup
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'portal_setup';

	// Page object name
	public $PageObjName = "portal_setup_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (portal_setup)
		if (!isset($GLOBALS["portal_setup"]) || get_class($GLOBALS["portal_setup"]) == PROJECT_NAMESPACE . "portal_setup") {
			$GLOBALS["portal_setup"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["portal_setup"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'portal_setup');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $portal_setup;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($portal_setup);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "portal_setupview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("portal_setuplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->url->setVisibility();
		$this->admin_url->setVisibility();
		$this->mail_code->setVisibility();
		$this->footer_line->setVisibility();
		$this->portal_category->setVisibility();
		$this->mcu->setVisibility();
		$this->fcm_server_key->setVisibility();
		$this->app_version->setVisibility();
		$this->pd_byepass->setVisibility();
		$this->operator->setVisibility();
		$this->google_map_api->setVisibility();
		$this->material_payment_type->setVisibility();
		$this->material_payment_varient->setVisibility();
		$this->footer_line_be->setVisibility();
		$this->allow_reg->setVisibility();
		$this->login_remember->setVisibility();
		$this->gp_p_check->setVisibility();
		$this->fe_version->setVisibility();
		$this->admin_version->setVisibility();
		$this->dashboard->setVisibility();
		$this->developer_upi_id->setVisibility();
		$this->developer_company->setVisibility();
		$this->default_page->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->portal_category);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("portal_setuplist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "portal_setuplist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'url' first before field var 'x_url'
		$val = $CurrentForm->hasValue("url") ? $CurrentForm->getValue("url") : $CurrentForm->getValue("x_url");
		if (!$this->url->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->url->Visible = FALSE; // Disable update for API request
			else
				$this->url->setFormValue($val);
		}

		// Check field name 'admin_url' first before field var 'x_admin_url'
		$val = $CurrentForm->hasValue("admin_url") ? $CurrentForm->getValue("admin_url") : $CurrentForm->getValue("x_admin_url");
		if (!$this->admin_url->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->admin_url->Visible = FALSE; // Disable update for API request
			else
				$this->admin_url->setFormValue($val);
		}

		// Check field name 'mail_code' first before field var 'x_mail_code'
		$val = $CurrentForm->hasValue("mail_code") ? $CurrentForm->getValue("mail_code") : $CurrentForm->getValue("x_mail_code");
		if (!$this->mail_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mail_code->Visible = FALSE; // Disable update for API request
			else
				$this->mail_code->setFormValue($val);
		}

		// Check field name 'footer_line' first before field var 'x_footer_line'
		$val = $CurrentForm->hasValue("footer_line") ? $CurrentForm->getValue("footer_line") : $CurrentForm->getValue("x_footer_line");
		if (!$this->footer_line->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->footer_line->Visible = FALSE; // Disable update for API request
			else
				$this->footer_line->setFormValue($val);
		}

		// Check field name 'portal_category' first before field var 'x_portal_category'
		$val = $CurrentForm->hasValue("portal_category") ? $CurrentForm->getValue("portal_category") : $CurrentForm->getValue("x_portal_category");
		if (!$this->portal_category->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->portal_category->Visible = FALSE; // Disable update for API request
			else
				$this->portal_category->setFormValue($val);
		}

		// Check field name 'mcu' first before field var 'x_mcu'
		$val = $CurrentForm->hasValue("mcu") ? $CurrentForm->getValue("mcu") : $CurrentForm->getValue("x_mcu");
		if (!$this->mcu->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mcu->Visible = FALSE; // Disable update for API request
			else
				$this->mcu->setFormValue($val);
		}

		// Check field name 'fcm_server_key' first before field var 'x_fcm_server_key'
		$val = $CurrentForm->hasValue("fcm_server_key") ? $CurrentForm->getValue("fcm_server_key") : $CurrentForm->getValue("x_fcm_server_key");
		if (!$this->fcm_server_key->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fcm_server_key->Visible = FALSE; // Disable update for API request
			else
				$this->fcm_server_key->setFormValue($val);
		}

		// Check field name 'app_version' first before field var 'x_app_version'
		$val = $CurrentForm->hasValue("app_version") ? $CurrentForm->getValue("app_version") : $CurrentForm->getValue("x_app_version");
		if (!$this->app_version->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->app_version->Visible = FALSE; // Disable update for API request
			else
				$this->app_version->setFormValue($val);
		}

		// Check field name 'pd_byepass' first before field var 'x_pd_byepass'
		$val = $CurrentForm->hasValue("pd_byepass") ? $CurrentForm->getValue("pd_byepass") : $CurrentForm->getValue("x_pd_byepass");
		if (!$this->pd_byepass->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pd_byepass->Visible = FALSE; // Disable update for API request
			else
				$this->pd_byepass->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'google_map_api' first before field var 'x_google_map_api'
		$val = $CurrentForm->hasValue("google_map_api") ? $CurrentForm->getValue("google_map_api") : $CurrentForm->getValue("x_google_map_api");
		if (!$this->google_map_api->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->google_map_api->Visible = FALSE; // Disable update for API request
			else
				$this->google_map_api->setFormValue($val);
		}

		// Check field name 'material_payment_type' first before field var 'x_material_payment_type'
		$val = $CurrentForm->hasValue("material_payment_type") ? $CurrentForm->getValue("material_payment_type") : $CurrentForm->getValue("x_material_payment_type");
		if (!$this->material_payment_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->material_payment_type->Visible = FALSE; // Disable update for API request
			else
				$this->material_payment_type->setFormValue($val);
		}

		// Check field name 'material_payment_varient' first before field var 'x_material_payment_varient'
		$val = $CurrentForm->hasValue("material_payment_varient") ? $CurrentForm->getValue("material_payment_varient") : $CurrentForm->getValue("x_material_payment_varient");
		if (!$this->material_payment_varient->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->material_payment_varient->Visible = FALSE; // Disable update for API request
			else
				$this->material_payment_varient->setFormValue($val);
		}

		// Check field name 'footer_line_be' first before field var 'x_footer_line_be'
		$val = $CurrentForm->hasValue("footer_line_be") ? $CurrentForm->getValue("footer_line_be") : $CurrentForm->getValue("x_footer_line_be");
		if (!$this->footer_line_be->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->footer_line_be->Visible = FALSE; // Disable update for API request
			else
				$this->footer_line_be->setFormValue($val);
		}

		// Check field name 'allow_reg' first before field var 'x_allow_reg'
		$val = $CurrentForm->hasValue("allow_reg") ? $CurrentForm->getValue("allow_reg") : $CurrentForm->getValue("x_allow_reg");
		if (!$this->allow_reg->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->allow_reg->Visible = FALSE; // Disable update for API request
			else
				$this->allow_reg->setFormValue($val);
		}

		// Check field name 'login_remember' first before field var 'x_login_remember'
		$val = $CurrentForm->hasValue("login_remember") ? $CurrentForm->getValue("login_remember") : $CurrentForm->getValue("x_login_remember");
		if (!$this->login_remember->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->login_remember->Visible = FALSE; // Disable update for API request
			else
				$this->login_remember->setFormValue($val);
		}

		// Check field name 'gp_p_check' first before field var 'x_gp_p_check'
		$val = $CurrentForm->hasValue("gp_p_check") ? $CurrentForm->getValue("gp_p_check") : $CurrentForm->getValue("x_gp_p_check");
		if (!$this->gp_p_check->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gp_p_check->Visible = FALSE; // Disable update for API request
			else
				$this->gp_p_check->setFormValue($val);
		}

		// Check field name 'fe_version' first before field var 'x_fe_version'
		$val = $CurrentForm->hasValue("fe_version") ? $CurrentForm->getValue("fe_version") : $CurrentForm->getValue("x_fe_version");
		if (!$this->fe_version->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fe_version->Visible = FALSE; // Disable update for API request
			else
				$this->fe_version->setFormValue($val);
		}

		// Check field name 'admin_version' first before field var 'x_admin_version'
		$val = $CurrentForm->hasValue("admin_version") ? $CurrentForm->getValue("admin_version") : $CurrentForm->getValue("x_admin_version");
		if (!$this->admin_version->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->admin_version->Visible = FALSE; // Disable update for API request
			else
				$this->admin_version->setFormValue($val);
		}

		// Check field name 'dashboard' first before field var 'x_dashboard'
		$val = $CurrentForm->hasValue("dashboard") ? $CurrentForm->getValue("dashboard") : $CurrentForm->getValue("x_dashboard");
		if (!$this->dashboard->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dashboard->Visible = FALSE; // Disable update for API request
			else
				$this->dashboard->setFormValue($val);
		}

		// Check field name 'developer_upi_id' first before field var 'x_developer_upi_id'
		$val = $CurrentForm->hasValue("developer_upi_id") ? $CurrentForm->getValue("developer_upi_id") : $CurrentForm->getValue("x_developer_upi_id");
		if (!$this->developer_upi_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->developer_upi_id->Visible = FALSE; // Disable update for API request
			else
				$this->developer_upi_id->setFormValue($val);
		}

		// Check field name 'developer_company' first before field var 'x_developer_company'
		$val = $CurrentForm->hasValue("developer_company") ? $CurrentForm->getValue("developer_company") : $CurrentForm->getValue("x_developer_company");
		if (!$this->developer_company->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->developer_company->Visible = FALSE; // Disable update for API request
			else
				$this->developer_company->setFormValue($val);
		}

		// Check field name 'default_page' first before field var 'x_default_page'
		$val = $CurrentForm->hasValue("default_page") ? $CurrentForm->getValue("default_page") : $CurrentForm->getValue("x_default_page");
		if (!$this->default_page->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->default_page->Visible = FALSE; // Disable update for API request
			else
				$this->default_page->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->url->CurrentValue = $this->url->FormValue;
		$this->admin_url->CurrentValue = $this->admin_url->FormValue;
		$this->mail_code->CurrentValue = $this->mail_code->FormValue;
		$this->footer_line->CurrentValue = $this->footer_line->FormValue;
		$this->portal_category->CurrentValue = $this->portal_category->FormValue;
		$this->mcu->CurrentValue = $this->mcu->FormValue;
		$this->fcm_server_key->CurrentValue = $this->fcm_server_key->FormValue;
		$this->app_version->CurrentValue = $this->app_version->FormValue;
		$this->pd_byepass->CurrentValue = $this->pd_byepass->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->google_map_api->CurrentValue = $this->google_map_api->FormValue;
		$this->material_payment_type->CurrentValue = $this->material_payment_type->FormValue;
		$this->material_payment_varient->CurrentValue = $this->material_payment_varient->FormValue;
		$this->footer_line_be->CurrentValue = $this->footer_line_be->FormValue;
		$this->allow_reg->CurrentValue = $this->allow_reg->FormValue;
		$this->login_remember->CurrentValue = $this->login_remember->FormValue;
		$this->gp_p_check->CurrentValue = $this->gp_p_check->FormValue;
		$this->fe_version->CurrentValue = $this->fe_version->FormValue;
		$this->admin_version->CurrentValue = $this->admin_version->FormValue;
		$this->dashboard->CurrentValue = $this->dashboard->FormValue;
		$this->developer_upi_id->CurrentValue = $this->developer_upi_id->FormValue;
		$this->developer_company->CurrentValue = $this->developer_company->FormValue;
		$this->default_page->CurrentValue = $this->default_page->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->url->setDbValue($row['url']);
		$this->admin_url->setDbValue($row['admin_url']);
		$this->mail_code->setDbValue($row['mail_code']);
		$this->footer_line->setDbValue($row['footer_line']);
		$this->portal_category->setDbValue($row['portal_category']);
		$this->mcu->setDbValue($row['mcu']);
		$this->fcm_server_key->setDbValue($row['fcm_server_key']);
		$this->app_version->setDbValue($row['app_version']);
		$this->pd_byepass->setDbValue($row['pd_byepass']);
		$this->operator->setDbValue($row['operator']);
		$this->google_map_api->setDbValue($row['google_map_api']);
		$this->material_payment_type->setDbValue($row['material_payment_type']);
		$this->material_payment_varient->setDbValue($row['material_payment_varient']);
		$this->footer_line_be->setDbValue($row['footer_line_be']);
		$this->allow_reg->setDbValue($row['allow_reg']);
		$this->login_remember->setDbValue($row['login_remember']);
		$this->gp_p_check->setDbValue($row['gp_p_check']);
		$this->fe_version->setDbValue($row['fe_version']);
		$this->admin_version->setDbValue($row['admin_version']);
		$this->dashboard->setDbValue($row['dashboard']);
		$this->developer_upi_id->setDbValue($row['developer_upi_id']);
		$this->developer_company->setDbValue($row['developer_company']);
		$this->default_page->setDbValue($row['default_page']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['url'] = NULL;
		$row['admin_url'] = NULL;
		$row['mail_code'] = NULL;
		$row['footer_line'] = NULL;
		$row['portal_category'] = NULL;
		$row['mcu'] = NULL;
		$row['fcm_server_key'] = NULL;
		$row['app_version'] = NULL;
		$row['pd_byepass'] = NULL;
		$row['operator'] = NULL;
		$row['google_map_api'] = NULL;
		$row['material_payment_type'] = NULL;
		$row['material_payment_varient'] = NULL;
		$row['footer_line_be'] = NULL;
		$row['allow_reg'] = NULL;
		$row['login_remember'] = NULL;
		$row['gp_p_check'] = NULL;
		$row['fe_version'] = NULL;
		$row['admin_version'] = NULL;
		$row['dashboard'] = NULL;
		$row['developer_upi_id'] = NULL;
		$row['developer_company'] = NULL;
		$row['default_page'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// url
		// admin_url
		// mail_code
		// footer_line
		// portal_category
		// mcu
		// fcm_server_key
		// app_version
		// pd_byepass
		// operator
		// google_map_api
		// material_payment_type
		// material_payment_varient
		// footer_line_be
		// allow_reg
		// login_remember
		// gp_p_check
		// fe_version
		// admin_version
		// dashboard
		// developer_upi_id
		// developer_company
		// default_page

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// url
			$this->url->ViewValue = $this->url->CurrentValue;
			$this->url->ViewCustomAttributes = "";

			// admin_url
			$this->admin_url->ViewValue = $this->admin_url->CurrentValue;
			$this->admin_url->ViewCustomAttributes = "";

			// mail_code
			$this->mail_code->ViewValue = $this->mail_code->CurrentValue;
			$this->mail_code->ViewCustomAttributes = "";

			// footer_line
			$this->footer_line->ViewValue = $this->footer_line->CurrentValue;
			$this->footer_line->ViewCustomAttributes = "";

			// portal_category
			$curVal = strval($this->portal_category->CurrentValue);
			if ($curVal <> "") {
				$this->portal_category->ViewValue = $this->portal_category->lookupCacheOption($curVal);
				if ($this->portal_category->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`category`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$sqlWrk = $this->portal_category->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->portal_category->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->portal_category->ViewValue->add($this->portal_category->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->portal_category->ViewValue = $this->portal_category->CurrentValue;
					}
				}
			} else {
				$this->portal_category->ViewValue = NULL;
			}
			$this->portal_category->ViewCustomAttributes = "";

			// mcu
			$this->mcu->ViewValue = $this->mcu->CurrentValue;
			$this->mcu->ViewValue = FormatNumber($this->mcu->ViewValue, 0, -2, -2, -2);
			$this->mcu->ViewCustomAttributes = "";

			// fcm_server_key
			$this->fcm_server_key->ViewValue = $this->fcm_server_key->CurrentValue;
			$this->fcm_server_key->ViewCustomAttributes = "";

			// app_version
			$this->app_version->ViewValue = $this->app_version->CurrentValue;
			$this->app_version->ViewValue = FormatNumber($this->app_version->ViewValue, 0, -2, -2, -2);
			$this->app_version->ViewCustomAttributes = "";

			// pd_byepass
			if (strval($this->pd_byepass->CurrentValue) <> "") {
				$this->pd_byepass->ViewValue = $this->pd_byepass->optionCaption($this->pd_byepass->CurrentValue);
			} else {
				$this->pd_byepass->ViewValue = NULL;
			}
			$this->pd_byepass->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// google_map_api
			$this->google_map_api->ViewValue = $this->google_map_api->CurrentValue;
			$this->google_map_api->ViewCustomAttributes = "";

			// material_payment_type
			$this->material_payment_type->ViewValue = $this->material_payment_type->CurrentValue;
			$this->material_payment_type->ViewValue = FormatNumber($this->material_payment_type->ViewValue, 0, -2, -2, -2);
			$this->material_payment_type->ViewCustomAttributes = "";

			// material_payment_varient
			$this->material_payment_varient->ViewValue = $this->material_payment_varient->CurrentValue;
			$this->material_payment_varient->ViewValue = FormatNumber($this->material_payment_varient->ViewValue, 0, -2, -2, -2);
			$this->material_payment_varient->ViewCustomAttributes = "";

			// footer_line_be
			$this->footer_line_be->ViewValue = $this->footer_line_be->CurrentValue;
			$this->footer_line_be->ViewCustomAttributes = "";

			// allow_reg
			$this->allow_reg->ViewValue = $this->allow_reg->CurrentValue;
			$this->allow_reg->ViewValue = FormatNumber($this->allow_reg->ViewValue, 0, -2, -2, -2);
			$this->allow_reg->ViewCustomAttributes = "";

			// login_remember
			$this->login_remember->ViewValue = $this->login_remember->CurrentValue;
			$this->login_remember->ViewValue = FormatNumber($this->login_remember->ViewValue, 0, -2, -2, -2);
			$this->login_remember->ViewCustomAttributes = "";

			// gp_p_check
			$this->gp_p_check->ViewValue = $this->gp_p_check->CurrentValue;
			$this->gp_p_check->ViewValue = FormatNumber($this->gp_p_check->ViewValue, 0, -2, -2, -2);
			$this->gp_p_check->ViewCustomAttributes = "";

			// fe_version
			$this->fe_version->ViewValue = $this->fe_version->CurrentValue;
			$this->fe_version->ViewCustomAttributes = "";

			// admin_version
			$this->admin_version->ViewValue = $this->admin_version->CurrentValue;
			$this->admin_version->ViewCustomAttributes = "";

			// dashboard
			if (strval($this->dashboard->CurrentValue) <> "") {
				$this->dashboard->ViewValue = $this->dashboard->optionCaption($this->dashboard->CurrentValue);
			} else {
				$this->dashboard->ViewValue = NULL;
			}
			$this->dashboard->ViewCustomAttributes = "";

			// developer_upi_id
			$this->developer_upi_id->ViewValue = $this->developer_upi_id->CurrentValue;
			$this->developer_upi_id->ViewCustomAttributes = "";

			// developer_company
			$this->developer_company->ViewValue = $this->developer_company->CurrentValue;
			$this->developer_company->ViewCustomAttributes = "";

			// default_page
			$this->default_page->ViewValue = $this->default_page->CurrentValue;
			$this->default_page->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// url
			$this->url->LinkCustomAttributes = "";
			$this->url->HrefValue = "";
			$this->url->TooltipValue = "";

			// admin_url
			$this->admin_url->LinkCustomAttributes = "";
			$this->admin_url->HrefValue = "";
			$this->admin_url->TooltipValue = "";

			// mail_code
			$this->mail_code->LinkCustomAttributes = "";
			$this->mail_code->HrefValue = "";
			$this->mail_code->TooltipValue = "";

			// footer_line
			$this->footer_line->LinkCustomAttributes = "";
			$this->footer_line->HrefValue = "";
			$this->footer_line->TooltipValue = "";

			// portal_category
			$this->portal_category->LinkCustomAttributes = "";
			$this->portal_category->HrefValue = "";
			$this->portal_category->TooltipValue = "";

			// mcu
			$this->mcu->LinkCustomAttributes = "";
			$this->mcu->HrefValue = "";
			$this->mcu->TooltipValue = "";

			// fcm_server_key
			$this->fcm_server_key->LinkCustomAttributes = "";
			$this->fcm_server_key->HrefValue = "";
			$this->fcm_server_key->TooltipValue = "";

			// app_version
			$this->app_version->LinkCustomAttributes = "";
			$this->app_version->HrefValue = "";
			$this->app_version->TooltipValue = "";

			// pd_byepass
			$this->pd_byepass->LinkCustomAttributes = "";
			$this->pd_byepass->HrefValue = "";
			$this->pd_byepass->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// google_map_api
			$this->google_map_api->LinkCustomAttributes = "";
			$this->google_map_api->HrefValue = "";
			$this->google_map_api->TooltipValue = "";

			// material_payment_type
			$this->material_payment_type->LinkCustomAttributes = "";
			$this->material_payment_type->HrefValue = "";
			$this->material_payment_type->TooltipValue = "";

			// material_payment_varient
			$this->material_payment_varient->LinkCustomAttributes = "";
			$this->material_payment_varient->HrefValue = "";
			$this->material_payment_varient->TooltipValue = "";

			// footer_line_be
			$this->footer_line_be->LinkCustomAttributes = "";
			$this->footer_line_be->HrefValue = "";
			$this->footer_line_be->TooltipValue = "";

			// allow_reg
			$this->allow_reg->LinkCustomAttributes = "";
			$this->allow_reg->HrefValue = "";
			$this->allow_reg->TooltipValue = "";

			// login_remember
			$this->login_remember->LinkCustomAttributes = "";
			$this->login_remember->HrefValue = "";
			$this->login_remember->TooltipValue = "";

			// gp_p_check
			$this->gp_p_check->LinkCustomAttributes = "";
			$this->gp_p_check->HrefValue = "";
			$this->gp_p_check->TooltipValue = "";

			// fe_version
			$this->fe_version->LinkCustomAttributes = "";
			$this->fe_version->HrefValue = "";
			$this->fe_version->TooltipValue = "";

			// admin_version
			$this->admin_version->LinkCustomAttributes = "";
			$this->admin_version->HrefValue = "";
			$this->admin_version->TooltipValue = "";

			// dashboard
			$this->dashboard->LinkCustomAttributes = "";
			$this->dashboard->HrefValue = "";
			$this->dashboard->TooltipValue = "";

			// developer_upi_id
			$this->developer_upi_id->LinkCustomAttributes = "";
			$this->developer_upi_id->HrefValue = "";
			$this->developer_upi_id->TooltipValue = "";

			// developer_company
			$this->developer_company->LinkCustomAttributes = "";
			$this->developer_company->HrefValue = "";
			$this->developer_company->TooltipValue = "";

			// default_page
			$this->default_page->LinkCustomAttributes = "";
			$this->default_page->HrefValue = "";
			$this->default_page->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// url
			$this->url->EditAttrs["class"] = "form-control";
			$this->url->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
			$this->url->EditValue = HtmlEncode($this->url->CurrentValue);
			$this->url->PlaceHolder = RemoveHtml($this->url->caption());

			// admin_url
			$this->admin_url->EditAttrs["class"] = "form-control";
			$this->admin_url->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->admin_url->CurrentValue = HtmlDecode($this->admin_url->CurrentValue);
			$this->admin_url->EditValue = HtmlEncode($this->admin_url->CurrentValue);
			$this->admin_url->PlaceHolder = RemoveHtml($this->admin_url->caption());

			// mail_code
			$this->mail_code->EditAttrs["class"] = "form-control";
			$this->mail_code->EditCustomAttributes = "";
			$this->mail_code->EditValue = HtmlEncode($this->mail_code->CurrentValue);
			$this->mail_code->PlaceHolder = RemoveHtml($this->mail_code->caption());

			// footer_line
			$this->footer_line->EditAttrs["class"] = "form-control";
			$this->footer_line->EditCustomAttributes = "";
			$this->footer_line->EditValue = HtmlEncode($this->footer_line->CurrentValue);
			$this->footer_line->PlaceHolder = RemoveHtml($this->footer_line->caption());

			// portal_category
			$this->portal_category->EditCustomAttributes = "";
			$curVal = trim(strval($this->portal_category->CurrentValue));
			if ($curVal <> "")
				$this->portal_category->ViewValue = $this->portal_category->lookupCacheOption($curVal);
			else
				$this->portal_category->ViewValue = $this->portal_category->Lookup !== NULL && is_array($this->portal_category->Lookup->Options) ? $curVal : NULL;
			if ($this->portal_category->ViewValue !== NULL) { // Load from cache
				$this->portal_category->EditValue = array_values($this->portal_category->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`category`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$sqlWrk = $this->portal_category->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->portal_category->EditValue = $arwrk;
			}

			// mcu
			$this->mcu->EditAttrs["class"] = "form-control";
			$this->mcu->EditCustomAttributes = "";
			$this->mcu->EditValue = HtmlEncode($this->mcu->CurrentValue);
			$this->mcu->PlaceHolder = RemoveHtml($this->mcu->caption());

			// fcm_server_key
			$this->fcm_server_key->EditAttrs["class"] = "form-control";
			$this->fcm_server_key->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->fcm_server_key->CurrentValue = HtmlDecode($this->fcm_server_key->CurrentValue);
			$this->fcm_server_key->EditValue = HtmlEncode($this->fcm_server_key->CurrentValue);
			$this->fcm_server_key->PlaceHolder = RemoveHtml($this->fcm_server_key->caption());

			// app_version
			$this->app_version->EditAttrs["class"] = "form-control";
			$this->app_version->EditCustomAttributes = "";
			$this->app_version->EditValue = HtmlEncode($this->app_version->CurrentValue);
			$this->app_version->PlaceHolder = RemoveHtml($this->app_version->caption());

			// pd_byepass
			$this->pd_byepass->EditAttrs["class"] = "form-control";
			$this->pd_byepass->EditCustomAttributes = "";
			$this->pd_byepass->EditValue = $this->pd_byepass->options(TRUE);

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->CurrentValue);
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// google_map_api
			$this->google_map_api->EditAttrs["class"] = "form-control";
			$this->google_map_api->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->google_map_api->CurrentValue = HtmlDecode($this->google_map_api->CurrentValue);
			$this->google_map_api->EditValue = HtmlEncode($this->google_map_api->CurrentValue);
			$this->google_map_api->PlaceHolder = RemoveHtml($this->google_map_api->caption());

			// material_payment_type
			$this->material_payment_type->EditAttrs["class"] = "form-control";
			$this->material_payment_type->EditCustomAttributes = "";
			$this->material_payment_type->EditValue = HtmlEncode($this->material_payment_type->CurrentValue);
			$this->material_payment_type->PlaceHolder = RemoveHtml($this->material_payment_type->caption());

			// material_payment_varient
			$this->material_payment_varient->EditAttrs["class"] = "form-control";
			$this->material_payment_varient->EditCustomAttributes = "";
			$this->material_payment_varient->EditValue = HtmlEncode($this->material_payment_varient->CurrentValue);
			$this->material_payment_varient->PlaceHolder = RemoveHtml($this->material_payment_varient->caption());

			// footer_line_be
			$this->footer_line_be->EditAttrs["class"] = "form-control";
			$this->footer_line_be->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->footer_line_be->CurrentValue = HtmlDecode($this->footer_line_be->CurrentValue);
			$this->footer_line_be->EditValue = HtmlEncode($this->footer_line_be->CurrentValue);
			$this->footer_line_be->PlaceHolder = RemoveHtml($this->footer_line_be->caption());

			// allow_reg
			$this->allow_reg->EditAttrs["class"] = "form-control";
			$this->allow_reg->EditCustomAttributes = "";
			$this->allow_reg->EditValue = HtmlEncode($this->allow_reg->CurrentValue);
			$this->allow_reg->PlaceHolder = RemoveHtml($this->allow_reg->caption());

			// login_remember
			$this->login_remember->EditAttrs["class"] = "form-control";
			$this->login_remember->EditCustomAttributes = "";
			$this->login_remember->EditValue = HtmlEncode($this->login_remember->CurrentValue);
			$this->login_remember->PlaceHolder = RemoveHtml($this->login_remember->caption());

			// gp_p_check
			$this->gp_p_check->EditAttrs["class"] = "form-control";
			$this->gp_p_check->EditCustomAttributes = "";
			$this->gp_p_check->EditValue = HtmlEncode($this->gp_p_check->CurrentValue);
			$this->gp_p_check->PlaceHolder = RemoveHtml($this->gp_p_check->caption());

			// fe_version
			$this->fe_version->EditAttrs["class"] = "form-control";
			$this->fe_version->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->fe_version->CurrentValue = HtmlDecode($this->fe_version->CurrentValue);
			$this->fe_version->EditValue = HtmlEncode($this->fe_version->CurrentValue);
			$this->fe_version->PlaceHolder = RemoveHtml($this->fe_version->caption());

			// admin_version
			$this->admin_version->EditAttrs["class"] = "form-control";
			$this->admin_version->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->admin_version->CurrentValue = HtmlDecode($this->admin_version->CurrentValue);
			$this->admin_version->EditValue = HtmlEncode($this->admin_version->CurrentValue);
			$this->admin_version->PlaceHolder = RemoveHtml($this->admin_version->caption());

			// dashboard
			$this->dashboard->EditAttrs["class"] = "form-control";
			$this->dashboard->EditCustomAttributes = "";
			$this->dashboard->EditValue = $this->dashboard->options(TRUE);

			// developer_upi_id
			$this->developer_upi_id->EditAttrs["class"] = "form-control";
			$this->developer_upi_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->developer_upi_id->CurrentValue = HtmlDecode($this->developer_upi_id->CurrentValue);
			$this->developer_upi_id->EditValue = HtmlEncode($this->developer_upi_id->CurrentValue);
			$this->developer_upi_id->PlaceHolder = RemoveHtml($this->developer_upi_id->caption());

			// developer_company
			$this->developer_company->EditAttrs["class"] = "form-control";
			$this->developer_company->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->developer_company->CurrentValue = HtmlDecode($this->developer_company->CurrentValue);
			$this->developer_company->EditValue = HtmlEncode($this->developer_company->CurrentValue);
			$this->developer_company->PlaceHolder = RemoveHtml($this->developer_company->caption());

			// default_page
			$this->default_page->EditAttrs["class"] = "form-control";
			$this->default_page->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->default_page->CurrentValue = HtmlDecode($this->default_page->CurrentValue);
			$this->default_page->EditValue = HtmlEncode($this->default_page->CurrentValue);
			$this->default_page->PlaceHolder = RemoveHtml($this->default_page->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// url
			$this->url->LinkCustomAttributes = "";
			$this->url->HrefValue = "";

			// admin_url
			$this->admin_url->LinkCustomAttributes = "";
			$this->admin_url->HrefValue = "";

			// mail_code
			$this->mail_code->LinkCustomAttributes = "";
			$this->mail_code->HrefValue = "";

			// footer_line
			$this->footer_line->LinkCustomAttributes = "";
			$this->footer_line->HrefValue = "";

			// portal_category
			$this->portal_category->LinkCustomAttributes = "";
			$this->portal_category->HrefValue = "";

			// mcu
			$this->mcu->LinkCustomAttributes = "";
			$this->mcu->HrefValue = "";

			// fcm_server_key
			$this->fcm_server_key->LinkCustomAttributes = "";
			$this->fcm_server_key->HrefValue = "";

			// app_version
			$this->app_version->LinkCustomAttributes = "";
			$this->app_version->HrefValue = "";

			// pd_byepass
			$this->pd_byepass->LinkCustomAttributes = "";
			$this->pd_byepass->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// google_map_api
			$this->google_map_api->LinkCustomAttributes = "";
			$this->google_map_api->HrefValue = "";

			// material_payment_type
			$this->material_payment_type->LinkCustomAttributes = "";
			$this->material_payment_type->HrefValue = "";

			// material_payment_varient
			$this->material_payment_varient->LinkCustomAttributes = "";
			$this->material_payment_varient->HrefValue = "";

			// footer_line_be
			$this->footer_line_be->LinkCustomAttributes = "";
			$this->footer_line_be->HrefValue = "";

			// allow_reg
			$this->allow_reg->LinkCustomAttributes = "";
			$this->allow_reg->HrefValue = "";

			// login_remember
			$this->login_remember->LinkCustomAttributes = "";
			$this->login_remember->HrefValue = "";

			// gp_p_check
			$this->gp_p_check->LinkCustomAttributes = "";
			$this->gp_p_check->HrefValue = "";

			// fe_version
			$this->fe_version->LinkCustomAttributes = "";
			$this->fe_version->HrefValue = "";

			// admin_version
			$this->admin_version->LinkCustomAttributes = "";
			$this->admin_version->HrefValue = "";

			// dashboard
			$this->dashboard->LinkCustomAttributes = "";
			$this->dashboard->HrefValue = "";

			// developer_upi_id
			$this->developer_upi_id->LinkCustomAttributes = "";
			$this->developer_upi_id->HrefValue = "";

			// developer_company
			$this->developer_company->LinkCustomAttributes = "";
			$this->developer_company->HrefValue = "";

			// default_page
			$this->default_page->LinkCustomAttributes = "";
			$this->default_page->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->url->Required) {
			if (!$this->url->IsDetailKey && $this->url->FormValue != NULL && $this->url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->url->caption(), $this->url->RequiredErrorMessage));
			}
		}
		if ($this->admin_url->Required) {
			if (!$this->admin_url->IsDetailKey && $this->admin_url->FormValue != NULL && $this->admin_url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->admin_url->caption(), $this->admin_url->RequiredErrorMessage));
			}
		}
		if ($this->mail_code->Required) {
			if (!$this->mail_code->IsDetailKey && $this->mail_code->FormValue != NULL && $this->mail_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mail_code->caption(), $this->mail_code->RequiredErrorMessage));
			}
		}
		if ($this->footer_line->Required) {
			if (!$this->footer_line->IsDetailKey && $this->footer_line->FormValue != NULL && $this->footer_line->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->footer_line->caption(), $this->footer_line->RequiredErrorMessage));
			}
		}
		if ($this->portal_category->Required) {
			if ($this->portal_category->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->portal_category->caption(), $this->portal_category->RequiredErrorMessage));
			}
		}
		if ($this->mcu->Required) {
			if (!$this->mcu->IsDetailKey && $this->mcu->FormValue != NULL && $this->mcu->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mcu->caption(), $this->mcu->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->mcu->FormValue)) {
			AddMessage($FormError, $this->mcu->errorMessage());
		}
		if ($this->fcm_server_key->Required) {
			if (!$this->fcm_server_key->IsDetailKey && $this->fcm_server_key->FormValue != NULL && $this->fcm_server_key->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fcm_server_key->caption(), $this->fcm_server_key->RequiredErrorMessage));
			}
		}
		if ($this->app_version->Required) {
			if (!$this->app_version->IsDetailKey && $this->app_version->FormValue != NULL && $this->app_version->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->app_version->caption(), $this->app_version->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->app_version->FormValue)) {
			AddMessage($FormError, $this->app_version->errorMessage());
		}
		if ($this->pd_byepass->Required) {
			if (!$this->pd_byepass->IsDetailKey && $this->pd_byepass->FormValue != NULL && $this->pd_byepass->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pd_byepass->caption(), $this->pd_byepass->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->operator->FormValue)) {
			AddMessage($FormError, $this->operator->errorMessage());
		}
		if ($this->google_map_api->Required) {
			if (!$this->google_map_api->IsDetailKey && $this->google_map_api->FormValue != NULL && $this->google_map_api->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->google_map_api->caption(), $this->google_map_api->RequiredErrorMessage));
			}
		}
		if ($this->material_payment_type->Required) {
			if (!$this->material_payment_type->IsDetailKey && $this->material_payment_type->FormValue != NULL && $this->material_payment_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->material_payment_type->caption(), $this->material_payment_type->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->material_payment_type->FormValue)) {
			AddMessage($FormError, $this->material_payment_type->errorMessage());
		}
		if ($this->material_payment_varient->Required) {
			if (!$this->material_payment_varient->IsDetailKey && $this->material_payment_varient->FormValue != NULL && $this->material_payment_varient->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->material_payment_varient->caption(), $this->material_payment_varient->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->material_payment_varient->FormValue)) {
			AddMessage($FormError, $this->material_payment_varient->errorMessage());
		}
		if ($this->footer_line_be->Required) {
			if (!$this->footer_line_be->IsDetailKey && $this->footer_line_be->FormValue != NULL && $this->footer_line_be->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->footer_line_be->caption(), $this->footer_line_be->RequiredErrorMessage));
			}
		}
		if ($this->allow_reg->Required) {
			if (!$this->allow_reg->IsDetailKey && $this->allow_reg->FormValue != NULL && $this->allow_reg->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->allow_reg->caption(), $this->allow_reg->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->allow_reg->FormValue)) {
			AddMessage($FormError, $this->allow_reg->errorMessage());
		}
		if ($this->login_remember->Required) {
			if (!$this->login_remember->IsDetailKey && $this->login_remember->FormValue != NULL && $this->login_remember->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->login_remember->caption(), $this->login_remember->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->login_remember->FormValue)) {
			AddMessage($FormError, $this->login_remember->errorMessage());
		}
		if ($this->gp_p_check->Required) {
			if (!$this->gp_p_check->IsDetailKey && $this->gp_p_check->FormValue != NULL && $this->gp_p_check->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gp_p_check->caption(), $this->gp_p_check->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->gp_p_check->FormValue)) {
			AddMessage($FormError, $this->gp_p_check->errorMessage());
		}
		if ($this->fe_version->Required) {
			if (!$this->fe_version->IsDetailKey && $this->fe_version->FormValue != NULL && $this->fe_version->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fe_version->caption(), $this->fe_version->RequiredErrorMessage));
			}
		}
		if ($this->admin_version->Required) {
			if (!$this->admin_version->IsDetailKey && $this->admin_version->FormValue != NULL && $this->admin_version->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->admin_version->caption(), $this->admin_version->RequiredErrorMessage));
			}
		}
		if ($this->dashboard->Required) {
			if (!$this->dashboard->IsDetailKey && $this->dashboard->FormValue != NULL && $this->dashboard->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dashboard->caption(), $this->dashboard->RequiredErrorMessage));
			}
		}
		if ($this->developer_upi_id->Required) {
			if (!$this->developer_upi_id->IsDetailKey && $this->developer_upi_id->FormValue != NULL && $this->developer_upi_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->developer_upi_id->caption(), $this->developer_upi_id->RequiredErrorMessage));
			}
		}
		if ($this->developer_company->Required) {
			if (!$this->developer_company->IsDetailKey && $this->developer_company->FormValue != NULL && $this->developer_company->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->developer_company->caption(), $this->developer_company->RequiredErrorMessage));
			}
		}
		if ($this->default_page->Required) {
			if (!$this->default_page->IsDetailKey && $this->default_page->FormValue != NULL && $this->default_page->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->default_page->caption(), $this->default_page->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// url
			$this->url->setDbValueDef($rsnew, $this->url->CurrentValue, "", $this->url->ReadOnly);

			// admin_url
			$this->admin_url->setDbValueDef($rsnew, $this->admin_url->CurrentValue, "", $this->admin_url->ReadOnly);

			// mail_code
			$this->mail_code->setDbValueDef($rsnew, $this->mail_code->CurrentValue, "", $this->mail_code->ReadOnly);

			// footer_line
			$this->footer_line->setDbValueDef($rsnew, $this->footer_line->CurrentValue, "", $this->footer_line->ReadOnly);

			// portal_category
			$this->portal_category->setDbValueDef($rsnew, $this->portal_category->CurrentValue, NULL, $this->portal_category->ReadOnly);

			// mcu
			$this->mcu->setDbValueDef($rsnew, $this->mcu->CurrentValue, 0, $this->mcu->ReadOnly);

			// fcm_server_key
			$this->fcm_server_key->setDbValueDef($rsnew, $this->fcm_server_key->CurrentValue, "", $this->fcm_server_key->ReadOnly);

			// app_version
			$this->app_version->setDbValueDef($rsnew, $this->app_version->CurrentValue, 0, $this->app_version->ReadOnly);

			// pd_byepass
			$this->pd_byepass->setDbValueDef($rsnew, $this->pd_byepass->CurrentValue, 0, $this->pd_byepass->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, NULL, $this->operator->ReadOnly);

			// google_map_api
			$this->google_map_api->setDbValueDef($rsnew, $this->google_map_api->CurrentValue, "", $this->google_map_api->ReadOnly);

			// material_payment_type
			$this->material_payment_type->setDbValueDef($rsnew, $this->material_payment_type->CurrentValue, 0, $this->material_payment_type->ReadOnly);

			// material_payment_varient
			$this->material_payment_varient->setDbValueDef($rsnew, $this->material_payment_varient->CurrentValue, 0, $this->material_payment_varient->ReadOnly);

			// footer_line_be
			$this->footer_line_be->setDbValueDef($rsnew, $this->footer_line_be->CurrentValue, "", $this->footer_line_be->ReadOnly);

			// allow_reg
			$this->allow_reg->setDbValueDef($rsnew, $this->allow_reg->CurrentValue, 0, $this->allow_reg->ReadOnly);

			// login_remember
			$this->login_remember->setDbValueDef($rsnew, $this->login_remember->CurrentValue, NULL, $this->login_remember->ReadOnly);

			// gp_p_check
			$this->gp_p_check->setDbValueDef($rsnew, $this->gp_p_check->CurrentValue, 0, $this->gp_p_check->ReadOnly);

			// fe_version
			$this->fe_version->setDbValueDef($rsnew, $this->fe_version->CurrentValue, "", $this->fe_version->ReadOnly);

			// admin_version
			$this->admin_version->setDbValueDef($rsnew, $this->admin_version->CurrentValue, NULL, $this->admin_version->ReadOnly);

			// dashboard
			$this->dashboard->setDbValueDef($rsnew, $this->dashboard->CurrentValue, 0, $this->dashboard->ReadOnly);

			// developer_upi_id
			$this->developer_upi_id->setDbValueDef($rsnew, $this->developer_upi_id->CurrentValue, NULL, $this->developer_upi_id->ReadOnly);

			// developer_company
			$this->developer_company->setDbValueDef($rsnew, $this->developer_company->CurrentValue, NULL, $this->developer_company->ReadOnly);

			// default_page
			$this->default_page->setDbValueDef($rsnew, $this->default_page->CurrentValue, "", $this->default_page->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("portal_setuplist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_portal_category":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>