<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for portal_version
 */
class portal_version extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $mysql_query;
	public $sp_query;
	public $php_code;
	public $url_link;
	public $portal_d_url_link;
	public $portal_d_php_code;
	public $portal_d_mysql_query;
	public $portal_d_sp_query;
	public $portal_c_php_code;
	public $portal_c_mysql_query;
	public $portal_c_sp_query;
	public $version;
	public $php_version;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'portal_version';
		$this->TableName = 'portal_version';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`portal_version`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('portal_version', 'portal_version', 'x_id', 'id', '`id`', '`id`', 2, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// mysql_query
		$this->mysql_query = new DbField('portal_version', 'portal_version', 'x_mysql_query', 'mysql_query', '`mysql_query`', '`mysql_query`', 201, -1, FALSE, '`mysql_query`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->mysql_query->Sortable = TRUE; // Allow sort
		$this->fields['mysql_query'] = &$this->mysql_query;

		// sp_query
		$this->sp_query = new DbField('portal_version', 'portal_version', 'x_sp_query', 'sp_query', '`sp_query`', '`sp_query`', 201, -1, FALSE, '`sp_query`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->sp_query->Sortable = TRUE; // Allow sort
		$this->fields['sp_query'] = &$this->sp_query;

		// php_code
		$this->php_code = new DbField('portal_version', 'portal_version', 'x_php_code', 'php_code', '`php_code`', '`php_code`', 200, -1, FALSE, '`php_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->php_code->Sortable = TRUE; // Allow sort
		$this->php_code->UploadAllowedFileExt = "zip";
		$this->php_code->UploadMaxFileSize = 104587600;
		$this->fields['php_code'] = &$this->php_code;

		// url_link
		$this->url_link = new DbField('portal_version', 'portal_version', 'x_url_link', 'url_link', '`url_link`', '`url_link`', 200, -1, FALSE, '`url_link`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->url_link->Sortable = TRUE; // Allow sort
		$this->fields['url_link'] = &$this->url_link;

		// portal_d_url_link
		$this->portal_d_url_link = new DbField('portal_version', 'portal_version', 'x_portal_d_url_link', 'portal_d_url_link', '`portal_d_url_link`', '`portal_d_url_link`', 201, -1, FALSE, '`portal_d_url_link`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->portal_d_url_link->Sortable = TRUE; // Allow sort
		$this->fields['portal_d_url_link'] = &$this->portal_d_url_link;

		// portal_d_php_code
		$this->portal_d_php_code = new DbField('portal_version', 'portal_version', 'x_portal_d_php_code', 'portal_d_php_code', '`portal_d_php_code`', '`portal_d_php_code`', 201, -1, FALSE, '`portal_d_php_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->portal_d_php_code->Sortable = TRUE; // Allow sort
		$this->fields['portal_d_php_code'] = &$this->portal_d_php_code;

		// portal_d_mysql_query
		$this->portal_d_mysql_query = new DbField('portal_version', 'portal_version', 'x_portal_d_mysql_query', 'portal_d_mysql_query', '`portal_d_mysql_query`', '`portal_d_mysql_query`', 201, -1, FALSE, '`portal_d_mysql_query`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->portal_d_mysql_query->Sortable = TRUE; // Allow sort
		$this->fields['portal_d_mysql_query'] = &$this->portal_d_mysql_query;

		// portal_d_sp_query
		$this->portal_d_sp_query = new DbField('portal_version', 'portal_version', 'x_portal_d_sp_query', 'portal_d_sp_query', '`portal_d_sp_query`', '`portal_d_sp_query`', 201, -1, FALSE, '`portal_d_sp_query`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->portal_d_sp_query->Sortable = TRUE; // Allow sort
		$this->fields['portal_d_sp_query'] = &$this->portal_d_sp_query;

		// portal_c_php_code
		$this->portal_c_php_code = new DbField('portal_version', 'portal_version', 'x_portal_c_php_code', 'portal_c_php_code', '`portal_c_php_code`', '`portal_c_php_code`', 201, -1, FALSE, '`portal_c_php_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->portal_c_php_code->Sortable = TRUE; // Allow sort
		$this->portal_c_php_code->Lookup = new Lookup('portal_c_php_code', 'portal_list', FALSE, 'url', ["url","","",""], [], [], [], [], [], [], '`url` ASC', '');
		$this->fields['portal_c_php_code'] = &$this->portal_c_php_code;

		// portal_c_mysql_query
		$this->portal_c_mysql_query = new DbField('portal_version', 'portal_version', 'x_portal_c_mysql_query', 'portal_c_mysql_query', '`portal_c_mysql_query`', '`portal_c_mysql_query`', 201, -1, FALSE, '`portal_c_mysql_query`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->portal_c_mysql_query->Sortable = TRUE; // Allow sort
		$this->portal_c_mysql_query->Lookup = new Lookup('portal_c_mysql_query', 'portal_list', FALSE, 'url', ["url","","",""], [], [], [], [], [], [], '`url` ASC', '');
		$this->fields['portal_c_mysql_query'] = &$this->portal_c_mysql_query;

		// portal_c_sp_query
		$this->portal_c_sp_query = new DbField('portal_version', 'portal_version', 'x_portal_c_sp_query', 'portal_c_sp_query', '`portal_c_sp_query`', '`portal_c_sp_query`', 201, -1, FALSE, '`portal_c_sp_query`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->portal_c_sp_query->Sortable = TRUE; // Allow sort
		$this->portal_c_sp_query->Lookup = new Lookup('portal_c_sp_query', 'portal_list', FALSE, 'url', ["url","","",""], [], [], [], [], [], [], '`url` ASC', '');
		$this->fields['portal_c_sp_query'] = &$this->portal_c_sp_query;

		// version
		$this->version = new DbField('portal_version', 'portal_version', 'x_version', 'version', '`version`', '`version`', 200, -1, FALSE, '`version`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->version->Sortable = TRUE; // Allow sort
		$this->fields['version'] = &$this->version;

		// php_version
		$this->php_version = new DbField('portal_version', 'portal_version', 'x_php_version', 'php_version', '`php_version`', '`php_version`', 200, -1, FALSE, '`php_version`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->php_version->Nullable = FALSE; // NOT NULL field
		$this->php_version->Sortable = TRUE; // Allow sort
		$this->fields['php_version'] = &$this->php_version;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`portal_version`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->mysql_query->DbValue = $row['mysql_query'];
		$this->sp_query->DbValue = $row['sp_query'];
		$this->php_code->DbValue = $row['php_code'];
		$this->url_link->DbValue = $row['url_link'];
		$this->portal_d_url_link->DbValue = $row['portal_d_url_link'];
		$this->portal_d_php_code->DbValue = $row['portal_d_php_code'];
		$this->portal_d_mysql_query->DbValue = $row['portal_d_mysql_query'];
		$this->portal_d_sp_query->DbValue = $row['portal_d_sp_query'];
		$this->portal_c_php_code->DbValue = $row['portal_c_php_code'];
		$this->portal_c_mysql_query->DbValue = $row['portal_c_mysql_query'];
		$this->portal_c_sp_query->DbValue = $row['portal_c_sp_query'];
		$this->version->DbValue = $row['version'];
		$this->php_version->DbValue = $row['php_version'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "portal_versionlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "portal_versionview.php")
			return $Language->phrase("View");
		elseif ($pageName == "portal_versionedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "portal_versionadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "portal_versionlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("portal_versionview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("portal_versionview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "portal_versionadd.php?" . $this->getUrlParm($parm);
		else
			$url = "portal_versionadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("portal_versionedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("portal_versionadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("portal_versiondelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->mysql_query->setDbValue($rs->fields('mysql_query'));
		$this->sp_query->setDbValue($rs->fields('sp_query'));
		$this->php_code->setDbValue($rs->fields('php_code'));
		$this->url_link->setDbValue($rs->fields('url_link'));
		$this->portal_d_url_link->setDbValue($rs->fields('portal_d_url_link'));
		$this->portal_d_php_code->setDbValue($rs->fields('portal_d_php_code'));
		$this->portal_d_mysql_query->setDbValue($rs->fields('portal_d_mysql_query'));
		$this->portal_d_sp_query->setDbValue($rs->fields('portal_d_sp_query'));
		$this->portal_c_php_code->setDbValue($rs->fields('portal_c_php_code'));
		$this->portal_c_mysql_query->setDbValue($rs->fields('portal_c_mysql_query'));
		$this->portal_c_sp_query->setDbValue($rs->fields('portal_c_sp_query'));
		$this->version->setDbValue($rs->fields('version'));
		$this->php_version->setDbValue($rs->fields('php_version'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// mysql_query
		// sp_query
		// php_code
		// url_link
		// portal_d_url_link
		// portal_d_php_code
		// portal_d_mysql_query
		// portal_d_sp_query
		// portal_c_php_code
		// portal_c_mysql_query
		// portal_c_sp_query
		// version
		// php_version
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// mysql_query
		$this->mysql_query->ViewValue = $this->mysql_query->CurrentValue;
		$this->mysql_query->ViewCustomAttributes = "";

		// sp_query
		$this->sp_query->ViewValue = $this->sp_query->CurrentValue;
		$this->sp_query->ViewCustomAttributes = "";

		// php_code
		$this->php_code->ViewValue = $this->php_code->CurrentValue;
		$this->php_code->ViewCustomAttributes = "";

		// url_link
		$this->url_link->ViewValue = $this->url_link->CurrentValue;
		$this->url_link->ViewCustomAttributes = "";

		// portal_d_url_link
		$this->portal_d_url_link->ViewValue = $this->portal_d_url_link->CurrentValue;
		$this->portal_d_url_link->ViewCustomAttributes = "";

		// portal_d_php_code
		$this->portal_d_php_code->ViewValue = $this->portal_d_php_code->CurrentValue;
		$this->portal_d_php_code->ViewCustomAttributes = "";

		// portal_d_mysql_query
		$this->portal_d_mysql_query->ViewValue = $this->portal_d_mysql_query->CurrentValue;
		$this->portal_d_mysql_query->ViewCustomAttributes = "";

		// portal_d_sp_query
		$this->portal_d_sp_query->ViewValue = $this->portal_d_sp_query->CurrentValue;
		$this->portal_d_sp_query->ViewCustomAttributes = "";

		// portal_c_php_code
		$this->portal_c_php_code->ViewValue = $this->portal_c_php_code->CurrentValue;
		$curVal = strval($this->portal_c_php_code->CurrentValue);
		if ($curVal <> "") {
			$this->portal_c_php_code->ViewValue = $this->portal_c_php_code->lookupCacheOption($curVal);
			if ($this->portal_c_php_code->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`url`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->portal_c_php_code->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->portal_c_php_code->ViewValue = $this->portal_c_php_code->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->portal_c_php_code->ViewValue = $this->portal_c_php_code->CurrentValue;
				}
			}
		} else {
			$this->portal_c_php_code->ViewValue = NULL;
		}
		$this->portal_c_php_code->ViewCustomAttributes = "";

		// portal_c_mysql_query
		$this->portal_c_mysql_query->ViewValue = $this->portal_c_mysql_query->CurrentValue;
		$curVal = strval($this->portal_c_mysql_query->CurrentValue);
		if ($curVal <> "") {
			$this->portal_c_mysql_query->ViewValue = $this->portal_c_mysql_query->lookupCacheOption($curVal);
			if ($this->portal_c_mysql_query->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`url`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->portal_c_mysql_query->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->portal_c_mysql_query->ViewValue = $this->portal_c_mysql_query->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->portal_c_mysql_query->ViewValue = $this->portal_c_mysql_query->CurrentValue;
				}
			}
		} else {
			$this->portal_c_mysql_query->ViewValue = NULL;
		}
		$this->portal_c_mysql_query->ViewCustomAttributes = "";

		// portal_c_sp_query
		$this->portal_c_sp_query->ViewValue = $this->portal_c_sp_query->CurrentValue;
		$curVal = strval($this->portal_c_sp_query->CurrentValue);
		if ($curVal <> "") {
			$this->portal_c_sp_query->ViewValue = $this->portal_c_sp_query->lookupCacheOption($curVal);
			if ($this->portal_c_sp_query->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`url`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->portal_c_sp_query->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->portal_c_sp_query->ViewValue = $this->portal_c_sp_query->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->portal_c_sp_query->ViewValue = $this->portal_c_sp_query->CurrentValue;
				}
			}
		} else {
			$this->portal_c_sp_query->ViewValue = NULL;
		}
		$this->portal_c_sp_query->ViewCustomAttributes = "";

		// version
		$this->version->ViewValue = $this->version->CurrentValue;
		$this->version->ViewCustomAttributes = "";

		// php_version
		$this->php_version->ViewValue = $this->php_version->CurrentValue;
		$this->php_version->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// mysql_query
		$this->mysql_query->LinkCustomAttributes = "";
		$this->mysql_query->HrefValue = "";
		$this->mysql_query->TooltipValue = "";

		// sp_query
		$this->sp_query->LinkCustomAttributes = "";
		$this->sp_query->HrefValue = "";
		$this->sp_query->TooltipValue = "";

		// php_code
		$this->php_code->LinkCustomAttributes = "";
		$this->php_code->HrefValue = "";
		$this->php_code->TooltipValue = "";

		// url_link
		$this->url_link->LinkCustomAttributes = "";
		$this->url_link->HrefValue = "";
		$this->url_link->TooltipValue = "";

		// portal_d_url_link
		$this->portal_d_url_link->LinkCustomAttributes = "";
		$this->portal_d_url_link->HrefValue = "";
		$this->portal_d_url_link->TooltipValue = "";

		// portal_d_php_code
		$this->portal_d_php_code->LinkCustomAttributes = "";
		$this->portal_d_php_code->HrefValue = "";
		$this->portal_d_php_code->TooltipValue = "";

		// portal_d_mysql_query
		$this->portal_d_mysql_query->LinkCustomAttributes = "";
		$this->portal_d_mysql_query->HrefValue = "";
		$this->portal_d_mysql_query->TooltipValue = "";

		// portal_d_sp_query
		$this->portal_d_sp_query->LinkCustomAttributes = "";
		$this->portal_d_sp_query->HrefValue = "";
		$this->portal_d_sp_query->TooltipValue = "";

		// portal_c_php_code
		$this->portal_c_php_code->LinkCustomAttributes = "";
		$this->portal_c_php_code->HrefValue = "";
		$this->portal_c_php_code->TooltipValue = "";

		// portal_c_mysql_query
		$this->portal_c_mysql_query->LinkCustomAttributes = "";
		$this->portal_c_mysql_query->HrefValue = "";
		$this->portal_c_mysql_query->TooltipValue = "";

		// portal_c_sp_query
		$this->portal_c_sp_query->LinkCustomAttributes = "";
		$this->portal_c_sp_query->HrefValue = "";
		$this->portal_c_sp_query->TooltipValue = "";

		// version
		$this->version->LinkCustomAttributes = "";
		$this->version->HrefValue = "";
		$this->version->TooltipValue = "";

		// php_version
		$this->php_version->LinkCustomAttributes = "";
		$this->php_version->HrefValue = "";
		$this->php_version->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// mysql_query
		$this->mysql_query->EditAttrs["class"] = "form-control";
		$this->mysql_query->EditCustomAttributes = "";
		$this->mysql_query->EditValue = $this->mysql_query->CurrentValue;
		$this->mysql_query->ViewCustomAttributes = "";

		// sp_query
		$this->sp_query->EditAttrs["class"] = "form-control";
		$this->sp_query->EditCustomAttributes = "";
		$this->sp_query->EditValue = $this->sp_query->CurrentValue;
		$this->sp_query->ViewCustomAttributes = "";

		// php_code
		$this->php_code->EditAttrs["class"] = "form-control";
		$this->php_code->EditCustomAttributes = "";
		$this->php_code->EditValue = $this->php_code->CurrentValue;
		$this->php_code->ViewCustomAttributes = "";

		// url_link
		$this->url_link->EditAttrs["class"] = "form-control";
		$this->url_link->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->url_link->CurrentValue = HtmlDecode($this->url_link->CurrentValue);
		$this->url_link->EditValue = $this->url_link->CurrentValue;
		$this->url_link->PlaceHolder = RemoveHtml($this->url_link->caption());

		// portal_d_url_link
		$this->portal_d_url_link->EditAttrs["class"] = "form-control";
		$this->portal_d_url_link->EditCustomAttributes = "";
		$this->portal_d_url_link->EditValue = $this->portal_d_url_link->CurrentValue;
		$this->portal_d_url_link->PlaceHolder = RemoveHtml($this->portal_d_url_link->caption());

		// portal_d_php_code
		$this->portal_d_php_code->EditAttrs["class"] = "form-control";
		$this->portal_d_php_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->portal_d_php_code->CurrentValue = HtmlDecode($this->portal_d_php_code->CurrentValue);
		$this->portal_d_php_code->EditValue = $this->portal_d_php_code->CurrentValue;
		$this->portal_d_php_code->PlaceHolder = RemoveHtml($this->portal_d_php_code->caption());

		// portal_d_mysql_query
		$this->portal_d_mysql_query->EditAttrs["class"] = "form-control";
		$this->portal_d_mysql_query->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->portal_d_mysql_query->CurrentValue = HtmlDecode($this->portal_d_mysql_query->CurrentValue);
		$this->portal_d_mysql_query->EditValue = $this->portal_d_mysql_query->CurrentValue;
		$this->portal_d_mysql_query->PlaceHolder = RemoveHtml($this->portal_d_mysql_query->caption());

		// portal_d_sp_query
		$this->portal_d_sp_query->EditAttrs["class"] = "form-control";
		$this->portal_d_sp_query->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->portal_d_sp_query->CurrentValue = HtmlDecode($this->portal_d_sp_query->CurrentValue);
		$this->portal_d_sp_query->EditValue = $this->portal_d_sp_query->CurrentValue;
		$this->portal_d_sp_query->PlaceHolder = RemoveHtml($this->portal_d_sp_query->caption());

		// portal_c_php_code
		$this->portal_c_php_code->EditAttrs["class"] = "form-control";
		$this->portal_c_php_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->portal_c_php_code->CurrentValue = HtmlDecode($this->portal_c_php_code->CurrentValue);
		$this->portal_c_php_code->EditValue = $this->portal_c_php_code->CurrentValue;
		$this->portal_c_php_code->PlaceHolder = RemoveHtml($this->portal_c_php_code->caption());

		// portal_c_mysql_query
		$this->portal_c_mysql_query->EditAttrs["class"] = "form-control";
		$this->portal_c_mysql_query->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->portal_c_mysql_query->CurrentValue = HtmlDecode($this->portal_c_mysql_query->CurrentValue);
		$this->portal_c_mysql_query->EditValue = $this->portal_c_mysql_query->CurrentValue;
		$this->portal_c_mysql_query->PlaceHolder = RemoveHtml($this->portal_c_mysql_query->caption());

		// portal_c_sp_query
		$this->portal_c_sp_query->EditAttrs["class"] = "form-control";
		$this->portal_c_sp_query->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->portal_c_sp_query->CurrentValue = HtmlDecode($this->portal_c_sp_query->CurrentValue);
		$this->portal_c_sp_query->EditValue = $this->portal_c_sp_query->CurrentValue;
		$this->portal_c_sp_query->PlaceHolder = RemoveHtml($this->portal_c_sp_query->caption());

		// version
		$this->version->EditAttrs["class"] = "form-control";
		$this->version->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->version->CurrentValue = HtmlDecode($this->version->CurrentValue);
		$this->version->EditValue = $this->version->CurrentValue;
		$this->version->PlaceHolder = RemoveHtml($this->version->caption());

		// php_version
		$this->php_version->EditAttrs["class"] = "form-control";
		$this->php_version->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->php_version->CurrentValue = HtmlDecode($this->php_version->CurrentValue);
		$this->php_version->EditValue = $this->php_version->CurrentValue;
		$this->php_version->PlaceHolder = RemoveHtml($this->php_version->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->mysql_query);
					$doc->exportCaption($this->sp_query);
					$doc->exportCaption($this->php_code);
					$doc->exportCaption($this->url_link);
					$doc->exportCaption($this->portal_d_url_link);
					$doc->exportCaption($this->portal_d_php_code);
					$doc->exportCaption($this->portal_d_mysql_query);
					$doc->exportCaption($this->portal_d_sp_query);
					$doc->exportCaption($this->portal_c_php_code);
					$doc->exportCaption($this->portal_c_mysql_query);
					$doc->exportCaption($this->portal_c_sp_query);
					$doc->exportCaption($this->version);
					$doc->exportCaption($this->php_version);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->url_link);
					$doc->exportCaption($this->version);
					$doc->exportCaption($this->php_version);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->mysql_query);
						$doc->exportField($this->sp_query);
						$doc->exportField($this->php_code);
						$doc->exportField($this->url_link);
						$doc->exportField($this->portal_d_url_link);
						$doc->exportField($this->portal_d_php_code);
						$doc->exportField($this->portal_d_mysql_query);
						$doc->exportField($this->portal_d_sp_query);
						$doc->exportField($this->portal_c_php_code);
						$doc->exportField($this->portal_c_mysql_query);
						$doc->exportField($this->portal_c_sp_query);
						$doc->exportField($this->version);
						$doc->exportField($this->php_version);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->url_link);
						$doc->exportField($this->version);
						$doc->exportField($this->php_version);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>