<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class portal_version_add extends portal_version
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'portal_version';

	// Page object name
	public $PageObjName = "portal_version_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (portal_version)
		if (!isset($GLOBALS["portal_version"]) || get_class($GLOBALS["portal_version"]) == PROJECT_NAMESPACE . "portal_version") {
			$GLOBALS["portal_version"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["portal_version"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'portal_version');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $portal_version;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($portal_version);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "portal_versionview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("portal_versionlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->mysql_query->setVisibility();
		$this->sp_query->setVisibility();
		$this->php_code->setVisibility();
		$this->url_link->setVisibility();
		$this->portal_d_url_link->Visible = FALSE;
		$this->portal_d_php_code->Visible = FALSE;
		$this->portal_d_mysql_query->Visible = FALSE;
		$this->portal_d_sp_query->Visible = FALSE;
		$this->portal_c_php_code->Visible = FALSE;
		$this->portal_c_mysql_query->Visible = FALSE;
		$this->portal_c_sp_query->Visible = FALSE;
		$this->version->setVisibility();
		$this->php_version->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->portal_c_php_code);
		$this->setupLookupOptions($this->portal_c_mysql_query);
		$this->setupLookupOptions($this->portal_c_sp_query);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("portal_versionlist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "portal_versionlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "portal_versionview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->mysql_query->CurrentValue = NULL;
		$this->mysql_query->OldValue = $this->mysql_query->CurrentValue;
		$this->sp_query->CurrentValue = NULL;
		$this->sp_query->OldValue = $this->sp_query->CurrentValue;
		$this->php_code->CurrentValue = 'd0a125f695437c8e79d67fb6b96087ac' . date("ymdhis");
		$this->url_link->CurrentValue = NULL;
		$this->url_link->OldValue = $this->url_link->CurrentValue;
		$this->portal_d_url_link->CurrentValue = NULL;
		$this->portal_d_url_link->OldValue = $this->portal_d_url_link->CurrentValue;
		$this->portal_d_php_code->CurrentValue = NULL;
		$this->portal_d_php_code->OldValue = $this->portal_d_php_code->CurrentValue;
		$this->portal_d_mysql_query->CurrentValue = NULL;
		$this->portal_d_mysql_query->OldValue = $this->portal_d_mysql_query->CurrentValue;
		$this->portal_d_sp_query->CurrentValue = NULL;
		$this->portal_d_sp_query->OldValue = $this->portal_d_sp_query->CurrentValue;
		$this->portal_c_php_code->CurrentValue = NULL;
		$this->portal_c_php_code->OldValue = $this->portal_c_php_code->CurrentValue;
		$this->portal_c_mysql_query->CurrentValue = NULL;
		$this->portal_c_mysql_query->OldValue = $this->portal_c_mysql_query->CurrentValue;
		$this->portal_c_sp_query->CurrentValue = NULL;
		$this->portal_c_sp_query->OldValue = $this->portal_c_sp_query->CurrentValue;
		$this->version->CurrentValue = NULL;
		$this->version->OldValue = $this->version->CurrentValue;
		$this->php_version->CurrentValue = "fibre";
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'mysql_query' first before field var 'x_mysql_query'
		$val = $CurrentForm->hasValue("mysql_query") ? $CurrentForm->getValue("mysql_query") : $CurrentForm->getValue("x_mysql_query");
		if (!$this->mysql_query->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mysql_query->Visible = FALSE; // Disable update for API request
			else
				$this->mysql_query->setFormValue($val);
		}

		// Check field name 'sp_query' first before field var 'x_sp_query'
		$val = $CurrentForm->hasValue("sp_query") ? $CurrentForm->getValue("sp_query") : $CurrentForm->getValue("x_sp_query");
		if (!$this->sp_query->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sp_query->Visible = FALSE; // Disable update for API request
			else
				$this->sp_query->setFormValue($val);
		}

		// Check field name 'php_code' first before field var 'x_php_code'
		$val = $CurrentForm->hasValue("php_code") ? $CurrentForm->getValue("php_code") : $CurrentForm->getValue("x_php_code");
		if (!$this->php_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->php_code->Visible = FALSE; // Disable update for API request
			else
				$this->php_code->setFormValue($val);
		}

		// Check field name 'url_link' first before field var 'x_url_link'
		$val = $CurrentForm->hasValue("url_link") ? $CurrentForm->getValue("url_link") : $CurrentForm->getValue("x_url_link");
		if (!$this->url_link->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->url_link->Visible = FALSE; // Disable update for API request
			else
				$this->url_link->setFormValue($val);
		}

		// Check field name 'version' first before field var 'x_version'
		$val = $CurrentForm->hasValue("version") ? $CurrentForm->getValue("version") : $CurrentForm->getValue("x_version");
		if (!$this->version->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->version->Visible = FALSE; // Disable update for API request
			else
				$this->version->setFormValue($val);
		}

		// Check field name 'php_version' first before field var 'x_php_version'
		$val = $CurrentForm->hasValue("php_version") ? $CurrentForm->getValue("php_version") : $CurrentForm->getValue("x_php_version");
		if (!$this->php_version->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->php_version->Visible = FALSE; // Disable update for API request
			else
				$this->php_version->setFormValue($val);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->mysql_query->CurrentValue = $this->mysql_query->FormValue;
		$this->sp_query->CurrentValue = $this->sp_query->FormValue;
		$this->php_code->CurrentValue = $this->php_code->FormValue;
		$this->url_link->CurrentValue = $this->url_link->FormValue;
		$this->version->CurrentValue = $this->version->FormValue;
		$this->php_version->CurrentValue = $this->php_version->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->mysql_query->setDbValue($row['mysql_query']);
		$this->sp_query->setDbValue($row['sp_query']);
		$this->php_code->setDbValue($row['php_code']);
		$this->url_link->setDbValue($row['url_link']);
		$this->portal_d_url_link->setDbValue($row['portal_d_url_link']);
		$this->portal_d_php_code->setDbValue($row['portal_d_php_code']);
		$this->portal_d_mysql_query->setDbValue($row['portal_d_mysql_query']);
		$this->portal_d_sp_query->setDbValue($row['portal_d_sp_query']);
		$this->portal_c_php_code->setDbValue($row['portal_c_php_code']);
		$this->portal_c_mysql_query->setDbValue($row['portal_c_mysql_query']);
		$this->portal_c_sp_query->setDbValue($row['portal_c_sp_query']);
		$this->version->setDbValue($row['version']);
		$this->php_version->setDbValue($row['php_version']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['mysql_query'] = $this->mysql_query->CurrentValue;
		$row['sp_query'] = $this->sp_query->CurrentValue;
		$row['php_code'] = $this->php_code->CurrentValue;
		$row['url_link'] = $this->url_link->CurrentValue;
		$row['portal_d_url_link'] = $this->portal_d_url_link->CurrentValue;
		$row['portal_d_php_code'] = $this->portal_d_php_code->CurrentValue;
		$row['portal_d_mysql_query'] = $this->portal_d_mysql_query->CurrentValue;
		$row['portal_d_sp_query'] = $this->portal_d_sp_query->CurrentValue;
		$row['portal_c_php_code'] = $this->portal_c_php_code->CurrentValue;
		$row['portal_c_mysql_query'] = $this->portal_c_mysql_query->CurrentValue;
		$row['portal_c_sp_query'] = $this->portal_c_sp_query->CurrentValue;
		$row['version'] = $this->version->CurrentValue;
		$row['php_version'] = $this->php_version->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// mysql_query
		// sp_query
		// php_code
		// url_link
		// portal_d_url_link
		// portal_d_php_code
		// portal_d_mysql_query
		// portal_d_sp_query
		// portal_c_php_code
		// portal_c_mysql_query
		// portal_c_sp_query
		// version
		// php_version

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// mysql_query
			$this->mysql_query->ViewValue = $this->mysql_query->CurrentValue;
			$this->mysql_query->ViewCustomAttributes = "";

			// sp_query
			$this->sp_query->ViewValue = $this->sp_query->CurrentValue;
			$this->sp_query->ViewCustomAttributes = "";

			// php_code
			$this->php_code->ViewValue = $this->php_code->CurrentValue;
			$this->php_code->ViewCustomAttributes = "";

			// url_link
			$this->url_link->ViewValue = $this->url_link->CurrentValue;
			$this->url_link->ViewCustomAttributes = "";

			// version
			$this->version->ViewValue = $this->version->CurrentValue;
			$this->version->ViewCustomAttributes = "";

			// php_version
			$this->php_version->ViewValue = $this->php_version->CurrentValue;
			$this->php_version->ViewCustomAttributes = "";

			// mysql_query
			$this->mysql_query->LinkCustomAttributes = "";
			$this->mysql_query->HrefValue = "";
			$this->mysql_query->TooltipValue = "";

			// sp_query
			$this->sp_query->LinkCustomAttributes = "";
			$this->sp_query->HrefValue = "";
			$this->sp_query->TooltipValue = "";

			// php_code
			$this->php_code->LinkCustomAttributes = "";
			$this->php_code->HrefValue = "";
			$this->php_code->TooltipValue = "";

			// url_link
			$this->url_link->LinkCustomAttributes = "";
			$this->url_link->HrefValue = "";
			$this->url_link->TooltipValue = "";

			// version
			$this->version->LinkCustomAttributes = "";
			$this->version->HrefValue = "";
			$this->version->TooltipValue = "";

			// php_version
			$this->php_version->LinkCustomAttributes = "";
			$this->php_version->HrefValue = "";
			$this->php_version->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// mysql_query
			$this->mysql_query->EditAttrs["class"] = "form-control";
			$this->mysql_query->EditCustomAttributes = "";
			$this->mysql_query->EditValue = HtmlEncode($this->mysql_query->CurrentValue);
			$this->mysql_query->PlaceHolder = RemoveHtml($this->mysql_query->caption());

			// sp_query
			$this->sp_query->EditAttrs["class"] = "form-control";
			$this->sp_query->EditCustomAttributes = "";
			$this->sp_query->EditValue = HtmlEncode($this->sp_query->CurrentValue);
			$this->sp_query->PlaceHolder = RemoveHtml($this->sp_query->caption());

			// php_code
			$this->php_code->EditAttrs["class"] = "form-control";
			$this->php_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->php_code->CurrentValue = HtmlDecode($this->php_code->CurrentValue);
			$this->php_code->EditValue = HtmlEncode($this->php_code->CurrentValue);
			$this->php_code->PlaceHolder = RemoveHtml($this->php_code->caption());

			// url_link
			$this->url_link->EditAttrs["class"] = "form-control";
			$this->url_link->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->url_link->CurrentValue = HtmlDecode($this->url_link->CurrentValue);
			$this->url_link->EditValue = HtmlEncode($this->url_link->CurrentValue);
			$this->url_link->PlaceHolder = RemoveHtml($this->url_link->caption());

			// version
			$this->version->EditAttrs["class"] = "form-control";
			$this->version->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->version->CurrentValue = HtmlDecode($this->version->CurrentValue);
			$this->version->EditValue = HtmlEncode($this->version->CurrentValue);
			$this->version->PlaceHolder = RemoveHtml($this->version->caption());

			// php_version
			$this->php_version->EditAttrs["class"] = "form-control";
			$this->php_version->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->php_version->CurrentValue = HtmlDecode($this->php_version->CurrentValue);
			$this->php_version->EditValue = HtmlEncode($this->php_version->CurrentValue);
			$this->php_version->PlaceHolder = RemoveHtml($this->php_version->caption());

			// Add refer script
			// mysql_query

			$this->mysql_query->LinkCustomAttributes = "";
			$this->mysql_query->HrefValue = "";

			// sp_query
			$this->sp_query->LinkCustomAttributes = "";
			$this->sp_query->HrefValue = "";

			// php_code
			$this->php_code->LinkCustomAttributes = "";
			$this->php_code->HrefValue = "";

			// url_link
			$this->url_link->LinkCustomAttributes = "";
			$this->url_link->HrefValue = "";

			// version
			$this->version->LinkCustomAttributes = "";
			$this->version->HrefValue = "";

			// php_version
			$this->php_version->LinkCustomAttributes = "";
			$this->php_version->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->mysql_query->Required) {
			if (!$this->mysql_query->IsDetailKey && $this->mysql_query->FormValue != NULL && $this->mysql_query->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mysql_query->caption(), $this->mysql_query->RequiredErrorMessage));
			}
		}
		if ($this->sp_query->Required) {
			if (!$this->sp_query->IsDetailKey && $this->sp_query->FormValue != NULL && $this->sp_query->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sp_query->caption(), $this->sp_query->RequiredErrorMessage));
			}
		}
		if ($this->php_code->Required) {
			if (!$this->php_code->IsDetailKey && $this->php_code->FormValue != NULL && $this->php_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->php_code->caption(), $this->php_code->RequiredErrorMessage));
			}
		}
		if ($this->url_link->Required) {
			if (!$this->url_link->IsDetailKey && $this->url_link->FormValue != NULL && $this->url_link->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->url_link->caption(), $this->url_link->RequiredErrorMessage));
			}
		}
		if ($this->portal_d_url_link->Required) {
			if (!$this->portal_d_url_link->IsDetailKey && $this->portal_d_url_link->FormValue != NULL && $this->portal_d_url_link->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->portal_d_url_link->caption(), $this->portal_d_url_link->RequiredErrorMessage));
			}
		}
		if ($this->portal_d_php_code->Required) {
			if (!$this->portal_d_php_code->IsDetailKey && $this->portal_d_php_code->FormValue != NULL && $this->portal_d_php_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->portal_d_php_code->caption(), $this->portal_d_php_code->RequiredErrorMessage));
			}
		}
		if ($this->portal_d_mysql_query->Required) {
			if (!$this->portal_d_mysql_query->IsDetailKey && $this->portal_d_mysql_query->FormValue != NULL && $this->portal_d_mysql_query->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->portal_d_mysql_query->caption(), $this->portal_d_mysql_query->RequiredErrorMessage));
			}
		}
		if ($this->portal_d_sp_query->Required) {
			if (!$this->portal_d_sp_query->IsDetailKey && $this->portal_d_sp_query->FormValue != NULL && $this->portal_d_sp_query->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->portal_d_sp_query->caption(), $this->portal_d_sp_query->RequiredErrorMessage));
			}
		}
		if ($this->portal_c_php_code->Required) {
			if (!$this->portal_c_php_code->IsDetailKey && $this->portal_c_php_code->FormValue != NULL && $this->portal_c_php_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->portal_c_php_code->caption(), $this->portal_c_php_code->RequiredErrorMessage));
			}
		}
		if ($this->portal_c_mysql_query->Required) {
			if (!$this->portal_c_mysql_query->IsDetailKey && $this->portal_c_mysql_query->FormValue != NULL && $this->portal_c_mysql_query->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->portal_c_mysql_query->caption(), $this->portal_c_mysql_query->RequiredErrorMessage));
			}
		}
		if ($this->portal_c_sp_query->Required) {
			if (!$this->portal_c_sp_query->IsDetailKey && $this->portal_c_sp_query->FormValue != NULL && $this->portal_c_sp_query->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->portal_c_sp_query->caption(), $this->portal_c_sp_query->RequiredErrorMessage));
			}
		}
		if ($this->version->Required) {
			if (!$this->version->IsDetailKey && $this->version->FormValue != NULL && $this->version->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->version->caption(), $this->version->RequiredErrorMessage));
			}
		}
		if ($this->php_version->Required) {
			if (!$this->php_version->IsDetailKey && $this->php_version->FormValue != NULL && $this->php_version->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->php_version->caption(), $this->php_version->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		if ($this->version->CurrentValue <> "") { // Check field with unique index
			$filter = "(version = '" . AdjustSql($this->version->CurrentValue, $this->Dbid) . "')";
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->version->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->version->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
		}
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// mysql_query
		$this->mysql_query->setDbValueDef($rsnew, $this->mysql_query->CurrentValue, NULL, FALSE);

		// sp_query
		$this->sp_query->setDbValueDef($rsnew, $this->sp_query->CurrentValue, NULL, FALSE);

		// php_code
		$this->php_code->setDbValueDef($rsnew, $this->php_code->CurrentValue, NULL, FALSE);

		// url_link
		$this->url_link->setDbValueDef($rsnew, $this->url_link->CurrentValue, NULL, FALSE);

		// version
		$this->version->setDbValueDef($rsnew, $this->version->CurrentValue, NULL, FALSE);

		// php_version
		$this->php_version->setDbValueDef($rsnew, $this->php_version->CurrentValue, "", strval($this->php_version->CurrentValue) == "");

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("portal_versionlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_portal_c_php_code":
							break;
						case "x_portal_c_mysql_query":
							break;
						case "x_portal_c_sp_query":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		$this->php_code->ReadOnly = True;
		$URL = $_SERVER["HTTP_HOST"];
		IF ($URL != 'fibre.intsys.in')
		{
		$_SESSION[SESSION_SUCCESS_MESSAGE] = 'Not Authorized to View Portal Version';
		header('location:index.php');
		}	
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		extract($_POST,EXTR_OVERWRITE);	
		rename('fibre.zip', $x_php_code.'.zip');
		ExecuteStatement("SET @@group_concat_max_len = 100000;");
		return TRUE;
	}
}
?>