<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class portal_version_search extends portal_version
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'portal_version';

	// Page object name
	public $PageObjName = "portal_version_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (portal_version)
		if (!isset($GLOBALS["portal_version"]) || get_class($GLOBALS["portal_version"]) == PROJECT_NAMESPACE . "portal_version") {
			$GLOBALS["portal_version"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["portal_version"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'portal_version');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $portal_version;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($portal_version);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "portal_versionview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("portal_versionlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->mysql_query->setVisibility();
		$this->sp_query->setVisibility();
		$this->php_code->setVisibility();
		$this->url_link->setVisibility();
		$this->portal_d_url_link->setVisibility();
		$this->portal_d_php_code->setVisibility();
		$this->portal_d_mysql_query->setVisibility();
		$this->portal_d_sp_query->setVisibility();
		$this->portal_c_php_code->setVisibility();
		$this->portal_c_mysql_query->setVisibility();
		$this->portal_c_sp_query->setVisibility();
		$this->version->setVisibility();
		$this->php_version->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->portal_c_php_code);
		$this->setupLookupOptions($this->portal_c_mysql_query);
		$this->setupLookupOptions($this->portal_c_sp_query);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "portal_versionlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->mysql_query); // mysql_query
		$this->buildSearchUrl($srchUrl, $this->sp_query); // sp_query
		$this->buildSearchUrl($srchUrl, $this->php_code); // php_code
		$this->buildSearchUrl($srchUrl, $this->url_link); // url_link
		$this->buildSearchUrl($srchUrl, $this->portal_d_url_link); // portal_d_url_link
		$this->buildSearchUrl($srchUrl, $this->portal_d_php_code); // portal_d_php_code
		$this->buildSearchUrl($srchUrl, $this->portal_d_mysql_query); // portal_d_mysql_query
		$this->buildSearchUrl($srchUrl, $this->portal_d_sp_query); // portal_d_sp_query
		$this->buildSearchUrl($srchUrl, $this->portal_c_php_code); // portal_c_php_code
		$this->buildSearchUrl($srchUrl, $this->portal_c_mysql_query); // portal_c_mysql_query
		$this->buildSearchUrl($srchUrl, $this->portal_c_sp_query); // portal_c_sp_query
		$this->buildSearchUrl($srchUrl, $this->version); // version
		$this->buildSearchUrl($srchUrl, $this->php_version); // php_version
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// mysql_query
		if (!$this->isAddOrEdit())
			$this->mysql_query->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_mysql_query"));
		$this->mysql_query->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_mysql_query"));

		// sp_query
		if (!$this->isAddOrEdit())
			$this->sp_query->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sp_query"));
		$this->sp_query->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sp_query"));

		// php_code
		if (!$this->isAddOrEdit())
			$this->php_code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_php_code"));
		$this->php_code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_php_code"));

		// url_link
		if (!$this->isAddOrEdit())
			$this->url_link->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_url_link"));
		$this->url_link->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_url_link"));

		// portal_d_url_link
		if (!$this->isAddOrEdit())
			$this->portal_d_url_link->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_portal_d_url_link"));
		$this->portal_d_url_link->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_portal_d_url_link"));

		// portal_d_php_code
		if (!$this->isAddOrEdit())
			$this->portal_d_php_code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_portal_d_php_code"));
		$this->portal_d_php_code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_portal_d_php_code"));

		// portal_d_mysql_query
		if (!$this->isAddOrEdit())
			$this->portal_d_mysql_query->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_portal_d_mysql_query"));
		$this->portal_d_mysql_query->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_portal_d_mysql_query"));

		// portal_d_sp_query
		if (!$this->isAddOrEdit())
			$this->portal_d_sp_query->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_portal_d_sp_query"));
		$this->portal_d_sp_query->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_portal_d_sp_query"));

		// portal_c_php_code
		if (!$this->isAddOrEdit())
			$this->portal_c_php_code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_portal_c_php_code"));
		$this->portal_c_php_code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_portal_c_php_code"));

		// portal_c_mysql_query
		if (!$this->isAddOrEdit())
			$this->portal_c_mysql_query->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_portal_c_mysql_query"));
		$this->portal_c_mysql_query->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_portal_c_mysql_query"));

		// portal_c_sp_query
		if (!$this->isAddOrEdit())
			$this->portal_c_sp_query->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_portal_c_sp_query"));
		$this->portal_c_sp_query->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_portal_c_sp_query"));

		// version
		if (!$this->isAddOrEdit())
			$this->version->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_version"));
		$this->version->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_version"));

		// php_version
		if (!$this->isAddOrEdit())
			$this->php_version->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_php_version"));
		$this->php_version->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_php_version"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// mysql_query
		// sp_query
		// php_code
		// url_link
		// portal_d_url_link
		// portal_d_php_code
		// portal_d_mysql_query
		// portal_d_sp_query
		// portal_c_php_code
		// portal_c_mysql_query
		// portal_c_sp_query
		// version
		// php_version

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// mysql_query
			$this->mysql_query->ViewValue = $this->mysql_query->CurrentValue;
			$this->mysql_query->ViewCustomAttributes = "";

			// sp_query
			$this->sp_query->ViewValue = $this->sp_query->CurrentValue;
			$this->sp_query->ViewCustomAttributes = "";

			// php_code
			$this->php_code->ViewValue = $this->php_code->CurrentValue;
			$this->php_code->ViewCustomAttributes = "";

			// url_link
			$this->url_link->ViewValue = $this->url_link->CurrentValue;
			$this->url_link->ViewCustomAttributes = "";

			// portal_d_url_link
			$this->portal_d_url_link->ViewValue = $this->portal_d_url_link->CurrentValue;
			$this->portal_d_url_link->ViewCustomAttributes = "";

			// portal_d_php_code
			$this->portal_d_php_code->ViewValue = $this->portal_d_php_code->CurrentValue;
			$this->portal_d_php_code->ViewCustomAttributes = "";

			// portal_d_mysql_query
			$this->portal_d_mysql_query->ViewValue = $this->portal_d_mysql_query->CurrentValue;
			$this->portal_d_mysql_query->ViewCustomAttributes = "";

			// portal_d_sp_query
			$this->portal_d_sp_query->ViewValue = $this->portal_d_sp_query->CurrentValue;
			$this->portal_d_sp_query->ViewCustomAttributes = "";

			// portal_c_php_code
			$this->portal_c_php_code->ViewValue = $this->portal_c_php_code->CurrentValue;
			$curVal = strval($this->portal_c_php_code->CurrentValue);
			if ($curVal <> "") {
				$this->portal_c_php_code->ViewValue = $this->portal_c_php_code->lookupCacheOption($curVal);
				if ($this->portal_c_php_code->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`url`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->portal_c_php_code->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->portal_c_php_code->ViewValue = $this->portal_c_php_code->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->portal_c_php_code->ViewValue = $this->portal_c_php_code->CurrentValue;
					}
				}
			} else {
				$this->portal_c_php_code->ViewValue = NULL;
			}
			$this->portal_c_php_code->ViewCustomAttributes = "";

			// portal_c_mysql_query
			$this->portal_c_mysql_query->ViewValue = $this->portal_c_mysql_query->CurrentValue;
			$curVal = strval($this->portal_c_mysql_query->CurrentValue);
			if ($curVal <> "") {
				$this->portal_c_mysql_query->ViewValue = $this->portal_c_mysql_query->lookupCacheOption($curVal);
				if ($this->portal_c_mysql_query->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`url`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->portal_c_mysql_query->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->portal_c_mysql_query->ViewValue = $this->portal_c_mysql_query->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->portal_c_mysql_query->ViewValue = $this->portal_c_mysql_query->CurrentValue;
					}
				}
			} else {
				$this->portal_c_mysql_query->ViewValue = NULL;
			}
			$this->portal_c_mysql_query->ViewCustomAttributes = "";

			// portal_c_sp_query
			$this->portal_c_sp_query->ViewValue = $this->portal_c_sp_query->CurrentValue;
			$curVal = strval($this->portal_c_sp_query->CurrentValue);
			if ($curVal <> "") {
				$this->portal_c_sp_query->ViewValue = $this->portal_c_sp_query->lookupCacheOption($curVal);
				if ($this->portal_c_sp_query->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`url`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->portal_c_sp_query->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->portal_c_sp_query->ViewValue = $this->portal_c_sp_query->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->portal_c_sp_query->ViewValue = $this->portal_c_sp_query->CurrentValue;
					}
				}
			} else {
				$this->portal_c_sp_query->ViewValue = NULL;
			}
			$this->portal_c_sp_query->ViewCustomAttributes = "";

			// version
			$this->version->ViewValue = $this->version->CurrentValue;
			$this->version->ViewCustomAttributes = "";

			// php_version
			$this->php_version->ViewValue = $this->php_version->CurrentValue;
			$this->php_version->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// mysql_query
			$this->mysql_query->LinkCustomAttributes = "";
			$this->mysql_query->HrefValue = "";
			$this->mysql_query->TooltipValue = "";

			// sp_query
			$this->sp_query->LinkCustomAttributes = "";
			$this->sp_query->HrefValue = "";
			$this->sp_query->TooltipValue = "";

			// php_code
			$this->php_code->LinkCustomAttributes = "";
			$this->php_code->HrefValue = "";
			$this->php_code->TooltipValue = "";

			// url_link
			$this->url_link->LinkCustomAttributes = "";
			$this->url_link->HrefValue = "";
			$this->url_link->TooltipValue = "";

			// portal_d_url_link
			$this->portal_d_url_link->LinkCustomAttributes = "";
			$this->portal_d_url_link->HrefValue = "";
			$this->portal_d_url_link->TooltipValue = "";

			// portal_d_php_code
			$this->portal_d_php_code->LinkCustomAttributes = "";
			$this->portal_d_php_code->HrefValue = "";
			$this->portal_d_php_code->TooltipValue = "";

			// portal_d_mysql_query
			$this->portal_d_mysql_query->LinkCustomAttributes = "";
			$this->portal_d_mysql_query->HrefValue = "";
			$this->portal_d_mysql_query->TooltipValue = "";

			// portal_d_sp_query
			$this->portal_d_sp_query->LinkCustomAttributes = "";
			$this->portal_d_sp_query->HrefValue = "";
			$this->portal_d_sp_query->TooltipValue = "";

			// portal_c_php_code
			$this->portal_c_php_code->LinkCustomAttributes = "";
			$this->portal_c_php_code->HrefValue = "";
			$this->portal_c_php_code->TooltipValue = "";

			// portal_c_mysql_query
			$this->portal_c_mysql_query->LinkCustomAttributes = "";
			$this->portal_c_mysql_query->HrefValue = "";
			$this->portal_c_mysql_query->TooltipValue = "";

			// portal_c_sp_query
			$this->portal_c_sp_query->LinkCustomAttributes = "";
			$this->portal_c_sp_query->HrefValue = "";
			$this->portal_c_sp_query->TooltipValue = "";

			// version
			$this->version->LinkCustomAttributes = "";
			$this->version->HrefValue = "";
			$this->version->TooltipValue = "";

			// php_version
			$this->php_version->LinkCustomAttributes = "";
			$this->php_version->HrefValue = "";
			$this->php_version->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// mysql_query
			$this->mysql_query->EditAttrs["class"] = "form-control";
			$this->mysql_query->EditCustomAttributes = "";
			$this->mysql_query->EditValue = HtmlEncode($this->mysql_query->AdvancedSearch->SearchValue);
			$this->mysql_query->PlaceHolder = RemoveHtml($this->mysql_query->caption());

			// sp_query
			$this->sp_query->EditAttrs["class"] = "form-control";
			$this->sp_query->EditCustomAttributes = "";
			$this->sp_query->EditValue = HtmlEncode($this->sp_query->AdvancedSearch->SearchValue);
			$this->sp_query->PlaceHolder = RemoveHtml($this->sp_query->caption());

			// php_code
			$this->php_code->EditAttrs["class"] = "form-control";
			$this->php_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->php_code->AdvancedSearch->SearchValue = HtmlDecode($this->php_code->AdvancedSearch->SearchValue);
			$this->php_code->EditValue = HtmlEncode($this->php_code->AdvancedSearch->SearchValue);
			$this->php_code->PlaceHolder = RemoveHtml($this->php_code->caption());

			// url_link
			$this->url_link->EditAttrs["class"] = "form-control";
			$this->url_link->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->url_link->AdvancedSearch->SearchValue = HtmlDecode($this->url_link->AdvancedSearch->SearchValue);
			$this->url_link->EditValue = HtmlEncode($this->url_link->AdvancedSearch->SearchValue);
			$this->url_link->PlaceHolder = RemoveHtml($this->url_link->caption());

			// portal_d_url_link
			$this->portal_d_url_link->EditAttrs["class"] = "form-control";
			$this->portal_d_url_link->EditCustomAttributes = "";
			$this->portal_d_url_link->EditValue = HtmlEncode($this->portal_d_url_link->AdvancedSearch->SearchValue);
			$this->portal_d_url_link->PlaceHolder = RemoveHtml($this->portal_d_url_link->caption());

			// portal_d_php_code
			$this->portal_d_php_code->EditAttrs["class"] = "form-control";
			$this->portal_d_php_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->portal_d_php_code->AdvancedSearch->SearchValue = HtmlDecode($this->portal_d_php_code->AdvancedSearch->SearchValue);
			$this->portal_d_php_code->EditValue = HtmlEncode($this->portal_d_php_code->AdvancedSearch->SearchValue);
			$this->portal_d_php_code->PlaceHolder = RemoveHtml($this->portal_d_php_code->caption());

			// portal_d_mysql_query
			$this->portal_d_mysql_query->EditAttrs["class"] = "form-control";
			$this->portal_d_mysql_query->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->portal_d_mysql_query->AdvancedSearch->SearchValue = HtmlDecode($this->portal_d_mysql_query->AdvancedSearch->SearchValue);
			$this->portal_d_mysql_query->EditValue = HtmlEncode($this->portal_d_mysql_query->AdvancedSearch->SearchValue);
			$this->portal_d_mysql_query->PlaceHolder = RemoveHtml($this->portal_d_mysql_query->caption());

			// portal_d_sp_query
			$this->portal_d_sp_query->EditAttrs["class"] = "form-control";
			$this->portal_d_sp_query->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->portal_d_sp_query->AdvancedSearch->SearchValue = HtmlDecode($this->portal_d_sp_query->AdvancedSearch->SearchValue);
			$this->portal_d_sp_query->EditValue = HtmlEncode($this->portal_d_sp_query->AdvancedSearch->SearchValue);
			$this->portal_d_sp_query->PlaceHolder = RemoveHtml($this->portal_d_sp_query->caption());

			// portal_c_php_code
			$this->portal_c_php_code->EditAttrs["class"] = "form-control";
			$this->portal_c_php_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->portal_c_php_code->AdvancedSearch->SearchValue = HtmlDecode($this->portal_c_php_code->AdvancedSearch->SearchValue);
			$this->portal_c_php_code->EditValue = HtmlEncode($this->portal_c_php_code->AdvancedSearch->SearchValue);
			$curVal = strval($this->portal_c_php_code->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->portal_c_php_code->EditValue = $this->portal_c_php_code->lookupCacheOption($curVal);
				if ($this->portal_c_php_code->EditValue === NULL) { // Lookup from database
					$filterWrk = "`url`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->portal_c_php_code->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->portal_c_php_code->EditValue = $this->portal_c_php_code->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->portal_c_php_code->EditValue = HtmlEncode($this->portal_c_php_code->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->portal_c_php_code->EditValue = NULL;
			}
			$this->portal_c_php_code->PlaceHolder = RemoveHtml($this->portal_c_php_code->caption());

			// portal_c_mysql_query
			$this->portal_c_mysql_query->EditAttrs["class"] = "form-control";
			$this->portal_c_mysql_query->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->portal_c_mysql_query->AdvancedSearch->SearchValue = HtmlDecode($this->portal_c_mysql_query->AdvancedSearch->SearchValue);
			$this->portal_c_mysql_query->EditValue = HtmlEncode($this->portal_c_mysql_query->AdvancedSearch->SearchValue);
			$curVal = strval($this->portal_c_mysql_query->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->portal_c_mysql_query->EditValue = $this->portal_c_mysql_query->lookupCacheOption($curVal);
				if ($this->portal_c_mysql_query->EditValue === NULL) { // Lookup from database
					$filterWrk = "`url`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->portal_c_mysql_query->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->portal_c_mysql_query->EditValue = $this->portal_c_mysql_query->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->portal_c_mysql_query->EditValue = HtmlEncode($this->portal_c_mysql_query->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->portal_c_mysql_query->EditValue = NULL;
			}
			$this->portal_c_mysql_query->PlaceHolder = RemoveHtml($this->portal_c_mysql_query->caption());

			// portal_c_sp_query
			$this->portal_c_sp_query->EditAttrs["class"] = "form-control";
			$this->portal_c_sp_query->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->portal_c_sp_query->AdvancedSearch->SearchValue = HtmlDecode($this->portal_c_sp_query->AdvancedSearch->SearchValue);
			$this->portal_c_sp_query->EditValue = HtmlEncode($this->portal_c_sp_query->AdvancedSearch->SearchValue);
			$curVal = strval($this->portal_c_sp_query->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->portal_c_sp_query->EditValue = $this->portal_c_sp_query->lookupCacheOption($curVal);
				if ($this->portal_c_sp_query->EditValue === NULL) { // Lookup from database
					$filterWrk = "`url`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->portal_c_sp_query->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->portal_c_sp_query->EditValue = $this->portal_c_sp_query->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->portal_c_sp_query->EditValue = HtmlEncode($this->portal_c_sp_query->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->portal_c_sp_query->EditValue = NULL;
			}
			$this->portal_c_sp_query->PlaceHolder = RemoveHtml($this->portal_c_sp_query->caption());

			// version
			$this->version->EditAttrs["class"] = "form-control";
			$this->version->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->version->AdvancedSearch->SearchValue = HtmlDecode($this->version->AdvancedSearch->SearchValue);
			$this->version->EditValue = HtmlEncode($this->version->AdvancedSearch->SearchValue);
			$this->version->PlaceHolder = RemoveHtml($this->version->caption());

			// php_version
			$this->php_version->EditAttrs["class"] = "form-control";
			$this->php_version->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->php_version->AdvancedSearch->SearchValue = HtmlDecode($this->php_version->AdvancedSearch->SearchValue);
			$this->php_version->EditValue = HtmlEncode($this->php_version->AdvancedSearch->SearchValue);
			$this->php_version->PlaceHolder = RemoveHtml($this->php_version->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->mysql_query->AdvancedSearch->load();
		$this->sp_query->AdvancedSearch->load();
		$this->php_code->AdvancedSearch->load();
		$this->url_link->AdvancedSearch->load();
		$this->portal_d_url_link->AdvancedSearch->load();
		$this->portal_d_php_code->AdvancedSearch->load();
		$this->portal_d_mysql_query->AdvancedSearch->load();
		$this->portal_d_sp_query->AdvancedSearch->load();
		$this->portal_c_php_code->AdvancedSearch->load();
		$this->portal_c_mysql_query->AdvancedSearch->load();
		$this->portal_c_sp_query->AdvancedSearch->load();
		$this->version->AdvancedSearch->load();
		$this->php_version->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("portal_versionlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_portal_c_php_code":
							break;
						case "x_portal_c_mysql_query":
							break;
						case "x_portal_c_sp_query":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>