<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for pp_verify_compiled
 */
class pp_verify_compiled extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $pid;
	public $location;
	public $product_type;
	public $shape;
	public $plan_type;
	public $gcode;
	public $design_id;
	public $process;
	public $yes_no;
	public $fix;
	public $unit;
	public $_40unit;
	public $_40;
	public $extra_plan;
	public $custom_size;
	public $custom_size_below_st;
	public $method;
	public $category;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'pp_verify_compiled';
		$this->TableName = 'pp_verify_compiled';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`pp_verify_compiled`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->Nullable = FALSE; // NOT NULL field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// pid
		$this->pid = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_pid', 'pid', '`pid`', '`pid`', 201, -1, FALSE, '`pid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pid->Sortable = TRUE; // Allow sort
		$this->pid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pid'] = &$this->pid;

		// location
		$this->location = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_location', 'location', '`location`', '`location`', 201, -1, FALSE, '`location`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->location->Required = TRUE; // Required field
		$this->location->Sortable = TRUE; // Allow sort
		$this->location->SelectMultiple = TRUE; // Multiple select
		$this->location->Lookup = new Lookup('location', 'godown_table', FALSE, 'id', ["code","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['location'] = &$this->location;

		// product_type
		$this->product_type = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_product_type', 'product_type', '`product_type`', '`product_type`', 201, -1, FALSE, '`product_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product_type->Required = TRUE; // Required field
		$this->product_type->Sortable = TRUE; // Allow sort
		$this->product_type->SelectMultiple = TRUE; // Multiple select
		$this->product_type->Lookup = new Lookup('product_type', 'product_type', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->product_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product_type'] = &$this->product_type;

		// shape
		$this->shape = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_shape', 'shape', '`shape`', '`shape`', 201, -1, FALSE, '`shape`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->shape->Required = TRUE; // Required field
		$this->shape->Sortable = TRUE; // Allow sort
		$this->shape->SelectMultiple = TRUE; // Multiple select
		$this->shape->Lookup = new Lookup('shape', 'shape', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['shape'] = &$this->shape;

		// plan_type
		$this->plan_type = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_plan_type', 'plan_type', '`plan_type`', '`plan_type`', 201, -1, FALSE, '`plan_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->plan_type->Sortable = TRUE; // Allow sort
		$this->plan_type->SelectMultiple = TRUE; // Multiple select
		$this->plan_type->Lookup = new Lookup('plan_type', 'pp_verify_compiled', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->plan_type->OptionCount = 2;
		$this->plan_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['plan_type'] = &$this->plan_type;

		// gcode
		$this->gcode = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_gcode', 'gcode', '`gcode`', '`gcode`', 200, -1, FALSE, '`gcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->gcode->Sortable = TRUE; // Allow sort
		$this->fields['gcode'] = &$this->gcode;

		// design_id
		$this->design_id = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_design_id', 'design_id', '`design_id`', '`design_id`', 201, -1, FALSE, '`EV__design_id`', TRUE, TRUE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->design_id->Sortable = TRUE; // Allow sort
		$this->design_id->SelectMultiple = TRUE; // Multiple select
		$this->design_id->Lookup = new Lookup('design_id', 'ref', TRUE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->fields['design_id'] = &$this->design_id;

		// process
		$this->process = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_process', 'process', '`process`', '`process`', 201, -1, FALSE, '`EV__process`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->process->Required = TRUE; // Required field
		$this->process->Sortable = TRUE; // Allow sort
		$this->process->Lookup = new Lookup('process', 'sub_process_type_view', TRUE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->process->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process'] = &$this->process;

		// yes_no
		$this->yes_no = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_yes_no', 'yes_no', '`yes_no`', '`yes_no`', 201, -1, FALSE, '`yes_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->yes_no->Required = TRUE; // Required field
		$this->yes_no->Sortable = TRUE; // Allow sort
		$this->yes_no->SelectMultiple = TRUE; // Multiple select
		$this->yes_no->Lookup = new Lookup('yes_no', 'pp_verify_compiled', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->yes_no->OptionCount = 2;
		$this->yes_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['yes_no'] = &$this->yes_no;

		// fix
		$this->fix = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_fix', 'fix', '`fix`', '`fix`', 201, -1, FALSE, '`fix`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->fix->Required = TRUE; // Required field
		$this->fix->Sortable = TRUE; // Allow sort
		$this->fix->SelectMultiple = TRUE; // Multiple select
		$this->fix->Lookup = new Lookup('fix', 'pp_verify_compiled', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->fix->OptionCount = 2;
		$this->fix->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['fix'] = &$this->fix;

		// unit
		$this->unit = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_unit', 'unit', '`unit`', '`unit`', 201, -1, FALSE, '`unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->unit->Sortable = TRUE; // Allow sort
		$this->unit->SelectMultiple = TRUE; // Multiple select
		$this->unit->Lookup = new Lookup('unit', 'pp_verify_compiled', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->unit->OptionCount = 5;
		$this->unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['unit'] = &$this->unit;

		// @unit
		$this->_40unit = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x__40unit', '@unit', '`@unit`', '`@unit`', 201, -1, FALSE, '`@unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_40unit->Sortable = TRUE; // Allow sort
		$this->_40unit->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['@unit'] = &$this->_40unit;

		// @
		$this->_40 = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x__40', '@', '`@`', '`@`', 201, -1, FALSE, '`@`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_40->Required = TRUE; // Required field
		$this->_40->Sortable = TRUE; // Allow sort
		$this->_40->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['@'] = &$this->_40;

		// extra_plan
		$this->extra_plan = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_extra_plan', 'extra_plan', '`extra_plan`', '`extra_plan`', 201, -1, FALSE, '`extra_plan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->extra_plan->Required = TRUE; // Required field
		$this->extra_plan->Sortable = TRUE; // Allow sort
		$this->extra_plan->SelectMultiple = TRUE; // Multiple select
		$this->extra_plan->Lookup = new Lookup('extra_plan', 'pp_verify_compiled', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->extra_plan->OptionCount = 4;
		$this->extra_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['extra_plan'] = &$this->extra_plan;

		// custom_size
		$this->custom_size = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_custom_size', 'custom_size', '`custom_size`', '`custom_size`', 201, -1, FALSE, '`custom_size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->custom_size->Sortable = TRUE; // Allow sort
		$this->custom_size->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['custom_size'] = &$this->custom_size;

		// custom_size_below_st
		$this->custom_size_below_st = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_custom_size_below_st', 'custom_size_below_st', '`custom_size_below_st`', '`custom_size_below_st`', 201, -1, FALSE, '`custom_size_below_st`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->custom_size_below_st->Sortable = TRUE; // Allow sort
		$this->custom_size_below_st->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['custom_size_below_st'] = &$this->custom_size_below_st;

		// method
		$this->method = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_method', 'method', '`method`', '`method`', 201, -1, FALSE, '`method`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->method->Required = TRUE; // Required field
		$this->method->Sortable = TRUE; // Allow sort
		$this->method->SelectMultiple = TRUE; // Multiple select
		$this->method->Lookup = new Lookup('method', 'method', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['method'] = &$this->method;

		// category
		$this->category = new DbField('pp_verify_compiled', 'pp_verify_compiled', 'x_category', 'category', '`category`', '`category`', 201, -1, FALSE, '`category`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->category->Sortable = TRUE; // Allow sort
		$this->category->SelectMultiple = TRUE; // Multiple select
		$this->category->Lookup = new Lookup('category', 'product_category', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['category'] = &$this->category;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`pp_verify_compiled`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT DISTINCT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `pp_verify_compiled`.`design_id` LIMIT 1) AS `EV__design_id`, (SELECT DISTINCT `name` FROM `sub_process_type_view` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `pp_verify_compiled`.`process` LIMIT 1) AS `EV__process` FROM `pp_verify_compiled`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->design_id->AdvancedSearch->SearchValue <> "" ||
			$this->design_id->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->design_id->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->design_id->VirtualExpression . " "))
			return TRUE;
		if ($this->process->AdvancedSearch->SearchValue <> "" ||
			$this->process->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->process->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->process->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->pid->DbValue = $row['pid'];
		$this->location->DbValue = $row['location'];
		$this->product_type->DbValue = $row['product_type'];
		$this->shape->DbValue = $row['shape'];
		$this->plan_type->DbValue = $row['plan_type'];
		$this->gcode->DbValue = $row['gcode'];
		$this->design_id->DbValue = $row['design_id'];
		$this->process->DbValue = $row['process'];
		$this->yes_no->DbValue = $row['yes_no'];
		$this->fix->DbValue = $row['fix'];
		$this->unit->DbValue = $row['unit'];
		$this->_40unit->DbValue = $row['@unit'];
		$this->_40->DbValue = $row['@'];
		$this->extra_plan->DbValue = $row['extra_plan'];
		$this->custom_size->DbValue = $row['custom_size'];
		$this->custom_size_below_st->DbValue = $row['custom_size_below_st'];
		$this->method->DbValue = $row['method'];
		$this->category->DbValue = $row['category'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "pp_verify_compiledlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "pp_verify_compiledview.php")
			return $Language->phrase("View");
		elseif ($pageName == "pp_verify_compilededit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "pp_verify_compiledadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "pp_verify_compiledlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("pp_verify_compiledview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("pp_verify_compiledview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "pp_verify_compiledadd.php?" . $this->getUrlParm($parm);
		else
			$url = "pp_verify_compiledadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("pp_verify_compilededit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("pp_verify_compiledadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("pp_verify_compileddelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->pid->setDbValue($rs->fields('pid'));
		$this->location->setDbValue($rs->fields('location'));
		$this->product_type->setDbValue($rs->fields('product_type'));
		$this->shape->setDbValue($rs->fields('shape'));
		$this->plan_type->setDbValue($rs->fields('plan_type'));
		$this->gcode->setDbValue($rs->fields('gcode'));
		$this->design_id->setDbValue($rs->fields('design_id'));
		$this->process->setDbValue($rs->fields('process'));
		$this->yes_no->setDbValue($rs->fields('yes_no'));
		$this->fix->setDbValue($rs->fields('fix'));
		$this->unit->setDbValue($rs->fields('unit'));
		$this->_40unit->setDbValue($rs->fields('@unit'));
		$this->_40->setDbValue($rs->fields('@'));
		$this->extra_plan->setDbValue($rs->fields('extra_plan'));
		$this->custom_size->setDbValue($rs->fields('custom_size'));
		$this->custom_size_below_st->setDbValue($rs->fields('custom_size_below_st'));
		$this->method->setDbValue($rs->fields('method'));
		$this->category->setDbValue($rs->fields('category'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// pid
		// location
		// product_type
		// shape
		// plan_type
		// gcode
		// design_id
		// process
		// yes_no
		// fix
		// unit
		// @unit
		// @
		// extra_plan
		// custom_size
		// custom_size_below_st
		// method
		// category
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// pid
		$this->pid->ViewValue = $this->pid->CurrentValue;
		$this->pid->ViewCustomAttributes = "";

		// location
		$curVal = strval($this->location->CurrentValue);
		if ($curVal <> "") {
			$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
			if ($this->location->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` > 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->location->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->location->ViewValue->add($this->location->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->location->ViewValue = $this->location->CurrentValue;
				}
			}
		} else {
			$this->location->ViewValue = NULL;
		}
		$this->location->ViewCustomAttributes = "";

		// product_type
		$curVal = strval($this->product_type->CurrentValue);
		if ($curVal <> "") {
			$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
			if ($this->product_type->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` !=9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->product_type->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_type->ViewValue->add($this->product_type->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->product_type->ViewValue = $this->product_type->CurrentValue;
				}
			}
		} else {
			$this->product_type->ViewValue = NULL;
		}
		$this->product_type->ViewCustomAttributes = "";

		// shape
		$curVal = strval($this->shape->CurrentValue);
		if ($curVal <> "") {
			$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
			if ($this->shape->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and id < 100";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->shape->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shape->ViewValue->add($this->shape->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->shape->ViewValue = $this->shape->CurrentValue;
				}
			}
		} else {
			$this->shape->ViewValue = NULL;
		}
		$this->shape->ViewCustomAttributes = "";

		// plan_type
		if (strval($this->plan_type->CurrentValue) <> "") {
			$this->plan_type->ViewValue = new OptionValues();
			$arwrk = explode(",", strval($this->plan_type->CurrentValue));
			$cnt = count($arwrk);
			for ($ari = 0; $ari < $cnt; $ari++)
				$this->plan_type->ViewValue->add($this->plan_type->optionCaption(trim($arwrk[$ari])));
		} else {
			$this->plan_type->ViewValue = NULL;
		}
		$this->plan_type->ViewCustomAttributes = "";

		// gcode
		$this->gcode->ViewValue = $this->gcode->CurrentValue;
		$this->gcode->ViewCustomAttributes = "";

		// design_id
		if ($this->design_id->VirtualValue <> "") {
			$this->design_id->ViewValue = $this->design_id->VirtualValue;
		} else {
		$curVal = strval($this->design_id->CurrentValue);
		if ($curVal <> "") {
			$this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
			if ($this->design_id->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->design_id->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->design_id->ViewValue->add($this->design_id->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->design_id->ViewValue = $this->design_id->CurrentValue;
				}
			}
		} else {
			$this->design_id->ViewValue = NULL;
		}
		}
		$this->design_id->ViewCustomAttributes = "";

		// process
		if ($this->process->VirtualValue <> "") {
			$this->process->ViewValue = $this->process->VirtualValue;
		} else {
			$this->process->ViewValue = $this->process->CurrentValue;
		$curVal = strval($this->process->CurrentValue);
		if ($curVal <> "") {
			$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			if ($this->process->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`type`=1 and `status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->process->ViewValue = $this->process->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process->ViewValue = $this->process->CurrentValue;
				}
			}
		} else {
			$this->process->ViewValue = NULL;
		}
		}
		$this->process->ViewCustomAttributes = "";

		// yes_no
		if (strval($this->yes_no->CurrentValue) <> "") {
			$this->yes_no->ViewValue = new OptionValues();
			$arwrk = explode(",", strval($this->yes_no->CurrentValue));
			$cnt = count($arwrk);
			for ($ari = 0; $ari < $cnt; $ari++)
				$this->yes_no->ViewValue->add($this->yes_no->optionCaption(trim($arwrk[$ari])));
		} else {
			$this->yes_no->ViewValue = NULL;
		}
		$this->yes_no->ViewCustomAttributes = "";

		// fix
		if (strval($this->fix->CurrentValue) <> "") {
			$this->fix->ViewValue = new OptionValues();
			$arwrk = explode(",", strval($this->fix->CurrentValue));
			$cnt = count($arwrk);
			for ($ari = 0; $ari < $cnt; $ari++)
				$this->fix->ViewValue->add($this->fix->optionCaption(trim($arwrk[$ari])));
		} else {
			$this->fix->ViewValue = NULL;
		}
		$this->fix->ViewCustomAttributes = "";

		// unit
		if (strval($this->unit->CurrentValue) <> "") {
			$this->unit->ViewValue = new OptionValues();
			$arwrk = explode(",", strval($this->unit->CurrentValue));
			$cnt = count($arwrk);
			for ($ari = 0; $ari < $cnt; $ari++)
				$this->unit->ViewValue->add($this->unit->optionCaption(trim($arwrk[$ari])));
		} else {
			$this->unit->ViewValue = NULL;
		}
		$this->unit->ViewCustomAttributes = "";

		// @unit
		$this->_40unit->ViewValue = $this->_40unit->CurrentValue;
		$this->_40unit->ViewCustomAttributes = "";

		// @
		$this->_40->ViewValue = $this->_40->CurrentValue;
		$this->_40->ViewCustomAttributes = "";

		// extra_plan
		if (strval($this->extra_plan->CurrentValue) <> "") {
			$this->extra_plan->ViewValue = new OptionValues();
			$arwrk = explode(",", strval($this->extra_plan->CurrentValue));
			$cnt = count($arwrk);
			for ($ari = 0; $ari < $cnt; $ari++)
				$this->extra_plan->ViewValue->add($this->extra_plan->optionCaption(trim($arwrk[$ari])));
		} else {
			$this->extra_plan->ViewValue = NULL;
		}
		$this->extra_plan->ViewCustomAttributes = "";

		// custom_size
		$this->custom_size->ViewValue = $this->custom_size->CurrentValue;
		$this->custom_size->ViewCustomAttributes = "";

		// custom_size_below_st
		$this->custom_size_below_st->ViewValue = $this->custom_size_below_st->CurrentValue;
		$this->custom_size_below_st->ViewCustomAttributes = "";

		// method
		$curVal = strval($this->method->CurrentValue);
		if ($curVal <> "") {
			$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
			if ($this->method->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=11";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->method->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->method->ViewValue->add($this->method->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->method->ViewValue = $this->method->CurrentValue;
				}
			}
		} else {
			$this->method->ViewValue = NULL;
		}
		$this->method->ViewCustomAttributes = "";

		// category
		$curVal = strval($this->category->CurrentValue);
		if ($curVal <> "") {
			$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
			if ($this->category->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->category->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->category->ViewValue->add($this->category->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->category->ViewValue = $this->category->CurrentValue;
				}
			}
		} else {
			$this->category->ViewValue = NULL;
		}
		$this->category->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// pid
		$this->pid->LinkCustomAttributes = "";
		if (!EmptyValue($this->pid->CurrentValue)) {
			$this->pid->HrefValue = "payment_planlist.php?id=" . $this->pid->CurrentValue; // Add prefix/suffix
			$this->pid->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->pid->HrefValue = FullUrl($this->pid->HrefValue, "href");
		} else {
			$this->pid->HrefValue = "";
		}
		$this->pid->TooltipValue = "";

		// location
		$this->location->LinkCustomAttributes = "";
		if (!EmptyValue($this->location->CurrentValue)) {
			$this->location->HrefValue = "payment_planlist.php?x_location=" . $this->location->CurrentValue; // Add prefix/suffix
			$this->location->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->location->HrefValue = FullUrl($this->location->HrefValue, "href");
		} else {
			$this->location->HrefValue = "";
		}
		$this->location->TooltipValue = "";

		// product_type
		$this->product_type->LinkCustomAttributes = "";
		$this->product_type->HrefValue = "";
		$this->product_type->TooltipValue = "";

		// shape
		$this->shape->LinkCustomAttributes = "";
		$this->shape->HrefValue = "";
		$this->shape->TooltipValue = "";

		// plan_type
		$this->plan_type->LinkCustomAttributes = "";
		if (!EmptyValue($this->plan_type->CurrentValue)) {
			$this->plan_type->HrefValue = "payment_planlist.php?x_plan_type=" . $this->plan_type->CurrentValue; // Add prefix/suffix
			$this->plan_type->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->plan_type->HrefValue = FullUrl($this->plan_type->HrefValue, "href");
		} else {
			$this->plan_type->HrefValue = "";
		}
		$this->plan_type->TooltipValue = "";

		// gcode
		$this->gcode->LinkCustomAttributes = "";
		if (!EmptyValue($this->gcode->CurrentValue)) {
			$this->gcode->HrefValue = "pp_verify_compiledlist.php?x_gcode=" . $this->gcode->CurrentValue; // Add prefix/suffix
			$this->gcode->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->gcode->HrefValue = FullUrl($this->gcode->HrefValue, "href");
		} else {
			$this->gcode->HrefValue = "";
		}
		$this->gcode->TooltipValue = "";

		// design_id
		$this->design_id->LinkCustomAttributes = "";
		$this->design_id->HrefValue = "";
		$this->design_id->TooltipValue = "";

		// process
		$this->process->LinkCustomAttributes = "";
		if (!EmptyValue($this->process->CurrentValue)) {
			$this->process->HrefValue = "payment_planlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
			$this->process->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
		} else {
			$this->process->HrefValue = "";
		}
		$this->process->TooltipValue = "";

		// yes_no
		$this->yes_no->LinkCustomAttributes = "";
		$this->yes_no->HrefValue = "";
		$this->yes_no->TooltipValue = "";

		// fix
		$this->fix->LinkCustomAttributes = "";
		$this->fix->HrefValue = "";
		$this->fix->TooltipValue = "";

		// unit
		$this->unit->LinkCustomAttributes = "";
		$this->unit->HrefValue = "";
		$this->unit->TooltipValue = "";

		// @unit
		$this->_40unit->LinkCustomAttributes = "";
		$this->_40unit->HrefValue = "";
		$this->_40unit->TooltipValue = "";

		// @
		$this->_40->LinkCustomAttributes = "";
		$this->_40->HrefValue = "";
		$this->_40->TooltipValue = "";

		// extra_plan
		$this->extra_plan->LinkCustomAttributes = "";
		$this->extra_plan->HrefValue = "";
		$this->extra_plan->TooltipValue = "";

		// custom_size
		$this->custom_size->LinkCustomAttributes = "";
		$this->custom_size->HrefValue = "";
		$this->custom_size->TooltipValue = "";

		// custom_size_below_st
		$this->custom_size_below_st->LinkCustomAttributes = "";
		$this->custom_size_below_st->HrefValue = "";
		$this->custom_size_below_st->TooltipValue = "";

		// method
		$this->method->LinkCustomAttributes = "";
		$this->method->HrefValue = "";
		$this->method->TooltipValue = "";

		// category
		$this->category->LinkCustomAttributes = "";
		$this->category->HrefValue = "";
		$this->category->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->PlaceHolder = RemoveHtml($this->id->caption());

		// pid
		$this->pid->EditAttrs["class"] = "form-control";
		$this->pid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pid->CurrentValue = HtmlDecode($this->pid->CurrentValue);
		$this->pid->EditValue = $this->pid->CurrentValue;
		$this->pid->PlaceHolder = RemoveHtml($this->pid->caption());

		// location
		$this->location->EditAttrs["class"] = "form-control";
		$this->location->EditCustomAttributes = "";

		// product_type
		$this->product_type->EditAttrs["class"] = "form-control";
		$this->product_type->EditCustomAttributes = "";

		// shape
		$this->shape->EditAttrs["class"] = "form-control";
		$this->shape->EditCustomAttributes = "";

		// plan_type
		$this->plan_type->EditAttrs["class"] = "form-control";
		$this->plan_type->EditCustomAttributes = "";
		$this->plan_type->EditValue = $this->plan_type->options(FALSE);

		// gcode
		$this->gcode->EditAttrs["class"] = "form-control";
		$this->gcode->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->gcode->CurrentValue = HtmlDecode($this->gcode->CurrentValue);
		$this->gcode->EditValue = $this->gcode->CurrentValue;
		$this->gcode->PlaceHolder = RemoveHtml($this->gcode->caption());

		// design_id
		$this->design_id->EditAttrs["class"] = "form-control";
		$this->design_id->EditCustomAttributes = "";

		// process
		$this->process->EditAttrs["class"] = "form-control";
		$this->process->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->process->CurrentValue = HtmlDecode($this->process->CurrentValue);
		$this->process->EditValue = $this->process->CurrentValue;
		$this->process->PlaceHolder = RemoveHtml($this->process->caption());

		// yes_no
		$this->yes_no->EditAttrs["class"] = "form-control";
		$this->yes_no->EditCustomAttributes = "";
		$this->yes_no->EditValue = $this->yes_no->options(FALSE);

		// fix
		$this->fix->EditAttrs["class"] = "form-control";
		$this->fix->EditCustomAttributes = "";
		$this->fix->EditValue = $this->fix->options(FALSE);

		// unit
		$this->unit->EditAttrs["class"] = "form-control";
		$this->unit->EditCustomAttributes = "";
		$this->unit->EditValue = $this->unit->options(FALSE);

		// @unit
		$this->_40unit->EditAttrs["class"] = "form-control";
		$this->_40unit->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_40unit->CurrentValue = HtmlDecode($this->_40unit->CurrentValue);
		$this->_40unit->EditValue = $this->_40unit->CurrentValue;
		$this->_40unit->PlaceHolder = RemoveHtml($this->_40unit->caption());

		// @
		$this->_40->EditAttrs["class"] = "form-control";
		$this->_40->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_40->CurrentValue = HtmlDecode($this->_40->CurrentValue);
		$this->_40->EditValue = $this->_40->CurrentValue;
		$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

		// extra_plan
		$this->extra_plan->EditAttrs["class"] = "form-control";
		$this->extra_plan->EditCustomAttributes = "";
		$this->extra_plan->EditValue = $this->extra_plan->options(FALSE);

		// custom_size
		$this->custom_size->EditAttrs["class"] = "form-control";
		$this->custom_size->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->custom_size->CurrentValue = HtmlDecode($this->custom_size->CurrentValue);
		$this->custom_size->EditValue = $this->custom_size->CurrentValue;
		$this->custom_size->PlaceHolder = RemoveHtml($this->custom_size->caption());

		// custom_size_below_st
		$this->custom_size_below_st->EditAttrs["class"] = "form-control";
		$this->custom_size_below_st->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->custom_size_below_st->CurrentValue = HtmlDecode($this->custom_size_below_st->CurrentValue);
		$this->custom_size_below_st->EditValue = $this->custom_size_below_st->CurrentValue;
		$this->custom_size_below_st->PlaceHolder = RemoveHtml($this->custom_size_below_st->caption());

		// method
		$this->method->EditAttrs["class"] = "form-control";
		$this->method->EditCustomAttributes = "";

		// category
		$this->category->EditAttrs["class"] = "form-control";
		$this->category->EditCustomAttributes = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->pid);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->shape);
					$doc->exportCaption($this->plan_type);
					$doc->exportCaption($this->gcode);
					$doc->exportCaption($this->design_id);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->yes_no);
					$doc->exportCaption($this->fix);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->_40unit);
					$doc->exportCaption($this->_40);
					$doc->exportCaption($this->extra_plan);
					$doc->exportCaption($this->custom_size);
					$doc->exportCaption($this->custom_size_below_st);
					$doc->exportCaption($this->method);
					$doc->exportCaption($this->category);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->pid);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->shape);
					$doc->exportCaption($this->plan_type);
					$doc->exportCaption($this->gcode);
					$doc->exportCaption($this->design_id);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->yes_no);
					$doc->exportCaption($this->fix);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->_40unit);
					$doc->exportCaption($this->_40);
					$doc->exportCaption($this->extra_plan);
					$doc->exportCaption($this->custom_size);
					$doc->exportCaption($this->custom_size_below_st);
					$doc->exportCaption($this->method);
					$doc->exportCaption($this->category);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->pid);
						$doc->exportField($this->location);
						$doc->exportField($this->product_type);
						$doc->exportField($this->shape);
						$doc->exportField($this->plan_type);
						$doc->exportField($this->gcode);
						$doc->exportField($this->design_id);
						$doc->exportField($this->process);
						$doc->exportField($this->yes_no);
						$doc->exportField($this->fix);
						$doc->exportField($this->unit);
						$doc->exportField($this->_40unit);
						$doc->exportField($this->_40);
						$doc->exportField($this->extra_plan);
						$doc->exportField($this->custom_size);
						$doc->exportField($this->custom_size_below_st);
						$doc->exportField($this->method);
						$doc->exportField($this->category);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->pid);
						$doc->exportField($this->location);
						$doc->exportField($this->product_type);
						$doc->exportField($this->shape);
						$doc->exportField($this->plan_type);
						$doc->exportField($this->gcode);
						$doc->exportField($this->design_id);
						$doc->exportField($this->process);
						$doc->exportField($this->yes_no);
						$doc->exportField($this->fix);
						$doc->exportField($this->unit);
						$doc->exportField($this->_40unit);
						$doc->exportField($this->_40);
						$doc->exportField($this->extra_plan);
						$doc->exportField($this->custom_size);
						$doc->exportField($this->custom_size_below_st);
						$doc->exportField($this->method);
						$doc->exportField($this->category);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>