<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class pp_verify_compiled_search extends pp_verify_compiled
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'pp_verify_compiled';

	// Page object name
	public $PageObjName = "pp_verify_compiled_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (pp_verify_compiled)
		if (!isset($GLOBALS["pp_verify_compiled"]) || get_class($GLOBALS["pp_verify_compiled"]) == PROJECT_NAMESPACE . "pp_verify_compiled") {
			$GLOBALS["pp_verify_compiled"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["pp_verify_compiled"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'pp_verify_compiled');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $pp_verify_compiled;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($pp_verify_compiled);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "pp_verify_compiledview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("pp_verify_compiledlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->pid->setVisibility();
		$this->location->setVisibility();
		$this->product_type->setVisibility();
		$this->shape->setVisibility();
		$this->plan_type->setVisibility();
		$this->gcode->setVisibility();
		$this->design_id->setVisibility();
		$this->process->setVisibility();
		$this->yes_no->setVisibility();
		$this->fix->setVisibility();
		$this->unit->setVisibility();
		$this->_40unit->setVisibility();
		$this->_40->setVisibility();
		$this->extra_plan->setVisibility();
		$this->custom_size->setVisibility();
		$this->custom_size_below_st->setVisibility();
		$this->method->setVisibility();
		$this->category->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->design_id);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->method);
		$this->setupLookupOptions($this->category);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "pp_verify_compiledlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->pid); // pid
		$this->buildSearchUrl($srchUrl, $this->location); // location
		$this->buildSearchUrl($srchUrl, $this->product_type); // product_type
		$this->buildSearchUrl($srchUrl, $this->shape); // shape
		$this->buildSearchUrl($srchUrl, $this->plan_type); // plan_type
		$this->buildSearchUrl($srchUrl, $this->gcode); // gcode
		$this->buildSearchUrl($srchUrl, $this->design_id); // design_id
		$this->buildSearchUrl($srchUrl, $this->process); // process
		$this->buildSearchUrl($srchUrl, $this->yes_no); // yes_no
		$this->buildSearchUrl($srchUrl, $this->fix); // fix
		$this->buildSearchUrl($srchUrl, $this->unit); // unit
		$this->buildSearchUrl($srchUrl, $this->_40unit); // @unit
		$this->buildSearchUrl($srchUrl, $this->_40); // @
		$this->buildSearchUrl($srchUrl, $this->extra_plan); // extra_plan
		$this->buildSearchUrl($srchUrl, $this->custom_size); // custom_size
		$this->buildSearchUrl($srchUrl, $this->custom_size_below_st); // custom_size_below_st
		$this->buildSearchUrl($srchUrl, $this->method); // method
		$this->buildSearchUrl($srchUrl, $this->category); // category
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// pid
		if (!$this->isAddOrEdit())
			$this->pid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pid"));
		$this->pid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pid"));

		// location
		if (!$this->isAddOrEdit())
			$this->location->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_location"));
		$this->location->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_location"));
		if (is_array($this->location->AdvancedSearch->SearchValue))
			$this->location->AdvancedSearch->SearchValue = implode(",", $this->location->AdvancedSearch->SearchValue);
		if (is_array($this->location->AdvancedSearch->SearchValue2))
			$this->location->AdvancedSearch->SearchValue2 = implode(",", $this->location->AdvancedSearch->SearchValue2);

		// product_type
		if (!$this->isAddOrEdit())
			$this->product_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_type"));
		$this->product_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_type"));
		$this->product_type->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_product_type"));
		$this->product_type->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_product_type"));
		$this->product_type->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_product_type"));
		if (is_array($this->product_type->AdvancedSearch->SearchValue))
			$this->product_type->AdvancedSearch->SearchValue = implode(",", $this->product_type->AdvancedSearch->SearchValue);
		if (is_array($this->product_type->AdvancedSearch->SearchValue2))
			$this->product_type->AdvancedSearch->SearchValue2 = implode(",", $this->product_type->AdvancedSearch->SearchValue2);

		// shape
		if (!$this->isAddOrEdit())
			$this->shape->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_shape"));
		$this->shape->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_shape"));
		if (is_array($this->shape->AdvancedSearch->SearchValue))
			$this->shape->AdvancedSearch->SearchValue = implode(",", $this->shape->AdvancedSearch->SearchValue);
		if (is_array($this->shape->AdvancedSearch->SearchValue2))
			$this->shape->AdvancedSearch->SearchValue2 = implode(",", $this->shape->AdvancedSearch->SearchValue2);

		// plan_type
		if (!$this->isAddOrEdit())
			$this->plan_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_plan_type"));
		$this->plan_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_plan_type"));
		if (is_array($this->plan_type->AdvancedSearch->SearchValue))
			$this->plan_type->AdvancedSearch->SearchValue = implode(",", $this->plan_type->AdvancedSearch->SearchValue);
		if (is_array($this->plan_type->AdvancedSearch->SearchValue2))
			$this->plan_type->AdvancedSearch->SearchValue2 = implode(",", $this->plan_type->AdvancedSearch->SearchValue2);

		// gcode
		if (!$this->isAddOrEdit())
			$this->gcode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_gcode"));
		$this->gcode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_gcode"));

		// design_id
		if (!$this->isAddOrEdit())
			$this->design_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_design_id"));
		$this->design_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_design_id"));
		if (is_array($this->design_id->AdvancedSearch->SearchValue))
			$this->design_id->AdvancedSearch->SearchValue = implode(",", $this->design_id->AdvancedSearch->SearchValue);
		if (is_array($this->design_id->AdvancedSearch->SearchValue2))
			$this->design_id->AdvancedSearch->SearchValue2 = implode(",", $this->design_id->AdvancedSearch->SearchValue2);

		// process
		if (!$this->isAddOrEdit())
			$this->process->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process"));
		$this->process->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process"));

		// yes_no
		if (!$this->isAddOrEdit())
			$this->yes_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_yes_no"));
		$this->yes_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_yes_no"));
		if (is_array($this->yes_no->AdvancedSearch->SearchValue))
			$this->yes_no->AdvancedSearch->SearchValue = implode(",", $this->yes_no->AdvancedSearch->SearchValue);
		if (is_array($this->yes_no->AdvancedSearch->SearchValue2))
			$this->yes_no->AdvancedSearch->SearchValue2 = implode(",", $this->yes_no->AdvancedSearch->SearchValue2);

		// fix
		if (!$this->isAddOrEdit())
			$this->fix->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_fix"));
		$this->fix->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_fix"));
		if (is_array($this->fix->AdvancedSearch->SearchValue))
			$this->fix->AdvancedSearch->SearchValue = implode(",", $this->fix->AdvancedSearch->SearchValue);
		if (is_array($this->fix->AdvancedSearch->SearchValue2))
			$this->fix->AdvancedSearch->SearchValue2 = implode(",", $this->fix->AdvancedSearch->SearchValue2);

		// unit
		if (!$this->isAddOrEdit())
			$this->unit->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_unit"));
		$this->unit->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_unit"));
		if (is_array($this->unit->AdvancedSearch->SearchValue))
			$this->unit->AdvancedSearch->SearchValue = implode(",", $this->unit->AdvancedSearch->SearchValue);
		if (is_array($this->unit->AdvancedSearch->SearchValue2))
			$this->unit->AdvancedSearch->SearchValue2 = implode(",", $this->unit->AdvancedSearch->SearchValue2);

		// @unit
		if (!$this->isAddOrEdit())
			$this->_40unit->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__40unit"));
		$this->_40unit->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__40unit"));

		// @
		if (!$this->isAddOrEdit())
			$this->_40->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__40"));
		$this->_40->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__40"));

		// extra_plan
		if (!$this->isAddOrEdit())
			$this->extra_plan->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_extra_plan"));
		$this->extra_plan->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_extra_plan"));
		if (is_array($this->extra_plan->AdvancedSearch->SearchValue))
			$this->extra_plan->AdvancedSearch->SearchValue = implode(",", $this->extra_plan->AdvancedSearch->SearchValue);
		if (is_array($this->extra_plan->AdvancedSearch->SearchValue2))
			$this->extra_plan->AdvancedSearch->SearchValue2 = implode(",", $this->extra_plan->AdvancedSearch->SearchValue2);

		// custom_size
		if (!$this->isAddOrEdit())
			$this->custom_size->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_custom_size"));
		$this->custom_size->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_custom_size"));

		// custom_size_below_st
		if (!$this->isAddOrEdit())
			$this->custom_size_below_st->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_custom_size_below_st"));
		$this->custom_size_below_st->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_custom_size_below_st"));

		// method
		if (!$this->isAddOrEdit())
			$this->method->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_method"));
		$this->method->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_method"));
		if (is_array($this->method->AdvancedSearch->SearchValue))
			$this->method->AdvancedSearch->SearchValue = implode(",", $this->method->AdvancedSearch->SearchValue);
		if (is_array($this->method->AdvancedSearch->SearchValue2))
			$this->method->AdvancedSearch->SearchValue2 = implode(",", $this->method->AdvancedSearch->SearchValue2);

		// category
		if (!$this->isAddOrEdit())
			$this->category->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_category"));
		$this->category->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_category"));
		if (is_array($this->category->AdvancedSearch->SearchValue))
			$this->category->AdvancedSearch->SearchValue = implode(",", $this->category->AdvancedSearch->SearchValue);
		if (is_array($this->category->AdvancedSearch->SearchValue2))
			$this->category->AdvancedSearch->SearchValue2 = implode(",", $this->category->AdvancedSearch->SearchValue2);
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// pid
		// location
		// product_type
		// shape
		// plan_type
		// gcode
		// design_id
		// process
		// yes_no
		// fix
		// unit
		// @unit
		// @
		// extra_plan
		// custom_size
		// custom_size_below_st
		// method
		// category

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// pid
			$this->pid->ViewValue = $this->pid->CurrentValue;
			$this->pid->ViewCustomAttributes = "";

			// location
			$curVal = strval($this->location->CurrentValue);
			if ($curVal <> "") {
				$this->location->ViewValue = $this->location->lookupCacheOption($curVal);
				if ($this->location->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1 and `id` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->location->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->location->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->location->ViewValue->add($this->location->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->location->ViewValue = $this->location->CurrentValue;
					}
				}
			} else {
				$this->location->ViewValue = NULL;
			}
			$this->location->ViewCustomAttributes = "";

			// product_type
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1 and `id` !=9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->product_type->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->product_type->ViewValue->add($this->product_type->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1 and id < 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->shape->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->shape->ViewValue->add($this->shape->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// plan_type
			if (strval($this->plan_type->CurrentValue) <> "") {
				$this->plan_type->ViewValue = new OptionValues();
				$arwrk = explode(",", strval($this->plan_type->CurrentValue));
				$cnt = count($arwrk);
				for ($ari = 0; $ari < $cnt; $ari++)
					$this->plan_type->ViewValue->add($this->plan_type->optionCaption(trim($arwrk[$ari])));
			} else {
				$this->plan_type->ViewValue = NULL;
			}
			$this->plan_type->ViewCustomAttributes = "";

			// gcode
			$this->gcode->ViewValue = $this->gcode->CurrentValue;
			$this->gcode->ViewCustomAttributes = "";

			// design_id
			if ($this->design_id->VirtualValue <> "") {
				$this->design_id->ViewValue = $this->design_id->VirtualValue;
			} else {
			$curVal = strval($this->design_id->CurrentValue);
			if ($curVal <> "") {
				$this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
				if ($this->design_id->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->design_id->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->design_id->ViewValue->add($this->design_id->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->design_id->ViewValue = $this->design_id->CurrentValue;
					}
				}
			} else {
				$this->design_id->ViewValue = NULL;
			}
			}
			$this->design_id->ViewCustomAttributes = "";

			// process
			if ($this->process->VirtualValue <> "") {
				$this->process->ViewValue = $this->process->VirtualValue;
			} else {
				$this->process->ViewValue = $this->process->CurrentValue;
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`type`=1 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue = $this->process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			}
			$this->process->ViewCustomAttributes = "";

			// yes_no
			if (strval($this->yes_no->CurrentValue) <> "") {
				$this->yes_no->ViewValue = new OptionValues();
				$arwrk = explode(",", strval($this->yes_no->CurrentValue));
				$cnt = count($arwrk);
				for ($ari = 0; $ari < $cnt; $ari++)
					$this->yes_no->ViewValue->add($this->yes_no->optionCaption(trim($arwrk[$ari])));
			} else {
				$this->yes_no->ViewValue = NULL;
			}
			$this->yes_no->ViewCustomAttributes = "";

			// fix
			if (strval($this->fix->CurrentValue) <> "") {
				$this->fix->ViewValue = new OptionValues();
				$arwrk = explode(",", strval($this->fix->CurrentValue));
				$cnt = count($arwrk);
				for ($ari = 0; $ari < $cnt; $ari++)
					$this->fix->ViewValue->add($this->fix->optionCaption(trim($arwrk[$ari])));
			} else {
				$this->fix->ViewValue = NULL;
			}
			$this->fix->ViewCustomAttributes = "";

			// unit
			if (strval($this->unit->CurrentValue) <> "") {
				$this->unit->ViewValue = new OptionValues();
				$arwrk = explode(",", strval($this->unit->CurrentValue));
				$cnt = count($arwrk);
				for ($ari = 0; $ari < $cnt; $ari++)
					$this->unit->ViewValue->add($this->unit->optionCaption(trim($arwrk[$ari])));
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// @unit
			$this->_40unit->ViewValue = $this->_40unit->CurrentValue;
			$this->_40unit->ViewCustomAttributes = "";

			// @
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewCustomAttributes = "";

			// extra_plan
			if (strval($this->extra_plan->CurrentValue) <> "") {
				$this->extra_plan->ViewValue = new OptionValues();
				$arwrk = explode(",", strval($this->extra_plan->CurrentValue));
				$cnt = count($arwrk);
				for ($ari = 0; $ari < $cnt; $ari++)
					$this->extra_plan->ViewValue->add($this->extra_plan->optionCaption(trim($arwrk[$ari])));
			} else {
				$this->extra_plan->ViewValue = NULL;
			}
			$this->extra_plan->ViewCustomAttributes = "";

			// custom_size
			$this->custom_size->ViewValue = $this->custom_size->CurrentValue;
			$this->custom_size->ViewCustomAttributes = "";

			// custom_size_below_st
			$this->custom_size_below_st->ViewValue = $this->custom_size_below_st->CurrentValue;
			$this->custom_size_below_st->ViewCustomAttributes = "";

			// method
			$curVal = strval($this->method->CurrentValue);
			if ($curVal <> "") {
				$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
				if ($this->method->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`grp`=11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->method->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->method->ViewValue->add($this->method->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->method->ViewValue = $this->method->CurrentValue;
					}
				}
			} else {
				$this->method->ViewValue = NULL;
			}
			$this->method->ViewCustomAttributes = "";

			// category
			$curVal = strval($this->category->CurrentValue);
			if ($curVal <> "") {
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
				if ($this->category->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->category->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->category->ViewValue->add($this->category->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->category->ViewValue = $this->category->CurrentValue;
					}
				}
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// pid
			$this->pid->LinkCustomAttributes = "";
			if (!EmptyValue($this->pid->CurrentValue)) {
				$this->pid->HrefValue = "payment_planlist.php?id=" . $this->pid->CurrentValue; // Add prefix/suffix
				$this->pid->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->pid->HrefValue = FullUrl($this->pid->HrefValue, "href");
			} else {
				$this->pid->HrefValue = "";
			}
			$this->pid->TooltipValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			if (!EmptyValue($this->location->CurrentValue)) {
				$this->location->HrefValue = "payment_planlist.php?x_location=" . $this->location->CurrentValue; // Add prefix/suffix
				$this->location->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->location->HrefValue = FullUrl($this->location->HrefValue, "href");
			} else {
				$this->location->HrefValue = "";
			}
			$this->location->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// plan_type
			$this->plan_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->plan_type->CurrentValue)) {
				$this->plan_type->HrefValue = "payment_planlist.php?x_plan_type=" . $this->plan_type->CurrentValue; // Add prefix/suffix
				$this->plan_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->plan_type->HrefValue = FullUrl($this->plan_type->HrefValue, "href");
			} else {
				$this->plan_type->HrefValue = "";
			}
			$this->plan_type->TooltipValue = "";

			// gcode
			$this->gcode->LinkCustomAttributes = "";
			if (!EmptyValue($this->gcode->CurrentValue)) {
				$this->gcode->HrefValue = "pp_verify_compiledlist.php?x_gcode=" . $this->gcode->CurrentValue; // Add prefix/suffix
				$this->gcode->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->gcode->HrefValue = FullUrl($this->gcode->HrefValue, "href");
			} else {
				$this->gcode->HrefValue = "";
			}
			$this->gcode->TooltipValue = "";

			// design_id
			$this->design_id->LinkCustomAttributes = "";
			$this->design_id->HrefValue = "";
			$this->design_id->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			if (!EmptyValue($this->process->CurrentValue)) {
				$this->process->HrefValue = "payment_planlist.php?x_process=" . $this->process->CurrentValue; // Add prefix/suffix
				$this->process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->process->HrefValue = FullUrl($this->process->HrefValue, "href");
			} else {
				$this->process->HrefValue = "";
			}
			$this->process->TooltipValue = "";

			// yes_no
			$this->yes_no->LinkCustomAttributes = "";
			$this->yes_no->HrefValue = "";
			$this->yes_no->TooltipValue = "";

			// fix
			$this->fix->LinkCustomAttributes = "";
			$this->fix->HrefValue = "";
			$this->fix->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// @unit
			$this->_40unit->LinkCustomAttributes = "";
			$this->_40unit->HrefValue = "";
			$this->_40unit->TooltipValue = "";

			// @
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";

			// extra_plan
			$this->extra_plan->LinkCustomAttributes = "";
			$this->extra_plan->HrefValue = "";
			$this->extra_plan->TooltipValue = "";

			// custom_size
			$this->custom_size->LinkCustomAttributes = "";
			$this->custom_size->HrefValue = "";
			$this->custom_size->TooltipValue = "";

			// custom_size_below_st
			$this->custom_size_below_st->LinkCustomAttributes = "";
			$this->custom_size_below_st->HrefValue = "";
			$this->custom_size_below_st->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// pid
			$this->pid->EditAttrs["class"] = "form-control";
			$this->pid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pid->AdvancedSearch->SearchValue = HtmlDecode($this->pid->AdvancedSearch->SearchValue);
			$this->pid->EditValue = HtmlEncode($this->pid->AdvancedSearch->SearchValue);
			$this->pid->PlaceHolder = RemoveHtml($this->pid->caption());

			// location
			$this->location->EditAttrs["class"] = "form-control";
			$this->location->EditCustomAttributes = "";
			$curVal = trim(strval($this->location->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->location->AdvancedSearch->ViewValue = $this->location->lookupCacheOption($curVal);
			else
				$this->location->AdvancedSearch->ViewValue = $this->location->Lookup !== NULL && is_array($this->location->Lookup->Options) ? $curVal : NULL;
			if ($this->location->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->location->EditValue = array_values($this->location->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` > 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->location->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->location->EditValue = $arwrk;
			}

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_type->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->product_type->AdvancedSearch->ViewValue = $this->product_type->lookupCacheOption($curVal);
			else
				$this->product_type->AdvancedSearch->ViewValue = $this->product_type->Lookup !== NULL && is_array($this->product_type->Lookup->Options) ? $curVal : NULL;
			if ($this->product_type->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->product_type->EditValue = array_values($this->product_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` !=9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_type->EditValue = $arwrk;
			}
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_type->AdvancedSearch->SearchValue2));
			if ($curVal <> "")
				$this->product_type->AdvancedSearch->ViewValue2 = $this->product_type->lookupCacheOption($curVal);
			else
				$this->product_type->AdvancedSearch->ViewValue2 = $this->product_type->Lookup !== NULL && is_array($this->product_type->Lookup->Options) ? $curVal : NULL;
			if ($this->product_type->AdvancedSearch->ViewValue2 !== NULL) { // Load from cache
				$this->product_type->EditValue2 = array_values($this->product_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` !=9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_type->EditValue2 = $arwrk;
			}

			// shape
			$this->shape->EditAttrs["class"] = "form-control";
			$this->shape->EditCustomAttributes = "";
			$curVal = trim(strval($this->shape->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->shape->AdvancedSearch->ViewValue = $this->shape->lookupCacheOption($curVal);
			else
				$this->shape->AdvancedSearch->ViewValue = $this->shape->Lookup !== NULL && is_array($this->shape->Lookup->Options) ? $curVal : NULL;
			if ($this->shape->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->shape->EditValue = array_values($this->shape->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1 and id < 100";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->shape->EditValue = $arwrk;
			}

			// plan_type
			$this->plan_type->EditAttrs["class"] = "form-control";
			$this->plan_type->EditCustomAttributes = "";
			$this->plan_type->EditValue = $this->plan_type->options(FALSE);

			// gcode
			$this->gcode->EditAttrs["class"] = "form-control";
			$this->gcode->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->gcode->AdvancedSearch->SearchValue = HtmlDecode($this->gcode->AdvancedSearch->SearchValue);
			$this->gcode->EditValue = HtmlEncode($this->gcode->AdvancedSearch->SearchValue);
			$this->gcode->PlaceHolder = RemoveHtml($this->gcode->caption());

			// design_id
			$this->design_id->EditAttrs["class"] = "form-control";
			$this->design_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->design_id->AdvancedSearch->SearchValue = HtmlDecode($this->design_id->AdvancedSearch->SearchValue);
			$this->design_id->EditValue = HtmlEncode($this->design_id->AdvancedSearch->SearchValue);
			$this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->process->AdvancedSearch->SearchValue = HtmlDecode($this->process->AdvancedSearch->SearchValue);
			$this->process->EditValue = HtmlEncode($this->process->AdvancedSearch->SearchValue);
			$this->process->PlaceHolder = RemoveHtml($this->process->caption());

			// yes_no
			$this->yes_no->EditAttrs["class"] = "form-control";
			$this->yes_no->EditCustomAttributes = "";
			$this->yes_no->EditValue = $this->yes_no->options(FALSE);

			// fix
			$this->fix->EditAttrs["class"] = "form-control";
			$this->fix->EditCustomAttributes = "";
			$this->fix->EditValue = $this->fix->options(FALSE);

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";
			$this->unit->EditValue = $this->unit->options(FALSE);

			// @unit
			$this->_40unit->EditAttrs["class"] = "form-control";
			$this->_40unit->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_40unit->AdvancedSearch->SearchValue = HtmlDecode($this->_40unit->AdvancedSearch->SearchValue);
			$this->_40unit->EditValue = HtmlEncode($this->_40unit->AdvancedSearch->SearchValue);
			$this->_40unit->PlaceHolder = RemoveHtml($this->_40unit->caption());

			// @
			$this->_40->EditAttrs["class"] = "form-control";
			$this->_40->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_40->AdvancedSearch->SearchValue = HtmlDecode($this->_40->AdvancedSearch->SearchValue);
			$this->_40->EditValue = HtmlEncode($this->_40->AdvancedSearch->SearchValue);
			$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

			// extra_plan
			$this->extra_plan->EditAttrs["class"] = "form-control";
			$this->extra_plan->EditCustomAttributes = "";
			$this->extra_plan->EditValue = $this->extra_plan->options(FALSE);

			// custom_size
			$this->custom_size->EditAttrs["class"] = "form-control";
			$this->custom_size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->custom_size->AdvancedSearch->SearchValue = HtmlDecode($this->custom_size->AdvancedSearch->SearchValue);
			$this->custom_size->EditValue = HtmlEncode($this->custom_size->AdvancedSearch->SearchValue);
			$this->custom_size->PlaceHolder = RemoveHtml($this->custom_size->caption());

			// custom_size_below_st
			$this->custom_size_below_st->EditAttrs["class"] = "form-control";
			$this->custom_size_below_st->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->custom_size_below_st->AdvancedSearch->SearchValue = HtmlDecode($this->custom_size_below_st->AdvancedSearch->SearchValue);
			$this->custom_size_below_st->EditValue = HtmlEncode($this->custom_size_below_st->AdvancedSearch->SearchValue);
			$this->custom_size_below_st->PlaceHolder = RemoveHtml($this->custom_size_below_st->caption());

			// method
			$this->method->EditAttrs["class"] = "form-control";
			$this->method->EditCustomAttributes = "";
			$curVal = trim(strval($this->method->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->method->AdvancedSearch->ViewValue = $this->method->lookupCacheOption($curVal);
			else
				$this->method->AdvancedSearch->ViewValue = $this->method->Lookup !== NULL && is_array($this->method->Lookup->Options) ? $curVal : NULL;
			if ($this->method->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->method->EditValue = array_values($this->method->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`grp`=11";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->method->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->method->EditValue = $arwrk;
			}

			// category
			$this->category->EditAttrs["class"] = "form-control";
			$this->category->EditCustomAttributes = "";
			$curVal = trim(strval($this->category->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->category->AdvancedSearch->ViewValue = $this->category->lookupCacheOption($curVal);
			else
				$this->category->AdvancedSearch->ViewValue = $this->category->Lookup !== NULL && is_array($this->category->Lookup->Options) ? $curVal : NULL;
			if ($this->category->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->category->EditValue = array_values($this->category->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->category->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->category->EditValue = $arwrk;
			}
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->pid->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pid->errorMessage());
		}
		if (!CheckNumber($this->_40unit->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->_40unit->errorMessage());
		}
		if (!CheckNumber($this->_40->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->_40->errorMessage());
		}
		if (!CheckNumber($this->custom_size->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->custom_size->errorMessage());
		}
		if (!CheckNumber($this->custom_size_below_st->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->custom_size_below_st->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->pid->AdvancedSearch->load();
		$this->location->AdvancedSearch->load();
		$this->product_type->AdvancedSearch->load();
		$this->shape->AdvancedSearch->load();
		$this->plan_type->AdvancedSearch->load();
		$this->gcode->AdvancedSearch->load();
		$this->design_id->AdvancedSearch->load();
		$this->process->AdvancedSearch->load();
		$this->yes_no->AdvancedSearch->load();
		$this->fix->AdvancedSearch->load();
		$this->unit->AdvancedSearch->load();
		$this->_40unit->AdvancedSearch->load();
		$this->_40->AdvancedSearch->load();
		$this->extra_plan->AdvancedSearch->load();
		$this->custom_size->AdvancedSearch->load();
		$this->custom_size_below_st->AdvancedSearch->load();
		$this->method->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("pp_verify_compiledlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_location":
					$lookupFilter = function() {
						return "`status`=1 and `id` > 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_type":
					$lookupFilter = function() {
						return "`status`=1 and `id` !=9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status`=1 and id < 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`type`=1 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_method":
					$lookupFilter = function() {
						return "`grp`=11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_category":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_location":
							break;
						case "x_product_type":
							break;
						case "x_shape":
							break;
						case "x_design_id":
							break;
						case "x_process":
							break;
						case "x_method":
							break;
						case "x_category":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>